/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import java.util.EnumSet;
import net.sourceforge.plantuml.klimt.creole.command.AddStyle;
import net.sourceforge.plantuml.klimt.creole.command.ColorAndSizeChange;
import net.sourceforge.plantuml.klimt.creole.command.ColorChange;
import net.sourceforge.plantuml.klimt.creole.command.ExposantChange;
import net.sourceforge.plantuml.klimt.creole.command.FontFamilyChange;
import net.sourceforge.plantuml.klimt.creole.command.HtmlCommand;
import net.sourceforge.plantuml.klimt.creole.command.Img;
import net.sourceforge.plantuml.klimt.creole.command.PlainText;
import net.sourceforge.plantuml.klimt.creole.command.RemoveStyle;
import net.sourceforge.plantuml.klimt.creole.command.ResetFont;
import net.sourceforge.plantuml.klimt.creole.command.SizeChange;
import net.sourceforge.plantuml.klimt.creole.command.Splitter;
import net.sourceforge.plantuml.klimt.creole.command.SpriteCommand;
import net.sourceforge.plantuml.klimt.creole.command.SvgAttributesChange;
import net.sourceforge.plantuml.klimt.creole.command.TextLink;
import net.sourceforge.plantuml.klimt.font.FontPosition;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;

class HtmlCommandFactory {
    static final Pattern2 addStyle;
    static final Pattern2 removeStyle;
    private Pattern2 htmlTag = MyPattern.cmpile(Splitter.htmlTag);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(String s2) {
        if (!this.htmlTag.matcher(s2).matches()) {
            return new PlainText(s2);
        }
        if (MyPattern.mtches(s2, "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>")) {
            return Img.getInstance(s2, true);
        }
        if (MyPattern.mtches(s2, "\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>")) {
            return Img.getInstance(s2, false);
        }
        if (addStyle.matcher(s2).matches()) {
            return AddStyle.fromString(s2);
        }
        if (removeStyle.matcher(s2).matches()) {
            return new RemoveStyle(FontStyle.getStyle(s2));
        }
        if (MyPattern.mtches(s2, "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>")) {
            return new ColorAndSizeChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>")) {
            return new ColorChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<size[\\s:]+(\\d+)[%s]*\\>")) {
            return new SizeChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<sup\\>")) {
            return new ExposantChange(FontPosition.EXPOSANT);
        }
        if (MyPattern.mtches(s2, "\\<sub\\>")) {
            return new ExposantChange(FontPosition.INDICE);
        }
        if (MyPattern.mtches(s2, "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>")) {
            return new ResetFont();
        }
        if (MyPattern.mtches(s2, "\\</sup\\>|\\</sub\\>")) {
            return new ExposantChange(FontPosition.NORMAL);
        }
        if (MyPattern.mtches(s2, "\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(s2);
        }
        if (MyPattern.mtches(s2, "\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>")) {
            return new SpriteCommand(s2);
        }
        if (MyPattern.mtches(s2, "\\[\\[([^\\[\\]]+)\\]\\]")) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlMode.STRICT);
            Url url = urlBuilder.getUrl(s2);
            url.setMember(true);
            return new TextLink(url);
        }
        if (MyPattern.mtches(s2, "\\<text[\\s:]+([^>]+)/?\\>")) {
            return new SvgAttributesChange(s2);
        }
        return null;
    }

    static {
        StringBuilder sbAddStyle = new StringBuilder();
        StringBuilder sbRemoveStyle = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            if (sbAddStyle.length() > 0) {
                sbAddStyle.append('|');
                sbRemoveStyle.append('|');
            }
            sbAddStyle.append(style.getActivationPattern());
            sbRemoveStyle.append(style.getDeactivationPattern());
        }
        addStyle = MyPattern.cmpile(sbAddStyle.toString());
        removeStyle = MyPattern.cmpile(sbRemoveStyle.toString());
    }
}

