/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.util.tokens.Token;
import org.tribuo.util.tokens.Tokenizer;

public class NonTokenizer
implements Tokenizer {
    private CharSequence cs;
    private boolean done = false;

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    @Override
    public void reset(CharSequence cs) {
        this.cs = cs;
        this.done = false;
    }

    @Override
    public boolean advance() {
        if (this.cs == null) {
            throw new IllegalStateException("NonTokenizer has not been reset.");
        }
        if (!this.done) {
            this.done = true;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.done) {
            return this.cs.toString();
        }
        throw new IllegalStateException("NonTokenizer isn't ready.");
    }

    @Override
    public int getStart() {
        if (this.done) {
            return 0;
        }
        throw new IllegalStateException("NonTokenizer isn't ready.");
    }

    @Override
    public int getEnd() {
        if (this.done) {
            return this.cs.length();
        }
        throw new IllegalStateException("NonTokenizer isn't ready.");
    }

    @Override
    public Token.TokenType getType() {
        if (this.done) {
            return Token.TokenType.WORD;
        }
        throw new IllegalStateException("NonTokenizer isn't ready.");
    }

    @Override
    public NonTokenizer clone() {
        try {
            NonTokenizer copy = (NonTokenizer)super.clone();
            copy.done = false;
            copy.cs = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion error, NonTokenizer is Cloneable.");
        }
    }
}

