/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.util.ComponentsScrollPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ChecklistComponent<T extends SingleCheckPanel>
extends SystemFormComponent {
    private ScrollablePanel checklistPanel;
    private List<T> singleCheckPanels = new ArrayList<T>();
    private boolean fillVertical = false;

    protected ChecklistComponent() {
        this.checklistPanel = new ScrollablePanel();
    }

    protected List<T> getSingleCheckPanels() {
        return this.singleCheckPanels;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    protected void save() {
        for (SingleCheckPanel singleCheckPanel : this.getSingleCheckPanels()) {
            singleCheckPanel.save();
        }
    }

    @Override
    public boolean checkCompleted() {
        this.save();
        return super.checkCompleted();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.checklistPanel.removeAll();
        this.fillChecklistPanel();
    }

    @Override
    public boolean handleUnattended() {
        this.fillChecklistPanel();
        this.save();
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.fillChecklistPanel();
        for (SingleCheckPanel singleCheckPanel : this.getSingleCheckPanels()) {
            singleCheckPanel.handleConsole(console);
        }
        this.save();
        return true;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public JComponent createCenterComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.fill = 1;
        gc.anchor = 23;
        gc.insets.top = 3;
        this.buildPanel(panel, gc);
        return panel;
    }

    protected void buildPanel(JPanel panel, GridBagConstraints gc) {
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        if (this.isFillVertical()) {
            gc.fill = 1;
            ComponentsScrollPane scrollPane = new ComponentsScrollPane(this.checklistPanel);
            panel.add((Component)scrollPane, gc);
        } else {
            panel.add((Component)this.checklistPanel, gc);
        }
        ++gc.gridy;
    }

    private void fillChecklistPanel() {
        this.checklistPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 21;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.addSingleChecks(this.checklistPanel, gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        this.checklistPanel.add((Component)new JPanel(), gc);
    }

    protected abstract void addSingleChecks(JPanel var1, GridBagConstraints var2);

    public void setSingleCheckPanels(List<T> singleCheckPanels) {
        this.singleCheckPanels = singleCheckPanels;
    }

    protected static abstract class SingleCheckPanel
    extends JPanel {
        protected JCheckBox chkSingle;

        protected SingleCheckPanel() {
        }

        public void save() {
        }

        public void handleConsole(Console console) throws UserCanceledException {
            if (this.chkSingle != null) {
                this.chkSingle.setSelected(console.askYesNo(this.chkSingle.getText(), this.chkSingle.isSelected()));
            }
        }
    }
}

