/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.Timeable;
import sun.misc.TimerThread;

public class Timer {
    public Timeable owner;
    long interval;
    long sleepUntil;
    long remainingTime;
    boolean regular;
    boolean stopped;
    Timer next;
    static TimerThread timerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(Timeable owner, long interval) {
        this.owner = owner;
        this.interval = interval;
        this.remainingTime = interval;
        this.regular = true;
        this.sleepUntil = System.currentTimeMillis();
        this.stopped = true;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (timerThread == null) {
                timerThread = new TimerThread();
            }
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long now = System.currentTimeMillis();
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (!this.stopped) {
                    TimerThread.dequeue(this);
                    this.remainingTime = Math.max(0L, this.sleepUntil - now);
                    this.sleepUntil = now;
                    this.stopped = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cont() {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (this.stopped) {
                    this.sleepUntil = Math.max(this.sleepUntil + 1L, System.currentTimeMillis() + this.remainingTime);
                    TimerThread.enqueue(this);
                    this.stopped = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                this.setRemainingTime(this.interval);
            }
        }
    }

    public synchronized long getStopTime() {
        return this.sleepUntil;
    }

    public synchronized long getInterval() {
        return this.interval;
    }

    public synchronized void setInterval(long interval) {
        this.interval = interval;
    }

    public synchronized long getRemainingTime() {
        return this.remainingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemainingTime(long time) {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = this;
            synchronized (timer) {
                if (this.stopped) {
                    this.remainingTime = time;
                } else {
                    this.stop();
                    this.remainingTime = time;
                    this.cont();
                }
            }
        }
    }

    public synchronized void setRegular(boolean regular) {
        this.regular = regular;
    }

    protected Thread getTimerThread() {
        return TimerThread.timerThread;
    }
}

