/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.PageRank;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.PageRankPanel;
import org.openide.util.NbBundle;

public class PageRankUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private PageRankPanel panel;
    private PageRank pageRank;

    public JPanel getSettingsPanel() {
        this.panel = new PageRankPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.pageRank = (PageRank)statistics;
        if (this.panel != null) {
            this.settings.load(this.pageRank);
            this.panel.setEpsilon(this.pageRank.getEpsilon());
            this.panel.setProbability(this.pageRank.getProbability());
            this.panel.setDirected(this.pageRank.getDirected());
            this.panel.setEdgeWeight(this.pageRank.isUseEdgeWeight());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.pageRank.setEpsilon(this.panel.getEpsilon());
            this.pageRank.setProbability(this.panel.getProbability());
            this.pageRank.setDirected(this.panel.isDirected());
            this.pageRank.setUseEdgeWeight(this.panel.isEdgeWeight());
            this.settings.save(this.pageRank);
        }
        this.panel = null;
        this.pageRank = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return PageRank.class;
    }

    public String getValue() {
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"PageRankUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_NETWORK_OVERVIEW;
    }

    public int getPosition() {
        return 800;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"PageRankUI.shortDescription");
    }

    private static class StatSettings {
        private double epsilon = 0.001;
        private double probability = 0.85;
        private boolean useEdgeWeight = false;

        private StatSettings() {
        }

        private void save(PageRank stat) {
            this.epsilon = stat.getEpsilon();
            this.probability = stat.getProbability();
            this.useEdgeWeight = stat.isUseEdgeWeight();
        }

        private void load(PageRank stat) {
            stat.setEpsilon(this.epsilon);
            stat.setProbability(this.probability);
            stat.setUseEdgeWeight(this.useEdgeWeight);
        }
    }
}

