/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class FlatTreeUI
extends BasicTreeUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionBorderColor;
    @FlatStylingSupport.Styleable
    protected boolean wideSelection;
    @FlatStylingSupport.Styleable
    protected boolean showCellFocusIndicator;
    @FlatStylingSupport.Styleable(dot=true)
    public String iconArrowType;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconExpandedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconCollapsedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconLeafColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconClosedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconOpenColor;
    @FlatStylingSupport.Styleable
    protected boolean paintSelection = true;
    private Color defaultCellNonSelectionBackground;
    private Color defaultSelectionBackground;
    private Color defaultSelectionForeground;
    private Color defaultSelectionBorderColor;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.tree, "Tree.border");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("Tree.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("Tree.selectionInactiveForeground");
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.wideSelection = UIManager.getBoolean("Tree.wideSelection");
        this.showCellFocusIndicator = UIManager.getBoolean("Tree.showCellFocusIndicator");
        this.defaultCellNonSelectionBackground = UIManager.getColor("Tree.textBackground");
        this.defaultSelectionBackground = this.selectionBackground;
        this.defaultSelectionForeground = this.selectionForeground;
        this.defaultSelectionBorderColor = this.selectionBorderColor;
        int rowHeight = FlatUIUtils.getUIInt("Tree.rowHeight", 16);
        if (rowHeight > 0) {
            LookAndFeel.installProperty(this.tree, "rowHeight", UIScale.scale(rowHeight));
        }
        this.setLeftChildIndent(UIScale.scale(this.getLeftChildIndent()));
        this.setRightChildIndent(UIScale.scale(this.getRightChildIndent()));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.tree);
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.selectionBorderColor = null;
        this.defaultCellNonSelectionBackground = null;
        this.defaultSelectionBackground = null;
        this.defaultSelectionForeground = null;
        this.defaultSelectionBorderColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new BasicTreeUI.MouseHandler(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(this.handleWideMouseEvent(e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(this.handleWideMouseEvent(e));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(this.handleWideMouseEvent(e));
            }

            private MouseEvent handleWideMouseEvent(MouseEvent e) {
                if (!FlatTreeUI.this.isWideSelection() || !FlatTreeUI.this.tree.isEnabled() || !SwingUtilities.isLeftMouseButton(e) || e.isConsumed()) {
                    return e;
                }
                int x = e.getX();
                int y = e.getY();
                TreePath path = FlatTreeUI.this.getClosestPathForLocation(FlatTreeUI.this.tree, x, y);
                if (path == null || FlatTreeUI.this.isLocationInExpandControl(path, x, y)) {
                    return e;
                }
                Rectangle bounds = FlatTreeUI.this.getPathBounds(FlatTreeUI.this.tree, path);
                if (bounds == null || y < bounds.y || y >= bounds.y + bounds.height) {
                    return e;
                }
                int newX = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1));
                if (newX == x) {
                    return e;
                }
                return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), newX, e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener superListener = super.createPropertyChangeListener();
        return e -> {
            superListener.propertyChange(e);
            if (e.getSource() == this.tree) {
                switch (e.getPropertyName()) {
                    case "JTree.wideSelection": 
                    case "JTree.paintSelection": {
                        this.tree.repaint();
                        break;
                    }
                    case "dropLocation": {
                        if (!this.isWideSelection()) break;
                        JTree.DropLocation oldValue = (JTree.DropLocation)e.getOldValue();
                        this.repaintWideDropLocation(oldValue);
                        this.repaintWideDropLocation(this.tree.getDropLocation());
                        break;
                    }
                    case "FlatLaf.style": 
                    case "FlatLaf.styleClass": {
                        this.installStyle();
                        this.tree.revalidate();
                        this.tree.repaint();
                    }
                }
            }
        };
    }

    private void repaintWideDropLocation(JTree.DropLocation loc) {
        if (loc == null || this.isDropLine(loc)) {
            return;
        }
        Rectangle r = this.tree.getPathBounds(loc.getPath());
        if (r != null) {
            this.tree.repaint(0, r.y, this.tree.getWidth(), r.height);
        }
    }

    @Override
    public Rectangle getPathBounds(JTree tree, TreePath path) {
        Rectangle bounds = super.getPathBounds(tree, path);
        if (bounds != null && this.isWideSelection() && UIManager.getBoolean("FlatLaf.experimental.tree.widePathForLocation") && StackUtils.wasInvokedFrom(JTree.class.getName(), "getPathForLocation", 5)) {
            bounds.x = 0;
            bounds.width = tree.getWidth();
        }
        return bounds;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.tree, "Tree"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.tree, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        DefaultTreeCellRenderer renderer;
        Color bg;
        boolean cellHasFocus;
        boolean needsSelectionPainting;
        boolean isEditing = this.editingComponent != null && this.editingRow == row;
        boolean isSelected = this.tree.isRowSelected(row);
        boolean isDropRow = this.isDropRow(row);
        boolean bl = needsSelectionPainting = (isSelected || isDropRow) && this.isPaintSelection();
        if (isEditing) {
            if (isSelected && this.isWideSelection()) {
                Color oldColor = g.getColor();
                g.setColor(this.selectionInactiveBackground);
                this.paintWideSelection(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                g.setColor(oldColor);
            }
            return;
        }
        boolean hasFocus = FlatUIUtils.isPermanentFocusOwner(this.tree);
        boolean bl2 = cellHasFocus = hasFocus && row == this.getLeadSelectionRow();
        if (!hasFocus && isSelected && this.tree.getParent() instanceof CellRendererPane) {
            hasFocus = FlatUIUtils.isPermanentFocusOwner(this.tree.getParent().getParent());
        }
        Component rendererComponent = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), isSelected, isExpanded, isLeaf, row, cellHasFocus);
        Color oldBackgroundSelectionColor = null;
        if (isSelected && !hasFocus && !isDropRow) {
            oldBackgroundSelectionColor = this.setRendererBackgroundSelectionColor(rendererComponent, this.selectionInactiveBackground);
            this.setRendererForeground(rendererComponent, this.selectionInactiveForeground);
        } else if (isSelected) {
            if (this.selectionBackground != this.defaultSelectionBackground) {
                oldBackgroundSelectionColor = this.setRendererBackgroundSelectionColor(rendererComponent, this.selectionBackground);
            }
            if (this.selectionForeground != this.defaultSelectionForeground) {
                this.setRendererForeground(rendererComponent, this.selectionForeground);
            }
        }
        Color oldBorderSelectionColor = null;
        if (isSelected && hasFocus && (!this.showCellFocusIndicator || this.tree.getMinSelectionRow() == this.tree.getMaxSelectionRow())) {
            oldBorderSelectionColor = this.setRendererBorderSelectionColor(rendererComponent, null);
        } else if (hasFocus && this.selectionBorderColor != this.defaultSelectionBorderColor) {
            oldBorderSelectionColor = this.setRendererBorderSelectionColor(rendererComponent, this.selectionBorderColor);
        }
        if (needsSelectionPainting) {
            Color oldColor = g.getColor();
            g.setColor(isDropRow ? UIManager.getColor("Tree.dropCellBackground") : (rendererComponent instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)rendererComponent).getBackgroundSelectionColor() : (hasFocus ? this.selectionBackground : this.selectionInactiveBackground)));
            if (this.isWideSelection()) {
                this.paintWideSelection(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            } else {
                this.paintCellBackground(g, rendererComponent, bounds);
            }
            g.setColor(oldColor);
        } else if (rendererComponent instanceof DefaultTreeCellRenderer && (bg = (renderer = (DefaultTreeCellRenderer)rendererComponent).getBackgroundNonSelectionColor()) != null && !bg.equals(this.defaultCellNonSelectionBackground)) {
            Color oldColor = g.getColor();
            g.setColor(bg);
            this.paintCellBackground(g, rendererComponent, bounds);
            g.setColor(oldColor);
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
        if (oldBackgroundSelectionColor != null) {
            ((DefaultTreeCellRenderer)rendererComponent).setBackgroundSelectionColor(oldBackgroundSelectionColor);
        }
        if (oldBorderSelectionColor != null) {
            ((DefaultTreeCellRenderer)rendererComponent).setBorderSelectionColor(oldBorderSelectionColor);
        }
    }

    private Color setRendererBackgroundSelectionColor(Component rendererComponent, Color color) {
        Color oldColor = null;
        if (rendererComponent instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)rendererComponent;
            if (renderer.getBackgroundSelectionColor() == this.defaultSelectionBackground) {
                oldColor = renderer.getBackgroundSelectionColor();
                renderer.setBackgroundSelectionColor(color);
            }
        } else if (rendererComponent.getBackground() == this.defaultSelectionBackground) {
            rendererComponent.setBackground(color);
        }
        return oldColor;
    }

    private void setRendererForeground(Component rendererComponent, Color color) {
        if (rendererComponent.getForeground() == this.defaultSelectionForeground) {
            rendererComponent.setForeground(color);
        }
    }

    private Color setRendererBorderSelectionColor(Component rendererComponent, Color color) {
        DefaultTreeCellRenderer renderer;
        Color oldColor = null;
        if (rendererComponent instanceof DefaultTreeCellRenderer && (renderer = (DefaultTreeCellRenderer)rendererComponent).getBorderSelectionColor() == this.defaultSelectionBorderColor) {
            oldColor = renderer.getBorderSelectionColor();
            renderer.setBorderSelectionColor(color);
        }
        return oldColor;
    }

    private void paintWideSelection(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        g.fillRect(0, bounds.y, this.tree.getWidth(), bounds.height);
        if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
            this.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private void paintCellBackground(Graphics g, Component rendererComponent, Rectangle bounds) {
        int xOffset = 0;
        int imageOffset = 0;
        if (rendererComponent instanceof JLabel) {
            JLabel label = (JLabel)rendererComponent;
            Icon icon = label.getIcon();
            imageOffset = icon != null && label.getText() != null ? icon.getIconWidth() + Math.max(label.getIconTextGap() - 1, 0) : 0;
            xOffset = label.getComponentOrientation().isLeftToRight() ? imageOffset : 0;
        }
        g.fillRect(bounds.x + xOffset, bounds.y, bounds.width - imageOffset, bounds.height);
    }

    private boolean isDropRow(int row) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.tree.getRowForPath(dropLocation.getPath()) == row;
    }

    @Override
    protected Rectangle getDropLineRect(JTree.DropLocation loc) {
        Rectangle r = super.getDropLineRect(loc);
        return this.isWideSelection() ? new Rectangle(0, r.y, this.tree.getWidth(), r.height) : r;
    }

    protected boolean isWideSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.wideSelection", this.wideSelection);
    }

    protected boolean isPaintSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.paintSelection", this.paintSelection);
    }
}

