/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.util.NetMask;

public class NetMaskSet {
    private final Set<NetMask> netmasks = new HashSet<NetMask>();

    public boolean contains(InetAddress inetAddress) {
        for (NetMask netMask : this.netmasks) {
            if (!netMask.matches(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return this.contains(inetAddress);
    }

    public boolean add(NetMask netMask) {
        return this.netmasks.add(netMask);
    }

    public boolean add(String string) {
        NetMask netMask = new NetMask(string);
        return this.netmasks.add(netMask);
    }

    public void clear() {
        this.netmasks.clear();
    }

    public boolean isEmpty() {
        return this.netmasks.isEmpty();
    }

    public List<String> addAll(String string) {
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (String string2 : string.split("\\s*,\\s*")) {
            try {
                this.add(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                arrayList.add((CallSite)((Object)(string2 + ": " + illegalArgumentException.getMessage())));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        String string = this.netmasks.toString();
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

