/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.jstl.core.LoopTagSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.taglibs.standard.resources.Resources;

public abstract class ForEachSupport
extends LoopTagSupport {
    protected ForEachIterator items;
    protected Object rawItems;

    @Override
    protected boolean hasNext() throws JspTagException {
        return this.items.hasNext();
    }

    @Override
    protected Object next() throws JspTagException {
        return this.items.next();
    }

    @Override
    protected void prepare() throws JspTagException {
        if (this.rawItems != null) {
            if (this.rawItems instanceof ValueExpression) {
                this.deferredExpression = (ValueExpression)this.rawItems;
                this.rawItems = this.deferredExpression.getValue(this.pageContext.getELContext());
                if (this.rawItems == null) {
                    this.rawItems = new ArrayList();
                }
            }
            this.items = this.supportedTypeForEachIterator(this.rawItems);
        } else {
            this.items = this.beginEndForEachIterator();
        }
    }

    @Override
    public void release() {
        super.release();
        this.items = null;
        this.rawItems = null;
        this.deferredExpression = null;
    }

    protected ForEachIterator supportedTypeForEachIterator(Object o) throws JspTagException {
        ForEachIterator items = o instanceof Object[] ? this.toForEachIterator((Object[])o) : (o instanceof boolean[] ? this.toForEachIterator((boolean[])o) : (o instanceof byte[] ? this.toForEachIterator((byte[])o) : (o instanceof char[] ? this.toForEachIterator((char[])o) : (o instanceof short[] ? this.toForEachIterator((short[])o) : (o instanceof int[] ? this.toForEachIterator((int[])o) : (o instanceof long[] ? this.toForEachIterator((long[])o) : (o instanceof float[] ? this.toForEachIterator((float[])o) : (o instanceof double[] ? this.toForEachIterator((double[])o) : (o instanceof Collection ? this.toForEachIterator((Collection)o) : (o instanceof Iterator ? this.toForEachIterator((Iterator)o) : (o instanceof Enumeration ? this.toForEachIterator((Enumeration)o) : (o instanceof Map ? this.toForEachIterator((Map)o) : (o instanceof String ? this.toForEachIterator((String)o) : this.toForEachIterator(o))))))))))))));
        return items;
    }

    private ForEachIterator beginEndForEachIterator() {
        Integer[] ia = new Integer[this.end + 1];
        for (int i = 0; i <= this.end; ++i) {
            ia[i] = i;
        }
        return new SimpleForEachIterator(Arrays.asList(ia).iterator());
    }

    protected ForEachIterator toForEachIterator(Object o) throws JspTagException {
        throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
    }

    protected ForEachIterator toForEachIterator(Object[] a) {
        return new SimpleForEachIterator(Arrays.asList(a).iterator());
    }

    protected ForEachIterator toForEachIterator(boolean[] a) {
        Boolean[] wrapped = new Boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = a[i];
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(byte[] a) {
        Byte[] wrapped = new Byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = a[i];
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(char[] a) {
        Character[] wrapped = new Character[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = Character.valueOf(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(short[] a) {
        Short[] wrapped = new Short[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = a[i];
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(int[] a) {
        Integer[] wrapped = new Integer[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = a[i];
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(long[] a) {
        Long[] wrapped = new Long[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = a[i];
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(float[] a) {
        Float[] wrapped = new Float[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Float(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(double[] a) {
        Double[] wrapped = new Double[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Double(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(Collection c) {
        return new SimpleForEachIterator(c.iterator());
    }

    protected ForEachIterator toForEachIterator(Iterator i) {
        return new SimpleForEachIterator(i);
    }

    protected ForEachIterator toForEachIterator(Enumeration e) {
        class EnumerationAdapter
        implements ForEachIterator {
            private Enumeration e;

            public EnumerationAdapter(Enumeration e) {
                this.e = e;
            }

            @Override
            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            @Override
            public Object next() {
                return this.e.nextElement();
            }
        }
        return new EnumerationAdapter(e);
    }

    protected ForEachIterator toForEachIterator(Map m) {
        return new SimpleForEachIterator(m.entrySet().iterator());
    }

    protected ForEachIterator toForEachIterator(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        return this.toForEachIterator(st);
    }

    protected class SimpleForEachIterator
    implements ForEachIterator {
        private Iterator i;

        public SimpleForEachIterator(Iterator i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return this.i.next();
        }
    }

    protected static interface ForEachIterator {
        public boolean hasNext() throws JspTagException;

        public Object next() throws JspTagException;
    }
}

