/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerParameterizedOutputVisitor;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitor;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.PrintableVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitorUtils;
import java.util.List;

public class ParameterizedOutputVisitorUtils {
    public static final String ATTR_PARAMS_SKIP = "druid.parameterized.skip";

    public static String parameterize(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        List<SQLStatement> statementList = parser.parseStatementList();
        if (statementList.size() == 0) {
            return sql;
        }
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            if (i > 0) {
                out.append(";\n");
            }
            SQLStatement stmt = statementList.get(i);
            stmt.accept(visitor);
        }
        if (visitor.getReplaceCount() == 0 && !parser.getLexer().isHasComment()) {
            return sql;
        }
        return out.toString();
    }

    public static ParameterizedVisitor createParameterizedOutputVisitor(Appendable out, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleParameterizedOutputVisitor(out);
        }
        if ("mysql".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("h2".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("postgresql".equals(dbType)) {
            return new PGParameterizedOutputVisitor(out);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerParameterizedOutputVisitor(out);
        }
        if ("db2".equals(dbType)) {
            return new DB2ParameterizedOutputVisitor(out);
        }
        return new ParameterizedOutputVisitor(out);
    }

    public static boolean visit(ParameterizedVisitor v, SQLInListExpr x) {
        List<SQLExpr> targetList = x.getTargetList();
        boolean changed = true;
        if (targetList.size() == 1 && targetList.get(0) instanceof SQLVariantRefExpr) {
            changed = false;
        }
        x.getExpr().accept(v);
        if (x.isNot()) {
            v.print(" NOT IN (?)");
        } else {
            v.print(" IN (?)");
        }
        if (changed) {
            v.incrementReplaceCunt();
        }
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLIntegerExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return SQLASTOutputVisitorUtils.visit((PrintableVisitor)v, x);
        }
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLNumberExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return SQLASTOutputVisitorUtils.visit((PrintableVisitor)v, x);
        }
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLCharExpr x) {
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean checkParameterize(SQLObject x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return false;
        }
        SQLObject parent = x.getParent();
        return !(parent instanceof SQLDataType) && !(parent instanceof SQLColumnDefinition) && !(parent instanceof SQLServerTop) && !(parent instanceof SQLSelectOrderByItem);
    }

    public static boolean visit(ParameterizedVisitor v, SQLNCharExpr x) {
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLNullExpr x) {
        SQLBinaryOpExpr binaryOpExpr;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLBinaryOpExpr && ((binaryOpExpr = (SQLBinaryOpExpr)parent).getOperator() == SQLBinaryOperator.IsNot || binaryOpExpr.getOperator() == SQLBinaryOperator.Is)) {
            v.print("NULL");
            return false;
        }
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLVariantRefExpr x) {
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static boolean visit(ParameterizedVisitor v, SQLHexExpr x) {
        v.print('?');
        v.incrementReplaceCunt();
        return false;
    }

    public static SQLBinaryOpExpr merge(ParameterizedVisitor v, SQLBinaryOpExpr x) {
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        SQLObject parent = x.getParent();
        if (left instanceof SQLLiteralExpr && right instanceof SQLLiteralExpr) {
            if (x.getOperator() == SQLBinaryOperator.Equality || x.getOperator() == SQLBinaryOperator.NotEqual) {
                if (left instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
                    if (((SQLIntegerExpr)left).getNumber().intValue() < 100) {
                        left.putAttribute(ATTR_PARAMS_SKIP, true);
                    }
                    if (((SQLIntegerExpr)right).getNumber().intValue() < 100) {
                        right.putAttribute(ATTR_PARAMS_SKIP, true);
                    }
                } else {
                    left.putAttribute(ATTR_PARAMS_SKIP, true);
                    right.putAttribute(ATTR_PARAMS_SKIP, true);
                }
            }
            return x;
        }
        while (x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinaryExpr;
            if (x.getLeft() instanceof SQLBinaryOpExpr && (leftBinaryExpr = (SQLBinaryOpExpr)x.getLeft()).getRight().equals(x.getRight())) {
                x = leftBinaryExpr;
                v.incrementReplaceCunt();
                continue;
            }
            SQLBinaryOpExpr mergedRight = ParameterizedOutputVisitorUtils.merge(v, (SQLBinaryOpExpr)x.getRight());
            if (mergedRight != x.getRight()) {
                x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), mergedRight);
                v.incrementReplaceCunt();
            }
            x.setParent(parent);
            break;
        }
        if (x.getLeft() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr mergedLeft = ParameterizedOutputVisitorUtils.merge(v, (SQLBinaryOpExpr)x.getLeft());
            if (mergedLeft != x.getLeft()) {
                x = new SQLBinaryOpExpr((SQLExpr)mergedLeft, x.getOperator(), x.getRight());
                v.incrementReplaceCunt();
            }
            x.setParent(parent);
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr && left instanceof SQLBinaryOpExpr && right instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr rightBinary;
            SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)x.getLeft();
            if (ParameterizedOutputVisitorUtils.mergeEqual(leftBinary, rightBinary = (SQLBinaryOpExpr)x.getRight())) {
                v.incrementReplaceCunt();
                return leftBinary;
            }
            if (ParameterizedOutputVisitorUtils.isLiteralExpr(leftBinary.getLeft()) && leftBinary.getOperator() == SQLBinaryOperator.BooleanOr && ParameterizedOutputVisitorUtils.mergeEqual(leftBinary.getRight(), right)) {
                v.incrementReplaceCunt();
                return leftBinary;
            }
        }
        return x;
    }

    private static boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.getRight() instanceof SQLLiteralExpr) && !(binaryA.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.getRight() instanceof SQLLiteralExpr) && !(binaryB.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.getLeft().toString().equals(binaryB.getLeft().toString());
    }

    private static boolean isLiteralExpr(SQLExpr expr) {
        if (expr instanceof SQLLiteralExpr) {
            return true;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binary = (SQLBinaryOpExpr)expr;
            return ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getLeft()) && ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getRight());
        }
        return false;
    }
}

