/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocation;

public class GetIpamPoolAllocationsPublisher
implements SdkPublisher<GetIpamPoolAllocationsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamPoolAllocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamPoolAllocationsPublisher(Ec2AsyncClient client, GetIpamPoolAllocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamPoolAllocationsPublisher(Ec2AsyncClient client, GetIpamPoolAllocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamPoolAllocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamPoolAllocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPoolAllocation> ipamPoolAllocations() {
        Function<GetIpamPoolAllocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPoolAllocations() != null) {
                return response.ipamPoolAllocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamPoolAllocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamPoolAllocationsResponseFetcher
    implements AsyncPageFetcher<GetIpamPoolAllocationsResponse> {
        private GetIpamPoolAllocationsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPoolAllocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamPoolAllocationsResponse> nextPage(GetIpamPoolAllocationsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPoolAllocationsPublisher.this.client.getIpamPoolAllocations(GetIpamPoolAllocationsPublisher.this.firstRequest);
            }
            return GetIpamPoolAllocationsPublisher.this.client.getIpamPoolAllocations((GetIpamPoolAllocationsRequest)((Object)GetIpamPoolAllocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

