/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnection;

public class DescribeVpcEndpointConnectionsIterable
implements SdkIterable<DescribeVpcEndpointConnectionsResponse> {
    private final Ec2Client client;
    private final DescribeVpcEndpointConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcEndpointConnectionsIterable(Ec2Client client, DescribeVpcEndpointConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVpcEndpointConnectionsResponseFetcher();
    }

    public Iterator<DescribeVpcEndpointConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcEndpointConnection> vpcEndpointConnections() {
        Function<DescribeVpcEndpointConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcEndpointConnections() != null) {
                return response.vpcEndpointConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcEndpointConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeVpcEndpointConnectionsResponse> {
        private DescribeVpcEndpointConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcEndpointConnectionsResponse nextPage(DescribeVpcEndpointConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointConnectionsIterable.this.client.describeVpcEndpointConnections(DescribeVpcEndpointConnectionsIterable.this.firstRequest);
            }
            return DescribeVpcEndpointConnectionsIterable.this.client.describeVpcEndpointConnections((DescribeVpcEndpointConnectionsRequest)((Object)DescribeVpcEndpointConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

