/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment;

public class DescribeTransitGatewayAttachmentsIterable
implements SdkIterable<DescribeTransitGatewayAttachmentsResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayAttachmentsIterable(Ec2Client client, DescribeTransitGatewayAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTransitGatewayAttachmentsResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayAttachment> transitGatewayAttachments() {
        Function<DescribeTransitGatewayAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayAttachments() != null) {
                return response.transitGatewayAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayAttachmentsResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayAttachmentsResponse> {
        private DescribeTransitGatewayAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayAttachmentsResponse nextPage(DescribeTransitGatewayAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayAttachmentsIterable.this.client.describeTransitGatewayAttachments(DescribeTransitGatewayAttachmentsIterable.this.firstRequest);
            }
            return DescribeTransitGatewayAttachmentsIterable.this.client.describeTransitGatewayAttachments((DescribeTransitGatewayAttachmentsRequest)((Object)DescribeTransitGatewayAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

