/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery;

public class DescribeIpamResourceDiscoveriesIterable
implements SdkIterable<DescribeIpamResourceDiscoveriesResponse> {
    private final Ec2Client client;
    private final DescribeIpamResourceDiscoveriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamResourceDiscoveriesIterable(Ec2Client client, DescribeIpamResourceDiscoveriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeIpamResourceDiscoveriesResponseFetcher();
    }

    public Iterator<DescribeIpamResourceDiscoveriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamResourceDiscovery> ipamResourceDiscoveries() {
        Function<DescribeIpamResourceDiscoveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamResourceDiscoveries() != null) {
                return response.ipamResourceDiscoveries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamResourceDiscoveriesResponseFetcher
    implements SyncPageFetcher<DescribeIpamResourceDiscoveriesResponse> {
        private DescribeIpamResourceDiscoveriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamResourceDiscoveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamResourceDiscoveriesResponse nextPage(DescribeIpamResourceDiscoveriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamResourceDiscoveriesIterable.this.client.describeIpamResourceDiscoveries(DescribeIpamResourceDiscoveriesIterable.this.firstRequest);
            }
            return DescribeIpamResourceDiscoveriesIterable.this.client.describeIpamResourceDiscoveries((DescribeIpamResourceDiscoveriesRequest)((Object)DescribeIpamResourceDiscoveriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

