/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DataResponse;
import software.amazon.awssdk.services.ec2.model.DataResponsesCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAwsNetworkPerformanceDataResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetAwsNetworkPerformanceDataResponse> {
    private static final SdkField<List<DataResponse>> DATA_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataResponses").getter(GetAwsNetworkPerformanceDataResponse.getter(GetAwsNetworkPerformanceDataResponse::dataResponses)).setter(GetAwsNetworkPerformanceDataResponse.setter(Builder::dataResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataResponseSet").unmarshallLocationName("dataResponseSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAwsNetworkPerformanceDataResponse.getter(GetAwsNetworkPerformanceDataResponse::nextToken)).setter(GetAwsNetworkPerformanceDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RESPONSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataResponse> dataResponses;
    private final String nextToken;

    private GetAwsNetworkPerformanceDataResponse(BuilderImpl builder) {
        super(builder);
        this.dataResponses = builder.dataResponses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataResponses() {
        return this.dataResponses != null && !(this.dataResponses instanceof SdkAutoConstructList);
    }

    public final List<DataResponse> dataResponses() {
        return this.dataResponses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataResponses() ? this.dataResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsNetworkPerformanceDataResponse)) {
            return false;
        }
        GetAwsNetworkPerformanceDataResponse other = (GetAwsNetworkPerformanceDataResponse)((Object)obj);
        return this.hasDataResponses() == other.hasDataResponses() && Objects.equals(this.dataResponses(), other.dataResponses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAwsNetworkPerformanceDataResponse").add("DataResponses", this.hasDataResponses() ? this.dataResponses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataResponses": {
                return Optional.ofNullable(clazz.cast(this.dataResponses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAwsNetworkPerformanceDataResponse, T> g) {
        return obj -> g.apply((GetAwsNetworkPerformanceDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DataResponse> dataResponses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsNetworkPerformanceDataResponse model) {
            super(model);
            this.dataResponses(model.dataResponses);
            this.nextToken(model.nextToken);
        }

        public final List<DataResponse.Builder> getDataResponses() {
            List<DataResponse.Builder> result = DataResponsesCopier.copyToBuilder(this.dataResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataResponses(Collection<DataResponse.BuilderImpl> dataResponses) {
            this.dataResponses = DataResponsesCopier.copyFromBuilder(dataResponses);
        }

        @Override
        public final Builder dataResponses(Collection<DataResponse> dataResponses) {
            this.dataResponses = DataResponsesCopier.copy(dataResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResponses(DataResponse ... dataResponses) {
            this.dataResponses(Arrays.asList(dataResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResponses(Consumer<DataResponse.Builder> ... dataResponses) {
            this.dataResponses(Stream.of(dataResponses).map(c -> (DataResponse)((DataResponse.Builder)DataResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAwsNetworkPerformanceDataResponse build() {
            return new GetAwsNetworkPerformanceDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAwsNetworkPerformanceDataResponse> {
        public Builder dataResponses(Collection<DataResponse> var1);

        public Builder dataResponses(DataResponse ... var1);

        public Builder dataResponses(Consumer<DataResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

