"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanExpression = void 0;

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SpanExpression extends _node.PPLNode {
  constructor(name, children, fieldExpression, literalValue, timeUnit) {
    super(name, children);
    this.fieldExpression = fieldExpression;
    this.literalValue = literalValue;
    this.timeUnit = timeUnit;
  }

  getTokens() {
    return {
      field: this.fieldExpression,
      literal_value: this.literalValue,
      time_unit: this.timeUnit
    };
  }

  toString() {
    return `span(${this.fieldExpression}, ${this.literalValue}${this.timeUnit})`;
  }

}

exports.SpanExpression = SpanExpression;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNwYW5FeHByZXNzaW9uLnRzIl0sIm5hbWVzIjpbIlNwYW5FeHByZXNzaW9uIiwiUFBMTm9kZSIsImNvbnN0cnVjdG9yIiwibmFtZSIsImNoaWxkcmVuIiwiZmllbGRFeHByZXNzaW9uIiwibGl0ZXJhbFZhbHVlIiwidGltZVVuaXQiLCJnZXRUb2tlbnMiLCJmaWVsZCIsImxpdGVyYWxfdmFsdWUiLCJ0aW1lX3VuaXQiLCJ0b1N0cmluZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSU8sTUFBTUEsY0FBTixTQUE2QkMsYUFBN0IsQ0FBcUM7QUFDMUNDLEVBQUFBLFdBQVcsQ0FDVEMsSUFEUyxFQUVUQyxRQUZTLEVBR0RDLGVBSEMsRUFJREMsWUFKQyxFQUtEQyxRQUxDLEVBTVQ7QUFDQSxVQUFNSixJQUFOLEVBQVlDLFFBQVo7QUFEQSxTQUhRQyxlQUdSLEdBSFFBLGVBR1I7QUFBQSxTQUZRQyxZQUVSLEdBRlFBLFlBRVI7QUFBQSxTQURRQyxRQUNSLEdBRFFBLFFBQ1I7QUFFRDs7QUFFREMsRUFBQUEsU0FBUyxHQUFHO0FBQ1YsV0FBTztBQUNMQyxNQUFBQSxLQUFLLEVBQUUsS0FBS0osZUFEUDtBQUVMSyxNQUFBQSxhQUFhLEVBQUUsS0FBS0osWUFGZjtBQUdMSyxNQUFBQSxTQUFTLEVBQUUsS0FBS0o7QUFIWCxLQUFQO0FBS0Q7O0FBRURLLEVBQUFBLFFBQVEsR0FBVztBQUNqQixXQUFRLFFBQU8sS0FBS1AsZUFBZ0IsS0FBSSxLQUFLQyxZQUFhLEdBQUUsS0FBS0MsUUFBUyxHQUExRTtBQUNEOztBQXJCeUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IFBQTE5vZGUgfSBmcm9tICcuLi9ub2RlJztcblxuZXhwb3J0IGNsYXNzIFNwYW5FeHByZXNzaW9uIGV4dGVuZHMgUFBMTm9kZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIG5hbWU6IHN0cmluZyxcbiAgICBjaGlsZHJlbjogQXJyYXk8UFBMTm9kZT4sXG4gICAgcHJpdmF0ZSBmaWVsZEV4cHJlc3Npb246IHN0cmluZyxcbiAgICBwcml2YXRlIGxpdGVyYWxWYWx1ZTogc3RyaW5nLFxuICAgIHByaXZhdGUgdGltZVVuaXQ6IHN0cmluZ1xuICApIHtcbiAgICBzdXBlcihuYW1lLCBjaGlsZHJlbik7XG4gIH1cblxuICBnZXRUb2tlbnMoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGZpZWxkOiB0aGlzLmZpZWxkRXhwcmVzc2lvbixcbiAgICAgIGxpdGVyYWxfdmFsdWU6IHRoaXMubGl0ZXJhbFZhbHVlLFxuICAgICAgdGltZV91bml0OiB0aGlzLnRpbWVVbml0LFxuICAgIH07XG4gIH1cblxuICB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiBgc3Bhbigke3RoaXMuZmllbGRFeHByZXNzaW9ufSwgJHt0aGlzLmxpdGVyYWxWYWx1ZX0ke3RoaXMudGltZVVuaXR9KWA7XG4gIH1cbn1cbiJdfQ==