/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.imputation;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.returntypes.ConditionalTreeSample;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConditionalSampleSummarizer {
    public static int MAX_NUMBER_OF_TYPICAL_PER_DIMENSION = 2;
    public static int MAX_NUMBER_OF_TYPICAL_ELEMENTS = 5;
    protected int[] missingDimensions;
    protected float[] queryPoint;
    protected double centrality;
    protected boolean project = false;

    public ConditionalSampleSummarizer(int[] missingDimensions, float[] queryPoint, double centrality) {
        this.missingDimensions = Arrays.copyOf(missingDimensions, missingDimensions.length);
        this.queryPoint = Arrays.copyOf(queryPoint, queryPoint.length);
        this.centrality = centrality;
    }

    public ConditionalSampleSummarizer(int[] missingDimensions, float[] queryPoint, double centrality, boolean project) {
        this.missingDimensions = Arrays.copyOf(missingDimensions, missingDimensions.length);
        this.queryPoint = Arrays.copyOf(queryPoint, queryPoint.length);
        this.centrality = centrality;
        this.project = project;
    }

    public SampleSummary summarize(List<ConditionalTreeSample> alist) {
        CommonUtils.checkArgument(alist.size() > 0, "incorrect call to summarize");
        return this.summarize(alist, true);
    }

    public SampleSummary summarize(List<ConditionalTreeSample> alist, boolean addTypical) {
        int num;
        double totalWeight = alist.size();
        List<ConditionalTreeSample> newList = ConditionalTreeSample.dedup(alist);
        newList.sort((o1, o2) -> Double.compare(o1.distance, o2.distance));
        ArrayList<Weighted<float[]>> points = new ArrayList<Weighted<float[]>>();
        newList.stream().forEach(e -> {
            if (!this.project) {
                points.add(new Weighted<float[]>(e.leafPoint, (float)e.weight));
            } else {
                float[] values = new float[this.missingDimensions.length];
                for (int i = 0; i < this.missingDimensions.length; ++i) {
                    values[i] = e.leafPoint[this.missingDimensions[i]];
                }
                points.add(new Weighted<float[]>(values, (float)e.weight));
            }
        });
        if (!addTypical) {
            return new SampleSummary(points);
        }
        int dimensions = this.queryPoint.length;
        double threshold = this.centrality * newList.get((int)0).distance;
        double currentWeight = 0.0;
        int alwaysInclude = 0;
        double remainderWeight = totalWeight;
        while (newList.get((int)alwaysInclude).distance == 0.0) {
            remainderWeight -= newList.get((int)alwaysInclude).weight;
            if (++alwaysInclude != newList.size()) continue;
        }
        for (int j = 1; j < newList.size(); ++j) {
            if (currentWeight < remainderWeight / 3.0 && currentWeight + newList.get((int)j).weight >= remainderWeight / 3.0 || currentWeight < remainderWeight / 2.0 && currentWeight + newList.get((int)j).weight >= remainderWeight / 2.0) {
                threshold = this.centrality * newList.get((int)j).distance;
            }
            currentWeight += newList.get((int)j).weight;
        }
        threshold += (1.0 - this.centrality) * newList.get((int)(newList.size() - 1)).distance;
        for (num = 0; num < newList.size() && newList.get((int)num).distance <= threshold; ++num) {
        }
        ArrayList<Weighted<float[]>> typicalPoints = new ArrayList<Weighted<float[]>>();
        for (int j = 0; j < num; ++j) {
            float[] values;
            ConditionalTreeSample e2 = newList.get(j);
            if (this.project) {
                values = new float[this.missingDimensions.length];
                for (int i = 0; i < this.missingDimensions.length; ++i) {
                    values[i] = e2.leafPoint[this.missingDimensions[i]];
                }
            } else {
                values = Arrays.copyOf(e2.leafPoint, dimensions);
            }
            typicalPoints.add(new Weighted<float[]>(values, (float)e2.weight));
        }
        int maxAllowed = Math.min(this.queryPoint.length * MAX_NUMBER_OF_TYPICAL_PER_DIMENSION, MAX_NUMBER_OF_TYPICAL_ELEMENTS);
        maxAllowed = Math.min(maxAllowed, num);
        SampleSummary projectedSummary = Summarizer.l2summarize(typicalPoints, maxAllowed, num, false, 72L);
        float[][] pointList = new float[projectedSummary.summaryPoints.length][];
        float[] likelihood = new float[projectedSummary.summaryPoints.length];
        for (int i = 0; i < projectedSummary.summaryPoints.length; ++i) {
            pointList[i] = Arrays.copyOf(this.queryPoint, dimensions);
            for (int j = 0; j < this.missingDimensions.length; ++j) {
                pointList[i][this.missingDimensions[j]] = projectedSummary.summaryPoints[i][j];
            }
            likelihood[i] = projectedSummary.relativeWeight[i];
        }
        return new SampleSummary(points, pointList, likelihood);
    }
}

