/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dissect;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dissect.DissectException;

public final class DissectKey {
    private static final Pattern LEFT_MODIFIER_PATTERN = Pattern.compile("([+*&?])(.*?)(->)?$", 32);
    private static final Pattern RIGHT_PADDING_PATTERN = Pattern.compile("^(.*?)(->)?$", 32);
    private static final Pattern APPEND_WITH_ORDER_PATTERN = Pattern.compile("[+](.*?)(/)([0-9]+)(->)?$", 32);
    private final Modifier modifier;
    private boolean skip;
    private boolean skipRightPadding;
    private int appendPosition;
    private String name;

    DissectKey(String key) {
        this.skip = key == null || key.isEmpty();
        this.modifier = Modifier.findModifier(key);
        switch (this.modifier) {
            case NONE: {
                Matcher matcher = RIGHT_PADDING_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(1);
                    this.skipRightPadding = matcher.group(2) != null;
                }
                this.skip = this.name.isEmpty();
                break;
            }
            case NAMED_SKIP: {
                Matcher matcher = LEFT_MODIFIER_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(2);
                    this.skipRightPadding = matcher.group(3) != null;
                }
                this.skip = true;
                break;
            }
            case APPEND: {
                Matcher matcher = LEFT_MODIFIER_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(2);
                    this.skipRightPadding = matcher.group(3) != null;
                }
                break;
            }
            case FIELD_NAME: {
                Matcher matcher = LEFT_MODIFIER_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(2);
                    this.skipRightPadding = matcher.group(3) != null;
                }
                break;
            }
            case FIELD_VALUE: {
                Matcher matcher = LEFT_MODIFIER_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(2);
                    this.skipRightPadding = matcher.group(3) != null;
                }
                break;
            }
            case APPEND_WITH_ORDER: {
                Matcher matcher = APPEND_WITH_ORDER_PATTERN.matcher(key);
                while (matcher.find()) {
                    this.name = matcher.group(1);
                    this.appendPosition = Short.valueOf(matcher.group(3)).shortValue();
                    this.skipRightPadding = matcher.group(4) != null;
                }
                break;
            }
        }
        if (this.name == null || this.name.isEmpty() && !this.skip) {
            throw new DissectException.KeyParse(key, "The key name could be determined");
        }
    }

    DissectKey(DissectKey key, Modifier modifier) {
        this.modifier = modifier;
        this.skipRightPadding = key.skipRightPadding;
        this.skip = key.skip;
        this.name = key.name;
        this.appendPosition = key.appendPosition;
    }

    Modifier getModifier() {
        return this.modifier;
    }

    boolean skip() {
        return this.skip;
    }

    boolean skipRightPadding() {
        return this.skipRightPadding;
    }

    int getAppendPosition() {
        return this.appendPosition;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return "DissectKey{modifier=" + this.modifier + ", skip=" + this.skip + ", appendPosition=" + this.appendPosition + ", name='" + this.name + "'}";
    }

    public static enum Modifier {
        NONE(""),
        APPEND_WITH_ORDER("/"),
        APPEND("+"),
        FIELD_NAME("*"),
        FIELD_VALUE("&"),
        NAMED_SKIP("?");

        private static final Pattern MODIFIER_PATTERN;
        private final String modifier;

        public String toString() {
            return this.modifier;
        }

        private Modifier(String modifier) {
            this.modifier = modifier;
        }

        static Modifier fromString(String modifier) {
            return EnumSet.allOf(Modifier.class).stream().filter(km -> km.modifier.equals(modifier)).findFirst().orElseThrow(() -> new IllegalArgumentException("Found invalid modifier."));
        }

        private static Modifier findModifier(String key) {
            Modifier modifier = NONE;
            if (key != null && !key.isEmpty()) {
                Matcher matcher = MODIFIER_PATTERN.matcher(key);
                int matches = 0;
                while (matcher.find()) {
                    Modifier priorModifier = modifier;
                    modifier = Modifier.fromString(matcher.group());
                    if (++matches <= 1 || APPEND.equals((Object)priorModifier) && APPEND_WITH_ORDER.equals((Object)modifier)) continue;
                    throw new DissectException.KeyParse(key, "multiple modifiers are not allowed.");
                }
            }
            return modifier;
        }

        static {
            MODIFIER_PATTERN = Pattern.compile("[/+*&?]");
        }
    }
}

