/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class ApostropheTypeFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        String wordFrom = this.getRequired("wordFrom", arguments);
        boolean hasTypographicalApostrophe = this.getRequired("hasTypographicalApostrophe", arguments).equalsIgnoreCase("true");
        if (wordFrom != null) {
            int posWord;
            if (wordFrom.equals("marker")) {
                for (posWord = 0; posWord < patternTokens.length && patternTokens[posWord].getStartPos() < match.getFromPos(); ++posWord) {
                }
                ++posWord;
            } else {
                posWord = Integer.parseInt(wordFrom);
            }
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("ApostropheTypeFilter: Index out of bounds in " + match.getRule().getFullId() + ", wordFrom: " + posWord);
            }
            AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
            if (hasTypographicalApostrophe == atrWord.hasTypographicApostrophe()) {
                return match;
            }
        }
        return null;
    }
}

