/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.lang.ref.WeakReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleTable;
import org.GNOME.Accessibility.AtkUtil;

public class AtkTableCell {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleTable> _acc_pt;
    public int row;
    public int rowSpan;
    public int column;
    public int columnSpan;

    public AtkTableCell(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        Accessible accessible = accessibleContext.getAccessibleParent();
        this._acc_pt = null;
        this.row = -1;
        this.rowSpan = -1;
        this.column = -1;
        this.columnSpan = -1;
        if (accessible == null) {
            return;
        }
        AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
        if (accessibleContext2 == null) {
            return;
        }
        AccessibleTable accessibleTable = accessibleContext2.getAccessibleTable();
        if (accessibleTable == null) {
            return;
        }
        this._acc_pt = new WeakReference<AccessibleTable>(accessibleTable);
        int n = accessibleContext.getAccessibleIndexInParent();
        if (!(accessibleTable instanceof AccessibleExtendedTable)) {
            return;
        }
        AccessibleExtendedTable accessibleExtendedTable = (AccessibleExtendedTable)accessibleTable;
        this.row = accessibleExtendedTable.getAccessibleRow(n);
        this.column = accessibleExtendedTable.getAccessibleColumn(n);
        this.rowSpan = accessibleTable.getAccessibleRowExtentAt(this.row, this.column);
        this.columnSpan = accessibleTable.getAccessibleColumnExtentAt(this.row, this.column);
    }

    public static AtkTableCell createAtkTableCell(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkTableCell(accessibleContext), null);
    }

    public AccessibleTable getTable() {
        if (this._acc_pt == null) {
            return null;
        }
        return (AccessibleTable)this._acc_pt.get();
    }

    public AccessibleContext[] getAccessibleColumnHeader() {
        if (this._acc_pt == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleTable accessibleTable = ((AccessibleTable)this._acc_pt.get()).getAccessibleColumnHeader();
            if (accessibleTable != null) {
                int n = accessibleTable.getAccessibleColumnCount();
                AccessibleContext[] accessibleContextArray = new AccessibleContext[n];
                for (int i = 0; i < n; ++i) {
                    accessibleContextArray[i] = accessibleTable.getAccessibleAt(0, i).getAccessibleContext();
                }
                return accessibleContextArray;
            }
            return null;
        }, null);
    }

    public AccessibleContext[] getAccessibleRowHeader() {
        if (this._acc_pt == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleTable accessibleTable = ((AccessibleTable)this._acc_pt.get()).getAccessibleRowHeader();
            if (accessibleTable != null) {
                int n = accessibleTable.getAccessibleRowCount();
                AccessibleContext[] accessibleContextArray = new AccessibleContext[n];
                for (int i = 0; i < n; ++i) {
                    accessibleContextArray[i] = accessibleTable.getAccessibleAt(i, 0).getAccessibleContext();
                }
                return accessibleContextArray;
            }
            return null;
        }, null);
    }
}

