/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.beans.aware;

import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.spring.beans.ImportedBy;
import io.micronaut.spring.core.type.BeanDefinitionSpringMetadata;
import jakarta.inject.Singleton;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;

@Singleton
@Internal
public class ImportAwareListener
implements BeanCreatedEventListener<ImportAware> {
    public ImportAware onCreated(BeanCreatedEvent<ImportAware> event) {
        ImportAware importAware = (ImportAware)event.getBean();
        BeanDefinition beanDefinition = event.getBeanDefinition();
        Class importedBy = beanDefinition.getAnnotationMetadata().classValue(ImportedBy.class).orElse(null);
        if (importedBy != null) {
            event.getSource().findBeanDefinition(importedBy).ifPresent(importedDef -> importAware.setImportMetadata((AnnotationMetadata)new BeanDefinitionSpringMetadata((BeanDefinition<?>)importedDef)));
        }
        return importAware;
    }
}

