/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.NullableMap;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0010J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\rR\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "resolvedFunctionType", "Lorg/jetbrains/kotlin/fir/caches/NullableMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "Ljava/util/Map;", "samConstructorsCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "buildSamConstructor", "classSymbol", "getFunctionTypeForPossibleSamType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firRegularClass", "resolveFunctionTypeIfSamInterface", "shouldRunSamConversionForFunction", "", "firFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "resolve"})
public final class FirSamResolverImpl
extends FirSamResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final FirOuterClassManager outerClassManager;
    @NotNull
    private final Map<K, Object> resolvedFunctionType;
    @NotNull
    private final FirCache<FirRegularClassSymbol, FirNamedFunctionSymbol, FirSamResolverImpl> samConstructorsCache;

    public FirSamResolverImpl(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @Nullable FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        this.resolvedFunctionType = NullableMap.constructor-impl$default(null, 1, null);
        this.samConstructorsCache = SamResolutionKt.access$getSamConstructorStorage(this.session).getSamConstructors();
    }

    public /* synthetic */ FirSamResolverImpl(FirSession firSession, ScopeSession scopeSession, FirOuterClassManager firOuterClassManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firOuterClassManager = null;
        }
        this(firSession, scopeSession, firOuterClassManager);
    }

    @Override
    @Nullable
    public ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, this.session, null, 2, null));
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null || (coneKotlinType3 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType3)) == null) {
                return null;
            }
            ConeKotlinType coneKotlinType4 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType4 == null || (coneKotlinType4 = ConeTypeUtilsKt.upperBoundIfFlexible(coneKotlinType4)) == null) {
                return null;
            }
            coneKotlinType = new ConeFlexibleType((ConeSimpleKotlinType)coneKotlinType3, (ConeSimpleKotlinType)coneKotlinType4);
        } else if (coneKotlinType2 instanceof ConeErrorType ? true : coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (((((coneKotlinType2 instanceof ConeTypeParameterType ? true : coneKotlinType2 instanceof ConeTypeVariableType) ? true : coneKotlinType2 instanceof ConeCapturedType) ? true : coneKotlinType2 instanceof ConeDefinitelyNotNullType) ? true : coneKotlinType2 instanceof ConeIntersectionType) ? true : coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        Collection collection;
        FirTypeParameterRef firTypeParameterRef;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        FirRegularClass firRegularClass = LookupTagUtilsKt.toFirRegularClass(type2.getLookupTag(), this.session);
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = coneLookupTagBasedType;
        if (firRegularClass2.getTypeParameters().isEmpty()) {
            return (ConeLookupTagBasedType)TypeUtilsKt.withNullability$default(unsubstitutedFunctionType, ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), TypeComponentsKt.getTypeContext(this.session), null, 4, null);
        }
        Iterable iterable = firRegularClass2.getTypeParameters();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        $this$map$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Object[])type2.getTypeArguments());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            firTypeParameterRef = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeParameterSymbol parameterSymbol = (FirTypeParameterSymbol)firTypeParameterRef.component1();
            ConeTypeProjection projection = (ConeTypeProjection)firTypeParameterRef.component2();
            ConeKotlinTypeProjection coneKotlinTypeProjection = projection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)projection : null;
            if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
                ConeKotlinTypeProjection coneKotlinTypeProjection2;
                if ((FirTypeRef)CollectionsKt.firstOrNull(((FirTypeParameter)parameterSymbol.getFir()).getBounds()) != null) {
                    FirTypeRef $this$coneTypeSafe$iv;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    coneKotlinTypeProjection2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinTypeProjection2 instanceof ConeKotlinType)) {
                        coneKotlinTypeProjection2 = null;
                    }
                } else {
                    coneKotlinTypeProjection2 = coneKotlinTypeProjection = null;
                }
                if (coneKotlinTypeProjection2 == null) {
                    coneKotlinTypeProjection = this.session.getBuiltinTypes().getNullableAnyType().getType();
                }
            }
            ConeKotlinTypeProjection typeArgument = coneKotlinTypeProjection;
            collection.add(new Pair((Object)parameterSymbol, (Object)typeArgument));
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)((List)destination$iv$iv)), this.session);
        ConeKotlinType result2 = TypeUtilsKt.withNullability$default(substitutor2.substituteOrSelf(unsubstitutedFunctionType), ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), TypeComponentsKt.getTypeContext(this.session), null, 4, null);
        if (!(result2 instanceof ConeLookupTagBasedType)) {
            boolean bl = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(result2.getClass()) + " was found";
            throw new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)result2;
    }

    @Override
    @Nullable
    public FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firRegularClass) {
        Intrinsics.checkNotNullParameter((Object)firRegularClass, (String)"firRegularClass");
        FirNamedFunctionSymbol firNamedFunctionSymbol = this.samConstructorsCache.getValue(firRegularClass.getSymbol(), this);
        return firNamedFunctionSymbol != null ? (FirSimpleFunction)firNamedFunctionSymbol.getFir() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructor(@NotNull FirRegularClassSymbol classSymbol) {
        FirSimpleFunction firSimpleFunction;
        void $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        FirValueParameterBuilder firValueParameterBuilder;
        void $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d12;
        void $this$mapTo$iv$iv;
        void $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10;
        FirSimpleFunctionBuilder $i$f$map42;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$mapTo$iv$iv2;
        Iterator $this$map$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv4;
        void it;
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
        FirRegularClass firRegularClass = (FirRegularClass)classSymbol.getFir();
        ConeLookupTagBasedType coneLookupTagBasedType = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (coneLookupTagBasedType == null) {
            return null;
        }
        ConeLookupTagBasedType functionType = coneLookupTagBasedType;
        ClassId classId = FirDeclarationUtilKt.getClassId(firRegularClass);
        FqName fqName3 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.packageFqName");
        FqName fqName4 = fqName2 = classId.getRelativeClassName().parent();
        FqName fqName5 = fqName3;
        boolean bl = false;
        boolean bl2 = !it.isRoot();
        FqName fqName6 = bl2 ? fqName2 : null;
        Name name = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        FqName fqName7 = null;
        Name name2 = name;
        FqName fqName8 = fqName6;
        FqName fqName9 = fqName5;
        CallableId callableId = new CallableId(fqName9, fqName8, name2, fqName7, n, defaultConstructorMarker);
        FirSyntheticFunctionSymbol symbol2 = new FirSyntheticFunctionSymbol(callableId);
        Iterable $this$map$iv3 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            FirTypeParameterBuilder $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl4 = false;
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setSource(declaredTypeParameter.getSource());
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setModuleData(FirModuleDataKt.getModuleData(this.session));
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setResolvePhase(FirResolvePhase.Companion.getDECLARATIONS());
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setName(declaredTypeParameter.getName());
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setSymbol(new FirTypeParameterSymbol());
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setVariance(Variance.INVARIANT);
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setReified(false);
            CollectionsKt.addAll((Collection)$this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.getAnnotations(), (Iterable)declaredTypeParameter.getAnnotations());
            $this$buildSamConstructor_u24lambda_u2d5_u24lambda_u2d4.setContainingDeclarationSymbol(symbol2);
            collection.add(firTypeParameterBuilder);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            FirTypeParameterBuilder bl3 = (FirTypeParameterBuilder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(new ConeTypeParameterTypeImpl(it2.getSymbol().toLookupTag(), false, null, 4, null));
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map42 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            FirTypeParameterRef bl5 = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add(it3.getSymbol());
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)), this.session);
        for (Pair $i$f$map42 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv5;
            Object item$iv$iv;
            FirTypeParameterBuilder newTypeParameter = (FirTypeParameterBuilder)$i$f$map42.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$i$f$map42.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv = newTypeParameter.getBounds();
            Iterable $this$map$iv4 = declared.getSymbol().getResolvedBounds();
            boolean $i$f$map5 = false;
            Iterable bl6 = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                void typeRef;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl7 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                FirResolvedTypeRefBuilder $this$buildSamConstructor_u24lambda_u2d9_u24lambda_u2d8 = firAnnotationContainerBuilder;
                boolean bl8 = false;
                $this$buildSamConstructor_u24lambda_u2d9_u24lambda_u2d8.setSource(typeRef.getSource());
                $this$buildSamConstructor_u24lambda_u2d9_u24lambda_u2d8.setType(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType((FirTypeRef)typeRef)));
                collection.add(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
            }
            $this$map$iv4 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)item$iv$iv, (Iterable)$this$map$iv4);
        }
        boolean $i$f$buildSimpleFunction = false;
        FirSimpleFunctionBuilder $this$buildSamConstructor_u24lambda_u2d15 = $i$f$map42 = new FirSimpleFunctionBuilder();
        boolean bl9 = false;
        $this$buildSamConstructor_u24lambda_u2d15.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructor_u24lambda_u2d15.setSource(firRegularClass.getSource());
        Name name3 = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"classId.shortClassName");
        $this$buildSamConstructor_u24lambda_u2d15.setName(name3);
        $this$buildSamConstructor_u24lambda_u2d15.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility22 = false;
        Visibility visibility2 = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
        $this$visibility$iv = new FirResolvedDeclarationStatusImpl(visibility2, Modality.FINAL, EffectiveVisibility.Local.INSTANCE);
        FirPureAbstractElement $i$f$getVisibility22 = $this$visibility$iv;
        Object object = $this$buildSamConstructor_u24lambda_u2d15;
        boolean bl10 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setExpect($this$isExpect$iv.getStatus().isExpect());
        Object $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual = false;
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setActual(((FirMemberDeclaration)$this$isActual$iv).getStatus().isActual());
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setOverride(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setOperator(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setInfix(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setExternal(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setInline(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setSuspend(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d10.setTailRec(false);
        ((FirSimpleFunctionBuilder)object).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSamConstructor_u24lambda_u2d15.setSymbol(symbol2);
        $this$visibility$iv = $this$buildSamConstructor_u24lambda_u2d15.getTypeParameters();
        Iterable $this$map$iv5 = newTypeParameters;
        boolean $i$f$map6 = false;
        $this$isActual$iv = $this$map$iv5;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            FirTypeParameterBuilder bl7 = (FirTypeParameterBuilder)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl11 = false;
            object.add(it4.build());
        }
        $this$map$iv5 = (List)destination$iv$iv5;
        CollectionsKt.addAll((Collection)$this$visibility$iv, (Iterable)$this$map$iv5);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        ConeClassLikeLookupTag coneClassLikeLookupTag = firRegularClass.getSymbol().toLookupTag();
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        Intrinsics.checkNotNull((Object)coneTypeParameterTypeImplArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag, coneTypeParameterTypeImplArray, false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        thisCollection$iv = $i$f$toTypedArray22;
        object = $this$buildSamConstructor_u24lambda_u2d15;
        boolean bl12 = false;
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d12.setSource(null);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d12.setType(substitutedReturnType);
        ((FirSimpleFunctionBuilder)object).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection2 = $this$buildSamConstructor_u24lambda_u2d15.getValueParameters();
        boolean $i$f$buildValueParameter = false;
        FirValueParameterBuilder $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14 = firValueParameterBuilder = new FirValueParameterBuilder();
        boolean bl13 = false;
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setModuleData(FirModuleDataKt.getModuleData(this.session));
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        FirResolvedTypeRefBuilder bl11 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        firAnnotationContainerBuilder = $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14;
        boolean bl14 = false;
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13.setSource(firRegularClass.getSource());
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13.setType(substitutedFunctionType);
        ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setName(SamResolutionKt.access$getSAM_PARAMETER_NAME$p());
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setSymbol(new FirValueParameterSymbol(SamResolutionKt.access$getSAM_PARAMETER_NAME$p()));
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setCrossinline(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setNoinline(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setVararg(false);
        $this$buildSamConstructor_u24lambda_u2d15_u24lambda_u2d14.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        collection2.add(firValueParameter);
        $this$buildSamConstructor_u24lambda_u2d15.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction $this$buildSamConstructor_u24lambda_u2d16 = firSimpleFunction = $i$f$map42.build();
        boolean bl15 = false;
        Object object2 = this.outerClassManager;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildSamConstructor_u24lambda_u2d16, object2 != null && (object2 = ((FirOuterClassManager)object2).outerClass(firRegularClass.getSymbol())) != null ? ((FirClassLikeSymbol)object2).toLookupTag() : null);
        return firSimpleFunction.getSymbol();
    }

    private final ConeLookupTagBasedType resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Map<FirRegularClass, Object> $this$getOrPut_u2dLcU4HiU$iv = this.resolvedFunctionType;
        boolean bl = false;
        boolean bl2 = false;
        Object value$iv$iv = $this$getOrPut_u2dLcU4HiU$iv.get(firRegularClass);
        if (value$iv$iv == null) {
            ConeLookupTagBasedType coneLookupTagBasedType;
            ConeLookupTagBasedType coneLookupTagBasedType2;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!firRegularClass.getStatus().isFun()) {
                coneLookupTagBasedType2 = null;
            } else {
                FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.session, this.scopeSession);
                if (firSimpleFunction == null) {
                    coneLookupTagBasedType2 = null;
                } else {
                    FirSimpleFunction abstractMethod = firSimpleFunction;
                    coneLookupTagBasedType2 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
                }
            }
            ConeLookupTagBasedType it$iv = coneLookupTagBasedType = coneLookupTagBasedType2;
            boolean bl5 = false;
            boolean bl6 = false;
            Object object2 = it$iv;
            if (object2 == null) {
                object2 = NullableMap.NullValue.INSTANCE;
            }
            $this$getOrPut_u2dLcU4HiU$iv.put(firRegularClass, object2);
            object = coneLookupTagBasedType;
        } else {
            object = Intrinsics.areEqual((Object)value$iv$iv, (Object)NullableMap.NullValue.INSTANCE) ? null : value$iv$iv;
        }
        return (ConeLookupTagBasedType)object;
    }

    @Override
    public boolean shouldRunSamConversionForFunction(@NotNull FirFunction firFunction) {
        Intrinsics.checkNotNullParameter((Object)firFunction, (String)"firFunction");
        return true;
    }
}

