/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.BezierEdgeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.edge.HiddenEdgeView;
import org.freeplane.view.swing.map.edge.HiddenOutlineEdgeView;
import org.freeplane.view.swing.map.edge.HorizontalEdgeView;
import org.freeplane.view.swing.map.edge.LinearEdgeView;
import org.freeplane.view.swing.map.edge.OutlineEdgeView;
import org.freeplane.view.swing.map.edge.SharpBezierEdgeView;
import org.freeplane.view.swing.map.edge.SharpLinearEdgeView;
import org.freeplane.view.swing.map.edge.SummaryEdgeView;

public class EdgeViewFactory {
    private static final EdgeViewFactory instance = new EdgeViewFactory();

    public EdgeView getEdge(NodeView source, NodeView target, Component paintedComponent) {
        EdgeStyle edgeStyle = target.getEdgeStyle();
        if (source.getMap().getLayoutType() == MapViewLayout.OUTLINE) {
            if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_HIDDEN)) {
                return new HiddenOutlineEdgeView(source, target, paintedComponent);
            }
            return new OutlineEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_LINEAR)) {
            return new LinearEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_BEZIER)) {
            return new BezierEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_SUMMARY)) {
            return new SummaryEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_SHARP_LINEAR)) {
            return new SharpLinearEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_SHARP_BEZIER)) {
            return new SharpBezierEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_HORIZONTAL)) {
            return new HorizontalEdgeView(source, target, paintedComponent);
        }
        if (edgeStyle.equals((Object)EdgeStyle.EDGESTYLE_HIDDEN)) {
            return new HiddenEdgeView(source, target, paintedComponent);
        }
        System.err.println("Unknown Edge Type.");
        return new LinearEdgeView(source, target, paintedComponent);
    }

    public static EdgeViewFactory getInstance() {
        return instance;
    }
}

