/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.api;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.freeplane.api.PhysicalUnit;

public class Quantity<U extends Enum<U>> {
    private static final DecimalFormat ROUNDING_FORMAT = new DecimalFormat("###.#####", DecimalFormatSymbols.getInstance(Locale.US));
    public final double value;
    public final U unit;

    public static <U extends Enum<U>> Quantity<U> fromString(String valueString, U defaultUnit) {
        U unit;
        String numberString;
        if (valueString == null) {
            return null;
        }
        int separatorPosition = valueString.lastIndexOf(32);
        if (separatorPosition >= 0) {
            numberString = valueString.substring(0, separatorPosition);
            String unitString = valueString.substring(separatorPosition + 1);
            Class<U> unitClass = defaultUnit.getDeclaringClass();
            unit = Enum.valueOf(unitClass, unitString);
        } else {
            numberString = valueString;
            unit = defaultUnit;
        }
        try {
            double doubleValue = ROUNDING_FORMAT.parse(numberString).doubleValue();
            return new Quantity<U>(doubleValue, unit);
        }
        catch (ParseException e) {
            throw new NumberFormatException("Invalid number " + numberString);
        }
    }

    public Quantity(double value, U unit) {
        this.value = value;
        this.unit = unit;
    }

    public double toBaseUnits() {
        return this.value * ((PhysicalUnit)this.unit).factor();
    }

    public int toBaseUnitsRounded() {
        return (int)(this.toBaseUnits() + 0.5);
    }

    public String toString() {
        String rounded = ROUNDING_FORMAT.format(this.value);
        return rounded + " " + this.unit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Enum)this.unit).hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        if (!((Enum)this.unit).equals(other.unit)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public Quantity<U> in(U unit) {
        return new Quantity<U>(this.value * (((PhysicalUnit)this.unit).factor() / ((PhysicalUnit)unit).factor()), unit);
    }

    public void assertNonNegative() {
        if (this.value < 0.0) {
            throw new IllegalStateException("non negative value required");
        }
    }

    public static <U extends Enum<U>> void assertNonNegativeOrNull(Quantity<U> quantity) {
        if (quantity != null) {
            quantity.assertNonNegative();
        }
    }

    public Quantity<U> add(Quantity<U> second) {
        if (this.unit == second.unit) {
            return new Quantity<U>(this.value + second.value, this.unit);
        }
        double sum = this.value + second.in(this.unit).value;
        return new Quantity<U>(sum, this.unit);
    }

    public Quantity<U> add(double value, U unit) {
        return this.add(new Quantity<U>(value, unit));
    }

    public Quantity<U> zoomBy(double zoom) {
        return new Quantity<U>(this.value * zoom, this.unit);
    }
}

