/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.gui.DynamicUIManagerListener;

public class DynamicUIManager {
    private static final DynamicUIManager instance = new DynamicUIManager();
    private ArrayList listeners = new ArrayList(2);
    private ArrayList prioritizedListeners = new ArrayList(2);
    private String[] properties = new String[]{"win.3d.backgroundColor", "win.3d.highlightColor", "win.3d.lightColor", "win.3d.shadowColor", "win.frame.activeCaptionColor", "win.frame.activeCaptionGradientColor", "win.frame.captionTextColor", "win.frame.activeBorderColor", "win.mdi.backgroundColor", "win.desktop.backgroundColor", "win.frame.inactiveCaptionColor", "win.frame.inactiveCaptionGradientColor", "win.frame.inactiveCaptionTextColor", "win.frame.inactiveBorderColor", "win.menu.backgroundColor", "win.menu.textColor", "win.frame.textColor?????", "win.item.highlightColor", "win.item.highlightTextColor", "win.tooltip.backgroundColor", "win.tooltip.textColor", "win.frame.backgroundColor", "win.frame.textColor", "win.item.hotTrackedColor"};
    private Toolkit currentToolkit;
    private boolean propertyChangePending;

    public static DynamicUIManager getInstance() {
        return instance;
    }

    private DynamicUIManager() {
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                DynamicUIManager.this.handlePropertyChanges();
            }
        };
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    DynamicUIManager.this.setupPropertyListener(l);
                    DynamicUIManager.this.fireLookAndFeelChanging();
                    DynamicUIManager.this.fireLookAndFeelChanged();
                }
            }
        });
        UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!(event.getNewValue() instanceof Class)) {
                    DynamicUIManager.this.handlePropertyChanges();
                }
            }
        });
        this.setupPropertyListener(l);
    }

    private void setupPropertyListener(PropertyChangeListener l) {
        int i;
        if (this.currentToolkit != null) {
            i = 0;
            while (i < this.properties.length) {
                this.currentToolkit.removePropertyChangeListener(this.properties[i], l);
                ++i;
            }
        }
        this.currentToolkit = Toolkit.getDefaultToolkit();
        i = 0;
        while (i < this.properties.length) {
            this.currentToolkit.addPropertyChangeListener(this.properties[i], l);
            ++i;
        }
    }

    public void addListener(DynamicUIManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DynamicUIManagerListener l) {
        this.listeners.remove(l);
    }

    public void addPrioritizedListener(DynamicUIManagerListener l) {
        this.prioritizedListeners.add(l);
    }

    public void removePrioritizedListener(DynamicUIManagerListener l) {
        this.prioritizedListeners.remove(l);
    }

    private void fireLookAndFeelChanging() {
        Object[] l = this.prioritizedListeners.toArray();
        Object[] l2 = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((DynamicUIManagerListener)l[i]).lookAndFeelChanging();
            ++i;
        }
        i = 0;
        while (i < l2.length) {
            ((DynamicUIManagerListener)l2[i]).lookAndFeelChanging();
            ++i;
        }
    }

    private void fireLookAndFeelChanged() {
        Object[] l = this.prioritizedListeners.toArray();
        Object[] l2 = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((DynamicUIManagerListener)l[i]).lookAndFeelChanged();
            ++i;
        }
        i = 0;
        while (i < l2.length) {
            ((DynamicUIManagerListener)l2[i]).lookAndFeelChanged();
            ++i;
        }
    }

    private void handlePropertyChanges() {
        if (!this.propertyChangePending) {
            this.propertyChangePending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DynamicUIManager.this.propertyChangePending = false;
                    DynamicUIManager.this.firePropertyChanged();
                }
            });
            this.firePropertyChanging();
        }
    }

    private void firePropertyChanging() {
        Object[] l = this.prioritizedListeners.toArray();
        Object[] l2 = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((DynamicUIManagerListener)l[i]).propertiesChanging();
            ++i;
        }
        i = 0;
        while (i < l2.length) {
            ((DynamicUIManagerListener)l2[i]).propertiesChanging();
            ++i;
        }
    }

    private void firePropertyChanged() {
        Object[] l = this.prioritizedListeners.toArray();
        Object[] l2 = this.listeners.toArray();
        int i = 0;
        while (i < l.length) {
            ((DynamicUIManagerListener)l[i]).propertiesChanged();
            ++i;
        }
        i = 0;
        while (i < l2.length) {
            ((DynamicUIManagerListener)l2[i]).propertiesChanged();
            ++i;
        }
    }
}

