---
title: Операційні системи BSD
x-toc-enable: true
...

Керівництво було востаннє оновлено 16 листопада 2022 року.

ПРИМІТКА: Це керівництво стосується хостів x86, і не покриває підтримувані CrOS/ARM
chromebook. Для цілей ARM, вам варто звернутись до документації u-boot.

Canoeboot є спроможним завантажити багато систем BSD. Ця секція в основному задокументовує
особливості Canoeboot, які стосуються BSD; ви можете в іншому випадку звернутись до
офіційної документації для будь-якої системи BSD, яку хочете використовувати.

Kernel Mode Setting
===================

Ваша система BSD *мусить* підтримувати Kernel Mode Setting для вашого графічного
пристрою (більшість з них підтримує в ці дні). Причини стануть очевидними, як
ви прочитаєте цю статтю.

Завантажуйте BSD, використовуючи SeaBIOS
=======================

На платформах x86, Canoeboot надає вибір корисного навантаження GRUB та/або
SeaBIOS. GRUB технічно може завантажувати ядра BSD, але код погано
підтримується і є ненадійним для цього сценарію використання; на системах BIOS,
GRUB може завантажити ланцюгом завантажувачі BSD, але bare metal (в якості корисного навантаження coreboot),
GRUB може тільки завантажити ланцюгом інші корисні навантаження coreboot або завантажити ядра Linux/BSD
безпосередньо (але безпосереднє завантаження тільки реально надійне для Linux, в GRUB).

Це рекомендовано, щоб ви завантажувались в текстовому режимі, з SeaBIOS. Ви можете буквально
просто слідкувати офіційним керівництвам встановлення для вашої системи BSD, чи це буде
FreeBSD, OpenBSD або інші.

Якщо ви не плануєте встановлювати Xorg/Wayland, тоді це все, що вам дійсно треба
робити. Наприклад, ви могли би хотіти виконувати сервер headless, у випадку чого ви
мабуть не заперечуєте виконувати текстовий режим весь час.

OpenBSD та corebootfb
----------------------

Досі рекомендовано використовувати SeaBIOS в текстовому режимі, але OpenBSD конкретно
може працювати з завантаженням SeaBIOS в coreboot framebuffer, з SeaVGABIOS. В
Canoeboot образах ROM, це були би образи SeaBIOS з `corebootfb` в
імені файла.

Переконайтесь, щоб вибрати розмітку в стилі MBR у встановлювачі, і він буде
Просто Працювати.

Якщо ви використовуєте корисне навантаження GRUB, але SeaBIOS є доступним в меню завантаження,
ви можете просто вибрати SeaBIOS в сказаному меню, і OpenBSD буде працювати чудово.

FreeBSD та corebootfb
----------------------

Припущений поламаним, тому будь ласка переконайтесь, що ви завантажуєтесь з корисним навантаженням SeaBIOS в текстовому
режимі (lbmk образи ROM з `txtmode` в імені файлу, не `corebootfb`).

Попередження для користувачів X11
----------------------

Одна важлива особливість більшості систем Canoeboot: Підтримка VGA mode
існує, якщо завантажуєтесь з corebootfb (власний framebuffer coreboot) і
option ROM SeaVGABIOS використано в корисному навантаженні SeaBIOS; хоча, можливість
змінювати режими не є присутньою, що означає, що ви не можете перемикнутись на текстовий режим
так само.

Coreboot може розпочатись в framebuffer (corebootfb) або INT10H текстовому режимі, і він залишається
в будь-якому встановленому режимі, допоки KMS використано для зміни режиму. Має
бути відмічено, що coreboot framebuffer це не є VGA mode, але натомість
coreboot реалізує мінімальні драйвери для апаратного забезпечення, яке він підтримує, надаючи
framebuffer безпосередньо в пам'яті, яке програмне забезпечення (таке як GRUB) може просто
використовувати.

Завантажувачі BSD на x86, в BIOS системах, типово очікують запуск текстового
режиму. Це зазвичай можливо встановити консоль на вищі VGA mode,
на більшості систем, але не на більшості систем coreboot з використаною нативною
ініціалізацією відео, в зв'язку з примхами, що вже описано. Якщо ви бачити будь-яку
документацію (на землі BSD), що стосується VESA mode, ігноруйте її повністю;
допоки ви не використовуєте пропрієтарний VGA ROM для вашого пристрою, це не буде працювати,
і Canoeboot не поширює це (натомість, власна ініціалізація відео coreboot
використана там, де можливо, або налаштування headless корисного навантаження SeaBIOS
надано, де ви би або виконували його headless, або встановили графічну
карту).

Тепер, це би інакше значило: відсутність X11/Wayland. Якщо ви запускаєтесь в corebootfb
mode з SeaVGABIOS, ви не отримаєте дисплей в завантажувачах BSD, і якщо ви завантажуєтесь
в текстовому режимі, ви не можете встановити VESA mode з BSD. Тим не менш, ви в удачі:

Щонайменш OpenBSD та FreeBSD (можливо інші) всі мають чудову підтримку KMS
в ці дні; коротко для `Kernel Mode Setting`. Це уникає неефективності
методів BIOS/UEFI, маючи ядро, що встановлює режими безпосередньо. Воно засновано на
драйверах KMS, що проекти BSD портували з ядра Linux. З цим,
ви можете використовувати X11/Wayland в FreeBSD (і просто X11 в OpenBSD, тепер).

Наприклад: в FreeBSD, ви можете встановити `graphics/drm-kmod` в якості пакунка
або з портів, і (для графічних карток Intel) зробіть це:

	sysrc kld_list+="i915kms"

Це створює наступний запис в `/etc/rc.conf`:

	kld_list="i915kms"

В FreeBSD також рекомендовано, щоб ви перемикнулись на KMS в консолі/TTY;
додайте це до `/boot/loader.conf`, щоб ви могли досі використовувати консоль після завершення
Xorg:

	kern.vty=vt

Вам не варто сподіватись на вищезазначену інструкцію (для FreeBSD), тому що точний
крок може змінитись, і це не йде в повні подробиці так само. Зверніться до
документації, наданої вашою системою, щоб знати те, як налаштовується KMS.

ЗАВЖДИ ЧИТАЙТЕ КЕРІВНИЦТВО
----------------------

Всі BSD мають *чудову* документацію; це одна з визначних
характеристик, проти типових дистрибутивів Linux.

Осторонь від цієї примхи в coreboot, що стосується *BIOS* video mode, BSD
в іншому випадку працюють в точності таким чином, як ви би передбачали, і ви можете
прослідувати їх офіційній документації без значної метушні.

Ніяких конкретних або деталізованих керівництв не буде надано тут, оскільки SeaBIOS
справедливо пояснюючий сам за себе; ви можете в іншому випадку посилатись до документації
SeaBIOS.

Якщо ви прошиваєте ROM для машини, де `seabios_withgrub`
та `seabios_grubfirst` ROM є доступними, виберіть `seabios_withgrub`.

НЕ ВИКОРИСТОВУЙТЕ ОБРАЗИ ROM З `seabios_grubfirst` В ІМЕНІ ФАЙЛА! Ці були
присутніми в старіших випусках Canoeboot, і підтримувались в минулих ревізіях
системи побудови, але вони не працювали для передбаченої мети. Більше
інформації написано в [керівництві встановлення Canoeboot](../install/). ROM
образи з `seabios_grubfirst` в імені файла НЕ буде включено в
наступні випуски Canoeboot.

Сумнівна згадка: Tianocore
--------------------------

Tianocore є надзвичайно роздутим, та непридатним для аудіту, тому його не включено
в прошивку Canoeboot, але це реалізація посилання UEFI від
Intel та вкладників. Він можете завантажувати більшість систем BSD дуже добре.

Більш міцним шляхам для надання послуг UEFI в Canoeboot бути дослідженими.
Інтеграція Tianocore не буде надана офіційно, в жодному з поточних або майбутніх
випусків Canoeboot.

Настільні користувачі
-------------

ПРИМІТКА: Ця секція не може бути повністю точною; наприклад, сторінка апаратного забезпечення
про HP Elite 8200 SFF розповідає про використання графічних карток на обох налаштуваннях corebootfb
та txtmode, і здається працюючою добре з SeaBIOS в обох випадках.

Настільні користувачі на Canoeboot мають просто встановити графічну картку,
та знову завантажитись з SeaBIOS в текстовому режимі; тим не менш, коли ви робите це,
SeaBIOS виконає option ROM VGA на карточці, яка надасть
ранню ініціалізацію відео, замість ініціалізації coreboot, і цей
VGA ROM зазвичай буде реалізовувати повні INT10H mode, включаючи можливість
встановлювати режими в BIOS (використовуючи переривання), у випадку чого ви не
маєте хвилюватись про Kernel Mode Setting, але вам варто досі використовувати KMS
в будь-якому випадку.

Причиною використовувати KMS є те, що він більш ефективний. Сервіс INT10H може тільки
бути викликано в Real Mode або Virtual 8086 mode; v8086 є недоступним в
long mode (x86\_64) та перемикання в Real Mode лише для встановлення VGA mode є
надзвичайно дорого, говорячи з точки зору обчислень. Це те, чому сучасні ядра
(Linux та BSD) роблять mode setting самостійно.

Ви можете вивчити більше про режими INT10H text/VGA тут:

<https://en.wikipedia.org/wiki/INT_10H>
