#ifndef VNOTEAUDIODEVICEWATCHER_H
#define VNOTEAUDIODEVICEWATCHER_H

#include <com_deepin_daemon_audio.h>
#include <com_deepin_daemon_audio_source.h>

#include <QThread>

class VNoteAudioDeviceWatcher : public QThread
{
    Q_OBJECT
public:
    explicit VNoteAudioDeviceWatcher(QObject *parent = nullptr);
    virtual ~VNoteAudioDeviceWatcher() override;

    void initDeviceWatcher();
    void initWatcherCofing();
    void exitWatcher();

    enum MicrophoneState {
        NotAvailable,
        VolumeTooLow,   // volume lower than 20%
        Normal,         // volume more than 20%
    };
signals:
    void microphoneAvailableState(int isAvailable);
    void inputSourceChanged(const QString &name);
public slots:
    void onDefaultSourceChanaged(const QDBusObjectPath & value);
    void onCardsChanged(const QString & value);
protected:
    virtual void run() override;

    void initAudioMeter();
    void initConnections();
    void initAvailInputPorts(const QString& cards);
    bool isMicrophoneAvail(const QString& activePort) const;

private:
    const QString m_serviceName {"com.deepin.daemon.Audio"};

    QScopedPointer<com::deepin::daemon::Audio> m_audioInterface;
    QScopedPointer<com::deepin::daemon::audio::Source> m_defaultSource;

    //Reference the state to AudioPort
    enum PortState {
        Unkown = 0,
        UnAvailable,
        Available,
    };

    typedef QString PortID;

    struct Port {
        PortID  portId;
        QString portName;
        QString cardName;
        int     available {UnAvailable};
        int     cardId;
        bool    isActive {false};

        bool isInputPort() const;
        bool isLoopback() const;
    };

    friend QDebug& operator << (QDebug& out, const Port &port);

    MicrophoneState m_microphoneState {NotAvailable};
    volatile bool m_quitWatcher {false};

    //All available input ports.except loopback port.
    QMap<PortID, Port> m_availableInputPorts;

    bool m_fNeedDeviceChecker {true};
};

#endif // VNOTEAUDIODEVICEWATCHER_H
