/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.4.5*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#define D_S_SIZE DELTA_SWINGIDX_SIZE

#if (RTL8822B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}

static boolean
check_negative(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2
)
{
	return true;
}

/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8822b_radioa[] = {
		0x000, 0x00030000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000D0F4E,
	0xA0000000,	0x00000000,
		0x03F, 0x000C0F4E,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x000DEFCE,
		0x0EF, 0x00000000,
		0x07F, 0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xB0000000,	0x00000000,
		0x0B1, 0x0007DBE4,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0B2, 0x000215D1,
	0xA0000000,	0x00000000,
		0x0B2, 0x000225D1,
	0xB0000000,	0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C330,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0003C360,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xB0000000,	0x00000000,
		0x0B4, 0x00099DD0,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0B5, 0x000100FC,
	0xA0000000,	0x00000000,
		0x0B5, 0x000400FC,
	0xB0000000,	0x00000000,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000000,
		0x0BC, 0x00040030,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C146,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
		0x08E, 0x00064D40,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0xA0000000,	0x00000000,
		0x03E, 0x00004080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004084,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040C8,
	0xA0000000,	0x00000000,
		0x03E, 0x000040C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004108,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004190,
	0xA0000000,	0x00000000,
		0x03E, 0x00004190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x0000490C,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004998,
	0xA0000000,	0x00000000,
		0x03E, 0x00004998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005E00,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005840,
	0xA0000000,	0x00000000,
		0x03E, 0x00005840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005862,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000058C2,
	0xA0000000,	0x00000000,
		0x03E, 0x000058C2,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005948,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00005930,
	0xA0000000,	0x00000000,
		0x03E, 0x00005930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000DFF86,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000006,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x0B8, 0x00080A00,
		0x0FE, 0x00000000,
		0x0B0, 0x000FF0FA,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0CA, 0x00080000,
		0x0FE, 0x00000000,
		0x0C9, 0x0001C141,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0B0, 0x000FF0F8,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0EE, 0x00000002,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000004,
		0x033, 0x00000003,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x00000004,
		0x033, 0x00000005,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000004,
		0x033, 0x00000007,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0xA0000000,	0x00000000,
		0x061, 0x0005D3D0,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
		0x0EF, 0x00000000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000303,
		0x030, 0x00001303,
		0x030, 0x00002303,
		0x030, 0x00003303,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x00004355,
		0x030, 0x00005355,
		0x030, 0x00006355,
		0x030, 0x00007355,
		0x030, 0x00008315,
		0x030, 0x00009315,
		0x030, 0x0000A315,
		0x030, 0x0000B315,
		0x0EF, 0x00000000,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000384,
		0x030, 0x00001384,
		0x030, 0x00002384,
		0x030, 0x00003384,
		0x030, 0x00004425,
		0x030, 0x00005425,
		0x030, 0x00006425,
		0x030, 0x00007425,
		0x030, 0x000084A6,
		0x030, 0x000094A6,
		0x030, 0x0000A4A6,
		0x030, 0x0000B4A6,
		0x0EF, 0x00000000,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000463,
		0x030, 0x00001463,
		0x030, 0x00002463,
		0x030, 0x00003463,
		0x030, 0x00004545,
		0x030, 0x00005545,
		0x030, 0x00006545,
		0x030, 0x00007545,
		0x030, 0x00008565,
		0x030, 0x00009565,
		0x030, 0x0000A565,
		0x030, 0x0000B565,
		0x0EF, 0x00000000,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
		0x0EF, 0x00000000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
		0x0EF, 0x00000000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000443,
		0x030, 0x00001443,
		0x030, 0x00002443,
		0x030, 0x00003443,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
		0x0EF, 0x00000000,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000443,
		0x030, 0x00001443,
		0x030, 0x00002443,
		0x030, 0x00003443,
		0x030, 0x00004483,
		0x030, 0x00005483,
		0x030, 0x00006483,
		0x030, 0x00007483,
		0x030, 0x000084A4,
		0x030, 0x000094A4,
		0x030, 0x0000A4A4,
		0x030, 0x0000B4A4,
		0x0EF, 0x00000000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000361,
		0x030, 0x00001361,
		0x030, 0x00002361,
		0x030, 0x00003361,
		0x030, 0x00004443,
		0x030, 0x00005443,
		0x030, 0x00006443,
		0x030, 0x00007443,
		0x030, 0x00008424,
		0x030, 0x00009424,
		0x030, 0x0000A424,
		0x030, 0x0000B424,
		0x0EF, 0x00000000,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
		0x0EF, 0x00000000,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000403,
		0x030, 0x00001403,
		0x030, 0x00002403,
		0x030, 0x00003403,
		0x030, 0x000044A2,
		0x030, 0x000054A2,
		0x030, 0x000064A2,
		0x030, 0x000074A2,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
		0x0EF, 0x00000000,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
		0x0EF, 0x00000000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
		0x0EF, 0x00000000,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
		0x0EF, 0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
		0x0EF, 0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x00004430,
		0x030, 0x00005430,
		0x030, 0x00006430,
		0x030, 0x00007430,
		0x030, 0x00008372,
		0x030, 0x00009372,
		0x030, 0x0000A372,
		0x030, 0x0000B372,
		0x0EF, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003D0,
		0x030, 0x000013D0,
		0x030, 0x000023D0,
		0x030, 0x000033D0,
		0x030, 0x000043D0,
		0x030, 0x000053D0,
		0x030, 0x000063D0,
		0x030, 0x000073D0,
		0x030, 0x000083D0,
		0x030, 0x000093D0,
		0x030, 0x0000A3D0,
		0x030, 0x0000B3D0,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A3,
		0x030, 0x000053A3,
		0x030, 0x000063A3,
		0x030, 0x000073A3,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000776,
		0x030, 0x00001455,
		0x030, 0x00002335,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000660,
		0x030, 0x00001443,
		0x030, 0x00002221,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000767,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000765,
		0x030, 0x00001632,
		0x030, 0x00002451,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000777,
		0x030, 0x00001454,
		0x030, 0x00002224,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001343,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000CAC,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C0C,
		0x033, 0x00000021,
		0x03F, 0x00000C29,
		0x033, 0x00000022,
		0x03F, 0x00000C2C,
		0x033, 0x00000023,
		0x03F, 0x00000C69,
		0x033, 0x00000024,
		0x03F, 0x00000CA8,
		0x033, 0x00000025,
		0x03F, 0x00000CE8,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000CE5,
		0x033, 0x00000026,
		0x03F, 0x00000CE8,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C0B,
		0x033, 0x00000021,
		0x03F, 0x00000C0E,
		0x033, 0x00000022,
		0x03F, 0x00000C2B,
		0x033, 0x00000023,
		0x03F, 0x00000C2E,
		0x033, 0x00000024,
		0x03F, 0x00000C89,
		0x033, 0x00000025,
		0x03F, 0x00000CE8,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x0000086A,
		0x033, 0x00000025,
		0x03F, 0x0000086D,
		0x033, 0x00000026,
		0x03F, 0x00000870,
		0x033, 0x00000027,
		0x03F, 0x00000891,
		0x033, 0x00000028,
		0x03F, 0x00000894,
		0x033, 0x00000029,
		0x03F, 0x000008B5,
		0x033, 0x0000002A,
		0x03F, 0x000008F5,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042A,
		0x033, 0x00000061,
		0x03F, 0x00000829,
		0x033, 0x00000062,
		0x03F, 0x00000848,
		0x033, 0x00000063,
		0x03F, 0x0000084B,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000CAC,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000080B,
		0x033, 0x00000061,
		0x03F, 0x0000080E,
		0x033, 0x00000062,
		0x03F, 0x00000848,
		0x033, 0x00000063,
		0x03F, 0x00000869,
		0x033, 0x00000064,
		0x03F, 0x000008A9,
		0x033, 0x00000065,
		0x03F, 0x00000CE8,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000CE5,
		0x033, 0x00000066,
		0x03F, 0x00000CE8,
		0x033, 0x00000067,
		0x03F, 0x00000CEB,
		0x033, 0x00000068,
		0x03F, 0x00000CEE,
		0x033, 0x00000069,
		0x03F, 0x00000CF1,
		0x033, 0x0000006A,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C10,
		0x033, 0x00000063,
		0x03F, 0x00000C4A,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000CC9,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x0000086A,
		0x033, 0x00000065,
		0x03F, 0x0000086D,
		0x033, 0x00000066,
		0x03F, 0x00000870,
		0x033, 0x00000067,
		0x03F, 0x00000891,
		0x033, 0x00000068,
		0x03F, 0x00000894,
		0x033, 0x00000069,
		0x03F, 0x000008B5,
		0x033, 0x0000006A,
		0x03F, 0x000008F5,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000CAC,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C0A,
		0x033, 0x000000A1,
		0x03F, 0x00000C0D,
		0x033, 0x000000A2,
		0x03F, 0x00000C2A,
		0x033, 0x000000A3,
		0x03F, 0x00000C2D,
		0x033, 0x000000A4,
		0x03F, 0x00000C6A,
		0x033, 0x000000A5,
		0x03F, 0x00000CE8,
		0x033, 0x000000A6,
		0x03F, 0x00000CEB,
		0x033, 0x000000A7,
		0x03F, 0x00000CEE,
		0x033, 0x000000A8,
		0x03F, 0x00000CF1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF4,
		0x033, 0x000000AA,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000CE5,
		0x033, 0x000000A6,
		0x03F, 0x00000CE8,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000824,
		0x033, 0x000000A1,
		0x03F, 0x00000827,
		0x033, 0x000000A2,
		0x03F, 0x0000082A,
		0x033, 0x000000A3,
		0x03F, 0x0000082D,
		0x033, 0x000000A4,
		0x03F, 0x00000C68,
		0x033, 0x000000A5,
		0x03F, 0x00000C6B,
		0x033, 0x000000A6,
		0x03F, 0x00000CCA,
		0x033, 0x000000A7,
		0x03F, 0x00000CCD,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C08,
		0x033, 0x000000A1,
		0x03F, 0x00000C0B,
		0x033, 0x000000A2,
		0x03F, 0x00000C0E,
		0x033, 0x000000A3,
		0x03F, 0x00000C2B,
		0x033, 0x000000A4,
		0x03F, 0x00000C2E,
		0x033, 0x000000A5,
		0x03F, 0x00000C31,
		0x033, 0x000000A6,
		0x03F, 0x00000CCA,
		0x033, 0x000000A7,
		0x03F, 0x00000CCD,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x0000086A,
		0x033, 0x000000A5,
		0x03F, 0x0000086D,
		0x033, 0x000000A6,
		0x03F, 0x00000870,
		0x033, 0x000000A7,
		0x03F, 0x00000891,
		0x033, 0x000000A8,
		0x03F, 0x00000894,
		0x033, 0x000000A9,
		0x03F, 0x000008B5,
		0x033, 0x000000AA,
		0x03F, 0x000008F5,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000008BB,
		0x033, 0x00000001,
		0x03F, 0x000008BB,
		0x033, 0x00000002,
		0x03F, 0x000008BB,
		0x033, 0x00000003,
		0x03F, 0x000008BB,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000800,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000002,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000008,
		0x033, 0x00000003,
		0x03F, 0x0000000B,
		0x033, 0x00000004,
		0x03F, 0x0000000E,
		0x033, 0x00000005,
		0x03F, 0x0000002B,
		0x033, 0x00000006,
		0x03F, 0x0000002E,
		0x033, 0x00000007,
		0x03F, 0x00000031,
		0x033, 0x00000008,
		0x03F, 0x0000006E,
		0x033, 0x00000009,
		0x03F, 0x00000071,
		0x033, 0x0000000A,
		0x03F, 0x00000074,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000002,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000008,
		0x033, 0x00000003,
		0x03F, 0x0000000B,
		0x033, 0x00000004,
		0x03F, 0x0000000E,
		0x033, 0x00000005,
		0x03F, 0x0000002B,
		0x033, 0x00000006,
		0x03F, 0x0000002E,
		0x033, 0x00000007,
		0x03F, 0x00000031,
		0x033, 0x00000008,
		0x03F, 0x0000006E,
		0x033, 0x00000009,
		0x03F, 0x00000071,
		0x033, 0x0000000A,
		0x03F, 0x00000074,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005144B,
		0x033, 0x00000002,
		0x03F, 0x0005144E,
		0x033, 0x00000003,
		0x03F, 0x00051C69,
		0x033, 0x00000004,
		0x03F, 0x00051C6C,
		0x033, 0x00000005,
		0x03F, 0x00051C6F,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000D0F4F,
	0xA0000000,	0x00000000,
		0x03F, 0x000C0F4F,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,
	0x83000002,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0CE, 0x00094400,
	0xA0000000,	0x00000000,
		0x0CE, 0x00094C00,
	0xB0000000,	0x00000000,
	0x83000002,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00064700,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0CF, 0x00072F00,
	0xA0000000,	0x00000000,
		0x0CF, 0x00064700,
	0xB0000000,	0x00000000,
	0x83000002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000096,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x00000056,
		0x0EF, 0x00000000,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000056,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000096,
		0x033, 0x00000001,
		0x03F, 0x000000D6,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0B0, 0x000FF0FC,
		0x0C4, 0x00081402,
		0x0CC, 0x00082000,

};

void
odm_read_and_config_mp_8822b_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8822b_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8822b_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8822b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822b_radioa(void)
{
		return 112;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8822b_radiob[] = {
		0x000, 0x00030000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000D0F4E,
	0xA0000000,	0x00000000,
		0x03F, 0x000C0F4E,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x000DEFCE,
		0x0EF, 0x00000000,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000FF186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
		0x08E, 0x00064D40,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
	0x8300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040D0,
	0xA0000000,	0x00000000,
		0x03E, 0x000040C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000DFF86,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000DFF86,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C0006,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
	0x8300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000040D0,
	0xA0000000,	0x00000000,
		0x03E, 0x000040C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000002,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0EE, 0x00000002,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000004,
		0x033, 0x00000003,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x00000004,
		0x033, 0x00000005,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000004,
		0x033, 0x00000007,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D3D1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000062,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0xA0000000,	0x00000000,
		0x061, 0x0005D3D0,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A3,
		0x030, 0x000053A3,
		0x030, 0x000063A3,
		0x030, 0x000073A3,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000303,
		0x030, 0x00001303,
		0x030, 0x00002303,
		0x030, 0x00003303,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A4,
		0x030, 0x000014A4,
		0x030, 0x000024A4,
		0x030, 0x000034A4,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x000083A5,
		0x030, 0x000093A5,
		0x030, 0x0000A3A5,
		0x030, 0x0000B3A5,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002F4,
		0x030, 0x000012F4,
		0x030, 0x000022F4,
		0x030, 0x000032F4,
		0x030, 0x00004365,
		0x030, 0x00005365,
		0x030, 0x00006365,
		0x030, 0x00007365,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000382,
		0x030, 0x00001382,
		0x030, 0x00002382,
		0x030, 0x00003382,
		0x030, 0x00004445,
		0x030, 0x00005445,
		0x030, 0x00006445,
		0x030, 0x00007445,
		0x030, 0x00008425,
		0x030, 0x00009425,
		0x030, 0x0000A425,
		0x030, 0x0000B425,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A3,
		0x030, 0x000053A3,
		0x030, 0x000063A3,
		0x030, 0x000073A3,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A3,
		0x030, 0x000014A3,
		0x030, 0x000024A3,
		0x030, 0x000034A3,
		0x030, 0x000044A3,
		0x030, 0x000054A3,
		0x030, 0x000064A3,
		0x030, 0x000074A3,
		0x030, 0x000084A3,
		0x030, 0x000094A3,
		0x030, 0x0000A4A3,
		0x030, 0x0000B4A3,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000443,
		0x030, 0x00001443,
		0x030, 0x00002443,
		0x030, 0x00003443,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000343,
		0x030, 0x00001343,
		0x030, 0x00002343,
		0x030, 0x00003343,
		0x030, 0x00004483,
		0x030, 0x00005483,
		0x030, 0x00006483,
		0x030, 0x00007483,
		0x030, 0x000083A4,
		0x030, 0x000093A4,
		0x030, 0x0000A3A4,
		0x030, 0x0000B3A4,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x00004423,
		0x030, 0x00005423,
		0x030, 0x00006423,
		0x030, 0x00007423,
		0x030, 0x00008324,
		0x030, 0x00009324,
		0x030, 0x0000A324,
		0x030, 0x0000B324,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000303,
		0x030, 0x00001303,
		0x030, 0x00002303,
		0x030, 0x00003303,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000403,
		0x030, 0x00001403,
		0x030, 0x00002403,
		0x030, 0x00003403,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x00008365,
		0x030, 0x00009365,
		0x030, 0x0000A365,
		0x030, 0x0000B365,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A6,
		0x030, 0x000012A6,
		0x030, 0x000022A6,
		0x030, 0x000032A6,
		0x030, 0x000042A6,
		0x030, 0x000052A6,
		0x030, 0x000062A6,
		0x030, 0x000072A6,
		0x030, 0x000082A6,
		0x030, 0x000092A6,
		0x030, 0x0000A2A6,
		0x030, 0x0000B2A6,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000002A1,
		0x030, 0x000012A1,
		0x030, 0x000022A1,
		0x030, 0x000032A1,
		0x030, 0x000042A1,
		0x030, 0x000052A1,
		0x030, 0x000062A1,
		0x030, 0x000072A1,
		0x030, 0x000082A1,
		0x030, 0x000092A1,
		0x030, 0x0000A2A1,
		0x030, 0x0000B2A1,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A1,
		0x030, 0x000014A1,
		0x030, 0x000024A1,
		0x030, 0x000034A1,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A1,
		0x030, 0x000093A1,
		0x030, 0x0000A3A1,
		0x030, 0x0000B3A1,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
	0xA0000000,	0x00000000,
		0x030, 0x000002D0,
		0x030, 0x000012D0,
		0x030, 0x000022D0,
		0x030, 0x000032D0,
		0x030, 0x000042D0,
		0x030, 0x000052D0,
		0x030, 0x000062D0,
		0x030, 0x000072D0,
		0x030, 0x000082D0,
		0x030, 0x000092D0,
		0x030, 0x0000A2D0,
		0x030, 0x0000B2D0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A3,
		0x030, 0x000013A3,
		0x030, 0x000023A3,
		0x030, 0x000033A3,
		0x030, 0x000043A4,
		0x030, 0x000053A4,
		0x030, 0x000063A4,
		0x030, 0x000073A4,
		0x030, 0x000083A3,
		0x030, 0x000093A3,
		0x030, 0x0000A3A3,
		0x030, 0x0000B3A3,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
	0xA0000000,	0x00000000,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001452,
		0x030, 0x00002220,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000660,
		0x030, 0x00001341,
		0x030, 0x00002220,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000767,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000765,
		0x030, 0x00001632,
		0x030, 0x00002451,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000776,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000777,
		0x030, 0x00001442,
		0x030, 0x00002222,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004777,
		0x030, 0x00005777,
		0x030, 0x00006777,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000775,
		0x030, 0x00001222,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xA0000000,	0x00000000,
		0x030, 0x00000764,
		0x030, 0x00001632,
		0x030, 0x00002421,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042C,
		0x033, 0x00000021,
		0x03F, 0x0000082B,
		0x033, 0x00000022,
		0x03F, 0x0000084A,
		0x033, 0x00000023,
		0x03F, 0x0000084D,
		0x033, 0x00000024,
		0x03F, 0x00000C4E,
		0x033, 0x00000025,
		0x03F, 0x00000C6E,
		0x033, 0x00000026,
		0x03F, 0x00000CAD,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000828,
		0x033, 0x00000021,
		0x03F, 0x0000082B,
		0x033, 0x00000022,
		0x03F, 0x00000868,
		0x033, 0x00000023,
		0x03F, 0x00000889,
		0x033, 0x00000024,
		0x03F, 0x000008AA,
		0x033, 0x00000025,
		0x03F, 0x00000CE8,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000CE5,
		0x033, 0x00000026,
		0x03F, 0x00000CE8,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C25,
		0x033, 0x00000021,
		0x03F, 0x00000C28,
		0x033, 0x00000022,
		0x03F, 0x00000C2B,
		0x033, 0x00000023,
		0x03F, 0x00000C68,
		0x033, 0x00000024,
		0x03F, 0x00000C6B,
		0x033, 0x00000025,
		0x03F, 0x00000C6E,
		0x033, 0x00000026,
		0x03F, 0x00000CEB,
		0x033, 0x00000027,
		0x03F, 0x00000CEE,
		0x033, 0x00000028,
		0x03F, 0x00000CF1,
		0x033, 0x00000029,
		0x03F, 0x00000CF4,
		0x033, 0x0000002A,
		0x03F, 0x00000CF7,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000CEA,
		0x033, 0x00000027,
		0x03F, 0x00000CED,
		0x033, 0x00000028,
		0x03F, 0x00000CF0,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000429,
		0x033, 0x00000021,
		0x03F, 0x00000828,
		0x033, 0x00000022,
		0x03F, 0x00000847,
		0x033, 0x00000023,
		0x03F, 0x0000084A,
		0x033, 0x00000024,
		0x03F, 0x00000C4B,
		0x033, 0x00000025,
		0x03F, 0x00000C6C,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CAF,
		0x033, 0x00000028,
		0x03F, 0x00000CD1,
		0x033, 0x00000029,
		0x03F, 0x00000CF3,
		0x033, 0x0000002A,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x0000002E,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000005,
		0x033, 0x00000021,
		0x03F, 0x00000008,
		0x033, 0x00000022,
		0x03F, 0x0000000B,
		0x033, 0x00000023,
		0x03F, 0x0000000E,
		0x033, 0x00000024,
		0x03F, 0x0000002B,
		0x033, 0x00000025,
		0x03F, 0x00000068,
		0x033, 0x00000026,
		0x03F, 0x0000006B,
		0x033, 0x00000027,
		0x03F, 0x0000006E,
		0x033, 0x00000028,
		0x03F, 0x00000071,
		0x033, 0x00000029,
		0x03F, 0x00000074,
		0x033, 0x0000002A,
		0x03F, 0x00000077,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000007,
		0x033, 0x00000021,
		0x03F, 0x0000000A,
		0x033, 0x00000022,
		0x03F, 0x0000000D,
		0x033, 0x00000023,
		0x03F, 0x0000002A,
		0x033, 0x00000024,
		0x03F, 0x0000002D,
		0x033, 0x00000025,
		0x03F, 0x00000030,
		0x033, 0x00000026,
		0x03F, 0x0000006D,
		0x033, 0x00000027,
		0x03F, 0x00000070,
		0x033, 0x00000028,
		0x03F, 0x000000ED,
		0x033, 0x00000029,
		0x03F, 0x000000F0,
		0x033, 0x0000002A,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000C09,
		0x033, 0x00000021,
		0x03F, 0x00000C0C,
		0x033, 0x00000022,
		0x03F, 0x00000C0F,
		0x033, 0x00000023,
		0x03F, 0x00000C2C,
		0x033, 0x00000024,
		0x03F, 0x00000C2F,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000C90,
		0x033, 0x00000028,
		0x03F, 0x00000CD0,
		0x033, 0x00000029,
		0x03F, 0x00000CF2,
		0x033, 0x0000002A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042A,
		0x033, 0x00000061,
		0x03F, 0x00000829,
		0x033, 0x00000062,
		0x03F, 0x00000848,
		0x033, 0x00000063,
		0x03F, 0x0000084B,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000CAC,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000842,
		0x033, 0x00000061,
		0x03F, 0x00000845,
		0x033, 0x00000062,
		0x03F, 0x00000866,
		0x033, 0x00000063,
		0x03F, 0x000008A6,
		0x033, 0x00000064,
		0x03F, 0x000008C8,
		0x033, 0x00000065,
		0x03F, 0x00000CE8,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000CE5,
		0x033, 0x00000066,
		0x03F, 0x00000CE8,
		0x033, 0x00000067,
		0x03F, 0x00000CEB,
		0x033, 0x00000068,
		0x03F, 0x00000CEE,
		0x033, 0x00000069,
		0x03F, 0x00000CF1,
		0x033, 0x0000006A,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C10,
		0x033, 0x00000063,
		0x03F, 0x00000C4A,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000CC9,
		0x033, 0x00000066,
		0x03F, 0x00000CEB,
		0x033, 0x00000067,
		0x03F, 0x00000CEE,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C8A,
		0x033, 0x00000066,
		0x03F, 0x00000CEA,
		0x033, 0x00000067,
		0x03F, 0x00000CED,
		0x033, 0x00000068,
		0x03F, 0x00000CF0,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000429,
		0x033, 0x00000061,
		0x03F, 0x00000828,
		0x033, 0x00000062,
		0x03F, 0x00000847,
		0x033, 0x00000063,
		0x03F, 0x0000084A,
		0x033, 0x00000064,
		0x03F, 0x00000C4B,
		0x033, 0x00000065,
		0x03F, 0x00000C6C,
		0x033, 0x00000066,
		0x03F, 0x00000C8D,
		0x033, 0x00000067,
		0x03F, 0x00000CAF,
		0x033, 0x00000068,
		0x03F, 0x00000CD1,
		0x033, 0x00000069,
		0x03F, 0x00000CF3,
		0x033, 0x0000006A,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x0000002E,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000005,
		0x033, 0x00000061,
		0x03F, 0x00000008,
		0x033, 0x00000062,
		0x03F, 0x0000000B,
		0x033, 0x00000063,
		0x03F, 0x0000000E,
		0x033, 0x00000064,
		0x03F, 0x0000002B,
		0x033, 0x00000065,
		0x03F, 0x00000068,
		0x033, 0x00000066,
		0x03F, 0x0000006B,
		0x033, 0x00000067,
		0x03F, 0x0000006E,
		0x033, 0x00000068,
		0x03F, 0x00000071,
		0x033, 0x00000069,
		0x03F, 0x00000074,
		0x033, 0x0000006A,
		0x03F, 0x00000077,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000007,
		0x033, 0x00000061,
		0x03F, 0x0000000A,
		0x033, 0x00000062,
		0x03F, 0x0000000D,
		0x033, 0x00000063,
		0x03F, 0x0000002A,
		0x033, 0x00000064,
		0x03F, 0x0000002D,
		0x033, 0x00000065,
		0x03F, 0x00000030,
		0x033, 0x00000066,
		0x03F, 0x0000006D,
		0x033, 0x00000067,
		0x03F, 0x00000070,
		0x033, 0x00000068,
		0x03F, 0x000000ED,
		0x033, 0x00000069,
		0x03F, 0x000000F0,
		0x033, 0x0000006A,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000C0A,
		0x033, 0x00000061,
		0x03F, 0x00000C0D,
		0x033, 0x00000062,
		0x03F, 0x00000C2A,
		0x033, 0x00000063,
		0x03F, 0x00000C2D,
		0x033, 0x00000064,
		0x03F, 0x00000C6A,
		0x033, 0x00000065,
		0x03F, 0x00000CAA,
		0x033, 0x00000066,
		0x03F, 0x00000CAD,
		0x033, 0x00000067,
		0x03F, 0x00000CB0,
		0x033, 0x00000068,
		0x03F, 0x00000CF1,
		0x033, 0x00000069,
		0x03F, 0x00000CF4,
		0x033, 0x0000006A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x83000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x93000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x93000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x93000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000CAC,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x93000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000826,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x0000082C,
		0x033, 0x000000A3,
		0x03F, 0x0000082F,
		0x033, 0x000000A4,
		0x03F, 0x0000086C,
		0x033, 0x000000A5,
		0x03F, 0x00000CE8,
		0x033, 0x000000A6,
		0x03F, 0x00000CEB,
		0x033, 0x000000A7,
		0x03F, 0x00000CEE,
		0x033, 0x000000A8,
		0x03F, 0x00000CF1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF4,
		0x033, 0x000000AA,
		0x03F, 0x00000CF7,
	0x93000009,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000a,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000CE5,
		0x033, 0x000000A6,
		0x03F, 0x00000CE8,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
	0x9300000d,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000080A,
		0x033, 0x000000A1,
		0x03F, 0x0000080D,
		0x033, 0x000000A2,
		0x03F, 0x00000810,
		0x033, 0x000000A3,
		0x03F, 0x00000868,
		0x033, 0x000000A4,
		0x03F, 0x00000C68,
		0x033, 0x000000A5,
		0x03F, 0x00000C6B,
		0x033, 0x000000A6,
		0x03F, 0x00000CAB,
		0x033, 0x000000A7,
		0x03F, 0x00000CAE,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000e,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C08,
		0x033, 0x000000A1,
		0x03F, 0x00000C0B,
		0x033, 0x000000A2,
		0x03F, 0x00000C0E,
		0x033, 0x000000A3,
		0x03F, 0x00000C2B,
		0x033, 0x000000A4,
		0x03F, 0x00000C2E,
		0x033, 0x000000A5,
		0x03F, 0x00000C31,
		0x033, 0x000000A6,
		0x03F, 0x00000CAB,
		0x033, 0x000000A7,
		0x03F, 0x00000CAE,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000CEA,
		0x033, 0x000000A7,
		0x03F, 0x00000CED,
		0x033, 0x000000A8,
		0x03F, 0x00000CF0,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000010,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000011,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000429,
		0x033, 0x000000A1,
		0x03F, 0x00000828,
		0x033, 0x000000A2,
		0x03F, 0x00000847,
		0x033, 0x000000A3,
		0x03F, 0x0000084A,
		0x033, 0x000000A4,
		0x03F, 0x00000C4B,
		0x033, 0x000000A5,
		0x03F, 0x00000C6C,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CAF,
		0x033, 0x000000A8,
		0x03F, 0x00000CD1,
		0x033, 0x000000A9,
		0x03F, 0x00000CF3,
		0x033, 0x000000AA,
		0x03F, 0x00000CF6,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x0000002B,
		0x033, 0x000000A5,
		0x03F, 0x0000002E,
		0x033, 0x000000A6,
		0x03F, 0x00000031,
		0x033, 0x000000A7,
		0x03F, 0x00000034,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x000000D1,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000005,
		0x033, 0x000000A1,
		0x03F, 0x00000008,
		0x033, 0x000000A2,
		0x03F, 0x0000000B,
		0x033, 0x000000A3,
		0x03F, 0x0000000E,
		0x033, 0x000000A4,
		0x03F, 0x00000047,
		0x033, 0x000000A5,
		0x03F, 0x0000004A,
		0x033, 0x000000A6,
		0x03F, 0x0000004D,
		0x033, 0x000000A7,
		0x03F, 0x00000050,
		0x033, 0x000000A8,
		0x03F, 0x00000053,
		0x033, 0x000000A9,
		0x03F, 0x00000056,
		0x033, 0x000000AA,
		0x03F, 0x00000094,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000007,
		0x033, 0x000000A1,
		0x03F, 0x0000000A,
		0x033, 0x000000A2,
		0x03F, 0x0000000D,
		0x033, 0x000000A3,
		0x03F, 0x0000002A,
		0x033, 0x000000A4,
		0x03F, 0x0000002D,
		0x033, 0x000000A5,
		0x03F, 0x00000030,
		0x033, 0x000000A6,
		0x03F, 0x0000006D,
		0x033, 0x000000A7,
		0x03F, 0x00000070,
		0x033, 0x000000A8,
		0x03F, 0x000000ED,
		0x033, 0x000000A9,
		0x03F, 0x000000F0,
		0x033, 0x000000AA,
		0x03F, 0x000000F3,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000C09,
		0x033, 0x000000A1,
		0x03F, 0x00000C0C,
		0x033, 0x000000A2,
		0x03F, 0x00000C0F,
		0x033, 0x000000A3,
		0x03F, 0x00000C2C,
		0x033, 0x000000A4,
		0x03F, 0x00000C2F,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000C90,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000004FB,
		0x033, 0x00000001,
		0x03F, 0x000004FB,
		0x033, 0x00000002,
		0x03F, 0x000004FB,
		0x033, 0x00000003,
		0x03F, 0x000004FB,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000800,
	0x83000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x93000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000002,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000008,
		0x033, 0x00000003,
		0x03F, 0x0000000B,
		0x033, 0x00000004,
		0x03F, 0x0000000E,
		0x033, 0x00000005,
		0x03F, 0x0000002B,
		0x033, 0x00000006,
		0x03F, 0x0000002E,
		0x033, 0x00000007,
		0x03F, 0x00000031,
		0x033, 0x00000008,
		0x03F, 0x0000006E,
		0x033, 0x00000009,
		0x03F, 0x00000071,
		0x033, 0x0000000A,
		0x03F, 0x00000074,
	0x93000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x93000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300000b,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x9300000c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005142F,
		0x033, 0x00000002,
		0x03F, 0x00051432,
		0x033, 0x00000003,
		0x03F, 0x00051CA5,
		0x033, 0x00000004,
		0x03F, 0x00051CA8,
		0x033, 0x00000005,
		0x03F, 0x00051CAB,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0x9300000f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005144B,
		0x033, 0x00000002,
		0x03F, 0x00051868,
		0x033, 0x00000003,
		0x03F, 0x0005186B,
		0x033, 0x00000004,
		0x03F, 0x0005186E,
		0x033, 0x00000005,
		0x03F, 0x00051871,
		0x033, 0x00000006,
		0x03F, 0x00051874,
		0x033, 0x00000007,
		0x03F, 0x00051895,
		0x033, 0x00000008,
		0x03F, 0x000518B6,
		0x033, 0x00000009,
		0x03F, 0x000518F6,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0x93000012,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000002,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000008,
		0x033, 0x00000003,
		0x03F, 0x0000000B,
		0x033, 0x00000004,
		0x03F, 0x0000000E,
		0x033, 0x00000005,
		0x03F, 0x0000002B,
		0x033, 0x00000006,
		0x03F, 0x0000002E,
		0x033, 0x00000007,
		0x03F, 0x00000031,
		0x033, 0x00000008,
		0x03F, 0x0000006E,
		0x033, 0x00000009,
		0x03F, 0x00000071,
		0x033, 0x0000000A,
		0x03F, 0x00000074,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
	0xA0000000,	0x00000000,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005142F,
		0x033, 0x00000002,
		0x03F, 0x00051432,
		0x033, 0x00000003,
		0x03F, 0x00051C87,
		0x033, 0x00000004,
		0x03F, 0x00051C8A,
		0x033, 0x00000005,
		0x03F, 0x00051C8D,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
	0xB0000000,	0x00000000,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
	0x8300000c,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000D0F4F,
	0xA0000000,	0x00000000,
		0x03F, 0x000C0F4F,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,

};

void
odm_read_and_config_mp_8822b_radiob(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8822b_radiob) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8822b_radiob;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8822b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822b_radiob(void)
{
		return 112;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8822b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13,
	 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 12,
	 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11,
	 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12,
	 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8822B

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE0
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE0

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type0_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE1
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type1_8822b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type1_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13,
	 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 12,
	 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type1_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type1_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11,
	 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12,
	 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type1_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type1_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type1_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type1_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE1

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type1_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type10.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE10
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type10_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type10_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type10_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type10_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type10_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type10_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type10_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type10_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type10_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type10_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type10_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type10_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type10(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE10

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type10_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type11.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE11
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type11_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type11_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type11_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type11_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type11_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type11_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type11_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type11_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type11_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type11_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type11_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type11_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type11(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE11

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type11_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type12.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE12
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type12_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type12_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type12_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type12_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type12_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type12_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type12_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type12_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type12_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type12_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type12_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type12(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE12

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type12_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type13.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE13
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type13_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type13_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type13_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type13_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type13_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type13_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type13_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type13_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type13_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type13_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type13_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type13_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type13(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE13

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type13_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type14.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE14
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type14_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type14_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type14_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type14_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type14_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type14_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type14_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type14_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type14_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type14_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type14_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type14_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type14(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE14

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type14_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type15.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE15
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type15_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type15_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type15_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type15_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type15_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type15_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type15_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type15_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type15_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type15_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type15_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type15(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE15

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type15_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type16.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE16
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type16_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type16_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type16_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type16_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type16_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type16_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type16_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type16_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type16_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type16_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type16_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type16(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE16

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type16_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type17.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE17
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type17_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type17_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type17_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type17_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type17_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type17_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type17_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type17_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type17_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type17_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type17_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type17_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type17(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE17

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type17_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type18.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE18
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type18_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type18_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type18_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type18_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type18_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type18_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type18_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type18_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type18_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type18_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type18_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type18_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type18(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE18

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type18_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE2
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type2_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type2_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type2_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type2_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type2_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type2_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type2_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type2_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE2

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type2_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type3_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE3_TYPE5
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type3_type5_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type3_type5_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type3_type5_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type3_type5_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type3_type5_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type3_type5_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type3_type5_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type3_type5_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_type5_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_type5_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_type5_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type3_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE3_TYPE5

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type3_type5_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE4
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type4_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type4_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type4_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12,
	 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 20, 21, 22},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type4_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13,
	 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 23},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type4_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type4_8822b[]    = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type4_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type4_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8822b[] = {
	0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE4

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type4_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE6
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type6_8822b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 12, 13,
	 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type6_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13,
	 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13,
	 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type6_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 12,
	 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11,
	 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type6_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 2, 3, 4, 4, 5, 7, 7, 8, 9, 10, 11, 11, 12, 13,
	 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type6_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type6_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type6_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type6_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE6

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type6_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type7.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE7
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type7_8822b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 12, 13,
	 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type7_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13,
	 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13,
	 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type7_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 12,
	 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 17, 17, 17},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11,
	 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type7_8822b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 19, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 2, 3, 4, 4, 5, 7, 7, 8, 9, 10, 11, 11, 12, 13,
	 13, 14, 15, 16, 17, 18, 18, 19, 19, 20, 20, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 16, 17, 17, 18, 19, 19, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type7_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type7_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type7_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type7_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type7_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type7_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type7_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type7_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type7(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE7

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type7_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type8.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE8
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type8_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type8_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type8_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type8_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type8_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type8_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type8_8822b[]    = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type8_8822b[]    = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8822b[] = {
	0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8822b[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type8(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE8

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type8_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type9.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE9
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type9_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type9_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type9_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9,
	 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type9_8822b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 13, 13, 14, 14, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9,
	 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type9_8822b[]    = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type9_8822b[]    = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type9_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type9_8822b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type9_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type9_8822b[] = {
	0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type9_8822b[] = {
	0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13,
	 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type9_8822b[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
#endif

void
odm_read_and_config_mp_8822b_txpowertrack_type9(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE9

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type9_8822b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B
const char *array_mp_8822b_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt(struct dm_struct *dm)
{
#ifdef CONFIG_8822B

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type12.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE12
const char *array_mp_8822b_txpwr_lmt_type12[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type12(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE12

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type12) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type12;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type12) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type12;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type15.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE15
const char *array_mp_8822b_txpwr_lmt_type15[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type15(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE15

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type15) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type15;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type15) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type15;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type16.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE16
const char *array_mp_8822b_txpwr_lmt_type16[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type16(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE16

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type16) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type16;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type16) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type16;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type17.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE17
const char *array_mp_8822b_txpwr_lmt_type17[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type17(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE17

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type17) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type17;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type17) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type17;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type18.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE18
const char *array_mp_8822b_txpwr_lmt_type18[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "36",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "36",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "36",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "36",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "36",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "38",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "36",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "34",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "36",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "36",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "38",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "38",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "38",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "38",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "38",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "38",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "34",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "32",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "38",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "38",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "38",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "38",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "38",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "38",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "38",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "38",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "38",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "32",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "38",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "38",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "38",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "38",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "38",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "34",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "36",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "36",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "36",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "36",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "36",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "36",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "34",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "32",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "36",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "38",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "38",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "38",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "38",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "38",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "38",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "38",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "36",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "32",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "38",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "38",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "38",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "38",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "38",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "28",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "36",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "36",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "30",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "30",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "36",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "36",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "36",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "36",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "36",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "26",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "36",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "36",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "28",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "28",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "36",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "36",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "36",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "36",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "36",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "36",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type18(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE18

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type18) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type18;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type18) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type18;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE2
const char *array_mp_8822b_txpwr_lmt_type2[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "36",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "36",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "38",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "38",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "38",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "38",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "38",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "38",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "34",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "32",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "38",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "38",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "38",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "38",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "38",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "38",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "38",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "38",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "38",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "32",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "38",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "38",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "38",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "38",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "38",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "34",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "36",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "36",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "36",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "36",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "36",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "36",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "34",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "32",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "36",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "38",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "38",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "38",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "38",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "38",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "38",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "38",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "36",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "32",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "38",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "38",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "38",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "38",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "38",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "28",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "36",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "36",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "30",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "30",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "36",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "36",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "36",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "36",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "36",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "26",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "36",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "36",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "28",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "28",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "36",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "36",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "36",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "36",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "36",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "36",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE2

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type2) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type2;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type2) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type2;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE3
const char *array_mp_8822b_txpwr_lmt_type3[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE3

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type3) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type3;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type3) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type3;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE4
const char *array_mp_8822b_txpwr_lmt_type4[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "38",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "36",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "36",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "36",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "38",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "38",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "36",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "38",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "36",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "36",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "38",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "36",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "34",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "32",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "36",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "34",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "36",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"FCC", "5G", "20M", "HT", "1T", "40", "38",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"FCC", "5G", "20M", "HT", "1T", "44", "38",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"FCC", "5G", "20M", "HT", "1T", "48", "38",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"FCC", "5G", "20M", "HT", "1T", "52", "38",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"FCC", "5G", "20M", "HT", "1T", "56", "38",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"FCC", "5G", "20M", "HT", "1T", "60", "38",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"FCC", "5G", "20M", "HT", "1T", "64", "34",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"FCC", "5G", "20M", "HT", "1T", "100", "32",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "38",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "38",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "38",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "38",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "38",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "38",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "38",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "38",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "38",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "32",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "38",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "38",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "38",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "38",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "38",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "34",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"FCC", "5G", "20M", "HT", "2T", "40", "36",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"FCC", "5G", "20M", "HT", "2T", "44", "36",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"FCC", "5G", "20M", "HT", "2T", "48", "36",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"FCC", "5G", "20M", "HT", "2T", "52", "36",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"FCC", "5G", "20M", "HT", "2T", "56", "36",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"FCC", "5G", "20M", "HT", "2T", "60", "36",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"FCC", "5G", "20M", "HT", "2T", "64", "34",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"FCC", "5G", "20M", "HT", "2T", "100", "32",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "36",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "38",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "38",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "38",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "38",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "38",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "38",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "38",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "36",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "32",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "38",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "38",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "38",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "38",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "38",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "28",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"FCC", "5G", "40M", "HT", "1T", "46", "36",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "36",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "30",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"FCC", "5G", "40M", "HT", "1T", "102", "30",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "36",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "36",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "36",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "36",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "36",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "26",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"FCC", "5G", "40M", "HT", "2T", "46", "36",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"FCC", "5G", "40M", "HT", "2T", "54", "36",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"FCC", "5G", "40M", "HT", "2T", "62", "28",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"FCC", "5G", "40M", "HT", "2T", "102", "28",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "36",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "36",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "36",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "36",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "36",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "36",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"FCC", "5G", "80M", "VHT", "2T", "58", "24",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"FCC", "5G", "80M", "VHT", "2T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "138", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "36",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE4

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type4) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type4;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type4) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type4;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txpwr_lmt_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8822B_TYPE5
const char *array_mp_8822b_txpwr_lmt_type5[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "01", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "01", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "01", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "01", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "02", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "02", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "03", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "03", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "04", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "04", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "05", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "05", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "06", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "06", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "07", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "07", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "08", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "08", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "09", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "09", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "10", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "10", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "11", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "11", "32",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "30",
	"IC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"KCC", "2.4G", "20M", "CCK", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "12", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "12", "26",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "28",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "28",
	"IC", "2.4G", "20M", "CCK", "1T", "13", "20",
	"KCC", "2.4G", "20M", "CCK", "1T", "13", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "13", "28",
	"CHILE", "2.4G", "20M", "CCK", "1T", "13", "20",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "13", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"IC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"KCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "CCK", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "CCK", "1T", "14", "63",
	"UKRAINE", "2.4G", "20M", "CCK", "1T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"KCC", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "01", "26",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"KCC", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "11", "28",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"KCC", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "12", "22",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"KCC", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"IC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"KCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"UKRAINE", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"IC", "2.4G", "20M", "HT", "1T", "01", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "01", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "01", "26",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"IC", "2.4G", "20M", "HT", "1T", "02", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "02", "30",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"IC", "2.4G", "20M", "HT", "1T", "03", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "03", "32",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"IC", "2.4G", "20M", "HT", "1T", "04", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "04", "34",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"IC", "2.4G", "20M", "HT", "1T", "05", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "05", "34",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"IC", "2.4G", "20M", "HT", "1T", "06", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "06", "34",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"IC", "2.4G", "20M", "HT", "1T", "07", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "07", "34",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"IC", "2.4G", "20M", "HT", "1T", "08", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "08", "34",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"IC", "2.4G", "20M", "HT", "1T", "09", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "09", "32",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"IC", "2.4G", "20M", "HT", "1T", "10", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "10", "30",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"IC", "2.4G", "20M", "HT", "1T", "11", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "11", "26",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"IC", "2.4G", "20M", "HT", "1T", "12", "20",
	"KCC", "2.4G", "20M", "HT", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "12", "20",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"IC", "2.4G", "20M", "HT", "1T", "13", "14",
	"KCC", "2.4G", "20M", "HT", "1T", "13", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "13", "14",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"IC", "2.4G", "20M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "HT", "1T", "14", "63",
	"UKRAINE", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"IC", "2.4G", "20M", "HT", "2T", "01", "26",
	"KCC", "2.4G", "20M", "HT", "2T", "01", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "01", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "01", "26",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "01", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"IC", "2.4G", "20M", "HT", "2T", "02", "28",
	"KCC", "2.4G", "20M", "HT", "2T", "02", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "02", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "02", "28",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "02", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"IC", "2.4G", "20M", "HT", "2T", "03", "30",
	"KCC", "2.4G", "20M", "HT", "2T", "03", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "03", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "03", "30",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "03", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"IC", "2.4G", "20M", "HT", "2T", "04", "30",
	"KCC", "2.4G", "20M", "HT", "2T", "04", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "04", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "04", "30",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "04", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"IC", "2.4G", "20M", "HT", "2T", "05", "32",
	"KCC", "2.4G", "20M", "HT", "2T", "05", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "05", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "05", "32",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "05", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"IC", "2.4G", "20M", "HT", "2T", "06", "32",
	"KCC", "2.4G", "20M", "HT", "2T", "06", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "06", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "06", "32",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "06", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "32",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"IC", "2.4G", "20M", "HT", "2T", "07", "32",
	"KCC", "2.4G", "20M", "HT", "2T", "07", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "07", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "07", "32",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "07", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"IC", "2.4G", "20M", "HT", "2T", "08", "30",
	"KCC", "2.4G", "20M", "HT", "2T", "08", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "08", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "08", "30",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "08", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"IC", "2.4G", "20M", "HT", "2T", "09", "30",
	"KCC", "2.4G", "20M", "HT", "2T", "09", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "09", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "09", "30",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "09", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"IC", "2.4G", "20M", "HT", "2T", "10", "28",
	"KCC", "2.4G", "20M", "HT", "2T", "10", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "10", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "10", "28",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "10", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"IC", "2.4G", "20M", "HT", "2T", "11", "26",
	"KCC", "2.4G", "20M", "HT", "2T", "11", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "11", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "11", "26",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "11", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"IC", "2.4G", "20M", "HT", "2T", "12", "20",
	"KCC", "2.4G", "20M", "HT", "2T", "12", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "12", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "12", "20",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "12", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "18",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"IC", "2.4G", "20M", "HT", "2T", "13", "14",
	"KCC", "2.4G", "20M", "HT", "2T", "13", "34",
	"ACMA", "2.4G", "20M", "HT", "2T", "13", "18",
	"CHILE", "2.4G", "20M", "HT", "2T", "13", "14",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "13", "18",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"IC", "2.4G", "20M", "HT", "2T", "14", "63",
	"KCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ACMA", "2.4G", "20M", "HT", "2T", "14", "63",
	"CHILE", "2.4G", "20M", "HT", "2T", "14", "63",
	"UKRAINE", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"IC", "2.4G", "40M", "HT", "1T", "01", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "01", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "01", "63",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"IC", "2.4G", "40M", "HT", "1T", "02", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "02", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "02", "63",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "34",
	"IC", "2.4G", "40M", "HT", "1T", "03", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "03", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "03", "26",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "34",
	"IC", "2.4G", "40M", "HT", "1T", "04", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "04", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "04", "26",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "34",
	"IC", "2.4G", "40M", "HT", "1T", "05", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "05", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "05", "30",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "32",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "34",
	"IC", "2.4G", "40M", "HT", "1T", "06", "32",
	"KCC", "2.4G", "40M", "HT", "1T", "06", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "06", "32",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "34",
	"IC", "2.4G", "40M", "HT", "1T", "07", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "07", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "07", "30",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "34",
	"IC", "2.4G", "40M", "HT", "1T", "08", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "08", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "08", "26",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "34",
	"IC", "2.4G", "40M", "HT", "1T", "09", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "09", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "09", "26",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "34",
	"IC", "2.4G", "40M", "HT", "1T", "10", "20",
	"KCC", "2.4G", "40M", "HT", "1T", "10", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "10", "20",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "34",
	"IC", "2.4G", "40M", "HT", "1T", "11", "14",
	"KCC", "2.4G", "40M", "HT", "1T", "11", "34",
	"ACMA", "2.4G", "40M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "11", "14",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"IC", "2.4G", "40M", "HT", "1T", "12", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "12", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "12", "63",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"IC", "2.4G", "40M", "HT", "1T", "13", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "13", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "13", "63",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"IC", "2.4G", "40M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "14", "63",
	"UKRAINE", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"IC", "2.4G", "40M", "HT", "2T", "01", "63",
	"KCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ACMA", "2.4G", "40M", "HT", "2T", "01", "63",
	"CHILE", "2.4G", "40M", "HT", "2T", "01", "63",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"IC", "2.4G", "40M", "HT", "2T", "02", "63",
	"KCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ACMA", "2.4G", "40M", "HT", "2T", "02", "63",
	"CHILE", "2.4G", "40M", "HT", "2T", "02", "63",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"IC", "2.4G", "40M", "HT", "2T", "03", "24",
	"KCC", "2.4G", "40M", "HT", "2T", "03", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "03", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "03", "24",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "03", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"IC", "2.4G", "40M", "HT", "2T", "04", "24",
	"KCC", "2.4G", "40M", "HT", "2T", "04", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "04", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "04", "24",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "04", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"IC", "2.4G", "40M", "HT", "2T", "05", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "05", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "05", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "05", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "05", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"IC", "2.4G", "40M", "HT", "2T", "06", "28",
	"KCC", "2.4G", "40M", "HT", "2T", "06", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "06", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "06", "28",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "06", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"IC", "2.4G", "40M", "HT", "2T", "07", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "07", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "07", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "07", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "07", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"IC", "2.4G", "40M", "HT", "2T", "08", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "08", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "08", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "08", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "08", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"IC", "2.4G", "40M", "HT", "2T", "09", "26",
	"KCC", "2.4G", "40M", "HT", "2T", "09", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "09", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "09", "26",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "09", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "20",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"IC", "2.4G", "40M", "HT", "2T", "10", "20",
	"KCC", "2.4G", "40M", "HT", "2T", "10", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "10", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "10", "20",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "10", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "14",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "18",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"IC", "2.4G", "40M", "HT", "2T", "11", "14",
	"KCC", "2.4G", "40M", "HT", "2T", "11", "34",
	"ACMA", "2.4G", "40M", "HT", "2T", "11", "18",
	"CHILE", "2.4G", "40M", "HT", "2T", "11", "14",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "11", "18",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"IC", "2.4G", "40M", "HT", "2T", "12", "63",
	"KCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ACMA", "2.4G", "40M", "HT", "2T", "12", "63",
	"CHILE", "2.4G", "40M", "HT", "2T", "12", "63",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"IC", "2.4G", "40M", "HT", "2T", "13", "63",
	"KCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ACMA", "2.4G", "40M", "HT", "2T", "13", "63",
	"CHILE", "2.4G", "40M", "HT", "2T", "13", "63",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"IC", "2.4G", "40M", "HT", "2T", "14", "63",
	"KCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ACMA", "2.4G", "40M", "HT", "2T", "14", "63",
	"CHILE", "2.4G", "40M", "HT", "2T", "14", "63",
	"UKRAINE", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "30",
	"IC", "5G", "20M", "OFDM", "1T", "36", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "36", "18",
	"ACMA", "5G", "20M", "OFDM", "1T", "36", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "36", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "36", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "30",
	"IC", "5G", "20M", "OFDM", "1T", "40", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "40", "24",
	"ACMA", "5G", "20M", "OFDM", "1T", "40", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "40", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "40", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "30",
	"IC", "5G", "20M", "OFDM", "1T", "44", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "44", "24",
	"ACMA", "5G", "20M", "OFDM", "1T", "44", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "44", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "44", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "30",
	"IC", "5G", "20M", "OFDM", "1T", "48", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "48", "18",
	"ACMA", "5G", "20M", "OFDM", "1T", "48", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "48", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "48", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "28",
	"IC", "5G", "20M", "OFDM", "1T", "52", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "52", "10",
	"ACMA", "5G", "20M", "OFDM", "1T", "52", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "52", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "52", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "28",
	"IC", "5G", "20M", "OFDM", "1T", "56", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "56", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "56", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "56", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "56", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "28",
	"IC", "5G", "20M", "OFDM", "1T", "60", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "60", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "60", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "60", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "60", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "28",
	"IC", "5G", "20M", "OFDM", "1T", "64", "28",
	"KCC", "5G", "20M", "OFDM", "1T", "64", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "64", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "64", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "64", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "26",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"IC", "5G", "20M", "OFDM", "1T", "100", "26",
	"KCC", "5G", "20M", "OFDM", "1T", "100", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "100", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "100", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "100", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"IC", "5G", "20M", "OFDM", "1T", "104", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "104", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "104", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "104", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "104", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"IC", "5G", "20M", "OFDM", "1T", "108", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "108", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "108", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "108", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "108", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"IC", "5G", "20M", "OFDM", "1T", "112", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "112", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "112", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "112", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "112", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"IC", "5G", "20M", "OFDM", "1T", "116", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "116", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "116", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "116", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "116", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"IC", "5G", "20M", "OFDM", "1T", "120", "-63",
	"KCC", "5G", "20M", "OFDM", "1T", "120", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "120", "-63",
	"CHILE", "5G", "20M", "OFDM", "1T", "120", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "120", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"IC", "5G", "20M", "OFDM", "1T", "124", "-63",
	"KCC", "5G", "20M", "OFDM", "1T", "124", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "124", "-63",
	"CHILE", "5G", "20M", "OFDM", "1T", "124", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "124", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"IC", "5G", "20M", "OFDM", "1T", "128", "-63",
	"KCC", "5G", "20M", "OFDM", "1T", "128", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "128", "-63",
	"CHILE", "5G", "20M", "OFDM", "1T", "128", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "128", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"IC", "5G", "20M", "OFDM", "1T", "132", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "132", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "132", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "132", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "132", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"IC", "5G", "20M", "OFDM", "1T", "136", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "136", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "136", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "136", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "136", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"IC", "5G", "20M", "OFDM", "1T", "140", "28",
	"KCC", "5G", "20M", "OFDM", "1T", "140", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "140", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "140", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "140", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"IC", "5G", "20M", "OFDM", "1T", "144", "28",
	"KCC", "5G", "20M", "OFDM", "1T", "144", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "144", "-63",
	"CHILE", "5G", "20M", "OFDM", "1T", "144", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"IC", "5G", "20M", "OFDM", "1T", "149", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "149", "26",
	"ACMA", "5G", "20M", "OFDM", "1T", "149", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "149", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "149", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"IC", "5G", "20M", "OFDM", "1T", "153", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "153", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "153", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "153", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "153", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"IC", "5G", "20M", "OFDM", "1T", "157", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "157", "32",
	"ACMA", "5G", "20M", "OFDM", "1T", "157", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "157", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "157", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"IC", "5G", "20M", "OFDM", "1T", "161", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "161", "30",
	"ACMA", "5G", "20M", "OFDM", "1T", "161", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "161", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "161", "27",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"IC", "5G", "20M", "OFDM", "1T", "165", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "165", "-63",
	"ACMA", "5G", "20M", "OFDM", "1T", "165", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "165", "30",
	"UKRAINE", "5G", "20M", "OFDM", "1T", "165", "27",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "28",
	"IC", "5G", "20M", "HT", "1T", "36", "30",
	"KCC", "5G", "20M", "HT", "1T", "36", "18",
	"ACMA", "5G", "20M", "HT", "1T", "36", "32",
	"CHILE", "5G", "20M", "HT", "1T", "36", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "36", "27",
	"FCC", "5G", "20M", "HT", "1T", "40", "32",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "28",
	"IC", "5G", "20M", "HT", "1T", "40", "30",
	"KCC", "5G", "20M", "HT", "1T", "40", "24",
	"ACMA", "5G", "20M", "HT", "1T", "40", "32",
	"CHILE", "5G", "20M", "HT", "1T", "40", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "40", "27",
	"FCC", "5G", "20M", "HT", "1T", "44", "32",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "28",
	"IC", "5G", "20M", "HT", "1T", "44", "30",
	"KCC", "5G", "20M", "HT", "1T", "44", "24",
	"ACMA", "5G", "20M", "HT", "1T", "44", "32",
	"CHILE", "5G", "20M", "HT", "1T", "44", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "44", "27",
	"FCC", "5G", "20M", "HT", "1T", "48", "32",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "28",
	"IC", "5G", "20M", "HT", "1T", "48", "30",
	"KCC", "5G", "20M", "HT", "1T", "48", "18",
	"ACMA", "5G", "20M", "HT", "1T", "48", "32",
	"CHILE", "5G", "20M", "HT", "1T", "48", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "48", "27",
	"FCC", "5G", "20M", "HT", "1T", "52", "32",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "28",
	"IC", "5G", "20M", "HT", "1T", "52", "32",
	"KCC", "5G", "20M", "HT", "1T", "52", "4",
	"ACMA", "5G", "20M", "HT", "1T", "52", "32",
	"CHILE", "5G", "20M", "HT", "1T", "52", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "52", "27",
	"FCC", "5G", "20M", "HT", "1T", "56", "32",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "28",
	"IC", "5G", "20M", "HT", "1T", "56", "32",
	"KCC", "5G", "20M", "HT", "1T", "56", "32",
	"ACMA", "5G", "20M", "HT", "1T", "56", "32",
	"CHILE", "5G", "20M", "HT", "1T", "56", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "56", "27",
	"FCC", "5G", "20M", "HT", "1T", "60", "32",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "28",
	"IC", "5G", "20M", "HT", "1T", "60", "32",
	"KCC", "5G", "20M", "HT", "1T", "60", "32",
	"ACMA", "5G", "20M", "HT", "1T", "60", "32",
	"CHILE", "5G", "20M", "HT", "1T", "60", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "60", "27",
	"FCC", "5G", "20M", "HT", "1T", "64", "28",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "28",
	"IC", "5G", "20M", "HT", "1T", "64", "28",
	"KCC", "5G", "20M", "HT", "1T", "64", "32",
	"ACMA", "5G", "20M", "HT", "1T", "64", "32",
	"CHILE", "5G", "20M", "HT", "1T", "64", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "64", "27",
	"FCC", "5G", "20M", "HT", "1T", "100", "26",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"IC", "5G", "20M", "HT", "1T", "100", "26",
	"KCC", "5G", "20M", "HT", "1T", "100", "32",
	"ACMA", "5G", "20M", "HT", "1T", "100", "32",
	"CHILE", "5G", "20M", "HT", "1T", "100", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "100", "27",
	"FCC", "5G", "20M", "HT", "1T", "104", "32",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"IC", "5G", "20M", "HT", "1T", "104", "32",
	"KCC", "5G", "20M", "HT", "1T", "104", "32",
	"ACMA", "5G", "20M", "HT", "1T", "104", "32",
	"CHILE", "5G", "20M", "HT", "1T", "104", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "104", "27",
	"FCC", "5G", "20M", "HT", "1T", "108", "32",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"IC", "5G", "20M", "HT", "1T", "108", "32",
	"KCC", "5G", "20M", "HT", "1T", "108", "32",
	"ACMA", "5G", "20M", "HT", "1T", "108", "32",
	"CHILE", "5G", "20M", "HT", "1T", "108", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "108", "27",
	"FCC", "5G", "20M", "HT", "1T", "112", "32",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"IC", "5G", "20M", "HT", "1T", "112", "32",
	"KCC", "5G", "20M", "HT", "1T", "112", "32",
	"ACMA", "5G", "20M", "HT", "1T", "112", "32",
	"CHILE", "5G", "20M", "HT", "1T", "112", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "112", "27",
	"FCC", "5G", "20M", "HT", "1T", "116", "32",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"IC", "5G", "20M", "HT", "1T", "116", "32",
	"KCC", "5G", "20M", "HT", "1T", "116", "32",
	"ACMA", "5G", "20M", "HT", "1T", "116", "32",
	"CHILE", "5G", "20M", "HT", "1T", "116", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "116", "27",
	"FCC", "5G", "20M", "HT", "1T", "120", "32",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"IC", "5G", "20M", "HT", "1T", "120", "-63",
	"KCC", "5G", "20M", "HT", "1T", "120", "32",
	"ACMA", "5G", "20M", "HT", "1T", "120", "-63",
	"CHILE", "5G", "20M", "HT", "1T", "120", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "120", "27",
	"FCC", "5G", "20M", "HT", "1T", "124", "32",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"IC", "5G", "20M", "HT", "1T", "124", "-63",
	"KCC", "5G", "20M", "HT", "1T", "124", "32",
	"ACMA", "5G", "20M", "HT", "1T", "124", "-63",
	"CHILE", "5G", "20M", "HT", "1T", "124", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "124", "27",
	"FCC", "5G", "20M", "HT", "1T", "128", "32",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"IC", "5G", "20M", "HT", "1T", "128", "-63",
	"KCC", "5G", "20M", "HT", "1T", "128", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "128", "-63",
	"CHILE", "5G", "20M", "HT", "1T", "128", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "128", "27",
	"FCC", "5G", "20M", "HT", "1T", "132", "32",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"IC", "5G", "20M", "HT", "1T", "132", "32",
	"KCC", "5G", "20M", "HT", "1T", "132", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "132", "32",
	"CHILE", "5G", "20M", "HT", "1T", "132", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "132", "27",
	"FCC", "5G", "20M", "HT", "1T", "136", "32",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"IC", "5G", "20M", "HT", "1T", "136", "32",
	"KCC", "5G", "20M", "HT", "1T", "136", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "136", "32",
	"CHILE", "5G", "20M", "HT", "1T", "136", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "136", "63",
	"FCC", "5G", "20M", "HT", "1T", "140", "26",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"IC", "5G", "20M", "HT", "1T", "140", "26",
	"KCC", "5G", "20M", "HT", "1T", "140", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "140", "32",
	"CHILE", "5G", "20M", "HT", "1T", "140", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "140", "63",
	"FCC", "5G", "20M", "HT", "1T", "144", "26",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"IC", "5G", "20M", "HT", "1T", "144", "26",
	"KCC", "5G", "20M", "HT", "1T", "144", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "144", "-63",
	"CHILE", "5G", "20M", "HT", "1T", "144", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "32",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"IC", "5G", "20M", "HT", "1T", "149", "32",
	"KCC", "5G", "20M", "HT", "1T", "149", "24",
	"ACMA", "5G", "20M", "HT", "1T", "149", "32",
	"CHILE", "5G", "20M", "HT", "1T", "149", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "149", "27",
	"FCC", "5G", "20M", "HT", "1T", "153", "32",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"IC", "5G", "20M", "HT", "1T", "153", "32",
	"KCC", "5G", "20M", "HT", "1T", "153", "32",
	"ACMA", "5G", "20M", "HT", "1T", "153", "32",
	"CHILE", "5G", "20M", "HT", "1T", "153", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "153", "27",
	"FCC", "5G", "20M", "HT", "1T", "157", "32",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"IC", "5G", "20M", "HT", "1T", "157", "32",
	"KCC", "5G", "20M", "HT", "1T", "157", "32",
	"ACMA", "5G", "20M", "HT", "1T", "157", "32",
	"CHILE", "5G", "20M", "HT", "1T", "157", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "157", "27",
	"FCC", "5G", "20M", "HT", "1T", "161", "32",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"IC", "5G", "20M", "HT", "1T", "161", "32",
	"KCC", "5G", "20M", "HT", "1T", "161", "30",
	"ACMA", "5G", "20M", "HT", "1T", "161", "32",
	"CHILE", "5G", "20M", "HT", "1T", "161", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "161", "27",
	"FCC", "5G", "20M", "HT", "1T", "165", "32",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"IC", "5G", "20M", "HT", "1T", "165", "32",
	"KCC", "5G", "20M", "HT", "1T", "165", "-63",
	"ACMA", "5G", "20M", "HT", "1T", "165", "32",
	"CHILE", "5G", "20M", "HT", "1T", "165", "30",
	"UKRAINE", "5G", "20M", "HT", "1T", "165", "27",
	"FCC", "5G", "20M", "HT", "2T", "36", "28",
	"ETSI", "5G", "20M", "HT", "2T", "36", "20",
	"MKK", "5G", "20M", "HT", "2T", "36", "22",
	"IC", "5G", "20M", "HT", "2T", "36", "18",
	"KCC", "5G", "20M", "HT", "2T", "36", "18",
	"ACMA", "5G", "20M", "HT", "2T", "36", "20",
	"CHILE", "5G", "20M", "HT", "2T", "36", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "36", "15",
	"FCC", "5G", "20M", "HT", "2T", "40", "30",
	"ETSI", "5G", "20M", "HT", "2T", "40", "20",
	"MKK", "5G", "20M", "HT", "2T", "40", "22",
	"IC", "5G", "20M", "HT", "2T", "40", "18",
	"KCC", "5G", "20M", "HT", "2T", "40", "18",
	"ACMA", "5G", "20M", "HT", "2T", "40", "20",
	"CHILE", "5G", "20M", "HT", "2T", "40", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "40", "15",
	"FCC", "5G", "20M", "HT", "2T", "44", "30",
	"ETSI", "5G", "20M", "HT", "2T", "44", "20",
	"MKK", "5G", "20M", "HT", "2T", "44", "22",
	"IC", "5G", "20M", "HT", "2T", "44", "18",
	"KCC", "5G", "20M", "HT", "2T", "44", "18",
	"ACMA", "5G", "20M", "HT", "2T", "44", "20",
	"CHILE", "5G", "20M", "HT", "2T", "44", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "44", "15",
	"FCC", "5G", "20M", "HT", "2T", "48", "30",
	"ETSI", "5G", "20M", "HT", "2T", "48", "20",
	"MKK", "5G", "20M", "HT", "2T", "48", "22",
	"IC", "5G", "20M", "HT", "2T", "48", "18",
	"KCC", "5G", "20M", "HT", "2T", "48", "18",
	"ACMA", "5G", "20M", "HT", "2T", "48", "20",
	"CHILE", "5G", "20M", "HT", "2T", "48", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "48", "15",
	"FCC", "5G", "20M", "HT", "2T", "52", "30",
	"ETSI", "5G", "20M", "HT", "2T", "52", "20",
	"MKK", "5G", "20M", "HT", "2T", "52", "22",
	"IC", "5G", "20M", "HT", "2T", "52", "20",
	"KCC", "5G", "20M", "HT", "2T", "52", "4",
	"ACMA", "5G", "20M", "HT", "2T", "52", "20",
	"CHILE", "5G", "20M", "HT", "2T", "52", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "52", "15",
	"FCC", "5G", "20M", "HT", "2T", "56", "30",
	"ETSI", "5G", "20M", "HT", "2T", "56", "20",
	"MKK", "5G", "20M", "HT", "2T", "56", "22",
	"IC", "5G", "20M", "HT", "2T", "56", "20",
	"KCC", "5G", "20M", "HT", "2T", "56", "32",
	"ACMA", "5G", "20M", "HT", "2T", "56", "20",
	"CHILE", "5G", "20M", "HT", "2T", "56", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "56", "15",
	"FCC", "5G", "20M", "HT", "2T", "60", "30",
	"ETSI", "5G", "20M", "HT", "2T", "60", "20",
	"MKK", "5G", "20M", "HT", "2T", "60", "22",
	"IC", "5G", "20M", "HT", "2T", "60", "20",
	"KCC", "5G", "20M", "HT", "2T", "60", "32",
	"ACMA", "5G", "20M", "HT", "2T", "60", "20",
	"CHILE", "5G", "20M", "HT", "2T", "60", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "60", "15",
	"FCC", "5G", "20M", "HT", "2T", "64", "28",
	"ETSI", "5G", "20M", "HT", "2T", "64", "20",
	"MKK", "5G", "20M", "HT", "2T", "64", "22",
	"IC", "5G", "20M", "HT", "2T", "64", "20",
	"KCC", "5G", "20M", "HT", "2T", "64", "32",
	"ACMA", "5G", "20M", "HT", "2T", "64", "20",
	"CHILE", "5G", "20M", "HT", "2T", "64", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "64", "15",
	"FCC", "5G", "20M", "HT", "2T", "100", "26",
	"ETSI", "5G", "20M", "HT", "2T", "100", "20",
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"IC", "5G", "20M", "HT", "2T", "100", "26",
	"KCC", "5G", "20M", "HT", "2T", "100", "32",
	"ACMA", "5G", "20M", "HT", "2T", "100", "20",
	"CHILE", "5G", "20M", "HT", "2T", "100", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "100", "15",
	"FCC", "5G", "20M", "HT", "2T", "104", "30",
	"ETSI", "5G", "20M", "HT", "2T", "104", "20",
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"IC", "5G", "20M", "HT", "2T", "104", "30",
	"KCC", "5G", "20M", "HT", "2T", "104", "32",
	"ACMA", "5G", "20M", "HT", "2T", "104", "20",
	"CHILE", "5G", "20M", "HT", "2T", "104", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "104", "15",
	"FCC", "5G", "20M", "HT", "2T", "108", "32",
	"ETSI", "5G", "20M", "HT", "2T", "108", "20",
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"IC", "5G", "20M", "HT", "2T", "108", "32",
	"KCC", "5G", "20M", "HT", "2T", "108", "32",
	"ACMA", "5G", "20M", "HT", "2T", "108", "20",
	"CHILE", "5G", "20M", "HT", "2T", "108", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "108", "15",
	"FCC", "5G", "20M", "HT", "2T", "112", "32",
	"ETSI", "5G", "20M", "HT", "2T", "112", "20",
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"IC", "5G", "20M", "HT", "2T", "112", "32",
	"KCC", "5G", "20M", "HT", "2T", "112", "32",
	"ACMA", "5G", "20M", "HT", "2T", "112", "20",
	"CHILE", "5G", "20M", "HT", "2T", "112", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "112", "15",
	"FCC", "5G", "20M", "HT", "2T", "116", "32",
	"ETSI", "5G", "20M", "HT", "2T", "116", "20",
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"IC", "5G", "20M", "HT", "2T", "116", "32",
	"KCC", "5G", "20M", "HT", "2T", "116", "32",
	"ACMA", "5G", "20M", "HT", "2T", "116", "20",
	"CHILE", "5G", "20M", "HT", "2T", "116", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "116", "15",
	"FCC", "5G", "20M", "HT", "2T", "120", "32",
	"ETSI", "5G", "20M", "HT", "2T", "120", "20",
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"IC", "5G", "20M", "HT", "2T", "120", "-63",
	"KCC", "5G", "20M", "HT", "2T", "120", "32",
	"ACMA", "5G", "20M", "HT", "2T", "120", "-63",
	"CHILE", "5G", "20M", "HT", "2T", "120", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "120", "15",
	"FCC", "5G", "20M", "HT", "2T", "124", "32",
	"ETSI", "5G", "20M", "HT", "2T", "124", "20",
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"IC", "5G", "20M", "HT", "2T", "124", "-63",
	"KCC", "5G", "20M", "HT", "2T", "124", "32",
	"ACMA", "5G", "20M", "HT", "2T", "124", "-63",
	"CHILE", "5G", "20M", "HT", "2T", "124", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "124", "15",
	"FCC", "5G", "20M", "HT", "2T", "128", "32",
	"ETSI", "5G", "20M", "HT", "2T", "128", "20",
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"IC", "5G", "20M", "HT", "2T", "128", "-63",
	"KCC", "5G", "20M", "HT", "2T", "128", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "128", "-63",
	"CHILE", "5G", "20M", "HT", "2T", "128", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "128", "15",
	"FCC", "5G", "20M", "HT", "2T", "132", "32",
	"ETSI", "5G", "20M", "HT", "2T", "132", "20",
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"IC", "5G", "20M", "HT", "2T", "132", "32",
	"KCC", "5G", "20M", "HT", "2T", "132", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "132", "20",
	"CHILE", "5G", "20M", "HT", "2T", "132", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "132", "15",
	"FCC", "5G", "20M", "HT", "2T", "136", "30",
	"ETSI", "5G", "20M", "HT", "2T", "136", "20",
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"IC", "5G", "20M", "HT", "2T", "136", "30",
	"KCC", "5G", "20M", "HT", "2T", "136", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "136", "20",
	"CHILE", "5G", "20M", "HT", "2T", "136", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "136", "63",
	"FCC", "5G", "20M", "HT", "2T", "140", "26",
	"ETSI", "5G", "20M", "HT", "2T", "140", "20",
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"IC", "5G", "20M", "HT", "2T", "140", "26",
	"KCC", "5G", "20M", "HT", "2T", "140", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "140", "20",
	"CHILE", "5G", "20M", "HT", "2T", "140", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "140", "63",
	"FCC", "5G", "20M", "HT", "2T", "144", "26",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"IC", "5G", "20M", "HT", "2T", "144", "26",
	"KCC", "5G", "20M", "HT", "2T", "144", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "144", "-63",
	"CHILE", "5G", "20M", "HT", "2T", "144", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "32",
	"ETSI", "5G", "20M", "HT", "2T", "149", "63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"IC", "5G", "20M", "HT", "2T", "149", "32",
	"KCC", "5G", "20M", "HT", "2T", "149", "24",
	"ACMA", "5G", "20M", "HT", "2T", "149", "32",
	"CHILE", "5G", "20M", "HT", "2T", "149", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "149", "15",
	"FCC", "5G", "20M", "HT", "2T", "153", "32",
	"ETSI", "5G", "20M", "HT", "2T", "153", "63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"IC", "5G", "20M", "HT", "2T", "153", "32",
	"KCC", "5G", "20M", "HT", "2T", "153", "30",
	"ACMA", "5G", "20M", "HT", "2T", "153", "32",
	"CHILE", "5G", "20M", "HT", "2T", "153", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "153", "15",
	"FCC", "5G", "20M", "HT", "2T", "157", "32",
	"ETSI", "5G", "20M", "HT", "2T", "157", "63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"IC", "5G", "20M", "HT", "2T", "157", "32",
	"KCC", "5G", "20M", "HT", "2T", "157", "30",
	"ACMA", "5G", "20M", "HT", "2T", "157", "32",
	"CHILE", "5G", "20M", "HT", "2T", "157", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "157", "15",
	"FCC", "5G", "20M", "HT", "2T", "161", "32",
	"ETSI", "5G", "20M", "HT", "2T", "161", "63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"IC", "5G", "20M", "HT", "2T", "161", "32",
	"KCC", "5G", "20M", "HT", "2T", "161", "30",
	"ACMA", "5G", "20M", "HT", "2T", "161", "32",
	"CHILE", "5G", "20M", "HT", "2T", "161", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "161", "15",
	"FCC", "5G", "20M", "HT", "2T", "165", "32",
	"ETSI", "5G", "20M", "HT", "2T", "165", "63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"IC", "5G", "20M", "HT", "2T", "165", "32",
	"KCC", "5G", "20M", "HT", "2T", "165", "-63",
	"ACMA", "5G", "20M", "HT", "2T", "165", "32",
	"CHILE", "5G", "20M", "HT", "2T", "165", "18",
	"UKRAINE", "5G", "20M", "HT", "2T", "165", "15",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "30",
	"MKK", "5G", "40M", "HT", "1T", "38", "30",
	"IC", "5G", "40M", "HT", "1T", "38", "22",
	"KCC", "5G", "40M", "HT", "1T", "38", "18",
	"ACMA", "5G", "40M", "HT", "1T", "38", "30",
	"CHILE", "5G", "40M", "HT", "1T", "38", "22",
	"UKRAINE", "5G", "40M", "HT", "1T", "38", "27",
	"FCC", "5G", "40M", "HT", "1T", "46", "30",
	"ETSI", "5G", "40M", "HT", "1T", "46", "30",
	"MKK", "5G", "40M", "HT", "1T", "46", "30",
	"IC", "5G", "40M", "HT", "1T", "46", "30",
	"KCC", "5G", "40M", "HT", "1T", "46", "18",
	"ACMA", "5G", "40M", "HT", "1T", "46", "30",
	"CHILE", "5G", "40M", "HT", "1T", "46", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "46", "27",
	"FCC", "5G", "40M", "HT", "1T", "54", "30",
	"ETSI", "5G", "40M", "HT", "1T", "54", "30",
	"MKK", "5G", "40M", "HT", "1T", "54", "30",
	"IC", "5G", "40M", "HT", "1T", "54", "30",
	"KCC", "5G", "40M", "HT", "1T", "54", "16",
	"ACMA", "5G", "40M", "HT", "1T", "54", "30",
	"CHILE", "5G", "40M", "HT", "1T", "54", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "54", "27",
	"FCC", "5G", "40M", "HT", "1T", "62", "24",
	"ETSI", "5G", "40M", "HT", "1T", "62", "30",
	"MKK", "5G", "40M", "HT", "1T", "62", "30",
	"IC", "5G", "40M", "HT", "1T", "62", "24",
	"KCC", "5G", "40M", "HT", "1T", "62", "30",
	"ACMA", "5G", "40M", "HT", "1T", "62", "30",
	"CHILE", "5G", "40M", "HT", "1T", "62", "22",
	"UKRAINE", "5G", "40M", "HT", "1T", "62", "27",
	"FCC", "5G", "40M", "HT", "1T", "102", "24",
	"ETSI", "5G", "40M", "HT", "1T", "102", "30",
	"MKK", "5G", "40M", "HT", "1T", "102", "30",
	"IC", "5G", "40M", "HT", "1T", "102", "24",
	"KCC", "5G", "40M", "HT", "1T", "102", "26",
	"ACMA", "5G", "40M", "HT", "1T", "102", "30",
	"CHILE", "5G", "40M", "HT", "1T", "102", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "102", "27",
	"FCC", "5G", "40M", "HT", "1T", "110", "30",
	"ETSI", "5G", "40M", "HT", "1T", "110", "30",
	"MKK", "5G", "40M", "HT", "1T", "110", "30",
	"IC", "5G", "40M", "HT", "1T", "110", "30",
	"KCC", "5G", "40M", "HT", "1T", "110", "30",
	"ACMA", "5G", "40M", "HT", "1T", "110", "30",
	"CHILE", "5G", "40M", "HT", "1T", "110", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "110", "27",
	"FCC", "5G", "40M", "HT", "1T", "118", "30",
	"ETSI", "5G", "40M", "HT", "1T", "118", "30",
	"MKK", "5G", "40M", "HT", "1T", "118", "30",
	"IC", "5G", "40M", "HT", "1T", "118", "-63",
	"KCC", "5G", "40M", "HT", "1T", "118", "30",
	"ACMA", "5G", "40M", "HT", "1T", "118", "-63",
	"CHILE", "5G", "40M", "HT", "1T", "118", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "118", "27",
	"FCC", "5G", "40M", "HT", "1T", "126", "30",
	"ETSI", "5G", "40M", "HT", "1T", "126", "30",
	"MKK", "5G", "40M", "HT", "1T", "126", "30",
	"IC", "5G", "40M", "HT", "1T", "126", "-63",
	"KCC", "5G", "40M", "HT", "1T", "126", "-63",
	"ACMA", "5G", "40M", "HT", "1T", "126", "-63",
	"CHILE", "5G", "40M", "HT", "1T", "126", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "126", "27",
	"FCC", "5G", "40M", "HT", "1T", "134", "30",
	"ETSI", "5G", "40M", "HT", "1T", "134", "30",
	"MKK", "5G", "40M", "HT", "1T", "134", "30",
	"IC", "5G", "40M", "HT", "1T", "134", "30",
	"KCC", "5G", "40M", "HT", "1T", "134", "-63",
	"ACMA", "5G", "40M", "HT", "1T", "134", "30",
	"CHILE", "5G", "40M", "HT", "1T", "134", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "134", "63",
	"FCC", "5G", "40M", "HT", "1T", "142", "30",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"IC", "5G", "40M", "HT", "1T", "142", "30",
	"KCC", "5G", "40M", "HT", "1T", "142", "-63",
	"ACMA", "5G", "40M", "HT", "1T", "142", "-63",
	"CHILE", "5G", "40M", "HT", "1T", "142", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "30",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"IC", "5G", "40M", "HT", "1T", "151", "30",
	"KCC", "5G", "40M", "HT", "1T", "151", "20",
	"ACMA", "5G", "40M", "HT", "1T", "151", "30",
	"CHILE", "5G", "40M", "HT", "1T", "151", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "151", "27",
	"FCC", "5G", "40M", "HT", "1T", "159", "30",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"IC", "5G", "40M", "HT", "1T", "159", "30",
	"KCC", "5G", "40M", "HT", "1T", "159", "24",
	"ACMA", "5G", "40M", "HT", "1T", "159", "30",
	"CHILE", "5G", "40M", "HT", "1T", "159", "30",
	"UKRAINE", "5G", "40M", "HT", "1T", "159", "27",
	"FCC", "5G", "40M", "HT", "2T", "38", "20",
	"ETSI", "5G", "40M", "HT", "2T", "38", "20",
	"MKK", "5G", "40M", "HT", "2T", "38", "22",
	"IC", "5G", "40M", "HT", "2T", "38", "20",
	"KCC", "5G", "40M", "HT", "2T", "38", "18",
	"ACMA", "5G", "40M", "HT", "2T", "38", "20",
	"CHILE", "5G", "40M", "HT", "2T", "38", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "38", "15",
	"FCC", "5G", "40M", "HT", "2T", "46", "30",
	"ETSI", "5G", "40M", "HT", "2T", "46", "20",
	"MKK", "5G", "40M", "HT", "2T", "46", "22",
	"IC", "5G", "40M", "HT", "2T", "46", "18",
	"KCC", "5G", "40M", "HT", "2T", "46", "18",
	"ACMA", "5G", "40M", "HT", "2T", "46", "20",
	"CHILE", "5G", "40M", "HT", "2T", "46", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "46", "15",
	"FCC", "5G", "40M", "HT", "2T", "54", "30",
	"ETSI", "5G", "40M", "HT", "2T", "54", "20",
	"MKK", "5G", "40M", "HT", "2T", "54", "22",
	"IC", "5G", "40M", "HT", "2T", "54", "20",
	"KCC", "5G", "40M", "HT", "2T", "54", "16",
	"ACMA", "5G", "40M", "HT", "2T", "54", "20",
	"CHILE", "5G", "40M", "HT", "2T", "54", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "54", "15",
	"FCC", "5G", "40M", "HT", "2T", "62", "22",
	"ETSI", "5G", "40M", "HT", "2T", "62", "20",
	"MKK", "5G", "40M", "HT", "2T", "62", "22",
	"IC", "5G", "40M", "HT", "2T", "62", "20",
	"KCC", "5G", "40M", "HT", "2T", "62", "30",
	"ACMA", "5G", "40M", "HT", "2T", "62", "20",
	"CHILE", "5G", "40M", "HT", "2T", "62", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "62", "15",
	"FCC", "5G", "40M", "HT", "2T", "102", "22",
	"ETSI", "5G", "40M", "HT", "2T", "102", "20",
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"IC", "5G", "40M", "HT", "2T", "102", "22",
	"KCC", "5G", "40M", "HT", "2T", "102", "26",
	"ACMA", "5G", "40M", "HT", "2T", "102", "20",
	"CHILE", "5G", "40M", "HT", "2T", "102", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "102", "15",
	"FCC", "5G", "40M", "HT", "2T", "110", "30",
	"ETSI", "5G", "40M", "HT", "2T", "110", "20",
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"IC", "5G", "40M", "HT", "2T", "110", "30",
	"KCC", "5G", "40M", "HT", "2T", "110", "30",
	"ACMA", "5G", "40M", "HT", "2T", "110", "20",
	"CHILE", "5G", "40M", "HT", "2T", "110", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "110", "15",
	"FCC", "5G", "40M", "HT", "2T", "118", "30",
	"ETSI", "5G", "40M", "HT", "2T", "118", "20",
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"IC", "5G", "40M", "HT", "2T", "118", "-63",
	"KCC", "5G", "40M", "HT", "2T", "118", "30",
	"ACMA", "5G", "40M", "HT", "2T", "118", "-63",
	"CHILE", "5G", "40M", "HT", "2T", "118", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "118", "15",
	"FCC", "5G", "40M", "HT", "2T", "126", "30",
	"ETSI", "5G", "40M", "HT", "2T", "126", "20",
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"IC", "5G", "40M", "HT", "2T", "126", "-63",
	"KCC", "5G", "40M", "HT", "2T", "126", "-63",
	"ACMA", "5G", "40M", "HT", "2T", "126", "-63",
	"CHILE", "5G", "40M", "HT", "2T", "126", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "126", "15",
	"FCC", "5G", "40M", "HT", "2T", "134", "30",
	"ETSI", "5G", "40M", "HT", "2T", "134", "20",
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"IC", "5G", "40M", "HT", "2T", "134", "30",
	"KCC", "5G", "40M", "HT", "2T", "134", "-63",
	"ACMA", "5G", "40M", "HT", "2T", "134", "20",
	"CHILE", "5G", "40M", "HT", "2T", "134", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "134", "63",
	"FCC", "5G", "40M", "HT", "2T", "142", "30",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"IC", "5G", "40M", "HT", "2T", "142", "30",
	"KCC", "5G", "40M", "HT", "2T", "142", "-63",
	"ACMA", "5G", "40M", "HT", "2T", "142", "-63",
	"CHILE", "5G", "40M", "HT", "2T", "142", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "30",
	"ETSI", "5G", "40M", "HT", "2T", "151", "63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"IC", "5G", "40M", "HT", "2T", "151", "30",
	"KCC", "5G", "40M", "HT", "2T", "151", "20",
	"ACMA", "5G", "40M", "HT", "2T", "151", "30",
	"CHILE", "5G", "40M", "HT", "2T", "151", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "151", "15",
	"FCC", "5G", "40M", "HT", "2T", "159", "30",
	"ETSI", "5G", "40M", "HT", "2T", "159", "63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"IC", "5G", "40M", "HT", "2T", "159", "30",
	"KCC", "5G", "40M", "HT", "2T", "159", "24",
	"ACMA", "5G", "40M", "HT", "2T", "159", "30",
	"CHILE", "5G", "40M", "HT", "2T", "159", "18",
	"UKRAINE", "5G", "40M", "HT", "2T", "159", "15",
	"FCC", "5G", "80M", "VHT", "1T", "42", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "30",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"IC", "5G", "80M", "VHT", "1T", "42", "20",
	"KCC", "5G", "80M", "VHT", "1T", "42", "14",
	"ACMA", "5G", "80M", "VHT", "1T", "42", "30",
	"CHILE", "5G", "80M", "VHT", "1T", "42", "20",
	"UKRAINE", "5G", "80M", "VHT", "1T", "42", "27",
	"FCC", "5G", "80M", "VHT", "1T", "58", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "30",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"IC", "5G", "80M", "VHT", "1T", "58", "20",
	"KCC", "5G", "80M", "VHT", "1T", "58", "28",
	"ACMA", "5G", "80M", "VHT", "1T", "58", "30",
	"CHILE", "5G", "80M", "VHT", "1T", "58", "20",
	"UKRAINE", "5G", "80M", "VHT", "1T", "58", "27",
	"FCC", "5G", "80M", "VHT", "1T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "30",
	"MKK", "5G", "80M", "VHT", "1T", "106", "30",
	"IC", "5G", "80M", "VHT", "1T", "106", "20",
	"KCC", "5G", "80M", "VHT", "1T", "106", "28",
	"ACMA", "5G", "80M", "VHT", "1T", "106", "30",
	"CHILE", "5G", "80M", "VHT", "1T", "106", "30",
	"UKRAINE", "5G", "80M", "VHT", "1T", "106", "27",
	"FCC", "5G", "80M", "VHT", "1T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "30",
	"MKK", "5G", "80M", "VHT", "1T", "122", "30",
	"IC", "5G", "80M", "VHT", "1T", "122", "-63",
	"KCC", "5G", "80M", "VHT", "1T", "122", "28",
	"ACMA", "5G", "80M", "VHT", "1T", "122", "-63",
	"CHILE", "5G", "80M", "VHT", "1T", "122", "30",
	"UKRAINE", "5G", "80M", "VHT", "1T", "122", "27",
	"FCC", "5G", "80M", "VHT", "1T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"IC", "5G", "80M", "VHT", "1T", "138", "30",
	"KCC", "5G", "80M", "VHT", "1T", "138", "-63",
	"ACMA", "5G", "80M", "VHT", "1T", "138", "-63",
	"CHILE", "5G", "80M", "VHT", "1T", "138", "30",
	"UKRAINE", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"IC", "5G", "80M", "VHT", "1T", "155", "30",
	"KCC", "5G", "80M", "VHT", "1T", "155", "22",
	"ACMA", "5G", "80M", "VHT", "1T", "155", "30",
	"CHILE", "5G", "80M", "VHT", "1T", "155", "30",
	"UKRAINE", "5G", "80M", "VHT", "1T", "155", "27",
	"FCC", "5G", "80M", "VHT", "2T", "42", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "20",
	"MKK", "5G", "80M", "VHT", "2T", "42", "22",
	"IC", "5G", "80M", "VHT", "2T", "42", "18",
	"KCC", "5G", "80M", "VHT", "2T", "42", "14",
	"ACMA", "5G", "80M", "VHT", "2T", "42", "20",
	"CHILE", "5G", "80M", "VHT", "2T", "42", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "42", "15",
	"FCC", "5G", "80M", "VHT", "2T", "58", "18",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "20",
	"MKK", "5G", "80M", "VHT", "2T", "58", "22",
	"IC", "5G", "80M", "VHT", "2T", "58", "18",
	"KCC", "5G", "80M", "VHT", "2T", "58", "28",
	"ACMA", "5G", "80M", "VHT", "2T", "58", "20",
	"CHILE", "5G", "80M", "VHT", "2T", "58", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "58", "15",
	"FCC", "5G", "80M", "VHT", "2T", "106", "20",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "20",
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"IC", "5G", "80M", "VHT", "2T", "106", "20",
	"KCC", "5G", "80M", "VHT", "2T", "106", "28",
	"ACMA", "5G", "80M", "VHT", "2T", "106", "20",
	"CHILE", "5G", "80M", "VHT", "2T", "106", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "106", "15",
	"FCC", "5G", "80M", "VHT", "2T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "20",
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"IC", "5G", "80M", "VHT", "2T", "122", "-63",
	"KCC", "5G", "80M", "VHT", "2T", "122", "28",
	"ACMA", "5G", "80M", "VHT", "2T", "122", "-63",
	"CHILE", "5G", "80M", "VHT", "2T", "122", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "122", "15",
	"FCC", "5G", "80M", "VHT", "2T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"IC", "5G", "80M", "VHT", "2T", "138", "30",
	"KCC", "5G", "80M", "VHT", "2T", "138", "-63",
	"ACMA", "5G", "80M", "VHT", "2T", "138", "-63",
	"CHILE", "5G", "80M", "VHT", "2T", "138", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"IC", "5G", "80M", "VHT", "2T", "155", "30",
	"KCC", "5G", "80M", "VHT", "2T", "155", "22",
	"ACMA", "5G", "80M", "VHT", "2T", "155", "30",
	"CHILE", "5G", "80M", "VHT", "2T", "155", "18",
	"UKRAINE", "5G", "80M", "VHT", "2T", "155", "15"
};
#endif

void
odm_read_and_config_mp_8822b_txpwr_lmt_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8822B_TYPE5

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type5) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8822b_txpwr_lmt_type5;
#else
	u32	array_len =
			sizeof(array_mp_8822b_txpwr_lmt_type5) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8822b_txpwr_lmt_type5;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8822b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

#endif /* end of HWIMG_SUPPORT*/

