% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentize.R
\name{normalize}
\alias{normalize}
\alias{normalize.default}
\alias{normalize.data.frame}
\alias{normalize.matrix}
\title{Normalization transformation (0-1)}
\usage{
normalize(x, ...)
}
\arguments{
\item{x}{a vector or a data.frame.}

\item{...}{Currently ignored.}
}
\value{
A vector (or data.frame) after normalizing the numeric variables.
}
\description{
An Empirical Normalization Transformation brings data to the 0 to 1 scale
by substracting the minimum and dividing by the maximum of all observations.
This is similar to \link{percentize} in that it allows to compare variables
of different scales, but it also keeps the shape of the distribution.
}
\examples{
\dontrun{
x <- mtcars
x <- data.frame(x)
x$am <- factor(x$am)
x$vs <- factor(x$vs)
heatmaply(percentize(x))
heatmaply(normalize(x))


x <- data.frame(a = 1:10, b = 11:20)
x[4:6, 1:2] <- NA
normalize(x)
normalize(x[,1])

}
}
\seealso{
\link{percentize}
}
