# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpdateClusterUpgradeDescription(Model):
    """Parameters for updating a cluster upgrade.

    :param upgrade_kind: The type of upgrade out of the following possible
     values. Possible values include: 'Invalid', 'Rolling',
     'Rolling_ForceRestart'. Default value: "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeType
    :param update_description: Describes the parameters for updating a rolling
     upgrade of application or cluster.
    :type update_description:
     ~azure.servicefabric.models.RollingUpgradeUpdateDescription
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param enable_delta_health_evaluation: When true, enables delta health
     evaluation rather than absolute health evaluation after completion of each
     upgrade domain.
    :type enable_delta_health_evaluation: bool
    :param cluster_upgrade_health_policy: Defines a health policy used to
     evaluate the health of the cluster during a cluster upgrade.
    :type cluster_upgrade_health_policy:
     ~azure.servicefabric.models.ClusterUpgradeHealthPolicyObject
    :param application_health_policy_map: Defines the application health
     policy map used to evaluate the health of an application or one of its
     children entities.
    :type application_health_policy_map:
     ~azure.servicefabric.models.ApplicationHealthPolicies
    """

    _attribute_map = {
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'update_description': {'key': 'UpdateDescription', 'type': 'RollingUpgradeUpdateDescription'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'enable_delta_health_evaluation': {'key': 'EnableDeltaHealthEvaluation', 'type': 'bool'},
        'cluster_upgrade_health_policy': {'key': 'ClusterUpgradeHealthPolicy', 'type': 'ClusterUpgradeHealthPolicyObject'},
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': 'ApplicationHealthPolicies'},
    }

    def __init__(self, **kwargs):
        super(UpdateClusterUpgradeDescription, self).__init__(**kwargs)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.update_description = kwargs.get('update_description', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.enable_delta_health_evaluation = kwargs.get('enable_delta_health_evaluation', None)
        self.cluster_upgrade_health_policy = kwargs.get('cluster_upgrade_health_policy', None)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)
