# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExpressRouteCrossConnectionRoutesTableSummary(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: IP address of Neighbor router
    :type neighbor: str
    :param asn: Autonomous system number.
    :type asn: int
    :param up_down: The length of time that the BGP session has been in the
     Established state, or the current status if not in the Established state.
    :type up_down: str
    :param state_or_prefixes_received: Current state of the BGP session, and
     the number of prefixes that have been received from a neighbor or peer
     group.
    :type state_or_prefixes_received: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_or_prefixes_received': {'key': 'stateOrPrefixesReceived', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExpressRouteCrossConnectionRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = kwargs.get('neighbor', None)
        self.asn = kwargs.get('asn', None)
        self.up_down = kwargs.get('up_down', None)
        self.state_or_prefixes_received = kwargs.get('state_or_prefixes_received', None)
