/*M///////////////////////////////////////////////////////////////////////////////////////
 //
 //  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
 //
 //  By downloading, copying, installing or using the software you agree to this license.
 //  If you do not agree to this license, do not download, install,
 //  copy or use the software.
 //
 //
 //                           License Agreement
 //                For Open Source Computer Vision Library
 //
 // Copyright (C) 2013, OpenCV Foundation, all rights reserved.
 // Third party copyrights are property of their respective owners.
 //
 // Redistribution and use in source and binary forms, with or without modification,
 // are permitted provided that the following conditions are met:
 //
 //   * Redistribution's of source code must retain the above copyright notice,
 //     this list of conditions and the following disclaimer.
 //
 //   * Redistribution's in binary form must reproduce the above copyright notice,
 //     this list of conditions and the following disclaimer in the documentation
 //     and/or other materials provided with the distribution.
 //
 //   * The name of the copyright holders may not be used to endorse or promote products
 //     derived from this software without specific prior written permission.
 //
 // This software is provided by the copyright holders and contributors "as is" and
 // any express or implied warranties, including, but not limited to, the implied
 // warranties of merchantability and fitness for a particular purpose are disclaimed.
 // In no event shall the Intel Corporation or contributors be liable for any direct,
 // indirect, incidental, special, exemplary, or consequential damages
 // (including, but not limited to, procurement of substitute goods or services;
 // loss of use, data, or profits; or business interruption) however caused
 // and on any theory of liability, whether in contract, strict liability,
 // or tort (including negligence or otherwise) arising in any way out of
 // the use of this software, even if advised of the possibility of such damage.
 //
 //M*/

#include "precomp.hpp"
#include <stdlib.h>

namespace cv{
  const double ColorNames[][10]={
      {0.45975,0.014802,0.044289,-0.028193,0.001151,-0.0050145,0.34522,0.018362,0.23994,0.1689},
      {0.47157,0.021424,0.041444,-0.030215,0.0019002,-0.0029264,0.32875,0.0082059,0.2502,0.17007},
      {0.47098,0.042624,0.025014,-0.033501,0.0028958,-0.001415,0.29519,-0.0072627,0.26919,0.16947},
      {0.42128,0.088147,0.0058496,-0.044178,0.010076,0.0021587,0.21576,-0.026959,0.2669,0.16206},
      {0.31121,0.16376,-0.0081563,-0.059056,0.028275,0.010449,0.078392,-0.044238,0.23125,0.14402},
      {0.15115,0.24388,-0.029545,-0.061341,0.09908,0.049603,-0.086541,-0.05286,0.15297,0.077428},
      {0.044892,0.30219,-0.050092,-0.037427,0.16874,0.089091,-0.19539,-0.035538,0.11125,0.012195},
      {0.019769,0.29248,-0.064553,0.0012266,0.23761,0.13017,-0.20335,-4.63E-05,0.09961,-0.05174},
      {0.0088796,0.26221,-0.084374,0.008441,0.28072,0.15633,-0.18567,0.022777,0.072167,-0.0909},
      {0.0022172,0.22642,-0.10431,0.013484,0.32373,0.18305,-0.16172,0.045342,0.044433,-0.1296},
      {0.0010121,0.19464,-0.11342,0.015283,0.36313,0.20679,-0.13917,0.060641,0.02893,-0.16607},
      {0.00077574,0.16621,-0.1137,0.013666,0.40119,0.22916,-0.11882,0.066766,0.018284,-0.20197},
      {0.0005609,0.1382,-0.11075,0.011384,0.43716,0.25035,-0.098706,0.067128,0.0070239,-0.23589},
      {0.00035375,0.11059,-0.10696,0.0081607,0.47472,0.27278,-0.078921,0.067596,-0.0030686,-0.27112},
      {0.00019737,0.088039,-0.10526,0.0041345,0.50556,0.29129,-0.062775,0.070046,-0.011211,-0.29997},
      {0.00015506,0.073477,-0.11885,0.0019322,0.50877,0.29298,-0.052358,0.081131,-0.024383,-0.30315},
      {0.00011927,0.059127,-0.13513,0.0011085,0.50737,0.29208,-0.042128,0.092906,-0.039611,-0.30186},
      {8.21E-05,0.046284,-0.14906,0.00034294,0.50726,0.29211,-0.032978,0.10324,-0.052739,-0.30168},
      {4.48E-05,0.035151,-0.15967,-0.00029085,0.50925,0.29356,-0.025049,0.11144,-0.063192,-0.30331},
      {2.41E-05,0.02788,-0.17279,-0.00079457,0.50472,0.29117,-0.019864,0.12141,-0.072941,-0.29879},
      {2.54E-05,0.02165,-0.19739,-0.0011171,0.48609,0.28037,-0.015435,0.13864,-0.088498,-0.28099},
      {4.51E-05,0.015644,-0.22519,-0.0013494,0.46409,0.26763,-0.011162,0.15818,-0.10548,-0.25996},
      {8.50E-05,0.010389,-0.24767,-0.0014462,0.44686,0.25769,-0.0073889,0.17404,-0.11937,-0.24345},
      {0.00014991,0.0059795,-0.26473,-0.0014038,0.43438,0.25058,-0.0041866,0.18618,-0.13005,-0.23143},
      {0.00031694,0.0028859,-0.27656,-0.0011899,0.42589,0.24578,-0.0018503,0.19473,-0.13731,-0.22322},
      {0.00056233,0.0013592,-0.28349,-0.00102,0.42047,0.24264,-0.00058662,0.19976,-0.14132,-0.21802},
      {0.00068571,0.00049051,-0.28492,-0.00095185,0.41987,0.24229,0.00012151,0.20081,-0.14237,-0.21746},
      {0.00068903,0.00024501,-0.28935,-0.00080839,0.41585,0.23998,0.00030324,0.20404,-0.14463,-0.21361},
      {0.0006093,9.07E-05,-0.29023,-0.00064321,0.41541,0.23974,0.00036058,0.20478,-0.1451,-0.21316},
      {0.00045048,2.37E-06,-0.28884,-0.00045463,0.4173,0.24089,0.00031409,0.20393,-0.14443,-0.21493},
      {0.00015668,1.29E-06,-0.29056,-0.00024875,0.4161,0.2402,0.00010849,0.20529,-0.14533,-0.21377},
      {0,8.37E-07,-0.28955,-9.68E-05,0.41742,0.24097,-1.14E-06,0.20468,-0.14483,-0.21504},
      {0.45189,0.016535,0.061726,-0.027316,0.0012303,-0.0041319,0.32553,0.027836,0.22868,0.16959},
      {0.46226,0.023961,0.051722,-0.028453,0.0015605,-0.0028334,0.30868,0.015618,0.24439,0.1701},
      {0.45748,0.046163,0.031605,-0.030988,0.0025403,-0.0018479,0.27382,-0.00071319,0.26472,0.16886},
      {0.41795,0.087735,0.0094753,-0.037383,0.0083231,0.0008791,0.20373,-0.019349,0.27109,0.16252},
      {0.31478,0.16326,-0.0051786,-0.047301,0.025317,0.0084112,0.072026,-0.032802,0.24198,0.14548},
      {0.18565,0.24039,-0.02491,-0.043494,0.077851,0.036964,-0.070847,-0.034905,0.19059,0.095722},
      {0.075164,0.31163,-0.046618,-0.018966,0.14142,0.072532,-0.19055,-0.01593,0.15303,0.036005},
      {0.025677,0.32773,-0.067978,-0.0017575,0.18986,0.1003,-0.22816,0.0072291,0.12476,-0.0088445},
      {0.013256,0.29523,-0.087223,0.0065028,0.23697,0.12868,-0.2093,0.028581,0.094433,-0.051804},
      {0.0052935,0.25811,-0.10629,0.012172,0.28373,0.15747,-0.18472,0.049949,0.06493,-0.094048},
      {0.0013102,0.21828,-0.12545,0.013128,0.33194,0.18787,-0.15607,0.073741,0.03837,-0.1371},
      {0.00090962,0.18653,-0.12532,0.012102,0.36962,0.21007,-0.13322,0.07615,0.023607,-0.17255},
      {0.00068173,0.15686,-0.12213,0.010073,0.4074,0.23226,-0.11191,0.076255,0.011529,-0.20822},
      {0.00046348,0.12782,-0.11808,0.0070708,0.44657,0.25558,-0.091087,0.076436,0.00075602,-0.245},
      {0.00025348,0.098669,-0.11563,0.0032403,0.48534,0.27907,-0.070281,0.078401,-0.010328,-0.28108},
      {0.00017665,0.078384,-0.13051,0.0019297,0.49228,0.28325,-0.055843,0.089617,-0.027558,-0.28754},
      {0.00013887,0.063453,-0.14716,0.0011316,0.49103,0.28242,-0.045201,0.10162,-0.043282,-0.28642},
      {9.99E-05,0.050092,-0.16136,0.0003831,0.49112,0.28253,-0.035683,0.11212,-0.056828,-0.28644},
      {6.10E-05,0.038491,-0.17218,-0.00024104,0.49331,0.28408,-0.027422,0.12044,-0.06764,-0.28829},
      {2.61E-05,0.028656,-0.18137,-0.00065409,0.49545,0.2858,-0.020421,0.12758,-0.07677,-0.28994},
      {2.76E-05,0.022281,-0.20783,-0.00099758,0.47508,0.27397,-0.015895,0.14609,-0.09333,-0.27048},
      {4.56E-05,0.016214,-0.23585,-0.0012458,0.4529,0.26111,-0.011579,0.16578,-0.11047,-0.24929},
      {8.36E-05,0.010898,-0.25848,-0.0013584,0.43556,0.25111,-0.0077615,0.18175,-0.12447,-0.23268},
      {0.00014662,0.0064253,-0.27564,-0.0013319,0.42304,0.24397,-0.0045145,0.19394,-0.13523,-0.22062},
      {0.0002466,0.0029136,-0.28739,-0.0011591,0.41513,0.23956,-0.0019207,0.20241,-0.14273,-0.21292},
      {0.00049286,0.0013711,-0.29454,-0.0010165,0.40947,0.23628,-0.00064528,0.20758,-0.14687,-0.2075},
      {0.00062483,0.0005198,-0.29691,-0.00094596,0.4079,0.23537,5.69E-05,0.2093,-0.14837,-0.20601},
      {0.00064,0.00027361,-0.30142,-0.00080406,0.40379,0.233,0.00024765,0.21258,-0.15067,-0.20207},
      {0.00057159,0.00011218,-0.30214,-0.00064136,0.4035,0.23285,0.00031821,0.21321,-0.15106,-0.20177},
      {0.00042292,1.80E-05,-0.30054,-0.00045512,0.40559,0.23411,0.0002832,0.2122,-0.15029,-0.20374},
      {0.000156,1.33E-06,-0.30088,-0.00025054,0.40577,0.23424,0.00010795,0.21258,-0.15049,-0.20389},
      {0,8.60E-07,-0.30007,-9.95E-05,0.4069,0.23489,-1.18E-06,0.21212,-0.15009,-0.20496},
      {0.43233,0.01979,0.086639,-0.024605,0.00073035,-0.0039374,0.2928,0.045629,0.21094,0.16984},
      {0.44089,0.026777,0.071451,-0.024877,0.00077527,-0.0033664,0.27713,0.031721,0.23006,0.16976},
      {0.43441,0.048327,0.048581,-0.026336,0.0016822,-0.0028252,0.24272,0.014543,0.25177,0.16813},
      {0.42125,0.077325,0.01911,-0.027409,0.0029524,-0.0024165,0.19636,-0.0062372,0.27814,0.1656},
      {0.32699,0.15112,0.0038678,-0.031551,0.019075,0.0046403,0.072984,-0.015276,0.25623,0.14928},
      {0.23051,0.23408,-0.014201,-0.027276,0.03657,0.012235,-0.058422,-0.018363,0.24131,0.13134},
      {0.1288,0.29622,-0.037664,-0.013458,0.08858,0.038737,-0.1614,-0.0034142,0.19859,0.081033},
      {0.05634,0.33812,-0.064461,-0.0030047,0.13184,0.062356,-0.22668,0.015287,0.16046,0.040974},
      {0.016217,0.3473,-0.090532,0.0060974,0.17256,0.087223,-0.24832,0.035463,0.12623,0.0052226},
      {0.007569,0.30763,-0.10905,0.011643,0.22499,0.11926,-0.22139,0.056529,0.094701,-0.042314},
      {0.0034144,0.26397,-0.12626,0.012127,0.27437,0.14963,-0.18952,0.075188,0.064023,-0.086963},
      {0.0012812,0.21814,-0.14161,0.010226,0.32068,0.17977,-0.15568,0.089194,0.032726,-0.12756},
      {0.00085968,0.18476,-0.13998,0.0083565,0.36185,0.20442,-0.13162,0.090398,0.01777,-0.16597},
      {0.00062698,0.15381,-0.13534,0.005616,0.40339,0.22906,-0.10942,0.090031,0.0061927,-0.20502},
      {0.00041079,0.1226,-0.13636,0.0027247,0.43933,0.25067,-0.087154,0.093577,-0.0082832,-0.23859},
      {0.00022166,0.087079,-0.14964,0.0019612,0.46421,0.26647,-0.062004,0.10346,-0.032517,-0.26114},
      {0.00016866,0.069701,-0.16653,0.0011833,0.46538,0.2672,-0.049638,0.11562,-0.049586,-0.26219},
      {0.00012695,0.0556,-0.18107,0.00045094,0.4658,0.26748,-0.039595,0.12632,-0.063702,-0.26255},
      {8.56E-05,0.043327,-0.19214,-0.00016524,0.46835,0.2692,-0.030857,0.13478,-0.075004,-0.26477},
      {4.72E-05,0.032229,-0.20203,-0.00053393,0.47078,0.27108,-0.022965,0.14222,-0.085253,-0.2667},
      {2.93E-05,0.023187,-0.22461,-0.00082034,0.45746,0.26372,-0.016558,0.15808,-0.10117,-0.25367},
      {4.46E-05,0.017029,-0.25288,-0.0010924,0.4351,0.25076,-0.012176,0.17792,-0.11848,-0.23232},
      {7.98E-05,0.01162,-0.27566,-0.0012288,0.41768,0.2407,-0.0082938,0.19398,-0.13262,-0.21564},
      {0.00013986,0.0070542,-0.29289,-0.001226,0.40516,0.23354,-0.0049802,0.20621,-0.14348,-0.20358},
      {0.00022927,0.0034009,-0.30485,-0.0010764,0.39717,0.22909,-0.0022898,0.21482,-0.15117,-0.19581},
      {0.0003881,0.0013628,-0.31194,-0.0010124,0.39217,0.22628,-0.00071513,0.21988,-0.15562,-0.19095},
      {0.00053248,0.00057251,-0.31595,-0.00093563,0.3889,0.22438,-4.70E-05,0.22277,-0.15791,-0.18783},
      {0.0005666,0.00031416,-0.32024,-0.00079779,0.38499,0.22211,0.00016605,0.22589,-0.16009,-0.18409},
      {0.00051522,0.0001426,-0.32066,-0.00063892,0.38498,0.22213,0.00025608,0.2263,-0.16033,-0.18407},
      {0.00038186,4.01E-05,-0.31869,-0.00045631,0.38743,0.22359,0.00023804,0.22503,-0.15937,-0.18637},
      {0.00015266,1.39E-06,-0.317,-0.00025194,0.38965,0.22492,0.00010551,0.22398,-0.15855,-0.18846},
      {0,8.86E-07,-0.31649,-0.00010276,0.39047,0.2254,-1.23E-06,0.22372,-0.1583,-0.18924},
      {0.38781,0.021078,0.13954,-0.019427,-0.00032756,-0.0046008,0.24557,0.086508,0.16601,0.16992},
      {0.39572,0.027942,0.11924,-0.019185,-0.00049069,-0.0046284,0.2314,0.070315,0.18867,0.16933},
      {0.39674,0.043586,0.091983,-0.019105,-0.00020782,-0.0046638,0.20401,0.04996,0.21626,0.16785},
      {0.38333,0.07122,0.061772,-0.018958,0.00089664,-0.0045981,0.15867,0.029298,0.24328,0.16521},
      {0.34641,0.11437,0.030632,-0.017358,0.0040353,-0.0076712,0.086959,0.01042,0.26367,0.15728},
      {0.24828,0.19901,0.010497,-0.014483,0.020002,-0.0049779,-0.038817,0.0092979,0.24411,0.13814},
      {0.15596,0.28591,-0.020407,-0.0099214,0.036268,-0.0012377,-0.15845,0.006983,0.23004,0.11949},
      {0.084203,0.33589,-0.050477,-0.0010108,0.074262,0.019037,-0.22814,0.01864,0.19776,0.084144},
      {0.036225,0.36169,-0.080023,0.0075267,0.11456,0.044122,-0.26088,0.039374,0.16212,0.049933},
      {0.0087909,0.37393,-0.11203,0.012231,0.14579,0.065566,-0.27045,0.062484,0.13119,0.025838},
      {0.0055905,0.3245,-0.12805,0.01116,0.1962,0.095002,-0.23347,0.077123,0.096345,-0.020873},
      {0.00321,0.2751,-0.14351,0.0092721,0.24713,0.12743,-0.19675,0.091349,0.062834,-0.066066},
      {0.0014093,0.22595,-0.15932,0.006689,0.29795,0.16306,-0.16076,0.10575,0.030269,-0.10868},
      {0.0008447,0.19001,-0.16089,0.0042353,0.34085,0.19037,-0.1349,0.10955,0.012615,-0.14734},
      {0.00061965,0.1542,-0.16664,0.0028667,0.37389,0.20964,-0.10944,0.11493,-0.0075624,-0.17868},
      {0.00040949,0.11591,-0.17909,0.0021006,0.40226,0.22716,-0.082323,0.12427,-0.032748,-0.20482},
      {0.00021612,0.078596,-0.19485,0.0012777,0.42776,0.24466,-0.055947,0.13601,-0.058991,-0.22687},
      {0.00016349,0.062512,-0.20975,0.00054946,0.42994,0.24611,-0.044505,0.14693,-0.074301,-0.22879},
      {0.00011881,0.049403,-0.22101,-6.69E-05,0.43305,0.24812,-0.035175,0.15548,-0.086155,-0.23156},
      {7.88E-05,0.03704,-0.23301,-0.00038481,0.43421,0.24918,-0.026393,0.16416,-0.098261,-0.23235},
      {4.23E-05,0.025633,-0.25322,-0.00063256,0.42603,0.24509,-0.018326,0.17841,-0.11413,-0.22398},
      {3.99E-05,0.018023,-0.27755,-0.00089261,0.40948,0.23583,-0.012914,0.1955,-0.1302,-0.20789},
      {7.11E-05,0.012495,-0.30037,-0.0010605,0.3921,0.22579,-0.0089451,0.21157,-0.14444,-0.19126},
      {0.00012713,0.0078038,-0.31768,-0.0010882,0.3796,0.21864,-0.0055416,0.22383,-0.15542,-0.17924},
      {0.00021267,0.0040158,-0.32998,-0.00096407,0.37139,0.21404,-0.0027542,0.23266,-0.16337,-0.17126},
      {0.00026619,0.001385,-0.3367,-0.00099978,0.36747,0.21197,-0.00082162,0.23739,-0.16804,-0.16735},
      {0.00041038,0.00063638,-0.34276,-0.00092224,0.36213,0.20889,-0.00018022,0.24173,-0.17133,-0.16223},
      {0.00046965,0.00036328,-0.34662,-0.00079004,0.35862,0.20685,6.14E-05,0.24455,-0.1733,-0.15888},
      {0.00044096,0.00017937,-0.34654,-0.00063648,0.3591,0.20714,0.00017659,0.2446,-0.17329,-0.15933},
      {0.00032812,6.66E-05,-0.344,-0.00045888,0.3621,0.20891,0.00018061,0.24293,-0.17204,-0.16217},
      {0.00013463,7.91E-06,-0.3404,-0.00025465,0.36623,0.21138,8.80E-05,0.24053,-0.17026,-0.16606},
      {0,9.06E-07,-0.33958,-0.00010548,0.36738,0.21207,-1.28E-06,0.24005,-0.16984,-0.16714},
      {0.27637,0.016208,0.28952,-0.011135,-0.0015191,-0.0064237,0.16583,0.20008,0.027106,0.17089},
      {0.28091,0.023375,0.26789,-0.010632,-0.0017693,-0.0079961,0.15188,0.18366,0.049174,0.1691},
      {0.28752,0.033932,0.23445,-0.0098181,-0.0021889,-0.011025,0.13223,0.15846,0.082567,0.16587},
      {0.28545,0.052724,0.19144,-0.0089787,-0.0021494,-0.015457,0.097853,0.12734,0.12176,0.16036},
      {0.26273,0.091798,0.14054,-0.0079568,-0.00060808,-0.020818,0.036224,0.09361,0.16168,0.15204},
      {0.23924,0.14002,0.071812,-0.0060892,0.0011676,-0.028662,-0.034924,0.048404,0.21593,0.1408},
      {0.1641,0.22496,0.031218,-0.0018843,0.0166,-0.024951,-0.13705,0.039022,0.21288,0.12362},
      {0.092571,0.31966,-0.015663,0.0043396,0.033343,-0.019601,-0.2339,0.032503,0.2105,0.1069},
      {0.047527,0.37208,-0.059723,0.0085909,0.057744,-0.013899,-0.27812,0.036666,0.19403,0.080233},
      {0.024953,0.37705,-0.091604,0.0099029,0.087876,0.0024958,-0.27716,0.05657,0.1595,0.054047},
      {0.0098262,0.38243,-0.12535,0.010026,0.11031,0.025142,-0.27572,0.078096,0.1314,0.04348},
      {0.005038,0.34573,-0.14597,0.0083623,0.15573,0.058499,-0.24686,0.094537,0.09922,0.0074178},
      {0.0030513,0.29431,-0.16177,0.0061165,0.20969,0.095991,-0.20892,0.10874,0.064999,-0.038054},
      {0.0015424,0.24163,-0.18451,0.0039891,0.2559,0.13137,-0.17114,0.12695,0.027332,-0.074439},
      {0.00086557,0.19296,-0.20483,0.0031425,0.29155,0.15683,-0.13674,0.14188,-0.0072208,-0.10428},
      {0.00063099,0.15101,-0.21639,0.0023133,0.32441,0.17667,-0.10704,0.15066,-0.033759,-0.13493},
      {0.00041554,0.11044,-0.23111,0.0014415,0.35412,0.19633,-0.078362,0.16173,-0.061091,-0.16123},
      {0.00022436,0.072769,-0.24845,0.00066831,0.37984,0.21555,-0.051771,0.17464,-0.088218,-0.18217},
      {0.0001608,0.056139,-0.26074,6.13E-05,0.38592,0.21988,-0.039966,0.18384,-0.1024,-0.18729},
      {0.00011677,0.04231,-0.27849,-0.00020065,0.38225,0.21796,-0.030183,0.19636,-0.11826,-0.18361},
      {7.53E-05,0.030213,-0.29672,-0.0004549,0.37669,0.21533,-0.021621,0.20921,-0.13349,-0.17781},
      {4.08E-05,0.01995,-0.31345,-0.00067431,0.37125,0.2132,-0.014326,0.22101,-0.14706,-0.17176},
      {5.39E-05,0.013411,-0.3339,-0.00086104,0.35764,0.20569,-0.0096402,0.23541,-0.16063,-0.15844},
      {0.00010494,0.0085598,-0.35145,-0.00092287,0.34502,0.19846,-0.0061204,0.24782,-0.17184,-0.14631},
      {0.00018272,0.0046193,-0.36393,-0.00084807,0.33675,0.1938,-0.0032252,0.25674,-0.17998,-0.13828},
      {0.00023141,0.0018416,-0.36978,-0.00092206,0.33376,0.19223,-0.0011911,0.26084,-0.18432,-0.1353},
      {0.00026249,0.00070397,-0.37816,-0.0009067,0.32677,0.18843,-0.00033463,0.26678,-0.18907,-0.12842},
      {0.00035242,0.00041522,-0.38129,-0.00078175,0.32397,0.18679,-5.98E-05,0.26908,-0.19066,-0.12576},
      {0.00035161,0.00021811,-0.38041,-0.00063503,0.32522,0.18751,8.49E-05,0.26855,-0.19025,-0.12695},
      {0.00026411,9.44E-05,-0.37701,-0.00046389,0.32905,0.18976,0.00011499,0.26626,-0.18856,-0.13059},
      {9.37E-05,2.68E-05,-0.3725,-0.00026577,0.33407,0.19273,4.54E-05,0.26322,-0.18633,-0.13534},
      {0,9.04E-07,-0.37006,-0.00010607,0.33689,0.19446,-1.31E-06,0.2616,-0.18509,-0.13795},
      {0.12724,0.0086872,0.49817,-0.0043658,-0.0015597,-0.0064611,0.071305,0.35419,-0.16929,0.17461},
      {0.13184,0.010657,0.48286,-0.0040048,-0.001817,-0.0082865,0.066035,0.34251,-0.15452,0.17264},
      {0.14329,0.018736,0.43907,-0.0035306,-0.0023027,-0.012801,0.052641,0.30999,-0.11342,0.16777},
      {0.15624,0.028713,0.38407,-0.0027527,-0.0029478,-0.019398,0.035183,0.2693,-0.062487,0.16085},
      {0.16468,0.045695,0.32008,-0.0015474,-0.0032953,-0.02802,0.0083016,0.223,-0.0054702,0.15156},
      {0.15156,0.097973,0.236,0.00037802,-0.001293,-0.036836,-0.055679,0.16722,0.062454,0.13931},
      {0.13988,0.15369,0.1361,0.0022194,0.00082245,-0.060184,-0.11728,0.10186,0.1379,0.11536},
      {0.099856,0.23055,0.06526,0.0047831,0.011332,-0.078209,-0.18105,0.07331,0.16043,0.088078},
      {0.059029,0.31448,0.0010232,0.0070174,0.022475,-0.085318,-0.24088,0.058365,0.17054,0.070108},
      {0.032318,0.38045,-0.064644,0.0083118,0.034482,-0.083965,-0.28302,0.047208,0.18159,0.057331},
      {0.018103,0.38618,-0.098938,0.0082478,0.059148,-0.057937,-0.28014,0.068662,0.15339,0.046531},
      {0.0087172,0.39491,-0.13415,0.0077764,0.076014,-0.024979,-0.28103,0.09081,0.13206,0.051944},
      {0.0044238,0.37332,-0.16152,0.0062064,0.1076,0.012206,-0.26379,0.1098,0.10541,0.038789},
      {0.0028626,0.30778,-0.18649,0.0048895,0.1583,0.046138,-0.21753,0.12825,0.05972,-0.0053201},
      {0.0016255,0.24543,-0.22412,0.0036393,0.19897,0.082143,-0.17356,0.15557,0.009564,-0.033457},
      {0.00087215,0.19047,-0.26139,0.0025446,0.2322,0.11518,-0.1348,0.18257,-0.03642,-0.053527},
      {0.00063313,0.14605,-0.27502,0.0015734,0.26686,0.13751,-0.10341,0.19293,-0.065086,-0.08471},
      {0.00042015,0.10489,-0.29111,0.00071694,0.29729,0.15926,-0.074354,0.20502,-0.093312,-0.11032},
      {0.00023744,0.06732,-0.31347,0.000294,0.31878,0.1777,-0.047902,0.22117,-0.12306,-0.12584},
      {0.00015787,0.047757,-0.33489,3.81E-05,0.31873,0.17958,-0.03412,0.23629,-0.14359,-0.12421},
      {0.00011075,0.034961,-0.35015,-0.00023175,0.31682,0.17899,-0.025053,0.24705,-0.1577,-0.12195},
      {7.10E-05,0.024023,-0.36412,-0.00046797,0.3148,0.17878,-0.017273,0.2569,-0.17023,-0.11922},
      {4.02E-05,0.014925,-0.37896,-0.00064664,0.31051,0.17772,-0.010772,0.2674,-0.18227,-0.11394},
      {6.84E-05,0.0091634,-0.39573,-0.00074067,0.30005,0.17219,-0.0066065,0.27926,-0.19358,-0.1035},
      {0.00013433,0.0050696,-0.40752,-0.00074942,0.2925,0.16792,-0.0036084,0.28763,-0.2015,-0.096202},
      {0.00017869,0.0025248,-0.41321,-0.00080622,0.28945,0.16627,-0.0017372,0.29162,-0.20564,-0.09318},
      {0.00019739,0.0012022,-0.41935,-0.00081255,0.2849,0.16389,-0.00075207,0.29596,-0.20938,-0.088628},
      {0.00022075,0.00046235,-0.42484,-0.00077453,0.28045,0.16158,-0.00018787,0.29987,-0.21248,-0.08415},
      {0.00025207,0.00025301,-0.42275,-0.00063619,0.28286,0.16296,-1.13E-05,0.29849,-0.21145,-0.086469},
      {0.000194,0.0001191,-0.41812,-0.00047296,0.28789,0.16588,4.73E-05,0.29533,-0.20915,-0.091266},
      {5.05E-05,4.32E-05,-0.41235,-0.00028232,0.29414,0.16955,3.04E-06,0.29138,-0.20627,-0.097199},
      {1.86E-07,8.95E-06,-0.40806,-0.00012834,0.29876,0.17233,-7.04E-06,0.28846,-0.20409,-0.10154},
      {0.032366,0.0087809,0.63451,-0.00054318,-0.00098394,-0.0055105,0.0090641,0.45221,-0.29444,0.17817},
      {0.036901,0.008587,0.62598,-0.00053174,-0.0011169,-0.006778,0.010512,0.44573,-0.28663,0.17688},
      {0.042394,0.0083166,0.6151,-0.00049811,-0.0012919,-0.0086785,0.012059,0.43743,-0.27673,0.175},
      {0.057378,0.015029,0.56151,-2.64E-05,-0.0017918,-0.017661,0.0031802,0.398,-0.22889,0.16623},
      {0.071094,0.022371,0.50273,0.00063814,-0.0023203,-0.031191,-0.0080541,0.35503,-0.17823,0.15363},
      {0.080656,0.029616,0.44578,0.0014719,-0.0027895,-0.050046,-0.020603,0.31379,-0.1319,0.13676},
      {0.076773,0.086428,0.33285,0.0028217,-0.0009232,-0.084437,-0.072766,0.24,-0.048826,0.10436},
      {0.071779,0.14873,0.20768,0.0043778,0.0008264,-0.1338,-0.12521,0.15924,0.03867,0.060117},
      {0.054911,0.22382,0.10421,0.005921,0.0062598,-0.16571,-0.17724,0.10625,0.094736,0.027454},
      {0.03376,0.30682,0.023705,0.0071746,0.013022,-0.16487,-0.2276,0.082515,0.12537,0.021211},
      {0.02027,0.3874,-0.063095,0.0080247,0.016665,-0.15918,-0.27686,0.056402,0.1658,0.023145},
      {0.012424,0.39095,-0.10007,0.0072743,0.034379,-0.12837,-0.27585,0.074247,0.1466,0.025421},
      {0.0073714,0.38504,-0.13632,0.0064141,0.046742,-0.095159,-0.27178,0.095601,0.12435,0.03649},
      {0.0039242,0.37347,-0.17581,0.0054834,0.061521,-0.053974,-0.26356,0.12092,0.098105,0.050388},
      {0.0026219,0.30542,-0.21366,0.0040055,0.10806,-0.014695,-0.21554,0.14852,0.045054,0.016581},
      {0.0015964,0.24152,-0.26484,0.0026839,0.14347,0.026637,-0.17052,0.18543,-0.012373,0.00033618},
      {0.00085379,0.18302,-0.32627,0.0015676,0.16823,0.068839,-0.12938,0.22946,-0.072021,-1.76E-05},
      {0.00061077,0.13749,-0.34201,0.00068351,0.20341,0.093352,-0.09727,0.24127,-0.10227,-0.030152},
      {0.00039192,0.09509,-0.36485,0.00050533,0.22881,0.11408,-0.067464,0.25746,-0.13488,-0.049415},
      {0.00022965,0.059899,-0.39289,0.00029473,0.24307,0.12995,-0.042741,0.27734,-0.16642,-0.056716},
      {0.00014548,0.03941,-0.41306,3.35E-05,0.24725,0.13647,-0.028293,0.29161,-0.18676,-0.057292},
      {9.98E-05,0.027773,-0.42398,-0.00022761,0.24895,0.13837,-0.020007,0.29931,-0.19814,-0.058168},
      {6.35E-05,0.017999,-0.43606,-0.00043022,0.24808,0.13923,-0.013017,0.30785,-0.20915,-0.05621},
      {3.82E-05,0.010121,-0.45089,-0.00055166,0.24303,0.13813,-0.007354,0.31837,-0.22057,-0.04986},
      {7.19E-05,0.0052218,-0.46161,-0.00063465,0.23797,0.13597,-0.003796,0.32594,-0.22841,-0.044384},
      {0.00011722,0.003184,-0.46399,-0.00067351,0.23772,0.13591,-0.0022752,0.32761,-0.23064,-0.044067},
      {0.00014405,0.0017365,-0.4665,-0.00069149,0.23687,0.13562,-0.0011918,0.32938,-0.23264,-0.043093},
      {0.00014965,0.00077402,-0.47065,-0.00069175,0.23404,0.13432,-0.0004738,0.33233,-0.23521,-0.040104},
      {0.00014935,0.00027744,-0.4739,-0.00064225,0.23168,0.13329,-0.0001023,0.33465,-0.23706,-0.037574},
      {0.00012373,0.00013585,-0.46756,-0.00048831,0.23836,0.13715,-1.48E-05,0.33028,-0.2339,-0.043964},
      {1.02E-05,5.37E-05,-0.4601,-0.00030649,0.24626,0.14176,-3.29E-05,0.32513,-0.23018,-0.051483},
      {-8.91E-08,1.56E-05,-0.45283,-0.00016136,0.25378,0.14616,-1.21E-05,0.32009,-0.22649,-0.058632},
      {0.0097357,0.00566,0.67839,-0.00015829,-0.00037469,-0.0039366,0.00021942,0.48082,-0.33061,0.18065},
      {0.011573,0.0056202,0.67371,-0.00012591,-0.00045284,-0.0052012,0.00044464,0.47731,-0.32662,0.17947},
      {0.013805,0.0055899,0.66751,-7.33E-05,-0.00055606,-0.0071142,0.00057453,0.47266,-0.32143,0.1777},
      {0.015876,0.005611,0.66069,2.62E-06,-0.00066772,-0.0096975,0.00040641,0.46751,-0.31589,0.17537},
      {0.021943,0.010021,0.62493,0.00048408,-0.00095631,-0.023155,-0.006277,0.44181,-0.28766,0.16346},
      {0.027995,0.016908,0.57665,0.001194,-0.0012617,-0.045303,-0.015865,0.40741,-0.25137,0.14422},
      {0.032059,0.025058,0.5281,0.0019373,-0.0015153,-0.074286,-0.0242,0.3732,-0.21795,0.11937},
      {0.032346,0.080876,0.40621,0.003345,-0.00040798,-0.12903,-0.064744,0.29419,-0.13445,0.071407},
      {0.030365,0.14987,0.26333,0.0050796,0.00083788,-0.20111,-0.11086,0.20296,-0.040427,0.009559},
      {0.02437,0.22405,0.13212,0.0065479,0.0031783,-0.2594,-0.15666,0.12777,0.038564,-0.040909},
      {0.018697,0.28336,0.038025,0.0064965,0.0065098,-0.25858,-0.19967,0.091046,0.088966,-0.044082},
      {0.014227,0.33514,-0.0437,0.0063577,0.0083107,-0.25732,-0.23661,0.060758,0.13192,-0.044597},
      {0.0098565,0.34603,-0.092341,0.0056641,0.017434,-0.22939,-0.24414,0.069351,0.12734,-0.033309},
      {0.0061272,0.34727,-0.13571,0.0047843,0.025442,-0.18283,-0.24479,0.096659,0.10551,-0.0051051},
      {0.0034316,0.35406,-0.18559,0.0038498,0.028278,-0.12666,-0.24943,0.12964,0.083613,0.038206},
      {0.0022806,0.29325,-0.23808,0.0024111,0.064113,-0.080413,-0.20655,0.16732,0.027115,0.02547},
      {0.0014473,0.22902,-0.3046,0.0012023,0.092816,-0.032547,-0.16138,0.21497,-0.037954,0.02418},
      {0.00079729,0.16731,-0.38384,0.00095619,0.11187,0.018532,-0.1182,0.27084,-0.10838,0.039251},
      {0.00051019,0.12054,-0.41457,0.00077337,0.14063,0.048908,-0.085361,0.29256,-0.1471,0.023179},
      {0.00033235,0.082432,-0.4379,0.00053598,0.16264,0.069302,-0.058576,0.30913,-0.17775,0.008497},
      {0.00020216,0.051246,-0.46737,0.00028918,0.17278,0.084297,-0.03666,0.33005,-0.20797,0.0063764},
      {0.00012323,0.030661,-0.49233,3.43E-05,0.17487,0.092505,-0.022145,0.34774,-0.2307,0.0102},
      {8.10E-05,0.020259,-0.5009,-0.00020051,0.17813,0.095715,-0.014697,0.35381,-0.24029,0.0081757},
      {5.01E-05,0.01177,-0.51246,-0.00035259,0.17697,0.096827,-0.0085882,0.362,-0.25039,0.010773},
      {3.08E-05,0.0065703,-0.5178,-0.00046685,0.17898,0.10019,-0.0048294,0.36577,-0.25575,0.010673},
      {5.03E-05,0.0037039,-0.52082,-0.00053058,0.17994,0.1019,-0.0027199,0.3679,-0.25874,0.010701},
      {8.66E-05,0.0021642,-0.51902,-0.00055989,0.18344,0.10406,-0.00156,0.36662,-0.25863,0.0074755},
      {0.0001012,0.0011152,-0.5191,-0.00057074,0.18471,0.10509,-0.00077004,0.36667,-0.25922,0.0064974},
      {9.15E-05,0.00045839,-0.5225,-0.0005661,0.18246,0.10424,-0.000283,0.36908,-0.26126,0.0090366},
      {6.10E-05,0.00013996,-0.52536,-0.00051297,0.18044,0.10353,-6.22E-05,0.37113,-0.26284,0.011338},
      {1.39E-06,5.64E-05,-0.51509,-0.00034469,0.19105,0.10967,-4.11E-05,0.36399,-0.25769,0.0011929},
      {-1.97E-07,2.33E-05,-0.50149,-0.00020088,0.20482,0.11761,-1.78E-05,0.35447,-0.25084,-0.011998},
      {0.0023269,0.0034483,0.69697,-0.00011693,-5.78E-05,-0.0023724,-0.00093188,0.49302,-0.34557,0.18247},
      {0.0031144,0.0035782,0.69384,-9.14E-05,-0.00010198,-0.0038192,-0.00099718,0.49076,-0.34325,0.18118},
      {0.0041402,0.0038037,0.6894,-5.30E-05,-0.00016064,-0.0060837,-0.0011151,0.48755,-0.34002,0.17919},
      {0.0052196,0.0041647,0.68391,-1.69E-06,-0.00022374,-0.0092911,-0.0013045,0.48361,-0.33619,0.17639},
      {0.00611,0.0047137,0.67781,6.13E-05,-0.00027639,-0.013585,-0.0015779,0.47923,-0.33221,0.17269},
      {0.0079791,0.0091228,0.65252,0.00042981,-0.00038018,-0.030745,-0.0051624,0.46143,-0.31561,0.15808},
      {0.0095627,0.018258,0.60899,0.0011166,-0.00044247,-0.06416,-0.011329,0.43098,-0.28867,0.12989},
      {0.010716,0.027817,0.5553,0.001744,-0.00049465,-0.11029,-0.017468,0.3935,-0.25713,0.091182},
      {0.013352,0.071682,0.42289,0.0028021,-0.00011165,-0.18913,-0.049374,0.3063,-0.17107,0.024271},
      {0.015602,0.12551,0.2624,0.0038733,0.00029367,-0.28596,-0.088487,0.20147,-0.067779,-0.057491},
      {0.016329,0.17243,0.11408,0.0045585,0.00070804,-0.38032,-0.12247,0.10658,0.023642,-0.13675},
      {0.012652,0.22448,0.03569,0.004483,0.0025742,-0.37468,-0.15903,0.078102,0.065755,-0.13361},
      {0.0098547,0.26849,-0.03015,0.0042113,0.0034089,-0.36799,-0.18946,0.056442,0.099895,-0.12816},
      {0.0072091,0.29037,-0.081212,0.0035487,0.0068163,-0.33912,-0.20421,0.061649,0.10453,-0.10807},
      {0.0046039,0.29776,-0.13239,0.0025895,0.010807,-0.27893,-0.20912,0.095491,0.082297,-0.063051},
      {0.0028447,0.30881,-0.19313,0.0016678,0.011829,-0.20403,-0.21685,0.1371,0.05744,-0.0018874},
      {0.0018656,0.26691,-0.26103,0.0011875,0.033054,-0.14121,-0.18769,0.18469,0.0026724,0.019872},
      {0.0011936,0.20165,-0.33836,0.0010965,0.057064,-0.087627,-0.14206,0.23906,-0.06864,0.029889},
      {0.00067581,0.14498,-0.42574,0.0010018,0.070267,-0.030893,-0.10242,0.30057,-0.14063,0.058031},
      {0.00039254,0.10076,-0.47985,0.00080859,0.087166,0.0088019,-0.071422,0.33877,-0.18972,0.066712},
      {0.00025236,0.067081,-0.50549,0.00052881,0.10379,0.027623,-0.047745,0.357,-0.21926,0.058468},
      {0.00015241,0.040256,-0.53767,0.00026168,0.10817,0.04079,-0.028883,0.37985,-0.24863,0.063105},
      {8.83E-05,0.02117,-0.57203,2.11E-05,0.10256,0.048177,-0.015431,0.40422,-0.27524,0.077291},
      {5.25E-05,0.013561,-0.57037,-0.00015657,0.11393,0.056787,-0.0099338,0.40306,-0.27834,0.068096},
      {3.11E-05,0.0084894,-0.56775,-0.00027872,0.12387,0.0648,-0.006255,0.4012,-0.27967,0.060475},
      {1.86E-05,0.0047412,-0.57174,-0.00036856,0.1259,0.068303,-0.0035228,0.40401,-0.28361,0.060459},
      {2.82E-05,0.0024295,-0.57542,-0.00042121,0.12612,0.070053,-0.0018132,0.4066,-0.28664,0.061596},
      {5.29E-05,0.0013328,-0.57084,-0.00044194,0.13204,0.073707,-0.00097766,0.40335,-0.28492,0.056123},
      {5.29E-05,0.00062853,-0.56983,-0.00044665,0.13419,0.075352,-0.00044578,0.40263,-0.28479,0.054405},
      {2.58E-05,0.00022487,-0.57371,-0.00043816,0.13133,0.074306,-0.00015495,0.40538,-0.28695,0.057637},
      {-2.70E-07,5.23E-05,-0.57519,-0.00038438,0.13063,0.074467,-3.95E-05,0.40646,-0.28777,0.058775},
      {-3.65E-07,2.94E-05,-0.55411,-0.00023036,0.15181,0.086598,-2.23E-05,0.39166,-0.27716,0.038416},
      {0.0011352,0.0018324,0.7003,-0.00029172,2.31E-05,-0.0028489,-0.00026496,0.49508,-0.34867,0.18214},
      {0.0012886,0.001929,0.69968,-0.00019786,2.26E-05,-0.0034073,-0.00029081,0.49471,-0.34823,0.18166},
      {0.0015665,0.0021532,0.69761,-9.44E-05,1.37E-05,-0.0051867,-0.00037276,0.49332,-0.34693,0.18015},
      {0.0020438,0.0026318,0.69203,-5.61E-05,-1.69E-05,-0.0099583,-0.00059031,0.48936,-0.34362,0.1761},
      {0.0025843,0.0031728,0.68432,-1.25E-05,-5.29E-05,-0.016949,-0.00085418,0.4839,-0.33917,0.17019},
      {0.0031455,0.003734,0.67393,3.30E-05,-9.20E-05,-0.026911,-0.0011548,0.47657,-0.33335,0.16179},
      {0.0041017,0.0069418,0.64498,0.00023817,-0.00016392,-0.053034,-0.0034938,0.45626,-0.31662,0.13984},
      {0.005601,0.01515,0.5793,0.00070108,-0.00029026,-0.11203,-0.0097174,0.41038,-0.27862,0.090396},
      {0.0067073,0.023424,0.50069,0.0010924,-0.00040084,-0.18664,-0.016138,0.35549,-0.23443,0.028047},
      {0.0079733,0.052263,0.37816,0.0017166,-0.00031387,-0.28033,-0.037263,0.27338,-0.16057,-0.050359},
      {0.0090859,0.093447,0.2309,0.0023802,-0.00017008,-0.38458,-0.066971,0.17646,-0.070294,-0.1374},
      {0.0093951,0.12638,0.092223,0.0027156,-0.00012164,-0.49408,-0.090457,0.08471,0.011414,-0.22828},
      {0.0074372,0.16847,0.024056,0.0025095,0.00067143,-0.49456,-0.11923,0.058953,0.048079,-0.22876},
      {0.0060011,0.20586,-0.025127,0.0021507,0.00097955,-0.47765,-0.14421,0.047557,0.072655,-0.2142},
      {0.0048235,0.23214,-0.068063,0.001326,0.0016076,-0.4465,-0.16157,0.052331,0.081193,-0.18842},
      {0.0033325,0.24383,-0.1293,0.0010902,0.0044713,-0.36379,-0.17035,0.093915,0.056562,-0.12373},
      {0.0022231,0.2506,-0.19767,0.0011927,0.0062112,-0.27781,-0.17579,0.1408,0.025895,-0.054881},
      {0.0014288,0.22781,-0.27427,0.0011997,0.015154,-0.20277,-0.16019,0.19414,-0.023735,-0.0054464},
      {0.00090189,0.16894,-0.36129,0.0010605,0.031237,-0.1441,-0.11901,0.25541,-0.096627,0.020172},
      {0.00050531,0.11812,-0.45705,0.00093436,0.038451,-0.08108,-0.083452,0.3229,-0.16984,0.062118},
      {0.00025786,0.077177,-0.5381,0.00076943,0.043674,-0.026734,-0.054766,0.38008,-0.23072,0.099721},
      {0.00015283,0.04835,-0.56701,0.00046638,0.053507,-0.010271,-0.034494,0.40064,-0.25944,0.099265},
      {8.14E-05,0.027765,-0.59682,0.0001997,0.056143,0.0042984,-0.019991,0.42184,-0.28449,0.10757},
      {4.51E-05,0.015489,-0.61867,4.00E-05,0.058965,0.019772,-0.011354,0.43733,-0.30145,0.11635},
      {2.39E-05,0.0097989,-0.6142,-9.56E-05,0.072465,0.031083,-0.0072473,0.43416,-0.30215,0.10634},
      {1.15E-05,0.0059099,-0.61259,-0.0001993,0.080249,0.037905,-0.0044099,0.43301,-0.30337,0.10082},
      {5.88E-06,0.0031368,-0.61711,-0.00027031,0.080874,0.040707,-0.0023707,0.43619,-0.30707,0.10224},
      {8.91E-06,0.0013961,-0.62395,-0.00030817,0.07793,0.041239,-0.0010702,0.44101,-0.31139,0.10691},
      {1.94E-05,0.00068569,-0.61804,-0.00032128,0.084914,0.045623,-0.00052191,0.43683,-0.30882,0.10052},
      {2.30E-06,0.00027189,-0.61728,-0.00032086,0.086655,0.047178,-0.0002123,0.43629,-0.30867,0.099307},
      {-1.79E-06,0.00012971,-0.61206,-0.00029622,0.092506,0.051027,-0.000103,0.4326,-0.30612,0.094095},
      {-6.05E-07,3.33E-05,-0.60932,-0.0002458,0.096084,0.053856,-2.51E-05,0.43069,-0.30477,0.091302},
      {0.00056712,0.0010075,0.69852,-0.00063738,4.16E-05,-0.0060142,0.00010267,0.4936,-0.34853,0.17952},
      {0.00068418,0.0010588,0.69753,-0.00052892,4.16E-05,-0.007099,9.38E-05,0.49299,-0.34794,0.1786},
      {0.00085673,0.0011295,0.69594,-0.00036586,4.18E-05,-0.008866,8.35E-05,0.49199,-0.347,0.17712},
      {0.0010802,0.0012116,0.69358,-0.00014921,4.23E-05,-0.011501,7.57E-05,0.49051,-0.34564,0.17491},
      {0.0014466,0.0015524,0.68461,-7.36E-05,1.80E-05,-0.020663,-0.00012297,0.48422,-0.34076,0.16721},
      {0.0018621,0.0019816,0.67107,-3.89E-05,-1.47E-05,-0.034718,-0.00040174,0.47467,-0.33352,0.15542},
      {0.0022701,0.0024098,0.65346,-3.95E-06,-4.74E-05,-0.053432,-0.00070452,0.46226,-0.32425,0.13975},
      {0.0027529,0.0043044,0.62008,9.27E-05,-9.18E-05,-0.087716,-0.0021824,0.43883,-0.30631,0.1111},
      {0.0034746,0.011997,0.53465,0.00040069,-0.00017602,-0.17203,-0.0082218,0.37916,-0.25933,0.040785},
      {0.0038512,0.019645,0.43451,0.00064223,-0.00022383,-0.27428,-0.014265,0.30922,-0.20535,-0.044324},
      {0.0041681,0.037174,0.3152,0.00096171,-0.00022903,-0.38431,-0.027071,0.22775,-0.13855,-0.13583},
      {0.0045028,0.066579,0.18814,0.0012697,-0.00016487,-0.48671,-0.047612,0.14345,-0.064181,-0.22071},
      {0.0043118,0.088611,0.072094,0.0012211,-6.69E-05,-0.59032,-0.062316,0.066015,0.00096383,-0.30614},
      {0.0036019,0.1201,0.010178,0.00079278,0.00019256,-0.60246,-0.083232,0.039882,0.03394,-0.31559},
      {0.0035453,0.15494,-0.02245,0.00083946,0.00028819,-0.56485,-0.10758,0.038332,0.052156,-0.28451},
      {0.0034305,0.18217,-0.049436,0.00086765,0.00034474,-0.53287,-0.12665,0.038776,0.065207,-0.25804},
      {0.002407,0.19067,-0.11877,0.00095531,0.0021565,-0.44385,-0.13326,0.086168,0.035102,-0.18677},
      {0.0015883,0.19307,-0.19526,0.001027,0.0030498,-0.35402,-0.13542,0.13917,-0.0018316,-0.11351},
      {0.00097633,0.18369,-0.2787,0.0010453,0.0046286,-0.26777,-0.12914,0.19747,-0.048179,-0.044209},
      {0.00058151,0.13135,-0.37488,0.00087895,0.013586,-0.20308,-0.092513,0.26527,-0.12234,-0.0033738},
      {0.00029685,0.086638,-0.47855,0.00074067,0.015588,-0.13269,-0.061215,0.33837,-0.1964,0.052165},
      {0.00012005,0.051414,-0.5846,0.00062399,0.015253,-0.052387,-0.036543,0.41323,-0.26691,0.11928},
      {6.33E-05,0.033357,-0.60461,0.0003905,0.026735,-0.030755,-0.023854,0.42748,-0.28582,0.12073},
      {2.87E-05,0.020722,-0.624,0.00021954,0.032819,-0.012888,-0.014976,0.44122,-0.30172,0.12681},
      {8.15E-06,0.01146,-0.64408,7.39E-05,0.033664,0.00054973,-0.0084487,0.45542,-0.31627,0.13675},
      {-2.21E-06,0.0064935,-0.64814,-4.21E-05,0.04,0.01009,-0.0048799,0.45828,-0.3208,0.13556},
      {-6.75E-06,0.0036778,-0.64787,-0.00012527,0.04546,0.01567,-0.0028061,0.45807,-0.32214,0.13234},
      {-6.77E-06,0.0017787,-0.65323,-0.0001756,0.044516,0.017728,-0.0013882,0.46184,-0.3258,0.13541},
      {-4.00E-06,0.00064124,-0.66365,-0.00019284,0.037938,0.01676,-0.00051516,0.46919,-0.33159,0.14405},
      {-4.93E-06,0.00036074,-0.6531,-0.00020138,0.049208,0.023686,-0.00028852,0.46171,-0.32648,0.13361},
      {-4.07E-06,0.00022762,-0.6422,-0.00019536,0.060436,0.030348,-0.00018421,0.45401,-0.32109,0.12301},
      {-2.77E-06,0.00011656,-0.63747,-0.00016992,0.065891,0.034129,-9.53E-05,0.45067,-0.31877,0.11831},
      {0.00017295,0.00052036,0.69766,-0.00087661,5.24E-05,-0.0076281,0.00028794,0.49289,-0.34865,0.17819},
      {0.00026411,0.00054203,0.69625,-0.00077547,5.28E-05,-0.0092449,0.00029004,0.49198,-0.34787,0.17684},
      {0.00039952,0.0005712,0.694,-0.00062584,5.34E-05,-0.011829,0.00029508,0.49052,-0.34665,0.17468},
      {0.00057496,0.00060496,0.69069,-0.00043748,5.49E-05,-0.015615,0.00030447,0.48836,-0.34488,0.17151},
      {0.00077828,0.00064289,0.68597,-0.00023132,5.87E-05,-0.020988,0.00031487,0.48523,-0.34239,0.16702},
      {0.0010329,0.00082187,0.67411,-9.99E-05,5.07E-05,-0.034037,0.00019387,0.47698,-0.33624,0.15611},
      {0.0013149,0.0011689,0.6518,-7.20E-05,2.93E-05,-0.058501,-9.75E-05,0.46127,-0.32474,0.13567},
      {0.001567,0.0015055,0.62362,-3.11E-05,1.32E-05,-0.089805,-0.00040559,0.44142,-0.31033,0.10954},
      {0.0017722,0.0022333,0.58481,2.92E-05,4.46E-06,-0.13283,-0.0010421,0.41411,-0.29046,0.073672},
      {0.0019214,0.0089746,0.48202,0.00023247,-2.56E-05,-0.24037,-0.0063024,0.34222,-0.23587,-0.015733},
      {0.0018165,0.015325,0.36716,0.00037018,1.44E-05,-0.36347,-0.01116,0.26184,-0.17576,-0.11789},
      {0.0015723,0.025073,0.24495,0.00042176,0.00015335,-0.49132,-0.018011,0.17715,-0.11124,-0.22371},
      {0.0019338,0.045627,0.14545,0.00051886,0.0001246,-0.57584,-0.031989,0.11073,-0.054024,-0.29359},
      {0.0021624,0.062441,0.059451,0.00059924,7.96E-05,-0.6507,-0.043454,0.052967,-0.0048425,-0.35547},
      {0.0022297,0.086319,0.0078032,0.00064853,9.81E-05,-0.66322,-0.060029,0.028443,0.024282,-0.3658},
      {0.0022051,0.11443,-0.017996,0.00066943,0.00015587,-0.62841,-0.079675,0.029913,0.037123,-0.33698},
      {0.0021199,0.13526,-0.039217,0.00065999,0.0001792,-0.60004,-0.094252,0.032681,0.045443,-0.31348},
      {0.0015441,0.14127,-0.10324,0.00069522,0.00081672,-0.52395,-0.098785,0.074829,0.018175,-0.25126},
      {0.00096368,0.13856,-0.18726,0.00071966,0.0011239,-0.43147,-0.097189,0.13352,-0.025107,-0.17496},
      {0.0005578,0.1297,-0.27883,0.00070259,0.0010529,-0.33726,-0.09113,0.19792,-0.075315,-0.096685},
      {0.00029685,0.091035,-0.38217,0.00053675,0.0045996,-0.25749,-0.064074,0.27087,-0.1462,-0.035585},
      {0.00013804,0.059734,-0.4864,0.00047664,0.0066222,-0.17054,-0.042196,0.34439,-0.21385,0.033651},
      {4.06E-05,0.037381,-0.58704,0.00050571,0.0076668,-0.078885,-0.026609,0.41531,-0.27526,0.1082},
      {-1.19E-06,0.02338,-0.6258,0.00037888,0.013187,-0.041236,-0.016803,0.44268,-0.30151,0.1315},
      {-1.90E-05,0.014045,-0.64393,0.00022293,0.016401,-0.026035,-0.010235,0.4555,-0.31512,0.13949},
      {-2.53E-05,0.0074903,-0.66196,9.59E-05,0.01579,-0.014401,-0.0055993,0.46822,-0.32729,0.15002},
      {-2.45E-05,0.0037197,-0.67196,1.37E-06,0.016669,-0.006159,-0.0028847,0.47525,-0.33414,0.15559},
      {-2.27E-05,0.0018593,-0.67327,-5.95E-05,0.01972,-0.0018152,-0.0014905,0.47615,-0.33576,0.15481},
      {-1.67E-05,0.00093274,-0.67627,-9.03E-05,0.020195,0.0011002,-0.00076266,0.47824,-0.33774,0.15655},
      {-9.74E-06,0.00052343,-0.67789,-0.00010558,0.021252,0.0040928,-0.00042643,0.47934,-0.33875,0.15751},
      {-6.93E-06,0.00033103,-0.66889,-0.00011179,0.031144,0.010519,-0.00027119,0.47296,-0.33435,0.14863},
      {-5.59E-06,0.00021216,-0.66067,-0.00010193,0.039846,0.0159,-0.0001772,0.46714,-0.33029,0.1406},
      {-0.00018259,0.00028081,0.69828,-0.0011649,7.19E-05,-0.0069228,0.00035688,0.49325,-0.3494,0.17878},
      {-0.00011234,0.00028912,0.69628,-0.0010726,7.37E-05,-0.0092356,0.00035794,0.49192,-0.34835,0.17685},
      {-7.56E-06,0.00030022,0.69311,-0.00093502,7.67E-05,-0.012902,0.00035985,0.48982,-0.34671,0.17379},
      {0.00013036,0.00031236,0.68854,-0.00075473,8.10E-05,-0.018174,0.00036301,0.48678,-0.34435,0.16939},
      {0.00029673,0.00032307,0.68232,-0.00053976,8.69E-05,-0.025335,0.00036798,0.48262,-0.34117,0.16342},
      {0.00048398,0.00032952,0.67415,-0.00030425,9.48E-05,-0.034718,0.00037544,0.47712,-0.33702,0.15559},
      {0.00067747,0.00039024,0.65962,-0.00010658,0.00010124,-0.051231,0.00032386,0.46711,-0.32967,0.14183},
      {0.00084005,0.00065512,0.62601,-4.48E-05,0.00010335,-0.089176,5.44E-05,0.44344,-0.31264,0.11021},
      {0.00096135,0.00090698,0.58492,7.35E-06,0.00012145,-0.13587,-0.00021402,0.41447,-0.29191,0.071338},
      {0.0010554,0.0011548,0.53178,2.86E-05,0.00014292,-0.19619,-0.00048894,0.37713,-0.26531,0.021158},
      {0.0010174,0.0062106,0.42008,0.00013462,0.00015823,-0.31723,-0.0043263,0.29897,-0.20745,-0.079255},
      {0.00094429,0.011058,0.30245,0.0002381,0.00016715,-0.44572,-0.0079972,0.21649,-0.14667,-0.18582},
      {0.00087416,0.016111,0.18802,0.00032631,0.00016492,-0.57056,-0.011727,0.13623,-0.087411,-0.28931},
      {0.0010743,0.031461,0.11307,0.00039703,0.0001142,-0.63512,-0.022213,0.085828,-0.04415,-0.34265},
      {0.001166,0.043582,0.049199,0.00044045,5.87E-05,-0.69203,-0.030508,0.04252,-0.0075542,-0.38965},
      {0.0011786,0.058131,0.0052469,0.00045314,3.32E-05,-0.71489,-0.040589,0.018374,0.016694,-0.40849},
      {0.0011672,0.079401,-0.014842,0.00043511,5.65E-05,-0.6845,-0.055451,0.021991,0.024705,-0.38331},
      {0.0011407,0.093911,-0.032199,0.00038194,4.51E-05,-0.65963,-0.065571,0.02708,0.028347,-0.36269},
      {0.00087363,0.096615,-0.086393,0.00034558,0.00018486,-0.59867,-0.067562,0.062632,0.0043991,-0.31233},
      {0.00049974,0.08936,-0.18012,0.00029994,0.00022662,-0.49985,-0.062625,0.1286,-0.046057,-0.23038},
      {0.00026932,0.08291,-0.27949,0.00030807,0.00017799,-0.39288,-0.058203,0.19883,-0.099036,-0.14156},
      {0.00013315,0.06601,-0.38288,0.0003718,0.0016678,-0.29069,-0.046456,0.27178,-0.15918,-0.058928},
      {3.78E-05,0.043957,-0.48458,0.00040042,0.0030911,-0.19685,-0.031089,0.34342,-0.22094,0.016889},
      {-2.87E-05,0.026097,-0.58273,0.00041435,0.0034461,-0.10411,-0.018649,0.41258,-0.27883,0.093334},
      {-5.73E-05,0.014449,-0.6408,0.00034122,0.0049424,-0.048463,-0.010512,0.45352,-0.31356,0.13735},
      {-6.01E-05,0.0080379,-0.65728,0.00020514,0.0059925,-0.035577,-0.0059855,0.46514,-0.32488,0.14653},
      {-5.40E-05,0.0038564,-0.67292,0.00010127,0.0045466,-0.025448,-0.0030032,0.47613,-0.33467,0.15701},
      {-3.77E-05,0.0019789,-0.68321,2.99E-05,0.0040819,-0.017126,-0.0016145,0.48331,-0.34066,0.16458},
      {-2.96E-05,0.0012437,-0.6814,-1.51E-05,0.0085688,-0.012566,-0.0010352,0.48198,-0.34013,0.16191},
      {-2.22E-05,0.0008619,-0.68037,-4.18E-05,0.011662,-0.0090488,-0.00072626,0.4812,-0.3398,0.16039},
      {-1.42E-05,0.00052856,-0.68218,-5.16E-05,0.012605,-0.0059202,-0.00044739,0.48244,-0.34087,0.16163},
      {-8.99E-06,0.00031504,-0.67955,-5.05E-05,0.017176,-0.0014211,-0.00026705,0.48055,-0.33966,0.15879},
      {-0.0002574,0.00016211,0.69904,-0.00058416,8.32E-05,-0.0068966,0.00031433,0.49431,-0.34972,0.1788},
      {-0.00024847,0.00014697,0.69843,-0.00059389,8.71E-05,-0.0075349,0.00033382,0.4939,-0.34945,0.17826},
      {-0.00023216,0.00012573,0.6973,-0.00059111,9.29E-05,-0.0087493,0.00036178,0.49316,-0.34892,0.17725},
      {-0.00012462,0.00012563,0.69151,-0.00043955,9.85E-05,-0.015414,0.00036228,0.48925,-0.346,0.17169},
      {-7.48E-06,0.00013528,0.68299,-0.00035366,0.00010547,-0.02488,0.00036419,0.48351,-0.34184,0.16381},
      {0.00012666,0.0001452,0.67155,-0.00025645,0.00011397,-0.037528,0.00036483,0.47584,-0.33629,0.15328},
      {0.00027383,0.00015302,0.65662,-0.00014078,0.00012397,-0.053956,0.0003631,0.46587,-0.32911,0.13961},
      {0.00042654,0.00016271,0.63692,-1.14E-05,0.00013535,-0.075591,0.00035215,0.45273,-0.31967,0.12162},
      {0.00051851,0.00038296,0.58598,-9.50E-07,0.00014895,-0.13336,0.00010442,0.41697,-0.29421,0.073576},
      {0.00059465,0.00058959,0.52552,9.37E-06,0.00016504,-0.20235,-0.00014308,0.37437,-0.26394,0.016225},
      {0.00064881,0.00077296,0.45491,1.91E-05,0.00018366,-0.28342,-0.00038102,0.32442,-0.22849,-0.051141},
      {0.00059994,0.0039548,0.35313,9.18E-05,0.00018603,-0.39637,-0.0028006,0.25277,-0.17624,-0.14482},
      {0.00051434,0.0073775,0.24561,0.0001675,0.00017747,-0.51591,-0.0053766,0.17697,-0.12096,-0.24391},
      {0.00041694,0.010038,0.14145,0.00022293,0.0001612,-0.63307,-0.0073742,0.10329,-0.067586,-0.341},
      {0.0004966,0.020235,0.08378,0.00025461,0.0001028,-0.68574,-0.014371,0.06391,-0.034691,-0.38451},
      {0.00055509,0.028776,0.03838,0.00025522,3.27E-05,-0.72655,-0.020214,0.033028,-0.0086206,-0.41819},
      {0.00056556,0.036341,0.003168,0.00022115,-2.86E-05,-0.7537,-0.025413,0.011255,0.010534,-0.44058},
      {0.00057523,0.050827,-0.014045,0.00015752,-3.08E-05,-0.72751,-0.035507,0.017141,0.013649,-0.41885},
      {0.0005073,0.05846,-0.029078,3.99E-05,-5.96E-05,-0.70858,-0.040827,0.023592,0.012966,-0.4031},
      {0.00044323,0.064141,-0.068312,4.14E-05,-5.79E-05,-0.65941,-0.04484,0.04963,-0.0026137,-0.36236},
      {0.00027945,0.062746,-0.16991,0.00014978,1.78E-05,-0.54344,-0.043975,0.12142,-0.054219,-0.26626},
      {0.00012782,0.058133,-0.27565,0.00024231,7.53E-05,-0.4263,-0.040835,0.19624,-0.10953,-0.16916},
      {6.95E-06,0.046786,-0.38221,0.00030133,0.00049046,-0.31559,-0.032967,0.27159,-0.16855,-0.077905},
      {-5.64E-05,0.029362,-0.48127,0.00031452,0.0010757,-0.22093,-0.02084,0.34136,-0.22666,-0.00020002},
      {-9.34E-05,0.015876,-0.5758,0.00031264,0.001045,-0.128,-0.011463,0.40797,-0.28053,0.076958},
      {-0.00010073,0.0071723,-0.64937,0.00027338,0.0010803,-0.05363,-0.0054071,0.45981,-0.32152,0.13862},
      {-8.52E-05,0.0038067,-0.66098,0.00016399,0.0016124,-0.043833,-0.0030018,0.46792,-0.32885,0.14598},
      {-6.58E-05,0.0019233,-0.67179,8.69E-05,0.0011553,-0.034926,-0.001623,0.47544,-0.33508,0.15402},
      {-4.62E-05,0.0015751,-0.67926,3.53E-05,0.00126,-0.027035,-0.0013395,0.48058,-0.33888,0.16041},
      {-3.65E-05,0.0012008,-0.67875,3.08E-06,0.0043772,-0.022906,-0.0010367,0.48015,-0.33879,0.15936},
      {-2.81E-05,0.00085247,-0.67929,-1.31E-05,0.0061896,-0.019755,-0.00074966,0.48048,-0.33923,0.15937},
      {-1.90E-05,0.00054704,-0.6824,-1.75E-05,0.0063799,-0.016403,-0.00048654,0.48263,-0.34094,0.16187},
      {-0.00027383,0.00015539,0.6968,-0.00035991,8.56E-05,-0.0090129,0.00022353,0.49343,-0.34895,0.17704},
      {-0.00027519,0.00014603,0.69574,-0.0003931,8.96E-05,-0.010018,0.00024153,0.49276,-0.3485,0.1762},
      {-0.0002775,0.00013177,0.69404,-0.00044355,9.58E-05,-0.011612,0.00026876,0.4917,-0.3478,0.17487},
      {-0.0002811,0.0001124,0.6916,-0.00051172,0.00010441,-0.013906,0.00030538,0.49018,-0.34678,0.17296},
      {-0.00026173,9.43E-05,0.68627,-0.00055325,0.00011445,-0.019361,0.00033802,0.48675,-0.34439,0.16841},
      {-0.00015188,9.47E-05,0.67167,-0.00044392,0.0001227,-0.035351,0.00032939,0.47707,-0.33744,0.15512},
      {-3.11E-05,9.35E-05,0.65311,-0.00031837,0.00013228,-0.055615,0.00031769,0.4648,-0.32864,0.13827},
      {9.57E-05,8.99E-05,0.62997,-0.00018008,0.00014299,-0.0808,0.00030233,0.44953,-0.31771,0.11734},
      {0.00022248,8.38E-05,0.60156,-3.41E-05,0.00015461,-0.11162,0.00028277,0.43083,-0.30435,0.091737},
      {0.00028296,0.00021666,0.54087,-4.06E-06,0.00017126,-0.18113,0.00010238,0.38808,-0.27401,0.033992},
      {0.00032007,0.00036246,0.46734,4.09E-06,0.00019865,-0.26615,-9.68E-05,0.33577,-0.23694,-0.036643},
      {0.00034692,0.00049193,0.38593,1.21E-05,0.00023854,-0.36077,-0.00028142,0.27762,-0.19575,-0.11524},
      {0.00031747,0.0022913,0.29371,5.25E-05,0.0002425,-0.46549,-0.0016491,0.21212,-0.14856,-0.20208},
      {0.00026246,0.0045116,0.2006,9.34E-05,0.00020963,-0.57069,-0.0032903,0.14609,-0.10079,-0.28924},
      {0.00020676,0.0060734,0.11096,0.00010985,0.00015953,-0.67317,-0.004433,0.082293,-0.054929,-0.37412},
      {0.00022585,0.011977,0.060397,9.81E-05,9.22E-05,-0.72392,-0.0084891,0.0472,-0.027181,-0.41605},
      {0.00022653,0.017313,0.02741,5.04E-05,2.73E-05,-0.75503,-0.012142,0.024621,-0.0085498,-0.44168},
      {0.00020257,0.02095,0.0020373,-1.14E-05,-3.12E-05,-0.77975,-0.01464,0.0071533,0.0056334,-0.46205},
      {0.00025791,0.03287,-0.013238,-5.52E-06,-5.91E-05,-0.75483,-0.022974,0.013827,0.0069336,-0.44141},
      {0.00028918,0.042525,-0.02819,2.23E-07,-8.59E-05,-0.72936,-0.029734,0.022461,0.0057095,-0.42031},
      {0.0002833,0.048611,-0.049527,1.15E-05,-0.00010714,-0.69977,-0.034011,0.03615,-0.00089348,-0.39581},
      {0.00013844,0.044247,-0.15725,0.00010205,-4.48E-05,-0.58003,-0.031044,0.11238,-0.057071,-0.29655},
      {5.06E-06,0.037689,-0.26884,0.00017444,4.86E-06,-0.45825,-0.026527,0.19144,-0.1163,-0.19558},
      {-0.00011033,0.028921,-0.38251,0.00022305,6.85E-05,-0.33658,-0.020459,0.27202,-0.17767,-0.094716},
      {-0.00013726,0.016334,-0.47655,0.00022082,0.00028299,-0.24292,-0.011719,0.33818,-0.23078,-0.017302},
      {-0.00013946,0.0077649,-0.56312,0.00020773,0.00032901,-0.15343,-0.0057794,0.39913,-0.27817,0.056892},
      {-0.00012067,0.0027961,-0.64235,0.0001859,0.00024284,-0.068359,-0.002351,0.45497,-0.32012,0.1276},
      {-0.00010038,0.0020386,-0.65371,0.00011772,0.00053151,-0.056188,-0.0018058,0.46283,-0.32602,0.13728},
      {-7.98E-05,0.0016947,-0.66079,6.57E-05,0.00069892,-0.048642,-0.0015315,0.46767,-0.32961,0.1433},
      {-5.83E-05,0.001455,-0.66848,3.01E-05,0.00072873,-0.040439,-0.0013121,0.47298,-0.3335,0.15006},
      {-4.38E-05,0.0011786,-0.67208,9.78E-06,0.0018367,-0.03499,-0.0010674,0.47545,-0.33542,0.15299},
      {-3.43E-05,0.00086067,-0.67417,1.30E-06,0.0026368,-0.031754,-0.00079814,0.47688,-0.33662,0.15452},
      {-0.00028517,0.00016234,0.69691,-0.00022429,8.51E-05,-0.0085875,0.00015244,0.49395,-0.34922,0.17739},
      {-0.00029634,0.00015369,0.69556,-0.0002526,9.03E-05,-0.0098162,0.00017346,0.49314,-0.34868,0.17637},
      {-0.00031527,0.00014061,0.69346,-0.0002951,9.85E-05,-0.011735,0.00020656,0.49188,-0.34782,0.17477},
      {-0.00034454,0.00012307,0.69049,-0.00035147,0.0001103,-0.014434,0.00025351,0.49011,-0.34661,0.17251},
      {-0.00038701,0.00010136,0.68654,-0.00042001,0.00012616,-0.018002,0.00031569,0.48778,-0.345,0.16953},
      {-0.00044517,7.61E-05,0.68151,-0.00049757,0.0001467,-0.02252,0.00039374,0.48484,-0.34297,0.16575},
      {-0.00038274,6.56E-05,0.66378,-0.00042868,0.00016412,-0.041475,0.0003986,0.47329,-0.33473,0.15},
      {-0.00025451,6.02E-05,0.63793,-0.00030175,0.00018117,-0.06948,0.00036095,0.45631,-0.32262,0.12673},
      {-0.00010493,5.44E-05,0.6071,-0.00017334,0.00019992,-0.10283,0.00030626,0.43608,-0.30822,0.099027},
      {5.99E-05,4.86E-05,0.57081,-5.10E-05,0.00021967,-0.14197,0.00023586,0.4123,-0.29133,0.066514},
      {0.00013665,0.00012561,0.5064,-9.10E-06,0.00025072,-0.21592,9.73E-05,0.36696,-0.25922,0.0051068},
      {0.00016129,0.00022721,0.42407,-1.93E-07,0.00028966,-0.31218,-5.58E-05,0.30786,-0.21739,-0.074822},
      {0.00017045,0.00030933,0.33355,7.64E-06,0.00033103,-0.41845,-0.00018643,0.24268,-0.17128,-0.16304},
      {0.00014664,0.0011592,0.24326,2.09E-05,0.00031983,-0.52322,-0.00083503,0.17793,-0.1251,-0.2499},
      {0.00010394,0.0023364,0.16111,2.23E-05,0.0002512,-0.61784,-0.0016836,0.11928,-0.08306,-0.32822},
      {6.49E-05,0.003019,0.084243,2.78E-06,0.00017563,-0.70741,-0.0021652,0.064135,-0.043732,-0.40232},
      {7.85E-05,0.006719,0.043202,-1.27E-06,0.00010036,-0.75063,-0.0047426,0.035103,-0.021338,-0.43806},
      {0.00010262,0.011686,0.022156,-5.79E-06,3.12E-05,-0.76823,-0.0081955,0.020841,-0.0087527,-0.45257},
      {0.0001155,0.015755,0.0034447,-9.76E-06,-3.54E-05,-0.78421,-0.011029,0.008201,0.0022338,-0.46576},
      {0.00013793,0.023284,-0.012297,-6.79E-06,-7.13E-05,-0.76914,-0.0163,0.012004,0.0033543,-0.45327},
      {0.00014501,0.029812,-0.027769,-2.50E-06,-9.82E-05,-0.74574,-0.020881,0.021595,-0.00011489,-0.4339},
      {0.00012815,0.033452,-0.043547,5.28E-07,-0.00012539,-0.72477,-0.023447,0.03177,-0.0054504,-0.41653},
      {1.51E-05,0.027694,-0.14414,5.74E-05,-7.80E-05,-0.61502,-0.019482,0.1029,-0.058652,-0.32554},
      {-9.47E-05,0.02034,-0.26102,0.00010758,-2.46E-05,-0.48807,-0.014408,0.18571,-0.12088,-0.22026},
      {-0.00018702,0.012878,-0.37799,0.00013962,2.15E-05,-0.36113,-0.0092603,0.26861,-0.18319,-0.11499},
      {-0.00019672,0.0054143,-0.46815,0.00013434,8.76E-05,-0.26602,-0.0040996,0.33216,-0.23186,-0.036163},
      {-0.00016766,0.0031129,-0.54532,0.00012468,0.00017155,-0.17991,-0.0025751,0.38649,-0.27141,0.035166},
      {-0.0001395,0.0021377,-0.6136,0.0001131,0.00024324,-0.10244,-0.0019777,0.43459,-0.30587,0.099337},
      {-0.00011677,0.0017191,-0.63873,7.73E-05,0.00037252,-0.074121,-0.0016899,0.4522,-0.31852,0.12264},
      {-9.43E-05,0.0014915,-0.64607,4.27E-05,0.00044449,-0.066247,-0.001484,0.45725,-0.32223,0.12907},
      {-7.11E-05,0.0013424,-0.65438,2.04E-05,0.00042702,-0.057273,-0.0013149,0.46301,-0.32642,0.13654},
      {-5.15E-05,0.0011795,-0.66149,8.72E-06,0.00059266,-0.049279,-0.0011312,0.46797,-0.33007,0.14293},
      {-0.00027279,0.00014156,0.70092,-7.76E-05,9.64E-05,-0.0045706,0.00011626,0.49667,-0.35105,0.18071},
      {-0.00029217,0.00013461,0.69943,-9.79E-05,0.00010324,-0.0058908,0.0001396,0.49581,-0.35045,0.1796},
      {-0.0003217,0.00012416,0.69709,-0.000128,0.00011395,-0.0079458,0.00017495,0.49448,-0.34953,0.17789},
      {-0.0003616,0.00011024,0.69382,-0.00016693,0.00012906,-0.010825,0.00022238,0.49261,-0.34823,0.17548},
      {-0.00041103,9.32E-05,0.68951,-0.00021251,0.00014907,-0.014608,0.00028077,0.49018,-0.34652,0.17231},
      {-0.00046765,7.37E-05,0.68406,-0.00026112,0.00017448,-0.019368,0.00034756,0.48713,-0.34439,0.16833},
      {-0.00052703,5.27E-05,0.67739,-0.00030764,0.00020581,-0.025175,0.0004183,0.48343,-0.34179,0.16347},
      {-0.00049296,3.79E-05,0.66099,-0.00029131,0.0002337,-0.041906,0.00042589,0.47318,-0.33453,0.14955},
      {-0.00031544,3.34E-05,0.62763,-0.00019093,0.0002487,-0.077909,0.00033449,0.45133,-0.31904,0.11966},
      {-0.00014196,3.00E-05,0.58876,-0.00010101,0.00026327,-0.11976,0.00024241,0.42588,-0.30103,0.08492},
      {1.14E-05,2.85E-05,0.54397,-3.06E-05,0.00027623,-0.16784,0.00015898,0.39659,-0.28031,0.045016},
      {7.78E-05,6.74E-05,0.47557,-3.01E-06,0.00030104,-0.24594,6.58E-05,0.34878,-0.24649,-0.019799},
      {8.04E-05,0.00012671,0.38484,3.54E-06,0.0003378,-0.35303,-2.85E-05,0.28314,-0.20007,-0.10867},
      {6.94E-05,0.00017746,0.29175,6.60E-06,0.00037281,-0.46359,-0.00010162,0.21537,-0.15215,-0.20041},
      {5.77E-05,0.0005575,0.20813,6.94E-06,0.00036133,-0.56251,-0.00039552,0.15453,-0.10894,-0.28242},
      {4.55E-05,0.0013951,0.14276,4.26E-06,0.00027091,-0.6388,-0.00099734,0.10731,-0.075124,-0.34553},
      {3.47E-05,0.0020815,0.078827,1.60E-06,0.0001769,-0.71388,-0.0014885,0.060939,-0.041983,-0.40765},
      {3.71E-05,0.0043276,0.035486,-1.67E-06,9.28E-05,-0.76216,-0.0030583,0.029841,-0.018859,-0.44758},
      {4.84E-05,0.0081398,0.018368,-5.45E-06,2.55E-05,-0.77654,-0.0057174,0.01836,-0.0088182,-0.45945},
      {5.11E-05,0.010942,0.0033305,-9.19E-06,-3.72E-05,-0.78928,-0.0076764,0.0085876,-0.00049433,-0.46997},
      {4.95E-05,0.014556,-0.012333,-9.64E-06,-7.58E-05,-0.78113,-0.010214,0.01096,-0.00033256,-0.46321},
      {3.22E-05,0.01737,-0.031046,-8.16E-06,-9.50E-05,-0.75752,-0.012202,0.023327,-0.0076268,-0.44365},
      {-5.02E-06,0.0175,-0.051774,-8.06E-06,-0.000109,-0.73437,-0.012319,0.037337,-0.017433,-0.42447},
      {-8.19E-05,0.012946,-0.13316,1.96E-05,-7.82E-05,-0.64562,-0.0091894,0.094794,-0.060316,-0.35088},
      {-0.00016407,0.0066587,-0.25011,5.10E-05,-2.79E-05,-0.51736,-0.0048662,0.17766,-0.12201,-0.24452},
      {-0.00021069,0.0043481,-0.36573,7.27E-05,9.55E-05,-0.3858,-0.0033626,0.25959,-0.18099,-0.13554},
      {-0.00020808,0.0029456,-0.45572,7.56E-05,0.0002056,-0.2834,-0.0024906,0.32314,-0.22656,-0.050733},
      {-0.00017848,0.0020833,-0.52369,6.82E-05,0.00029089,-0.20612,-0.0019724,0.37102,-0.26083,0.013266},
      {-0.00015447,0.0016353,-0.58406,5.85E-05,0.00032698,-0.13712,-0.0017395,0.41358,-0.29111,0.070462},
      {-0.00013343,0.0014646,-0.61935,4.08E-05,0.00034373,-0.096816,-0.001647,0.43843,-0.30876,0.10387},
      {-0.00010822,0.0013373,-0.62679,2.17E-05,0.00036139,-0.088763,-0.0014948,0.44357,-0.31251,0.11052},
      {-8.16E-05,0.0012702,-0.63496,1.20E-05,0.00036384,-0.079771,-0.0013642,0.44926,-0.31664,0.11797},
      {-0.00011072,8.52E-05,0.70616,0,8.84E-05,5.10E-05,2.13E-05,0.4998,-0.35331,0.18455},
      {-0.00011274,8.25E-05,0.70612,0,9.24E-05,5.33E-05,2.47E-05,0.49979,-0.35331,0.18455},
      {-0.00013252,7.51E-05,0.70363,-1.50E-05,0.00010503,-0.0020895,4.86E-05,0.49843,-0.35235,0.18275},
      {-0.00015645,6.53E-05,0.70014,-3.30E-05,0.00012279,-0.0050927,7.85E-05,0.49653,-0.35101,0.18024},
      {-0.00018092,5.35E-05,0.69556,-5.13E-05,0.00014613,-0.0090258,0.00011148,0.49406,-0.34927,0.17694},
      {-0.00020025,4.05E-05,0.68981,-6.60E-05,0.00017548,-0.013955,0.00014276,0.49097,-0.34709,0.17281},
      {-0.00020617,2.72E-05,0.68281,-7.18E-05,0.00021129,-0.019941,0.00016539,0.48726,-0.34447,0.1678},
      {-0.00018728,1.48E-05,0.67449,-6.19E-05,0.00025395,-0.027035,0.00016994,0.48289,-0.34138,0.16186},
      {-0.00012039,5.76E-06,0.66148,-2.65E-05,0.00029855,-0.039125,0.00013907,0.47553,-0.33617,0.15177},
      {-3.50E-05,8.42E-06,0.62053,-6.04E-07,0.00030348,-0.083148,9.56E-05,0.44864,-0.31716,0.11525},
      {-1.20E-06,1.35E-05,0.57496,-3.71E-07,0.0003041,-0.13215,8.53E-05,0.41862,-0.29593,0.074603},
      {3.06E-05,1.82E-05,0.5249,-1.51E-07,0.00030255,-0.18596,7.36E-05,0.38566,-0.27263,0.029983},
      {4.57E-05,3.94E-05,0.45893,8.43E-07,0.00031227,-0.26088,4.07E-05,0.33975,-0.24017,-0.032165},
      {3.88E-05,8.22E-05,0.37108,2.91E-06,0.00034202,-0.36591,-1.87E-05,0.27538,-0.19464,-0.1193},
      {3.25E-05,0.00011794,0.27981,4.73E-06,0.00037017,-0.47512,-7.02E-05,0.20845,-0.14731,-0.2099},
      {2.63E-05,0.00029738,0.19388,5.29E-06,0.00036578,-0.57766,-0.00021582,0.14553,-0.10274,-0.29492},
      {2.11E-05,0.00088234,0.13449,2.67E-06,0.00026547,-0.6478,-0.00063232,0.10225,-0.071827,-0.35295},
      {1.55E-05,0.0013301,0.075022,-3.02E-07,0.00016323,-0.71826,-0.00095213,0.058863,-0.040917,-0.41125},
      {1.25E-05,0.0023878,0.027886,-3.89E-06,7.21E-05,-0.77264,-0.0016962,0.024881,-0.016349,-0.45623},
      {1.42E-05,0.0047789,0.013896,-8.14E-06,1.19E-05,-0.78384,-0.0033702,0.016339,-0.0090996,-0.46547},
      {9.21E-06,0.0062302,0.0014241,-1.22E-05,-3.78E-05,-0.79367,-0.0043902,0.009303,-0.0033889,-0.47359},
      {-5.32E-06,0.007271,-0.01313,-1.45E-05,-6.72E-05,-0.79026,-0.0051311,0.010625,-0.0037835,-0.47075},
      {-3.83E-05,0.0074546,-0.035125,-1.48E-05,-7.61E-05,-0.76549,-0.0052861,0.025585,-0.014232,-0.45022},
      {-7.84E-05,0.0061044,-0.059604,-1.61E-05,-5.80E-05,-0.73924,-0.0043754,0.042514,-0.02684,-0.42851},
      {-0.00011,0.0053536,-0.12404,-5.06E-06,0.00013128,-0.66521,-0.0039155,0.088058,-0.05935,-0.36738},
      {-0.00015285,0.003708,-0.23938,1.69E-05,0.0003068,-0.53311,-0.0028808,0.16979,-0.11786,-0.25802},
      {-0.00019339,0.0023873,-0.34959,3.00E-05,0.00041067,-0.40676,-0.0020999,0.24784,-0.17357,-0.15334},
      {-0.00020881,0.001495,-0.4406,3.26E-05,0.00045194,-0.30248,-0.0016117,0.31219,-0.2194,-0.066885},
      {-0.00018366,0.0011734,-0.50036,2.65E-05,0.00049888,-0.234,-0.0014669,0.35432,-0.24934,-0.010136},
      {-0.00015907,0.0011839,-0.55046,2.50E-05,0.0005046,-0.17628,-0.0015392,0.38967,-0.27431,0.037734},
      {-0.00014034,0.0013155,-0.58974,2.18E-05,0.00042588,-0.13103,-0.001675,0.41739,-0.29383,0.075382},
      {-0.00011347,0.0012535,-0.59828,1.26E-05,0.00043478,-0.1216,-0.0015498,0.42334,-0.29815,0.083187},
      {-1.06E-05,8.68E-06,0.70639,0,8.28E-05,4.78E-05,2.96E-06,0.49993,-0.35349,0.18456},
      {-1.11E-05,8.78E-06,0.70635,0,8.73E-05,5.04E-05,3.34E-06,0.49992,-0.35349,0.18455},
      {-1.19E-05,8.94E-06,0.70629,0,9.42E-05,5.44E-05,3.90E-06,0.49992,-0.35348,0.18455},
      {-1.30E-05,9.15E-06,0.7062,0,0.0001038,5.99E-05,4.65E-06,0.49991,-0.35348,0.18454},
      {-1.65E-05,8.96E-06,0.70425,-3.95E-08,0.00012116,-0.0015376,9.21E-06,0.49891,-0.35277,0.18319},
      {-2.52E-05,7.88E-06,0.69828,-1.61E-07,0.00015119,-0.0066373,2.14E-05,0.49574,-0.35052,0.17892},
      {-3.53E-05,6.63E-06,0.69104,-3.03E-07,0.000186,-0.012853,3.52E-05,0.49189,-0.34778,0.17371},
      {-4.67E-05,5.25E-06,0.68247,-4.60E-07,0.0002249,-0.020264,5.03E-05,0.48729,-0.34453,0.16751},
      {-5.92E-05,3.77E-06,0.6725,-6.30E-07,0.00026693,-0.028956,6.61E-05,0.48191,-0.34071,0.16024},
      {-7.24E-05,2.22E-06,0.66108,-8.08E-07,0.00031079,-0.039026,8.20E-05,0.47568,-0.3363,0.15183},
      {-4.99E-05,5.45E-06,0.61939,-6.60E-07,0.00031087,-0.083765,7.37E-05,0.44828,-0.31693,0.11473},
      {-2.02E-05,8.99E-06,0.5709,-4.26E-07,0.00031365,-0.13633,6.25E-05,0.41609,-0.29417,0.071138},
      {1.03E-05,1.22E-05,0.51983,-1.29E-07,0.00030836,-0.19188,5.27E-05,0.38207,-0.27012,0.025078},
      {3.16E-05,2.26E-05,0.45851,5.64E-07,0.00029767,-0.26115,3.52E-05,0.33966,-0.24013,-0.032346},
      {3.00E-05,5.20E-05,0.37108,2.12E-06,0.00032181,-0.36603,-5.87E-06,0.27539,-0.19468,-0.11934},
      {2.58E-05,7.55E-05,0.27989,3.26E-06,0.00034061,-0.475,-4.13E-05,0.20862,-0.14746,-0.20973},
      {1.94E-05,0.00013257,0.18916,3.52E-06,0.00034038,-0.58298,-9.74E-05,0.14247,-0.10066,-0.29927},
      {1.30E-05,0.00049281,0.13066,7.58E-08,0.00023066,-0.65229,-0.00035627,0.099853,-0.070338,-0.3566},
      {6.26E-06,0.00073128,0.072425,-3.67E-06,0.00012877,-0.72137,-0.0005296,0.057467,-0.040242,-0.41375},
      {9.26E-08,0.0010213,0.020182,-7.69E-06,4.40E-05,-0.78274,-0.00073838,0.019744,-0.013417,-0.46454},
      {-5.18E-06,0.0022027,0.0086454,-1.18E-05,-3.04E-07,-0.79121,-0.0015709,0.013733,-0.0085665,-0.47152},
      {-1.42E-05,0.0025854,-0.0014706,-1.57E-05,-3.06E-05,-0.79815,-0.0018471,0.0092148,-0.0051737,-0.47725},
      {-2.37E-05,0.0029232,-0.013027,-1.88E-05,-3.85E-05,-0.7967,-0.0020991,0.0098282,-0.0054222,-0.47605},
      {-4.77E-05,0.0032838,-0.040023,-1.95E-05,7.88E-05,-0.76502,-0.0023906,0.028731,-0.018554,-0.44999},
      {-7.03E-05,0.003275,-0.070673,-2.04E-05,0.00036822,-0.72921,-0.0024342,0.05025,-0.033715,-0.42073},
      {-9.47E-05,0.0028145,-0.11893,-1.81E-05,0.00080127,-0.67322,-0.0021849,0.084294,-0.057943,-0.37492},
      {-0.00013447,0.0017406,-0.22836,-5.42E-06,0.00093343,-0.54743,-0.0015784,0.16179,-0.11314,-0.27075},
      {-0.00016632,0.0010309,-0.32842,4.11E-06,0.00099063,-0.43225,-0.0012401,0.2326,-0.16342,-0.17528},
      {-0.00018773,0.0005544,-0.41522,1.10E-05,0.00094373,-0.33241,-0.0010631,0.29399,-0.20694,-0.092383},
      {-0.00016344,0.00061681,-0.46523,1.14E-05,0.0009681,-0.27468,-0.0011669,0.32929,-0.23186,-0.044532},
      {-0.00014743,0.00082365,-0.51025,1.09E-05,0.00086581,-0.22268,-0.0013737,0.36109,-0.25422,-0.001255},
      {-0.00013951,0.0011604,-0.55031,9.90E-06,0.00060468,-0.17647,-0.0016757,0.3894,-0.27403,0.037445},
      {-5.45E-06,6.27E-06,0.70628,0,0.00035885,0.00020718,5.35E-07,0.49974,-0.35336,0.18429},
      {-5.77E-06,6.32E-06,0.7062,0,0.00040929,0.00023631,8.16E-07,0.4997,-0.35333,0.18425},
      {-6.25E-06,6.40E-06,0.70606,0,0.00049495,0.00028576,1.24E-06,0.49964,-0.35329,0.18416},
      {-6.87E-06,6.51E-06,0.70586,0,0.00062984,0.00036364,1.82E-06,0.49954,-0.35322,0.18403},
      {-7.62E-06,6.63E-06,0.70556,0,0.00083404,0.00048153,2.53E-06,0.4994,-0.35312,0.18384},
      {-8.43E-06,6.75E-06,0.70515,0,0.0011357,0.00065572,3.37E-06,0.49918,-0.35297,0.18355},
      {-1.29E-05,6.16E-06,0.70045,-6.58E-08,0.0013504,-0.0032547,1.00E-05,0.49656,-0.3511,0.18},
      {-1.99E-05,4.97E-06,0.69162,-1.85E-07,0.00139,-0.011332,2.14E-05,0.49156,-0.34756,0.17324},
      {-2.65E-05,3.73E-06,0.6814,-3.07E-07,0.0013351,-0.020988,3.32E-05,0.48569,-0.34341,0.16532},
      {-3.20E-05,2.47E-06,0.66974,-4.25E-07,0.0011279,-0.032425,4.48E-05,0.4789,-0.3386,0.15613},
      {-3.61E-05,1.25E-06,0.6566,-5.34E-07,0.000693,-0.045895,5.57E-05,0.4711,-0.33308,0.14559},
      {-2.00E-05,2.78E-06,0.62047,-3.58E-07,0.00047444,-0.085227,5.40E-05,0.44724,-0.31621,0.11329},
      {3.49E-06,5.28E-06,0.57179,-4.89E-08,0.00042475,-0.13859,4.77E-05,0.41461,-0.29314,0.06911},
      {2.47E-05,7.36E-06,0.52024,2.55E-07,0.00034759,-0.19531,4.24E-05,0.37996,-0.26863,0.02219},
      {3.99E-05,1.12E-05,0.46208,6.00E-07,0.00025241,-0.2605,3.48E-05,0.34014,-0.24048,-0.031727},
      {3.16E-05,2.86E-05,0.37173,1.15E-06,0.0002591,-0.36786,5.28E-06,0.27438,-0.19398,-0.12076},
      {2.22E-05,3.97E-05,0.27816,1.13E-06,0.0002576,-0.47861,-1.77E-05,0.20656,-0.14602,-0.21259},
      {1.21E-05,4.33E-05,0.1819,4.10E-07,0.00024598,-0.59204,-3.29E-05,0.13712,-0.096927,-0.30662},
      {5.36E-06,0.00020334,0.12352,-3.56E-06,0.00014953,-0.66116,-0.00015181,0.09476,-0.06689,-0.36381},
      {-4.67E-07,0.00026638,0.067885,-7.85E-06,6.77E-05,-0.72701,-0.00020239,0.054458,-0.038357,-0.41831},
      {-3.95E-06,0.00029863,0.014749,-1.20E-05,1.78E-05,-0.7898,-0.00023234,0.016013,-0.011152,-0.47031},
      {-8.50E-06,0.00092342,0.0039562,-1.57E-05,-1.46E-06,-0.79646,-0.00068127,0.011465,-0.0076127,-0.47583},
      {-1.27E-05,0.0013747,-0.004444,-1.92E-05,-1.33E-05,-0.79855,-0.0010113,0.0098374,-0.0062235,-0.47757},
      {-1.63E-05,0.0016294,-0.012661,-2.25E-05,-1.72E-05,-0.79871,-0.0012067,0.0095188,-0.005857,-0.47771},
      {-3.81E-05,0.0016232,-0.044306,-2.37E-05,0.00033983,-0.76182,-0.0012553,0.031628,-0.021433,-0.44765},
      {-5.54E-05,0.0014862,-0.07976,-2.48E-05,0.00097322,-0.71996,-0.0012238,0.056588,-0.039087,-0.41386},
      {-6.83E-05,0.0012373,-0.11776,-2.50E-05,0.0019392,-0.67469,-0.0011236,0.083364,-0.05808,-0.37771},
      {-9.80E-05,0.00069075,-0.21264,-1.50E-05,0.0020838,-0.56517,-0.00089049,0.15051,-0.1057,-0.28706},
      {-0.00012482,0.00025835,-0.30111,-6.70E-06,0.0020433,-0.46328,-0.00074874,0.2131,-0.15003,-0.20248},
      {-0.00014779,-7.93E-05,-0.38063,-7.63E-08,0.0018258,-0.37196,-0.00067986,0.26933,-0.18981,-0.12642},
      {-0.00013858,0.00010221,-0.42963,1.33E-06,0.0016878,-0.3154,-0.00088202,0.30395,-0.21417,-0.079313},
      {-0.00013226,0.00046931,-0.47092,2.59E-06,0.0015781,-0.26742,-0.0011961,0.33316,-0.23461,-0.039367},
      {-1.64E-06,3.48E-06,0.70551,0,0.0013371,0.00077199,-2.90E-07,0.49905,-0.35288,0.18336},
      {-1.79E-06,3.51E-06,0.70531,0,0.001512,0.00087294,-8.85E-08,0.49893,-0.35279,0.18319},
      {-2.01E-06,3.55E-06,0.70498,0,0.0017935,0.0010355,2.17E-07,0.49873,-0.35265,0.18292},
      {-2.29E-06,3.60E-06,0.70451,0,0.002207,0.0012742,6.29E-07,0.49843,-0.35244,0.18252},
      {-2.61E-06,3.65E-06,0.70386,0,0.0027846,0.0016077,1.14E-06,0.49802,-0.35215,0.18197},
      {-2.94E-06,3.70E-06,0.70298,0,0.0035671,0.0020594,1.74E-06,0.49747,-0.35176,0.18122},
      {-3.25E-06,3.73E-06,0.70184,0,0.0046059,0.0026592,2.41E-06,0.49674,-0.35124,0.18023},
      {-3.62E-06,3.71E-06,0.69996,-3.99E-09,0.00587,0.0029016,3.48E-06,0.49554,-0.35039,0.17861},
      {-6.18E-06,2.85E-06,0.68952,-8.49E-08,0.0053323,-0.0083131,1.17E-05,0.48924,-0.34593,0.17009},
      {-7.95E-06,2.00E-06,0.67757,-1.61E-07,0.0045288,-0.021639,1.97E-05,0.48192,-0.34075,0.16019},
      {-8.63E-06,1.19E-06,0.66403,-2.29E-07,0.0033705,-0.037357,2.69E-05,0.47352,-0.33481,0.14882},
      {-7.98E-06,4.58E-07,0.64884,-2.81E-07,0.0017499,-0.055796,3.31E-05,0.46394,-0.32803,0.13586},
      {1.18E-06,1.01E-06,0.61667,-1.65E-07,0.00068607,-0.092646,3.37E-05,0.4425,-0.31287,0.10683},
      {1.57E-05,2.42E-06,0.56682,7.22E-08,0.00055405,-0.1481,3.06E-05,0.40868,-0.28895,0.061038},
      {2.70E-05,3.33E-06,0.51392,2.47E-07,0.00038188,-0.2073,2.79E-05,0.37261,-0.26345,0.012202},
      {3.43E-05,3.61E-06,0.45803,3.28E-07,0.00016158,-0.27026,2.56E-05,0.33429,-0.23636,-0.039685},
      {2.33E-05,8.94E-06,0.36625,-3.66E-07,0.00014334,-0.3782,8.87E-06,0.26821,-0.18964,-0.12916},
      {1.24E-05,7.68E-06,0.27126,-1.79E-06,0.00011792,-0.48949,-7.59E-07,0.2001,-0.14148,-0.2214},
      {5.54E-06,9.18E-06,0.17565,-3.33E-06,0.00011939,-0.60121,-8.34E-06,0.13168,-0.093106,-0.31403},
      {2.25E-06,7.39E-05,0.11593,-6.83E-06,8.74E-05,-0.67153,-6.11E-05,0.088585,-0.062595,-0.37231},
      {-9.36E-08,0.00013441,0.065339,-1.12E-05,5.08E-05,-0.73101,-0.0001126,0.052133,-0.036784,-0.42158},
      {-2.05E-06,0.00017439,0.016794,-1.61E-05,1.92E-05,-0.78765,-0.00015145,0.01742,-0.012213,-0.46852},
      {-5.43E-06,0.00045658,0.00072003,-2.11E-05,7.59E-06,-0.79909,-0.00036476,0.010187,-0.0069467,-0.478},
      {-8.37E-06,0.00067577,-0.0074579,-2.54E-05,8.87E-06,-0.79767,-0.00053801,0.010861,-0.0072993,-0.47683},
      {-1.03E-05,0.00075832,-0.016063,-2.91E-05,2.01E-05,-0.7948,-0.00061932,0.012504,-0.0084034,-0.47448},
      {-2.31E-05,0.00067794,-0.046433,-3.01E-05,0.00064285,-0.76016,-0.00062128,0.033028,-0.022902,-0.44666},
      {-3.55E-05,0.00049874,-0.084608,-2.97E-05,0.0017566,-0.71434,-0.00057074,0.059937,-0.041953,-0.41027},
      {-4.38E-05,0.00025495,-0.12452,-2.82E-05,0.0032932,-0.66584,-0.00048348,0.088094,-0.061917,-0.37225},
      {-6.45E-05,-4.82E-05,-0.19805,-2.12E-05,0.0037347,-0.58028,-0.00041024,0.1401,-0.098718,-0.30192},
      {-8.73E-05,-0.00030806,-0.27573,-1.37E-05,0.0035293,-0.49098,-0.00038898,0.19502,-0.13755,-0.22755},
      {-0.00010816,-0.000416,-0.34499,-6.70E-06,0.0035208,-0.41086,-0.00046671,0.24401,-0.17211,-0.1611},
      {-0.00011317,-0.00019324,-0.39523,-2.76E-06,0.0033886,-0.35265,-0.00071215,0.27955,-0.19706,-0.11264},
      {-1.52E-07,1.59E-06,0.70596,0,0.0010714,0.00061856,-6.19E-07,0.49924,-0.35302,0.18361},
      {-1.89E-07,1.60E-06,0.7056,0,0.0014008,0.00080873,-4.81E-07,0.49901,-0.35285,0.1833},
      {-2.38E-07,1.61E-06,0.70504,0,0.0019236,0.0011106,-2.73E-07,0.49864,-0.35259,0.1828},
      {-2.93E-07,1.63E-06,0.70424,0,0.0026769,0.0015455,6.90E-09,0.4981,-0.35221,0.18207},
      {-3.39E-07,1.63E-06,0.70315,0,0.0037037,0.0021383,3.53E-07,0.49738,-0.3517,0.18109},
      {-3.58E-07,1.63E-06,0.70173,0,0.0050551,0.0029186,7.54E-07,0.49642,-0.35102,0.1798},
      {-3.29E-07,1.62E-06,0.6999,0,0.0067935,0.0039222,1.20E-06,0.49519,-0.35015,0.17813},
      {-2.26E-07,1.58E-06,0.6976,0,0.0089936,0.0051924,1.66E-06,0.49364,-0.34905,0.17603},
      {-2.31E-08,1.51E-06,0.69474,0,0.011745,0.0067809,2.12E-06,0.49169,-0.34767,0.17339},
      {5.84E-07,1.15E-06,0.68536,-2.59E-08,0.011783,-0.0030328,5.39E-06,0.48564,-0.34339,0.1652},
      {1.98E-06,6.96E-07,0.67134,-5.74E-08,0.0097386,-0.021363,9.56E-06,0.47658,-0.33698,0.15294},
      {4.20E-06,3.17E-07,0.65557,-7.54E-08,0.0070976,-0.042787,1.27E-05,0.46626,-0.32968,0.13897},
      {7.26E-06,5.02E-08,0.63796,-7.58E-08,0.0037256,-0.067698,1.43E-05,0.45458,-0.32142,0.12315},
      {1.21E-05,1.53E-07,0.60846,-2.97E-08,0.00094746,-0.10525,1.39E-05,0.43453,-0.30725,0.096007},
      {1.70E-05,4.13E-07,0.55663,5.94E-09,0.00071104,-0.16402,1.20E-05,0.39879,-0.28198,0.047619},
      {2.02E-05,6.51E-07,0.49982,3.89E-09,0.00042247,-0.22905,1.36E-05,0.35927,-0.25403,-0.0058855},
      {2.33E-05,9.14E-07,0.4391,4.96E-09,0.00012392,-0.29901,1.55E-05,0.31675,-0.22396,-0.063463},
      {1.81E-05,3.17E-06,0.35095,-1.24E-06,8.48E-05,-0.40159,8.82E-06,0.25397,-0.17957,-0.14847},
      {1.21E-05,5.25E-06,0.25905,-3.29E-06,8.75E-05,-0.50805,1.36E-06,0.18877,-0.13347,-0.23674},
      {6.20E-06,6.24E-06,0.169,-6.31E-06,8.64E-05,-0.61201,-5.81E-06,0.12511,-0.088459,-0.32294},
      {2.79E-06,3.40E-05,0.10817,-1.15E-05,6.34E-05,-0.68242,-3.53E-05,0.081971,-0.057943,-0.38129},
      {9.59E-07,6.08E-05,0.062549,-1.81E-05,3.64E-05,-0.73506,-6.67E-05,0.049717,-0.035118,-0.42491},
      {-4.74E-07,7.09E-05,0.019602,-2.56E-05,1.65E-05,-0.78416,-8.80E-05,0.01963,-0.013835,-0.4656},
      {-2.41E-06,0.00016229,-0.0011064,-3.12E-05,1.58E-05,-0.80021,-0.00017149,0.0097027,-0.0067585,-0.47891},
      {-4.08E-06,0.00022808,-0.0097854,-3.45E-05,3.18E-05,-0.79669,-0.00024282,0.011752,-0.0081568,-0.47603},
      {-4.78E-06,0.00020672,-0.018753,-3.67E-05,5.81E-05,-0.79192,-0.00025701,0.014626,-0.01018,-0.47211},
      {-1.11E-05,9.33E-05,-0.04552,-3.65E-05,0.00087107,-0.7617,-0.00023684,0.032278,-0.02267,-0.44822},
      {-1.89E-05,-7.96E-05,-0.085493,-3.43E-05,0.0025806,-0.71274,-0.00020009,0.060483,-0.042632,-0.41007},
      {-2.32E-05,-0.00026216,-0.12628,-3.09E-05,0.0048477,-0.66185,-0.00016326,0.089288,-0.063021,-0.37113},
      {-3.89E-05,-0.00031978,-0.18233,-2.47E-05,0.0064895,-0.59413,-0.0002387,0.12893,-0.090978,-0.31733},
      {-6.01E-05,-0.00038442,-0.24951,-1.72E-05,0.0063283,-0.51664,-0.0003368,0.17645,-0.12448,-0.25284},
      {-7.65E-05,-0.00046347,-0.31123,-9.97E-06,0.0059579,-0.44584,-0.00042442,0.2201,-0.15526,-0.19359},
      {0,4.46E-07,0.7071,0,1.03E-05,5.96E-06,-3.15E-07,0.49999,-0.35355,0.18463},
      {0,4.46E-07,0.7071,0,1.07E-05,6.15E-06,-3.16E-07,0.49999,-0.35355,0.18463},
      {0,4.46E-07,0.7071,0,1.12E-05,6.46E-06,-3.15E-07,0.49999,-0.35355,0.18463},
      {5.90E-08,4.37E-07,0.7062,0,0.0008783,0.00050708,-1.85E-07,0.49938,-0.35311,0.1838},
      {1.70E-07,4.19E-07,0.70462,0,0.0024116,0.0013923,2.66E-08,0.49829,-0.35235,0.18233},
      {3.26E-07,3.91E-07,0.70257,0,0.0043999,0.0025403,2.68E-07,0.49689,-0.35135,0.18042},
      {5.37E-07,3.48E-07,0.69999,0,0.006914,0.0039918,5.27E-07,0.49511,-0.35009,0.17802},
      {8.12E-07,2.85E-07,0.69679,0,0.010037,0.0057946,7.87E-07,0.4929,-0.34853,0.17503},
      {1.16E-06,1.98E-07,0.69288,0,0.013864,0.0080043,1.03E-06,0.4902,-0.34662,0.17136},
      {1.59E-06,8.19E-08,0.68814,0,0.018508,0.010686,1.23E-06,0.48691,-0.3443,0.16692},
      {2.65E-06,0,0.6799,0,0.020528,0.0050189,1.87E-06,0.4813,-0.34033,0.15932},
      {4.94E-06,0,0.6639,0,0.015815,-0.020798,3.49E-06,0.47049,-0.33268,0.14468},
      {7.29E-06,0,0.64466,0,0.01079,-0.050999,5.15E-06,0.45732,-0.32337,0.12685},
      {1.01E-05,0,0.62122,0,0.0056455,-0.086266,7.17E-06,0.44118,-0.31195,0.105},
      {1.33E-05,4.34E-08,0.58866,-2.40E-09,0.0012853,-0.1307,9.38E-06,0.41859,-0.29598,0.074422},
      {1.71E-05,2.64E-07,0.53167,-2.99E-08,0.00098826,-0.19609,1.18E-05,0.37886,-0.26789,0.020631},
      {2.07E-05,4.42E-07,0.47126,-9.01E-08,0.00061623,-0.2657,1.41E-05,0.33662,-0.23802,-0.036558},
      {2.41E-05,5.64E-07,0.40755,-1.97E-07,0.00018266,-0.33941,1.62E-05,0.29194,-0.20642,-0.09705},
      {2.00E-05,1.07E-06,0.32675,-2.60E-06,5.17E-05,-0.43269,1.10E-05,0.23495,-0.16613,-0.17421},
      {1.31E-05,8.36E-07,0.24146,-6.78E-06,5.05E-05,-0.53095,3.06E-06,0.17478,-0.12358,-0.25568},
      {6.47E-06,-6.35E-07,0.15863,-1.22E-05,4.77E-05,-0.62627,-4.72E-06,0.11641,-0.082313,-0.33471},
      {2.71E-06,5.04E-06,0.098404,-1.92E-05,3.60E-05,-0.69535,-2.06E-05,0.074093,-0.052392,-0.39197},
      {1.37E-06,8.75E-06,0.05806,-2.75E-05,2.18E-05,-0.74108,-3.83E-05,0.046067,-0.03257,-0.42988},
      {5.00E-07,1.49E-06,0.020648,-3.66E-05,1.32E-05,-0.78307,-4.94E-05,0.02034,-0.014379,-0.46468},
      {-2.74E-07,2.54E-06,-0.0023805,-4.31E-05,2.16E-05,-0.80213,-7.21E-05,0.0086202,-0.0060811,-0.4805},
      {-7.70E-07,-1.77E-05,-0.011374,-4.47E-05,5.28E-05,-0.79678,-8.89E-05,0.011846,-0.0083506,-0.47611},
      {-3.77E-07,-7.86E-05,-0.020526,-4.49E-05,9.47E-05,-0.79032,-8.12E-05,0.015763,-0.011127,-0.47081},
      {-3.11E-06,-0.00014114,-0.041923,-4.30E-05,0.00098608,-0.76608,-9.30E-05,0.029649,-0.020933,-0.45199},
      {-9.64E-06,-0.00020365,-0.08103,-3.90E-05,0.0035924,-0.71636,-0.00013263,0.057291,-0.04044,-0.41451},
      {-1.44E-05,-0.00026539,-0.1188,-3.38E-05,0.0066798,-0.66735,-0.00017299,0.083992,-0.059282,-0.3783},
      {-2.29E-05,-0.00032586,-0.16151,-2.67E-05,0.0085479,-0.6147,-0.0002271,0.11419,-0.080585,-0.33733},
      {-4.07E-05,-0.00040161,-0.21973,-1.89E-05,0.0075886,-0.54897,-0.00030852,0.15537,-0.10962,-0.28145},
      {0,0,0.7071,0,7.71E-06,4.45E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.00E-06,4.62E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.43E-06,4.87E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,9.03E-06,5.21E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,9.78E-06,5.65E-06,0,0.49999,-0.35355,0.18463},
      {3.74E-08,0,0.70669,0,0.00041338,0.00023866,2.64E-08,0.49971,-0.35335,0.18424},
      {3.01E-07,0,0.70384,0,0.0032101,0.0018533,2.13E-07,0.49773,-0.35195,0.18156},
      {6.12E-07,0,0.70056,0,0.0064313,0.0037131,4.33E-07,0.49545,-0.35034,0.17848},
      {9.73E-07,0,0.69688,0,0.010046,0.0058003,6.88E-07,0.4929,-0.34853,0.17502},
      {1.38E-06,0,0.69286,0,0.014008,0.0080877,9.77E-07,0.49009,-0.34655,0.17123},
      {1.83E-06,0,0.68855,0,0.018251,0.010537,1.30E-06,0.48709,-0.34443,0.16716},
      {2.46E-06,0,0.683,0,0.022103,0.010908,1.74E-06,0.48323,-0.3417,0.16194},
      {5.28E-06,0,0.65948,0,0.017078,-0.024392,3.73E-06,0.46695,-0.33018,0.13989},
      {8.21E-06,0,0.63155,0,0.011923,-0.065064,5.80E-06,0.44751,-0.31643,0.11357},
      {1.12E-05,0,0.59854,0,0.0067523,-0.11167,7.90E-06,0.42445,-0.30012,0.082348},
      {1.41E-05,3.49E-09,0.55929,-3.37E-09,0.0018321,-0.16511,9.95E-06,0.39694,-0.28067,0.045103},
      {1.70E-05,9.33E-08,0.50012,-1.46E-07,0.0013065,-0.23379,1.18E-05,0.35544,-0.25132,-0.011088},
      {1.94E-05,1.19E-07,0.43764,-3.54E-07,0.00076644,-0.30643,1.33E-05,0.31152,-0.22027,-0.070543},
      {2.12E-05,6.58E-08,0.37198,-6.44E-07,0.00023686,-0.38287,1.43E-05,0.26527,-0.18757,-0.13316},
      {1.75E-05,-1.03E-06,0.29715,-4.11E-06,2.59E-05,-0.46932,9.64E-06,0.21255,-0.15029,-0.20454},
      {1.07E-05,-3.88E-06,0.2192,-1.08E-05,2.36E-05,-0.55886,1.35E-06,0.15771,-0.11152,-0.27878},
      {4.98E-06,-8.23E-06,0.14433,-1.90E-05,2.02E-05,-0.64482,-6.50E-06,0.10507,-0.074302,-0.35005},
      {1.76E-06,-1.37E-05,0.086047,-2.85E-05,1.50E-05,-0.71131,-1.59E-05,0.064339,-0.045509,-0.40517},
      {1.03E-06,-2.38E-05,0.051294,-3.83E-05,1.07E-05,-0.74992,-2.56E-05,0.040674,-0.028778,-0.43718},
      {8.25E-07,-3.94E-05,0.019715,-4.90E-05,1.07E-05,-0.78457,-3.22E-05,0.019434,-0.013766,-0.46591},
      {9.18E-07,-5.98E-05,-0.0031677,-5.79E-05,2.57E-05,-0.80462,-4.07E-05,0.0071152,-0.0050581,-0.48256},
      {6.50E-07,-8.54E-05,-0.012058,-5.85E-05,8.02E-05,-0.7976,-5.81E-05,0.011339,-0.0080323,-0.47682},
      {4.76E-07,-0.00011138,-0.020805,-5.59E-05,0.00014816,-0.79015,-7.60E-05,0.015811,-0.011179,-0.47074},
      {-8.01E-07,-0.00014278,-0.034619,-5.00E-05,0.0007548,-0.77494,-9.71E-05,0.02447,-0.017279,-0.459},
      {-5.49E-06,-0.00019938,-0.068877,-4.39E-05,0.0033657,-0.73081,-0.00013387,0.048688,-0.034367,-0.42616},
      {-9.00E-06,-0.0002524,-0.099247,-3.63E-05,0.0058758,-0.69135,-0.00016902,0.070161,-0.049515,-0.39704},
      {-1.27E-05,-0.00030464,-0.12853,-2.70E-05,0.0078971,-0.65399,-0.00020614,0.090868,-0.064118,-0.36897},
      {0,0,0.7071,0,4.40E-06,2.54E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.62E-06,2.67E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.95E-06,2.86E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.40E-06,3.12E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.97E-06,3.45E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.65E-06,3.84E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.42E-06,4.29E-06,0,0.49999,-0.35355,0.18463},
      {1.01E-07,0,0.70618,0,0.00091368,0.00052752,7.17E-08,0.49935,-0.3531,0.18376},
      {4.78E-07,0,0.70281,0,0.0042383,0.002447,3.38E-07,0.497,-0.35143,0.18058},
      {8.90E-07,0,0.69919,0,0.0078157,0.0045124,6.29E-07,0.49447,-0.34964,0.17715},
      {1.33E-06,0,0.69539,0,0.011562,0.0066752,9.41E-07,0.49182,-0.34777,0.17357},
      {1.79E-06,0,0.69153,0,0.015372,0.0088749,1.27E-06,0.48913,-0.34587,0.16992},
      {2.25E-06,0,0.68774,0,0.019119,0.011038,1.59E-06,0.48648,-0.34399,0.16633},
      {4.57E-06,0,0.65958,0,0.015703,-0.027096,3.23E-06,0.46675,-0.33004,0.13962},
      {7.16E-06,0,0.62125,0,0.010893,-0.079386,5.06E-06,0.43983,-0.311,0.10317},
      {9.52E-06,0,0.57672,0,0.0063178,-0.13847,6.73E-06,0.4085,-0.28885,0.060752},
      {1.15E-05,0,0.52525,0,0.0021429,-0.20494,8.12E-06,0.37222,-0.26319,0.011631},
      {1.29E-05,-7.25E-08,0.46452,-2.91E-07,0.0011785,-0.27648,8.91E-06,0.32943,-0.23294,-0.046297},
      {1.35E-05,-2.36E-07,0.40013,-7.16E-07,0.00064642,-0.35157,9.12E-06,0.28401,-0.20082,-0.10779},
      {1.31E-05,-5.00E-07,0.33267,-1.26E-06,0.00020196,-0.43015,8.60E-06,0.23636,-0.16713,-0.17232},
      {9.62E-06,-2.81E-06,0.26187,-5.47E-06,8.35E-06,-0.51198,4.14E-06,0.18645,-0.13184,-0.23988},
      {4.45E-06,-8.67E-06,0.19199,-1.52E-05,5.95E-06,-0.59209,-3.93E-06,0.13738,-0.097153,-0.3063},
      {1.09E-06,-1.63E-05,0.12576,-2.67E-05,3.19E-06,-0.668,-1.13E-05,0.090884,-0.064282,-0.36924},
      {2.02E-07,-2.64E-05,0.071444,-4.06E-05,2.72E-06,-0.7298,-1.85E-05,0.053013,-0.037513,-0.42048},
      {4.42E-07,-3.95E-05,0.043315,-5.49E-05,8.28E-06,-0.76004,-2.75E-05,0.03446,-0.024402,-0.44556},
      {6.29E-07,-5.34E-05,0.017732,-7.20E-05,1.53E-05,-0.78684,-3.71E-05,0.018002,-0.012774,-0.4678},
      {7.30E-07,-6.93E-05,-0.0032177,-8.76E-05,2.97E-05,-0.80641,-4.81E-05,0.0059725,-0.0042755,-0.48404},
      {5.49E-07,-9.39E-05,-0.011153,-8.42E-05,9.23E-05,-0.79955,-6.50E-05,0.010094,-0.0071738,-0.47845},
      {3.99E-07,-0.00011722,-0.018393,-7.48E-05,0.00016029,-0.7931,-8.12E-05,0.013967,-0.0098914,-0.4732},
      {2.06E-07,-0.00013941,-0.025297,-5.87E-05,0.00027129,-0.78655,-9.66E-05,0.017865,-0.01262,-0.46793},
      {-3.03E-06,-0.00018997,-0.053968,-5.04E-05,0.0024795,-0.74958,-0.00013021,0.038137,-0.026919,-0.44044},
      {-5.31E-06,-0.00023612,-0.078586,-4.02E-05,0.0044296,-0.71774,-0.00016142,0.055546,-0.039195,-0.41685},
      {0,0,0.7071,0,1.98E-06,1.14E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.14E-06,1.23E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.37E-06,1.37E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.70E-06,1.56E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.10E-06,1.79E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.58E-06,2.07E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.12E-06,2.38E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.70E-06,2.71E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.30E-06,3.06E-06,0,0.5,-0.35355,0.18463},
      {2.54E-07,0,0.70504,0,0.0020432,0.0011796,1.79E-07,0.49856,-0.35253,0.18268},
      {6.32E-07,0,0.702,0,0.0050527,0.0029172,4.47E-07,0.49643,-0.35103,0.1798},
      {1.01E-06,0,0.69902,0,0.0079933,0.0046149,7.12E-07,0.49435,-0.34956,0.17698},
      {1.36E-06,0,0.69626,0,0.010725,0.0061919,9.63E-07,0.49242,-0.34819,0.17437},
      {1.67E-06,0,0.69388,0,0.013084,0.0075541,1.18E-06,0.49075,-0.34701,0.17211},
      {2.96E-06,0,0.66525,0,0.011293,-0.02849,2.09E-06,0.47057,-0.33274,0.1448},
      {4.54E-06,0,0.61461,0,0.0074268,-0.093516,3.21E-06,0.43485,-0.30748,0.096432},
      {5.57E-06,0,0.55663,0,0.0040741,-0.16617,3.94E-06,0.39392,-0.27854,0.041004},
      {5.87E-06,0,0.49052,0,0.001427,-0.24705,4.15E-06,0.3472,-0.2455,-0.022254},
      {5.19E-06,-2.18E-07,0.42494,-4.37E-07,0.00054034,-0.32424,3.48E-06,0.30087,-0.21274,-0.084986},
      {3.37E-06,-6.05E-07,0.35878,-1.15E-06,0.00018796,-0.40122,1.91E-06,0.2541,-0.17967,-0.14831},
      {1.92E-07,-1.12E-06,0.28966,-2.01E-06,3.83E-06,-0.48139,-6.57E-07,0.2052,-0.1451,-0.21452},
      {1.29E-08,-4.49E-06,0.22463,-8.15E-06,1.83E-07,-0.55618,-3.16E-06,0.1594,-0.11272,-0.27652},
      {5.00E-08,-1.38E-05,0.16579,-2.55E-05,8.64E-07,-0.6233,-9.70E-06,0.11826,-0.08364,-0.33218},
      {8.12E-08,-2.44E-05,0.10897,-4.74E-05,1.71E-06,-0.6881,-1.72E-05,0.07854,-0.055572,-0.38591},
      {1.21E-07,-3.67E-05,0.057467,-7.33E-05,3.25E-06,-0.74659,-2.58E-05,0.042676,-0.030232,-0.43441},
      {2.85E-07,-5.09E-05,0.034627,-9.16E-05,1.07E-05,-0.7701,-3.57E-05,0.028232,-0.020029,-0.45392},
      {4.06E-07,-6.59E-05,0.014511,-0.0001112,1.95E-05,-0.79028,-4.62E-05,0.01583,-0.011272,-0.47066},
      {4.84E-07,-8.20E-05,-0.0027372,-0.00013268,2.97E-05,-0.80698,-5.74E-05,0.0055493,-0.0040152,-0.48452},
      {3.72E-07,-0.00010408,-0.0098574,-0.00012177,9.14E-05,-0.80193,-7.28E-05,0.0085769,-0.0061339,-0.48042},
      {2.60E-07,-0.00012471,-0.015826,-0.00010209,0.00015724,-0.79639,-8.73E-05,0.011911,-0.0084618,-0.47592},
      {1.49E-07,-0.00014322,-0.020982,-7.41E-05,0.00022283,-0.79145,-0.00010031,0.014891,-0.010532,-0.47192},
      {-1.51E-06,-0.00018169,-0.040354,-5.92E-05,0.0015337,-0.76695,-0.0001265,0.028499,-0.020119,-0.45349},
      {0,0,0.70711,0,4.45E-07,2.57E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.46E-07,3.15E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.00E-07,4.04E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.06E-07,5.23E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.16E-06,6.70E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.46E-06,8.41E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.78E-06,1.03E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.12E-06,1.22E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.45E-06,1.41E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.74E-06,1.58E-06,0,0.5,-0.35355,0.18463},
      {5.85E-08,0,0.70666,0,0.00044418,0.00025645,4.14E-08,0.49969,-0.35333,0.18421},
      {3.06E-07,0,0.70478,0,0.0023038,0.0013301,2.17E-07,0.49837,-0.3524,0.18243},
      {5.09E-07,0,0.70326,0,0.0038077,0.0021984,3.60E-07,0.49731,-0.35165,0.18099},
      {6.43E-07,0,0.70227,0,0.0047849,0.0027626,4.55E-07,0.49662,-0.35116,0.18006},
      {6.82E-07,0,0.702,0,0.0050415,0.0029107,4.82E-07,0.49643,-0.35103,0.17981},
      {8.44E-07,0,0.67729,0,0.003584,-0.028123,5.97E-07,0.47898,-0.33869,0.15617},
      {7.96E-07,0,0.61341,0,0.001249,-0.10588,5.63E-07,0.43384,-0.30677,0.09505},
      {0,0,0.54234,0,0,-0.19009,0,0.3836,-0.27124,0.027026},
      {0,0,0.46494,0,0,-0.27943,0,0.32889,-0.23256,-0.047053},
      {0,-6.01E-07,0.3952,-1.29E-06,0,-0.35989,-4.25E-07,0.27961,-0.19772,-0.11377},
      {0,-2.01E-06,0.33065,-4.44E-06,0,-0.43433,-1.42E-06,0.23402,-0.16548,-0.17549},
      {0,-4.02E-06,0.2631,-9.12E-06,0,-0.51225,-2.84E-06,0.1863,-0.13174,-0.2401},
      {5.38E-09,-8.22E-06,0.1957,-1.86E-05,1.54E-07,-0.58986,-5.81E-06,0.13876,-0.09813,-0.30445},
      {3.18E-08,-2.00E-05,0.14232,-4.47E-05,1.09E-06,-0.6507,-1.42E-05,0.10145,-0.071773,-0.35489},
      {5.27E-08,-3.32E-05,0.091715,-7.56E-05,2.16E-06,-0.70836,-2.34E-05,0.066087,-0.046789,-0.40271},
      {6.79E-08,-4.77E-05,0.044564,-0.00011167,3.39E-06,-0.76208,-3.37E-05,0.033125,-0.023511,-0.44725},
      {1.63E-07,-6.32E-05,0.025489,-0.00013399,1.22E-05,-0.78113,-4.46E-05,0.021413,-0.015243,-0.46306},
      {2.27E-07,-7.99E-05,0.010412,-0.00015755,2.26E-05,-0.79532,-5.63E-05,0.012667,-0.0090746,-0.47484},
      {2.54E-07,-9.78E-05,-0.002013,-0.00018383,3.42E-05,-0.80638,-6.89E-05,0.0058301,-0.0042573,-0.48403},
      {1.82E-07,-0.00011703,-0.0085305,-0.00017086,8.42E-05,-0.8044,-8.24E-05,0.006993,-0.0050569,-0.48246},
      {8.02E-08,-0.00013432,-0.01317,-0.0001389,0.00014273,-0.79991,-9.46E-05,0.0097118,-0.0069388,-0.47882},
      {-4.03E-08,-0.00014903,-0.016956,-9.74E-05,0.00019734,-0.79613,-0.00010509,0.012021,-0.0085231,-0.47576},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.27E-08,1.31E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.40E-07,8.10E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.66E-07,1.54E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.88E-07,2.24E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.90E-07,2.83E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.56E-07,3.21E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.65E-07,3.26E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.97E-07,2.87E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.31E-07,1.91E-07,0,0.5,-0.35355,0.18464},
      {7.38E-09,0,0.70706,0,3.59E-05,2.07E-05,5.22E-09,0.49997,-0.35354,0.1846},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70708,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70707,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.68998,0,0,-0.019725,0,0.48792,-0.34501,0.16828},
      {0,0,0.61639,0,0,-0.10467,0,0.4359,-0.30823,0.097847},
      {0,0,0.53699,0,0,-0.19633,0,0.37977,-0.26854,0.021849},
      {0,0,0.45155,0,0,-0.29498,0,0.31936,-0.22582,-0.059946},
      {0,-1.10E-06,0.37291,-2.59E-06,0,-0.38574,-7.81E-07,0.26378,-0.18652,-0.1352},
      {0,-3.99E-06,0.30524,-9.48E-06,0,-0.46378,-2.82E-06,0.21598,-0.15273,-0.19991},
      {0,-7.71E-06,0.23466,-1.85E-05,0,-0.54521,-5.45E-06,0.1661,-0.11746,-0.26743},
      {9.24E-10,-1.28E-05,0.16248,-3.09E-05,5.13E-08,-0.62845,-9.04E-06,0.1151,-0.081414,-0.33645},
      {1.78E-08,-2.69E-05,0.11573,-6.58E-05,1.20E-06,-0.6817,-1.90E-05,0.082433,-0.058341,-0.3806},
      {2.96E-08,-4.24E-05,0.072501,-0.00010571,2.48E-06,-0.73094,-2.99E-05,0.052209,-0.037002,-0.42143},
      {3.61E-08,-5.90E-05,0.033469,-0.00015083,3.89E-06,-0.77541,-4.17E-05,0.0249,-0.017728,-0.45831},
      {7.24E-08,-7.64E-05,0.016066,-0.00018137,1.28E-05,-0.79283,-5.40E-05,0.01417,-0.010163,-0.47276},
      {8.82E-08,-9.51E-05,0.0056173,-0.00021012,2.46E-05,-0.80165,-6.72E-05,0.0086991,-0.0063137,-0.48009},
      {7.21E-08,-0.00011536,-0.0023855,-0.00024245,3.75E-05,-0.80768,-8.15E-05,0.0049324,-0.0036724,-0.48511},
      {-2.00E-09,-0.00013313,-0.0072195,-0.00023248,7.39E-05,-0.80687,-9.41E-05,0.0053946,-0.0039805,-0.48449},
      {-6.23E-08,-0.00014616,-0.01065,-0.00019287,0.00012011,-0.80326,-0.00010331,0.0076022,-0.0054953,-0.48156},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7012,0,0,-0.0068031,0,0.49583,-0.35061,0.179},
      {0,0,0.61963,0,0,-0.10097,0,0.43817,-0.30983,0.10091},
      {0,0,0.53182,0,0,-0.20236,0,0.37608,-0.26593,0.016853},
      {0,0,0.43751,0,0,-0.31125,0,0.3094,-0.21878,-0.073437},
      {0,-1.38E-06,0.348,-3.36E-06,0,-0.41457,-9.74E-07,0.24613,-0.17404,-0.1591},
      {0,-6.13E-06,0.2774,-1.51E-05,0,-0.49602,-4.34E-06,0.19623,-0.13877,-0.22664},
      {0,-1.19E-05,0.20396,-2.95E-05,0,-0.58075,-8.44E-06,0.14431,-0.10207,-0.2969},
      {0,-1.89E-05,0.12775,-4.70E-05,0,-0.66868,-1.34E-05,0.090439,-0.063988,-0.3698},
      {7.49E-09,-3.45E-05,0.085514,-8.88E-05,1.22E-06,-0.71688,-2.44E-05,0.060849,-0.043099,-0.40977},
      {1.13E-08,-5.20E-05,0.050768,-0.0001376,2.66E-06,-0.75647,-3.67E-05,0.036527,-0.02594,-0.4426},
      {1.03E-08,-7.06E-05,0.020943,-0.00019178,4.22E-06,-0.79047,-4.99E-05,0.015614,-0.011197,-0.47079},
      {7.75E-09,-8.98E-05,0.0069537,-0.0002336,1.25E-05,-0.80449,-6.35E-05,0.0069454,-0.0050998,-0.48243},
      {0,-0.00010999,0.0015668,-0.00027713,2.42E-05,-0.80773,-7.78E-05,0.0048728,-0.0036677,-0.48513},
      {0,-0.00013132,-0.0024279,-0.00033496,3.52E-05,-0.80956,-9.29E-05,0.003641,-0.0028439,-0.48667},
      {-1.22E-08,-0.00014948,-0.0057417,-0.00035443,6.08E-05,-0.80873,-0.00010569,0.0040818,-0.0031659,-0.48602},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62421,0,0,-0.095703,0,0.44139,-0.31211,0.10528},
      {0,0,0.5272,0,0,-0.20772,0,0.3728,-0.26361,0.012407},
      {0,0,0.42322,0,0,-0.32777,0,0.29928,-0.21162,-0.087139},
      {0,-1.26E-06,0.3205,-3.15E-06,0,-0.44637,-8.92E-07,0.22665,-0.16027,-0.18548},
      {0,-8.26E-06,0.24712,-2.07E-05,0,-0.53103,-5.84E-06,0.17478,-0.1236,-0.25567},
      {0,-1.67E-05,0.1705,-4.17E-05,0,-0.61944,-1.18E-05,0.1206,-0.08531,-0.32898},
      {0,-2.69E-05,0.091884,-6.70E-05,0,-0.71015,-1.90E-05,0.065012,-0.046024,-0.40419},
      {3.93E-10,-4.33E-05,0.052035,-0.00011309,1.05E-06,-0.75581,-3.06E-05,0.036971,-0.026234,-0.44205},
      {0,-6.06E-05,0.030562,-0.00016524,2.32E-06,-0.78023,-4.29E-05,0.021933,-0.015644,-0.46229},
      {0,-7.68E-05,0.013449,-0.00021607,3.42E-06,-0.79965,-5.43E-05,0.009953,-0.0072155,-0.4784},
      {0,-9.51E-05,0.0041496,-0.00027024,9.19E-06,-0.80888,-6.72E-05,0.004205,-0.0031961,-0.48606},
      {0,-0.00011764,0.00080027,-0.00034004,1.94E-05,-0.81021,-8.32E-05,0.0032664,-0.0025909,-0.48718},
      {0,-0.00014212,-0.0018729,-0.00042466,2.89E-05,-0.81107,-0.00010049,0.0025934,-0.0021874,-0.48791},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62994,0,0,-0.089103,0,0.44544,-0.31497,0.11076},
      {0,0,0.52136,0,0,-0.21447,0,0.36867,-0.26069,0.0068089},
      {0,0,0.40432,0,0,-0.34961,0,0.28591,-0.20217,-0.10525},
      {0,-6.34E-07,0.28219,-1.55E-06,0,-0.49062,-4.48E-07,0.19955,-0.14111,-0.22217},
      {0,-1.09E-05,0.20823,-2.67E-05,0,-0.57596,-7.72E-06,0.14726,-0.10415,-0.29292},
      {0,-2.27E-05,0.13653,-5.61E-05,0,-0.65868,-1.61E-05,0.096548,-0.068314,-0.36151},
      {0,-3.61E-05,0.067671,-8.97E-05,0,-0.73811,-2.55E-05,0.047851,-0.033907,-0.42737},
      {0,-5.13E-05,0.033472,-0.00013429,6.64E-07,-0.77736,-3.63E-05,0.023742,-0.016897,-0.45991},
      {0,-6.61E-05,0.019874,-0.00018222,1.59E-06,-0.79277,-4.68E-05,0.014224,-0.010207,-0.47269},
      {0,-8.01E-05,0.0089379,-0.00022853,2.38E-06,-0.80516,-5.66E-05,0.0065628,-0.0048291,-0.48297},
      {0,-9.71E-05,0.0023066,-0.00028758,5.96E-06,-0.81193,-6.86E-05,0.0023146,-0.0018757,-0.48859},
      {0,-0.00012267,0.00017761,-0.00038298,1.46E-05,-0.81242,-8.67E-05,0.0018507,-0.0016303,-0.48901},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.63663,0,0,-0.08138,0,0.45017,-0.31831,0.11716},
      {0,0,0.51472,0,0,-0.22215,0,0.36396,-0.25736,0.00044226},
      {0,0,0.38448,0,0,-0.37253,0,0.27187,-0.19224,-0.12425},
      {0,0,0.24595,0,0,-0.53249,0,0.17392,-0.12298,-0.25688},
      {0,-1.24E-05,0.17577,-3.08E-05,0,-0.61344,-8.79E-06,0.12429,-0.087912,-0.324},
      {0,-2.71E-05,0.11296,-6.76E-05,0,-0.68589,-1.92E-05,0.079862,-0.056525,-0.38408},
      {0,-4.32E-05,0.05281,-0.00010821,0,-0.75526,-3.06E-05,0.037318,-0.026474,-0.44159},
      {0,-5.85E-05,0.019021,-0.00015229,3.63E-07,-0.79411,-4.14E-05,0.013452,-0.0096351,-0.4738},
      {0,-7.11E-05,0.010885,-0.00019554,9.89E-07,-0.8033,-5.03E-05,0.0077524,-0.0056417,-0.48143},
      {0,-8.28E-05,0.0047655,-0.00023671,1.48E-06,-0.8102,-5.86E-05,0.0034584,-0.0026407,-0.48715},
      {0,-9.68E-05,0.00093395,-0.00028948,3.18E-06,-0.81423,-6.85E-05,0.00090597,-0.00088169,-0.49049},
      {0.46155,0.016194,0.041011,-0.030696,0.0017903,-0.0035989,0.34279,0.010131,0.24645,0.16975},
      {0.47039,0.022371,0.034269,-0.033667,0.0022674,-0.0017498,0.32786,-0.001591,0.25831,0.1708},
      {0.46766,0.043515,0.016574,-0.038678,0.0031066,-0.00046452,0.29679,-0.016851,0.27478,0.17015},
      {0.41696,0.08464,0.0037601,-0.054905,0.01096,0.0037747,0.21883,-0.037436,0.2592,0.16286},
      {0.30561,0.15023,-0.0078336,-0.075628,0.033517,0.015011,0.088789,-0.059716,0.21183,0.14112},
      {0.14969,0.22591,-0.026153,-0.086087,0.095959,0.049142,-0.071601,-0.07679,0.13052,0.082145},
      {0.053416,0.27298,-0.043342,-0.066617,0.16063,0.085798,-0.16744,-0.065139,0.087863,0.021415},
      {0.024633,0.27073,-0.056526,-0.024131,0.22867,0.12603,-0.18385,-0.029589,0.079006,-0.042183},
      {0.0096552,0.25765,-0.073211,0.0082049,0.28521,0.1597,-0.18218,0.0073573,0.070841,-0.094663},
      {0.0020359,0.22337,-0.092682,0.014883,0.327,0.18538,-0.15958,0.028528,0.042543,-0.13242},
      {0.0010656,0.19142,-0.10165,0.01876,0.36304,0.20699,-0.13697,0.041758,0.025888,-0.1659},
      {0.00080866,0.16326,-0.10497,0.017374,0.40471,0.23158,-0.11689,0.054827,0.017279,-0.20509},
      {0.00059149,0.13549,-0.10297,0.014682,0.44303,0.25412,-0.096959,0.058364,0.0074302,-0.24126},
      {0.00038112,0.10766,-0.099292,0.011849,0.48011,0.27615,-0.076984,0.058519,-0.0031405,-0.2761},
      {0.00022993,0.085967,-0.097685,0.0082516,0.50893,0.29332,-0.061421,0.060383,-0.011383,-0.30316},
      {0.0001689,0.073182,-0.10344,0.0037284,0.5214,0.30045,-0.052214,0.068051,-0.018309,-0.31511},
      {0.00012611,0.059281,-0.1161,0.0015032,0.52518,0.30255,-0.042283,0.078636,-0.030549,-0.31877},
      {8.73E-05,0.046044,-0.12985,0.00065174,0.52544,0.30274,-0.032848,0.088711,-0.043883,-0.31897},
      {4.79E-05,0.034414,-0.14062,-9.32E-05,0.52753,0.30419,-0.024561,0.09689,-0.054765,-0.32076},
      {2.67E-05,0.027208,-0.15364,-0.00072909,0.52288,0.30168,-0.019417,0.10673,-0.064492,-0.31617},
      {2.22E-05,0.022896,-0.16995,-0.0012931,0.51204,0.2954,-0.016336,0.11905,-0.074282,-0.30579},
      {3.69E-05,0.01686,-0.19705,-0.0016189,0.49071,0.28304,-0.012048,0.13805,-0.090956,-0.28541},
      {6.95E-05,0.011472,-0.21918,-0.0018106,0.47385,0.2733,-0.008186,0.15361,-0.10479,-0.26927},
      {0.00012526,0.0068589,-0.23652,-0.0018603,0.46121,0.26608,-0.0048435,0.16587,-0.11576,-0.2571},
      {0.00027853,0.0035366,-0.24975,-0.0017224,0.45147,0.26053,-0.0023521,0.17535,-0.12388,-0.24771},
      {0.00058783,0.001653,-0.25884,-0.0013688,0.4444,0.25647,-0.00078476,0.18206,-0.12902,-0.24093},
      {0.0008661,0.00055174,-0.26246,-0.0010536,0.44199,0.25509,0.00020267,0.18486,-0.13107,-0.23862},
      {0.00090821,0.0002796,-0.26903,-0.00091696,0.43582,0.25153,0.00043143,0.18959,-0.1344,-0.23271},
      {0.00086321,0.00010333,-0.27129,-0.0007594,0.43397,0.25048,0.0005296,0.1913,-0.13556,-0.23092},
      {0.00073153,1.40E-06,-0.2708,-0.00057811,0.43494,0.25108,0.00051261,0.19108,-0.13533,-0.23181},
      {0.00037793,9.88E-07,-0.27388,-0.00036118,0.43243,0.24963,0.00026445,0.19342,-0.13694,-0.22941},
      {0.00012212,6.92E-07,-0.27338,-0.00017459,0.4334,0.25019,8.49E-05,0.19319,-0.13672,-0.23033},
      {0.46278,0.017858,0.047327,-0.029713,0.0016388,-0.0029173,0.32792,0.013495,0.24459,0.17032},
      {0.47291,0.024266,0.038023,-0.031176,0.0019589,-0.001536,0.31359,0.0027013,0.25823,0.17096},
      {0.46546,0.0447,0.021145,-0.034572,0.0027661,-0.00064929,0.28149,-0.01073,0.27386,0.16987},
      {0.41385,0.085655,0.0064941,-0.046314,0.0097365,0.0027215,0.20631,-0.028654,0.26492,0.16278},
      {0.32061,0.15065,-0.0051371,-0.060027,0.023809,0.0089824,0.08902,-0.044399,0.23493,0.14878},
      {0.18792,0.22216,-0.022524,-0.063286,0.077022,0.037958,-0.05218,-0.053693,0.17269,0.098417},
      {0.079453,0.29042,-0.041827,-0.045179,0.13435,0.069754,-0.16973,-0.041576,0.1323,0.044363},
      {0.029486,0.3166,-0.057777,-0.0065711,0.19482,0.10477,-0.21863,-0.0083837,0.12139,-0.0124},
      {0.015351,0.28807,-0.075972,0.0053818,0.24213,0.13296,-0.20371,0.013064,0.093033,-0.055832},
      {0.0062276,0.25259,-0.094671,0.012733,0.28768,0.16071,-0.18069,0.033142,0.062877,-0.097191},
      {0.0012258,0.21433,-0.11349,0.015625,0.33461,0.18994,-0.15331,0.05555,0.035505,-0.13933},
      {0.00094769,0.18414,-0.11619,0.014816,0.37722,0.21505,-0.13175,0.066873,0.025213,-0.17941},
      {0.0007155,0.15413,-0.11339,0.013209,0.41442,0.23683,-0.11017,0.066883,0.012488,-0.21458},
      {0.00049358,0.12484,-0.10957,0.010614,0.453,0.25969,-0.08915,0.066836,0.001165,-0.25088},
      {0.00028008,0.09574,-0.10702,0.0072061,0.49099,0.28257,-0.068338,0.068197,-0.010269,-0.28633},
      {0.00018846,0.078746,-0.11202,0.0028829,0.50879,0.29303,-0.056159,0.075346,-0.018929,-0.30315},
      {0.00014709,0.06381,-0.12693,0.0015372,0.5099,0.29354,-0.045501,0.086542,-0.033502,-0.3043},
      {0.00010642,0.050054,-0.141,0.00070591,0.5103,0.29379,-0.035697,0.09681,-0.047277,-0.30466},
      {6.54E-05,0.037955,-0.15202,-2.68E-05,0.51257,0.29531,-0.027077,0.10514,-0.058539,-0.30663},
      {2.88E-05,0.028208,-0.16039,-0.00060855,0.51548,0.29739,-0.020132,0.11177,-0.067169,-0.30909},
      {2.52E-05,0.023559,-0.17943,-0.0011573,0.50201,0.28958,-0.016819,0.12587,-0.078587,-0.29622},
      {3.86E-05,0.017422,-0.20699,-0.0014956,0.48026,0.27696,-0.01246,0.14516,-0.095575,-0.27544},
      {6.96E-05,0.011974,-0.22942,-0.0017025,0.46315,0.26708,-0.0085554,0.16092,-0.10959,-0.25906},
      {0.00012375,0.0072984,-0.24706,-0.0017661,0.45025,0.2597,-0.0051685,0.17339,-0.12075,-0.24666},
      {0.00021849,0.0035661,-0.26001,-0.0016701,0.44128,0.25465,-0.0024172,0.18265,-0.129,-0.23796},
      {0.0005246,0.0016547,-0.26944,-0.0013281,0.43391,0.25041,-0.00083179,0.18958,-0.13433,-0.23089},
      {0.00078856,0.00058997,-0.27426,-0.0010427,0.43024,0.2483,0.00011975,0.19321,-0.13698,-0.22737},
      {0.000844,0.00031273,-0.28086,-0.00090828,0.42401,0.2447,0.00036174,0.19797,-0.14033,-0.22141},
      {0.00081136,0.00012865,-0.28302,-0.0007534,0.42226,0.2437,0.00047435,0.1996,-0.14143,-0.21972},
      {0.00069445,1.91E-05,-0.28227,-0.00057523,0.42347,0.24444,0.00047337,0.1992,-0.14108,-0.22085},
      {0.00038811,1.01E-06,-0.28387,-0.00036428,0.42243,0.24386,0.00027157,0.20048,-0.14193,-0.21984},
      {0.00012211,7.19E-07,-0.28346,-0.00017465,0.42331,0.24437,8.49E-05,0.20032,-0.14176,-0.22068},
      {0.44852,0.019859,0.066171,-0.026651,0.0010403,-0.0028641,0.29996,0.027977,0.23191,0.17049},
      {0.45252,0.027171,0.054418,-0.027419,0.0011863,-0.0021794,0.28363,0.017155,0.24634,0.17043},
      {0.4436,0.046859,0.035804,-0.029602,0.0019917,-0.0016255,0.25135,0.0031067,0.26292,0.16902},
      {0.41769,0.077782,0.014331,-0.033269,0.0052497,-0.00015745,0.19802,-0.013716,0.27495,0.16497},
      {0.33114,0.14254,0.0020093,-0.04106,0.018937,0.0058288,0.086412,-0.024828,0.25146,0.15119},
      {0.23848,0.21529,-0.013519,-0.039619,0.039453,0.01558,-0.033912,-0.029155,0.23025,0.13077},
      {0.13943,0.27994,-0.031597,-0.020477,0.092058,0.044752,-0.14296,-0.01549,0.19584,0.08107},
      {0.061341,0.32871,-0.055733,-0.0068026,0.13666,0.06835,-0.21789,0.0020806,0.15972,0.038873},
      {0.020009,0.3362,-0.079251,0.0035169,0.1789,0.093022,-0.23986,0.019953,0.12465,0.00063346},
      {0.0099646,0.2986,-0.097386,0.010837,0.23002,0.12388,-0.21492,0.039736,0.092536,-0.045962},
      {0.0039869,0.25839,-0.11579,0.01381,0.28187,0.15589,-0.18596,0.061865,0.063252,-0.092717},
      {0.0012171,0.21463,-0.13236,0.012606,0.33066,0.18678,-0.15343,0.08003,0.033912,-0.13613},
      {0.00089775,0.18194,-0.12987,0.011259,0.37059,0.21022,-0.12988,0.080187,0.019496,-0.17381},
      {0.00066083,0.15071,-0.12563,0.0089512,0.41139,0.2343,-0.10745,0.0797,0.0072754,-0.21225},
      {0.00043582,0.12052,-0.12436,0.0059768,0.44869,0.25665,-0.085836,0.081623,-0.005626,-0.24712},
      {0.0002258,0.087049,-0.12783,0.0024397,0.48555,0.27928,-0.062048,0.087449,-0.021985,-0.28118},
      {0.00017907,0.070387,-0.14442,0.0016116,0.4859,0.27935,-0.050174,0.09926,-0.038668,-0.2816},
      {0.00013561,0.055888,-0.1589,0.00080045,0.48656,0.27972,-0.039843,0.10978,-0.053051,-0.28224},
      {9.21E-05,0.043113,-0.17023,7.90E-05,0.48912,0.28138,-0.030744,0.11828,-0.064838,-0.28452},
      {4.96E-05,0.03222,-0.17759,-0.00048635,0.49423,0.28475,-0.022985,0.12419,-0.07355,-0.28905},
      {2.88E-05,0.024448,-0.19505,-0.0009484,0.48561,0.28005,-0.017474,0.13705,-0.085831,-0.28056},
      {3.98E-05,0.018229,-0.22293,-0.0013113,0.46359,0.26727,-0.013056,0.15656,-0.10303,-0.25954},
      {6.84E-05,0.012687,-0.24583,-0.0015404,0.44609,0.25715,-0.0090842,0.17262,-0.11734,-0.24279},
      {0.00011995,0.0079195,-0.26387,-0.0016249,0.43286,0.24957,-0.0056307,0.18537,-0.12876,-0.23008},
      {0.00019974,0.0040216,-0.27704,-0.0015551,0.42384,0.24449,-0.0027681,0.19477,-0.13723,-0.22133},
      {0.00042485,0.001626,-0.28619,-0.001269,0.41734,0.24083,-0.00088362,0.20147,-0.14273,-0.21503},
      {0.00067188,0.00065003,-0.29289,-0.0010254,0.41166,0.23755,-6.81E-06,0.2064,-0.14632,-0.20959},
      {0.00074789,0.00035965,-0.29936,-0.00089541,0.40556,0.23402,0.00025931,0.21106,-0.14959,-0.20376},
      {0.00073378,0.00016449,-0.30129,-0.00074467,0.40401,0.23314,0.00039313,0.21253,-0.15058,-0.20227},
      {0.00063359,4.57E-05,-0.30025,-0.00057039,0.4055,0.23403,0.00041077,0.21192,-0.15008,-0.20366},
      {0.00040117,1.05E-06,-0.29948,-0.0003677,0.4068,0.23483,0.0002807,0.21151,-0.14973,-0.20487},
      {0.00011975,7.58E-07,-0.2992,-0.00017345,0.40756,0.23527,8.31E-05,0.21145,-0.14963,-0.20561},
      {0.40746,0.021008,0.11207,-0.021302,-8.22E-05,-0.0037804,0.25632,0.064559,0.19302,0.17027},
      {0.41372,0.026581,0.095519,-0.021158,-0.00025744,-0.0036444,0.24271,0.051136,0.21201,0.16993},
      {0.40801,0.043177,0.074634,-0.021801,0.00026275,-0.0034534,0.21337,0.035757,0.2317,0.16851},
      {0.3952,0.06713,0.048723,-0.022141,0.0011408,-0.0033477,0.17184,0.017687,0.25467,0.16629},
      {0.36001,0.10683,0.022575,-0.021942,0.0058712,-0.001669,0.10468,0.00098452,0.2696,0.16019},
      {0.27038,0.18313,0.0066104,-0.019822,0.020597,0.0027519,-0.013607,-0.0018999,0.25282,0.14378},
      {0.17682,0.26508,-0.017991,-0.016262,0.035817,0.0054893,-0.13354,-0.004198,0.23581,0.12543},
      {0.099585,0.31439,-0.043864,-0.0061674,0.077605,0.027037,-0.20622,0.0076059,0.19843,0.085652},
      {0.04482,0.34674,-0.071398,0.0034998,0.11834,0.050844,-0.24767,0.025732,0.16172,0.049745},
      {0.011488,0.36314,-0.10082,0.010929,0.15492,0.074774,-0.26359,0.047968,0.13032,0.019966},
      {0.0059234,0.31855,-0.11806,0.013069,0.20956,0.10761,-0.23051,0.067183,0.097685,-0.029944},
      {0.0033599,0.27004,-0.13356,0.011536,0.25933,0.13797,-0.19405,0.081409,0.064105,-0.075092},
      {0.0014017,0.22168,-0.14916,0.0092826,0.30932,0.17154,-0.15815,0.095641,0.031513,-0.1181},
      {0.00088118,0.18717,-0.14925,0.0074956,0.35068,0.19701,-0.13318,0.09785,0.014835,-0.15606},
      {0.00064347,0.15478,-0.14827,0.0046611,0.38992,0.22036,-0.10999,0.1,0.00068983,-0.19288},
      {0.00042433,0.11747,-0.15568,0.0026561,0.42412,0.24105,-0.083501,0.10706,-0.020654,-0.22472},
      {0.00022305,0.078786,-0.17012,0.0017471,0.45176,0.2591,-0.056143,0.11787,-0.046949,-0.24938},
      {0.00017523,0.063279,-0.185,0.00094539,0.45295,0.25974,-0.045097,0.12862,-0.062078,-0.25054},
      {0.00012827,0.04966,-0.19663,0.00022689,0.45597,0.26163,-0.035399,0.13729,-0.074473,-0.25329},
      {8.26E-05,0.037961,-0.20492,-0.00034356,0.46085,0.26483,-0.027072,0.1438,-0.084092,-0.25763},
      {4.30E-05,0.026927,-0.22176,-0.00072451,0.45616,0.26267,-0.019269,0.15605,-0.097811,-0.25268},
      {3.86E-05,0.019218,-0.2463,-0.001067,0.43933,0.25315,-0.013794,0.17324,-0.11407,-0.2364},
      {6.36E-05,0.013554,-0.2697,-0.0013256,0.42141,0.24278,-0.0097331,0.18965,-0.12871,-0.21927},
      {0.00011166,0.0086645,-0.28817,-0.0014382,0.40785,0.23499,-0.0061918,0.20268,-0.14043,-0.20625},
      {0.00018783,0.0046469,-0.30171,-0.0013952,0.39855,0.22975,-0.0032426,0.21232,-0.14915,-0.19725},
      {0.00029701,0.0015925,-0.31029,-0.0011874,0.39345,0.22701,-0.00095398,0.21858,-0.15482,-0.19219},
      {0.00051767,0.00072267,-0.31926,-0.0010027,0.38537,0.22235,-0.0001693,0.22506,-0.15953,-0.18445},
      {0.00062083,0.00041642,-0.3254,-0.00087873,0.37958,0.21899,0.00012764,0.22948,-0.16263,-0.17891},
      {0.00063132,0.00020779,-0.32692,-0.00073368,0.37842,0.21833,0.00028874,0.23066,-0.16342,-0.17781},
      {0.00055342,7.77E-05,-0.32539,-0.00056477,0.38037,0.21948,0.00033046,0.2297,-0.16267,-0.17964},
      {0.00039108,8.09E-06,-0.32231,-0.00036935,0.38396,0.22162,0.00026831,0.22765,-0.16115,-0.18302},
      {0.00011175,8.02E-07,-0.32138,-0.00016915,0.3854,0.22247,7.74E-05,0.22714,-0.16072,-0.18438},
      {0.32169,0.016817,0.22667,-0.013553,-0.0014719,-0.004895,0.19253,0.15251,0.088445,0.17108},
      {0.32833,0.022847,0.20511,-0.013219,-0.0017478,-0.0052898,0.18019,0.13619,0.11115,0.17026},
      {0.33288,0.032016,0.17755,-0.012487,-0.0021499,-0.0070554,0.15981,0.11546,0.13953,0.16821},
      {0.32192,0.050173,0.14633,-0.012055,-0.0018443,-0.0097564,0.12042,0.093166,0.16693,0.164},
      {0.2975,0.081865,0.10738,-0.01144,-0.00064255,-0.013777,0.062261,0.067103,0.19692,0.15727},
      {0.2696,0.12386,0.052794,-0.010032,0.0013861,-0.019629,-0.0069557,0.031464,0.23799,0.14749},
      {0.18724,0.20703,0.023405,-0.0068125,0.017113,-0.015792,-0.11267,0.026563,0.22468,0.1301},
      {0.11351,0.29727,-0.016424,-0.0017062,0.032993,-0.011504,-0.21047,0.02025,0.21842,0.11349},
      {0.058659,0.35568,-0.053713,0.0059817,0.063277,0.0048108,-0.26692,0.027546,0.19824,0.086769},
      {0.027647,0.37226,-0.084335,0.011027,0.098301,0.025027,-0.27756,0.048061,0.16437,0.056781},
      {0.010225,0.37877,-0.11656,0.011834,0.12268,0.04245,-0.27546,0.068298,0.13408,0.039501},
      {0.005406,0.33885,-0.1355,0.010524,0.17029,0.073343,-0.24378,0.083883,0.10049,-0.0016605},
      {0.0032384,0.28877,-0.15088,0.0088256,0.22289,0.1083,-0.20627,0.09764,0.06646,-0.047139},
      {0.0015737,0.24027,-0.17007,0.0065954,0.27008,0.1433,-0.17067,0.11392,0.032318,-0.085072},
      {0.00090146,0.19774,-0.18062,0.0038663,0.31219,0.17167,-0.14022,0.12403,0.0068713,-0.12167},
      {0.00066117,0.15505,-0.19088,0.0030063,0.34657,0.19177,-0.10999,0.13187,-0.019422,-0.15427},
      {0.00043748,0.11311,-0.2044,0.0020524,0.37828,0.21187,-0.080327,0.14208,-0.046859,-0.18306},
      {0.00023555,0.073448,-0.22062,0.001146,0.40648,0.23171,-0.052312,0.15422,-0.074441,-0.20704},
      {0.00017383,0.057156,-0.23271,0.00041115,0.41198,0.23535,-0.04073,0.16319,-0.088427,-0.21191},
      {0.00012268,0.044408,-0.24649,-0.00018003,0.41218,0.23573,-0.031698,0.1735,-0.10135,-0.21186},
      {7.92E-05,0.032066,-0.26411,-0.00052627,0.40756,0.23351,-0.022967,0.18605,-0.11631,-0.20706},
      {4.27E-05,0.02117,-0.28091,-0.00079606,0.40251,0.23144,-0.01523,0.19787,-0.13024,-0.20152},
      {5.22E-05,0.014465,-0.30252,-0.0010651,0.38773,0.22316,-0.010429,0.21303,-0.14451,-0.18717},
      {9.55E-05,0.00943,-0.32135,-0.0012125,0.37392,0.21521,-0.0067812,0.22629,-0.1565,-0.17392},
      {0.00016703,0.005269,-0.33519,-0.0012027,0.36444,0.20984,-0.0037273,0.23613,-0.16547,-0.16475},
      {0.00027158,0.002073,-0.34403,-0.0010267,0.35919,0.20701,-0.0013354,0.24255,-0.17136,-0.15957},
      {0.00033077,0.00079941,-0.35426,-0.00097539,0.35047,0.20216,-0.00035823,0.24983,-0.17707,-0.15106},
      {0.00046684,0.0004764,-0.35976,-0.00085922,0.34528,0.19914,-2.57E-05,0.25379,-0.17985,-0.14612},
      {0.00050735,0.00025343,-0.36057,-0.00072148,0.34481,0.19886,0.00016725,0.25446,-0.18028,-0.14567},
      {0.00045684,0.00011124,-0.35828,-0.00055946,0.34749,0.20043,0.00023733,0.25296,-0.17915,-0.14822},
      {0.00031947,3.16E-05,-0.35438,-0.00037056,0.35187,0.20302,0.00020034,0.25033,-0.1772,-0.15236},
      {9.31E-05,8.44E-07,-0.35072,-0.00015897,0.35608,0.20553,6.42E-05,0.24789,-0.1754,-0.15632},
      {0.16891,0.0061288,0.44199,-0.006154,-0.0017429,-0.0059262,0.099178,0.31201,-0.1152,0.17388},
      {0.1754,0.010226,0.41706,-0.005948,-0.0020612,-0.0077657,0.089713,0.29338,-0.091165,0.17169},
      {0.18501,0.01671,0.37755,-0.0056105,-0.0025631,-0.01103,0.075022,0.26404,-0.053565,0.16792},
      {0.1961,0.0247,0.32682,-0.0050224,-0.003244,-0.016053,0.055954,0.22653,-0.0059809,0.16234},
      {0.1989,0.043525,0.26779,-0.0041342,-0.0032918,-0.022537,0.023144,0.18434,0.046138,0.15455},
      {0.18407,0.088261,0.19625,-0.0027407,-0.0016065,-0.029785,-0.037054,0.13653,0.10363,0.1441},
      {0.16904,0.14154,0.10791,-0.00044695,0.00028776,-0.039601,-0.10554,0.077996,0.1747,0.13077},
      {0.11625,0.22795,0.051561,0.004234,0.013596,-0.038383,-0.18736,0.058331,0.18918,0.11496},
      {0.069043,0.31237,-0.0037538,0.0070133,0.026273,-0.049893,-0.24807,0.046576,0.19032,0.091657},
      {0.037929,0.3735,-0.059519,0.0088549,0.041841,-0.051227,-0.28601,0.0403,0.18996,0.072082},
      {0.021264,0.38044,-0.092183,0.0095035,0.068639,-0.030982,-0.2823,0.060384,0.15937,0.053876},
      {0.0098612,0.39039,-0.12545,0.01003,0.087557,-0.0040191,-0.28177,0.080702,0.13572,0.051802},
      {0.0047643,0.3694,-0.15007,0.0089508,0.12252,0.030758,-0.26299,0.098197,0.10855,0.032189},
      {0.003011,0.31638,-0.16987,0.0060442,0.17524,0.069058,-0.22393,0.1154,0.071963,-0.010814},
      {0.0016945,0.2536,-0.20213,0.0046365,0.21819,0.10155,-0.17952,0.13907,0.024205,-0.04505},
      {0.0009233,0.19816,-0.23325,0.0034586,0.25421,0.13155,-0.14034,0.16178,-0.019014,-0.071624},
      {0.00067536,0.1523,-0.2458,0.0024032,0.29079,0.15421,-0.10791,0.17138,-0.047889,-0.10526},
      {0.00045102,0.10908,-0.26091,0.0014124,0.3236,0.17647,-0.077385,0.18279,-0.076662,-0.13387},
      {0.00025142,0.069672,-0.28116,0.0006392,0.34887,0.19627,-0.049616,0.19779,-0.10607,-0.15368},
      {0.0001672,0.050896,-0.30089,3.88E-05,0.35006,0.19842,-0.036379,0.21218,-0.12504,-0.15359},
      {0.0001189,0.037453,-0.31733,-0.00027074,0.34743,0.19724,-0.026861,0.22375,-0.14007,-0.15078},
      {7.69E-05,0.025825,-0.33214,-0.00055437,0.34506,0.19665,-0.018596,0.23417,-0.15339,-0.14787},
      {4.33E-05,0.016046,-0.34717,-0.00078631,0.34108,0.19558,-0.011616,0.24478,-0.16588,-0.14304},
      {6.68E-05,0.010066,-0.36493,-0.00095973,0.32968,0.1894,-0.0072953,0.25729,-0.17783,-0.13179},
      {0.0001327,0.0057453,-0.37891,-0.0009888,0.32019,0.18401,-0.0041234,0.2672,-0.18698,-0.12263},
      {0.00021542,0.00285,-0.38901,-0.0008667,0.31334,0.18023,-0.0019525,0.27446,-0.19339,-0.11593},
      {0.00024539,0.0013597,-0.39658,-0.00087564,0.30748,0.17704,-0.00083639,0.27982,-0.19793,-0.11015},
      {0.00029293,0.00053082,-0.40313,-0.00083863,0.30199,0.17408,-0.00018934,0.28448,-0.20158,-0.10473},
      {0.00036779,0.00029462,-0.40283,-0.00070979,0.30259,0.17441,3.78E-05,0.28435,-0.20145,-0.10532},
      {0.00034886,0.00014114,-0.39939,-0.00055618,0.30638,0.17661,0.00013866,0.28203,-0.19974,-0.10894},
      {0.00024051,5.21E-05,-0.39431,-0.00037522,0.3119,0.17984,0.0001293,0.27856,-0.1972,-0.11418},
      {4.68E-05,1.00E-05,-0.389,-0.00016446,0.31776,0.18332,2.48E-05,0.27495,-0.19456,-0.11971},
      {0.061134,0.0069095,0.59248,-0.0018602,-0.0012276,-0.0054649,0.027991,0.42134,-0.25494,0.17726},
      {0.063136,0.0064745,0.58734,-0.0016584,-0.0013936,-0.0065044,0.026915,0.41736,-0.25016,0.17619},
      {0.067489,0.0075683,0.57181,-0.0013371,-0.0016889,-0.0088825,0.022842,0.40576,-0.23596,0.17372},
      {0.079816,0.014631,0.52022,-0.0007054,-0.0023106,-0.015276,0.0087978,0.36795,-0.18906,0.167},
      {0.091587,0.023003,0.46228,0.00029647,-0.0030262,-0.023887,-0.0085597,0.32565,-0.13728,0.15823},
      {0.10178,0.035135,0.39616,0.0011817,-0.0033585,-0.037649,-0.028588,0.27823,-0.08106,0.14484},
      {0.097862,0.086243,0.29368,0.002375,-0.0014888,-0.060538,-0.08125,0.21026,-0.0020951,0.12149},
      {0.092902,0.14282,0.17835,0.0038084,0.00026339,-0.097714,-0.13476,0.13489,0.082016,0.086809},
      {0.07034,0.21776,0.089473,0.0056206,0.0074353,-0.12147,-0.18788,0.091623,0.12547,0.058843},
      {0.043956,0.30198,0.017319,0.0074855,0.015756,-0.12491,-0.23766,0.070584,0.14744,0.047184},
      {0.025801,0.38289,-0.061083,0.0090529,0.021286,-0.1233,-0.28512,0.047353,0.17867,0.043506},
      {0.015172,0.39398,-0.094833,0.0091525,0.041963,-0.092517,-0.28437,0.067675,0.15568,0.042505},
      {0.0079845,0.40641,-0.12982,0.0079814,0.055751,-0.056561,-0.28758,0.089807,0.1383,0.055092},
      {0.0042053,0.38832,-0.1635,0.007035,0.074994,-0.023754,-0.2745,0.11087,0.11134,0.055814},
      {0.0028174,0.31922,-0.19589,0.0054436,0.12387,0.011441,-0.22563,0.13469,0.060388,0.015349},
      {0.0017127,0.25394,-0.24105,0.0039858,0.16227,0.04877,-0.17952,0.16743,0.0051883,-0.0084325},
      {0.00092239,0.19416,-0.29403,0.0027139,0.19133,0.086674,-0.13735,0.2056,-0.050966,-0.018463},
      {0.00066492,0.14652,-0.30939,0.0016836,0.22837,0.11135,-0.10373,0.21719,-0.082071,-0.051117},
      {0.00042525,0.10267,-0.33247,0.0007731,0.25547,0.13229,-0.072863,0.23426,-0.11506,-0.072606},
      {0.0002467,0.064344,-0.36083,0.00033504,0.27194,0.14831,-0.045935,0.25461,-0.14818,-0.082956},
      {0.00015877,0.042558,-0.38143,3.92E-05,0.27619,0.15398,-0.030578,0.26917,-0.16939,-0.084339},
      {0.00011077,0.030212,-0.39335,-0.00026822,0.27741,0.15541,-0.021791,0.27755,-0.18163,-0.084914},
      {7.15E-05,0.019745,-0.4057,-0.00052291,0.27678,0.15622,-0.014312,0.28626,-0.19314,-0.083338},
      {4.26E-05,0.011195,-0.42016,-0.0007012,0.27259,0.15544,-0.0081718,0.2965,-0.20473,-0.07796},
      {7.85E-05,0.0059413,-0.43437,-0.00076687,0.26443,0.15144,-0.0043375,0.30657,-0.21449,-0.069555},
      {0.00014194,0.003606,-0.44158,-0.00072574,0.2598,0.14889,-0.0025717,0.31172,-0.21923,-0.06502},
      {0.00018025,0.0019822,-0.44548,-0.00074701,0.25768,0.14781,-0.001351,0.31448,-0.22201,-0.062869},
      {0.00019742,0.00088771,-0.45041,-0.00074939,0.25416,0.14606,-0.00052708,0.31797,-0.22503,-0.059261},
      {0.00022093,0.00032363,-0.45408,-0.00070112,0.25137,0.14473,-8.82E-05,0.3206,-0.22713,-0.056365},
      {0.00023657,0.00016161,-0.44902,-0.00055733,0.25674,0.14783,4.37E-05,0.31712,-0.22459,-0.061511},
      {0.00016026,6.54E-05,-0.44232,-0.00038568,0.26383,0.15195,6.26E-05,0.3125,-0.22124,-0.068269},
      {-6.49E-08,1.78E-05,-0.43536,-0.00018533,0.27129,0.15634,-1.39E-05,0.30772,-0.21777,-0.075337},
      {0.013544,0.0060925,0.66988,-0.00021537,-0.00054533,-0.0040411,0.00097199,0.47503,-0.3233,0.18028},
      {0.015835,0.0058986,0.6645,-0.00018496,-0.00064746,-0.0051556,0.0012821,0.47097,-0.31856,0.17919},
      {0.018675,0.0056353,0.65734,-0.00013348,-0.00078629,-0.0068462,0.0014929,0.46556,-0.31233,0.17755},
      {0.021417,0.005342,0.6494,-5.57E-05,-0.00094465,-0.0091377,0.0013447,0.45953,-0.30555,0.17539},
      {0.031114,0.0099758,0.60189,0.00049332,-0.0014372,-0.021281,-0.0085214,0.42524,-0.26563,0.16415},
      {0.039752,0.015644,0.54849,0.0011914,-0.0019377,-0.03886,-0.020384,0.38696,-0.22257,0.14834},
      {0.047052,0.022325,0.49413,0.0019032,-0.002459,-0.062506,-0.03079,0.34842,-0.18154,0.12744},
      {0.048293,0.078441,0.37151,0.0032511,-0.0012935,-0.10676,-0.076018,0.26819,-0.093369,0.087185},
      {0.047243,0.14165,0.23728,0.0049047,-0.00022781,-0.16555,-0.12295,0.18151,-0.0014355,0.035479},
      {0.038644,0.21538,0.12018,0.0066123,0.002967,-0.20913,-0.16983,0.11607,0.068163,-0.004281},
      {0.024338,0.29909,0.037684,0.0077329,0.0081818,-0.20359,-0.21834,0.08974,0.10625,-0.0035258},
      {0.016245,0.37168,-0.047172,0.0080799,0.010859,-0.19669,-0.26367,0.061266,0.15074,0.00095403},
      {0.011187,0.37759,-0.091599,0.0074404,0.022524,-0.17462,-0.26759,0.068332,0.14391,0.0039554},
      {0.0069185,0.37505,-0.12965,0.0066465,0.032481,-0.13806,-0.26529,0.09129,0.12242,0.021315},
      {0.0037257,0.37857,-0.17385,0.0058368,0.037119,-0.091987,-0.26728,0.11963,0.10127,0.053927},
      {0.002516,0.31211,-0.21982,0.0042154,0.078161,-0.051329,-0.22029,0.15289,0.045109,0.029162},
      {0.0015975,0.24534,-0.28032,0.0029784,0.11011,-0.0082983,-0.17318,0.1963,-0.018391,0.019283},
      {0.00086693,0.18235,-0.35626,0.0018688,0.1299,0.036904,-0.1289,0.25057,-0.087515,0.028559},
      {0.00056138,0.13295,-0.38596,0.00085962,0.16033,0.064688,-0.094148,0.27224,-0.12662,0.0079533},
      {0.00036779,0.091067,-0.40973,0.00060811,0.18458,0.085073,-0.064719,0.28913,-0.15936,-0.009942},
      {0.00022515,0.056334,-0.43944,0.00034059,0.19702,0.1002,-0.04032,0.31022,-0.19146,-0.015247},
      {0.00014008,0.03378,-0.46379,4.97E-05,0.20075,0.10828,-0.024425,0.32748,-0.21487,-0.013892},
      {9.48E-05,0.022676,-0.47263,-0.00023666,0.20426,0.11144,-0.016479,0.33371,-0.22496,-0.016311},
      {6.03E-05,0.013504,-0.48385,-0.000445,0.20393,0.11285,-0.0098851,0.34164,-0.23526,-0.014666},
      {3.50E-05,0.0073964,-0.49598,-0.00051839,0.20022,0.11287,-0.0054415,0.35029,-0.24444,-0.0093146},
      {6.16E-05,0.0042032,-0.50073,-0.00057476,0.19971,0.11362,-0.0030852,0.35365,-0.24845,-0.007968},
      {0.00010957,0.0024821,-0.50024,-0.00060795,0.20202,0.11505,-0.0017842,0.3533,-0.24909,-0.010104},
      {0.00013597,0.0012944,-0.50104,-0.0006215,0.20266,0.11565,-0.00088338,0.35386,-0.2501,-0.010521},
      {0.00013814,0.00053718,-0.50463,-0.00061852,0.20026,0.11466,-0.00031252,0.3564,-0.25228,-0.0078894},
      {0.00012892,0.00016702,-0.50725,-0.00056617,0.19846,0.11401,-3.70E-05,0.35829,-0.25377,-0.0058441},
      {8.64E-05,6.76E-05,-0.49842,-0.00040504,0.20763,0.11933,8.68E-06,0.35216,-0.24934,-0.014607},
      {-1.59E-07,2.67E-05,-0.48654,-0.00023145,0.21985,0.12641,-2.04E-05,0.34388,-0.24338,-0.026278},
      {0.0033448,0.0040353,0.69347,-0.00015109,-0.00013519,-0.0025858,-0.0011468,0.4906,-0.34265,0.18218},
      {0.0044837,0.0040209,0.68977,-0.00012737,-0.00020418,-0.0038575,-0.0011806,0.48791,-0.33972,0.181},
      {0.006022,0.0040289,0.68448,-9.14E-05,-0.0003003,-0.0058475,-0.0012588,0.48407,-0.3356,0.17918},
      {0.0077552,0.0040982,0.67793,-4.30E-05,-0.00041389,-0.0086661,-0.0014099,0.47934,-0.33064,0.17663},
      {0.0094047,0.0042837,0.67062,1.73E-05,-0.00052977,-0.012442,-0.0016598,0.47406,-0.32534,0.17327},
      {0.013756,0.0085086,0.63669,0.00044941,-0.00084905,-0.029053,-0.0074181,0.45003,-0.30049,0.1587},
      {0.018089,0.01589,0.58839,0.0011195,-0.0012049,-0.05693,-0.015741,0.41599,-0.26686,0.1346},
      {0.019995,0.024956,0.54071,0.0018299,-0.0013996,-0.091737,-0.023202,0.38259,-0.23662,0.10501},
      {0.019953,0.077637,0.4228,0.0032994,-0.00061367,-0.15189,-0.059306,0.3061,-0.15816,0.053438},
      {0.019044,0.14466,0.27677,0.0049765,0.00037439,-0.23119,-0.10264,0.21246,-0.063183,-0.013549},
      {0.019747,0.19902,0.12853,0.0059431,0.0011163,-0.31158,-0.14246,0.11935,0.030782,-0.081894},
      {0.015368,0.25626,0.043146,0.0060788,0.0036539,-0.30752,-0.18293,0.08613,0.078018,-0.080904},
      {0.011921,0.30583,-0.030209,0.0060486,0.0050477,-0.30275,-0.21746,0.059386,0.11767,-0.077676},
      {0.0086208,0.32669,-0.081889,0.0055328,0.010119,-0.27847,-0.23139,0.061826,0.12282,-0.063532},
      {0.005497,0.33007,-0.12735,0.0046589,0.015898,-0.22958,-0.23309,0.090982,0.10098,-0.030167},
      {0.0032557,0.33653,-0.18251,0.0041798,0.018496,-0.1665,-0.23712,0.12776,0.075967,0.019229},
      {0.0020892,0.29134,-0.24633,0.0028147,0.041867,-0.11144,-0.20516,0.17303,0.021657,0.03174},
      {0.0013395,0.22463,-0.32164,0.0012528,0.066495,-0.063441,-0.15826,0.2271,-0.048803,0.036384},
      {0.00075347,0.16198,-0.40559,0.0011404,0.081975,-0.013791,-0.11445,0.28618,-0.12208,0.055388},
      {0.00044273,0.1135,-0.45583,0.00092208,0.10198,0.021803,-0.080444,0.32166,-0.17137,0.05621},
      {0.00028967,0.076212,-0.48147,0.00062066,0.12117,0.040892,-0.054245,0.3399,-0.2027,0.044502},
      {0.00017956,0.045986,-0.5135,0.00032669,0.12814,0.054432,-0.033004,0.36267,-0.23367,0.045728},
      {0.00010858,0.024289,-0.54656,5.08E-05,0.12539,0.062227,-0.017724,0.38612,-0.26093,0.056155},
      {6.46E-05,0.015634,-0.5491,-0.0001745,0.13351,0.068777,-0.011464,0.38793,-0.26666,0.049925},
      {3.54E-05,0.0095885,-0.5519,-0.00030542,0.13906,0.074185,-0.007058,0.38995,-0.27118,0.046434},
      {2.18E-05,0.0053868,-0.55577,-0.00040354,0.14158,0.077859,-0.0040011,0.39268,-0.2753,0.045862},
      {3.68E-05,0.0027955,-0.5594,-0.00046228,0.14199,0.079562,-0.0020867,0.39524,-0.27845,0.046693},
      {7.35E-05,0.001557,-0.55545,-0.00048617,0.14737,0.08285,-0.0011378,0.39243,-0.27711,0.041685},
      {8.55E-05,0.00074775,-0.55455,-0.00049303,0.14944,0.084387,-0.00051857,0.3918,-0.27709,0.039992},
      {7.04E-05,0.00027191,-0.55812,-0.00048576,0.14691,0.083463,-0.00016372,0.39432,-0.27913,0.042855},
      {2.85E-05,6.14E-05,-0.56139,-0.00043445,0.14449,0.082633,-2.75E-05,0.39666,-0.28087,0.045644},
      {-3.14E-07,3.38E-05,-0.54191,-0.00026624,0.16415,0.093916,-2.57E-05,0.383,-0.27107,0.02677},
      {0.0012572,0.0024079,0.69934,-0.00032742,2.51E-06,-0.0024859,-0.00046457,0.49445,-0.34778,0.18242},
      {0.0014492,0.002501,0.6989,-0.00022949,1.43E-06,-0.0028497,-0.00049666,0.49421,-0.34744,0.18211},
      {0.0020286,0.0026664,0.69601,-0.00015484,-3.57E-05,-0.0046785,-0.00062425,0.49218,-0.34543,0.18051},
      {0.0028586,0.0029534,0.69088,-0.0001066,-9.87E-05,-0.0081077,-0.00085148,0.48851,-0.34202,0.17752},
      {0.0036325,0.003398,0.68483,-4.76E-05,-0.00015693,-0.012683,-0.0011309,0.4842,-0.33818,0.17358},
      {0.0041906,0.0040576,0.67811,1.99E-05,-0.00019467,-0.018568,-0.0014404,0.47942,-0.33422,0.16857},
      {0.0050895,0.0086725,0.6538,0.00035118,-0.00025309,-0.038038,-0.004545,0.46238,-0.3194,0.1521},
      {0.0069506,0.017412,0.59847,0.00092529,-0.00042613,-0.083337,-0.011144,0.42367,-0.28595,0.11388},
      {0.0084573,0.026215,0.53084,0.0014271,-0.00059774,-0.14322,-0.018025,0.37639,-0.24652,0.063587},
      {0.010264,0.062311,0.40542,0.0023454,-0.00047607,-0.22724,-0.044736,0.29299,-0.1675,-0.0071903},
      {0.011825,0.11015,0.25267,0.0033443,-0.00030523,-0.32563,-0.079846,0.19267,-0.070826,-0.089789},
      {0.012522,0.14976,0.10733,0.0040146,-0.00026633,-0.43059,-0.10881,0.096749,0.01782,-0.17729},
      {0.0098496,0.19819,0.035085,0.0040315,0.0010784,-0.42687,-0.1421,0.069445,0.057731,-0.17483},
      {0.0078355,0.24033,-0.022392,0.0040619,0.0018393,-0.41397,-0.17037,0.052347,0.08761,-0.16404},
      {0.006087,0.26791,-0.070583,0.0036671,0.0034239,-0.38633,-0.18848,0.053729,0.098003,-0.14226},
      {0.0039836,0.27545,-0.12741,0.0026953,0.0067904,-0.31913,-0.19325,0.091977,0.073057,-0.090497},
      {0.0025323,0.28381,-0.1928,0.0014133,0.0076918,-0.24131,-0.19913,0.13731,0.044911,-0.026769},
      {0.0016357,0.25668,-0.26546,0.0014181,0.018919,-0.17225,-0.18052,0.18776,-0.0049152,0.014441},
      {0.0010423,0.19192,-0.34888,0.0012582,0.037402,-0.12056,-0.13521,0.24648,-0.078965,0.030823},
      {0.00058811,0.13559,-0.44159,0.001108,0.046422,-0.064444,-0.095803,0.3118,-0.15341,0.064457},
      {0.00030594,0.090207,-0.51814,0.00090988,0.054126,-0.016221,-0.064,0.36583,-0.21426,0.093423},
      {0.0001906,0.05795,-0.54671,0.00057894,0.066773,0.00073382,-0.041328,0.38616,-0.24451,0.089333},
      {0.00010963,0.033839,-0.57674,0.00028634,0.071761,0.015533,-0.02436,0.40753,-0.27141,0.09445},
      {5.28E-05,0.017418,-0.608,4.05E-05,0.068628,0.026545,-0.012761,0.42973,-0.29512,0.10809},
      {2.80E-05,0.011129,-0.60311,-0.0001103,0.082837,0.037875,-0.0082172,0.42628,-0.29592,0.097075},
      {1.45E-05,0.0067868,-0.60107,-0.00022249,0.091406,0.045035,-0.0050555,0.42483,-0.29716,0.090706},
      {8.39E-06,0.0036406,-0.60536,-0.0003017,0.092531,0.048002,-0.0027491,0.42785,-0.30094,0.091551},
      {1.43E-05,0.0016393,-0.61172,-0.00034652,0.090177,0.048697,-0.0012597,0.43233,-0.30515,0.095508},
      {3.70E-05,0.00082242,-0.60583,-0.00036215,0.097184,0.053031,-0.00062277,0.42816,-0.30264,0.089038},
      {3.22E-05,0.0003335,-0.60468,-0.00036334,0.09933,0.054752,-0.00024683,0.42734,-0.30233,0.087383},
      {4.11E-07,0.00014613,-0.60371,-0.00033966,0.10116,0.05645,-0.00011359,0.42667,-0.30195,0.086163},
      {-5.43E-07,3.84E-05,-0.60004,-0.00028515,0.10556,0.059607,-2.91E-05,0.4241,-0.30015,0.082458},
      {0.00063938,0.0012509,0.70005,-0.00075673,4.18E-05,-0.0036132,4.21E-05,0.49455,-0.34911,0.18149},
      {0.00077056,0.0013105,0.6994,-0.00062017,4.16E-05,-0.0043359,2.70E-05,0.49419,-0.34866,0.18088},
      {0.00096421,0.0013931,0.69831,-0.00041327,4.13E-05,-0.0055438,7.73E-06,0.49358,-0.34794,0.17986},
      {0.0012156,0.0014896,0.69668,-0.0001351,4.12E-05,-0.0074038,-1.16E-05,0.49264,-0.34689,0.17829},
      {0.0016803,0.0019331,0.68877,-9.40E-05,1.86E-06,-0.014886,-0.00026783,0.48706,-0.34244,0.17197},
      {0.0021811,0.0024129,0.67801,-5.28E-05,-4.22E-05,-0.025495,-0.00056539,0.47946,-0.33651,0.16302},
      {0.0026814,0.002893,0.66374,-1.10E-05,-8.80E-05,-0.040108,-0.00089089,0.4694,-0.32883,0.15074},
      {0.0033839,0.0056373,0.63113,0.00014789,-0.00016638,-0.071562,-0.0030403,0.44653,-0.31064,0.12436},
      {0.0044305,0.013818,0.55589,0.00054962,-0.00031166,-0.14226,-0.0095455,0.39394,-0.26809,0.065176},
      {0.0051167,0.021974,0.46662,0.0008845,-0.00042893,-0.23002,-0.016105,0.33156,-0.21888,-0.0080878},
      {0.0058161,0.044461,0.34824,0.0014417,-0.00049841,-0.32979,-0.032798,0.25126,-0.14995,-0.091389},
      {0.0064841,0.080005,0.21318,0.0021139,-0.00047743,-0.4301,-0.058347,0.1618,-0.068369,-0.17493},
      {0.0065682,0.10798,0.088717,0.0024557,-0.0004413,-0.53245,-0.077921,0.078895,0.0040409,-0.25971},
      {0.0054314,0.14506,0.02117,0.0023445,0.00015322,-0.54272,-0.10271,0.050086,0.040852,-0.26787},
      {0.0044396,0.1804,-0.021834,0.0017215,0.00046303,-0.52198,-0.12607,0.042581,0.062265,-0.24983},
      {0.0039856,0.20942,-0.054491,0.0010727,0.00050917,-0.49331,-0.14563,0.042571,0.076336,-0.22551},
      {0.0028083,0.21899,-0.12012,0.0011798,0.0027694,-0.40679,-0.15309,0.087316,0.048496,-0.15695},
      {0.0018694,0.22271,-0.19271,0.0012748,0.0039713,-0.3199,-0.15625,0.13735,0.014194,-0.086569},
      {0.001164,0.21196,-0.27286,0.0013064,0.0065214,-0.23776,-0.14905,0.19316,-0.031169,-0.022054},
      {0.0007136,0.15421,-0.36589,0.0011135,0.017336,-0.17987,-0.10864,0.25873,-0.10646,0.010474},
      {0.00038101,0.10441,-0.46686,0.0009474,0.020776,-0.11614,-0.073774,0.32993,-0.18173,0.058433},
      {0.00016375,0.064125,-0.56832,0.00080742,0.022189,-0.044057,-0.045553,0.40154,-0.25247,0.11622},
      {8.42E-05,0.039503,-0.59374,0.00045805,0.032976,-0.0252,-0.028221,0.41968,-0.27731,0.11637},
      {3.65E-05,0.023564,-0.6169,0.00022355,0.038045,-0.0086735,-0.017001,0.43615,-0.29672,0.1228},
      {1.20E-05,0.013081,-0.6376,7.08E-05,0.039492,0.0051209,-0.0096239,0.4508,-0.31219,0.13217},
      {-1.53E-07,0.0075288,-0.64082,-5.34E-05,0.046985,0.015016,-0.0056406,0.45306,-0.3166,0.12961},
      {-5.19E-06,0.0043442,-0.64007,-0.00014498,0.053179,0.020892,-0.0033024,0.45252,-0.31789,0.12559},
      {-5.16E-06,0.0021436,-0.64513,-0.00020341,0.052719,0.023093,-0.0016684,0.45608,-0.32156,0.12807},
      {-1.84E-06,0.00076674,-0.65542,-0.00022846,0.046398,0.022129,-0.00062366,0.46333,-0.32741,0.13635},
      {4.36E-06,0.00042885,-0.6453,-0.00023489,0.05732,0.028874,-0.00034101,0.45617,-0.32254,0.12626},
      {-3.91E-06,0.00025511,-0.63694,-0.00022491,0.066255,0.03441,-0.00020332,0.45026,-0.31846,0.11802},
      {-2.65E-06,0.00013073,-0.63138,-0.00019951,0.072423,0.038456,-0.00010512,0.44634,-0.31573,0.11251},
      {0.00017069,0.00067328,0.69848,-0.0011523,5.49E-05,-0.0060395,0.00028392,0.49322,-0.34899,0.1795},
      {0.00027287,0.00069884,0.69742,-0.0010199,5.51E-05,-0.0072867,0.00028193,0.49257,-0.34837,0.17845},
      {0.00042488,0.00073343,0.6957,-0.00082185,5.54E-05,-0.0093017,0.00028095,0.49152,-0.34738,0.17676},
      {0.00062098,0.00077496,0.69312,-0.00057271,5.67E-05,-0.012315,0.00028161,0.4899,-0.34593,0.17424},
      {0.00085174,0.00082108,0.68937,-0.00028593,6.01E-05,-0.016654,0.00028116,0.4875,-0.34388,0.1706},
      {0.0011692,0.001069,0.67824,-0.00014794,4.05E-05,-0.028618,0.00010254,0.47976,-0.33799,0.16057},
      {0.0015263,0.0014563,0.65932,-0.00011475,4.42E-06,-0.048962,-0.0002167,0.46643,-0.32812,0.14353},
      {0.0018587,0.0018334,0.63505,-6.13E-05,-2.97E-05,-0.07552,-0.00055811,0.44935,-0.31559,0.12132},
      {0.0021811,0.0031864,0.59675,4.49E-05,-7.41E-05,-0.11666,-0.0017035,0.42244,-0.29555,0.086959},
      {0.0025809,0.010446,0.50285,0.00034406,-0.00020213,-0.21203,-0.0075076,0.35673,-0.24479,0.0074374},
      {0.0027081,0.017358,0.39674,0.00058412,-0.00027908,-0.323,-0.012972,0.28244,-0.18842,-0.0849},
      {0.0027226,0.030177,0.27924,0.00082116,-0.00025304,-0.4394,-0.022294,0.20136,-0.1246,-0.1815},
      {0.0028135,0.054665,0.16563,0.0009847,-0.00011629,-0.53568,-0.039036,0.12551,-0.059033,-0.26096},
      {0.002535,0.072162,0.064395,0.00073293,8.98E-05,-0.6308,-0.050219,0.057505,-0.00298,-0.33905},
      {0.0026306,0.10068,0.0095122,0.00080619,0.00012626,-0.63894,-0.070032,0.032318,0.028908,-0.34577},
      {0.0026275,0.13334,-0.018775,0.00085135,0.00020508,-0.59999,-0.092859,0.033041,0.044522,-0.31355},
      {0.0025636,0.15854,-0.042198,0.00086832,0.00024783,-0.56741,-0.11049,0.035242,0.055399,-0.28656},
      {0.0018832,0.1662,-0.10589,0.00093191,0.0011476,-0.48987,-0.11625,0.076901,0.029182,-0.2235},
      {0.0012099,0.16498,-0.18649,0.00098349,0.0016515,-0.3997,-0.11575,0.13298,-0.011623,-0.1494},
      {0.00073056,0.15723,-0.27512,0.0010074,0.0017523,-0.30766,-0.11052,0.19511,-0.059772,-0.073161},
      {0.00042306,0.11275,-0.37598,0.00082768,0.0068944,-0.23487,-0.079392,0.26627,-0.13232,-0.020135},
      {0.00019702,0.072056,-0.48027,0.00063192,0.009048,-0.15883,-0.050892,0.3399,-0.20466,0.039872},
      {5.46E-05,0.042375,-0.58388,0.00053062,0.00899,-0.074416,-0.030126,0.41301,-0.27117,0.11},
      {7.04E-06,0.026955,-0.62076,0.00039442,0.015629,-0.038635,-0.019329,0.43906,-0.29719,0.13015},
      {-1.44E-05,0.016431,-0.63936,0.00023126,0.019563,-0.023013,-0.011932,0.45222,-0.31162,0.13746},
      {-2.37E-05,0.008873,-0.65805,9.63E-05,0.019291,-0.01117,-0.0065997,0.46541,-0.32463,0.14767},
      {-2.46E-05,0.0044783,-0.66783,-6.71E-06,0.020821,-0.0027828,-0.0034486,0.47229,-0.33167,0.15243},
      {-2.26E-05,0.0023229,-0.66865,-7.58E-05,0.024537,0.001805,-0.0018429,0.47285,-0.33321,0.15089},
      {-1.62E-05,0.0012017,-0.67092,-0.00011307,0.025842,0.0050835,-0.00097285,0.47442,-0.33493,0.15174},
      {-9.31E-06,0.0005829,-0.67604,-0.00012214,0.024036,0.0068635,-0.00046849,0.47802,-0.3378,0.15581},
      {-6.76E-06,0.000369,-0.66627,-0.00012957,0.0346,0.013535,-0.00029707,0.47108,-0.33302,0.14617},
      {-5.46E-06,0.00023667,-0.65709,-0.00012069,0.044138,0.019249,-0.00019363,0.46459,-0.3285,0.13721},
      {-0.00026021,0.00039615,0.6979,-0.0017344,7.55E-05,-0.0064416,0.00038934,0.49252,-0.3493,0.17917},
      {-0.00018023,0.00040602,0.69626,-0.0016096,7.72E-05,-0.0083758,0.00038669,0.49147,-0.34842,0.17755},
      {-6.05E-05,0.00041922,0.69365,-0.0014218,8.00E-05,-0.011459,0.00038296,0.48978,-0.34702,0.17498},
      {9.78E-05,0.00043366,0.68985,-0.0011716,8.41E-05,-0.015926,0.00037849,0.48733,-0.345,0.17124},
      {0.00029011,0.00044632,0.68463,-0.0008655,8.98E-05,-0.02205,0.00037388,0.48393,-0.34226,0.16613},
      {0.00050881,0.00045368,0.6777,-0.00051647,9.73E-05,-0.030156,0.00036996,0.47937,-0.33866,0.15936},
      {0.00074572,0.00055326,0.66339,-0.00024138,9.58E-05,-0.046376,0.00026943,0.46954,-0.33132,0.14582},
      {0.0009752,0.0008478,0.63365,-0.00015172,7.78E-05,-0.079676,-3.53E-05,0.44862,-0.31616,0.11803},
      {0.0011666,0.0011283,0.59692,-6.31E-05,7.24E-05,-0.12115,-0.0003442,0.42276,-0.29754,0.083461},
      {0.001301,0.0013823,0.55208,1.19E-05,8.66E-05,-0.17215,-0.00064229,0.39115,-0.27492,0.040985},
      {0.0012677,0.0073853,0.44388,0.00018479,9.38E-05,-0.2879,-0.0052483,0.31534,-0.21819,-0.055114},
      {0.0010862,0.012888,0.32479,0.00029184,0.00018061,-0.41776,-0.0093361,0.23188,-0.15651,-0.16274},
      {0.0010407,0.019473,0.20793,0.00040323,0.00017779,-0.54293,-0.014141,0.15026,-0.095522,-0.26651},
      {0.0012841,0.037034,0.12539,0.00049926,0.00012487,-0.61299,-0.026146,0.094869,-0.04763,-0.3244},
      {0.0014094,0.051222,0.054516,0.00056878,6.64E-05,-0.67496,-0.035864,0.046946,-0.0067462,-0.37558},
      {0.0014501,0.06934,0.0067742,0.00060772,4.98E-05,-0.69585,-0.048432,0.02142,0.020244,-0.39279},
      {0.0014644,0.09486,-0.015305,0.00061585,9.16E-05,-0.66117,-0.066264,0.024597,0.030667,-0.36407},
      {0.0014756,0.1135,-0.034505,0.00059309,9.61E-05,-0.63172,-0.079262,0.029489,0.036492,-0.33966},
      {0.0011717,0.11837,-0.090213,0.00059608,0.00036859,-0.5672,-0.082799,0.065536,0.013195,-0.28653},
      {0.00072989,0.11214,-0.18104,0.00059366,0.00058994,-0.47058,-0.078627,0.12926,-0.035267,-0.20666},
      {0.00038658,0.10059,-0.2778,0.00050445,0.00047941,-0.37327,-0.070637,0.19754,-0.08941,-0.12575},
      {0.00017532,0.074722,-0.38049,0.00038904,0.0020073,-0.28265,-0.052564,0.27007,-0.15362,-0.052751},
      {6.44E-05,0.050414,-0.48234,0.00042229,0.0036828,-0.19084,-0.03562,0.3418,-0.2166,0.02102},
      {-1.66E-05,0.030429,-0.58096,0.00044086,0.0041715,-0.099814,-0.021693,0.41128,-0.27578,0.095852},
      {-5.30E-05,0.017335,-0.63767,0.00036222,0.0061443,-0.046596,-0.012545,0.45126,-0.31055,0.13717},
      {-5.86E-05,0.0099573,-0.65472,0.00021802,0.0076076,-0.03346,-0.0073473,0.46328,-0.32263,0.14597},
      {-5.46E-05,0.0049653,-0.67109,0.00010544,0.0062542,-0.023259,-0.0038041,0.47479,-0.33318,0.15637},
      {-3.95E-05,0.0025458,-0.68128,2.55E-05,0.0063576,-0.014686,-0.0020385,0.48191,-0.3394,0.16333},
      {-3.02E-05,0.0015082,-0.68009,-2.31E-05,0.010877,-0.0097378,-0.0012294,0.48103,-0.33934,0.16094},
      {-2.19E-05,0.00093365,-0.68061,-4.91E-05,0.012986,-0.0063899,-0.00077055,0.48136,-0.33989,0.16069},
      {-1.39E-05,0.00057647,-0.68194,-6.07E-05,0.014158,-0.0034519,-0.00047725,0.48226,-0.34073,0.16144},
      {-8.86E-06,0.00034853,-0.67831,-6.06E-05,0.019457,0.0011341,-0.00028894,0.47966,-0.33902,0.15763},
      {-0.00041393,0.00026781,0.69874,-0.0013315,8.74E-05,-0.006121,0.00037487,0.49351,-0.34975,0.17944},
      {-0.00040229,0.00024759,0.69815,-0.0013969,9.14E-05,-0.0066788,0.00039683,0.49308,-0.34952,0.17897},
      {-0.00035684,0.00022806,0.69628,-0.0013928,9.67E-05,-0.0087562,0.00041629,0.4918,-0.34861,0.17723},
      {-0.00023021,0.00022646,0.69126,-0.0011666,0.00010213,-0.014629,0.0004101,0.48849,-0.34604,0.17234},
      {-7.65E-05,0.00022242,0.68447,-0.00089638,0.00010935,-0.022545,0.00040311,0.48398,-0.34257,0.16574},
      {9.79E-05,0.00021497,0.67562,-0.00059873,0.00011858,-0.032823,0.00039606,0.47806,-0.33809,0.15717},
      {0.00028407,0.0002036,0.66436,-0.00029734,0.00013001,-0.045827,0.00038986,0.47048,-0.33243,0.14634},
      {0.00046506,0.0002168,0.64766,-4.26E-05,0.00014339,-0.064964,0.00035616,0.45903,-0.32407,0.1304},
      {0.00057988,0.00045349,0.60293,-7.77E-07,0.00015878,-0.11557,8.91E-05,0.42768,-0.30169,0.088281},
      {0.00067647,0.00068488,0.54757,1.10E-05,0.00017556,-0.17827,-0.00018391,0.38888,-0.27407,0.036127},
      {0.00075099,0.00089296,0.48208,2.24E-05,0.00019504,-0.25299,-0.00044934,0.34277,-0.24132,-0.025987},
      {0.00069879,0.0048115,0.37632,0.00011808,0.00019797,-0.36919,-0.0034216,0.26852,-0.18686,-0.12237},
      {0.00061056,0.0088093,0.26481,0.00021569,0.00019131,-0.49225,-0.0064332,0.1901,-0.12944,-0.2244},
      {0.00050777,0.012034,0.15609,0.00029391,0.00017686,-0.61359,-0.0088582,0.11338,-0.073643,-0.32498},
      {0.00062807,0.024515,0.094606,0.00035071,0.00011185,-0.66731,-0.017421,0.071696,-0.037988,-0.36933},
      {0.00071844,0.034871,0.043813,0.00037718,3.29E-05,-0.71167,-0.024511,0.037305,-0.0085407,-0.40594},
      {0.00076301,0.045081,0.0046179,0.00037078,-3.24E-05,-0.73848,-0.031543,0.0138,0.013148,-0.42805},
      {0.00081179,0.063533,-0.014322,0.00033848,-1.79E-05,-0.70778,-0.044404,0.019558,0.018321,-0.4026},
      {0.00078091,0.074963,-0.031023,0.00025552,-2.82E-05,-0.68441,-0.052372,0.025958,0.019551,-0.38318},
      {0.00059027,0.076148,-0.071832,0.00014662,-1.17E-05,-0.64054,-0.053238,0.052279,0.0015206,-0.3468},
      {0.00033645,0.070952,-0.17076,0.00015976,3.47E-05,-0.53265,-0.049712,0.1221,-0.050574,-0.25734},
      {0.00017488,0.066801,-0.27476,0.00025712,9.80E-05,-0.41704,-0.046901,0.19566,-0.10478,-0.16152},
      {4.40E-05,0.054502,-0.38017,0.0003199,0.00062297,-0.30865,-0.038369,0.27015,-0.16368,-0.072336},
      {-3.33E-05,0.035041,-0.47971,0.00033756,0.001338,-0.2156,-0.024818,0.34024,-0.22305,0.0038416},
      {-8.32E-05,0.01963,-0.57498,0.00034016,0.0013386,-0.12402,-0.014094,0.40735,-0.27825,0.079834},
      {-9.98E-05,0.0094395,-0.6477,0.00029884,0.0015009,-0.052152,-0.0069972,0.45858,-0.31956,0.13924},
      {-8.57E-05,0.0053866,-0.6598,0.00017918,0.0024473,-0.041873,-0.0041164,0.46704,-0.32747,0.1464},
      {-6.73E-05,0.0028588,-0.67121,9.33E-05,0.002216,-0.032636,-0.0022887,0.475,-0.33432,0.15439},
      {-4.58E-05,0.0016936,-0.68166,3.70E-05,0.0013818,-0.023922,-0.0014087,0.48227,-0.34004,0.16282},
      {-3.63E-05,0.0012897,-0.68039,1.54E-06,0.004927,-0.019966,-0.0010882,0.4813,-0.33958,0.16101},
      {-2.78E-05,0.00091779,-0.6804,-1.66E-05,0.0070005,-0.017002,-0.00078702,0.48125,-0.33976,0.16049},
      {-1.88E-05,0.00059101,-0.68305,-2.19E-05,0.0073308,-0.013952,-0.00051168,0.48309,-0.34125,0.16254},
      {-0.00032523,0.00017753,0.69855,-0.00044385,9.14E-05,-0.0074579,0.0002617,0.49419,-0.34952,0.17832},
      {-0.00032753,0.00016682,0.69768,-0.00048336,9.54E-05,-0.0082873,0.00028208,0.49361,-0.34915,0.17763},
      {-0.00033132,0.00015045,0.69628,-0.00054363,0.00010166,-0.009612,0.00031301,0.4927,-0.34856,0.17652},
      {-0.00033704,0.00012814,0.69426,-0.00062558,0.00011033,-0.011535,0.00035476,0.49139,-0.3477,0.17491},
      {-0.00029815,0.00011209,0.68863,-0.00064177,0.00012,-0.017523,0.00038186,0.48767,-0.34508,0.16993},
      {-0.00017621,0.00011198,0.6762,-0.00051501,0.00012912,-0.031272,0.00037137,0.47938,-0.33909,0.15849},
      {-4.13E-05,0.00010975,0.6602,-0.0003681,0.00013974,-0.048899,0.00035741,0.46875,-0.33143,0.14382},
      {0.0001015,0.0001047,0.63999,-0.00020425,0.00015169,-0.071069,0.00033938,0.45537,-0.3218,0.12539},
      {0.00024607,9.64E-05,0.61484,-2.82E-05,0.00016473,-0.098525,0.00031672,0.43877,-0.3099,0.10257},
      {0.00031857,0.0002611,0.5561,-5.02E-06,0.00018255,-0.1656,9.93E-05,0.39744,-0.28055,0.046822},
      {0.00037303,0.00042873,0.48686,4.50E-06,0.00021241,-0.2452,-0.00012629,0.3484,-0.24578,-0.019336},
      {0.00041795,0.00058055,0.40961,1.42E-05,0.0002556,-0.33452,-0.00033995,0.29345,-0.20684,-0.093551},
      {0.00038946,0.0028938,0.31538,7.29E-05,0.00025818,-0.44045,-0.0020923,0.22678,-0.15856,-0.18141},
      {0.00033324,0.0056163,0.2181,0.00013523,0.00022391,-0.54949,-0.0041096,0.15798,-0.10859,-0.27178},
      {0.00027657,0.0076637,0.12419,0.00017361,0.00016991,-0.65594,-0.0056142,0.091349,-0.060488,-0.35997},
      {0.00032349,0.015304,0.070753,0.00018669,9.26E-05,-0.70737,-0.010869,0.054558,-0.030682,-0.40245},
      {0.00035122,0.022269,0.033134,0.00016508,1.48E-05,-0.74142,-0.015643,0.028978,-0.0091291,-0.43052},
      {0.000328,0.026638,0.0030409,0.00010187,-5.36E-05,-0.77054,-0.018631,0.0083426,0.0076465,-0.45451},
      {0.00030656,0.037232,-0.013504,2.43E-06,-5.84E-05,-0.74855,-0.026017,0.014497,0.0086708,-0.43622},
      {0.00034277,0.04804,-0.02862,1.00E-06,-8.50E-05,-0.72196,-0.03358,0.023004,0.008121,-0.4142},
      {0.00034107,0.05518,-0.052489,1.59E-05,-0.00010311,-0.68839,-0.038596,0.038379,0.00085261,-0.38638},
      {0.00018698,0.051232,-0.15853,0.00011136,-3.54E-05,-0.57015,-0.035923,0.11339,-0.054267,-0.28838},
      {4.47E-05,0.044882,-0.26855,0.00018913,1.85E-05,-0.44999,-0.031556,0.1913,-0.1126,-0.18876},
      {-7.80E-05,0.035762,-0.38054,0.00024245,0.00010027,-0.33072,-0.025241,0.27064,-0.17329,-0.089908},
      {-0.00011747,0.021306,-0.47568,0.00024266,0.00038342,-0.23787,-0.015194,0.33756,-0.22788,-0.013261},
      {-0.0001305,0.011088,-0.56325,0.00023124,0.00048319,-0.14908,-0.0081026,0.3992,-0.27659,0.060279},
      {-0.00012082,0.0046882,-0.64339,0.00021034,0.00043662,-0.064596,-0.0036726,0.45566,-0.31971,0.13045},
      {-0.00010015,0.0022491,-0.65673,0.00012666,0.0005761,-0.052371,-0.0019196,0.46498,-0.32747,0.14039},
      {-7.95E-05,0.0018316,-0.66383,7.07E-05,0.0007503,-0.044878,-0.0016008,0.46984,-0.3311,0.14635},
      {-5.79E-05,0.0015627,-0.67138,3.22E-05,0.00079189,-0.03687,-0.0013688,0.47504,-0.33492,0.15293},
      {-4.36E-05,0.0012588,-0.6744,9.88E-06,0.0020996,-0.031774,-0.0011099,0.47709,-0.33655,0.15528},
      {-3.41E-05,0.00091984,-0.67601,3.72E-07,0.0030617,-0.028843,-0.00082874,0.47818,-0.33752,0.15633},
      {-0.00035174,0.00019279,0.6977,-0.00029202,9.15E-05,-0.0078846,0.00018849,0.49419,-0.34941,0.17797},
      {-0.0003665,0.00018271,0.69653,-0.00032699,9.68E-05,-0.0089559,0.00021366,0.49347,-0.34893,0.17707},
      {-0.00039142,0.00016744,0.6947,-0.00037979,0.00010513,-0.010634,0.00025348,0.49234,-0.34817,0.17567},
      {-0.00042992,0.00014684,0.69209,-0.00045049,0.00011707,-0.013006,0.00031033,0.49075,-0.34709,0.17368},
      {-0.00048588,0.00012117,0.68861,-0.00053769,0.00013315,-0.016159,0.00038638,0.48863,-0.34565,0.17105},
      {-0.00056311,9.10E-05,0.68413,-0.00063849,0.00015397,-0.020178,0.00048316,0.48595,-0.34382,0.16769},
      {-0.00047182,8.10E-05,0.6668,-0.00052947,0.00017162,-0.038962,0.00047526,0.47457,-0.33566,0.15206},
      {-0.00032392,7.36E-05,0.64355,-0.00037554,0.00019068,-0.064297,0.00043054,0.45926,-0.32471,0.131},
      {-0.00014704,6.52E-05,0.61558,-0.00021613,0.00021195,-0.094703,0.00036375,0.44088,-0.3116,0.10574},
      {5.44E-05,5.65E-05,0.58239,-5.88E-05,0.00023482,-0.13069,0.00027488,0.4191,-0.2961,0.075842},
      {0.00014575,0.0001553,0.5194,-1.30E-05,0.00027016,-0.20302,0.0001048,0.37471,-0.26464,0.015748},
      {0.00018834,0.0002765,0.44066,-1.89E-06,0.00031303,-0.29466,-7.68E-05,0.31841,-0.22478,-0.060367},
      {0.00021659,0.00037836,0.35372,8.52E-06,0.00035914,-0.39631,-0.00023813,0.25602,-0.18063,-0.14477},
      {0.00019984,0.0015647,0.26345,3.54E-05,0.00034278,-0.50018,-0.0011406,0.19155,-0.13448,-0.2309},
      {0.00015704,0.0031757,0.17733,5.77E-05,0.00026774,-0.5985,-0.0023102,0.13026,-0.090366,-0.3123},
      {0.00011284,0.0041747,0.095167,5.31E-05,0.00018446,-0.69349,-0.0030226,0.071547,-0.048369,-0.39091},
      {0.00010335,0.0080012,0.046665,1.62E-05,0.00010807,-0.74506,-0.0056517,0.037492,-0.022373,-0.43349},
      {0.00011966,0.013163,0.023067,-5.66E-06,3.67E-05,-0.76542,-0.0092284,0.021473,-0.008445,-0.45026},
      {0.00013657,0.017762,0.0034917,-9.95E-06,-3.59E-05,-0.78172,-0.012431,0.0082657,0.0032098,-0.46371},
      {0.00016901,0.026672,-0.012486,-6.43E-06,-7.21E-05,-0.76428,-0.018665,0.012528,0.0047024,-0.44925},
      {0.00018593,0.034526,-0.028058,-1.67E-06,-9.93E-05,-0.73944,-0.024171,0.022052,0.00195,-0.42868},
      {0.00017803,0.039437,-0.04392,1.85E-06,-0.00012691,-0.71708,-0.027626,0.032164,-0.0026995,-0.41017},
      {5.49E-05,0.033593,-0.1459,6.51E-05,-7.40E-05,-0.60585,-0.023602,0.10425,-0.056638,-0.31795},
      {-6.36E-05,0.026139,-0.2618,0.00011998,-1.69E-05,-0.48019,-0.018459,0.18634,-0.11842,-0.21375},
      {-0.00016348,0.018486,-0.37822,0.00015631,3.28E-05,-0.35415,-0.013176,0.26882,-0.18054,-0.10923},
      {-0.00018098,0.0096355,-0.46844,0.00015234,0.00014488,-0.26055,-0.0070458,0.33239,-0.22993,-0.031714},
      {-0.00016847,0.0037317,-0.54808,0.00013599,0.00015442,-0.17598,-0.0029679,0.38848,-0.27254,0.038442},
      {-0.0001398,0.0023325,-0.61816,0.00012308,0.00022314,-0.096968,-0.0020715,0.43784,-0.30811,0.1039},
      {-0.00011659,0.0018642,-0.64253,8.40E-05,0.00037488,-0.069565,-0.0017529,0.45491,-0.3204,0.12642},
      {-9.40E-05,0.0016088,-0.64969,4.66E-05,0.00045946,-0.061917,-0.0015354,0.45982,-0.32401,0.13264},
      {-7.07E-05,0.0014373,-0.65776,2.24E-05,0.0004455,-0.053246,-0.0013583,0.46541,-0.32809,0.13985},
      {-5.13E-05,0.0012514,-0.66438,9.57E-06,0.00066965,-0.045748,-0.001165,0.47001,-0.33149,0.14574},
      {-0.00036752,0.00018092,0.70077,-0.00011604,0.00010393,-0.0046626,0.00016071,0.49645,-0.35086,0.18062},
      {-0.00039411,0.00017258,0.69942,-0.00014311,0.00011086,-0.0058515,0.00019057,0.49566,-0.35032,0.17963},
      {-0.00043507,0.00015997,0.69731,-0.00018359,0.00012169,-0.0077057,0.00023619,0.49442,-0.34946,0.17807},
      {-0.00049142,0.00014306,0.69434,-0.00023697,0.00013696,-0.01031,0.00029825,0.4927,-0.34827,0.17589},
      {-0.00056319,0.00012214,0.69041,-0.00030131,0.00015718,-0.013744,0.00037629,0.49043,-0.3467,0.17302},
      {-0.00064905,9.79E-05,0.68543,-0.00037321,0.00018285,-0.018083,0.00046844,0.48759,-0.34471,0.16938},
      {-0.00074565,7.11E-05,0.6793,-0.0004477,0.00021451,-0.023399,0.00057099,0.48413,-0.34229,0.16493},
      {-0.00069519,5.34E-05,0.66244,-0.00042031,0.00024168,-0.040919,0.00057334,0.47341,-0.3347,0.15035},
      {-0.00047559,4.60E-05,0.63166,-0.00028859,0.00025978,-0.074307,0.0004578,0.45322,-0.32037,0.12262},
      {-0.00025089,3.92E-05,0.59558,-0.00016341,0.00027801,-0.11332,0.00033526,0.42959,-0.30362,0.09023},
      {-3.61E-05,3.38E-05,0.55379,-5.38E-05,0.00029526,-0.15839,0.00021416,0.40223,-0.28426,0.052823},
      {6.34E-05,8.56E-05,0.48667,-9.86E-06,0.00032624,-0.23527,8.35E-05,0.35517,-0.25096,-0.011004},
      {8.47E-05,0.0001623,0.39905,-3.80E-07,0.00036816,-0.33831,-4.08E-05,0.29199,-0.20627,-0.096531},
      {8.75E-05,0.00021938,0.30374,6.63E-06,0.00040947,-0.45086,-0.00013484,0.22302,-0.1575,-0.18993},
      {6.53E-05,0.00066824,0.21252,8.07E-06,0.00039353,-0.558,-0.00047427,0.15716,-0.11074,-0.27873},
      {5.16E-05,0.0015949,0.14536,5.11E-06,0.00029681,-0.63604,-0.0011395,0.10881,-0.076075,-0.3433},
      {4.02E-05,0.00237,0.080166,2.38E-06,0.00019551,-0.71229,-0.0016941,0.061662,-0.042343,-0.40637},
      {4.51E-05,0.0050421,0.037343,-1.13E-06,0.00010526,-0.75925,-0.0035606,0.031075,-0.019365,-0.4452},
      {6.01E-05,0.0093605,0.019427,-5.20E-06,3.20E-05,-0.77391,-0.0065717,0.019065,-0.0086947,-0.45729},
      {6.59E-05,0.012638,0.0036211,-9.24E-06,-3.75E-05,-0.78694,-0.008862,0.0087849,0.00022833,-0.46804},
      {7.06E-05,0.01722,-0.012505,-9.34E-06,-7.89E-05,-0.77717,-0.012075,0.011454,0.00066931,-0.45993},
      {6.03E-05,0.021072,-0.031283,-7.41E-06,-9.88E-05,-0.75245,-0.014787,0.023754,-0.0060535,-0.43946},
      {2.85E-05,0.022109,-0.052043,-6.85E-06,-0.00011337,-0.72836,-0.015536,0.037684,-0.015345,-0.4195},
      {-5.29E-05,0.017668,-0.13529,2.51E-05,-7.87E-05,-0.63738,-0.012485,0.096422,-0.059085,-0.34407},
      {-0.00014181,0.011209,-0.25179,6.07E-05,-2.48E-05,-0.50988,-0.0080414,0.17894,-0.12063,-0.23834},
      {-0.00021655,0.004988,-0.36704,7.95E-05,2.18E-05,-0.38356,-0.0037689,0.26059,-0.1814,-0.13358},
      {-0.00021244,0.0033178,-0.45767,8.23E-05,0.00014534,-0.28075,-0.0027046,0.32458,-0.22743,-0.048448},
      {-0.00018125,0.0023429,-0.52712,7.47E-05,0.00024409,-0.20189,-0.0021097,0.3735,-0.26248,0.016841},
      {-0.00015556,0.0018062,-0.58879,6.46E-05,0.00029626,-0.13149,-0.0018158,0.41697,-0.29346,0.07517},
      {-0.00013336,0.0015824,-0.62377,4.53E-05,0.00032949,-0.091603,-0.0016874,0.44158,-0.31096,0.10821},
      {-0.00010802,0.0014357,-0.6309,2.45E-05,0.00035286,-0.083925,-0.0015294,0.4465,-0.31456,0.11454},
      {-8.13E-05,0.0013555,-0.63874,1.36E-05,0.0003623,-0.075335,-0.0013977,0.45194,-0.31852,0.12165},
      {-0.00017725,0.00013442,0.70609,0,9.46E-05,5.46E-05,3.42E-05,0.49971,-0.35319,0.18455},
      {-0.00019115,0.00012993,0.70535,-8.20E-06,0.00010069,-0.000555,4.89E-05,0.49931,-0.35291,0.18403},
      {-0.00022625,0.00012038,0.70305,-3.35E-05,0.00011348,-0.0025351,8.55E-05,0.49802,-0.35201,0.18237},
      {-0.00027174,0.00010769,0.69981,-6.59E-05,0.00013139,-0.0053069,0.00013333,0.49623,-0.35075,0.18005},
      {-0.00032486,9.22E-05,0.69555,-0.00010277,0.00015493,-0.0089447,0.00019002,0.49389,-0.34911,0.177},
      {-0.00038075,7.45E-05,0.6902,-0.00014053,0.00018454,-0.013516,0.00025134,0.49097,-0.34705,0.17317},
      {-0.00043193,5.57E-05,0.68366,-0.00017394,0.00022066,-0.019083,0.00031092,0.48744,-0.34456,0.1685},
      {-0.00046786,3.69E-05,0.67586,-0.00019625,0.00026368,-0.025704,0.00035989,0.48328,-0.34163,0.16295},
      {-0.00043535,2.20E-05,0.66163,-0.00018231,0.00030597,-0.039378,0.00035963,0.4749,-0.33571,0.15155},
      {-0.00023835,1.88E-05,0.62288,-9.75E-05,0.00031778,-0.081142,0.0002429,0.44954,-0.31777,0.11689},
      {-7.23E-05,1.80E-05,0.57836,-3.29E-05,0.00032716,-0.12898,0.00014402,0.42041,-0.29718,0.077197},
      {3.51E-05,2.07E-05,0.52793,-1.58E-07,0.0003322,-0.18302,8.12E-05,0.38742,-0.27387,0.032379},
      {5.01E-05,4.70E-05,0.46093,1.08E-06,0.00034651,-0.25949,4.19E-05,0.34055,-0.24072,-0.031065},
      {4.31E-05,9.56E-05,0.37301,3.45E-06,0.00038018,-0.36445,-2.43E-05,0.2762,-0.19521,-0.11816},
      {3.67E-05,0.00013701,0.28166,5.58E-06,0.00041256,-0.47366,-8.26E-05,0.20927,-0.14787,-0.20876},
      {3.02E-05,0.00036826,0.19671,6.20E-06,0.00040449,-0.57484,-0.00026617,0.14715,-0.10384,-0.29265},
      {2.51E-05,0.0010325,0.13663,3.55E-06,0.00029661,-0.64555,-0.00073901,0.10347,-0.072613,-0.35113},
      {1.93E-05,0.0015563,0.076378,5.18E-07,0.00018503,-0.71669,-0.0011128,0.059619,-0.041333,-0.40999},
      {1.74E-05,0.0028919,0.029788,-3.23E-06,8.52E-05,-0.7699,-0.0020512,0.02616,-0.016995,-0.45399},
      {2.17E-05,0.00571,0.015083,-7.75E-06,1.79E-05,-0.7814,-0.0040225,0.017133,-0.0091863,-0.46348},
      {1.88E-05,0.0075584,0.0019203,-1.21E-05,-3.96E-05,-0.79156,-0.0053189,0.0096143,-0.0029341,-0.47186},
      {7.26E-06,0.009226,-0.013316,-1.43E-05,-7.35E-05,-0.78713,-0.0064971,0.011115,-0.0031375,-0.46817},
      {-2.09E-05,0.010246,-0.035324,-1.41E-05,-8.28E-05,-0.76152,-0.007235,0.025989,-0.013102,-0.44695},
      {-6.25E-05,0.0090724,-0.059396,-1.53E-05,-8.77E-05,-0.73577,-0.0064446,0.042514,-0.025337,-0.42561},
      {-0.00011621,0.005925,-0.12405,-4.00E-06,-2.95E-05,-0.66473,-0.0042989,0.088107,-0.059103,-0.36676},
      {-0.00015955,0.0041657,-0.24028,1.95E-05,0.00016718,-0.53169,-0.0031738,0.17048,-0.11813,-0.25666},
      {-0.00020052,0.0027447,-0.35167,3.36E-05,0.00030081,-0.40404,-0.0023127,0.24938,-0.1745,-0.15093},
      {-0.0002142,0.0017687,-0.44332,3.64E-05,0.0003733,-0.29909,-0.0017587,0.31417,-0.2207,-0.063968},
      {-0.00018734,0.0013673,-0.50429,3.00E-05,0.0004372,-0.2293,-0.001559,0.35715,-0.25126,-0.0061599},
      {-0.0001608,0.001329,-0.55525,2.86E-05,0.00045947,-0.17064,-0.0015985,0.3931,-0.27669,0.042478},
      {-0.00014032,0.0014172,-0.59454,2.51E-05,0.00040407,-0.12541,-0.0017036,0.42082,-0.29624,0.080069},
      {-0.00011329,0.0013428,-0.60273,1.48E-05,0.00042013,-0.1164,-0.0015775,0.42651,-0.30037,0.087521},
      {-4.78E-05,4.27E-05,0.70634,0,8.79E-05,5.07E-05,5.45E-06,0.49987,-0.35342,0.18455},
      {-4.74E-05,4.02E-05,0.7063,0,9.23E-05,5.33E-05,7.04E-06,0.49987,-0.35342,0.18455},
      {-4.60E-05,3.62E-05,0.70624,0,9.91E-05,5.72E-05,9.01E-06,0.49987,-0.35342,0.18454},
      {-4.28E-05,3.07E-05,0.70617,0,0.00010858,6.27E-05,1.08E-05,0.49987,-0.35342,0.18453},
      {-4.35E-05,2.22E-05,0.70359,-2.82E-06,0.00012874,-0.0020695,2.01E-05,0.49854,-0.35249,0.18274},
      {-3.92E-05,1.18E-05,0.69796,-2.63E-06,0.00016152,-0.0068032,3.02E-05,0.49561,-0.35042,0.17876},
      {-4.10E-05,7.28E-06,0.69111,-3.56E-07,0.00020044,-0.012573,4.10E-05,0.49204,-0.34789,0.17392},
      {-5.41E-05,5.76E-06,0.68298,-5.33E-07,0.00024411,-0.019469,5.78E-05,0.48775,-0.34484,0.16814},
      {-6.84E-05,4.12E-06,0.67351,-7.26E-07,0.0002917,-0.02757,7.56E-05,0.48272,-0.34128,0.16136},
      {-8.38E-05,2.40E-06,0.66264,-9.29E-07,0.00034195,-0.036972,9.37E-05,0.4769,-0.33715,0.15349},
      {-5.60E-05,6.45E-06,0.61959,-7.40E-07,0.00034068,-0.083363,8.27E-05,0.44849,-0.31706,0.11502},
      {-2.26E-05,1.05E-05,0.572,-4.74E-07,0.00034521,-0.13501,7.03E-05,0.41685,-0.2947,0.072183},
      {1.17E-05,1.42E-05,0.52196,-1.36E-07,0.00034179,-0.18947,5.94E-05,0.3835,-0.27112,0.027028},
      {3.48E-05,2.80E-05,0.46016,7.60E-07,0.00033758,-0.25969,3.78E-05,0.3405,-0.24071,-0.03119},
      {3.38E-05,6.27E-05,0.37306,2.66E-06,0.00036675,-0.36415,-9.28E-06,0.27647,-0.19543,-0.11785},
      {2.98E-05,9.15E-05,0.28214,4.18E-06,0.00039103,-0.4728,-5.09E-05,0.2099,-0.14835,-0.20798},
      {2.33E-05,0.00017746,0.19279,4.64E-06,0.00039027,-0.57909,-0.00012905,0.14475,-0.10225,-0.29612},
      {1.65E-05,0.00060553,0.1334,1.12E-06,0.00026954,-0.64927,-0.0004362,0.10157,-0.07149,-0.35416},
      {9.26E-06,0.00090881,0.074129,-2.71E-06,0.00015493,-0.71938,-0.00065563,0.05851,-0.040887,-0.41215},
      {2.85E-06,0.0013528,0.022109,-6.87E-06,5.76E-05,-0.78012,-0.00097254,0.021071,-0.014186,-0.46241},
      {-7.59E-07,0.0028966,0.0099281,-1.13E-05,5.61E-06,-0.78892,-0.0020574,0.014601,-0.0088265,-0.46966},
      {-8.64E-06,0.0036155,-0.00081141,-1.55E-05,-3.29E-05,-0.79623,-0.0025679,0.0096263,-0.0049412,-0.47568},
      {-2.35E-05,0.0035824,-0.013005,-1.88E-05,-5.28E-05,-0.79572,-0.0025581,0.0099528,-0.0051759,-0.47524},
      {-5.14E-05,0.0036629,-0.039142,-1.98E-05,-1.23E-06,-0.76566,-0.0026492,0.028147,-0.017951,-0.45041},
      {-7.54E-05,0.003693,-0.069057,-2.09E-05,0.00021474,-0.73079,-0.0027161,0.049135,-0.032718,-0.42184},
      {-0.0001015,0.0032081,-0.11864,-1.81E-05,0.00057944,-0.67341,-0.002446,0.084116,-0.057622,-0.37478},
      {-0.00014161,0.0020463,-0.22933,-4.49E-06,0.00074568,-0.54621,-0.0017684,0.16251,-0.1135,-0.26948},
      {-0.00017336,0.0012832,-0.33076,5.84E-06,0.00083789,-0.42945,-0.0013844,0.23431,-0.16452,-0.17274},
      {-0.00019342,0.00077339,-0.4182,1.32E-05,0.00083157,-0.32885,-0.0011759,0.29615,-0.20838,-0.089274},
      {-0.0001673,0.00079043,-0.46908,1.37E-05,0.0008744,-0.27016,-0.0012492,0.33205,-0.23375,-0.040654},
      {-0.00014959,0.00095739,-0.51492,1.34E-05,0.00079734,-0.21724,-0.0014289,0.36443,-0.25654,0.0033535},
      {-0.0001401,0.0012597,-0.55575,1.24E-05,0.00056797,-0.17014,-0.001707,0.39327,-0.27675,0.042745},
      {-6.40E-06,7.13E-06,0.70631,0,0.00031816,0.00018369,7.22E-07,0.49976,-0.35338,0.18433},
      {-6.77E-06,7.20E-06,0.70624,0,0.00036127,0.00020858,1.03E-06,0.49973,-0.35336,0.18429},
      {-7.32E-06,7.29E-06,0.70611,0,0.00043451,0.00025086,1.51E-06,0.49968,-0.35332,0.18422},
      {-8.04E-06,7.42E-06,0.70593,0,0.00054995,0.00031751,2.15E-06,0.4996,-0.35326,0.18411},
      {-8.90E-06,7.56E-06,0.70567,0,0.00072515,0.00041867,2.95E-06,0.49947,-0.35317,0.18394},
      {-9.86E-06,7.72E-06,0.7053,0,0.00098502,0.0005687,3.90E-06,0.49929,-0.35304,0.18369},
      {-1.58E-05,6.92E-06,0.70012,-8.90E-08,0.0011476,-0.0037916,1.26E-05,0.49644,-0.35102,0.17985},
      {-2.40E-05,5.60E-06,0.69176,-2.25E-07,0.0011979,-0.011302,2.56E-05,0.49177,-0.34771,0.17355},
      {-3.18E-05,4.21E-06,0.68208,-3.66E-07,0.0011696,-0.020282,3.90E-05,0.48629,-0.34383,0.16614},
      {-3.86E-05,2.79E-06,0.67103,-5.05E-07,0.0010102,-0.030926,5.25E-05,0.47993,-0.33932,0.15754},
      {-4.39E-05,1.39E-06,0.65856,-6.35E-07,0.00065052,-0.043474,6.53E-05,0.47262,-0.33414,0.14766},
      {-2.40E-05,3.45E-06,0.62156,-4.08E-07,0.00049651,-0.08373,6.26E-05,0.44812,-0.31682,0.1145},
      {3.06E-06,6.44E-06,0.57392,-4.27E-08,0.0004517,-0.13594,5.56E-05,0.41619,-0.29425,0.071266},
      {2.80E-05,9.05E-06,0.52351,3.28E-07,0.00038099,-0.19138,4.97E-05,0.38232,-0.27029,0.025397},
      {4.55E-05,1.49E-05,0.46505,8.17E-07,0.00029905,-0.25717,3.95E-05,0.34211,-0.24187,-0.029037},
      {3.70E-05,3.73E-05,0.37483,1.74E-06,0.00031112,-0.3644,4.20E-06,0.27643,-0.19542,-0.11797},
      {2.70E-05,5.33E-05,0.28131,2.11E-06,0.0003154,-0.4751,-2.47E-05,0.20863,-0.14748,-0.20976},
      {1.61E-05,6.21E-05,0.18504,1.81E-06,0.00030998,-0.58857,-4.60E-05,0.13915,-0.098353,-0.30384},
      {8.76E-06,0.00028656,0.12688,-2.35E-06,0.00019677,-0.65731,-0.00021062,0.09699,-0.068423,-0.3607},
      {2.04E-06,0.00040467,0.070017,-6.76E-06,9.94E-05,-0.72448,-0.00030044,0.05585,-0.039269,-0.41627},
      {-3.49E-06,0.00041047,0.014806,-1.13E-05,2.53E-05,-0.78963,-0.00031125,0.016016,-0.011096,-0.47019},
      {-9.49E-06,0.0010375,0.0043832,-1.54E-05,-3.27E-06,-0.79607,-0.00075966,0.011621,-0.007665,-0.47551},
      {-1.41E-05,0.0015439,-0.0040166,-1.91E-05,-1.81E-05,-0.79856,-0.0011274,0.0097062,-0.0060452,-0.47758},
      {-1.81E-05,0.0018443,-0.012191,-2.26E-05,-2.53E-05,-0.79913,-0.0013538,0.0091095,-0.0054595,-0.47806},
      {-4.17E-05,0.0018671,-0.043663,-2.39E-05,0.00026086,-0.76234,-0.0014195,0.031207,-0.021013,-0.44799},
      {-6.02E-05,0.0017541,-0.078603,-2.53E-05,0.00080411,-0.72121,-0.0014013,0.055796,-0.038393,-0.41467},
      {-7.42E-05,0.0015213,-0.11622,-2.57E-05,0.0016668,-0.67656,-0.0013091,0.082294,-0.057182,-0.37888},
      {-0.00010432,0.00092558,-0.21366,-1.48E-05,0.0018259,-0.5641,-0.0010354,0.15127,-0.10612,-0.28582},
      {-0.00013104,0.00045976,-0.30339,-5.83E-06,0.0018289,-0.46072,-0.00086349,0.21475,-0.15111,-0.20006},
      {-0.00015393,9.88E-05,-0.3841,1.31E-06,0.0016605,-0.36798,-0.00077236,0.27182,-0.1915,-0.1229},
      {-0.00014259,0.00025491,-0.43344,2.77E-06,0.0015591,-0.31101,-0.00095437,0.30668,-0.21604,-0.075496},
      {-0.00013391,0.00059057,-0.47462,3.06E-06,0.0013297,-0.26345,-0.0012535,0.33579,-0.23642,-0.035718},
      {-2.06E-06,4.09E-06,0.7056,0,0.0012359,0.00071356,-2.68E-07,0.49912,-0.35293,0.18345},
      {-2.24E-06,4.12E-06,0.70542,0,0.0013913,0.00080325,-3.96E-08,0.49901,-0.35285,0.18331},
      {-2.51E-06,4.17E-06,0.70512,0,0.0016418,0.00094789,3.07E-07,0.49883,-0.35272,0.18307},
      {-2.86E-06,4.24E-06,0.7047,0,0.0020108,0.0011609,7.75E-07,0.49857,-0.35254,0.18271},
      {-3.26E-06,4.31E-06,0.70411,0,0.0025278,0.0014594,1.36E-06,0.49821,-0.35228,0.18222},
      {-3.69E-06,4.39E-06,0.70331,0,0.0032307,0.0018653,2.05E-06,0.49771,-0.35193,0.18154},
      {-4.11E-06,4.46E-06,0.70227,0,0.0041682,0.0024065,2.82E-06,0.49704,-0.35146,0.18065},
      {-4.93E-06,4.37E-06,0.69986,-1.33E-08,0.0051638,0.0017097,4.85E-06,0.49556,-0.35041,0.17864},
      {-8.31E-06,3.39E-06,0.68994,-1.10E-07,0.0047147,-0.0087389,1.45E-05,0.48963,-0.34621,0.17062},
      {-1.09E-05,2.39E-06,0.67857,-2.04E-07,0.0040242,-0.021178,2.41E-05,0.48273,-0.34132,0.1613},
      {-1.24E-05,1.43E-06,0.66568,-2.91E-07,0.0030076,-0.035881,3.31E-05,0.4748,-0.33571,0.15057},
      {-1.25E-05,5.41E-07,0.6512,-3.63E-07,0.0015617,-0.053171,4.10E-05,0.46574,-0.3293,0.13831},
      {-1.04E-06,1.40E-06,0.61844,-2.02E-07,0.00069788,-0.09033,4.19E-05,0.4439,-0.31385,0.10874},
      {1.69E-05,3.29E-06,0.56973,1.11E-07,0.00057466,-0.14447,3.84E-05,0.41087,-0.2905,0.064019},
      {3.19E-05,4.69E-06,0.51806,3.72E-07,0.0004129,-0.20223,3.54E-05,0.37567,-0.26561,0.016362},
      {4.25E-05,5.76E-06,0.46274,5.48E-07,0.00020978,-0.26458,3.24E-05,0.3377,-0.23876,-0.035045},
      {3.03E-05,1.59E-05,0.37037,2.40E-07,0.00020094,-0.37329,9.86E-06,0.27114,-0.1917,-0.12517},
      {1.83E-05,1.93E-05,0.27525,-7.72E-07,0.00018154,-0.48476,-5.50E-06,0.20291,-0.14346,-0.21757},
      {7.17E-06,1.52E-05,0.17793,-2.62E-06,0.00014957,-0.59828,-1.24E-05,0.13344,-0.094341,-0.31165},
      {2.35E-06,8.43E-05,0.11765,-6.44E-06,9.47E-05,-0.66923,-6.84E-05,0.089979,-0.063574,-0.37041},
      {-2.37E-07,0.00015214,0.066031,-1.07E-05,5.50E-05,-0.72998,-0.00012465,0.052741,-0.037204,-0.42074},
      {-2.44E-06,0.00019886,0.016337,-1.55E-05,2.02E-05,-0.78805,-0.00016781,0.017157,-0.012014,-0.46885},
      {-6.26E-06,0.00052935,0.0010465,-2.06E-05,6.03E-06,-0.79869,-0.00041418,0.010377,-0.0070434,-0.47767},
      {-9.58E-06,0.00078781,-0.0071198,-2.51E-05,4.26E-06,-0.79759,-0.00061397,0.010826,-0.0072176,-0.47677},
      {-1.18E-05,0.00090196,-0.015732,-2.91E-05,1.24E-05,-0.79503,-0.00071645,0.012266,-0.0081629,-0.47467},
      {-2.60E-05,0.00084191,-0.04634,-3.04E-05,0.00057084,-0.76013,-0.00073061,0.032996,-0.022797,-0.44654},
      {-3.94E-05,0.00067699,-0.084189,-3.02E-05,0.0015777,-0.71487,-0.00068696,0.059665,-0.041672,-0.41046},
      {-4.87E-05,0.0004407,-0.12389,-2.90E-05,0.0029958,-0.66682,-0.00060203,0.087665,-0.061522,-0.37265},
      {-7.01E-05,0.00011787,-0.19919,-2.15E-05,0.0034082,-0.57929,-0.00051073,0.14092,-0.099222,-0.30064},
      {-9.28E-05,-0.00015951,-0.27799,-1.35E-05,0.003255,-0.48863,-0.00047156,0.19665,-0.13863,-0.22522},
      {-0.00011199,-0.000391,-0.34839,-6.78E-06,0.0029079,-0.40796,-0.00046774,0.24642,-0.17381,-0.15782},
      {-0.00011605,-0.00013029,-0.39845,-2.78E-06,0.0029369,-0.34966,-0.00073553,0.28184,-0.19865,-0.10951},
      {-2.57E-07,2.00E-06,0.7059,0,0.001113,0.00064256,-7.20E-07,0.49921,-0.35299,0.18357},
      {-3.14E-07,2.01E-06,0.70558,0,0.0014137,0.00081621,-5.60E-07,0.499,-0.35284,0.18328},
      {-3.94E-07,2.03E-06,0.70507,0,0.0018917,0.0010922,-3.17E-07,0.49866,-0.3526,0.18283},
      {-4.89E-07,2.06E-06,0.70433,0,0.0025816,0.0014905,9.89E-09,0.49817,-0.35226,0.18217},
      {-5.85E-07,2.08E-06,0.70332,0,0.0035239,0.0020345,4.17E-07,0.4975,-0.35179,0.18126},
      {-6.64E-07,2.10E-06,0.702,0,0.0047674,0.0027525,8.94E-07,0.49663,-0.35116,0.18007},
      {-7.01E-07,2.11E-06,0.70031,0,0.0063716,0.0036787,1.42E-06,0.49549,-0.35036,0.17854},
      {-6.68E-07,2.10E-06,0.69818,0,0.0084085,0.0048547,1.99E-06,0.49405,-0.34934,0.17659},
      {-5.38E-07,2.06E-06,0.69551,0,0.010965,0.0063305,2.56E-06,0.49224,-0.34806,0.17414},
      {-2.80E-07,1.59E-06,0.68597,-4.01E-08,0.010718,-0.0040515,7.21E-06,0.48614,-0.34375,0.16588},
      {6.71E-07,1.00E-06,0.67258,-8.79E-08,0.0088684,-0.021299,1.29E-05,0.47754,-0.33766,0.15424},
      {2.50E-06,4.87E-07,0.65749,-1.23E-07,0.0064554,-0.041508,1.76E-05,0.46772,-0.33071,0.14095},
      {5.26E-06,7.71E-08,0.64061,-1.42E-07,0.0033481,-0.065069,2.09E-05,0.45658,-0.32284,0.12588},
      {1.14E-05,2.97E-07,0.61072,-6.95E-08,0.00094824,-0.10237,2.14E-05,0.43628,-0.30848,0.098395},
      {1.96E-05,1.02E-06,0.56011,6.00E-08,0.00072406,-0.15968,1.95E-05,0.40143,-0.28384,0.051198},
      {2.40E-05,1.17E-06,0.50628,7.41E-08,0.00044837,-0.22107,1.76E-05,0.36413,-0.25746,0.00069042},
      {2.55E-05,1.01E-06,0.44842,5.46E-09,0.00012387,-0.28762,1.70E-05,0.32372,-0.22889,-0.054024},
      {1.96E-05,3.61E-06,0.35782,-1.16E-06,9.32E-05,-0.39314,9.42E-06,0.25913,-0.18322,-0.14147},
      {1.32E-05,5.98E-06,0.26385,-3.05E-06,9.66E-05,-0.50202,1.35E-06,0.19245,-0.13607,-0.23176},
      {6.70E-06,7.32E-06,0.17158,-5.86E-06,9.61E-05,-0.60859,-6.46E-06,0.12719,-0.089929,-0.32012},
      {3.04E-06,4.08E-05,0.1104,-1.09E-05,7.02E-05,-0.6795,-3.98E-05,0.083744,-0.059192,-0.37889},
      {9.59E-07,7.29E-05,0.063625,-1.74E-05,4.03E-05,-0.73355,-7.46E-05,0.050624,-0.035752,-0.42367},
      {-7.26E-07,8.77E-05,0.019501,-2.48E-05,1.77E-05,-0.78409,-9.88E-05,0.019658,-0.013845,-0.46555},
      {-3.02E-06,0.00020505,-0.00087837,-3.04E-05,1.48E-05,-0.79971,-0.00019997,0.0099754,-0.0069288,-0.4785},
      {-5.03E-06,0.00029683,-0.0095756,-3.40E-05,2.77E-05,-0.79647,-0.00028856,0.011842,-0.0081854,-0.47584},
      {-6.06E-06,0.00029472,-0.018579,-3.67E-05,5.10E-05,-0.79194,-0.00031528,0.014553,-0.010084,-0.47212},
      {-1.34E-05,0.00019244,-0.045816,-3.68E-05,0.0008178,-0.76128,-0.00030168,0.03252,-0.02279,-0.4478},
      {-2.21E-05,2.54E-05,-0.085629,-3.48E-05,0.002406,-0.71271,-0.00026619,0.060603,-0.042664,-0.40981},
      {-2.70E-05,-0.00016837,-0.12653,-3.17E-05,0.0044916,-0.66203,-0.00021978,0.08948,-0.063111,-0.37077},
      {-4.09E-05,-0.00031471,-0.1852,-2.54E-05,0.0056894,-0.59219,-0.0002385,0.13096,-0.092411,-0.31458},
      {-6.26E-05,-0.00037232,-0.25267,-1.76E-05,0.0056927,-0.51408,-0.00033711,0.17868,-0.12606,-0.2498},
      {-7.95E-05,-0.00044509,-0.31455,-1.03E-05,0.0054175,-0.44292,-0.00042503,0.22245,-0.15692,-0.1904},
      {0,6.87E-07,0.70709,0,1.13E-05,6.55E-06,-4.85E-07,0.49999,-0.35355,0.18463},
      {0,6.94E-07,0.70709,0,1.17E-05,6.76E-06,-4.91E-07,0.49999,-0.35355,0.18463},
      {0,7.03E-07,0.70709,0,1.23E-05,7.09E-06,-4.97E-07,0.49999,-0.35355,0.18463},
      {5.44E-08,7.03E-07,0.70601,0,0.0010549,0.00060903,-2.88E-07,0.49925,-0.35302,0.18363},
      {1.40E-07,6.97E-07,0.70453,0,0.002486,0.0014353,-2.52E-08,0.49824,-0.35231,0.18226},
      {2.65E-07,6.83E-07,0.70262,0,0.004345,0.0025086,2.80E-07,0.49693,-0.35138,0.18048},
      {4.43E-07,6.57E-07,0.70019,0,0.0067004,0.0038685,6.14E-07,0.49526,-0.3502,0.17822},
      {6.86E-07,6.13E-07,0.69718,0,0.0096326,0.0055614,9.61E-07,0.49319,-0.34873,0.17541},
      {1.00E-06,5.47E-07,0.69349,0,0.013236,0.0076415,1.30E-06,0.49064,-0.34693,0.17197},
      {1.41E-06,4.52E-07,0.68902,0,0.017619,0.010172,1.61E-06,0.48754,-0.34474,0.16777},
      {2.60E-06,2.79E-07,0.68016,-4.81E-09,0.019514,0.0036497,2.79E-06,0.48153,-0.34049,0.15964},
      {5.19E-06,8.33E-08,0.6644,-8.12E-09,0.015985,-0.019803,4.68E-06,0.47091,-0.33298,0.14526},
      {8.04E-06,0,0.64674,0,0.011452,-0.047292,5.69E-06,0.45889,-0.32448,0.12898},
      {1.12E-05,0,0.62555,0,0.0059016,-0.08061,7.91E-06,0.44437,-0.31421,0.10932},
      {1.47E-05,5.89E-08,0.59415,-2.26E-09,0.0013937,-0.1239,1.04E-05,0.42264,-0.29884,0.079907},
      {1.89E-05,3.06E-07,0.53848,-2.49E-08,0.0010721,-0.18774,1.30E-05,0.38388,-0.27144,0.027431},
      {2.30E-05,5.13E-07,0.47943,-7.62E-08,0.00066572,-0.2558,1.57E-05,0.34263,-0.24227,-0.028417},
      {2.69E-05,6.67E-07,0.41709,-1.70E-07,0.00018701,-0.32795,1.82E-05,0.29895,-0.21138,-0.087554},
      {2.22E-05,1.46E-06,0.33439,-2.50E-06,5.81E-05,-0.42344,1.23E-05,0.24061,-0.17013,-0.16654},
      {1.46E-05,1.59E-06,0.24694,-6.43E-06,5.74E-05,-0.52423,3.69E-06,0.17889,-0.12649,-0.25011},
      {7.26E-06,5.10E-07,0.16188,-1.15E-05,5.49E-05,-0.62215,-4.78E-06,0.11892,-0.084092,-0.3313},
      {3.10E-06,9.20E-06,0.10097,-1.84E-05,4.16E-05,-0.69205,-2.29E-05,0.076102,-0.05381,-0.38925},
      {1.51E-06,1.66E-05,0.059476,-2.65E-05,2.51E-05,-0.73918,-4.29E-05,0.047224,-0.033383,-0.4283},
      {3.84E-07,1.22E-05,0.020887,-3.56E-05,1.44E-05,-0.78257,-5.58E-05,0.020633,-0.01458,-0.46427},
      {-7.01E-07,2.46E-05,-0.0022236,-4.21E-05,2.10E-05,-0.80157,-8.62E-05,0.0089502,-0.0063022,-0.48003},
      {-1.51E-06,1.87E-05,-0.011261,-4.41E-05,4.93E-05,-0.79644,-0.00011213,0.01203,-0.0084621,-0.47582},
      {-1.41E-06,-3.38E-05,-0.020473,-4.47E-05,8.82E-05,-0.79019,-0.00010936,0.015819,-0.011144,-0.47069},
      {-3.78E-06,-0.00012811,-0.042817,-4.31E-05,0.00091734,-0.76514,-0.0001007,0.030291,-0.02138,-0.45111},
      {-1.02E-05,-0.00020374,-0.082613,-3.94E-05,0.0033178,-0.715,-0.00013195,0.058412,-0.041233,-0.41299},
      {-1.52E-05,-0.00026562,-0.12104,-3.45E-05,0.0062828,-0.66545,-0.00017219,0.085573,-0.0604,-0.37616},
      {-2.43E-05,-0.0003242,-0.16469,-2.75E-05,0.0080397,-0.6119,-0.00022721,0.11644,-0.082175,-0.33428},
      {-4.26E-05,-0.00039425,-0.22304,-1.95E-05,0.0071257,-0.54594,-0.00030864,0.15771,-0.11127,-0.27827},
      {0,5.07E-08,0.7071,0,8.49E-06,4.90E-06,-3.59E-08,0.49999,-0.35355,0.18463},
      {0,4.59E-08,0.7071,0,8.80E-06,5.08E-06,-3.25E-08,0.49999,-0.35355,0.18463},
      {0,3.74E-08,0.7071,0,9.27E-06,5.35E-06,-2.65E-08,0.49999,-0.35355,0.18463},
      {0,2.37E-08,0.7071,0,9.91E-06,5.72E-06,-1.67E-08,0.49999,-0.35355,0.18463},
      {0,2.37E-09,0.7071,0,1.07E-05,6.19E-06,-1.68E-09,0.49999,-0.35355,0.18463},
      {7.24E-08,0,0.7063,0,0.0007908,0.00045657,5.12E-08,0.49944,-0.35316,0.18388},
      {3.58E-07,0,0.70322,0,0.0038164,0.0022034,2.53E-07,0.4973,-0.35164,0.18098},
      {6.97E-07,0,0.69967,0,0.007311,0.004221,4.93E-07,0.49483,-0.3499,0.17764},
      {1.09E-06,0,0.69567,0,0.011247,0.0064935,7.71E-07,0.49205,-0.34793,0.17387},
      {1.54E-06,0,0.69127,0,0.01558,0.008995,1.09E-06,0.48898,-0.34576,0.16972},
      {2.04E-06,0,0.68654,0,0.020247,0.011689,1.44E-06,0.48568,-0.34343,0.16525},
      {2.86E-06,0,0.6799,0,0.023971,0.010619,2.02E-06,0.48108,-0.34017,0.15902},
      {5.97E-06,0,0.65848,0,0.018547,-0.022922,4.22E-06,0.46629,-0.32971,0.139},
      {9.23E-06,0,0.63282,0,0.012949,-0.061694,6.53E-06,0.44848,-0.31712,0.11489},
      {1.26E-05,0,0.60229,0,0.0072893,-0.10626,8.89E-06,0.42719,-0.30206,0.086059},
      {1.59E-05,9.92E-09,0.565,-6.68E-09,0.002033,-0.15798,1.12E-05,0.40109,-0.28361,0.050729},
      {1.93E-05,1.30E-07,0.50705,-1.34E-07,0.0014573,-0.22528,1.34E-05,0.36048,-0.25489,-0.004251},
      {2.23E-05,1.89E-07,0.44583,-3.22E-07,0.00085731,-0.29654,1.53E-05,0.31748,-0.22448,-0.062476},
      {2.47E-05,1.72E-07,0.38143,-5.89E-07,0.00025719,-0.37161,1.68E-05,0.27214,-0.19242,-0.12386},
      {2.04E-05,-7.11E-07,0.30544,-4.01E-06,3.07E-05,-0.45942,1.15E-05,0.21861,-0.15457,-0.19633},
      {1.28E-05,-3.15E-06,0.22532,-1.04E-05,2.85E-05,-0.55148,2.57E-06,0.16223,-0.11471,-0.27267},
      {6.14E-06,-7.06E-06,0.14822,-1.83E-05,2.54E-05,-0.64002,-6.00E-06,0.108,-0.076375,-0.34608},
      {2.29E-06,-1.12E-05,0.088939,-2.74E-05,1.93E-05,-0.70766,-1.66E-05,0.066568,-0.047083,-0.40215},
      {1.30E-06,-1.91E-05,0.053036,-3.72E-05,1.33E-05,-0.74764,-2.78E-05,0.042064,-0.029758,-0.4353},
      {8.37E-07,-3.32E-05,0.020284,-4.78E-05,1.17E-05,-0.78368,-3.52E-05,0.019976,-0.014145,-0.46517},
      {7.75E-07,-5.39E-05,-0.0031103,-5.59E-05,2.44E-05,-0.80413,-4.34E-05,0.0074174,-0.0052672,-0.48215},
      {7.10E-07,-8.46E-05,-0.0122,-5.64E-05,7.17E-05,-0.79728,-5.73E-05,0.011545,-0.0081757,-0.47654},
      {5.40E-07,-0.00011085,-0.021092,-5.49E-05,0.00013565,-0.7898,-7.54E-05,0.016046,-0.011343,-0.47042},
      {-8.92E-07,-0.00014311,-0.035665,-5.00E-05,0.00075278,-0.77373,-9.70E-05,0.025211,-0.017802,-0.45799},
      {-5.82E-06,-0.0001998,-0.070479,-4.42E-05,0.0032328,-0.72919,-0.00013361,0.049823,-0.035169,-0.42462},
      {-9.54E-06,-0.00025304,-0.10143,-3.68E-05,0.0056361,-0.68924,-0.00016873,0.071706,-0.050607,-0.39495},
      {-1.37E-05,-0.00030563,-0.1318,-2.78E-05,0.007536,-0.65084,-0.00020661,0.093178,-0.06575,-0.36583},
      {0,0,0.7071,0,4.94E-06,2.85E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.17E-06,2.99E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.54E-06,3.20E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.03E-06,3.48E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.66E-06,3.85E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.41E-06,4.28E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.27E-06,4.78E-06,0,0.49999,-0.35355,0.18463},
      {1.46E-07,0,0.70577,0,0.0013149,0.00075913,1.03E-07,0.49907,-0.3529,0.18338},
      {5.62E-07,0,0.70206,0,0.0049831,0.002877,3.97E-07,0.49648,-0.35106,0.17987},
      {1.02E-06,0,0.69804,0,0.0089557,0.0051706,7.22E-07,0.49367,-0.34907,0.17606},
      {1.51E-06,0,0.69379,0,0.013151,0.0075925,1.07E-06,0.4907,-0.34698,0.17205},
      {2.03E-06,0,0.68943,0,0.017465,0.010083,1.44E-06,0.48765,-0.34482,0.16792},
      {2.56E-06,0,0.68507,0,0.021774,0.012571,1.81E-06,0.4846,-0.34266,0.16379},
      {5.33E-06,0,0.65754,0,0.017615,-0.026087,3.77E-06,0.46534,-0.32904,0.13771},
      {8.34E-06,0,0.62167,0,0.012291,-0.076399,5.90E-06,0.44017,-0.31124,0.10364},
      {1.12E-05,0,0.57979,0,0.0071553,-0.13338,7.89E-06,0.41073,-0.29042,0.063772},
      {1.36E-05,0,0.53114,0,0.0023728,-0.19762,9.64E-06,0.37646,-0.26619,0.01737},
      {1.56E-05,-4.24E-08,0.47156,-2.79E-07,0.0014011,-0.26781,1.08E-05,0.3345,-0.23652,-0.039429},
      {1.68E-05,-1.68E-07,0.40833,-6.74E-07,0.00078664,-0.34168,1.14E-05,0.28992,-0.205,-0.099795},
      {1.71E-05,-3.93E-07,0.34204,-1.19E-06,0.00024942,-0.41905,1.14E-05,0.2431,-0.17189,-0.16318},
      {1.34E-05,-2.59E-06,0.27077,-5.41E-06,1.16E-05,-0.50146,6.64E-06,0.19289,-0.13639,-0.23117},
      {7.16E-06,-7.99E-06,0.19872,-1.48E-05,9.31E-06,-0.58408,-2.15E-06,0.14228,-0.10062,-0.29967},
      {2.68E-06,-1.51E-05,0.13026,-2.58E-05,6.55E-06,-0.66255,-1.03E-05,0.094215,-0.066636,-0.36473},
      {5.71E-07,-2.49E-05,0.07415,-3.81E-05,4.30E-06,-0.72645,-1.80E-05,0.055067,-0.038963,-0.41771},
      {4.79E-07,-3.83E-05,0.044564,-5.08E-05,7.47E-06,-0.75849,-2.66E-05,0.035416,-0.025074,-0.44428},
      {6.83E-07,-5.21E-05,0.018147,-6.80E-05,1.39E-05,-0.78628,-3.60E-05,0.018353,-0.013019,-0.46733},
      {7.90E-07,-6.80E-05,-0.0032561,-8.34E-05,2.83E-05,-0.80609,-4.70E-05,0.0061747,-0.0044149,-0.48378},
      {6.12E-07,-9.29E-05,-0.011322,-8.11E-05,8.69E-05,-0.79919,-6.41E-05,0.010322,-0.0073322,-0.47814},
      {4.65E-07,-0.00011651,-0.018698,-7.29E-05,0.0001514,-0.79269,-8.05E-05,0.014228,-0.010074,-0.47285},
      {2.09E-07,-0.00013964,-0.026184,-5.83E-05,0.00029462,-0.78548,-9.66E-05,0.018494,-0.013064,-0.46708},
      {-3.21E-06,-0.00019049,-0.055437,-5.04E-05,0.0024109,-0.748,-0.00013016,0.039177,-0.027654,-0.43903},
      {-5.65E-06,-0.00023702,-0.080659,-4.05E-05,0.0042903,-0.71559,-0.0001615,0.057012,-0.040232,-0.41486},
      {0,0,0.7071,0,2.30E-06,1.33E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.48E-06,1.43E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.75E-06,1.59E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.11E-06,1.80E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.57E-06,2.06E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.11E-06,2.37E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.73E-06,2.73E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.40E-06,3.12E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.10E-06,3.52E-06,0,0.5,-0.35355,0.18463},
      {3.20E-07,0,0.7045,0,0.0025757,0.0014871,2.26E-07,0.49818,-0.35227,0.18217},
      {7.57E-07,0,0.70099,0,0.0060517,0.003494,5.36E-07,0.49572,-0.35053,0.17884},
      {1.20E-06,0,0.6975,0,0.0095144,0.0054931,8.48E-07,0.49327,-0.34879,0.17553},
      {1.63E-06,0,0.69415,0,0.012825,0.0074046,1.15E-06,0.49093,-0.34714,0.17236},
      {2.02E-06,0,0.69113,0,0.015822,0.0091348,1.43E-06,0.48881,-0.34564,0.16949},
      {3.71E-06,0,0.66215,0,0.013646,-0.027964,2.63E-06,0.4684,-0.33121,0.14185},
      {5.79E-06,0,0.61413,0,0.0092012,-0.090948,4.09E-06,0.43454,-0.30727,0.096013},
      {7.36E-06,0,0.55895,0,0.0052246,-0.16144,5.21E-06,0.39559,-0.27972,0.043275},
      {8.25E-06,0,0.4958,0,0.0019078,-0.24004,5.83E-06,0.35098,-0.24817,-0.017134},
      {8.19E-06,-1.96E-07,0.43206,-4.28E-07,0.00083818,-0.31541,5.59E-06,0.30596,-0.21634,-0.07809},
      {7.03E-06,-5.43E-07,0.36698,-1.10E-06,0.00038353,-0.39131,4.48E-06,0.25996,-0.18381,-0.14037},
      {4.54E-06,-1.01E-06,0.29894,-1.92E-06,8.72E-05,-0.47042,2.41E-06,0.21183,-0.14978,-0.20554},
      {4.74E-07,-4.23E-06,0.23071,-7.20E-06,3.91E-07,-0.54909,-2.68E-06,0.16374,-0.11579,-0.27064},
      {5.44E-08,-1.32E-05,0.17012,-2.32E-05,7.98E-07,-0.61822,-9.29E-06,0.12138,-0.085844,-0.32796},
      {8.81E-08,-2.36E-05,0.11184,-4.40E-05,1.59E-06,-0.68467,-1.66E-05,0.080645,-0.057056,-0.38307},
      {1.36E-07,-3.56E-05,0.059501,-6.86E-05,3.14E-06,-0.74406,-2.50E-05,0.04423,-0.031326,-0.43231},
      {3.14E-07,-4.95E-05,0.035893,-8.68E-05,1.01E-05,-0.76848,-3.47E-05,0.029234,-0.020733,-0.45257},
      {4.49E-07,-6.44E-05,0.015036,-0.00010634,1.85E-05,-0.78952,-4.50E-05,0.016306,-0.011604,-0.47002},
      {5.41E-07,-8.02E-05,-0.0029259,-0.00012762,2.82E-05,-0.80704,-5.61E-05,0.0055248,-0.0039937,-0.48456},
      {4.31E-07,-0.00010275,-0.010037,-0.00011741,8.79E-05,-0.80156,-7.18E-05,0.0088138,-0.0062977,-0.48011},
      {3.27E-07,-0.00012381,-0.016146,-9.92E-05,0.00015119,-0.79595,-8.65E-05,0.012192,-0.0086574,-0.47555},
      {2.27E-07,-0.00014279,-0.021446,-7.29E-05,0.00021469,-0.79093,-9.99E-05,0.015222,-0.010764,-0.47148},
      {-1.59E-06,-0.00018218,-0.041672,-5.89E-05,0.0015053,-0.76548,-0.00012656,0.029433,-0.020778,-0.45222},
      {0,0,0.70711,0,5.79E-07,3.35E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.98E-07,4.03E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,8.78E-07,5.07E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.12E-06,6.47E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.42E-06,8.22E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.78E-06,1.03E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.18E-06,1.26E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.60E-06,1.50E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.02E-06,1.74E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.42E-06,1.97E-06,0,0.5,-0.35355,0.18463},
      {9.35E-08,0,0.70639,0,0.00070843,0.00040901,6.61E-08,0.4995,-0.3532,0.18396},
      {4.13E-07,0,0.70398,0,0.003102,0.0017909,2.92E-07,0.49781,-0.352,0.18167},
      {6.95E-07,0,0.70187,0,0.0051965,0.0030002,4.92E-07,0.49633,-0.35095,0.17966},
      {9.18E-07,0,0.70022,0,0.0068217,0.0039385,6.49E-07,0.49518,-0.35014,0.17811},
      {1.05E-06,0,0.69925,0,0.0077845,0.0044944,7.44E-07,0.49449,-0.34966,0.17718},
      {1.56E-06,0,0.67314,0,0.0063559,-0.028095,1.10E-06,0.47605,-0.33662,0.15221},
      {2.20E-06,0,0.61207,0,0.00335,-0.10377,1.56E-06,0.4329,-0.30611,0.093786},
      {1.90E-06,0,0.5439,0,0.0011807,-0.18621,1.35E-06,0.38472,-0.27203,0.028544},
      {1.75E-07,0,0.4681,0,3.44E-05,-0.2757,1.24E-07,0.33113,-0.23415,-0.044011},
      {0,-5.49E-07,0.39984,-1.13E-06,0,-0.35451,-3.88E-07,0.28291,-0.20005,-0.1093},
      {0,-1.82E-06,0.33578,-3.90E-06,0,-0.42838,-1.28E-06,0.23766,-0.16806,-0.17056},
      {0,-3.67E-06,0.26872,-8.14E-06,0,-0.50573,-2.60E-06,0.19029,-0.13456,-0.23469},
      {6.56E-09,-7.86E-06,0.2018,-1.74E-05,1.63E-07,-0.58276,-5.55E-06,0.1431,-0.1012,-0.29856},
      {3.52E-08,-1.94E-05,0.14694,-4.23E-05,1.04E-06,-0.64528,-1.37E-05,0.10477,-0.074119,-0.3504},
      {5.84E-08,-3.23E-05,0.094786,-7.21E-05,2.07E-06,-0.7047,-2.28E-05,0.068332,-0.048374,-0.39968},
      {7.57E-08,-4.66E-05,0.046012,-0.00010698,3.25E-06,-0.76027,-3.29E-05,0.034244,-0.024298,-0.44575},
      {1.86E-07,-6.19E-05,0.02675,-0.00012871,1.18E-05,-0.77947,-4.36E-05,0.022434,-0.015961,-0.46168},
      {2.62E-07,-7.82E-05,0.011012,-0.000152,2.18E-05,-0.79441,-5.51E-05,0.013232,-0.0094688,-0.47408},
      {3.00E-07,-9.59E-05,-0.0020472,-0.00017792,3.30E-05,-0.80618,-6.75E-05,0.0059613,-0.004345,-0.48386},
      {2.37E-07,-0.0001154,-0.0087135,-0.00016526,8.21E-05,-0.80403,-8.12E-05,0.0072314,-0.0052207,-0.48215},
      {1.46E-07,-0.00013319,-0.013497,-0.00013499,0.00013883,-0.79946,-9.37E-05,0.010003,-0.0071411,-0.47844},
      {3.89E-08,-0.00014845,-0.017429,-9.53E-05,0.00019214,-0.79557,-0.00010456,0.012371,-0.0087682,-0.47529},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.97E-08,3.45E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.20E-07,1.27E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.97E-07,2.29E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.79E-07,3.35E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.51E-07,4.34E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,8.93E-07,5.16E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.85E-07,5.68E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.00E-06,5.80E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.30E-07,5.37E-07,0,0.5,-0.35355,0.18464},
      {1.14E-07,0,0.70654,0,0.00055366,0.00031965,8.06E-08,0.49961,-0.35328,0.18411},
      {1.32E-07,0,0.70648,0,0.00060537,0.00034951,9.33E-08,0.49957,-0.35325,0.18406},
      {0,0,0.70708,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70707,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.68798,0,0,-0.022034,0,0.48651,-0.34401,0.16637},
      {0,0,0.61594,0,0,-0.10519,0,0.43559,-0.30801,0.097421},
      {0,0,0.53818,0,0,-0.19496,0,0.38061,-0.26913,0.022988},
      {0,0,0.45444,0,0,-0.29163,0,0.32141,-0.22727,-0.057171},
      {0,-1.08E-06,0.37764,-2.50E-06,0,-0.38026,-7.64E-07,0.26714,-0.1889,-0.13066},
      {0,-3.79E-06,0.31042,-8.89E-06,0,-0.45779,-2.68E-06,0.21965,-0.15532,-0.19494},
      {0,-7.30E-06,0.24028,-1.73E-05,0,-0.5387,-5.16E-06,0.17008,-0.12028,-0.26203},
      {1.50E-09,-1.23E-05,0.16899,-2.96E-05,7.20E-08,-0.62089,-8.72E-06,0.11973,-0.084686,-0.33018},
      {2.04E-08,-2.63E-05,0.12068,-6.34E-05,1.17E-06,-0.67591,-1.86E-05,0.085981,-0.060848,-0.3758},
      {3.42E-08,-4.15E-05,0.075823,-0.00010213,2.41E-06,-0.727,-2.93E-05,0.054629,-0.03871,-0.41816},
      {4.26E-08,-5.80E-05,0.035094,-0.00014613,3.77E-06,-0.77339,-4.09E-05,0.026145,-0.018605,-0.45663},
      {8.94E-08,-7.51E-05,0.0173,-0.00017572,1.26E-05,-0.79118,-5.30E-05,0.015188,-0.010878,-0.47139},
      {1.16E-07,-9.34E-05,0.0062648,-0.00020405,2.40E-05,-0.80065,-6.59E-05,0.009322,-0.0067489,-0.47926},
      {1.10E-07,-0.00011331,-0.0023014,-0.00023587,3.65E-05,-0.80729,-8.00E-05,0.0051824,-0.0038437,-0.48479},
      {4.66E-08,-0.00013119,-0.0073996,-0.00022564,7.26E-05,-0.80651,-9.27E-05,0.0056282,-0.0041397,-0.48419},
      {-6.25E-08,-0.00014589,-0.010837,-0.0001887,0.00012029,-0.80303,-0.00010311,0.0077495,-0.0055954,-0.48137},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.23E-09,1.29E-09,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69886,0,0,-0.0094922,0,0.49419,-0.34944,0.17677},
      {0,0,0.61889,0,0,-0.10183,0,0.43764,-0.30946,0.10021},
      {0,0,0.53274,0,0,-0.20128,0,0.37674,-0.2664,0.017743},
      {0,0,0.44017,0,0,-0.30817,0,0.31128,-0.22011,-0.070885},
      {0,-1.40E-06,0.35282,-3.40E-06,0,-0.409,-9.92E-07,0.24953,-0.17645,-0.15449},
      {0,-5.94E-06,0.28262,-1.45E-05,0,-0.48998,-4.20E-06,0.19993,-0.14138,-0.22163},
      {0,-1.15E-05,0.20958,-2.82E-05,0,-0.57425,-8.13E-06,0.1483,-0.10489,-0.2915},
      {0,-1.82E-05,0.13377,-4.50E-05,0,-0.66171,-1.29E-05,0.09471,-0.067006,-0.36402},
      {9.39E-09,-3.38E-05,0.090819,-8.62E-05,1.21E-06,-0.71069,-2.39E-05,0.064643,-0.045779,-0.40464},
      {1.49E-08,-5.10E-05,0.054379,-0.00013398,2.61E-06,-0.7522,-3.61E-05,0.039148,-0.02779,-0.43905},
      {1.57E-08,-6.95E-05,0.022798,-0.00018709,4.13E-06,-0.78818,-4.91E-05,0.017021,-0.012188,-0.4689},
      {2.03E-08,-8.84E-05,0.0081392,-0.00022779,1.23E-05,-0.80289,-6.25E-05,0.0079348,-0.0057943,-0.4811},
      {5.57E-09,-0.00010947,0.0018102,-0.00027362,2.43E-05,-0.80725,-7.74E-05,0.0051723,-0.0038762,-0.48473},
      {0,-0.00013115,-0.0024767,-0.00033228,3.54E-05,-0.8094,-9.27E-05,0.003743,-0.0029134,-0.48654},
      {-1.33E-08,-0.00014916,-0.0058831,-0.00035012,6.14E-05,-0.80855,-0.00010546,0.0041997,-0.0032452,-0.48587},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62316,0,0,-0.096913,0,0.44065,-0.31159,0.10428},
      {0,0,0.52784,0,0,-0.20697,0,0.37326,-0.26393,0.013025},
      {0,0,0.42563,0,0,-0.325,0,0.30098,-0.21282,-0.084837},
      {0,-1.35E-06,0.32538,-3.36E-06,0,-0.44073,-9.56E-07,0.2301,-0.16271,-0.1808},
      {0,-8.09E-06,0.25238,-2.02E-05,0,-0.52496,-5.72E-06,0.1785,-0.12623,-0.25063},
      {0,-1.62E-05,0.17604,-4.05E-05,0,-0.61304,-1.15E-05,0.12452,-0.088084,-0.32367},
      {0,-2.62E-05,0.097568,-6.50E-05,0,-0.70357,-1.85E-05,0.069041,-0.048871,-0.39873},
      {1.66E-09,-4.25E-05,0.057286,-0.00011058,1.05E-06,-0.7497,-3.00E-05,0.040719,-0.028882,-0.43698},
      {1.11E-10,-6.04E-05,0.031857,-0.00016369,2.37E-06,-0.7787,-4.27E-05,0.022871,-0.016306,-0.46103},
      {0,-7.69E-05,0.013912,-0.00021519,3.48E-06,-0.79907,-5.44E-05,0.010307,-0.0074651,-0.47792},
      {0,-9.53E-05,0.0043717,-0.00026968,9.42E-06,-0.80851,-6.74E-05,0.0044318,-0.0033558,-0.48576},
      {0,-0.00011781,0.0008872,-0.00033941,1.96E-05,-0.80995,-8.33E-05,0.0034264,-0.0027033,-0.48696},
      {0,-0.00014222,-0.0019086,-0.00042411,2.92E-05,-0.8109,-0.00010056,0.0026978,-0.0022606,-0.48776},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62854,0,0,-0.090722,0,0.44444,-0.31427,0.10941},
      {0,0,0.52165,0,0,-0.21414,0,0.36887,-0.26083,0.0070812},
      {0,0,0.40635,0,0,-0.34727,0,0.28734,-0.20318,-0.1033},
      {0,-8.15E-07,0.2871,-1.99E-06,0,-0.48495,-5.77E-07,0.20303,-0.14356,-0.21746},
      {0,-1.08E-05,0.21277,-2.64E-05,0,-0.57072,-7.67E-06,0.15046,-0.10641,-0.28858},
      {0,-2.25E-05,0.13925,-5.49E-05,0,-0.65553,-1.59E-05,0.098477,-0.069677,-0.3589},
      {0,-3.57E-05,0.069214,-8.78E-05,0,-0.73633,-2.53E-05,0.048945,-0.034679,-0.42589},
      {0,-5.10E-05,0.035102,-0.00013266,6.92E-07,-0.77546,-3.61E-05,0.024904,-0.017717,-0.45834},
      {0,-6.61E-05,0.02088,-0.0001812,1.63E-06,-0.79158,-4.67E-05,0.014951,-0.01072,-0.47171},
      {0,-8.02E-05,0.0093821,-0.00022815,2.43E-06,-0.80461,-5.67E-05,0.0068972,-0.0050651,-0.48251},
      {0,-9.75E-05,0.0024717,-0.00028831,6.17E-06,-0.81165,-6.89E-05,0.0024849,-0.0019967,-0.48836},
      {0,-0.00012304,0.00023674,-0.0003839,1.49E-05,-0.81221,-8.70E-05,0.0019786,-0.0017215,-0.48883},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.63479,0,0,-0.083506,0,0.44886,-0.31739,0.1154},
      {0,0,0.51441,0,0,-0.2225,0,0.36374,-0.25721,0.00014651},
      {0,0,0.38566,0,0,-0.37116,0,0.27271,-0.19284,-0.12311},
      {0,0,0.24857,0,0,-0.52946,0,0.17577,-0.12429,-0.25437},
      {0,-1.25E-05,0.17902,-3.08E-05,0,-0.60969,-8.86E-06,0.12659,-0.089538,-0.32089},
      {0,-2.71E-05,0.11514,-6.69E-05,0,-0.68337,-1.91E-05,0.081409,-0.057618,-0.38198},
      {0,-4.31E-05,0.053954,-0.00010687,0,-0.75393,-3.04E-05,0.03813,-0.027047,-0.44049},
      {0,-5.83E-05,0.020248,-0.00015099,3.81E-07,-0.79269,-4.12E-05,0.014326,-0.010252,-0.47262},
      {0,-7.11E-05,0.01165,-0.00019488,1.02E-06,-0.8024,-5.03E-05,0.0083048,-0.0060317,-0.48068},
      {0,-8.30E-05,0.0051279,-0.00023673,1.51E-06,-0.80976,-5.87E-05,0.0037294,-0.0028323,-0.48678},
      {0,-9.74E-05,0.0010369,-0.00029125,3.35E-06,-0.81405,-6.89E-05,0.0010154,-0.00096053,-0.49034},
      {0.45209,0.018544,0.032163,-0.037279,0.0023964,-0.0017011,0.33789,-0.0046859,0.25647,0.17084},
      {0.44412,0.029143,0.022968,-0.044156,0.0027222,-0.00064375,0.31802,-0.016908,0.26291,0.17104},
      {0.43366,0.046396,0.008152,-0.052533,0.0031924,0.00031867,0.28922,-0.032426,0.27228,0.1707},
      {0.35703,0.086146,0.0016158,-0.089849,0.011673,0.0046442,0.2007,-0.064841,0.22624,0.16352},
      {0.26442,0.13416,-0.0072614,-0.11966,0.037279,0.018555,0.089173,-0.096506,0.1649,0.13994},
      {0.14673,0.19674,-0.019503,-0.1293,0.087692,0.046331,-0.048871,-0.11897,0.092463,0.092557},
      {0.064388,0.22969,-0.032531,-0.11317,0.14629,0.079473,-0.12723,-0.11324,0.049941,0.037196},
      {0.031833,0.23291,-0.044679,-0.073159,0.20807,0.11556,-0.15056,-0.082637,0.038953,-0.020958},
      {0.012229,0.23315,-0.058727,-0.025541,0.27078,0.15242,-0.16228,-0.039319,0.041692,-0.079869},
      {0.001502,0.21926,-0.074317,0.017732,0.33133,0.18841,-0.15679,0.0017665,0.03955,-0.13627},
      {0.00114,0.1861,-0.083911,0.024794,0.36191,0.20674,-0.13332,0.012244,0.020326,-0.16468},
      {0.00084855,0.15637,-0.089208,0.026571,0.39906,0.22871,-0.11215,0.023779,0.0078481,-0.19953},
      {0.00061936,0.12942,-0.090326,0.023123,0.44343,0.25481,-0.092863,0.036513,0.0018025,-0.24136},
      {0.0004226,0.10306,-0.087514,0.017671,0.48825,0.2812,-0.073935,0.044432,-0.0034103,-0.28365},
      {0.00027901,0.082758,-0.085778,0.014758,0.51402,0.29639,-0.059321,0.045068,-0.011721,-0.30798},
      {0.00020822,0.070296,-0.089568,0.01094,0.52605,0.30327,-0.050313,0.049823,-0.018611,-0.3195},
      {0.00014692,0.057843,-0.094353,0.0060657,0.53984,0.31121,-0.041357,0.057261,-0.024544,-0.33268},
      {9.49E-05,0.045581,-0.10017,0.0011175,0.55354,0.31917,-0.032579,0.066244,-0.030274,-0.34572},
      {5.22E-05,0.033171,-0.11126,0.00019678,0.55574,0.32058,-0.023732,0.074445,-0.041859,-0.3477},
      {3.12E-05,0.025828,-0.12571,-0.00060873,0.54935,0.31698,-0.018483,0.085007,-0.05257,-0.3415},
      {2.53E-05,0.021401,-0.14299,-0.0012891,0.53724,0.30996,-0.015316,0.097716,-0.063117,-0.32991},
      {2.96E-05,0.017257,-0.16223,-0.001857,0.52326,0.30186,-0.012366,0.1121,-0.074262,-0.31655},
      {4.69E-05,0.012967,-0.17908,-0.0023363,0.51186,0.29529,-0.0092881,0.12482,-0.084283,-0.30563},
      {9.05E-05,0.0080384,-0.19764,-0.002501,0.4982,0.28744,-0.0057257,0.13786,-0.096088,-0.29251},
      {0.00022292,0.0044093,-0.21286,-0.0024663,0.48667,0.28085,-0.0030282,0.14868,-0.10543,-0.28142},
      {0.00048846,0.0021885,-0.2247,-0.0021974,0.47715,0.27537,-0.0012511,0.15726,-0.11218,-0.27229},
      {0.00082371,0.00076481,-0.23121,-0.0017617,0.47226,0.27257,9.97E-06,0.16221,-0.11575,-0.2676},
      {0.0011777,0.00033388,-0.24042,-0.0011346,0.46389,0.26776,0.00057954,0.1692,-0.12005,-0.25955},
      {0.0012282,0.00011918,-0.24439,-0.00092528,0.46033,0.26572,0.00077427,0.17216,-0.122,-0.25614},
      {0.001125,9.03E-07,-0.24519,-0.00075302,0.45997,0.26554,0.00078992,0.17285,-0.12242,-0.25577},
      {0.00069046,5.61E-07,-0.25001,-0.00052149,0.45583,0.26315,0.00048476,0.17642,-0.12493,-0.25181},
      {0.00035892,3.42E-07,-0.25122,-0.00031927,0.45516,0.26276,0.00025188,0.17742,-0.1256,-0.25117},
      {0.45337,0.019037,0.036747,-0.035366,0.0020628,-0.001325,0.32479,-0.00095648,0.25582,0.17125},
      {0.44813,0.029946,0.02628,-0.040574,0.002389,-0.00055795,0.30599,-0.011953,0.2635,0.17112},
      {0.44347,0.045106,0.011371,-0.04591,0.0028713,0.00033507,0.28054,-0.025608,0.27518,0.17069},
      {0.38637,0.081723,0.0038681,-0.069907,0.010436,0.0042788,0.20508,-0.048942,0.24534,0.1641},
      {0.32544,0.12677,-0.0037009,-0.084304,0.02424,0.011606,0.11622,-0.066467,0.21519,0.15144},
      {0.19069,0.19273,-0.01751,-0.098505,0.072527,0.037533,-0.02378,-0.087607,0.14187,0.10549},
      {0.085396,0.25678,-0.033403,-0.089107,0.12104,0.064004,-0.13807,-0.084905,0.097896,0.059442},
      {0.042922,0.27303,-0.046398,-0.053145,0.1778,0.096817,-0.17673,-0.056924,0.085289,0.0058768},
      {0.019602,0.26987,-0.05978,-0.0086412,0.24162,0.13442,-0.18843,-0.019683,0.08028,-0.053995},
      {0.0071986,0.24475,-0.076558,0.014238,0.29348,0.16535,-0.17504,0.0066919,0.059442,-0.10187},
      {0.001327,0.20921,-0.093517,0.020303,0.33696,0.19179,-0.14985,0.025536,0.031999,-0.1414},
      {0.0010108,0.17754,-0.098608,0.022625,0.37538,0.2145,-0.12727,0.036185,0.018067,-0.17743},
      {0.00076039,0.14888,-0.099539,0.019708,0.4208,0.24121,-0.10674,0.048092,0.010719,-0.22023},
      {0.00053929,0.12016,-0.096487,0.016213,0.46275,0.26589,-0.086101,0.051941,0.0016377,-0.25982},
      {0.00032044,0.091217,-0.093688,0.013446,0.49954,0.28783,-0.065325,0.052257,-0.010268,-0.2943},
      {0.00023218,0.076143,-0.097269,0.009864,0.51447,0.29648,-0.054465,0.056814,-0.018415,-0.30852},
      {0.00016868,0.063,-0.1022,0.0052263,0.52852,0.30455,-0.045021,0.064154,-0.024916,-0.32194},
      {0.00011611,0.049902,-0.10955,0.0011934,0.53998,0.31119,-0.035653,0.073131,-0.032591,-0.33286},
      {7.17E-05,0.037023,-0.12102,0.00028824,0.54222,0.3126,-0.026472,0.081572,-0.044622,-0.3349},
      {3.37E-05,0.026818,-0.13124,-0.00049689,0.54332,0.31348,-0.019193,0.089286,-0.054573,-0.33573},
      {2.84E-05,0.02225,-0.15046,-0.0011613,0.5293,0.30535,-0.015933,0.10331,-0.066193,-0.32233},
      {3.20E-05,0.017991,-0.17052,-0.001736,0.51456,0.29681,-0.012902,0.11823,-0.077833,-0.30824},
      {4.93E-05,0.013445,-0.18886,-0.0021955,0.50168,0.28938,-0.0096426,0.13183,-0.08885,-0.29591},
      {9.15E-05,0.008467,-0.20776,-0.0023748,0.48771,0.28135,-0.0060447,0.1451,-0.10086,-0.28251},
      {0.00017702,0.0044433,-0.22227,-0.0023857,0.47735,0.27546,-0.0030878,0.15539,-0.11009,-0.27251},
      {0.00043847,0.0021948,-0.23447,-0.0021312,0.46748,0.26978,-0.0012932,0.16422,-0.11705,-0.26305},
      {0.00076571,0.00081642,-0.24241,-0.0016913,0.46114,0.26614,-6.92E-05,0.17018,-0.12131,-0.25695},
      {0.0011165,0.00036978,-0.25185,-0.0010872,0.45252,0.26119,0.00051013,0.17733,-0.12575,-0.24868},
      {0.0011567,0.00014999,-0.25583,-0.00091359,0.44893,0.25912,0.000701,0.18026,-0.12774,-0.24524},
      {0.0010864,1.93E-05,-0.25613,-0.00074773,0.44905,0.25922,0.00074893,0.18059,-0.1279,-0.24532},
      {0.00071654,5.62E-07,-0.2595,-0.0005266,0.44631,0.25765,0.00050309,0.18312,-0.12966,-0.2427},
      {0.00037404,3.46E-07,-0.26083,-0.00032142,0.44554,0.2572,0.0002625,0.18421,-0.1304,-0.24196},
      {0.45691,0.018637,0.045854,-0.030783,0.0014034,-0.0011921,0.30645,0.0084483,0.25262,0.17163},
      {0.45586,0.028239,0.035279,-0.033443,0.0017379,-0.00057784,0.29015,-0.0006281,0.26178,0.17133},
      {0.45693,0.041059,0.020481,-0.0355,0.0022061,0.00023874,0.2679,-0.012132,0.27573,0.17082},
      {0.41654,0.072212,0.0092853,-0.045771,0.0071103,0.0026102,0.20809,-0.02731,0.26778,0.16581},
      {0.34133,0.12407,0.00082868,-0.05853,0.017317,0.0070457,0.11334,-0.041382,0.24259,0.1556},
      {0.24997,0.18509,-0.011256,-0.062815,0.041204,0.019098,0.0034999,-0.050201,0.21016,0.13233},
      {0.15235,0.24615,-0.026279,-0.052408,0.086177,0.043639,-0.10372,-0.045932,0.17113,0.089561},
      {0.069465,0.30583,-0.044016,-0.027431,0.13547,0.071103,-0.19534,-0.027656,0.14558,0.043049},
      {0.025269,0.3199,-0.06162,0.0001855,0.18837,0.1016,-0.22759,-0.0045178,0.12198,-0.0062665},
      {0.013187,0.28537,-0.079203,0.010246,0.23747,0.13064,-0.20552,0.013309,0.088928,-0.051414},
      {0.0053944,0.24797,-0.097222,0.016317,0.28729,0.16076,-0.17882,0.033455,0.058321,-0.096741},
      {0.0012309,0.20854,-0.11413,0.017888,0.33791,0.19202,-0.14939,0.054839,0.031588,-0.14241},
      {0.0009555,0.17748,-0.11438,0.015876,0.38389,0.21901,-0.1271,0.064383,0.021968,-0.18575},
      {0.00071231,0.14586,-0.11069,0.014227,0.42358,0.24224,-0.10436,0.063674,0.0087893,-0.22328},
      {0.00047931,0.11628,-0.10873,0.01208,0.45938,0.2635,-0.083091,0.064034,-0.004294,-0.2569},
      {0.00026769,0.084715,-0.10952,0.0084463,0.49634,0.28582,-0.06055,0.067616,-0.018706,-0.29132},
      {0.00020124,0.070566,-0.11471,0.0041007,0.51079,0.29411,-0.050394,0.074883,-0.026013,-0.30514},
      {0.0001486,0.05624,-0.12469,0.0013285,0.51865,0.29861,-0.040161,0.084215,-0.036683,-0.31267},
      {0.00010152,0.042678,-0.13672,0.00043808,0.52094,0.30002,-0.030494,0.093016,-0.049366,-0.31478},
      {5.48E-05,0.030866,-0.14553,-0.0003342,0.52519,0.30276,-0.022075,0.099761,-0.059401,-0.31858},
      {3.25E-05,0.02348,-0.16289,-0.0009677,0.5162,0.29775,-0.016832,0.11255,-0.071441,-0.30983},
      {3.49E-05,0.019059,-0.18412,-0.0015493,0.50036,0.28856,-0.013686,0.12825,-0.083795,-0.29469},
      {5.17E-05,0.014132,-0.20457,-0.001984,0.4854,0.27991,-0.010155,0.14308,-0.096235,-0.28037},
      {9.18E-05,0.0090784,-0.22392,-0.0021853,0.47102,0.27164,-0.006503,0.15666,-0.10852,-0.26659},
      {0.00015798,0.0048528,-0.23844,-0.0022294,0.46086,0.26587,-0.0034098,0.16694,-0.11789,-0.25677},
      {0.00035852,0.0021706,-0.24997,-0.0020351,0.45218,0.26094,-0.001336,0.17526,-0.1248,-0.24841},
      {0.00067438,0.00088585,-0.26011,-0.0015885,0.44357,0.25599,-0.00018516,0.18277,-0.13011,-0.24014},
      {0.0010098,0.00042115,-0.26985,-0.0010346,0.43463,0.25085,0.00039717,0.19009,-0.13475,-0.23156},
      {0.0010495,0.0001936,-0.27372,-0.00089617,0.43111,0.24881,0.00059299,0.19292,-0.1367,-0.22819},
      {0.00099777,5.24E-05,-0.27383,-0.00073454,0.43139,0.249,0.00066178,0.19312,-0.13677,-0.22843},
      {0.00075367,5.57E-07,-0.27434,-0.00053318,0.43142,0.24905,0.0005292,0.19362,-0.13707,-0.22844},
      {0.00039465,3.47E-07,-0.27585,-0.00032347,0.43049,0.24851,0.00027698,0.19483,-0.1379,-0.22755},
      {0.43489,0.018583,0.076797,-0.024459,0.00029043,-0.0021283,0.27347,0.03573,0.22796,0.17133},
      {0.43458,0.025006,0.06632,-0.02505,0.00033,-0.0017983,0.25819,0.027124,0.23929,0.17104},
      {0.42589,0.039277,0.05178,-0.026557,0.00078461,-0.0015208,0.2311,0.016097,0.2518,0.16993},
      {0.41387,0.058098,0.031911,-0.027581,0.0013576,-0.0013556,0.19488,0.0016716,0.26905,0.16829},
      {0.3661,0.098977,0.016255,-0.031526,0.007703,0.0012358,0.1227,-0.0108,0.26671,0.16124},
      {0.28896,0.16247,0.0036682,-0.033655,0.01985,0.0064477,0.019554,-0.017648,0.25076,0.14886},
      {0.20539,0.23105,-0.012766,-0.029112,0.035238,0.013751,-0.093338,-0.021635,0.2378,0.13298},
      {0.12014,0.28417,-0.032795,-0.013693,0.083202,0.038972,-0.17638,-0.01056,0.19889,0.087017},
      {0.055506,0.32625,-0.057294,-0.002274,0.1246,0.060862,-0.23038,0.0035939,0.16054,0.048588},
      {0.017176,0.34318,-0.082356,0.0072752,0.16468,0.084464,-0.25013,0.02158,0.12681,0.013392},
      {0.0088643,0.30353,-0.099873,0.013429,0.21963,0.11745,-0.22107,0.041341,0.094222,-0.036759},
      {0.0038039,0.26142,-0.11746,0.015118,0.27559,0.15186,-0.18912,0.063282,0.064521,-0.087263},
      {0.0013487,0.21526,-0.13333,0.013378,0.32677,0.18413,-0.15409,0.079929,0.033423,-0.13287},
      {0.00093642,0.1828,-0.13123,0.012683,0.36567,0.20712,-0.13052,0.079586,0.018178,-0.16938},
      {0.00068929,0.15102,-0.12951,0.010761,0.40345,0.22939,-0.10767,0.080134,0.0038573,-0.20497},
      {0.00045724,0.11617,-0.13009,0.0072587,0.4442,0.25387,-0.082782,0.083708,-0.012033,-0.24302},
      {0.00024454,0.080266,-0.13284,0.0028222,0.48575,0.27933,-0.05728,0.09001,-0.02855,-0.28144},
      {0.00019284,0.06436,-0.14704,0.0015413,0.4883,0.28067,-0.045936,0.10051,-0.043397,-0.28396},
      {0.0001421,0.049935,-0.15975,0.00065646,0.49069,0.28208,-0.035656,0.10974,-0.056886,-0.28621},
      {9.22E-05,0.037318,-0.17008,-0.00010713,0.4941,0.28429,-0.026673,0.11751,-0.06812,-0.28926},
      {4.69E-05,0.026384,-0.18494,-0.0007165,0.49162,0.28329,-0.018931,0.12865,-0.080612,-0.28651},
      {3.72E-05,0.020414,-0.20455,-0.001289,0.47917,0.27625,-0.014687,0.1432,-0.092935,-0.27446},
      {5.26E-05,0.014977,-0.22752,-0.0017025,0.46173,0.26615,-0.010793,0.1595,-0.10712,-0.2578},
      {8.95E-05,0.0098233,-0.24737,-0.0019333,0.44693,0.25762,-0.0070683,0.17342,-0.11972,-0.24361},
      {0.00015244,0.0054967,-0.26232,-0.0020056,0.43641,0.25164,-0.0039017,0.18398,-0.12938,-0.23347},
      {0.00024666,0.0020965,-0.27233,-0.0019101,0.43012,0.24817,-0.0013677,0.19117,-0.136,-0.22729},
      {0.0005444,0.00096274,-0.2854,-0.0014574,0.41845,0.24147,-0.00033416,0.20076,-0.14271,-0.2161},
      {0.00084064,0.00048899,-0.29531,-0.0010056,0.40928,0.23619,0.00022739,0.20812,-0.14751,-0.2073},
      {0.00090748,0.00024634,-0.29891,-0.00087334,0.406,0.23429,0.00045347,0.21075,-0.14933,-0.20417},
      {0.00088044,9.23E-05,-0.29868,-0.00071753,0.40661,0.23466,0.00054916,0.21069,-0.14922,-0.20474},
      {0.00076395,7.53E-06,-0.29618,-0.00053544,0.40955,0.23641,0.00053112,0.20906,-0.14798,-0.20751},
      {0.00041763,3.39E-07,-0.29705,-0.00032374,0.40927,0.23626,0.00029313,0.20982,-0.14848,-0.20724},
      {0.36095,0.016379,0.17026,-0.016587,-0.0011144,-0.0038719,0.2175,0.10924,0.14257,0.17122},
      {0.36611,0.020875,0.15316,-0.016366,-0.0013965,-0.0039267,0.20581,0.096145,0.16116,0.1708},
      {0.37363,0.02726,0.12578,-0.015999,-0.0018734,-0.004144,0.18825,0.075451,0.19025,0.16997},
      {0.36087,0.043393,0.10029,-0.016787,-0.0014133,-0.003924,0.14967,0.05703,0.21198,0.16789},
      {0.34519,0.063639,0.066986,-0.0171,-0.00080286,-0.0036421,0.102,0.033496,0.24048,0.16514},
      {0.30689,0.10109,0.033703,-0.016606,0.0033309,-0.0042452,0.031183,0.011981,0.25959,0.15719},
      {0.22196,0.17744,0.01455,-0.014993,0.017561,-0.0020919,-0.075466,0.0073399,0.24113,0.14013},
      {0.14488,0.26099,-0.014714,-0.01156,0.032199,0.0006472,-0.17463,0.0013451,0.22893,0.12368},
      {0.083083,0.31587,-0.043273,-0.0026011,0.06704,0.018231,-0.23316,0.0095236,0.19964,0.091472},
      {0.039459,0.34836,-0.071026,0.0065342,0.10581,0.041374,-0.26112,0.027482,0.16527,0.05856},
      {0.011359,0.37057,-0.10177,0.013269,0.13933,0.064167,-0.27251,0.049962,0.136,0.032858},
      {0.0059254,0.32839,-0.11924,0.013961,0.19262,0.09572,-0.23903,0.067362,0.10242,-0.015855},
      {0.0034874,0.28049,-0.1338,0.013151,0.24312,0.12678,-0.20222,0.080258,0.068795,-0.061365},
      {0.0016004,0.2347,-0.15082,0.011977,0.2887,0.15798,-0.16757,0.094506,0.035793,-0.099914},
      {0.00094823,0.19586,-0.15628,0.0096793,0.3308,0.18466,-0.13932,0.10068,0.014168,-0.13783},
      {0.00070404,0.15818,-0.15684,0.0060914,0.37462,0.21079,-0.11241,0.10439,-0.0030396,-0.17888},
      {0.00046895,0.11683,-0.1632,0.0029697,0.41583,0.23585,-0.083066,0.1118,-0.025119,-0.21714},
      {0.00024994,0.073998,-0.17831,0.0018431,0.44735,0.25635,-0.05279,0.12319,-0.053738,-0.24533},
      {0.00019323,0.058366,-0.19175,0.00094443,0.45017,0.25798,-0.041655,0.13289,-0.06823,-0.248},
      {0.0001386,0.044757,-0.20795,0.00023471,0.44839,0.25707,-0.03201,0.1447,-0.082945,-0.24619},
      {8.78E-05,0.032903,-0.22345,-0.00043416,0.44614,0.25615,-0.023614,0.15628,-0.096242,-0.2437},
      {4.47E-05,0.022723,-0.23596,-0.00097125,0.44579,0.25668,-0.016383,0.16592,-0.10708,-0.24274},
      {4.91E-05,0.015887,-0.25921,-0.0013588,0.42927,0.24726,-0.011494,0.18215,-0.1223,-0.22683},
      {8.17E-05,0.010609,-0.2795,-0.0016261,0.41412,0.23851,-0.007678,0.19635,-0.13521,-0.21233},
      {0.00014028,0.0061594,-0.29482,-0.0017333,0.40332,0.23235,-0.0044206,0.20715,-0.14513,-0.20193},
      {0.00023017,0.0026357,-0.30515,-0.0016713,0.3968,0.22875,-0.001796,0.21454,-0.152,-0.19555},
      {0.00037031,0.0010319,-0.31947,-0.0013058,0.38464,0.22193,-0.00050872,0.22497,-0.15971,-0.18374},
      {0.00063497,0.00056074,-0.32913,-0.00097055,0.37559,0.21671,2.86E-05,0.23206,-0.16447,-0.17508},
      {0.00073474,0.000302,-0.33218,-0.00084616,0.37283,0.2151,0.00028978,0.2343,-0.16601,-0.17245},
      {0.00073784,0.0001341,-0.33133,-0.00069777,0.37403,0.2158,0.00041699,0.2338,-0.16559,-0.17359},
      {0.00064894,3.77E-05,-0.32815,-0.00052271,0.37763,0.21792,0.00042714,0.23167,-0.164,-0.177},
      {0.00043771,3.15E-07,-0.32514,-0.00031956,0.38115,0.22002,0.00030724,0.22969,-0.16252,-0.18032},
      {0.23634,0.0047544,0.34194,-0.0092187,-0.0021103,-0.004634,0.13636,0.2372,-0.018518,0.17285},
      {0.2414,0.0077257,0.31942,-0.0091769,-0.0024528,-0.0053108,0.12505,0.22043,0.0037185,0.17164},
      {0.2486,0.011883,0.28542,-0.0090478,-0.0029897,-0.0067656,0.1085,0.19519,0.036888,0.16944},
      {0.25736,0.016953,0.24006,-0.0087505,-0.0037368,-0.0094903,0.087115,0.1617,0.080409,0.16581},
      {0.25113,0.035743,0.19417,-0.0084966,-0.0034571,-0.013075,0.048647,0.12911,0.11997,0.16029},
      {0.2338,0.069342,0.14107,-0.0079041,-0.0022391,-0.017973,-0.0059834,0.092979,0.16214,0.1525},
      {0.21622,0.11103,0.071699,-0.0065192,-0.00082234,-0.025198,-0.068747,0.04638,0.21746,0.14204},
      {0.15071,0.1966,0.036613,-0.0032099,0.013834,-0.021829,-0.15512,0.037199,0.21109,0.12676},
      {0.091891,0.28968,-0.0076259,0.0018359,0.028677,-0.017881,-0.23588,0.027367,0.21069,0.11221},
      {0.047429,0.35961,-0.050941,0.0088909,0.053052,-0.0053943,-0.28689,0.028516,0.20121,0.091392},
      {0.025542,0.37184,-0.081244,0.011642,0.084087,0.009198,-0.28523,0.047138,0.16791,0.063016},
      {0.011144,0.3837,-0.11145,0.013761,0.1061,0.026956,-0.28245,0.064548,0.14079,0.049538},
      {0.0052926,0.35887,-0.13225,0.013882,0.14525,0.055887,-0.25903,0.079273,0.11091,0.019424},
      {0.0032941,0.30864,-0.15007,0.011995,0.19613,0.08997,-0.22089,0.094656,0.075378,-0.024204},
      {0.0017774,0.25742,-0.17343,0.0088833,0.24298,0.1246,-0.18298,0.11442,0.038081,-0.061827},
      {0.00099915,0.20954,-0.19016,0.0048369,0.28823,0.15663,-0.14854,0.12995,0.0074425,-0.099755},
      {0.00073622,0.16123,-0.20176,0.0036273,0.32724,0.17946,-0.11435,0.13891,-0.022208,-0.13675},
      {0.00049346,0.11468,-0.21639,0.0024064,0.36286,0.20197,-0.081448,0.15004,-0.052404,-0.16914},
      {0.0002737,0.071227,-0.23726,0.0014134,0.39042,0.22164,-0.050807,0.16551,-0.084151,-0.19234},
      {0.00019028,0.052667,-0.25825,0.00064471,0.38943,0.22181,-0.037709,0.18073,-0.1037,-0.19075},
      {0.00013259,0.039861,-0.27389,-0.00013982,0.38801,0.22134,-0.028631,0.1924,-0.11754,-0.18909},
      {8.46E-05,0.028189,-0.28784,-0.00068115,0.38711,0.22146,-0.020336,0.20268,-0.13012,-0.18769},
      {4.70E-05,0.017496,-0.30279,-0.00098795,0.38388,0.22058,-0.01271,0.2132,-0.14306,-0.18377},
      {6.39E-05,0.011299,-0.32186,-0.0012767,0.37114,0.21347,-0.0082376,0.22655,-0.15583,-0.17138},
      {0.00011714,0.0067087,-0.3374,-0.0014246,0.36024,0.20723,-0.0048753,0.23748,-0.16596,-0.16089},
      {0.00019496,0.0035105,-0.35034,-0.0013438,0.35082,0.20195,-0.0024811,0.24673,-0.17397,-0.15174},
      {0.00028871,0.00162,-0.36309,-0.0010785,0.34052,0.19624,-0.0010063,0.25597,-0.18113,-0.14169},
      {0.00040122,0.000626,-0.37213,-0.00093128,0.33275,0.19193,-0.00018585,0.26249,-0.18603,-0.1341},
      {0.00053842,0.00035243,-0.37421,-0.00081645,0.33093,0.19085,0.00011288,0.26404,-0.18708,-0.13238},
      {0.00057606,0.00017162,-0.37235,-0.00067709,0.33309,0.19209,0.00027418,0.26282,-0.18615,-0.13446},
      {0.00051901,6.42E-05,-0.36813,-0.00051057,0.33769,0.19478,0.00031514,0.25995,-0.18403,-0.13883},
      {0.00037177,1.17E-05,-0.36305,-0.00031434,0.34324,0.19806,0.00025188,0.2565,-0.1815,-0.14408},
      {0.10748,0.0026859,0.52539,-0.0039057,-0.0016618,-0.004937,0.057557,0.37174,-0.19116,0.17613},
      {0.10938,0.0013606,0.52053,-0.0036414,-0.0018732,-0.0056316,0.055609,0.36778,-0.18617,0.17529},
      {0.11764,0.0035068,0.48929,-0.0034596,-0.0023621,-0.0079997,0.045968,0.34472,-0.15676,0.17239},
      {0.12976,0.0079519,0.43904,-0.0031911,-0.0030804,-0.012176,0.030306,0.3079,-0.11006,0.16745},
      {0.14206,0.01321,0.3809,-0.0026504,-0.0039372,-0.01815,0.011081,0.26547,-0.0568,0.16076},
      {0.14608,0.030709,0.31569,-0.0017484,-0.0040544,-0.025503,-0.021266,0.21928,-0.00024306,0.15199},
      {0.1367,0.075804,0.23356,-0.00025955,-0.0024681,-0.033599,-0.078796,0.16396,0.066461,0.14063},
      {0.12744,0.12872,0.13574,0.0021367,-0.00070594,-0.044228,-0.14373,0.098674,0.14591,0.12652},
      {0.092393,0.20898,0.069273,0.0053229,0.0098754,-0.054313,-0.20441,0.069783,0.1703,0.10564},
      {0.058316,0.29508,0.0096588,0.0081476,0.02052,-0.064227,-0.25305,0.052713,0.17926,0.085799},
      {0.033774,0.37085,-0.053285,0.010826,0.030668,-0.067358,-0.29357,0.036553,0.19266,0.072348},
      {0.020032,0.38392,-0.083889,0.012523,0.054693,-0.046728,-0.29016,0.053902,0.16587,0.058921},
      {0.010072,0.39875,-0.11562,0.013095,0.071921,-0.020896,-0.29044,0.072731,0.14486,0.059242},
      {0.0046527,0.3926,-0.14456,0.011723,0.096669,0.011691,-0.28017,0.092391,0.12178,0.053206},
      {0.0030913,0.33752,-0.16867,0.0079523,0.14808,0.048997,-0.23923,0.11313,0.082289,0.011382},
      {0.0018669,0.27169,-0.20499,0.0058725,0.19081,0.080933,-0.19237,0.14023,0.03127,-0.022931},
      {0.0010178,0.20959,-0.24752,0.0043372,0.2252,0.11258,-0.1484,0.17118,-0.020898,-0.045719},
      {0.00073772,0.15817,-0.26364,0.0031915,0.26403,0.13678,-0.11208,0.18331,-0.054329,-0.081311},
      {0.00047707,0.11006,-0.28806,0.0022468,0.29261,0.15695,-0.078196,0.20124,-0.090204,-0.10555},
      {0.00027595,0.068259,-0.31706,0.0010721,0.31182,0.17324,-0.048798,0.22269,-0.12495,-0.11958},
      {0.0001771,0.046683,-0.33761,7.52E-05,0.3164,0.17827,-0.033575,0.23801,-0.14548,-0.12196},
      {0.00012547,0.033488,-0.35055,-0.00033202,0.3173,0.17926,-0.024192,0.24714,-0.15864,-0.12241},
      {8.21E-05,0.022086,-0.36299,-0.00065999,0.31726,0.18016,-0.016051,0.25588,-0.17068,-0.12161},
      {4.84E-05,0.012614,-0.37668,-0.00091894,0.31451,0.17997,-0.0092568,0.26554,-0.18237,-0.11782},
      {7.68E-05,0.0070424,-0.39172,-0.0010904,0.30559,0.17535,-0.0051959,0.27612,-0.19276,-0.10884},
      {0.00014382,0.004323,-0.4047,-0.0010181,0.29567,0.16977,-0.0031347,0.2854,-0.20057,-0.099216},
      {0.00023144,0.0023221,-0.41521,-0.00083561,0.28765,0.16537,-0.0015715,0.29301,-0.20672,-0.091359},
      {0.00026726,0.0010396,-0.42125,-0.00083266,0.28315,0.16298,-0.00059422,0.29729,-0.21038,-0.086871},
      {0.0003285,0.00038836,-0.42551,-0.00078695,0.27975,0.16121,-6.34E-05,0.30034,-0.2128,-0.083454},
      {0.00040367,0.00019764,-0.42215,-0.0006581,0.28337,0.16329,0.00013199,0.29804,-0.21111,-0.086936},
      {0.00038154,8.16E-05,-0.41643,-0.00050153,0.28941,0.16679,0.00020427,0.29411,-0.20824,-0.092705},
      {0.0002665,2.24E-05,-0.40981,-0.00031519,0.29647,0.17093,0.00016912,0.28956,-0.20492,-0.099409},
      {0.030091,0.004578,0.64174,-0.00087118,-0.00090903,-0.0039817,0.0096199,0.45479,-0.29735,0.17953},
      {0.03196,0.004023,0.63672,-0.00076976,-0.001056,-0.004839,0.0089704,0.45097,-0.29278,0.17861},
      {0.034077,0.003393,0.63021,-0.0006149,-0.0012562,-0.0061648,0.0078042,0.44601,-0.28695,0.17723},
      {0.037744,0.0038863,0.61432,-0.00034473,-0.0015772,-0.008839,0.0035055,0.43426,-0.27285,0.17446},
      {0.048768,0.0086157,0.56035,0.00035233,-0.0023131,-0.01607,-0.012034,0.39519,-0.22487,0.16686},
      {0.059827,0.013085,0.50123,0.0011738,-0.0031109,-0.026428,-0.028431,0.3526,-0.17354,0.15653},
      {0.070981,0.022665,0.43308,0.0018738,-0.003778,-0.041985,-0.046064,0.30445,-0.11715,0.14125},
      {0.073436,0.072809,0.32056,0.0030637,-0.0026968,-0.06756,-0.093813,0.22934,-0.0302,0.11522},
      {0.073668,0.12729,0.19934,0.0046143,-0.0019235,-0.1065,-0.14199,0.14952,0.05847,0.078635},
      {0.060117,0.19985,0.10187,0.0067962,0.0030495,-0.13458,-0.18926,0.096766,0.11312,0.049075},
      {0.038835,0.2867,0.030045,0.0090987,0.010682,-0.13706,-0.23605,0.07311,0.13912,0.040745},
      {0.023704,0.37118,-0.046598,0.010789,0.015633,-0.13465,-0.28265,0.048214,0.17338,0.040111},
      {0.014363,0.39687,-0.085853,0.010886,0.031397,-0.10907,-0.28977,0.060976,0.162,0.042783},
      {0.0079951,0.41333,-0.11984,0.0094874,0.043305,-0.075183,-0.29386,0.082463,0.1465,0.057022},
      {0.0040959,0.41098,-0.15615,0.0086533,0.051383,-0.044018,-0.29091,0.10465,0.12561,0.072778},
      {0.0028254,0.33766,-0.19358,0.0066967,0.098729,-0.010988,-0.23889,0.13224,0.070197,0.032739},
      {0.0017875,0.267,-0.24629,0.0054237,0.13478,0.024876,-0.18884,0.17017,0.0084126,0.011146},
      {0.00095297,0.19999,-0.31521,0.0044704,0.15786,0.062514,-0.14153,0.21935,-0.059521,0.0095366},
      {0.00063782,0.14728,-0.34249,0.0029234,0.19098,0.087632,-0.1044,0.23969,-0.098875,-0.017086},
      {0.00041802,0.10189,-0.36941,0.0012513,0.21641,0.10748,-0.072443,0.25997,-0.13416,-0.037086},
      {0.00025537,0.0629,-0.40033,0.0004082,0.23146,0.12267,-0.045055,0.28245,-0.16862,-0.046079},
      {0.00016319,0.038045,-0.42356,6.44E-05,0.23735,0.13057,-0.027544,0.29891,-0.19263,-0.047977},
      {0.00011358,0.025987,-0.43254,-0.00029477,0.24141,0.13379,-0.018923,0.30521,-0.2033,-0.051141},
      {7.41E-05,0.015874,-0.44307,-0.00058299,0.24246,0.13573,-0.01166,0.31262,-0.21374,-0.051024},
      {4.36E-05,0.008771,-0.45585,-0.00071263,0.23886,0.13557,-0.0065123,0.32172,-0.22376,-0.045993},
      {7.28E-05,0.0049643,-0.46781,-0.0007225,0.23186,0.1325,-0.0036758,0.33024,-0.23165,-0.038485},
      {0.00014389,0.0029237,-0.47318,-0.00067765,0.22881,0.13089,-0.0020942,0.33411,-0.23534,-0.035449},
      {0.00018735,0.0015421,-0.47489,-0.00069521,0.22866,0.13095,-0.0010379,0.33531,-0.2369,-0.035174},
      {0.00020675,0.00064381,-0.47864,-0.00069478,0.22615,0.12981,-0.00034874,0.33797,-0.23924,-0.032511},
      {0.00023135,0.00020515,-0.48092,-0.00064432,0.22466,0.12925,3.15E-06,0.33961,-0.24057,-0.030834},
      {0.00024579,8.48E-05,-0.47317,-0.00049896,0.23268,0.13388,0.00010494,0.33423,-0.23667,-0.038515},
      {0.00016243,3.37E-05,-0.46271,-0.00032622,0.24349,0.14016,8.70E-05,0.32696,-0.23143,-0.048832},
      {0.0056426,0.004656,0.68685,-0.00020548,-0.00030409,-0.0026039,-0.001409,0.48594,-0.33687,0.18192},
      {0.0072831,0.0044272,0.68231,-0.00018421,-0.00040968,-0.0036071,-0.001403,0.48264,-0.33307,0.18091},
      {0.0095514,0.004112,0.67584,-0.00015155,-0.00056111,-0.0051771,-0.0014326,0.47793,-0.3277,0.17935},
      {0.012213,0.0037485,0.66781,-0.00010674,-0.00074904,-0.0074039,-0.0015402,0.47209,-0.32114,0.17719},
      {0.014932,0.0033967,0.65881,-4.97E-05,-0.00095764,-0.010397,-0.0017717,0.46556,-0.31399,0.17434},
      {0.023937,0.0068571,0.6099,0.00047549,-0.0016939,-0.024109,-0.011898,0.43067,-0.27399,0.16139},
      {0.032137,0.011607,0.55498,0.0011238,-0.0024839,-0.043861,-0.023374,0.39164,-0.23091,0.14328},
      {0.037767,0.017536,0.50107,0.0018236,-0.0031817,-0.06972,-0.0343,0.35352,-0.19131,0.12025},
      {0.039178,0.069548,0.38106,0.0033905,-0.0026139,-0.11475,-0.07734,0.27459,-0.10545,0.079594},
      {0.038634,0.13012,0.24842,0.0051822,-0.0019626,-0.17404,-0.1226,0.1885,-0.014662,0.027843},
      {0.033093,0.20094,0.12707,0.0070108,0.00024721,-0.22581,-0.16711,0.11671,0.060674,-0.017169},
      {0.021347,0.2865,0.048005,0.0082683,0.0050511,-0.21951,-0.21383,0.090165,0.099781,-0.013809},
      {0.014672,0.35957,-0.032429,0.0086656,0.0074644,-0.21186,-0.2577,0.062258,0.14397,-0.0074858},
      {0.010455,0.37627,-0.082183,0.0082866,0.015142,-0.19599,-0.26846,0.061472,0.14803,-0.0036985},
      {0.0066295,0.37404,-0.11987,0.0075336,0.023287,-0.1628,-0.26566,0.084256,0.12663,0.013655},
      {0.0037441,0.37433,-0.16738,0.0077034,0.027987,-0.11578,-0.2647,0.11439,0.10145,0.047114},
      {0.002382,0.31911,-0.22339,0.0065614,0.057295,-0.072144,-0.22537,0.15389,0.045587,0.041814},
      {0.0015287,0.24882,-0.29204,0.0047694,0.085104,-0.031533,-0.17572,0.20342,-0.023458,0.035902},
      {0.00085467,0.18363,-0.37393,0.0027487,0.10094,0.010135,-0.12984,0.26251,-0.096197,0.047934},
      {0.00051092,0.13078,-0.42198,0.0010774,0.12341,0.040325,-0.092698,0.29756,-0.14584,0.040789},
      {0.00034053,0.08857,-0.4475,0.00074591,0.14623,0.059842,-0.063049,0.31573,-0.17955,0.024215},
      {0.00021672,0.053646,-0.4792,0.00041431,0.15692,0.073963,-0.038523,0.33827,-0.21268,0.020597},
      {0.00013687,0.028627,-0.51014,8.61E-05,0.15812,0.082353,-0.020915,0.36024,-0.24055,0.025827},
      {8.68E-05,0.0189,-0.51329,-0.000205,0.16646,0.088756,-0.013896,0.36245,-0.24713,0.019169},
      {4.99E-05,0.011636,-0.51953,-0.00038296,0.16964,0.092565,-0.0086106,0.36691,-0.25399,0.017757},
      {2.73E-05,0.0063121,-0.53129,-0.00046582,0.16559,0.092401,-0.0046973,0.3753,-0.26259,0.023448},
      {5.04E-05,0.0033101,-0.53619,-0.00052221,0.16499,0.093343,-0.0024702,0.37877,-0.26659,0.025078},
      {0.00010449,0.0018719,-0.53303,-0.00055076,0.1697,0.096157,-0.0013613,0.37653,-0.26575,0.020655},
      {0.00013408,0.00091406,-0.53223,-0.00056082,0.17174,0.097588,-0.0006182,0.37596,-0.26585,0.018917},
      {0.00013656,0.00033609,-0.53525,-0.00055545,0.16976,0.096888,-0.00017224,0.3781,-0.26766,0.021171},
      {0.00012152,7.79E-05,-0.53725,-0.00050421,0.16855,0.096649,2.14E-05,0.37954,-0.26878,0.022716},
      {7.54E-05,4.22E-05,-0.52135,-0.00033641,0.1847,0.10598,1.96E-05,0.36842,-0.26079,0.007246},
      {0.001516,0.0032603,0.69798,-0.00036975,-3.03E-05,-0.0018586,-0.00077297,0.49358,-0.3465,0.18292},
      {0.0019214,0.0033132,0.69687,-0.00028818,-5.14E-05,-0.0023704,-0.00083671,0.49285,-0.34562,0.18245},
      {0.0031895,0.0031936,0.69209,-0.0002518,-0.00015875,-0.0043211,-0.0010222,0.4894,-0.34197,0.18064},
      {0.0046915,0.0030843,0.68597,-0.00020299,-0.00029105,-0.007097,-0.0012885,0.48499,-0.33739,0.1781},
      {0.0062445,0.0030361,0.67881,-0.0001425,-0.0004356,-0.010828,-0.0016404,0.47984,-0.33222,0.17473},
      {0.0076373,0.0031152,0.67096,-7.20E-05,-0.00057538,-0.015673,-0.0020703,0.47421,-0.32682,0.17044},
      {0.01111,0.0069613,0.63655,0.00035744,-0.00099581,-0.034005,-0.0082913,0.4499,-0.30225,0.15426},
      {0.014488,0.01416,0.58701,0.0010088,-0.0014611,-0.064424,-0.017176,0.41505,-0.26851,0.12786},
      {0.015886,0.023485,0.5373,0.0016776,-0.0017041,-0.10216,-0.024971,0.38025,-0.23747,0.095731},
      {0.015943,0.072284,0.42462,0.0031379,-0.0011768,-0.16273,-0.058022,0.30673,-0.16313,0.044237},
      {0.015731,0.13528,0.27952,0.0047632,-0.00048455,-0.24427,-0.099248,0.21297,-0.068892,-0.024196},
      {0.016693,0.18468,0.12854,0.005859,-0.0003309,-0.33761,-0.13603,0.11477,0.026793,-0.10264},
      {0.013073,0.24083,0.048219,0.0062042,0.0017509,-0.3335,-0.1748,0.08273,0.072501,-0.10057},
      {0.01029,0.28949,-0.020416,0.0067871,0.0031241,-0.32579,-0.20759,0.057946,0.10957,-0.094678},
      {0.0077613,0.31721,-0.073566,0.0069767,0.0062835,-0.3037,-0.22553,0.055155,0.12133,-0.079365},
      {0.0050485,0.31881,-0.12265,0.0065936,0.011727,-0.25241,-0.22549,0.086739,0.096442,-0.043362},
      {0.0030606,0.32255,-0.18069,0.0057192,0.014007,-0.19,-0.22741,0.12584,0.06892,0.0060942},
      {0.0019065,0.29188,-0.24981,0.0037144,0.026844,-0.13176,-0.20559,0.17498,0.019619,0.036468},
      {0.0012312,0.22346,-0.33123,0.0015336,0.046527,-0.087791,-0.15747,0.23378,-0.054418,0.044871},
      {0.00069782,0.15957,-0.41963,0.0013504,0.058028,-0.04132,-0.11276,0.29605,-0.13049,0.066953},
      {0.00037277,0.10825,-0.48966,0.0011053,0.069521,-0.0010369,-0.076793,0.34549,-0.19105,0.083894},
      {0.00024334,0.071221,-0.51765,0.00073518,0.086179,0.016647,-0.050782,0.36543,-0.22336,0.074652},
      {0.00014959,0.042239,-0.54765,0.00040897,0.094729,0.031945,-0.030409,0.38679,-0.25267,0.075069},
      {8.24E-05,0.021361,-0.57976,0.00011929,0.094008,0.042955,-0.015704,0.40963,-0.27899,0.085242},
      {4.14E-05,0.013446,-0.58152,-0.00011606,0.10278,0.050468,-0.0099425,0.41091,-0.28394,0.078878},
      {1.88E-05,0.008016,-0.58426,-0.00025719,0.10774,0.055455,-0.0059612,0.41288,-0.28813,0.075893},
      {1.20E-05,0.0043407,-0.5882,-0.00034829,0.10959,0.058666,-0.0032759,0.41566,-0.29201,0.07589},
      {2.32E-05,0.001984,-0.5938,-0.00040282,0.10812,0.059617,-0.0015276,0.41961,-0.29602,0.078791},
      {6.38E-05,0.0010156,-0.58788,-0.00042216,0.11523,0.063915,-0.00076426,0.41541,-0.29357,0.072153},
      {7.69E-05,0.00041966,-0.58609,-0.00042579,0.11802,0.065912,-0.00029338,0.41414,-0.29299,0.069796},
      {5.80E-05,0.00018664,-0.58431,-0.00040287,0.12063,0.067967,-0.00011139,0.4129,-0.29223,0.067756},
      {1.69E-05,4.69E-05,-0.58461,-0.00034378,0.12121,0.068987,-2.44E-05,0.41315,-0.29245,0.067765},
      {0.00061533,0.0018107,0.69968,-0.00083034,2.61E-05,-0.0026214,-0.00013819,0.49427,-0.34849,0.18231},
      {0.00078768,0.0018613,0.69933,-0.00068436,2.55E-05,-0.003015,-0.00016117,0.49413,-0.3482,0.18198},
      {0.0010398,0.0019305,0.69881,-0.00045653,2.51E-05,-0.0036435,-0.00019139,0.49392,-0.34776,0.18144},
      {0.0014985,0.0020328,0.69668,-0.00022909,7.96E-09,-0.0053954,-0.0003043,0.49256,-0.34628,0.17991},
      {0.00229,0.0022684,0.6906,-0.0001719,-8.24E-05,-0.0099309,-0.00062835,0.48823,-0.3424,0.17596},
      {0.0030005,0.0026708,0.68359,-0.0001062,-0.00015357,-0.015767,-0.00096891,0.48326,-0.33815,0.17094},
      {0.0035261,0.0033075,0.6758,-3.49E-05,-0.00019663,-0.02309,-0.0012779,0.47775,-0.33372,0.1647},
      {0.0043915,0.0077777,0.64858,0.00026239,-0.00029121,-0.045835,-0.0044778,0.45868,-0.31742,0.14544},
      {0.0058707,0.016612,0.58735,0.00078955,-0.00052057,-0.097856,-0.011618,0.41582,-0.28098,0.10154},
      {0.0069719,0.025457,0.51301,0.0012532,-0.00073936,-0.16575,-0.018885,0.36383,-0.23831,0.044515},
      {0.0082228,0.056488,0.39127,0.0022008,-0.00087944,-0.25392,-0.042257,0.28207,-0.16339,-0.029645},
      {0.0093403,0.10041,0.24543,0.0033793,-0.00092252,-0.35122,-0.074646,0.18565,-0.072024,-0.11124},
      {0.0097976,0.13655,0.10951,0.0042669,-0.0009764,-0.45169,-0.10092,0.095313,0.010308,-0.19499},
      {0.0080541,0.18201,0.035925,0.0047344,0.00017052,-0.45601,-0.13158,0.064052,0.051716,-0.19872},
      {0.0064705,0.22359,-0.017165,0.0047936,0.0010346,-0.43933,-0.15912,0.049633,0.079598,-0.18439},
      {0.0052865,0.25498,-0.060501,0.0042477,0.0017106,-0.41659,-0.1796,0.046205,0.095824,-0.16501},
      {0.0034853,0.25999,-0.12053,0.0029106,0.0044255,-0.34968,-0.18244,0.087051,0.06833,-0.11242},
      {0.0022525,0.26519,-0.18893,0.0016312,0.0053302,-0.27117,-0.1861,0.13461,0.037233,-0.048147},
      {0.0014231,0.25142,-0.26443,0.0016746,0.0095818,-0.19544,-0.17686,0.18695,-0.0072897,0.0086183},
      {0.00089561,0.18617,-0.35301,0.0014449,0.022968,-0.14713,-0.13119,0.24936,-0.084108,0.029515},
      {0.00049613,0.12921,-0.4501,0.0012411,0.028433,-0.092825,-0.091305,0.31782,-0.16102,0.066758},
      {0.00022548,0.081981,-0.54484,0.0010674,0.032602,-0.031893,-0.058213,0.38468,-0.23188,0.11135},
      {0.00013279,0.052344,-0.57021,0.00068422,0.047056,-0.012549,-0.037377,0.40281,-0.25917,0.10664},
      {6.46E-05,0.0303,-0.59853,0.00033894,0.051587,0.0017598,-0.021849,0.423,-0.28416,0.112},
      {1.74E-05,0.015316,-0.62824,6.53E-05,0.04805,0.011848,-0.011248,0.44411,-0.30636,0.12545},
      {2.81E-06,0.0089986,-0.63001,-7.10E-05,0.057327,0.022281,-0.0067211,0.44536,-0.31044,0.12078},
      {-2.90E-06,0.0052875,-0.62858,-0.00017473,0.06458,0.028584,-0.0040057,0.44434,-0.31165,0.11559},
      {-2.75E-06,0.0026551,-0.63321,-0.00024496,0.064821,0.030993,-0.0020621,0.4476,-0.31534,0.11724},
      {1.40E-06,0.0009341,-0.64328,-0.00028144,0.058878,0.03004,-0.00077068,0.4547,-0.32126,0.12499},
      {2.48E-05,0.00054314,-0.63135,-0.00028837,0.071514,0.037609,-0.00043017,0.44626,-0.31551,0.11312},
      {1.99E-05,0.00031435,-0.62419,-0.00027603,0.079392,0.042621,-0.0002386,0.44121,-0.31206,0.10596},
      {-2.48E-06,0.00015064,-0.62228,-0.00024338,0.082161,0.044886,-0.00011886,0.43987,-0.31119,0.10386},
      {0.00019595,0.00089833,0.70016,-0.0014722,5.80E-05,-0.0032486,0.00027004,0.4941,-0.34969,0.18179},
      {0.00031288,0.0009287,0.69959,-0.0012965,5.79E-05,-0.0039836,0.00026266,0.49382,-0.34929,0.18117},
      {0.00048708,0.00096994,0.69862,-0.0010316,5.79E-05,-0.0052097,0.00025378,0.49334,-0.34863,0.18014},
      {0.00071056,0.0010221,0.69705,-0.00070242,5.90E-05,-0.0071421,0.00024212,0.49248,-0.34762,0.17851},
      {0.0009788,0.0010784,0.69466,-0.00030257,6.18E-05,-0.010039,0.00022677,0.4911,-0.34617,0.17607},
      {0.0014019,0.001444,0.68516,-0.0002125,1.96E-05,-0.019595,-4.40E-05,0.48445,-0.34097,0.168},
      {0.001861,0.0018848,0.67096,-0.00017,-3.73E-05,-0.034199,-0.00040211,0.47445,-0.33337,0.15569},
      {0.0023028,0.0023161,0.65219,-9.69E-05,-9.70E-05,-0.054122,-0.00079001,0.46124,-0.32347,0.13895},
      {0.0028405,0.0047666,0.61509,9.76E-05,-0.00021186,-0.091404,-0.0028562,0.43522,-0.30326,0.10766},
      {0.0035815,0.012743,0.53354,0.00053007,-0.00047923,-0.16989,-0.009418,0.37809,-0.25781,0.041848},
      {0.004026,0.020435,0.43964,0.00091312,-0.00072274,-0.26396,-0.015732,0.31231,-0.20666,-0.036797},
      {0.0044171,0.038802,0.32532,0.0014682,-0.00083868,-0.36624,-0.02947,0.23402,-0.14157,-0.12209},
      {0.0048304,0.070913,0.20035,0.002174,-0.00079503,-0.46152,-0.052466,0.15077,-0.066477,-0.20121},
      {0.0047822,0.095704,0.086926,0.002473,-0.000691,-0.55733,-0.069628,0.074767,-0.00076403,-0.28033},
      {0.0040301,0.1281,0.019145,0.0022953,-0.00013017,-0.5782,-0.090997,0.042661,0.036454,-0.29692},
      {0.0033467,0.16239,-0.019481,0.0014536,0.00027354,-0.5545,-0.11345,0.037817,0.055891,-0.27628},
      {0.0032049,0.19269,-0.04687,0.0011708,0.00034924,-0.5198,-0.13431,0.038867,0.070086,-0.24728},
      {0.0023556,0.20229,-0.10956,0.0012755,0.0016615,-0.44075,-0.14154,0.079745,0.04521,-0.18355},
      {0.0015528,0.20325,-0.1853,0.001367,0.0024367,-0.35379,-0.14266,0.13211,0.0079667,-0.11248},
      {0.00097092,0.19712,-0.26972,0.0014523,0.0027851,-0.26481,-0.13862,0.19099,-0.037235,-0.039129},
      {0.00060024,0.1435,-0.36704,0.001245,0.010403,-0.2026,-0.10108,0.25963,-0.11258,0.0015738},
      {0.00031367,0.095523,-0.46798,0.0010209,0.014357,-0.13587,-0.067479,0.33088,-0.18689,0.051278},
      {0.00010427,0.056687,-0.57136,0.00081032,0.014551,-0.062163,-0.040272,0.40387,-0.25783,0.11217},
      {2.21E-05,0.032797,-0.61219,0.00044629,0.019988,-0.034085,-0.023465,0.43289,-0.28998,0.12766},
      {-8.01E-06,0.019806,-0.63273,0.0002423,0.024268,-0.018517,-0.014334,0.44745,-0.3066,0.13443},
      {-2.15E-05,0.01081,-0.6524,9.57E-05,0.024466,-0.0063836,-0.0080037,0.46135,-0.3208,0.14421},
      {-2.46E-05,0.0055641,-0.66165,-1.95E-05,0.027041,0.0022373,-0.0042563,0.46786,-0.32801,0.14766},
      {-2.25E-05,0.0029838,-0.66177,-0.00010065,0.031717,0.0071762,-0.0023459,0.46793,-0.32942,0.14504},
      {-1.53E-05,0.0015843,-0.66295,-0.00014715,0.034254,0.010999,-0.0012724,0.46874,-0.33074,0.14456},
      {-7.65E-06,0.00074412,-0.66724,-0.00016302,0.033348,0.0131,-0.00060582,0.47175,-0.33331,0.14761},
      {-2.96E-06,0.00043297,-0.66044,-0.00016099,0.041412,0.018726,-0.00034388,0.46694,-0.33009,0.14069},
      {-5.27E-06,0.00027198,-0.65169,-0.00014865,0.050586,0.024249,-0.00021728,0.46075,-0.32579,0.1321},
      {-0.00034676,0.00056415,0.6979,-0.0024744,8.06E-05,-0.0052026,0.00042836,0.4919,-0.34939,0.18018},
      {-0.00025331,0.00057594,0.69677,-0.0023042,8.21E-05,-0.0066048,0.00042056,0.49124,-0.34874,0.179},
      {-0.00011299,0.00059168,0.69494,-0.0020458,8.47E-05,-0.0088683,0.000409,0.49015,-0.34768,0.17711},
      {7.36E-05,0.0006088,0.69224,-0.0016972,8.85E-05,-0.012202,0.00039394,0.48852,-0.34615,0.17431},
      {0.00030197,0.00062355,0.68843,-0.0012627,9.38E-05,-0.016863,0.00037602,0.48619,-0.34403,0.17041},
      {0.00056445,0.00063144,0.68324,-0.00075351,0.00010091,-0.023168,0.00035623,0.48295,-0.34121,0.16514},
      {0.00087218,0.00080249,0.66981,-0.00042184,8.04E-05,-0.038179,0.00017452,0.47375,-0.33417,0.15257},
      {0.0011943,0.0011373,0.64554,-0.00029174,3.39E-05,-0.064914,-0.0001799,0.45671,-0.32164,0.13018},
      {0.0014832,0.0014568,0.615,-0.00015042,-4.95E-06,-0.098987,-0.00054603,0.43525,-0.306,0.1017},
      {0.0017308,0.002424,0.57196,1.21E-05,-4.90E-05,-0.14646,-0.001447,0.40501,-0.28382,0.062079},
      {0.0019511,0.0092364,0.47391,0.00032435,-0.00022146,-0.24773,-0.0069451,0.33626,-0.23132,-0.02236},
      {0.0019465,0.015574,0.36447,0.00056331,-0.00029849,-0.36397,-0.011934,0.2595,-0.17368,-0.11902},
      {0.0018109,0.025235,0.24716,0.00075322,-0.00022993,-0.48575,-0.01891,0.17792,-0.11128,-0.21994},
      {0.0017852,0.046344,0.14518,0.00082144,-1.42E-05,-0.57518,-0.033071,0.10939,-0.052774,-0.29348},
      {0.001767,0.062638,0.060795,0.00075823,7.65E-05,-0.65137,-0.043862,0.052411,-0.004735,-0.35614},
      {0.0018479,0.086331,0.0085648,0.00083473,7.70E-05,-0.66749,-0.060319,0.025767,0.025806,-0.36941},
      {0.0018996,0.11793,-0.016319,0.00088091,0.00014518,-0.62662,-0.082397,0.02834,0.039661,-0.33557},
      {0.0019668,0.1425,-0.038148,0.00090292,0.00017235,-0.59053,-0.099532,0.032981,0.048603,-0.30568},
      {0.0015946,0.15012,-0.095678,0.00096426,0.00066126,-0.52141,-0.10505,0.069671,0.026099,-0.24903},
      {0.0010563,0.1454,-0.18232,0.0010258,0.0011395,-0.42791,-0.10199,0.13017,-0.019486,-0.17211},
      {0.00062498,0.13492,-0.27527,0.0010127,0.0012516,-0.33385,-0.094805,0.19546,-0.071149,-0.094192},
      {0.00032378,0.099958,-0.37523,0.00079387,0.0038062,-0.25559,-0.070352,0.26604,-0.13848,-0.032901},
      {0.00011369,0.061579,-0.47845,0.00052201,0.0049864,-0.17992,-0.043471,0.33894,-0.20909,0.028207},
      {-2.57E-07,0.036557,-0.57864,0.00048016,0.0052503,-0.093451,-0.026,0.40955,-0.27156,0.099579},
      {-4.70E-05,0.021474,-0.63314,0.00039194,0.0079853,-0.043782,-0.015461,0.44797,-0.30621,0.13686},
      {-5.65E-05,0.012701,-0.651,0.00023592,0.010027,-0.030296,-0.0092954,0.46058,-0.31939,0.14511},
      {-5.57E-05,0.0065371,-0.66844,0.0001106,0.0087871,-0.020003,-0.0049411,0.47286,-0.33106,0.15543},
      {-4.21E-05,0.0033666,-0.67832,1.82E-05,0.0098363,-0.011022,-0.0026528,0.47977,-0.33748,0.16137},
      {-3.20E-05,0.0020635,-0.67583,-3.97E-05,0.015798,-0.005398,-0.0016487,0.47798,-0.33692,0.15747},
      {-2.23E-05,0.001177,-0.6775,-6.82E-05,0.017435,-0.0019531,-0.000952,0.47913,-0.33821,0.15798},
      {-1.35E-05,0.00064555,-0.68155,-7.43E-05,0.016486,0.00019961,-0.0005203,0.48196,-0.3405,0.16113},
      {-8.68E-06,0.00039736,-0.67636,-7.59E-05,0.022935,0.0049681,-0.0003208,0.47826,-0.33803,0.15582},
      {-0.00063279,0.00040939,0.69831,-0.0025091,9.39E-05,-0.0048923,0.00046747,0.49229,-0.34986,0.18045},
      {-0.00061739,0.00038191,0.69776,-0.0026541,9.80E-05,-0.005335,0.00049297,0.49182,-0.34968,0.18007},
      {-0.00051589,0.00037428,0.69532,-0.0024744,0.00010213,-0.0082529,0.00048867,0.49026,-0.3484,0.17763},
      {-0.00036241,0.00037023,0.69141,-0.0021423,0.00010739,-0.012999,0.00047305,0.48779,-0.34631,0.17367},
      {-0.00017436,0.00036214,0.68604,-0.0017347,0.00011444,-0.019463,0.00045415,0.48436,-0.34347,0.16827},
      {4.18E-05,0.00034839,0.67894,-0.0012669,0.00012349,-0.027957,0.0004328,0.47977,-0.33976,0.16119},
      {0.00027695,0.00032766,0.66977,-0.00076173,0.00013476,-0.038844,0.00041011,0.47378,-0.33503,0.15211},
      {0.00051212,0.0003737,0.65307,-0.00034257,0.00013901,-0.058095,0.00031244,0.4624,-0.32652,0.13605},
      {0.00070632,0.00062837,0.61622,-0.00020138,0.00012564,-0.099814,-4.68E-06,0.43649,-0.30783,0.10126},
      {0.00085855,0.00086958,0.57142,-7.77E-05,0.00013178,-0.15083,-0.00031427,0.40494,-0.28522,0.058758},
      {0.00095341,0.0010896,0.51749,1.03E-05,0.0001657,-0.21256,-0.00060023,0.3669,-0.25812,0.0073963},
      {0.0008417,0.0062013,0.40846,0.00016126,0.00021563,-0.33122,-0.0044336,0.29037,-0.20149,-0.091019},
      {0.00074936,0.011016,0.29127,0.00029023,0.00021164,-0.45929,-0.0080641,0.20818,-0.14101,-0.19723},
      {0.00064922,0.015506,0.17737,0.0004015,0.00019809,-0.58443,-0.011406,0.12815,-0.082243,-0.30097},
      {0.00082541,0.031092,0.10922,0.00049461,0.00012369,-0.64129,-0.022098,0.08228,-0.042086,-0.34791},
      {0.00096145,0.044052,0.050756,0.00055859,3.16E-05,-0.69067,-0.030979,0.042897,-0.0078231,-0.38867},
      {0.0010572,0.058478,0.0064182,0.00059287,-3.53E-05,-0.71552,-0.040937,0.017511,0.017286,-0.40916},
      {0.0011626,0.082656,-0.015004,0.00060658,3.55E-06,-0.67829,-0.057791,0.023095,0.025419,-0.37831},
      {0.0011857,0.099588,-0.034113,0.0005746,2.02E-05,-0.64845,-0.069599,0.029437,0.029412,-0.35354},
      {0.00098116,0.10412,-0.078779,0.00053165,0.00015375,-0.59759,-0.072833,0.057493,0.011737,-0.3115},
      {0.00057453,0.09481,-0.17339,0.00048498,0.00030848,-0.50015,-0.066455,0.12401,-0.04015,-0.23083},
      {0.00025628,0.080996,-0.27361,0.00032375,0.00017717,-0.40139,-0.056844,0.19487,-0.097153,-0.14866},
      {9.69E-05,0.065613,-0.37743,0.00034769,0.00084033,-0.29837,-0.046148,0.26821,-0.15677,-0.064132},
      {-5.20E-07,0.043201,-0.47765,0.00037193,0.0017365,-0.20769,-0.030533,0.33876,-0.21796,0.0098329},
      {-6.93E-05,0.024987,-0.574,0.00038115,0.0017752,-0.11808,-0.017849,0.4066,-0.27511,0.084133},
      {-9.86E-05,0.012724,-0.64529,0.0003353,0.0021696,-0.049905,-0.0093015,0.45681,-0.31672,0.14014},
      {-8.65E-05,0.0076716,-0.65809,0.00020071,0.003718,-0.03893,-0.0057292,0.46577,-0.32548,0.14702},
      {-6.98E-05,0.0042917,-0.67003,0.00010217,0.0039205,-0.029319,-0.0033118,0.47411,-0.333,0.1547},
      {-4.90E-05,0.0023381,-0.68145,3.58E-05,0.0031183,-0.020365,-0.0018792,0.48208,-0.33959,0.16327},
      {-3.62E-05,0.0014388,-0.6825,-1.42E-06,0.0059179,-0.015644,-0.0011789,0.48279,-0.34058,0.16317},
      {-2.75E-05,0.0010131,-0.68201,-2.21E-05,0.0082302,-0.012917,-0.00084144,0.48238,-0.34053,0.16211},
      {-1.84E-05,0.00065488,-0.684,-2.86E-05,0.008762,-0.010318,-0.00054813,0.48375,-0.3417,0.1635},
      {-0.00056512,0.0003291,0.69848,-0.0012889,9.74E-05,-0.0063174,0.00035012,0.49338,-0.34957,0.17926},
      {-0.00055698,0.00030582,0.69783,-0.0013632,0.0001017,-0.0069385,0.00037299,0.49289,-0.34931,0.17874},
      {-0.00054543,0.00027091,0.69682,-0.0014657,0.0001083,-0.0079204,0.00040771,0.49215,-0.3489,0.17791},
      {-0.00053148,0.00022466,0.69539,-0.0015828,0.00011743,-0.0093268,0.00045461,0.49113,-0.34831,0.17674},
      {-0.0004257,0.00019537,0.68997,-0.0013939,0.00012679,-0.015632,0.00046042,0.48753,-0.34559,0.17148},
      {-0.00025608,0.00017527,0.68087,-0.0010178,0.00013711,-0.026316,0.00043896,0.48151,-0.34097,0.16257},
      {-7.27E-05,0.00015226,0.66935,-0.00062596,0.00014968,-0.039764,0.00041573,0.47381,-0.33516,0.15137},
      {0.00011468,0.00012798,0.65501,-0.00025091,0.00016459,-0.056368,0.00039192,0.46416,-0.32799,0.13755},
      {0.00028406,0.000124,0.63376,-1.83E-05,0.00018009,-0.080048,0.00035451,0.44994,-0.31772,0.11784},
      {0.00037559,0.00033269,0.57894,-5.96E-06,0.0001993,-0.1421,8.66E-05,0.41159,-0.29045,0.066233},
      {0.0004549,0.00053166,0.51587,5.52E-06,0.00023315,-0.21393,-0.00017709,0.36726,-0.25897,0.0065014},
      {0.00052597,0.00071551,0.44462,1.78E-05,0.00028128,-0.2956,-0.00043274,0.31693,-0.22327,-0.061397},
      {0.00049434,0.0038863,0.3458,0.00010702,0.00028084,-0.40511,-0.0028239,0.24736,-0.17252,-0.15225},
      {0.00043653,0.0073302,0.24254,0.00020034,0.00024414,-0.51963,-0.0053812,0.17459,-0.11939,-0.24719},
      {0.0003786,0.010077,0.14252,0.00027059,0.00018409,-0.63175,-0.0074068,0.1039,-0.068086,-0.34011},
      {0.00047124,0.020462,0.085088,0.00032027,9.12E-05,-0.68367,-0.014549,0.064792,-0.035287,-0.38299},
      {0.00053807,0.029787,0.040801,0.00033681,-5.52E-06,-0.72193,-0.020949,0.034893,-0.0095202,-0.41454},
      {0.00055273,0.036754,0.0046751,0.00031351,-9.37E-05,-0.75354,-0.025732,0.010824,0.01096,-0.44058},
      {0.00058636,0.052986,-0.013894,0.00026625,-6.78E-05,-0.72358,-0.037055,0.017736,0.01424,-0.41569},
      {0.00054296,0.062378,-0.030251,0.00015481,-7.38E-05,-0.70118,-0.043607,0.02503,0.013864,-0.39706},
      {0.00042497,0.064923,-0.056911,2.31E-05,-9.63E-05,-0.67148,-0.045397,0.0417,0.003429,-0.37238},
      {0.00025749,0.061574,-0.16049,0.00012584,-2.08E-05,-0.55546,-0.043151,0.11491,-0.050143,-0.27623},
      {0.00010231,0.055526,-0.26821,0.00021154,3.91E-05,-0.43769,-0.038996,0.19115,-0.10716,-0.17859},
      {-3.13E-05,0.045687,-0.3779,0.00027147,0.00015566,-0.32196,-0.03218,0.2688,-0.16704,-0.082724},
      {-8.92E-05,0.028507,-0.47463,0.00027526,0.00053856,-0.2303,-0.020229,0.33682,-0.22379,-0.0072096},
      {-0.00011802,0.015883,-0.56366,0.00026629,0.00071673,-0.14254,-0.011454,0.39946,-0.27442,0.065366},
      {-0.00012167,0.007388,-0.6451,0.00024675,0.000728,-0.05893,-0.0055583,0.45681,-0.31923,0.13473},
      {-0.00010271,0.0041739,-0.65668,0.0001482,0.0013295,-0.048844,-0.003267,0.46489,-0.32649,0.14223},
      {-8.00E-05,0.0022731,-0.66736,7.87E-05,0.0010596,-0.039755,-0.0018815,0.47233,-0.33268,0.15015},
      {-5.73E-05,0.0017213,-0.6757,3.51E-05,0.00088727,-0.031559,-0.0014523,0.47809,-0.33703,0.1572},
      {-4.33E-05,0.0013767,-0.67782,9.87E-06,0.0025125,-0.026989,-0.0011723,0.47951,-0.33822,0.15865},
      {-3.38E-05,0.0010067,-0.67872,-1.08E-06,0.0037091,-0.024512,-0.00087353,0.48009,-0.33885,0.15899},
      {-0.00045497,0.0002342,0.69913,-0.00040491,0.00010116,-0.0066145,0.00024914,0.49468,-0.34978,0.17901},
      {-0.00047537,0.00022206,0.69822,-0.00044954,0.00010658,-0.0074593,0.0002806,0.49408,-0.34939,0.1783},
      {-0.00050966,0.0002036,0.69677,-0.00051731,0.00011511,-0.0087915,0.00033059,0.49313,-0.34877,0.17718},
      {-0.00056246,0.00017858,0.69469,-0.00060886,0.00012731,-0.010692,0.00040242,0.49179,-0.34788,0.17559},
      {-0.00063917,0.00014719,0.69187,-0.00072324,0.00014372,-0.013246,0.00049935,0.48999,-0.34669,0.17345},
      {-0.00073248,0.00011168,0.68767,-0.00084135,0.0001646,-0.017171,0.00061569,0.48733,-0.34487,0.17016},
      {-0.00059332,0.00010285,0.67199,-0.00066557,0.00018342,-0.034505,0.00058452,0.47693,-0.33737,0.15574},
      {-0.00041554,9.24E-05,0.6525,-0.00047242,0.00020546,-0.055974,0.0005284,0.46405,-0.3281,0.13787},
      {-0.00019753,8.04E-05,0.62869,-0.00026793,0.00023049,-0.082121,0.00044281,0.44835,-0.31685,0.11613},
      {5.86E-05,6.72E-05,0.6,-5.96E-05,0.000258,-0.11351,0.00032578,0.42947,-0.30337,0.090036},
      {0.00016363,0.00020419,0.5389,-1.81E-05,0.00029962,-0.18349,0.00010832,0.38644,-0.27285,0.031863},
      {0.00023236,0.0003537,0.4654,-3.82E-06,0.00034832,-0.26842,-0.00011482,0.33421,-0.23583,-0.038707},
      {0.00028846,0.00048413,0.38369,1.04E-05,0.00040146,-0.36332,-0.00032081,0.2759,-0.19455,-0.11755},
      {0.00027813,0.0022461,0.29214,6.05E-05,0.00037528,-0.46728,-0.0016528,0.2109,-0.14774,-0.20376},
      {0.00023528,0.0044866,0.20031,0.0001133,0.0002906,-0.57093,-0.0032879,0.14581,-0.10064,-0.28962},
      {0.00019137,0.0060946,0.11231,0.00013985,0.00019442,-0.67142,-0.0044482,0.083209,-0.055616,-0.37282},
      {0.00021087,0.011981,0.060454,0.0001387,9.95E-05,-0.72365,-0.0085042,0.047218,-0.027241,-0.41595},
      {0.00022059,0.017951,0.028623,9.95E-05,1.80E-05,-0.7524,-0.012608,0.025621,-0.0089792,-0.43961},
      {0.00018532,0.021436,0.0037026,1.42E-05,-4.45E-05,-0.77679,-0.014999,0.0085463,0.0048676,-0.45965},
      {0.00021634,0.031866,-0.012815,-5.82E-06,-7.34E-05,-0.75685,-0.022291,0.013318,0.0067781,-0.44311},
      {0.00024769,0.041669,-0.028529,-3.73E-07,-0.00010098,-0.72989,-0.029158,0.022741,0.0050803,-0.42078},
      {0.00025278,0.048425,-0.044551,3.85E-06,-0.00012919,-0.70548,-0.033901,0.03279,0.0014071,-0.40056},
      {0.00011291,0.042347,-0.1486,7.72E-05,-6.76E-05,-0.59215,-0.029717,0.10632,-0.053693,-0.30661},
      {-1.81E-05,0.034747,-0.26307,0.00013892,-4.97E-06,-0.46836,-0.024471,0.18736,-0.11483,-0.20397},
      {-0.00012914,0.026812,-0.37869,0.0001816,4.99E-05,-0.34364,-0.018991,0.26923,-0.17668,-0.10054},
      {-0.00015825,0.0158,-0.46907,0.00017928,0.00023438,-0.25233,-0.011348,0.33287,-0.22721,-0.025035},
      {-0.0001584,0.0079044,-0.5499,0.00016436,0.00030115,-0.16865,-0.0058767,0.38977,-0.27141,0.044309},
      {-0.00014022,0.0032779,-0.62387,0.00014233,0.00026138,-0.089162,-0.0026858,0.44191,-0.31058,0.11032},
      {-0.00011628,0.0020786,-0.64819,9.37E-05,0.00038016,-0.062767,-0.0018459,0.45895,-0.3232,0.13205},
      {-9.36E-05,0.0017825,-0.65509,5.23E-05,0.00048286,-0.055454,-0.0016116,0.46366,-0.32668,0.13796},
      {-7.02E-05,0.0015782,-0.66281,2.52E-05,0.00047355,-0.047232,-0.0014227,0.46899,-0.33058,0.14479},
      {-5.11E-05,0.0013578,-0.66867,1.08E-05,0.00079541,-0.04048,-0.001215,0.47305,-0.3336,0.14993},
      {-0.00052091,0.00023592,0.70076,-0.00018632,0.00011542,-0.004604,0.00023916,0.49622,-0.35066,0.18065},
      {-0.00055829,0.00022554,0.69962,-0.00022321,0.00012246,-0.0056024,0.00027871,0.49552,-0.35018,0.17982},
      {-0.00061637,0.00020979,0.69783,-0.0002789,0.00013346,-0.0071648,0.00033961,0.49443,-0.34944,0.1785},
      {-0.00069734,0.00018853,0.69531,-0.00035341,0.00014897,-0.0093705,0.00042343,0.4929,-0.34839,0.17665},
      {-0.00080253,0.00016198,0.69194,-0.00044523,0.00016951,-0.012297,0.00053067,0.49089,-0.34701,0.1742},
      {-0.00093205,0.00013072,0.68764,-0.00055126,0.00019558,-0.016021,0.00066048,0.48834,-0.34525,0.17107},
      {-0.0010842,9.57E-05,0.6823,-0.00066674,0.00022772,-0.020624,0.00081026,0.48522,-0.34309,0.16721},
      {-0.00097794,7.53E-05,0.66521,-0.00059947,0.00025451,-0.038842,0.00078209,0.47416,-0.33523,0.15205},
      {-0.00069591,6.37E-05,0.63819,-0.0004219,0.00027719,-0.068412,0.00063046,0.4564,-0.3226,0.12748},
      {-0.00039524,5.19E-05,0.6062,-0.00024509,0.00030085,-0.10328,0.00046251,0.43541,-0.3077,0.098512},
      {-8.93E-05,4.07E-05,0.56878,-7.82E-05,0.00032446,-0.14393,0.00028531,0.41089,-0.29032,0.064759},
      {4.62E-05,0.00011651,0.50336,-1.93E-05,0.00036457,-0.21908,0.00010292,0.36487,-0.25774,0.0023399},
      {9.51E-05,0.00021858,0.42031,-5.54E-06,0.00041417,-0.31617,-6.52E-05,0.30529,-0.21558,-0.078283},
      {0.00012698,0.00030112,0.32954,6.34E-06,0.00046428,-0.42279,-0.00020605,0.23991,-0.16934,-0.16679},
      {0.00012025,0.0011084,0.23968,2.47E-05,0.00043798,-0.5272,-0.00082015,0.17543,-0.12337,-0.25335},
      {8.82E-05,0.002308,0.15941,3.32E-05,0.00032891,-0.61961,-0.001672,0.11812,-0.082275,-0.32981},
      {5.40E-05,0.0029392,0.083477,1.25E-05,0.00021982,-0.70818,-0.0021053,0.063665,-0.043462,-0.40304},
      {5.77E-05,0.0061808,0.03995,-3.71E-07,0.00012285,-0.75501,-0.0043605,0.032806,-0.020006,-0.44172},
      {7.79E-05,0.011245,0.020867,-4.87E-06,4.07E-05,-0.77008,-0.00789,0.020022,-0.0084126,-0.45414},
      {8.83E-05,0.015221,0.0039352,-9.35E-06,-3.90E-05,-0.78352,-0.010666,0.0089997,0.0013884,-0.46522},
      {0.00010294,0.021318,-0.012802,-8.85E-06,-8.36E-05,-0.7711,-0.014937,0.012203,0.0022186,-0.45492},
      {0.00010285,0.026699,-0.031673,-6.24E-06,-0.0001045,-0.74474,-0.018715,0.024406,-0.0036636,-0.43309},
      {7.90E-05,0.02907,-0.052479,-5.01E-06,-0.00011993,-0.71929,-0.020394,0.038215,-0.012197,-0.412},
      {-1.03E-05,0.024702,-0.1386,3.38E-05,-7.90E-05,-0.62498,-0.017395,0.098934,-0.057313,-0.3338},
      {-0.00010915,0.017988,-0.25444,7.56E-05,-1.98E-05,-0.49858,-0.012772,0.18096,-0.11865,-0.22899},
      {-0.00019262,0.011396,-0.36956,0.00010009,3.19E-05,-0.37289,-0.0082382,0.26248,-0.17954,-0.12476},
      {-0.00021261,0.0051019,-0.46051,9.58E-05,9.33E-05,-0.27533,-0.0038984,0.32668,-0.22806,-0.043894},
      {-0.00018524,0.0027238,-0.53244,8.45E-05,0.00017538,-0.19535,-0.0023099,0.37734,-0.26506,0.022356},
      {-0.00015703,0.0020565,-0.59603,7.38E-05,0.00025164,-0.12289,-0.0019263,0.42214,-0.29705,0.082365},
      {-0.00013324,0.0017575,-0.63039,5.18E-05,0.00030886,-0.083801,-0.0017476,0.44631,-0.31427,0.11471},
      {-0.00010769,0.0015824,-0.63706,2.85E-05,0.00034061,-0.076683,-0.0015813,0.45088,-0.31762,0.12057},
      {-8.07E-05,0.0014829,-0.6444,1.60E-05,0.0003605,-0.068687,-0.0014479,0.45596,-0.32132,0.12717},
      {-0.00028826,0.00020568,0.70568,-6.42E-06,0.00010511,-0.00019838,6.41E-05,0.4994,-0.35289,0.18432},
      {-0.00032643,0.00019734,0.70438,-3.35E-05,0.00011344,-0.0013101,0.00010084,0.49865,-0.35236,0.18339},
      {-0.00038422,0.00018473,0.70234,-7.40E-05,0.00012639,-0.0030431,0.00015635,0.49748,-0.35155,0.18193},
      {-0.0004618,0.00016779,0.69948,-0.00012739,0.00014454,-0.0054761,0.00023078,0.49584,-0.35041,0.17989},
      {-0.00055756,0.0001468,0.6957,-0.00019166,0.00016838,-0.0086813,0.00032263,0.4937,-0.34891,0.1772},
      {-0.00066781,0.00012235,0.69092,-0.00026335,0.00019838,-0.012727,0.00042853,0.49101,-0.34703,0.1738},
      {-0.00078632,9.54E-05,0.68505,-0.00033745,0.00023495,-0.017681,0.00054294,0.48776,-0.34475,0.16964},
      {-0.00090381,6.71E-05,0.67801,-0.00040733,0.00027853,-0.023608,0.00065785,0.4839,-0.34204,0.16466},
      {-0.00088342,4.50E-05,0.66238,-0.00040297,0.00031816,-0.039251,0.00067475,0.47429,-0.33524,0.15163},
      {-0.00059399,3.64E-05,0.62735,-0.00026655,0.00033601,-0.077277,0.00049907,0.45134,-0.319,0.12006},
      {-0.00032071,2.95E-05,0.58683,-0.00014464,0.00035231,-0.1211,0.00033082,0.42481,-0.30024,0.083686},
      {-8.58E-05,2.53E-05,0.5404,-4.75E-05,0.00036558,-0.17113,0.00018418,0.39443,-0.27877,0.042178},
      {2.25E-05,6.24E-05,0.47112,-7.39E-06,0.00039367,-0.25022,6.36E-05,0.34606,-0.24458,-0.023457},
      {4.30E-05,0.00012168,0.37979,1.92E-06,0.00043672,-0.35812,-3.47E-05,0.27994,-0.19783,-0.113},
      {4.29E-05,0.00016641,0.28415,6.90E-06,0.00047634,-0.47179,-0.00010212,0.2103,-0.14859,-0.20731},
      {3.60E-05,0.00048776,0.20064,7.54E-06,0.00046065,-0.57096,-0.00035109,0.14936,-0.10534,-0.28952},
      {3.09E-05,0.0012687,0.13958,4.83E-06,0.00034153,-0.64244,-0.00090676,0.10513,-0.07366,-0.34864},
      {2.49E-05,0.0019043,0.078154,1.72E-06,0.00021595,-0.71462,-0.0013601,0.06058,-0.041831,-0.40833},
      {2.51E-05,0.0037048,0.032507,-2.28E-06,0.00010381,-0.76587,-0.0026232,0.027989,-0.017872,-0.4507},
      {3.33E-05,0.007153,0.016749,-7.22E-06,2.58E-05,-0.77782,-0.005033,0.018246,-0.0092385,-0.46055},
      {3.34E-05,0.009588,0.0025667,-1.20E-05,-4.31E-05,-0.78847,-0.006738,0.010015,-0.0021863,-0.46933},
      {2.66E-05,0.012247,-0.013627,-1.39E-05,-8.30E-05,-0.78232,-0.0086077,0.01186,-0.0021313,-0.46421},
      {5.40E-06,0.014504,-0.035654,-1.31E-05,-9.28E-05,-0.75547,-0.010207,0.026606,-0.011381,-0.44196},
      {-3.12E-05,0.0144,-0.059704,-1.36E-05,-9.81E-05,-0.72871,-0.010162,0.042985,-0.022972,-0.41978},
      {-9.37E-05,0.010821,-0.12695,1.34E-06,-7.13E-05,-0.65539,-0.0077111,0.090321,-0.058195,-0.35898},
      {-0.00016617,0.0053683,-0.24205,2.44E-05,-1.60E-05,-0.5284,-0.0039768,0.17182,-0.11849,-0.25368},
      {-0.00021129,0.0032736,-0.35502,3.91E-05,0.00013909,-0.39969,-0.0026262,0.25184,-0.176,-0.14711},
      {-0.00022213,0.0021733,-0.44755,4.21E-05,0.00025666,-0.29383,-0.0019751,0.31726,-0.22272,-0.059442},
      {-0.00019272,0.0016542,-0.51032,3.51E-05,0.000346,-0.2221,-0.0016943,0.36149,-0.25423,-6.00E-05},
      {-0.00016324,0.0015444,-0.56258,3.40E-05,0.00039316,-0.16202,-0.0016857,0.39834,-0.28034,0.049715},
      {-0.00014024,0.0015693,-0.60175,2.99E-05,0.00037181,-0.11698,-0.0017464,0.42596,-0.29985,0.087104},
      {-0.00011298,0.0014766,-0.60941,1.81E-05,0.00039858,-0.10858,-0.0016192,0.43126,-0.30371,0.094032},
      {-0.00013497,0.00011811,0.70621,0,9.71E-05,5.60E-05,1.42E-05,0.49975,-0.35325,0.18454},
      {-0.00013896,0.00011547,0.70617,0,0.00010165,5.87E-05,1.90E-05,0.49975,-0.35324,0.18454},
      {-0.00014448,0.00011138,0.70612,0,0.00010876,6.28E-05,2.60E-05,0.49974,-0.35324,0.18453},
      {-0.00015081,0.00010572,0.70604,0,0.00011864,6.85E-05,3.46E-05,0.49973,-0.35323,0.18452},
      {-0.00019873,9.22E-05,0.70263,-2.71E-05,0.00014281,-0.0027613,8.29E-05,0.4979,-0.35195,0.18214},
      {-0.00025639,7.51E-05,0.69749,-6.03E-05,0.00017595,-0.0070445,0.00014239,0.49516,-0.35002,0.17854},
      {-0.00030531,5.69E-05,0.69123,-8.84E-05,0.00021614,-0.012259,0.00019706,0.49186,-0.34769,0.17416},
      {-0.00033293,3.86E-05,0.68377,-0.00010468,0.00026371,-0.01846,0.00023683,0.48797,-0.34494,0.16895},
      {-0.00032301,2.19E-05,0.67506,-0.00010107,0.00031895,-0.025695,0.00024878,0.4835,-0.34178,0.16287},
      {-0.00024835,8.99E-06,0.66324,-6.61E-05,0.00037865,-0.0361,0.00021211,0.47717,-0.33731,0.15416},
      {-6.43E-05,8.08E-06,0.61987,-8.54E-07,0.00038547,-0.082798,9.56E-05,0.44877,-0.31725,0.11542},
      {-2.54E-05,1.29E-05,0.57364,-5.39E-07,0.00039259,-0.13304,8.16E-05,0.41799,-0.29549,0.073746},
      {1.47E-05,1.74E-05,0.52516,-1.36E-07,0.00039219,-0.18585,6.91E-05,0.38564,-0.27263,0.029954},
      {3.98E-05,3.71E-05,0.46242,1.11E-06,0.00039799,-0.25773,4.04E-05,0.3416,-0.24148,-0.029662},
      {3.94E-05,7.96E-05,0.37582,3.53E-06,0.00043469,-0.36157,-1.55E-05,0.27794,-0.19646,-0.11583},
      {3.57E-05,0.00011635,0.28531,5.60E-06,0.00046718,-0.46973,-6.62E-05,0.21165,-0.14958,-0.20556},
      {2.91E-05,0.00025524,0.19797,6.29E-06,0.00046314,-0.57354,-0.00018401,0.14799,-0.10449,-0.29164},
      {2.18E-05,0.00078366,0.13724,2.66E-06,0.00032591,-0.64501,-0.00056252,0.10396,-0.073088,-0.35073},
      {1.37E-05,0.0011829,0.076438,-1.30E-06,0.00019223,-0.71666,-0.00085024,0.059905,-0.04173,-0.40998},
      {7.22E-06,0.0018958,0.0249,-5.69E-06,7.71E-05,-0.77625,-0.0013558,0.022995,-0.015267,-0.45925},
      {6.03E-06,0.0039771,0.011765,-1.05E-05,1.36E-05,-0.78555,-0.0028149,0.015843,-0.0091543,-0.46691},
      {-1.24E-07,0.0051954,0.0001002,-1.52E-05,-3.72E-05,-0.79339,-0.0036733,0.010191,-0.0045375,-0.47337},
      {-1.37E-05,0.0057828,-0.013365,-1.86E-05,-6.65E-05,-0.79184,-0.0040964,0.010712,-0.0045951,-0.47206},
      {-4.67E-05,0.0056314,-0.038682,-1.95E-05,-6.68E-05,-0.76356,-0.0040191,0.028052,-0.016886,-0.44862},
      {-8.31E-05,0.0043252,-0.0666,-2.15E-05,-2.21E-05,-0.73321,-0.0031424,0.047438,-0.031202,-0.42352},
      {-0.00011174,0.0037926,-0.11842,-1.79E-05,0.00024919,-0.67345,-0.0028326,0.084008,-0.057255,-0.37436},
      {-0.00015241,0.0025003,-0.231,-3.00E-06,0.00046671,-0.54413,-0.0020494,0.16376,-0.11417,-0.26737},
      {-0.000184,0.0016595,-0.33449,8.52E-06,0.00061127,-0.425,-0.0015987,0.23702,-0.16627,-0.16874},
      {-0.00020183,0.0011001,-0.42281,1.66E-05,0.00066414,-0.32335,-0.0013437,0.29949,-0.21061,-0.084484},
      {-0.00017298,0.0010495,-0.47499,1.73E-05,0.00073494,-0.26323,-0.0013716,0.33629,-0.23665,-0.034712},
      {-0.00015272,0.001157,-0.52206,1.71E-05,0.00069607,-0.20893,-0.0015107,0.36952,-0.26008,0.010392},
      {-0.00014087,0.0014077,-0.56405,1.61E-05,0.00051472,-0.16049,-0.0017529,0.39918,-0.28089,0.050822},
      {-8.30E-06,8.86E-06,0.70637,0,0.00024626,0.00014218,1.04E-06,0.49981,-0.35341,0.1844},
      {-8.37E-06,8.52E-06,0.70631,0,0.00027718,0.00016003,1.43E-06,0.49979,-0.3534,0.18437},
      {-9.02E-06,8.64E-06,0.70621,0,0.00033066,0.0001909,1.98E-06,0.49975,-0.35337,0.18432},
      {-9.87E-06,8.80E-06,0.70606,0,0.00041545,0.00023986,2.72E-06,0.49969,-0.35332,0.18424},
      {-1.09E-05,8.99E-06,0.70584,0,0.00054528,0.00031482,3.65E-06,0.4996,-0.35326,0.18412},
      {-1.21E-05,9.20E-06,0.70554,0,0.0007402,0.00042736,4.75E-06,0.49946,-0.35316,0.18393},
      {-2.07E-05,8.01E-06,0.69975,-1.31E-07,0.00085146,-0.0044283,1.72E-05,0.49636,-0.35096,0.17974},
      {-3.06E-05,6.49E-06,0.69209,-2.93E-07,0.00092085,-0.011088,3.24E-05,0.49219,-0.348,0.17412},
      {-4.02E-05,4.87E-06,0.68321,-4.61E-07,0.00093564,-0.019054,4.84E-05,0.48728,-0.34452,0.1675},
      {-4.88E-05,3.21E-06,0.67307,-6.30E-07,0.00085164,-0.028506,6.46E-05,0.48157,-0.34047,0.15978},
      {-5.60E-05,1.55E-06,0.6616,-7.93E-07,0.00060813,-0.039671,8.04E-05,0.47497,-0.3358,0.15087},
      {-2.92E-05,4.57E-06,0.62323,-4.70E-07,0.00053043,-0.081437,7.54E-05,0.44947,-0.31777,0.11635},
      {3.16E-06,8.30E-06,0.57716,-2.15E-08,0.00049306,-0.13191,6.73E-05,0.4186,-0.29594,0.074544},
      {3.37E-05,1.17E-05,0.52847,4.48E-07,0.00043213,-0.18542,6.05E-05,0.38589,-0.27281,0.03026},
      {5.39E-05,2.14E-05,0.46931,1.20E-06,0.00036979,-0.25242,4.55E-05,0.34492,-0.24384,-0.025202},
      {4.49E-05,5.11E-05,0.37927,2.68E-06,0.00038991,-0.35944,1.62E-06,0.27935,-0.19747,-0.11397},
      {3.42E-05,7.46E-05,0.28585,3.64E-06,0.00040289,-0.47006,-3.61E-05,0.21159,-0.14955,-0.20572},
      {2.22E-05,0.00010588,0.19116,3.80E-06,0.00040091,-0.58171,-7.65E-05,0.1432,-0.10119,-0.29829},
      {1.38E-05,0.00041877,0.13168,-5.61E-07,0.00026572,-0.6518,-0.00030409,0.10017,-0.070602,-0.35624},
      {5.70E-06,0.00061882,0.072986,-5.15E-06,0.000145,-0.72096,-0.00045231,0.057778,-0.040521,-0.41344},
      {-1.40E-06,0.00072729,0.016657,-9.93E-06,4.60E-05,-0.78715,-0.00053598,0.01725,-0.011805,-0.4682},
      {-7.57E-06,0.0016606,0.0059652,-1.46E-05,2.12E-06,-0.7936,-0.0011962,0.012651,-0.0080752,-0.4735},
      {-1.59E-05,0.0018693,-0.0033507,-1.89E-05,-2.55E-05,-0.79844,-0.0013517,0.0095419,-0.0057643,-0.47749},
      {-2.17E-05,0.0021708,-0.012201,-2.27E-05,-3.50E-05,-0.79864,-0.0015779,0.0091727,-0.0053384,-0.47766},
      {-4.73E-05,0.0022378,-0.042674,-2.42E-05,0.00013514,-0.76316,-0.0016689,0.030559,-0.020368,-0.4485},
      {-6.75E-05,0.0021603,-0.076851,-2.60E-05,0.0005421,-0.72313,-0.0016703,0.054595,-0.037341,-0.4159},
      {-8.35E-05,0.0019451,-0.11476,-2.66E-05,0.0012405,-0.67842,-0.0015862,0.081289,-0.05626,-0.37983},
      {-0.00011385,0.0012773,-0.2154,-1.44E-05,0.0014404,-0.56228,-0.0012518,0.15254,-0.10685,-0.28376},
      {-0.00014046,0.000762,-0.30701,-4.46E-06,0.0015089,-0.45667,-0.0010351,0.21736,-0.15282,-0.19626},
      {-0.00016323,0.00036679,-0.38948,3.45E-06,0.0014144,-0.36181,-0.00091099,0.27569,-0.19412,-0.11743},
      {-0.00014854,0.00048387,-0.43929,4.96E-06,0.0013668,-0.30428,-0.0010624,0.31087,-0.21892,-0.069646},
      {-0.00013757,0.00077107,-0.4816,5.32E-06,0.0011883,-0.25542,-0.0013276,0.34077,-0.23989,-0.028858},
      {-2.77E-06,5.01E-06,0.70577,0,0.0010509,0.00060671,-1.78E-07,0.49925,-0.35302,0.18363},
      {-2.99E-06,5.06E-06,0.70562,0,0.0011765,0.00067926,9.00E-08,0.49916,-0.35295,0.18351},
      {-3.33E-06,5.13E-06,0.70537,0,0.0013799,0.00079671,4.98E-07,0.49902,-0.35285,0.18332},
      {-3.77E-06,5.22E-06,0.70501,0,0.0016812,0.00097063,1.05E-06,0.4988,-0.3527,0.18303},
      {-4.29E-06,5.33E-06,0.70451,0,0.0021061,0.001216,1.74E-06,0.4985,-0.35249,0.18262},
      {-4.86E-06,5.44E-06,0.70384,0,0.0026885,0.0015522,2.56E-06,0.49809,-0.35219,0.18206},
      {-5.44E-06,5.56E-06,0.70295,0,0.003472,0.0020046,3.49E-06,0.49753,-0.3518,0.18131},
      {-7.19E-06,5.31E-06,0.69983,-3.31E-08,0.004133,0.00012028,7.43E-06,0.49567,-0.35048,0.1788},
      {-1.18E-05,4.14E-06,0.69068,-1.54E-07,0.0038186,-0.0091777,1.93E-05,0.4903,-0.34668,0.17154},
      {-1.56E-05,2.94E-06,0.68019,-2.74E-07,0.0032996,-0.020284,3.12E-05,0.48404,-0.34224,0.16308},
      {-1.83E-05,1.76E-06,0.66827,-3.89E-07,0.0024977,-0.033463,4.28E-05,0.47681,-0.33712,0.1533},
      {-1.95E-05,6.31E-07,0.65485,-4.91E-07,0.0013164,-0.049027,5.35E-05,0.46852,-0.33126,0.1421},
      {-3.70E-06,2.08E-06,0.62117,-2.44E-07,0.00071698,-0.086756,5.41E-05,0.44605,-0.31536,0.11167},
      {1.95E-05,4.68E-06,0.57418,1.84E-07,0.00060706,-0.13892,5.00E-05,0.41422,-0.29286,0.06858},
      {3.99E-05,6.82E-06,0.52436,5.75E-07,0.00046103,-0.1945,4.67E-05,0.38033,-0.26889,0.0227},
      {5.43E-05,9.91E-06,0.46882,9.25E-07,0.00028869,-0.25727,4.15E-05,0.34208,-0.24184,-0.029097},
      {4.07E-05,2.70E-05,0.37638,1.20E-06,0.00028837,-0.36613,1.05E-05,0.27541,-0.1947,-0.11936},
      {2.70E-05,3.74E-05,0.28109,8.15E-07,0.00027805,-0.47787,-1.34E-05,0.20699,-0.14633,-0.212},
      {1.37E-05,4.04E-05,0.18349,-3.73E-07,0.00025573,-0.59179,-2.91E-05,0.13726,-0.097032,-0.30643},
      {5.70E-06,0.0001541,0.1223,-4.91E-06,0.00015243,-0.66362,-0.00011748,0.093285,-0.065874,-0.36585},
      {-2.42E-07,0.00018962,0.067088,-9.90E-06,6.44E-05,-0.72844,-0.00015045,0.053643,-0.037821,-0.41948},
      {-3.07E-06,0.00023651,0.015464,-1.46E-05,2.14E-05,-0.78886,-0.00019297,0.016626,-0.011618,-0.46953},
      {-7.56E-06,0.00064391,0.0015335,-1.98E-05,3.38E-06,-0.79812,-0.00049199,0.01064,-0.0071705,-0.47721},
      {-1.14E-05,0.00096076,-0.0066165,-2.47E-05,-2.97E-06,-0.79751,-0.00073125,0.010753,-0.0070786,-0.4767},
      {-1.42E-05,0.0011219,-0.015242,-2.92E-05,5.66E-07,-0.79539,-0.00086516,0.01189,-0.0077867,-0.47496},
      {-3.04E-05,0.0010916,-0.046198,-3.08E-05,0.00045443,-0.76011,-0.00089697,0.032945,-0.022635,-0.44636},
      {-4.55E-05,0.00094783,-0.083564,-3.10E-05,0.0012994,-0.71568,-0.00086342,0.05926,-0.04125,-0.41074},
      {-5.63E-05,0.00072249,-0.12296,-3.02E-05,0.0025383,-0.6683,-0.00078177,0.087027,-0.060931,-0.37324},
      {-7.85E-05,0.00036787,-0.20106,-2.18E-05,0.0029182,-0.57763,-0.00066161,0.14227,-0.10006,-0.29857},
      {-0.00010114,6.48E-05,-0.28155,-1.32E-05,0.0028438,-0.48491,-0.00059587,0.1992,-0.14034,-0.22155},
      {-0.00012015,-0.00018468,-0.35355,-5.89E-06,0.0025642,-0.40232,-0.00057248,0.25011,-0.17633,-0.15265},
      {-0.00012042,-2.75E-05,-0.4034,-2.76E-06,0.0022812,-0.34497,-0.00077543,0.28535,-0.20111,-0.10468},
      {-4.56E-07,2.61E-06,0.70587,0,0.0011273,0.00065083,-8.27E-07,0.4992,-0.35299,0.18356},
      {-5.42E-07,2.64E-06,0.70559,0,0.0013848,0.0007995,-6.33E-07,0.49902,-0.35286,0.18331},
      {-6.66E-07,2.67E-06,0.70515,0,0.001795,0.0010363,-3.39E-07,0.49873,-0.35265,0.18292},
      {-8.20E-07,2.72E-06,0.7045,0,0.0023889,0.0013793,5.91E-08,0.49831,-0.35235,0.18235},
      {-9.91E-07,2.77E-06,0.70363,0,0.0032035,0.0018496,5.57E-07,0.49773,-0.35195,0.18157},
      {-1.16E-06,2.82E-06,0.70247,0,0.0042839,0.0024733,1.15E-06,0.49697,-0.3514,0.18054},
      {-1.29E-06,2.86E-06,0.70098,0,0.0056854,0.0032825,1.81E-06,0.49597,-0.3507,0.17919},
      {-1.36E-06,2.89E-06,0.69909,0,0.0074758,0.0043162,2.52E-06,0.49471,-0.34981,0.17748},
      {-1.34E-06,2.89E-06,0.69672,0,0.0097372,0.0056218,3.27E-06,0.49311,-0.34867,0.17531},
      {-1.71E-06,2.21E-06,0.687,-6.58E-08,0.0091594,-0.005369,1.04E-05,0.48698,-0.34434,0.16703},
      {-1.41E-06,1.43E-06,0.67454,-1.38E-07,0.0076031,-0.020987,1.83E-05,0.47906,-0.33873,0.15632},
      {-1.41E-07,7.13E-07,0.66048,-1.99E-07,0.0055343,-0.039368,2.53E-05,0.46999,-0.33232,0.14405},
      {2.19E-06,8.98E-08,0.64472,-2.45E-07,0.0028267,-0.060895,3.11E-05,0.45968,-0.32502,0.13009},
      {1.09E-05,5.95E-07,0.61421,-1.14E-07,0.00095108,-0.097907,3.27E-05,0.439,-0.31039,0.10209},
      {2.42E-05,2.01E-06,0.56545,1.57E-07,0.00074539,-0.15301,3.08E-05,0.40547,-0.28668,0.056693},
      {3.38E-05,2.87E-06,0.51359,3.29E-07,0.00049061,-0.21202,2.90E-05,0.3696,-0.26132,0.0081308},
      {3.88E-05,3.08E-06,0.45864,3.63E-07,0.0001784,-0.27506,2.71E-05,0.33134,-0.23427,-0.043685},
      {2.55E-05,7.12E-06,0.36697,-7.45E-07,0.0001339,-0.38186,1.11E-05,0.26599,-0.18807,-0.13217},
      {1.47E-05,7.13E-06,0.2707,-2.66E-06,0.00011053,-0.49338,1.24E-06,0.19773,-0.1398,-0.22461},
      {7.36E-06,8.98E-06,0.1751,-5.15E-06,0.00011075,-0.60387,-7.52E-06,0.13006,-0.091961,-0.31622},
      {3.38E-06,5.17E-05,0.11359,-1.01E-05,8.00E-05,-0.67531,-4.71E-05,0.086291,-0.060985,-0.37543},
      {9.31E-07,9.18E-05,0.065084,-1.64E-05,4.59E-05,-0.73148,-8.70E-05,0.05187,-0.036623,-0.42196},
      {-1.13E-06,0.00011345,0.019188,-2.36E-05,1.94E-05,-0.78418,-0.00011545,0.019583,-0.013778,-0.46563},
      {-3.98E-06,0.0002727,-0.00054163,-2.93E-05,1.29E-05,-0.79898,-0.00024507,0.010372,-0.0071734,-0.4779},
      {-6.51E-06,0.00040314,-0.0092672,-3.34E-05,2.13E-05,-0.79615,-0.00035932,0.011964,-0.0082178,-0.47557},
      {-8.04E-06,0.0004296,-0.018324,-3.66E-05,4.00E-05,-0.79199,-0.0004046,0.014431,-0.00993,-0.47216},
      {-1.69E-05,0.00034371,-0.046278,-3.72E-05,0.00072895,-0.76063,-0.00040044,0.032894,-0.022979,-0.44714},
      {-2.71E-05,0.00018499,-0.085853,-3.57E-05,0.0021333,-0.71266,-0.00036664,0.060797,-0.042722,-0.40939},
      {-3.34E-05,-9.31E-06,-0.12667,-3.30E-05,0.0040198,-0.66245,-0.00031592,0.089601,-0.063118,-0.37045},
      {-4.71E-05,-0.00020473,-0.1879,-2.64E-05,0.0049305,-0.59023,-0.00029952,0.13288,-0.093718,-0.31187},
      {-6.65E-05,-0.00035353,-0.25752,-1.84E-05,0.0047348,-0.51011,-0.00033767,0.18212,-0.12848,-0.24514},
      {-8.41E-05,-0.00041682,-0.31964,-1.07E-05,0.0045997,-0.43843,-0.00042604,0.22606,-0.15946,-0.18551},
      {0,1.06E-06,0.70709,0,1.29E-05,7.47E-06,-7.52E-07,0.49999,-0.35355,0.18462},
      {0,1.08E-06,0.70709,0,1.34E-05,7.71E-06,-7.64E-07,0.49999,-0.35355,0.18462},
      {5.53E-09,1.10E-06,0.70677,0,0.00031817,0.0001837,-6.81E-07,0.49977,-0.35339,0.18433},
      {2.95E-08,1.11E-06,0.70579,0,0.0012627,0.00072905,-4.08E-07,0.49911,-0.35292,0.18343},
      {7.63E-08,1.13E-06,0.70447,0,0.0025394,0.0014661,-6.73E-08,0.4982,-0.35228,0.18221},
      {1.58E-07,1.13E-06,0.70274,0,0.0042031,0.0024266,3.33E-07,0.49703,-0.35145,0.18061},
      {2.89E-07,1.13E-06,0.70056,0,0.0063188,0.0036481,7.79E-07,0.49553,-0.35039,0.17859},
      {4.84E-07,1.12E-06,0.69784,0,0.0089632,0.0051749,1.26E-06,0.49366,-0.34907,0.17606},
      {7.59E-07,1.08E-06,0.69449,0,0.012227,0.0070592,1.74E-06,0.49135,-0.34744,0.17293},
      {1.12E-06,1.02E-06,0.69041,0,0.016216,0.009362,2.21E-06,0.48853,-0.34544,0.16911},
      {2.38E-06,7.65E-07,0.68138,-1.68E-08,0.017272,0.0013022,4.70E-06,0.48247,-0.34115,0.16091},
      {4.86E-06,3.94E-07,0.66661,-4.27E-08,0.014151,-0.020249,8.65E-06,0.47258,-0.33416,0.14752},
      {7.87E-06,1.16E-07,0.65001,-5.41E-08,0.010259,-0.045329,1.15E-05,0.46135,-0.32621,0.13232},
      {1.23E-05,-3.28E-08,0.63102,-4.64E-08,0.0055715,-0.074551,1.36E-05,0.44842,-0.31707,0.11482},
      {1.72E-05,8.55E-08,0.60181,-1.13E-08,0.0015167,-0.11441,1.37E-05,0.42832,-0.30285,0.087595},
      {2.18E-05,3.74E-07,0.54889,-1.64E-08,0.0011936,-0.175,1.50E-05,0.39155,-0.27686,0.037822},
      {2.66E-05,6.25E-07,0.49187,-5.39E-08,0.00073441,-0.24071,1.81E-05,0.3518,-0.24874,-0.016003},
      {3.13E-05,8.26E-07,0.4316,-1.27E-07,0.00018653,-0.31051,2.12E-05,0.30963,-0.21893,-0.073094},
      {2.55E-05,2.09E-06,0.34559,-2.32E-06,6.80E-05,-0.40986,1.41E-05,0.24892,-0.176,-0.1553},
      {1.69E-05,2.77E-06,0.25488,-5.88E-06,6.78E-05,-0.51445,4.54E-06,0.18487,-0.13071,-0.24202},
      {8.36E-06,2.29E-06,0.16647,-1.05E-05,6.59E-05,-0.61629,-4.95E-06,0.1225,-0.08662,-0.32645},
      {3.66E-06,1.59E-05,0.1047,-1.72E-05,4.97E-05,-0.68725,-2.67E-05,0.079031,-0.055875,-0.38528},
      {1.70E-06,2.88E-05,0.061471,-2.51E-05,2.99E-05,-0.73647,-5.01E-05,0.048869,-0.034538,-0.42607},
      {1.84E-07,2.88E-05,0.021107,-3.40E-05,1.61E-05,-0.78199,-6.58E-05,0.020975,-0.014812,-0.4638},
      {-1.38E-06,5.96E-05,-0.0019956,-4.05E-05,1.99E-05,-0.80073,-0.0001086,0.0094396,-0.0066289,-0.47934},
      {-2.66E-06,7.51E-05,-0.011101,-4.32E-05,4.37E-05,-0.79593,-0.00014807,0.012301,-0.0086243,-0.4754},
      {-3.01E-06,3.49E-05,-0.020403,-4.45E-05,7.81E-05,-0.78999,-0.00015253,0.015897,-0.011164,-0.47052},
      {-6.49E-06,-5.64E-05,-0.043682,-4.35E-05,0.00087047,-0.76405,-0.00014482,0.030949,-0.021809,-0.45015},
      {-1.21E-05,-0.00018064,-0.084529,-4.01E-05,0.0029505,-0.71337,-0.00014419,0.059779,-0.042188,-0.41111},
      {-1.64E-05,-0.000266,-0.1245,-3.56E-05,0.0056733,-0.6625,-0.00017101,0.088024,-0.062133,-0.37284},
      {-2.65E-05,-0.00032128,-0.16957,-2.87E-05,0.0072687,-0.60759,-0.00022743,0.11989,-0.084612,-0.3296},
      {-4.56E-05,-0.00038276,-0.2281,-2.03E-05,0.0064229,-0.54129,-0.00030887,0.1613,-0.1138,-0.27341},
      {0,2.45E-07,0.7071,0,9.76E-06,5.64E-06,-1.73E-07,0.49999,-0.35355,0.18463},
      {0,2.47E-07,0.7071,0,1.01E-05,5.83E-06,-1.75E-07,0.49999,-0.35355,0.18463},
      {0,2.49E-07,0.7071,0,1.06E-05,6.14E-06,-1.76E-07,0.49999,-0.35355,0.18463},
      {0,2.49E-07,0.7071,0,1.13E-05,6.55E-06,-1.76E-07,0.49999,-0.35355,0.18463},
      {0,2.45E-07,0.70709,0,1.22E-05,7.07E-06,-1.73E-07,0.49999,-0.35355,0.18463},
      {1.35E-07,2.33E-07,0.70584,0,0.0012446,0.00071859,-2.16E-08,0.49912,-0.35293,0.18345},
      {4.61E-07,2.10E-07,0.70282,0,0.0042056,0.0024281,3.08E-07,0.49703,-0.35145,0.18061},
      {8.56E-07,1.73E-07,0.69911,0,0.0078629,0.0045396,6.60E-07,0.49444,-0.34962,0.17711},
      {1.31E-06,1.19E-07,0.69459,0,0.012314,0.0071095,1.01E-06,0.49129,-0.34739,0.17285},
      {1.81E-06,4.32E-08,0.68916,0,0.017667,0.0102,1.33E-06,0.48751,-0.34472,0.16772},
      {2.36E-06,0,0.68337,0,0.023384,0.013501,1.67E-06,0.48346,-0.34186,0.16225},
      {3.53E-06,0,0.67559,0,0.026707,0.010469,2.50E-06,0.47808,-0.33805,0.15496},
      {7.07E-06,0,0.65733,0,0.02068,-0.020416,5.00E-06,0.46556,-0.3292,0.13801},
      {1.08E-05,0,0.63513,0,0.014412,-0.056318,7.67E-06,0.45022,-0.31835,0.11724},
      {1.48E-05,0,0.60832,0,0.0080113,-0.097813,1.04E-05,0.43159,-0.30518,0.09203},
      {1.88E-05,2.43E-08,0.57375,-9.77E-09,0.0023295,-0.14707,1.32E-05,0.40746,-0.28811,0.059351},
      {2.29E-05,1.91E-07,0.51766,-1.13E-07,0.0016773,-0.2123,1.59E-05,0.3682,-0.26035,0.0062021},
      {2.67E-05,3.01E-07,0.45832,-2.72E-07,0.00098591,-0.28147,1.84E-05,0.32657,-0.23091,-0.050162},
      {3.01E-05,3.38E-07,0.39584,-5.03E-07,0.00027829,-0.35446,2.05E-05,0.28262,-0.19983,-0.10966},
      {2.49E-05,-1.83E-07,0.31769,-3.84E-06,3.79E-05,-0.44477,1.44E-05,0.22757,-0.16091,-0.1842},
      {1.59E-05,-2.00E-06,0.2343,-9.78E-06,3.61E-05,-0.54063,4.33E-06,0.16886,-0.1194,-0.26368},
      {7.80E-06,-5.24E-06,0.15383,-1.71E-05,3.32E-05,-0.63308,-5.33E-06,0.11224,-0.079374,-0.34033},
      {3.05E-06,-7.06E-06,0.09319,-2.59E-05,2.57E-05,-0.70229,-1.80E-05,0.06985,-0.0494,-0.39771},
      {1.69E-06,-1.18E-05,0.055547,-3.55E-05,1.71E-05,-0.74433,-3.11E-05,0.044081,-0.031179,-0.43256},
      {8.32E-07,-2.38E-05,0.021022,-4.59E-05,1.31E-05,-0.78246,-4.00E-05,0.020711,-0.014658,-0.46417},
      {3.40E-07,-3.99E-05,-0.0029567,-5.39E-05,2.41E-05,-0.80322,-5.13E-05,0.0079672,-0.0056468,-0.4814},
      {2.08E-07,-7.16E-05,-0.012255,-5.45E-05,6.37E-05,-0.79671,-6.36E-05,0.011899,-0.0084182,-0.47605},
      {6.38E-07,-0.00011009,-0.021544,-5.35E-05,0.00011638,-0.78924,-7.45E-05,0.016407,-0.011598,-0.46994},
      {-1.05E-06,-0.00014366,-0.037318,-5.00E-05,0.00074117,-0.77184,-9.68E-05,0.026383,-0.01863,-0.4564},
      {-6.34E-06,-0.00020049,-0.072978,-4.46E-05,0.0030238,-0.72666,-0.00013323,0.051591,-0.036419,-0.42222},
      {-1.04E-05,-0.00025406,-0.10481,-3.76E-05,0.0052658,-0.68597,-0.00016832,0.074098,-0.052298,-0.39171},
      {-1.53E-05,-0.00030685,-0.13681,-2.91E-05,0.0069867,-0.64599,-0.00020734,0.096724,-0.068256,-0.36102},
      {0,0,0.7071,0,5.79E-06,3.34E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.06E-06,3.50E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.47E-06,3.74E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.04E-06,4.06E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.75E-06,4.48E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.61E-06,4.97E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,9.60E-06,5.55E-06,0,0.49999,-0.35355,0.18463},
      {2.28E-07,0,0.70504,0,0.0020451,0.0011808,1.61E-07,0.49855,-0.35253,0.18268},
      {7.04E-07,0,0.7008,0,0.0062345,0.0035995,4.98E-07,0.49559,-0.35044,0.17867},
      {1.23E-06,0,0.69617,0,0.010806,0.006239,8.71E-07,0.49236,-0.34815,0.17429},
      {1.81E-06,0,0.69125,0,0.015682,0.0090539,1.28E-06,0.48891,-0.34571,0.16962},
      {2.42E-06,0,0.68611,0,0.020762,0.011987,1.71E-06,0.48532,-0.34317,0.16476},
      {3.05E-06,0,0.6809,0,0.025923,0.014967,2.16E-06,0.48167,-0.34059,0.15982},
      {6.55E-06,0,0.65481,0,0.020423,-0.024298,4.63E-06,0.46345,-0.32771,0.13516},
      {1.02E-05,0,0.62267,0,0.014319,-0.071615,7.21E-06,0.44095,-0.31179,0.10469},
      {1.37E-05,0,0.5848,0,0.0083335,-0.1254,9.70E-06,0.41436,-0.29299,0.06869},
      {1.70E-05,0,0.54042,0,0.0026296,-0.18627,1.20E-05,0.38313,-0.2709,0.02641},
      {1.98E-05,7.95E-09,0.48233,-2.56E-07,0.0017286,-0.25457,1.38E-05,0.34226,-0.24201,-0.028919},
      {2.19E-05,-6.19E-08,0.42086,-6.08E-07,0.00098852,-0.32659,1.50E-05,0.29894,-0.21137,-0.087573},
      {2.32E-05,-2.26E-07,0.35634,-1.07E-06,0.00031005,-0.40213,1.57E-05,0.2534,-0.17917,-0.14923},
      {1.89E-05,-2.20E-06,0.28402,-5.31E-06,1.67E-05,-0.48582,1.04E-05,0.20246,-0.14315,-0.2182},
      {1.12E-05,-6.92E-06,0.20868,-1.41E-05,1.44E-05,-0.57222,4.66E-07,0.14954,-0.10574,-0.28984},
      {4.98E-06,-1.33E-05,0.13685,-2.46E-05,1.17E-05,-0.65458,-8.82E-06,0.099093,-0.070083,-0.35812},
      {1.53E-06,-2.22E-05,0.078895,-3.62E-05,8.81E-06,-0.72054,-1.78E-05,0.058679,-0.041514,-0.41282},
      {8.67E-07,-3.51E-05,0.047137,-4.74E-05,8.68E-06,-0.7552,-2.65E-05,0.037431,-0.026495,-0.44156},
      {7.65E-07,-4.99E-05,0.018695,-6.20E-05,1.18E-05,-0.78553,-3.44E-05,0.018829,-0.01335,-0.4667},
      {8.82E-07,-6.60E-05,-0.0033297,-7.71E-05,2.59E-05,-0.8056,-4.55E-05,0.0064871,-0.0046304,-0.48337},
      {7.07E-07,-9.13E-05,-0.011594,-7.64E-05,7.84E-05,-0.79864,-6.28E-05,0.010674,-0.0075768,-0.47768},
      {5.68E-07,-0.00011548,-0.019177,-7.01E-05,0.00013765,-0.79207,-7.95E-05,0.01463,-0.010356,-0.47231},
      {1.99E-07,-0.00014005,-0.027593,-5.79E-05,0.00032458,-0.7838,-9.65E-05,0.019494,-0.01377,-0.46572},
      {-3.50E-06,-0.00019132,-0.057731,-5.03E-05,0.002302,-0.74553,-0.00013011,0.040801,-0.028802,-0.43683},
      {-6.18E-06,-0.00023844,-0.08387,-4.10E-05,0.0040747,-0.71224,-0.00016165,0.059284,-0.041837,-0.41178},
      {0,0,0.7071,0,2.84E-06,1.64E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.04E-06,1.76E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.35E-06,1.94E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.78E-06,2.18E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.31E-06,2.49E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.95E-06,2.86E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.69E-06,3.29E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.50E-06,3.75E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.36E-06,4.25E-06,0,0.49999,-0.35355,0.18463},
      {4.36E-07,0,0.70357,0,0.0035092,0.002026,3.08E-07,0.49752,-0.3518,0.18128},
      {9.63E-07,0,0.69934,0,0.0076936,0.0044419,6.81E-07,0.49456,-0.34971,0.17727},
      {1.51E-06,0,0.69505,0,0.011949,0.0068989,1.07E-06,0.49155,-0.34758,0.1732},
      {2.05E-06,0,0.69083,0,0.01614,0.0093184,1.45E-06,0.48859,-0.34548,0.16918},
      {2.57E-06,0,0.68683,0,0.020106,0.011608,1.82E-06,0.48578,-0.3435,0.16539},
      {4.94E-06,0,0.65778,0,0.017129,-0.02693,3.49E-06,0.46534,-0.32904,0.13771},
      {7.77E-06,0,0.61374,0,0.011806,-0.086812,5.49E-06,0.43431,-0.3071,0.095701},
      {1.02E-05,0,0.56281,0,0.006882,-0.15402,7.19E-06,0.39838,-0.28169,0.047046},
      {1.19E-05,0,0.50417,0,0.0025478,-0.22916,8.45E-06,0.35696,-0.2524,-0.0090348},
      {1.28E-05,-1.59E-07,0.44298,-4.11E-07,0.0012792,-0.30191,8.85E-06,0.31375,-0.22185,-0.06753},
      {1.27E-05,-4.45E-07,0.37952,-1.03E-06,0.0006688,-0.37618,8.44E-06,0.26892,-0.19015,-0.12823},
      {1.12E-05,-8.48E-07,0.31313,-1.79E-06,0.00020151,-0.45367,7.13E-06,0.22196,-0.15694,-0.19182},
      {7.48E-06,-4.00E-06,0.24478,-7.17E-06,3.69E-06,-0.53262,2.12E-06,0.17382,-0.12291,-0.25699},
      {2.21E-06,-1.23E-05,0.17824,-2.09E-05,2.12E-06,-0.60865,-7.41E-06,0.12724,-0.089983,-0.32003},
      {9.89E-08,-2.23E-05,0.11604,-3.87E-05,1.39E-06,-0.67965,-1.57E-05,0.08373,-0.059234,-0.3789},
      {1.59E-07,-3.39E-05,0.062519,-6.13E-05,2.93E-06,-0.74031,-2.38E-05,0.04654,-0.032953,-0.4292},
      {3.59E-07,-4.75E-05,0.037749,-7.96E-05,9.19E-06,-0.76609,-3.32E-05,0.03071,-0.021771,-0.45059},
      {5.16E-07,-6.20E-05,0.015768,-9.89E-05,1.68E-05,-0.78843,-4.33E-05,0.016984,-0.012077,-0.46912},
      {6.28E-07,-7.74E-05,-0.0032743,-0.00011989,2.58E-05,-0.80719,-5.41E-05,0.0054467,-0.0039321,-0.48469},
      {5.22E-07,-0.00010077,-0.010324,-0.00011085,8.24E-05,-0.80099,-7.02E-05,0.0091801,-0.006551,-0.47963},
      {4.31E-07,-0.00012248,-0.016646,-9.49E-05,0.00014182,-0.79527,-8.53E-05,0.012624,-0.0089595,-0.47497},
      {3.46E-07,-0.00014218,-0.022167,-7.10E-05,0.00020217,-0.79013,-9.92E-05,0.01573,-0.011122,-0.47079},
      {-1.71E-06,-0.00018299,-0.043734,-5.84E-05,0.0014598,-0.76317,-0.00012666,0.030893,-0.02181,-0.45025},
      {0,0,0.70711,0,8.20E-07,4.73E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.65E-07,5.57E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.18E-06,6.84E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.48E-06,8.57E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.86E-06,1.07E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.30E-06,1.33E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.81E-06,1.62E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.35E-06,1.94E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.92E-06,2.26E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.48E-06,2.59E-06,0,0.5,-0.35355,0.18463},
      {1.63E-07,0,0.70586,0,0.0012347,0.00071286,1.15E-07,0.49913,-0.35294,0.18346},
      {5.91E-07,0,0.70264,0,0.0044402,0.0025636,4.18E-07,0.49686,-0.35133,0.18039},
      {9.95E-07,0,0.69962,0,0.007433,0.0042915,7.03E-07,0.49474,-0.34984,0.17752},
      {1.35E-06,0,0.69699,0,0.010044,0.0057991,9.56E-07,0.4929,-0.34853,0.17502},
      {1.63E-06,0,0.69494,0,0.012082,0.0069754,1.16E-06,0.49146,-0.34751,0.17307},
      {2.74E-06,0,0.66716,0,0.010481,-0.027836,1.94E-06,0.47184,-0.33364,0.1465},
      {4.44E-06,0,0.61034,0,0.0064565,-0.10034,3.14E-06,0.4317,-0.30526,0.092167},
      {5.43E-06,0,0.54661,0,0.0032209,-0.17949,3.84E-06,0.38667,-0.27341,0.031186},
      {5.25E-06,0,0.47542,0,0.00096411,-0.26558,3.71E-06,0.33634,-0.23783,-0.036952},
      {3.13E-06,-4.92E-07,0.40864,-9.86E-07,0.00021078,-0.34392,1.85E-06,0.28916,-0.20447,-0.10083},
      {0,-1.51E-06,0.34361,-3.04E-06,0,-0.41931,-1.07E-06,0.24322,-0.17199,-0.16303},
      {0,-3.12E-06,0.2773,-6.60E-06,0,-0.49579,-2.21E-06,0.19638,-0.13887,-0.22645},
      {8.61E-09,-7.30E-06,0.21094,-1.54E-05,1.72E-07,-0.57213,-5.15E-06,0.14962,-0.10581,-0.28975},
      {4.07E-08,-1.85E-05,0.15383,-3.86E-05,9.72E-07,-0.6372,-1.30E-05,0.10972,-0.077616,-0.34371},
      {6.72E-08,-3.10E-05,0.09931,-6.66E-05,1.92E-06,-0.69931,-2.19E-05,0.071644,-0.050711,-0.3952},
      {8.78E-08,-4.49E-05,0.048061,-9.98E-05,3.03E-06,-0.75768,-3.17E-05,0.035842,-0.025421,-0.4436},
      {2.21E-07,-5.98E-05,0.028614,-0.00012064,1.11E-05,-0.77701,-4.21E-05,0.023953,-0.017028,-0.45965},
      {3.16E-07,-7.57E-05,0.011874,-0.00014351,2.05E-05,-0.79309,-5.32E-05,0.014056,-0.010044,-0.47299},
      {3.72E-07,-9.29E-05,-0.0021494,-0.00016887,3.11E-05,-0.80594,-6.53E-05,0.0061283,-0.0044555,-0.48366},
      {3.21E-07,-0.00011295,-0.0090051,-0.00015681,7.87E-05,-0.80346,-7.93E-05,0.0076005,-0.0054743,-0.48167},
      {2.48E-07,-0.00013151,-0.014007,-0.00012913,0.00013281,-0.79875,-9.24E-05,0.010452,-0.0074537,-0.47784},
      {1.61E-07,-0.0001476,-0.018164,-9.22E-05,0.00018413,-0.79471,-0.00010378,0.012909,-0.0091462,-0.47457},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.46E-07,8.45E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.70E-07,2.14E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.25E-07,3.61E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,8.99E-07,5.19E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.18E-06,6.78E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.43E-06,8.27E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.65E-06,9.52E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.80E-06,1.04E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.86E-06,1.08E-06,0,0.5,-0.35355,0.18464},
      {3.00E-07,0,0.70564,0,0.0014553,0.00084023,2.12E-07,0.49897,-0.35283,0.18324},
      {5.29E-07,0,0.70466,0,0.002419,0.0013966,3.74E-07,0.49829,-0.35234,0.18232},
      {6.22E-07,0,0.70439,0,0.0026865,0.001551,4.40E-07,0.4981,-0.35221,0.18207},
      {5.12E-07,0,0.70498,0,0.0020829,0.0012026,3.62E-07,0.49853,-0.35251,0.18264},
      {1.44E-07,0,0.68471,0,0.00036471,-0.025162,1.02E-07,0.4842,-0.34238,0.16325},
      {0,0,0.61539,0,0,-0.10582,0,0.4352,-0.30773,0.096898},
      {0,0,0.54011,0,0,-0.19271,0,0.38199,-0.27011,0.024849},
      {0,0,0.45897,0,0,-0.28638,0,0.32463,-0.22955,-0.052815},
      {0,-1.03E-06,0.38487,-2.32E-06,0,-0.37189,-7.27E-07,0.27226,-0.19252,-0.12372},
      {0,-3.45E-06,0.31833,-7.93E-06,0,-0.44863,-2.44E-06,0.22526,-0.15929,-0.18735},
      {0,-6.65E-06,0.24887,-1.55E-05,0,-0.52876,-4.70E-06,0.17618,-0.12459,-0.25379},
      {2.59E-09,-1.16E-05,0.17878,-2.74E-05,1.00E-07,-0.60954,-8.22E-06,0.12669,-0.089605,-0.32076},
      {2.46E-08,-2.52E-05,0.12809,-5.95E-05,1.13E-06,-0.66725,-1.78E-05,0.091291,-0.064599,-0.36862},
      {4.14E-08,-4.01E-05,0.080743,-9.66E-05,2.30E-06,-0.72115,-2.83E-05,0.058219,-0.041243,-0.41331},
      {5.27E-08,-5.63E-05,0.037428,-0.00013888,3.60E-06,-0.77047,-3.98E-05,0.027944,-0.01987,-0.45421},
      {1.16E-07,-7.29E-05,0.019139,-0.00016707,1.21E-05,-0.78871,-5.15E-05,0.016712,-0.011948,-0.46935},
      {1.59E-07,-9.08E-05,0.0072103,-0.00019475,2.30E-05,-0.79917,-6.40E-05,0.010245,-0.0073937,-0.47803},
      {1.68E-07,-0.00011015,-0.0022134,-0.0002258,3.49E-05,-0.80674,-7.77E-05,0.0055387,-0.004087,-0.48433},
      {1.22E-07,-0.00012826,-0.0076861,-0.00021528,7.06E-05,-0.80595,-9.05E-05,0.0059902,-0.0043867,-0.48372},
      {3.38E-08,-0.00014376,-0.011342,-0.00018111,0.00011664,-0.80232,-0.0001015,0.0082021,-0.0059089,-0.48078},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.94E-08,2.85E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.09E-07,6.29E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.42E-07,8.21E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.36E-07,7.85E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.74E-08,4.47E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69543,0,0,-0.013452,0,0.49176,-0.34773,0.17348},
      {0,0,0.61788,0,0,-0.10298,0,0.43694,-0.30896,0.09925},
      {0,0,0.53428,0,0,-0.1995,0,0.37783,-0.26717,0.01922},
      {0,0,0.44436,0,0,-0.30333,0,0.31425,-0.22221,-0.066868},
      {0,-1.42E-06,0.36017,-3.40E-06,0,-0.40049,-1.01E-06,0.25474,-0.18013,-0.14743},
      {0,-5.62E-06,0.2906,-1.35E-05,0,-0.48075,-3.97E-06,0.20558,-0.14538,-0.21398},
      {0,-1.08E-05,0.21818,-2.63E-05,0,-0.5643,-7.64E-06,0.15439,-0.10919,-0.28326},
      {0,-1.71E-05,0.14298,-4.20E-05,0,-0.65106,-1.21E-05,0.10124,-0.07162,-0.35519},
      {1.25E-08,-3.26E-05,0.098785,-8.23E-05,1.19E-06,-0.7014,-2.31E-05,0.070342,-0.049805,-0.39693},
      {2.07E-08,-4.96E-05,0.059758,-0.00012838,2.54E-06,-0.74583,-3.51E-05,0.043057,-0.030549,-0.43377},
      {2.40E-08,-6.78E-05,0.025495,-0.00017985,4.00E-06,-0.78485,-4.80E-05,0.019074,-0.013633,-0.46613},
      {4.01E-08,-8.63E-05,0.0099135,-0.00021889,1.21E-05,-0.80048,-6.10E-05,0.0094234,-0.0068391,-0.4791},
      {3.94E-08,-0.00010669,0.0027701,-0.00026371,2.35E-05,-0.80571,-7.54E-05,0.0061293,-0.0045444,-0.48346},
      {1.06E-08,-0.00013017,-0.0025,-0.00032648,3.54E-05,-0.80906,-9.20E-05,0.0039656,-0.0030655,-0.48625},
      {-1.51E-08,-0.00014868,-0.0061026,-0.00034353,6.24E-05,-0.80827,-0.00010512,0.0043821,-0.0033678,-0.48563},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62168,0,0,-0.098626,0,0.4396,-0.31085,0.10286},
      {0,0,0.52895,0,0,-0.2057,0,0.37404,-0.26448,0.014082},
      {0,0,0.42942,0,0,-0.32062,0,0.30366,-0.21472,-0.081205},
      {0,-1.47E-06,0.33286,-3.62E-06,0,-0.43209,-1.04E-06,0.23539,-0.16645,-0.17363},
      {0,-7.81E-06,0.26042,-1.94E-05,0,-0.51566,-5.52E-06,0.18419,-0.13026,-0.24293},
      {0,-1.55E-05,0.1845,-3.85E-05,0,-0.60325,-1.10E-05,0.13052,-0.092323,-0.31555},
      {0,-2.50E-05,0.10625,-6.18E-05,0,-0.69353,-1.77E-05,0.075194,-0.05322,-0.39041},
      {3.71E-09,-4.12E-05,0.065188,-0.00010667,1.05E-06,-0.74049,-2.91E-05,0.046364,-0.03287,-0.42935},
      {4.35E-09,-5.88E-05,0.037151,-0.00015838,2.32E-06,-0.77244,-4.16E-05,0.02671,-0.019016,-0.45584},
      {9.43E-10,-7.68E-05,0.014881,-0.0002131,3.56E-06,-0.79787,-5.43E-05,0.011049,-0.0079872,-0.47692},
      {0,-9.57E-05,0.0047015,-0.00026881,9.79E-06,-0.80795,-6.77E-05,0.0047745,-0.003597,-0.48529},
      {0,-0.00011807,0.0010112,-0.00033846,2.00E-05,-0.80955,-8.35E-05,0.0036676,-0.0028728,-0.48664},
      {0,-0.00014238,-0.0019714,-0.00042328,2.96E-05,-0.81064,-0.00010068,0.0028547,-0.0023706,-0.48755},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.6265,0,0,-0.093073,0,0.443,-0.31325,0.10747},
      {0,0,0.52219,0,0,-0.21351,0,0.36925,-0.2611,0.0076021},
      {0,0,0.40956,0,0,-0.34356,0,0.28961,-0.20479,-0.10023},
      {0,-1.07E-06,0.2946,-2.61E-06,0,-0.47629,-7.58E-07,0.20833,-0.14731,-0.21028},
      {0,-1.06E-05,0.22037,-2.58E-05,0,-0.56193,-7.53E-06,0.15585,-0.11022,-0.28129},
      {0,-2.20E-05,0.14541,-5.31E-05,0,-0.64842,-1.55E-05,0.10284,-0.072759,-0.353},
      {0,-3.52E-05,0.071464,-8.47E-05,0,-0.73373,-2.49E-05,0.050542,-0.035805,-0.42374},
      {0,-5.06E-05,0.03755,-0.00013023,7.37E-07,-0.77261,-3.58E-05,0.026651,-0.01895,-0.45598},
      {0,-6.60E-05,0.022379,-0.00017969,1.69E-06,-0.78982,-4.67E-05,0.016035,-0.011485,-0.47025},
      {0,-8.04E-05,0.010025,-0.00022761,2.51E-06,-0.80382,-5.69E-05,0.0073832,-0.0054081,-0.48186},
      {0,-9.82E-05,0.0027172,-0.00028946,6.50E-06,-0.81122,-6.94E-05,0.0027433,-0.0021802,-0.488},
      {0,-0.00012363,0.00032083,-0.00038533,1.53E-05,-0.81189,-8.74E-05,0.0021727,-0.0018598,-0.48857},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.6321,0,0,-0.086602,0,0.44697,-0.31605,0.11283},
      {0,0,0.51419,0,0,-0.22275,0,0.36359,-0.2571,-6.02E-05},
      {0,0,0.38756,0,0,-0.36897,0,0.27405,-0.19378,-0.1213},
      {0,0,0.25265,0,0,-0.52475,0,0.17866,-0.12633,-0.25046},
      {0,-1.27E-05,0.1839,-3.07E-05,0,-0.60405,-8.98E-06,0.13004,-0.091978,-0.31622},
      {0,-2.70E-05,0.11839,-6.58E-05,0,-0.67961,-1.91E-05,0.083711,-0.059245,-0.37887},
      {0,-4.28E-05,0.055615,-0.0001048,0,-0.75201,-3.02E-05,0.039308,-0.027879,-0.4389},
      {0,-5.80E-05,0.022095,-0.00014906,4.11E-07,-0.79054,-4.10E-05,0.015644,-0.011182,-0.47084},
      {0,-7.11E-05,0.012795,-0.00019394,1.06E-06,-0.80105,-5.03E-05,0.0091321,-0.0066157,-0.47956},
      {0,-8.33E-05,0.0056592,-0.00023683,1.57E-06,-0.80911,-5.89E-05,0.0041282,-0.0031142,-0.48624},
      {0,-9.83E-05,0.0011898,-0.00029402,3.62E-06,-0.81377,-6.95E-05,0.0011821,-0.0010807,-0.49011},
      {0.40895,0.024257,0.019014,-0.055053,0.0027831,-1.85E-05,0.32528,-0.027647,0.25835,0.17177},
      {0.39228,0.034225,0.010938,-0.065842,0.0028042,0.00048987,0.30497,-0.040417,0.25776,0.1719},
      {0.33708,0.053406,0.0044975,-0.10476,0.0051987,0.0019085,0.25293,-0.073387,0.22149,0.17051},
      {0.26171,0.081804,-0.00015862,-0.15524,0.010186,0.0043884,0.17887,-0.11424,0.16595,0.16702},
      {0.17201,0.10943,-0.0061541,-0.21585,0.03165,0.016107,0.081856,-0.16884,0.074172,0.14777},
      {0.086366,0.1505,-0.014117,-0.24401,0.064752,0.034325,-0.022771,-0.20247,0.0012071,0.11703},
      {0.057047,0.16741,-0.020293,-0.21083,0.11555,0.063696,-0.073685,-0.1941,-0.022963,0.069005},
      {0.038785,0.18303,-0.027595,-0.14321,0.17655,0.099084,-0.10848,-0.15997,-0.019298,0.01103},
      {0.014709,0.18791,-0.04024,-0.098543,0.23295,0.13183,-0.12673,-0.12366,-0.020778,-0.042305},
      {0.0019525,0.18177,-0.052935,-0.044752,0.28791,0.16405,-0.12928,-0.085704,-0.019299,-0.09405},
      {0.0013063,0.1687,-0.061309,0.0084999,0.34043,0.19488,-0.12086,-0.047033,-0.007417,-0.1438},
      {0.0008885,0.14626,-0.068309,0.040502,0.38937,0.22361,-0.10518,-0.01966,-0.006765,-0.19004},
      {0.00061344,0.11735,-0.07231,0.041475,0.42714,0.24583,-0.084507,-0.0089231,-0.018133,-0.22559},
      {0.00039403,0.090792,-0.072358,0.037385,0.47233,0.27234,-0.065439,0.0031439,-0.023411,-0.26826},
      {0.00031334,0.076337,-0.070326,0.028783,0.50993,0.29419,-0.054979,0.01601,-0.019811,-0.30401},
      {0.00025759,0.066357,-0.070959,0.020692,0.53202,0.3069,-0.047704,0.025135,-0.01923,-0.32515},
      {0.00018307,0.054075,-0.074298,0.016362,0.54489,0.31429,-0.038829,0.02995,-0.025533,-0.33746},
      {0.00011736,0.041949,-0.078301,0.011054,0.55964,0.32281,-0.030107,0.037153,-0.030685,-0.35152},
      {5.94E-05,0.030357,-0.081935,0.0050306,0.57658,0.33269,-0.021802,0.045759,-0.034167,-0.36761},
      {3.62E-05,0.024085,-0.092392,-0.00048578,0.58091,0.33522,-0.017301,0.059017,-0.038458,-0.3717},
      {2.87E-05,0.019583,-0.11121,-0.0012965,0.56689,0.32709,-0.014075,0.072492,-0.050035,-0.3583},
      {2.82E-05,0.015628,-0.1308,-0.0018954,0.5519,0.31839,-0.011255,0.086789,-0.061508,-0.34397},
      {3.60E-05,0.011963,-0.14628,-0.0024541,0.54132,0.31229,-0.0086185,0.098574,-0.070514,-0.33384},
      {5.61E-05,0.0085343,-0.15689,-0.0030249,0.53604,0.30929,-0.0061267,0.10735,-0.076665,-0.32875},
      {0.0001504,0.0054204,-0.16839,-0.0033843,0.52912,0.30534,-0.0038179,0.11651,-0.083224,-0.32208},
      {0.00036279,0.002807,-0.18321,-0.0032222,0.51695,0.29833,-0.0017981,0.12712,-0.091749,-0.31042},
      {0.00064859,0.0010677,-0.19313,-0.0028616,0.50895,0.29373,-0.00034557,0.13441,-0.097244,-0.30273},
      {0.00096958,0.00049258,-0.20538,-0.0021727,0.49775,0.2873,0.00030535,0.14359,-0.10313,-0.29199},
      {0.0013339,0.00015433,-0.21143,-0.0015171,0.49246,0.28428,0.00081762,0.14838,-0.10579,-0.2869},
      {0.0016085,2.90E-07,-0.21316,-0.00097062,0.49129,0.28363,0.0011307,0.15004,-0.10628,-0.28576},
      {0.0010757,3.00E-08,-0.21998,-0.000722,0.48527,0.28015,0.00075632,0.15504,-0.10983,-0.27999},
      {0.00065114,-9.28E-08,-0.2232,-0.0005011,0.48271,0.27867,0.00045793,0.15747,-0.11154,-0.27754},
      {0.4128,0.024873,0.021978,-0.051918,0.0024323,4.02E-05,0.3141,-0.023203,0.25878,0.17187},
      {0.40127,0.033578,0.013714,-0.059922,0.0025156,0.00051211,0.29671,-0.034277,0.2606,0.1719},
      {0.36284,0.050948,0.00624,-0.086243,0.0046608,0.0018478,0.25448,-0.058734,0.23859,0.17045},
      {0.29943,0.079296,0.001565,-0.12585,0.0098159,0.0044279,0.18649,-0.091698,0.19371,0.16657},
      {0.22859,0.11152,-0.0044075,-0.16323,0.026297,0.013355,0.10245,-0.12712,0.13425,0.15178},
      {0.15014,0.15327,-0.012106,-0.18193,0.058802,0.031298,0.0028962,-0.15352,0.071897,0.12149},
      {0.089335,0.20331,-0.020516,-0.16155,0.098532,0.053476,-0.089458,-0.15289,0.042124,0.083932},
      {0.058322,0.21516,-0.02995,-0.1199,0.15131,0.083861,-0.12281,-0.12819,0.032256,0.033716},
      {0.029124,0.2169,-0.042089,-0.076933,0.20821,0.11688,-0.14244,-0.098938,0.021549,-0.020106},
      {0.0095196,0.21077,-0.055465,-0.02812,0.26961,0.15288,-0.14841,-0.063127,0.015697,-0.077793},
      {0.0014896,0.1979,-0.067439,0.020329,0.33252,0.18991,-0.14194,-0.022254,0.019026,-0.13685},
      {0.0010829,0.16765,-0.075051,0.034819,0.37011,0.21211,-0.12052,-0.0076612,0.0060303,-0.17211},
      {0.00078294,0.13699,-0.079153,0.036431,0.40864,0.23476,-0.098576,0.0024046,-0.0068454,-0.20834},
      {0.00054223,0.10891,-0.079276,0.032935,0.45444,0.26162,-0.078397,0.013842,-0.013455,-0.25157},
      {0.00035691,0.084147,-0.07642,0.024499,0.50467,0.29111,-0.060542,0.026596,-0.014452,-0.29903},
      {0.00028682,0.072594,-0.077666,0.019228,0.52178,0.30092,-0.052141,0.031939,-0.017965,-0.31542},
      {0.00020952,0.059634,-0.081202,0.015169,0.53481,0.30838,-0.042784,0.036662,-0.024872,-0.32789},
      {0.00014136,0.046907,-0.085373,0.010086,0.54971,0.31698,-0.033635,0.043781,-0.030557,-0.3421},
      {8.12E-05,0.034776,-0.089159,0.0042492,0.56679,0.32693,-0.024947,0.052317,-0.034514,-0.35833},
      {3.94E-05,0.02507,-0.096665,-0.00038518,0.57632,0.33256,-0.018009,0.062537,-0.03974,-0.36732},
      {3.23E-05,0.020467,-0.11717,-0.0011639,0.5606,0.32343,-0.01472,0.077142,-0.052254,-0.35229},
      {3.14E-05,0.016389,-0.13766,-0.0017736,0.54476,0.31425,-0.011813,0.092035,-0.06427,-0.33716},
      {3.87E-05,0.012618,-0.15394,-0.0023402,0.53344,0.30771,-0.009101,0.10434,-0.073756,-0.32632},
      {5.82E-05,0.0090975,-0.16526,-0.0029163,0.52748,0.30432,-0.0065443,0.11358,-0.080334,-0.32058},
      {0.00012154,0.0054626,-0.17667,-0.0032712,0.52094,0.30061,-0.0038727,0.12245,-0.087291,-0.31426},
      {0.0003288,0.0028206,-0.1919,-0.0031267,0.50838,0.29337,-0.0018354,0.13334,-0.096049,-0.30221},
      {0.00060713,0.0011448,-0.20332,-0.0027489,0.49884,0.28789,-0.00043276,0.1417,-0.10226,-0.29306},
      {0.0009237,0.00054997,-0.2159,-0.0020881,0.4873,0.28126,0.00022987,0.15109,-0.10834,-0.28199},
      {0.0012842,0.00019557,-0.22222,-0.0014567,0.48174,0.27808,0.00075174,0.15606,-0.11116,-0.27664},
      {0.0015864,1.70E-05,-0.22321,-0.00096624,0.48125,0.27782,0.0011025,0.15715,-0.11131,-0.27614},
      {0.0011223,-8.23E-10,-0.2288,-0.00072987,0.47639,0.27503,0.00078912,0.16127,-0.11422,-0.27149},
      {0.00068578,-1.20E-07,-0.23218,-0.00050607,0.47369,0.27346,0.00048232,0.16382,-0.11601,-0.2689},
      {0.422,0.023262,0.029879,-0.044155,0.0018268,1.10E-05,0.29996,-0.012116,0.25865,0.17203},
      {0.41621,0.030607,0.021527,-0.049154,0.0019604,0.00044642,0.28531,-0.021284,0.26296,0.17195},
      {0.40724,0.041671,0.010371,-0.0566,0.0025501,0.0011986,0.26224,-0.034282,0.26683,0.17147},
      {0.35766,0.069448,0.0058087,-0.083584,0.0077397,0.0038327,0.20146,-0.058015,0.23446,0.16728},
      {0.31491,0.10242,0.00046451,-0.10022,0.014062,0.0071028,0.13596,-0.075,0.21108,0.16182},
      {0.2571,0.14293,-0.0062977,-0.10556,0.038275,0.020486,0.050931,-0.089085,0.17397,0.13919},
      {0.16851,0.19789,-0.017001,-0.10315,0.073684,0.039437,-0.050754,-0.095227,0.13216,0.10526},
      {0.084405,0.25356,-0.031082,-0.088186,0.11439,0.061601,-0.14288,-0.089543,0.098981,0.066468},
      {0.04151,0.26417,-0.043687,-0.05214,0.16985,0.093607,-0.17617,-0.068852,0.077905,0.014123},
      {0.019089,0.25581,-0.05633,-0.0095483,0.23337,0.13093,-0.1818,-0.037572,0.066166,-0.045439},
      {0.006564,0.23481,-0.07153,0.021075,0.29417,0.16679,-0.16981,-0.0063775,0.05091,-0.10197},
      {0.0013481,0.19886,-0.086729,0.027473,0.33936,0.19375,-0.1429,0.010553,0.023332,-0.14341},
      {0.0010188,0.16601,-0.090713,0.029798,0.37908,0.21707,-0.11935,0.019603,0.0086769,-0.18075},
      {0.00075173,0.13594,-0.090746,0.027007,0.42588,0.2445,-0.097712,0.030095,0.00042234,-0.22491},
      {0.00053371,0.1105,-0.088062,0.020303,0.47337,0.27238,-0.079313,0.040559,-0.0027936,-0.26973},
      {0.00032983,0.081819,-0.0883,0.017267,0.50567,0.29149,-0.0587,0.042336,-0.016575,-0.30011},
      {0.00024878,0.067858,-0.092193,0.013539,0.51895,0.29908,-0.048633,0.047035,-0.024363,-0.31284},
      {0.00017725,0.054239,-0.096657,0.0087406,0.53409,0.3078,-0.038851,0.05411,-0.030823,-0.32729},
      {0.00011408,0.041309,-0.10069,0.0031451,0.55141,0.31787,-0.029595,0.062595,-0.035471,-0.34376},
      {5.95E-05,0.028944,-0.10771,-0.00019232,0.56195,0.32413,-0.02077,0.070894,-0.042908,-0.35368},
      {3.75E-05,0.021745,-0.12728,-0.00096811,0.55002,0.31729,-0.015655,0.084938,-0.056187,-0.3422},
      {3.58E-05,0.017494,-0.14908,-0.0015899,0.53296,0.30739,-0.012626,0.10069,-0.06899,-0.3259},
      {4.23E-05,0.013573,-0.16652,-0.0021652,0.52054,0.30022,-0.0098077,0.11375,-0.079173,-0.31401},
      {6.07E-05,0.0099214,-0.17886,-0.002747,0.51361,0.29626,-0.0071581,0.12365,-0.086374,-0.30734},
      {0.00010558,0.0058107,-0.19144,-0.0030695,0.50598,0.29193,-0.0041521,0.13304,-0.094391,-0.29996},
      {0.00027286,0.0028043,-0.20575,-0.0029876,0.49474,0.28549,-0.0018691,0.14324,-0.10293,-0.28916},
      {0.0005406,0.0012501,-0.21952,-0.0025836,0.48276,0.2786,-0.0005592,0.15328,-0.11024,-0.27768},
      {0.00085078,0.00062839,-0.23255,-0.0019642,0.47077,0.27171,0.00011929,0.16296,-0.11659,-0.26617},
      {0.0012058,0.00025199,-0.23924,-0.001368,0.46483,0.26831,0.00065418,0.16816,-0.11962,-0.26046},
      {0.0014637,5.83E-05,-0.24051,-0.00094292,0.46404,0.26787,0.000985,0.1694,-0.11998,-0.25968},
      {0.0011906,-5.45E-08,-0.24263,-0.00074077,0.46248,0.26699,0.0008372,0.17105,-0.12111,-0.25817},
      {0.00073605,-1.67E-07,-0.24624,-0.00051253,0.45957,0.26531,0.00051772,0.17376,-0.12302,-0.25539},
      {0.43452,0.017058,0.049703,-0.031641,0.00074355,-0.00027003,0.28343,0.010569,0.25147,0.17244},
      {0.43321,0.023104,0.041601,-0.034013,0.00089342,0.000129,0.27081,0.00329,0.25764,0.17228},
      {0.43342,0.031378,0.02997,-0.036111,0.0011057,0.00069844,0.25288,-0.0062928,0.26757,0.172},
      {0.43609,0.041661,0.015451,-0.03687,0.0014918,0.0014693,0.22945,-0.017071,0.2812,0.17147},
      {0.38022,0.079276,0.010503,-0.049866,0.0079217,0.0042014,0.15751,-0.030385,0.25957,0.16508},
      {0.31285,0.12874,0.0024313,-0.058879,0.016534,0.0077695,0.07044,-0.041524,0.23962,0.15628},
      {0.23107,0.18112,-0.0091208,-0.061193,0.035658,0.017552,-0.028983,-0.050446,0.2125,0.13704},
      {0.14308,0.23462,-0.023154,-0.049956,0.07786,0.040812,-0.12072,-0.050148,0.17206,0.097078},
      {0.068633,0.29138,-0.039778,-0.025934,0.12437,0.066728,-0.19827,-0.037602,0.14332,0.053811},
      {0.023999,0.31725,-0.056881,0.0036477,0.17748,0.097031,-0.23279,-0.015362,0.12137,0.0046633},
      {0.01298,0.28214,-0.074098,0.01426,0.22943,0.12714,-0.20725,0.0020167,0.087031,-0.043428},
      {0.005591,0.2442,-0.091647,0.020774,0.28234,0.15859,-0.178,0.021655,0.055163,-0.091869},
      {0.0013018,0.20399,-0.1084,0.022662,0.33628,0.19145,-0.14651,0.042807,0.026865,-0.14076},
      {0.00099901,0.17528,-0.1074,0.021781,0.37984,0.21696,-0.12571,0.050341,0.018087,-0.18181},
      {0.00074509,0.14589,-0.1052,0.018809,0.42093,0.24096,-0.10446,0.05418,0.0076588,-0.22066},
      {0.00050384,0.11161,-0.10543,0.015835,0.45973,0.26385,-0.079845,0.056407,-0.0086667,-0.25718},
      {0.0003003,0.078527,-0.10815,0.011644,0.49641,0.28584,-0.056215,0.061533,-0.024672,-0.29147},
      {0.00022482,0.063749,-0.11306,0.0071333,0.51192,0.29474,-0.045613,0.068676,-0.032114,-0.30629},
      {0.000158,0.049776,-0.11746,0.0017916,0.52959,0.30499,-0.035618,0.077183,-0.037636,-0.32311},
      {0.00010208,0.03626,-0.12913,0.00014178,0.53342,0.30729,-0.025988,0.086555,-0.04953,-0.32667},
      {5.17E-05,0.024472,-0.14514,-0.00068019,0.53023,0.3057,-0.017635,0.098321,-0.063174,-0.32339},
      {4.09E-05,0.018892,-0.16651,-0.0013413,0.51506,0.29699,-0.013662,0.11377,-0.076428,-0.30883},
      {4.58E-05,0.014787,-0.1854,-0.0019227,0.50127,0.28902,-0.010713,0.12778,-0.087491,-0.29561},
      {6.26E-05,0.010974,-0.19904,-0.0025078,0.49309,0.28434,-0.0079488,0.13852,-0.09548,-0.28775},
      {0.00010764,0.0064827,-0.21416,-0.0027709,0.48274,0.27842,-0.0046691,0.14932,-0.10523,-0.27779},
      {0.00018862,0.0027102,-0.22579,-0.0028109,0.47505,0.2741,-0.0018694,0.15755,-0.11293,-0.27033},
      {0.00044357,0.0013697,-0.24286,-0.0023715,0.45961,0.26522,-0.00071889,0.16995,-0.12178,-0.25552},
      {0.00074571,0.00071777,-0.25639,-0.0018049,0.44711,0.25803,-2.27E-05,0.17995,-0.12843,-0.24352},
      {0.0010937,0.00031651,-0.26348,-0.0012542,0.44075,0.25439,0.00052684,0.18539,-0.1317,-0.23742},
      {0.0013006,0.00010806,-0.2649,-0.00091202,0.43977,0.25384,0.00083234,0.18667,-0.13222,-0.23646},
      {0.0012434,5.27E-06,-0.26293,-0.00074773,0.44211,0.25522,0.00087028,0.18539,-0.13123,-0.23868},
      {0.00079922,-2.42E-07,-0.26612,-0.000519,0.43962,0.25379,0.00056222,0.18781,-0.13293,-0.23629},
      {0.4092,0.012084,0.10634,-0.021038,-0.00061107,-0.0017682,0.25149,0.059458,0.20437,0.17234},
      {0.41141,0.014725,0.096101,-0.020901,-0.00089029,-0.001524,0.23992,0.051345,0.2165,0.17234},
      {0.40541,0.021049,0.082757,-0.021898,-0.0010107,-0.0012416,0.21683,0.040756,0.22899,0.17163},
      {0.39138,0.031706,0.065629,-0.023739,-0.00089847,-0.00091364,0.18235,0.027424,0.2424,0.17011},
      {0.37529,0.045386,0.041178,-0.025286,-0.00073772,-0.0005666,0.13998,0.0090941,0.26222,0.168},
      {0.32789,0.081223,0.022101,-0.029759,0.005012,0.0021836,0.068294,-0.0070551,0.26201,0.16114},
      {0.25608,0.14002,0.0087,-0.032555,0.016469,0.0074246,-0.025864,-0.017121,0.24599,0.14974},
      {0.18366,0.2098,-0.0085286,-0.029026,0.029955,0.013649,-0.12412,-0.024801,0.23521,0.13669},
      {0.11115,0.26723,-0.027717,-0.013234,0.073144,0.035768,-0.19327,-0.016931,0.20026,0.095964},
      {0.054746,0.31404,-0.051302,-0.0010373,0.11336,0.05617,-0.23663,-0.0046584,0.16298,0.058937},
      {0.016879,0.34564,-0.077219,0.0090877,0.15008,0.077154,-0.25788,0.011932,0.13017,0.027369},
      {0.0092503,0.30565,-0.094402,0.015771,0.20754,0.11109,-0.22613,0.031268,0.096447,-0.025376},
      {0.0042879,0.2664,-0.11031,0.019487,0.26295,0.14488,-0.19435,0.050702,0.066896,-0.07545},
      {0.0015594,0.2277,-0.12569,0.019071,0.31283,0.17618,-0.16338,0.069233,0.040206,-0.11975},
      {0.0010015,0.19168,-0.12774,0.017814,0.35226,0.19943,-0.13691,0.071835,0.020749,-0.15665},
      {0.00074742,0.15454,-0.12842,0.014777,0.39374,0.22371,-0.11024,0.074599,0.0028874,-0.19584},
      {0.00050543,0.11474,-0.13116,0.010434,0.43802,0.25019,-0.081839,0.080152,-0.016247,-0.23726},
      {0.00028317,0.074951,-0.13571,0.005406,0.48231,0.27724,-0.053574,0.088126,-0.035349,-0.27827},
      {0.00021461,0.059453,-0.1436,0.0015378,0.49532,0.28472,-0.042503,0.097236,-0.04469,-0.29069},
      {0.00015606,0.044872,-0.16252,0.00069459,0.49129,0.28232,-0.032168,0.11071,-0.061438,-0.28687},
      {0.00010019,0.032103,-0.1797,-0.00017084,0.48785,0.28054,-0.023117,0.12326,-0.076186,-0.2834},
      {4.99E-05,0.021107,-0.19304,-0.0010068,0.48723,0.28073,-0.015298,0.1334,-0.087925,-0.28233},
      {4.76E-05,0.016183,-0.21233,-0.0016042,0.47388,0.2731,-0.011767,0.14763,-0.099641,-0.26948},
      {6.33E-05,0.011995,-0.22846,-0.0021509,0.46318,0.26695,-0.0087335,0.15982,-0.10927,-0.25921},
      {0.00010591,0.0072019,-0.24523,-0.0024037,0.45112,0.26003,-0.0052351,0.17154,-0.12018,-0.24764},
      {0.00017731,0.0032985,-0.2572,-0.0024813,0.4432,0.25557,-0.0023414,0.17999,-0.12815,-0.23995},
      {0.00030985,0.0014829,-0.27458,-0.0021241,0.42815,0.24704,-0.00090119,0.19257,-0.13751,-0.22541},
      {0.00060292,0.00080312,-0.28855,-0.0016186,0.41519,0.23958,-0.00018883,0.20284,-0.14443,-0.21298},
      {0.00094288,0.00037874,-0.29599,-0.001121,0.40846,0.23573,0.00037412,0.20849,-0.14792,-0.20652},
      {0.0011009,0.00016053,-0.29715,-0.00087455,0.40768,0.23528,0.00065154,0.2095,-0.14839,-0.20576},
      {0.0010744,4.39E-05,-0.29468,-0.00071785,0.41049,0.23692,0.00072138,0.20786,-0.14715,-0.20843},
      {0.00086978,-3.53E-07,-0.29256,-0.00052298,0.4131,0.23847,0.00061195,0.2065,-0.14611,-0.2109},
      {0.29691,0.00066321,0.24739,-0.01327,-0.0020922,-0.0030311,0.17202,0.16616,0.071731,0.17247},
      {0.30159,0.0017092,0.22788,-0.013406,-0.0025157,-0.0029643,0.16104,0.15149,0.091537,0.17189},
      {0.30902,0.003076,0.1969,-0.013577,-0.0031792,-0.002946,0.14477,0.12836,0.12264,0.17089},
      {0.31912,0.0048056,0.15308,-0.013762,-0.0040829,-0.0030535,0.12312,0.095935,0.16601,0.1693},
      {0.30799,0.020194,0.12147,-0.014947,-0.0037006,-0.0026293,0.084458,0.072708,0.19259,0.16709},
      {0.29582,0.038651,0.081128,-0.015527,-0.0032458,-0.0021119,0.03856,0.043676,0.22721,0.16433},
      {0.26623,0.073808,0.041513,-0.015351,0.00027486,-0.0029641,-0.023482,0.016592,0.25295,0.15702},
      {0.19443,0.15183,0.022,-0.014221,0.013805,-0.0015413,-0.11231,0.0091351,0.23617,0.14155},
      {0.12965,0.23691,-0.0073556,-0.011401,0.027557,0.00036347,-0.19531,0.00024963,0.22597,0.12668},
      {0.076849,0.30059,-0.037143,-0.0030144,0.057134,0.013939,-0.24683,0.0036465,0.20267,0.099496},
      {0.038982,0.33818,-0.064118,0.0067673,0.094529,0.035533,-0.26781,0.020015,0.16937,0.068016},
      {0.013764,0.36907,-0.091899,0.016231,0.12555,0.056665,-0.27759,0.038157,0.14222,0.044877},
      {0.0058594,0.34557,-0.10959,0.020283,0.17417,0.086841,-0.25368,0.055263,0.11361,0.0024445},
      {0.003565,0.29899,-0.12529,0.019492,0.22242,0.11532,-0.21676,0.068777,0.079392,-0.041728},
      {0.0018126,0.25166,-0.14547,0.017374,0.26742,0.14485,-0.18017,0.085856,0.044044,-0.080581},
      {0.0010354,0.20729,-0.15733,0.013931,0.31141,0.17302,-0.1475,0.097266,0.016542,-0.11977},
      {0.00078261,0.16443,-0.16038,0.0093188,0.35874,0.20111,-0.1169,0.10327,-0.0041431,-0.1642},
      {0.00053558,0.11949,-0.1651,0.0040658,0.40856,0.23141,-0.084979,0.11162,-0.025755,-0.21043},
      {0.00029406,0.071789,-0.1852,0.0022792,0.44084,0.25219,-0.051314,0.12724,-0.058789,-0.23945},
      {0.00021802,0.054138,-0.20819,0.0014267,0.43588,0.24935,-0.038842,0.14357,-0.079113,-0.23464},
      {0.00015517,0.040353,-0.22599,0.00045372,0.43282,0.24773,-0.029065,0.15655,-0.094692,-0.23157},
      {9.85E-05,0.028409,-0.23986,-0.00048017,0.4326,0.24811,-0.020568,0.16705,-0.10719,-0.23093},
      {5.13E-05,0.018294,-0.25072,-0.0011999,0.43417,0.24989,-0.013351,0.17562,-0.11712,-0.2317},
      {5.89E-05,0.012762,-0.26899,-0.0016857,0.42207,0.24303,-0.0093571,0.18881,-0.12887,-0.22},
      {9.64E-05,0.007849,-0.2861,-0.0019813,0.40976,0.23595,-0.0057681,0.20074,-0.14003,-0.2082},
      {0.00015905,0.0043199,-0.30178,-0.0019975,0.39783,0.22917,-0.0031396,0.21186,-0.14964,-0.19669},
      {0.00024137,0.0021176,-0.31716,-0.0017725,0.38517,0.22206,-0.001438,0.22294,-0.15831,-0.1844},
      {0.00041635,0.00086679,-0.33024,-0.0014166,0.37383,0.21568,-0.00037009,0.23248,-0.16522,-0.1734},
      {0.00074797,0.00042679,-0.33786,-0.00097649,0.36689,0.2117,0.00020162,0.23822,-0.16884,-0.16673},
      {0.00087198,0.00020787,-0.33794,-0.00083239,0.36706,0.21178,0.00045337,0.23838,-0.16886,-0.16691},
      {0.00088078,7.81E-05,-0.33462,-0.00068487,0.37068,0.21388,0.00055798,0.23613,-0.16718,-0.17037},
      {0.00079381,1.32E-05,-0.32966,-0.0005079,0.37603,0.21702,0.00054745,0.23275,-0.16469,-0.17545},
      {0.17018,-0.0052271,0.43505,-0.0064944,-0.0023601,-0.0034478,0.095436,0.30444,-0.10408,0.17512},
      {0.17558,-0.0055381,0.41604,-0.0065174,-0.0027423,-0.0036914,0.088298,0.29028,-0.085359,0.17427},
      {0.18537,-0.0045685,0.37846,-0.0067437,-0.0033789,-0.004344,0.074855,0.2627,-0.049107,0.17256},
      {0.19743,-0.0033528,0.32917,-0.0069261,-0.0042305,-0.0058137,0.057147,0.22662,-0.0020216,0.16979},
      {0.2106,-0.0019307,0.27002,-0.0069563,-0.0052772,-0.008571,0.035546,0.18347,0.05375,0.1656},
      {0.20718,0.015269,0.21709,-0.0070411,-0.0050855,-0.01207,-0.0014936,0.14572,0.09909,0.15986},
      {0.19461,0.046553,0.15873,-0.0067392,-0.0040272,-0.016947,-0.051631,0.10532,0.14592,0.15205},
      {0.18208,0.085395,0.085008,-0.0056328,-0.0027925,-0.024145,-0.10908,0.055088,0.20522,0.14165},
      {0.12994,0.17028,0.047152,-0.0028175,0.010219,-0.022281,-0.18055,0.040929,0.20467,0.12799},
      {0.083258,0.26415,0.0029565,0.00251,0.023067,-0.018472,-0.24572,0.027717,0.20663,0.1152},
      {0.045844,0.34706,-0.042905,0.010758,0.04185,-0.009139,-0.29463,0.020971,0.20568,0.099922},
      {0.024975,0.37247,-0.070119,0.017091,0.071775,0.0069347,-0.29633,0.036458,0.17686,0.075258},
      {0.011801,0.39038,-0.098141,0.019693,0.092782,0.020217,-0.29306,0.051525,0.15154,0.0611},
      {0.0051534,0.37951,-0.12224,0.019726,0.12402,0.043955,-0.27577,0.067526,0.12411,0.039272},
      {0.0033485,0.32835,-0.14328,0.016851,0.17349,0.075874,-0.23611,0.085763,0.086532,-0.0038725},
      {0.0019612,0.27566,-0.17049,0.012861,0.21894,0.10857,-0.19643,0.10886,0.046641,-0.040892},
      {0.0011067,0.22318,-0.19596,0.0078192,0.26331,0.14117,-0.15824,0.13129,0.0094995,-0.076885},
      {0.00081711,0.17069,-0.20918,0.0049664,0.30766,0.16751,-0.12107,0.14296,-0.021981,-0.11856},
      {0.00053343,0.11766,-0.23481,0.0039543,0.33827,0.18698,-0.083708,0.16167,-0.06101,-0.14628},
      {0.00031317,0.070645,-0.26454,0.0024094,0.36067,0.20331,-0.050618,0.18375,-0.098666,-0.16482},
      {0.0002127,0.048606,-0.28569,0.0011208,0.36401,0.20653,-0.035045,0.19937,-0.11985,-0.16691},
      {0.00014841,0.035737,-0.29944,2.77E-05,0.36489,0.20751,-0.025882,0.2098,-0.13273,-0.16735},
      {9.42E-05,0.024743,-0.31017,-0.00083635,0.36749,0.20985,-0.018032,0.21829,-0.14304,-0.16914},
      {5.45E-05,0.014198,-0.32249,-0.0012017,0.36692,0.21061,-0.010476,0.22696,-0.15461,-0.16767},
      {7.35E-05,0.0083625,-0.33886,-0.0015065,0.35663,0.205,-0.0062279,0.23839,-0.16587,-0.15756},
      {0.00012703,0.005254,-0.35603,-0.0015088,0.34283,0.19714,-0.0038937,0.25057,-0.17601,-0.14425},
      {0.00020222,0.0029309,-0.36941,-0.0013799,0.3322,0.19119,-0.0020974,0.26017,-0.1838,-0.13393},
      {0.00029826,0.0012901,-0.38104,-0.0011524,0.32278,0.186,-0.00077952,0.2686,-0.1903,-0.1247},
      {0.00047338,0.00046703,-0.38926,-0.00089774,0.31577,0.18213,-2.35E-05,0.27462,-0.19461,-0.11783},
      {0.00062403,0.00024121,-0.38783,-0.00078832,0.31737,0.18303,0.0002515,0.27368,-0.19388,-0.1194},
      {0.00067127,0.00010091,-0.38318,-0.00065148,0.32226,0.18584,0.00039132,0.27049,-0.19154,-0.12409},
      {0.000619,2.77E-05,-0.37687,-0.00048514,0.32892,0.18972,0.00041171,0.26614,-0.18836,-0.13043},
      {0.063255,-0.0011039,0.58826,-0.0022554,-0.0015739,-0.0034531,0.027661,0.41568,-0.2467,0.17844},
      {0.065929,-0.0027292,0.58164,-0.0021387,-0.0017989,-0.0039916,0.026582,0.41064,-0.2403,0.17768},
      {0.069363,-0.00497,0.57246,-0.0019685,-0.0021209,-0.0048566,0.024834,0.40368,-0.23151,0.17652},
      {0.079867,-0.0049772,0.53295,-0.0019596,-0.0028081,-0.0073319,0.014314,0.37485,-0.19476,0.17319},
      {0.094016,-0.0036304,0.47367,-0.0018882,-0.0037571,-0.011598,-0.0026103,0.33185,-0.14025,0.1678},
      {0.10812,-0.0019054,0.4086,-0.0015796,-0.0048771,-0.017546,-0.02167,0.28487,-0.081416,0.16067},
      {0.11592,0.013115,0.33746,-0.00097327,-0.0054895,-0.024466,-0.050273,0.23469,-0.020361,0.15139},
      {0.11273,0.054876,0.25105,0.00042378,-0.0048175,-0.03185,-0.10045,0.17587,0.04993,0.13981},
      {0.10891,0.10341,0.15209,0.002967,-0.0043027,-0.041199,-0.15744,0.10927,0.13014,0.12597},
      {0.083169,0.18432,0.081701,0.0074189,0.0042315,-0.047474,-0.21317,0.073834,0.16387,0.11005},
      {0.053927,0.27491,0.022062,0.011124,0.014594,-0.059888,-0.25767,0.053196,0.17585,0.0909},
      {0.031662,0.36377,-0.044291,0.014387,0.022198,-0.067817,-0.30184,0.030142,0.19746,0.079472},
      {0.019296,0.38401,-0.073581,0.01636,0.044224,-0.052262,-0.29898,0.044776,0.17371,0.066365},
      {0.010232,0.40401,-0.10375,0.017032,0.060117,-0.030755,-0.29912,0.062162,0.15422,0.066332},
      {0.0045156,0.41455,-0.13471,0.015816,0.075156,-0.0026061,-0.29729,0.082216,0.13621,0.07172},
      {0.0031293,0.35844,-0.16278,0.011162,0.12446,0.032419,-0.25491,0.10632,0.094319,0.031221},
      {0.0019841,0.29144,-0.20448,0.0083456,0.16584,0.064084,-0.2065,0.13812,0.040238,-0.0011662},
      {0.0010324,0.21992,-0.2649,0.0075879,0.19279,0.092855,-0.15579,0.18115,-0.026061,-0.015558},
      {0.00072759,0.16287,-0.2887,0.005906,0.23,0.11614,-0.11557,0.19901,-0.065901,-0.049572},
      {0.00048686,0.11204,-0.3165,0.0038395,0.25863,0.13597,-0.079777,0.22005,-0.10427,-0.074159},
      {0.00030215,0.068068,-0.34901,0.001843,0.27702,0.15148,-0.048852,0.24451,-0.14144,-0.08765},
      {0.00019443,0.042473,-0.37293,0.00037727,0.28352,0.1585,-0.030801,0.2625,-0.16544,-0.091137},
      {0.00013592,0.029904,-0.38251,-0.00038012,0.28798,0.16176,-0.021818,0.26963,-0.17636,-0.094823},
      {9.03E-05,0.01866,-0.39187,-0.00076807,0.291,0.16453,-0.013751,0.27618,-0.18683,-0.096861},
      {5.37E-05,0.010343,-0.40538,-0.00096534,0.28761,0.16418,-0.0077464,0.28577,-0.19782,-0.092277},
      {7.64E-05,0.0059908,-0.41988,-0.0010494,0.27834,0.15955,-0.0045234,0.29605,-0.2073,-0.082804},
      {0.00014487,0.0035886,-0.43039,-0.0010107,0.27059,0.15523,-0.002657,0.30356,-0.21375,-0.075257},
      {0.00023456,0.0018665,-0.43935,-0.00086727,0.26385,0.15157,-0.0012684,0.31004,-0.21902,-0.068607},
      {0.00029645,0.00076577,-0.44528,-0.00079274,0.2594,0.14926,-0.0003826,0.3143,-0.22249,-0.064136},
      {0.00036972,0.00025172,-0.44714,-0.00074613,0.25825,0.14879,6.14E-05,0.31565,-0.22364,-0.062881},
      {0.00045695,0.00010559,-0.4406,-0.00062129,0.26498,0.15265,0.00023423,0.31112,-0.22033,-0.06934},
      {0.00043345,4.30E-05,-0.43123,-0.00046735,0.27462,0.15823,0.00026814,0.3046,-0.21561,-0.07856},
      {0.014593,0.0028241,0.6684,-0.00056299,-0.00069967,-0.0025783,0.0018165,0.47269,-0.31993,0.18126},
      {0.017204,0.0020418,0.66218,-0.00055738,-0.00086544,-0.0032728,0.0018591,0.46814,-0.31437,0.18041},
      {0.02062,0.0010347,0.65368,-0.00053638,-0.0011005,-0.004358,0.0017599,0.46193,-0.30686,0.17914},
      {0.024242,2.02E-05,0.64394,-0.00048456,-0.0013863,-0.0058892,0.0013411,0.45482,-0.29841,0.17741},
      {0.029565,-0.00015622,0.62368,-0.00031901,-0.0018774,-0.008787,-0.0025631,0.44018,-0.28076,0.17413},
      {0.041248,0.0021692,0.56698,0.00026859,-0.0030447,-0.015764,-0.017846,0.39953,-0.23091,0.16601},
      {0.051113,0.0053741,0.50973,0.0011468,-0.0042556,-0.025054,-0.034464,0.35862,-0.1817,0.15585},
      {0.060124,0.012604,0.44357,0.0019281,-0.0053403,-0.040635,-0.053266,0.31192,-0.12748,0.14002},
      {0.062635,0.058644,0.33153,0.0035433,-0.0051006,-0.065286,-0.10066,0.23658,-0.040738,0.11448},
      {0.063223,0.10927,0.21166,0.0054059,-0.0050071,-0.1031,-0.14796,0.15706,0.047297,0.078763},
      {0.053504,0.17904,0.11078,0.0079279,-0.0011919,-0.13515,-0.1933,0.098753,0.10794,0.047583},
      {0.035196,0.26939,0.040958,0.010755,0.0062993,-0.13942,-0.23741,0.073396,0.13527,0.040119},
      {0.022054,0.357,-0.032458,0.012764,0.011259,-0.13817,-0.28188,0.047858,0.16973,0.040317},
      {0.013692,0.39693,-0.076385,0.013084,0.023155,-0.11881,-0.29563,0.053247,0.16855,0.044655},
      {0.0079504,0.4177,-0.10932,0.011764,0.033402,-0.088593,-0.2999,0.073859,0.15423,0.059156},
      {0.004193,0.41923,-0.14806,0.012082,0.040021,-0.056451,-0.29736,0.09722,0.1322,0.078469},
      {0.0027099,0.3514,-0.19462,0.01109,0.077391,-0.024969,-0.24886,0.13,0.074355,0.051667},
      {0.0017377,0.27636,-0.25453,0.0093832,0.10945,0.0067364,-0.19564,0.17329,0.0069855,0.032402},
      {0.00096715,0.20672,-0.32822,0.0073811,0.12915,0.039809,-0.14642,0.22654,-0.064127,0.031893},
      {0.00060552,0.14967,-0.37085,0.0047664,0.15637,0.065883,-0.10621,0.25838,-0.11281,0.014567},
      {0.00040739,0.10233,-0.40153,0.0021751,0.18058,0.084746,-0.0729,0.28192,-0.15049,-0.0044981},
      {0.00026058,0.062329,-0.43633,0.00051504,0.19363,0.098653,-0.044797,0.3078,-0.1869,-0.011658},
      {0.00017121,0.033868,-0.46428,0.00011702,0.19955,0.10778,-0.024775,0.32765,-0.21498,-0.012584},
      {0.00011364,0.022832,-0.46808,-0.000254,0.20821,0.11404,-0.01683,0.33029,-0.22258,-0.019829},
      {7.01E-05,0.01425,-0.47536,-0.00050193,0.21138,0.11751,-0.010613,0.33546,-0.23062,-0.021499},
      {4.21E-05,0.0077299,-0.48767,-0.00064867,0.2077,0.11726,-0.0058519,0.34424,-0.24011,-0.016424},
      {6.48E-05,0.0040056,-0.49937,-0.00069092,0.2011,0.11462,-0.0030503,0.35257,-0.24787,-0.0091418},
      {0.0001464,0.0022547,-0.50421,-0.00063412,0.19841,0.11326,-0.0016306,0.35608,-0.25115,-0.0064026},
      {0.00019847,0.001114,-0.50339,-0.00064839,0.20054,0.11463,-0.00073412,0.3555,-0.25133,-0.0083223},
      {0.0002237,0.00041027,-0.50559,-0.00064559,0.1994,0.11429,-0.00017506,0.35706,-0.25279,-0.0069649},
      {0.00024744,9.85E-05,-0.50602,-0.00059588,0.19966,0.11477,8.93E-05,0.35739,-0.25314,-0.0069355},
      {0.00026073,5.48E-05,-0.49187,-0.00044839,0.21399,0.12302,0.00013665,0.34749,-0.246,-0.020674},
      {0.0023119,0.0041834,0.69524,-0.00042261,-0.00010986,-0.0011645,-0.0012007,0.49174,-0.344,0.18341},
      {0.0036061,0.0038656,0.6914,-0.00039862,-0.00022335,-0.002045,-0.0013325,0.48896,-0.3408,0.18249},
      {0.0054356,0.0034106,0.68581,-0.00036206,-0.00038892,-0.0034393,-0.0015506,0.4849,-0.33619,0.18106},
      {0.0076562,0.0028498,0.67867,-0.00031245,-0.00059978,-0.0054449,-0.001877,0.47972,-0.33038,0.17904},
      {0.010045,0.0022374,0.67035,-0.00025003,-0.00084277,-0.0081793,-0.0023307,0.4737,-0.32377,0.17636},
      {0.012336,0.0016483,0.66133,-0.00017587,-0.0010996,-0.011791,-0.0029207,0.46718,-0.31683,0.17292},
      {0.019984,0.0036886,0.61167,0.00038966,-0.0021333,-0.026242,-0.014592,0.43183,-0.27665,0.15886},
      {0.026586,0.0070354,0.55717,0.0010499,-0.0031884,-0.046811,-0.027201,0.39318,-0.23447,0.13964},
      {0.030969,0.011962,0.5031,0.0017408,-0.0040941,-0.073884,-0.03902,0.35502,-0.19532,0.11526},
      {0.032501,0.060117,0.38578,0.0035067,-0.0040668,-0.11823,-0.080633,0.27735,-0.11131,0.075231},
      {0.032377,0.11767,0.25555,0.0054411,-0.003831,-0.17669,-0.12451,0.1923,-0.021923,0.024389},
      {0.02888,0.18496,0.13147,0.0073777,-0.0023977,-0.23519,-0.1669,0.11583,0.057156,-0.025243},
      {0.019057,0.27295,0.055869,0.0089964,0.0022165,-0.22965,-0.21145,0.088986,0.096188,-0.020768},
      {0.013115,0.3518,-0.021315,0.010247,0.0048591,-0.21875,-0.2546,0.062835,0.13854,-0.010628},
      {0.0096529,0.37651,-0.076145,0.011119,0.010386,-0.20496,-0.27,0.055871,0.14972,-0.0051314},
      {0.0062299,0.37123,-0.11585,0.01149,0.018267,-0.17254,-0.26437,0.079369,0.12507,0.01222},
      {0.0036253,0.36882,-0.16441,0.011551,0.02258,-0.12849,-0.26124,0.11022,0.09818,0.04405},
      {0.0022062,0.32651,-0.22462,0.0099221,0.041205,-0.085732,-0.23077,0.15252,0.046934,0.053576},
      {0.0014368,0.25422,-0.29878,0.007104,0.064415,-0.050111,-0.17966,0.20664,-0.025342,0.050156},
      {0.00082307,0.18685,-0.38593,0.0041648,0.076286,-0.012813,-0.13219,0.27005,-0.10135,0.064289},
      {0.00045345,0.1299,-0.45384,0.0013415,0.089759,0.018364,-0.092147,0.31991,-0.16238,0.070907},
      {0.00030737,0.087066,-0.48098,0.00092291,0.11142,0.036997,-0.062079,0.33928,-0.19714,0.055269},
      {0.00019815,0.052092,-0.51094,0.00055572,0.12436,0.052908,-0.037522,0.36064,-0.22937,0.049892},
      {0.00011873,0.025902,-0.54356,0.00020992,0.12685,0.063935,-0.019114,0.38387,-0.25856,0.055468},
      {7.11E-05,0.017051,-0.54436,-0.00010148,0.13681,0.071342,-0.012679,0.38444,-0.26354,0.047305},
      {3.86E-05,0.010213,-0.55057,-0.00031054,0.13959,0.074827,-0.0076695,0.38889,-0.27017,0.046212},
      {1.97E-05,0.0052717,-0.56277,-0.00042262,0.13467,0.074087,-0.0040042,0.39759,-0.27882,0.052659},
      {3.71E-05,0.0024088,-0.57058,-0.00047596,0.13138,0.073753,-0.0018564,0.40313,-0.2842,0.057113},
      {0.00010056,0.0012522,-0.56451,-0.00050012,0.1387,0.078063,-0.00093549,0.39883,-0.28177,0.050167},
      {0.00013679,0.00052334,-0.56181,-0.00050698,0.14242,0.080471,-0.00034592,0.39691,-0.28079,0.046821},
      {0.00013403,0.00023503,-0.55894,-0.00048524,0.14607,0.083011,-0.00010391,0.39489,-0.27952,0.043685},
      {0.00011451,6.19E-05,-0.55774,-0.00042741,0.14803,0.08467,2.80E-05,0.39409,-0.279,0.042243},
      {0.00065885,0.0025497,0.69876,-0.00087536,7.19E-07,-0.0017996,-0.00041012,0.49367,-0.34747,0.183},
      {0.00087038,0.0025982,0.69853,-0.00072274,-1.11E-06,-0.0020598,-0.00044837,0.49362,-0.34723,0.18277},
      {0.0011805,0.0026629,0.69819,-0.00048438,-3.36E-06,-0.002482,-0.00050198,0.49355,-0.34689,0.1824},
      {0.0022857,0.0024437,0.69351,-0.00038465,-0.00012888,-0.0047326,-0.00084526,0.49023,-0.34339,0.18031},
      {0.0036665,0.0021609,0.68675,-0.0003218,-0.00030353,-0.0082327,-0.0013455,0.48538,-0.3385,0.17709},
      {0.0050148,0.0019454,0.67906,-0.00024843,-0.00048496,-0.0128,-0.0019235,0.47988,-0.33316,0.17296},
      {0.006182,0.0018739,0.67067,-0.00016704,-0.00065471,-0.01862,-0.0025423,0.4739,-0.32764,0.16779},
      {0.0090368,0.0052903,0.6348,0.00027045,-0.0012074,-0.038558,-0.0095297,0.44859,-0.30239,0.15005},
      {0.011724,0.012098,0.58375,0.00090367,-0.0018089,-0.070822,-0.01915,0.41272,-0.268,0.12187},
      {0.012905,0.021483,0.53138,0.0015476,-0.0021748,-0.11105,-0.027439,0.37606,-0.23547,0.087459},
      {0.013284,0.066994,0.42105,0.0031464,-0.0020596,-0.173,-0.058029,0.3034,-0.16331,0.034776},
      {0.013004,0.12843,0.28004,0.0050922,-0.0014848,-0.25477,-0.097025,0.2117,-0.072517,-0.033525},
      {0.013895,0.17433,0.13056,0.0066481,-0.0016551,-0.35283,-0.13131,0.11256,0.021588,-0.11592},
      {0.011158,0.22986,0.051196,0.007833,0.00034548,-0.34916,-0.16874,0.079578,0.067102,-0.11363},
      {0.0088787,0.27904,-0.013941,0.0087503,0.0018736,-0.3371,-0.20137,0.056886,0.10276,-0.10349},
      {0.0069634,0.31298,-0.066557,0.0091404,0.003846,-0.31739,-0.2233,0.049146,0.12127,-0.08785},
      {0.0045802,0.31205,-0.11704,0.0087125,0.008579,-0.26865,-0.22123,0.081724,0.094581,-0.052685},
      {0.0028214,0.31288,-0.17699,0.00756,0.010575,-0.2083,-0.22088,0.12233,0.064868,-0.0043376},
      {0.0017121,0.29463,-0.24897,0.0051222,0.016159,-0.14625,-0.20764,0.1735,0.020615,0.03976},
      {0.0011116,0.22498,-0.33667,0.0018543,0.030552,-0.10688,-0.15858,0.23748,-0.056624,0.051981},
      {0.00063083,0.15921,-0.42891,0.0016064,0.038502,-0.064276,-0.11252,0.30252,-0.13553,0.075958},
      {0.00030153,0.10378,-0.515,0.0013892,0.046603,-0.016157,-0.073674,0.36326,-0.20615,0.10428},
      {0.00019289,0.06797,-0.54028,0.00096326,0.065578,0.0037796,-0.048528,0.38136,-0.23645,0.093571},
      {0.00011208,0.040378,-0.56919,0.00055923,0.073571,0.018338,-0.029133,0.402,-0.26445,0.094173},
      {5.45E-05,0.020375,-0.60054,0.00020769,0.072143,0.028146,-0.015036,0.42433,-0.28992,0.10436},
      {1.82E-05,0.011432,-0.60937,-5.59E-05,0.076469,0.034819,-0.0085639,0.43064,-0.29886,0.10369},
      {7.62E-08,0.0064465,-0.61357,-0.00021488,0.079515,0.038623,-0.0048712,0.43366,-0.30355,0.10247},
      {4.64E-07,0.0032729,-0.61764,-0.00030026,0.080644,0.041293,-0.0025398,0.43653,-0.30724,0.10306},
      {8.37E-06,0.0011572,-0.62639,-0.00035099,0.076101,0.040779,-0.00096373,0.4427,-0.3127,0.10916},
      {5.30E-05,0.00068644,-0.61298,-0.0003582,0.090197,0.049088,-0.00054024,0.43321,-0.30625,0.095804},
      {6.56E-05,0.00039915,-0.6046,-0.00034722,0.099253,0.054664,-0.00028499,0.42729,-0.30222,0.087421},
      {5.18E-05,0.00018835,-0.60247,-0.00031633,0.10222,0.056962,-0.00011705,0.4258,-0.30127,0.085063},
      {-1.35E-05,0.0014127,0.69972,-0.0015916,4.50E-05,-0.0023874,0.00014343,0.49371,-0.34904,0.18252},
      {0.00014252,0.0014279,0.69948,-0.0014091,4.50E-05,-0.0027803,0.0001256,0.49367,-0.34881,0.18218},
      {0.00037395,0.0014466,0.6991,-0.001127,4.53E-05,-0.0034071,0.0001022,0.4936,-0.34845,0.18164},
      {0.00067318,0.0014766,0.69844,-0.0007757,4.70E-05,-0.0043698,7.07E-05,0.49339,-0.34791,0.18082},
      {0.0010983,0.0015147,0.6966,-0.00039658,3.04E-05,-0.0062978,-3.09E-05,0.49235,-0.34661,0.17915},
      {0.0018543,0.0016763,0.68928,-0.00035474,-8.47E-05,-0.012145,-0.0004822,0.48715,-0.34212,0.17404},
      {0.0025399,0.0020193,0.68078,-0.00027635,-0.00018839,-0.019664,-0.00091593,0.48114,-0.33713,0.16753},
      {0.0030736,0.0026141,0.67107,-0.00015137,-0.00025819,-0.029194,-0.0012807,0.47433,-0.33173,0.15939},
      {0.0038103,0.0071538,0.6408,0.00021965,-0.0004338,-0.055385,-0.0046882,0.45312,-0.31389,0.13712},
      {0.0049515,0.015992,0.57415,0.00081407,-0.00087617,-0.11348,-0.012173,0.40637,-0.27486,0.087856},
      {0.0057697,0.024629,0.49509,0.0013717,-0.0013287,-0.18701,-0.019527,0.35091,-0.23006,0.025829},
      {0.0066467,0.05213,0.37809,0.0024274,-0.0015871,-0.27579,-0.040468,0.27168,-0.15913,-0.048797},
      {0.0074409,0.093468,0.23947,0.0038031,-0.0016637,-0.36972,-0.071047,0.17953,-0.072554,-0.1274},
      {0.0076975,0.12733,0.11162,0.0048161,-0.0017071,-0.46534,-0.095691,0.094079,0.0048467,-0.20694},
      {0.0065064,0.16999,0.03663,0.005503,-0.00064176,-0.47765,-0.12425,0.059238,0.047707,-0.21678},
      {0.005294,0.21165,-0.013101,0.0056573,0.00037213,-0.45752,-0.1515,0.046808,0.074267,-0.19922},
      {0.004492,0.24558,-0.051957,0.0050266,0.00086696,-0.43573,-0.1735,0.041319,0.093506,-0.17996},
      {0.0030311,0.24973,-0.11253,0.0034326,0.0028676,-0.37305,-0.17549,0.081158,0.066718,-0.12966},
      {0.0019659,0.25226,-0.18356,0.0018604,0.00348,-0.29531,-0.17712,0.1308,0.033164,-0.065526},
      {0.0012595,0.24814,-0.26273,0.0020275,0.0041426,-0.21012,-0.17458,0.18563,-0.0083648,0.0042484},
      {0.00081585,0.18142,-0.35562,0.0017703,0.015233,-0.16236,-0.12784,0.25115,-0.088048,0.027988},
      {0.00045381,0.12441,-0.45232,0.0015113,0.021416,-0.10731,-0.087905,0.31939,-0.16476,0.064811},
      {0.00017297,0.077067,-0.55213,0.0012611,0.023323,-0.044773,-0.05474,0.38984,-0.23816,0.11399},
      {7.62E-05,0.047827,-0.58813,0.00082162,0.032881,-0.021342,-0.034198,0.4155,-0.27052,0.11971},
      {2.00E-05,0.027172,-0.61617,0.00041087,0.035732,-0.0087682,-0.019644,0.43553,-0.29463,0.12604},
      {-1.91E-05,0.013147,-0.64522,9.31E-05,0.031246,-9.49E-05,-0.0097027,0.45619,-0.31599,0.13968},
      {-2.47E-05,0.0069192,-0.65344,-3.79E-05,0.035347,0.0088696,-0.0052655,0.46199,-0.32319,0.14123},
      {-2.23E-05,0.0038025,-0.65267,-0.00013449,0.041232,0.014247,-0.0029706,0.46143,-0.32443,0.13724},
      {-1.41E-05,0.0020559,-0.65241,-0.00019269,0.045389,0.018792,-0.001643,0.46123,-0.32522,0.13503},
      {-5.35E-06,0.00093359,-0.65562,-0.00021727,0.045634,0.021301,-0.00076972,0.46348,-0.32741,0.13676},
      {1.48E-05,0.0005431,-0.64657,-0.00021848,0.055786,0.02786,-0.00043275,0.45708,-0.32309,0.12762},
      {1.40E-05,0.00032706,-0.63989,-0.00019945,0.063203,0.032636,-0.00025079,0.45237,-0.31987,0.12093},
      {-0.00041112,0.0007812,0.69896,-0.0032695,8.66E-05,-0.0025828,0.00046381,0.49196,-0.34996,0.18233},
      {-0.0003015,0.00079483,0.69846,-0.0030432,8.80E-05,-0.0033312,0.0004498,0.49177,-0.34958,0.1817},
      {-0.00013636,0.0008129,0.6976,-0.0026977,9.03E-05,-0.0045859,0.00042881,0.49142,-0.34895,0.18063},
      {8.43E-05,0.0008323,0.69623,-0.0022278,9.37E-05,-0.0065235,0.00040094,0.4908,-0.34802,0.179},
      {0.00035624,0.00084837,0.69417,-0.0016347,9.86E-05,-0.0093796,0.00036689,0.48979,-0.34667,0.17659},
      {0.0006718,0.00085548,0.69114,-0.00092733,0.00010535,-0.013457,0.00032785,0.48819,-0.3448,0.17317},
      {0.0010849,0.0011457,0.67987,-0.00062565,4.70E-05,-0.025412,2.33E-05,0.48046,-0.33869,0.16306},
      {0.0015184,0.0015273,0.66239,-0.00044342,-3.52E-05,-0.044022,-0.00039245,0.46825,-0.32943,0.14737},
      {0.0019248,0.001892,0.63954,-0.00023457,-0.00011595,-0.068912,-0.00082946,0.45226,-0.3175,0.12646},
      {0.0023655,0.0041463,0.59849,6.33E-05,-0.00027806,-0.11123,-0.0028612,0.42349,-0.29543,0.090906},
      {0.00289,0.011905,0.51337,0.00054646,-0.00067602,-0.19424,-0.0094266,0.36375,-0.24839,0.021179},
      {0.0031614,0.019262,0.4167,0.00096754,-0.0010101,-0.29221,-0.015589,0.29588,-0.19608,-0.060808},
      {0.0033442,0.034704,0.30495,0.001537,-0.0011735,-0.39655,-0.02726,0.21876,-0.13352,-0.14778},
      {0.0035748,0.064374,0.18859,0.0023166,-0.0011082,-0.48666,-0.048488,0.14078,-0.063655,-0.22243},
      {0.0034521,0.086956,0.084608,0.0026225,-0.00094308,-0.57597,-0.064019,0.07067,-0.0033535,-0.29596},
      {0.0029432,0.11538,0.01763,0.0024111,-0.00035919,-0.60511,-0.082505,0.036246,0.033765,-0.31917},
      {0.0025088,0.14933,-0.017735,0.0014293,0.00019114,-0.57879,-0.10455,0.033317,0.051952,-0.29625},
      {0.0026055,0.18072,-0.04337,0.0013062,0.00027433,-0.53651,-0.12625,0.037443,0.064657,-0.26113},
      {0.0021172,0.19111,-0.10248,0.0014444,0.0010853,-0.46263,-0.13378,0.074777,0.04289,-0.20096},
      {0.0014591,0.1883,-0.18386,0.0015897,0.0018848,-0.37305,-0.13214,0.1312,0.00094286,-0.12774},
      {0.00091801,0.1792,-0.27196,0.0016761,0.002277,-0.28308,-0.12599,0.19272,-0.04756,-0.053586},
      {0.00053842,0.136,-0.3678,0.0014433,0.0068016,-0.21601,-0.095782,0.26027,-0.11693,-0.0043959},
      {0.00025768,0.089286,-0.46733,0.0011256,0.0097291,-0.15139,-0.06306,0.33057,-0.18985,0.045047},
      {5.28E-05,0.051429,-0.56902,0.00083295,0.0094705,-0.079434,-0.036536,0.4024,-0.25942,0.10514},
      {-3.74E-05,0.027157,-0.62658,0.00045281,0.010858,-0.039659,-0.019474,0.44321,-0.3001,0.13615},
      {-5.42E-05,0.016115,-0.64629,0.0002572,0.013254,-0.02609,-0.011722,0.45715,-0.3153,0.14397},
      {-5.72E-05,0.0084646,-0.66513,0.00011543,0.012118,-0.015703,-0.0063395,0.47044,-0.3284,0.15421},
      {-4.53E-05,0.0044074,-0.67425,7.27E-06,0.014608,-0.0061187,-0.003432,0.47683,-0.33489,0.15858},
      {-3.42E-05,0.002765,-0.67009,-6.25E-05,0.022413,0.00036569,-0.0021791,0.47386,-0.33368,0.15275},
      {-2.33E-05,0.0015934,-0.67048,-0.00010052,0.025402,0.0043232,-0.0012737,0.47411,-0.33448,0.15174},
      {-1.32E-05,0.00081161,-0.67475,-0.00011068,0.024441,0.0064017,-0.00065532,0.47711,-0.33702,0.15484},
      {-6.71E-06,0.00046219,-0.67229,-0.00010081,0.028747,0.010443,-0.00036587,0.47537,-0.33597,0.15201},
      {-0.00089832,0.00056886,0.69781,-0.0041968,0.00010289,-0.0031143,0.00059517,0.49062,-0.35011,0.18191},
      {-0.00081863,0.00056111,0.69685,-0.0040527,0.00010549,-0.0043373,0.00058927,0.49006,-0.34957,0.18088},
      {-0.00067935,0.00055734,0.69514,-0.0037088,0.00010904,-0.0066141,0.00056893,0.48912,-0.34855,0.17897},
      {-0.00049296,0.00054964,0.69259,-0.003245,0.00011412,-0.0099552,0.00054175,0.48768,-0.34707,0.17617},
      {-0.00026275,0.00053577,0.689,-0.0026664,0.00012097,-0.014607,0.0005082,0.48561,-0.34503,0.17228},
      {4.83E-06,0.00051328,0.68409,-0.0019864,0.00012983,-0.020869,0.00046925,0.48269,-0.34229,0.16704},
      {0.00030047,0.00047989,0.67753,-0.0012267,0.00014093,-0.029104,0.00042621,0.47869,-0.33871,0.16015},
      {0.00061145,0.00059135,0.66179,-0.0006924,0.00011882,-0.047121,0.00022659,0.46802,-0.3305,0.14507},
      {0.00090741,0.00087843,0.63259,-0.00046467,6.11E-05,-0.079768,-0.00016411,0.44756,-0.31551,0.11774},
      {0.0011654,0.0011491,0.59627,-0.00023782,1.66E-05,-0.12073,-0.00055654,0.42209,-0.297,0.083519},
      {0.0013691,0.001874,0.5482,-1.55E-05,-2.61E-05,-0.1746,-0.0013186,0.3883,-0.27243,0.038574},
      {0.0014656,0.0083142,0.44751,0.0003205,-0.0002458,-0.27974,-0.0065713,0.31758,-0.21886,-0.049118},
      {0.0013844,0.014172,0.33623,0.00057073,-0.00032919,-0.39919,-0.011165,0.2394,-0.16058,-0.14841},
      {0.0011805,0.021608,0.21823,0.00074082,-0.00022468,-0.52564,-0.01648,0.15685,-0.098755,-0.25312},
      {0.0011502,0.040553,0.12779,0.00076547,5.11E-05,-0.60588,-0.028982,0.095832,-0.046706,-0.31889},
      {0.0012835,0.056432,0.057839,0.00079905,2.68E-05,-0.66496,-0.03969,0.04888,-0.0057623,-0.36753},
      {0.0014479,0.076962,0.0081402,0.00088626,-3.41E-05,-0.68451,-0.053893,0.022282,0.023233,-0.38363},
      {0.0016253,0.10839,-0.016413,0.00095969,3.62E-05,-0.63896,-0.075805,0.02767,0.035098,-0.3459},
      {0.0017172,0.13233,-0.038572,0.00099399,8.75E-05,-0.60084,-0.092502,0.03396,0.042591,-0.3143},
      {0.001472,0.14048,-0.087641,0.0010394,0.00040442,-0.54199,-0.098311,0.064106,0.025109,-0.26585},
      {0.00096074,0.13255,-0.17749,0.0010923,0.00083112,-0.44855,-0.092966,0.1269,-0.023657,-0.18885},
      {0.00054656,0.11966,-0.27333,0.0010439,0.00093639,-0.35392,-0.084059,0.1943,-0.077952,-0.11042},
      {0.00024514,0.090961,-0.37362,0.00079277,0.0019648,-0.27063,-0.063995,0.26517,-0.14232,-0.042752},
      {4.36E-05,0.054048,-0.47524,0.00044297,0.0023758,-0.19658,-0.038138,0.33698,-0.21136,0.01812},
      {-5.33E-05,0.031624,-0.57319,0.0004354,0.0023507,-0.1102,-0.022502,0.40595,-0.27141,0.089839},
      {-9.71E-05,0.01689,-0.64224,0.00038075,0.0031345,-0.04685,-0.012226,0.45455,-0.31313,0.14129},
      {-8.75E-05,0.010561,-0.65592,0.00022711,0.0054498,-0.034997,-0.0077699,0.46415,-0.32294,0.14779},
      {-7.30E-05,0.006089,-0.66853,0.00011233,0.0062051,-0.024919,-0.004597,0.47298,-0.33134,0.15506},
      {-5.41E-05,0.003221,-0.68041,3.24E-05,0.0057527,-0.01589,-0.0025314,0.48129,-0.3386,0.1632},
      {-4.07E-05,0.0020185,-0.67957,-1.49E-05,0.010224,-0.010818,-0.0016111,0.48066,-0.3388,0.16098},
      {-2.85E-05,0.0012238,-0.68159,-3.53E-05,0.011391,-0.007658,-0.00098742,0.48206,-0.34022,0.16193},
      {-1.79E-05,0.00073601,-0.68518,-3.75E-05,0.010679,-0.0055533,-0.00059434,0.48457,-0.34225,0.1647},
      {-0.00090522,0.00053491,0.69771,-0.0027406,0.00010519,-0.0049779,0.00048141,0.4917,-0.34954,0.18036},
      {-0.00089247,0.0005016,0.69711,-0.0029179,0.00010962,-0.0054494,0.00050918,0.49118,-0.34935,0.17996},
      {-0.00087383,0.00045112,0.69617,-0.0031797,0.00011646,-0.0062,0.00055151,0.49037,-0.34906,0.17933},
      {-0.00084001,0.00038681,0.69465,-0.0034596,0.00012567,-0.0075838,0.00060252,0.48915,-0.3485,0.17817},
      {-0.0006515,0.00035915,0.68943,-0.0029458,0.00013385,-0.01406,0.00057049,0.4859,-0.34571,0.17276},
      {-0.0004325,0.00032411,0.68252,-0.0023495,0.00014417,-0.022541,0.00053295,0.48154,-0.34206,0.16568},
      {-0.00019095,0.00028179,0.6736,-0.0016946,0.00015678,-0.033371,0.00049103,0.47583,-0.33741,0.15665},
      {6.31E-05,0.00023308,0.66228,-0.0010132,0.0001718,-0.04695,0.00044614,0.46849,-0.33158,0.14533},
      {0.00030459,0.00024011,0.64314,-0.00044142,0.00018059,-0.069255,0.00033776,0.45553,-0.32185,0.12673},
      {0.00047496,0.00046187,0.59971,-0.00024878,0.00017053,-0.11876,6.10E-06,0.42499,-0.2999,0.085467},
      {0.00060604,0.00068236,0.54851,-8.83E-05,0.00020017,-0.17731,-0.00030802,0.38893,-0.27411,0.036696},
      {0.00069787,0.00089786,0.48874,1.07E-05,0.00027952,-0.24589,-0.00059404,0.34676,-0.24411,-0.020372},
      {0.00062907,0.0053805,0.38269,0.00015937,0.00030952,-0.36184,-0.0039277,0.27231,-0.1893,-0.11655},
      {0.00056947,0.0097312,0.27195,0.00029209,0.00026895,-0.48321,-0.0071632,0.19459,-0.13222,-0.21721},
      {0.0005102,0.013361,0.16424,0.00040299,0.00020045,-0.60243,-0.0098456,0.11879,-0.076885,-0.31606},
      {0.00067137,0.027676,0.10203,0.00050052,8.58E-05,-0.65407,-0.019684,0.07699,-0.040239,-0.35868},
      {0.0007878,0.040004,0.049338,0.00056618,-3.58E-05,-0.6976,-0.028153,0.041648,-0.0091487,-0.39458},
      {0.00085713,0.051346,0.0066519,0.00059692,-0.00013759,-0.72808,-0.035971,0.015051,0.015279,-0.41969},
      {0.00095892,0.074372,-0.014841,0.000617,-7.48E-05,-0.68997,-0.052036,0.021994,0.021897,-0.38806},
      {0.000981,0.090337,-0.03405,0.00057845,-4.11E-05,-0.65945,-0.063181,0.029443,0.024656,-0.36269},
      {0.00085088,0.095828,-0.066953,0.00049457,1.93E-05,-0.62119,-0.067043,0.049192,0.013445,-0.33096},
      {0.00046603,0.083801,-0.16465,0.00041135,0.00014658,-0.5233,-0.058733,0.11797,-0.041328,-0.24985},
      {0.00017565,0.069465,-0.26787,0.00024217,6.72E-05,-0.42144,-0.048742,0.19102,-0.1001,-0.16517},
      {2.75E-05,0.058301,-0.37496,0.00031012,0.00024387,-0.31031,-0.040999,0.26675,-0.1593,-0.073202},
      {-5.40E-05,0.037631,-0.4737,0.00031848,0.00075428,-0.22021,-0.026608,0.33615,-0.2188,0.00084115},
      {-0.00010319,0.021918,-0.56457,0.00031264,0.0010328,-0.1338,-0.015673,0.40006,-0.2719,0.072158},
      {-0.00012314,0.010883,-0.64506,0.00029054,0.0011897,-0.054056,-0.0079967,0.45671,-0.31749,0.13811},
      {-0.00010614,0.006635,-0.65665,0.00017525,0.0023666,-0.044163,-0.0049906,0.46481,-0.32525,0.14462},
      {-8.51E-05,0.0038399,-0.6677,9.22E-05,0.0024757,-0.035028,-0.0029869,0.47252,-0.33206,0.15204},
      {-6.05E-05,0.0022643,-0.67855,3.78E-05,0.0018407,-0.025973,-0.0018248,0.48008,-0.33819,0.16046},
      {-4.30E-05,0.0015293,-0.68227,9.60E-06,0.0030988,-0.020686,-0.0012527,0.48265,-0.3404,0.16304},
      {-3.34E-05,0.0011187,-0.68224,-3.14E-06,0.0045915,-0.018811,-0.00093107,0.48258,-0.34057,0.16245},
      {-0.00082399,0.00043569,0.69899,-0.0011807,0.00010962,-0.0055435,0.00039134,0.4938,-0.34963,0.17988},
      {-0.00083903,0.00040873,0.69832,-0.0012665,0.00011532,-0.0061557,0.00043046,0.49329,-0.34935,0.17937},
      {-0.00086604,0.00036832,0.69728,-0.0013862,0.00012432,-0.0071137,0.00049228,0.49252,-0.34892,0.17856},
      {-0.00091095,0.00031481,0.69582,-0.0015273,0.00013716,-0.0084666,0.0005807,0.49146,-0.34831,0.17742},
      {-0.00098172,0.00024986,0.69391,-0.0016686,0.00015444,-0.010262,0.00069977,0.49011,-0.34747,0.17591},
      {-0.00098931,0.00019065,0.68922,-0.0015949,0.0001751,-0.015471,0.00078627,0.48698,-0.34517,0.17155},
      {-0.00078263,0.00015663,0.6782,-0.0011239,0.00019731,-0.028478,0.00073332,0.4797,-0.3396,0.1607},
      {-0.00052899,0.00012288,0.66461,-0.00066395,0.00022482,-0.04441,0.00065026,0.47063,-0.3328,0.14742},
      {-0.00024079,9.83E-05,0.64699,-0.00031391,0.00025625,-0.064502,0.00053471,0.45887,-0.32423,0.13068},
      {8.76E-05,8.01E-05,0.62395,-4.10E-05,0.00028989,-0.090136,0.00037884,0.44364,-0.31328,0.10935},
      {0.00019558,0.00027776,0.56508,-2.37E-05,0.00033958,-0.15696,9.86E-05,0.40239,-0.284,0.053757},
      {0.00029779,0.00046311,0.49826,-5.23E-06,0.00039601,-0.2333,-0.0001777,0.35534,-0.25062,-0.0097308},
      {0.00038964,0.00062979,0.42325,1.39E-05,0.00045843,-0.31957,-0.00044107,0.30225,-0.21301,-0.081445},
      {0.00037995,0.0032953,0.32754,0.00010039,0.000415,-0.42639,-0.0024395,0.23476,-0.164,-0.17005},
      {0.00033721,0.006337,0.22846,0.0001923,0.00031742,-0.5368,-0.0046667,0.16485,-0.11311,-0.26156},
      {0.00029383,0.0087229,0.13303,0.00025904,0.0002041,-0.64428,-0.0063984,0.097311,-0.064224,-0.35059},
      {0.00035793,0.017609,0.077218,0.00030522,8.39E-05,-0.69649,-0.012526,0.059111,-0.032815,-0.39371},
      {0.00041042,0.026335,0.038002,0.00031598,-2.87E-05,-0.72968,-0.018531,0.032757,-0.0098428,-0.42104},
      {0.00041453,0.032487,0.0060557,0.00028218,-0.00012652,-0.75823,-0.022763,0.011167,0.0084955,-0.44452},
      {0.00043321,0.045977,-0.013398,0.00022024,-0.00010308,-0.73456,-0.032177,0.01622,0.011745,-0.42481},
      {0.00038604,0.054206,-0.029757,8.57E-05,-0.00010265,-0.71223,-0.037921,0.024325,0.010253,-0.4062},
      {0.00035255,0.060471,-0.045455,6.58E-06,-0.00013236,-0.68992,-0.04231,0.033638,0.0069037,-0.38768},
      {0.00018734,0.053849,-0.15231,9.42E-05,-5.80E-05,-0.57396,-0.037751,0.10915,-0.049902,-0.29156},
      {4.02E-05,0.046059,-0.26496,0.00016489,1.16E-05,-0.45258,-0.032372,0.18884,-0.11021,-0.19092},
      {-8.52E-05,0.037756,-0.37955,0.00021581,7.33E-05,-0.32954,-0.026634,0.26995,-0.17172,-0.088894},
      {-0.00012965,0.023698,-0.47024,0.00021511,0.00036081,-0.24135,-0.01686,0.33374,-0.22391,-0.016122},
      {-0.0001462,0.013223,-0.55262,0.00020201,0.00050117,-0.15883,-0.0095838,0.39169,-0.27016,0.052158},
      {-0.00014169,0.0063567,-0.62798,0.00018059,0.0005122,-0.080331,-0.004825,0.44477,-0.31113,0.11728},
      {-0.00011966,0.0034159,-0.65226,0.00011467,0.00072826,-0.055889,-0.0027452,0.46181,-0.32461,0.13725},
      {-9.30E-05,0.0020096,-0.66223,5.96E-05,0.00051582,-0.046907,-0.0017113,0.46874,-0.33021,0.145},
      {-6.95E-05,0.0017627,-0.66949,2.87E-05,0.00051154,-0.039277,-0.0015074,0.47372,-0.33387,0.15134},
      {-5.08E-05,0.0014963,-0.67432,1.24E-05,0.00098279,-0.033516,-0.0012796,0.47704,-0.33639,0.15544},
      {-0.00074793,0.00030177,0.70116,-0.00030417,0.00013109,-0.0041476,0.00036672,0.49609,-0.35053,0.18101},
      {-0.00079973,0.00028879,0.70029,-0.00035373,0.00013828,-0.004903,0.00041908,0.49551,-0.35014,0.18037},
      {-0.00088066,0.00026901,0.69892,-0.00042901,0.00014951,-0.0060933,0.00050015,0.49461,-0.34954,0.17937},
      {-0.00099444,0.00024217,0.69696,-0.00053076,0.00016534,-0.0077897,0.00061269,0.49333,-0.34869,0.17794},
      {-0.0011441,0.00020839,0.69431,-0.00065803,0.00018629,-0.010067,0.00075845,0.49164,-0.34754,0.17602},
      {-0.0013316,0.0001682,0.69088,-0.00080813,0.00021289,-0.013007,0.00093789,0.48947,-0.34607,0.17355},
      {-0.0015572,0.00012248,0.68654,-0.00097662,0.00024567,-0.016696,0.0011499,0.48678,-0.34423,0.17044},
      {-0.0013163,0.00010201,0.67006,-0.00081155,0.0002733,-0.034905,0.0010371,0.47593,-0.33647,0.15528},
      {-0.00095208,8.48E-05,0.64787,-0.00057489,0.00030199,-0.059573,0.00083749,0.46129,-0.32603,0.13477},
      {-0.00055148,6.66E-05,0.62115,-0.00033144,0.00033278,-0.089113,0.00060933,0.44371,-0.31351,0.1102},
      {-0.00012587,4.79E-05,0.58937,-9.04E-05,0.00036473,-0.12406,0.00035796,0.42284,-0.29869,0.08116},
      {3.17E-05,0.00016477,0.52578,-3.05E-05,0.0004168,-0.19705,0.00011536,0.37807,-0.26697,0.020494},
      {0.00011632,0.00029931,0.44864,-1.10E-05,0.00047651,-0.28647,-0.00010947,0.32313,-0.22807,-0.0538},
      {0.00018592,0.00041451,0.36374,7.21E-06,0.00053823,-0.38541,-0.00031092,0.2624,-0.1851,-0.13598},
      {0.00019255,0.00181,0.2737,5.28E-05,0.00049248,-0.48843,-0.0013644,0.19829,-0.13911,-0.2214},
      {0.00016225,0.0037153,0.1864,0.00010001,0.00036269,-0.58749,-0.0027306,0.1363,-0.094382,-0.30342},
      {0.00013023,0.0050295,0.10331,0.0001189,0.00022902,-0.6829,-0.0036587,0.077073,-0.051879,-0.38237},
      {0.00013635,0.0097184,0.052228,0.0001077,0.00011503,-0.73608,-0.0068924,0.04138,-0.024303,-0.42627},
      {0.00013672,0.015117,0.024816,5.55E-05,3.07E-05,-0.7605,-0.010616,0.022866,-0.0084847,-0.44632},
      {0.00011858,0.018738,0.0041214,-9.58E-06,-4.28E-05,-0.77912,-0.013124,0.0091308,0.0030823,-0.4616},
      {0.00014738,0.026985,-0.013268,-8.09E-06,-8.99E-05,-0.76273,-0.018896,0.013216,0.0043762,-0.44801},
      {0.00016045,0.034344,-0.032259,-4.60E-06,-0.00011216,-0.73427,-0.024053,0.025291,-0.00041657,-0.42443},
      {0.00014668,0.038447,-0.05312,-2.49E-06,-0.00012869,-0.70705,-0.026939,0.038943,-0.0079637,-0.40187},
      {4.47E-05,0.033984,-0.14318,4.62E-05,-7.84E-05,-0.60834,-0.023874,0.10241,-0.055089,-0.32003},
      {-6.70E-05,0.026933,-0.2582,9.61E-05,-1.24E-05,-0.48337,-0.019014,0.1838,-0.11617,-0.21641},
      {-0.00016181,0.019853,-0.37317,0.00012808,4.60E-05,-0.35847,-0.014136,0.26518,-0.17722,-0.11284},
      {-0.00019169,0.011689,-0.46362,0.00012605,0.00015809,-0.2637,-0.0084858,0.32896,-0.22641,-0.034354},
      {-0.00018238,0.0056267,-0.53799,0.00010835,0.00021065,-0.18536,-0.0042933,0.38132,-0.26647,0.030583},
      {-0.00015867,0.0023785,-0.60595,8.59E-05,0.00019508,-0.11112,-0.0020657,0.42924,-0.30197,0.092203},
      {-0.00013301,0.0019878,-0.63918,6.01E-05,0.00028283,-0.073446,-0.0018266,0.45258,-0.31865,0.12333},
      {-0.00010717,0.0017762,-0.64524,3.38E-05,0.00032538,-0.067073,-0.0016502,0.4567,-0.3217,0.12856},
      {-7.99E-05,0.0016515,-0.65192,1.92E-05,0.00035913,-0.059852,-0.0015147,0.46129,-0.32505,0.13449},
      {-0.00048389,0.00029123,0.7045,-5.24E-05,0.00012246,-0.0010899,0.00014803,0.49857,-0.3522,0.18356},
      {-0.0005412,0.00028033,0.70342,-9.22E-05,0.00013093,-0.0019941,0.00020062,0.49791,-0.35174,0.1828},
      {-0.00062895,0.00026376,0.70174,-0.00015241,0.0001441,-0.0034088,0.00028094,0.49689,-0.35104,0.1816},
      {-0.00074886,0.00024134,0.69936,-0.00023311,0.00016255,-0.0054051,0.00039033,0.49545,-0.35005,0.17992},
      {-0.00090087,0.00021324,0.69619,-0.00033289,0.00018679,-0.0080526,0.00052838,0.49356,-0.34874,0.17769},
      {-0.0010828,0.00018001,0.69216,-0.00044867,0.00021729,-0.011421,0.00069286,0.49118,-0.34708,0.17486},
      {-0.0012901,0.00014253,0.68716,-0.0005757,0.00025448,-0.015583,0.00087936,0.48827,-0.34506,0.17135},
      {-0.0015152,0.00010205,0.68111,-0.0007075,0.00029878,-0.020612,0.001081,0.48481,-0.34264,0.16712},
      {-0.0014343,7.33E-05,0.66439,-0.00067232,0.00033647,-0.038086,0.0010649,0.47415,-0.3351,0.15257},
      {-0.0010236,5.76E-05,0.63418,-0.00046881,0.00036225,-0.071264,0.00081159,0.45433,-0.32106,0.125},
      {-0.00060955,4.27E-05,0.59886,-0.00027244,0.00038765,-0.10988,0.00055197,0.43117,-0.30467,0.092931},
      {-0.00021304,2.94E-05,0.55795,-9.37E-05,0.00041125,-0.15439,0.00029902,0.40438,-0.28573,0.055978},
      {-3.37E-05,9.03E-05,0.49053,-2.42E-05,0.00045448,-0.23182,9.82E-05,0.35705,-0.25225,-0.0083124},
      {2.42E-05,0.00017885,0.40439,-8.00E-06,0.00050973,-0.33288,-5.97E-05,0.29507,-0.20842,-0.092218},
      {6.24E-05,0.00024811,0.31098,5.07E-06,0.00056288,-0.44297,-0.00018416,0.2276,-0.16071,-0.1836},
      {6.50E-05,0.00081968,0.2208,1.85E-05,0.00053193,-0.54853,-0.00061718,0.16262,-0.11451,-0.27109},
      {4.74E-05,0.0017484,0.1474,1.71E-05,0.00039527,-0.63358,-0.0012588,0.11005,-0.076884,-0.34143},
      {3.23E-05,0.0023854,0.080029,3.29E-06,0.00025368,-0.71237,-0.0017019,0.06153,-0.042252,-0.40654},
      {3.61E-05,0.004899,0.035873,-1.12E-06,0.00012651,-0.76066,-0.0034625,0.030256,-0.018863,-0.44645},
      {4.92E-05,0.0091665,0.018748,-6.60E-06,3.45E-05,-0.77319,-0.0064428,0.01958,-0.0091571,-0.45676},
      {5.32E-05,0.012366,0.0032383,-1.20E-05,-4.95E-05,-0.78448,-0.0086802,0.010421,-0.001062,-0.46606},
      {5.35E-05,0.016446,-0.014105,-1.33E-05,-9.56E-05,-0.77567,-0.011541,0.012872,-0.00071665,-0.45874},
      {4.12E-05,0.020314,-0.036153,-1.16E-05,-0.00010615,-0.74721,-0.014264,0.02745,-0.0090326,-0.43514},
      {1.08E-05,0.021608,-0.060169,-1.13E-05,-0.00011191,-0.71913,-0.015191,0.043634,-0.01978,-0.41187},
      {-5.70E-05,0.018275,-0.13171,1.00E-05,-7.86E-05,-0.64067,-0.012911,0.093934,-0.056984,-0.34681},
      {-0.00013948,0.012355,-0.24686,4.03E-05,-1.66E-05,-0.51424,-0.0088469,0.17543,-0.11753,-0.24197},
      {-0.00020938,0.0068438,-0.36017,5.44E-05,3.79E-05,-0.38946,-0.0050755,0.25564,-0.17692,-0.1385},
      {-0.00023238,0.0027004,-0.45352,4.96E-05,0.00010402,-0.28646,-0.0022553,0.32159,-0.22558,-0.053124},
      {-0.00019959,0.0020282,-0.51864,4.20E-05,0.00022719,-0.21218,-0.001869,0.36747,-0.25834,0.0083253},
      {-0.00016621,0.0018262,-0.57258,4.12E-05,0.00030765,-0.15026,-0.0017984,0.40549,-0.28531,0.059584},
      {-0.00014007,0.001771,-0.61136,3.62E-05,0.00032976,-0.10575,-0.0018036,0.43281,-0.30465,0.096477},
      {-0.0001125,0.0016543,-0.61834,2.24E-05,0.00037077,-0.098157,-0.0016749,0.43761,-0.30816,0.10272},
      {-0.0002609,0.00021718,0.70604,0,0.00010988,6.34E-05,3.39E-05,0.49958,-0.35302,0.18453},
      {-0.0002707,0.00021445,0.706,0,0.00011472,6.62E-05,4.29E-05,0.49957,-0.35301,0.18453},
      {-0.00028523,0.00021026,0.70595,0,0.00012221,7.06E-05,5.63E-05,0.49956,-0.35299,0.18452},
      {-0.00032492,0.00020143,0.70517,-1.45E-05,0.0001353,-0.00051123,9.22E-05,0.49915,-0.3527,0.18402},
      {-0.0004469,0.00017956,0.70161,-8.28E-05,0.00016216,-0.0034399,0.00020066,0.49715,-0.3513,0.18155},
      {-0.00058637,0.00015394,0.69711,-0.00015966,0.00019579,-0.0071372,0.00032515,0.49465,-0.34954,0.17844},
      {-0.00073535,0.00012546,0.6916,-0.00024008,0.00023657,-0.011665,0.00045908,0.49162,-0.34741,0.17463},
      {-0.00088259,9.53E-05,0.685,-0.00031757,0.00028484,-0.017082,0.0005932,0.48805,-0.3449,0.17006},
      {-0.0010131,6.50E-05,0.67723,-0.00038401,0.00034089,-0.023448,0.00071541,0.48391,-0.34198,0.16471},
      {-0.0010159,3.98E-05,0.66282,-0.00039066,0.00039477,-0.037245,0.00074453,0.4754,-0.33597,0.15319},
      {-0.0006645,3.01E-05,0.62418,-0.00024705,0.00041184,-0.079223,0.0005161,0.45009,-0.3181,0.11835},
      {-0.00034086,2.30E-05,0.5815,-0.00012029,0.00043584,-0.12565,0.00031123,0.42202,-0.29827,0.079812},
      {-8.53E-05,2.06E-05,0.5348,-3.38E-05,0.00045095,-0.17629,0.00015457,0.39126,-0.27655,0.037795},
      {2.98E-05,5.09E-05,0.46805,-2.08E-06,0.0004775,-0.25272,5.14E-05,0.34452,-0.24351,-0.025629},
      {4.70E-05,0.00010377,0.37912,4.80E-06,0.00052629,-0.35861,-2.58E-05,0.27962,-0.19762,-0.11351},
      {4.36E-05,0.00015095,0.28913,7.60E-06,0.0005697,-0.46611,-8.84E-05,0.21371,-0.15101,-0.20272},
      {3.68E-05,0.00037928,0.20436,8.45E-06,0.00055633,-0.5667,-0.00027176,0.15195,-0.10723,-0.28612},
      {2.86E-05,0.0010386,0.14186,4.68E-06,0.00039716,-0.63988,-0.00074339,0.10681,-0.074968,-0.3466},
      {1.94E-05,0.0015633,0.079036,5.29E-07,0.00023811,-0.71358,-0.0011204,0.061432,-0.042612,-0.40751},
      {1.35E-05,0.0027091,0.028426,-4.19E-06,0.00010121,-0.77121,-0.0019288,0.025427,-0.016569,-0.45514},
      {1.54E-05,0.0054942,0.014042,-9.61E-06,2.23E-05,-0.78116,-0.0038781,0.017381,-0.0094692,-0.46333},
      {1.14E-05,0.0073678,0.0011635,-1.48E-05,-4.47E-05,-0.7897,-0.005193,0.010838,-0.0038918,-0.47037},
      {-4.56E-08,0.0088541,-0.0139,-1.82E-05,-8.48E-05,-0.78647,-0.0062433,0.011746,-0.0037669,-0.46765},
      {-2.78E-05,0.0099879,-0.039153,-1.83E-05,-8.52E-05,-0.75702,-0.0070605,0.028882,-0.015264,-0.44324},
      {-6.57E-05,0.0091614,-0.066466,-1.98E-05,-8.17E-05,-0.72719,-0.0065131,0.047653,-0.028904,-0.41851},
      {-0.00011557,0.0061215,-0.11983,-1.58E-05,-5.94E-05,-0.66939,-0.0044362,0.085119,-0.056867,-0.37058},
      {-0.00016699,0.0030955,-0.23368,-8.52E-07,0.00010071,-0.54083,-0.0024156,0.16573,-0.11529,-0.26413},
      {-0.00019829,0.002156,-0.33986,1.22E-05,0.00031463,-0.41858,-0.0018796,0.24092,-0.16881,-0.163},
      {-0.00021277,0.0015313,-0.42921,2.12E-05,0.000443,-0.31573,-0.0015642,0.30411,-0.21371,-0.077861},
      {-0.00018031,0.0013915,-0.48311,2.21E-05,0.0005516,-0.25371,-0.001532,0.34212,-0.24065,-0.026559},
      {-0.00015668,0.0014204,-0.53182,2.21E-05,0.00056422,-0.19756,-0.0016174,0.37649,-0.26493,0.020003},
      {-0.00014171,0.0016031,-0.57535,2.12E-05,0.00044757,-0.14735,-0.0018122,0.40723,-0.28655,0.06182},
      {-9.97E-05,0.00010461,0.70622,0,0.00024432,0.00014106,-1.66E-06,0.49968,-0.35322,0.1844},
      {-0.00010294,0.00010182,0.70617,0,0.00026971,0.00015571,2.77E-06,0.49966,-0.35321,0.18438},
      {-0.00010735,9.75E-05,0.70608,0,0.00031177,0.00018,9.14E-06,0.49963,-0.35319,0.18434},
      {-0.00011214,9.16E-05,0.70596,0,0.00037595,0.00021706,1.70E-05,0.49959,-0.35316,0.18428},
      {-0.00011605,8.39E-05,0.70579,0,0.00046965,0.00027115,2.56E-05,0.49952,-0.35311,0.18419},
      {-0.00012624,7.34E-05,0.70486,-4.15E-06,0.00058933,-0.00027875,4.16E-05,0.49905,-0.35278,0.18356},
      {-0.00017994,5.52E-05,0.69914,-2.92E-05,0.00064605,-0.0050458,9.97E-05,0.496,-0.35063,0.17953},
      {-0.00020972,3.71E-05,0.69242,-4.39E-05,0.00069017,-0.010732,0.00014184,0.49244,-0.34811,0.17475},
      {-0.0001987,2.07E-05,0.68467,-4.25E-05,0.00070888,-0.017397,0.00015513,0.48835,-0.34522,0.16919},
      {-0.00012655,7.34E-06,0.67589,-1.96E-05,0.00068579,-0.02511,0.00012404,0.48373,-0.34197,0.16283},
      {-7.26E-05,1.67E-06,0.66587,-1.01E-06,0.00059481,-0.03426,0.00010141,0.47828,-0.33812,0.15538},
      {-3.46E-05,6.28E-06,0.62556,-5.31E-07,0.00057728,-0.078271,9.20E-05,0.45134,-0.31907,0.1189},
      {4.75E-06,1.10E-05,0.58159,3.05E-08,0.00055003,-0.12642,8.26E-05,0.42188,-0.29824,0.079012},
      {4.27E-05,1.53E-05,0.53519,6.34E-07,0.00050235,-0.17735,7.46E-05,0.39073,-0.27622,0.03685},
      {6.49E-05,3.16E-05,0.4746,1.83E-06,0.0004655,-0.24655,5.15E-05,0.34839,-0.24627,-0.020475},
      {5.53E-05,7.10E-05,0.38482,4.04E-06,0.00049637,-0.35328,-3.67E-06,0.28297,-0.20001,-0.10903},
      {4.34E-05,0.00010433,0.29153,5.79E-06,0.00052095,-0.46378,-5.31E-05,0.21526,-0.15213,-0.20069},
      {3.01E-05,0.00018349,0.19931,6.36E-06,0.0005169,-0.57256,-0.00013092,0.1486,-0.10496,-0.29089},
      {2.02E-05,0.00060932,0.13763,1.79E-06,0.00035373,-0.64497,-0.00043891,0.10409,-0.07327,-0.35073},
      {1.03E-05,0.00091721,0.076492,-3.05E-06,0.0002019,-0.71676,-0.00066398,0.060029,-0.041957,-0.41007},
      {1.56E-06,0.0012463,0.020286,-8.12E-06,7.23E-05,-0.78221,-0.00090306,0.019823,-0.013356,-0.46419},
      {-3.08E-06,0.0027805,0.0084526,-1.33E-05,1.21E-05,-0.78937,-0.001982,0.014366,-0.0087173,-0.47007},
      {-1.07E-05,0.0035468,-0.0019729,-1.83E-05,-3.28E-05,-0.79498,-0.0025262,0.010403,-0.0055211,-0.47468},
      {-2.18E-05,0.003579,-0.012549,-2.26E-05,-5.74E-05,-0.79593,-0.0025604,0.0097937,-0.005062,-0.47544},
      {-5.51E-05,0.0027405,-0.041308,-2.47E-05,-4.67E-05,-0.76432,-0.0020068,0.029661,-0.01948,-0.44923},
      {-7.76E-05,0.0027094,-0.074486,-2.69E-05,0.0001767,-0.72573,-0.0020337,0.052972,-0.035919,-0.41756},
      {-9.65E-05,0.0024965,-0.11481,-2.74E-05,0.0006544,-0.67861,-0.0019465,0.081371,-0.056043,-0.37918},
      {-0.00012671,0.001744,-0.21808,-1.37E-05,0.00093019,-0.55941,-0.0015377,0.15449,-0.10801,-0.28067},
      {-0.00015317,0.0011643,-0.31218,-2.50E-06,0.0010863,-0.45086,-0.0012622,0.22109,-0.15527,-0.19084},
      {-0.00017577,0.0007248,-0.39701,6.42E-06,0.0010912,-0.35317,-0.0010952,0.28109,-0.19779,-0.10981},
      {-0.00015632,0.00078813,-0.44734,7.93E-06,0.0011125,-0.29504,-0.0012052,0.31663,-0.22288,-0.061618},
      {-0.00014229,0.0010111,-0.49115,8.38E-06,0.0010025,-0.24442,-0.0014251,0.34758,-0.24462,-0.019478},
      {-3.83E-06,6.28E-06,0.70606,0,0.00073736,0.00042572,5.31E-08,0.49947,-0.35317,0.18393},
      {-4.12E-06,6.34E-06,0.70595,0,0.00082263,0.00047494,3.73E-07,0.49941,-0.35313,0.18385},
      {-4.55E-06,6.44E-06,0.70577,0,0.00096204,0.00055543,8.60E-07,0.49931,-0.35306,0.18372},
      {-5.11E-06,6.56E-06,0.7055,0,0.0011712,0.00067622,1.52E-06,0.49916,-0.35295,0.18352},
      {-5.78E-06,6.71E-06,0.70513,0,0.0014713,0.00084943,2.35E-06,0.49895,-0.3528,0.18323},
      {-6.54E-06,6.88E-06,0.70462,0,0.0018902,0.0010913,3.35E-06,0.49865,-0.35259,0.18283},
      {-7.31E-06,7.05E-06,0.70394,0,0.0024656,0.0014235,4.48E-06,0.49824,-0.3523,0.18228},
      {-1.08E-05,6.49E-06,0.70002,-7.08E-08,0.0028173,-0.0015982,1.19E-05,0.49601,-0.35072,0.17927},
      {-1.69E-05,5.07E-06,0.69191,-2.23E-07,0.0026863,-0.0093611,2.66E-05,0.49138,-0.34744,0.17302},
      {-2.23E-05,3.60E-06,0.68257,-3.78E-07,0.0023999,-0.01869,4.17E-05,0.48596,-0.34359,0.16569},
      {-2.65E-05,2.12E-06,0.67194,-5.29E-07,0.0018884,-0.029834,5.66E-05,0.47966,-0.33913,0.15719},
      {-2.91E-05,6.80E-07,0.65994,-6.71E-07,0.0010641,-0.043094,7.08E-05,0.47241,-0.33399,0.14738},
      {-5.94E-06,3.18E-06,0.62498,-2.72E-07,0.00074521,-0.081789,7.02E-05,0.44904,-0.31746,0.11575},
      {2.41E-05,6.72E-06,0.58028,3.09E-07,0.00065318,-0.13129,6.55E-05,0.41882,-0.29609,0.074836},
      {5.17E-05,9.84E-06,0.53295,8.75E-07,0.00052828,-0.18396,6.18E-05,0.38669,-0.27338,0.031341},
      {6.98E-05,1.69E-05,0.4766,1.54E-06,0.00039569,-0.24794,5.19E-05,0.34765,-0.24577,-0.021517},
      {5.43E-05,4.31E-05,0.38405,2.60E-06,0.00040675,-0.35699,9.83E-06,0.28085,-0.19853,-0.11196},
      {3.82E-05,6.29E-05,0.28853,3.04E-06,0.00040861,-0.46908,-2.55E-05,0.2122,-0.14999,-0.20491},
      {2.19E-05,7.53E-05,0.19058,2.73E-06,0.00039922,-0.58353,-5.29E-05,0.14213,-0.10045,-0.29978},
      {1.22E-05,0.00029377,0.12964,-2.23E-06,0.00025849,-0.65499,-0.00021583,0.098324,-0.069362,-0.35887},
      {3.86E-06,0.00042137,0.071635,-7.53E-06,0.00013442,-0.72295,-0.00031455,0.056724,-0.039879,-0.41506},
      {-2.64E-06,0.00044478,0.015728,-1.29E-05,3.95E-05,-0.78829,-0.00033995,0.016777,-0.011617,-0.46911},
      {-9.10E-06,0.00086272,0.0023441,-1.89E-05,5.13E-07,-0.79713,-0.00064228,0.011082,-0.0073712,-0.47639},
      {-1.40E-05,0.0012005,-0.0059544,-2.43E-05,-1.32E-05,-0.79745,-0.00089385,0.010616,-0.0068606,-0.47666},
      {-1.76E-05,0.0014232,-0.0146,-2.94E-05,-1.59E-05,-0.79592,-0.0010689,0.011353,-0.0072556,-0.4754},
      {-3.67E-05,0.0014312,-0.046004,-3.13E-05,0.00028268,-0.7601,-0.0011229,0.032872,-0.022412,-0.44613},
      {-5.39E-05,0.0013149,-0.082735,-3.21E-05,0.00090941,-0.71678,-0.0011024,0.058722,-0.040686,-0.41111},
      {-6.67E-05,0.0011035,-0.12172,-3.18E-05,0.0019066,-0.6703,-0.0010246,0.086186,-0.060147,-0.374},
      {-8.99E-05,0.00070228,-0.20387,-2.23E-05,0.0022661,-0.57504,-0.00086252,0.1443,-0.10133,-0.2955},
      {-0.00011243,0.00036588,-0.28661,-1.27E-05,0.0022975,-0.47959,-0.00076204,0.20283,-0.14277,-0.21637},
      {-0.0001313,0.00010082,-0.36073,-4.59E-06,0.0021338,-0.39439,-0.0007177,0.25524,-0.17983,-0.14546},
      {-0.0001285,0.0002364,-0.41139,-1.38E-06,0.0019521,-0.33598,-0.00089871,0.29105,-0.20504,-0.09676},
      {-8.02E-07,3.47E-06,0.70592,0,0.0010496,0.000606,-8.78E-07,0.49925,-0.35302,0.18363},
      {-9.25E-07,3.50E-06,0.7057,0,0.0012489,0.00072103,-6.41E-07,0.49911,-0.35292,0.18344},
      {-1.11E-06,3.56E-06,0.70535,0,0.0015678,0.00090515,-2.79E-07,0.49889,-0.35276,0.18314},
      {-1.34E-06,3.63E-06,0.70484,0,0.0020325,0.0011735,2.13E-07,0.49856,-0.35253,0.18269},
      {-1.60E-06,3.71E-06,0.70413,0,0.0026753,0.0015446,8.31E-07,0.4981,-0.35221,0.18208},
      {-1.88E-06,3.80E-06,0.7032,0,0.003536,0.0020415,1.57E-06,0.49749,-0.35178,0.18125},
      {-2.14E-06,3.89E-06,0.70198,0,0.0046647,0.0026932,2.40E-06,0.49669,-0.35121,0.18017},
      {-2.34E-06,3.97E-06,0.70043,0,0.0061236,0.0035354,3.32E-06,0.49566,-0.35048,0.17877},
      {-2.46E-06,4.02E-06,0.69843,-3.62E-10,0.0079791,0.0045739,4.32E-06,0.49433,-0.34954,0.17697},
      {-3.87E-06,2.98E-06,0.68861,-1.09E-07,0.0071613,-0.006698,1.54E-05,0.48828,-0.34525,0.1688},
      {-4.40E-06,1.95E-06,0.67739,-2.13E-07,0.0059999,-0.020138,2.62E-05,0.48127,-0.34029,0.15932},
      {-3.84E-06,9.58E-07,0.6647,-3.09E-07,0.0043939,-0.036072,3.64E-05,0.47321,-0.33458,0.14842},
      {-2.04E-06,5.19E-08,0.65042,-3.90E-07,0.0022235,-0.054876,4.55E-05,0.46399,-0.32806,0.13594},
      {1.14E-05,1.16E-06,0.61909,-1.42E-07,0.0009582,-0.09168,4.79E-05,0.44279,-0.31306,0.10724},
      {3.14E-05,3.48E-06,0.5728,3.19E-07,0.00077735,-0.14383,4.60E-05,0.41104,-0.29061,0.064263},
      {4.80E-05,5.30E-06,0.5236,7.01E-07,0.00055067,-0.19964,4.45E-05,0.3771,-0.26661,0.018315},
      {5.99E-05,6.71E-06,0.47092,9.66E-07,0.00027429,-0.25989,4.26E-05,0.3405,-0.24073,-0.031245},
      {4.26E-05,2.00E-05,0.37663,6.34E-07,0.00026178,-0.36993,1.45E-05,0.27313,-0.1931,-0.12247},
      {2.73E-05,2.58E-05,0.2797,-7.20E-07,0.00022971,-0.48235,-4.80E-06,0.20432,-0.14445,-0.21564},
      {1.22E-05,2.34E-05,0.18106,-3.30E-06,0.00018377,-0.59634,-1.64E-05,0.13458,-0.095143,-0.31009},
      {3.78E-06,6.76E-05,0.11752,-8.90E-06,9.26E-05,-0.67011,-5.78E-05,0.089453,-0.063212,-0.37113},
      {8.38E-07,0.00011841,0.066713,-1.49E-05,5.28E-05,-0.7291,-0.00010438,0.053302,-0.037619,-0.42},
      {-1.73E-06,0.00014903,0.018454,-2.19E-05,2.11E-05,-0.78467,-0.0001385,0.019253,-0.013524,-0.46604},
      {-5.35E-06,0.00036965,-0.00010416,-2.78E-05,9.76E-06,-0.79805,-0.00030977,0.010873,-0.0074769,-0.47713},
      {-8.57E-06,0.00055089,-0.0088696,-3.27E-05,1.22E-05,-0.79575,-0.00045768,0.012102,-0.0082401,-0.47524},
      {-1.08E-05,0.00061468,-0.018002,-3.67E-05,2.48E-05,-0.79209,-0.00052719,0.014244,-0.009705,-0.47223},
      {-2.19E-05,0.00054978,-0.046925,-3.77E-05,0.00059279,-0.75975,-0.00053476,0.033414,-0.023242,-0.44623},
      {-3.40E-05,0.00040161,-0.086191,-3.68E-05,0.0017488,-0.71259,-0.00050274,0.061083,-0.042816,-0.40879},
      {-4.21E-05,0.0002059,-0.12691,-3.47E-05,0.0033664,-0.66299,-0.00044579,0.089796,-0.06315,-0.36998},
      {-5.73E-05,-4.04E-06,-0.19088,-2.77E-05,0.0041415,-0.58785,-0.00041276,0.13502,-0.095136,-0.30877},
      {-7.59E-05,-0.00018093,-0.26276,-1.90E-05,0.0039851,-0.50511,-0.00042432,0.18585,-0.13105,-0.23993},
      {-9.10E-05,-0.00035009,-0.32662,-1.11E-05,0.0035928,-0.43205,-0.00044376,0.231,-0.16294,-0.17877},
      {0,1.60E-06,0.70709,0,1.52E-05,8.78E-06,-1.13E-06,0.49999,-0.35354,0.18462},
      {-3.22E-09,1.62E-06,0.70701,0,8.91E-05,5.15E-05,-1.11E-06,0.49994,-0.35351,0.18455},
      {-2.29E-08,1.65E-06,0.70644,0,0.000637,0.00036777,-8.49E-07,0.49955,-0.35323,0.18403},
      {-3.92E-08,1.68E-06,0.70561,0,0.0014241,0.00082223,-4.96E-07,0.49899,-0.35284,0.18327},
      {-4.14E-08,1.72E-06,0.70449,0,0.0024931,0.0014394,-5.27E-08,0.49823,-0.3523,0.18225},
      {-1.54E-08,1.76E-06,0.70303,0,0.0038941,0.0022482,4.73E-07,0.49724,-0.3516,0.18091},
      {5.60E-08,1.79E-06,0.70117,0,0.0056873,0.0032836,1.07E-06,0.49597,-0.3507,0.17919},
      {1.92E-07,1.81E-06,0.69883,0,0.0079448,0.0045869,1.72E-06,0.49438,-0.34957,0.17703},
      {4.12E-07,1.81E-06,0.69594,0,0.010752,0.0062078,2.40E-06,0.49239,-0.34817,0.17434},
      {7.34E-07,1.79E-06,0.69239,0,0.01421,0.0082043,3.08E-06,0.48995,-0.34644,0.17103},
      {2.03E-06,1.37E-06,0.68324,-3.99E-08,0.014366,-0.0014037,7.89E-06,0.48389,-0.34216,0.16284},
      {4.41E-06,7.62E-07,0.66978,-9.56E-08,0.011793,-0.020404,1.46E-05,0.47498,-0.33585,0.15078},
      {7.64E-06,2.42E-07,0.6546,-1.38E-07,0.008534,-0.042667,2.04E-05,0.4648,-0.32865,0.137},
      {1.35E-05,-1.44E-07,0.63717,-1.61E-07,0.0045322,-0.068803,2.64E-05,0.45303,-0.32032,0.12108},
      {2.30E-05,2.08E-07,0.6075,-6.56E-08,0.001444,-0.1074,2.97E-05,0.43267,-0.30592,0.093511},
      {3.41E-05,1.22E-06,0.55828,1.07E-07,0.0011789,-0.16352,3.02E-05,0.39858,-0.28181,0.047361},
      {4.02E-05,1.62E-06,0.50601,1.30E-07,0.00077059,-0.22353,2.96E-05,0.36226,-0.25613,-0.0018144},
      {3.99E-05,1.29E-06,0.45076,-1.93E-08,0.00017745,-0.28747,2.71E-05,0.32374,-0.2289,-0.053977},
      {2.98E-05,3.03E-06,0.35996,-2.03E-06,8.14E-05,-0.3924,1.64E-05,0.25959,-0.18354,-0.14084},
      {1.98E-05,4.44E-06,0.2649,-5.08E-06,8.20E-05,-0.50207,5.53E-06,0.19243,-0.13606,-0.23178},
      {9.66E-06,4.76E-06,0.172,-9.17E-06,8.07E-05,-0.60914,-5.36E-06,0.12686,-0.089699,-0.32055},
      {4.36E-06,2.59E-05,0.10942,-1.55E-05,6.03E-05,-0.68114,-3.24E-05,0.082753,-0.0585,-0.38023},
      {1.90E-06,4.59E-05,0.063868,-2.33E-05,3.59E-05,-0.73317,-6.03E-05,0.050873,-0.035945,-0.42334},
      {-1.36E-07,5.16E-05,0.021125,-3.19E-05,1.81E-05,-0.78154,-7.96E-05,0.021236,-0.014982,-0.46342},
      {-2.35E-06,0.00011005,-0.001707,-3.85E-05,1.79E-05,-0.79963,-0.00014097,0.010079,-0.0070529,-0.47843},
      {-4.26E-06,0.00015341,-0.010904,-4.20E-05,3.57E-05,-0.79528,-0.00019805,0.012649,-0.0088297,-0.47486},
      {-5.22E-06,0.00012907,-0.02033,-4.44E-05,6.40E-05,-0.78974,-0.0002117,0.015989,-0.011182,-0.47031},
      {-1.03E-05,4.13E-05,-0.044896,-4.40E-05,0.00079018,-0.76255,-0.00020468,0.031868,-0.022409,-0.4488},
      {-1.77E-05,-8.76E-05,-0.085725,-4.13E-05,0.0025959,-0.7124,-0.00019583,0.06067,-0.042772,-0.40981},
      {-2.14E-05,-0.00022,-0.12725,-3.72E-05,0.0049481,-0.66048,-0.00019188,0.089987,-0.063499,-0.37013},
      {-2.95E-05,-0.00031657,-0.17627,-3.03E-05,0.0062269,-0.60165,-0.00022785,0.12463,-0.087957,-0.32318},
      {-4.97E-05,-0.00036654,-0.23506,-2.15E-05,0.0054723,-0.53489,-0.00030926,0.16622,-0.11728,-0.26674},
      {0,5.24E-07,0.70709,0,1.16E-05,6.69E-06,-3.71E-07,0.49999,-0.35355,0.18463},
      {0,5.35E-07,0.70709,0,1.20E-05,6.91E-06,-3.78E-07,0.49999,-0.35355,0.18463},
      {0,5.50E-07,0.70709,0,1.26E-05,7.25E-06,-3.89E-07,0.49999,-0.35355,0.18463},
      {0,5.69E-07,0.70709,0,1.34E-05,7.71E-06,-4.02E-07,0.49999,-0.35355,0.18462},
      {0,5.88E-07,0.70709,0,1.44E-05,8.30E-06,-4.16E-07,0.49999,-0.35355,0.18462},
      {2.41E-07,6.00E-07,0.70536,0,0.0017128,0.00098889,-6.51E-08,0.49879,-0.3527,0.183},
      {6.30E-07,6.03E-07,0.70267,0,0.0043428,0.0025073,4.48E-07,0.49693,-0.35138,0.18048},
      {1.13E-06,5.97E-07,0.69934,0,0.0076129,0.0043953,1.03E-06,0.49461,-0.34974,0.17735},
      {1.74E-06,5.76E-07,0.69526,0,0.01162,0.0067091,1.66E-06,0.49178,-0.34774,0.17351},
      {2.46E-06,5.35E-07,0.69034,0,0.016474,0.0095113,2.32E-06,0.48835,-0.34531,0.16886},
      {3.26E-06,4.70E-07,0.68444,0,0.022293,0.012871,2.96E-06,0.48423,-0.3424,0.16329},
      {5.32E-06,3.29E-07,0.67488,-5.13E-09,0.025605,0.0078637,4.82E-06,0.47765,-0.33775,0.15438},
      {9.96E-06,1.25E-07,0.65809,-1.35E-08,0.021074,-0.01867,8.64E-06,0.4662,-0.32965,0.13889},
      {1.40E-05,1.48E-08,0.63906,-8.45E-09,0.015617,-0.049425,1.08E-05,0.45316,-0.32042,0.12123},
      {1.79E-05,0,0.61719,0,0.008803,-0.085882,1.26E-05,0.43806,-0.30975,0.10079},
      {2.28E-05,5.28E-08,0.58575,-1.01E-08,0.0027137,-0.13213,1.60E-05,0.41619,-0.29428,0.071184},
      {2.80E-05,2.82E-07,0.53215,-8.12E-08,0.0019571,-0.19457,1.94E-05,0.37875,-0.26781,0.020498},
      {3.29E-05,4.60E-07,0.47537,-2.00E-07,0.0011412,-0.26094,2.26E-05,0.33897,-0.23967,-0.033361},
      {3.74E-05,5.71E-07,0.41546,-3.81E-07,0.00028729,-0.33113,2.56E-05,0.29689,-0.20992,-0.090334},
      {3.06E-05,6.17E-07,0.33361,-3.55E-06,4.77E-05,-0.42572,1.80E-05,0.23922,-0.16914,-0.16842},
      {1.99E-05,-3.58E-07,0.24582,-8.86E-06,4.64E-05,-0.52668,6.55E-06,0.17739,-0.12543,-0.25213},
      {9.83E-06,-2.70E-06,0.16082,-1.55E-05,4.37E-05,-0.62437,-4.59E-06,0.11757,-0.083136,-0.33312},
      {4.04E-06,-1.02E-06,0.098662,-2.38E-05,3.40E-05,-0.69534,-2.01E-05,0.07409,-0.052394,-0.39196},
      {2.16E-06,-1.57E-06,0.058683,-3.32E-05,2.19E-05,-0.74017,-3.59E-05,0.046621,-0.032968,-0.42912},
      {7.80E-07,-1.07E-05,0.021771,-4.34E-05,1.48E-05,-0.78112,-4.66E-05,0.021526,-0.015226,-0.46306},
      {-2.98E-07,-1.96E-05,-0.0027705,-5.12E-05,2.32E-05,-0.802,-6.28E-05,0.0086979,-0.0061505,-0.48039},
      {-1.00E-06,-4.39E-05,-0.012207,-5.28E-05,5.68E-05,-0.79586,-7.84E-05,0.012403,-0.0087591,-0.47535},
      {-8.43E-07,-8.88E-05,-0.021727,-5.28E-05,0.00010131,-0.78871,-8.36E-05,0.016733,-0.011817,-0.46948},
      {-1.85E-06,-0.00013802,-0.039502,-5.01E-05,0.00071326,-0.76932,-9.94E-05,0.027943,-0.01973,-0.45428},
      {-7.08E-06,-0.00020151,-0.076487,-4.51E-05,0.0027263,-0.72311,-0.00013275,0.054075,-0.038175,-0.41885},
      {-1.15E-05,-0.00025554,-0.10952,-3.87E-05,0.0047521,-0.68142,-0.0001678,0.077425,-0.05465,-0.3872},
      {-1.74E-05,-0.00030798,-0.1437,-3.07E-05,0.0062419,-0.6393,-0.00020837,0.1016,-0.071699,-0.35442},
      {0,8.23E-08,0.7071,0,6.94E-06,4.01E-06,-5.82E-08,0.5,-0.35355,0.18463},
      {0,8.20E-08,0.7071,0,7.25E-06,4.19E-06,-5.80E-08,0.49999,-0.35355,0.18463},
      {0,8.07E-08,0.7071,0,7.73E-06,4.46E-06,-5.71E-08,0.49999,-0.35355,0.18463},
      {0,7.75E-08,0.7071,0,8.38E-06,4.84E-06,-5.48E-08,0.49999,-0.35355,0.18463},
      {0,7.09E-08,0.7071,0,9.22E-06,5.32E-06,-5.01E-08,0.49999,-0.35355,0.18463},
      {0,5.87E-08,0.7071,0,1.02E-05,5.91E-06,-4.15E-08,0.49999,-0.35355,0.18463},
      {0,3.87E-08,0.7071,0,1.14E-05,6.60E-06,-2.74E-08,0.49999,-0.35355,0.18463},
      {3.71E-07,7.97E-09,0.70382,0,0.0032516,0.0018773,2.60E-07,0.4977,-0.35193,0.18152},
      {9.23E-07,0,0.69885,0,0.0081679,0.0047157,6.53E-07,0.49422,-0.34947,0.17682},
      {1.55E-06,0,0.69341,0,0.013549,0.0078226,1.09E-06,0.49042,-0.34678,0.17166},
      {2.23E-06,0,0.68756,0,0.019344,0.011169,1.58E-06,0.48632,-0.34388,0.16612},
      {2.97E-06,0,0.68139,0,0.025459,0.014699,2.10E-06,0.482,-0.34082,0.16026},
      {3.94E-06,0,0.67429,0,0.031069,0.016302,2.78E-06,0.47703,-0.33731,0.15353},
      {8.35E-06,0,0.65183,0,0.024032,-0.021361,5.91E-06,0.46142,-0.32627,0.13241},
      {1.29E-05,0,0.62473,0,0.016875,-0.064642,9.09E-06,0.44251,-0.31289,0.1068},
      {1.73E-05,0,0.59226,0,0.0097417,-0.11413,1.23E-05,0.41977,-0.29681,0.076016},
      {2.17E-05,5.31E-09,0.55308,-8.17E-09,0.0030693,-0.17064,1.53E-05,0.39223,-0.27734,0.038743},
      {2.56E-05,8.51E-08,0.49707,-2.19E-07,0.0021501,-0.23649,1.79E-05,0.35288,-0.24951,-0.014536},
      {2.90E-05,9.13E-08,0.43797,-5.12E-07,0.0012395,-0.30601,2.00E-05,0.31127,-0.22009,-0.070875},
      {3.16E-05,8.37E-09,0.37585,-9.06E-07,0.00036918,-0.37907,2.16E-05,0.26745,-0.1891,-0.13021},
      {2.62E-05,-1.59E-06,0.30139,-5.10E-06,2.35E-05,-0.46528,1.52E-05,0.21502,-0.15203,-0.20118},
      {1.64E-05,-5.38E-06,0.22162,-1.31E-05,2.14E-05,-0.55678,3.85E-06,0.15898,-0.11242,-0.27705},
      {7.88E-06,-1.08E-05,0.14524,-2.28E-05,1.86E-05,-0.64437,-6.99E-06,0.10534,-0.074495,-0.34967},
      {2.79E-06,-1.83E-05,0.085082,-3.37E-05,1.47E-05,-0.71282,-1.76E-05,0.063401,-0.044849,-0.40643},
      {1.60E-06,-2.97E-05,0.050965,-4.48E-05,1.20E-05,-0.75024,-2.73E-05,0.040465,-0.028636,-0.43745},
      {9.65E-07,-4.33E-05,0.020014,-5.85E-05,1.28E-05,-0.78349,-3.59E-05,0.020077,-0.014227,-0.46502},
      {8.55E-07,-6.13E-05,-0.0033824,-7.02E-05,2.33E-05,-0.80472,-4.52E-05,0.0070352,-0.0050105,-0.48264},
      {8.36E-07,-8.93E-05,-0.011992,-7.02E-05,6.64E-05,-0.79789,-6.11E-05,0.01116,-0.0079158,-0.47703},
      {7.07E-07,-0.00011416,-0.019855,-6.65E-05,0.00011855,-0.7912,-7.82E-05,0.015186,-0.010745,-0.47156},
      {1.52E-07,-0.00014069,-0.029622,-5.72E-05,0.00035411,-0.7814,-9.63E-05,0.020933,-0.014786,-0.46377},
      {-3.93E-06,-0.00019255,-0.060959,-5.03E-05,0.0021452,-0.74207,-0.00013008,0.043087,-0.030417,-0.43374},
      {-6.93E-06,-0.00024048,-0.088344,-4.17E-05,0.0037749,-0.70759,-0.00016189,0.062449,-0.044074,-0.40749},
      {0,0,0.7071,0,3.64E-06,2.10E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.88E-06,2.24E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.25E-06,2.45E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.76E-06,2.75E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.40E-06,3.12E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.18E-06,3.57E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.07E-06,4.08E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.07E-06,4.66E-06,0,0.49999,-0.35355,0.18463},
      {2.07E-08,0,0.70693,0,0.00017646,0.00010188,1.47E-08,0.49988,-0.35347,0.18447},
      {6.25E-07,0,0.70204,0,0.0050222,0.0028996,4.42E-07,0.49645,-0.35104,0.17983},
      {1.27E-06,0,0.69686,0,0.010165,0.0058688,9.01E-07,0.49281,-0.34847,0.1749},
      {1.95E-06,0,0.69149,0,0.015494,0.0089456,1.38E-06,0.48904,-0.3458,0.1698},
      {2.65E-06,0,0.68607,0,0.020876,0.012053,1.88E-06,0.48524,-0.34311,0.16465},
      {3.35E-06,0,0.68076,0,0.026154,0.0151,2.37E-06,0.4815,-0.34047,0.1596},
      {6.76E-06,0,0.65254,0,0.021661,-0.02505,4.78E-06,0.46168,-0.32645,0.13276},
      {1.06E-05,0,0.6139,0,0.015151,-0.080741,7.50E-06,0.43448,-0.30722,0.095931},
      {1.41E-05,0,0.56871,0,0.0089447,-0.14351,9.99E-06,0.40262,-0.28469,0.0528},
      {1.71E-05,0,0.51616,0,0.0032331,-0.21397,1.21E-05,0.36553,-0.25846,0.0025764},
      {1.93E-05,-9.98E-08,0.45792,-3.81E-07,0.0018532,-0.28347,1.34E-05,0.32443,-0.2294,-0.053065},
      {2.05E-05,-3.03E-07,0.39668,-9.20E-07,0.0010312,-0.35553,1.39E-05,0.28118,-0.19881,-0.11163},
      {2.05E-05,-6.17E-07,0.33252,-1.60E-06,0.00033158,-0.43083,1.36E-05,0.2358,-0.16673,-0.17306},
      {1.68E-05,-3.60E-06,0.26335,-7.07E-06,8.20E-06,-0.51085,8.48E-06,0.18714,-0.13232,-0.23895},
      {9.25E-06,-1.08E-05,0.19216,-1.98E-05,6.75E-06,-0.59219,-2.48E-06,0.13731,-0.097101,-0.30639},
      {3.44E-06,-1.99E-05,0.12438,-3.54E-05,5.04E-06,-0.66961,-1.29E-05,0.089877,-0.063575,-0.37058},
      {5.46E-07,-3.12E-05,0.06701,-5.30E-05,3.78E-06,-0.7347,-2.22E-05,0.049987,-0.035383,-0.42455},
      {4.24E-07,-4.48E-05,0.040127,-6.97E-05,7.83E-06,-0.76301,-3.12E-05,0.032614,-0.023109,-0.44803},
      {6.09E-07,-5.88E-05,0.01663,-8.89E-05,1.45E-05,-0.78711,-4.09E-05,0.017813,-0.012655,-0.46802},
      {7.40E-07,-7.40E-05,-0.003413,-0.00010838,2.42E-05,-0.80652,-5.15E-05,0.005878,-0.0042272,-0.48413},
      {6.47E-07,-9.81E-05,-0.010742,-0.00010213,7.46E-05,-0.80019,-6.82E-05,0.0096883,-0.0069029,-0.47896},
      {5.73E-07,-0.00012075,-0.017353,-8.92E-05,0.00012879,-0.79433,-8.38E-05,0.013223,-0.0093778,-0.47417},
      {5.10E-07,-0.00014143,-0.023173,-6.87E-05,0.00018489,-0.78902,-9.83E-05,0.016433,-0.011617,-0.46985},
      {-1.90E-06,-0.00018418,-0.046645,-5.78E-05,0.001393,-0.75992,-0.00012686,0.032955,-0.023266,-0.44745},
      {0,0,0.70711,0,1.22E-06,7.02E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.40E-06,8.06E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.67E-06,9.65E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.05E-06,1.18E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.52E-06,1.45E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.09E-06,1.78E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.73E-06,2.16E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.45E-06,2.57E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.21E-06,3.01E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.99E-06,3.46E-06,0,0.5,-0.35355,0.18463},
      {2.91E-07,0,0.7049,0,0.0021977,0.0012688,2.06E-07,0.49845,-0.35245,0.18253},
      {8.66E-07,0,0.70056,0,0.0065041,0.0037551,6.12E-07,0.4954,-0.3503,0.17841},
      {1.43E-06,0,0.69633,0,0.010715,0.0061864,1.01E-06,0.49242,-0.34819,0.17438},
      {1.97E-06,0,0.69236,0,0.014664,0.0084663,1.40E-06,0.48963,-0.34622,0.1706},
      {2.46E-06,0,0.68885,0,0.01816,0.010485,1.74E-06,0.48716,-0.34447,0.16725},
      {4.53E-06,0,0.65969,0,0.015892,-0.027049,3.20E-06,0.46658,-0.32992,0.13939},
      {7.68E-06,0,0.60864,0,0.01049,-0.095263,5.43E-06,0.43053,-0.30443,0.090584},
      {1.05E-05,0,0.55092,0,0.0058121,-0.16995,7.39E-06,0.38976,-0.27559,0.035375},
      {1.24E-05,0,0.48596,0,0.0020519,-0.25142,8.77E-06,0.34385,-0.24313,-0.02678},
      {1.22E-05,-4.50E-07,0.42324,-9.66E-07,0.00079261,-0.32593,8.24E-06,0.29956,-0.21181,-0.086748},
      {9.92E-06,-1.32E-06,0.35955,-2.76E-06,0.00033091,-0.40019,6.00E-06,0.25457,-0.18001,-0.14765},
      {5.70E-06,-2.55E-06,0.29193,-5.22E-06,6.62E-05,-0.47867,2.17E-06,0.20679,-0.14623,-0.21235},
      {1.19E-08,-6.49E-06,0.22304,-1.25E-05,1.76E-07,-0.55805,-4.58E-06,0.15824,-0.1119,-0.27807},
      {4.86E-08,-1.71E-05,0.16287,-3.34E-05,8.69E-07,-0.62659,-1.21E-05,0.11623,-0.082215,-0.3349},
      {7.97E-08,-2.91E-05,0.10514,-5.90E-05,1.72E-06,-0.69233,-2.05E-05,0.075929,-0.053734,-0.38942},
      {1.11E-07,-4.26E-05,0.051776,-8.92E-05,2.95E-06,-0.75299,-3.00E-05,0.038731,-0.027454,-0.43971},
      {2.71E-07,-5.69E-05,0.031036,-0.00010963,1.02E-05,-0.7738,-4.00E-05,0.025941,-0.018424,-0.45698},
      {3.91E-07,-7.22E-05,0.012939,-0.00013192,1.87E-05,-0.79141,-5.07E-05,0.015106,-0.010777,-0.47159},
      {4.71E-07,-8.88E-05,-0.0023889,-0.00015651,2.84E-05,-0.80571,-6.23E-05,0.0062893,-0.004559,-0.48346},
      {4.37E-07,-0.0001097,-0.009427,-0.00014549,7.38E-05,-0.80265,-7.69E-05,0.0081137,-0.0058274,-0.481},
      {3.88E-07,-0.0001293,-0.014726,-0.00012132,0.00012442,-0.79776,-9.06E-05,0.011075,-0.0078874,-0.47701},
      {3.29E-07,-0.00014653,-0.019189,-8.82E-05,0.00017308,-0.79353,-0.00010277,0.013654,-0.0096693,-0.47357},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.41E-08,4.28E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.24E-07,1.87E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.33E-07,3.66E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.93E-07,5.73E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.39E-06,8.02E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.80E-06,1.04E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.22E-06,1.28E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.60E-06,1.50E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.93E-06,1.69E-06,0,0.5,-0.35355,0.18463},
      {5.10E-08,0,0.70684,0,0.00026265,0.00015164,3.61E-08,0.49981,-0.35342,0.18439},
      {6.03E-07,0,0.70418,0,0.0029072,0.0016785,4.26E-07,0.49794,-0.3521,0.18185},
      {1.12E-06,0,0.70197,0,0.005106,0.002948,7.92E-07,0.49639,-0.351,0.17975},
      {1.55E-06,0,0.70038,0,0.0066881,0.0038614,1.10E-06,0.49527,-0.35021,0.17823},
      {1.84E-06,0,0.69958,0,0.0074728,0.0043144,1.30E-06,0.49471,-0.34982,0.17748},
      {2.59E-06,0,0.67582,0,0.0060145,-0.025623,1.83E-06,0.47793,-0.33794,0.15475},
      {3.31E-06,0,0.61304,0,0.0029744,-0.10334,2.34E-06,0.43356,-0.30657,0.094677},
      {2.30E-06,0,0.54299,0,0.00086444,-0.18786,1.63E-06,0.38404,-0.27156,0.027633},
      {0,0,0.46542,0,0,-0.27892,0,0.3292,-0.23278,-0.046632},
      {0,-9.22E-07,0.39472,-1.97E-06,0,-0.36049,-6.52E-07,0.27924,-0.19746,-0.11426},
      {0,-2.97E-06,0.32911,-6.53E-06,0,-0.43615,-2.10E-06,0.2329,-0.16469,-0.177},
      {0,-5.74E-06,0.26057,-1.29E-05,0,-0.5152,-4.06E-06,0.18448,-0.13046,-0.24255},
      {4.45E-09,-1.06E-05,0.19179,-2.42E-05,1.32E-07,-0.59441,-7.53E-06,0.13595,-0.096154,-0.30823},
      {3.06E-08,-2.38E-05,0.13787,-5.41E-05,1.07E-06,-0.65579,-1.68E-05,0.098315,-0.069562,-0.35912},
      {5.15E-08,-3.82E-05,0.087147,-8.89E-05,2.15E-06,-0.71352,-2.70E-05,0.062903,-0.044549,-0.40699},
      {6.68E-08,-5.40E-05,0.04031,-0.00012886,3.36E-06,-0.76683,-3.81E-05,0.03019,-0.02145,-0.45119},
      {1.55E-07,-7.00E-05,0.021552,-0.00015522,1.15E-05,-0.78545,-4.93E-05,0.018728,-0.013363,-0.46664},
      {2.19E-07,-8.72E-05,0.0084125,-0.00018201,2.16E-05,-0.79724,-6.14E-05,0.011448,-0.0082332,-0.47643},
      {2.49E-07,-0.0001058,-0.0021745,-0.00021199,3.28E-05,-0.80607,-7.46E-05,0.0059731,-0.0043825,-0.48377},
      {2.26E-07,-0.00012434,-0.0080997,-0.00020135,6.76E-05,-0.80516,-8.76E-05,0.0064947,-0.0047314,-0.48307},
      {1.67E-07,-0.00014093,-0.012052,-0.0001709,0.00011155,-0.80133,-9.93E-05,0.0088299,-0.0063439,-0.47995},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.51E-07,8.74E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.10E-07,1.79E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.53E-07,2.61E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.64E-07,3.26E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.29E-07,3.63E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.32E-07,3.65E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.60E-07,3.23E-07,0,0.5,-0.35355,0.18464},
      {1.23E-07,0,0.70672,0,0.00038086,0.00021989,8.69E-08,0.49973,-0.35336,0.18427},
      {1.02E-07,0,0.70679,0,0.00030418,0.00017562,7.20E-08,0.49978,-0.3534,0.18435},
      {0,0,0.70709,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70708,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69101,0,0,-0.018553,0,0.48864,-0.34552,0.16925},
      {0,0,0.61677,0,0,-0.10426,0,0.43615,-0.30841,0.098189},
      {0,0,0.53663,0,0,-0.19678,0,0.3795,-0.26835,0.021478},
      {0,0,0.45032,0,0,-0.29643,0,0.31848,-0.2252,-0.061148},
      {0,-1.41E-06,0.37022,-3.30E-06,0,-0.38887,-9.98E-07,0.26186,-0.18516,-0.1378},
      {0,-5.14E-06,0.30149,-1.22E-05,0,-0.46815,-3.63E-06,0.2133,-0.15083,-0.20353},
      {0,-9.82E-06,0.22991,-2.35E-05,0,-0.55072,-6.94E-06,0.16271,-0.11507,-0.272},
      {2.20E-10,-1.57E-05,0.15587,-3.79E-05,1.25E-08,-0.63613,-1.11E-05,0.11038,-0.078083,-0.34282},
      {1.69E-08,-3.11E-05,0.10937,-7.67E-05,1.16E-06,-0.68904,-2.20E-05,0.077922,-0.05516,-0.38668},
      {2.88E-08,-4.77E-05,0.066817,-0.0001206,2.43E-06,-0.73745,-3.37E-05,0.048196,-0.034177,-0.42683},
      {3.57E-08,-6.55E-05,0.028895,-0.00016983,3.82E-06,-0.78061,-4.63E-05,0.021683,-0.015469,-0.46262},
      {6.86E-08,-8.33E-05,0.01226,-0.00020666,1.17E-05,-0.79727,-5.88E-05,0.011408,-0.0082317,-0.47644},
      {8.69E-08,-0.00010285,0.0040113,-0.00025007,2.25E-05,-0.80369,-7.27E-05,0.0073936,-0.0054266,-0.48178},
      {7.61E-08,-0.00012538,-0.0022889,-0.00031052,3.37E-05,-0.8081,-8.86E-05,0.0045779,-0.0034848,-0.48545},
      {2.30E-08,-0.00014602,-0.0064493,-0.00032978,6.23E-05,-0.80771,-0.00010321,0.004743,-0.0036106,-0.48517},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70273,0,0,-0.0050371,0,0.49692,-0.35137,0.18046},
      {0,0,0.61989,0,0,-0.10069,0,0.43834,-0.30995,0.10115},
      {0,0,0.53069,0,0,-0.20368,0,0.37527,-0.26536,0.015755},
      {0,0,0.43483,0,0,-0.31436,0,0.3075,-0.21743,-0.076015},
      {0,-1.59E-06,0.34308,-3.88E-06,0,-0.42028,-1.13E-06,0.24262,-0.17156,-0.16384},
      {0,-7.39E-06,0.27141,-1.81E-05,0,-0.50296,-5.23E-06,0.19197,-0.13576,-0.23239},
      {0,-1.45E-05,0.19605,-3.57E-05,0,-0.58989,-1.03E-05,0.13871,-0.098109,-0.30447},
      {0,-2.34E-05,0.11808,-5.74E-05,0,-0.67984,-1.65E-05,0.083585,-0.059149,-0.37906},
      {6.75E-09,-3.94E-05,0.075727,-0.00010122,1.05E-06,-0.7282,-2.79E-05,0.053898,-0.038193,-0.41916},
      {1.04E-08,-5.66E-05,0.044144,-0.00015102,2.25E-06,-0.76417,-4.01E-05,0.03179,-0.022602,-0.44898},
      {9.68E-09,-7.42E-05,0.018469,-0.00020392,3.43E-06,-0.79344,-5.24E-05,0.013775,-0.0099072,-0.47325},
      {8.81E-09,-9.46E-05,0.0058349,-0.0002632,1.00E-05,-0.80629,-6.69E-05,0.0058018,-0.0043184,-0.48392},
      {0,-0.00011842,0.0011625,-0.00033718,2.06E-05,-0.80903,-8.37E-05,0.00399,-0.0030994,-0.4862},
      {0,-0.0001426,-0.0020737,-0.00042221,3.02E-05,-0.8103,-0.00010084,0.0030633,-0.002517,-0.48727},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62394,0,0,-0.096029,0,0.44119,-0.31197,0.10501},
      {0,0,0.52315,0,0,-0.2124,0,0.36993,-0.26158,0.0085261},
      {0,0,0.41417,0,0,-0.33824,0,0.29287,-0.20709,-0.095814},
      {0,-1.38E-06,0.30483,-3.36E-06,0,-0.46447,-9.76E-07,0.21556,-0.15243,-0.20048},
      {0,-1.03E-05,0.23074,-2.50E-05,0,-0.54995,-7.30E-06,0.16319,-0.11541,-0.27135},
      {0,-2.10E-05,0.15567,-5.06E-05,0,-0.63655,-1.48E-05,0.11011,-0.077899,-0.34316},
      {0,-3.36E-05,0.080291,-8.05E-05,0,-0.72351,-2.37E-05,0.056804,-0.040231,-0.41527},
      {4.23E-10,-4.97E-05,0.04221,-0.00012654,7.87E-07,-0.76719,-3.51E-05,0.02998,-0.021301,-0.45148},
      {0,-6.59E-05,0.024345,-0.00017773,1.78E-06,-0.7875,-4.66E-05,0.017459,-0.01249,-0.46832},
      {0,-8.08E-05,0.01083,-0.000227,2.62E-06,-0.80282,-5.71E-05,0.0079962,-0.0058408,-0.48103},
      {0,-9.91E-05,0.0030389,-0.00029109,6.96E-06,-0.81065,-7.01E-05,0.0030921,-0.002428,-0.48753},
      {0,-0.00012443,0.00042296,-0.00038738,1.58E-05,-0.81146,-8.80E-05,0.0024347,-0.0020467,-0.48821},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62864,0,0,-0.090607,0,0.44451,-0.31432,0.10951},
      {0,0,0.51427,0,0,-0.22266,0,0.36365,-0.25714,1.55E-05},
      {0,0,0.3912,0,0,-0.36476,0,0.27663,-0.19561,-0.11781},
      {0,-3.89E-07,0.26121,-9.22E-07,0,-0.51486,-2.75E-07,0.18471,-0.13061,-0.24226},
      {0,-1.29E-05,0.19038,-3.05E-05,0,-0.59657,-9.12E-06,0.13463,-0.095219,-0.31001},
      {0,-2.69E-05,0.12265,-6.42E-05,0,-0.67469,-1.90E-05,0.086729,-0.061377,-0.37479},
      {0,-4.24E-05,0.057708,-0.00010188,0,-0.7496,-3.00E-05,0.040794,-0.028926,-0.43689},
      {0,-5.76E-05,0.024561,-0.00014652,4.54E-07,-0.78767,-4.07E-05,0.017404,-0.012424,-0.46847},
      {0,-7.11E-05,0.014308,-0.00019275,1.12E-06,-0.79927,-5.03E-05,0.010227,-0.0073884,-0.47808},
      {0,-8.38E-05,0.0063392,-0.00023707,1.65E-06,-0.80827,-5.92E-05,0.0046411,-0.0034769,-0.48555},
      {0,-9.96E-05,0.0013891,-0.00029792,3.99E-06,-0.81339,-7.04E-05,0.0014086,-0.0012442,-0.48979},
      {0.16969,0.020441,0.0064497,-0.091255,0.00185,0.00018346,0.32257,-0.0613,0.2429,0.17493},
      {0.13758,0.029424,0.0041333,-0.12414,0.0026566,0.00050323,0.29104,-0.086879,0.21039,0.17479},
      {0.098192,0.044053,0.0017194,-0.1731,0.0043428,0.0012513,0.24216,-0.1246,0.15979,0.17418},
      {0.070671,0.057888,-0.00078624,-0.24174,0.0083063,0.0035363,0.17768,-0.17892,0.083688,0.17161},
      {0.051238,0.067389,-0.0029127,-0.32935,0.015896,0.0079586,0.10055,-0.25107,-0.021638,0.16565},
      {0.036046,0.077467,-0.0053277,-0.39563,0.027474,0.014519,0.030035,-0.31079,-0.11262,0.15558},
      {0.027391,0.089841,-0.0098834,-0.37359,0.061697,0.034153,-0.012256,-0.30831,-0.13511,0.12289},
      {0.019395,0.11011,-0.015888,-0.31016,0.11118,0.06261,-0.050652,-0.27795,-0.12875,0.075516},
      {0.0080955,0.12978,-0.02281,-0.22222,0.1738,0.098759,-0.08311,-0.2344,-0.11203,0.015705},
      {0.002399,0.13495,-0.030354,-0.1283,0.22616,0.12918,-0.095043,-0.19444,-0.096706,-0.03417},
      {0.0016149,0.12504,-0.039809,-0.077624,0.26629,0.15268,-0.089139,-0.16043,-0.087806,-0.072204},
      {0.0010029,0.11297,-0.047755,-0.023834,0.32005,0.18406,-0.081323,-0.12062,-0.074287,-0.12326},
      {0.00057866,0.097603,-0.053817,0.03379,0.38759,0.22339,-0.070667,-0.076582,-0.057349,-0.18749},
      {0.00031627,0.074483,-0.057162,0.06336,0.44624,0.25755,-0.054038,-0.048323,-0.05266,-0.24317},
      {0.00025953,0.062988,-0.05648,0.060351,0.47116,0.27196,-0.045672,-0.040257,-0.052307,-0.26692},
      {0.0002314,0.055946,-0.055651,0.050809,0.49826,0.28755,-0.040455,-0.0276,-0.046305,-0.29284},
      {0.00019718,0.048012,-0.054888,0.034937,0.53522,0.30884,-0.034654,-0.0084945,-0.036213,-0.32817},
      {0.00013813,0.037425,-0.05625,0.022439,0.56383,0.32533,-0.027003,0.0058357,-0.032934,-0.3555},
      {6.84E-05,0.025507,-0.059885,0.016589,0.5794,0.33435,-0.018432,0.013217,-0.037485,-0.37033},
      {4.45E-05,0.02031,-0.070076,0.011173,0.58276,0.33628,-0.014671,0.026173,-0.041202,-0.37351},
      {3.23E-05,0.016852,-0.082368,0.0047291,0.58419,0.33708,-0.01218,0.04206,-0.044038,-0.37488},
      {2.56E-05,0.013796,-0.096637,-0.0019482,0.58292,0.3363,-0.010004,0.059161,-0.047764,-0.37368},
      {2.56E-05,0.010354,-0.11284,-0.0025009,0.57084,0.32931,-0.0075228,0.071052,-0.057312,-0.36212},
      {3.56E-05,0.0071645,-0.12473,-0.0030355,0.56347,0.32509,-0.0051987,0.080319,-0.064284,-0.35503},
      {9.98E-05,0.0048398,-0.13452,-0.0033892,0.55781,0.32187,-0.0034676,0.088486,-0.069453,-0.34958},
      {0.00023366,0.0030712,-0.14202,-0.003845,0.55475,0.32013,-0.0020981,0.095727,-0.072667,-0.34663},
      {0.00044394,0.0013843,-0.15021,-0.004118,0.55031,0.31759,-0.00073343,0.10306,-0.076415,-0.34235},
      {0.00072679,0.00065404,-0.16555,-0.0033634,0.53626,0.30952,3.35E-06,0.11446,-0.08393,-0.32887},
      {0.0010569,0.00020391,-0.17428,-0.0026262,0.5285,0.30507,0.00057539,0.12119,-0.087976,-0.32141},
      {0.0013468,-2.57E-06,-0.17876,-0.0019121,0.52479,0.30296,0.0009417,0.12491,-0.089781,-0.31784},
      {0.0012446,-1.36E-06,-0.1862,-0.0011951,0.51832,0.29923,0.00087389,0.13076,-0.093132,-0.31163},
      {0.00097993,-5.87E-07,-0.19053,-0.00071128,0.51483,0.29723,0.00068977,0.13422,-0.095146,-0.30829},
      {0.23263,0.022677,0.0085779,-0.082582,0.0018641,0.00047416,0.31268,-0.053759,0.24811,0.17433},
      {0.21193,0.031346,0.0055252,-0.10756,0.0025999,0.00089363,0.28552,-0.07413,0.22459,0.1741},
      {0.18024,0.046441,0.0030832,-0.15163,0.0043959,0.0017837,0.23826,-0.1085,0.1787,0.17331},
      {0.15365,0.066152,1.67E-06,-0.20251,0.0070552,0.0032281,0.17912,-0.14893,0.1245,0.17186},
      {0.13194,0.076127,-0.0020926,-0.28142,0.014754,0.0076396,0.1063,-0.21502,0.027589,0.16569},
      {0.079865,0.09997,-0.0065445,-0.31507,0.032791,0.017505,0.03483,-0.24943,-0.034271,0.14919},
      {0.053305,0.12602,-0.011765,-0.30043,0.062813,0.034468,-0.023635,-0.25101,-0.059422,0.12069},
      {0.045196,0.14419,-0.017044,-0.24653,0.10758,0.060298,-0.062092,-0.2272,-0.058502,0.077895},
      {0.03109,0.15786,-0.023472,-0.16706,0.16511,0.093573,-0.094153,-0.19529,-0.054668,0.023},
      {0.0096404,0.16024,-0.034503,-0.10207,0.2225,0.12678,-0.11035,-0.16372,-0.060161,-0.031405},
      {0.001973,0.15106,-0.045097,-0.054789,0.26945,0.15421,-0.10766,-0.13142,-0.0589,-0.07573},
      {0.0012821,0.13708,-0.052687,-0.0073631,0.32068,0.18416,-0.098549,-0.095394,-0.048753,-0.12433},
      {0.00079062,0.12009,-0.058461,0.044977,0.38604,0.22227,-0.086804,-0.054558,-0.034674,-0.18643},
      {0.0004915,0.092795,-0.061878,0.057148,0.43263,0.24945,-0.0672,-0.037516,-0.040243,-0.23052},
      {0.00029619,0.070339,-0.061797,0.053658,0.47,0.27126,-0.050928,-0.028192,-0.04534,-0.26586},
      {0.00026832,0.062819,-0.060896,0.045188,0.49631,0.28639,-0.045364,-0.016547,-0.04023,-0.29102},
      {0.00023437,0.054485,-0.06006,0.03023,0.5326,0.30729,-0.039273,0.0016901,-0.030888,-0.32571},
      {0.00016669,0.042808,-0.06232,0.021153,0.55514,0.32026,-0.030839,0.012219,-0.031753,-0.34724},
      {9.44E-05,0.030355,-0.066117,0.015532,0.57078,0.32931,-0.021887,0.019499,-0.036811,-0.36214},
      {4.82E-05,0.021507,-0.072708,0.0097281,0.58177,0.3357,-0.01553,0.030073,-0.040469,-0.37257},
      {3.63E-05,0.017905,-0.086082,0.003661,0.58191,0.33575,-0.012948,0.04649,-0.044076,-0.37272},
      {2.98E-05,0.014582,-0.10187,-0.0018256,0.57756,0.33318,-0.010582,0.063374,-0.049606,-0.36857},
      {2.95E-05,0.011028,-0.11894,-0.0023901,0.56466,0.32572,-0.0080213,0.075839,-0.059676,-0.35623},
      {3.92E-05,0.0077413,-0.13161,-0.0029336,0.55655,0.32108,-0.005628,0.085613,-0.067114,-0.34844},
      {8.20E-05,0.0049757,-0.14054,-0.0034095,0.55227,0.31866,-0.0035827,0.093175,-0.072091,-0.34429},
      {0.00021255,0.003153,-0.14854,-0.0038466,0.54867,0.31661,-0.0021764,0.1007,-0.075636,-0.34081},
      {0.000421,0.0014911,-0.15918,-0.0039591,0.54141,0.31245,-0.00083046,0.10953,-0.080771,-0.33383},
      {0.00069813,0.00073637,-0.17497,-0.0032382,0.52691,0.30412,-7.96E-05,0.12122,-0.088543,-0.31992},
      {0.0010233,0.00026572,-0.18408,-0.00253,0.51877,0.29945,0.00050428,0.12819,-0.092803,-0.3121},
      {0.0013922,1.07E-05,-0.18718,-0.0018662,0.51636,0.29809,0.00096332,0.1309,-0.093938,-0.30976},
      {0.0013286,-1.41E-06,-0.1941,-0.0011753,0.51036,0.29464,0.00093317,0.13636,-0.097029,-0.30401},
      {0.0010378,-6.52E-07,-0.19874,-0.00071977,0.50656,0.29245,0.00073054,0.14002,-0.099225,-0.30037},
      {0.32949,0.02371,0.014914,-0.068311,0.0017278,0.00087345,0.29672,-0.039465,0.25395,0.17345},
      {0.33358,0.029398,0.0087749,-0.075289,0.0017586,0.0012265,0.28232,-0.048621,0.25353,0.17343},
      {0.30977,0.044636,0.0063756,-0.11337,0.0035874,0.002207,0.23756,-0.078796,0.2135,0.17253},
      {0.26225,0.063998,0.0031808,-0.1497,0.0063565,0.0035383,0.18801,-0.10838,0.17437,0.17087},
      {0.21892,0.086686,-0.00060116,-0.18028,0.012103,0.0065331,0.13208,-0.13541,0.13597,0.1662},
      {0.17395,0.11132,-0.0047323,-0.20316,0.029496,0.016134,0.064779,-0.1614,0.086291,0.15016},
      {0.12984,0.14827,-0.010337,-0.20142,0.054238,0.029871,-0.0090715,-0.17138,0.053348,0.12692},
      {0.083702,0.19145,-0.017374,-0.17454,0.087815,0.048626,-0.086077,-0.16948,0.030666,0.095067},
      {0.057012,0.19651,-0.025339,-0.1223,0.13987,0.078631,-0.11546,-0.15171,0.014205,0.045449},
      {0.027901,0.19522,-0.037056,-0.078255,0.19519,0.11057,-0.13082,-0.12843,-0.0032893,-0.0069163},
      {0.0086874,0.1882,-0.050045,-0.032102,0.2564,0.14623,-0.13363,-0.096191,-0.013242,-0.064447},
      {0.0015981,0.17404,-0.06064,0.011452,0.3166,0.18145,-0.12516,-0.059728,-0.01223,-0.12109},
      {0.0010572,0.15175,-0.066374,0.046725,0.37148,0.21351,-0.10961,-0.030095,-0.0088459,-0.17311},
      {0.0007381,0.12025,-0.070097,0.048725,0.41007,0.23603,-0.08692,-0.021249,-0.022761,-0.20948},
      {0.00047284,0.094032,-0.070186,0.046362,0.4498,0.25925,-0.067873,-0.012984,-0.030823,-0.24698},
      {0.00032742,0.073361,-0.069094,0.03767,0.49185,0.28376,-0.052885,-0.00041075,-0.031651,-0.28683},
      {0.00029401,0.064494,-0.068157,0.023812,0.52747,0.30426,-0.046406,0.016817,-0.023199,-0.32087},
      {0.00020923,0.050825,-0.071983,0.019365,0.54141,0.31224,-0.036549,0.022069,-0.030381,-0.33421},
      {0.00013337,0.037573,-0.076063,0.014041,0.55718,0.32134,-0.027029,0.029268,-0.036184,-0.34924},
      {6.57E-05,0.025114,-0.079392,0.0080128,0.57527,0.33189,-0.018107,0.037593,-0.040003,-0.36641},
      {4.26E-05,0.019418,-0.092423,0.0021589,0.57773,0.3333,-0.014056,0.05365,-0.04457,-0.36874},
      {3.59E-05,0.015722,-0.11076,-0.0016451,0.56851,0.32792,-0.011424,0.070434,-0.052906,-0.35994},
      {3.52E-05,0.012009,-0.12911,-0.0022237,0.55441,0.31976,-0.0087498,0.083735,-0.06374,-0.34645},
      {4.43E-05,0.0085828,-0.14291,-0.0027776,0.54522,0.31449,-0.0062574,0.094247,-0.07186,-0.33762},
      {6.71E-05,0.0053878,-0.15144,-0.0033589,0.54178,0.31258,-0.0039063,0.1015,-0.076896,-0.33427},
      {0.00017717,0.0032448,-0.15902,-0.0038345,0.53886,0.31094,-0.0022747,0.10863,-0.080471,-0.33143},
      {0.00038238,0.0016383,-0.17357,-0.0037254,0.52715,0.30421,-0.00096989,0.11988,-0.087779,-0.32018},
      {0.00065121,0.00084994,-0.18997,-0.0030538,0.51203,0.29551,-0.00019974,0.13197,-0.095905,-0.30568},
      {0.00096904,0.00035106,-0.1996,-0.0023882,0.50337,0.29055,0.00040023,0.13927,-0.10046,-0.29736},
      {0.0013316,7.27E-05,-0.20312,-0.0017612,0.50052,0.28894,0.0008726,0.14226,-0.10184,-0.29461},
      {0.0014605,-1.45E-06,-0.20653,-0.0011465,0.49783,0.2874,0.0010262,0.14518,-0.10316,-0.29201},
      {0.0011234,-7.56E-07,-0.21163,-0.00073172,0.49357,0.28495,0.0007909,0.14912,-0.10563,-0.28794},
      {0.39294,0.0186,0.032008,-0.048098,0.0010028,0.00083104,0.28113,-0.013393,0.25555,0.17309},
      {0.38885,0.022996,0.025706,-0.052062,0.0010224,0.0011093,0.27014,-0.020573,0.25826,0.1731},
      {0.38529,0.029124,0.016456,-0.056406,0.0010663,0.0015174,0.25443,-0.030115,0.2635,0.17306},
      {0.35962,0.045052,0.010875,-0.074341,0.0032128,0.0027428,0.21704,-0.047722,0.24673,0.17148},
      {0.32389,0.069716,0.006943,-0.094445,0.0072312,0.0048099,0.16497,-0.066281,0.22229,0.1683},
      {0.29,0.098688,0.0019867,-0.1065,0.012391,0.0075945,0.10521,-0.080198,0.20423,0.1637},
      {0.24011,0.13044,-0.0039471,-0.1092,0.032429,0.018889,0.029337,-0.094535,0.17075,0.14449},
      {0.16129,0.17787,-0.013402,-0.10388,0.065168,0.036539,-0.059523,-0.10557,0.12658,0.11324},
      {0.083638,0.23207,-0.026427,-0.088929,0.1033,0.057087,-0.13979,-0.10629,0.088911,0.077475},
      {0.041088,0.24838,-0.038866,-0.055038,0.15538,0.086814,-0.17154,-0.090329,0.064437,0.028629},
      {0.019761,0.23935,-0.051162,-0.014151,0.21812,0.12343,-0.17342,-0.062489,0.048996,-0.030222},
      {0.0066251,0.22445,-0.064818,0.026089,0.2883,0.16454,-0.16453,-0.0253,0.040674,-0.095844},
      {0.0013918,0.18985,-0.079612,0.035984,0.3378,0.19351,-0.13701,-0.0065769,0.014263,-0.14164},
      {0.0010192,0.15943,-0.08243,0.040849,0.37198,0.21341,-0.11493,-0.0015613,-0.001097,-0.17383},
      {0.00072991,0.1314,-0.082588,0.03908,0.41313,0.23741,-0.094554,0.0064161,-0.010407,-0.21267},
      {0.00051258,0.10253,-0.081302,0.030441,0.4647,0.26758,-0.073682,0.019254,-0.015093,-0.26141},
      {0.00035504,0.076203,-0.081632,0.021233,0.50784,0.29279,-0.054739,0.030585,-0.021,-0.30223},
      {0.00026527,0.061334,-0.086018,0.017232,0.52181,0.30076,-0.04403,0.035791,-0.029381,-0.3156},
      {0.00018516,0.047029,-0.090534,0.012225,0.53778,0.30995,-0.033762,0.043005,-0.036143,-0.33084},
      {0.00011435,0.033658,-0.095483,0.0066071,0.55465,0.31975,-0.024209,0.052149,-0.041455,-0.34688},
      {5.46E-05,0.021833,-0.10325,0.00043609,0.56915,0.32827,-0.015824,0.064747,-0.046301,-0.36059},
      {4.40E-05,0.017159,-0.12468,-0.0014095,0.55444,0.31974,-0.012493,0.081311,-0.058383,-0.34652},
      {4.22E-05,0.013252,-0.14466,-0.002,0.53878,0.31068,-0.0096801,0.095671,-0.070191,-0.33154},
      {5.01E-05,0.0096537,-0.15991,-0.0025626,0.5282,0.30459,-0.0070651,0.10712,-0.079183,-0.32138},
      {7.16E-05,0.0063074,-0.16974,-0.0031497,0.5235,0.30195,-0.004606,0.11521,-0.085005,-0.31682},
      {0.00012257,0.0033039,-0.17435,-0.0037833,0.52442,0.30258,-0.0023664,0.12013,-0.087665,-0.31761},
      {0.00032262,0.0018083,-0.19453,-0.0034242,0.50637,0.2922,-0.0011433,0.13493,-0.098033,-0.30031},
      {0.00058097,0.00098152,-0.21164,-0.0028156,0.49054,0.28309,-0.0003514,0.14748,-0.10657,-0.28512},
      {0.0008895,0.00045011,-0.22186,-0.0022048,0.48127,0.27778,0.00026696,0.15516,-0.11147,-0.27622},
      {0.0012438,0.00014467,-0.22587,-0.0016253,0.47793,0.27588,0.0007546,0.15846,-0.11314,-0.27299},
      {0.0016398,-3.55E-07,-0.22435,-0.0011087,0.47988,0.27704,0.001152,0.15782,-0.11195,-0.27483},
      {0.0012347,-9.10E-07,-0.2299,-0.00074591,0.47517,0.27432,0.00086932,0.16203,-0.11472,-0.27032},
      {0.41364,0.0076097,0.069242,-0.02672,-0.00044999,0.00017154,0.26607,0.027918,0.24007,0.17357},
      {0.41156,0.010511,0.062192,-0.028962,-0.00049066,0.00052528,0.25477,0.021247,0.24505,0.17346},
      {0.40717,0.013938,0.052083,-0.032038,-0.00059514,0.0010675,0.2359,0.011871,0.25176,0.17306},
      {0.40384,0.017934,0.037944,-0.034744,-0.00075167,0.0017987,0.21132,-0.00016324,0.26253,0.1724},
      {0.40181,0.022677,0.019795,-0.036543,-0.00084033,0.0027844,0.1806,-0.014556,0.27745,0.17132},
      {0.34517,0.056477,0.014363,-0.050953,0.0050432,0.0054119,0.10913,-0.030476,0.2541,0.16522},
      {0.28086,0.10142,0.0059439,-0.061455,0.013061,0.0087924,0.028629,-0.045001,0.2324,0.15716},
      {0.21095,0.15587,-0.00575,-0.064524,0.028763,0.016366,-0.056376,-0.05702,0.20827,0.14221},
      {0.13382,0.21139,-0.018806,-0.052364,0.068042,0.037676,-0.13305,-0.060406,0.16746,0.10592},
      {0.068295,0.27026,-0.034391,-0.029456,0.11143,0.061538,-0.198,-0.052241,0.13749,0.06637},
      {0.023563,0.31091,-0.050625,0.0034718,0.16364,0.091129,-0.23582,-0.031198,0.11831,0.01865},
      {0.012804,0.27847,-0.067341,0.01851,0.21956,0.12298,-0.20979,-0.012111,0.085395,-0.033516},
      {0.0058062,0.24367,-0.08366,0.028761,0.27044,0.15261,-0.18004,0.0045598,0.052717,-0.080385},
      {0.0013918,0.20981,-0.099407,0.034522,0.31848,0.18153,-0.15096,0.022259,0.024567,-0.12375},
      {0.0010181,0.18012,-0.099538,0.032604,0.36181,0.2068,-0.12925,0.030185,0.01422,-0.16458},
      {0.00078676,0.14962,-0.097967,0.024118,0.41492,0.23783,-0.10717,0.042458,0.0085431,-0.21477},
      {0.00054,0.11017,-0.10076,0.019931,0.45704,0.26244,-0.078875,0.047029,-0.011288,-0.2546},
      {0.00033347,0.073902,-0.10543,0.014957,0.49541,0.28525,-0.052971,0.05388,-0.029634,-0.29059},
      {0.00024882,0.058328,-0.11055,0.010227,0.51171,0.2946,-0.041805,0.061271,-0.03751,-0.30615},
      {0.00017555,0.043821,-0.12055,0.0052569,0.5238,0.30152,-0.031501,0.073499,-0.04623,-0.3177},
      {0.00011161,0.030828,-0.13146,5.55E-05,0.53416,0.30758,-0.022289,0.08681,-0.054302,-0.32749},
      {5.35E-05,0.018868,-0.14559,-0.0011161,0.53336,0.30746,-0.013775,0.097341,-0.067046,-0.32642},
      {4.93E-05,0.014673,-0.16731,-0.0017167,0.51612,0.2975,-0.010757,0.11283,-0.079941,-0.30992},
      {5.53E-05,0.010886,-0.18423,-0.0022821,0.5039,0.29047,-0.0080065,0.12535,-0.089943,-0.2982},
      {7.49E-05,0.0073709,-0.19557,-0.0028699,0.49773,0.28697,-0.0054263,0.13441,-0.096679,-0.29223},
      {0.00011468,0.004006,-0.20267,-0.0034222,0.49599,0.28608,-0.0029277,0.14069,-0.10106,-0.29047},
      {0.00023487,0.0019744,-0.22338,-0.0030707,0.4778,0.27569,-0.0013365,0.15561,-0.11222,-0.27296},
      {0.00048127,0.0011108,-0.24118,-0.0025352,0.46126,0.26617,-0.00052423,0.16859,-0.12116,-0.2571},
      {0.0007791,0.00054791,-0.25196,-0.0019885,0.45141,0.26051,0.00011159,0.17663,-0.1264,-0.24764},
      {0.0011239,0.00021608,-0.25645,-0.001465,0.44757,0.25833,0.00061381,0.18021,-0.12835,-0.24394},
      {0.0015114,4.96E-05,-0.2553,-0.00099699,0.44913,0.25927,0.001023,0.1798,-0.12739,-0.24541},
      {0.0013659,-1.13E-06,-0.25429,-0.00076008,0.45063,0.26015,0.00096186,0.17927,-0.12686,-0.24683},
      {0.35259,-0.0077772,0.16126,-0.01802,-0.0021479,-0.00075118,0.20506,0.10068,0.15423,0.17283},
      {0.35478,-0.0084591,0.14715,-0.018286,-0.002609,-0.00041637,0.19385,0.089864,0.1689,0.17256},
      {0.35883,-0.0095494,0.12365,-0.018669,-0.0033299,-7.21E-06,0.17733,0.072068,0.1929,0.172},
      {0.35393,-0.0051007,0.1018,-0.020446,-0.0036649,0.00036745,0.15213,0.05491,0.21207,0.17088},
      {0.34201,0.0044337,0.079449,-0.022883,-0.0036747,0.00077058,0.11848,0.037201,0.22944,0.16923},
      {0.32887,0.016614,0.049411,-0.024946,-0.0036416,0.0012347,0.078053,0.014258,0.25371,0.16705},
      {0.28813,0.05247,0.027477,-0.03003,0.0018087,0.0037751,0.014763,-0.0055119,0.25587,0.161},
      {0.22567,0.11259,0.01366,-0.033732,0.012753,0.0085448,-0.066059,-0.018446,0.24026,0.15112},
      {0.16311,0.18334,-0.0038982,-0.031318,0.025524,0.014279,-0.15036,-0.029216,0.23007,0.13977},
      {0.1014,0.24599,-0.021664,-0.013813,0.064101,0.034326,-0.21086,-0.024825,0.20132,0.10458},
      {0.052543,0.29844,-0.044267,-0.00026503,0.10297,0.052837,-0.24432,-0.014562,0.16481,0.068824},
      {0.017772,0.34275,-0.068395,0.014158,0.13555,0.070605,-0.26339,-0.0023724,0.13311,0.041137},
      {0.0091969,0.31375,-0.084176,0.024666,0.18759,0.10098,-0.2359,0.013037,0.10054,-0.0063161},
      {0.0045202,0.2788,-0.099383,0.029463,0.24024,0.13254,-0.20525,0.030996,0.071739,-0.05388},
      {0.0017777,0.24341,-0.11532,0.027638,0.29244,0.16468,-0.17523,0.052772,0.047446,-0.10046},
      {0.0010672,0.20364,-0.12206,0.023879,0.33697,0.19084,-0.14548,0.061777,0.025407,-0.142},
      {0.0008095,0.16109,-0.12554,0.019443,0.38182,0.21684,-0.11496,0.067097,0.0038361,-0.18456},
      {0.00056091,0.11626,-0.13075,0.014019,0.42937,0.24508,-0.082975,0.074896,-0.018717,-0.22918},
      {0.00032417,0.070623,-0.14201,0.0088281,0.47281,0.27158,-0.050615,0.087633,-0.044067,-0.26938},
      {0.00024719,0.055008,-0.15592,0.0037812,0.48194,0.27667,-0.039558,0.10261,-0.055296,-0.27818},
      {0.00017806,0.040518,-0.17277,0.0010498,0.48292,0.27721,-0.029276,0.11667,-0.069527,-0.27909},
      {0.00011352,0.027546,-0.18796,-0.00020822,0.48202,0.27699,-0.020038,0.12792,-0.083331,-0.27798},
      {5.65E-05,0.01641,-0.1996,-0.0013483,0.48356,0.27853,-0.012082,0.13693,-0.094255,-0.27889},
      {5.77E-05,0.012187,-0.21785,-0.0019246,0.47038,0.27097,-0.0090192,0.15029,-0.10521,-0.26621},
      {7.46E-05,0.0085,-0.23079,-0.0025048,0.46261,0.26655,-0.0063156,0.16035,-0.11292,-0.25872},
      {0.00011588,0.0051862,-0.24616,-0.0027659,0.45172,0.26037,-0.0038492,0.17191,-0.12182,-0.24821},
      {0.00018506,0.0026432,-0.26413,-0.0025873,0.43675,0.25188,-0.0018994,0.18478,-0.13199,-0.23375},
      {0.00034501,0.0012133,-0.27987,-0.0022286,0.42291,0.24401,-0.00070515,0.1962,-0.14034,-0.2204},
      {0.00063157,0.00062652,-0.29108,-0.0017513,0.4126,0.23809,-5.68E-05,0.20448,-0.14585,-0.2105},
      {0.00096617,0.00027446,-0.29591,-0.0012889,0.40839,0.23569,0.000456,0.20827,-0.14803,-0.20645},
      {0.0013176,9.21E-05,-0.29498,-0.00089294,0.4097,0.23647,0.00085346,0.20795,-0.14724,-0.20768},
      {0.0013025,1.37E-05,-0.28992,-0.0007395,0.41504,0.23958,0.0009048,0.20448,-0.14469,-0.21278},
      {0.22774,-0.013642,0.33659,-0.0098582,-0.0027653,-0.0020875,0.12607,0.2313,-0.010052,0.17416},
      {0.23361,-0.014366,0.31482,-0.010226,-0.003254,-0.0019511,0.11716,0.21514,0.011287,0.17351},
      {0.2426,-0.015508,0.2811,-0.010738,-0.0040033,-0.0018043,0.10372,0.19019,0.0442,0.17246},
      {0.25488,-0.017131,0.23421,-0.011338,-0.0050316,-0.0017152,0.085634,0.15568,0.089723,0.1709},
      {0.26811,-0.017935,0.17651,-0.012053,-0.0061955,-0.0017096,0.062052,0.11339,0.14502,0.16875},
      {0.25933,-0.0040328,0.1394,-0.013642,-0.0059633,-0.0011321,0.024266,0.085706,0.17612,0.16649},
      {0.25009,0.012589,0.093394,-0.014561,-0.0056695,-0.00041923,-0.019989,0.052114,0.21556,0.16374},
      {0.22886,0.044018,0.047552,-0.014678,-0.0027257,-0.00024777,-0.07523,0.019464,0.24863,0.15782},
      {0.16791,0.12368,0.028615,-0.014011,0.010164,0.00032232,-0.14868,0.0096667,0.23241,0.14353},
      {0.11536,0.20862,-0.00011812,-0.010561,0.022014,0.0019303,-0.21383,-0.0020833,0.22281,0.12945},
      {0.071282,0.28078,-0.030063,-0.00071242,0.046085,0.012138,-0.25799,-0.0045684,0.20462,0.1073},
      {0.038396,0.32777,-0.053781,0.012655,0.080324,0.031191,-0.27508,0.0068949,0.17371,0.079644},
      {0.015128,0.36896,-0.078628,0.02344,0.10971,0.049552,-0.28533,0.021324,0.1492,0.059101},
      {0.0057902,0.36292,-0.097683,0.028326,0.15334,0.076845,-0.26897,0.038998,0.12457,0.023026},
      {0.0035397,0.31805,-0.115,0.02669,0.20227,0.10482,-0.23202,0.055472,0.090863,-0.022202},
      {0.0019701,0.2699,-0.13769,0.023597,0.24642,0.13235,-0.19391,0.07487,0.053803,-0.061229},
      {0.0011206,0.2214,-0.15625,0.019058,0.29065,0.16073,-0.15757,0.091698,0.020851,-0.10029},
      {0.00084711,0.17209,-0.16498,0.014375,0.33832,0.18892,-0.12244,0.10145,-0.0060986,-0.1451},
      {0.00057808,0.12144,-0.18166,0.0091126,0.38149,0.21521,-0.086572,0.11811,-0.036607,-0.18505},
      {0.00034793,0.071535,-0.2058,0.0037602,0.41693,0.23759,-0.051398,0.14027,-0.07013,-0.21722},
      {0.00025041,0.050393,-0.22751,0.0022288,0.41765,0.23834,-0.036429,0.15603,-0.091337,-0.2176},
      {0.00017805,0.036428,-0.24306,0.00081361,0.41742,0.23846,-0.026478,0.16755,-0.10582,-0.21715},
      {0.00011389,0.02435,-0.25504,-0.00046643,0.41957,0.24031,-0.017844,0.1768,-0.11739,-0.21869},
      {6.12E-05,0.014154,-0.26431,-0.0014432,0.42309,0.24333,-0.010534,0.18431,-0.12654,-0.22123},
      {6.76E-05,0.0097341,-0.27872,-0.0019966,0.41471,0.23872,-0.0073088,0.19536,-0.1354,-0.213},
      {0.0001057,0.006268,-0.29997,-0.0020929,0.39719,0.22869,-0.004725,0.21044,-0.14777,-0.19617},
      {0.00016665,0.0035902,-0.31626,-0.002025,0.38395,0.22117,-0.0026714,0.22204,-0.15723,-0.18338},
      {0.00024938,0.0016603,-0.32948,-0.0018376,0.37317,0.21515,-0.0011351,0.23157,-0.16472,-0.1729},
      {0.00044007,0.00066819,-0.34043,-0.0015066,0.36365,0.20979,-0.00022917,0.23958,-0.17045,-0.16366},
      {0.00076468,0.00030814,-0.34536,-0.0011067,0.3593,0.20731,0.00028659,0.24339,-0.17272,-0.15947},
      {0.0010244,0.00012139,-0.34371,-0.00083151,0.36125,0.20845,0.0006218,0.24245,-0.17171,-0.16133},
      {0.0010459,3.32E-05,-0.33761,-0.00068912,0.36758,0.21211,0.00070647,0.23824,-0.16862,-0.16739},
      {0.10396,-0.010526,0.52174,-0.0038095,-0.0024561,-0.0023668,0.048613,0.36683,-0.18294,0.17739},
      {0.10722,-0.013172,0.51373,-0.003665,-0.0027839,-0.0025708,0.046663,0.36076,-0.17493,0.17678},
      {0.11559,-0.015727,0.48692,-0.0038084,-0.0034236,-0.0027768,0.039068,0.34107,-0.14906,0.17559},
      {0.13102,-0.017516,0.43266,-0.0043762,-0.0044242,-0.0031609,0.023773,0.30155,-0.09729,0.17348},
      {0.14852,-0.019583,0.3675,-0.0049325,-0.0055975,-0.0045048,0.0055914,0.25421,-0.035743,0.17024},
      {0.16831,-0.022111,0.29304,-0.0054395,-0.0071541,-0.0069897,-0.013423,0.20027,0.033547,0.16534},
      {0.17028,-0.0072882,0.23325,-0.0059685,-0.007676,-0.0097944,-0.044366,0.15734,0.084191,0.15889},
      {0.16416,0.020104,0.17043,-0.0058369,-0.0077897,-0.013769,-0.085986,0.11323,0.1345,0.15041},
      {0.15741,0.054,0.094836,-0.004632,-0.0081282,-0.019628,-0.13448,0.061114,0.19495,0.13953},
      {0.11672,0.13834,0.055614,-0.00085284,0.0029914,-0.018369,-0.19289,0.042389,0.19852,0.12797},
      {0.076766,0.2359,0.012796,0.0052812,0.015439,-0.015795,-0.25136,0.026297,0.20231,0.11824},
      {0.043708,0.33156,-0.035059,0.01403,0.030714,-0.010223,-0.30187,0.012706,0.20898,0.10816},
      {0.023604,0.37139,-0.059658,0.022989,0.060269,0.007013,-0.30777,0.026129,0.18475,0.087537},
      {0.011841,0.3952,-0.085593,0.025919,0.08032,0.015543,-0.30374,0.038953,0.16125,0.072625},
      {0.0048682,0.39963,-0.11107,0.026305,0.10417,0.033567,-0.2925,0.054554,0.13742,0.058308},
      {0.0032954,0.34814,-0.13462,0.022457,0.15214,0.063173,-0.25168,0.075045,0.098395,0.015657},
      {0.0020446,0.29161,-0.16807,0.019719,0.19417,0.092938,-0.2085,0.10159,0.0524,-0.01865},
      {0.0011073,0.23251,-0.21,0.01587,0.22968,0.12122,-0.16505,0.13483,0.0027107,-0.045239},
      {0.00082016,0.17848,-0.22834,0.0091382,0.27549,0.1488,-0.12679,0.1534,-0.029805,-0.087901},
      {0.00055799,0.12175,-0.25679,0.0066058,0.30791,0.16878,-0.086819,0.17507,-0.071375,-0.11778},
      {0.00035537,0.07155,-0.2895,0.0038568,0.3312,0.18515,-0.051489,0.20001,-0.11153,-0.13757},
      {0.00024202,0.044862,-0.31235,0.0018259,0.33869,0.19128,-0.03263,0.21728,-0.13555,-0.14321},
      {0.00016968,0.031908,-0.32391,0.00034462,0.34222,0.1939,-0.023362,0.22627,-0.14734,-0.14609},
      {0.0001094,0.020867,-0.33283,-0.00081266,0.347,0.19762,-0.01544,0.23355,-0.15673,-0.14986},
      {6.40E-05,0.011922,-0.34667,-0.0012729,0.34454,0.19756,-0.0090028,0.24396,-0.16779,-0.14636},
      {7.87E-05,0.0071247,-0.36433,-0.0014463,0.33225,0.19092,-0.0054646,0.25641,-0.17912,-0.13422},
      {0.00013188,0.0043579,-0.37798,-0.0014821,0.32164,0.1849,-0.0033344,0.26608,-0.18737,-0.12398},
      {0.00020722,0.0023361,-0.38878,-0.0013919,0.3133,0.18026,-0.0017204,0.27383,-0.19376,-0.11585},
      {0.000304,0.00096003,-0.39872,-0.0012077,0.3053,0.1759,-0.00056574,0.28103,-0.19932,-0.10797},
      {0.00051322,0.00030945,-0.40589,-0.000927,0.29921,0.17258,0.00010865,0.28634,-0.203,-0.10197},
      {0.0007181,0.00012802,-0.40179,-0.00076926,0.30347,0.17501,0.00039688,0.28356,-0.20086,-0.10608},
      {0.0007648,5.33E-05,-0.39357,-0.00063773,0.31185,0.17984,0.00049068,0.27784,-0.1967,-0.11411},
      {0.032283,-0.0028988,0.63439,-0.0012532,-0.0014358,-0.0022149,0.0084184,0.44806,-0.28793,0.18026},
      {0.036501,-0.0046415,0.62532,-0.0013015,-0.001684,-0.0026389,0.008803,0.44142,-0.2795,0.17951},
      {0.042252,-0.0070984,0.61264,-0.0013604,-0.0020449,-0.0033157,0.0091588,0.43213,-0.26776,0.17837},
      {0.048825,-0.010059,0.59748,-0.0014129,-0.0025026,-0.004298,0.0092326,0.42104,-0.25384,0.17683},
      {0.062881,-0.012641,0.54817,-0.0016434,-0.0037337,-0.006577,-0.00090821,0.38537,-0.20852,0.17272},
      {0.079317,-0.015103,0.48225,-0.0017574,-0.0054701,-0.01029,-0.017089,0.33783,-0.14844,0.16649},
      {0.093695,-0.017247,0.4153,-0.0015456,-0.0074019,-0.015485,-0.035646,0.28969,-0.08832,0.15869},
      {0.099851,-0.0048681,0.34582,-0.00080101,-0.008641,-0.021624,-0.064952,0.24064,-0.029114,0.14931},
      {0.09735,0.032966,0.26117,0.00093326,-0.0087932,-0.028238,-0.11276,0.18259,0.039471,0.13814},
      {0.094284,0.077332,0.16499,0.0038075,-0.0090362,-0.036738,-0.16685,0.11742,0.11714,0.12502},
      {0.073199,0.15937,0.093994,0.0095631,-0.0014613,-0.038609,-0.22268,0.078462,0.15688,0.1151},
      {0.048257,0.25458,0.033789,0.014103,0.0088139,-0.053956,-0.26389,0.05413,0.17205,0.096386},
      {0.029171,0.34769,-0.031638,0.017989,0.016513,-0.064216,-0.30531,0.028567,0.19551,0.085283},
      {0.01792,0.38224,-0.064091,0.020392,0.034814,-0.055288,-0.30793,0.036178,0.18053,0.073822},
      {0.009937,0.40694,-0.092809,0.021724,0.049438,-0.037986,-0.30729,0.051758,0.16199,0.073489},
      {0.0043498,0.4264,-0.12649,0.023842,0.058396,-0.012753,-0.30769,0.070734,0.14309,0.086568},
      {0.00297,0.36902,-0.16315,0.020192,0.10173,0.01934,-0.26346,0.099915,0.095144,0.052573},
      {0.00194,0.30553,-0.2109,0.014544,0.13866,0.048957,-0.21672,0.13838,0.041001,0.025193},
      {0.0010685,0.23121,-0.27534,0.012578,0.16258,0.072533,-0.16397,0.18504,-0.028106,0.01091},
      {0.0007098,0.16925,-0.31091,0.0094449,0.19653,0.096066,-0.12025,0.21212,-0.075625,-0.018161},
      {0.00049213,0.11543,-0.34192,0.0060576,0.22573,0.11577,-0.082353,0.23627,-0.11646,-0.043677},
      {0.00032662,0.068936,-0.37779,0.003037,0.24389,0.13074,-0.049659,0.26375,-0.15606,-0.05727},
      {0.00021766,0.038451,-0.40712,0.00089549,0.25124,0.13903,-0.028183,0.28602,-0.18484,-0.060914},
      {0.00014317,0.027121,-0.41531,-0.00032805,0.25721,0.14366,-0.020039,0.29275,-0.19407,-0.065643},
      {9.25E-05,0.017064,-0.42357,-0.00065551,0.26053,0.14685,-0.012779,0.29859,-0.20336,-0.067765},
      {5.85E-05,0.0091902,-0.43633,-0.00087559,0.25747,0.14661,-0.0070602,0.30767,-0.21376,-0.063562},
      {7.56E-05,0.0048476,-0.44883,-0.00099244,0.25036,0.14335,-0.003813,0.31655,-0.22226,-0.056064},
      {0.0001443,0.0027857,-0.45629,-0.00098901,0.24534,0.1406,-0.002153,0.32187,-0.22706,-0.051129},
      {0.00023469,0.001361,-0.46316,-0.0008873,0.2404,0.13798,-0.00094776,0.32684,-0.23117,-0.046199},
      {0.00033061,0.00048492,-0.46994,-0.00075349,0.23502,0.13519,-0.0001652,0.33177,-0.23492,-0.040793},
      {0.00040723,0.00012197,-0.4687,-0.00070789,0.23683,0.13642,0.00017815,0.33092,-0.23444,-0.042368},
      {0.0004908,6.91E-05,-0.45644,-0.00058458,0.24916,0.1435,0.00028341,0.32234,-0.22824,-0.054212},
      {0.0080781,0.0026329,0.68134,-0.00072317,-0.00046703,-0.0014984,0.00077219,0.48174,-0.33149,0.18254},
      {0.010276,0.0016155,0.67578,-0.00072849,-0.00065221,-0.0020464,0.00060374,0.47769,-0.32651,0.18179},
      {0.013279,0.00021266,0.66796,-0.00072762,-0.00092004,-0.0029111,0.00026787,0.47199,-0.31955,0.18065},
      {0.01672,-0.001407,0.65853,-0.00070928,-0.001256,-0.0041461,-0.00032496,0.46511,-0.31125,0.17909},
      {0.02007,-0.0029752,0.6485,-0.00065839,-0.0016333,-0.0058106,-0.0012597,0.45781,-0.30263,0.17711},
      {0.025204,-0.0042082,0.62607,-0.00047872,-0.0023662,-0.0088464,-0.0065354,0.44165,-0.28311,0.17331},
      {0.035249,-0.0046868,0.57036,0.00010879,-0.0040054,-0.015327,-0.023068,0.40178,-0.23431,0.16488},
      {0.042742,-0.0034823,0.517,0.0010359,-0.0055405,-0.023589,-0.040615,0.36374,-0.18868,0.15505},
      {0.049096,0.0023457,0.4541,0.0020073,-0.0069722,-0.038181,-0.061142,0.31943,-0.13754,0.13955},
      {0.051759,0.044479,0.34208,0.0040444,-0.0075524,-0.061764,-0.10838,0.24357,-0.050572,0.11458},
      {0.052753,0.091407,0.22304,0.0062271,-0.0081351,-0.098278,-0.15508,0.16402,0.037294,0.079791},
      {0.046111,0.15787,0.11915,0.009055,-0.0053724,-0.13326,-0.19895,0.10103,0.10296,0.047321},
      {0.030901,0.25186,0.050431,0.012722,0.0019085,-0.13945,-0.24005,0.073403,0.13161,0.040278},
      {0.019983,0.34201,-0.021359,0.016515,0.0069578,-0.13847,-0.28085,0.046522,0.16461,0.041251},
      {0.012708,0.3919,-0.070471,0.018869,0.016755,-0.12208,-0.29781,0.045765,0.16872,0.047818},
      {0.0075827,0.41213,-0.1052,0.019137,0.027077,-0.093548,-0.29902,0.066398,0.15106,0.062392},
      {0.0041113,0.42046,-0.14434,0.0184,0.032938,-0.061439,-0.29883,0.090967,0.1315,0.08408},
      {0.0025184,0.3642,-0.1947,0.016943,0.059192,-0.034178,-0.25818,0.12609,0.077758,0.070033},
      {0.0016472,0.287,-0.25941,0.014055,0.086945,-0.0081284,-0.20337,0.17354,0.0075179,0.052302},
      {0.00095215,0.21496,-0.33756,0.010985,0.10302,0.019852,-0.15239,0.23064,-0.066493,0.052814},
      {0.00056484,0.15346,-0.39558,0.00733,0.12353,0.045463,-0.10902,0.27401,-0.12461,0.044786},
      {0.00039065,0.10386,-0.42986,0.0036452,0.14706,0.063554,-0.074124,0.30079,-0.16467,0.026066},
      {0.00025341,0.062298,-0.46732,0.00094007,0.16049,0.078011,-0.044921,0.32937,-0.20258,0.018811},
      {0.00016002,0.031406,-0.49899,0.00029782,0.16682,0.088799,-0.023224,0.35215,-0.23348,0.018688},
      {0.0001046,0.021055,-0.50042,-9.92E-05,0.17728,0.096109,-0.015729,0.35315,-0.23955,0.0097241},
      {6.56E-05,0.012837,-0.50678,-0.00038761,0.18098,0.099769,-0.0097398,0.35769,-0.24695,0.0074472},
      {4.13E-05,0.006629,-0.51866,-0.00057315,0.17738,0.099455,-0.0051735,0.36617,-0.25608,0.012355},
      {5.59E-05,0.0029405,-0.53091,-0.00065268,0.17045,0.096806,-0.0023752,0.37489,-0.26411,0.020114},
      {0.00014085,0.001521,-0.53388,-0.00062147,0.16935,0.096385,-0.0011529,0.37706,-0.26632,0.021345},
      {0.0002116,0.00063469,-0.53241,-0.00060468,0.17197,0.098076,-0.00039621,0.37605,-0.26603,0.018982},
      {0.00022752,0.00028619,-0.5282,-0.00058459,0.1769,0.10121,-8.73E-05,0.37308,-0.26412,0.014513},
      {0.00024009,7.91E-05,-0.52531,-0.00053006,0.18041,0.10359,9.76E-05,0.37108,-0.26276,0.01144},
      {0.0008727,0.0033987,0.69798,-0.00087673,-3.23E-05,-0.00055597,-0.00077156,0.49321,-0.34641,0.18403},
      {0.0011225,0.0034423,0.69789,-0.0007164,-3.53E-05,-0.00066873,-0.00082595,0.49327,-0.34625,0.18392},
      {0.0021635,0.0030949,0.69478,-0.00060327,-0.00015172,-0.0015007,-0.0011138,0.49109,-0.34366,0.18304},
      {0.0039248,0.0023666,0.68863,-0.00054818,-0.00038247,-0.0032034,-0.0016646,0.48663,-0.33865,0.18125},
      {0.0058837,0.0015279,0.68125,-0.00047909,-0.00065558,-0.0055616,-0.0023715,0.48131,-0.33278,0.17884},
      {0.0078575,0.00064665,0.67297,-0.00039725,-0.00095528,-0.0087243,-0.003226,0.47534,-0.32638,0.17571},
      {0.0096523,-0.00019206,0.66409,-0.00030473,-0.0012618,-0.012876,-0.0042035,0.46896,-0.3198,0.17173},
      {0.015923,0.00022745,0.61337,0.00031137,-0.0026359,-0.027876,-0.01768,0.43294,-0.27909,0.15665},
      {0.020976,0.0020566,0.55942,0.00098585,-0.0039666,-0.048931,-0.031445,0.39475,-0.23782,0.13659},
      {0.02443,0.0060401,0.50445,0.001695,-0.0052545,-0.07706,-0.044076,0.35598,-0.19849,0.11074},
      {0.026639,0.051424,0.38699,0.0038669,-0.0062544,-0.12123,-0.084237,0.27748,-0.11454,0.070011},
      {0.027189,0.10644,0.25793,0.0063555,-0.0068767,-0.17921,-0.12614,0.19225,-0.02625,0.01883},
      {0.025253,0.16952,0.13168,0.0089771,-0.0062701,-0.24336,-0.16572,0.11162,0.054712,-0.035647},
      {0.016962,0.25843,0.058889,0.011999,-0.0007825,-0.237,-0.20764,0.085168,0.091445,-0.028638},
      {0.011548,0.34367,-0.014212,0.013604,0.0029885,-0.22113,-0.25121,0.062357,0.1318,-0.012117},
      {0.0087182,0.37837,-0.071879,0.014952,0.006963,-0.20675,-0.27244,0.050967,0.15047,-0.002763},
      {0.0057031,0.37101,-0.11155,0.0156,0.013892,-0.17825,-0.26503,0.07416,0.12484,0.013073},
      {0.0033963,0.36607,-0.16053,0.015699,0.017718,-0.13776,-0.25982,0.10518,0.096571,0.042962},
      {0.0019918,0.3352,-0.22268,0.01394,0.028345,-0.095139,-0.23713,0.14846,0.050175,0.064146},
      {0.0013129,0.26105,-0.30194,0.010091,0.046891,-0.064945,-0.18465,0.20685,-0.025052,0.062955},
      {0.00077089,0.19102,-0.39376,0.0063129,0.055522,-0.031862,-0.13523,0.27413,-0.10431,0.078277},
      {0.00038971,0.12805,-0.478,0.0025046,0.065168,0.0031928,-0.090921,0.33618,-0.17601,0.093642},
      {0.00026078,0.085183,-0.50511,0.0012769,0.088327,0.023332,-0.060829,0.35615,-0.21031,0.077106},
      {0.00016601,0.051294,-0.5347,0.00080376,0.10022,0.038148,-0.037046,0.37732,-0.24174,0.072316},
      {9.79E-05,0.025633,-0.56744,0.00036548,0.10159,0.047852,-0.019018,0.4007,-0.27066,0.078412},
      {5.49E-05,0.015156,-0.57395,1.62E-05,0.1087,0.054895,-0.011454,0.40537,-0.27923,0.074043},
      {2.71E-05,0.0087268,-0.57992,-0.0002278,0.11127,0.058153,-0.0067071,0.40966,-0.28554,0.073049},
      {1.22E-05,0.0041415,-0.59234,-0.00037367,0.10575,0.056956,-0.0032701,0.41851,-0.29412,0.079988},
      {2.03E-05,0.0014068,-0.60575,-0.00043518,0.097127,0.053853,-0.0011785,0.42803,-0.30226,0.089801},
      {8.97E-05,0.00085,-0.59052,-0.0004426,0.11302,0.063085,-0.00066293,0.41726,-0.29494,0.074626},
      {0.00012297,0.00049466,-0.58067,-0.0004336,0.1235,0.06934,-0.00033346,0.4103,-0.29021,0.064772},
      {0.000126,0.00023071,-0.57728,-0.00040708,0.12762,0.072139,-0.00010704,0.40792,-0.28865,0.061166},
      {-0.00017856,0.0020202,0.69912,-0.0016426,2.61E-05,-0.0015257,-6.34E-05,0.49328,-0.34821,0.18325},
      {6.52E-06,0.0020251,0.69904,-0.0014513,2.56E-05,-0.0017621,-9.79E-05,0.49336,-0.34807,0.18304},
      {0.00028292,0.0020347,0.69888,-0.0011725,2.52E-05,-0.0021576,-0.00014941,0.49344,-0.34784,0.1827},
      {0.00064932,0.0020473,0.69857,-0.00080958,2.51E-05,-0.0027646,-0.00021697,0.49349,-0.34748,0.18218},
      {0.0015689,0.0017469,0.69416,-0.00064009,-0.00011709,-0.0052415,-0.00069261,0.49043,-0.34428,0.17986},
      {0.002812,0.0013005,0.6866,-0.00058515,-0.00036322,-0.0095459,-0.0014483,0.48503,-0.33903,0.17585},
      {0.0040327,0.00094514,0.67796,-0.00048749,-0.00062906,-0.01517,-0.0022397,0.47889,-0.33324,0.17069},
      {0.0051296,0.00076263,0.66828,-0.00033541,-0.00089492,-0.022424,-0.003013,0.47208,-0.32708,0.16416},
      {0.0076907,0.0038785,0.62888,0.00020734,-0.0018653,-0.044911,-0.010796,0.44429,-0.29979,0.14366},
      {0.010053,0.010348,0.57409,0.00095263,-0.0030176,-0.080254,-0.020941,0.4057,-0.26347,0.1121},
      {0.011138,0.019545,0.51711,0.0017337,-0.0038324,-0.12455,-0.0296,0.36565,-0.22848,0.073652},
      {0.011342,0.061808,0.41058,0.0036218,-0.0037716,-0.18657,-0.058335,0.29483,-0.15938,0.021092},
      {0.010598,0.12309,0.27797,0.0059163,-0.0027013,-0.26497,-0.095371,0.20836,-0.074493,-0.043384},
      {0.011177,0.16706,0.13409,0.0077456,-0.0029203,-0.3603,-0.12837,0.11241,0.015891,-0.12334},
      {0.009237,0.22133,0.053222,0.0094716,-0.0010419,-0.36136,-0.16464,0.076289,0.06316,-0.12416},
      {0.0074467,0.27136,-0.008898,0.010789,0.00065275,-0.34499,-0.19733,0.055378,0.097705,-0.10981},
      {0.0061031,0.31194,-0.059751,0.011441,0.0019562,-0.32564,-0.22348,0.043226,0.12265,-0.092751},
      {0.0040461,0.30856,-0.11101,0.011083,0.0059694,-0.2801,-0.21942,0.07625,0.094451,-0.058922},
      {0.0025206,0.30656,-0.17218,0.0097889,0.0076405,-0.22256,-0.21683,0.11775,0.06286,-0.012215},
      {0.0015475,0.29602,-0.24783,0.0074883,0.0093992,-0.15461,-0.20875,0.17116,0.020634,0.042474},
      {0.0010507,0.22368,-0.34127,0.0028584,0.021769,-0.11673,-0.1577,0.24017,-0.060131,0.056403},
      {0.00060464,0.15671,-0.43383,0.0020793,0.030193,-0.074956,-0.11076,0.30581,-0.13952,0.079028},
      {0.00024146,0.099619,-0.52944,0.0017839,0.034037,-0.025383,-0.070766,0.37329,-0.2157,0.11467},
      {0.00013863,0.064752,-0.55965,0.0012511,0.04889,-0.0059604,-0.046301,0.39493,-0.24792,0.10946},
      {7.18E-05,0.038382,-0.58874,0.00074941,0.054929,0.0067193,-0.027772,0.41576,-0.27533,0.11131},
      {2.48E-05,0.01918,-0.61963,0.00032313,0.052509,0.015099,-0.014239,0.43782,-0.30012,0.12174},
      {-5.50E-06,0.0093911,-0.6348,1.53E-05,0.052639,0.020703,-0.0071887,0.44864,-0.31257,0.1262},
      {-2.18E-05,0.0047201,-0.64148,-0.00017775,0.052962,0.022887,-0.0036734,0.45344,-0.31835,0.12755},
      {-1.23E-05,0.0025799,-0.63946,-0.00024939,0.059087,0.02832,-0.0020571,0.452,-0.31847,0.12326},
      {-2.34E-06,0.0011275,-0.64139,-0.0002842,0.060678,0.031294,-0.00094212,0.45336,-0.32019,0.12344},
      {3.85E-05,0.00067007,-0.62945,-0.00028875,0.073507,0.039085,-0.00053317,0.44491,-0.31447,0.11148},
      {5.61E-05,0.00039906,-0.62122,-0.00027421,0.082373,0.044526,-0.00029002,0.4391,-0.3105,0.10326},
      {-0.00075702,0.001302,0.69827,-0.0031357,6.85E-05,-0.0022231,0.00038189,0.49158,-0.34901,0.18264},
      {-0.00060882,0.0012986,0.69803,-0.0029526,6.98E-05,-0.0026527,0.00035593,0.49154,-0.3488,0.18227},
      {-0.00038608,0.0012913,0.69766,-0.002667,7.20E-05,-0.003343,0.00031793,0.49148,-0.34847,0.18168},
      {-8.94E-05,0.0012777,0.6971,-0.0022647,7.56E-05,-0.0043543,0.00026938,0.49137,-0.34799,0.18082},
      {0.00027511,0.0012544,0.69633,-0.0017294,8.10E-05,-0.0057603,0.00021324,0.49121,-0.34733,0.17961},
      {0.00073351,0.0012181,0.69451,-0.0011073,6.60E-05,-0.0081464,9.52E-05,0.49036,-0.34603,0.17755},
      {0.0014817,0.0012562,0.68585,-0.00090097,-0.00012039,-0.015587,-0.00047783,0.48433,-0.34077,0.17099},
      {0.0021488,0.0014825,0.67583,-0.00064349,-0.00028088,-0.024998,-0.001014,0.47739,-0.33495,0.1628},
      {0.0026724,0.00197,0.66439,-0.0003312,-0.00038579,-0.036757,-0.0014577,0.46948,-0.32863,0.15273},
      {0.0032589,0.0067021,0.63252,0.00020187,-0.00064362,-0.064833,-0.0050953,0.44719,-0.30998,0.12875},
      {0.0041067,0.015544,0.56215,0.00087988,-0.0012995,-0.12711,-0.012866,0.39771,-0.26919,0.075716},
      {0.0046773,0.024055,0.47994,0.0015085,-0.0019329,-0.20437,-0.02037,0.33992,-0.22295,0.010343},
      {0.0052436,0.048964,0.36617,0.0026792,-0.0023131,-0.29383,-0.039582,0.26233,-0.15482,-0.06487},
      {0.0057495,0.088298,0.23361,0.0042783,-0.002427,-0.38465,-0.068803,0.1737,-0.072177,-0.14072},
      {0.0058281,0.12043,0.1126,0.0054514,-0.0024687,-0.4758,-0.092261,0.092357,0.0011604,-0.21639},
      {0.0050274,0.16061,0.03698,0.0063583,-0.0014602,-0.49464,-0.11901,0.0547,0.044964,-0.23125},
      {0.0041693,0.20276,-0.0099831,0.0066831,-0.00027641,-0.47114,-0.14625,0.043874,0.070567,-0.21051},
      {0.0037767,0.23697,-0.04821,0.0061972,0.00045534,-0.44428,-0.16808,0.040866,0.088171,-0.18705},
      {0.0028012,0.24189,-0.10845,0.0045677,0.0020485,-0.38594,-0.17026,0.077823,0.064086,-0.1395},
      {0.0019108,0.23954,-0.18541,0.002274,0.0028342,-0.3079,-0.16817,0.13217,0.025496,-0.075126},
      {0.0012442,0.23206,-0.26788,0.002481,0.0035486,-0.22268,-0.16323,0.18928,-0.019323,-0.0053466},
      {0.00077981,0.17718,-0.35894,0.0022037,0.010767,-0.17026,-0.12484,0.2534,-0.092121,0.027834},
      {0.00041706,0.12082,-0.45414,0.0018336,0.015686,-0.11855,-0.085369,0.32063,-0.1677,0.063716},
      {0.00013391,0.073819,-0.55214,0.0014836,0.016915,-0.059034,-0.052441,0.38986,-0.23999,0.11136},
      {1.77E-05,0.04351,-0.60365,0.0010013,0.021467,-0.027798,-0.03117,0.42646,-0.2806,0.13075},
      {-2.60E-05,0.024102,-0.63167,0.00051417,0.022459,-0.017133,-0.017494,0.44652,-0.30403,0.13817},
      {-5.59E-05,0.010925,-0.66006,0.00013909,0.017082,-0.0099079,-0.0081402,0.46674,-0.32459,0.15189},
      {-4.90E-05,0.0056125,-0.669,-8.23E-06,0.020745,-3.98E-06,-0.0043351,0.47304,-0.33163,0.15484},
      {-3.65E-05,0.0035724,-0.66289,-9.20E-05,0.030706,0.0074784,-0.0027904,0.4687,-0.32965,0.14674},
      {-2.44E-05,0.0020651,-0.66176,-0.00014122,0.035278,0.012026,-0.0016397,0.46789,-0.32987,0.14394},
      {-1.27E-05,0.0010068,-0.66494,-0.0001601,0.035362,0.014312,-0.00081999,0.47012,-0.33201,0.14572},
      {6.17E-06,0.00055028,-0.66005,-0.00015655,0.041821,0.019165,-0.00044038,0.46665,-0.3298,0.14047},
      {-0.0011276,0.00081343,0.69732,-0.005418,0.00010786,-0.0016602,0.00068295,0.48928,-0.35004,0.18309},
      {-0.0010084,0.00080156,0.69697,-0.0051898,0.00011071,-0.0022978,0.00066484,0.48919,-0.34976,0.18255},
      {-0.00082837,0.00078251,0.69642,-0.0048306,0.00011531,-0.0033093,0.00063828,0.48906,-0.34931,0.18169},
      {-0.00058709,0.00075478,0.69563,-0.0043184,0.00012205,-0.0047652,0.00060423,0.48887,-0.34867,0.18044},
      {-0.00030923,0.00073287,0.69409,-0.0035452,0.00012874,-0.0073313,0.00055434,0.48834,-0.34753,0.17828},
      {1.63E-05,0.00069892,0.6917,-0.0026218,0.00013743,-0.011029,0.00049555,0.48734,-0.34591,0.17516},
      {0.0003803,0.00064938,0.68814,-0.0015693,0.0001484,-0.016206,0.00042954,0.48563,-0.34368,0.17081},
      {0.00079146,0.00087538,0.67517,-0.0010515,7.11E-05,-0.030457,7.70E-05,0.47686,-0.33666,0.15876},
      {0.001201,0.0011964,0.65478,-0.00072204,-3.82E-05,-0.052637,-0.00039824,0.46271,-0.32593,0.14005},
      {0.0015777,0.0014977,0.6283,-0.00037392,-0.00014141,-0.081963,-0.00088621,0.44427,-0.31218,0.1154},
      {0.0019411,0.0036688,0.58329,3.44E-05,-0.00035507,-0.12909,-0.0029737,0.41275,-0.28816,0.07577},
      {0.0022761,0.011266,0.49539,0.00057486,-0.00088836,-0.21555,-0.0095929,0.35093,-0.23986,0.0030004},
      {0.0024023,0.018361,0.39668,0.0010418,-0.0013201,-0.31632,-0.01567,0.28151,-0.18672,-0.081436},
      {0.002429,0.031648,0.28647,0.0016386,-0.0015403,-0.4225,-0.02585,0.20497,-0.12581,-0.16995},
      {0.0026043,0.059593,0.1786,0.0025564,-0.0015314,-0.50574,-0.0458,0.13243,-0.060887,-0.23887},
      {0.0026114,0.081206,0.083253,0.0029518,-0.0013968,-0.58624,-0.060499,0.06825,-0.0053455,-0.3051},
      {0.0024094,0.10698,0.016966,0.002778,-0.00077672,-0.61914,-0.076992,0.033125,0.031139,-0.33129},
      {0.0022419,0.14161,-0.018249,0.0017178,1.44E-05,-0.5869,-0.099314,0.033449,0.04758,-0.30322},
      {0.0023665,0.17296,-0.044654,0.001507,0.00017582,-0.54209,-0.12092,0.03941,0.059055,-0.26586},
      {0.0020346,0.18425,-0.097976,0.0016629,0.00076431,-0.47549,-0.12899,0.071756,0.041387,-0.21133},
      {0.0014027,0.17794,-0.18224,0.0018366,0.0015063,-0.38674,-0.12486,0.13018,-0.0037196,-0.13865},
      {0.00087732,0.16614,-0.27291,0.0019251,0.001887,-0.29698,-0.11679,0.1935,-0.05482,-0.064598},
      {0.0004886,0.13058,-0.36855,0.0016935,0.0042829,-0.22507,-0.091941,0.26087,-0.12025,-0.0083102},
      {0.00020947,0.084663,-0.46641,0.0012799,0.0061912,-0.16336,-0.059786,0.33003,-0.19189,0.040184},
      {4.88E-06,0.047336,-0.56615,0.00090173,0.0054524,-0.094033,-0.033631,0.40052,-0.26018,0.098793},
      {-9.16E-05,0.022644,-0.63737,0.00048463,0.0049296,-0.042503,-0.016284,0.45095,-0.30785,0.14231},
      {-8.90E-05,0.013889,-0.65341,0.00025611,0.0076591,-0.030106,-0.010123,0.46228,-0.32002,0.14867},
      {-7.71E-05,0.0081326,-0.6668,0.00012226,0.0090572,-0.019507,-0.0060616,0.47168,-0.32942,0.15545},
      {-6.04E-05,0.0041857,-0.67921,2.64E-05,0.0090088,-0.010419,-0.0032492,0.48038,-0.33748,0.16306},
      {-4.59E-05,0.0026939,-0.6758,-3.27E-05,0.015678,-0.0048539,-0.0021151,0.47793,-0.33655,0.1581},
      {-3.21E-05,0.0016209,-0.67653,-6.26E-05,0.018071,-0.0013961,-0.0012892,0.47843,-0.33748,0.15753},
      {-1.93E-05,0.00088927,-0.6808,-6.70E-05,0.017005,0.00057267,-0.00071347,0.48143,-0.33998,0.16069},
      {-0.0012903,0.00074369,0.69686,-0.0047814,0.00011545,-0.0030206,0.00065454,0.48952,-0.3497,0.18197},
      {-0.0012724,0.0006987,0.69632,-0.0050785,0.00012006,-0.0033179,0.00068805,0.48895,-0.3496,0.18171},
      {-0.0012458,0.00063009,0.69548,-0.0055258,0.00012717,-0.0037988,0.00073932,0.48805,-0.34945,0.1813},
      {-0.0011012,0.00058133,0.69353,-0.0052868,0.00013439,-0.0062809,0.00073233,0.48688,-0.34841,0.17922},
      {-0.00086652,0.00053991,0.69037,-0.0045673,0.00014256,-0.010679,0.00068514,0.4852,-0.34653,0.17554},
      {-0.00059106,0.00048668,0.686,-0.0037162,0.0001529,-0.016599,0.00062925,0.48279,-0.34401,0.17058},
      {-0.00028281,0.00042091,0.68011,-0.0027563,0.00016559,-0.024384,0.00056594,0.47939,-0.3407,0.16407},
      {4.78E-05,0.00034265,0.6723,-0.001719,0.00018078,-0.034434,0.00049687,0.47473,-0.33644,0.15567},
      {0.0003676,0.0004043,0.65422,-0.00097712,0.00015483,-0.055477,0.00026738,0.46257,-0.32702,0.13805},
      {0.00064239,0.00064533,0.62055,-0.00064634,8.39E-05,-0.093472,-0.0001621,0.43904,-0.30979,0.10625},
      {0.00088012,0.00088512,0.58002,-0.00031738,4.14E-05,-0.13946,-0.00058632,0.41065,-0.28916,0.067804},
      {0.0010802,0.0014852,0.52889,-3.28E-05,9.16E-06,-0.19714,-0.0012952,0.37474,-0.26313,0.019641},
      {0.0011376,0.0075787,0.42892,0.00034802,-0.00031482,-0.30186,-0.0063058,0.30442,-0.21011,-0.067857},
      {0.0010836,0.013014,0.32002,0.00062814,-0.00048202,-0.41909,-0.010527,0.22786,-0.15325,-0.1654},
      {0.00094109,0.018945,0.20504,0.00079131,-0.00040338,-0.54422,-0.014662,0.14725,-0.093569,-0.26901},
      {0.00096046,0.037417,0.12118,0.00079529,-1.44E-05,-0.61772,-0.026735,0.09092,-0.045076,-0.32896},
      {0.0010994,0.053024,0.057281,0.00085231,-7.86E-05,-0.66994,-0.037319,0.048254,-0.0072684,-0.37191},
      {0.0012392,0.07055,0.0082217,0.00095049,-0.00018138,-0.69543,-0.049438,0.02018,0.021263,-0.39289},
      {0.0014214,0.10157,-0.016699,0.0010516,-7.47E-05,-0.64766,-0.071086,0.027188,0.031787,-0.35326},
      {0.0015211,0.12531,-0.039268,0.0011011,6.52E-06,-0.6075,-0.087663,0.034847,0.038234,-0.3199},
      {0.0013821,0.13529,-0.079384,0.0011321,0.000214,-0.55742,-0.094695,0.058405,0.026434,-0.27851},
      {0.00089111,0.12432,-0.172,0.0011865,0.00060778,-0.46434,-0.087194,0.12315,-0.025199,-0.20171},
      {0.00048797,0.10912,-0.27032,0.0011155,0.00072105,-0.36951,-0.076648,0.19234,-0.081864,-0.12309},
      {0.00018094,0.084382,-0.37252,0.00084047,0.00093843,-0.28077,-0.059348,0.26463,-0.14523,-0.049706},
      {-1.09E-05,0.048724,-0.47314,0.00039782,0.0011034,-0.20713,-0.034372,0.33571,-0.21303,0.011185},
      {-8.78E-05,0.028811,-0.56631,0.00036947,0.0014323,-0.12295,-0.020491,0.40123,-0.26936,0.080574},
      {-0.00012498,0.015008,-0.64444,0.00034019,0.0018658,-0.048749,-0.010876,0.45618,-0.31514,0.14153},
      {-0.00011043,0.0095106,-0.65668,0.00020601,0.0037045,-0.038403,-0.0070056,0.46475,-0.32384,0.14747},
      {-9.15E-05,0.0056538,-0.66817,0.00010696,0.0042545,-0.029239,-0.004268,0.47278,-0.33138,0.15428},
      {-6.86E-05,0.0031987,-0.67924,3.93E-05,0.0038492,-0.020562,-0.0024979,0.48051,-0.33804,0.16206},
      {-5.01E-05,0.0020258,-0.68191,1.69E-06,0.0060805,-0.015316,-0.0016124,0.48235,-0.33995,0.16321},
      {-3.53E-05,0.00131,-0.68426,-1.08E-05,0.0067663,-0.012498,-0.0010528,0.48398,-0.3415,0.16456},
      {-0.0013777,0.00071973,0.69776,-0.0026592,0.00011829,-0.004372,0.00061396,0.49178,-0.34923,0.18084},
      {-0.0013965,0.00068037,0.69715,-0.0028481,0.00012407,-0.0048149,0.00066542,0.49124,-0.34904,0.18047},
      {-0.0014294,0.0006208,0.69621,-0.0031244,0.00013316,-0.0055137,0.00074643,0.49041,-0.34873,0.17987},
      {-0.001483,0.00054076,0.69489,-0.0034767,0.0001461,-0.0065115,0.00086165,0.48928,-0.34828,0.17903},
      {-0.0015657,0.00044144,0.69316,-0.0038822,0.00016343,-0.0078544,0.0010158,0.48784,-0.34765,0.17789},
      {-0.0014308,0.00037138,0.68791,-0.0034622,0.00018202,-0.014234,0.0010272,0.48453,-0.34492,0.17255},
      {-0.0011506,0.00031073,0.67986,-0.0026775,0.00020395,-0.024292,0.00094475,0.47952,-0.34067,0.16415},
      {-0.00080232,0.00024539,0.66969,-0.001875,0.00023116,-0.036819,0.00081971,0.47307,-0.33541,0.15369},
      {-0.0003831,0.0001784,0.65705,-0.0010947,0.00026432,-0.052195,0.0006446,0.46488,-0.32898,0.14086},
      {4.48E-05,0.0001682,0.63651,-0.000465,0.00029426,-0.076365,0.00039075,0.45101,-0.31866,0.12069},
      {0.0002426,0.00038069,0.58994,-0.00025251,0.00030827,-0.12955,2.26E-05,0.41826,-0.29516,0.076324},
      {0.0004112,0.00059381,0.53508,-8.94E-05,0.0003677,-0.19242,-0.00032359,0.3796,-0.26758,0.02395},
      {0.00053887,0.0008079,0.47102,1.07E-05,0.00048857,-0.26607,-0.00062984,0.33438,-0.23548,-0.037328},
      {0.00050242,0.0048244,0.36701,0.00016027,0.00045851,-0.38029,-0.0035832,0.26135,-0.18193,-0.13207},
      {0.00046005,0.0088012,0.25947,0.00029844,0.00034474,-0.49858,-0.0065005,0.18583,-0.12663,-0.23016},
      {0.00041754,0.012098,0.15537,0.00041286,0.00021021,-0.61421,-0.0089005,0.11252,-0.073236,-0.32601},
      {0.00054653,0.025117,0.095425,0.00051729,5.80E-05,-0.665,-0.017875,0.072152,-0.038261,-0.36793},
      {0.00064928,0.037102,0.047558,0.00058792,-9.25E-05,-0.70336,-0.026126,0.04023,-0.0097611,-0.39952},
      {0.00069985,0.046419,0.007356,0.0006159,-0.00023311,-0.73673,-0.032544,0.013337,0.013866,-0.427},
      {0.00080215,0.068573,-0.014684,0.00064562,-0.00014914,-0.69847,-0.048016,0.020981,0.019572,-0.39519},
      {0.00082932,0.084171,-0.034221,0.00060618,-9.59E-05,-0.66662,-0.058915,0.029507,0.021413,-0.36868},
      {0.00075889,0.091399,-0.055522,0.0004864,-7.41E-05,-0.63959,-0.063971,0.041187,0.016872,-0.34619},
      {0.00037604,0.075048,-0.15873,0.0003645,5.23E-05,-0.54037,-0.052605,0.11389,-0.042784,-0.26393},
      {0.00010859,0.059804,-0.26757,0.00019823,3.34E-05,-0.43305,-0.041973,0.19087,-0.10475,-0.17477},
      {-3.30E-05,0.050913,-0.38076,0.00025846,0.00010901,-0.3124,-0.035822,0.27091,-0.16584,-0.074743},
      {-9.71E-05,0.032947,-0.47224,0.00025932,0.00052902,-0.22775,-0.023315,0.33518,-0.22035,-0.005091},
      {-0.00013314,0.0194,-0.55643,0.00024832,0.00075601,-0.14664,-0.013889,0.39438,-0.26903,0.0619},
      {-0.00014493,0.0098604,-0.63344,0.00022757,0.00082653,-0.069335,-0.0072583,0.44857,-0.31214,0.12595},
      {-0.00012667,0.0057628,-0.65473,0.00014516,0.0014421,-0.049022,-0.004372,0.4635,-0.3247,0.14192},
      {-0.0001015,0.0034852,-0.66491,7.68E-05,0.0014673,-0.04041,-0.0027355,0.47059,-0.33082,0.14902},
      {-7.32E-05,0.0022331,-0.67518,3.37E-05,0.00099252,-0.03134,-0.0018063,0.47774,-0.33651,0.15723},
      {-5.04E-05,0.001662,-0.68116,1.41E-05,0.0012468,-0.025013,-0.0013565,0.48189,-0.33976,0.16211},
      {-0.0015025,0.00057986,0.70016,-0.00085479,0.0001397,-0.0037161,0.00072263,0.49481,-0.34964,0.18136},
      {-0.0015468,0.00054991,0.69951,-0.00095147,0.00014728,-0.0042562,0.00078241,0.49431,-0.34937,0.1809},
      {-0.0016177,0.00050481,0.6985,-0.0010916,0.00015914,-0.0051022,0.00087547,0.49355,-0.34895,0.18018},
      {-0.0017211,0.0004447,0.69709,-0.0012677,0.00017588,-0.006298,0.0010058,0.4925,-0.34835,0.17916},
      {-0.0018638,0.00037098,0.69524,-0.0014655,0.00019812,-0.0078871,0.001177,0.49115,-0.34754,0.17781},
      {-0.0020534,0.0002864,0.69292,-0.0016645,0.00022648,-0.0099145,0.0013919,0.4895,-0.3465,0.17609},
      {-0.0021953,0.00020199,0.68888,-0.0017439,0.00026042,-0.014019,0.001579,0.48675,-0.34458,0.17264},
      {-0.0017364,0.00015571,0.6763,-0.0012531,0.00029385,-0.029106,0.0013398,0.47841,-0.33837,0.16005},
      {-0.0012219,0.00011189,0.66097,-0.00077097,0.00033359,-0.04733,0.0010612,0.46816,-0.33086,0.14486},
      {-0.00068597,8.12E-05,0.64103,-0.00040196,0.00037485,-0.070194,0.00075396,0.45491,-0.32135,0.12581},
      {-0.00011446,5.34E-05,0.61595,-7.26E-05,0.00041692,-0.098388,0.00041142,0.43837,-0.30957,0.10235},
      {2.77E-05,0.00023602,0.55395,-4.18E-05,0.00048349,-0.16891,0.00010887,0.39493,-0.27876,0.043679},
      {0.00015466,0.0004087,0.48382,-1.56E-05,0.00055555,-0.24922,-0.0001835,0.3455,-0.24373,-0.023102},
      {0.00026929,0.00056236,0.40591,1.03E-05,0.00063142,-0.33903,-0.00045729,0.29031,-0.20465,-0.097749},
      {0.00028077,0.0028672,0.31234,9.73E-05,0.00055224,-0.44402,-0.0021748,0.22423,-0.15685,-0.18484},
      {0.0002527,0.0056061,0.21675,0.0001907,0.00039706,-0.55093,-0.0041481,0.15673,-0.10783,-0.27342},
      {0.00022343,0.0077297,0.12518,0.00025707,0.00023331,-0.65444,-0.0056616,0.091854,-0.060964,-0.35913},
      {0.00027079,0.015529,0.070385,0.00030258,8.35E-05,-0.70706,-0.01105,0.05419,-0.030477,-0.40257},
      {0.00031469,0.02395,0.03531,0.00031138,-4.52E-05,-0.73583,-0.016861,0.030769,-0.0097207,-0.42622},
      {0.0003154,0.029503,0.0069035,0.0002633,-0.00016401,-0.76034,-0.020691,0.012071,0.0063014,-0.44636},
      {0.00031702,0.039596,-0.014143,0.00018282,-0.00015175,-0.74223,-0.027733,0.016169,0.0085548,-0.43122},
      {0.00025786,0.045343,-0.033421,3.95E-05,-0.00012704,-0.71865,-0.031739,0.026815,0.0040473,-0.41154},
      {0.00023118,0.050216,-0.054008,7.47E-07,-0.00013952,-0.69166,-0.035152,0.039872,-0.0026625,-0.38914},
      {0.00010991,0.045313,-0.14915,6.31E-05,-7.63E-05,-0.58762,-0.031783,0.1069,-0.052557,-0.30289},
      {-1.72E-05,0.037849,-0.26321,0.00012261,-1.88E-06,-0.46431,-0.026632,0.18756,-0.11335,-0.20065},
      {-0.00012551,0.03017,-0.37807,0.0001636,6.46E-05,-0.34032,-0.021332,0.26881,-0.17463,-0.097834},
      {-0.00016762,0.01949,-0.46788,0.00016338,0.00024645,-0.24924,-0.013918,0.33207,-0.22473,-0.022503},
      {-0.00017371,0.010885,-0.54377,0.00014636,0.00035695,-0.1721,-0.007945,0.38545,-0.26681,0.041356},
      {-0.00016255,0.0054121,-0.61316,0.00012311,0.00037264,-0.098859,-0.0041581,0.43432,-0.30411,0.10211},
      {-0.00013722,0.0029363,-0.64724,7.84E-05,0.00040697,-0.062814,-0.002422,0.4583,-0.32229,0.13197},
      {-0.00010643,0.0020124,-0.65528,3.99E-05,0.00030843,-0.055279,-0.0017347,0.46384,-0.32669,0.13836},
      {-7.88E-05,0.0018574,-0.66117,2.28E-05,0.0003592,-0.048988,-0.001597,0.46785,-0.32964,0.1435},
      {-0.00078401,0.00038592,0.70364,-0.00015096,0.00014474,-0.0016478,0.00030285,0.49777,-0.35152,0.18306},
      {-0.00086473,0.00037198,0.70284,-0.00020598,0.00015337,-0.0023066,0.00037478,0.49723,-0.35116,0.1825},
      {-0.00098915,0.00035071,0.70157,-0.00028968,0.00016681,-0.0033447,0.00048532,0.49637,-0.35058,0.18162},
      {-0.0011609,0.00032177,0.69975,-0.00040307,0.00018564,-0.0048242,0.00063722,0.49517,-0.34976,0.18037},
      {-0.0013816,0.00028522,0.69731,-0.00054538,0.00021037,-0.0068111,0.00083151,0.49358,-0.34868,0.17869},
      {-0.0016513,0.00024152,0.69416,-0.00071399,0.00024148,-0.0093768,0.0010673,0.49156,-0.34729,0.17652},
      {-0.0019671,0.00019152,0.69019,-0.00090449,0.00027942,-0.012599,0.0013415,0.48907,-0.34557,0.17379},
      {-0.0023236,0.00013645,0.68531,-0.0011106,0.0003246,-0.016561,0.0016487,0.48607,-0.34348,0.17044},
      {-0.0020404,0.00010421,0.66857,-0.00096535,0.00036258,-0.034966,0.0014989,0.47511,-0.33571,0.15511},
      {-0.0014823,8.01E-05,0.64412,-0.00068149,0.00039799,-0.062358,0.0011508,0.45902,-0.3243,0.13233},
      {-0.00089723,5.54E-05,0.61502,-0.00039584,0.00043446,-0.094749,0.00077968,0.43989,-0.31075,0.1054},
      {-0.00030426,3.12E-05,0.58073,-0.00011898,0.00047063,-0.13265,0.00039705,0.41739,-0.29484,0.073904},
      {-8.98E-05,0.00013433,0.51491,-4.24E-05,0.00053241,-0.20831,0.00012065,0.37108,-0.26206,0.011027},
      {1.29E-05,0.00025775,0.43499,-1.79E-05,0.00060256,-0.30117,-0.00010885,0.31408,-0.22172,-0.066119},
      {9.84E-05,0.00036195,0.34774,4.35E-06,0.00067234,-0.40308,-0.0003093,0.25157,-0.17751,-0.15076},
      {0.00012191,0.0015067,0.25858,4.84E-05,0.00061202,-0.50569,-0.0011726,0.18792,-0.13199,-0.23583},
      {0.00011214,0.0031673,0.17771,9.07E-05,0.00044031,-0.59776,-0.0023372,0.13041,-0.090537,-0.31205},
      {9.31E-05,0.0042707,0.099035,0.00010076,0.00025781,-0.68837,-0.0031027,0.074296,-0.050331,-0.387},
      {9.17E-05,0.0078658,0.047146,7.99E-05,0.00010949,-0.7436,-0.0055838,0.038148,-0.022965,-0.43256},
      {8.50E-05,0.012377,0.022164,2.23E-05,2.32E-05,-0.76518,-0.0086987,0.02201,-0.0092576,-0.45024},
      {7.82E-05,0.015924,0.0037552,-1.20E-05,-6.05E-05,-0.77975,-0.011167,0.010711,0.00054019,-0.46219},
      {8.83E-05,0.021924,-0.014795,-1.25E-05,-0.00011114,-0.76707,-0.015367,0.014152,0.0011573,-0.45165},
      {8.66E-05,0.027724,-0.036863,-9.71E-06,-0.00012257,-0.73668,-0.019436,0.028523,-0.0060367,-0.42646},
      {6.35E-05,0.030695,-0.060833,-8.33E-06,-0.00012895,-0.70703,-0.021531,0.04447,-0.015769,-0.40187},
      {-1.33E-05,0.027402,-0.138,2.20E-05,-8.64E-05,-0.62212,-0.019278,0.098681,-0.055731,-0.33146},
      {-0.00010783,0.020905,-0.25325,6.11E-05,-1.62E-05,-0.49631,-0.014807,0.1802,-0.1166,-0.22714},
      {-0.00018814,0.014656,-0.36739,8.34E-05,4.63E-05,-0.37151,-0.010514,0.26095,-0.17677,-0.12365},
      {-0.00022034,0.0084683,-0.46002,8.00E-05,0.00012249,-0.27185,-0.0062514,0.32634,-0.22607,-0.041049},
      {-0.00020347,0.0039513,-0.52811,5.97E-05,0.00016923,-0.19895,-0.003136,0.37428,-0.26224,0.019372},
      {-0.00016938,0.0021653,-0.58533,5.02E-05,0.00020709,-0.13529,-0.0019313,0.4146,-0.29166,0.072141},
      {-0.00013974,0.0020184,-0.6232,4.38E-05,0.00027949,-0.091905,-0.001874,0.44125,-0.31058,0.10803},
      {-0.0001118,0.0018726,-0.62936,2.76E-05,0.00033801,-0.085278,-0.0017438,0.44545,-0.31366,0.11344},
      {-0.00043309,0.00033753,0.70583,0,0.00012673,7.32E-05,7.15E-05,0.49936,-0.35271,0.18452},
      {-0.00044992,0.00033473,0.70579,0,0.00013187,7.61E-05,8.55E-05,0.49935,-0.3527,0.18451},
      {-0.00047532,0.00033044,0.70573,0,0.00013983,8.07E-05,0.00010668,0.49933,-0.35267,0.1845},
      {-0.00062211,0.0003083,0.70373,-7.99E-05,0.00015973,-0.0015156,0.0002319,0.49812,-0.35183,0.18315},
      {-0.00082324,0.00027813,0.7008,-0.00019065,0.00018707,-0.0038694,0.00040332,0.49636,-0.3506,0.18116},
      {-0.0010626,0.00024223,0.69707,-0.00032012,0.00022129,-0.0068656,0.00060699,0.49415,-0.34906,0.17863},
      {-0.0013338,0.00020144,0.69245,-0.00046372,0.00026278,-0.010569,0.00083746,0.49145,-0.34717,0.1755},
      {-0.0016271,0.00015694,0.68687,-0.00061513,0.0003119,-0.015048,0.0010866,0.48825,-0.34492,0.17171},
      {-0.0019292,0.00011025,0.68024,-0.00076631,0.00036895,-0.02037,0.0013432,0.48452,-0.3423,0.16722},
      {-0.0018851,7.40E-05,0.66377,-0.00075542,0.00041853,-0.037237,0.0013495,0.47418,-0.33499,0.15316},
      {-0.0013423,5.41E-05,0.6309,-0.00052235,0.00044739,-0.073481,0.00099299,0.45262,-0.31978,0.12305},
      {-0.0007924,3.51E-05,0.59459,-0.00028833,0.00048434,-0.11352,0.00063867,0.42874,-0.30291,0.08979},
      {-0.00028816,2.05E-05,0.55435,-9.67E-05,0.00051565,-0.15765,0.00031629,0.40226,-0.28423,0.053146},
      {-5.35E-05,7.34E-05,0.48934,-2.24E-05,0.00056896,-0.23265,9.90E-05,0.35646,-0.25185,-0.0091424},
      {1.78E-05,0.00015626,0.40452,-4.90E-06,0.00063907,-0.3325,-4.78E-05,0.29522,-0.20855,-0.092066},
      {5.91E-05,0.00022241,0.31244,7.61E-06,0.00070351,-0.44107,-0.00015918,0.22868,-0.1615,-0.1822},
      {6.09E-05,0.0006467,0.22231,1.62E-05,0.00066702,-0.54668,-0.000482,0.16377,-0.11543,-0.26974},
      {3.77E-05,0.0013967,0.14725,8.09E-06,0.0004782,-0.63383,-0.00099868,0.11011,-0.077117,-0.34173},
      {2.61E-05,0.0020587,0.081454,2.72E-06,0.00028833,-0.71063,-0.0014723,0.062773,-0.043302,-0.40518},
      {2.19E-05,0.0038637,0.032458,-2.48E-06,0.00012773,-0.76516,-0.0027412,0.028211,-0.017947,-0.45022},
      {2.74E-05,0.0074978,0.016568,-8.59E-06,3.01E-05,-0.7759,-0.0052819,0.019085,-0.0096539,-0.45905},
      {2.60E-05,0.010164,0.0022231,-1.45E-05,-5.69E-05,-0.7853,-0.0071487,0.011463,-0.0029133,-0.46678},
      {1.79E-05,0.01288,-0.014649,-1.76E-05,-0.00010728,-0.77951,-0.0090572,0.013058,-0.0026503,-0.46194},
      {-3.80E-06,0.015565,-0.03982,-1.66E-05,-0.000108,-0.74866,-0.010953,0.029943,-0.013187,-0.43635},
      {-3.84E-05,0.016064,-0.066992,-1.71E-05,-0.00010453,-0.71773,-0.011328,0.048436,-0.02596,-0.41071},
      {-9.24E-05,0.01343,-0.12572,-7.83E-06,-7.58E-05,-0.65341,-0.0095315,0.089598,-0.056336,-0.35737},
      {-0.00016057,0.0083002,-0.23991,1.21E-05,-1.03E-05,-0.52725,-0.0060247,0.17037,-0.11595,-0.25275},
      {-0.00020897,0.0041502,-0.34748,2.20E-05,5.14E-05,-0.40765,-0.0032057,0.24646,-0.17175,-0.15358},
      {-0.00022582,0.0020559,-0.43753,2.69E-05,0.00017372,-0.30585,-0.0018308,0.31012,-0.21775,-0.069291},
      {-0.00018894,0.0018077,-0.49354,2.82E-05,0.00032992,-0.24149,-0.0017254,0.3496,-0.24579,-0.016113},
      {-0.00016119,0.001741,-0.54427,2.83E-05,0.0004071,-0.18307,-0.0017453,0.38537,-0.27112,0.032244},
      {-0.0001422,0.0018366,-0.58921,2.73E-05,0.00037364,-0.13123,-0.0018777,0.4171,-0.29348,0.075292},
      {-0.0002284,0.00022131,0.70604,0,0.00023509,0.00013573,7.46E-06,0.49951,-0.35298,0.18441},
      {-0.00023799,0.00021816,0.70599,0,0.00025654,0.00014811,1.66E-05,0.49949,-0.35297,0.18439},
      {-0.0002521,0.00021329,0.70591,0,0.00029192,0.00016854,3.03E-05,0.49946,-0.35294,0.18436},
      {-0.00027024,0.00020657,0.70579,0,0.00034563,0.00019955,4.82E-05,0.49942,-0.3529,0.18431},
      {-0.00029129,0.0001979,0.70563,0,0.00042365,0.0002446,6.97E-05,0.49935,-0.35285,0.18423},
      {-0.00039137,0.00017817,0.70334,-3.93E-05,0.00050036,-0.0015139,0.00015867,0.49807,-0.35194,0.18266},
      {-0.00057095,0.00014756,0.69843,-0.00011531,0.00055381,-0.0055206,0.00031592,0.49534,-0.35,0.17926},
      {-0.00074915,0.00011542,0.69263,-0.00018631,0.00059947,-0.010321,0.0004746,0.49213,-0.34772,0.17522},
      {-0.00090976,8.33E-05,0.6859,-0.00024527,0.00062697,-0.015978,0.0006221,0.48845,-0.3451,0.17049},
      {-0.001033,5.30E-05,0.67824,-0.00028502,0.00062263,-0.02256,0.0007431,0.48429,-0.34214,0.16504},
      {-0.0010317,2.84E-05,0.66619,-0.00028047,0.00058293,-0.034157,0.00077433,0.47723,-0.33714,0.15548},
      {-0.00061803,2.06E-05,0.62982,-0.00016046,0.0006002,-0.074029,0.00051055,0.45322,-0.32023,0.12239},
      {-0.00026959,1.69E-05,0.5897,-7.05E-05,0.00060324,-0.11783,0.00029256,0.42672,-0.30157,0.086055},
      {-1.81E-05,1.81E-05,0.54584,-1.55E-05,0.00058552,-0.16554,0.00014218,0.39775,-0.28114,0.046522},
      {7.73E-05,4.69E-05,0.48065,2.65E-06,0.00058603,-0.23993,5.62E-05,0.35227,-0.249,-0.015165},
      {6.78E-05,9.81E-05,0.39107,5.92E-06,0.0006303,-0.34642,-1.33E-05,0.28698,-0.20282,-0.10353},
      {5.44E-05,0.00014346,0.29795,8.63E-06,0.00066921,-0.45676,-7.70E-05,0.21934,-0.15499,-0.19509},
      {3.95E-05,0.00030623,0.20857,9.45E-06,0.0006535,-0.56215,-0.00021724,0.1547,-0.10922,-0.28246},
      {2.78E-05,0.00086881,0.14419,4.62E-06,0.00045579,-0.63741,-0.00062264,0.10838,-0.076168,-0.34463},
      {1.57E-05,0.0013075,0.080061,-5.19E-07,0.00026554,-0.71244,-0.00094094,0.062275,-0.043342,-0.40662},
      {5.57E-06,0.0020067,0.024526,-6.00E-06,0.00010188,-0.77625,-0.0014397,0.022831,-0.015093,-0.45935},
      {2.70E-06,0.004271,0.011304,-1.19E-05,2.15E-05,-0.78428,-0.0030274,0.01633,-0.0093469,-0.46594},
      {-4.10E-06,0.0057162,-0.00047252,-1.76E-05,-4.46E-05,-0.79081,-0.0040448,0.011324,-0.0050706,-0.4713},
      {-1.63E-05,0.0065039,-0.013405,-2.22E-05,-8.63E-05,-0.79017,-0.0046066,0.011159,-0.004541,-0.47073},
      {-4.70E-05,0.0068349,-0.042006,-2.33E-05,-7.67E-05,-0.75765,-0.0048649,0.030744,-0.018168,-0.44376},
      {-7.79E-05,0.0057435,-0.0734,-2.62E-05,-5.90E-05,-0.72332,-0.0041365,0.05246,-0.034021,-0.41529},
      {-0.00011153,0.0033943,-0.11573,-2.78E-05,-3.20E-05,-0.67754,-0.0025419,0.082085,-0.056098,-0.37733},
      {-0.00014282,0.0023163,-0.22202,-1.26E-05,0.00030735,-0.55514,-0.0018859,0.15736,-0.10977,-0.27626},
      {-0.00016909,0.0016595,-0.31916,1.11E-07,0.00057254,-0.44298,-0.0015398,0.22612,-0.15861,-0.18358},
      {-0.00019149,0.0011676,-0.40687,1.03E-05,0.00070106,-0.34183,-0.0013212,0.28816,-0.20261,-0.099854},
      {-0.00016565,0.0011616,-0.45767,1.17E-05,0.00080266,-0.28316,-0.001379,0.32401,-0.22796,-0.05133},
      {-0.00014786,0.0013059,-0.50334,1.22E-05,0.00077844,-0.23038,-0.0015434,0.35626,-0.25068,-0.0075189},
      {-6.57E-05,8.65E-05,0.70604,0,0.00062199,0.00035911,-1.22E-05,0.49945,-0.35309,0.18404},
      {-6.89E-05,8.42E-05,0.70596,0,0.00067934,0.00039222,-8.09E-06,0.49941,-0.35306,0.18399},
      {-7.33E-05,8.06E-05,0.70583,0,0.00077105,0.00044517,-2.16E-06,0.49934,-0.35301,0.1839},
      {-7.84E-05,7.57E-05,0.70564,0,0.00090459,0.00052227,5.28E-06,0.49925,-0.35294,0.18377},
      {-8.29E-05,6.94E-05,0.70539,0,0.001089,0.00062875,1.36E-05,0.49912,-0.35285,0.18359},
      {-8.56E-05,6.16E-05,0.70507,0,0.0013356,0.00077114,2.16E-05,0.49895,-0.35273,0.18336},
      {-8.45E-05,5.24E-05,0.70466,0,0.0016585,0.00095754,2.81E-05,0.49872,-0.35258,0.18305},
      {-0.00011929,3.75E-05,0.70005,-1.17E-05,0.0017074,-0.0029912,7.11E-05,0.49621,-0.3508,0.1797},
      {-0.00013226,2.20E-05,0.69333,-1.81E-05,0.0016127,-0.0090967,0.00010247,0.49256,-0.34821,0.17478},
      {-8.70E-05,8.77E-06,0.68569,-1.06E-05,0.0014595,-0.016193,9.23E-05,0.48841,-0.34529,0.16911},
      {-3.74E-05,2.44E-06,0.67686,-7.19E-07,0.0012579,-0.024652,7.52E-05,0.48349,-0.34182,0.16239},
      {-4.16E-05,6.22E-07,0.6666,-9.08E-07,0.00088195,-0.035059,9.38E-05,0.47749,-0.33757,0.1543},
      {-6.48E-06,4.86E-06,0.62998,-2.58E-07,0.00078486,-0.075288,8.99E-05,0.45295,-0.32021,0.12108},
      {3.19E-05,9.55E-06,0.58814,5.14E-07,0.0007152,-0.12148,8.45E-05,0.42473,-0.30026,0.082879},
      {6.83E-05,1.39E-05,0.5439,1.30E-06,0.00061668,-0.17052,8.03E-05,0.39479,-0.27909,0.042352},
      {8.84E-05,2.78E-05,0.48563,2.49E-06,0.00053085,-0.23711,6.19E-05,0.3541,-0.25031,-0.012735},
      {7.06E-05,6.53E-05,0.39297,4.52E-06,0.00055604,-0.34638,6.20E-06,0.28714,-0.20296,-0.10338},
      {5.14E-05,9.65E-05,0.29719,5.98E-06,0.000573,-0.45889,-4.31E-05,0.21821,-0.15422,-0.19669},
      {3.18E-05,0.00013842,0.20054,6.48E-06,0.00057046,-0.57196,-9.68E-05,0.14895,-0.10524,-0.29045},
      {1.98E-05,0.00048571,0.13799,1.01E-06,0.00038317,-0.64515,-0.0003512,0.10404,-0.073304,-0.35091},
      {8.51E-06,0.00072576,0.076545,-4.65E-06,0.00021449,-0.71698,-0.00053022,0.060026,-0.042055,-0.41027},
      {-1.31E-06,0.00085423,0.016961,-1.05E-05,7.12E-05,-0.78651,-0.00063074,0.017478,-0.0119,-0.46774},
      {-7.36E-06,0.0019219,0.0054458,-1.72E-05,1.18E-05,-0.79211,-0.0013857,0.013306,-0.0084036,-0.47233},
      {-1.39E-05,0.0023449,-0.0045114,-2.35E-05,-2.50E-05,-0.7949,-0.0016921,0.011311,-0.0067701,-0.47459},
      {-2.06E-05,0.0021467,-0.013877,-2.96E-05,-3.95E-05,-0.79595,-0.0015674,0.01081,-0.0065059,-0.47543},
      {-4.48E-05,0.0018612,-0.045752,-3.21E-05,4.22E-05,-0.76014,-0.0014086,0.032772,-0.022125,-0.44584},
      {-6.46E-05,0.0017777,-0.08172,-3.35E-05,0.00039573,-0.71817,-0.0014032,0.058061,-0.039988,-0.41155},
      {-8.00E-05,0.0015824,-0.12023,-3.39E-05,0.00109,-0.67278,-0.0013294,0.085164,-0.059188,-0.37491},
      {-0.00010428,0.0011165,-0.20788,-2.26E-05,0.0014643,-0.57122,-0.0011098,0.14719,-0.10318,-0.2912},
      {-0.00012662,0.00074074,-0.29338,-1.18E-05,0.0016275,-0.47241,-0.00096765,0.20768,-0.14603,-0.20947},
      {-0.00014532,0.00045816,-0.37011,-2.86E-06,0.0016083,-0.38397,-0.00089863,0.26194,-0.18442,-0.13608},
      {-0.0001383,0.00056269,-0.42165,3.79E-07,0.0015483,-0.32443,-0.00105,0.29836,-0.21008,-0.08661},
      {-1.36E-06,4.57E-06,0.70616,0,0.00078593,0.00045376,-7.88E-07,0.49944,-0.35315,0.18388},
      {-1.53E-06,4.62E-06,0.70601,0,0.00091224,0.00052668,-4.97E-07,0.49935,-0.35309,0.18376},
      {-1.78E-06,4.70E-06,0.70577,0,0.0011168,0.00064481,-5.29E-08,0.4992,-0.35299,0.18357},
      {-2.10E-06,4.80E-06,0.70542,0,0.00142,0.00081982,5.52E-07,0.49899,-0.35283,0.18328},
      {-2.48E-06,4.92E-06,0.70493,0,0.0018477,0.0010668,1.32E-06,0.49869,-0.35262,0.18287},
      {-2.89E-06,5.06E-06,0.70427,0,0.0024337,0.0014051,2.23E-06,0.49827,-0.35232,0.18231},
      {-3.29E-06,5.20E-06,0.7034,0,0.0032215,0.0018599,3.28E-06,0.49771,-0.35193,0.18155},
      {-3.65E-06,5.34E-06,0.70226,0,0.0042659,0.0024629,4.44E-06,0.49697,-0.3514,0.18055},
      {-4.52E-06,5.14E-06,0.69942,-3.20E-08,0.0052362,0.0012963,8.55E-06,0.49522,-0.35016,0.17819},
      {-6.97E-06,3.82E-06,0.69098,-1.77E-07,0.0048352,-0.007597,2.29E-05,0.49019,-0.3466,0.17139},
      {-8.45E-06,2.48E-06,0.68131,-3.21E-07,0.0041671,-0.018336,3.74E-05,0.48431,-0.34243,0.16345},
      {-8.69E-06,1.16E-06,0.6703,-4.58E-07,0.0031389,-0.031236,5.14E-05,0.47749,-0.33759,0.15423},
      {-7.47E-06,-8.84E-08,0.65787,-5.83E-07,0.001639,-0.046662,6.45E-05,0.46962,-0.33202,0.14359},
      {1.39E-05,2.13E-06,0.6255,-1.23E-07,0.00097283,-0.083504,6.67E-05,0.44775,-0.31656,0.114},
      {4.22E-05,5.58E-06,0.58229,5.74E-07,0.00082295,-0.13197,6.50E-05,0.41823,-0.29568,0.074033},
      {6.74E-05,8.57E-06,0.5364,1.22E-06,0.00063131,-0.18378,6.37E-05,0.38669,-0.27338,0.031346},
      {8.42E-05,1.38E-05,0.48288,1.84E-06,0.00042109,-0.245,5.78E-05,0.34942,-0.24702,-0.019114},
      {6.30E-05,3.78E-05,0.38809,2.52E-06,0.00042343,-0.35577,1.64E-05,0.28158,-0.19905,-0.11096},
      {4.45E-05,5.42E-05,0.29041,2.13E-06,0.00039974,-0.46929,-1.56E-05,0.21209,-0.14992,-0.20506},
      {2.41E-05,6.20E-05,0.19087,4.64E-07,0.00036029,-0.58458,-4.07E-05,0.14154,-0.10004,-0.30059},
      {1.26E-05,0.00019941,0.12751,-5.70E-06,0.00021989,-0.65822,-0.00014937,0.096465,-0.068098,-0.36148},
      {4.02E-06,0.00026747,0.071119,-1.26E-05,0.0001044,-0.72356,-0.00020864,0.056503,-0.039803,-0.41551},
      {-2.14E-06,0.00024734,0.017788,-1.98E-05,2.91E-05,-0.78502,-0.00020597,0.018941,-0.013251,-0.46636},
      {-7.17E-06,0.00050069,0.00041601,-2.61E-05,5.00E-06,-0.79696,-0.00039732,0.011443,-0.0078121,-0.47623},
      {-1.12E-05,0.00074322,-0.0084023,-3.18E-05,-1.30E-07,-0.79533,-0.0005858,0.012228,-0.0082314,-0.47489},
      {-1.43E-05,0.00085177,-0.01763,-3.69E-05,4.85E-06,-0.79227,-0.00068424,0.013973,-0.009394,-0.47237},
      {-2.84E-05,0.00081125,-0.047772,-3.85E-05,0.00039407,-0.75866,-0.00070477,0.034089,-0.023588,-0.44506},
      {-4.29E-05,0.00067501,-0.086674,-3.83E-05,0.0012387,-0.71247,-0.00067416,0.06148,-0.042961,-0.40798},
      {-5.33E-05,0.00047643,-0.12727,-3.70E-05,0.0025186,-0.66362,-0.00060866,0.090092,-0.063226,-0.36931},
      {-7.00E-05,0.00024768,-0.19503,-2.91E-05,0.0031656,-0.58438,-0.0005539,0.13799,-0.097116,-0.30451},
      {-8.85E-05,6.54E-05,-0.26941,-1.96E-05,0.003161,-0.49851,-0.00054987,0.1906,-0.13429,-0.23328},
      {-0.00010351,-8.99E-05,-0.33564,-1.11E-05,0.0029316,-0.42244,-0.0005688,0.23742,-0.16737,-0.16985},
      {-2.52E-08,2.29E-06,0.70693,0,0.0001668,9.63E-05,-1.48E-06,0.49988,-0.35347,0.18448},
      {-6.51E-08,2.32E-06,0.70665,0,0.000423,0.00024422,-1.26E-06,0.4997,-0.35334,0.18423},
      {-1.20E-07,2.37E-06,0.70622,0,0.00083104,0.0004798,-9.33E-07,0.49941,-0.35313,0.18384},
      {-1.83E-07,2.42E-06,0.70559,0,0.0014217,0.00082081,-4.83E-07,0.49899,-0.35284,0.18328},
      {-2.42E-07,2.49E-06,0.70473,0,0.0022313,0.0012883,8.62E-08,0.49842,-0.35243,0.1825},
      {-2.80E-07,2.56E-06,0.70359,0,0.0033044,0.0019078,7.67E-07,0.49766,-0.35189,0.18147},
      {-2.77E-07,2.63E-06,0.70213,0,0.0046952,0.0027107,1.55E-06,0.49667,-0.3512,0.18014},
      {-2.08E-07,2.70E-06,0.70028,0,0.0064696,0.0037352,2.40E-06,0.49542,-0.35031,0.17844},
      {-4.91E-08,2.75E-06,0.69796,0,0.0087072,0.0050271,3.32E-06,0.49384,-0.34919,0.1763},
      {2.26E-07,2.77E-06,0.69507,0,0.011503,0.0066411,4.26E-06,0.49186,-0.34779,0.17362},
      {1.53E-06,2.03E-06,0.68591,-8.02E-08,0.010925,-0.004001,1.30E-05,0.48595,-0.3436,0.16563},
      {3.83E-06,1.14E-06,0.67409,-1.73E-07,0.0090359,-0.019831,2.31E-05,0.47825,-0.33815,0.15522},
      {7.59E-06,3.24E-07,0.66066,-2.53E-07,0.0065696,-0.038589,3.27E-05,0.46936,-0.33187,0.14321},
      {1.55E-05,-3.51E-07,0.6452,-3.13E-07,0.0034106,-0.06089,4.35E-05,0.45905,-0.32456,0.12925},
      {3.22E-05,5.97E-07,0.61496,-8.09E-08,0.0013577,-0.098194,5.02E-05,0.43837,-0.30994,0.10127},
      {5.39E-05,2.71E-06,0.56892,3.39E-07,0.0011164,-0.15049,5.33E-05,0.4066,-0.28746,0.058254},
      {7.13E-05,4.22E-06,0.51994,6.15E-07,0.00075534,-0.20652,5.59E-05,0.37266,-0.26346,0.012311},
      {8.31E-05,5.03E-06,0.46807,7.21E-07,0.00023589,-0.26634,5.75E-05,0.33658,-0.23795,-0.03654},
      {5.82E-05,1.33E-05,0.3741,-8.57E-07,0.00018468,-0.37509,2.91E-05,0.27004,-0.19091,-0.12664},
      {3.31E-05,1.50E-05,0.27669,-3.52E-06,0.00014934,-0.48757,6.53E-06,0.20121,-0.14226,-0.21985},
      {1.17E-05,9.35E-06,0.17807,-7.30E-06,0.00010539,-0.6012,-6.83E-06,0.13169,-0.093111,-0.31401},
      {5.15E-06,3.97E-05,0.11481,-1.34E-05,7.27E-05,-0.67413,-4.04E-05,0.087027,-0.061513,-0.37443},
      {2.06E-06,6.85E-05,0.066369,-2.09E-05,4.28E-05,-0.72962,-7.39E-05,0.05302,-0.037449,-0.42041},
      {-6.22E-07,8.12E-05,0.02067,-2.93E-05,1.99E-05,-0.78153,-9.76E-05,0.021218,-0.014952,-0.46342},
      {-3.67E-06,0.00017873,-0.0013779,-3.60E-05,1.46E-05,-0.7983,-0.00018514,0.010842,-0.0075554,-0.47733},
      {-6.36E-06,0.00025538,-0.010693,-4.07E-05,2.49E-05,-0.79451,-0.00026318,0.013055,-0.0090638,-0.47421},
      {-8.08E-06,0.00024943,-0.020275,-4.42E-05,4.57E-05,-0.78947,-0.0002873,0.016079,-0.011185,-0.47007},
      {-1.54E-05,0.00016504,-0.046494,-4.48E-05,0.00066003,-0.76065,-0.00028015,0.033074,-0.023199,-0.44705},
      {-2.50E-05,2.93E-05,-0.087317,-4.28E-05,0.0021208,-0.71114,-0.00026031,0.061851,-0.043549,-0.40809},
      {-3.08E-05,-0.00012309,-0.12906,-3.95E-05,0.0041049,-0.65966,-0.00023649,0.091301,-0.064382,-0.36824},
      {-4.02E-05,-0.00021592,-0.18084,-3.25E-05,0.0051166,-0.59811,-0.00027073,0.12789,-0.090215,-0.31866},
      {-5.70E-05,-0.0002968,-0.24312,-2.28E-05,0.0044092,-0.52733,-0.00033469,0.17193,-0.12129,-0.25894},
      {0,9.02E-07,0.70709,0,1.40E-05,8.10E-06,-6.38E-07,0.49999,-0.35355,0.18462},
      {0,9.24E-07,0.70709,0,1.45E-05,8.35E-06,-6.53E-07,0.49999,-0.35355,0.18462},
      {0,9.55E-07,0.70709,0,1.51E-05,8.74E-06,-6.75E-07,0.49999,-0.35354,0.18462},
      {0,9.96E-07,0.70709,0,1.61E-05,9.27E-06,-7.04E-07,0.49999,-0.35354,0.18462},
      {6.50E-08,1.04E-06,0.70674,0,0.00035746,0.00020638,-6.05E-07,0.49975,-0.35337,0.18429},
      {4.15E-07,1.08E-06,0.70496,0,0.002092,0.0012078,1.51E-08,0.49852,-0.35251,0.18263},
      {8.98E-07,1.12E-06,0.70268,0,0.0043122,0.0024897,7.64E-07,0.49695,-0.35139,0.18051},
      {1.54E-06,1.15E-06,0.69983,0,0.0071029,0.0041009,1.64E-06,0.49497,-0.35,0.17784},
      {2.36E-06,1.17E-06,0.6963,0,0.010561,0.0060973,2.63E-06,0.49253,-0.34827,0.17453},
      {3.38E-06,1.17E-06,0.69199,0,0.014795,0.0085418,3.73E-06,0.48953,-0.34615,0.17047},
      {4.58E-06,1.15E-06,0.68678,0,0.019926,0.011504,4.89E-06,0.4859,-0.34358,0.16556},
      {8.69E-06,8.90E-07,0.67719,-2.17E-08,0.021475,0.0035537,9.82E-06,0.47939,-0.33897,0.15674},
      {1.64E-05,4.53E-07,0.66228,-5.89E-08,0.017681,-0.019438,1.84E-05,0.46932,-0.33185,0.14313},
      {2.45E-05,1.03E-07,0.64535,-8.26E-08,0.013001,-0.046335,2.60E-05,0.45781,-0.3237,0.12755},
      {3.22E-05,-1.38E-07,0.62617,-9.05E-08,0.007317,-0.077632,3.18E-05,0.44467,-0.3144,0.10976},
      {3.94E-05,9.01E-08,0.59689,-4.07E-08,0.0026407,-0.11883,3.44E-05,0.4244,-0.30007,0.082319},
      {4.43E-05,7.39E-07,0.54827,1.32E-08,0.0020673,-0.1751,3.32E-05,0.39054,-0.27613,0.03648},
      {4.26E-05,7.61E-07,0.49672,-8.57E-08,0.0012896,-0.23527,2.95E-05,0.35453,-0.25067,-0.012289},
      {4.69E-05,8.79E-07,0.44036,-2.19E-07,0.00026495,-0.30159,3.22E-05,0.315,-0.22272,-0.065804},
      {3.75E-05,1.77E-06,0.35249,-3.10E-06,6.02E-05,-0.40308,2.22E-05,0.25307,-0.17893,-0.14966},
      {2.46E-05,1.85E-06,0.25924,-7.60E-06,5.94E-05,-0.51037,9.04E-06,0.18736,-0.13247,-0.23863},
      {1.20E-05,6.40E-07,0.1686,-1.33E-05,5.71E-05,-0.61457,-3.94E-06,0.12355,-0.087362,-0.32502},
      {5.20E-06,7.36E-06,0.10506,-2.11E-05,4.38E-05,-0.68718,-2.33E-05,0.079078,-0.055914,-0.38521},
      {2.68E-06,1.18E-05,0.062174,-3.03E-05,2.75E-05,-0.73546,-4.23E-05,0.049492,-0.034989,-0.42522},
      {6.36E-07,6.03E-06,0.022284,-4.03E-05,1.66E-05,-0.77992,-5.51E-05,0.022248,-0.015725,-0.46207},
      {-1.18E-06,7.77E-06,-0.002573,-4.80E-05,2.13E-05,-0.80051,-7.83E-05,0.0095931,-0.0067665,-0.47916},
      {-2.61E-06,-8.26E-06,-0.012185,-5.09E-05,4.76E-05,-0.79483,-9.74E-05,0.013018,-0.0091748,-0.47448},
      {-3.13E-06,-5.69E-05,-0.021899,-5.23E-05,8.44E-05,-0.7881,-9.75E-05,0.017096,-0.012058,-0.46895},
      {-5.53E-06,-9.97E-05,-0.041524,-5.07E-05,0.00067385,-0.76688,-0.00011661,0.029447,-0.020773,-0.4522},
      {-1.09E-05,-0.00017113,-0.079597,-4.62E-05,0.0023635,-0.72004,-0.00014455,0.05631,-0.03974,-0.41579},
      {-1.35E-05,-0.00025261,-0.11535,-4.03E-05,0.0040915,-0.6758,-0.0001689,0.081554,-0.057567,-0.38159},
      {-2.03E-05,-0.00030846,-0.15254,-3.27E-05,0.0053036,-0.63071,-0.00020972,0.10784,-0.076114,-0.34594},
      {0,2.82E-07,0.7071,0,8.41E-06,4.86E-06,-1.99E-07,0.49999,-0.35355,0.18463},
      {0,2.89E-07,0.7071,0,8.76E-06,5.06E-06,-2.05E-07,0.49999,-0.35355,0.18463},
      {0,3.00E-07,0.7071,0,9.30E-06,5.37E-06,-2.12E-07,0.49999,-0.35355,0.18463},
      {0,3.12E-07,0.7071,0,1.00E-05,5.79E-06,-2.21E-07,0.49999,-0.35355,0.18463},
      {0,3.26E-07,0.7071,0,1.10E-05,6.33E-06,-2.31E-07,0.49999,-0.35355,0.18463},
      {0,3.38E-07,0.70709,0,1.21E-05,6.99E-06,-2.39E-07,0.49999,-0.35355,0.18463},
      {1.90E-08,3.46E-07,0.70701,0,9.57E-05,5.53E-05,-2.27E-07,0.49993,-0.35351,0.18455},
      {8.69E-07,3.41E-07,0.70313,0,0.0039206,0.0022636,5.49E-07,0.49723,-0.35159,0.18088},
      {1.81E-06,3.25E-07,0.69846,0,0.0085431,0.0049324,1.37E-06,0.49396,-0.34928,0.17646},
      {2.79E-06,2.97E-07,0.69288,0,0.014063,0.0081195,2.18E-06,0.49005,-0.34652,0.17117},
      {3.77E-06,2.52E-07,0.68629,0,0.020591,0.011888,2.94E-06,0.48544,-0.34325,0.16492},
      {4.66E-06,1.89E-07,0.67857,0,0.028243,0.016306,3.57E-06,0.48003,-0.33943,0.1576},
      {6.32E-06,9.63E-08,0.6681,-9.43E-10,0.034281,0.014835,4.73E-06,0.47272,-0.33426,0.14771},
      {1.09E-05,1.09E-09,0.64937,-1.22E-10,0.028203,-0.016807,7.73E-06,0.45979,-0.32511,0.1302},
      {1.65E-05,0,0.62854,0,0.019765,-0.055009,1.16E-05,0.44534,-0.31489,0.11064},
      {2.21E-05,0,0.60284,0,0.011192,-0.099115,1.57E-05,0.42742,-0.30222,0.086382},
      {2.78E-05,2.93E-08,0.56896,-1.63E-08,0.0037525,-0.15075,1.96E-05,0.40368,-0.28543,0.05425},
      {3.32E-05,1.98E-07,0.51588,-1.62E-07,0.002643,-0.21349,2.32E-05,0.36644,-0.2591,0.0038288},
      {3.82E-05,2.99E-07,0.45975,-3.80E-07,0.0015167,-0.27989,2.64E-05,0.32697,-0.23118,-0.04961},
      {4.25E-05,3.19E-07,0.40064,-6.87E-07,0.00040389,-0.34984,2.92E-05,0.28531,-0.20172,-0.10602},
      {3.51E-05,-6.75E-07,0.32227,-4.73E-06,3.22E-05,-0.44055,2.11E-05,0.23015,-0.16272,-0.1807},
      {2.25E-05,-3.30E-06,0.23698,-1.18E-05,3.02E-05,-0.53842,7.83E-06,0.17021,-0.12035,-0.26184},
      {1.11E-05,-7.49E-06,0.15492,-2.05E-05,2.74E-05,-0.63254,-4.96E-06,0.11257,-0.079606,-0.33987},
      {4.29E-06,-1.30E-05,0.092455,-3.05E-05,2.18E-05,-0.70358,-1.76E-05,0.069052,-0.04884,-0.39878},
      {2.45E-06,-2.26E-05,0.055376,-4.14E-05,1.60E-05,-0.74446,-2.85E-05,0.044001,-0.03113,-0.43266},
      {1.16E-06,-3.42E-05,0.021386,-5.47E-05,1.41E-05,-0.7812,-3.84E-05,0.021473,-0.015207,-0.46313},
      {3.81E-07,-4.97E-05,-0.00329,-6.56E-05,2.30E-05,-0.8031,-4.96E-05,0.0080242,-0.0057,-0.4813},
      {8.29E-08,-7.50E-05,-0.012254,-6.59E-05,5.75E-05,-0.79665,-6.56E-05,0.011922,-0.0084442,-0.476},
      {4.57E-07,-0.00010721,-0.020656,-6.28E-05,9.68E-05,-0.79009,-7.91E-05,0.01589,-0.011238,-0.47061},
      {3.74E-08,-0.00014166,-0.032382,-5.65E-05,0.00037219,-0.77817,-9.63E-05,0.022891,-0.016169,-0.46112},
      {-4.51E-06,-0.00019426,-0.065229,-5.04E-05,0.0019319,-0.7375,-0.00013011,0.04611,-0.032553,-0.42964},
      {-7.92E-06,-0.00024323,-0.094184,-4.26E-05,0.0033845,-0.70151,-0.00016229,0.06658,-0.046993,-0.40189},
      {0,2.13E-08,0.7071,0,4.70E-06,2.71E-06,-1.51E-08,0.5,-0.35355,0.18463},
      {0,2.06E-08,0.7071,0,4.99E-06,2.88E-06,-1.46E-08,0.5,-0.35355,0.18463},
      {0,1.91E-08,0.7071,0,5.44E-06,3.14E-06,-1.35E-08,0.5,-0.35355,0.18463},
      {0,1.61E-08,0.7071,0,6.06E-06,3.50E-06,-1.14E-08,0.5,-0.35355,0.18463},
      {0,1.07E-08,0.7071,0,6.86E-06,3.96E-06,-7.55E-09,0.5,-0.35355,0.18463},
      {0,1.60E-09,0.7071,0,7.84E-06,4.52E-06,-1.13E-09,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.94E-06,5.16E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,1.02E-05,5.87E-06,0,0.49999,-0.35355,0.18463},
      {1.78E-07,0,0.70565,0,0.0014437,0.00083354,1.26E-07,0.49898,-0.35283,0.18325},
      {9.16E-07,0,0.6997,0,0.0073536,0.0042456,6.48E-07,0.4948,-0.34988,0.1776},
      {1.72E-06,0,0.69331,0,0.013701,0.0079104,1.21E-06,0.49031,-0.3467,0.17152},
      {2.57E-06,0,0.68659,0,0.02038,0.011766,1.82E-06,0.48559,-0.34336,0.16512},
      {3.47E-06,0,0.67966,0,0.027261,0.015739,2.45E-06,0.48072,-0.33992,0.15854},
      {4.38E-06,0,0.67269,0,0.03419,0.019739,3.10E-06,0.47582,-0.33645,0.1519},
      {9.33E-06,0,0.64715,0,0.027046,-0.021854,6.60E-06,0.45792,-0.3238,0.12767},
      {1.45E-05,0,0.61526,0,0.019044,-0.072285,1.02E-05,0.43553,-0.30796,0.097353},
      {1.94E-05,0,0.57729,0,0.011226,-0.12948,1.37E-05,0.40879,-0.28905,0.061159},
      {2.39E-05,0,0.53241,0,0.0037816,-0.19406,1.69E-05,0.37713,-0.26666,0.018298},
      {2.76E-05,-9.75E-09,0.47701,-3.30E-07,0.0025349,-0.26,1.93E-05,0.33807,-0.23904,-0.034583},
      {3.06E-05,-1.08E-07,0.41855,-7.73E-07,0.0014454,-0.32927,2.10E-05,0.29681,-0.20986,-0.090459},
      {3.24E-05,-3.12E-07,0.35721,-1.34E-06,0.00045223,-0.40182,2.20E-05,0.25343,-0.17919,-0.14918},
      {2.82E-05,-2.96E-06,0.28589,-6.82E-06,1.39E-05,-0.4844,1.63E-05,0.20332,-0.14376,-0.21702},
      {1.77E-05,-8.91E-06,0.20888,-1.83E-05,1.26E-05,-0.57239,3.45E-06,0.14942,-0.10566,-0.28998},
      {8.38E-06,-1.67E-05,0.13513,-3.25E-05,1.10E-05,-0.65661,-9.18E-06,0.097834,-0.069197,-0.35981},
      {2.38E-06,-2.66E-05,0.074507,-4.85E-05,9.36E-06,-0.72527,-2.07E-05,0.055759,-0.039459,-0.41674},
      {1.32E-06,-3.91E-05,0.044289,-6.28E-05,9.80E-06,-0.75749,-3.03E-05,0.035999,-0.025494,-0.44346},
      {8.34E-07,-5.36E-05,0.017761,-7.81E-05,1.26E-05,-0.78526,-3.88E-05,0.018963,-0.013458,-0.46648},
      {8.82E-07,-6.98E-05,-0.0036358,-9.41E-05,2.13E-05,-0.80564,-4.84E-05,0.0064401,-0.0046124,-0.4834},
      {8.07E-07,-9.50E-05,-0.011316,-9.14E-05,6.41E-05,-0.79916,-6.56E-05,0.010348,-0.0073603,-0.47809},
      {7.55E-07,-0.00011869,-0.018292,-8.24E-05,0.00011181,-0.79311,-8.20E-05,0.013998,-0.0099199,-0.47314},
      {7.20E-07,-0.00014063,-0.02449,-6.62E-05,0.00016262,-0.78758,-9.73E-05,0.01734,-0.012256,-0.46862},
      {-2.16E-06,-0.00018587,-0.050507,-5.71E-05,0.0013004,-0.75561,-0.0001272,0.03569,-0.025198,-0.44375},
      {0,0,0.7071,0,1.84E-06,1.06E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.06E-06,1.19E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.40E-06,1.39E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.87E-06,1.66E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.47E-06,2.00E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.19E-06,2.42E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.02E-06,2.90E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.95E-06,3.43E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.95E-06,4.01E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,8.00E-06,4.62E-06,0,0.49999,-0.35355,0.18463},
      {5.09E-07,0,0.70325,0,0.0038415,0.0022179,3.60E-07,0.49728,-0.35163,0.18096},
      {1.27E-06,0,0.69752,0,0.0095346,0.0055048,8.98E-07,0.49326,-0.34878,0.17551},
      {2.05E-06,0,0.69175,0,0.015281,0.0088225,1.45E-06,0.48919,-0.34591,0.17001},
      {2.82E-06,0,0.68609,0,0.020916,0.012076,1.99E-06,0.48521,-0.34309,0.16461},
      {3.55E-06,0,0.68074,0,0.026252,0.015156,2.51E-06,0.48143,-0.34042,0.1595},
      {7.10E-06,0,0.65141,0,0.022393,-0.025297,5.02E-06,0.46075,-0.3258,0.1315},
      {1.21E-05,0,0.60761,0,0.015263,-0.088115,8.58E-06,0.42984,-0.30394,0.089656},
      {1.72E-05,0,0.55744,0,0.0087729,-0.15719,1.22E-05,0.39442,-0.27889,0.041703},
      {2.19E-05,0,0.50032,0,0.0031231,-0.23286,1.55E-05,0.35408,-0.25036,-0.012924},
      {2.39E-05,-3.78E-07,0.44189,-9.15E-07,0.0014885,-0.30303,1.65E-05,0.31284,-0.2212,-0.068756},
      {2.39E-05,-1.09E-06,0.3805,-2.48E-06,0.00075388,-0.37506,1.59E-05,0.2695,-0.19056,-0.12743},
      {2.20E-05,-2.12E-06,0.31516,-4.67E-06,0.00022773,-0.45132,1.38E-05,0.22336,-0.15793,-0.1899},
      {1.57E-05,-5.94E-06,0.2458,-1.20E-05,4.27E-06,-0.53141,6.49E-06,0.17454,-0.12342,-0.25599},
      {6.69E-06,-1.53E-05,0.17725,-2.93E-05,3.18E-06,-0.60963,-6.69E-06,0.12662,-0.089552,-0.32084},
      {9.33E-07,-2.66E-05,0.1125,-4.99E-05,1.98E-06,-0.6835,-1.84E-05,0.081352,-0.05756,-0.38209},
      {1.45E-07,-3.95E-05,0.0564,-7.58E-05,2.76E-06,-0.74713,-2.78E-05,0.042341,-0.029996,-0.43485},
      {3.38E-07,-5.32E-05,0.0339,-9.57E-05,8.85E-06,-0.76995,-3.73E-05,0.028321,-0.020095,-0.45379},
      {4.90E-07,-6.78E-05,0.014102,-0.00011718,1.62E-05,-0.78948,-4.74E-05,0.01631,-0.011616,-0.46999},
      {6.00E-07,-8.35E-05,-0.0028651,-0.00014076,2.50E-05,-0.80561,-5.84E-05,0.0063791,-0.0046093,-0.48338},
      {5.88E-07,-0.00010571,-0.010004,-0.00013147,6.73E-05,-0.80161,-7.39E-05,0.0087821,-0.0062878,-0.48012},
      {5.69E-07,-0.00012664,-0.015678,-0.00011177,0.00011349,-0.79649,-8.85E-05,0.011883,-0.0084503,-0.47594},
      {5.45E-07,-0.00014531,-0.020529,-8.35E-05,0.00015884,-0.79199,-0.00010159,0.014617,-0.010346,-0.47227},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.25E-08,4.18E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.19E-07,1.84E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.52E-07,3.76E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.07E-06,6.16E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.56E-06,8.98E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.10E-06,1.22E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.69E-06,1.55E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.30E-06,1.90E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.89E-06,2.24E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.43E-06,2.56E-06,0,0.5,-0.35355,0.18463},
      {2.05E-07,0,0.70606,0,0.0010418,0.00060146,1.45E-07,0.49926,-0.35303,0.18364},
      {1.07E-06,0,0.70195,0,0.0051325,0.0029633,7.56E-07,0.49637,-0.35099,0.17972},
      {1.96E-06,0,0.69818,0,0.0088845,0.0051295,1.38E-06,0.49372,-0.34911,0.17613},
      {2.83E-06,0,0.69493,0,0.01212,0.0069978,2.00E-06,0.49143,-0.34749,0.17303},
      {3.63E-06,0,0.69239,0,0.014653,0.0084598,2.57E-06,0.48964,-0.34622,0.17061},
      {6.14E-06,0,0.66559,0,0.012869,-0.025535,4.34E-06,0.47071,-0.33284,0.14498},
      {9.71E-06,0,0.60999,0,0.00809,-0.097946,6.87E-06,0.43143,-0.30506,0.091806},
      {1.20E-05,0,0.54742,0,0.0041643,-0.17696,8.46E-06,0.38721,-0.27379,0.031933},
      {1.23E-05,0,0.47731,0,0.0012864,-0.26287,8.71E-06,0.33765,-0.23875,-0.035174},
      {9.19E-06,-8.24E-07,0.41024,-1.73E-06,0.00033932,-0.34189,5.89E-06,0.29027,-0.20525,-0.09933},
      {3.59E-06,-2.37E-06,0.34402,-4.91E-06,7.31E-05,-0.41874,8.44E-07,0.24348,-0.17217,-0.16267},
      {0,-4.51E-06,0.27543,-9.49E-06,0,-0.498,-3.19E-06,0.19502,-0.13791,-0.22828},
      {7.50E-09,-9.36E-06,0.20775,-2.00E-05,1.59E-07,-0.57586,-6.61E-06,0.14733,-0.10419,-0.29284},
      {3.89E-08,-2.19E-05,0.14974,-4.70E-05,9.79E-07,-0.64187,-1.55E-05,0.10685,-0.075593,-0.34757},
      {6.49E-08,-3.58E-05,0.094745,-7.88E-05,1.94E-06,-0.70444,-2.52E-05,0.06848,-0.048484,-0.39946},
      {8.52E-08,-5.10E-05,0.04345,-0.0001159,3.05E-06,-0.7628,-3.60E-05,0.032682,-0.0232,-0.44784},
      {2.06E-07,-6.62E-05,0.024451,-0.00014009,1.06E-05,-0.78149,-4.66E-05,0.02118,-0.015083,-0.46336},
      {2.99E-07,-8.25E-05,0.0097873,-0.00016573,1.97E-05,-0.79496,-5.81E-05,0.012877,-0.0092295,-0.47453},
      {3.55E-07,-0.00010021,-0.0022655,-0.00019434,3.00E-05,-0.80537,-7.06E-05,0.0064354,-0.0046945,-0.48318},
      {3.63E-07,-0.0001195,-0.0086641,-0.00018398,6.37E-05,-0.80414,-8.41E-05,0.0071536,-0.0051823,-0.48221},
      {3.40E-07,-0.00013745,-0.012991,-0.00015823,0.00010491,-0.80004,-9.67E-05,0.0096448,-0.006909,-0.47887},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.50E-08,4.33E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.45E-07,1.99E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.27E-07,3.62E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.05E-07,5.23E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.16E-06,6.71E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.38E-06,7.96E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.54E-06,8.88E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.62E-06,9.37E-07,0,0.5,-0.35355,0.18464},
      {5.71E-07,0,0.70533,0,0.0017645,0.0010187,4.04E-07,0.49875,-0.35267,0.18295},
      {1.09E-06,0,0.70385,0,0.0032411,0.0018712,7.69E-07,0.49771,-0.35193,0.18153},
      {1.39E-06,0,0.7031,0,0.0039816,0.0022988,9.82E-07,0.49718,-0.35156,0.18083},
      {1.38E-06,0,0.70327,0,0.0038082,0.0021987,9.77E-07,0.49731,-0.35165,0.18099},
      {1.23E-06,0,0.68379,0,0.0021807,-0.023102,8.69E-07,0.48354,-0.34191,0.16235},
      {0,0,0.6158,0,0,-0.10537,0,0.43548,-0.30793,0.097271},
      {0,0,0.54005,0,0,-0.19281,0,0.38193,-0.27006,0.024766},
      {0,0,0.45833,0,0,-0.28717,0,0.32415,-0.22921,-0.053469},
      {0,-1.33E-06,0.38299,-2.99E-06,0,-0.37411,-9.42E-07,0.2709,-0.19156,-0.12556},
      {0,-4.47E-06,0.31534,-1.02E-05,0,-0.45213,-3.16E-06,0.22311,-0.15777,-0.19025},
      {0,-8.49E-06,0.24483,-1.97E-05,0,-0.53346,-6.01E-06,0.17329,-0.12255,-0.25768},
      {1.72E-09,-1.42E-05,0.17312,-3.34E-05,6.99E-08,-0.61613,-1.00E-05,0.12264,-0.086748,-0.32623},
      {2.32E-08,-2.91E-05,0.12232,-6.94E-05,1.11E-06,-0.67389,-2.05E-05,0.087206,-0.061719,-0.37413},
      {3.97E-08,-4.52E-05,0.075293,-0.00011049,2.28E-06,-0.72737,-3.19E-05,0.054387,-0.038545,-0.41847},
      {5.10E-08,-6.26E-05,0.032729,-0.00015688,3.58E-06,-0.77578,-4.42E-05,0.024662,-0.017564,-0.45861},
      {1.07E-07,-7.94E-05,0.015111,-0.00019098,1.12E-05,-0.79333,-5.61E-05,0.013847,-0.0099428,-0.47317},
      {1.50E-07,-9.79E-05,0.0054683,-0.00023253,2.11E-05,-0.80123,-6.91E-05,0.0089264,-0.0064954,-0.47974},
      {1.62E-07,-0.0001192,-0.0021309,-0.00028995,3.15E-05,-0.807,-8.42E-05,0.0052905,-0.0039712,-0.48453},
      {1.38E-07,-0.00013955,-0.0069811,-0.000305,5.97E-05,-0.80673,-9.85E-05,0.005386,-0.0040436,-0.48436},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.67E-08,4.43E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.33E-07,7.68E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.60E-07,9.25E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.50E-07,8.68E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.74E-08,5.63E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69659,0,0,-0.012129,0,0.49257,-0.3483,0.17458},
      {0,0,0.61804,0,0,-0.10282,0,0.43704,-0.30903,0.099387},
      {0,0,0.53333,0,0,-0.20063,0,0.37714,-0.26668,0.018286},
      {0,0,0.44214,0,0,-0.30591,0,0.31267,-0.22109,-0.069014},
      {0,-1.68E-06,0.35609,-4.00E-06,0,-0.40525,-1.19E-06,0.25183,-0.17807,-0.15138},
      {0,-6.79E-06,0.28541,-1.63E-05,0,-0.48677,-4.80E-06,0.20188,-0.14277,-0.21897},
      {0,-1.32E-05,0.21073,-3.20E-05,0,-0.57292,-9.33E-06,0.14911,-0.10546,-0.2904},
      {0,-2.12E-05,0.13309,-5.15E-05,0,-0.66248,-1.50E-05,0.094226,-0.066669,-0.36466},
      {1.10E-08,-3.71E-05,0.088684,-9.41E-05,1.03E-06,-0.71308,-2.62E-05,0.063171,-0.044744,-0.40662},
      {1.84E-08,-5.38E-05,0.052619,-0.00014147,2.15E-06,-0.75411,-3.81E-05,0.037963,-0.026958,-0.44064},
      {2.12E-08,-7.09E-05,0.022641,-0.00019207,3.26E-06,-0.78825,-5.01E-05,0.016973,-0.012158,-0.46895},
      {3.59E-08,-9.05E-05,0.0083366,-0.00024863,9.79E-06,-0.80276,-6.40E-05,0.007985,-0.0058496,-0.48099},
      {3.84E-08,-0.00011423,0.0022541,-0.00032207,1.99E-05,-0.80703,-8.07E-05,0.005239,-0.0039695,-0.48455},
      {1.53E-08,-0.00014131,-0.002144,-0.00041591,3.04E-05,-0.80969,-9.99E-05,0.0034458,-0.0027818,-0.48677},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62107,0,0,-0.099341,0,0.43917,-0.31054,0.10227},
      {0,0,0.52477,0,0,-0.21053,0,0.37108,-0.26239,0.010075},
      {0,0,0.42043,0,0,-0.33101,0,0.2973,-0.21022,-0.089822},
      {0,-1.70E-06,0.3178,-4.11E-06,0,-0.44948,-1.20E-06,0.22474,-0.15892,-0.18805},
      {0,-9.84E-06,0.24386,-2.38E-05,0,-0.53477,-6.96E-06,0.17248,-0.12198,-0.25877},
      {0,-1.96E-05,0.16865,-4.73E-05,0,-0.62154,-1.39E-05,0.11931,-0.084401,-0.33071},
      {0,-3.13E-05,0.092796,-7.50E-05,0,-0.70903,-2.21E-05,0.065678,-0.046501,-0.40326},
      {3.03E-09,-4.70E-05,0.054051,-0.00011974,7.94E-07,-0.75338,-3.32E-05,0.038447,-0.027283,-0.44003},
      {3.74E-09,-6.37E-05,0.030402,-0.00017102,1.78E-06,-0.78032,-4.51E-05,0.021865,-0.0156,-0.46237},
      {1.11E-09,-8.08E-05,0.012156,-0.00022502,2.72E-06,-0.80116,-5.71E-05,0.0090149,-0.0065591,-0.47965},
      {0,-0.00010028,0.0034237,-0.00029327,7.56E-06,-0.80993,-7.09E-05,0.0035282,-0.0027379,-0.48693},
      {0,-0.00012548,0.00053065,-0.00039012,1.65E-05,-0.81091,-8.87E-05,0.0027622,-0.0022806,-0.48776},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62457,0,0,-0.095299,0,0.44164,-0.31229,0.10562},
      {0,0,0.51472,0,0,-0.22213,0,0.36397,-0.25737,0.00045337},
      {0,0,0.39633,0,0,-0.35884,0,0.28025,-0.19817,-0.1129},
      {0,-9.96E-07,0.27451,-2.36E-06,0,-0.4995,-7.04E-07,0.19412,-0.13726,-0.22952},
      {0,-1.27E-05,0.20232,-2.99E-05,0,-0.58277,-8.96E-06,0.14308,-0.10119,-0.29857},
      {0,-2.63E-05,0.13025,-6.17E-05,0,-0.66591,-1.86E-05,0.09211,-0.06518,-0.36751},
      {0,-4.18E-05,0.060061,-9.80E-05,0,-0.74688,-2.96E-05,0.042465,-0.030105,-0.43464},
      {0,-5.71E-05,0.027598,-0.00014347,5.12E-07,-0.78414,-4.04E-05,0.019572,-0.013955,-0.46554},
      {0,-7.12E-05,0.016142,-0.00019143,1.21E-06,-0.7971,-5.04E-05,0.011556,-0.0083271,-0.47628},
      {0,-8.44E-05,0.0071237,-0.00023756,1.76E-06,-0.80729,-5.97E-05,0.0052378,-0.003899,-0.48474},
      {0,-0.00010121,0.001626,-0.00030307,4.50E-06,-0.8129,-7.16E-05,0.0016945,-0.0014506,-0.48939},
      {-0.12116,0.011453,0.002562,-0.16538,0.0008476,-0.00082678,0.31132,-0.11697,0.17706,0.17908},
      {-0.14338,0.01515,0.0015536,-0.19986,0.00088878,-0.0010835,0.28755,-0.1426,0.14288,0.17954},
      {-0.15028,0.021125,0.00037088,-0.24743,0.0016127,-0.00059379,0.25185,-0.17833,0.093862,0.17962},
      {-0.12654,0.025936,-0.00051524,-0.3159,0.0038999,0.0012726,0.19992,-0.23067,0.019184,0.17835},
      {-0.10731,0.034097,-0.0018647,-0.3865,0.0082471,0.0040529,0.139,-0.28703,-0.062452,0.17505},
      {-0.062342,0.03741,-0.0027643,-0.44298,0.015278,0.0077323,0.082624,-0.33665,-0.13721,0.16824},
      {-0.022911,0.037835,-0.0035892,-0.47948,0.024737,0.013134,0.037068,-0.37645,-0.19962,0.15929},
      {0.0015852,0.038555,-0.004764,-0.49061,0.03759,0.021167,0.0024874,-0.40266,-0.24495,0.14764},
      {-0.0050808,0.060405,-0.011367,-0.40899,0.090166,0.051264,-0.032279,-0.36414,-0.22991,0.097154},
      {-0.0015523,0.075831,-0.01721,-0.30457,0.13679,0.078217,-0.048638,-0.31591,-0.1972,0.052368},
      {0.00060004,0.080107,-0.022305,-0.20032,0.18307,0.10513,-0.055628,-0.27504,-0.17352,0.0081126},
      {0.0010296,0.073897,-0.028454,-0.11512,0.22867,0.13169,-0.053424,-0.23916,-0.15866,-0.035331},
      {0.00045407,0.062709,-0.035972,-0.060962,0.28404,0.16386,-0.046129,-0.19798,-0.14343,-0.088036},
      {0.00010487,0.049342,-0.041283,-0.0020364,0.35135,0.20289,-0.036741,-0.15358,-0.12453,-0.1522},
      {0.00017111,0.047672,-0.04235,0.065386,0.41101,0.23732,-0.035063,-0.11266,-0.097304,-0.20936},
      {0.00018001,0.043308,-0.041658,0.0896,0.44835,0.25885,-0.031593,-0.091501,-0.083749,-0.2451},
      {0.00015132,0.036665,-0.041103,0.077915,0.47804,0.27591,-0.026666,-0.076349,-0.076048,-0.27349},
      {0.00011464,0.028879,-0.0405,0.060371,0.51708,0.29838,-0.020978,-0.055455,-0.06477,-0.31081},
      {6.74E-05,0.019702,-0.039822,0.037989,0.56386,0.32538,-0.014355,-0.030167,-0.050963,-0.35551},
      {5.20E-05,0.01611,-0.048204,0.024779,0.58122,0.33539,-0.011735,-0.0087351,-0.046065,-0.37209},
      {3.58E-05,0.01295,-0.060092,0.020051,0.581,0.33523,-0.0094413,0.0055993,-0.049459,-0.37187},
      {2.45E-05,0.010466,-0.072516,0.01429,0.58146,0.33545,-0.007658,0.021694,-0.051777,-0.37231},
      {1.62E-05,0.0081202,-0.082876,0.0060709,0.58581,0.33795,-0.005966,0.037704,-0.052022,-0.37647},
      {1.18E-05,0.0056831,-0.090963,-0.0030459,0.59207,0.34158,-0.0041926,0.051759,-0.051428,-0.38245},
      {4.80E-05,0.0038061,-0.1027,-0.0030545,0.58311,0.33643,-0.0027981,0.060653,-0.057824,-0.37385},
      {0.00013877,0.00236,-0.1119,-0.0030153,0.57713,0.333,-0.0016826,0.068421,-0.062229,-0.36809},
      {0.00028445,0.0011625,-0.11826,-0.003176,0.57486,0.33173,-0.0007066,0.075008,-0.064474,-0.36588},
      {0.00047985,0.00070437,-0.12693,-0.0033851,0.57099,0.32955,-0.00022253,0.084285,-0.066728,-0.36214},
      {0.00074758,0.00023824,-0.13394,-0.0038406,0.56765,0.32766,0.0003214,0.09164,-0.068652,-0.35891},
      {0.00099328,-5.83E-06,-0.14143,-0.0030007,0.56112,0.32392,0.00068739,0.097571,-0.071958,-0.35263},
      {0.00096281,-4.22E-06,-0.15093,-0.0021378,0.55268,0.31906,0.00067114,0.10499,-0.076225,-0.34453},
      {0.00085515,-2.63E-06,-0.15689,-0.0014157,0.5477,0.3162,0.00059919,0.1098,-0.07883,-0.33976},
      {-0.03899,0.014644,0.0035468,-0.15077,0.0011914,-0.0002944,0.30383,-0.10601,0.18903,0.17799},
      {-0.056097,0.020468,0.0024486,-0.17747,0.0016109,-0.00019795,0.28175,-0.12625,0.16206,0.1781},
      {-0.073866,0.030081,0.00076266,-0.21293,0.0024611,0.00015453,0.24918,-0.15345,0.12584,0.17798},
      {-0.059395,0.036375,-0.00031981,-0.2737,0.0050714,0.0019968,0.1995,-0.20076,0.058345,0.17629},
      {-0.043122,0.044828,-0.0016267,-0.33863,0.0094942,0.0047612,0.14098,-0.25344,-0.018086,0.17285},
      {-0.028616,0.056453,-0.0032255,-0.39763,0.015682,0.0083323,0.078929,-0.30462,-0.093416,0.16765},
      {0.011901,0.058197,-0.0039148,-0.43043,0.024108,0.013249,0.034565,-0.34118,-0.15046,0.15972},
      {0.020387,0.071136,-0.0073843,-0.40786,0.051026,0.028779,-0.0042701,-0.3395,-0.16833,0.13398},
      {0.012042,0.087693,-0.01339,-0.33559,0.097522,0.055402,-0.039275,-0.31293,-0.16597,0.089329},
      {0.00019968,0.10111,-0.020285,-0.24234,0.15469,0.088332,-0.066243,-0.27898,-0.16001,0.034749},
      {0.0016813,0.10367,-0.025037,-0.14724,0.19811,0.11365,-0.072692,-0.24321,-0.14124,-0.0067218},
      {0.0014665,0.094918,-0.032528,-0.089095,0.23899,0.13749,-0.068178,-0.21066,-0.13129,-0.045575},
      {0.00081212,0.082287,-0.039797,-0.040912,0.29144,0.16799,-0.059925,-0.17307,-0.11914,-0.095454},
      {0.00035602,0.066065,-0.045135,0.012351,0.35795,0.20661,-0.048594,-0.13143,-0.10374,-0.15878},
      {0.00021909,0.055335,-0.046919,0.073378,0.4239,0.24479,-0.040495,-0.091988,-0.083092,-0.22175},
      {0.00020996,0.04966,-0.04614,0.081896,0.45002,0.25981,-0.03615,-0.079323,-0.076362,-0.24675},
      {0.00018163,0.042601,-0.04556,0.071349,0.4787,0.27628,-0.030921,-0.06523,-0.0696,-0.27417},
      {0.00014533,0.03447,-0.044927,0.054779,0.51688,0.29826,-0.024981,-0.045239,-0.059113,-0.31066},
      {9.68E-05,0.024742,-0.043986,0.033123,0.5635,0.32515,-0.017961,-0.020843,-0.04596,-0.3552},
      {5.66E-05,0.017394,-0.050289,0.022526,0.58139,0.33548,-0.012657,-0.0047195,-0.044658,-0.37226},
      {4.06E-05,0.014103,-0.062993,0.018312,0.5801,0.33469,-0.010281,0.0099292,-0.048704,-0.37102},
      {2.91E-05,0.011417,-0.075973,0.012716,0.5799,0.33453,-0.0083556,0.026203,-0.051551,-0.37084},
      {2.06E-05,0.0088997,-0.086843,0.0046695,0.58363,0.33667,-0.0065435,0.04238,-0.052274,-0.37441},
      {1.70E-05,0.0062719,-0.096202,-0.0029512,0.58695,0.3386,-0.0046327,0.056017,-0.053344,-0.37757},
      {4.24E-05,0.0039256,-0.10728,-0.0031875,0.57929,0.33421,-0.0028947,0.064527,-0.059606,-0.37019},
      {0.00012965,0.0024253,-0.11706,-0.0031401,0.57268,0.33043,-0.0017425,0.072625,-0.064384,-0.36383},
      {0.00027151,0.0012889,-0.12495,-0.0031518,0.56875,0.3282,-0.00081263,0.080244,-0.067402,-0.36004},
      {0.00046396,0.00081877,-0.13433,-0.0034526,0.56412,0.32558,-0.00032135,0.089985,-0.07005,-0.35557},
      {0.00073116,0.00032267,-0.1426,-0.0037066,0.55906,0.3227,0.00024426,0.097869,-0.072868,-0.35069},
      {0.0010613,-6.15E-06,-0.1481,-0.0029435,0.55443,0.32006,0.00073492,0.10233,-0.075234,-0.34622},
      {0.001033,-4.47E-06,-0.15789,-0.0020984,0.54568,0.31502,0.0007204,0.10994,-0.079653,-0.33783},
      {0.00092728,-2.81E-06,-0.16411,-0.0013917,0.54043,0.312,0.00064992,0.11492,-0.082392,-0.3328},
      {0.093354,0.017982,0.0060131,-0.11372,0.0013638,0.00053366,0.29955,-0.077898,0.22167,0.17643},
      {0.081678,0.024494,0.004879,-0.13681,0.0019502,0.00080323,0.27758,-0.095699,0.19804,0.17632},
      {0.070033,0.034804,0.0031803,-0.16799,0.0029457,0.0013209,0.2452,-0.12,0.16583,0.176},
      {0.063772,0.049506,0.00091252,-0.20413,0.0044416,0.0021724,0.20277,-0.14869,0.12793,0.17531},
      {0.076441,0.059102,-0.00040779,-0.2593,0.0085035,0.0046741,0.14809,-0.19432,0.062008,0.17213},
      {0.090685,0.070625,-0.0017648,-0.31188,0.013931,0.0078967,0.08949,-0.24053,-0.0057544,0.16762},
      {0.070757,0.094054,-0.0051458,-0.33001,0.028349,0.015893,0.030582,-0.26335,-0.0483,0.1543},
      {0.049575,0.11564,-0.0099219,-0.30665,0.055658,0.03123,-0.02085,-0.26444,-0.070926,0.12814},
      {0.038547,0.12626,-0.015044,-0.25113,0.096788,0.054875,-0.055255,-0.25031,-0.081629,0.088731},
      {0.02464,0.1347,-0.021114,-0.17423,0.14904,0.085077,-0.081701,-0.22736,-0.087037,0.038955},
      {0.0072625,0.13754,-0.02972,-0.095094,0.20769,0.11899,-0.095991,-0.19909,-0.09285,-0.016622},
      {0.0020182,0.12707,-0.039119,-0.056018,0.24919,0.14315,-0.090924,-0.1706,-0.092354,-0.055878},
      {0.0012656,0.11254,-0.046028,-0.015606,0.29825,0.17172,-0.081411,-0.13738,-0.084018,-0.10247},
      {0.00071562,0.095286,-0.050908,0.031701,0.36059,0.20795,-0.069395,-0.10022,-0.071971,-0.16179},
      {0.00038272,0.07561,-0.053017,0.075027,0.4227,0.244,-0.054999,-0.069471,-0.062687,-0.22089},
      {0.00025786,0.05933,-0.053164,0.071426,0.4508,0.26026,-0.04308,-0.061755,-0.066009,-0.24757},
      {0.00023033,0.051728,-0.052553,0.062278,0.47834,0.27606,-0.037455,-0.048908,-0.060384,-0.27389},
      {0.00019474,0.043131,-0.051881,0.046939,0.51552,0.29744,-0.031176,-0.030025,-0.050885,-0.30942},
      {0.00014689,0.033009,-0.050895,0.026363,0.56126,0.32383,-0.023867,-0.0066031,-0.038584,-0.35311},
      {6.91E-05,0.020096,-0.054553,0.019555,0.57943,0.33433,-0.014593,0.0019145,-0.042856,-0.37042},
      {4.79E-05,0.015751,-0.067989,0.015743,0.57813,0.33353,-0.011485,0.016855,-0.04795,-0.36917},
      {3.62E-05,0.012784,-0.081825,0.010418,0.57692,0.33278,-0.0093634,0.033426,-0.051583,-0.36802},
      {2.76E-05,0.010027,-0.093479,0.0026471,0.57971,0.33436,-0.0073832,0.049874,-0.053017,-0.37069},
      {2.47E-05,0.0071287,-0.10496,-0.0028095,0.5784,0.33362,-0.0052764,0.063047,-0.056678,-0.36941},
      {3.50E-05,0.0041941,-0.11534,-0.003326,0.5722,0.3301,-0.0031084,0.071127,-0.062853,-0.36342},
      {0.00011277,0.0024924,-0.12545,-0.003328,0.56536,0.32619,-0.0018129,0.079381,-0.06797,-0.35684},
      {0.00024926,0.0014783,-0.13583,-0.0031327,0.55874,0.32241,-0.00097389,0.088694,-0.072218,-0.35046},
      {0.00043744,0.00098875,-0.14629,-0.0035568,0.55297,0.31913,-0.00047061,0.09913,-0.075466,-0.3449},
      {0.00070306,0.00043993,-0.1564,-0.0035087,0.54537,0.31478,0.0001326,0.10779,-0.07961,-0.33758},
      {0.0010285,7.91E-05,-0.16239,-0.0027909,0.54024,0.31186,0.00064409,0.11256,-0.08226,-0.33265},
      {0.0011439,-4.83E-06,-0.16889,-0.0020402,0.53462,0.30864,0.00079824,0.11775,-0.085068,-0.32725},
      {0.0010408,-3.05E-06,-0.17548,-0.0013565,0.52898,0.30539,0.0007298,0.12299,-0.088003,-0.32184},
      {0.2652,0.015806,0.016531,-0.070625,0.00077594,0.0011827,0.28907,-0.039892,0.2525,0.17492},
      {0.27311,0.019224,0.011798,-0.07533,0.00075003,0.0014317,0.27823,-0.046566,0.25254,0.17492},
      {0.27108,0.028639,0.0092771,-0.098225,0.0015759,0.002002,0.24932,-0.065491,0.22985,0.17455},
      {0.2669,0.043093,0.0071373,-0.13106,0.0029895,0.0028593,0.20742,-0.091865,0.19522,0.17386},
      {0.23832,0.061825,0.0041702,-0.16021,0.0053235,0.0040265,0.16254,-0.11629,0.16351,0.17244},
      {0.20391,0.081247,0.0005487,-0.18367,0.010184,0.0066446,0.1111,-0.1388,0.13211,0.16817},
      {0.16378,0.10053,-0.0031415,-0.20171,0.02572,0.015289,0.050117,-0.16463,0.084322,0.15349},
      {0.12017,0.13172,-0.0084016,-0.19936,0.04865,0.027957,-0.016757,-0.18069,0.045044,0.132},
      {0.074272,0.17504,-0.015117,-0.17567,0.078881,0.04458,-0.086874,-0.18687,0.014928,0.10396},
      {0.054033,0.17852,-0.021529,-0.11777,0.12764,0.072782,-0.11129,-0.17367,-0.0030546,0.057659},
      {0.026945,0.17688,-0.032767,-0.074128,0.18094,0.1034,-0.12217,-0.1542,-0.023889,0.0072543},
      {0.0085814,0.16945,-0.04536,-0.029547,0.24111,0.13825,-0.12171,-0.12555,-0.037537,-0.049313},
      {0.0017147,0.1548,-0.055331,0.0093085,0.29955,0.17224,-0.11174,-0.092397,-0.039227,-0.10438},
      {0.0010338,0.13843,-0.058777,0.051996,0.35339,0.20354,-0.10033,-0.062805,-0.030923,-0.15558},
      {0.0006682,0.11237,-0.061412,0.065373,0.39394,0.22705,-0.081374,-0.050539,-0.038756,-0.19399},
      {0.00041694,0.08344,-0.062672,0.060991,0.43584,0.25141,-0.060348,-0.041025,-0.048495,-0.23361},
      {0.00030187,0.064367,-0.062478,0.05158,0.47542,0.27433,-0.046487,-0.027687,-0.048855,-0.27119},
      {0.00026743,0.055239,-0.061758,0.037484,0.51175,0.29522,-0.03982,-0.0098584,-0.040332,-0.30591},
      {0.00020843,0.043594,-0.062589,0.023196,0.54623,0.31506,-0.031414,0.0070751,-0.035221,-0.33883},
      {0.00012567,0.029651,-0.068122,0.018003,0.56123,0.32369,-0.021426,0.015317,-0.042074,-0.35314},
      {5.78E-05,0.01779,-0.07598,0.012448,0.57423,0.33122,-0.012984,0.026966,-0.047731,-0.36548},
      {4.60E-05,0.014491,-0.090994,0.0075214,0.57162,0.32966,-0.010631,0.043981,-0.052392,-0.36299},
      {3.71E-05,0.011447,-0.10371,0.00014383,0.57312,0.3305,-0.0084501,0.060822,-0.054756,-0.36443},
      {3.46E-05,0.0082148,-0.11845,-0.0026205,0.56524,0.32596,-0.0060993,0.073697,-0.062044,-0.35686},
      {4.40E-05,0.0051199,-0.13026,-0.0031481,0.55765,0.32163,-0.0038164,0.082709,-0.069081,-0.34954},
      {8.38E-05,0.0025188,-0.13793,-0.0035725,0.55434,0.31981,-0.0018669,0.089267,-0.073453,-0.34631},
      {0.00021399,0.0017281,-0.15202,-0.0031316,0.54371,0.31372,-0.0011916,0.10113,-0.079489,-0.33609},
      {0.00039673,0.0012101,-0.16392,-0.0036924,0.5364,0.30956,-0.00067008,0.11249,-0.083546,-0.32904},
      {0.00065874,0.00057732,-0.17639,-0.0032517,0.52555,0.30333,-7.91E-06,0.12213,-0.089403,-0.31862},
      {0.0009738,0.00018141,-0.18307,-0.0025901,0.51973,0.30001,0.00052289,0.12734,-0.092448,-0.31302},
      {0.0013023,-5.31E-06,-0.18461,-0.0019647,0.51882,0.29951,0.00090957,0.12892,-0.092809,-0.31212},
      {0.0012021,-3.37E-06,-0.19169,-0.0013117,0.51267,0.29597,0.00084349,0.13449,-0.095998,-0.30622},
      {0.37635,0.0070628,0.047802,-0.040986,-0.0003003,0.0013,0.26507,0.0027504,0.24916,0.17402},
      {0.37095,0.008563,0.042411,-0.044849,-0.00045021,0.0015728,0.25409,-0.0038366,0.25058,0.1739},
      {0.36456,0.010639,0.033914,-0.049824,-0.00065992,0.0019837,0.23795,-0.013451,0.25384,0.17366},
      {0.35881,0.013093,0.021803,-0.055052,-0.00092346,0.0025416,0.21688,-0.025869,0.26018,0.17323},
      {0.33143,0.025858,0.014471,-0.07399,0.00089711,0.0038081,0.1763,-0.046012,0.24323,0.17143},
      {0.29392,0.047583,0.0099046,-0.095628,0.0046876,0.0058159,0.12332,-0.06726,0.21653,0.1682},
      {0.25954,0.074364,0.004227,-0.10975,0.0096997,0.0084203,0.066092,-0.084681,0.19577,0.16387},
      {0.21592,0.10722,-0.0018186,-0.11172,0.027226,0.018033,0.000552,-0.10167,0.16308,0.14781},
      {0.14938,0.15487,-0.010254,-0.10313,0.057739,0.0343,-0.073244,-0.11583,0.11906,0.11963},
      {0.08064,0.21109,-0.022323,-0.087906,0.093382,0.053182,-0.14052,-0.12066,0.080081,0.087086},
      {0.039427,0.23457,-0.034604,-0.055452,0.1415,0.080272,-0.17004,-0.1093,0.053002,0.042444},
      {0.019752,0.22526,-0.046581,-0.01506,0.20273,0.11579,-0.168,-0.084667,0.034494,-0.014999},
      {0.0070878,0.21269,-0.05879,0.028009,0.26704,0.15315,-0.15796,-0.054234,0.022378,-0.075262},
      {0.0013294,0.19012,-0.070762,0.053434,0.31931,0.18339,-0.13747,-0.031754,0.0056011,-0.12383},
      {0.00097586,0.15931,-0.074013,0.056545,0.3528,0.20271,-0.11498,-0.026939,-0.010614,-0.15545},
      {0.00070583,0.12866,-0.075393,0.052481,0.396,0.22777,-0.092682,-0.017662,-0.021572,-0.1963},
      {0.00049507,0.096523,-0.075548,0.04213,0.44996,0.25921,-0.069436,-0.003459,-0.028407,-0.24735},
      {0.00036922,0.071206,-0.074982,0.027266,0.50414,0.29072,-0.051195,0.015132,-0.027773,-0.29875},
      {0.00028197,0.056274,-0.079207,0.020745,0.5234,0.30171,-0.040447,0.023783,-0.033584,-0.31716},
      {0.00019604,0.040962,-0.088869,0.016797,0.53431,0.30788,-0.029546,0.034116,-0.043743,-0.32762},
      {0.00011996,0.02744,-0.0977,0.011101,0.54772,0.31561,-0.019928,0.046247,-0.050872,-0.34037},
      {5.85E-05,0.016413,-0.10475,0.0043036,0.56268,0.32441,-0.012076,0.058648,-0.05476,-0.3545},
      {4.93E-05,0.013021,-0.1196,-0.0018418,0.56071,0.32325,-0.0096484,0.075806,-0.059205,-0.35262},
      {4.59E-05,0.0094569,-0.1382,-0.0023835,0.54595,0.31474,-0.0070527,0.089043,-0.070273,-0.33847},
      {5.38E-05,0.006183,-0.15171,-0.0029172,0.5367,0.30945,-0.0046412,0.099144,-0.078325,-0.32956},
      {7.71E-05,0.0032527,-0.16035,-0.0033916,0.53275,0.30727,-0.0024527,0.10633,-0.083399,-0.3257},
      {0.00016076,0.0020275,-0.1749,-0.0031473,0.52222,0.3013,-0.0014617,0.11851,-0.089952,-0.31552},
      {0.00034048,0.0014207,-0.1896,-0.0035463,0.51143,0.29513,-0.00087655,0.13129,-0.095846,-0.30514},
      {0.00059229,0.00071502,-0.20371,-0.0029469,0.49848,0.28768,-0.00016717,0.1417,-0.10284,-0.29271},
      {0.00089518,0.0002837,-0.21109,-0.0023517,0.49194,0.28394,0.00038268,0.14736,-0.1063,-0.28643},
      {0.0012447,5.80E-05,-0.21243,-0.0017949,0.49118,0.28354,0.00081533,0.14874,-0.10661,-0.28567},
      {0.001418,-3.71E-06,-0.21343,-0.0012598,0.49077,0.28333,0.00099578,0.14991,-0.10673,-0.28526},
      {0.35551,-0.015269,0.11099,-0.023511,-0.0026984,0.0010773,0.21582,0.060175,0.20171,0.173},
      {0.36,-0.017279,0.095834,-0.024118,-0.0031797,0.0015673,0.20758,0.048546,0.21701,0.17287},
      {0.35993,-0.016547,0.081549,-0.027001,-0.0034664,0.0020808,0.19331,0.036105,0.22832,0.17255},
      {0.35731,-0.013882,0.066711,-0.031013,-0.0036444,0.0026784,0.17328,0.022549,0.23834,0.172},
      {0.35603,-0.01107,0.047492,-0.034519,-0.0039126,0.003462,0.14826,0.006149,0.25282,0.17118},
      {0.35556,-0.0076027,0.02429,-0.037182,-0.0041281,0.0045057,0.11751,-0.012701,0.27123,0.16991},
      {0.30519,0.028191,0.018225,-0.052439,0.0018681,0.0068373,0.055241,-0.031023,0.24727,0.16468},
      {0.2482,0.075,0.009332,-0.063891,0.0097881,0.0098529,-0.014244,-0.0481,0.22523,0.15775},
      {0.18824,0.13146,-0.0027436,-0.068166,0.022807,0.015653,-0.087113,-0.062944,0.20366,0.1463},
      {0.12148,0.18889,-0.014948,-0.0544,0.059493,0.035209,-0.14952,-0.069443,0.16276,0.11333},
      {0.064947,0.24957,-0.029533,-0.030923,0.099764,0.057095,-0.20174,-0.065309,0.1318,0.077267},
      {0.022948,0.30238,-0.044847,0.0046252,0.14494,0.082098,-0.23678,-0.0511,0.11052,0.036592},
      {0.012005,0.27971,-0.058286,0.031688,0.20036,0.1136,-0.21589,-0.032804,0.083275,-0.015243},
      {0.0057031,0.24897,-0.073694,0.043577,0.24812,0.14075,-0.18652,-0.018421,0.050876,-0.059161},
      {0.0016336,0.21774,-0.089446,0.049322,0.29521,0.16842,-0.1574,-0.0010515,0.022813,-0.10172},
      {0.0010196,0.18571,-0.092288,0.045203,0.34104,0.19509,-0.13334,0.0095145,0.009747,-0.14476},
      {0.00080052,0.15207,-0.092185,0.034667,0.39658,0.22739,-0.10898,0.023318,0.0020806,-0.19731},
      {0.00058244,0.11167,-0.094799,0.024303,0.45194,0.25964,-0.07997,0.036223,-0.012171,-0.24972},
      {0.00036846,0.069947,-0.10577,0.019742,0.48853,0.28122,-0.050258,0.046997,-0.036744,-0.28412},
      {0.00027802,0.053352,-0.1186,0.015892,0.49719,0.28599,-0.038471,0.059377,-0.049258,-0.29249},
      {0.00019708,0.038751,-0.12923,0.009931,0.50984,0.29322,-0.028089,0.07278,-0.057836,-0.30457},
      {0.00012483,0.025808,-0.13652,0.0027,0.5267,0.3031,-0.018875,0.085472,-0.062728,-0.32051},
      {6.27E-05,0.014518,-0.14555,-0.001555,0.53539,0.30851,-0.010809,0.095872,-0.070137,-0.32848},
      {5.69E-05,0.010755,-0.16618,-0.0020937,0.51863,0.29883,-0.0080697,0.11041,-0.082417,-0.31241},
      {6.24E-05,0.0072995,-0.18152,-0.0026243,0.50755,0.29249,-0.0055269,0.12168,-0.091571,-0.30176},
      {8.44E-05,0.0047133,-0.19618,-0.0027323,0.49722,0.28664,-0.0035888,0.1331,-0.099492,-0.29177},
      {0.00012672,0.0028375,-0.20943,-0.0029723,0.48864,0.28185,-0.0021243,0.14425,-0.10584,-0.28342},
      {0.00025919,0.0015677,-0.22481,-0.0031283,0.47658,0.27499,-0.0010588,0.15652,-0.11317,-0.27179},
      {0.00049658,0.0008285,-0.23962,-0.0026105,0.4629,0.26712,-0.00033229,0.16737,-0.12058,-0.25866},
      {0.00078636,0.00036774,-0.2476,-0.0020881,0.45573,0.26302,0.00023259,0.1734,-0.12439,-0.25178},
      {0.001124,0.00011691,-0.24945,-0.0015955,0.45444,0.2623,0.00067795,0.17509,-0.12501,-0.25051},
      {0.0015053,1.10E-05,-0.24582,-0.0011655,0.45839,0.26462,0.0010439,0.1729,-0.12281,-0.25427},
      {0.2856,-0.025542,0.23526,-0.01429,-0.0034527,0.00021489,0.15336,0.15555,0.086889,0.17378},
      {0.28999,-0.027481,0.21733,-0.014822,-0.0039665,0.00056168,0.1447,0.14207,0.10455,0.17337},
      {0.29696,-0.030397,0.18902,-0.015591,-0.0047555,0.0010212,0.1317,0.12091,0.13226,0.17266},
      {0.3069,-0.034299,0.14872,-0.016557,-0.0058402,0.0015208,0.1143,0.090984,0.17143,0.17153},
      {0.30392,-0.030803,0.11963,-0.019088,-0.0062992,0.0019432,0.088878,0.068129,0.19617,0.17011},
      {0.2941,-0.022312,0.092392,-0.022092,-0.0064158,0.0024121,0.056251,0.046317,0.21724,0.16833},
      {0.28367,-0.011436,0.057199,-0.024642,-0.006493,0.0029799,0.017596,0.019112,0.24559,0.16609},
      {0.24862,0.024621,0.032626,-0.030314,-0.0012577,0.0053506,-0.038517,-0.00397,0.2498,0.16072},
      {0.19469,0.085483,0.018309,-0.034604,0.0089624,0.0098783,-0.10662,-0.01955,0.23434,0.15183},
      {0.1427,0.15471,0.00033933,-0.031574,0.019924,0.015571,-0.17438,-0.033304,0.22401,0.14098},
      {0.09161,0.2209,-0.015898,-0.010114,0.053107,0.033577,-0.22506,-0.033597,0.19989,0.11128},
      {0.049817,0.28137,-0.03591,0.0082957,0.089033,0.04927,-0.25079,-0.028085,0.16457,0.079296},
      {0.01858,0.33563,-0.057548,0.024532,0.1204,0.064377,-0.26781,-0.019634,0.13476,0.054641},
      {0.0086097,0.32164,-0.073838,0.035718,0.16675,0.09056,-0.24618,-0.0061003,0.10391,0.0135},
      {0.0044766,0.28962,-0.089032,0.04058,0.21759,0.12038,-0.21561,0.011307,0.075357,-0.032417},
      {0.0019565,0.25663,-0.10532,0.038542,0.26873,0.15119,-0.18571,0.033233,0.051144,-0.078159},
      {0.0011292,0.21826,-0.11455,0.030779,0.32017,0.18155,-0.15594,0.049873,0.031909,-0.1258},
      {0.00085695,0.16838,-0.12393,0.027057,0.36479,0.20714,-0.12025,0.05831,0.0029755,-0.1683},
      {0.00059685,0.11711,-0.13977,0.02257,0.40633,0.23161,-0.083798,0.072587,-0.028801,-0.20737},
      {0.00037337,0.067282,-0.15985,0.015223,0.44671,0.25603,-0.048529,0.092885,-0.059671,-0.24485},
      {0.00028404,0.050679,-0.17262,0.008544,0.4599,0.26354,-0.036733,0.10826,-0.069998,-0.25746},
      {0.00020658,0.03671,-0.18247,0.0015483,0.47428,0.27191,-0.026787,0.12211,-0.07715,-0.27109},
      {0.00013174,0.02351,-0.19537,-0.00018666,0.47631,0.27346,-0.017341,0.13188,-0.089852,-0.2727},
      {6.64E-05,0.012193,-0.20504,-0.0017121,0.48032,0.27652,-0.0092146,0.13959,-0.099836,-0.27591},
      {6.74E-05,0.0085528,-0.22346,-0.0021164,0.46628,0.2685,-0.0065428,0.15295,-0.11068,-0.26238},
      {8.69E-05,0.0062132,-0.24341,-0.0021225,0.45033,0.25944,-0.0047844,0.16804,-0.12117,-0.24699},
      {0.00012572,0.0041653,-0.25816,-0.0026379,0.44027,0.25379,-0.0031911,0.18012,-0.12846,-0.23722},
      {0.00019309,0.0020185,-0.27224,-0.0026111,0.42916,0.24752,-0.0014875,0.19046,-0.13636,-0.22647},
      {0.00036354,0.00089221,-0.28547,-0.0022616,0.41748,0.24088,-0.0004898,0.20008,-0.14332,-0.2152},
      {0.00064021,0.00041496,-0.29381,-0.0018135,0.40991,0.23654,8.19E-05,0.20631,-0.14737,-0.20793},
      {0.00096582,0.00014965,-0.29596,-0.0013875,0.40828,0.23562,0.00053325,0.20817,-0.14819,-0.20634},
      {0.0013302,3.54E-05,-0.29285,-0.0010173,0.41168,0.23762,0.00089717,0.2063,-0.14629,-0.20957},
      {0.15364,-0.024368,0.43951,-0.0057841,-0.0031425,-0.0012724,0.079278,0.30633,-0.10377,0.17629},
      {0.16048,-0.026226,0.41623,-0.0063309,-0.0036683,-0.0010943,0.072082,0.28915,-0.081437,0.1756},
      {0.17085,-0.029037,0.38047,-0.0071151,-0.0044705,-0.00086724,0.061094,0.26283,-0.047206,0.17451},
      {0.18484,-0.032826,0.33131,-0.0080866,-0.0055634,-0.00064116,0.046075,0.22677,-0.00025548,0.17294},
      {0.20232,-0.037581,0.26827,-0.0091579,-0.0069504,-0.00048577,0.026871,0.18072,0.059799,0.1708},
      {0.22053,-0.041521,0.19691,-0.010553,-0.0088837,1.56E-05,0.0055431,0.12858,0.12633,0.16753},
      {0.21635,-0.030674,0.15366,-0.012531,-0.0097172,0.0013226,-0.026868,0.095994,0.162,0.16422},
      {0.21194,-0.018239,0.10251,-0.013558,-0.010921,0.0030038,-0.06466,0.05828,0.20512,0.16015},
      {0.19883,0.0065158,0.051826,-0.013266,-0.010083,0.0051586,-0.11074,0.021242,0.24327,0.15406},
      {0.1485,0.087421,0.033699,-0.011222,0.0018253,0.0051133,-0.1691,0.0089918,0.22706,0.14133},
      {0.10317,0.17633,0.0063665,-0.0068907,0.013935,0.0053414,-0.22624,-0.0051157,0.21829,0.13023},
      {0.064854,0.25846,-0.023463,0.0033873,0.034717,0.011834,-0.26831,-0.012835,0.2051,0.1137},
      {0.036061,0.31483,-0.044716,0.018668,0.067131,0.027899,-0.28297,-0.0050304,0.17639,0.089677},
      {0.015346,0.36554,-0.066966,0.030862,0.094948,0.043501,-0.29269,0.0059202,0.1542,0.071922},
      {0.0055871,0.37658,-0.086224,0.036841,0.13212,0.066103,-0.2824,0.021574,0.13283,0.043352},
      {0.0033936,0.33718,-0.10365,0.034563,0.18275,0.09523,-0.24763,0.041035,0.10271,-0.0029163},
      {0.0020224,0.28462,-0.1312,0.034509,0.22324,0.11928,-0.20545,0.061514,0.058909,-0.039311},
      {0.0011124,0.22934,-0.16252,0.033222,0.25992,0.14318,-0.16345,0.084963,0.013896,-0.070885},
      {0.00083889,0.17571,-0.1796,0.026315,0.30495,0.16953,-0.1253,0.10177,-0.018537,-0.11336},
      {0.00060199,0.12354,-0.20075,0.017093,0.34844,0.19562,-0.088339,0.12412,-0.05024,-0.15391},
      {0.00040381,0.072574,-0.22636,0.0069152,0.38922,0.22082,-0.0524,0.15151,-0.082044,-0.19137},
      {0.0002902,0.046998,-0.24678,0.0032824,0.39879,0.22694,-0.034287,0.1683,-0.10346,-0.19997},
      {0.00020683,0.032854,-0.25972,0.0013417,0.4018,0.22902,-0.024158,0.17812,-0.11664,-0.20255},
      {0.00013368,0.020626,-0.26947,-0.00036606,0.40669,0.23254,-0.015373,0.18592,-0.12712,-0.20663},
      {7.52E-05,0.011164,-0.28416,-0.0011974,0.40451,0.23246,-0.0085731,0.19743,-0.13849,-0.20356},
      {7.97E-05,0.0076371,-0.30388,-0.0015877,0.39024,0.22458,-0.005961,0.21235,-0.14948,-0.1896},
      {0.00011495,0.0051448,-0.31991,-0.0020239,0.37825,0.21778,-0.0040344,0.22456,-0.1582,-0.178},
      {0.00017463,0.0028084,-0.33236,-0.0019903,0.36852,0.21228,-0.0021829,0.23342,-0.16562,-0.16859},
      {0.00025661,0.0011803,-0.34266,-0.0018421,0.36037,0.20776,-0.00082725,0.24085,-0.17154,-0.16064},
      {0.00044918,0.00041024,-0.35094,-0.0015421,0.35327,0.2038,-6.21E-05,0.24695,-0.17585,-0.15373},
      {0.00076348,0.00014696,-0.35306,-0.0011808,0.3516,0.20286,0.00038495,0.24874,-0.17671,-0.15211},
      {0.0010933,6.22E-05,-0.35028,-0.00086566,0.35463,0.20464,0.00070885,0.24705,-0.17501,-0.15498},
      {0.061249,-0.012926,0.58022,-0.0023867,-0.0024163,-0.0013939,0.021806,0.40866,-0.2364,0.17908},
      {0.066111,-0.015538,0.56975,-0.0024463,-0.0027508,-0.001537,0.021739,0.40099,-0.22646,0.17844},
      {0.072921,-0.019324,0.5548,-0.0025277,-0.0032523,-0.0017743,0.021368,0.39003,-0.21231,0.17748},
      {0.08535,-0.024173,0.51879,-0.002964,-0.0043441,-0.0018039,0.01503,0.36381,-0.17835,0.17565},
      {0.10519,-0.030492,0.45209,-0.003802,-0.0063475,-0.0014271,-0.00077879,0.31544,-0.11547,0.17256},
      {0.12582,-0.03797,0.37749,-0.0045521,-0.0087261,-0.0018733,-0.018452,0.26143,-0.045724,0.16813},
      {0.14471,-0.046126,0.30031,-0.0050342,-0.011466,-0.0035041,-0.038782,0.20569,0.025583,0.16213},
      {0.14562,-0.033645,0.24116,-0.0053672,-0.012788,-0.005594,-0.069918,0.16298,0.075101,0.1553},
      {0.14086,-0.0094992,0.1779,-0.0049648,-0.01375,-0.0089127,-0.10937,0.11813,0.12566,0.14679},
      {0.13556,0.02089,0.10293,-0.0034958,-0.014869,-0.014031,-0.15511,0.065977,0.1855,0.1362},
      {0.10199,0.10635,0.063211,0.0010836,-0.0042435,-0.014137,-0.20688,0.043859,0.19228,0.12714},
      {0.06815,0.20756,0.021677,0.0079692,0.0080532,-0.01284,-0.25926,0.025213,0.19756,0.12025},
      {0.039819,0.31382,-0.028307,0.017108,0.02066,-0.010285,-0.30991,0.0054842,0.21087,0.1148},
      {0.021911,0.36538,-0.050266,0.028154,0.048839,0.0060962,-0.3172,0.016071,0.19023,0.098198},
      {0.011273,0.3972,-0.074386,0.033433,0.068434,0.012647,-0.31346,0.026614,0.16848,0.084144},
      {0.0044383,0.41151,-0.10248,0.039181,0.085285,0.025205,-0.30346,0.039296,0.14233,0.077366},
      {0.0030711,0.35535,-0.1325,0.038048,0.12881,0.051362,-0.25846,0.062169,0.095805,0.038543},
      {0.0019634,0.29814,-0.17218,0.034626,0.16542,0.076547,-0.21414,0.093345,0.046204,0.0085545},
      {0.0010799,0.2396,-0.22322,0.028393,0.19421,0.10014,-0.17042,0.13461,-0.007006,-0.011931},
      {0.00080331,0.18506,-0.24746,0.016811,0.23998,0.12793,-0.13169,0.16075,-0.04037,-0.054269},
      {0.00057758,0.1274,-0.27702,0.01,0.27708,0.15044,-0.091039,0.18671,-0.080452,-0.088745},
      {0.00039612,0.073766,-0.31252,0.0058306,0.30185,0.16713,-0.05329,0.21452,-0.12305,-0.11038},
      {0.00027789,0.041323,-0.3388,0.0027798,0.31303,0.17579,-0.030385,0.23487,-0.15116,-0.11921},
      {0.00019247,0.028816,-0.35041,0.0013865,0.31646,0.17872,-0.021402,0.24389,-0.16277,-0.12167},
      {0.00012263,0.018621,-0.36308,1.63E-05,0.31732,0.18041,-0.014053,0.2541,-0.17344,-0.1215},
      {7.52E-05,0.010479,-0.37874,-0.0011197,0.31351,0.17959,-0.0081622,0.26661,-0.18442,-0.1167},
      {8.52E-05,0.0057232,-0.39253,-0.0013475,0.3053,0.17538,-0.0046141,0.2764,-0.19377,-0.1084},
      {0.0001371,0.0033376,-0.40184,-0.0014134,0.29867,0.17164,-0.0027102,0.28298,-0.19972,-0.10199},
      {0.00021166,0.0016507,-0.40929,-0.00136,0.29335,0.16873,-0.0012971,0.28833,-0.20431,-0.096759},
      {0.0003081,0.00056825,-0.41681,-0.0012186,0.28748,0.1656,-0.00032075,0.29379,-0.20856,-0.090923},
      {0.0005008,0.00013694,-0.42158,-0.00098024,0.28357,0.16354,0.00020508,0.29737,-0.21097,-0.087014},
      {0.00076424,8.41E-05,-0.41606,-0.00074237,0.28924,0.16682,0.00045984,0.29367,-0.20798,-0.092429},
      {0.0196,-0.0026317,0.6557,-0.0012378,-0.0011957,-0.0013588,0.0038438,0.46317,-0.30761,0.18146},
      {0.022828,-0.0045239,0.64807,-0.0012866,-0.0014622,-0.0016495,0.0037138,0.45759,-0.30052,0.1808},
      {0.027336,-0.0072562,0.63714,-0.001351,-0.0018548,-0.0021231,0.0033961,0.44961,-0.29042,0.17979},
      {0.032695,-0.010677,0.62365,-0.0014191,-0.0023617,-0.0028284,0.0027492,0.43975,-0.27802,0.17842},
      {0.038258,-0.014511,0.60874,-0.0014738,-0.0029574,-0.0038256,0.0016157,0.42887,-0.26445,0.17666},
      {0.051467,-0.020639,0.55506,-0.0016738,-0.0049387,-0.0056922,-0.011822,0.39015,-0.21526,0.17176},
      {0.065919,-0.027417,0.4883,-0.0017177,-0.007492,-0.0087615,-0.030562,0.34211,-0.15462,0.16485},
      {0.078053,-0.033557,0.42226,-0.001451,-0.010138,-0.013281,-0.051016,0.29473,-0.095554,0.15655},
      {0.082891,-0.023551,0.35381,-0.00056239,-0.011993,-0.018673,-0.080948,0.24634,-0.037626,0.14704},
      {0.081218,0.010762,0.27039,0.0014676,-0.012908,-0.024581,-0.12652,0.18871,0.029741,0.13621},
      {0.079008,0.051376,0.17637,0.0046334,-0.013858,-0.032303,-0.17794,0.12459,0.10542,0.1237},
      {0.062769,0.13139,0.10452,0.010829,-0.0073727,-0.0351,-0.22991,0.082382,0.14862,0.11536},
      {0.041589,0.23425,0.044645,0.017664,0.0027638,-0.046685,-0.27063,0.05513,0.16721,0.10169},
      {0.026003,0.3304,-0.021393,0.024385,0.010276,-0.058536,-0.30707,0.026028,0.19015,0.09073},
      {0.016196,0.37404,-0.05841,0.030229,0.025877,-0.054125,-0.31111,0.026605,0.17862,0.081362},
      {0.009298,0.39821,-0.088032,0.034686,0.040116,-0.039895,-0.3066,0.040315,0.15637,0.0813},
      {0.0043315,0.41918,-0.12171,0.037066,0.049115,-0.018231,-0.30563,0.058759,0.13687,0.093686},
      {0.0027077,0.37589,-0.1629,0.032227,0.081314,0.0088176,-0.26954,0.091049,0.093006,0.072585},
      {0.0018255,0.31581,-0.21565,0.023507,0.11299,0.034341,-0.22458,0.1352,0.039276,0.049686},
      {0.001068,0.24368,-0.28339,0.018335,0.13384,0.054195,-0.173,0.18672,-0.028761,0.036893},
      {0.00068169,0.17707,-0.3309,0.013852,0.16317,0.076272,-0.12595,0.22309,-0.083951,0.013315},
      {0.00049013,0.12004,-0.36493,0.0089574,0.19347,0.096103,-0.085801,0.25032,-0.12718,-0.013669},
      {0.00034111,0.07019,-0.40377,0.0054827,0.21254,0.11166,-0.050752,0.28025,-0.16965,-0.028082},
      {0.00022799,0.035607,-0.43978,0.0025326,0.21914,0.12049,-0.026432,0.30791,-0.20328,-0.030192},
      {0.00014561,0.024836,-0.44887,0.00040923,0.22467,0.12489,-0.018639,0.31588,-0.21227,-0.034483},
      {9.43E-05,0.015487,-0.45738,-0.00049275,0.22795,0.12801,-0.01185,0.3225,-0.22092,-0.036592},
      {6.43E-05,0.0079092,-0.46875,-0.00075859,0.22594,0.12825,-0.0063101,0.33062,-0.23048,-0.033506},
      {7.52E-05,0.0035241,-0.4798,-0.00091113,0.22055,0.1261,-0.0030033,0.33848,-0.23828,-0.027554},
      {0.00014337,0.0018372,-0.48347,-0.00093894,0.21896,0.12532,-0.0015691,0.3411,-0.24104,-0.025911},
      {0.0002335,0.0007414,-0.48753,-0.00087628,0.21651,0.12414,-0.00056421,0.34405,-0.24363,-0.023371},
      {0.00031658,0.00033148,-0.49062,-0.00073708,0.21447,0.1233,-8.16E-05,0.34639,-0.24533,-0.021131},
      {0.00039559,9.75E-05,-0.48816,-0.00065029,0.21747,0.12525,0.00018671,0.34472,-0.24415,-0.023831},
      {0.0021705,0.0033235,0.69403,-0.00084332,-0.00011546,-0.00056943,0.00038261,0.49058,-0.34281,0.18388},
      {0.0038898,0.0021158,0.68918,-0.00085566,-0.00031837,-0.00099203,-5.44E-05,0.48704,-0.33845,0.18321},
      {0.0063005,0.00039131,0.6822,-0.00086795,-0.00061616,-0.0016648,-0.00075037,0.48196,-0.33222,0.18219},
      {0.0091835,-0.0017245,0.67349,-0.00087204,-0.0009983,-0.0026375,-0.0017443,0.47563,-0.32453,0.18079},
      {0.012204,-0.0040113,0.66377,-0.0008564,-0.0014424,-0.0039669,-0.0030554,0.46857,-0.31605,0.17899},
      {0.014965,-0.0061649,0.65393,-0.00080696,-0.0019153,-0.0057193,-0.0046619,0.46143,-0.30769,0.17679},
      {0.019736,-0.008826,0.62894,-0.0006073,-0.0029709,-0.0088187,-0.011696,0.44349,-0.28598,0.17242},
      {0.028139,-0.01228,0.57415,-1.41E-05,-0.0051154,-0.014759,-0.029502,0.40435,-0.23816,0.16365},
      {0.033963,-0.013614,0.52311,0.00088661,-0.0070292,-0.022442,-0.04762,0.36804,-0.19477,0.15371},
      {0.038245,-0.0077408,0.46401,0.0021623,-0.0090768,-0.034675,-0.06917,0.32647,-0.14705,0.13928},
      {0.041986,0.032032,0.34943,0.0049037,-0.011357,-0.057154,-0.11544,0.24808,-0.058349,0.11349},
      {0.043859,0.076995,0.22957,0.0079534,-0.013593,-0.092444,-0.16038,0.16697,0.029631,0.077863},
      {0.039749,0.1403,0.12264,0.012088,-0.012385,-0.12949,-0.20158,0.099408,0.098072,0.043148},
      {0.027082,0.23516,0.054968,0.018154,-0.0042569,-0.13674,-0.239,0.0702,0.12517,0.037993},
      {0.017675,0.32601,-0.013909,0.023269,0.0022436,-0.13562,-0.27778,0.043714,0.15631,0.042098},
      {0.011376,0.38464,-0.066111,0.02655,0.011045,-0.1218,-0.29856,0.038246,0.16595,0.051589},
      {0.0069468,0.40609,-0.10091,0.027213,0.02095,-0.096791,-0.29848,0.058365,0.14769,0.066034},
      {0.0038701,0.42325,-0.14035,0.024956,0.026155,-0.064272,-0.3015,0.084339,0.13153,0.090945},
      {0.0022703,0.37761,-0.19236,0.023512,0.043507,-0.040404,-0.26795,0.11998,0.082289,0.087252},
      {0.001511,0.2985,-0.26171,0.019439,0.066727,-0.020242,-0.21174,0.17148,0.009396,0.071185},
      {0.00090738,0.22298,-0.34418,0.015628,0.080029,0.0031259,-0.15823,0.23212,-0.068134,0.071895},
      {0.00051235,0.15407,-0.41588,0.011875,0.097467,0.030212,-0.10958,0.28518,-0.13674,0.069562},
      {0.00035806,0.10268,-0.4517,0.0069963,0.12262,0.049486,-0.073434,0.31388,-0.17783,0.049495},
      {0.00023429,0.061854,-0.49156,0.0026404,0.13399,0.062191,-0.044759,0.34524,-0.21577,0.043742},
      {0.00014459,0.030348,-0.53056,0.00051911,0.13541,0.07022,-0.02266,0.37438,-0.24976,0.048389},
      {9.46E-05,0.019069,-0.53362,7.83E-05,0.14567,0.077847,-0.014507,0.3766,-0.25704,0.039973},
      {6.07E-05,0.011243,-0.53879,-0.0002517,0.15015,0.081823,-0.0087644,0.38033,-0.26366,0.036847},
      {4.06E-05,0.0053651,-0.54995,-0.00047805,0.14691,0.081589,-0.0044044,0.38831,-0.27226,0.041307},
      {4.70E-05,0.0016909,-0.56366,-0.00059856,0.13875,0.078407,-0.0015967,0.39807,-0.28102,0.050383},
      {0.00012187,0.0010253,-0.55775,-0.00058502,0.14587,0.082761,-0.00085942,0.39395,-0.27847,0.043764},
      {0.00019193,0.00059395,-0.55286,-0.00053322,0.15165,0.086347,-0.0003778,0.39056,-0.27625,0.038436},
      {0.00021369,0.00027182,-0.54803,-0.00051208,0.1571,0.089718,-8.72E-05,0.38716,-0.27401,0.033409},
      {-0.00028862,0.0025632,0.69894,-0.0015231,4.62E-06,-0.00038196,-0.00026133,0.49327,-0.34753,0.18422},
      {-6.52E-05,0.0025787,0.699,-0.001366,3.33E-06,-0.00042265,-0.00033225,0.49342,-0.34748,0.18418},
      {0.00028301,0.002606,0.69906,-0.0011302,1.22E-06,-0.00048463,-0.00043866,0.49364,-0.34738,0.18412},
      {0.0011005,0.0023194,0.69714,-0.00092218,-9.87E-05,-0.0010083,-0.00083389,0.4924,-0.3457,0.18351},
      {0.0026896,0.0013555,0.69064,-0.00088838,-0.00042325,-0.0028623,-0.0017788,0.4877,-0.34053,0.18145},
      {0.0044093,0.00028413,0.68296,-0.00081566,-0.00081228,-0.0054888,-0.0028511,0.48219,-0.33457,0.17863},
      {0.0061556,-0.00079239,0.6743,-0.00069329,-0.001255,-0.0090495,-0.0040162,0.47602,-0.32806,0.17494},
      {0.0078214,-0.0017835,0.66468,-0.0005064,-0.00174,-0.013848,-0.0052597,0.46921,-0.32109,0.17014},
      {0.013393,-0.002481,0.61061,0.00025295,-0.0040975,-0.029601,-0.020225,0.4308,-0.27828,0.15295},
      {0.017864,-0.001337,0.5542,0.0010838,-0.0065029,-0.051764,-0.034524,0.39082,-0.23593,0.1304},
      {0.020947,0.002196,0.49607,0.0019705,-0.0087878,-0.081788,-0.047546,0.34972,-0.19508,0.10154},
      {0.022553,0.044762,0.38142,0.0048113,-0.010339,-0.12517,-0.086688,0.27236,-0.11371,0.061033},
      {0.022787,0.096611,0.25633,0.0078902,-0.011229,-0.18174,-0.12722,0.18896,-0.02846,0.010979},
      {0.021474,0.15458,0.13035,0.010893,-0.010961,-0.2497,-0.16503,0.10641,0.052934,-0.046319},
      {0.014528,0.24406,0.060816,0.015092,-0.0042495,-0.24257,-0.20506,0.080829,0.087603,-0.035953},
      {0.010004,0.33046,-0.008471,0.01738,0.00066813,-0.22486,-0.2472,0.059629,0.12568,-0.015971},
      {0.0076239,0.38179,-0.068021,0.018842,0.0040572,-0.20537,-0.27608,0.046308,0.15168,0.0013708},
      {0.0050332,0.3726,-0.10725,0.019878,0.009934,-0.18099,-0.26707,0.068834,0.12536,0.015678},
      {0.0030493,0.36538,-0.1562,0.020147,0.01314,-0.14435,-0.25996,0.099607,0.096024,0.043592},
      {0.0017972,0.33964,-0.22139,0.019637,0.019288,-0.10011,-0.24048,0.14369,0.050144,0.072916},
      {0.0012383,0.26054,-0.30567,0.015353,0.0365,-0.072486,-0.18444,0.20592,-0.029811,0.071544},
      {0.00074572,0.18837,-0.3982,0.01054,0.046144,-0.040509,-0.13346,0.2744,-0.10997,0.084527},
      {0.00032048,0.12369,-0.49525,0.0051897,0.049832,-0.0050344,-0.087927,0.3465,-0.1882,0.10884},
      {0.00020629,0.082463,-0.52772,0.0017108,0.067944,0.011718,-0.058989,0.37188,-0.22318,0.096753},
      {0.00012843,0.049895,-0.55801,0.0011071,0.07736,0.024457,-0.036155,0.39364,-0.25422,0.093803},
      {7.37E-05,0.025089,-0.5908,0.00056161,0.077255,0.032547,-0.018739,0.41713,-0.28266,0.10067},
      {3.75E-05,0.013069,-0.60335,0.00015188,0.080958,0.03874,-0.010118,0.42614,-0.29491,0.10049},
      {1.50E-05,0.0070611,-0.60885,-0.00012852,0.083562,0.041889,-0.0056415,0.43012,-0.30077,0.099361},
      {3.48E-06,0.0034631,-0.61422,-0.00029992,0.084202,0.044221,-0.0028446,0.434,-0.30536,0.10038},
      {1.76E-06,0.0012984,-0.62448,-0.00036345,0.078526,0.043035,-0.0011054,0.44132,-0.31165,0.10755},
      {6.92E-05,0.00080641,-0.6093,-0.00037042,0.094321,0.052215,-0.00063777,0.43059,-0.30432,0.092473},
      {0.00010723,0.00047479,-0.59932,-0.00036135,0.10482,0.058405,-0.00032703,0.42354,-0.29951,0.082525},
      {-0.0010042,0.0018493,0.69798,-0.0030088,4.56E-05,-0.0012933,0.00023071,0.49148,-0.34825,0.18344},
      {-0.00082774,0.0018356,0.69791,-0.0028486,4.60E-05,-0.0015219,0.00018939,0.49155,-0.34814,0.18324},
      {-0.00056195,0.0018123,0.69779,-0.0026015,4.69E-05,-0.0019,0.00012809,0.49164,-0.34798,0.18291},
      {-0.00020694,0.0017761,0.69759,-0.0022586,4.85E-05,-0.002475,4.80E-05,0.49175,-0.34773,0.18241},
      {0.00023088,0.001723,0.69727,-0.0018109,5.15E-05,-0.0033101,-4.76E-05,0.49184,-0.34738,0.18169},
      {0.0011237,0.0012998,0.69272,-0.0014781,-0.00015866,-0.0062036,-0.00062036,0.48881,-0.3441,0.17891},
      {0.0023078,0.00066191,0.68439,-0.0012362,-0.00054024,-0.011387,-0.0015656,0.483,-0.33837,0.17395},
      {0.0034398,0.00012783,0.67489,-0.0009341,-0.00093265,-0.018129,-0.0025289,0.47641,-0.3321,0.16766},
      {0.0044406,-0.00021955,0.66419,-0.00056682,-0.0013079,-0.026792,-0.0034521,0.46903,-0.32539,0.15977},
      {0.0066445,0.0025424,0.62122,0.00015659,-0.0028306,-0.051649,-0.012139,0.43871,-0.29599,0.13648},
      {0.0085333,0.0084903,0.56367,0.0010319,-0.0045259,-0.089264,-0.022881,0.3981,-0.25831,0.10225},
      {0.0093531,0.017281,0.50342,0.0019247,-0.0056999,-0.13641,-0.032072,0.35565,-0.22156,0.060903},
      {0.0094003,0.056765,0.39956,0.0041166,-0.0057641,-0.1985,-0.05948,0.28596,-0.15463,0.0083232},
      {0.00869,0.11509,0.2718,0.0067464,-0.0045282,-0.27529,-0.094871,0.20195,-0.072997,-0.054315},
      {0.008553,0.16131,0.13615,0.0088949,-0.0042269,-0.36656,-0.12662,0.11145,0.011661,-0.12988},
      {0.0072268,0.21436,0.054283,0.011133,-0.002461,-0.37167,-0.16184,0.072743,0.060209,-0.13337},
      {0.0059293,0.26543,-0.005082,0.012915,-0.00060152,-0.35096,-0.19471,0.053453,0.09377,-0.11473},
      {0.0052357,0.30706,-0.055505,0.014243,0.00085634,-0.32746,-0.22099,0.042086,0.11817,-0.093882},
      {0.0037272,0.30258,-0.1095,0.014668,0.0044036,-0.28501,-0.21577,0.07324,0.090205,-0.061574},
      {0.00246,0.29386,-0.17516,0.013906,0.0066326,-0.22878,-0.20819,0.11748,0.052856,-0.016415},
      {0.0015199,0.28513,-0.25271,0.011359,0.0072878,-0.15979,-0.2012,0.17217,0.010781,0.041085},
      {0.0010192,0.2198,-0.34553,0.0053201,0.016693,-0.12163,-0.15504,0.24161,-0.065453,0.059579},
      {0.000579,0.15427,-0.43922,0.0026167,0.022866,-0.083247,-0.10905,0.3094,-0.14375,0.082667},
      {0.00020961,0.097241,-0.53311,0.002204,0.025672,-0.037549,-0.069101,0.37572,-0.21899,0.1166},
      {7.86E-05,0.060999,-0.57784,0.0015986,0.034231,-0.014088,-0.0437,0.40762,-0.25909,0.12378},
      {2.72E-05,0.035939,-0.60748,0.00098701,0.03786,-0.003536,-0.026107,0.42893,-0.28606,0.12732},
      {-7.41E-06,0.017697,-0.63781,0.00047082,0.034441,0.0034392,-0.013251,0.45063,-0.31002,0.13802},
      {-2.64E-05,0.0082062,-0.65201,9.79E-05,0.036484,0.011342,-0.0063897,0.46083,-0.32176,0.14164},
      {-3.47E-05,0.0046144,-0.65202,-0.00011101,0.042466,0.016748,-0.0036026,0.46091,-0.32366,0.13754},
      {-2.51E-05,0.0025581,-0.65143,-0.00019014,0.04695,0.021015,-0.0020244,0.46051,-0.32444,0.13464},
      {-1.18E-05,0.0011929,-0.6534,-0.00021868,0.04817,0.023502,-0.00098146,0.4619,-0.32614,0.13495},
      {2.38E-05,0.00064542,-0.64547,-0.00022218,0.057334,0.029449,-0.00051874,0.45629,-0.32246,0.12672},
      {-0.0015508,0.0013115,0.69677,-0.0048111,8.59E-05,-0.0016895,0.00065477,0.48932,-0.34891,0.18308},
      {-0.001407,0.0012884,0.69658,-0.0046291,8.78E-05,-0.0021085,0.00062336,0.48932,-0.34874,0.18272},
      {-0.0011895,0.001252,0.69628,-0.0043431,9.11E-05,-0.0027816,0.00057655,0.48931,-0.34847,0.18215},
      {-0.0008973,0.0012,0.69583,-0.0039362,9.59E-05,-0.003767,0.00051501,0.48929,-0.34808,0.1813},
      {-0.00053413,0.0011301,0.6952,-0.0033896,0.00010279,-0.0051358,0.00044087,0.48923,-0.34754,0.18013},
      {-0.00010802,0.0010404,0.69433,-0.0026796,0.00011231,-0.0069756,0.00035752,0.48912,-0.34681,0.17856},
      {0.00039633,0.00092239,0.69235,-0.0018453,9.35E-05,-0.0099383,0.00020233,0.4883,-0.34537,0.17599},
      {0.0011183,0.00081741,0.68246,-0.0014615,-0.00017682,-0.018857,-0.00050442,0.48153,-0.33942,0.16806},
      {0.0017584,0.00090954,0.67105,-0.0010178,-0.00040465,-0.030019,-0.0011544,0.47374,-0.33284,0.1583},
      {0.0022708,0.0012727,0.65798,-0.00051573,-0.00055435,-0.043837,-0.0016888,0.46483,-0.32563,0.14642},
      {0.0027933,0.005982,0.62259,0.0001725,-0.0009763,-0.075186,-0.0057874,0.44008,-0.30495,0.11946},
      {0.003287,0.015237,0.55188,0.0009569,-0.0017501,-0.13835,-0.013702,0.39028,-0.26426,0.065512},
      {0.0036231,0.023674,0.46682,0.0016604,-0.0025688,-0.21886,-0.021403,0.33037,-0.21669,-0.0028168},
      {0.0039115,0.046628,0.35512,0.0029534,-0.0030771,-0.3092,-0.039368,0.25371,-0.1505,-0.078814},
      {0.0043122,0.084241,0.2283,0.0048676,-0.0033868,-0.39578,-0.067325,0.16861,-0.071654,-0.15127},
      {0.0045168,0.11527,0.11302,0.0063392,-0.0036066,-0.48096,-0.089824,0.091172,-0.0019495,-0.2222},
      {0.0042065,0.15299,0.036264,0.0076449,-0.0026455,-0.5033,-0.11468,0.052029,0.041671,-0.23988},
      {0.0037503,0.19486,-0.010527,0.0084272,-0.0010728,-0.4743,-0.14133,0.044215,0.064657,-0.2142},
      {0.0034688,0.22956,-0.049305,0.0080181,6.33E-05,-0.44412,-0.16336,0.043118,0.0811,-0.1875},
      {0.0027204,0.23613,-0.10697,0.0062878,0.0015669,-0.39126,-0.16649,0.076084,0.060899,-0.14378},
      {0.0018745,0.22977,-0.18732,0.0027077,0.0023462,-0.31662,-0.1613,0.13358,0.019248,-0.081776},
      {0.0012279,0.21917,-0.27224,0.0029537,0.003028,-0.23228,-0.15414,0.19235,-0.028312,-0.012614},
      {0.00074817,0.17356,-0.36278,0.0027,0.0073168,-0.17502,-0.12228,0.25598,-0.096169,0.028831},
      {0.00038299,0.11771,-0.45643,0.0022163,0.01083,-0.12708,-0.083168,0.32217,-0.17067,0.063598},
      {9.57E-05,0.070886,-0.55258,0.0017633,0.011213,-0.07112,-0.050372,0.39014,-0.24189,0.10952},
      {-3.99E-05,0.039541,-0.61645,0.0012049,0.013044,-0.031819,-0.028381,0.43546,-0.28914,0.13951},
      {-6.20E-05,0.022546,-0.64013,0.00061527,0.01554,-0.020996,-0.01638,0.4525,-0.30911,0.14491},
      {-7.47E-05,0.011112,-0.66214,0.00019562,0.014148,-0.012339,-0.0082355,0.46823,-0.32558,0.15409},
      {-6.78E-05,0.0052902,-0.67642,1.69E-05,0.013699,-0.004117,-0.0040682,0.47832,-0.3355,0.16155},
      {-5.16E-05,0.0034274,-0.67113,-5.53E-05,0.022286,0.0021581,-0.0026634,0.47456,-0.33383,0.15442},
      {-3.59E-05,0.0020438,-0.67043,-9.58E-05,0.026023,0.0059205,-0.0016119,0.47406,-0.3342,0.15217},
      {-2.12E-05,0.0010599,-0.67369,-0.00010821,0.02576,0.0078079,-0.00085413,0.47635,-0.33634,0.15412},
      {-0.0017862,0.00099932,0.69597,-0.0067208,0.00011927,-0.0010636,0.00085991,0.4874,-0.34972,0.18358},
      {-0.0017465,0.00093569,0.69551,-0.0071714,0.0001245,-0.0011465,0.00089341,0.48676,-0.34976,0.18351},
      {-0.0016009,0.00087836,0.69497,-0.0070944,0.00013062,-0.0019059,0.00088238,0.48643,-0.34948,0.18286},
      {-0.0013593,0.00082014,0.69428,-0.0065643,0.00013831,-0.0033355,0.00083533,0.48632,-0.34892,0.18164},
      {-0.001057,0.00074459,0.69335,-0.0058493,0.0001488,-0.0052777,0.00077823,0.48617,-0.34815,0.17998},
      {-0.00069939,0.00065126,0.69212,-0.0049188,0.00016261,-0.007823,0.00071344,0.48596,-0.34713,0.17782},
      {-0.00031575,0.00055551,0.68965,-0.0036484,0.00017606,-0.012129,0.0006292,0.48515,-0.34536,0.17419},
      {9.78E-05,0.00044312,0.68572,-0.0022204,0.00019149,-0.018291,0.00053403,0.48345,-0.34282,0.16901},
      {0.00050762,0.00061138,0.67109,-0.0014929,9.05E-05,-0.034736,0.00012107,0.47367,-0.33492,0.15508},
      {0.00089349,0.0008704,0.64821,-0.0010073,-4.79E-05,-0.060021,-0.00041587,0.45788,-0.32293,0.13373},
      {0.0012463,0.001129,0.61939,-0.00049111,-0.00017382,-0.092218,-0.00096267,0.43792,-0.30797,0.10662},
      {0.0015753,0.0032939,0.57193,3.10E-05,-0.00046869,-0.14209,-0.0031643,0.40471,-0.28272,0.064547},
      {0.0018225,0.010615,0.48339,0.00066739,-0.0012664,-0.22911,-0.0097141,0.34236,-0.23427,-0.0090912},
      {0.0019449,0.017279,0.38549,0.0012278,-0.0019834,-0.32891,-0.015525,0.27343,-0.18176,-0.093118},
      {0.0020196,0.028902,0.27864,0.0019086,-0.0024443,-0.43297,-0.024463,0.19905,-0.12332,-0.18018},
      {0.0022178,0.056323,0.1752,0.0030021,-0.0023979,-0.51152,-0.043941,0.12966,-0.061137,-0.24509},
      {0.0022491,0.077814,0.083885,0.0034781,-0.0021545,-0.58753,-0.058509,0.068376,-0.0077917,-0.30739},
      {0.0021254,0.10119,0.01696,0.0033293,-0.001384,-0.62615,-0.073357,0.031472,0.028865,-0.33799},
      {0.0020387,0.13604,-0.018616,0.0022565,-0.00024953,-0.59107,-0.095732,0.033694,0.044112,-0.30714},
      {0.0021568,0.1672,-0.046179,0.001717,7.34E-05,-0.54563,-0.11699,0.041151,0.054613,-0.26893},
      {0.0019617,0.18063,-0.093288,0.0018881,0.00050385,-0.48463,-0.12649,0.068621,0.041575,-0.21873},
      {0.0013539,0.17084,-0.18021,0.0021012,0.0011911,-0.39695,-0.11988,0.12886,-0.006558,-0.14678},
      {0.00084282,0.15631,-0.27323,0.002205,0.0015603,-0.3077,-0.10987,0.1938,-0.060162,-0.073084},
      {0.00044391,0.12597,-0.37041,0.0019932,0.002598,-0.23037,-0.08869,0.26222,-0.12373,-0.010306},
      {0.00016366,0.080408,-0.46735,0.0014288,0.0040757,-0.17037,-0.05678,0.33077,-0.19463,0.03739},
      {-2.57E-05,0.045276,-0.56197,0.00094082,0.0040712,-0.10342,-0.032153,0.39765,-0.25917,0.092984},
      {-0.00012101,0.02125,-0.6413,0.00050601,0.0035143,-0.042023,-0.015275,0.45376,-0.31051,0.14474},
      {-0.00011554,0.012646,-0.6568,0.00023823,0.0053601,-0.031675,-0.0092048,0.46475,-0.32234,0.15067},
      {-9.89E-05,0.0076037,-0.66876,0.00012134,0.0063873,-0.022524,-0.0056477,0.47312,-0.33068,0.15679},
      {-7.80E-05,0.0041649,-0.68006,3.89E-05,0.0062215,-0.014321,-0.0031974,0.48102,-0.33794,0.16383},
      {-5.90E-05,0.0026039,-0.68064,-9.78E-06,0.009991,-0.0092678,-0.0020352,0.48139,-0.33901,0.1626},
      {-4.20E-05,0.0016358,-0.68181,-3.10E-05,0.011636,-0.0064594,-0.0012939,0.4822,-0.3401,0.16257},
      {-0.0020065,0.00098887,0.69649,-0.0047493,0.00012931,-0.0025163,0.00091023,0.48926,-0.34905,0.18237},
      {-0.0020303,0.00093588,0.69595,-0.0050474,0.00013515,-0.0027745,0.00097578,0.48868,-0.34894,0.18214},
      {-0.0020711,0.00085524,0.69511,-0.0054893,0.00014431,-0.0031902,0.0010787,0.48779,-0.34876,0.18178},
      {-0.0021359,0.00074597,0.69395,-0.0060655,0.0001573,-0.0037999,0.0012244,0.48659,-0.34849,0.18126},
      {-0.002139,0.00062964,0.69212,-0.0063024,0.00017339,-0.0055529,0.0013466,0.48517,-0.34773,0.17978},
      {-0.0018537,0.00055142,0.68863,-0.0052804,0.00019045,-0.010727,0.0012708,0.48349,-0.34559,0.17543},
      {-0.0014859,0.00046094,0.68386,-0.0041627,0.00021212,-0.017516,0.0011503,0.48099,-0.3428,0.16974},
      {-0.0010259,0.00036014,0.67749,-0.002996,0.00023906,-0.026262,0.00097274,0.47742,-0.33926,0.16241},
      {-0.00046654,0.00025182,0.66913,-0.0018308,0.00027196,-0.037357,0.00072716,0.47248,-0.3348,0.15313},
      {2.78E-05,0.00028965,0.64977,-0.0010303,0.00024927,-0.060095,0.00033827,0.45947,-0.32483,0.13405},
      {0.0003386,0.0005071,0.6144,-0.00065274,0.00016785,-0.10009,-0.00015785,0.43477,-0.30678,0.1005},
      {0.00062761,0.00071896,0.57154,-0.00031843,0.00011792,-0.14884,-0.00064571,0.40474,-0.28504,0.059707},
      {0.00087458,0.0012482,0.51794,-2.97E-05,7.92E-05,-0.20951,-0.0013684,0.36707,-0.25786,0.0090117},
      {0.00092741,0.0069646,0.41788,0.00040599,-0.00043818,-0.31452,-0.0061184,0.29663,-0.205,-0.078945},
      {0.00089048,0.012038,0.30988,0.00071683,-0.00071863,-0.4311,-0.010045,0.22064,-0.14878,-0.17603},
      {0.00077298,0.016772,0.19531,0.00087333,-0.00066585,-0.55759,-0.013269,0.14013,-0.089794,-0.28073},
      {0.00082155,0.035101,0.11576,0.00089888,-0.00016324,-0.62643,-0.0252,0.086882,-0.043578,-0.3366},
      {0.0009371,0.050386,0.055878,0.00091507,-0.00017656,-0.67483,-0.035484,0.04709,-0.0079999,-0.37622},
      {0.001054,0.065439,0.0083484,0.0010212,-0.00033377,-0.70489,-0.045889,0.018006,0.020001,-0.40095},
      {0.0012448,0.096418,-0.017068,0.0011542,-0.000189,-0.65449,-0.067531,0.026612,0.029383,-0.35908},
      {0.0013558,0.12032,-0.040174,0.001224,-7.57E-05,-0.61185,-0.084238,0.035641,0.034959,-0.32362},
      {0.0013042,0.13249,-0.071734,0.0012334,6.10E-05,-0.56916,-0.092776,0.053165,0.028633,-0.28819},
      {0.00080682,0.11572,-0.17001,0.0012527,0.00042916,-0.47633,-0.081181,0.12194,-0.028691,-0.21153},
      {0.00040999,0.097534,-0.27388,0.0011435,0.00058008,-0.3787,-0.068526,0.19499,-0.089533,-0.13058},
      {0.00011286,0.07656,-0.38155,0.00086672,0.00062442,-0.27973,-0.053865,0.27109,-0.15367,-0.048408},
      {-5.42E-05,0.04439,-0.47494,0.00038282,0.00087346,-0.21035,-0.031319,0.33707,-0.21608,0.0088287},
      {-0.00012082,0.026069,-0.56156,0.00030242,0.0010667,-0.13224,-0.018536,0.39798,-0.26832,0.073385},
      {-0.00015089,0.013525,-0.6404,0.00028229,0.0012021,-0.056325,-0.0098016,0.45341,-0.31383,0.1362},
      {-0.00013487,0.0083569,-0.65764,0.00017817,0.0023362,-0.041049,-0.0061706,0.46549,-0.32487,0.14724},
      {-0.00011151,0.005118,-0.66794,9.50E-05,0.0026267,-0.032961,-0.0038704,0.47267,-0.33153,0.15353},
      {-8.47E-05,0.0030856,-0.67812,4.00E-05,0.0022048,-0.024825,-0.0024025,0.47976,-0.33754,0.16089},
      {-6.08E-05,0.0020393,-0.68343,1.18E-05,0.0028841,-0.019097,-0.0016167,0.48345,-0.3407,0.16466},
      {-0.0025799,0.00094649,0.69829,-0.0019245,0.00014527,-0.0030534,0.0012506,0.49264,-0.34842,0.1819},
      {-0.0026289,0.00090291,0.69772,-0.0021055,0.00015274,-0.003428,0.0013241,0.49213,-0.34823,0.18158},
      {-0.0027075,0.00083675,0.69683,-0.0023738,0.00016441,-0.0040198,0.0014385,0.49135,-0.34793,0.18107},
      {-0.0028217,0.00074742,0.6956,-0.0027233,0.00018087,-0.0048665,0.0015986,0.49028,-0.34749,0.18034},
      {-0.002979,0.00063584,0.69398,-0.0031385,0.00020269,-0.0060089,0.0018086,0.48891,-0.3469,0.17936},
      {-0.0031877,0.00050443,0.69194,-0.0035952,0.00023046,-0.0074923,0.0020721,0.48723,-0.34611,0.17809},
      {-0.0030119,0.00039582,0.68685,-0.003408,0.00026096,-0.013489,0.0020617,0.48389,-0.34364,0.17306},
      {-0.0024051,0.00031209,0.67795,-0.0026384,0.00029433,-0.024872,0.0017405,0.47829,-0.33916,0.16355},
      {-0.0017126,0.00022493,0.66679,-0.001861,0.00033402,-0.038899,0.0013604,0.47113,-0.33362,0.15183},
      {-0.00094233,0.00013847,0.65298,-0.0011059,0.00038055,-0.055977,0.0009226,0.46213,-0.32684,0.13758},
      {-0.00022825,0.00011202,0.63075,-0.00048796,0.00042179,-0.082397,0.0004485,0.44708,-0.31585,0.11552},
      {1.50E-05,0.00030892,0.58117,-0.00026966,0.00044406,-0.13913,3.25E-05,0.41219,-0.29089,0.068174},
      {0.00022678,0.00051295,0.52299,-0.00010066,0.0005251,-0.20592,-0.00035081,0.37118,-0.26169,0.012517},
      {0.00039524,0.0007268,0.45526,7.04E-06,0.00068262,-0.28391,-0.00068225,0.32336,-0.22779,-0.05236},
      {0.00038306,0.00439,0.35292,0.00016408,0.00061139,-0.39681,-0.0033305,0.25146,-0.17525,-0.146},
      {0.00035772,0.0080549,0.24812,0.00030959,0.00042657,-0.51243,-0.005977,0.17783,-0.12147,-0.24186},
      {0.00033176,0.011081,0.1471,0.00042964,0.00022782,-0.62497,-0.0081419,0.10665,-0.069741,-0.33512},
      {0.00043855,0.023111,0.088974,0.00054262,3.54E-05,-0.67501,-0.016452,0.067449,-0.036095,-0.37641},
      {0.00053105,0.034935,0.045354,0.00062105,-0.00014447,-0.70859,-0.024614,0.038561,-0.0098221,-0.40404},
      {0.00057649,0.043565,0.0088094,0.00063168,-0.00033614,-0.73755,-0.030571,0.014837,0.011254,-0.42788},
      {0.00065712,0.061614,-0.01606,0.00063846,-0.00027732,-0.70528,-0.04318,0.021742,0.015468,-0.40102},
      {0.00066432,0.073953,-0.039171,0.00058238,-0.00019865,-0.67212,-0.051803,0.033404,0.013497,-0.37338},
      {0.0005893,0.0788,-0.061317,0.00044958,-0.00014839,-0.64688,-0.055183,0.045714,0.0073519,-0.3523},
      {0.00027643,0.06498,-0.15866,0.00033094,-6.17E-06,-0.55206,-0.045564,0.11394,-0.047824,-0.27362},
      {3.79E-05,0.050458,-0.26962,0.00015548,1.23E-05,-0.4416,-0.03543,0.19233,-0.11041,-0.18186},
      {-8.55E-05,0.042079,-0.38441,0.00020672,8.80E-05,-0.31858,-0.029636,0.27348,-0.17199,-0.079853},
      {-0.00014203,0.028137,-0.47349,0.00020717,0.00036254,-0.23217,-0.019938,0.33613,-0.22332,-0.0085251},
      {-0.00016551,0.016654,-0.55107,0.0001908,0.0005367,-0.15642,-0.011951,0.39065,-0.26766,0.054093},
      {-0.00016854,0.0086985,-0.62199,0.00016675,0.00058895,-0.084362,-0.0064234,0.44054,-0.30694,0.11382},
      {-0.0001485,0.004901,-0.65286,0.00011004,0.00078741,-0.053346,-0.0037618,0.46222,-0.32416,0.13927},
      {-0.00011732,0.0031939,-0.66114,5.87E-05,0.00078259,-0.046298,-0.0025304,0.46795,-0.32906,0.14512},
      {-8.30E-05,0.0023065,-0.6694,2.89E-05,0.00065596,-0.038476,-0.0018643,0.47367,-0.33358,0.15179},
      {-0.0020083,0.00077417,0.70147,-0.00050342,0.00015259,-0.0019643,0.000908,0.49591,-0.34974,0.18279},
      {-0.0020767,0.00074074,0.70086,-0.00060717,0.00016162,-0.0024354,0.00098555,0.49543,-0.34948,0.18239},
      {-0.0021842,0.0006902,0.6999,-0.00076084,0.0001757,-0.0031738,0.0011057,0.49469,-0.34908,0.18175},
      {-0.0023369,0.00062237,0.69855,-0.00096082,0.00019548,-0.0042186,0.0012727,0.49367,-0.3485,0.18086},
      {-0.0025406,0.00053839,0.69678,-0.001198,0.0002216,-0.0056094,0.0014899,0.49235,-0.34773,0.17967},
      {-0.0028019,0.00044074,0.69456,-0.0014585,0.00025465,-0.0073872,0.0017597,0.49072,-0.34674,0.17815},
      {-0.0031273,0.0003332,0.69183,-0.0017243,0.00029528,-0.0095957,0.0020835,0.48877,-0.34549,0.17626},
      {-0.0034733,0.00022313,0.68818,-0.0019426,0.00034366,-0.01283,0.0024252,0.48623,-0.34378,0.1735},
      {-0.0027344,0.0001624,0.67423,-0.0014335,0.00038893,-0.029801,0.0019789,0.47695,-0.33705,0.15935},
      {-0.0019383,0.00010664,0.65739,-0.00092507,0.00044125,-0.050097,0.0014898,0.46568,-0.32894,0.14242},
      {-0.0011323,6.50E-05,0.63601,-0.00048975,0.00049422,-0.075007,0.00097936,0.45148,-0.31884,0.12167},
      {-0.00031272,2.83E-05,0.6092,-0.0001015,0.00054489,-0.10545,0.00044649,0.43384,-0.30636,0.096337},
      {-0.00013598,0.00020035,0.54425,-6.00E-05,0.00062821,-0.17944,0.00011699,0.38833,-0.27411,0.034784},
      {1.76E-05,0.0003627,0.47136,-2.60E-05,0.00071563,-0.26302,-0.00019377,0.33694,-0.23774,-0.034722},
      {0.00015682,0.00050605,0.3911,6.83E-06,0.00080469,-0.35566,-0.00048071,0.28006,-0.19748,-0.11172},
      {0.00018955,0.0025429,0.29915,9.68E-05,0.00069354,-0.45928,-0.0019881,0.21506,-0.15059,-0.19766},
      {0.00018895,0.0050229,0.20988,0.00018802,0.00047951,-0.55923,-0.0037377,0.15201,-0.10485,-0.28049},
      {0.00017613,0.0069094,0.12226,0.00024437,0.00024028,-0.65839,-0.0050624,0.089964,-0.060095,-0.36261},
      {0.00021161,0.013421,0.067367,0.00027515,2.84E-05,-0.71212,-0.0095673,0.052537,-0.030399,-0.40698},
      {0.00024522,0.020756,0.034474,0.00026932,-0.00013909,-0.73813,-0.014635,0.031566,-0.011894,-0.42836},
      {0.00023841,0.025508,0.0070831,0.00021997,-0.00026545,-0.76111,-0.017914,0.014382,0.0026648,-0.4472},
      {0.00022121,0.032965,-0.016055,0.00014919,-0.00022591,-0.74767,-0.023111,0.017552,0.0042443,-0.43584},
      {0.00015702,0.037577,-0.038127,2.13E-05,-0.00015115,-0.72219,-0.02632,0.030183,-0.0022383,-0.41452},
      {0.00012642,0.041627,-0.061735,-4.65E-06,-0.00014881,-0.69244,-0.029159,0.045494,-0.010956,-0.38982},
      {3.54E-05,0.037979,-0.14597,3.79E-05,-9.34E-05,-0.59984,-0.026657,0.10466,-0.054618,-0.31303},
      {-7.27E-05,0.030803,-0.2614,8.71E-05,-1.38E-05,-0.4747,-0.021706,0.18625,-0.1159,-0.20926},
      {-0.00016483,0.023688,-0.37657,0.0001188,5.78E-05,-0.34979,-0.016801,0.26767,-0.17701,-0.10568},
      {-0.00020522,0.015461,-0.46801,0.00011774,0.00017289,-0.25398,-0.011105,0.33214,-0.22671,-0.026325},
      {-0.00020115,0.0086148,-0.53733,9.70E-05,0.00025469,-0.18244,-0.0063574,0.38089,-0.26463,0.032928},
      {-0.00017557,0.0047238,-0.59663,8.27E-05,0.0003035,-0.11897,-0.0036708,0.42262,-0.29612,0.085529},
      {-0.00014406,0.0028326,-0.63492,6.05E-05,0.00033278,-0.077351,-0.002356,0.44956,-0.31613,0.12002},
      {-0.00011082,0.0021262,-0.64225,3.33E-05,0.00030216,-0.070215,-0.0018246,0.45462,-0.32009,0.12598},
      {-0.00066031,0.00047598,0.70557,0,0.00014799,8.54E-05,0.0001354,0.49909,-0.35234,0.1845},
      {-0.00068516,0.00047313,0.70553,0,0.00015348,8.86E-05,0.00015513,0.49907,-0.35231,0.18449},
      {-0.00084881,0.00045071,0.70439,-9.05E-05,0.00016856,-0.0007793,0.00029208,0.49828,-0.35177,0.18375},
      {-0.0010779,0.00041948,0.70273,-0.0002167,0.00018987,-0.0020487,0.00048352,0.49715,-0.35099,0.18267},
      {-0.0013707,0.0003799,0.70051,-0.00037568,0.00021774,-0.0037549,0.00072754,0.49566,-0.34996,0.18121},
      {-0.0017256,0.00033235,0.69764,-0.00056511,0.00025265,-0.0059608,0.0010226,0.49377,-0.34864,0.17933},
      {-0.0021383,0.0002776,0.69403,-0.00078077,0.00029497,-0.0087355,0.0013645,0.49145,-0.34703,0.17697},
      {-0.0026008,0.00021682,0.68961,-0.0010166,0.00034508,-0.012154,0.0017464,0.48866,-0.34508,0.17406},
      {-0.0031017,0.00015151,0.68425,-0.0012646,0.00040327,-0.016295,0.0021584,0.48539,-0.34278,0.17055},
      {-0.0027866,0.00010834,0.66713,-0.0011295,0.00045224,-0.035045,0.0019803,0.47423,-0.3349,0.15492},
      {-0.0020196,7.65E-05,0.64095,-0.00079048,0.00049551,-0.064648,0.0014744,0.45702,-0.32276,0.1303},
      {-0.0012102,4.41E-05,0.61179,-0.00043743,0.000547,-0.097497,0.00094803,0.43786,-0.30923,0.10298},
      {-0.00041979,1.57E-05,0.57888,-0.00012914,0.00059823,-0.13421,0.00043474,0.41626,-0.29402,0.072448},
      {-0.00013243,0.00011167,0.5151,-4.26E-05,0.00068228,-0.20781,0.00012858,0.37124,-0.26218,0.011251},
      {-4.58E-06,0.0002302,0.43741,-1.46E-05,0.00077704,-0.29824,-9.68E-05,0.31572,-0.22291,-0.063917},
      {9.36E-05,0.00033188,0.35295,8.12E-06,0.00086951,-0.39685,-0.0002866,0.25521,-0.18011,-0.14585},
      {0.00012338,0.0012847,0.26561,4.42E-05,0.00078611,-0.49746,-0.0010061,0.19292,-0.13565,-0.22929},
      {0.00010411,0.0027417,0.18182,7.74E-05,0.00052886,-0.59306,-0.0020274,0.13346,-0.092911,-0.30839},
      {7.75E-05,0.0036981,0.10026,8.23E-05,0.00027883,-0.68708,-0.0026911,0.075427,-0.051424,-0.38608},
      {6.37E-05,0.006414,0.043884,6.03E-05,9.59E-05,-0.74828,-0.0045656,0.036297,-0.02239,-0.43654},
      {5.01E-05,0.010332,0.019954,7.16E-06,1.80E-05,-0.76843,-0.0072717,0.021472,-0.0099085,-0.45299},
      {4.37E-05,0.01361,0.0030824,-1.43E-05,-7.57E-05,-0.78038,-0.0095588,0.011929,-0.0014929,-0.46278},
      {4.05E-05,0.017949,-0.015655,-1.66E-05,-0.0001336,-0.77086,-0.012599,0.014642,-0.001197,-0.45484},
      {2.54E-05,0.022394,-0.04072,-1.45E-05,-0.00013458,-0.73843,-0.01572,0.031234,-0.010637,-0.42793},
      {-5.83E-06,0.024399,-0.067721,-1.37E-05,-0.00013112,-0.70628,-0.017141,0.049402,-0.02242,-0.40126},
      {-6.69E-05,0.02191,-0.13335,3.09E-06,-9.34E-05,-0.63395,-0.015443,0.095354,-0.056116,-0.34128},
      {-0.0001453,0.015927,-0.24881,3.23E-05,-1.86E-05,-0.50739,-0.011333,0.17698,-0.11678,-0.23633},
      {-0.00019874,0.010964,-0.35823,5.04E-05,5.36E-05,-0.3867,-0.0079391,0.25431,-0.17389,-0.13625},
      {-0.00022231,0.006625,-0.44798,5.35E-05,0.00012212,-0.28818,-0.00497,0.31768,-0.22084,-0.054584},
      {-0.00019544,0.00338,-0.50605,4.27E-05,0.00017581,-0.22534,-0.0027341,0.35856,-0.2514,-0.0025108},
      {-0.00016588,0.0021082,-0.55942,3.58E-05,0.00023245,-0.16543,-0.0018885,0.39618,-0.27866,0.047118},
      {-0.00014199,0.0020957,-0.60422,3.39E-05,0.00029816,-0.11378,-0.0019404,0.42778,-0.30099,0.089868},
      {-0.00040331,0.00035583,0.70583,0,0.00021221,0.00012252,3.68E-05,0.49931,-0.35268,0.18443},
      {-0.00042002,0.00035227,0.70578,0,0.00022829,0.00013181,5.14E-05,0.49929,-0.35266,0.18442},
      {-0.00044509,0.00034678,0.70571,0,0.0002547,0.00014705,7.33E-05,0.49926,-0.35263,0.18439},
      {-0.00047832,0.00033919,0.7056,0,0.00029458,0.00017008,0.0001026,0.49921,-0.35258,0.18436},
      {-0.00052677,0.00032846,0.70537,-4.21E-06,0.00035151,0.00012092,0.00014531,0.49909,-0.35248,0.18423},
      {-0.00081511,0.00028878,0.7021,-0.00012806,0.00040059,-0.0024197,0.00038583,0.49711,-0.35107,0.18206},
      {-0.0011399,0.0002442,0.69811,-0.00026054,0.0004529,-0.0055519,0.00065724,0.49474,-0.34937,0.17938},
      {-0.0014895,0.00019617,0.69336,-0.000394,0.00050332,-0.0093334,0.00095017,0.49195,-0.34737,0.17618},
      {-0.0018485,0.00014646,0.68781,-0.00051982,0.00054427,-0.013828,0.0012525,0.48873,-0.34505,0.17239},
      {-0.0021977,9.70E-05,0.68141,-0.000629,0.00056515,-0.019106,0.001549,0.48509,-0.34242,0.16798},
      {-0.0021608,5.88E-05,0.66697,-0.00060523,0.00057724,-0.03399,0.0015684,0.47601,-0.33599,0.15562},
      {-0.0014783,3.93E-05,0.63691,-0.0003933,0.00061836,-0.067482,0.0011242,0.45618,-0.32207,0.12778},
      {-0.0008339,2.35E-05,0.60336,-0.00021254,0.00065086,-0.10463,0.00070698,0.43405,-0.30654,0.096927},
      {-0.00025906,1.23E-05,0.56626,-7.00E-05,0.00066892,-0.14548,0.00033825,0.40958,-0.28936,0.063027},
      {-6.64E-06,6.32E-05,0.50221,-1.35E-05,0.00071741,-0.21919,0.0001092,0.36456,-0.25758,0.0018136},
      {4.76E-05,0.00014409,0.41531,7.49E-07,0.00079172,-0.32095,-3.22E-05,0.30215,-0.21345,-0.082699},
      {7.23E-05,0.00020936,0.32074,1.08E-05,0.00085583,-0.43181,-0.00013994,0.23421,-0.16542,-0.17472},
      {6.19E-05,0.00053841,0.22669,1.62E-05,0.00080682,-0.54163,-0.00039691,0.16681,-0.11764,-0.26574},
      {3.62E-05,0.0012093,0.1507,7.83E-06,0.00056511,-0.62986,-0.00086392,0.11258,-0.078964,-0.33857},
      {2.14E-05,0.0017975,0.083095,2.34E-06,0.00032982,-0.70867,-0.0012888,0.064097,-0.044375,-0.40365},
      {1.08E-05,0.0030786,0.029121,-3.71E-06,0.00013195,-0.76949,-0.0021946,0.026096,-0.016853,-0.45385},
      {9.80E-06,0.0061794,0.014307,-1.05E-05,2.81E-05,-0.77852,-0.0043653,0.018393,-0.009834,-0.46127},
      {3.74E-06,0.0084038,0.00097635,-1.70E-05,-6.28E-05,-0.78613,-0.0059258,0.012184,-0.0043136,-0.4675},
      {-9.12E-06,0.010199,-0.014524,-2.15E-05,-0.00012014,-0.78301,-0.0071904,0.01281,-0.0038316,-0.46487},
      {-3.68E-05,0.011894,-0.042964,-2.15E-05,-0.00010961,-0.7494,-0.0083959,0.032093,-0.016555,-0.43698},
      {-6.49E-05,0.011907,-0.074179,-2.31E-05,-8.96E-05,-0.71429,-0.0084307,0.053497,-0.031629,-0.40786},
      {-9.93E-05,0.01007,-0.12223,-2.07E-05,-5.50E-05,-0.66153,-0.0071883,0.087028,-0.056208,-0.3641},
      {-0.0001459,0.0061657,-0.22946,-2.88E-06,1.57E-05,-0.5421,-0.0045363,0.16283,-0.1117,-0.26507},
      {-0.00018455,0.0029613,-0.32862,6.33E-06,7.55E-05,-0.43118,-0.0023751,0.23294,-0.16281,-0.17311},
      {-0.00020692,0.001702,-0.41744,1.46E-05,0.00026082,-0.32965,-0.0015914,0.29575,-0.20776,-0.089133},
      {-0.00017612,0.0015941,-0.47034,1.62E-05,0.00044752,-0.26858,-0.001578,0.33307,-0.23421,-0.038743},
      {-0.00015394,0.0016475,-0.51819,1.69E-05,0.00052536,-0.21328,-0.001678,0.36684,-0.25805,0.0070257},
      {-0.00017216,0.00019833,0.70594,0,0.00053518,0.00030899,-1.50E-05,0.49936,-0.35291,0.18412},
      {-0.0001816,0.00019569,0.70587,0,0.00057956,0.00033461,-6.20E-06,0.49932,-0.35288,0.18408},
      {-0.00019561,0.00019161,0.70576,0,0.0006507,0.00037568,6.97E-06,0.49926,-0.35283,0.18401},
      {-0.00021386,0.00018598,0.7056,0,0.00075464,0.00043569,2.44E-05,0.49918,-0.35277,0.18391},
      {-0.00023546,0.0001787,0.70538,0,0.00089885,0.00051895,4.55E-05,0.49907,-0.35268,0.18378},
      {-0.00025899,0.00016975,0.70511,0,0.0010928,0.00063092,6.94E-05,0.49892,-0.35257,0.18359},
      {-0.00030689,0.00015699,0.70426,-7.62E-06,0.0013134,0.00030316,0.00011448,0.49844,-0.35222,0.183},
      {-0.00053342,0.00012717,0.69934,-6.89E-05,0.0012972,-0.0038926,0.00030728,0.49565,-0.3502,0.17955},
      {-0.00074916,9.68E-05,0.69363,-0.00012311,0.0012508,-0.0088688,0.00049435,0.49242,-0.34787,0.17549},
      {-0.00093428,6.74E-05,0.68709,-0.00016501,0.0011598,-0.014698,0.00066057,0.48876,-0.34523,0.17078},
      {-0.0010653,4.05E-05,0.67972,-0.00018984,0.0010062,-0.021459,0.00078816,0.48466,-0.34228,0.1654},
      {-0.001069,1.89E-05,0.66936,-0.00018541,0.00079485,-0.031709,0.00082407,0.4786,-0.33799,0.1572},
      {-0.00060145,1.37E-05,0.63553,-0.0001004,0.00079586,-0.068967,0.00052595,0.45619,-0.32227,0.1263},
      {-0.00022159,1.27E-05,0.59837,-3.99E-05,0.00077437,-0.10972,0.00028959,0.43157,-0.30497,0.092543},
      {3.56E-05,1.67E-05,0.5579,-5.67E-06,0.00072263,-0.15394,0.00013923,0.40473,-0.28607,0.055947},
      {0.0001095,4.43E-05,0.49536,3.90E-06,0.00069365,-0.22545,6.91E-05,0.36101,-0.25518,-0.0033083},
      {8.88E-05,9.48E-05,0.40259,7.05E-06,0.00073543,-0.33496,-2.27E-06,0.29388,-0.2077,-0.094174},
      {6.60E-05,0.00013928,0.30652,9.71E-06,0.00077016,-0.44794,-6.78E-05,0.22464,-0.15874,-0.18791},
      {4.32E-05,0.00025694,0.21292,1.06E-05,0.00075462,-0.55756,-0.00017949,0.15745,-0.11118,-0.2788},
      {2.80E-05,0.00074002,0.14667,4.71E-06,0.0005192,-0.63486,-0.00053084,0.10996,-0.077355,-0.34262},
      {1.33E-05,0.0011096,0.081208,-1.38E-06,0.00029812,-0.71123,-0.00080238,0.063118,-0.044041,-0.40568},
      {1.21E-07,0.0015011,0.020845,-7.83E-06,0.00010454,-0.781,-0.0010883,0.020274,-0.013545,-0.4633},
      {-5.23E-06,0.0032884,0.0088161,-1.54E-05,2.08E-05,-0.7864,-0.0023442,0.015726,-0.0094181,-0.4677},
      {-1.17E-05,0.0043188,-0.0026261,-2.26E-05,-4.12E-05,-0.79041,-0.0030726,0.012554,-0.0066464,-0.47097},
      {-1.91E-05,0.004659,-0.014022,-2.92E-05,-7.89E-05,-0.79175,-0.0033213,0.011499,-0.0057168,-0.47203},
      {-4.51E-05,0.0047057,-0.046557,-3.10E-05,-5.47E-05,-0.75499,-0.0033853,0.033892,-0.021472,-0.44154},
      {-7.18E-05,0.0036912,-0.081318,-3.36E-05,-2.67E-05,-0.71667,-0.0027164,0.057996,-0.038973,-0.40976},
      {-9.62E-05,0.0021543,-0.11852,-3.66E-05,7.94E-05,-0.67573,-0.0016929,0.083994,-0.058077,-0.37594},
      {-0.00012142,0.0016021,-0.21336,-2.28E-05,0.00053406,-0.56581,-0.0013973,0.15113,-0.10574,-0.2854},
      {-0.00014356,0.0011831,-0.30208,-1.07E-05,0.00085308,-0.46309,-0.0012084,0.2139,-0.15023,-0.20064},
      {-0.00016205,0.00088282,-0.38185,-6.28E-07,0.001005,-0.37088,-0.0011124,0.27032,-0.19017,-0.12437},
      {-0.00014948,0.00094403,-0.43422,2.52E-06,0.0010813,-0.31026,-0.001225,0.30732,-0.21627,-0.074192},
      {-4.17E-05,7.62E-05,0.70614,0,0.00068028,0.00039276,-2.21E-05,0.49943,-0.35309,0.18399},
      {-4.52E-05,7.43E-05,0.70604,0,0.00076215,0.00044003,-1.80E-05,0.49937,-0.35305,0.18391},
      {-5.02E-05,7.14E-05,0.70587,0,0.00089194,0.00051496,-1.20E-05,0.49928,-0.35298,0.18378},
      {-5.61E-05,6.74E-05,0.70564,0,0.0010786,0.00062275,-4.39E-06,0.49915,-0.35289,0.1836},
      {-6.23E-05,6.22E-05,0.70533,0,0.0013325,0.00076934,4.33E-06,0.49897,-0.35276,0.18336},
      {-6.74E-05,5.59E-05,0.70493,0,0.001666,0.00096186,1.33E-05,0.49873,-0.35259,0.18304},
      {-6.97E-05,4.84E-05,0.70443,0,0.0020938,0.0012088,2.13E-05,0.49843,-0.35238,0.18263},
      {-6.74E-05,3.97E-05,0.7038,0,0.0026338,0.0015206,2.70E-05,0.49805,-0.35212,0.18212},
      {-8.66E-05,2.76E-05,0.70041,-4.66E-06,0.0028479,-0.0012107,5.66E-05,0.49613,-0.35076,0.17954},
      {-8.95E-05,1.40E-05,0.69385,-7.57E-06,0.0025995,-0.0076342,8.25E-05,0.49245,-0.34815,0.17457},
      {-1.68E-05,3.14E-06,0.68648,-7.83E-07,0.0022604,-0.015061,5.45E-05,0.48832,-0.34525,0.1689},
      {-1.48E-05,1.25E-06,0.67748,-6.53E-07,0.0019129,-0.024382,7.09E-05,0.48296,-0.34145,0.16167},
      {-1.41E-05,-3.96E-07,0.6672,-8.29E-07,0.0012082,-0.035833,8.86E-05,0.47668,-0.337,0.15319},
      {1.99E-05,3.69E-06,0.63361,-1.87E-08,0.00099914,-0.073161,8.90E-05,0.45403,-0.32098,0.12254},
      {5.77E-05,8.46E-06,0.59404,9.58E-07,0.00088591,-0.11726,8.73E-05,0.42713,-0.30195,0.086133},
      {9.30E-05,1.28E-05,0.55206,1.91E-06,0.00073576,-0.16435,8.65E-05,0.39844,-0.28166,0.047305},
      {0.0001116,2.53E-05,0.49613,3.14E-06,0.00059824,-0.22848,7.19E-05,0.3593,-0.25398,-0.0056762},
      {8.60E-05,6.18E-05,0.40077,5.02E-06,0.00061811,-0.34009,1.49E-05,0.29093,-0.20563,-0.098245},
      {6.35E-05,9.04E-05,0.30221,5.71E-06,0.00060273,-0.45491,-3.17E-05,0.22062,-0.15592,-0.19343},
      {3.64E-05,0.00010986,0.20166,5.12E-06,0.00057083,-0.57169,-7.29E-05,0.14914,-0.10539,-0.29022},
      {2.24E-05,0.00037675,0.13829,-2.03E-06,0.0003611,-0.64536,-0.00027305,0.10401,-0.07334,-0.35105},
      {9.69E-06,0.00054521,0.07754,-9.47E-06,0.00019072,-0.71572,-0.00040441,0.060949,-0.042801,-0.40918},
      {-1.20E-06,0.00061431,0.019661,-1.72E-05,6.33E-05,-0.78245,-0.0004662,0.020146,-0.013912,-0.46435},
      {-7.56E-06,0.0012561,0.0034373,-2.42E-05,1.07E-05,-0.79215,-0.00092552,0.013767,-0.0090683,-0.47233},
      {-1.34E-05,0.0014661,-0.007177,-3.08E-05,-1.57E-05,-0.79326,-0.0010857,0.012941,-0.0083675,-0.47321},
      {-1.85E-05,0.00119,-0.017226,-3.72E-05,-2.05E-05,-0.79247,-0.00091021,0.013616,-0.0089719,-0.47252},
      {-3.65E-05,0.0011272,-0.048834,-3.96E-05,0.00011377,-0.75737,-0.00090957,0.034927,-0.024021,-0.44361},
      {-5.39E-05,0.0010032,-0.087334,-4.02E-05,0.0005876,-0.71232,-0.00087934,0.06201,-0.043172,-0.40693},
      {-6.70E-05,0.00079941,-0.12783,-3.97E-05,0.0014651,-0.66433,-0.00080252,0.090522,-0.063371,-0.3684},
      {-8.53E-05,0.00054752,-0.20058,-3.07E-05,0.0020252,-0.57951,-0.00072063,0.14196,-0.099779,-0.29885},
      {-0.00010362,0.00036124,-0.27789,-2.02E-05,0.0022005,-0.48997,-0.00069993,0.19664,-0.13844,-0.22483},
      {-0.00011846,0.0002248,-0.3469,-1.10E-05,0.0021645,-0.41036,-0.00071995,0.24542,-0.1729,-0.15875},
      {-1.68E-07,3.16E-06,0.70671,0,0.00035059,0.00020241,-1.52E-06,0.49975,-0.35337,0.1843},
      {-2.33E-07,3.20E-06,0.70654,0,0.00050054,0.00028899,-1.25E-06,0.49964,-0.3533,0.18416},
      {-3.26E-07,3.26E-06,0.70627,0,0.00074286,0.00042889,-8.42E-07,0.49947,-0.35318,0.18393},
      {-4.39E-07,3.34E-06,0.70587,0,0.0011006,0.00063542,-2.79E-07,0.49922,-0.353,0.18358},
      {-5.58E-07,3.44E-06,0.70532,0,0.001603,0.00092548,4.35E-07,0.49886,-0.35274,0.1831},
      {-6.65E-07,3.55E-06,0.70458,0,0.0022874,0.0013206,1.29E-06,0.49838,-0.3524,0.18245},
      {-7.33E-07,3.67E-06,0.70359,0,0.0032011,0.0018481,2.28E-06,0.49773,-0.35194,0.18157},
      {-7.34E-07,3.78E-06,0.70231,0,0.0044029,0.002542,3.39E-06,0.49688,-0.35134,0.18042},
      {-6.34E-07,3.89E-06,0.70066,0,0.0059653,0.0034441,4.57E-06,0.49577,-0.35056,0.17893},
      {-3.81E-07,3.91E-06,0.69827,-6.90E-09,0.0078375,0.0040963,6.46E-06,0.49418,-0.34943,0.17678},
      {8.54E-07,2.68E-06,0.68964,-1.46E-07,0.0071421,-0.0058593,2.06E-05,0.48881,-0.34562,0.16952},
      {3.13E-06,1.46E-06,0.67975,-2.81E-07,0.0060626,-0.017952,3.46E-05,0.48254,-0.34118,0.16105},
      {7.94E-06,3.07E-07,0.66838,-4.05E-07,0.0045341,-0.032579,4.90E-05,0.47519,-0.33597,0.15111},
      {1.85E-05,-7.02E-07,0.65525,-5.07E-07,0.0023544,-0.050362,6.56E-05,0.46659,-0.32988,0.1395},
      {4.62E-05,1.42E-06,0.62437,-1.82E-08,0.0012633,-0.086561,7.51E-05,0.44557,-0.31501,0.11105},
      {8.03E-05,4.82E-06,0.58209,6.90E-07,0.0010546,-0.13435,8.13E-05,0.41651,-0.29445,0.071723},
      {0.00011111,7.63E-06,0.53698,1.26E-06,0.00075374,-0.18569,8.80E-05,0.38537,-0.27243,0.029588},
      {0.00013303,1.14E-05,0.48562,1.63E-06,0.00036196,-0.2447,9.04E-05,0.34964,-0.24716,-0.018778},
      {9.92E-05,3.10E-05,0.38893,1.00E-06,0.00034247,-0.35688,4.49E-05,0.28097,-0.19861,-0.11177},
      {6.39E-05,4.33E-05,0.29035,-6.89E-07,0.00031419,-0.47099,5.07E-06,0.21113,-0.14924,-0.20635},
      {2.98E-05,4.79E-05,0.1904,-3.51E-06,0.00027683,-0.58642,-2.69E-05,0.14051,-0.099317,-0.302},
      {1.43E-05,0.00012837,0.12548,-1.03E-05,0.00016782,-0.6612,-9.97E-05,0.094749,-0.066921,-0.36387},
      {4.73E-06,0.00015845,0.070755,-1.80E-05,7.67E-05,-0.72391,-0.00013491,0.056397,-0.039786,-0.41575},
      {-1.32E-06,0.00011916,0.019431,-2.61E-05,2.14E-05,-0.78234,-0.00012098,0.02069,-0.014556,-0.46411},
      {-5.39E-06,0.00026866,-0.0010356,-3.33E-05,9.35E-06,-0.79681,-0.00024312,0.011693,-0.0081083,-0.4761},
      {-9.01E-06,0.00038242,-0.010494,-3.93E-05,1.08E-05,-0.79366,-0.00034435,0.01349,-0.0093061,-0.4735},
      {-1.16E-05,0.00039609,-0.020265,-4.43E-05,2.27E-05,-0.78921,-0.00037937,0.016147,-0.01116,-0.46983},
      {-2.18E-05,0.00031417,-0.048511,-4.58E-05,0.00045891,-0.75832,-0.00037053,0.034586,-0.024192,-0.44485},
      {-3.40E-05,0.00016876,-0.089349,-4.47E-05,0.001508,-0.70956,-0.00033653,0.063351,-0.04454,-0.40592},
      {-4.23E-05,-8.99E-06,-0.13137,-4.24E-05,0.0030522,-0.65858,-0.00028806,0.092976,-0.065511,-0.36586},
      {-5.36E-05,-8.06E-05,-0.18643,-3.49E-05,0.0038362,-0.59364,-0.00032935,0.13187,-0.092972,-0.31313},
      {-6.99E-05,-0.00010684,-0.25137,-2.43E-05,0.003432,-0.51922,-0.00041983,0.1778,-0.12536,-0.25082},
      {0,1.40E-06,0.70709,0,1.72E-05,9.92E-06,-9.87E-07,0.49999,-0.35354,0.18462},
      {0,1.43E-06,0.70709,0,1.77E-05,1.02E-05,-1.01E-06,0.49999,-0.35354,0.18462},
      {0,1.48E-06,0.70709,0,1.85E-05,1.07E-05,-1.05E-06,0.49999,-0.35354,0.18462},
      {0,1.55E-06,0.70709,0,1.95E-05,1.13E-05,-1.09E-06,0.49999,-0.35354,0.18462},
      {2.59E-07,1.61E-06,0.70618,0,0.000886,0.00051153,-5.24E-07,0.49937,-0.35311,0.18379},
      {6.94E-07,1.68E-06,0.7048,0,0.0022211,0.0012823,3.23E-07,0.49843,-0.35244,0.18251},
      {1.31E-06,1.76E-06,0.703,0,0.0039613,0.0022871,1.36E-06,0.4972,-0.35157,0.18084},
      {2.15E-06,1.83E-06,0.70071,0,0.00619,0.0035738,2.59E-06,0.49562,-0.35045,0.17871},
      {3.24E-06,1.89E-06,0.69782,0,0.0090032,0.005198,4.03E-06,0.49363,-0.34904,0.17602},
      {4.64E-06,1.94E-06,0.69424,0,0.01251,0.0072228,5.65E-06,0.49115,-0.34729,0.17266},
      {6.35E-06,1.97E-06,0.68983,0,0.016833,0.0097183,7.45E-06,0.48809,-0.34512,0.16852},
      {1.38E-05,1.46E-06,0.68053,-5.39E-08,0.01683,-0.00037235,1.77E-05,0.4819,-0.34074,0.16016},
      {2.54E-05,7.51E-07,0.66787,-1.24E-07,0.013896,-0.019181,3.20E-05,0.47348,-0.33478,0.14878},
      {3.85E-05,1.24E-07,0.65343,-1.81E-07,0.010127,-0.041519,4.61E-05,0.46379,-0.32791,0.13567},
      {5.25E-05,-3.97E-07,0.637,-2.21E-07,0.0053949,-0.067884,5.92E-05,0.45265,-0.32003,0.1206},
      {7.00E-05,3.81E-07,0.60762,-4.58E-08,0.002192,-0.10647,6.77E-05,0.4324,-0.30571,0.09321},
      {8.80E-05,2.23E-06,0.56261,2.78E-07,0.0017305,-0.15828,7.13E-05,0.40116,-0.28361,0.050912},
      {0.00010046,3.46E-06,0.51477,4.54E-07,0.0010934,-0.21381,7.33E-05,0.36782,-0.26003,0.0057855},
      {0.00010576,4.00E-06,0.46412,4.61E-07,0.00023668,-0.27313,7.27E-05,0.33241,-0.23499,-0.042171},
      {7.01E-05,8.84E-06,0.37156,-2.10E-06,0.00012771,-0.38003,3.99E-05,0.26708,-0.18881,-0.13065},
      {3.61E-05,8.01E-06,0.27387,-5.86E-06,9.46E-05,-0.49253,1.31E-05,0.19824,-0.14016,-0.22388},
      {1.40E-05,4.85E-06,0.17635,-1.06E-05,7.32E-05,-0.60467,-3.61E-06,0.1296,-0.091636,-0.31683},
      {6.45E-06,1.85E-05,0.11197,-1.79E-05,5.47E-05,-0.67829,-2.80E-05,0.084504,-0.059742,-0.37785},
      {3.16E-06,2.87E-05,0.065647,-2.68E-05,3.34E-05,-0.73065,-5.06E-05,0.052422,-0.037049,-0.42124},
      {3.42E-07,2.66E-05,0.022238,-3.66E-05,1.81E-05,-0.77926,-6.58E-05,0.02264,-0.015989,-0.46153},
      {-2.37E-06,4.34E-05,-0.0023935,-4.43E-05,1.79E-05,-0.79879,-9.87E-05,0.010625,-0.0074746,-0.47773},
      {-4.64E-06,3.52E-05,-0.012217,-4.88E-05,3.54E-05,-0.79364,-0.00012045,0.013725,-0.0096504,-0.47349},
      {-5.97E-06,-1.76E-05,-0.022168,-5.19E-05,6.32E-05,-0.7874,-0.00011471,0.017511,-0.012331,-0.46836},
      {-1.02E-05,-5.23E-05,-0.044086,-5.15E-05,0.0005854,-0.76386,-0.00013767,0.031344,-0.022091,-0.44958},
      {-1.77E-05,-0.00011208,-0.082464,-4.78E-05,0.0019195,-0.71731,-0.00016742,0.058401,-0.04119,-0.4129},
      {-2.21E-05,-0.00018461,-0.11873,-4.27E-05,0.0033539,-0.67301,-0.0001922,0.083984,-0.059254,-0.37823},
      {-2.81E-05,-0.00025626,-0.16062,-3.52E-05,0.0042651,-0.62306,-0.00022949,0.11358,-0.080143,-0.33812},
      {0,5.51E-07,0.7071,0,1.04E-05,5.98E-06,-3.89E-07,0.49999,-0.35355,0.18463},
      {0,5.67E-07,0.7071,0,1.07E-05,6.21E-06,-4.01E-07,0.49999,-0.35355,0.18463},
      {0,5.91E-07,0.70709,0,1.14E-05,6.55E-06,-4.18E-07,0.49999,-0.35355,0.18463},
      {0,6.22E-07,0.70709,0,1.22E-05,7.03E-06,-4.40E-07,0.49999,-0.35355,0.18463},
      {0,6.58E-07,0.70709,0,1.32E-05,7.64E-06,-4.66E-07,0.49999,-0.35355,0.18462},
      {0,6.99E-07,0.70709,0,1.45E-05,8.38E-06,-4.94E-07,0.49999,-0.35355,0.18462},
      {4.62E-07,7.34E-07,0.70593,0,0.0011589,0.0006691,-4.99E-08,0.49918,-0.35297,0.18353},
      {1.74E-06,7.57E-07,0.7026,0,0.0044388,0.0025627,1.20E-06,0.49686,-0.35133,0.18039},
      {3.22E-06,7.73E-07,0.69854,0,0.0084359,0.0048705,2.58E-06,0.49403,-0.34933,0.17656},
      {4.87E-06,7.76E-07,0.69367,0,0.01325,0.00765,4.06E-06,0.49063,-0.34692,0.17195},
      {6.65E-06,7.64E-07,0.68786,0,0.018992,0.010965,5.60E-06,0.48656,-0.34405,0.16645},
      {8.51E-06,7.32E-07,0.681,0,0.025782,0.014885,7.12E-06,0.48176,-0.34065,0.15995},
      {1.41E-05,5.64E-07,0.67066,-1.13E-08,0.028962,0.0087314,1.21E-05,0.47462,-0.33559,0.15028},
      {2.57E-05,2.42E-07,0.65454,-3.51E-08,0.023728,-0.018337,2.21E-05,0.46358,-0.32778,0.13536},
      {3.62E-05,4.15E-09,0.63615,-4.78E-08,0.017522,-0.049764,3.03E-05,0.45091,-0.31882,0.11821},
      {4.42E-05,-1.34E-07,0.61523,-4.82E-08,0.010235,-0.086069,3.58E-05,0.4364,-0.30856,0.098573},
      {4.87E-05,4.14E-08,0.58576,-2.70E-08,0.0039735,-0.13047,3.71E-05,0.41585,-0.29402,0.070747},
      {4.75E-05,4.44E-07,0.53806,-6.53E-08,0.0030675,-0.18659,3.36E-05,0.38245,-0.27041,0.025523},
      {4.95E-05,5.72E-07,0.48619,-2.04E-07,0.0017876,-0.24828,3.43E-05,0.34603,-0.24465,-0.023796},
      {5.59E-05,7.13E-07,0.43066,-4.08E-07,0.00038338,-0.31455,3.85E-05,0.30693,-0.217,-0.076724},
      {4.50E-05,6.51E-07,0.34573,-4.14E-06,4.26E-05,-0.41273,2.76E-05,0.24717,-0.17475,-0.15764},
      {2.93E-05,-5.82E-07,0.2539,-1.01E-05,4.08E-05,-0.51813,1.21E-05,0.18262,-0.12912,-0.24503},
      {1.44E-05,-3.28E-06,0.16511,-1.75E-05,3.79E-05,-0.61998,-2.95E-06,0.12025,-0.085032,-0.32948},
      {5.97E-06,-6.30E-06,0.10063,-2.67E-05,2.96E-05,-0.69329,-1.80E-05,0.075352,-0.053288,-0.39025},
      {3.35E-06,-1.38E-05,0.060019,-3.74E-05,2.02E-05,-0.73827,-3.02E-05,0.047786,-0.033799,-0.42754},
      {1.28E-06,-2.31E-05,0.022441,-5.01E-05,1.53E-05,-0.77914,-4.16E-05,0.022735,-0.01609,-0.46142},
      {-2.85E-07,-3.47E-05,-0.0032434,-6.02E-05,2.16E-05,-0.80119,-5.54E-05,0.0091908,-0.0065128,-0.47971},
      {-1.23E-06,-5.28E-05,-0.01253,-6.23E-05,4.86E-05,-0.79508,-7.38E-05,0.012876,-0.0091047,-0.47469},
      {-1.41E-06,-7.93E-05,-0.021323,-6.11E-05,8.10E-05,-0.78877,-8.89E-05,0.016694,-0.011792,-0.4695},
      {-2.26E-06,-0.00011792,-0.035425,-5.66E-05,0.00038044,-0.7745,-0.00010532,0.025107,-0.017724,-0.45809},
      {-6.42E-06,-0.00018423,-0.070061,-5.08E-05,0.0016632,-0.73233,-0.00013369,0.049548,-0.034977,-0.42497},
      {-9.16E-06,-0.00024679,-0.10148,-4.38E-05,0.0028977,-0.69391,-0.00016289,0.071742,-0.050641,-0.39489},
      {0,1.39E-07,0.7071,0,5.82E-06,3.36E-06,-9.85E-08,0.5,-0.35355,0.18463},
      {0,1.44E-07,0.7071,0,6.14E-06,3.55E-06,-1.02E-07,0.5,-0.35355,0.18463},
      {0,1.52E-07,0.7071,0,6.63E-06,3.83E-06,-1.07E-07,0.5,-0.35355,0.18463},
      {0,1.61E-07,0.7071,0,7.31E-06,4.22E-06,-1.14E-07,0.49999,-0.35355,0.18463},
      {0,1.71E-07,0.7071,0,8.19E-06,4.73E-06,-1.21E-07,0.49999,-0.35355,0.18463},
      {0,1.80E-07,0.7071,0,9.25E-06,5.34E-06,-1.27E-07,0.49999,-0.35355,0.18463},
      {0,1.87E-07,0.7071,0,1.05E-05,6.07E-06,-1.32E-07,0.49999,-0.35355,0.18463},
      {0,1.89E-07,0.70709,0,1.20E-05,6.90E-06,-1.34E-07,0.49999,-0.35355,0.18463},
      {7.16E-07,1.82E-07,0.70419,0,0.0028921,0.0016698,4.38E-07,0.49795,-0.35211,0.18187},
      {2.05E-06,1.65E-07,0.6981,0,0.008936,0.0051592,1.48E-06,0.49368,-0.34908,0.17608},
      {3.32E-06,1.38E-07,0.69097,0,0.016019,0.0092486,2.45E-06,0.48867,-0.34554,0.1693},
      {4.44E-06,1.01E-07,0.68269,0,0.02425,0.014001,3.26E-06,0.48285,-0.34142,0.16142},
      {5.26E-06,5.35E-08,0.67315,0,0.033747,0.019484,3.81E-06,0.47613,-0.33667,0.15233},
      {6.22E-06,0,0.66164,0,0.042636,0.021675,4.40E-06,0.46805,-0.33096,0.14138},
      {1.28E-05,0,0.64257,0,0.032982,-0.016727,9.07E-06,0.45477,-0.32156,0.1234},
      {1.95E-05,0,0.61874,0,0.0232,-0.060896,1.38E-05,0.43809,-0.30977,0.10083},
      {2.61E-05,0,0.58937,0,0.013459,-0.11145,1.85E-05,0.41746,-0.29518,0.072901},
      {3.25E-05,1.43E-08,0.55248,-1.82E-08,0.0047231,-0.16899,2.29E-05,0.39148,-0.2768,0.037732},
      {3.81E-05,1.22E-07,0.50026,-2.49E-07,0.0032854,-0.23154,2.66E-05,0.3547,-0.25079,-0.012063},
      {4.31E-05,1.49E-07,0.44513,-5.76E-07,0.0018748,-0.2975,2.98E-05,0.3158,-0.22328,-0.064728},
      {4.72E-05,7.38E-08,0.38715,-1.03E-06,0.00052779,-0.36675,3.24E-05,0.27482,-0.1943,-0.12021},
      {4.12E-05,-1.95E-06,0.31153,-6.33E-06,2.09E-05,-0.45427,2.52E-05,0.22175,-0.15679,-0.19205},
      {2.72E-05,-6.37E-06,0.22759,-1.63E-05,1.97E-05,-0.55016,1.01E-05,0.16302,-0.11527,-0.27156},
      {1.36E-05,-1.25E-05,0.14674,-2.88E-05,1.82E-05,-0.64247,-5.19E-06,0.10648,-0.075307,-0.3481},
      {4.46E-06,-2.07E-05,0.082939,-4.31E-05,1.57E-05,-0.7146,-1.92E-05,0.062294,-0.044073,-0.4079},
      {2.64E-06,-3.12E-05,0.049368,-5.68E-05,1.34E-05,-0.75064,-2.99E-05,0.040196,-0.028455,-0.43778},
      {1.38E-06,-4.39E-05,0.019578,-7.16E-05,1.37E-05,-0.78209,-3.96E-05,0.020907,-0.014824,-0.46386},
      {7.35E-07,-5.98E-05,-0.0037333,-8.45E-05,2.07E-05,-0.80381,-4.96E-05,0.0075717,-0.0054005,-0.48188},
      {6.64E-07,-8.67E-05,-0.011967,-8.15E-05,5.35E-05,-0.79767,-6.51E-05,0.011283,-0.0080103,-0.47684},
      {9.78E-07,-0.00011644,-0.019489,-7.47E-05,9.06E-05,-0.7916,-8.00E-05,0.014957,-0.010591,-0.47186},
      {9.38E-07,-0.00014015,-0.026381,-6.37E-05,0.00014554,-0.78549,-9.64E-05,0.01864,-0.013172,-0.46687},
      {-2.54E-06,-0.00018817,-0.055429,-5.64E-05,0.0011764,-0.75013,-0.00012776,0.039175,-0.027659,-0.43903},
      {0,3.90E-09,0.7071,0,2.73E-06,1.58E-06,-2.76E-09,0.5,-0.35355,0.18463},
      {0,3.59E-09,0.7071,0,3.01E-06,1.74E-06,-2.54E-09,0.5,-0.35355,0.18463},
      {0,2.85E-09,0.7071,0,3.44E-06,1.99E-06,-2.01E-09,0.5,-0.35355,0.18463},
      {0,1.34E-09,0.7071,0,4.04E-06,2.33E-06,-9.45E-10,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.79E-06,2.77E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.69E-06,3.28E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.73E-06,3.89E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.91E-06,4.57E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,9.21E-06,5.32E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,1.06E-05,6.11E-06,0,0.49999,-0.35355,0.18463},
      {8.59E-07,0,0.7006,0,0.0064799,0.0037412,6.08E-07,0.49542,-0.35031,0.17843},
      {1.84E-06,0,0.69321,0,0.013832,0.0079856,1.30E-06,0.49022,-0.34664,0.17139},
      {2.87E-06,0,0.6856,0,0.021415,0.012364,2.03E-06,0.48486,-0.34284,0.16413},
      {3.92E-06,0,0.67792,0,0.029069,0.016783,2.77E-06,0.47944,-0.33902,0.15681},
      {4.96E-06,0,0.67036,0,0.036607,0.021135,3.51E-06,0.47411,-0.33524,0.14959},
      {1.07E-05,0,0.64328,0,0.029675,-0.021998,7.56E-06,0.45505,-0.32176,0.12378},
      {1.80E-05,0,0.60811,0,0.020488,-0.078382,1.28E-05,0.43026,-0.30423,0.090223},
      {2.59E-05,0,0.56696,0,0.011838,-0.14076,1.83E-05,0.40123,-0.2837,0.050926},
      {3.39E-05,0,0.5192,0,0.0039357,-0.20949,2.40E-05,0.36752,-0.25986,0.0052853},
      {3.85E-05,-2.59E-07,0.46458,-8.14E-07,0.0022627,-0.27526,2.68E-05,0.32901,-0.23263,-0.046848},
      {4.12E-05,-7.68E-07,0.40595,-2.11E-06,0.0012059,-0.34463,2.82E-05,0.28765,-0.20338,-0.10285},
      {4.20E-05,-1.57E-06,0.34335,-3.94E-06,0.00037102,-0.41822,2.81E-05,0.24346,-0.17213,-0.16267},
      {3.46E-05,-5.10E-06,0.27227,-1.13E-05,9.41E-06,-0.50038,1.98E-05,0.19352,-0.13683,-0.23027},
      {2.05E-05,-1.29E-05,0.1968,-2.67E-05,8.35E-06,-0.58647,3.39E-06,0.14079,-0.099561,-0.30165},
      {8.94E-06,-2.26E-05,0.12498,-4.53E-05,7.12E-06,-0.66839,-1.19E-05,0.090603,-0.064094,-0.36957},
      {1.92E-06,-3.44E-05,0.063892,-6.60E-05,6.22E-06,-0.73759,-2.50E-05,0.048193,-0.034124,-0.42695},
      {9.30E-07,-4.77E-05,0.037729,-8.17E-05,8.56E-06,-0.76473,-3.44E-05,0.03154,-0.022358,-0.44945},
      {6.15E-07,-6.23E-05,0.015211,-9.93E-05,1.32E-05,-0.78749,-4.35E-05,0.017566,-0.012489,-0.46833},
      {7.61E-07,-7.70E-05,-0.0037072,-0.00012168,2.07E-05,-0.80579,-5.37E-05,0.0063093,-0.004544,-0.48352},
      {7.73E-07,-0.00010113,-0.010765,-0.00011511,5.89E-05,-0.80031,-7.04E-05,0.0096149,-0.0068625,-0.47903},
      {7.92E-07,-0.00012365,-0.016891,-0.00010081,9.99E-05,-0.7949,-8.60E-05,0.012885,-0.009149,-0.47461},
      {8.12E-07,-0.00014406,-0.022208,-7.83E-05,0.00014132,-0.79009,-0.00010031,0.015807,-0.011182,-0.47067},
      {0,0,0.70711,0,2.49E-07,1.44E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.57E-07,2.64E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.74E-07,4.47E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.20E-06,6.95E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.74E-06,1.01E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.38E-06,1.38E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.11E-06,1.80E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.90E-06,2.25E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.73E-06,2.73E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.56E-06,3.21E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.36E-06,3.67E-06,0,0.5,-0.35355,0.18463},
      {5.16E-07,0,0.7045,0,0.0025986,0.0015003,3.65E-07,0.49816,-0.35225,0.18215},
      {1.76E-06,0,0.69866,0,0.0084132,0.0048573,1.25E-06,0.49405,-0.34935,0.17658},
      {3.11E-06,0,0.69304,0,0.014018,0.008093,2.20E-06,0.49009,-0.34654,0.17122},
      {4.52E-06,0,0.68781,0,0.019227,0.011101,3.19E-06,0.4864,-0.34394,0.16623},
      {5.94E-06,0,0.68317,0,0.023846,0.013768,4.20E-06,0.48313,-0.34162,0.16181},
      {1.12E-05,0,0.65489,0,0.020648,-0.024368,7.89E-06,0.46317,-0.3275,0.13478},
      {1.82E-05,0,0.60789,0,0.013792,-0.090423,1.29E-05,0.42999,-0.30404,0.089855},
      {2.44E-05,0,0.55427,0,0.0076945,-0.16284,1.73E-05,0.3921,-0.27725,0.038569},
      {2.93E-05,0,0.49341,0,0.0025583,-0.24195,2.07E-05,0.3491,-0.24684,-0.019651},
      {2.90E-05,-7.43E-07,0.43188,-1.66E-06,0.0010214,-0.31555,1.99E-05,0.30566,-0.21612,-0.078473},
      {2.58E-05,-2.02E-06,0.36816,-4.41E-06,0.00049443,-0.38993,1.67E-05,0.26067,-0.18431,-0.13939},
      {2.07E-05,-3.71E-06,0.30064,-7.94E-06,0.0001432,-0.46843,1.18E-05,0.21297,-0.15058,-0.20397},
      {1.21E-05,-8.20E-06,0.23048,-1.68E-05,1.93E-06,-0.54934,2.56E-06,0.16356,-0.11566,-0.27086},
      {2.32E-06,-1.96E-05,0.16408,-3.88E-05,1.31E-06,-0.62501,-1.23E-05,0.11719,-0.082893,-0.3336},
      {8.20E-08,-3.28E-05,0.10308,-6.63E-05,1.68E-06,-0.69442,-2.31E-05,0.074636,-0.052826,-0.39115},
      {1.10E-07,-4.73E-05,0.046749,-9.97E-05,2.71E-06,-0.75845,-3.34E-05,0.035368,-0.025085,-0.44424},
      {2.73E-07,-6.15E-05,0.027694,-0.00012171,9.42E-06,-0.77699,-4.32E-05,0.02397,-0.01704,-0.45962},
      {3.99E-07,-7.68E-05,0.01121,-0.00014593,1.73E-05,-0.79245,-5.39E-05,0.014448,-0.010324,-0.47245},
      {4.87E-07,-9.34E-05,-0.0025943,-0.00017285,2.65E-05,-0.80475,-6.56E-05,0.0068539,-0.0049723,-0.48266},
      {5.32E-07,-0.00011387,-0.0094064,-0.00016354,5.87E-05,-0.80286,-7.99E-05,0.0079772,-0.0057469,-0.48114},
      {5.54E-07,-0.00013344,-0.014182,-0.00014339,9.66E-05,-0.79844,-9.36E-05,0.010656,-0.0076107,-0.47753},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.82E-07,1.63E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.79E-07,3.92E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.10E-06,6.38E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.54E-06,8.90E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.97E-06,1.14E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.36E-06,1.36E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,2.71E-06,1.56E-06,0,0.5,-0.35355,0.18463},
      {5.69E-08,0,0.70692,0,0.0001843,0.00010641,4.03E-08,0.49987,-0.35346,0.18446},
      {1.29E-06,0,0.70312,0,0.0039695,0.0022918,9.12E-07,0.49719,-0.35157,0.18084},
      {2.46E-06,0,0.69978,0,0.0073055,0.0042179,1.74E-06,0.49483,-0.3499,0.17764},
      {3.50E-06,0,0.69706,0,0.010016,0.0057826,2.48E-06,0.49292,-0.34854,0.17505},
      {4.34E-06,0,0.69515,0,0.011915,0.0068789,3.07E-06,0.49157,-0.34759,0.17323},
      {6.66E-06,0,0.67071,0,0.010431,-0.023886,4.71E-06,0.4743,-0.33538,0.14985},
      {9.96E-06,0,0.61127,0,0.006148,-0.099894,7.04E-06,0.4323,-0.30568,0.09298},
      {1.10E-05,0,0.5446,0,0.0028353,-0.1826,7.77E-06,0.38517,-0.27235,0.029164},
      {9.02E-06,0,0.47012,0,0.00068784,-0.27231,6.38E-06,0.33251,-0.23511,-0.042138},
      {2.95E-06,-1.16E-06,0.39907,-2.42E-06,6.61E-05,-0.35538,1.27E-06,0.2823,-0.19962,-0.11012},
      {0,-3.55E-06,0.33208,-7.55E-06,0,-0.43276,-2.51E-06,0.23498,-0.16616,-0.17419},
      {0,-6.79E-06,0.26287,-1.49E-05,0,-0.51258,-4.80E-06,0.18608,-0.13159,-0.24037},
      {4.41E-09,-1.23E-05,0.19315,-2.76E-05,1.24E-07,-0.59287,-8.70E-06,0.1369,-0.096822,-0.30694},
      {3.15E-08,-2.66E-05,0.13717,-6.02E-05,1.04E-06,-0.65649,-1.88E-05,0.097877,-0.069257,-0.3597},
      {5.36E-08,-4.22E-05,0.084758,-9.79E-05,2.09E-06,-0.71607,-2.98E-05,0.061329,-0.043443,-0.4091},
      {7.02E-08,-5.90E-05,0.036594,-0.00014087,3.28E-06,-0.77081,-4.17E-05,0.027732,-0.019721,-0.45449},
      {1.58E-07,-7.46E-05,0.018349,-0.00017182,1.05E-05,-0.78878,-5.26E-05,0.016665,-0.011918,-0.4694},
      {2.29E-07,-9.18E-05,0.0070399,-0.00021101,1.93E-05,-0.79846,-6.47E-05,0.010663,-0.0077046,-0.47744},
      {2.68E-07,-0.00011159,-0.0021129,-0.00026466,2.87E-05,-0.80583,-7.87E-05,0.0060489,-0.0044859,-0.48356},
      {2.83E-07,-0.00013189,-0.007675,-0.00027549,5.63E-05,-0.80551,-9.30E-05,0.0061876,-0.0045846,-0.48333},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.81E-08,3.36E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.37E-07,1.37E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.02E-07,2.32E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.40E-07,3.12E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.40E-07,3.70E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.93E-07,4.00E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.92E-07,3.99E-07,0,0.5,-0.35355,0.18464},
      {4.54E-07,0,0.70606,0,0.0010417,0.00060145,3.21E-07,0.49926,-0.35303,0.18364},
      {8.62E-07,0,0.70517,0,0.0019254,0.0011117,6.09E-07,0.49864,-0.35259,0.18279},
      {9.08E-07,0,0.70512,0,0.0019712,0.0011381,6.42E-07,0.49861,-0.35257,0.18275},
      {4.76E-07,0,0.70609,0,0.0010039,0.00057958,3.37E-07,0.49929,-0.35305,0.18368},
      {0,0,0.68985,0,0,-0.01991,0,0.48781,-0.34493,0.16813},
      {0,0,0.61649,0,0,-0.10461,0,0.43594,-0.30826,0.097901},
      {0,0,0.53719,0,0,-0.19616,0,0.37988,-0.26861,0.021987},
      {0,0,0.45164,0,0,-0.29494,0,0.31939,-0.22584,-0.059912},
      {0,-1.67E-06,0.37185,-3.83E-06,0,-0.38703,-1.18E-06,0.26299,-0.18596,-0.13627},
      {0,-5.94E-06,0.30237,-1.39E-05,0,-0.46717,-4.20E-06,0.21389,-0.15126,-0.20272},
      {0,-1.15E-05,0.22844,-2.71E-05,0,-0.55243,-8.10E-06,0.16166,-0.11433,-0.27342},
      {0,-1.85E-05,0.15116,-4.42E-05,0,-0.64157,-1.31E-05,0.10705,-0.075728,-0.34732},
      {1.69E-08,-3.43E-05,0.10365,-8.52E-05,1.01E-06,-0.69558,-2.42E-05,0.0739,-0.052323,-0.39211},
      {2.87E-08,-5.04E-05,0.062212,-0.00012963,2.03E-06,-0.74269,-3.56E-05,0.044974,-0.031906,-0.43117},
      {3.56E-08,-6.68E-05,0.027072,-0.00017747,3.05E-06,-0.78266,-4.72E-05,0.020417,-0.014581,-0.46432},
      {7.17E-08,-8.55E-05,0.011208,-0.00023054,9.44E-06,-0.79864,-6.04E-05,0.010536,-0.0076378,-0.47758},
      {9.96E-08,-0.00010757,0.0037309,-0.00029906,1.87E-05,-0.80431,-7.60E-05,0.0069415,-0.0051536,-0.48229},
      {1.00E-07,-0.00013291,-0.0019568,-0.00038669,2.83E-05,-0.80822,-9.39E-05,0.0043956,-0.0034283,-0.48555},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,8.60E-09,4.96E-09,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.04E-08,1.18E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.61E-08,9.30E-09,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70167,0,0,-0.0062753,0,0.49616,-0.35084,0.17943},
      {0,0,0.61822,0,0,-0.10263,0,0.43715,-0.30911,0.099543},
      {0,0,0.52735,0,0,-0.20755,0,0.3729,-0.26368,0.012543},
      {0,0,0.42862,0,0,-0.32155,0,0.30309,-0.21432,-0.081976},
      {0,-1.97E-06,0.33343,-4.72E-06,0,-0.43142,-1.39E-06,0.2358,-0.16674,-0.17308},
      {0,-9.14E-06,0.25965,-2.19E-05,0,-0.51652,-6.46E-06,0.18366,-0.12988,-0.24364},
      {0,-1.79E-05,0.18422,-4.29E-05,0,-0.60352,-1.26E-05,0.13035,-0.092204,-0.31577},
      {0,-2.84E-05,0.10777,-6.80E-05,0,-0.6917,-2.01E-05,0.076303,-0.054009,-0.38889},
      {6.66E-09,-4.37E-05,0.067843,-0.00011125,7.95E-07,-0.73727,-3.09E-05,0.048326,-0.034261,-0.42668},
      {1.09E-08,-5.98E-05,0.039515,-0.00016004,1.71E-06,-0.76949,-4.23E-05,0.028515,-0.020293,-0.45339},
      {1.15E-08,-7.63E-05,0.016791,-0.00021169,2.59E-06,-0.79537,-5.39E-05,0.012579,-0.0090681,-0.47486},
      {1.58E-08,-9.74E-05,0.0051429,-0.00028388,7.78E-06,-0.80732,-6.89E-05,0.0051389,-0.0038689,-0.48477},
      {8.18E-09,-0.00012531,0.00082682,-0.00038895,1.71E-05,-0.80995,-8.86E-05,0.0033522,-0.0026966,-0.48696},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.62021,0,0,-0.10033,0,0.43856,-0.31011,0.10145},
      {0,0,0.51585,0,0,-0.22084,0,0.36477,-0.25793,0.00153},
      {0,0,0.40311,0,0,-0.35101,0,0.28505,-0.20156,-0.1064},
      {0,-1.61E-06,0.29045,-3.82E-06,0,-0.48107,-1.14E-06,0.2054,-0.14524,-0.21425},
      {0,-1.22E-05,0.21752,-2.88E-05,0,-0.5652,-8.61E-06,0.15384,-0.1088,-0.284},
      {0,-2.46E-05,0.14434,-5.80E-05,0,-0.6496,-1.74E-05,0.1021,-0.072242,-0.35399},
      {0,-3.91E-05,0.071626,-9.17E-05,0,-0.73348,-2.77E-05,0.050681,-0.035909,-0.42353},
      {1.01E-09,-5.51E-05,0.035303,-0.00013771,5.58E-07,-0.77515,-3.90E-05,0.025087,-0.017849,-0.45808},
      {1.48E-10,-7.13E-05,0.018405,-0.00018984,1.31E-06,-0.79442,-5.04E-05,0.013201,-0.0094891,-0.47406},
      {0,-8.52E-05,0.0079458,-0.00023847,1.89E-06,-0.80626,-6.03E-05,0.0058717,-0.0043478,-0.48388},
      {0,-0.00010323,0.0018862,-0.00030962,5.14E-06,-0.81233,-7.30E-05,0.0020364,-0.001698,-0.48892},
      {-0.35433,0.0068585,0.00053109,-0.18513,0.0004257,-0.00058895,0.33537,-0.132,0.1627,0.18241},
      {-0.33198,0.0073625,0.00036041,-0.22048,0.00049249,-0.00044038,0.31124,-0.15771,0.12666,0.18255},
      {-0.30104,0.00795,9.66E-05,-0.2722,0.0006033,-0.00020125,0.27631,-0.19552,0.073687,0.18277},
      {-0.26391,0.0084842,-0.00027321,-0.33897,0.00077541,0.00013361,0.23184,-0.24468,0.0048564,0.18307},
      {-0.20169,0.0079179,-0.00050911,-0.4202,0.00099877,-9.94E-05,0.17547,-0.30476,-0.080023,0.18275},
      {-0.13106,0.0080995,-0.00076533,-0.49384,0.0025478,-0.00032566,0.11775,-0.36129,-0.16152,0.1804},
      {-0.078658,0.013714,-0.0016782,-0.52707,0.01051,0.0036225,0.069134,-0.39585,-0.21632,0.17225},
      {-0.042128,0.016837,-0.0026529,-0.54333,0.020492,0.0094282,0.031043,-0.42316,-0.26169,0.16281},
      {-0.018805,0.017767,-0.0037242,-0.53643,0.029205,0.015515,0.0073149,-0.43992,-0.29144,0.15539},
      {-0.0051322,0.022919,-0.0060232,-0.49231,0.045346,0.025909,-0.0072862,-0.43228,-0.2936,0.14077},
      {-0.0022088,0.036074,-0.011483,-0.39122,0.091649,0.052657,-0.021273,-0.38514,-0.2622,0.096301},
      {-0.00052389,0.038876,-0.016351,-0.28912,0.13715,0.079055,-0.026704,-0.3452,-0.23956,0.052752},
      {2.06E-05,0.031711,-0.020801,-0.18433,0.181,0.10454,-0.02407,-0.31276,-0.22595,0.010892},
      {-0.00011337,0.024976,-0.02546,-0.099847,0.22903,0.13228,-0.02014,-0.27631,-0.20896,-0.035068},
      {-2.66E-05,0.027415,-0.028374,-0.028722,0.28694,0.16558,-0.021285,-0.23062,-0.17859,-0.090639},
      {4.88E-05,0.027926,-0.02911,0.040163,0.34729,0.20038,-0.02101,-0.1887,-0.14905,-0.14847},
      {9.18E-05,0.02512,-0.028024,0.099939,0.40763,0.23524,-0.018559,-0.15196,-0.12262,-0.20619},
      {7.91E-05,0.019222,-0.027072,0.10881,0.45073,0.26008,-0.014125,-0.12812,-0.10757,-0.24739},
      {4.97E-05,0.013324,-0.027775,0.090633,0.48875,0.28195,-0.0097984,-0.10473,-0.094857,-0.28373},
      {4.23E-05,0.011404,-0.032744,0.071211,0.52237,0.30136,-0.0083741,-0.075468,-0.080159,-0.31585},
      {3.42E-05,0.0090588,-0.039393,0.047346,0.55907,0.32255,-0.0066892,-0.041886,-0.064266,-0.35093},
      {2.23E-05,0.0069039,-0.049034,0.033179,0.57608,0.33235,-0.0051422,-0.017816,-0.057992,-0.36719},
      {9.81E-06,0.0051122,-0.059412,0.027719,0.57814,0.33353,-0.0038319,-0.0030339,-0.058855,-0.36914},
      {2.07E-07,0.0033728,-0.067303,0.019562,0.58463,0.33728,-0.00255,0.011378,-0.05747,-0.37532},
      {6.92E-06,0.0026081,-0.074922,0.010018,0.59067,0.34077,-0.0019867,0.025863,-0.055243,-0.3811},
      {2.97E-05,0.0016488,-0.081003,-0.0020139,0.59963,0.34595,-0.0012765,0.040106,-0.051739,-0.38967},
      {0.00012876,0.00079068,-0.089356,-0.0012611,0.59401,0.34275,-0.00056981,0.047345,-0.055374,-0.38425},
      {0.00027995,0.00048543,-0.098849,0.00038748,0.58775,0.33919,-0.00022207,0.056175,-0.058718,-0.37821},
      {0.00048272,0.0001683,-0.10374,0.00036932,0.5876,0.33916,0.00017488,0.062833,-0.058976,-0.37803},
      {0.0006497,-8.76E-06,-0.10623,-0.0014499,0.59149,0.34144,0.00043984,0.069039,-0.0571,-0.38171},
      {0.00067236,-7.14E-06,-0.11364,-0.0031307,0.589,0.34002,0.00046223,0.077745,-0.058345,-0.37931},
      {0.00063289,-5.00E-06,-0.12163,-0.0022538,0.5821,0.33605,0.00043937,0.084108,-0.061846,-0.3727},
      {-0.2858,0.008895,0.001079,-0.18054,0.00052179,-0.0006488,0.32437,-0.12861,0.16545,0.18158},
      {-0.2794,0.010613,0.0005852,-0.20854,0.00059414,-0.00060413,0.30484,-0.14927,0.13718,0.18177},
      {-0.25067,0.011043,0.00031921,-0.25889,0.00070929,-0.00034205,0.27106,-0.18624,0.085422,0.18201},
      {-0.21546,0.011468,-4.79E-05,-0.3233,0.00088786,5.77E-06,0.22821,-0.23384,0.01877,0.18233},
      {-0.17634,0.013222,-0.00060425,-0.39455,0.0016418,0.00068167,0.17853,-0.28749,-0.056727,0.18216},
      {-0.11967,0.021454,-0.0014228,-0.44001,0.0064063,0.0027966,0.12491,-0.32656,-0.11569,0.1771},
      {-0.066492,0.027858,-0.0022011,-0.47121,0.013315,0.0062956,0.077218,-0.35923,-0.16698,0.17006},
      {-0.028252,0.030375,-0.0030356,-0.49262,0.021942,0.011337,0.037163,-0.39022,-0.21657,0.16192},
      {-0.0075769,0.027986,-0.0043876,-0.4911,0.032619,0.018261,0.0063202,-0.41909,-0.26493,0.1525},
      {-0.0052338,0.040162,-0.0091036,-0.42311,0.067851,0.038758,-0.018467,-0.39808,-0.2624,0.11893},
      {-0.0020565,0.05245,-0.014173,-0.33149,0.10997,0.063125,-0.032241,-0.35551,-0.23445,0.078483},
      {-0.0001638,0.054497,-0.018704,-0.23754,0.15199,0.087548,-0.037465,-0.31939,-0.21471,0.038276},
      {0.00054949,0.046669,-0.022859,-0.13977,0.19296,0.1114,-0.034625,-0.29018,-0.20354,-0.00081133},
      {7.46E-05,0.034545,-0.029109,-0.080919,0.24548,0.14183,-0.026899,-0.25318,-0.19063,-0.050877},
      {6.64E-06,0.033188,-0.03223,-0.014909,0.30275,0.17482,-0.025397,-0.21074,-0.16481,-0.10576},
      {8.12E-05,0.033535,-0.03269,0.049398,0.35987,0.20773,-0.025016,-0.17132,-0.13704,-0.16051},
      {0.00012376,0.030584,-0.031357,0.1054,0.41752,0.24102,-0.02247,-0.1367,-0.11208,-0.21568},
      {0.0001029,0.024239,-0.0308,0.10162,0.45343,0.26165,-0.017738,-0.11724,-0.10102,-0.25001},
      {6.52E-05,0.016379,-0.030379,0.083188,0.49386,0.2849,-0.011998,-0.095182,-0.089136,-0.28865},
      {4.83E-05,0.012577,-0.034034,0.063662,0.53009,0.30581,-0.0092243,-0.067307,-0.075074,-0.32326},
      {4.06E-05,0.010205,-0.040924,0.041102,0.56554,0.32627,-0.0075295,-0.03428,-0.059821,-0.35714},
      {2.76E-05,0.0079288,-0.051599,0.030925,0.57594,0.33225,-0.0058924,-0.013503,-0.056975,-0.36708},
      {1.50E-05,0.0059466,-0.062459,0.025626,0.57741,0.33308,-0.0044481,0.0014074,-0.058326,-0.36846},
      {5.16E-06,0.0040449,-0.070802,0.017637,0.58333,0.33651,-0.0030521,0.015944,-0.057385,-0.3741},
      {6.62E-06,0.0027285,-0.077631,0.0075257,0.59119,0.34106,-0.0020836,0.030164,-0.054844,-0.38161},
      {3.30E-05,0.0016959,-0.084711,-0.002267,0.59691,0.34437,-0.0013165,0.043478,-0.053032,-0.38708},
      {0.00012831,0.00088644,-0.094459,-0.0012598,0.58973,0.34027,-0.00064748,0.051622,-0.0574,-0.38016},
      {0.00027599,0.00057358,-0.1047,0.00026127,0.58269,0.33626,-0.00029612,0.060947,-0.061147,-0.37338},
      {0.00047554,0.00024849,-0.11028,0.00014592,0.58182,0.33581,0.00010493,0.068054,-0.061783,-0.37249},
      {0.00069876,-9.34E-06,-0.11116,-0.0019591,0.58732,0.33903,0.0004737,0.073106,-0.059132,-0.37773},
      {0.00072755,-7.61E-06,-0.11958,-0.0030714,0.58306,0.33659,0.00050059,0.081975,-0.061258,-0.37363},
      {0.00069095,-5.39E-06,-0.12787,-0.0022122,0.57583,0.33243,0.0004799,0.088549,-0.064922,-0.3667},
      {-0.15253,0.0094141,0.0028579,-0.16827,0.00054252,-0.00040055,0.30832,-0.11889,0.17419,0.18019},
      {-0.15565,0.012192,0.0020966,-0.19121,0.00061996,-0.00043946,0.29136,-0.13605,0.15138,0.18043},
      {-0.15755,0.01743,0.00091114,-0.22218,0.00089568,-0.00036163,0.26639,-0.15945,0.12031,0.18064},
      {-0.12391,0.022852,0.00037706,-0.26612,0.0021879,0.00072629,0.22803,-0.19321,0.07208,0.17979},
      {-0.087556,0.03083,-0.00037595,-0.31212,0.0047359,0.0024501,0.18214,-0.23021,0.018418,0.17771},
      {-0.054075,0.0415,-0.0013944,-0.35734,0.0086462,0.0048381,0.13092,-0.26892,-0.038306,0.17436},
      {-0.028203,0.053146,-0.0026685,-0.40146,0.013996,0.0079036,0.077011,-0.31033,-0.099365,0.16969},
      {0.0069514,0.052434,-0.0035671,-0.42396,0.021954,0.012392,0.035413,-0.34645,-0.15612,0.16202},
      {0.016058,0.057818,-0.006539,-0.40229,0.04325,0.024687,1.40E-09,-0.35737,-0.18802,0.14171},
      {0.0079704,0.070692,-0.012055,-0.33344,0.084938,0.048581,-0.030717,-0.33834,-0.19284,0.10177},
      {-0.0011552,0.080233,-0.018161,-0.24743,0.13481,0.077329,-0.051748,-0.31155,-0.19184,0.054238},
      {0.00088385,0.080501,-0.022163,-0.16466,0.17249,0.099305,-0.055976,-0.2808,-0.17639,0.01823},
      {0.001358,0.07169,-0.027071,-0.091824,0.21094,0.12171,-0.052222,-0.25339,-0.16787,-0.018398},
      {0.00062353,0.059693,-0.033627,-0.047711,0.26044,0.15038,-0.044329,-0.21858,-0.1569,-0.065569},
      {0.00014335,0.046238,-0.037808,0.0050822,0.32108,0.1855,-0.034619,-0.18142,-0.14225,-0.1234},
      {0.00013525,0.042546,-0.03827,0.061515,0.3773,0.21791,-0.031441,-0.14536,-0.11913,-0.17722},
      {0.00016835,0.038981,-0.036906,0.10288,0.42628,0.24614,-0.028495,-0.11677,-0.099048,-0.22411},
      {0.00014141,0.031971,-0.036673,0.091482,0.45632,0.26335,-0.023298,-0.1012,-0.091573,-0.25283},
      {0.00010457,0.02371,-0.036263,0.074361,0.49551,0.28587,-0.017264,-0.0803,-0.080729,-0.29028},
      {5.76E-05,0.01433,-0.035929,0.052769,0.54153,0.31241,-0.010493,-0.055233,-0.06753,-0.33423},
      {5.10E-05,0.011929,-0.043431,0.032011,0.57498,0.3317,-0.0087966,-0.022745,-0.053272,-0.3662},
      {3.57E-05,0.0093954,-0.055995,0.02755,0.57525,0.33181,-0.0069701,-0.0066491,-0.055762,-0.36644},
      {2.28E-05,0.0071458,-0.067608,0.022513,0.57579,0.33211,-0.005338,0.0084821,-0.057842,-0.36694},
      {1.28E-05,0.0050147,-0.076648,0.014793,0.58083,0.33503,-0.0037809,0.023226,-0.057566,-0.37175},
      {5.89E-06,0.0028816,-0.08211,0.0039774,0.59143,0.34117,-0.0022103,0.03681,-0.054538,-0.38186},
      {3.54E-05,0.0017357,-0.090875,-0.0026637,0.59225,0.34166,-0.0013567,0.048956,-0.055293,-0.38263},
      {0.00012513,0.0010317,-0.10286,-0.0013004,0.58259,0.33613,-0.00076749,0.05858,-0.060801,-0.37334},
      {0.00026768,0.00070579,-0.11424,4.56E-05,0.57436,0.33144,-0.00040929,0.068652,-0.065166,-0.36541},
      {0.00046251,0.00036741,-0.12086,-0.00020287,0.57237,0.33035,-9.68E-07,0.076434,-0.066377,-0.36346},
      {0.00070928,6.38E-05,-0.12165,-0.0024858,0.57792,0.3336,0.00042088,0.081351,-0.063737,-0.36873},
      {0.00081564,-8.31E-06,-0.12899,-0.0029832,0.57362,0.33115,0.00056192,0.088684,-0.065884,-0.3646},
      {0.00078308,-5.98E-06,-0.13775,-0.0021507,0.56591,0.3267,0.0005443,0.095572,-0.069788,-0.3572},
      {0.053222,0.010074,0.0074226,-0.10875,0.00052401,0.00066586,0.30234,-0.073225,0.22691,0.17771},
      {0.05272,0.014587,0.0066919,-0.12417,0.00084702,0.00087655,0.28667,-0.085133,0.2111,0.17767},
      {0.053569,0.02194,0.005535,-0.14624,0.0014234,0.0012584,0.26271,-0.10236,0.18832,0.17753},
      {0.05656,0.032792,0.003861,-0.1743,0.0023383,0.0018611,0.2299,-0.1246,0.15911,0.17719},
      {0.062081,0.047564,0.0015879,-0.20738,0.0036485,0.0027039,0.18795,-0.15136,0.12429,0.17659},
      {0.078163,0.054182,0.00041759,-0.25672,0.0071164,0.0048285,0.13565,-0.19425,0.062385,0.17345},
      {0.088572,0.061984,-0.00099751,-0.30564,0.012252,0.0077817,0.080349,-0.24191,-0.0072,0.16895},
      {0.066015,0.081747,-0.0043708,-0.32062,0.025898,0.015169,0.0263,-0.26923,-0.055063,0.15642},
      {0.043516,0.10335,-0.0088888,-0.29951,0.050234,0.028724,-0.021221,-0.27666,-0.083562,0.13351},
      {0.033343,0.11133,-0.013579,-0.24564,0.087118,0.04997,-0.051027,-0.2683,-0.099326,0.098292},
      {0.020852,0.11666,-0.019209,-0.17233,0.13437,0.077282,-0.072327,-0.25222,-0.11094,0.053411},
      {0.0066275,0.1179,-0.025716,-0.08202,0.19093,0.11,-0.083111,-0.23031,-0.12038,-0.00011414},
      {0.0020948,0.10751,-0.034475,-0.049984,0.22906,0.13208,-0.07738,-0.20444,-0.1211,-0.036237},
      {0.0011492,0.095964,-0.04016,-0.0094377,0.27091,0.15629,-0.069815,-0.17631,-0.11406,-0.076133},
      {0.0005789,0.081293,-0.043748,0.033272,0.3257,0.18803,-0.059431,-0.14471,-0.10356,-0.12833},
      {0.00028076,0.061524,-0.04542,0.076153,0.39189,0.22639,-0.044981,-0.11172,-0.092303,-0.19139},
      {0.00022389,0.050247,-0.045253,0.089002,0.4293,0.24792,-0.03659,-0.094541,-0.085886,-0.22709},
      {0.00019847,0.042711,-0.045056,0.07915,0.45802,0.26435,-0.031007,-0.080251,-0.079627,-0.25454},
      {0.000163,0.033988,-0.044662,0.063438,0.49599,0.28616,-0.024634,-0.060528,-0.06988,-0.29081},
      {0.00011446,0.02365,-0.044789,0.04339,0.54102,0.31209,-0.017194,-0.036175,-0.058127,-0.33382},
      {6.32E-05,0.014118,-0.04887,0.025575,0.57726,0.33297,-0.010405,-0.011756,-0.049801,-0.36844},
      {4.68E-05,0.011211,-0.062997,0.02311,0.57326,0.33061,-0.0083132,0.0032659,-0.054802,-0.3646},
      {3.36E-05,0.0086407,-0.075657,0.018458,0.57251,0.33016,-0.0064562,0.018742,-0.057845,-0.36386},
      {2.33E-05,0.0062312,-0.085658,0.011122,0.57636,0.33238,-0.0047039,0.033798,-0.058448,-0.36752},
      {1.55E-05,0.003816,-0.091867,0.00063355,0.58606,0.33801,-0.0029338,0.047604,-0.056153,-0.37677},
      {3.32E-05,0.0017256,-0.10029,-0.003218,0.58488,0.33739,-0.0013697,0.057084,-0.058953,-0.37559},
      {0.00011582,0.0012265,-0.11556,-0.0014287,0.5716,0.32977,-0.0009329,0.068933,-0.066072,-0.36283},
      {0.0002518,0.00088013,-0.12847,-0.00028455,0.56175,0.32415,-0.000563,0.08,-0.071278,-0.35335},
      {0.00044057,0.00052154,-0.13649,-0.00068542,0.55826,0.32219,-0.00014284,0.088682,-0.073272,-0.34996},
      {0.00068171,0.00019782,-0.13858,-0.0030766,0.5624,0.32463,0.00029105,0.094418,-0.071364,-0.35388},
      {0.0009433,-9.27E-06,-0.14254,-0.0028677,0.56004,0.3233,0.00065097,0.098337,-0.072547,-0.35159},
      {0.00091559,-6.77E-06,-0.1519,-0.0020707,0.55169,0.31849,0.00063704,0.10563,-0.076763,-0.34359},
      {0.24764,0.0031146,0.028747,-0.059895,-0.00048498,0.0015718,0.27799,-0.02373,0.25214,0.17548},
      {0.25229,0.0041406,0.024393,-0.064645,-0.00062809,0.0018231,0.26762,-0.03026,0.25149,0.17536},
      {0.2616,0.0055078,0.017352,-0.071309,-0.00084714,0.0022259,0.25177,-0.040113,0.25142,0.17513},
      {0.26146,0.01203,0.012653,-0.094339,-0.00036953,0.0028631,0.22029,-0.060941,0.23043,0.17459},
      {0.25382,0.024161,0.0099889,-0.13053,0.00089717,0.0037058,0.17556,-0.090856,0.1918,0.17374},
      {0.21875,0.040776,0.0063606,-0.15999,0.0033264,0.0047857,0.13233,-0.11702,0.15885,0.17216},
      {0.18604,0.061319,0.0019158,-0.18359,0.0076911,0.0068574,0.084877,-0.14126,0.12783,0.16881},
      {0.14894,0.082177,-0.0017136,-0.19847,0.02247,0.014893,0.030843,-0.16925,0.07874,0.15539},
      {0.10925,0.11383,-0.0066756,-0.1952,0.043836,0.026497,-0.027095,-0.18902,0.03687,0.13603},
      {0.06805,0.15661,-0.012884,-0.17271,0.071798,0.041659,-0.086641,-0.20028,0.00295,0.11085},
      {0.050364,0.16225,-0.018209,-0.11139,0.11591,0.067151,-0.10962,-0.19305,-0.017985,0.069279},
      {0.025794,0.1606,-0.029027,-0.066895,0.16663,0.096139,-0.11587,-0.17706,-0.041535,0.021375},
      {0.0085339,0.15517,-0.040585,-0.015351,0.22025,0.1269,-0.11331,-0.15505,-0.059281,-0.029155},
      {0.0015431,0.14502,-0.048992,0.025795,0.27016,0.15568,-0.10486,-0.12903,-0.063676,-0.076134},
      {0.00094415,0.12927,-0.051702,0.058715,0.32029,0.18475,-0.093803,-0.1025,-0.056574,-0.12384},
      {0.00060427,0.1064,-0.053455,0.08276,0.37416,0.21594,-0.077205,-0.079943,-0.054576,-0.17506},
      {0.00037527,0.075334,-0.055802,0.076084,0.41768,0.24109,-0.05459,-0.069288,-0.065702,-0.21627},
      {0.0002793,0.056788,-0.056353,0.065696,0.4568,0.26365,-0.041085,-0.054799,-0.065727,-0.25348},
      {0.00024566,0.047591,-0.055977,0.051229,0.4939,0.28493,-0.034364,-0.036021,-0.056917,-0.28891},
      {0.00020053,0.036456,-0.058568,0.033825,0.53469,0.30835,-0.026406,-0.011656,-0.047996,-0.32788},
      {0.00012351,0.02324,-0.064848,0.023561,0.55817,0.32181,-0.01698,0.0041919,-0.049818,-0.35031},
      {6.10E-05,0.013226,-0.073713,0.017816,0.56884,0.32798,-0.0098209,0.016902,-0.05481,-0.36043},
      {4.74E-05,0.010317,-0.087719,0.013688,0.56644,0.32657,-0.0077266,0.032872,-0.059018,-0.35812},
      {3.67E-05,0.0076076,-0.098941,0.0068641,0.56875,0.3279,-0.0057647,0.048362,-0.060684,-0.36031},
      {2.87E-05,0.0049271,-0.10639,-0.0029573,0.57672,0.33253,-0.0038085,0.062503,-0.059522,-0.3679},
      {3.73E-05,0.0023284,-0.1178,-0.0031694,0.56894,0.32813,-0.0018553,0.071124,-0.0662,-0.36038},
      {9.55E-05,0.001465,-0.13385,-0.0016896,0.55544,0.32043,-0.0011435,0.083576,-0.073884,-0.34737},
      {0.00022384,0.0010886,-0.14866,-0.00074245,0.54356,0.31363,-0.00075498,0.095864,-0.080151,-0.33594},
      {0.00040552,0.00070111,-0.15844,-0.00129,0.53818,0.31058,-0.00031679,0.10565,-0.08313,-0.33074},
      {0.0006428,0.00033954,-0.16288,-0.0032988,0.53911,0.31117,0.0001437,0.11243,-0.082873,-0.33159},
      {0.00095174,5.84E-05,-0.16659,-0.0026472,0.53614,0.30949,0.000596,0.11552,-0.084395,-0.32872},
      {0.0010953,-7.74E-06,-0.17103,-0.0019755,0.53246,0.30739,0.0007631,0.11922,-0.086195,-0.32518},
      {0.33399,-0.02122,0.072475,-0.033495,-0.0033029,0.0025304,0.22238,0.025378,0.23244,0.17305},
      {0.3305,-0.020269,0.066598,-0.03738,-0.0034033,0.0027258,0.21398,0.018379,0.23423,0.17296},
      {0.32616,-0.018937,0.057472,-0.042692,-0.0035541,0.0030294,0.20136,0.0080129,0.23767,0.17279},
      {0.32192,-0.017343,0.044711,-0.048831,-0.0037609,0.0034569,0.18442,-0.0055884,0.24366,0.17247},
      {0.31888,-0.015672,0.027945,-0.054986,-0.0040374,0.0040281,0.16319,-0.022132,0.25326,0.17195},
      {0.29511,-0.0018806,0.018283,-0.074501,-0.0020579,0.0051605,0.12608,-0.045017,0.2374,0.17038},
      {0.26093,0.02196,0.012919,-0.097116,0.001964,0.0069377,0.078468,-0.068572,0.20977,0.16765},
      {0.22918,0.050571,0.0064837,-0.11282,0.007085,0.0092758,0.026847,-0.088778,0.1876,0.16394},
      {0.19111,0.08466,0.00016774,-0.11449,0.022562,0.017469,-0.02987,-0.1081,0.15576,0.15052},
      {0.1352,0.13244,-0.0074325,-0.10249,0.051102,0.032487,-0.090277,-0.12504,0.11177,0.12507},
      {0.075277,0.19,-0.01869,-0.084167,0.084209,0.04979,-0.14423,-0.13377,0.071264,0.095383},
      {0.036155,0.22181,-0.030393,-0.046869,0.12644,0.073005,-0.17034,-0.12891,0.040694,0.056647},
      {0.018517,0.21561,-0.040811,-0.00064092,0.17991,0.10373,-0.16622,-0.1111,0.019484,0.0064473},
      {0.0070687,0.2064,-0.051616,0.041684,0.23789,0.13709,-0.15573,-0.086319,0.0055469,-0.047566},
      {0.0012262,0.19184,-0.062207,0.073941,0.29672,0.17092,-0.13894,-0.058418,-0.0037279,-0.10214},
      {0.00091792,0.15995,-0.066227,0.073686,0.33132,0.19071,-0.11559,-0.052494,-0.020504,-0.13489},
      {0.00067699,0.12735,-0.068685,0.066996,0.376,0.21648,-0.091831,-0.042038,-0.032713,-0.1772},
      {0.00048193,0.092548,-0.07016,0.054628,0.43178,0.24883,-0.066639,-0.026593,-0.041353,-0.23003},
      {0.00036125,0.064079,-0.074033,0.040903,0.48303,0.27853,-0.046208,-0.0059306,-0.045251,-0.27867},
      {0.00030422,0.050981,-0.080265,0.02851,0.5129,0.29556,-0.036871,0.014525,-0.043725,-0.30725},
      {0.00021084,0.035674,-0.090627,0.023105,0.52496,0.30234,-0.025953,0.026612,-0.053352,-0.31881},
      {0.00012678,0.022193,-0.098465,0.015913,0.54102,0.31161,-0.016324,0.039146,-0.059206,-0.33409},
      {6.43E-05,0.012036,-0.10529,0.0086091,0.55594,0.32039,-0.0090572,0.051753,-0.062299,-0.34817},
      {5.33E-05,0.0090386,-0.11796,0.0024255,0.55643,0.32067,-0.0068944,0.067803,-0.065162,-0.34862},
      {4.66E-05,0.0060262,-0.13036,-0.0027403,0.55398,0.31929,-0.0046876,0.081333,-0.069554,-0.34624},
      {5.43E-05,0.0037453,-0.14748,-0.0023078,0.5401,0.31137,-0.0029706,0.093935,-0.078958,-0.33285},
      {7.90E-05,0.0020921,-0.16187,-0.0017568,0.52931,0.30529,-0.0016665,0.10527,-0.086215,-0.3224},
      {0.00017796,0.0013153,-0.17644,-0.0013099,0.51809,0.29891,-0.00097805,0.11731,-0.09265,-0.31158},
      {0.000352,0.00088851,-0.18825,-0.0019684,0.51049,0.29458,-0.00051392,0.12837,-0.096798,-0.30424},
      {0.00058576,0.00045159,-0.1961,-0.0029441,0.50621,0.29216,1.02E-06,0.13622,-0.099224,-0.30011},
      {0.00087993,0.00013563,-0.20058,-0.0023677,0.50246,0.29002,0.00047081,0.1398,-0.10119,-0.29649},
      {0.0012215,3.65E-06,-0.19919,-0.001836,0.50431,0.29113,0.00083773,0.13923,-0.10012,-0.29824},
      {0.28855,-0.034689,0.17167,-0.019505,-0.004589,0.0019158,0.16374,0.10604,0.1465,0.17302},
      {0.29511,-0.037508,0.1528,-0.020349,-0.0051082,0.0023517,0.15765,0.091799,0.16474,0.17272},
      {0.30563,-0.04192,0.12346,-0.021547,-0.005906,0.0030024,0.14825,0.069774,0.19307,0.17221},
      {0.30961,-0.042795,0.10004,-0.025187,-0.0063726,0.0036099,0.13308,0.05025,0.21228,0.17165},
      {0.30899,-0.040998,0.080567,-0.030074,-0.0066197,0.0042497,0.11237,0.03262,0.22557,0.17096},
      {0.3097,-0.039343,0.056526,-0.034337,-0.0069931,0.0050796,0.087054,0.012073,0.24355,0.16998},
      {0.31067,-0.037015,0.02865,-0.037819,-0.007321,0.0061755,0.056309,-0.010925,0.26517,0.16855},
      {0.26579,0.00064814,0.021976,-0.053899,-0.001207,0.0082452,0.0020942,-0.031499,0.24058,0.16409},
      {0.21571,0.04781,0.012433,-0.065591,0.0060071,0.011327,-0.055888,-0.050925,0.21801,0.15737},
      {0.16543,0.10322,-0.00026359,-0.069351,0.015856,0.016173,-0.11493,-0.068303,0.19816,0.14766},
      {0.10878,0.16189,-0.011489,-0.049731,0.049226,0.033728,-0.16251,-0.078813,0.15602,0.11796},
      {0.060187,0.22658,-0.024421,-0.021634,0.085873,0.052517,-0.20424,-0.080344,0.12337,0.08692},
      {0.020936,0.29475,-0.038608,0.013579,0.12561,0.072688,-0.23895,-0.072219,0.10171,0.05434},
      {0.010694,0.28032,-0.049656,0.046706,0.18041,0.10387,-0.22219,-0.053712,0.08018,0.003516},
      {0.005307,0.25297,-0.064445,0.059174,0.22579,0.12899,-0.19273,-0.040963,0.048126,-0.038025},
      {0.0017898,0.22463,-0.079978,0.065208,0.27125,0.15504,-0.16358,-0.024457,0.020229,-0.079046},
      {0.0010026,0.19183,-0.085377,0.059367,0.31848,0.18236,-0.13782,-0.01158,0.0048952,-0.12322},
      {0.00079494,0.15314,-0.089275,0.050059,0.37209,0.21343,-0.10988,0.002993,-0.0087555,-0.17395},
      {0.00061194,0.11116,-0.09651,0.036277,0.43285,0.24878,-0.079842,0.02524,-0.021759,-0.23144},
      {0.00040749,0.06504,-0.11428,0.028997,0.46914,0.26984,-0.047045,0.042497,-0.050721,-0.26579},
      {0.00030895,0.048713,-0.12678,0.023002,0.48048,0.27613,-0.035403,0.056401,-0.061717,-0.27672},
      {0.00021982,0.034236,-0.13647,0.015359,0.4959,0.28495,-0.025067,0.070423,-0.068882,-0.29144},
      {0.0001394,0.021302,-0.14228,0.0068491,0.51563,0.29652,-0.015819,0.082938,-0.072436,-0.31009},
      {7.29E-05,0.01042,-0.14458,-0.0016005,0.53733,0.30948,-0.008027,0.093231,-0.073005,-0.33046},
      {6.44E-05,0.0073023,-0.1658,-0.0021676,0.51984,0.29943,-0.0057314,0.10851,-0.085041,-0.31367},
      {7.00E-05,0.005198,-0.18799,-0.0015364,0.50059,0.28844,-0.0041471,0.1246,-0.09695,-0.29513},
      {9.18E-05,0.0033732,-0.20442,-0.001315,0.48777,0.28118,-0.0027149,0.13725,-0.10541,-0.28273},
      {0.00013521,0.0018202,-0.21604,-0.0016874,0.48052,0.27716,-0.0014372,0.14719,-0.11085,-0.27564},
      {0.00027359,0.0010567,-0.22783,-0.0026152,0.47316,0.27301,-0.00071894,0.15805,-0.11532,-0.26852},
      {0.00049858,0.00051423,-0.23867,-0.0025731,0.46407,0.26781,-0.00013056,0.16664,-0.12027,-0.25979},
      {0.00077762,0.00017446,-0.24372,-0.0020747,0.4597,0.26531,0.00034965,0.17058,-0.12259,-0.25557},
      {0.0010977,2.96E-05,-0.24337,-0.0016203,0.46047,0.26579,0.0007149,0.17069,-0.1221,-0.25629},
      {0.21029,-0.039491,0.32678,-0.0097626,-0.0044252,0.001013,0.099842,0.22308,0.0040589,0.17522},
      {0.21843,-0.042529,0.30481,-0.010516,-0.0049629,0.0014077,0.093708,0.20676,0.025128,0.17476},
      {0.22771,-0.046637,0.27296,-0.011582,-0.0057934,0.0018899,0.083587,0.18311,0.055549,0.17393},
      {0.24046,-0.052132,0.22864,-0.012949,-0.0069279,0.0024562,0.069794,0.15032,0.097766,0.1727},
      {0.25727,-0.059392,0.17021,-0.014596,-0.0086251,0.0031869,0.053259,0.1073,0.15301,0.17068},
      {0.25688,-0.058095,0.13434,-0.017914,-0.010047,0.004189,0.030904,0.079026,0.18229,0.16803},
      {0.25039,-0.052591,0.10181,-0.021306,-0.011464,0.0054501,0.0028683,0.052938,0.20689,0.16486},
      {0.24357,-0.045606,0.062199,-0.023923,-0.01325,0.0070623,-0.030162,0.022218,0.23806,0.16092},
      {0.21495,-0.011997,0.035827,-0.028985,-0.0094288,0.0099181,-0.075996,-0.0033654,0.24293,0.15491},
      {0.16961,0.048984,0.021541,-0.032014,0.00028979,0.01383,-0.13169,-0.02121,0.22701,0.14727},
      {0.12497,0.1207,0.004017,-0.028429,0.011674,0.018111,-0.19066,-0.037374,0.21661,0.13916},
      {0.081403,0.19305,-0.011511,-0.0066011,0.040863,0.032127,-0.23529,-0.042746,0.19466,0.1162},
      {0.045179,0.26239,-0.028659,0.016623,0.076002,0.046506,-0.25844,-0.040311,0.16311,0.088182},
      {0.018016,0.32586,-0.048064,0.034892,0.10608,0.058981,-0.27255,-0.03546,0.13496,0.066808},
      {0.0075515,0.32775,-0.064254,0.04728,0.14701,0.080889,-0.25588,-0.024516,0.10614,0.032162},
      {0.0041292,0.29882,-0.079239,0.052463,0.19553,0.10869,-0.2254,-0.0081085,0.077897,-0.011548},
      {0.0020087,0.26322,-0.098441,0.056481,0.24164,0.13605,-0.19194,0.01134,0.046908,-0.052572},
      {0.0011075,0.22337,-0.11415,0.051826,0.29074,0.16525,-0.15984,0.03235,0.022606,-0.097261},
      {0.00084994,0.17035,-0.12991,0.044683,0.33529,0.19048,-0.12197,0.047764,-0.0093215,-0.13991},
      {0.00061997,0.11776,-0.15014,0.034983,0.37802,0.21518,-0.084552,0.068373,-0.041658,-0.18044},
      {0.00042581,0.066464,-0.17449,0.023421,0.41903,0.23956,-0.04822,0.094329,-0.073517,-0.21884},
      {0.00032193,0.046538,-0.18787,0.014403,0.43774,0.25038,-0.034044,0.1119,-0.084574,-0.23659},
      {0.00023689,0.032803,-0.19526,0.0052311,0.45725,0.26174,-0.024225,0.12596,-0.089032,-0.25509},
      {0.0001547,0.019884,-0.20233,-6.82E-05,0.47042,0.26978,-0.014949,0.13543,-0.095998,-0.26729},
      {8.32E-05,0.0092928,-0.21831,-0.0011222,0.46784,0.26919,-0.0073432,0.14782,-0.10861,-0.26406},
      {8.06E-05,0.0065732,-0.24144,-0.00091396,0.44828,0.25808,-0.0053089,0.16451,-0.12136,-0.24517},
      {9.81E-05,0.0045824,-0.2594,-0.00098828,0.43394,0.24996,-0.003748,0.17809,-0.13078,-0.23132},
      {0.00013736,0.0028736,-0.27242,-0.0016274,0.42526,0.24512,-0.0023502,0.18888,-0.13711,-0.22286},
      {0.00020283,0.0013685,-0.28186,-0.0025409,0.42015,0.24233,-0.0010666,0.19726,-0.14145,-0.21782},
      {0.00037237,0.00050421,-0.29192,-0.0022056,0.41135,0.23734,-0.00023925,0.20463,-0.14672,-0.20933},
      {0.00063695,0.00015834,-0.29723,-0.0017834,0.40667,0.23466,0.00024034,0.20868,-0.14922,-0.20482},
      {0.00092111,5.74E-05,-0.29827,-0.0014071,0.40598,0.2343,0.00055607,0.20973,-0.14946,-0.20414},
      {0.10288,-0.028236,0.50243,-0.0040863,-0.0034605,-0.000395,0.046318,0.35194,-0.16195,0.1776},
      {0.1079,-0.03164,0.49106,-0.0041551,-0.0038347,-0.00036688,0.046203,0.3436,-0.151,0.17705},
      {0.11809,-0.036548,0.46081,-0.0048376,-0.0048676,1.72E-05,0.040694,0.3214,-0.12247,0.17572},
      {0.13325,-0.043273,0.41141,-0.0060343,-0.0066497,0.00077246,0.029444,0.28522,-0.076099,0.17349},
      {0.15127,-0.052076,0.35,-0.0073367,-0.0090285,0.0017231,0.014487,0.24036,-0.018488,0.17047},
      {0.17123,-0.063055,0.27782,-0.0085963,-0.012042,0.0028467,-0.0045676,0.18781,0.04916,0.1666},
      {0.18662,-0.071381,0.20649,-0.0099392,-0.015132,0.004152,-0.028825,0.13568,0.11478,0.1622},
      {0.18347,-0.063006,0.16159,-0.011713,-0.016756,0.0058915,-0.060465,0.10163,0.15152,0.15834},
      {0.1802,-0.05346,0.10881,-0.01249,-0.018795,0.0080245,-0.097214,0.06245,0.19573,0.15375},
      {0.17033,-0.032391,0.055805,-0.011753,-0.018812,0.010804,-0.14096,0.023021,0.2366,0.14815},
      {0.12767,0.051481,0.038301,-0.0085249,-0.0064133,0.0099712,-0.1912,0.0084589,0.22158,0.13851},
      {0.089116,0.1442,0.01221,-0.0033127,0.0060298,0.008896,-0.24067,-0.0077798,0.21342,0.13016},
      {0.056527,0.23477,-0.017738,0.0072438,0.024259,0.01228,-0.27994,-0.020116,0.20451,0.11857},
      {0.032105,0.29983,-0.036781,0.024565,0.05491,0.025482,-0.29158,-0.015799,0.17772,0.098226},
      {0.014538,0.35748,-0.057272,0.040329,0.08079,0.038393,-0.29829,-0.0089398,0.15545,0.083533},
      {0.0051201,0.37938,-0.078385,0.053974,0.11066,0.055806,-0.28848,0.0015775,0.13023,0.063765},
      {0.0031146,0.34113,-0.098719,0.057334,0.15831,0.083946,-0.25251,0.021001,0.09647,0.021656},
      {0.0019339,0.28845,-0.13037,0.057061,0.19431,0.10388,-0.2095,0.044055,0.050007,-0.011228},
      {0.0010606,0.23436,-0.16957,0.053553,0.22546,0.12377,-0.16731,0.074479,0.0020392,-0.037654},
      {0.0008209,0.17964,-0.19112,0.041107,0.27158,0.1503,-0.12838,0.097877,-0.030738,-0.081517},
      {0.0006168,0.1262,-0.21667,0.027352,0.31563,0.1763,-0.0905,0.12615,-0.063254,-0.1229},
      {0.00045049,0.073822,-0.24659,0.013543,0.3565,0.20118,-0.053543,0.15889,-0.09627,-0.16072},
      {0.00033703,0.04384,-0.26639,0.0046065,0.37902,0.21499,-0.032337,0.18064,-0.11574,-0.18151},
      {0.00024171,0.029988,-0.28107,0.003202,0.38012,0.21631,-0.022398,0.19152,-0.12977,-0.18195},
      {0.00015874,0.018524,-0.2952,0.0015568,0.38049,0.21742,-0.014141,0.2027,-0.14186,-0.18155},
      {9.42E-05,0.0092377,-0.31065,-0.00011012,0.37808,0.2171,-0.0074223,0.21522,-0.15321,-0.17834},
      {9.19E-05,0.0056062,-0.32852,-0.00077469,0.36604,0.21058,-0.0046869,0.22889,-0.16332,-0.16645},
      {0.00012599,0.0037545,-0.34234,-0.0016393,0.35655,0.20528,-0.0031737,0.24009,-0.17024,-0.15722},
      {0.000184,0.001917,-0.35059,-0.0018867,0.35111,0.20225,-0.001634,0.24635,-0.17508,-0.15191},
      {0.00026449,0.00062817,-0.35714,-0.0017739,0.34639,0.19969,-0.00047977,0.2511,-0.17901,-0.14725},
      {0.00043905,0.00013586,-0.36279,-0.0015052,0.34166,0.19709,0.00010015,0.25531,-0.18191,-0.14261},
      {0.00069995,8.14E-05,-0.36312,-0.0011848,0.34159,0.19708,0.00037317,0.25581,-0.18182,-0.14253},
      {0.039999,-0.012881,0.61022,-0.0021701,-0.0022364,-0.0007404,0.012904,0.43011,-0.26454,0.18012},
      {0.043573,-0.015569,0.60158,-0.0022336,-0.0025779,-0.00079396,0.012312,0.42379,-0.25637,0.17956},
      {0.048651,-0.019515,0.58909,-0.002323,-0.0030909,-0.00089192,0.011249,0.41465,-0.24459,0.1787},
      {0.05486,-0.024581,0.5734,-0.00243,-0.0037737,-0.0010569,0.0095013,0.40318,-0.22986,0.17753},
      {0.066622,-0.032458,0.53407,-0.0028802,-0.0055056,-0.00071541,0.00027878,0.37462,-0.19303,0.17507},
      {0.085062,-0.044184,0.46361,-0.0036316,-0.0086401,0.00033713,-0.019292,0.32365,-0.12703,0.17088},
      {0.10368,-0.057541,0.38601,-0.0042159,-0.012204,0.00098247,-0.04185,0.26765,-0.054642,0.16563},
      {0.11988,-0.07111,0.30804,-0.0045538,-0.015997,9.09E-05,-0.065398,0.21149,0.01708,0.15872},
      {0.12027,-0.06047,0.24908,-0.0047023,-0.018053,-0.0013551,-0.096289,0.16863,0.065908,0.15155},
      {0.11691,-0.039206,0.18505,-0.0040596,-0.019799,-0.004079,-0.13371,0.12283,0.11704,0.14296},
      {0.11307,-0.011934,0.11024,-0.0023535,-0.021645,-0.0085297,-0.17696,0.070365,0.17667,0.13257},
      {0.085794,0.074489,0.07014,0.0029641,-0.011401,-0.0097754,-0.22265,0.045362,0.18599,0.12569},
      {0.058308,0.17935,0.029175,0.011576,0.00017661,-0.0093415,-0.26738,0.023799,0.19178,0.12077},
      {0.035381,0.29002,-0.021902,0.024079,0.011019,-0.0080414,-0.3122,-0.00078987,0.20562,0.11832},
      {0.020171,0.34777,-0.044968,0.040886,0.036101,0.0049921,-0.31676,0.0032865,0.18356,0.10617},
      {0.01039,0.38569,-0.068829,0.052534,0.055804,0.012129,-0.31252,0.010723,0.15997,0.096127},
      {0.0040146,0.4107,-0.096886,0.059909,0.068471,0.01922,-0.30576,0.021207,0.13597,0.094807},
      {0.002749,0.35896,-0.1301,0.057069,0.10662,0.040937,-0.2628,0.04687,0.089965,0.060734},
      {0.0018175,0.3036,-0.17367,0.051533,0.13869,0.061856,-0.21917,0.081894,0.039874,0.03414},
      {0.0010727,0.24658,-0.22924,0.04306,0.16285,0.081064,-0.17594,0.1277,-0.014163,0.017001},
      {0.00076971,0.19072,-0.26429,0.02788,0.20384,0.10671,-0.13595,0.16379,-0.052152,-0.020068},
      {0.0005894,0.13444,-0.29577,0.014167,0.24573,0.13192,-0.096237,0.1968,-0.088483,-0.059081},
      {0.00043053,0.076046,-0.33625,0.0099561,0.27033,0.14845,-0.055167,0.22826,-0.13577,-0.080613},
      {0.00031295,0.038603,-0.37005,0.0062677,0.28052,0.15717,-0.028795,0.25464,-0.16957,-0.087959},
      {0.00021682,0.02649,-0.38096,0.0038318,0.28529,0.16081,-0.02004,0.26381,-0.1802,-0.091764},
      {0.00014046,0.016518,-0.39367,0.0014835,0.28669,0.1627,-0.012801,0.2746,-0.19041,-0.09221},
      {8.96E-05,0.0085227,-0.41038,-0.00040607,0.28225,0.1614,-0.0069732,0.28823,-0.2016,-0.086892},
      {9.30E-05,0.0040967,-0.42414,-0.0012111,0.27517,0.15802,-0.0036342,0.29881,-0.21021,-0.079527},
      {0.00014337,0.0021366,-0.42825,-0.0012992,0.27335,0.15703,-0.0019822,0.3017,-0.21339,-0.077735},
      {0.00021542,0.000847,-0.43144,-0.0012757,0.27193,0.15635,-0.00080715,0.30401,-0.2157,-0.076249},
      {0.0002819,0.00034842,-0.43511,-0.0011577,0.26941,0.15515,-0.0002144,0.30675,-0.21779,-0.073633},
      {0.0004294,9.97E-05,-0.43793,-0.00096108,0.26729,0.15413,0.00016621,0.30892,-0.21919,-0.071435},
      {0.0085638,-0.001361,0.67574,-0.0011927,-0.00080639,-0.00070477,0.00068169,0.4773,-0.32599,0.1827},
      {0.010886,-0.0033663,0.66938,-0.0012404,-0.0010884,-0.00088436,6.76E-05,0.47266,-0.3201,0.18212},
      {0.014176,-0.006309,0.66014,-0.0013061,-0.0015078,-0.0011863,-0.0009259,0.46593,-0.31159,0.18123},
      {0.018176,-0.010086,0.64845,-0.0013816,-0.0020571,-0.0016533,-0.0023794,0.45741,-0.30086,0.18},
      {0.022475,-0.01448,0.63509,-0.0014545,-0.0027156,-0.0023413,-0.0043639,0.44769,-0.28871,0.17842},
      {0.026568,-0.019175,0.62111,-0.0015084,-0.0034506,-0.0033197,-0.0069191,0.43752,-0.27615,0.17649},
      {0.0388,-0.029493,0.56247,-0.0016591,-0.0063228,-0.0046686,-0.024062,0.39532,-0.22257,0.17067},
      {0.051226,-0.040648,0.49497,-0.001623,-0.009707,-0.0070885,-0.045326,0.34686,-0.16147,0.16307},
      {0.061225,-0.050756,0.42962,-0.0012961,-0.013069,-0.010951,-0.067657,0.30008,-0.10325,0.15425},
      {0.066333,-0.041821,0.35963,-0.00019298,-0.016309,-0.015307,-0.09674,0.25043,-0.044686,0.14375},
      {0.066825,-0.0087881,0.275,0.0024477,-0.019189,-0.020061,-0.1383,0.19132,0.022781,0.1317},
      {0.066186,0.030957,0.18145,0.0065581,-0.022301,-0.026489,-0.18533,0.12668,0.096654,0.11783},
      {0.054106,0.10933,0.1082,0.014896,-0.017674,-0.029498,-0.23211,0.080791,0.14061,0.10969},
      {0.035869,0.21572,0.050531,0.026094,-0.0064633,-0.036697,-0.27142,0.052062,0.15813,0.10339},
      {0.022603,0.31184,-0.014133,0.034947,0.002798,-0.05071,-0.30517,0.021621,0.17999,0.095},
      {0.014072,0.36335,-0.054295,0.042507,0.017059,-0.050833,-0.3121,0.016677,0.17311,0.088597},
      {0.0082646,0.38908,-0.083355,0.048119,0.03085,-0.04068,-0.30614,0.02873,0.15039,0.08906},
      {0.0040552,0.41154,-0.1168,0.051103,0.039741,-0.022705,-0.30378,0.046212,0.13031,0.10114},
      {0.0023697,0.38141,-0.16051,0.045915,0.06314,0.00014375,-0.27483,0.079604,0.090553,0.090769},
      {0.0016434,0.32303,-0.21805,0.035111,0.08947,0.020918,-0.23053,0.12835,0.035916,0.071928},
      {0.0010308,0.25447,-0.28988,0.025546,0.10794,0.038648,-0.18087,0.18629,-0.030197,0.061102},
      {0.000638,0.17907,-0.34958,0.021547,0.13461,0.060153,-0.12755,0.23093,-0.09608,0.040955},
      {0.0004725,0.11903,-0.3869,0.015706,0.16565,0.080488,-0.085298,0.26119,-0.14189,0.013331},
      {0.00034452,0.070336,-0.42845,0.010036,0.18247,0.094191,-0.051084,0.29454,-0.18404,0.00060325},
      {0.00024394,0.032716,-0.47277,0.0050964,0.18598,0.10149,-0.024684,0.32949,-0.22227,0.0016642},
      {0.00015494,0.022289,-0.48174,0.0019351,0.19221,0.10616,-0.017085,0.33798,-0.23062,-0.003389},
      {9.58E-05,0.013657,-0.49341,-0.00030066,0.19337,0.10805,-0.010769,0.34796,-0.2397,-0.0034749},
      {7.05E-05,0.006422,-0.5031,-0.00061214,0.19267,0.10891,-0.0054399,0.35493,-0.24824,-0.001764},
      {7.56E-05,0.0019666,-0.51351,-0.00080447,0.18822,0.10742,-0.0020572,0.36237,-0.25576,0.0033886},
      {0.000129,0.0012015,-0.50813,-0.00083987,0.19492,0.11145,-0.0011935,0.35859,-0.25361,-0.0028948},
      {0.00019328,0.00067742,-0.50616,-0.00079515,0.19799,0.11345,-0.00056981,0.35728,-0.25295,-0.0056467},
      {0.00026496,0.000298,-0.50887,-0.00069971,0.19626,0.11275,-0.00011473,0.3593,-0.25447,-0.0037264},
      {-0.00078172,0.0026175,0.69856,-0.0011107,-1.29E-05,-0.00033287,-4.35E-05,0.49333,-0.34681,0.18426},
      {-0.00056743,0.0026252,0.69853,-0.0010604,-1.45E-05,-0.00036132,-0.0001166,0.49335,-0.34677,0.18423},
      {0.00051889,0.0016576,0.69535,-0.0010449,-0.00018428,-0.00063939,-0.00069093,0.49108,-0.34396,0.18373},
      {0.0028756,-0.00081399,0.68719,-0.0011005,-0.00063497,-0.0013649,-0.0020532,0.48515,-0.33678,0.18244},
      {0.0055727,-0.0036159,0.67759,-0.0011438,-0.0011949,-0.0023582,-0.0036916,0.4782,-0.32842,0.18075},
      {0.0083943,-0.0064835,0.66717,-0.001152,-0.0018475,-0.0036713,-0.0055228,0.47066,-0.31946,0.17864},
      {0.01109,-0.0090874,0.65669,-0.0010957,-0.0025654,-0.0053659,-0.0074331,0.46312,-0.31063,0.17612},
      {0.016187,-0.013118,0.62737,-0.00081843,-0.0044398,-0.0082341,-0.015925,0.44215,-0.28528,0.17068},
      {0.023988,-0.018389,0.57102,-0.00011839,-0.0080534,-0.013317,-0.034274,0.40189,-0.23672,0.16049},
      {0.029561,-0.020636,0.51843,0.0009278,-0.011619,-0.02013,-0.052371,0.36442,-0.19273,0.14888},
      {0.032489,-0.013325,0.46244,0.0027441,-0.014856,-0.029271,-0.07432,0.32492,-0.14803,0.1353},
      {0.035183,0.023718,0.34953,0.0065144,-0.018193,-0.051147,-0.11996,0.24691,-0.061653,0.10897},
      {0.03632,0.065744,0.23207,0.01044,-0.021196,-0.085504,-0.16404,0.16663,0.023854,0.07345},
      {0.033197,0.12427,0.12478,0.015519,-0.02054,-0.12413,-0.20404,0.096985,0.093203,0.03808},
      {0.022645,0.21898,0.058881,0.023584,-0.010899,-0.13292,-0.23888,0.066925,0.11896,0.035684},
      {0.014855,0.31034,-0.0075826,0.030183,-0.0029542,-0.13224,-0.27556,0.040387,0.14847,0.042624},
      {0.0096607,0.37692,-0.061935,0.034561,0.0054564,-0.12008,-0.29959,0.03073,0.16287,0.055403},
      {0.0060203,0.39961,-0.096603,0.035893,0.014884,-0.098681,-0.29821,0.049973,0.14403,0.069958},
      {0.0034556,0.41885,-0.1362,0.033635,0.019843,-0.068996,-0.30051,0.075848,0.12771,0.094775},
      {0.0020404,0.38363,-0.19147,0.032613,0.03184,-0.043618,-0.27247,0.11313,0.081141,0.10119},
      {0.0014196,0.29767,-0.26617,0.028727,0.053953,-0.026681,-0.21136,0.16824,0.0021268,0.08408},
      {0.00087557,0.21893,-0.35011,0.024281,0.067866,-0.0049922,-0.15554,0.23033,-0.077397,0.082561},
      {0.00044723,0.14947,-0.4329,0.018917,0.078445,0.020142,-0.10647,0.29232,-0.15103,0.088526},
      {0.00031848,0.10012,-0.47191,0.011712,0.10011,0.03684,-0.071783,0.32488,-0.19152,0.071325},
      {0.00021333,0.060632,-0.51461,0.0054196,0.10861,0.047243,-0.044061,0.35955,-0.22926,0.067801},
      {0.00012543,0.030216,-0.55977,0.00078736,0.10498,0.051797,-0.022733,0.39488,-0.26446,0.076809},
      {8.31E-05,0.016778,-0.56828,0.00027821,0.1129,0.05897,-0.013095,0.40105,-0.27542,0.071384},
      {5.50E-05,0.0093864,-0.57201,-9.27E-05,0.11837,0.06338,-0.0076284,0.4038,-0.28108,0.067197},
      {3.42E-05,0.0046159,-0.57526,-0.00035201,0.12214,0.06718,-0.0039539,0.40623,-0.28521,0.064934},
      {2.71E-05,0.0014623,-0.58361,-0.00049053,0.11912,0.06711,-0.0014694,0.41224,-0.29105,0.069202},
      {9.13E-05,0.00093568,-0.57588,-0.00050346,0.12788,0.072363,-0.00083804,0.40681,-0.28754,0.060988},
      {0.00016245,0.00054701,-0.57315,-0.00046636,0.13151,0.074741,-0.00036864,0.40495,-0.2864,0.057746},
      {-0.0012282,0.0022227,0.6982,-0.0026154,2.17E-05,-0.0002377,0.00017159,0.49194,-0.3477,0.18434},
      {-0.0010281,0.0022134,0.69824,-0.00253,2.11E-05,-0.00026529,0.00010564,0.49203,-0.34769,0.18431},
      {-0.00072121,0.0021965,0.6983,-0.0023935,2.03E-05,-0.00030765,4.83E-06,0.49218,-0.34767,0.18426},
      {-0.00029998,0.0021678,0.69842,-0.0021951,1.96E-05,-0.00036578,-0.00013289,0.4924,-0.34766,0.1842},
      {0.00048942,0.0017992,0.69693,-0.0019691,-0.00010264,-0.00076717,-0.00056443,0.49149,-0.34633,0.18366},
      {0.0020946,0.00056586,0.69023,-0.0018077,-0.0006244,-0.0024083,-0.001831,0.48675,-0.34091,0.18147},
      {0.0036855,-0.00065574,0.68264,-0.0015392,-0.0012038,-0.0050309,-0.0031511,0.48144,-0.33498,0.17836},
      {0.0052595,-0.0019581,0.6738,-0.0011875,-0.0018403,-0.0089619,-0.0045504,0.47531,-0.32835,0.17406},
      {0.0069251,-0.0032358,0.66148,-0.00073378,-0.0026626,-0.014746,-0.0068165,0.46676,-0.31927,0.1679},
      {0.011446,-0.0049298,0.60633,0.0002105,-0.0061172,-0.030727,-0.022585,0.42754,-0.2763,0.14894},
      {0.014961,-0.0046641,0.5486,0.0012136,-0.0094841,-0.053663,-0.037565,0.38658,-0.23368,0.12435},
      {0.017281,-0.0018907,0.48867,0.0022551,-0.012554,-0.085042,-0.051194,0.34414,-0.1922,0.093231},
      {0.018283,0.038223,0.37607,0.0057842,-0.014698,-0.12768,-0.089656,0.26747,-0.11284,0.052821},
      {0.018177,0.087101,0.25435,0.009473,-0.015926,-0.18292,-0.12904,0.18554,-0.030242,0.0037124},
      {0.017036,0.14098,0.13044,0.012865,-0.015938,-0.25173,-0.16545,0.10301,0.050012,-0.054217},
      {0.011648,0.22991,0.062016,0.018283,-0.0082174,-0.24667,-0.20346,0.07626,0.084209,-0.042892},
      {0.0081607,0.31708,-0.0040792,0.021497,-0.0021258,-0.22775,-0.24388,0.056215,0.12003,-0.01984},
      {0.0066413,0.38242,-0.066519,0.023486,0.0018285,-0.20187,-0.27764,0.042779,0.14989,0.005872},
      {0.0046006,0.36653,-0.10801,0.026183,0.0075286,-0.18086,-0.26353,0.065669,0.11851,0.017995},
      {0.0029581,0.35091,-0.16067,0.028123,0.011475,-0.14679,-0.25021,0.097797,0.082455,0.043181},
      {0.0017123,0.33251,-0.22567,0.028447,0.014516,-0.1008,-0.2356,0.1407,0.040036,0.07907},
      {0.0011842,0.25537,-0.31033,0.022424,0.029427,-0.076451,-0.18093,0.20439,-0.03825,0.078322},
      {0.00071147,0.18471,-0.40261,0.015952,0.037493,-0.047709,-0.13099,0.27382,-0.1167,0.090925},
      {0.00028399,0.12046,-0.50171,0.0090527,0.039279,-0.014588,-0.08573,0.34841,-0.195,0.11605},
      {0.0001432,0.078655,-0.54991,0.0022166,0.049176,0.0012302,-0.056382,0.38725,-0.23643,0.11501},
      {8.42E-05,0.047654,-0.58137,0.0014698,0.05545,0.011583,-0.034675,0.40995,-0.26717,0.1146},
      {4.46E-05,0.024065,-0.61373,0.00079805,0.054121,0.018319,-0.018121,0.43322,-0.29471,0.1221},
      {1.63E-05,0.011772,-0.62501,0.00028907,0.060652,0.027269,-0.0092646,0.44144,-0.30637,0.12014},
      {-1.42E-06,0.0069393,-0.62289,-1.30E-05,0.069822,0.034158,-0.0055532,0.44006,-0.30784,0.11268},
      {-8.33E-06,0.0035303,-0.62697,-0.0001993,0.071343,0.036732,-0.0029001,0.44305,-0.31167,0.11263},
      {-6.67E-06,0.0013666,-0.63643,-0.00028395,0.066233,0.035626,-0.0011756,0.44981,-0.31755,0.11906},
      {4.72E-05,0.00074213,-0.62866,-0.00029694,0.075156,0.041173,-0.00059522,0.44433,-0.31401,0.11084},
      {-0.0018593,0.0017975,0.6968,-0.0043209,5.89E-05,-0.00089311,0.00055797,0.4897,-0.34814,0.18377},
      {-0.0016914,0.0017624,0.69678,-0.0041907,6.00E-05,-0.0010829,0.00051337,0.48978,-0.34809,0.1836},
      {-0.0014373,0.0017073,0.69674,-0.0039868,6.18E-05,-0.0014009,0.00044645,0.4899,-0.34801,0.18333},
      {-0.0010951,0.001629,0.69664,-0.0036978,6.46E-05,-0.0018921,0.00035759,0.49004,-0.34787,0.1829},
      {-0.00066864,0.0015248,0.69647,-0.0033105,6.90E-05,-0.0026172,0.00024893,0.49019,-0.34767,0.18227},
      {-0.00016656,0.001392,0.69616,-0.0028082,7.53E-05,-0.0036552,0.00012426,0.49033,-0.34736,0.18137},
      {0.00070626,0.00081311,0.6913,-0.0023349,-0.00022225,-0.0069974,-0.00058046,0.48718,-0.34389,0.17808},
      {0.001795,-2.26E-05,0.68236,-0.0018919,-0.00075257,-0.012939,-0.0017227,0.48109,-0.33779,0.17225},
      {0.002815,-0.00073984,0.67214,-0.0013777,-0.001281,-0.020673,-0.0028638,0.47415,-0.33113,0.16491},
      {0.0037071,-0.0012559,0.66056,-0.00079294,-0.0017729,-0.030606,-0.0039422,0.46631,-0.32394,0.15578},
      {0.0055014,0.0010836,0.61389,0.00010931,-0.0039378,-0.057643,-0.013653,0.43337,-0.29234,0.12972},
      {0.0068956,0.0064459,0.55385,0.001116,-0.0062143,-0.097168,-0.025007,0.39091,-0.25343,0.093056},
      {0.0074268,0.01476,0.4906,0.0021226,-0.0077945,-0.14677,-0.034757,0.34626,-0.21505,0.049084},
      {0.0073009,0.051846,0.38858,0.0046383,-0.0080514,-0.20893,-0.061229,0.27721,-0.14967,-0.0036398},
      {0.0069011,0.10698,0.26494,0.0077792,-0.0070469,-0.28312,-0.09478,0.19534,-0.071125,-0.064297},
      {0.0066663,0.15614,0.1362,0.010414,-0.0061118,-0.36993,-0.12481,0.10997,0.0080072,-0.13515},
      {0.0060666,0.20644,0.052557,0.013507,-0.0043799,-0.37768,-0.15777,0.069751,0.055904,-0.14063},
      {0.0053145,0.25579,-0.0061963,0.016298,-0.0019651,-0.35194,-0.18886,0.053473,0.085574,-0.11732},
      {0.0047643,0.29739,-0.056239,0.018108,9.74E-05,-0.32487,-0.21489,0.044232,0.10798,-0.092688},
      {0.0035429,0.29527,-0.11066,0.019122,0.0033847,-0.28577,-0.21111,0.071575,0.083492,-0.061867},
      {0.0023787,0.28253,-0.17793,0.018614,0.0057462,-0.23255,-0.20055,0.11667,0.043311,-0.018906},
      {0.0014954,0.26983,-0.25723,0.015884,0.0066563,-0.1667,-0.19061,0.17259,-0.0014593,0.036012},
      {0.00097824,0.21516,-0.34962,0.0088854,0.012556,-0.12468,-0.15186,0.24215,-0.071614,0.062918},
      {0.000552,0.15144,-0.44549,0.0032202,0.01632,-0.089554,-0.10706,0.31356,-0.14864,0.08683},
      {0.00017627,0.094515,-0.53779,0.0026874,0.017822,-0.04799,-0.067196,0.37881,-0.22297,0.11921},
      {1.58E-05,0.056955,-0.59374,0.0019584,0.022729,-0.019771,-0.040874,0.41868,-0.26928,0.13559},
      {-1.46E-05,0.034416,-0.6191,0.0011887,0.02804,-0.0086326,-0.025016,0.43705,-0.29275,0.1372},
      {-3.48E-05,0.018076,-0.64286,0.00059173,0.028848,6.92E-05,-0.013454,0.45417,-0.31245,0.14326},
      {-4.58E-05,0.007994,-0.66088,0.00018204,0.028171,0.0069229,-0.0062193,0.4671,-0.32631,0.14992},
      {-4.86E-05,0.0045745,-0.66094,-3.49E-05,0.033651,0.011737,-0.0035731,0.46724,-0.32812,0.14604},
      {-3.97E-05,0.0024639,-0.66331,-0.000135,0.035189,0.014163,-0.0019346,0.46896,-0.33042,0.14584},
      {-2.28E-05,0.0012109,-0.66552,-0.0001559,0.035738,0.015913,-0.00098276,0.47052,-0.33217,0.14651},
      {-0.0023816,0.0014211,0.69532,-0.0064617,9.71E-05,-0.0009107,0.00096559,0.48712,-0.34874,0.18374},
      {-0.0022425,0.0013814,0.69518,-0.006296,9.95E-05,-0.0012956,0.00093017,0.48714,-0.34862,0.18341},
      {-0.0020311,0.0013197,0.69496,-0.0060338,0.00010338,-0.001915,0.00087682,0.48717,-0.34842,0.18287},
      {-0.0017452,0.0012339,0.69461,-0.0056573,0.00010909,-0.0028241,0.00080557,0.48719,-0.34812,0.18209},
      {-0.0013866,0.0011224,0.69412,-0.0051459,0.00011703,-0.0040903,0.00071781,0.48721,-0.3477,0.18101},
      {-0.00096119,0.00098402,0.69343,-0.0044742,0.00012767,-0.0057969,0.00061612,0.4872,-0.34712,0.17955},
      {-0.00047783,0.00081867,0.69249,-0.0036103,0.00014161,-0.0080449,0.00050413,0.48715,-0.34635,0.17763},
      {7.21E-05,0.00060852,0.69013,-0.0026005,0.00010785,-0.011692,0.00029047,0.48619,-0.34468,0.17445},
      {0.00074773,0.00034882,0.67916,-0.0020302,-0.00025776,-0.021956,-0.00055918,0.4788,-0.33812,0.16524},
      {0.0013479,0.00030001,0.66657,-0.001382,-0.00056629,-0.034614,-0.0013323,0.47032,-0.33086,0.15409},
      {0.0018571,0.0005479,0.65256,-0.00066323,-0.00079345,-0.049586,-0.0019761,0.4609,-0.32308,0.14109},
      {0.0023497,0.0051528,0.61425,0.00018795,-0.0015151,-0.083047,-0.006559,0.43409,-0.30068,0.1119},
      {0.0026597,0.014658,0.54538,0.0011469,-0.002538,-0.1444,-0.014281,0.3855,-0.2613,0.059052},
      {0.0029602,0.022589,0.45899,0.0020089,-0.0038599,-0.22591,-0.021756,0.32456,-0.21335,-0.01084},
      {0.0032828,0.043804,0.3496,0.0035472,-0.0047787,-0.31481,-0.038421,0.24934,-0.14935,-0.086195},
      {0.003662,0.080577,0.22562,0.0058132,-0.0051056,-0.39865,-0.065644,0.16624,-0.072844,-0.15631},
      {0.0038478,0.11122,0.11322,0.0075389,-0.0052642,-0.4807,-0.087799,0.090846,-0.0051228,-0.22448},
      {0.0036622,0.14658,0.034881,0.0091566,-0.0041198,-0.5081,-0.1111,0.049806,0.03859,-0.24593},
      {0.0033334,0.18814,-0.011477,0.01035,-0.0020063,-0.47587,-0.13732,0.044153,0.059494,-0.21682},
      {0.0031496,0.22329,-0.05063,0.01012,-0.00042609,-0.44259,-0.15951,0.044803,0.074748,-0.187},
      {0.0026129,0.2325,-0.10518,0.008413,0.0010999,-0.39368,-0.16431,0.073873,0.058713,-0.14582},
      {0.0018293,0.222,-0.18769,0.0045715,0.0020514,-0.32204,-0.15605,0.13297,0.014111,-0.086197},
      {0.0012066,0.20847,-0.27622,0.0034466,0.0025495,-0.23971,-0.1466,0.19513,-0.036035,-0.018157},
      {0.00071236,0.16936,-0.36813,0.0032346,0.0047871,-0.17706,-0.11931,0.2596,-0.10128,0.030758},
      {0.00033822,0.11327,-0.46105,0.0025397,0.0076474,-0.13169,-0.080038,0.32538,-0.17542,0.064332},
      {6.49E-05,0.068546,-0.55221,0.0019211,0.0087593,-0.078125,-0.048697,0.38988,-0.24298,0.10722},
      {-8.02E-05,0.037509,-0.62317,0.0013251,0.0099604,-0.031649,-0.026911,0.44017,-0.29359,0.14408},
      {-9.25E-05,0.02175,-0.64485,0.00070864,0.012309,-0.021988,-0.015779,0.45582,-0.31193,0.14872},
      {-9.66E-05,0.011034,-0.66489,0.00026371,0.011272,-0.014185,-0.0081463,0.47018,-0.32704,0.15669},
      {-8.85E-05,0.0050796,-0.681,3.55E-05,0.0089274,-0.0074147,-0.0038652,0.48161,-0.33792,0.16567},
      {-6.83E-05,0.0032033,-0.6789,-2.47E-05,0.01466,-0.0024243,-0.0024742,0.4801,-0.33782,0.16157},
      {-4.91E-05,0.0019642,-0.67882,-5.52E-05,0.017293,0.00032809,-0.0015379,0.48003,-0.33842,0.16007},
      {-0.0027827,0.001299,0.69528,-0.0062753,0.00012776,-0.0010037,0.0012606,0.48722,-0.34856,0.18362},
      {-0.0027841,0.0012295,0.69485,-0.0066726,0.00013374,-0.0010821,0.0013229,0.48664,-0.34857,0.18355},
      {-0.0027948,0.0011229,0.69418,-0.0072824,0.00014324,-0.0012057,0.0014246,0.48573,-0.34857,0.18343},
      {-0.0028144,0.00098015,0.69325,-0.0080466,0.00015675,-0.0014416,0.0015664,0.48454,-0.34852,0.18322},
      {-0.0025431,0.00087628,0.69253,-0.0072907,0.00017128,-0.0032062,0.0015127,0.48457,-0.34785,0.18171},
      {-0.0021869,0.00075197,0.69159,-0.006349,0.00019071,-0.0054932,0.001425,0.48457,-0.34701,0.17975},
      {-0.0017288,0.00060944,0.69039,-0.0052144,0.00021609,-0.0083791,0.0012883,0.48453,-0.34598,0.17729},
      {-0.0011476,0.00045192,0.68888,-0.0038822,0.00024862,-0.011956,0.0010827,0.48441,-0.34475,0.17424},
      {-0.00042856,0.00029888,0.68508,-0.0023296,0.00028131,-0.01848,0.00075315,0.4829,-0.34239,0.16874},
      {8.81E-05,0.00043611,0.66977,-0.0015406,0.00014325,-0.035784,0.00019072,0.4727,-0.33421,0.154},
      {0.00051815,0.00065518,0.64635,-0.00099121,-4.26E-05,-0.061721,-0.00044276,0.45659,-0.32198,0.13198},
      {0.0009346,0.00086196,0.61631,-0.0004781,-0.00021221,-0.095365,-0.0010831,0.43577,-0.30651,0.10356},
      {0.0012942,0.0029927,0.56656,7.85E-05,-0.00065516,-0.14758,-0.0034001,0.40092,-0.28018,0.05931},
      {0.0014995,0.0098997,0.47659,0.00082488,-0.0018239,-0.23598,-0.009765,0.33747,-0.23126,-0.015964},
      {0.0016009,0.016164,0.37823,0.0014723,-0.0028352,-0.33622,-0.015357,0.26813,-0.17873,-0.10074},
      {0.0016586,0.026532,0.27234,0.002217,-0.0034755,-0.44059,-0.023415,0.19425,-0.12137,-0.18826},
      {0.0018452,0.053621,0.17197,0.0035067,-0.0033647,-0.51583,-0.042592,0.12704,-0.061166,-0.25027},
      {0.0018987,0.075131,0.084014,0.0041025,-0.0030268,-0.5878,-0.057145,0.068178,-0.0096464,-0.30902},
      {0.0018419,0.096569,0.017002,0.0040082,-0.0021457,-0.63113,-0.070683,0.029709,0.02722,-0.34326},
      {0.0018387,0.13166,-0.018937,0.0030304,-0.00063139,-0.59324,-0.093103,0.033701,0.041254,-0.30959},
      {0.0019625,0.16272,-0.047899,0.0019357,-3.57E-05,-0.54799,-0.11393,0.042679,0.050954,-0.27103},
      {0.0018769,0.17799,-0.089438,0.0020968,0.0002791,-0.4915,-0.12469,0.066134,0.0418,-0.22433},
      {0.0012577,0.16078,-0.18236,0.0022729,0.00090651,-0.40561,-0.11285,0.13063,-0.012994,-0.15375},
      {0.00074882,0.14189,-0.28117,0.0023315,0.0012971,-0.31491,-0.099763,0.19961,-0.071572,-0.078808},
      {0.00035731,0.11636,-0.38262,0.0021489,0.001882,-0.22819,-0.081953,0.27088,-0.13477,-0.007482},
      {0.00010868,0.074871,-0.47252,0.0015329,0.0032362,-0.17194,-0.052884,0.33446,-0.20006,0.037285},
      {-5.85E-05,0.04288,-0.5601,0.00099713,0.0033535,-0.10938,-0.030447,0.39638,-0.25946,0.089053},
      {-0.00015226,0.019703,-0.64481,0.00054755,0.002502,-0.041453,-0.014164,0.45625,-0.31306,0.14667},
      {-0.00014415,0.011071,-0.66093,0.0002117,0.0034246,-0.032157,-0.0080534,0.46774,-0.32518,0.15305},
      {-0.00012275,0.0067995,-0.67135,0.00011275,0.0039758,-0.024702,-0.0050402,0.47501,-0.33239,0.15844},
      {-9.75E-05,0.003929,-0.6814,4.48E-05,0.0035826,-0.017648,-0.0029936,0.48202,-0.33874,0.16486},
      {-7.36E-05,0.0024581,-0.68499,7.19E-06,0.0050829,-0.012982,-0.0019107,0.4845,-0.34125,0.16657},
      {-0.0037796,0.0012802,0.69646,-0.0035139,0.00015241,-0.0016911,0.0018961,0.49008,-0.34739,0.18302},
      {-0.0038345,0.0012221,0.69598,-0.0037806,0.00015974,-0.0018908,0.0019847,0.48956,-0.34729,0.18284},
      {-0.0039223,0.0011335,0.69523,-0.0041793,0.00017118,-0.0022139,0.0021225,0.48876,-0.34711,0.18256},
      {-0.0040497,0.001013,0.69419,-0.0047052,0.00018729,-0.0026913,0.0023153,0.48768,-0.34685,0.18214},
      {-0.0042247,0.00086107,0.69282,-0.0053416,0.0002086,-0.0033605,0.002568,0.4863,-0.34647,0.18155},
      {-0.0044052,0.00068502,0.69103,-0.0059598,0.00023534,-0.0044963,0.0028461,0.48465,-0.34589,0.18057},
      {-0.0037528,0.00057367,0.68744,-0.0049693,0.00026285,-0.010168,0.0025069,0.48288,-0.34391,0.1758},
      {-0.0029812,0.00044937,0.68249,-0.0039157,0.00029618,-0.017572,0.0020921,0.48022,-0.34129,0.16959},
      {-0.0020906,0.00031519,0.6758,-0.0028374,0.00033587,-0.027081,0.001597,0.47638,-0.33788,0.16161},
      {-0.0010857,0.00017507,0.66698,-0.0017735,0.00038245,-0.039119,0.0010198,0.47105,-0.3335,0.15153},
      {-0.00033465,0.00018645,0.64619,-0.00104,0.0003488,-0.063693,0.0004111,0.45699,-0.323,0.13088},
      {3.35E-05,0.000368,0.60908,-0.0006586,0.00024228,-0.10574,-0.0001619,0.43107,-0.30415,0.095556},
      {0.00037764,0.00054926,0.56418,-0.00032136,0.00017919,-0.1569,-0.00071699,0.3996,-0.28146,0.052689},
      {0.00067337,0.0010539,0.50822,-2.38E-05,0.00012428,-0.22032,-0.0014953,0.36026,-0.25316,-0.00035938},
      {0.00072308,0.0064296,0.40814,0.00047474,-0.00060438,-0.3254,-0.0060318,0.28974,-0.20047,-0.08862},
      {0.00070389,0.011181,0.30107,0.00082589,-0.00102,-0.44114,-0.0097173,0.21434,-0.14487,-0.18514},
      {0.00062115,0.015206,0.18757,0.00099084,-0.0010226,-0.5674,-0.012393,0.13446,-0.086703,-0.28965},
      {0.00069468,0.033265,0.11099,0.0010718,-0.00042414,-0.6332,-0.024115,0.08331,-0.042147,-0.3428},
      {0.00078677,0.048242,0.053657,0.00098544,-0.00027129,-0.67999,-0.033991,0.045384,-0.0080996,-0.38076},
      {0.00088019,0.060196,0.0084181,0.001057,-0.00054715,-0.7134,-0.042246,0.016447,0.018287,-0.40832},
      {0.0010562,0.088162,-0.019358,0.001169,-0.00040068,-0.66118,-0.061803,0.028277,0.02394,-0.36494},
      {0.001134,0.10755,-0.046698,0.0012087,-0.00026149,-0.61765,-0.075363,0.041091,0.024631,-0.32869},
      {0.0011154,0.11846,-0.073866,0.0011731,-0.00013799,-0.5822,-0.082995,0.05518,0.020205,-0.2991},
      {0.00067079,0.10249,-0.17442,0.0012405,0.00026238,-0.48612,-0.071935,0.12537,-0.037733,-0.21964},
      {0.00031594,0.085371,-0.28035,0.0011646,0.00046335,-0.38508,-0.060018,0.19971,-0.098957,-0.13582},
      {4.52E-05,0.067396,-0.39151,0.0009248,0.00047541,-0.27886,-0.047453,0.27816,-0.16326,-0.047496},
      {-0.00010072,0.039735,-0.4797,0.00041341,0.00070282,-0.21036,-0.028055,0.34048,-0.2208,0.0090573},
      {-0.00015901,0.022621,-0.56002,0.00024081,0.00075101,-0.13855,-0.01609,0.397,-0.26924,0.068599},
      {-0.00017732,0.011978,-0.63258,0.00021569,0.0008397,-0.067804,-0.0086798,0.44798,-0.31065,0.12719},
      {-0.00016117,0.0069808,-0.65917,0.00014318,0.001253,-0.042811,-0.0051793,0.46662,-0.3263,0.14734},
      {-0.00013063,0.0045305,-0.6671,7.91E-05,0.0013985,-0.036781,-0.0034384,0.47211,-0.33138,0.15213},
      {-9.64E-05,0.0030799,-0.67472,3.80E-05,0.0014614,-0.030033,-0.0023898,0.47738,-0.33585,0.15764},
      {-0.0036351,0.0012311,0.6988,-0.0012257,0.00015616,-0.0018555,0.0017542,0.49344,-0.34765,0.18287},
      {-0.0037093,0.0011832,0.69828,-0.0013948,0.00016491,-0.0021677,0.0018466,0.49297,-0.34747,0.1826},
      {-0.0038258,0.0011103,0.69747,-0.0016479,0.00017855,-0.0026618,0.0019896,0.49225,-0.34718,0.18217},
      {-0.0039912,0.0010113,0.69633,-0.0019825,0.0001977,-0.0033704,0.0021885,0.49126,-0.34676,0.18156},
      {-0.004212,0.00088703,0.69483,-0.0023886,0.00022296,-0.0043293,0.0024475,0.48997,-0.34619,0.18073},
      {-0.0044951,0.00073943,0.69294,-0.0028495,0.00025489,-0.0055792,0.0027694,0.4884,-0.34545,0.17965},
      {-0.0048477,0.00057208,0.69062,-0.0033426,0.00029411,-0.0071654,0.0031561,0.48652,-0.3445,0.17827},
      {-0.0046822,0.00042517,0.68556,-0.0033057,0.0003373,-0.012962,0.0031634,0.48311,-0.34215,0.1734},
      {-0.0037123,0.00031566,0.67598,-0.0025737,0.00038276,-0.025492,0.0025751,0.47702,-0.33756,0.16292},
      {-0.0026476,0.00020449,0.66401,-0.0018377,0.00043534,-0.040831,0.0019189,0.46928,-0.33185,0.1501},
      {-0.0015063,9.67E-05,0.64922,-0.0011178,0.00049542,-0.059411,0.0012037,0.45959,-0.32482,0.13459},
      {-0.00050725,5.59E-05,0.62518,-0.00052125,0.00054582,-0.088206,0.00050526,0.44325,-0.31312,0.11054},
      {-0.00021509,0.00023592,0.57305,-0.00029495,0.00057156,-0.14795,3.72E-05,0.40656,-0.28692,0.060645},
      {4.34E-05,0.00042995,0.51202,-0.0001172,0.00066893,-0.21811,-0.00038779,0.36354,-0.25634,0.0021706},
      {0.00025626,0.00064267,0.44114,1.46E-06,0.00085707,-0.29981,-0.00074951,0.31349,-0.22089,-0.065808},
      {0.00026929,0.0040315,0.34035,0.00016969,0.00076921,-0.4115,-0.0031345,0.24261,-0.16926,-0.15842},
      {0.00027705,0.0073872,0.24169,0.0003132,0.0005045,-0.52034,-0.0055099,0.17334,-0.11873,-0.2487},
      {0.00027042,0.010113,0.14437,0.00041911,0.00019954,-0.6288,-0.0074337,0.10486,-0.069046,-0.33862},
      {0.00035883,0.020577,0.087306,0.00050934,-8.42E-05,-0.6785,-0.014674,0.06696,-0.03707,-0.37969},
      {0.00043534,0.030944,0.045786,0.00055929,-0.00034333,-0.70937,-0.021839,0.040742,-0.013374,-0.40512},
      {0.0004658,0.0385,0.0096753,0.00056128,-0.00057407,-0.73745,-0.027059,0.018322,0.0062564,-0.42824},
      {0.00051316,0.052772,-0.018801,0.00058103,-0.00048172,-0.71111,-0.037027,0.024368,0.0091704,-0.40616},
      {0.00050596,0.063337,-0.045273,0.00054903,-0.00033034,-0.67629,-0.04441,0.038339,0.0046652,-0.37704},
      {0.00042893,0.067348,-0.070457,0.00043954,-0.00021984,-0.64869,-0.047203,0.052702,-0.0033576,-0.35391},
      {0.00018179,0.05626,-0.15869,0.00032691,-6.01E-05,-0.56189,-0.039473,0.11409,-0.052287,-0.2818},
      {-3.59E-05,0.0418,-0.2715,0.00011863,-8.59E-06,-0.4495,-0.02937,0.19369,-0.11565,-0.18841},
      {-0.00014073,0.033702,-0.38789,0.00016069,7.31E-05,-0.32439,-0.023771,0.27594,-0.17785,-0.08467},
      {-0.00019046,0.022892,-0.4777,0.00016034,0.0002398,-0.23359,-0.016261,0.33915,-0.22799,-0.0095314},
      {-0.00019994,0.013538,-0.54831,0.00013894,0.00035918,-0.16356,-0.0097554,0.38874,-0.26778,0.048426},
      {-0.00018406,0.0076779,-0.60931,0.00012254,0.00045075,-0.10052,-0.0056914,0.43159,-0.30105,0.10062},
      {-0.0001569,0.0045751,-0.64452,9.16E-05,0.00060039,-0.063757,-0.003529,0.45631,-0.3201,0.13091},
      {-0.00012251,0.0032406,-0.65154,5.20E-05,0.00072063,-0.057467,-0.0025636,0.46115,-0.3242,0.13595},
      {-0.0023858,0.0010235,0.70282,-0.00011571,0.00014933,-0.00035121,0.00097441,0.49704,-0.34986,0.18413},
      {-0.0024745,0.00098629,0.70224,-0.00022107,0.00015946,-0.00075813,0.0010674,0.49658,-0.34961,0.18378},
      {-0.0026129,0.00092982,0.70134,-0.00037923,0.00017522,-0.0013966,0.0012111,0.49588,-0.34923,0.18323},
      {-0.0028072,0.00085361,0.70008,-0.00058937,0.00019732,-0.0023012,0.0014104,0.49491,-0.34868,0.18245},
      {-0.0030633,0.00075848,0.69841,-0.00084633,0.0002264,-0.0035074,0.0016686,0.49364,-0.34795,0.1814},
      {-0.0033867,0.00064656,0.69631,-0.0011411,0.00026307,-0.0050525,0.0019878,0.49207,-0.34701,0.18007},
      {-0.0037827,0.00052133,0.69374,-0.0014616,0.00030793,-0.0069767,0.002369,0.49018,-0.34584,0.17841},
      {-0.0042561,0.00038756,0.69065,-0.0017936,0.00036161,-0.0093232,0.0028116,0.48795,-0.3444,0.17639},
      {-0.0048115,0.00025129,0.687,-0.0021227,0.00042475,-0.012138,0.003314,0.48537,-0.34268,0.17396},
      {-0.0037827,0.00017325,0.67199,-0.0016142,0.00048242,-0.030645,0.0026527,0.47537,-0.3356,0.15852},
      {-0.0026717,0.00010261,0.65418,-0.0010731,0.00054903,-0.052437,0.0019337,0.46345,-0.32718,0.14034},
      {-0.0015266,4.70E-05,0.63386,-0.0005405,0.00062642,-0.076802,0.0011936,0.44994,-0.31764,0.12001},
      {-0.00041977,3.81E-06,0.60895,-0.00010936,0.00070145,-0.10543,0.00046887,0.43364,-0.3062,0.096144},
      {-0.00019583,0.00017126,0.54548,-6.05E-05,0.00081906,-0.17777,0.0001259,0.38914,-0.2747,0.035915},
      {-6.85E-06,0.00032829,0.47574,-2.12E-05,0.00094168,-0.25772,-0.00018427,0.33997,-0.23989,-0.030635},
      {0.00015295,0.00046836,0.39981,1.23E-05,0.0010658,-0.34523,-0.00045898,0.28618,-0.20184,-0.10345},
      {0.00019482,0.0022561,0.31028,8.99E-05,0.00089565,-0.4462,-0.0017764,0.22299,-0.15634,-0.18722},
      {0.0001793,0.0044767,0.21696,0.00016754,0.00056021,-0.55105,-0.0033427,0.15717,-0.10878,-0.27408},
      {0.00015438,0.0061601,0.12558,0.00021429,0.00021768,-0.65469,-0.0045249,0.092596,-0.062338,-0.35986},
      {0.00016825,0.011477,0.066522,0.00023911,-5.38E-05,-0.71404,-0.0082071,0.052611,-0.031431,-0.40887},
      {0.00018772,0.01799,0.034019,0.00023373,-0.00024066,-0.73934,-0.012711,0.032678,-0.01407,-0.42962},
      {0.000174,0.022223,0.0071214,0.00019034,-0.00037011,-0.76132,-0.015634,0.016493,-0.00047885,-0.4476},
      {0.00014412,0.027729,-0.017374,0.00013091,-0.00031184,-0.75185,-0.019465,0.018657,0.00082291,-0.43945},
      {7.64E-05,0.031386,-0.042339,2.21E-05,-0.00018398,-0.72425,-0.022005,0.033285,-0.0075542,-0.41629},
      {3.16E-05,0.034141,-0.068691,-9.68E-06,-0.00016094,-0.69286,-0.023935,0.050551,-0.018296,-0.39019},
      {-4.01E-05,0.031345,-0.14294,1.76E-05,-0.00011065,-0.61102,-0.022021,0.10254,-0.056426,-0.32231},
      {-0.00012924,0.024407,-0.25984,5.70E-05,-2.54E-05,-0.484,-0.017235,0.18513,-0.11828,-0.21698},
      {-0.0001882,0.018547,-0.37145,8.40E-05,5.82E-05,-0.36193,-0.013206,0.26394,-0.1769,-0.11575},
      {-0.00021359,0.012794,-0.46042,8.96E-05,0.00015384,-0.26611,-0.0092409,0.32666,-0.22412,-0.036352},
      {-0.00019587,0.0076801,-0.52003,7.69E-05,0.00024992,-0.20376,-0.0056973,0.36854,-0.25635,0.015266},
      {-0.00017333,0.0044623,-0.57514,6.42E-05,0.00030064,-0.14427,-0.0034778,0.40734,-0.28542,0.064553},
      {-0.00014685,0.0028552,-0.61967,4.93E-05,0.00031964,-0.095037,-0.0023733,0.43874,-0.30845,0.10538},
      {-0.00065915,0.00051436,0.70556,0,0.00016746,9.67E-05,0.00010673,0.49905,-0.35229,0.18448},
      {-0.00065862,0.00050067,0.70556,0,0.00017549,0.00010132,0.00011628,0.49905,-0.3523,0.18447},
      {-0.0006955,0.00049451,0.7055,0,0.00019016,0.00010979,0.00014711,0.49902,-0.35226,0.18446},
      {-0.00074502,0.00048597,0.70541,0,0.00021226,0.00012255,0.00018871,0.49897,-0.35221,0.18443},
      {-0.0010315,0.00044921,0.7039,-0.00011812,0.00024894,-0.00093343,0.00042383,0.49793,-0.35146,0.18351},
      {-0.0014529,0.00039677,0.70148,-0.00029371,0.00029609,-0.0026681,0.00076889,0.49629,-0.35028,0.182},
      {-0.0019387,0.0003372,0.6985,-0.00048554,0.00035089,-0.0048354,0.0011664,0.49431,-0.34884,0.18012},
      {-0.0024784,0.0002721,0.69489,-0.00068462,0.00041084,-0.0074916,0.0016079,0.49198,-0.34713,0.17784},
      {-0.0030575,0.00020342,0.69061,-0.00088068,0.00047138,-0.010701,0.0020815,0.48928,-0.34515,0.17509},
      {-0.0036578,0.00013341,0.6856,-0.0010627,0.0005253,-0.014536,0.0025727,0.48622,-0.34287,0.17183},
      {-0.0032721,8.64E-05,0.67053,-0.00091754,0.00058433,-0.031171,0.0023551,0.4764,-0.33597,0.15794},
      {-0.0022917,5.44E-05,0.64738,-0.00060798,0.00065313,-0.057669,0.0017107,0.46116,-0.32534,0.13586},
      {-0.0013187,2.53E-05,0.62104,-0.00033082,0.00071963,-0.087508,0.0010721,0.44382,-0.31326,0.11102},
      {-0.00038454,5.75E-07,0.59136,-9.55E-05,0.00077878,-0.12081,0.0004605,0.42429,-0.29964,0.083313},
      {-8.11E-05,9.50E-05,0.52811,-2.84E-05,0.00087623,-0.19363,0.00014024,0.37973,-0.26817,0.022735},
      {2.97E-05,0.00021084,0.44985,-4.98E-06,0.00098417,-0.28435,-7.85E-05,0.32401,-0.22877,-0.052694},
      {0.00011118,0.00031082,0.36447,1.37E-05,0.0010856,-0.38357,-0.0002633,0.26312,-0.18571,-0.13516},
      {0.00012912,0.0011184,0.27454,4.24E-05,0.00096803,-0.48705,-0.00088172,0.1992,-0.14017,-0.22096},
      {0.00010004,0.0024107,0.18731,6.86E-05,0.00062504,-0.58672,-0.001788,0.13742,-0.095882,-0.30337},
      {6.64E-05,0.0032572,0.1026,7.03E-05,0.00030702,-0.68437,-0.0023765,0.077292,-0.052969,-0.38402},
      {4.30E-05,0.0053288,0.04131,4.94E-05,8.26E-05,-0.75184,-0.0038071,0.034832,-0.021906,-0.43961},
      {2.42E-05,0.0087821,0.018071,2.63E-06,8.92E-06,-0.77081,-0.0061938,0.021079,-0.010417,-0.45503},
      {1.28E-05,0.011638,0.0021716,-1.65E-05,-8.96E-05,-0.78112,-0.0081887,0.012839,-0.0031354,-0.46345},
      {-1.70E-07,0.014738,-0.015935,-2.05E-05,-0.00015821,-0.7744,-0.010364,0.014735,-0.0028873,-0.45782},
      {-2.45E-05,0.017912,-0.044198,-1.92E-05,-0.00014638,-0.73961,-0.012595,0.033684,-0.014628,-0.42894},
      {-4.97E-05,0.019125,-0.075214,-1.94E-05,-0.00012374,-0.70367,-0.013459,0.054741,-0.028848,-0.39911},
      {-8.65E-05,0.017522,-0.13066,-1.09E-05,-7.88E-05,-0.6423,-0.012374,0.093374,-0.056918,-0.3482},
      {-0.00013833,0.012786,-0.24042,1.53E-05,2.88E-06,-0.52102,-0.0091341,0.1709,-0.11407,-0.24763},
      {-0.00018147,0.0087835,-0.34293,3.16E-05,7.32E-05,-0.40728,-0.0064105,0.2433,-0.16721,-0.15333},
      {-0.00020912,0.0054569,-0.43216,3.74E-05,0.0001352,-0.30813,-0.0041542,0.30632,-0.21338,-0.071133},
      {-0.00018509,0.0029505,-0.4859,2.80E-05,0.00018862,-0.24936,-0.002431,0.34417,-0.24144,-0.022442},
      {-0.00016014,0.0020258,-0.53567,2.22E-05,0.00025494,-0.19311,-0.0018235,0.37929,-0.26675,0.02413},
      {-0.00032157,0.00032287,0.70586,0,0.00038574,0.00022271,4.00E-06,0.49927,-0.35271,0.18427},
      {-0.0003378,0.00031986,0.7058,0,0.00041488,0.00023953,1.79E-05,0.49924,-0.35268,0.18424},
      {-0.00036226,0.0003152,0.70571,0,0.00046188,0.00026667,3.90E-05,0.49919,-0.35264,0.1842},
      {-0.00039492,0.00030877,0.70559,0,0.00053118,0.00030667,6.73E-05,0.49912,-0.35258,0.18413},
      {-0.00043509,0.00030045,0.70542,0,0.00062842,0.00036282,0.00010246,0.49903,-0.35249,0.18404},
      {-0.00048138,0.0002902,0.7052,0,0.000761,0.00043936,0.00014355,0.49891,-0.35239,0.18391},
      {-0.00073724,0.00026073,0.70306,-6.42E-05,0.00084758,-0.0011007,0.00035291,0.49761,-0.35141,0.18251},
      {-0.0011594,0.00021642,0.69913,-0.0001729,0.00087532,-0.0041982,0.00069606,0.49524,-0.34964,0.1799},
      {-0.0016011,0.00016996,0.69452,-0.00027754,0.00088593,-0.0079189,0.0010564,0.4925,-0.34759,0.1768},
      {-0.0020432,0.00012297,0.6892,-0.00037138,0.00086763,-0.012337,0.001419,0.48937,-0.34526,0.17316},
      {-0.0024627,7.73E-05,0.68313,-0.00044786,0.00080529,-0.017536,0.0017663,0.48585,-0.34264,0.16894},
      {-0.0024461,4.21E-05,0.67028,-0.00042954,0.00074632,-0.030903,0.001802,0.47774,-0.33689,0.15794},
      {-0.0016408,2.53E-05,0.64292,-0.00027234,0.00079032,-0.061573,0.0012746,0.45964,-0.3243,0.13244},
      {-0.00089279,1.23E-05,0.61246,-0.0001429,0.00081867,-0.09549,0.00078787,0.43949,-0.31027,0.10427},
      {-0.00023719,4.03E-06,0.57884,-4.50E-05,0.00082422,-0.1327,0.00036593,0.41724,-0.29473,0.073403},
      {3.63E-05,5.48E-05,0.51586,-5.67E-06,0.00086846,-0.20508,0.00012072,0.37304,-0.26356,0.013302},
      {7.60E-05,0.00013548,0.42725,5.81E-06,0.00094736,-0.30829,-1.86E-05,0.30975,-0.21882,-0.072411},
      {8.70E-05,0.00020164,0.33057,1.39E-05,0.0010117,-0.42095,-0.00012649,0.24071,-0.17002,-0.16593},
      {6.61E-05,0.00046804,0.23298,1.75E-05,0.00095284,-0.53443,-0.00034187,0.17113,-0.12073,-0.25996},
      {3.64E-05,0.0010681,0.15488,8.74E-06,0.00065783,-0.62506,-0.00076296,0.11552,-0.081111,-0.33473},
      {1.77E-05,0.0015804,0.084911,2.16E-06,0.00037753,-0.70653,-0.0011364,0.065495,-0.045478,-0.40196},
      {2.01E-06,0.0024623,0.025946,-5.03E-06,0.00013724,-0.77353,-0.0017658,0.024029,-0.015708,-0.45725},
      {-2.72E-06,0.0050045,0.012231,-1.36E-05,2.49E-05,-0.7802,-0.0035472,0.01818,-0.01028,-0.46268},
      {-9.05E-06,0.0066995,-0.00086504,-2.17E-05,-6.52E-05,-0.7856,-0.004737,0.013696,-0.0062442,-0.46709},
      {-1.82E-05,0.0077592,-0.015644,-2.84E-05,-0.00012178,-0.78454,-0.0054857,0.013595,-0.0056217,-0.46615},
      {-4.19E-05,0.0088887,-0.04798,-2.88E-05,-9.44E-05,-0.74708,-0.006297,0.035642,-0.020584,-0.43506},
      {-6.77E-05,0.0087351,-0.082551,-3.00E-05,-6.24E-05,-0.70832,-0.0062198,0.059407,-0.037408,-0.4029},
      {-9.46E-05,0.0074397,-0.12209,-3.12E-05,-2.53E-05,-0.66488,-0.0053551,0.086849,-0.057409,-0.36688},
      {-0.0001313,0.0044592,-0.22216,-1.55E-05,4.29E-05,-0.55274,-0.0033478,0.15755,-0.10883,-0.2739},
      {-0.00016123,0.0021315,-0.31339,-6.93E-06,0.00010093,-0.45005,-0.0017963,0.22201,-0.15551,-0.18876},
      {-0.00018129,0.0013687,-0.39612,2.15E-06,0.00034572,-0.3549,-0.0013552,0.2805,-0.19716,-0.11018},
      {-0.00016159,0.0013708,-0.44912,5.03E-06,0.00056644,-0.29342,-0.0014182,0.31793,-0.22362,-0.059494},
      {-0.00012217,0.00017805,0.70604,0,0.00060235,0.00034777,-3.59E-05,0.49936,-0.35295,0.18406},
      {-0.00013168,0.00017586,0.70596,0,0.00066241,0.00038244,-2.72E-05,0.49931,-0.35291,0.184},
      {-0.0001459,0.00017247,0.70583,0,0.00075802,0.00043765,-1.43E-05,0.49923,-0.35285,0.18391},
      {-0.00016464,0.00016779,0.70564,0,0.00089636,0.00051752,2.98E-06,0.49913,-0.35277,0.18378},
      {-0.00018723,0.00016175,0.70539,0,0.0010859,0.00062696,2.42E-05,0.49898,-0.35265,0.1836},
      {-0.0002125,0.0001543,0.70506,0,0.0013371,0.00077198,4.84E-05,0.49879,-0.35251,0.18336},
      {-0.0002388,0.00014547,0.70465,0,0.0016627,0.00095996,7.46E-05,0.49854,-0.35233,0.18305},
      {-0.00026401,0.00013527,0.70414,0,0.0020784,0.0011999,0.00010126,0.49824,-0.3521,0.18265},
      {-0.00051513,0.00010884,0.69984,-3.82E-05,0.0020577,-0.0025414,0.00031066,0.49574,-0.35024,0.17957},
      {-0.00077868,8.05E-05,0.69433,-7.46E-05,0.0019157,-0.0075899,0.00053346,0.49255,-0.34789,0.17559},
      {-0.00099798,5.36E-05,0.68811,-0.00010025,0.0017029,-0.013492,0.00072547,0.48897,-0.34527,0.171},
      {-0.0011462,2.97E-05,0.68115,-0.00011268,0.0013974,-0.02034,0.00086667,0.48497,-0.34238,0.16577},
      {-0.0011546,1.09E-05,0.672,-0.00010685,0.0010063,-0.029873,0.00090747,0.47953,-0.33851,0.15842},
      {-0.00062187,8.05E-06,0.64112,-5.40E-05,0.00099192,-0.064089,0.00056729,0.459,-0.32418,0.13007},
      {-0.00019894,9.35E-06,0.60731,-1.87E-05,0.00094681,-0.10139,0.00030468,0.4365,-0.30842,0.0992},
      {7.64E-05,1.55E-05,0.57059,-3.12E-07,0.00086222,-0.14178,0.00014596,0.41204,-0.29122,0.065834},
      {0.00014109,4.28E-05,0.51,5.01E-06,0.00080496,-0.21118,8.23E-05,0.36962,-0.26125,0.0083707},
      {0.00011031,9.33E-05,0.41402,8.24E-06,0.00084471,-0.3237,7.89E-06,0.30066,-0.21249,-0.084989},
      {8.33E-05,0.00013517,0.31446,1.01E-05,0.00083643,-0.44001,-5.49E-05,0.22943,-0.16212,-0.18142},
      {5.05E-05,0.00021604,0.21663,9.83E-06,0.00078224,-0.55395,-0.00014555,0.15966,-0.11277,-0.27583},
      {3.25E-05,0.00060764,0.14901,1.97E-06,0.00050702,-0.63252,-0.00043472,0.1115,-0.078511,-0.34065},
      {1.50E-05,0.00088644,0.083368,-6.08E-06,0.00027577,-0.70852,-0.00064538,0.064954,-0.045454,-0.4034},
      {-1.30E-06,0.0010535,0.02037,-1.43E-05,9.04E-05,-0.78116,-0.00077807,0.020504,-0.013937,-0.46341},
      {-7.60E-06,0.0023782,0.0071965,-2.21E-05,1.57E-05,-0.78598,-0.0017108,0.01663,-0.010519,-0.46734},
      {-1.41E-05,0.0030886,-0.0049691,-2.95E-05,-3.70E-05,-0.78864,-0.0022166,0.014503,-0.0086453,-0.46949},
      {-2.05E-05,0.0032247,-0.016533,-3.67E-05,-6.75E-05,-0.78952,-0.0023243,0.013869,-0.0081167,-0.47018},
      {-4.23E-05,0.0030795,-0.050322,-3.86E-05,-3.65E-05,-0.75258,-0.0022571,0.036519,-0.024153,-0.43953},
      {-6.47E-05,0.002206,-0.088357,-4.09E-05,1.61E-06,-0.71032,-0.001692,0.062938,-0.043218,-0.40449},
      {-8.33E-05,0.0011706,-0.12862,-4.31E-05,0.00019361,-0.66508,-0.0010244,0.091122,-0.063613,-0.36722},
      {-0.000103,0.00089151,-0.20779,-3.23E-05,0.00074979,-0.57288,-0.00090993,0.14711,-0.10326,-0.29154},
      {-0.00012108,0.00070414,-0.28839,-2.06E-05,0.0011303,-0.47923,-0.00087282,0.20412,-0.14357,-0.21439},
      {-0.0001357,0.00059239,-0.36052,-1.06E-05,0.0013152,-0.39564,-0.00089651,0.25511,-0.17959,-0.14532},
      {-2.03E-05,6.89E-05,0.7065,0,0.00044738,0.00025829,-3.29E-05,0.49962,-0.35324,0.18421},
      {-2.43E-05,6.74E-05,0.70638,0,0.00054651,0.00031553,-2.87E-05,0.49955,-0.35319,0.18411},
      {-3.01E-05,6.50E-05,0.7062,0,0.00070311,0.00040594,-2.24E-05,0.49943,-0.3531,0.18396},
      {-3.74E-05,6.18E-05,0.70594,0,0.00092722,0.00053533,-1.43E-05,0.49927,-0.35299,0.18375},
      {-4.55E-05,5.77E-05,0.70558,0,0.00123,0.00071016,-4.79E-06,0.49905,-0.35283,0.18346},
      {-5.33E-05,5.26E-05,0.70513,0,0.0016245,0.00093792,5.44E-06,0.49877,-0.35263,0.18308},
      {-5.95E-05,4.66E-05,0.70456,0,0.0021261,0.0012275,1.54E-05,0.49842,-0.35238,0.1826},
      {-6.25E-05,3.97E-05,0.70386,0,0.0027528,0.0015893,2.38E-05,0.49797,-0.35206,0.182},
      {-6.00E-05,3.19E-05,0.703,0,0.0035262,0.0020358,2.92E-05,0.49743,-0.35169,0.18126},
      {-7.19E-05,2.19E-05,0.70034,-1.56E-06,0.0040048,0.00029529,5.16E-05,0.49585,-0.35056,0.17913},
      {-7.42E-05,1.00E-05,0.69407,-2.94E-06,0.0035978,-0.0063479,7.91E-05,0.4922,-0.34797,0.17421},
      {2.35E-06,1.64E-06,0.68701,-4.28E-07,0.0030982,-0.014067,5.00E-05,0.48804,-0.34506,0.16852},
      {9.02E-06,1.25E-07,0.67797,-5.99E-07,0.0026318,-0.024014,7.01E-05,0.48243,-0.34107,0.16095},
      {2.30E-05,-1.25E-06,0.66752,-7.47E-07,0.0015418,-0.036686,9.33E-05,0.4758,-0.33637,0.152},
      {6.67E-05,2.88E-06,0.63596,1.69E-07,0.0011684,-0.072227,0.00010439,0.45441,-0.32123,0.12307},
      {0.00011489,7.70E-06,0.59791,1.20E-06,0.001003,-0.11492,0.00011446,0.42842,-0.30284,0.087909},
      {0.00016086,1.20E-05,0.55719,2.10E-06,0.00077693,-0.16093,0.00012584,0.40045,-0.28306,0.05008},
      {0.00018586,2.27E-05,0.50255,2.93E-06,0.00053636,-0.22368,0.00012119,0.36227,-0.25605,-0.0016008},
      {0.00014286,5.44E-05,0.40472,3.40E-06,0.0005252,-0.33749,5.76E-05,0.29258,-0.20678,-0.095959},
      {9.57E-05,7.85E-05,0.30482,2.80E-06,0.00050481,-0.45342,-1.76E-06,0.22163,-0.15663,-0.19205},
      {4.66E-05,9.45E-05,0.2034,1.03E-06,0.00047482,-0.57083,-5.49E-05,0.14978,-0.10584,-0.28936},
      {2.73E-05,0.00027959,0.1386,-6.62E-06,0.00030361,-0.64551,-0.00020262,0.10405,-0.073416,-0.35108},
      {1.19E-05,0.00039357,0.078721,-1.49E-05,0.00016009,-0.7142,-0.00029898,0.06202,-0.043636,-0.40787},
      {-6.40E-07,0.00042659,0.022031,-2.34E-05,5.51E-05,-0.77886,-0.00033833,0.022482,-0.015661,-0.46135},
      {-7.31E-06,0.00076992,0.0017511,-3.09E-05,1.00E-05,-0.7921,-0.00059118,0.014143,-0.0095822,-0.47227},
      {-1.23E-05,0.00082288,-0.0095873,-3.79E-05,-7.77E-06,-0.79163,-0.00064415,0.014391,-0.0097181,-0.47184},
      {-1.58E-05,0.00056863,-0.020334,-4.47E-05,-5.28E-06,-0.789,-0.00048761,0.016171,-0.011091,-0.46963},
      {-2.97E-05,0.00048738,-0.050978,-4.71E-05,0.00016113,-0.7556,-0.00047462,0.036425,-0.025405,-0.44218},
      {-4.49E-05,0.00032854,-0.091869,-4.70E-05,0.00073734,-0.70766,-0.00042289,0.065201,-0.04577,-0.40325},
      {-5.61E-05,0.00011964,-0.13425,-4.58E-05,0.0017757,-0.65722,-0.00034474,0.095049,-0.066916,-0.36291},
      {-6.92E-05,8.48E-05,-0.19357,-3.76E-05,0.0024058,-0.58761,-0.00040199,0.13696,-0.09649,-0.30608},
      {-8.49E-05,0.00012055,-0.26149,-2.58E-05,0.0023413,-0.5091,-0.00052252,0.18499,-0.13035,-0.24087},
      {0,2.02E-06,0.70708,0,2.12E-05,1.22E-05,-1.43E-06,0.49998,-0.35354,0.18462},
      {0,2.07E-06,0.70708,0,2.17E-05,1.25E-05,-1.46E-06,0.49998,-0.35354,0.18462},
      {0,2.14E-06,0.70708,0,2.26E-05,1.31E-05,-1.51E-06,0.49998,-0.35354,0.18462},
      {1.97E-07,2.22E-06,0.7067,0,0.00037881,0.0002187,-1.01E-06,0.49973,-0.35336,0.18427},
      {5.75E-07,2.31E-06,0.70602,0,0.0010184,0.00058795,-1.30E-07,0.49928,-0.35304,0.18366},
      {1.13E-06,2.42E-06,0.70508,0,0.0019048,0.0010997,9.86E-07,0.49865,-0.35259,0.18281},
      {1.93E-06,2.53E-06,0.70382,0,0.0031057,0.0017931,2.36E-06,0.4978,-0.35199,0.18166},
      {3.02E-06,2.65E-06,0.70216,0,0.0047024,0.002715,4.02E-06,0.49667,-0.35119,0.18013},
      {4.47E-06,2.77E-06,0.7,0,0.0067903,0.0039204,5.97E-06,0.49519,-0.35014,0.17814},
      {6.34E-06,2.87E-06,0.69723,0,0.0094786,0.0054725,8.21E-06,0.49329,-0.3488,0.17556},
      {8.67E-06,2.95E-06,0.69373,0,0.01289,0.007442,1.08E-05,0.49087,-0.34709,0.1723},
      {2.14E-05,1.97E-06,0.68524,-1.08E-07,0.011901,-0.0031216,2.95E-05,0.48543,-0.34323,0.16496},
      {3.76E-05,9.63E-07,0.67514,-2.15E-07,0.0099287,-0.017183,5.05E-05,0.47889,-0.33859,0.15613},
      {5.67E-05,2.81E-08,0.66355,-3.08E-07,0.0071778,-0.034345,7.19E-05,0.47128,-0.33319,0.14585},
      {7.82E-05,-8.03E-07,0.65027,-3.83E-07,0.0035142,-0.055104,9.34E-05,0.46243,-0.32692,0.1339},
      {0.0001092,1.15E-06,0.62067,4.44E-08,0.001715,-0.091334,0.00010723,0.44213,-0.31256,0.10644},
      {0.00014233,4.34E-06,0.57976,6.72E-07,0.0013855,-0.13807,0.00011653,0.41385,-0.29254,0.068166},
      {0.00017086,6.94E-06,0.53614,1.16E-06,0.00091336,-0.18832,0.00012507,0.38356,-0.27112,0.027182},
      {0.00018999,9.67E-06,0.4876,1.41E-06,0.00029109,-0.24471,0.00012906,0.34968,-0.24715,-0.018688},
      {0.00013534,2.58E-05,0.38985,-3.52E-07,0.00027275,-0.35776,7.23E-05,0.28049,-0.19825,-0.1124},
      {8.31E-05,3.53E-05,0.29053,-3.14E-06,0.00024653,-0.47239,2.33E-05,0.21035,-0.14868,-0.2074},
      {3.63E-05,3.78E-05,0.19016,-7.01E-06,0.00021224,-0.58798,-1.58E-05,0.13962,-0.09869,-0.3032},
      {1.61E-05,7.89E-05,0.12364,-1.45E-05,0.00012709,-0.66402,-6.54E-05,0.093096,-0.065779,-0.36614},
      {5.66E-06,8.22E-05,0.070331,-2.31E-05,5.58E-05,-0.72442,-8.43E-05,0.056164,-0.039663,-0.41612},
      {-1.72E-07,5.10E-05,0.021239,-3.22E-05,1.89E-05,-0.7796,-7.86E-05,0.022418,-0.015816,-0.46182},
      {-3.92E-06,8.82E-05,-0.0022671,-4.05E-05,1.24E-05,-0.7969,-0.00012437,0.011758,-0.0082486,-0.47616},
      {-7.16E-06,8.64E-05,-0.012338,-4.68E-05,1.99E-05,-0.79234,-0.00014738,0.014495,-0.010167,-0.4724},
      {-9.37E-06,2.90E-05,-0.022569,-5.17E-05,3.74E-05,-0.78665,-0.00013516,0.017958,-0.012625,-0.4677},
      {-1.61E-05,4.52E-06,-0.047239,-5.26E-05,0.00042395,-0.76025,-0.00016269,0.033668,-0.023705,-0.44637},
      {-2.59E-05,-4.22E-05,-0.085981,-4.98E-05,0.0013586,-0.714,-0.00019431,0.060957,-0.042964,-0.40936},
      {-3.23E-05,-0.00010482,-0.12284,-4.57E-05,0.0024639,-0.66961,-0.00021938,0.08694,-0.061308,-0.37414},
      {-4.04E-05,-0.00014771,-0.16829,-3.82E-05,0.0031568,-0.61593,-0.00027043,0.11903,-0.083949,-0.33062},
      {0,9.02E-07,0.70709,0,1.28E-05,7.41E-06,-6.38E-07,0.49999,-0.35355,0.18462},
      {0,9.28E-07,0.70709,0,1.33E-05,7.67E-06,-6.56E-07,0.49999,-0.35355,0.18462},
      {0,9.66E-07,0.70709,0,1.40E-05,8.06E-06,-6.83E-07,0.49999,-0.35355,0.18462},
      {0,1.02E-06,0.70709,0,1.49E-05,8.59E-06,-7.19E-07,0.49999,-0.35354,0.18462},
      {0,1.08E-06,0.70709,0,1.61E-05,9.28E-06,-7.63E-07,0.49999,-0.35354,0.18462},
      {0,1.15E-06,0.70709,0,1.75E-05,1.01E-05,-8.13E-07,0.49999,-0.35354,0.18462},
      {1.36E-06,1.21E-06,0.7051,0,0.0019633,0.0011335,5.90E-07,0.49861,-0.35257,0.18276},
      {3.16E-06,1.26E-06,0.70238,0,0.0046269,0.0026714,2.39E-06,0.49672,-0.35123,0.18021},
      {5.28E-06,1.31E-06,0.69903,0,0.0079164,0.0045706,4.42E-06,0.4944,-0.34959,0.17706},
      {7.71E-06,1.35E-06,0.69495,0,0.011932,0.0068888,6.68E-06,0.49155,-0.34758,0.17321},
      {1.05E-05,1.37E-06,0.69003,0,0.016784,0.0096902,9.11E-06,0.48812,-0.34515,0.16857},
      {1.35E-05,1.37E-06,0.68415,0,0.022595,0.013045,1.17E-05,0.48401,-0.34224,0.163},
      {2.60E-05,1.00E-06,0.67454,-3.48E-08,0.023167,0.0033997,2.36E-05,0.47748,-0.33761,0.15418},
      {4.60E-05,4.25E-07,0.66142,-8.57E-08,0.018884,-0.018456,4.18E-05,0.46862,-0.33134,0.14221},
      {6.61E-05,-6.83E-08,0.64632,-1.25E-07,0.013677,-0.044247,5.89E-05,0.45834,-0.32405,0.12831},
      {8.56E-05,-4.61E-07,0.62898,-1.49E-07,0.0074329,-0.074498,7.43E-05,0.44642,-0.31561,0.11219},
      {0.00010398,2.34E-07,0.60012,-1.19E-08,0.0030893,-0.11473,8.43E-05,0.42638,-0.30143,0.085072},
      {0.00011867,1.90E-06,0.55637,2.35E-07,0.0023978,-0.16579,8.82E-05,0.39583,-0.27983,0.043726},
      {0.0001264,2.96E-06,0.50989,3.34E-07,0.0014762,-0.22056,8.91E-05,0.36327,-0.2568,-0.00035994},
      {0.00012562,3.33E-06,0.46069,2.63E-07,0.00027585,-0.27913,8.61E-05,0.32868,-0.23234,-0.047205},
      {8.03E-05,5.96E-06,0.36935,-3.12E-06,8.70E-05,-0.38452,4.85E-05,0.26437,-0.18689,-0.13431},
      {3.83E-05,3.55E-06,0.27137,-7.86E-06,5.70E-05,-0.49708,1.73E-05,0.19549,-0.13822,-0.2276},
      {1.74E-05,1.88E-06,0.17484,-1.38E-05,5.01E-05,-0.60781,-1.26E-06,0.1277,-0.09029,-0.3194},
      {7.72E-06,2.03E-06,0.1091,-2.24E-05,3.79E-05,-0.68251,-1.89E-05,0.081942,-0.05794,-0.38133},
      {4.22E-06,-3.16E-06,0.064453,-3.28E-05,2.45E-05,-0.73218,-3.26E-05,0.051506,-0.036421,-0.4225},
      {1.25E-06,-9.81E-06,0.022812,-4.47E-05,1.62E-05,-0.77771,-4.56E-05,0.023603,-0.016693,-0.46024},
      {-1.19E-06,-1.59E-05,-0.003282,-5.44E-05,1.87E-05,-0.79903,-6.27E-05,0.010509,-0.0074308,-0.47792},
      {-2.86E-06,-2.60E-05,-0.012945,-5.84E-05,3.71E-05,-0.79331,-8.38E-05,0.013959,-0.0098549,-0.47321},
      {-3.66E-06,-4.61E-05,-0.022192,-5.95E-05,6.16E-05,-0.78726,-0.00010066,0.017614,-0.012426,-0.46823},
      {-5.98E-06,-8.02E-05,-0.038977,-5.72E-05,0.00035567,-0.77022,-0.00011935,0.027713,-0.019548,-0.45452},
      {-1.20E-05,-0.00013799,-0.074315,-5.24E-05,0.0013505,-0.72777,-0.00014741,0.052626,-0.037133,-0.42075},
      {-1.54E-05,-0.00020406,-0.10725,-4.61E-05,0.0023525,-0.68807,-0.00017302,0.075858,-0.053533,-0.38927},
      {0,3.03E-07,0.7071,0,7.28E-06,4.21E-06,-2.14E-07,0.49999,-0.35355,0.18463},
      {0,3.15E-07,0.7071,0,7.64E-06,4.41E-06,-2.22E-07,0.49999,-0.35355,0.18463},
      {0,3.32E-07,0.7071,0,8.18E-06,4.72E-06,-2.35E-07,0.49999,-0.35355,0.18463},
      {0,3.54E-07,0.7071,0,8.92E-06,5.15E-06,-2.50E-07,0.49999,-0.35355,0.18463},
      {0,3.81E-07,0.7071,0,9.87E-06,5.70E-06,-2.69E-07,0.49999,-0.35355,0.18463},
      {0,4.10E-07,0.7071,0,1.10E-05,6.37E-06,-2.90E-07,0.49999,-0.35355,0.18463},
      {0,4.40E-07,0.70709,0,1.24E-05,7.16E-06,-3.11E-07,0.49999,-0.35355,0.18463},
      {0,4.67E-07,0.70709,0,1.40E-05,8.06E-06,-3.30E-07,0.49999,-0.35355,0.18462},
      {2.00E-06,4.79E-07,0.70301,0,0.0040543,0.0023408,1.32E-06,0.49713,-0.35152,0.18076},
      {4.38E-06,4.81E-07,0.69769,0,0.0093208,0.0053814,3.26E-06,0.49341,-0.34889,0.17571},
      {6.89E-06,4.74E-07,0.69143,0,0.015538,0.0089706,5.27E-06,0.48901,-0.34578,0.16976},
      {9.45E-06,4.54E-07,0.6841,0,0.022815,0.013172,7.26E-06,0.48386,-0.34213,0.16279},
      {1.19E-05,4.20E-07,0.67559,0,0.031273,0.018056,9.14E-06,0.47788,-0.3379,0.1547},
      {1.83E-05,3.08E-07,0.66418,-5.58E-09,0.03629,0.013745,1.41E-05,0.46991,-0.33227,0.14392},
      {3.34E-05,8.07E-08,0.64692,-1.96E-08,0.029655,-0.017247,2.56E-05,0.45796,-0.32381,0.12775},
      {4.56E-05,-6.92E-08,0.62715,-2.55E-08,0.021977,-0.05302,3.44E-05,0.44419,-0.31406,0.10911},
      {5.33E-05,-1.32E-07,0.60455,-2.31E-08,0.01316,-0.094117,3.95E-05,0.42837,-0.30287,0.087699},
      {5.47E-05,2.52E-08,0.57452,-2.16E-08,0.0053688,-0.14206,3.94E-05,0.40727,-0.28796,0.059139},
      {5.07E-05,3.09E-07,0.52765,-1.27E-07,0.0040547,-0.19821,3.55E-05,0.37428,-0.26463,0.014465},
      {5.81E-05,4.79E-07,0.47634,-3.18E-07,0.0022723,-0.26038,4.04E-05,0.3381,-0.23904,-0.034519},
      {6.50E-05,5.52E-07,0.42219,-6.30E-07,0.00051472,-0.32587,4.50E-05,0.29985,-0.21199,-0.0863},
      {5.54E-05,-4.52E-07,0.3391,-5.49E-06,2.90E-05,-0.42179,3.49E-05,0.24162,-0.17083,-0.16514},
      {3.72E-05,-3.12E-06,0.24725,-1.37E-05,2.80E-05,-0.52671,1.72E-05,0.17737,-0.12541,-0.25213},
      {1.86E-05,-7.45E-06,0.15829,-2.42E-05,2.66E-05,-0.62826,-1.29E-06,0.11518,-0.081448,-0.33633},
      {6.71E-06,-1.35E-05,0.091865,-3.68E-05,2.25E-05,-0.70319,-1.77E-05,0.06928,-0.049005,-0.39845},
      {4.01E-06,-2.18E-05,0.054483,-4.99E-05,1.72E-05,-0.74357,-2.98E-05,0.044529,-0.031509,-0.43192},
      {1.86E-06,-3.23E-05,0.020979,-6.40E-05,1.47E-05,-0.7792,-4.07E-05,0.022679,-0.016066,-0.46147},
      {3.90E-07,-4.60E-05,-0.0038806,-7.57E-05,2.01E-05,-0.80148,-5.26E-05,0.0089987,-0.0063962,-0.47995},
      {-2.13E-07,-6.78E-05,-0.01261,-7.53E-05,4.57E-05,-0.79552,-6.94E-05,0.012601,-0.0089289,-0.47505},
      {-2.24E-07,-9.53E-05,-0.02072,-7.10E-05,7.57E-05,-0.78954,-8.42E-05,0.016222,-0.011474,-0.47013},
      {-1.49E-07,-0.00012867,-0.030162,-6.29E-05,0.00017871,-0.78096,-9.93E-05,0.021365,-0.015092,-0.46316},
      {-3.34E-06,-0.00018814,-0.061379,-5.59E-05,0.0010163,-0.74351,-0.00012882,0.043394,-0.030639,-0.43331},
      {0,5.47E-08,0.7071,0,3.58E-06,2.06E-06,-3.87E-08,0.5,-0.35355,0.18463},
      {0,5.81E-08,0.7071,0,3.87E-06,2.24E-06,-4.11E-08,0.5,-0.35355,0.18463},
      {0,6.29E-08,0.7071,0,4.33E-06,2.50E-06,-4.45E-08,0.5,-0.35355,0.18463},
      {0,6.88E-08,0.7071,0,4.95E-06,2.86E-06,-4.87E-08,0.5,-0.35355,0.18463},
      {0,7.54E-08,0.7071,0,5.77E-06,3.33E-06,-5.33E-08,0.5,-0.35355,0.18463},
      {0,8.17E-08,0.7071,0,6.76E-06,3.91E-06,-5.78E-08,0.5,-0.35355,0.18463},
      {0,8.67E-08,0.7071,0,7.95E-06,4.59E-06,-6.13E-08,0.49999,-0.35355,0.18463},
      {0,8.93E-08,0.7071,0,9.32E-06,5.38E-06,-6.31E-08,0.49999,-0.35355,0.18463},
      {0,8.82E-08,0.7071,0,1.09E-05,6.28E-06,-6.24E-08,0.49999,-0.35355,0.18463},
      {3.87E-07,8.18E-08,0.70561,0,0.0014898,0.00086014,2.30E-07,0.49895,-0.35281,0.18321},
      {2.12E-06,6.81E-08,0.69807,0,0.0089978,0.0051949,1.52E-06,0.49364,-0.34905,0.17602},
      {3.67E-06,5.01E-08,0.68936,0,0.01767,0.010201,2.64E-06,0.4875,-0.34471,0.16772},
      {4.88E-06,2.85E-08,0.67938,0,0.027614,0.015943,3.50E-06,0.48047,-0.33974,0.1582},
      {5.56E-06,5.20E-09,0.66802,0,0.038945,0.022485,3.95E-06,0.47246,-0.33408,0.14735},
      {6.91E-06,0,0.65716,0,0.048855,0.027154,4.88E-06,0.4648,-0.32866,0.13699},
      {1.56E-05,0,0.63653,0,0.037333,-0.016434,1.10E-05,0.45033,-0.31842,0.11739},
      {2.57E-05,0,0.61125,0,0.025792,-0.065443,1.82E-05,0.43255,-0.30585,0.093334},
      {3.69E-05,0,0.58043,0,0.014672,-0.12013,2.61E-05,0.41085,-0.29049,0.063957},
      {4.85E-05,8.30E-10,0.54283,-2.82E-08,0.004708,-0.18067,3.43E-05,0.38434,-0.27174,0.028075},
      {5.60E-05,-7.42E-08,0.49128,-6.37E-07,0.0030689,-0.24278,3.92E-05,0.34803,-0.24607,-0.021075},
      {6.18E-05,-3.50E-07,0.4358,-1.60E-06,0.0016477,-0.30908,4.28E-05,0.30893,-0.21842,-0.074008},
      {6.57E-05,-8.79E-07,0.37634,-3.03E-06,0.00046344,-0.37961,4.50E-05,0.26699,-0.18876,-0.13078},
      {5.52E-05,-3.81E-06,0.3011,-1.01E-05,1.54E-05,-0.46654,3.43E-05,0.21423,-0.15146,-0.20222},
      {3.52E-05,-9.81E-06,0.2177,-2.34E-05,1.44E-05,-0.56165,1.43E-05,0.15598,-0.11029,-0.28108},
      {1.69E-05,-1.77E-05,0.13775,-3.96E-05,1.31E-05,-0.6528,-5.23E-06,0.10015,-0.070833,-0.35665},
      {4.63E-06,-2.75E-05,0.072957,-5.75E-05,1.16E-05,-0.72595,-2.18E-05,0.055324,-0.039158,-0.41731},
      {2.77E-06,-3.91E-05,0.043314,-7.27E-05,1.15E-05,-0.75698,-3.23E-05,0.036295,-0.02571,-0.44303},
      {1.49E-06,-5.24E-05,0.017289,-8.88E-05,1.35E-05,-0.78367,-4.19E-05,0.019916,-0.014139,-0.46517},
      {8.73E-07,-6.79E-05,-0.0042128,-0.00010467,1.89E-05,-0.80436,-5.13E-05,0.0072076,-0.0051629,-0.48233},
      {9.17E-07,-9.49E-05,-0.011714,-9.83E-05,4.90E-05,-0.79862,-6.70E-05,0.010685,-0.0076036,-0.47762},
      {1.06E-06,-0.0001205,-0.01839,-8.89E-05,8.34E-05,-0.793,-8.34E-05,0.014088,-0.0099891,-0.473},
      {1.13E-06,-0.00014293,-0.024246,-7.31E-05,0.00012049,-0.78781,-9.90E-05,0.017229,-0.012183,-0.46876},
      {0,3.98E-10,0.70711,0,8.64E-07,4.99E-07,-2.81E-10,0.5,-0.35355,0.18464},
      {0,4.11E-10,0.70711,0,1.12E-06,6.48E-07,-2.91E-10,0.5,-0.35355,0.18464},
      {0,3.40E-10,0.70711,0,1.52E-06,8.78E-07,-2.40E-10,0.5,-0.35355,0.18464},
      {0,5.52E-11,0.7071,0,2.07E-06,1.19E-06,-3.90E-11,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.75E-06,1.59E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.56E-06,2.05E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.48E-06,2.59E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.50E-06,3.17E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,6.57E-06,3.79E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,7.68E-06,4.43E-06,0,0.49999,-0.35355,0.18463},
      {0,0,0.7071,0,8.76E-06,5.06E-06,0,0.49999,-0.35355,0.18463},
      {1.06E-06,0,0.70179,0,0.0052986,0.0030591,7.50E-07,0.49625,-0.3509,0.17956},
      {2.77E-06,0,0.69398,0,0.013087,0.0075557,1.96E-06,0.49074,-0.34701,0.17211},
      {4.65E-06,0,0.68623,0,0.020814,0.012017,3.29E-06,0.48528,-0.34314,0.16471},
      {6.69E-06,0,0.67873,0,0.028286,0.016331,4.73E-06,0.47999,-0.3394,0.15756},
      {8.84E-06,0,0.6717,0,0.0353,0.02038,6.25E-06,0.47503,-0.33589,0.15084},
      {1.80E-05,0,0.64486,0,0.028979,-0.021453,1.28E-05,0.45611,-0.32251,0.12523},
      {2.92E-05,0,0.60775,0,0.019736,-0.080194,2.06E-05,0.42994,-0.304,0.0898},
      {4.01E-05,0,0.56442,0,0.011142,-0.14501,2.83E-05,0.39935,-0.28236,0.048396},
      {5.02E-05,0,0.51424,0,0.0034079,-0.21628,3.55E-05,0.36391,-0.25729,0.00041252},
      {5.24E-05,-5.89E-07,0.45733,-1.50E-06,0.0017474,-0.2847,3.65E-05,0.32376,-0.22891,-0.053934},
      {5.21E-05,-1.55E-06,0.3965,-3.73E-06,0.00092435,-0.35622,3.55E-05,0.28084,-0.19856,-0.11205},
      {4.98E-05,-2.88E-06,0.33184,-6.67E-06,0.000293,-0.43186,3.28E-05,0.23518,-0.16628,-0.17386},
      {3.97E-05,-7.16E-06,0.26054,-1.56E-05,6.11E-06,-0.51416,2.22E-05,0.18508,-0.13086,-0.24169},
      {2.24E-05,-1.67E-05,0.18619,-3.51E-05,5.37E-06,-0.59884,2.64E-06,0.1332,-0.094203,-0.3119},
      {9.14E-06,-2.83E-05,0.11583,-5.80E-05,4.61E-06,-0.67897,-1.50E-05,0.084101,-0.059507,-0.37834},
      {1.48E-06,-4.18E-05,0.053791,-8.38E-05,4.26E-06,-0.74934,-2.97E-05,0.040971,-0.029032,-0.43669},
      {5.04E-07,-5.57E-05,0.031258,-0.00010091,8.08E-06,-0.77192,-3.92E-05,0.027104,-0.019238,-0.45542},
      {5.22E-07,-7.00E-05,0.012521,-0.0001227,1.44E-05,-0.78989,-4.90E-05,0.016052,-0.011438,-0.47033},
      {6.45E-07,-8.53E-05,-0.0032945,-0.00014762,2.23E-05,-0.80436,-5.97E-05,0.007138,-0.0051519,-0.48234},
      {7.37E-07,-0.00010764,-0.010358,-0.00014058,5.24E-05,-0.8013,-7.53E-05,0.0089755,-0.0064328,-0.47984},
      {8.11E-07,-0.00012906,-0.01565,-0.00012682,8.65E-05,-0.79652,-9.02E-05,0.01187,-0.0084546,-0.47593},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.93E-07,1.12E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.70E-07,3.87E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.21E-06,6.98E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,1.80E-06,1.04E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.41E-06,1.39E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.03E-06,1.75E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.62E-06,2.09E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.16E-06,2.40E-06,0,0.5,-0.35355,0.18463},
      {4.79E-07,0,0.70558,0,0.0015213,0.00087833,3.38E-07,0.49892,-0.35279,0.18318},
      {2.39E-06,0,0.69978,0,0.0073097,0.0042203,1.69E-06,0.49483,-0.3499,0.17764},
      {4.33E-06,0,0.69429,0,0.012785,0.0073815,3.06E-06,0.49096,-0.34716,0.1724},
      {6.24E-06,0,0.68929,0,0.017763,0.010255,4.41E-06,0.48744,-0.34467,0.16763},
      {8.05E-06,0,0.685,0,0.022049,0.01273,5.70E-06,0.4844,-0.34252,0.16353},
      {1.43E-05,0,0.65764,0,0.019398,-0.023402,1.01E-05,0.46508,-0.32886,0.13737},
      {2.29E-05,0,0.60808,0,0.012703,-0.09217,1.62E-05,0.43007,-0.30409,0.089971},
      {2.99E-05,0,0.55164,0,0.0068765,-0.16738,2.11E-05,0.39019,-0.27589,0.035978},
      {3.45E-05,0,0.48774,0,0.0021205,-0.24937,2.44E-05,0.34502,-0.24395,-0.025176},
      {3.20E-05,-1.09E-06,0.42347,-2.37E-06,0.00068126,-0.32598,2.18E-05,0.29963,-0.21185,-0.086633},
      {2.59E-05,-2.95E-06,0.35777,-6.35E-06,0.0003104,-0.4024,1.62E-05,0.25322,-0.17905,-0.14946},
      {1.78E-05,-5.30E-06,0.2884,-1.13E-05,8.19E-05,-0.48282,8.78E-06,0.20421,-0.1444,-0.21582},
      {7.00E-06,-1.04E-05,0.21712,-2.15E-05,6.90E-07,-0.56497,-2.44E-06,0.15399,-0.1089,-0.28381},
      {4.24E-08,-2.37E-05,0.15331,-4.90E-05,9.43E-07,-0.63755,-1.67E-05,0.1095,-0.077463,-0.34399},
      {7.08E-08,-3.86E-05,0.094637,-8.28E-05,1.86E-06,-0.7042,-2.72E-05,0.068623,-0.048587,-0.39925},
      {9.37E-08,-5.48E-05,0.039972,-0.00012173,2.91E-06,-0.76629,-3.87E-05,0.030531,-0.021683,-0.45074},
      {2.22E-07,-6.88E-05,0.021815,-0.00014922,9.43E-06,-0.7838,-4.85E-05,0.019753,-0.014082,-0.46527},
      {3.26E-07,-8.44E-05,0.0085936,-0.00018549,1.71E-05,-0.79551,-5.94E-05,0.012514,-0.0089919,-0.47499},
      {3.97E-07,-0.00010252,-0.0023436,-0.0002346,2.54E-05,-0.80472,-7.22E-05,0.0067816,-0.0049784,-0.48264},
      {4.60E-07,-0.00012321,-0.0085572,-0.00024179,5.20E-05,-0.80402,-8.67E-05,0.0071559,-0.0052398,-0.4821},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.11E-07,1.22E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.03E-07,2.91E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.88E-07,4.55E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.05E-06,6.05E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.27E-06,7.34E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.44E-06,8.31E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.54E-06,8.91E-07,0,0.5,-0.35355,0.18464},
      {1.39E-06,0,0.70392,0,0.0031801,0.001836,9.83E-07,0.49775,-0.35196,0.18159},
      {2.79E-06,0,0.70088,0,0.0062114,0.0035862,1.97E-06,0.49561,-0.35044,0.17869},
      {3.94E-06,0,0.69856,0,0.0085221,0.0049203,2.78E-06,0.49397,-0.34929,0.17648},
      {4.72E-06,0,0.69715,0,0.0099288,0.0057324,3.34E-06,0.49298,-0.34858,0.17513},
      {6.66E-06,0,0.67495,0,0.0085424,-0.0223,4.71E-06,0.47728,-0.33748,0.15388},
      {9.30E-06,0,0.61232,0,0.0046321,-0.10136,6.57E-06,0.43301,-0.30618,0.093939},
      {8.69E-06,0,0.54222,0,0.0017996,-0.1872,6.14E-06,0.38345,-0.27113,0.026834},
      {4.02E-06,0,0.46409,0,0.00023966,-0.28013,2.85E-06,0.3282,-0.23207,-0.04798},
      {0,-1.49E-06,0.39024,-3.18E-06,0,-0.36577,-1.06E-06,0.27601,-0.19517,-0.11864},
      {0,-4.79E-06,0.32216,-1.05E-05,0,-0.44429,-3.39E-06,0.22791,-0.16117,-0.18374},
      {0,-9.25E-06,0.24902,-2.10E-05,0,-0.52863,-6.54E-06,0.17625,-0.12464,-0.25368},
      {2.15E-09,-1.58E-05,0.17389,-3.68E-05,7.35E-08,-0.61519,-1.12E-05,0.12321,-0.087153,-0.32545},
      {2.46E-08,-3.09E-05,0.12005,-7.43E-05,9.58E-07,-0.67637,-2.18E-05,0.085683,-0.060646,-0.37618},
      {4.16E-08,-4.63E-05,0.072423,-0.00011542,1.87E-06,-0.73048,-3.27E-05,0.052477,-0.037199,-0.42105},
      {5.32E-08,-6.20E-05,0.031333,-0.00016005,2.79E-06,-0.77717,-4.38E-05,0.023809,-0.016965,-0.45976},
      {1.18E-07,-7.93E-05,0.014326,-0.00020878,8.91E-06,-0.79406,-5.60E-05,0.013376,-0.0096271,-0.47378},
      {1.75E-07,-9.96E-05,0.005243,-0.00027144,1.71E-05,-0.80134,-7.03E-05,0.0088084,-0.00645,-0.47982},
      {2.04E-07,-0.00012286,-0.0019298,-0.00035168,2.58E-05,-0.80668,-8.67E-05,0.0054003,-0.0041087,-0.48426},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.81E-08,3.35E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.27E-07,7.31E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.73E-07,9.99E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.94E-07,1.12E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.88E-07,1.09E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.58E-07,9.12E-08,0,0.5,-0.35355,0.18464},
      {3.25E-07,0,0.70651,0,0.00059856,0.00034558,2.30E-07,0.49958,-0.35325,0.18406},
      {5.63E-07,0,0.70609,0,0.0010132,0.00058497,3.98E-07,0.49928,-0.35305,0.18367},
      {2.85E-07,0,0.7066,0,0.00050221,0.00028995,2.02E-07,0.49964,-0.3533,0.18416},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69321,0,0,-0.016049,0,0.49017,-0.3466,0.17133},
      {0,0,0.61583,0,0,-0.10539,0,0.43546,-0.30792,0.097256},
      {0,0,0.53127,0,0,-0.20302,0,0.37568,-0.26564,0.016304},
      {0,0,0.43909,0,0,-0.30946,0,0.3105,-0.21956,-0.07195},
      {0,-2.10E-06,0.35155,-4.98E-06,0,-0.41049,-1.49E-06,0.24862,-0.1758,-0.15572},
      {0,-8.14E-06,0.27789,-1.94E-05,0,-0.49543,-5.75E-06,0.19658,-0.13902,-0.22615},
      {0,-1.56E-05,0.20217,-3.74E-05,0,-0.58275,-1.11E-05,0.14308,-0.1012,-0.29855},
      {0,-2.48E-05,0.12497,-5.94E-05,0,-0.67179,-1.76E-05,0.088515,-0.062637,-0.37238},
      {1.16E-08,-3.97E-05,0.083128,-0.000101,7.86E-07,-0.71939,-2.81E-05,0.059296,-0.04201,-0.41185},
      {1.99E-08,-5.52E-05,0.049392,-0.00014689,1.62E-06,-0.7577,-3.90E-05,0.035755,-0.025402,-0.44362},
      {2.42E-08,-7.09E-05,0.02149,-0.00019581,2.43E-06,-0.78942,-5.02E-05,0.016252,-0.011652,-0.46992},
      {4.72E-08,-9.12E-05,0.007804,-0.00026455,7.63E-06,-0.80331,-6.44E-05,0.0076256,-0.005611,-0.48145},
      {6.52E-08,-0.00011692,0.0021661,-0.00036106,1.61E-05,-0.80716,-8.26E-05,0.0051092,-0.0039154,-0.48464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70622,0,0,-0.0010263,0,0.49937,-0.35311,0.18379},
      {0,0,0.61598,0,0,-0.10522,0,0.43557,-0.30799,0.097393},
      {0,0,0.51801,0,0,-0.21834,0,0.3663,-0.25901,0.0036011},
      {0,0,0.41188,0,0,-0.34088,0,0.29126,-0.20595,-0.098002},
      {0,-2.14E-06,0.30882,-5.11E-06,0,-0.45985,-1.52E-06,0.21839,-0.15443,-0.19665},
      {0,-1.14E-05,0.23497,-2.71E-05,0,-0.54502,-8.07E-06,0.1662,-0.11754,-0.26727},
      {0,-2.25E-05,0.16046,-5.32E-05,0,-0.63095,-1.59E-05,0.11353,-0.080323,-0.33852},
      {0,-3.55E-05,0.085971,-8.36E-05,0,-0.71686,-2.51E-05,0.060874,-0.04311,-0.40975},
      {3.87E-09,-5.06E-05,0.049228,-0.00012782,5.71E-07,-0.75887,-3.58E-05,0.035072,-0.024902,-0.44459},
      {6.11E-09,-6.61E-05,0.027647,-0.0001775,1.26E-06,-0.7834,-4.68E-05,0.019966,-0.014263,-0.46493},
      {5.53E-09,-8.19E-05,0.011202,-0.00022969,1.90E-06,-0.80215,-5.79E-05,0.008402,-0.0061298,-0.48047},
      {4.51E-09,-0.00010372,0.002551,-0.00031232,5.80E-06,-0.81109,-7.33E-05,0.0027896,-0.002233,-0.48789},
      {-0.46788,-0.00089318,0.00023241,-0.20221,4.89E-05,-4.32E-06,0.35316,-0.14311,0.14982,0.18437},
      {-0.44241,0.00012423,0.00012283,-0.2287,0.00010855,1.05E-05,0.33326,-0.16222,0.12289,0.18429},
      {-0.40592,0.0014979,-5.83E-05,-0.26911,0.00021031,7.13E-05,0.3033,-0.19156,0.081553,0.18422},
      {-0.33574,0.0023141,-0.00017274,-0.33764,0.00034431,-5.96E-05,0.25236,-0.24124,0.011175,0.18393},
      {-0.2553,0.0025623,-0.00026711,-0.41571,0.00053352,-0.00048344,0.19428,-0.29837,-0.069995,0.18332},
      {-0.17957,0.002272,-0.00037473,-0.49107,0.00080424,-0.0013144,0.13798,-0.35458,-0.15011,0.18227},
      {-0.11504,0.0015402,-0.00049905,-0.55583,0.0011813,-0.0027144,0.088537,-0.40451,-0.22171,0.18062},
      {-0.066845,0.0023406,-0.00086391,-0.59539,0.0041398,-0.0027165,0.049471,-0.43979,-0.27445,0.17641},
      {-0.03934,0.0066395,-0.0019016,-0.58396,0.012434,0.0034148,0.02708,-0.4493,-0.29368,0.16954},
      {-0.019608,0.0084748,-0.002883,-0.56506,0.019188,0.0089382,0.011463,-0.45652,-0.30918,0.16439},
      {-0.0068476,0.0080754,-0.0036481,-0.54235,0.024346,0.013379,0.0019446,-0.46147,-0.3213,0.16065},
      {-0.0017264,0.010831,-0.0062439,-0.48345,0.048106,0.027739,-0.0052412,-0.44239,-0.31341,0.13839},
      {-0.00053307,0.011729,-0.010851,-0.38367,0.09293,0.053698,-0.0087766,-0.40366,-0.29218,0.095478},
      {-0.00030632,0.011349,-0.014343,-0.27053,0.13295,0.076747,-0.0096567,-0.36922,-0.27186,0.057026},
      {-0.00019815,0.010999,-0.016184,-0.13971,0.1717,0.098901,-0.0098288,-0.338,-0.25226,0.019636},
      {-0.0001008,0.012867,-0.017855,-0.044801,0.22698,0.13063,-0.010691,-0.29615,-0.22355,-0.03348},
      {-2.56E-05,0.01334,-0.018446,0.022637,0.29066,0.16734,-0.010431,-0.25231,-0.19233,-0.094471},
      {1.55E-05,0.010582,-0.017354,0.080356,0.35339,0.20355,-0.0080463,-0.21398,-0.16462,-0.15446},
      {2.94E-05,0.0076115,-0.016245,0.13082,0.40747,0.23491,-0.005712,-0.18197,-0.14115,-0.20607},
      {2.72E-05,0.006863,-0.01933,0.13148,0.44165,0.25469,-0.0051056,-0.15467,-0.12505,-0.23868},
      {2.01E-05,0.0057981,-0.025105,0.11341,0.47542,0.27424,-0.0043237,-0.12354,-0.10938,-0.27091},
      {1.16E-05,0.0043074,-0.031643,0.09114,0.51209,0.29542,-0.0032596,-0.089522,-0.092624,-0.30594},
      {1.20E-06,0.0024523,-0.037726,0.062672,0.55229,0.31862,-0.0019298,-0.053886,-0.074457,-0.34439},
      {-1.03E-05,0.0011452,-0.044964,0.046102,0.57164,0.3298,-0.00096274,-0.030994,-0.066198,-0.36288},
      {-6.02E-06,0.0012677,-0.053775,0.042741,0.57123,0.32956,-0.001029,-0.018763,-0.066315,-0.36247},
      {3.72E-06,0.00091972,-0.060103,0.033913,0.57794,0.33344,-0.00076075,-0.0053353,-0.063336,-0.36889},
      {2.00E-05,0.00046327,-0.064609,0.019612,0.59114,0.34108,-0.00041406,0.010029,-0.057215,-0.38152},
      {6.26E-05,0.00028473,-0.070519,0.0046683,0.604,0.34854,-0.00024527,0.027343,-0.050966,-0.3938},
      {0.00022086,8.38E-05,-0.076962,0.0068434,0.60055,0.34661,4.31E-05,0.033908,-0.052812,-0.39045},
      {0.0003638,-1.04E-05,-0.082002,0.0086819,0.59913,0.34583,0.00023252,0.040006,-0.053531,-0.38905},
      {0.00041935,-8.38E-06,-0.087115,0.0079095,0.59991,0.34631,0.00027888,0.047788,-0.053117,-0.38977},
      {0.00041885,-6.68E-06,-0.089216,0.0022402,0.60761,0.35078,0.00028516,0.056169,-0.049294,-0.39713},
      {-0.42935,0.0013349,0.00034852,-0.19588,0.00019668,-9.20E-05,0.34738,-0.13924,0.15424,0.1838},
      {-0.40499,0.0022572,0.0002339,-0.22225,0.00026036,-4.94E-05,0.32767,-0.15837,0.12728,0.18375},
      {-0.3706,0.0034641,4.99E-05,-0.26174,0.00036539,4.06E-05,0.29859,-0.18719,0.086719,0.18371},
      {-0.32836,0.0047985,-0.00021814,-0.31397,0.0005266,0.00019549,0.26084,-0.22559,0.032692,0.18371},
      {-0.259,0.0053109,-0.0003701,-0.38391,0.00073152,-9.69E-05,0.20878,-0.27713,-0.040427,0.18322},
      {-0.1853,0.0052885,-0.00048398,-0.45443,0.0010086,-0.00085367,0.15513,-0.32996,-0.11577,0.18221},
      {-0.11889,0.0047651,-0.0006107,-0.51933,0.0013758,-0.0021469,0.10513,-0.3799,-0.18734,0.18065},
      {-0.071814,0.0096668,-0.0014698,-0.5434,0.0085772,0.0017278,0.061818,-0.41072,-0.23624,0.17352},
      {-0.0404,0.011255,-0.0026853,-0.54839,0.017976,0.0078672,0.026647,-0.43859,-0.28231,0.16522},
      {-0.019516,0.012828,-0.0037052,-0.52891,0.02445,0.012768,0.0098799,-0.44736,-0.30006,0.15996},
      {-0.0058167,0.012261,-0.0044968,-0.50547,0.02927,0.01665,-0.00026314,-0.45319,-0.31337,0.15624},
      {-0.0021537,0.02025,-0.0085856,-0.4259,0.065548,0.037774,-0.010783,-0.41865,-0.2926,0.12154},
      {-0.00070234,0.02116,-0.01294,-0.33314,0.10723,0.061931,-0.014702,-0.38287,-0.27338,0.081635},
      {-0.00030398,0.013452,-0.016953,-0.23496,0.1472,0.085097,-0.011562,-0.35367,-0.26192,0.043416},
      {-0.00018539,0.013497,-0.018701,-0.10559,0.18427,0.10631,-0.011874,-0.32418,-0.24299,0.007632},
      {-8.26E-05,0.016749,-0.020797,-0.030742,0.2418,0.13936,-0.01349,-0.27974,-0.21214,-0.04761},
      {-7.31E-06,0.017213,-0.021217,0.032361,0.30245,0.17428,-0.01323,-0.23802,-0.18243,-0.10572},
      {3.40E-05,0.014445,-0.019968,0.086469,0.36264,0.20901,-0.010843,-0.20147,-0.15599,-0.1633},
      {3.66E-05,0.0084708,-0.017241,0.12998,0.42052,0.24246,-0.006335,-0.17099,-0.13372,-0.21858},
      {3.20E-05,0.007751,-0.020819,0.12158,0.45084,0.25999,-0.0057511,-0.14538,-0.11951,-0.24752},
      {2.50E-05,0.0066802,-0.026711,0.10496,0.48343,0.27885,-0.0049734,-0.11492,-0.10443,-0.2786},
      {1.70E-05,0.0051149,-0.033274,0.083511,0.51915,0.29948,-0.0038581,-0.081594,-0.088224,-0.31272},
      {6.93E-06,0.0031873,-0.0394,0.055817,0.55848,0.32217,-0.0024784,-0.046559,-0.07056,-0.35034},
      {-5.97E-06,0.0017125,-0.047265,0.042985,0.57265,0.33036,-0.0013864,-0.026569,-0.06507,-0.36387},
      {-5.69E-06,0.0013615,-0.055729,0.038585,0.57393,0.33111,-0.0011062,-0.013997,-0.064846,-0.36508},
      {3.91E-06,0.00095923,-0.062373,0.030228,0.57985,0.33453,-0.00079963,-0.00072824,-0.062322,-0.37073},
      {2.00E-05,0.00052643,-0.067774,0.016794,0.59151,0.34128,-0.0004715,0.014831,-0.056945,-0.38188},
      {7.08E-05,0.00034561,-0.074747,0.0044816,0.60082,0.34669,-0.00029373,0.03114,-0.052467,-0.39076},
      {0.00022532,0.00014086,-0.081907,0.0065274,0.59662,0.34433,-4.65E-06,0.038181,-0.054699,-0.38669},
      {0.00039801,-1.11E-05,-0.085829,0.007453,0.5968,0.34448,0.00025531,0.043799,-0.054659,-0.38682},
      {0.00045781,-9.07E-06,-0.09133,0.0068342,0.59697,0.34461,0.00030498,0.051704,-0.054544,-0.38696},
      {0.00046126,-7.36E-06,-0.093794,0.0013227,0.6041,0.34875,0.00031434,0.060194,-0.051005,-0.39377},
      {-0.3583,0.0056704,0.00071201,-0.17153,0.00035553,-0.00024551,0.3428,-0.12223,0.17613,0.18275},
      {-0.3358,0.0064293,0.00059946,-0.19692,0.00041823,-0.00016803,0.32391,-0.14076,0.15004,0.18274},
      {-0.30345,0.0074651,0.0004234,-0.23444,0.00052197,-3.88E-05,0.29619,-0.16827,0.1113,0.18275},
      {-0.26264,0.0086921,0.00017597,-0.28316,0.00067995,0.00014956,0.26042,-0.20428,0.060628,0.18276},
      {-0.2155,0.010016,-0.00015188,-0.34128,0.00090899,0.0003938,0.21807,-0.24765,-0.0004074,0.18278},
      {-0.16762,0.01209,-0.00064423,-0.40649,0.0015254,0.00084036,0.17032,-0.29722,-0.070263,0.1825},
      {-0.11176,0.020189,-0.0013523,-0.44276,0.0059748,0.00263,0.11988,-0.33178,-0.12276,0.17754},
      {-0.064248,0.024348,-0.0021927,-0.46805,0.012302,0.0059254,0.074248,-0.36568,-0.17559,0.17116},
      {-0.030517,0.024985,-0.0033067,-0.47863,0.02044,0.010792,0.036313,-0.39778,-0.22705,0.1636},
      {-0.011779,0.022197,-0.0048004,-0.4699,0.030243,0.016947,0.0079759,-0.42685,-0.27563,0.15485},
      {-0.0051263,0.027495,-0.0077916,-0.42185,0.052141,0.029924,-0.010064,-0.42036,-0.28395,0.13422},
      {-0.0022292,0.037343,-0.012102,-0.34343,0.089702,0.051676,-0.021842,-0.38303,-0.26019,0.098149},
      {-0.00052437,0.03768,-0.016051,-0.26054,0.12731,0.073519,-0.025737,-0.35147,-0.24403,0.062147},
      {5.89E-05,0.029868,-0.019733,-0.16598,0.16451,0.095116,-0.022741,-0.32573,-0.2349,0.026584},
      {-0.00015458,0.019567,-0.023529,-0.075044,0.20785,0.12019,-0.016297,-0.29787,-0.22487,-0.014857},
      {-5.07E-05,0.023182,-0.025462,-0.01169,0.2623,0.15142,-0.018111,-0.25535,-0.19528,-0.067172},
      {2.46E-05,0.023561,-0.025579,0.045477,0.31895,0.18399,-0.017804,-0.21657,-0.16764,-0.12148},
      {6.62E-05,0.020719,-0.024061,0.094575,0.37574,0.21672,-0.015374,-0.18255,-0.14294,-0.17583},
      {6.62E-05,0.014762,-0.021784,0.12395,0.42738,0.24651,-0.010887,-0.15522,-0.12374,-0.22518},
      {3.97E-05,0.0091113,-0.023032,0.10714,0.46439,0.26779,-0.0067401,-0.13162,-0.11129,-0.26053},
      {3.31E-05,0.0080291,-0.02925,0.092432,0.49525,0.28566,-0.0059691,-0.10192,-0.097067,-0.28995},
      {2.57E-05,0.0063354,-0.035898,0.072227,0.52956,0.30546,-0.0047656,-0.069559,-0.081692,-0.32272},
      {1.62E-05,0.004286,-0.042124,0.045703,0.56761,0.3274,-0.0033023,-0.035371,-0.064788,-0.35912},
      {2.56E-06,0.0027254,-0.05154,0.039049,0.57251,0.33024,-0.0021444,-0.019815,-0.064032,-0.36377},
      {-5.40E-06,0.0014899,-0.059033,0.032439,0.57757,0.33319,-0.0012141,-0.0066259,-0.062863,-0.36858},
      {3.96E-06,0.00099584,-0.066146,0.024812,0.58228,0.33592,-0.00084279,0.0063893,-0.061033,-0.37308},
      {1.98E-05,0.00062329,-0.072995,0.012628,0.59158,0.3413,-0.00056071,0.022368,-0.056776,-0.38196},
      {8.11E-05,0.00043843,-0.081749,0.0041514,0.59542,0.34356,-0.00036953,0.037326,-0.055032,-0.3856},
      {0.00023011,0.00022646,-0.090001,0.0060173,0.59007,0.34053,-7.81E-05,0.045086,-0.057855,-0.38043},
      {0.00043177,1.72E-05,-0.093134,0.0060757,0.59144,0.34138,0.00025165,0.050395,-0.057265,-0.38169},
      {0.00051998,-1.01E-05,-0.098081,0.0052727,0.5921,0.3418,0.00034734,0.057851,-0.056917,-0.3823},
      {0.00052934,-8.42E-06,-0.1011,5.35E-06,0.59834,0.34542,0.00036135,0.066507,-0.053816,-0.38825},
      {-0.16604,0.0049106,0.0040314,-0.14522,0.00021447,3.62E-05,0.32263,-0.10145,0.19683,0.18081},
      {-0.16049,0.0069701,0.00349,-0.16182,0.00028039,9.03E-05,0.30928,-0.11387,0.18024,0.18094},
      {-0.15254,0.01023,0.0026084,-0.18757,0.00039369,0.00018155,0.28875,-0.1332,0.1545,0.18116},
      {-0.14259,0.016613,0.0012883,-0.21765,0.00078724,0.00048948,0.26154,-0.15621,0.1241,0.18127},
      {-0.1085,0.022102,0.00075056,-0.25892,0.0020313,0.0013765,0.2218,-0.18876,0.0776,0.18016},
      {-0.075174,0.028298,3.39E-05,-0.30445,0.0043838,0.0028349,0.17519,-0.22723,0.021959,0.17799},
      {-0.047705,0.036482,-0.0010793,-0.34963,0.0081031,0.0049755,0.12472,-0.26954,-0.039558,0.1747},
      {-0.02865,0.046993,-0.0026501,-0.39111,0.013384,0.0078311,0.073219,-0.31464,-0.10541,0.17024},
      {0.0027165,0.045805,-0.0036689,-0.40705,0.020701,0.011957,0.034248,-0.35102,-0.16233,0.16327},
      {0.013296,0.048002,-0.0061651,-0.38703,0.037537,0.021703,0.002513,-0.36885,-0.20075,0.14733},
      {0.0060393,0.058326,-0.011203,-0.32117,0.074612,0.042986,-0.024369,-0.35603,-0.211,0.11192},
      {-0.001396,0.065043,-0.016696,-0.24131,0.11869,0.068405,-0.041081,-0.33553,-0.21487,0.069995},
      {0.00040584,0.06398,-0.020072,-0.16844,0.15161,0.087585,-0.044213,-0.3094,-0.20287,0.038506},
      {0.0010066,0.056101,-0.023163,-0.0791,0.18363,0.10619,-0.041276,-0.28888,-0.19716,0.007857},
      {0.00039698,0.046401,-0.028445,-0.032341,0.22871,0.13223,-0.034846,-0.25782,-0.18651,-0.035179},
      {2.20E-06,0.032951,-0.0321,0.010173,0.28661,0.16571,-0.0251,-0.22314,-0.17313,-0.090408},
      {7.63E-05,0.03303,-0.031746,0.060366,0.3389,0.19573,-0.024603,-0.18791,-0.14792,-0.14058},
      {0.00011833,0.029988,-0.02981,0.1035,0.39185,0.22621,-0.022049,-0.15699,-0.12531,-0.19128},
      {0.00010927,0.023646,-0.028731,0.11053,0.43276,0.2497,-0.017302,-0.13502,-0.11181,-0.23039},
      {7.38E-05,0.015517,-0.029419,0.093773,0.47212,0.2723,-0.011383,-0.11236,-0.10074,-0.26797},
      {4.52E-05,0.0098544,-0.03294,0.07615,0.51056,0.29446,-0.0073217,-0.084462,-0.087447,-0.30465},
      {3.87E-05,0.0079604,-0.039785,0.057608,0.54303,0.31319,-0.0059806,-0.053244,-0.07318,-0.33567},
      {2.86E-05,0.0058062,-0.047516,0.038079,0.57074,0.32915,-0.0044391,-0.024314,-0.061555,-0.36218},
      {1.42E-05,0.0039809,-0.058259,0.033826,0.5714,0.32954,-0.0030928,-0.010068,-0.063189,-0.36277},
      {2.67E-06,0.002225,-0.065951,0.026663,0.57714,0.33289,-0.001785,0.0034843,-0.06223,-0.36822},
      {3.51E-06,0.00099143,-0.071911,0.017879,0.58463,0.33724,-0.00086444,0.016247,-0.059817,-0.37536},
      {1.91E-05,0.00075491,-0.080916,0.007247,0.59064,0.34073,-0.00068452,0.033052,-0.057059,-0.38109},
      {9.07E-05,0.00056356,-0.092411,0.0036209,0.58694,0.33865,-0.00047564,0.046545,-0.059092,-0.3775},
      {0.00023257,0.0003391,-0.10214,0.005275,0.58002,0.33472,-0.00017861,0.055271,-0.062722,-0.37082},
      {0.00042762,0.00011683,-0.10664,0.0051711,0.57992,0.33472,0.00015744,0.061458,-0.06289,-0.37068},
      {0.00061166,-1.16E-05,-0.10792,0.0033142,0.58464,0.33749,0.00041014,0.066569,-0.06055,-0.37516},
      {0.00062891,-9.93E-06,-0.11171,-0.0016143,0.58967,0.34041,0.00043038,0.075451,-0.05805,-0.37995},
      {0.061418,-0.0028155,0.012943,-0.081667,-0.00065991,0.0010198,0.30593,-0.049786,0.24953,0.17786},
      {0.062501,-0.0011559,0.010735,-0.090552,-0.00062638,0.0011826,0.29554,-0.057906,0.24226,0.17783},
      {0.060016,0.0031767,0.0096797,-0.11117,-0.00031066,0.0014772,0.27477,-0.074056,0.22105,0.17771},
      {0.058437,0.0097112,0.0081149,-0.13781,0.00024144,0.0019076,0.24654,-0.09529,0.19337,0.17745},
      {0.058844,0.018991,0.0059315,-0.16962,0.0011308,0.0024853,0.21103,-0.12126,0.15987,0.17698},
      {0.06207,0.031585,0.0030208,-0.20575,0.0024662,0.0032043,0.16883,-0.15164,0.12121,0.17629},
      {0.074939,0.039965,0.0012921,-0.25225,0.0057922,0.0050891,0.11923,-0.19532,0.059624,0.17358},
      {0.08369,0.048517,-0.00032714,-0.29757,0.010903,0.0078591,0.06831,-0.24448,-0.011463,0.1694},
      {0.06101,0.069263,-0.0036641,-0.30989,0.023858,0.014699,0.020408,-0.27378,-0.060593,0.15799},
      {0.038085,0.092726,-0.0080085,-0.2906,0.045654,0.026672,-0.023063,-0.28638,-0.093436,0.138},
      {0.029061,0.098912,-0.01236,-0.23646,0.078758,0.045775,-0.048783,-0.28245,-0.1128,0.10651},
      {0.018128,0.10194,-0.017638,-0.16341,0.12108,0.070225,-0.065515,-0.27227,-0.12953,0.0664},
      {0.0056154,0.10177,-0.023729,-0.066803,0.1687,0.097606,-0.072216,-0.25907,-0.146,0.02134},
      {0.0016846,0.095195,-0.030114,-0.018491,0.20211,0.11681,-0.068799,-0.23865,-0.14727,-0.010386},
      {0.0009101,0.085061,-0.035042,0.011587,0.24179,0.13973,-0.062085,-0.21197,-0.13979,-0.048233},
      {0.00044593,0.070766,-0.038096,0.04382,0.2939,0.16986,-0.051905,-0.18254,-0.13015,-0.097897},
      {0.00019758,0.050516,-0.039424,0.076456,0.35704,0.20639,-0.037123,-0.15232,-0.12081,-0.15807},
      {0.0001929,0.042623,-0.037825,0.10615,0.40655,0.23486,-0.03113,-0.12649,-0.10492,-0.20542},
      {0.00017134,0.035333,-0.038187,0.095495,0.43645,0.25192,-0.025716,-0.11041,-0.097839,-0.234},
      {0.00013975,0.026492,-0.040602,0.081809,0.47211,0.27235,-0.019324,-0.088374,-0.089277,-0.26805},
      {9.24E-05,0.016749,-0.042071,0.061848,0.51674,0.298,-0.012334,-0.061966,-0.077093,-0.31066},
      {5.71E-05,0.0099236,-0.045337,0.040463,0.55885,0.32224,-0.0074623,-0.032614,-0.063093,-0.3509},
      {4.40E-05,0.007532,-0.056428,0.031237,0.56923,0.3282,-0.0057409,-0.011366,-0.060392,-0.36081},
      {2.92E-05,0.0053742,-0.068395,0.027496,0.56834,0.32769,-0.0041613,0.0032767,-0.063133,-0.35992},
      {1.72E-05,0.0033252,-0.077212,0.020838,0.57263,0.3302,-0.0026479,0.017186,-0.063192,-0.36398},
      {7.66E-06,0.0014138,-0.082925,0.011523,0.58181,0.33555,-0.0012217,0.03024,-0.060688,-0.3727},
      {1.74E-05,0.00091808,-0.092402,0.00099264,0.58756,0.33891,-0.00084326,0.047298,-0.058365,-0.37817},
      {9.52E-05,0.00071725,-0.10791,0.0028346,0.5742,0.33127,-0.00061304,0.059615,-0.065244,-0.36533},
      {0.00022863,0.00047273,-0.11949,0.004274,0.5653,0.3262,-0.00030516,0.069535,-0.069901,-0.35674},
      {0.00041584,0.00023053,-0.12571,0.0040071,0.56335,0.32513,4.19E-05,0.07681,-0.071028,-0.35483},
      {0.00065645,3.67E-05,-0.12551,0.0015916,0.5696,0.32879,0.00039256,0.080896,-0.067952,-0.36077},
      {0.00076811,-1.18E-05,-0.12693,-0.0027114,0.57584,0.33243,0.00052725,0.087294,-0.064822,-0.36672},
      {0.21035,-0.020619,0.047313,-0.050157,-0.0028863,0.0024884,0.24933,-0.0039005,0.24329,0.17461},
      {0.21457,-0.020331,0.042563,-0.054676,-0.0030123,0.0026822,0.24098,-0.010571,0.24323,0.17452},
      {0.22236,-0.020017,0.035051,-0.061227,-0.0032133,0.0029942,0.22808,-0.020709,0.24371,0.17433},
      {0.23529,-0.01984,0.024292,-0.06957,-0.0035084,0.0034499,0.21015,-0.034511,0.24539,0.174},
      {0.24029,-0.014193,0.016494,-0.092605,-0.0030885,0.004045,0.17973,-0.057863,0.22713,0.17352},
      {0.22911,-0.00066908,0.013043,-0.12969,-0.0015191,0.0047144,0.13897,-0.089715,0.18749,0.17289},
      {0.19698,0.018202,0.0086262,-0.16026,0.0012335,0.005605,0.10012,-0.11809,0.1534,0.17168},
      {0.16704,0.041406,0.0032731,-0.18478,0.0052757,0.0071406,0.057551,-0.14398,0.12308,0.16933},
      {0.13329,0.063945,-0.00032259,-0.19605,0.019428,0.014638,0.01016,-0.1736,0.073243,0.15702},
      {0.097758,0.096366,-0.0050495,-0.19097,0.03948,0.025317,-0.039374,-0.19625,0.02959,0.13949},
      {0.061103,0.13816,-0.011017,-0.16451,0.06532,0.039177,-0.088457,-0.21222,-0.0084523,0.1166},
      {0.043014,0.14646,-0.01642,-0.097945,0.10317,0.060788,-0.10838,-0.21228,-0.03576,0.081025},
      {0.023171,0.14653,-0.025465,-0.039518,0.14648,0.085359,-0.11188,-0.20271,-0.061124,0.040136},
      {0.0080261,0.1444,-0.035746,0.011838,0.19414,0.1124,-0.10797,-0.1856,-0.080021,-0.0043484},
      {0.0012693,0.13701,-0.043666,0.049647,0.24142,0.13944,-0.099289,-0.16263,-0.086168,-0.048569},
      {0.00080344,0.122,-0.045858,0.072498,0.28936,0.16718,-0.088661,-0.13767,-0.079309,-0.094212},
      {0.00053579,0.10096,-0.046462,0.096419,0.34833,0.20131,-0.073395,-0.11178,-0.072849,-0.15036},
      {0.00034189,0.069305,-0.049181,0.091641,0.39658,0.22909,-0.050314,-0.097742,-0.082234,-0.19617},
      {0.00026164,0.049383,-0.05292,0.082796,0.43284,0.24988,-0.035865,-0.08166,-0.084985,-0.23067},
      {0.00023262,0.039911,-0.056516,0.070143,0.46631,0.26897,-0.029032,-0.059913,-0.078131,-0.26264},
      {0.00018759,0.029585,-0.05899,0.051246,0.50884,0.29335,-0.021631,-0.033947,-0.067565,-0.30327},
      {0.00012317,0.017972,-0.060151,0.029198,0.55558,0.32021,-0.013331,-0.0077978,-0.056181,-0.34794},
      {6.26E-05,0.0092558,-0.069805,0.023493,0.56468,0.32546,-0.0070684,0.0058007,-0.060692,-0.35656},
      {4.74E-05,0.0067768,-0.083267,0.020408,0.5619,0.32385,-0.0052642,0.020993,-0.0647,-0.35386},
      {3.50E-05,0.0044385,-0.093444,0.014384,0.56444,0.32535,-0.0035485,0.035382,-0.065924,-0.35624},
      {2.59E-05,0.0027265,-0.10354,0.0067649,0.56827,0.32763,-0.0022837,0.051021,-0.065864,-0.35984},
      {2.50E-05,0.00133,-0.113,-0.00035459,0.5708,0.32919,-0.0011961,0.064988,-0.066204,-0.36216},
      {8.85E-05,0.00088965,-0.12974,0.0017586,0.55565,0.32053,-0.00077916,0.077555,-0.074286,-0.34758},
      {0.0002128,0.00061509,-0.14352,0.003016,0.54437,0.31409,-0.00045293,0.088861,-0.080175,-0.33673},
      {0.00039139,0.00034418,-0.15175,0.0026142,0.54022,0.31176,-8.83E-05,0.0974,-0.082451,-0.33269},
      {0.00062387,0.0001225,-0.15344,0.00010886,0.5444,0.31423,0.00027953,0.10264,-0.080451,-0.33665},
      {0.00091447,-6.34E-06,-0.15024,-0.0025338,0.55253,0.31896,0.00061954,0.10389,-0.076315,-0.3444},
      {0.28364,-0.045619,0.10823,-0.026701,-0.0060087,0.003636,0.17753,0.055568,0.20408,0.17226},
      {0.28659,-0.047356,0.094654,-0.028762,-0.0063634,0.0039463,0.17229,0.044341,0.21558,0.17205},
      {0.2841,-0.046532,0.085244,-0.034188,-0.0064515,0.0041606,0.16246,0.033649,0.21912,0.17193},
      {0.28166,-0.045553,0.072173,-0.040805,-0.0065849,0.0044727,0.14899,0.019437,0.22489,0.17171},
      {0.27995,-0.044548,0.055147,-0.047991,-0.0067822,0.0049049,0.13175,0.0019228,0.23371,0.17133},
      {0.27961,-0.043687,0.03389,-0.055004,-0.0070723,0.0054851,0.11057,-0.01858,0.2465,0.1707},
      {0.25913,-0.028952,0.022005,-0.075147,-0.0049437,0.0064942,0.076644,-0.044126,0.23157,0.16935},
      {0.22811,-0.0031218,0.015895,-0.098678,-0.00070365,0.0080565,0.034032,-0.069846,0.20306,0.16708},
      {0.1992,0.025015,0.0084825,-0.11422,0.0036613,0.010747,-0.010423,-0.092292,0.17978,0.16276},
      {0.16659,0.057332,0.0015944,-0.11297,0.016631,0.018248,-0.056789,-0.11369,0.14801,0.15038},
      {0.11988,0.10381,-0.0054983,-0.092445,0.042937,0.031947,-0.10358,-0.13438,0.10168,0.12719},
      {0.067623,0.16513,-0.01568,-0.067651,0.073935,0.046706,-0.14675,-0.14815,0.058607,0.10177},
      {0.031293,0.20889,-0.026406,-0.03005,0.1112,0.065634,-0.17143,-0.14909,0.026753,0.070264},
      {0.016365,0.20609,-0.035673,0.016853,0.1585,0.09249,-0.16564,-0.1356,0.0050961,0.026347},
      {0.0065727,0.20007,-0.045333,0.058447,0.21078,0.12224,-0.15433,-0.11546,-0.010003,-0.021926},
      {0.0011154,0.19055,-0.055276,0.092081,0.26842,0.15507,-0.13822,-0.088911,-0.018881,-0.074985},
      {0.0008431,0.16105,-0.058836,0.092162,0.30839,0.1779,-0.11655,-0.07818,-0.030643,-0.11294},
      {0.0006401,0.12438,-0.064256,0.087052,0.35057,0.20207,-0.089868,-0.068109,-0.048128,-0.15294},
      {0.0004689,0.086087,-0.071431,0.076127,0.40088,0.23109,-0.062243,-0.050785,-0.062856,-0.20061},
      {0.00035915,0.055904,-0.078971,0.059793,0.45196,0.26054,-0.04061,-0.026218,-0.068509,-0.24912},
      {0.00031557,0.045023,-0.082687,0.041384,0.49302,0.284,-0.032828,0.00010557,-0.059213,-0.28836},
      {0.00022714,0.031047,-0.090884,0.030041,0.51582,0.29696,-0.022824,0.017606,-0.062194,-0.3102},
      {0.00013527,0.017723,-0.098208,0.021051,0.53437,0.30764,-0.013266,0.031193,-0.066735,-0.32786},
      {6.89E-05,0.008059,-0.10459,0.013104,0.55016,0.31692,-0.0063162,0.044075,-0.068966,-0.34276},
      {5.71E-05,0.0057616,-0.11855,0.0086355,0.54798,0.3157,-0.0046504,0.060515,-0.072481,-0.3406},
      {4.93E-05,0.0041315,-0.13303,0.001584,0.54709,0.31527,-0.003462,0.079093,-0.074675,-0.33967},
      {5.20E-05,0.0025599,-0.14899,0.00019884,0.53648,0.30927,-0.0022237,0.092802,-0.08179,-0.3294},
      {7.41E-05,0.0012281,-0.16144,0.00070572,0.52725,0.30409,-0.0011003,0.10265,-0.088031,-0.32043},
      {0.0001783,0.00074569,-0.17604,0.0015541,0.5153,0.29728,-0.00061174,0.11443,-0.094541,-0.30892},
      {0.00034806,0.00043557,-0.18655,0.0010755,0.50864,0.2935,-0.0002212,0.12436,-0.098127,-0.30248},
      {0.00057211,0.00017687,-0.19033,-0.0014698,0.51048,0.29463,0.00017095,0.13088,-0.097353,-0.3042},
      {0.00084437,2.26E-05,-0.19142,-0.0022534,0.51172,0.29538,0.00052058,0.13329,-0.096706,-0.30535},
      {0.21426,-0.050402,0.24889,-0.014743,-0.0061095,0.002661,0.11095,0.16386,0.076694,0.17364},
      {0.22233,-0.053722,0.2278,-0.015732,-0.0066445,0.0030534,0.10653,0.14807,0.096635,0.17322},
      {0.23491,-0.058857,0.19525,-0.017177,-0.007466,0.0036443,0.099593,0.12378,0.12742,0.17254},
      {0.25252,-0.066013,0.15009,-0.01903,-0.0086141,0.0044467,0.089815,0.090219,0.17013,0.17155},
      {0.26092,-0.069423,0.1162,-0.023546,-0.0099491,0.0055549,0.076118,0.062625,0.19777,0.1699},
      {0.2627,-0.070072,0.091225,-0.0291,-0.011282,0.0068453,0.05719,0.040448,0.21472,0.16796},
      {0.2656,-0.071808,0.062304,-0.033712,-0.013192,0.008579,0.034143,0.015994,0.23582,0.16528},
      {0.26814,-0.073643,0.030706,-0.037397,-0.015548,0.010875,0.006372,-0.010102,0.25919,0.16167},
      {0.22962,-0.03718,0.023465,-0.052415,-0.0099945,0.013167,-0.037309,-0.032494,0.23356,0.15688},
      {0.18654,0.010624,0.014088,-0.062802,-0.0023607,0.015613,-0.085212,-0.053568,0.2101,0.15136},
      {0.14377,0.068672,0.0016326,-0.066946,0.0071256,0.018466,-0.13652,-0.072967,0.19149,0.14525},
      {0.095066,0.13285,-0.0084754,-0.042923,0.038772,0.033109,-0.17501,-0.087633,0.14854,0.12065},
      {0.053396,0.20306,-0.01998,-0.012175,0.073231,0.048923,-0.20893,-0.093799,0.11495,0.094767},
      {0.019327,0.27964,-0.032691,0.023813,0.10969,0.065589,-0.23874,-0.090922,0.092599,0.068153},
      {0.0089523,0.27912,-0.041941,0.061453,0.16112,0.094547,-0.22783,-0.073936,0.075781,0.021507},
      {0.0045828,0.25564,-0.055845,0.075206,0.204,0.11765,-0.19862,-0.062883,0.044606,-0.017476},
      {0.0018258,0.22428,-0.073207,0.089518,0.24381,0.13988,-0.16513,-0.051138,0.0092364,-0.05317},
      {0.00094123,0.18744,-0.084719,0.08925,0.28571,0.16387,-0.13499,-0.038358,-0.015442,-0.091886},
      {0.00075686,0.14789,-0.092699,0.076852,0.33685,0.19335,-0.10645,-0.020275,-0.031112,-0.14029},
      {0.00060304,0.10655,-0.10279,0.05764,0.39754,0.22843,-0.076853,0.0064953,-0.043444,-0.1978},
      {0.00044711,0.060207,-0.1208,0.039631,0.44991,0.25864,-0.043887,0.035334,-0.064557,-0.24755},
      {0.00034089,0.044312,-0.13341,0.031171,0.4638,0.26633,-0.032506,0.051416,-0.073927,-0.26096},
      {0.00024391,0.030104,-0.1426,0.021535,0.48186,0.27664,-0.022316,0.066696,-0.079594,-0.2782},
      {0.00015584,0.017351,-0.1478,0.011638,0.50375,0.28947,-0.01316,0.079904,-0.081974,-0.2989},
      {8.55E-05,0.0073422,-0.15679,0.0037717,0.51891,0.29875,-0.0060128,0.095617,-0.084946,-0.31291},
      {7.71E-05,0.0054731,-0.17714,-9.28E-05,0.50776,0.29241,-0.0046329,0.11503,-0.09255,-0.30213},
      {7.69E-05,0.0037152,-0.197,0.00056572,0.49038,0.28252,-0.0032392,0.1293,-0.10327,-0.28538},
      {9.53E-05,0.0022282,-0.21139,0.00075764,0.4792,0.27622,-0.0019963,0.14037,-0.11067,-0.27454},
      {0.00013753,0.0010053,-0.22121,0.00030322,0.47337,0.27302,-0.00090698,0.14894,-0.11514,-0.26881},
      {0.00027863,0.00047279,-0.23217,-0.0004513,0.46636,0.26907,-0.00033827,0.15902,-0.11924,-0.26201},
      {0.00049418,0.00016094,-0.23858,-0.0024148,0.46453,0.26808,9.07E-05,0.1666,-0.12036,-0.26022},
      {0.00073096,5.14E-05,-0.24348,-0.0019772,0.4601,0.26555,0.00039243,0.1704,-0.12255,-0.25595},
      {0.14403,-0.047547,0.40513,-0.0066892,-0.0054046,0.0017029,0.066698,0.28061,-0.06892,0.17564},
      {0.1533,-0.051835,0.38193,-0.007548,-0.0063085,0.0022905,0.062214,0.26344,-0.047192,0.17474},
      {0.16724,-0.058641,0.34667,-0.0087849,-0.007763,0.0032261,0.054971,0.2374,-0.014158,0.17328},
      {0.18342,-0.067813,0.30009,-0.010312,-0.0098694,0.0044873,0.044372,0.20306,0.029409,0.17111},
      {0.19984,-0.079012,0.24319,-0.012009,-0.01268,0.0059931,0.030151,0.16121,0.082467,0.16807},
      {0.21827,-0.092895,0.17548,-0.013749,-0.016262,0.0077967,0.011968,0.11158,0.14555,0.16409},
      {0.21739,-0.09299,0.14001,-0.017161,-0.018349,0.0092212,-0.01047,0.083293,0.17358,0.16078},
      {0.2123,-0.089095,0.10615,-0.020442,-0.020385,0.010839,-0.037315,0.056017,0.19896,0.1571},
      {0.20704,-0.084073,0.065186,-0.022887,-0.022825,0.012827,-0.068879,0.024079,0.23098,0.1527},
      {0.1827,-0.050139,0.038421,-0.027333,-0.018732,0.015185,-0.10974,-0.0029983,0.236,0.14773},
      {0.14389,0.013202,0.024538,-0.029548,-0.0082281,0.017865,-0.1576,-0.022711,0.21977,0.14243},
      {0.10597,0.087305,0.0074077,-0.025384,0.0036372,0.020856,-0.20857,-0.041058,0.20924,0.13682},
      {0.069388,0.16498,-0.0076782,-0.0031752,0.029688,0.031481,-0.24735,-0.05082,0.18922,0.11962},
      {0.038865,0.24193,-0.022288,0.024671,0.063769,0.044434,-0.26722,-0.051456,0.16071,0.09568},
      {0.01645,0.31105,-0.040339,0.048273,0.091784,0.054193,-0.27535,-0.051191,0.13121,0.077865},
      {0.0065187,0.3226,-0.057918,0.069146,0.12593,0.071008,-0.25797,-0.046064,0.097608,0.051241},
      {0.0038114,0.29076,-0.075704,0.081969,0.16795,0.094516,-0.22329,-0.033843,0.061366,0.014031},
      {0.0019548,0.25744,-0.096963,0.087702,0.20879,0.11803,-0.1898,-0.01534,0.027887,-0.021515},
      {0.0010338,0.22097,-0.11731,0.081987,0.25313,0.14402,-0.15847,0.008965,0.001833,-0.061143},
      {0.00083508,0.17266,-0.13321,0.06523,0.30541,0.17374,-0.12391,0.033291,-0.021558,-0.11104},
      {0.00063568,0.11898,-0.15771,0.049776,0.34958,0.19881,-0.085707,0.060445,-0.054065,-0.1533},
      {0.00047139,0.066448,-0.18626,0.033436,0.39149,0.22328,-0.048474,0.092312,-0.086546,-0.19287},
      {0.00036077,0.042453,-0.20191,0.021327,0.41539,0.23714,-0.0314,0.11376,-0.099182,-0.21553},
      {0.00027169,0.029361,-0.21396,0.012945,0.43041,0.24617,-0.022047,0.13152,-0.10533,-0.2295},
      {0.00019028,0.017907,-0.22416,0.0029523,0.44718,0.25641,-0.013857,0.14896,-0.10903,-0.24501},
      {0.00010766,0.007497,-0.2389,0.00069505,0.4467,0.2569,-0.006325,0.16118,-0.12047,-0.2439},
      {9.44E-05,0.0046843,-0.25902,0.00071724,0.43047,0.24776,-0.004166,0.17575,-0.13179,-0.22815},
      {0.00010777,0.0030543,-0.2747,0.00064078,0.41796,0.2407,-0.0028075,0.18758,-0.14003,-0.21604},
      {0.00014523,0.0016956,-0.28577,-6.04E-05,0.41085,0.23677,-0.0016093,0.19687,-0.14532,-0.20908},
      {0.00021173,0.00060179,-0.29306,-0.0015552,0.40835,0.23552,-0.00057396,0.20429,-0.14801,-0.20652},
      {0.00036456,0.00013338,-0.30104,-0.0020582,0.40267,0.23233,-1.31E-05,0.21113,-0.15139,-0.20101},
      {0.00057723,7.54E-05,-0.30604,-0.0016859,0.39803,0.22969,0.00024309,0.21495,-0.15366,-0.19655},
      {0.068029,-0.02916,0.54481,-0.0034889,-0.003568,0.00024581,0.027933,0.38249,-0.20208,0.17846},
      {0.071689,-0.032622,0.53515,-0.0035696,-0.0039571,0.00033296,0.027221,0.37542,-0.19284,0.17794},
      {0.076893,-0.037764,0.52105,-0.0036862,-0.0045454,0.00044778,0.025958,0.36511,-0.17939,0.17715},
      {0.087015,-0.045918,0.48799,-0.0043377,-0.0061961,0.0011489,0.019061,0.34094,-0.14841,0.17519},
      {0.10299,-0.057804,0.43079,-0.0055833,-0.0092575,0.002632,0.0044953,0.29918,-0.095121,0.17169},
      {0.12093,-0.072285,0.36314,-0.0068529,-0.013005,0.0043701,-0.013915,0.24994,-0.032129,0.16733},
      {0.13986,-0.08927,0.28657,-0.0080089,-0.017402,0.0063062,-0.036469,0.19436,0.039147,0.16211},
      {0.1528,-0.10126,0.21553,-0.0092858,-0.021497,0.0083107,-0.063218,0.14238,0.10368,0.15675},
      {0.15072,-0.095133,0.16908,-0.010875,-0.023846,0.01045,-0.094033,0.10696,0.14144,0.15239},
      {0.14859,-0.088189,0.11474,-0.011427,-0.026647,0.013,-0.12977,0.066371,0.18672,0.14733},
      {0.14114,-0.06981,0.059927,-0.010368,-0.027403,0.015922,-0.17128,0.025065,0.22924,0.14178},
      {0.10576,0.015841,0.042515,-0.0059006,-0.01457,0.014867,-0.21459,0.0080227,0.21602,0.13522},
      {0.074674,0.11215,0.017001,0.0017501,-0.0029118,0.013045,-0.25371,-0.010684,0.20731,0.12836},
      {0.048525,0.20727,-0.013751,0.016011,0.01227,0.0142,-0.28601,-0.027866,0.19918,0.12053},
      {0.028637,0.27505,-0.032343,0.040682,0.040486,0.024473,-0.29043,-0.028987,0.16835,0.1045},
      {0.013706,0.33455,-0.052545,0.062888,0.064831,0.03418,-0.29258,-0.02746,0.14163,0.094376},
      {0.0045577,0.37112,-0.073751,0.079961,0.089331,0.04622,-0.28693,-0.02112,0.11707,0.083613},
      {0.0028216,0.33745,-0.095382,0.08353,0.13224,0.070972,-0.25261,-0.0018613,0.083305,0.04671},
      {0.0017769,0.29129,-0.12768,0.081347,0.16678,0.089676,-0.213,0.024182,0.040811,0.015686},
      {0.0010195,0.23911,-0.17268,0.076485,0.19218,0.10505,-0.17117,0.059387,-0.0091607,-0.0056348},
      {0.00079232,0.18368,-0.19989,0.058622,0.23832,0.13129,-0.13152,0.090128,-0.042862,-0.049654},
      {0.00062142,0.12888,-0.22991,0.040201,0.28304,0.15727,-0.092666,0.12445,-0.076228,-0.091976},
      {0.00048995,0.074178,-0.26767,0.025415,0.3196,0.17967,-0.054091,0.16365,-0.11362,-0.12564},
      {0.00039203,0.040855,-0.29727,0.011517,0.34317,0.19456,-0.03062,0.19739,-0.13599,-0.14696},
      {0.00028511,0.02772,-0.3095,0.0071894,0.34965,0.19888,-0.021142,0.2091,-0.14667,-0.15266},
      {0.00019027,0.016544,-0.32194,0.0042295,0.35261,0.20134,-0.013031,0.21988,-0.15724,-0.15485},
      {0.00011718,0.0074569,-0.33681,0.0014874,0.35149,0.20164,-0.0064029,0.2326,-0.1678,-0.15298},
      {0.00010459,0.0035981,-0.35295,0.00039177,0.3419,0.1966,-0.0034568,0.24524,-0.17705,-0.14337},
      {0.00013627,0.0021211,-0.36455,-0.0005079,0.33419,0.19234,-0.0021576,0.25474,-0.18279,-0.13584},
      {0.00019265,0.00093252,-0.37135,-0.0017143,0.33132,0.19085,-0.0010333,0.26111,-0.18582,-0.13294},
      {0.00024216,0.00034652,-0.37545,-0.0016156,0.32848,0.18937,-0.00033087,0.26414,-0.18822,-0.13009},
      {0.00037661,9.22E-05,-0.37942,-0.0013881,0.32521,0.1876,7.20E-05,0.26714,-0.19021,-0.12687},
      {0.019887,-0.011642,0.6395,-0.0018494,-0.0019065,-0.00027827,0.0049595,0.45097,-0.29178,0.18124},
      {0.022442,-0.014407,0.6322,-0.0019192,-0.0022562,-0.00026677,0.0039425,0.44564,-0.28492,0.18072},
      {0.026104,-0.018504,0.62154,-0.0020196,-0.0027833,-0.00026243,0.0022919,0.43787,-0.27493,0.17994},
      {0.030638,-0.023844,0.60796,-0.0021444,-0.003488,-0.00028244,-0.00014346,0.42797,-0.26225,0.17887},
      {0.035641,-0.030194,0.59235,-0.0022817,-0.0043569,-0.00035137,-0.0035271,0.41659,-0.24774,0.17752},
      {0.046714,-0.041581,0.54889,-0.0027495,-0.0068714,0.00045982,-0.016068,0.38512,-0.20734,0.17429},
      {0.063685,-0.05879,0.47508,-0.0034024,-0.011166,0.0022106,-0.0392,0.33186,-0.13862,0.16898},
      {0.080347,-0.078099,0.395,-0.0038137,-0.015897,0.0039618,-0.066436,0.27424,-0.064091,0.16295},
      {0.093983,-0.096936,0.31617,-0.0040073,-0.020717,0.0037792,-0.093081,0.2176,0.0081045,0.15513},
      {0.096578,-0.085866,0.25434,-0.0038875,-0.024795,0.0035892,-0.12024,0.1723,0.058353,0.14622},
      {0.096208,-0.064954,0.18786,-0.0026307,-0.028836,0.0021493,-0.15253,0.12426,0.11057,0.13579},
      {0.09465,-0.037718,0.1127,3.31E-05,-0.03316,-0.00088647,-0.19016,0.070873,0.16906,0.12349},
      {0.073369,0.048486,0.071853,0.0085087,-0.024112,-0.0027213,-0.22793,0.042706,0.17831,0.11774},
      {0.050485,0.15233,0.032457,0.020791,-0.011781,-0.003592,-0.26674,0.019111,0.1818,0.11642},
      {0.031037,0.26152,-0.016171,0.035968,0.00055296,-0.0037049,-0.30765,-0.0069481,0.19338,0.11848},
      {0.017804,0.32705,-0.041197,0.055955,0.023366,0.0050755,-0.31397,-0.0094207,0.17353,0.11243},
      {0.0090389,0.37383,-0.063535,0.071831,0.043226,0.012408,-0.31173,-0.0049672,0.15106,0.1077},
      {0.0037965,0.40064,-0.090811,0.080477,0.055739,0.015368,-0.30346,0.0035455,0.12662,0.10675},
      {0.0023457,0.36136,-0.12627,0.077483,0.086058,0.031795,-0.26641,0.029744,0.083677,0.08151},
      {0.0016056,0.30799,-0.17308,0.070095,0.11381,0.048681,-0.22357,0.067904,0.033316,0.058221},
      {0.0010227,0.24902,-0.233,0.061313,0.13514,0.064706,-0.17836,0.11674,-0.024159,0.042856},
      {0.0007222,0.1871,-0.28014,0.045994,0.1719,0.088554,-0.13366,0.16143,-0.071385,0.010653},
      {0.00058266,0.13144,-0.31906,0.026578,0.21234,0.11323,-0.094404,0.20425,-0.10786,-0.026664},
      {0.00045816,0.076564,-0.3626,0.017216,0.23579,0.12872,-0.055843,0.24197,-0.15199,-0.047365},
      {0.00035699,0.035734,-0.40337,0.010898,0.2451,0.13698,-0.027144,0.27519,-0.18954,-0.053835},
      {0.00024866,0.024037,-0.41231,0.0070746,0.25271,0.14212,-0.018623,0.28385,-0.19839,-0.060482},
      {0.00016342,0.014375,-0.42421,0.0035826,0.25563,0.14474,-0.011552,0.29475,-0.20759,-0.062487},
      {0.00010683,0.0066018,-0.44116,0.00077378,0.25149,0.1435,-0.0058353,0.30906,-0.21845,-0.057555},
      {0.0001022,0.0021792,-0.45868,-0.0009411,0.2422,0.13902,-0.0024763,0.3232,-0.22831,-0.04792},
      {0.00013311,0.001364,-0.45468,-0.0011259,0.24778,0.14234,-0.001519,0.3205,-0.22687,-0.053199},
      {0.00017892,0.00074552,-0.45302,-0.0011106,0.25065,0.14412,-0.00077835,0.31938,-0.22646,-0.055835},
      {0.00023565,0.00029712,-0.45543,-0.0010261,0.24928,0.14353,-0.00023098,0.3212,-0.22792,-0.054358},
      {-9.33E-05,0.0010065,0.69352,-0.0011764,-0.00026915,-0.00027803,-0.0005364,0.48973,-0.3422,0.18395},
      {0.0015834,-0.0010572,0.68802,-0.0012398,-0.00057728,-0.00035955,-0.0014749,0.48573,-0.33716,0.18342},
      {0.004044,-0.0041113,0.67983,-0.0013305,-0.0010481,-0.00050331,-0.0028876,0.47978,-0.32969,0.18258},
      {0.007205,-0.0080825,0.66913,-0.0014417,-0.0016898,-0.00073837,-0.004772,0.472,-0.31996,0.18142},
      {0.010893,-0.012791,0.65631,-0.0015607,-0.0025011,-0.0011049,-0.0070878,0.46271,-0.30837,0.17989},
      {0.014863,-0.017963,0.64203,-0.001668,-0.0034703,-0.0016552,-0.0097587,0.45235,-0.29557,0.17796},
      {0.018825,-0.023246,0.62707,-0.0017376,-0.0045749,-0.0024544,-0.012675,0.44154,-0.28231,0.17562},
      {0.031343,-0.037224,0.56097,-0.0017946,-0.0093877,-0.0027406,-0.032203,0.39405,-0.22254,0.1678},
      {0.043222,-0.050958,0.49047,-0.0016007,-0.014963,-0.0039078,-0.053974,0.34347,-0.15964,0.15804},
      {0.052907,-0.062597,0.42259,-0.0010766,-0.020828,-0.0064068,-0.075962,0.29486,-0.10026,0.14672},
      {0.056894,-0.05409,0.35308,0.00062528,-0.025613,-0.0097895,-0.10482,0.24528,-0.04324,0.13493},
      {0.056545,-0.023103,0.27186,0.004202,-0.029425,-0.013899,-0.14467,0.18796,0.020322,0.1226},
      {0.055195,0.014489,0.18206,0.0092314,-0.033432,-0.019615,-0.18976,0.12524,0.089988,0.10864},
      {0.045197,0.088888,0.11008,0.019305,-0.029074,-0.023272,-0.23391,0.078181,0.13298,0.10223},
      {0.029445,0.19791,0.05611,0.034422,-0.016101,-0.025997,-0.27294,0.049187,0.14893,0.10478},
      {0.018562,0.29383,-0.0076147,0.04551,-0.0051347,-0.042566,-0.30397,0.017078,0.16993,0.098728},
      {0.011485,0.35232,-0.050481,0.054911,0.0083699,-0.046622,-0.31326,0.0070093,0.1672,0.095403},
      {0.0068508,0.37958,-0.078841,0.061905,0.021617,-0.040535,-0.30587,0.017132,0.14403,0.096688},
      {0.0035276,0.40271,-0.11215,0.066086,0.03044,-0.02626,-0.30152,0.033265,0.12272,0.10859},
      {0.0020554,0.37617,-0.15957,0.064438,0.049236,-0.0062223,-0.27249,0.065857,0.079668,0.10453},
      {0.0015059,0.31227,-0.22276,0.054022,0.074148,0.012171,-0.22379,0.11807,0.018913,0.086133},
      {0.00099025,0.2478,-0.29815,0.038992,0.092384,0.030078,-0.17641,0.18275,-0.044286,0.076239},
      {0.00057728,0.17367,-0.36759,0.032789,0.11128,0.047707,-0.12391,0.23587,-0.11329,0.064141},
      {0.00044546,0.11629,-0.40819,0.024025,0.13882,0.065572,-0.08358,0.27051,-0.15789,0.039498},
      {0.00034372,0.069475,-0.45266,0.015845,0.15279,0.077091,-0.050713,0.30766,-0.19929,0.029046},
      {0.00026298,0.032472,-0.50061,0.0087535,0.1537,0.082403,-0.024773,0.34664,-0.23794,0.032194},
      {0.00017027,0.01957,-0.51469,0.0041742,0.15918,0.087147,-0.01544,0.35972,-0.24937,0.028269},
      {0.00010222,0.011393,-0.52826,0.00061275,0.15939,0.088413,-0.0094026,0.37198,-0.25854,0.029039},
      {6.55E-05,0.0055648,-0.53284,-0.00043089,0.16372,0.092261,-0.0049288,0.376,-0.26344,0.026},
      {5.54E-05,0.0016749,-0.5379,-0.00063963,0.16438,0.09379,-0.0018697,0.37972,-0.26802,0.026321},
      {0.00010001,0.0010493,-0.5303,-0.00069028,0.17311,0.098923,-0.0011166,0.37436,-0.2647,0.018051},
      {0.00015494,0.00058669,-0.52711,-0.00067261,0.17726,0.1015,-0.0005496,0.37217,-0.26341,0.014215},
      {-0.0016708,0.002248,0.69818,-0.0019004,2.40E-06,-0.00022141,0.00041868,0.49246,-0.34703,0.18436},
      {-0.0014884,0.0022336,0.69815,-0.0019019,1.63E-06,-0.0002404,0.00035371,0.49244,-0.34704,0.18434},
      {-0.001209,0.0022094,0.69811,-0.0018977,5.93E-07,-0.00026986,0.00025473,0.49242,-0.34704,0.18431},
      {-0.00048915,0.0016184,0.69647,-0.0018877,-0.00012471,-0.00040153,-0.00017206,0.49126,-0.34563,0.184},
      {0.0018929,-0.0015876,0.68715,-0.0018905,-0.00086204,-0.0010444,-0.0020478,0.48455,-0.33745,0.18234},
      {0.0044712,-0.0050521,0.67677,-0.0018545,-0.0017255,-0.001929,-0.004187,0.47709,-0.32841,0.18028},
      {0.0070606,-0.0084933,0.66592,-0.0017535,-0.002685,-0.0031174,-0.0064842,0.46934,-0.31909,0.17783},
      {0.009463,-0.011579,0.65533,-0.001555,-0.0036988,-0.004682,-0.0088059,0.46183,-0.31015,0.17496},
      {0.014241,-0.017154,0.62219,-0.0010822,-0.006713,-0.0071652,-0.019183,0.4382,-0.28173,0.16815},
      {0.020707,-0.024166,0.56528,-0.00019928,-0.011903,-0.011407,-0.038477,0.39754,-0.23338,0.15638},
      {0.025134,-0.02776,0.51264,0.0010135,-0.016843,-0.017484,-0.057176,0.36,-0.19,0.14341},
      {0.026979,-0.020412,0.45772,0.0032238,-0.021106,-0.025138,-0.079684,0.32113,-0.14674,0.12964},
      {0.028126,0.015493,0.35015,0.0081659,-0.025278,-0.043987,-0.12479,0.24616,-0.065281,0.10505},
      {0.028517,0.054811,0.23458,0.012966,-0.029081,-0.077565,-0.16817,0.1664,0.018093,0.069442},
      {0.026009,0.10882,0.12695,0.018882,-0.029125,-0.11742,-0.20725,0.094943,0.08813,0.033227},
      {0.017613,0.20329,0.062397,0.029021,-0.01799,-0.12815,-0.23953,0.063708,0.11276,0.033336},
      {0.011655,0.29462,-0.0024248,0.037455,-0.0085912,-0.12836,-0.27355,0.036609,0.14043,0.042663},
      {0.008032,0.36487,-0.059788,0.044296,0.00047996,-0.11744,-0.29708,0.023261,0.1555,0.057801},
      {0.0053462,0.38152,-0.097076,0.048529,0.010696,-0.099601,-0.28933,0.042005,0.13012,0.070786},
      {0.0033015,0.39174,-0.14119,0.048953,0.017442,-0.073103,-0.28363,0.069032,0.10496,0.092621},
      {0.0019164,0.37394,-0.19606,0.04617,0.025233,-0.044605,-0.26583,0.10701,0.067221,0.10971},
      {0.0013403,0.2903,-0.2719,0.040393,0.044472,-0.030776,-0.20636,0.16422,-0.01021,0.094187},
      {0.00082886,0.2134,-0.35622,0.03414,0.0563,-0.012217,-0.15181,0.22782,-0.088091,0.093105},
      {0.00037224,0.14317,-0.44825,0.027432,0.061275,0.011074,-0.10215,0.29724,-0.16609,0.10566},
      {0.00027082,0.096172,-0.49101,0.017743,0.078945,0.025115,-0.069148,0.33419,-0.20601,0.092},
      {0.00018857,0.058427,-0.53672,0.0093175,0.084214,0.03307,-0.042676,0.37245,-0.24331,0.091076},
      {0.00011317,0.029356,-0.58385,0.0026423,0.078859,0.036087,-0.022281,0.41056,-0.27781,0.1013},
      {6.02E-05,0.015266,-0.59511,0.00046692,0.087825,0.045007,-0.012103,0.41999,-0.28957,0.095821},
      {3.28E-05,0.0091619,-0.59085,6.95E-05,0.10022,0.053377,-0.0074441,0.41714,-0.29062,0.084967},
      {1.81E-05,0.0046323,-0.59335,-0.00020048,0.10423,0.056991,-0.0039539,0.41906,-0.29422,0.082198},
      {1.37E-05,0.0014958,-0.60177,-0.00035743,0.10091,0.056498,-0.0015004,0.42515,-0.30007,0.086557},
      {6.27E-05,0.00080534,-0.59573,-0.00039539,0.10826,0.061059,-0.00077771,0.42092,-0.29749,0.079782},
      {-0.0021248,0.0020055,0.69746,-0.0034699,3.41E-05,-0.00013278,0.00061395,0.49078,-0.34767,0.18443},
      {-0.0019504,0.0019758,0.69749,-0.0034354,3.42E-05,-0.000151,0.00055327,0.49083,-0.34769,0.1844},
      {-0.0016819,0.001928,0.69755,-0.0033776,3.45E-05,-0.00017896,0.00046003,0.49092,-0.34773,0.18437},
      {-0.0013113,0.0018575,0.69765,-0.0032885,3.51E-05,-0.00021732,0.00033167,0.49105,-0.3478,0.18432},
      {-0.00083352,0.0017587,0.69782,-0.0031577,3.62E-05,-0.00026623,0.00016661,0.49127,-0.34789,0.18426},
      {-4.02E-05,0.0012486,0.69643,-0.0029674,-0.00012361,-0.00061415,-0.00034037,0.4904,-0.3467,0.18371},
      {0.0015034,-0.00045086,0.6893,-0.0026722,-0.00088082,-0.0022128,-0.0019553,0.48545,-0.34086,0.18119},
      {0.0029333,-0.0016972,0.68252,-0.0022518,-0.0016495,-0.0042402,-0.0035103,0.48083,-0.33547,0.17829},
      {0.004299,-0.0031794,0.67377,-0.0016664,-0.0024831,-0.0083607,-0.005136,0.47495,-0.32891,0.17353},
      {0.0058591,-0.0048494,0.65867,-0.00094903,-0.0037711,-0.014938,-0.0085511,0.46457,-0.31767,0.16598},
      {0.0092945,-0.0075525,0.60268,0.00017998,-0.0083392,-0.030961,-0.025089,0.42473,-0.27472,0.14538},
      {0.01184,-0.0081785,0.54384,0.0013542,-0.01268,-0.054461,-0.040734,0.38293,-0.23195,0.11892},
      {0.013383,-0.0061829,0.48232,0.0025499,-0.016553,-0.086948,-0.054968,0.33931,-0.18996,0.085713},
      {0.013804,0.03177,0.37109,0.0068082,-0.019374,-0.12885,-0.092978,0.26289,-0.11216,0.045257},
      {0.013924,0.078017,0.25103,0.011439,-0.021597,-0.18209,-0.13084,0.18128,-0.03159,-0.003424},
      {0.013409,0.12928,0.12906,0.015731,-0.02218,-0.24845,-0.16536,0.099427,0.046383,-0.060128},
      {0.0098328,0.21373,0.059185,0.022958,-0.013384,-0.24765,-0.19911,0.070575,0.078814,-0.050401},
      {0.0073147,0.29661,-0.0051532,0.027874,-0.0053444,-0.22911,-0.23464,0.052924,0.10846,-0.025488},
      {0.0060595,0.37274,-0.068151,0.029585,0.0005106,-0.19833,-0.2716,0.042627,0.13902,0.0081638},
      {0.0042956,0.35624,-0.11139,0.033657,0.005925,-0.17932,-0.2569,0.063523,0.1076,0.019969},
      {0.0028149,0.33694,-0.16498,0.036529,0.0099014,-0.1481,-0.24084,0.095554,0.068954,0.043409},
      {0.0016551,0.31792,-0.23053,0.03758,0.012311,-0.10373,-0.22558,0.13811,0.025708,0.079488},
      {0.0011137,0.24885,-0.31488,0.030605,0.023265,-0.079278,-0.17648,0.202,-0.047868,0.084729},
      {0.00066577,0.17984,-0.40718,0.022503,0.029455,-0.053747,-0.12768,0.27256,-0.12469,0.097399},
      {0.00025324,0.11685,-0.50573,0.01405,0.029995,-0.023819,-0.083277,0.34782,-0.20132,0.1217},
      {8.10E-05,0.074165,-0.56629,0.0047257,0.035381,-0.0057458,-0.053274,0.39708,-0.24815,0.12904},
      {3.48E-05,0.045844,-0.59693,0.0017563,0.04224,0.004905,-0.033373,0.42079,-0.27602,0.12803},
      {7.09E-06,0.024463,-0.62251,0.00097361,0.045263,0.013598,-0.018298,0.43935,-0.29905,0.1309},
      {-1.13E-05,0.011295,-0.63857,0.00041221,0.048246,0.020844,-0.0088831,0.45101,-0.31343,0.13263},
      {-2.19E-05,0.0067343,-0.63671,0.00010758,0.056577,0.026892,-0.0053855,0.44985,-0.31486,0.12568},
      {-2.32E-05,0.0034857,-0.64062,-8.89E-05,0.057817,0.028986,-0.0028645,0.45274,-0.3185,0.12564},
      {-1.73E-05,0.0013833,-0.64956,-0.00019031,0.052915,0.027721,-0.001199,0.45914,-0.32407,0.13163},
      {-0.0027407,0.0018501,0.69563,-0.0054704,6.68E-05,-0.0004536,0.00091983,0.48804,-0.34787,0.18414},
      {-0.0025812,0.001797,0.69566,-0.0053789,6.82E-05,-0.00058985,0.00087312,0.48813,-0.34788,0.18402},
      {-0.0023387,0.0017148,0.69568,-0.0052326,7.07E-05,-0.00082451,0.00080251,0.48825,-0.34788,0.18381},
      {-0.0020102,0.0016002,0.69569,-0.0050196,7.44E-05,-0.0011988,0.00070769,0.48841,-0.34786,0.18348},
      {-0.0015974,0.001451,0.69564,-0.0047246,7.97E-05,-0.0017696,0.00058998,0.48858,-0.3478,0.18298},
      {-0.0011065,0.0012655,0.69551,-0.0043279,8.72E-05,-0.0026122,0.0004522,0.48877,-0.34767,0.18225},
      {-0.00054696,0.0010432,0.69522,-0.003803,9.72E-05,-0.0038214,0.00029838,0.48894,-0.34744,0.1812},
      {0.00029257,0.00027954,0.68994,-0.0031976,-0.00031439,-0.0076213,-0.00057439,0.48559,-0.34371,0.17734},
      {0.0012556,-0.0007556,0.68055,-0.0025443,-0.0010037,-0.014204,-0.0019185,0.47934,-0.33733,0.17073},
      {0.002157,-0.0016535,0.66982,-0.0017765,-0.0017019,-0.02266,-0.0032433,0.47223,-0.33035,0.16252},
      {0.0029849,-0.002337,0.65769,-0.00094444,-0.0024054,-0.033179,-0.004491,0.46419,-0.32281,0.15256},
      {0.0044695,-0.00060174,0.6073,0.00019218,-0.0056092,-0.061437,-0.015196,0.42856,-0.28898,0.12394},
      {0.0056218,0.0038411,0.54487,0.0014346,-0.0090057,-0.10164,-0.026834,0.38431,-0.24899,0.085088},
      {0.0061769,0.011097,0.47891,0.0026847,-0.011653,-0.15221,-0.036592,0.3376,-0.20936,0.038763},
      {0.0062762,0.045869,0.37798,0.0057824,-0.012423,-0.21328,-0.061698,0.26893,-0.14564,-0.013771},
      {0.0060269,0.098318,0.25734,0.0094463,-0.011127,-0.28587,-0.093724,0.18884,-0.06988,-0.072645},
      {0.0056244,0.15099,0.13423,0.012375,-0.0087139,-0.37071,-0.12237,0.10793,0.0045666,-0.13963},
      {0.00522,0.19854,0.04923,0.016167,-0.0066348,-0.38222,-0.15349,0.066433,0.051621,-0.14751},
      {0.004649,0.24687,-0.0080392,0.019772,-0.0034898,-0.35282,-0.18357,0.052745,0.07815,-0.12008},
      {0.0042479,0.28826,-0.057483,0.02216,-0.00079567,-0.32222,-0.20921,0.045637,0.098374,-0.091648},
      {0.0033003,0.28908,-0.11162,0.023804,0.0023886,-0.28502,-0.20728,0.069602,0.077283,-0.061121},
      {0.0022528,0.27247,-0.18024,0.023776,0.0048428,-0.23476,-0.19384,0.11521,0.034374,-0.020221},
      {0.0014426,0.25592,-0.26101,0.021116,0.0059629,-0.17204,-0.18104,0.17198,-0.013004,0.032236},
      {0.0009166,0.20855,-0.35459,0.013471,0.0093569,-0.12618,-0.14731,0.24261,-0.079723,0.06619},
      {0.00050176,0.14578,-0.45428,0.0037217,0.01187,-0.092745,-0.10307,0.31958,-0.15617,0.090562},
      {0.00014205,0.091192,-0.54181,0.0029417,0.014102,-0.053129,-0.064824,0.38159,-0.2268,0.12028},
      {-3.74E-05,0.053816,-0.60398,0.0021613,0.017639,-0.020225,-0.038607,0.42581,-0.2761,0.14252},
      {-5.68E-05,0.033011,-0.62735,0.0013554,0.02234,-0.01051,-0.023961,0.44281,-0.2977,0.14383},
      {-6.71E-05,0.017841,-0.64912,0.00072322,0.023077,-0.0029084,-0.013223,0.45856,-0.3158,0.14908},
      {-6.92E-05,0.0076847,-0.66916,0.00026877,0.020563,0.0029434,-0.0059647,0.47294,-0.33064,0.15754},
      {-6.58E-05,0.0043932,-0.67009,4.60E-05,0.024891,0.0069162,-0.0034326,0.47372,-0.33279,0.15462},
      {-5.61E-05,0.0022739,-0.67525,-8.37E-05,0.023715,0.0077435,-0.0017693,0.47745,-0.33647,0.157},
      {-0.0035278,0.0016661,0.69451,-0.0063244,0.00010381,-0.00061981,0.0015051,0.48664,-0.34765,0.18397},
      {-0.0034784,0.0015872,0.69422,-0.0066644,0.00010835,-0.00066822,0.0015355,0.4862,-0.34773,0.18393},
      {-0.0033744,0.0014779,0.69388,-0.006955,0.00011507,-0.00087866,0.0015578,0.48575,-0.34778,0.18374},
      {-0.0031174,0.0013676,0.69368,-0.0065757,0.00012311,-0.0016468,0.0014915,0.48588,-0.34757,0.18308},
      {-0.0027773,0.0012275,0.6934,-0.0060739,0.00013439,-0.002714,0.0013962,0.48603,-0.34727,0.18216},
      {-0.0023443,0.0010587,0.69298,-0.0054378,0.00014971,-0.0041466,0.0012629,0.48619,-0.34688,0.18092},
      {-0.0018062,0.00086342,0.69239,-0.0046563,0.00017001,-0.0060227,0.0010797,0.48633,-0.34638,0.17931},
      {-0.0011478,0.00064495,0.69159,-0.0037193,0.00019646,-0.0084324,0.00083127,0.48644,-0.34575,0.17724},
      {-0.00037779,0.00036213,0.68897,-0.0027022,0.00012893,-0.012469,0.00038693,0.4853,-0.34403,0.17365},
      {0.00029741,-5.61E-05,0.67756,-0.0020203,-0.00042072,-0.022987,-0.00063018,0.47768,-0.33721,0.16391},
      {0.00092851,-0.00024828,0.66462,-0.0013256,-0.0008928,-0.03581,-0.0015617,0.46898,-0.32979,0.15235},
      {0.0014942,-0.00013359,0.65005,-0.0006333,-0.0012261,-0.05128,-0.0023493,0.45916,-0.3218,0.13875},
      {0.0019962,0.0041471,0.60842,0.00030596,-0.0024225,-0.08702,-0.0073195,0.4299,-0.29763,0.10695},
      {0.0021903,0.013796,0.54165,0.001443,-0.0036521,-0.14655,-0.014609,0.38268,-0.25983,0.055297},
      {0.0024264,0.021262,0.45313,0.0024448,-0.0054453,-0.23003,-0.021914,0.32013,-0.21109,-0.016887},
      {0.0026827,0.041255,0.3443,0.0041865,-0.0066205,-0.31926,-0.03773,0.24516,-0.14816,-0.092824},
      {0.0030036,0.077307,0.22247,0.0068083,-0.0069275,-0.40112,-0.064333,0.16355,-0.073601,-0.1612},
      {0.0031662,0.10761,0.11248,0.0088143,-0.007036,-0.48045,-0.086175,0.089873,-0.0076404,-0.22696},
      {0.0030775,0.14094,0.032961,0.010734,-0.0057658,-0.51226,-0.10815,0.047091,0.036193,-0.25173},
      {0.0028811,0.18212,-0.012841,0.012425,-0.0030855,-0.47683,-0.13388,0.043557,0.054914,-0.21917},
      {0.0028018,0.21758,-0.052195,0.01248,-0.0010277,-0.44046,-0.15612,0.04594,0.068812,-0.18617},
      {0.0024527,0.22819,-0.10451,0.010851,0.00059548,-0.39483,-0.16171,0.072297,0.05541,-0.14701},
      {0.0016963,0.20875,-0.19255,0.0069013,0.0017055,-0.32753,-0.14705,0.13533,0.0036457,-0.090864},
      {0.0010848,0.18968,-0.28887,0.0036612,0.0021398,-0.24645,-0.13344,0.20433,-0.052109,-0.023315},
      {0.00059943,0.15677,-0.3838,0.0034971,0.0035782,-0.17495,-0.11049,0.2707,-0.11564,0.034217},
      {0.00026626,0.10562,-0.47,0.0027425,0.0060581,-0.13247,-0.074655,0.33171,-0.18387,0.065956},
      {2.36E-05,0.064819,-0.55439,0.0020676,0.0070527,-0.08253,-0.04605,0.39142,-0.24604,0.10601},
      {-0.00012531,0.03463,-0.63079,0.001461,0.0072491,-0.030731,-0.024852,0.44549,-0.29891,0.14874},
      {-0.00012755,0.020314,-0.65055,0.00081552,0.0091942,-0.02238,-0.01473,0.45981,-0.31556,0.15287},
      {-0.00012264,0.010526,-0.66865,0.00034263,0.0082537,-0.015588,-0.0077539,0.47284,-0.32922,0.15986},
      {-0.00011144,0.0046995,-0.68493,4.74E-05,0.0051054,-0.010014,-0.0035355,0.48444,-0.3401,0.169},
      {-8.66E-05,0.0028806,-0.68627,-1.09E-07,0.0078062,-0.0062637,-0.0022077,0.48535,-0.34167,0.16823},
      {-0.0048787,0.0016135,0.69494,-0.0044394,0.00014148,-0.00081534,0.0024481,0.48827,-0.34631,0.18376},
      {-0.0049001,0.0015429,0.69459,-0.0047484,0.00014827,-0.000885,0.0025218,0.48781,-0.3463,0.18369},
      {-0.0049417,0.0014344,0.69403,-0.0052235,0.00015901,-0.00099499,0.0026411,0.48708,-0.34628,0.18358},
      {-0.0050166,0.0012851,0.69325,-0.0058771,0.00017438,-0.0011522,0.0028178,0.48607,-0.34624,0.18343},
      {-0.0051444,0.0010937,0.6922,-0.0067156,0.00019514,-0.0013642,0.0030668,0.48474,-0.34614,0.18323},
      {-0.0047678,0.00092954,0.69135,-0.0064281,0.0002194,-0.0029543,0.0029497,0.48435,-0.34573,0.18186},
      {-0.0040905,0.00076353,0.69045,-0.0056074,0.0002493,-0.0054515,0.0026269,0.48429,-0.34514,0.17972},
      {-0.0032575,0.00057814,0.68929,-0.0046381,0.00028679,-0.0085562,0.0022103,0.48416,-0.34443,0.17706},
      {-0.0022448,0.00037727,0.68784,-0.003517,0.0003331,-0.012357,0.001679,0.48394,-0.34358,0.17381},
      {-0.0010196,0.00016984,0.68534,-0.0022355,0.00038623,-0.017762,0.00099438,0.4831,-0.34225,0.16921},
      {-0.00035683,0.00026674,0.66929,-0.0015199,0.00018928,-0.035866,0.0002561,0.47235,-0.33385,0.15369},
      {0.00014036,0.00042857,0.64522,-0.00097222,-5.45E-05,-0.062566,-0.00048179,0.4558,-0.32139,0.13092},
      {0.00062178,0.00058225,0.61424,-0.00046294,-0.00027129,-0.097348,-0.0012177,0.43432,-0.30554,0.10146},
      {0.0010079,0.0027103,0.56211,0.00013615,-0.00088858,-0.15186,-0.0036852,0.39777,-0.27808,0.055023},
      {0.0011703,0.0092248,0.47066,0.00099768,-0.0024408,-0.24162,-0.009894,0.33317,-0.22863,-0.021907},
      {0.001249,0.015115,0.37171,0.0017383,-0.003762,-0.34234,-0.015303,0.26334,-0.17601,-0.10749},
      {0.0012919,0.024435,0.26645,0.0025536,-0.0046093,-0.44702,-0.022647,0.18974,-0.11946,-0.19551},
      {0.001464,0.051262,0.16864,0.0040678,-0.0044442,-0.51935,-0.041582,0.12437,-0.060977,-0.25496},
      {0.0015346,0.072845,0.083519,0.0048175,-0.0040247,-0.58771,-0.056162,0.067553,-0.011033,-0.31055},
      {0.0015533,0.091055,0.016794,0.0047434,-0.0032131,-0.63454,-0.067511,0.028942,0.02444,-0.34769},
      {0.0015978,0.12207,-0.021616,0.0038705,-0.0013296,-0.59575,-0.086941,0.036572,0.033753,-0.3128},
      {0.0016653,0.14623,-0.056339,0.0019163,-0.0003067,-0.55517,-0.10248,0.04988,0.037494,-0.27737},
      {0.001626,0.15968,-0.096113,0.0020213,-2.89E-05,-0.50386,-0.11193,0.071623,0.02877,-0.2347},
      {0.0010717,0.1431,-0.19134,0.0022752,0.00061857,-0.41497,-0.1005,0.1375,-0.026713,-0.16145},
      {0.0006163,0.12514,-0.29222,0.0023967,0.0010486,-0.32113,-0.088041,0.20771,-0.085729,-0.083792},
      {0.00025696,0.1052,-0.39764,0.0023415,0.001335,-0.22416,-0.074141,0.28154,-0.14802,-0.0033776},
      {4.20E-05,0.067945,-0.48069,0.0016723,0.0024796,-0.17144,-0.048025,0.34026,-0.20771,0.03877},
      {-0.00010062,0.039294,-0.56137,0.0010865,0.0026243,-0.11308,-0.027915,0.39729,-0.26194,0.087026},
      {-0.00017846,0.018604,-0.63914,0.00059033,0.0020227,-0.04995,-0.013365,0.45228,-0.31079,0.1403},
      {-0.00017502,0.0090821,-0.66602,0.00017618,0.0018091,-0.031464,-0.0066105,0.47141,-0.32871,0.15595},
      {-0.00014497,0.005874,-0.67352,9.89E-05,0.0021171,-0.026539,-0.0043511,0.4766,-0.33393,0.15959},
      {-0.00011079,0.0038291,-0.6804,4.58E-05,0.0023817,-0.021021,-0.0028986,0.48134,-0.3383,0.16379},
      {-0.0054183,0.0016362,0.69629,-0.0023874,0.00016066,-0.0010084,0.0027536,0.49072,-0.34576,0.18357},
      {-0.0054991,0.0015732,0.69587,-0.0026208,0.00016909,-0.0011566,0.0028617,0.49026,-0.34565,0.18344},
      {-0.005626,0.0014769,0.69522,-0.0029715,0.00018223,-0.0013983,0.0030292,0.48956,-0.34548,0.18322},
      {-0.0058061,0.0013456,0.6943,-0.0034384,0.00020067,-0.0017591,0.0032623,0.4886,-0.34523,0.18289},
      {-0.0060466,0.0011792,0.69309,-0.0040105,0.00022496,-0.0022711,0.0035658,0.48737,-0.34487,0.18243},
      {-0.0063547,0.00097942,0.69155,-0.0046684,0.00025565,-0.0029737,0.0039435,0.48586,-0.34438,0.1818},
      {-0.0067384,0.00074954,0.68967,-0.0053846,0.00029328,-0.0039142,0.0043976,0.48408,-0.34373,0.18097},
      {-0.0057371,0.00059606,0.68619,-0.0045538,0.00033246,-0.0097147,0.0038079,0.48229,-0.34209,0.17608},
      {-0.0045186,0.00043493,0.68119,-0.0036034,0.00037815,-0.017576,0.0030652,0.47953,-0.33976,0.16947},
      {-0.0031648,0.00026502,0.67434,-0.0026445,0.00043103,-0.027694,0.0022274,0.4755,-0.33658,0.16098},
      {-0.0016912,9.13E-05,0.66519,-0.0017053,0.00049149,-0.040519,0.0013009,0.46986,-0.33237,0.15024},
      {-0.00070346,7.71E-05,0.64294,-0.0010491,0.00043978,-0.066908,0.00047905,0.45473,-0.32133,0.12802},
      {-0.00027606,0.00022063,0.60441,-0.00066434,0.00030375,-0.11063,-0.00017396,0.42782,-0.30184,0.091217},
      {0.00012517,0.00036979,0.5578,-0.00032393,0.00022295,-0.16382,-0.00079944,0.39514,-0.27836,0.046602},
      {0.00046939,0.00087923,0.4996,-1.37E-05,0.00013745,-0.22977,-0.0016627,0.35422,-0.24898,-0.0086305},
      {0.00052437,0.0059273,0.40046,0.00055439,-0.00082534,-0.33368,-0.0060045,0.2843,-0.19693,-0.096219},
      {0.00055149,0.010303,0.29748,0.00094122,-0.0014361,-0.44464,-0.0094113,0.21179,-0.14358,-0.18903},
      {0.00051797,0.013943,0.18739,0.0011034,-0.0015893,-0.567,-0.011793,0.13442,-0.087347,-0.29045},
      {0.00059976,0.03028,0.1127,0.0012093,-0.00098711,-0.63099,-0.02233,0.085521,-0.045239,-0.34207},
      {0.0006565,0.043104,0.054838,0.00089284,-0.00059624,-0.68004,-0.030421,0.048724,-0.013042,-0.38147},
      {0.00072496,0.053566,0.0094889,0.00094828,-0.00094158,-0.71356,-0.037653,0.020784,0.01191,-0.40914},
      {0.0008508,0.076379,-0.023277,0.0010798,-0.00073483,-0.66806,-0.053609,0.032275,0.015198,-0.37115},
      {0.00090227,0.093126,-0.054488,0.0011505,-0.00050008,-0.6234,-0.065329,0.04772,0.012685,-0.3338},
      {0.00087398,0.10258,-0.084588,0.0011435,-0.00029707,-0.5866,-0.071942,0.063712,0.0061711,-0.30295},
      {0.00052452,0.089713,-0.17896,0.0012384,9.48E-05,-0.49506,-0.063019,0.12894,-0.046665,-0.22708},
      {0.00021251,0.073572,-0.28687,0.0012044,0.00034348,-0.39086,-0.051772,0.2045,-0.10827,-0.14058},
      {-2.54E-05,0.056819,-0.39981,0.00099281,0.0004195,-0.28135,-0.040056,0.28405,-0.17275,-0.049525},
      {-0.00015427,0.034236,-0.48743,0.00048254,0.00054506,-0.20783,-0.024207,0.34597,-0.22744,0.011375},
      {-0.00020058,0.018482,-0.56114,0.00018468,0.00048445,-0.1425,-0.013164,0.39789,-0.27183,0.065698},
      {-0.00019492,0.010549,-0.62391,0.00016596,0.00062166,-0.079909,-0.0076496,0.4419,-0.30698,0.11746},
      {-0.00017079,0.0063799,-0.65491,0.00012344,0.00093657,-0.049049,-0.0047433,0.46361,-0.32443,0.14262},
      {-0.00013648,0.0044624,-0.66103,7.20E-05,0.0012613,-0.044143,-0.0033822,0.46781,-0.32836,0.14622},
      {-0.0045714,0.0015775,0.69922,-0.00057635,0.00015219,-0.00081212,0.0021414,0.49414,-0.34688,0.18375},
      {-0.0046666,0.0015252,0.69875,-0.00072925,0.00016188,-0.0010684,0.0022498,0.49371,-0.3467,0.18352},
      {-0.0048151,0.0014454,0.69801,-0.00095969,0.00017698,-0.0014749,0.0024176,0.49306,-0.34643,0.18316},
      {-0.0050237,0.0013369,0.69698,-0.0012676,0.00019814,-0.0020596,0.0026503,0.49215,-0.34603,0.18264},
      {-0.0052989,0.0011997,0.69562,-0.0016472,0.00022597,-0.0028538,0.0029523,0.49098,-0.3455,0.18195},
      {-0.0056465,0.0010358,0.6939,-0.0020871,0.00026105,-0.0038934,0.0033261,0.48952,-0.3448,0.18103},
      {-0.0060724,0.00084812,0.69177,-0.0025715,0.00030395,-0.0052196,0.0037731,0.48778,-0.34391,0.17987},
      {-0.006582,0.00064146,0.68922,-0.0030814,0.00035525,-0.0068784,0.0042935,0.48574,-0.3428,0.17842},
      {-0.0064262,0.00045624,0.68407,-0.0031341,0.00041146,-0.012671,0.0043187,0.48222,-0.34048,0.17353},
      {-0.0050614,0.00031848,0.67397,-0.0024648,0.00046946,-0.026177,0.003439,0.47574,-0.33589,0.16223},
      {-0.0035841,0.00017905,0.66183,-0.0017734,0.00053679,-0.042137,0.0024875,0.46786,-0.33035,0.14889},
      {-0.0020198,4.99E-05,0.64787,-0.0010783,0.00061779,-0.060203,0.0014821,0.45873,-0.32396,0.13377},
      {-0.0007118,2.51E-06,0.62475,-0.00050957,0.00068779,-0.088199,0.0005692,0.443,-0.31286,0.11033},
      {-0.00033677,0.00016708,0.57478,-0.00027908,0.00072878,-0.14543,6.35E-05,0.40785,-0.2878,0.062433},
      {-7.68E-06,0.00035275,0.51765,-0.0001058,0.00086169,-0.211,-0.00037946,0.36758,-0.2592,0.0076571},
      {0.00025492,0.0005652,0.45289,6.60E-06,0.0011098,-0.28546,-0.00073852,0.32189,-0.22685,-0.054416},
      {0.00027438,0.0036526,0.3539,0.00015846,0.00098248,-0.39546,-0.0028569,0.25231,-0.17632,-0.14566},
      {0.00026219,0.0066681,0.25049,0.00028237,0.00055978,-0.51012,-0.0049904,0.17978,-0.12365,-0.24075},
      {0.0002384,0.0091096,0.14871,0.00037266,0.00011453,-0.62397,-0.0067132,0.10826,-0.071961,-0.33512},
      {0.00029455,0.017967,0.08814,0.00045073,-0.00025048,-0.67855,-0.012849,0.068547,-0.039505,-0.38023},
      {0.000348,0.027192,0.046503,0.00049548,-0.00055674,-0.70936,-0.019232,0.043195,-0.016988,-0.4056},
      {0.00036281,0.033917,0.010361,0.00049799,-0.00081832,-0.7371,-0.023883,0.021591,0.0016501,-0.4284},
      {0.00038184,0.045052,-0.020985,0.00052929,-0.000708,-0.71605,-0.031659,0.026686,0.0036509,-0.41062},
      {0.00035977,0.053858,-0.050875,0.00052355,-0.00048098,-0.67955,-0.037815,0.042974,-0.0033876,-0.37998},
      {0.00027948,0.05699,-0.079184,0.0004397,-0.00030643,-0.64959,-0.039993,0.059421,-0.013334,-0.35479},
      {8.33E-05,0.048092,-0.159,0.00033986,-0.00012052,-0.57061,-0.033775,0.11447,-0.056663,-0.28909},
      {-0.0001076,0.034019,-0.27337,0.00011499,-2.37E-05,-0.45626,-0.023929,0.19505,-0.12049,-0.19405},
      {-0.00017798,0.026713,-0.38736,0.00012309,6.63E-05,-0.33332,-0.018876,0.27549,-0.18098,-0.092077},
      {-0.00020571,0.019181,-0.47483,0.00012923,0.00019888,-0.2415,-0.013659,0.33703,-0.22829,-0.016027},
      {-0.00019769,0.012086,-0.53606,0.00011436,0.0003404,-0.17966,-0.0087303,0.37997,-0.26227,0.035104},
      {-0.00018298,0.0071829,-0.59265,9.92E-05,0.00043253,-0.12052,-0.0053312,0.41974,-0.29289,0.084056},
      {-0.0001605,0.0043803,-0.63416,7.77E-05,0.0005342,-0.076156,-0.0033871,0.44895,-0.31496,0.12072},
      {-0.0025632,0.0011974,0.70303,0,0.00015645,9.03E-05,0.00097197,0.49722,-0.34971,0.18449},
      {-0.0026307,0.0011686,0.70298,0,0.00016325,9.43E-05,0.0010403,0.49719,-0.34966,0.18448},
      {-0.0027292,0.0011253,0.7029,0,0.00017398,0.00010045,0.0011411,0.49714,-0.3496,0.18447},
      {-0.0029424,0.0010428,0.70193,-0.00016869,0.00019686,-0.00052692,0.0013564,0.49639,-0.34916,0.18392},
      {-0.0032393,0.00093566,0.70049,-0.00040728,0.00022819,-0.0014802,0.0016512,0.49528,-0.34851,0.18308},
      {-0.0036126,0.00081041,0.69869,-0.00068052,0.00026718,-0.0026831,0.002015,0.49392,-0.34767,0.18203},
      {-0.0040657,0.0006712,0.69652,-0.00097566,0.00031412,-0.0041536,0.0024474,0.4923,-0.34665,0.18074},
      {-0.0045994,0.00052335,0.69397,-0.0012766,0.00036919,-0.0059073,0.002945,0.49043,-0.34541,0.17921},
      {-0.0052106,0.00037317,0.69105,-0.0015645,0.00043248,-0.0079564,0.0035013,0.48834,-0.34397,0.17742},
      {-0.0058915,0.00022761,0.68775,-0.0018188,0.00050402,-0.010309,0.0041056,0.48605,-0.34231,0.17537},
      {-0.0045478,0.0001431,0.67507,-0.0013406,0.00059128,-0.026415,0.0032327,0.47766,-0.33654,0.16187},
      {-0.0030988,7.29E-05,0.66022,-0.00085668,0.00069423,-0.045034,0.0022847,0.46778,-0.32977,0.14627},
      {-0.0016515,2.00E-05,0.64342,-0.00040863,0.00081484,-0.06576,0.0013378,0.45654,-0.32207,0.1289},
      {-0.00033025,-1.82E-05,0.62156,-7.76E-05,0.00092111,-0.091126,0.00046388,0.4422,-0.31222,0.10771},
      {-0.00013595,0.00014749,0.55877,-4.03E-05,0.0010648,-0.16255,0.00013624,0.3982,-0.28108,0.048178},
      {3.45E-05,0.00030013,0.48991,-7.42E-06,0.0012097,-0.24129,-0.00016389,0.34974,-0.2468,-0.017405},
      {0.00017608,0.00043666,0.41453,2.03E-05,0.0013521,-0.32789,-0.00043,0.29649,-0.20914,-0.089491},
      {0.00020252,0.0020134,0.32238,8.51E-05,0.001105,-0.43196,-0.0015979,0.23156,-0.16253,-0.17584},
      {0.00017236,0.0039964,0.22488,0.00015026,0.00064787,-0.54183,-0.0029963,0.16291,-0.11308,-0.26682},
      {0.00013551,0.0054967,0.1296,0.00018837,0.00020095,-0.65007,-0.0040502,0.095694,-0.064868,-0.35638},
      {0.00013034,0.0098359,0.066093,0.00020823,-0.00013756,-0.71522,-0.0070589,0.052891,-0.032459,-0.41016},
      {0.00013622,0.015591,0.033731,0.00020405,-0.0003477,-0.74,-0.011043,0.03383,-0.016094,-0.43046},
      {0.0001157,0.01935,0.0070673,0.00016705,-0.00048532,-0.76119,-0.013642,0.018479,-0.0033317,-0.44774},
      {7.67E-05,0.023361,-0.0182,0.00011925,-0.00041753,-0.75532,-0.016429,0.019541,-0.0020091,-0.44251},
      {1.10E-05,0.02605,-0.046522,3.18E-05,-0.00022797,-0.72512,-0.018288,0.036459,-0.012498,-0.4171},
      {-3.25E-05,0.027381,-0.076547,-1.49E-05,-0.00016049,-0.69148,-0.019209,0.056195,-0.025688,-0.38906},
      {-7.37E-05,0.025571,-0.14134,2.12E-06,-0.00010196,-0.61971,-0.017975,0.10134,-0.058471,-0.32952},
      {-0.00013111,0.019943,-0.25393,3.71E-05,-8.39E-06,-0.49632,-0.014103,0.18079,-0.11745,-0.2272},
      {-0.00017899,0.015083,-0.36016,6.10E-05,7.31E-05,-0.37939,-0.010776,0.25576,-0.17285,-0.13024},
      {-0.00020651,0.010669,-0.44997,6.98E-05,0.00015569,-0.281,-0.0077527,0.31909,-0.21982,-0.048689},
      {-0.00018974,0.0065786,-0.50503,5.80E-05,0.00025006,-0.22263,-0.0049208,0.35781,-0.24929,-0.00037512},
      {-0.00016986,0.0040741,-0.55595,4.67E-05,0.00030279,-0.16709,-0.0031964,0.39368,-0.27594,0.045635},
      {-0.00071352,0.00054113,0.70551,0,0.00019266,0.00011123,0.00012872,0.49897,-0.35219,0.18445},
      {-0.00072658,0.00052758,0.70549,0,0.00020251,0.00011692,0.00014791,0.49896,-0.35219,0.18444},
      {-0.00074222,0.00050739,0.70547,0,0.000218,0.00012586,0.00017383,0.49895,-0.35218,0.18443},
      {-0.00075479,0.0004809,0.70544,0,0.00024004,0.00013859,0.00020226,0.49895,-0.35219,0.18441},
      {-0.00075524,0.00044914,0.70542,0,0.00026961,0.00015566,0.00022611,0.49895,-0.3522,0.18438},
      {-0.00085979,0.00041194,0.70494,-3.17E-05,0.00031563,-0.00011924,0.00032999,0.49863,-0.35197,0.18409},
      {-0.001426,0.000358,0.70257,-0.00018163,0.00039095,-0.0016478,0.00078171,0.49702,-0.3507,0.18271},
      {-0.0020594,0.00029856,0.69969,-0.0003382,0.00047004,-0.0035634,0.0012868,0.4951,-0.3492,0.18101},
      {-0.0027454,0.00023523,0.69626,-0.00049362,0.00054661,-0.0059319,0.001834,0.49288,-0.34745,0.17893},
      {-0.0034656,0.00016984,0.69223,-0.00063957,0.0006117,-0.0088291,0.0024087,0.49033,-0.34544,0.17644},
      {-0.0041975,0.00010443,0.68755,-0.00076762,0.00065319,-0.012341,0.0029935,0.48744,-0.34317,0.17347},
      {-0.00375,6.08E-05,0.67426,-0.00065432,0.00071816,-0.02707,0.0027346,0.47878,-0.33713,0.16115},
      {-0.0025796,3.18E-05,0.65381,-0.00042336,0.0008099,-0.050695,0.0019592,0.46529,-0.3279,0.14143},
      {-0.0014331,6.05E-06,0.63051,-0.00022372,0.00089352,-0.077295,0.0012012,0.44992,-0.31737,0.11924},
      {-0.00034563,-1.52E-05,0.60423,-6.13E-05,0.0009625,-0.10699,0.00048469,0.43257,-0.30544,0.094516},
      {-3.10E-05,7.94E-05,0.54147,-1.42E-05,0.0010748,-0.17913,0.00015144,0.38841,-0.27429,0.034485},
      {6.43E-05,0.00019353,0.46297,4.71E-06,0.0011964,-0.26975,-6.24E-05,0.33273,-0.23492,-0.040889},
      {0.00013081,0.0002928,0.37699,1.97E-05,0.0013074,-0.36921,-0.0002442,0.27167,-0.19176,-0.12357},
      {0.0001373,0.00098644,0.28473,4.21E-05,0.0011577,-0.47519,-0.00078369,0.20632,-0.14527,-0.21144},
      {9.86E-05,0.0021348,0.19388,6.22E-05,0.00072727,-0.57908,-0.0015898,0.1421,-0.099336,-0.2973},
      {5.79E-05,0.0028905,0.10582,6.18E-05,0.00033874,-0.68057,-0.0021164,0.079744,-0.054893,-0.38107},
      {2.68E-05,0.0044562,0.039438,4.21E-05,6.49E-05,-0.75432,-0.0031992,0.033848,-0.021656,-0.4418},
      {6.85E-06,0.0073705,0.016691,1.34E-06,-1.04E-05,-0.77161,-0.0052119,0.021528,-0.011451,-0.45577},
      {-6.18E-06,0.0095107,0.00056775,-2.11E-05,-9.92E-05,-0.78067,-0.0067017,0.014589,-0.0054479,-0.46312},
      {-1.66E-05,0.011506,-0.017625,-2.72E-05,-0.00016828,-0.77606,-0.0081001,0.01599,-0.0054095,-0.45922},
      {-3.81E-05,0.013772,-0.049746,-2.60E-05,-0.00013726,-0.73789,-0.0096949,0.037664,-0.019531,-0.42753},
      {-6.31E-05,0.014517,-0.084112,-2.58E-05,-0.00010079,-0.69869,-0.010235,0.061059,-0.035638,-0.39499},
      {-9.26E-05,0.013509,-0.13069,-2.23E-05,-5.38E-05,-0.64707,-0.0095637,0.09331,-0.058893,-0.35215},
      {-0.00013346,0.0097429,-0.23479,4.24E-07,2.54E-05,-0.5313,-0.0070031,0.16679,-0.11269,-0.25616},
      {-0.00016677,0.0066618,-0.33087,1.49E-05,9.39E-05,-0.424,-0.004923,0.23461,-0.16213,-0.1672},
      {-0.00019319,0.0042624,-0.41756,2.22E-05,0.00015176,-0.32673,-0.0033185,0.29581,-0.20655,-0.086562},
      {-0.00017309,0.0025162,-0.4679,1.45E-05,0.00020482,-0.27091,-0.0021245,0.3313,-0.23255,-0.040322},
      {-0.00024409,0.00028858,0.70602,0,0.0004123,0.00023804,-2.59E-05,0.49933,-0.35281,0.18424},
      {-0.00025996,0.00028605,0.70596,0,0.00044795,0.00025863,-1.25E-05,0.49929,-0.35278,0.18421},
      {-0.00028397,0.00028214,0.70586,0,0.00050534,0.00029176,7.86E-06,0.49924,-0.35273,0.18415},
      {-0.00031625,0.00027672,0.70573,0,0.00058962,0.00034042,3.54E-05,0.49916,-0.35266,0.18407},
      {-0.00035629,0.00026973,0.70554,0,0.00070728,0.00040835,6.98E-05,0.49905,-0.35256,0.18396},
      {-0.00040302,0.0002611,0.70531,0,0.00086663,0.00050035,0.00011037,0.49891,-0.35244,0.18381},
      {-0.00045476,0.00025085,0.705,0,0.0010782,0.00062251,0.00015592,0.49873,-0.35229,0.1836},
      {-0.00066261,0.00022927,0.70363,-2.66E-05,0.0012629,-0.00013876,0.00032457,0.49788,-0.35162,0.18271},
      {-0.0011964,0.00018629,0.69985,-0.00010392,0.0012724,-0.003092,0.0007491,0.49558,-0.3498,0.18025},
      {-0.0017431,0.00014221,0.69548,-0.00017377,0.0012491,-0.0066501,0.0011854,0.49294,-0.34773,0.17733},
      {-0.0022799,9.85E-05,0.69048,-0.00023148,0.0011772,-0.010898,0.0016163,0.48995,-0.34541,0.17391},
      {-0.0027802,5.69E-05,0.68481,-0.00027297,0.0010372,-0.015932,0.0020217,0.4866,-0.34282,0.16994},
      {-0.0027696,2.53E-05,0.67329,-0.00025317,0.00091143,-0.028133,0.0020632,0.47926,-0.33761,0.16},
      {-0.00183,1.12E-05,0.64888,-0.00015232,0.00096051,-0.0557,0.0014447,0.46306,-0.32648,0.13707},
      {-0.00096735,8.76E-07,0.62175,-7.44E-05,0.00098682,-0.086146,0.00088068,0.44504,-0.31406,0.11178},
      {-0.00021974,-4.74E-06,0.59182,-2.02E-05,0.00098204,-0.11952,0.00039769,0.42514,-0.30027,0.084112},
      {7.71E-05,4.72E-05,0.52986,1.93E-06,0.0010242,-0.19066,0.00013302,0.38171,-0.26967,0.025048},
      {0.00010427,0.00012857,0.4399,1.08E-05,0.0011075,-0.29489,-6.14E-06,0.31778,-0.22449,-0.061523},
      {0.00011052,0.00019407,0.34061,1.56E-05,0.0011161,-0.41007,-0.00010802,0.24725,-0.17464,-0.15705},
      {7.73E-05,0.00040698,0.2395,1.66E-05,0.00099928,-0.52727,-0.00029077,0.1755,-0.12385,-0.25409},
      {4.22E-05,0.00090168,0.15879,6.15E-06,0.00064845,-0.62071,-0.00064136,0.11831,-0.083165,-0.33111},
      {1.94E-05,0.0012972,0.087824,-2.55E-06,0.00035199,-0.70285,-0.00093601,0.067965,-0.047368,-0.39888},
      {-1.17E-06,0.0018168,0.025321,-1.14E-05,0.00011733,-0.77374,-0.0013159,0.024369,-0.016276,-0.4574},
      {-7.77E-06,0.0037736,0.010882,-2.01E-05,1.43E-05,-0.77953,-0.0026863,0.019454,-0.011803,-0.46212},
      {-1.52E-05,0.0050122,-0.0029674,-2.84E-05,-6.71E-05,-0.7839,-0.0035566,0.01591,-0.0086613,-0.46569},
      {-2.33E-05,0.0056002,-0.016595,-3.62E-05,-0.00012401,-0.78582,-0.003975,0.014323,-0.0072303,-0.46722},
      {-4.65E-05,0.0062784,-0.052269,-3.60E-05,-8.33E-05,-0.74508,-0.0044736,0.038706,-0.024069,-0.43341},
      {-7.01E-05,0.00597,-0.090109,-3.68E-05,-3.94E-05,-0.70277,-0.0042919,0.064762,-0.04259,-0.3983},
      {-9.24E-05,0.0048846,-0.13013,-3.85E-05,6.74E-06,-0.65859,-0.0035772,0.092516,-0.062705,-0.36165},
      {-0.0001186,0.0028888,-0.21792,-2.68E-05,7.05E-05,-0.55963,-0.0022548,0.15446,-0.10744,-0.27961},
      {-0.00013991,0.0014086,-0.30167,-1.87E-05,0.00012704,-0.46466,-0.001293,0.21359,-0.14994,-0.20089},
      {-0.00015502,0.0010113,-0.37663,-1.00E-05,0.00041166,-0.37807,-0.0010977,0.26655,-0.18751,-0.12947},
      {-7.37E-05,0.00015695,0.70632,0,0.00047427,0.00027382,-5.60E-05,0.4995,-0.35308,0.18418},
      {-8.34E-05,0.00015515,0.70623,0,0.00054339,0.00031373,-4.74E-05,0.49944,-0.35304,0.18412},
      {-9.79E-05,0.00015238,0.70609,0,0.00065316,0.0003771,-3.46E-05,0.49936,-0.35297,0.18401},
      {-0.00011726,0.00014855,0.70589,0,0.00081144,0.00046849,-1.73E-05,0.49923,-0.35288,0.18386},
      {-0.00014091,0.00014359,0.70562,0,0.0010274,0.00059315,4.05E-06,0.49907,-0.35275,0.18365},
      {-0.00016793,0.0001375,0.70527,0,0.0013119,0.00075743,2.89E-05,0.49885,-0.35258,0.18338},
      {-0.00019696,0.00013026,0.70482,0,0.0016784,0.00096903,5.62E-05,0.49857,-0.35237,0.18303},
      {-0.00022619,0.00012192,0.70427,0,0.0021429,0.0012372,8.47E-05,0.49823,-0.35212,0.18259},
      {-0.00025343,0.00011252,0.7036,0,0.0027248,0.0015732,0.00011275,0.4978,-0.35181,0.18203},
      {-0.00051252,9.04E-05,0.70004,-1.57E-05,0.0027939,-0.0014377,0.00032534,0.49567,-0.35018,0.17943},
      {-0.00083524,6.44E-05,0.69484,-3.17E-05,0.0025595,-0.0064632,0.00059181,0.49258,-0.34785,0.1756},
      {-0.0010996,4.03E-05,0.68902,-3.97E-05,0.0022288,-0.012349,0.00081729,0.48912,-0.34526,0.1712},
      {-0.0012344,1.97E-05,0.68242,-4.45E-05,0.0018203,-0.019265,0.00096094,0.48519,-0.3424,0.16605},
      {-0.0011799,4.22E-06,0.674,-4.46E-05,0.0011501,-0.028788,0.00097504,0.48007,-0.33879,0.15912},
      {-0.00056289,3.91E-06,0.6457,-2.34E-05,0.0010832,-0.060379,0.00059812,0.46119,-0.32568,0.13302},
      {-0.00010579,7.30E-06,0.61441,-7.88E-06,0.00098134,-0.09516,0.00033644,0.44027,-0.31106,0.10432},
      {0.00017655,1.46E-05,0.58004,1.39E-06,0.00083996,-0.13324,0.0002,0.41724,-0.29487,0.072953},
      {0.00024075,3.99E-05,0.51977,4.77E-06,0.0007335,-0.20228,0.00014821,0.3751,-0.26508,0.015857},
      {0.00018709,8.46E-05,0.42072,6.43E-06,0.00073128,-0.31784,6.47E-05,0.30433,-0.21505,-0.079963},
      {0.00012619,0.00012152,0.31942,7.00E-06,0.00071938,-0.43571,-1.64E-05,0.23217,-0.16405,-0.17768},
      {6.35E-05,0.00017507,0.21908,5.82E-06,0.00067928,-0.55213,-0.00010784,0.16091,-0.11366,-0.27416},
      {4.02E-05,0.00047446,0.15124,-2.74E-06,0.00043895,-0.63032,-0.00033656,0.11301,-0.079639,-0.33873},
      {1.82E-05,0.00067748,0.085712,-1.15E-05,0.00023885,-0.70556,-0.00049799,0.066944,-0.046966,-0.40089},
      {-1.65E-06,0.00078705,0.023136,-2.06E-05,8.03E-05,-0.77706,-0.00059387,0.023203,-0.015982,-0.45999},
      {-9.61E-06,0.0016244,0.0058199,-2.87E-05,9.91E-06,-0.78552,-0.0011869,0.017439,-0.011473,-0.46695},
      {-1.63E-05,0.0020455,-0.0071065,-3.64E-05,-3.48E-05,-0.78693,-0.0014914,0.016277,-0.010427,-0.46807},
      {-2.21E-05,0.0020184,-0.019459,-4.39E-05,-5.80E-05,-0.7864,-0.001487,0.016612,-0.010664,-0.46759},
      {-3.96E-05,0.0017339,-0.053403,-4.62E-05,-2.20E-05,-0.75057,-0.0013242,0.038693,-0.026371,-0.43786},
      {-5.78E-05,0.0010117,-0.094629,-4.81E-05,2.62E-05,-0.70447,-0.00086949,0.067359,-0.046948,-0.39963},
      {-7.20E-05,0.00025953,-0.13774,-4.98E-05,0.00025877,-0.65555,-0.00040428,0.097561,-0.068626,-0.35936},
      {-8.66E-05,0.00028276,-0.20248,-4.02E-05,0.00086556,-0.57967,-0.00049021,0.1433,-0.10089,-0.2973},
      {-0.00010176,0.00038667,-0.27364,-2.72E-05,0.0011684,-0.49673,-0.00064371,0.19363,-0.13634,-0.22895},
      {0,6.12E-05,0.70702,0,2.62E-05,1.52E-05,-4.33E-05,0.49994,-0.35348,0.18461},
      {-1.74E-06,6.09E-05,0.70694,0,9.27E-05,5.35E-05,-4.12E-05,0.49989,-0.35344,0.18455},
      {-6.94E-06,5.92E-05,0.7067,0,0.0003099,0.00017892,-3.40E-05,0.49973,-0.35333,0.18434},
      {-1.33E-05,5.67E-05,0.70635,0,0.00062887,0.00036308,-2.44E-05,0.4995,-0.35316,0.18404},
      {-2.02E-05,5.35E-05,0.70586,0,0.0010742,0.0006202,-1.27E-05,0.49918,-0.35293,0.18361},
      {-2.66E-05,4.96E-05,0.7052,0,0.0016773,0.00096841,6.50E-07,0.49874,-0.35261,0.18303},
      {-3.14E-05,4.50E-05,0.70434,0,0.0024782,0.0014308,1.48E-05,0.49817,-0.3522,0.18226},
      {-3.34E-05,3.96E-05,0.70322,0,0.003527,0.0020363,2.85E-05,0.49742,-0.35167,0.18126},
      {-3.16E-05,3.36E-05,0.70178,0,0.0048864,0.0028212,4.05E-05,0.49646,-0.35099,0.17996},
      {-2.51E-05,2.70E-05,0.69996,0,0.0066328,0.0038295,4.85E-05,0.49522,-0.35011,0.17829},
      {-2.76E-05,1.88E-05,0.6969,-7.19E-07,0.0081209,0.0032049,6.53E-05,0.49326,-0.34872,0.17563},
      {-2.78E-05,8.59E-06,0.69093,-2.05E-06,0.0072794,-0.0040488,9.69E-05,0.48968,-0.34618,0.17083},
      {5.33E-05,1.06E-06,0.68443,-3.61E-07,0.0060151,-0.012624,7.53E-05,0.48581,-0.34346,0.16553},
      {8.01E-05,-2.38E-07,0.67602,-4.69E-07,0.0043658,-0.024079,0.00010461,0.48051,-0.3397,0.1584},
      {0.00011036,-1.40E-06,0.66625,-5.81E-07,0.0018604,-0.038658,0.0001354,0.47421,-0.33522,0.14991},
      {0.00015872,2.58E-06,0.63624,2.75E-07,0.0012364,-0.073126,0.00015322,0.45374,-0.32073,0.12223},
      {0.0002085,7.23E-06,0.59983,1.23E-06,0.0010592,-0.11426,0.00016897,0.42871,-0.30301,0.088376},
      {0.00025486,1.13E-05,0.56086,2.05E-06,0.00077587,-0.15868,0.00018498,0.40178,-0.28396,0.051954},
      {0.00027416,2.05E-05,0.50812,2.58E-06,0.00044746,-0.21953,0.00018083,0.36485,-0.25784,0.0019685},
      {0.00020198,4.82E-05,0.40878,1.89E-06,0.00043704,-0.33469,0.00010104,0.29436,-0.20802,-0.093508},
      {0.0001292,6.89E-05,0.30769,1.55E-07,0.00041829,-0.45163,2.72E-05,0.2228,-0.15745,-0.19044},
      {5.86E-05,8.21E-05,0.20536,-2.70E-06,0.00039093,-0.56972,-3.83E-05,0.15055,-0.10638,-0.28832},
      {3.27E-05,0.00020096,0.13911,-1.09E-05,0.00025153,-0.64549,-0.00014507,0.10417,-0.07354,-0.35098},
      {1.46E-05,0.00026748,0.079872,-2.00E-05,0.00013178,-0.71278,-0.00021135,0.063005,-0.044397,-0.40665},
      {1.99E-07,0.00027055,0.02413,-2.94E-05,4.64E-05,-0.77568,-0.00023255,0.024547,-0.017203,-0.45869},
      {-6.93E-06,0.00039527,0.0003441,-3.75E-05,9.00E-06,-0.79204,-0.00033481,0.01445,-0.0099906,-0.4722},
      {-1.11E-05,0.00031834,-0.01176,-4.49E-05,-1.38E-06,-0.79008,-0.00029936,0.01569,-0.010892,-0.47055},
      {-1.34E-05,8.32E-05,-0.02314,-5.20E-05,6.82E-06,-0.78587,-0.00015892,0.018419,-0.012924,-0.46702},
      {-2.33E-05,7.12E-05,-0.051033,-5.39E-05,0.00016225,-0.75606,-0.00019166,0.036451,-0.025639,-0.44253},
      {-3.56E-05,3.84E-05,-0.090201,-5.22E-05,0.00066418,-0.71009,-0.00022508,0.064013,-0.045086,-0.40513},
      {-4.42E-05,-1.36E-05,-0.12775,-4.91E-05,0.0014136,-0.66555,-0.00025021,0.090457,-0.063753,-0.36927},
      {-5.44E-05,-1.48E-05,-0.17763,-4.13E-05,0.0019517,-0.60699,-0.00032234,0.12567,-0.088585,-0.32149},
      {0,1.35E-06,0.70709,0,1.60E-05,9.21E-06,-9.56E-07,0.49999,-0.35354,0.18462},
      {0,1.39E-06,0.70709,0,1.64E-05,9.49E-06,-9.81E-07,0.49999,-0.35354,0.18462},
      {0,1.44E-06,0.70709,0,1.72E-05,9.93E-06,-1.02E-06,0.49999,-0.35354,0.18462},
      {0,1.51E-06,0.70709,0,1.82E-05,1.05E-05,-1.07E-06,0.49999,-0.35354,0.18462},
      {0,1.60E-06,0.70709,0,1.95E-05,1.13E-05,-1.13E-06,0.49999,-0.35354,0.18462},
      {9.48E-07,1.69E-06,0.70634,0,0.0007379,0.00042602,-1.49E-07,0.49948,-0.35318,0.18393},
      {2.92E-06,1.78E-06,0.70474,0,0.0022891,0.0013216,1.91E-06,0.49838,-0.3524,0.18245},
      {5.32E-06,1.86E-06,0.7027,0,0.004278,0.0024699,4.32E-06,0.49697,-0.3514,0.18054},
      {8.19E-06,1.95E-06,0.70012,0,0.0067921,0.0039214,7.10E-06,0.49519,-0.35014,0.17813},
      {1.15E-05,2.02E-06,0.69691,0,0.0099313,0.0057338,1.02E-05,0.49296,-0.34857,0.17513},
      {1.54E-05,2.08E-06,0.69297,0,0.013807,0.0079716,1.37E-05,0.49022,-0.34663,0.17142},
      {1.97E-05,2.11E-06,0.68816,0,0.018543,0.010706,1.74E-05,0.48687,-0.34425,0.16688},
      {4.35E-05,1.35E-06,0.68016,-7.64E-08,0.017135,-0.00022913,4.07E-05,0.48164,-0.34054,0.15984},
      {7.29E-05,5.03E-07,0.67038,-1.56E-07,0.013887,-0.016325,6.79E-05,0.4752,-0.33597,0.15116},
      {0.00010423,-2.65E-07,0.65895,-2.22E-07,0.0097713,-0.035883,9.51E-05,0.46756,-0.33055,0.14085},
      {0.00013665,-9.30E-07,0.64561,-2.73E-07,0.0046649,-0.059431,0.00012163,0.45853,-0.32414,0.12866},
      {0.00017135,9.41E-07,0.61709,1.14E-07,0.0021776,-0.095881,0.00013963,0.43883,-0.3102,0.10201},
      {0.00020372,3.98E-06,0.57771,6.74E-07,0.0017286,-0.14135,0.00015186,0.41144,-0.29082,0.064952},
      {0.00023026,6.44E-06,0.53573,1.09E-06,0.0010871,-0.19031,0.00016214,0.38212,-0.27008,0.025277},
      {0.00024729,8.57E-06,0.48993,1.28E-06,0.00023003,-0.24424,0.00016772,0.35,-0.24735,-0.018209},
      {0.0001722,2.20E-05,0.39112,-1.53E-06,0.00021358,-0.35818,9.93E-05,0.28027,-0.19808,-0.11266},
      {0.00010329,2.93E-05,0.29103,-5.33E-06,0.00019014,-0.47338,4.06E-05,0.20979,-0.14828,-0.20814},
      {4.40E-05,3.03E-05,0.19019,-1.02E-05,0.00015959,-0.58923,-6.11E-06,0.13891,-0.098191,-0.30416},
      {1.84E-05,4.27E-05,0.12205,-1.83E-05,9.35E-05,-0.66661,-4.03E-05,0.09157,-0.06472,-0.36824},
      {6.85E-06,2.79E-05,0.069601,-2.79E-05,3.95E-05,-0.72522,-4.89E-05,0.055728,-0.039385,-0.41675},
      {1.00E-06,5.58E-06,0.022083,-3.86E-05,1.64E-05,-0.77742,-5.06E-05,0.023778,-0.016805,-0.46},
      {-2.40E-06,7.08E-06,-0.0034505,-4.83E-05,1.37E-05,-0.79667,-7.17E-05,0.011949,-0.0084322,-0.47596},
      {-4.85E-06,5.57E-06,-0.013541,-5.44E-05,2.26E-05,-0.79135,-9.56E-05,0.015151,-0.010679,-0.47157},
      {-6.31E-06,-7.66E-06,-0.023305,-5.82E-05,3.86E-05,-0.78558,-0.00011434,0.018636,-0.01313,-0.46681},
      {-1.06E-05,-3.59E-05,-0.043263,-5.80E-05,0.00027347,-0.76518,-0.00013553,0.030844,-0.02174,-0.45023},
      {-1.86E-05,-8.47E-05,-0.079402,-5.43E-05,0.00095619,-0.72237,-0.00016301,0.056298,-0.039705,-0.41572},
      {-2.38E-05,-0.00014471,-0.11337,-4.91E-05,0.0017166,-0.68192,-0.00018644,0.080241,-0.056608,-0.38326},
      {0,5.23E-07,0.7071,0,9.15E-06,5.28E-06,-3.70E-07,0.49999,-0.35355,0.18463},
      {0,5.41E-07,0.7071,0,9.53E-06,5.50E-06,-3.83E-07,0.49999,-0.35355,0.18463},
      {0,5.69E-07,0.7071,0,1.01E-05,5.84E-06,-4.02E-07,0.49999,-0.35355,0.18463},
      {0,6.05E-07,0.7071,0,1.09E-05,6.31E-06,-4.28E-07,0.49999,-0.35355,0.18463},
      {0,6.49E-07,0.70709,0,1.20E-05,6.91E-06,-4.59E-07,0.49999,-0.35355,0.18463},
      {0,6.99E-07,0.70709,0,1.32E-05,7.64E-06,-4.94E-07,0.49999,-0.35355,0.18462},
      {0,7.52E-07,0.70709,0,1.47E-05,8.49E-06,-5.32E-07,0.49999,-0.35355,0.18462},
      {1.08E-06,7.99E-07,0.7059,0,0.001191,0.00068762,3.58E-07,0.49916,-0.35296,0.1835},
      {4.28E-06,8.30E-07,0.70219,0,0.004851,0.0028007,3.04E-06,0.49657,-0.35112,0.17999},
      {7.86E-06,8.53E-07,0.69773,0,0.0092606,0.0053466,6.00E-06,0.49344,-0.34891,0.17577},
      {1.18E-05,8.64E-07,0.69241,0,0.014522,0.0083844,9.16E-06,0.48972,-0.34628,0.17073},
      {1.60E-05,8.60E-07,0.68613,0,0.020748,0.011979,1.25E-05,0.48532,-0.34316,0.16477},
      {2.03E-05,8.39E-07,0.67876,0,0.028058,0.016199,1.59E-05,0.48014,-0.3395,0.15777},
      {3.74E-05,5.59E-07,0.66856,-2.10E-08,0.029344,0.0069739,2.95E-05,0.47312,-0.33452,0.14828},
      {6.58E-05,1.10E-07,0.65511,-5.39E-08,0.023734,-0.01776,5.17E-05,0.4639,-0.32799,0.13583},
      {9.31E-05,-2.60E-07,0.63946,-7.68E-08,0.017129,-0.04681,7.22E-05,0.45309,-0.32033,0.12123},
      {0.00011779,-5.39E-07,0.62132,-8.90E-08,0.0094245,-0.080728,9.00E-05,0.44048,-0.3114,0.10417},
      {0.00013733,1.28E-07,0.59276,2.28E-08,0.0039963,-0.12274,0.00010149,0.42049,-0.29726,0.077125},
      {0.00014894,1.68E-06,0.55045,2.08E-07,0.0030776,-0.17284,0.00010555,0.39078,-0.27625,0.036908},
      {0.00015234,2.62E-06,0.5055,2.44E-07,0.0018759,-0.22663,0.00010539,0.35911,-0.25385,-0.0059686},
      {0.00014695,2.89E-06,0.45767,8.80E-08,0.00033533,-0.28445,0.00010059,0.32534,-0.22998,-0.051701},
      {9.51E-05,4.03E-06,0.36619,-4.26E-06,5.89E-05,-0.38967,5.99E-05,0.26123,-0.18467,-0.13854},
      {4.71E-05,9.80E-07,0.26667,-1.04E-05,3.74E-05,-0.50342,2.42E-05,0.19163,-0.13548,-0.23283},
      {2.27E-05,-1.32E-06,0.16872,-1.87E-05,3.61E-05,-0.61521,2.11E-06,0.12317,-0.087089,-0.32552},
      {9.02E-06,-4.95E-06,0.10077,-2.96E-05,2.94E-05,-0.69165,-1.64E-05,0.076348,-0.053994,-0.38889},
      {5.33E-06,-1.07E-05,0.059195,-4.21E-05,2.07E-05,-0.73678,-3.01E-05,0.048684,-0.034436,-0.42631},
      {2.19E-06,-1.89E-05,0.0216,-5.55E-05,1.52E-05,-0.77702,-4.23E-05,0.024019,-0.017001,-0.45966},
      {-1.28E-07,-2.94E-05,-0.0041849,-6.64E-05,1.79E-05,-0.79888,-5.65E-05,0.010595,-0.0075098,-0.47779},
      {-1.30E-06,-4.57E-05,-0.013477,-6.88E-05,3.57E-05,-0.7931,-7.45E-05,0.014086,-0.0099644,-0.47303},
      {-1.78E-06,-6.93E-05,-0.022229,-6.78E-05,5.86E-05,-0.78718,-8.97E-05,0.017669,-0.012485,-0.46815},
      {-2.73E-06,-0.00010193,-0.034646,-6.32E-05,0.00019001,-0.77556,-0.00010544,0.024635,-0.017393,-0.45871},
      {-7.48E-06,-0.00015682,-0.067008,-5.73E-05,0.00082736,-0.73716,-0.00013213,0.04745,-0.033494,-0.42778},
      {0,1.32E-07,0.7071,0,4.66E-06,2.69E-06,-9.35E-08,0.5,-0.35355,0.18463},
      {0,1.39E-07,0.7071,0,4.97E-06,2.87E-06,-9.85E-08,0.5,-0.35355,0.18463},
      {0,1.50E-07,0.7071,0,5.45E-06,3.15E-06,-1.06E-07,0.5,-0.35355,0.18463},
      {0,1.63E-07,0.7071,0,6.12E-06,3.53E-06,-1.16E-07,0.5,-0.35355,0.18463},
      {0,1.79E-07,0.7071,0,6.97E-06,4.02E-06,-1.27E-07,0.49999,-0.35355,0.18463},
      {0,1.97E-07,0.7071,0,8.02E-06,4.63E-06,-1.39E-07,0.49999,-0.35355,0.18463},
      {0,2.14E-07,0.7071,0,9.25E-06,5.34E-06,-1.51E-07,0.49999,-0.35355,0.18463},
      {0,2.30E-07,0.7071,0,1.07E-05,6.17E-06,-1.62E-07,0.49999,-0.35355,0.18463},
      {0,2.41E-07,0.70709,0,1.23E-05,7.09E-06,-1.71E-07,0.49999,-0.35355,0.18463},
      {1.89E-06,2.42E-07,0.70373,0,0.0033591,0.0019394,1.27E-06,0.49762,-0.35187,0.18142},
      {5.29E-06,2.33E-07,0.69711,0,0.0099351,0.005736,3.84E-06,0.49297,-0.34858,0.17513},
      {8.75E-06,2.16E-07,0.68943,0,0.01758,0.01015,6.42E-06,0.48756,-0.34475,0.16781},
      {1.21E-05,1.91E-07,0.68056,0,0.026403,0.015244,8.91E-06,0.48132,-0.34034,0.15936},
      {1.53E-05,1.59E-07,0.67041,0,0.036522,0.021086,1.12E-05,0.47416,-0.33528,0.14967},
      {2.23E-05,8.77E-08,0.65774,-2.26E-09,0.043388,0.018445,1.63E-05,0.46526,-0.32898,0.13762},
      {4.35E-05,-4.11E-08,0.6402,-9.19E-09,0.034867,-0.016295,3.14E-05,0.45301,-0.3203,0.12105},
      {6.21E-05,-1.10E-07,0.62037,-1.21E-08,0.025333,-0.055479,4.46E-05,0.43911,-0.31047,0.10225},
      {7.50E-05,-1.16E-07,0.5979,-1.08E-08,0.014845,-0.0994,5.36E-05,0.42333,-0.2993,0.0809},
      {7.75E-05,1.94E-08,0.56884,-4.49E-08,0.0055943,-0.14881,5.49E-05,0.40289,-0.28484,0.05322},
      {7.66E-05,1.99E-07,0.52187,-3.54E-07,0.003853,-0.20578,5.38E-05,0.36984,-0.26148,0.0084783},
      {8.58E-05,1.91E-07,0.46991,-9.37E-07,0.0020335,-0.26866,5.99E-05,0.33326,-0.23561,-0.041047},
      {9.32E-05,-2.49E-08,0.41395,-1.89E-06,0.00046733,-0.33576,6.47E-05,0.29383,-0.20772,-0.09443},
      {7.68E-05,-1.94E-06,0.33102,-8.34E-06,2.22E-05,-0.43132,4.97E-05,0.23578,-0.16669,-0.17302},
      {5.01E-05,-5.92E-06,0.23879,-1.92E-05,2.12E-05,-0.53647,2.54E-05,0.17139,-0.12118,-0.26021},
      {2.42E-05,-1.17E-05,0.14979,-3.27E-05,1.98E-05,-0.63789,1.11E-06,0.10927,-0.077278,-0.3443},
      {7.49E-06,-1.93E-05,0.082239,-4.80E-05,1.72E-05,-0.71387,-1.85E-05,0.062727,-0.044381,-0.4073},
      {4.65E-06,-2.90E-05,0.048747,-6.25E-05,1.44E-05,-0.74919,-3.01E-05,0.041073,-0.029078,-0.43658},
      {2.38E-06,-4.06E-05,0.018972,-7.80E-05,1.40E-05,-0.78001,-4.07E-05,0.022165,-0.015718,-0.46214},
      {8.62E-07,-5.51E-05,-0.0045507,-9.19E-05,1.86E-05,-0.80168,-5.14E-05,0.0088629,-0.0063185,-0.48011},
      {5.28E-07,-7.96E-05,-0.012736,-8.90E-05,4.24E-05,-0.79591,-6.70E-05,0.012355,-0.0087723,-0.47536},
      {6.17E-07,-0.00010727,-0.020182,-8.18E-05,6.94E-05,-0.7903,-8.19E-05,0.015759,-0.011161,-0.47075},
      {1.03E-06,-0.00013632,-0.026748,-6.97E-05,9.90E-05,-0.78499,-9.71E-05,0.018982,-0.013418,-0.46639},
      {0,1.09E-08,0.70711,0,1.56E-06,8.99E-07,-7.69E-09,0.5,-0.35355,0.18464},
      {0,1.25E-08,0.7071,0,1.82E-06,1.05E-06,-8.85E-09,0.5,-0.35355,0.18464},
      {0,1.49E-08,0.7071,0,2.22E-06,1.28E-06,-1.06E-08,0.5,-0.35355,0.18464},
      {0,1.81E-08,0.7071,0,2.77E-06,1.60E-06,-1.28E-08,0.5,-0.35355,0.18463},
      {0,2.18E-08,0.7071,0,3.48E-06,2.01E-06,-1.54E-08,0.5,-0.35355,0.18463},
      {0,2.58E-08,0.7071,0,4.34E-06,2.51E-06,-1.83E-08,0.5,-0.35355,0.18463},
      {0,2.98E-08,0.7071,0,5.35E-06,3.09E-06,-2.11E-08,0.5,-0.35355,0.18463},
      {0,3.33E-08,0.7071,0,6.50E-06,3.75E-06,-2.36E-08,0.5,-0.35355,0.18463},
      {0,3.58E-08,0.7071,0,7.76E-06,4.48E-06,-2.53E-08,0.49999,-0.35355,0.18463},
      {0,3.67E-08,0.7071,0,9.13E-06,5.27E-06,-2.60E-08,0.49999,-0.35355,0.18463},
      {0,3.54E-08,0.7071,0,1.06E-05,6.10E-06,-2.50E-08,0.49999,-0.35355,0.18463},
      {3.07E-06,2.96E-08,0.69878,0,0.0083031,0.0047938,2.18E-06,0.49413,-0.3494,0.17669},
      {5.90E-06,2.15E-08,0.68931,0,0.017741,0.010243,4.20E-06,0.48745,-0.34468,0.16765},
      {8.06E-06,1.10E-08,0.67875,0,0.028276,0.016325,5.72E-06,0.48,-0.33941,0.15757},
      {9.44E-06,0,0.66739,0,0.03961,0.022869,6.68E-06,0.47198,-0.33374,0.14671},
      {1.24E-05,0,0.65768,0,0.049286,0.028455,8.80E-06,0.46514,-0.3289,0.13745},
      {2.73E-05,0,0.63686,0,0.037413,-0.015998,1.93E-05,0.4505,-0.31854,0.11764},
      {4.31E-05,0,0.61078,0,0.025512,-0.066578,3.05E-05,0.43214,-0.30555,0.092795},
      {5.93E-05,0,0.57894,0,0.014137,-0.12292,4.19E-05,0.40969,-0.28967,0.062418},
      {7.51E-05,-7.46E-09,0.54031,-3.37E-08,0.0038209,-0.18529,5.31E-05,0.38243,-0.27038,0.025517},
      {7.97E-05,-3.33E-07,0.48651,-1.18E-06,0.0024762,-0.24951,5.58E-05,0.34452,-0.24357,-0.025803},
      {8.25E-05,-9.28E-07,0.42889,-2.83E-06,0.0013283,-0.31782,5.72E-05,0.3039,-0.21485,-0.080797},
      {8.34E-05,-1.85E-06,0.36743,-5.09E-06,0.00038968,-0.39026,5.70E-05,0.26054,-0.18419,-0.13951},
      {6.89E-05,-5.58E-06,0.29216,-1.38E-05,1.08E-05,-0.47706,4.32E-05,0.20778,-0.1469,-0.21094},
      {4.31E-05,-1.31E-05,0.20895,-3.04E-05,9.94E-06,-0.5718,1.83E-05,0.14975,-0.10589,-0.28949},
      {2.05E-05,-2.25E-05,0.12951,-5.02E-05,8.96E-06,-0.66222,-5.21E-06,0.094358,-0.066747,-0.36446},
      {4.84E-06,-3.38E-05,0.063243,-7.21E-05,8.26E-06,-0.73703,-2.47E-05,0.048522,-0.03436,-0.42649},
      {2.90E-06,-4.63E-05,0.037187,-8.86E-05,9.98E-06,-0.76345,-3.51E-05,0.032304,-0.022903,-0.4484},
      {1.56E-06,-6.01E-05,0.014592,-0.0001061,1.35E-05,-0.7858,-4.49E-05,0.018585,-0.013214,-0.46693},
      {8.95E-07,-7.50E-05,-0.00439,-0.00012459,1.86E-05,-0.80393,-5.43E-05,0.0074435,-0.0053481,-0.48197},
      {9.77E-07,-0.00010101,-0.011553,-0.0001159,4.47E-05,-0.79943,-7.04E-05,0.010165,-0.0072521,-0.47828},
      {1.11E-06,-0.00012448,-0.017421,-0.00010908,7.45E-05,-0.79426,-8.66E-05,0.013293,-0.0094454,-0.47404},
      {0,1.26E-11,0.70711,0,0,0,-8.93E-12,0.5,-0.35355,0.18464},
      {0,1.12E-11,0.70711,0,0,0,-7.93E-12,0.5,-0.35355,0.18464},
      {0,8.90E-12,0.70711,0,0,0,-6.29E-12,0.5,-0.35355,0.18464},
      {0,5.46E-11,0.70711,0,1.90E-07,1.10E-07,-3.86E-11,0.5,-0.35355,0.18464},
      {0,1.26E-11,0.70711,0,7.00E-07,4.04E-07,-8.93E-12,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.31E-06,7.55E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.00E-06,1.15E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.76E-06,1.59E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.56E-06,2.06E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,4.38E-06,2.53E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.19E-06,3.00E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,5.95E-06,3.43E-06,0,0.5,-0.35355,0.18463},
      {1.31E-06,0,0.70297,0,0.004128,0.0023833,9.25E-07,0.49708,-0.35149,0.18068},
      {3.99E-06,0,0.69493,0,0.012149,0.0070141,2.82E-06,0.49141,-0.34747,0.17301},
      {6.81E-06,0,0.68705,0,0.02001,0.011553,4.81E-06,0.48585,-0.34354,0.16548},
      {9.72E-06,0,0.67952,0,0.027519,0.015888,6.87E-06,0.48053,-0.33978,0.15829},
      {1.27E-05,0,0.67256,0,0.034471,0.019902,8.95E-06,0.47562,-0.33631,0.15163},
      {2.47E-05,0,0.64586,0,0.028662,-0.020907,1.75E-05,0.45678,-0.32298,0.12614},
      {3.94E-05,0,0.60734,0,0.019269,-0.081563,2.79E-05,0.42959,-0.30374,0.089336},
      {5.31E-05,0,0.56238,0,0.010629,-0.14837,3.76E-05,0.39783,-0.28128,0.04635},
      {6.52E-05,0,0.51035,0,0.0029514,-0.2217,4.61E-05,0.36106,-0.25528,-0.0034239},
      {6.54E-05,-9.08E-07,0.45143,-2.17E-06,0.0013129,-0.29242,4.55E-05,0.31949,-0.22588,-0.059709},
      {6.22E-05,-2.32E-06,0.38867,-5.36E-06,0.00068661,-0.36583,4.22E-05,0.27519,-0.19456,-0.11968},
      {5.70E-05,-4.18E-06,0.32222,-9.42E-06,0.00022092,-0.44326,3.71E-05,0.22827,-0.16139,-0.18321},
      {4.44E-05,-9.11E-06,0.2504,-1.99E-05,3.61E-06,-0.52605,2.44E-05,0.17779,-0.12571,-0.25155},
      {2.41E-05,-2.03E-05,0.1768,-4.32E-05,3.25E-06,-0.60977,1.69E-06,0.1265,-0.089468,-0.32096},
      {9.21E-06,-3.36E-05,0.10749,-7.04E-05,3.03E-06,-0.68859,-1.82E-05,0.078191,-0.055338,-0.38632},
      {1.09E-06,-4.91E-05,0.044068,-0.00010172,3.13E-06,-0.76066,-3.45E-05,0.034008,-0.024124,-0.44607},
      {3.02E-07,-6.20E-05,0.025318,-0.00012323,8.06E-06,-0.7786,-4.36E-05,0.022981,-0.016342,-0.46095},
      {4.44E-07,-7.59E-05,0.0099703,-0.00015597,1.44E-05,-0.79255,-5.33E-05,0.014374,-0.010281,-0.47253},
      {5.50E-07,-9.20E-05,-0.0029508,-0.00019972,2.15E-05,-0.8038,-6.46E-05,0.0074035,-0.0053885,-0.48187},
      {6.70E-07,-0.00011373,-0.0096564,-0.00020462,4.65E-05,-0.80226,-7.97E-05,0.0082984,-0.0060152,-0.48063},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.81E-08,5.66E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.97E-07,2.87E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.11E-07,5.26E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.32E-06,7.64E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.71E-06,9.89E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.06E-06,1.19E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.35E-06,1.36E-06,0,0.5,-0.35355,0.18463},
      {3.07E-07,0,0.70639,0,0.00071915,0.0004152,2.17E-07,0.49949,-0.35319,0.18395},
      {2.88E-06,0,0.70053,0,0.0065591,0.0037869,2.03E-06,0.49536,-0.35027,0.17836},
      {5.41E-06,0,0.69509,0,0.011995,0.0069256,3.82E-06,0.49151,-0.34755,0.17315},
      {7.81E-06,0,0.69023,0,0.016844,0.0097249,5.52E-06,0.48808,-0.34512,0.16851},
      {9.98E-06,0,0.68616,0,0.020913,0.012074,7.06E-06,0.48521,-0.34309,0.16461},
      {1.70E-05,0,0.65964,0,0.018591,-0.022534,1.21E-05,0.46647,-0.32984,0.13925},
      {2.71E-05,0,0.60806,0,0.011952,-0.093552,1.91E-05,0.43002,-0.30405,0.089903},
      {3.45E-05,0,0.5494,0,0.0062832,-0.17108,2.44E-05,0.38855,-0.27473,0.033762},
      {3.86E-05,0,0.48306,0,0.0017855,-0.25546,2.73E-05,0.34164,-0.24156,-0.029744},
      {3.41E-05,-1.40E-06,0.41641,-3.04E-06,0.00043322,-0.33468,2.31E-05,0.29456,-0.20827,-0.093488},
      {2.54E-05,-3.85E-06,0.34898,-8.25E-06,0.000183,-0.41288,1.52E-05,0.24694,-0.1746,-0.15797},
      {1.40E-05,-7.05E-06,0.27503,-1.53E-05,4.23E-05,-0.49842,4.88E-06,0.1947,-0.13768,-0.2287},
      {1.27E-06,-1.28E-05,0.19845,-2.81E-05,1.87E-07,-0.58664,-8.17E-06,0.14071,-0.099515,-0.30178},
      {3.46E-08,-2.70E-05,0.13717,-6.14E-05,8.85E-07,-0.65625,-1.91E-05,0.098026,-0.069363,-0.35949},
      {5.73E-08,-4.16E-05,0.082641,-9.88E-05,1.67E-06,-0.71816,-2.94E-05,0.060046,-0.042537,-0.41083},
      {7.42E-08,-5.64E-05,0.03491,-0.00013981,2.48E-06,-0.77236,-3.98E-05,0.02679,-0.019055,-0.45577},
      {1.77E-07,-7.21E-05,0.017538,-0.0001832,8.14E-06,-0.78919,-5.08E-05,0.016405,-0.011747,-0.46973},
      {2.67E-07,-9.02E-05,0.0066653,-0.00023902,1.52E-05,-0.79824,-6.36E-05,0.010759,-0.0078017,-0.47725},
      {3.26E-07,-0.00011115,-0.0021634,-0.00031072,2.29E-05,-0.80517,-7.83E-05,0.0063961,-0.0047777,-0.483},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.29E-08,7.43E-09,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.59E-07,9.16E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,2.85E-07,1.64E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.82E-07,2.20E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.42E-07,2.55E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.60E-07,2.66E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.33E-07,2.50E-07,0,0.5,-0.35355,0.18464},
      {1.45E-06,0,0.70445,0,0.0026538,0.0015322,1.02E-06,0.49812,-0.35223,0.1821},
      {3.05E-06,0,0.70162,0,0.0054835,0.0031659,2.16E-06,0.49612,-0.35081,0.17939},
      {4.28E-06,0,0.69959,0,0.0075097,0.0043358,3.03E-06,0.49469,-0.34979,0.17745},
      {4.99E-06,0,0.69859,0,0.0085079,0.004912,3.53E-06,0.49398,-0.34929,0.17649},
      {6.46E-06,0,0.67837,0,0.006879,-0.021254,4.57E-06,0.47968,-0.33918,0.15714},
      {8.13E-06,0,0.61199,0,0.0032517,-0.10417,5.75E-06,0.43276,-0.306,0.093597},
      {5.70E-06,0,0.53676,0,0.00092342,-0.19507,4.03E-06,0.37956,-0.26839,0.02157},
      {0,0,0.45223,0,0,-0.29427,0,0.3198,-0.22613,-0.059361},
      {0,-2.01E-06,0.37189,-4.66E-06,0,-0.38697,-1.42E-06,0.26302,-0.18599,-0.13622},
      {0,-6.75E-06,0.29832,-1.59E-05,0,-0.4718,-4.77E-06,0.21106,-0.14925,-0.20656},
      {0,-1.29E-05,0.2222,-3.05E-05,0,-0.55957,-9.09E-06,0.15729,-0.11124,-0.27933},
      {5.77E-10,-2.07E-05,0.14496,-4.95E-05,2.12E-08,-0.64861,-1.46E-05,0.10273,-0.072677,-0.35316},
      {1.81E-08,-3.51E-05,0.099324,-8.89E-05,7.61E-07,-0.70038,-2.48E-05,0.070953,-0.050243,-0.39609},
      {3.10E-08,-4.98E-05,0.059534,-0.00013153,1.50E-06,-0.74553,-3.52E-05,0.043236,-0.030679,-0.43352},
      {3.94E-08,-6.48E-05,0.025832,-0.00017737,2.23E-06,-0.78377,-4.58E-05,0.019739,-0.014102,-0.46524},
      {8.79E-08,-8.38E-05,0.010584,-0.00024131,7.33E-06,-0.79897,-5.92E-05,0.010322,-0.0074979,-0.47785},
      {1.35E-07,-0.00010705,0.0034685,-0.00032795,1.48E-05,-0.80417,-7.56E-05,0.006996,-0.0052213,-0.48216},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {2.18E-07,0,0.70682,0,0.00028445,0.00016423,1.54E-07,0.4998,-0.35341,0.18436},
      {2.61E-07,0,0.70678,0,0.0003242,0.00018718,1.84E-07,0.49977,-0.35339,0.18433},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.69563,0,0,-0.013254,0,0.49188,-0.34781,0.17365},
      {0,0,0.61238,0,0,-0.10937,0,0.43302,-0.30619,0.093949},
      {0,0,0.52166,0,0,-0.21412,0,0.36888,-0.26084,0.0071011},
      {0,0,0.42304,0,0,-0.32799,0,0.29915,-0.21153,-0.087321},
      {0,-2.49E-06,0.32929,-5.97E-06,0,-0.4362,-1.76E-06,0.23288,-0.16467,-0.17704},
      {0,-1.03E-05,0.25434,-2.46E-05,0,-0.52261,-7.26E-06,0.17993,-0.12725,-0.24869},
      {0,-1.97E-05,0.17827,-4.71E-05,0,-0.61033,-1.40E-05,0.12617,-0.089252,-0.32142},
      {0,-3.11E-05,0.10171,-7.39E-05,0,-0.69861,-2.20E-05,0.072062,-0.051014,-0.39462},
      {7.79E-09,-4.54E-05,0.064159,-0.00011621,5.77E-07,-0.74138,-3.21E-05,0.045805,-0.032483,-0.43008},
      {1.35E-08,-6.02E-05,0.037319,-0.00016312,1.21E-06,-0.77182,-4.26E-05,0.027085,-0.019285,-0.45532},
      {1.59E-08,-7.53E-05,0.015861,-0.00021272,1.79E-06,-0.79619,-5.32E-05,0.012081,-0.0087179,-0.47553},
      {3.04E-08,-9.64E-05,0.0047804,-0.00029305,5.85E-06,-0.80747,-6.81E-05,0.0050397,-0.0038085,-0.48489},
      {-0.47577,3.90E-05,-1.19E-06,-0.22232,-3.93E-05,7.16E-05,0.34175,-0.15748,0.13031,0.18444},
      {-0.4468,3.63E-05,-1.25E-05,-0.25152,-2.07E-05,3.42E-05,0.32108,-0.17816,0.10108,0.18443},
      {-0.40323,3.26E-05,-2.90E-05,-0.29556,6.66E-06,-3.58E-05,0.2899,-0.20934,0.056979,0.1844},
      {-0.34507,2.85E-05,-5.02E-05,-0.35455,4.04E-05,-0.00015669,0.24812,-0.25113,-0.0021259,0.18433},
      {-0.27336,2.57E-05,-7.47E-05,-0.42751,7.43E-05,-0.00035231,0.19638,-0.30284,-0.075293,0.1842},
      {-0.19909,0.00029449,-0.00016947,-0.49806,0.00029319,-0.00094616,0.14323,-0.3549,-0.14942,0.1834},
      {-0.13775,0.00025518,-0.00028356,-0.55469,0.00062551,-0.0020663,0.098858,-0.39839,-0.21182,0.18201},
      {-0.091114,0.00033985,-0.00039908,-0.59304,0.00099586,-0.0034591,0.066197,-0.42952,-0.25695,0.18033},
      {-0.054439,0.00037427,-0.00058057,-0.61886,0.0014744,-0.0041604,0.040254,-0.45422,-0.29291,0.17906},
      {-0.029493,0.0018262,-0.0011752,-0.61932,0.0056024,-0.0010974,0.021437,-0.46737,-0.31472,0.17565},
      {-0.01415,0.0029348,-0.0019747,-0.60068,0.011706,0.004223,0.0093852,-0.47255,-0.32707,0.17128},
      {-0.0047137,0.0021724,-0.0024854,-0.58016,0.01636,0.0083894,0.002463,-0.47565,-0.33655,0.16804},
      {-0.00087473,0.00064055,-0.0027151,-0.55684,0.019889,0.011369,4.39E-05,-0.47556,-0.34154,0.16545},
      {-0.00045227,0.0030914,-0.0057523,-0.46897,0.051239,0.029576,-0.0024737,-0.44668,-0.32306,0.13545},
      {-0.00030959,0.0048926,-0.0087977,-0.33905,0.094279,0.054298,-0.0042849,-0.41013,-0.29905,0.094015},
      {-0.00020118,0.0050722,-0.010187,-0.20313,0.13654,0.078421,-0.0046607,-0.37699,-0.27739,0.053242},
      {-0.00011915,0.0039342,-0.0099998,-0.063318,0.17977,0.10294,-0.0038386,-0.34571,-0.25687,0.011444},
      {-4.72E-05,0.0037027,-0.010015,0.014522,0.24317,0.13939,-0.0031992,-0.30287,-0.22628,-0.049322},
      {-6.34E-06,0.0039309,-0.01058,0.082196,0.30101,0.17305,-0.0030798,-0.26447,-0.19784,-0.10445},
      {9.51E-06,0.0036954,-0.010997,0.13636,0.34949,0.20129,-0.002792,-0.23229,-0.17426,-0.15062},
      {6.71E-06,0.0029827,-0.011431,0.17501,0.38976,0.22476,-0.0022698,-0.20529,-0.15507,-0.18895},
      {-1.37E-06,0.002332,-0.016513,0.16654,0.42443,0.24484,-0.0017982,-0.17436,-0.13851,-0.22202},
      {-1.03E-05,0.0012777,-0.022488,0.1449,0.46182,0.26644,-0.0010357,-0.14033,-0.12097,-0.25774},
      {-1.80E-05,0.00035818,-0.028231,0.11892,0.49999,0.28848,-0.00036857,-0.10594,-0.10287,-0.29425},
      {-1.86E-05,0.00024976,-0.034175,0.090324,0.53482,0.30857,-0.00029243,-0.072986,-0.085565,-0.32759},
      {-1.50E-05,0.00027581,-0.040463,0.075853,0.5494,0.31699,-0.00029533,-0.05378,-0.078272,-0.34155},
      {-4.35E-06,0.00019996,-0.046289,0.069552,0.55496,0.32022,-0.00021962,-0.041679,-0.075595,-0.34686},
      {1.37E-05,0.00014405,-0.051881,0.059303,0.56455,0.32579,-0.00015503,-0.027035,-0.07088,-0.35602},
      {4.09E-05,2.93E-05,-0.05459,0.039578,0.58516,0.33771,-3.56E-05,-0.0087539,-0.06073,-0.37571},
      {8.46E-05,-1.18E-05,-0.057792,0.020299,0.60533,0.34939,3.02E-05,0.0099799,-0.050682,-0.395},
      {0.00018468,-8.91E-06,-0.064378,0.024253,0.60095,0.3469,0.0001085,0.01623,-0.052803,-0.39078},
      {0.00023105,-6.41E-06,-0.068453,0.023518,0.6028,0.34799,0.00014886,0.023294,-0.051863,-0.39253},
      {-0.47653,-0.00032329,9.63E-05,-0.20974,3.62E-06,5.75E-05,0.34948,-0.14855,0.14257,0.18441},
      {-0.46133,-0.00013315,3.40E-05,-0.2285,1.57E-05,6.81E-05,0.33661,-0.16188,0.12382,0.18442},
      {-0.42969,3.63E-05,-2.61E-05,-0.26345,4.57E-05,3.87E-05,0.31222,-0.18668,0.088845,0.18441},
      {-0.37356,3.04E-05,-4.71E-05,-0.32013,8.97E-05,-8.68E-05,0.27204,-0.22684,0.032036,0.18435},
      {-0.29955,0.0009935,-0.00014206,-0.38608,0.00026767,-0.00035624,0.22132,-0.27508,-0.036551,0.18385},
      {-0.22688,0.0016387,-0.0002552,-0.45117,0.00052302,-0.00094248,0.17068,-0.32363,-0.1058,0.18299},
      {-0.15789,0.0016683,-0.00037626,-0.51576,0.00085154,-0.0020324,0.12052,-0.37277,-0.17614,0.18163},
      {-0.098749,0.00089355,-0.00056826,-0.57284,0.001314,-0.0029735,0.074322,-0.41977,-0.24359,0.18024},
      {-0.058035,0.00068567,-0.00080778,-0.60426,0.0020288,-0.0033173,0.043546,-0.45005,-0.28753,0.17895},
      {-0.034278,0.0040877,-0.0017869,-0.58912,0.0094076,0.0023042,0.024288,-0.45826,-0.30458,0.17298},
      {-0.017287,0.0053301,-0.0026076,-0.56976,0.015361,0.0071002,0.010958,-0.46431,-0.31831,0.16838},
      {-0.006518,0.0046502,-0.0031405,-0.54865,0.019871,0.010831,0.0030115,-0.46818,-0.32895,0.16499},
      {-0.0011891,0.0024021,-0.0032836,-0.52803,0.023228,0.013425,-0.00033551,-0.46962,-0.33664,0.16233},
      {-0.00047131,0.004615,-0.0074767,-0.42696,0.064978,0.037548,-0.0037921,-0.43244,-0.31416,0.12227},
      {-0.00032093,0.0064927,-0.010561,-0.30067,0.10642,0.061378,-0.0056182,-0.39744,-0.29095,0.082371},
      {-0.00020586,0.0066584,-0.011952,-0.16974,0.14688,0.084485,-0.0059663,-0.36591,-0.27026,0.043331},
      {-0.00011762,0.0056856,-0.011866,-0.037941,0.18958,0.10873,-0.0052214,-0.33522,-0.24993,0.0020726},
      {-4.20E-05,0.0061067,-0.012128,0.024188,0.25384,0.14572,-0.0049748,-0.29142,-0.2184,-0.059467},
      {-1.04E-06,0.0045428,-0.011514,0.080837,0.31384,0.18042,-0.0035162,-0.25366,-0.19075,-0.11679},
      {1.39E-05,0.0042156,-0.011793,0.13347,0.36078,0.20779,-0.00317,-0.22287,-0.16804,-0.16148},
      {9.79E-06,0.0035054,-0.012257,0.17148,0.39984,0.23058,-0.0026634,-0.19672,-0.14944,-0.19862},
      {2.55E-06,0.0029112,-0.018135,0.1568,0.43291,0.24973,-0.0022311,-0.1656,-0.13363,-0.23016},
      {-6.01E-06,0.0018178,-0.02409,0.13596,0.4694,0.2708,-0.001442,-0.13227,-0.11658,-0.26502},
      {-1.72E-05,0.0004647,-0.029265,0.1085,0.50965,0.29405,-0.00045782,-0.09754,-0.0979,-0.30351},
      {-1.83E-05,0.00025727,-0.035063,0.080414,0.54427,0.31401,-0.00030958,-0.06501,-0.080801,-0.33666},
      {-1.42E-05,0.00030453,-0.041977,0.070518,0.55346,0.31932,-0.0003256,-0.048728,-0.076192,-0.34545},
      {-3.82E-06,0.0002363,-0.048517,0.06536,0.55739,0.32161,-0.00025689,-0.036764,-0.074323,-0.34919},
      {1.42E-05,0.00017991,-0.054539,0.05526,0.56639,0.32683,-0.00019267,-0.021932,-0.069903,-0.35778},
      {4.14E-05,6.36E-05,-0.057656,0.035712,0.58639,0.33842,-7.28E-05,-0.0034977,-0.060053,-0.37691},
      {0.00010346,-1.26E-05,-0.060477,0.018336,0.60488,0.34913,4.16E-05,0.013479,-0.050883,-0.39457},
      {0.00020832,-9.68E-06,-0.067468,0.022443,0.59987,0.34627,0.00012352,0.019861,-0.053313,-0.38975},
      {0.00025911,-7.17E-06,-0.071924,0.021867,0.60112,0.34702,0.0001673,0.027043,-0.052668,-0.39093},
      {-0.47064,-0.0013327,0.00037152,-0.1819,7.81E-05,7.87E-06,0.36519,-0.12872,0.16961,0.18426},
      {-0.44662,-0.00031696,0.00029672,-0.20236,0.00013305,2.60E-05,0.34864,-0.14356,0.1486,0.18416},
      {-0.41203,0.0010826,0.00017432,-0.23311,0.00022472,7.32E-05,0.3241,-0.166,0.11686,0.18403},
      {-0.36839,0.0027485,-7.13E-06,-0.2739,0.0003656,0.00016498,0.29201,-0.19601,0.074431,0.18389},
      {-0.31883,0.0044905,-0.00027326,-0.32519,0.00056883,0.00030731,0.25289,-0.2341,0.020682,0.18376},
      {-0.2454,0.0052112,-0.00040804,-0.39267,0.0008094,-0.00014435,0.20078,-0.28429,-0.050762,0.18304},
      {-0.17327,0.0049012,-0.00057501,-0.46014,0.0011504,-0.00082755,0.14751,-0.3368,-0.12579,0.182},
      {-0.11096,0.0039233,-0.00078999,-0.52041,0.0016047,-0.0015339,0.098582,-0.38666,-0.19722,0.18081},
      {-0.066462,0.007269,-0.0016759,-0.54131,0.0077155,0.0020264,0.056609,-0.4198,-0.24876,0.17501},
      {-0.036689,0.0086578,-0.002905,-0.53981,0.015873,0.0072999,0.024565,-0.44593,-0.29193,0.16778},
      {-0.018566,0.0097556,-0.0037635,-0.51906,0.021442,0.01141,0.010462,-0.45293,-0.30699,0.16316},
      {-0.0067779,0.0089478,-0.0043297,-0.49692,0.025613,0.014553,0.0018208,-0.45767,-0.31883,0.15976},
      {-0.0019813,0.011098,-0.0064734,-0.44672,0.046285,0.026745,-0.0048686,-0.44101,-0.31263,0.14012},
      {-0.00070546,0.01136,-0.010392,-0.35503,0.085153,0.049256,-0.0081027,-0.4085,-0.29541,0.10285},
      {-0.00032765,0.0091997,-0.013565,-0.24523,0.12388,0.071611,-0.0078667,-0.37861,-0.27885,0.065646},
      {-0.00020544,0.0092479,-0.014896,-0.12126,0.16149,0.093102,-0.0081002,-0.34966,-0.25977,0.029349},
      {-0.00010707,0.0096653,-0.015408,-0.019014,0.20841,0.11989,-0.0081376,-0.3155,-0.23635,-0.015834},
      {-3.04E-05,0.010182,-0.015488,0.037455,0.26886,0.15464,-0.0079656,-0.27421,-0.20661,-0.073769},
      {1.08E-05,0.0075275,-0.014041,0.085104,0.32848,0.18898,-0.0056983,-0.2381,-0.18028,-0.13081},
      {2.07E-05,0.0050495,-0.01307,0.12924,0.37788,0.21766,-0.0037862,-0.20856,-0.15857,-0.1779},
      {1.55E-05,0.0044697,-0.014769,0.15596,0.41397,0.23873,-0.0033809,-0.18241,-0.14132,-0.21219},
      {8.95E-06,0.0038061,-0.020676,0.14222,0.44553,0.257,-0.0029014,-0.15236,-0.12632,-0.24228},
      {9.69E-07,0.0026386,-0.026643,0.12261,0.48067,0.27729,-0.0020619,-0.12,-0.11002,-0.27586},
      {-9.62E-06,0.0012116,-0.031855,0.096306,0.5197,0.29981,-0.0010274,-0.086145,-0.092026,-0.31318},
      {-1.78E-05,0.00026218,-0.036516,0.065537,0.5586,0.32226,-0.00033201,-0.052781,-0.073591,-0.3504},
      {-1.30E-05,0.00033823,-0.044571,0.062526,0.55924,0.32263,-0.00036509,-0.040916,-0.073234,-0.351},
      {-3.23E-06,0.00029472,-0.052246,0.059044,0.56072,0.32351,-0.00031695,-0.029057,-0.072561,-0.35239},
      {1.48E-05,0.00023563,-0.05894,0.049187,0.56878,0.3282,-0.00025192,-0.013943,-0.068612,-0.36009},
      {4.20E-05,0.00011539,-0.062692,0.02992,0.58785,0.33924,-0.00013037,0.0047206,-0.059234,-0.37831},
      {0.00013546,-1.36E-05,-0.064857,0.015398,0.60385,0.34853,6.10E-05,0.01898,-0.051356,-0.3936},
      {0.00024759,-1.09E-05,-0.072465,0.019738,0.5979,0.34512,0.00014874,0.025563,-0.054258,-0.38786},
      {0.00030505,-8.37E-06,-0.077507,0.019407,0.59822,0.34534,0.00019768,0.032925,-0.054068,-0.38815},
      {-0.3633,0.0025586,0.0015505,-0.14233,0.00021307,1.32E-05,0.36162,-0.10071,0.20494,0.18294},
      {-0.35437,0.0042115,0.0011348,-0.15506,0.00027214,7.78E-05,0.35078,-0.11023,0.19217,0.18297},
      {-0.32915,0.0058295,0.0008251,-0.18223,0.0003569,0.00017944,0.32916,-0.13023,0.16431,0.18297},
      {-0.28948,0.0068775,0.00064499,-0.22466,0.00047932,0.0003042,0.29672,-0.16152,0.12013,0.18289},
      {-0.2449,0.0075724,0.00037602,-0.27776,0.00066876,0.00044628,0.25705,-0.20135,0.063932,0.18278},
      {-0.1987,0.0081987,-4.35E-05,-0.33924,0.00095461,0.00063021,0.21229,-0.2485,-0.0024835,0.18267},
      {-0.15574,0.010907,-0.00074842,-0.4003,0.0020073,0.001224,0.16457,-0.29799,-0.072462,0.18191},
      {-0.10723,0.017854,-0.0015565,-0.43528,0.0060727,0.0031017,0.11535,-0.33524,-0.12814,0.17767},
      {-0.062364,0.021009,-0.0024163,-0.45668,0.011811,0.0061598,0.071256,-0.37013,-0.18206,0.17196},
      {-0.03054,0.021124,-0.0036118,-0.4616,0.019212,0.010537,0.035215,-0.40267,-0.23394,0.16509},
      {-0.012854,0.01831,-0.005245,-0.44568,0.028163,0.015981,0.0089867,-0.4317,-0.28238,0.15703},
      {-0.0048911,0.019193,-0.0071329,-0.40935,0.041178,0.023758,-0.0047538,-0.43517,-0.29868,0.14489},
      {-0.0023002,0.027423,-0.010738,-0.33921,0.074544,0.043089,-0.015155,-0.40234,-0.2783,0.11281},
      {-0.00083815,0.027989,-0.014132,-0.25506,0.10858,0.062818,-0.018909,-0.37432,-0.26391,0.080139},
      {-0.00023082,0.021405,-0.01723,-0.16401,0.1435,0.083065,-0.016353,-0.35077,-0.255,0.046695},
      {-0.00019237,0.013014,-0.019345,-0.059854,0.17878,0.10341,-0.011216,-0.32911,-0.24655,0.012839},
      {-8.53E-05,0.015976,-0.020536,0.0031992,0.23101,0.13329,-0.012724,-0.28935,-0.21849,-0.037364},
      {-7.22E-06,0.016506,-0.020305,0.052906,0.28716,0.16551,-0.012576,-0.25112,-0.19085,-0.091212},
      {3.55E-05,0.013873,-0.018581,0.094717,0.34303,0.19764,-0.010335,-0.21767,-0.16635,-0.14469},
      {3.73E-05,0.0082943,-0.016053,0.12775,0.39651,0.22854,-0.0061811,-0.18923,-0.1458,-0.19574},
      {2.43E-05,0.0058302,-0.018325,0.13497,0.43243,0.24938,-0.0043946,-0.16324,-0.1306,-0.2299},
      {1.86E-05,0.0050321,-0.024314,0.12299,0.46207,0.26652,-0.0038234,-0.13452,-0.11669,-0.25817},
      {1.14E-05,0.0037383,-0.030375,0.10502,0.49545,0.28578,-0.0028978,-0.10336,-0.10138,-0.29006},
      {1.63E-06,0.002191,-0.035694,0.080281,0.53286,0.30735,-0.0017813,-0.07057,-0.084316,-0.32584},
      {-1.18E-05,0.00071882,-0.040506,0.054214,0.56649,0.32677,-0.00069427,-0.041146,-0.069097,-0.358},
      {-1.18E-05,0.00035671,-0.048682,0.051969,0.56625,0.32666,-0.00040047,-0.030079,-0.069659,-0.35774},
      {-2.86E-06,0.0003789,-0.058012,0.050634,0.56446,0.32564,-0.00040426,-0.018146,-0.070551,-0.356},
      {1.52E-05,0.00031244,-0.065647,0.04113,0.57118,0.32955,-0.00033551,-0.002659,-0.06728,-0.36241},
      {4.24E-05,0.0001839,-0.070284,0.022264,0.58892,0.33983,-0.00020952,0.016308,-0.058575,-0.37936},
      {0.00015504,5.05E-05,-0.074828,0.014177,0.59646,0.34424,3.13E-06,0.027957,-0.05492,-0.38653},
      {0.00030756,-1.26E-05,-0.079847,0.016175,0.5945,0.34316,0.00018777,0.033654,-0.055887,-0.38462},
      {0.00037394,-1.00E-05,-0.085696,0.016187,0.59356,0.34264,0.00024365,0.041264,-0.056327,-0.38369},
      {-0.1503,-0.0038558,0.0068829,-0.11271,-0.00034348,0.00038046,0.33398,-0.076181,0.22672,0.18061},
      {-0.14662,-0.0026961,0.006394,-0.12694,-0.0002914,0.00043697,0.32272,-0.086912,0.21241,0.18068},
      {-0.14116,-0.00084295,0.0055828,-0.14892,-0.00019443,0.00051233,0.30558,-0.10356,0.19032,0.18079},
      {-0.13398,0.0018628,0.0043452,-0.17935,-2.54E-05,0.00059436,0.28234,-0.12678,0.1597,0.18098},
      {-0.12663,0.0084792,0.0025293,-0.20862,0.00054112,0.00094595,0.25383,-0.15018,0.12948,0.18081},
      {-0.10059,0.014571,0.0013877,-0.24949,0.0017422,0.0017445,0.21351,-0.18409,0.082308,0.17979},
      {-0.06932,0.020766,0.00050213,-0.29602,0.0040482,0.0031533,0.16623,-0.22575,0.0226,0.17772},
      {-0.043999,0.029068,-0.00077851,-0.34045,0.0076764,0.005166,0.11727,-0.27059,-0.041938,0.17468},
      {-0.026684,0.039857,-0.002509,-0.37959,0.012814,0.0078102,0.069352,-0.3176,-0.10986,0.17061},
      {-0.00011209,0.03976,-0.0037521,-0.39041,0.019567,0.011606,0.032322,-0.35482,-0.16749,0.16439},
      {0.011255,0.040202,-0.0060167,-0.36797,0.033289,0.019535,0.0037551,-0.37657,-0.20941,0.15148},
      {0.0048728,0.048821,-0.010692,-0.29901,0.065923,0.038285,-0.019956,-0.36893,-0.22408,0.12037},
      {-0.0018036,0.054481,-0.015764,-0.21163,0.10366,0.059946,-0.034029,-0.35518,-0.23363,0.084514},
      {-0.00028542,0.053958,-0.018493,-0.14134,0.13195,0.076377,-0.037124,-0.33307,-0.22355,0.057352},
      {0.00040487,0.046585,-0.020997,-0.062899,0.16172,0.09367,-0.034152,-0.3147,-0.21838,0.02884},
      {0.00021592,0.036453,-0.024537,-0.0074485,0.20116,0.11647,-0.027646,-0.29013,-0.21069,-0.008842},
      {-4.41E-05,0.025386,-0.027459,0.026217,0.25543,0.14777,-0.019515,-0.25706,-0.19655,-0.060665},
      {3.54E-05,0.025764,-0.026746,0.068697,0.30734,0.1775,-0.019283,-0.22221,-0.17114,-0.11049},
      {8.02E-05,0.022975,-0.024747,0.10448,0.35914,0.20725,-0.016959,-0.19176,-0.14878,-0.1601},
      {8.41E-05,0.017127,-0.022844,0.13128,0.40753,0.23516,-0.012639,-0.16582,-0.13101,-0.20628},
      {5.00E-05,0.0098711,-0.024692,0.1139,0.44802,0.2584,-0.0073633,-0.14011,-0.11848,-0.24491},
      {3.25E-05,0.0065638,-0.029328,0.099774,0.48187,0.27791,-0.0049842,-0.11216,-0.10507,-0.2772},
      {2.65E-05,0.005073,-0.035618,0.083858,0.51314,0.29592,-0.0039242,-0.082297,-0.091002,-0.30709},
      {1.77E-05,0.0033448,-0.041155,0.061056,0.5486,0.31635,-0.0026841,-0.050693,-0.075081,-0.341},
      {4.15E-06,0.0018002,-0.048538,0.046332,0.56654,0.32672,-0.0015391,-0.02879,-0.067795,-0.35813},
      {-9.90E-06,0.00057258,-0.056182,0.041579,0.57056,0.3291,-0.00059677,-0.016189,-0.0672,-0.3619},
      {-3.17E-06,0.00049038,-0.066561,0.040371,0.56769,0.32748,-0.00052225,-0.0036212,-0.068746,-0.35913},
      {1.50E-05,0.00040869,-0.075426,0.031352,0.57262,0.33035,-0.00044464,0.01232,-0.06639,-0.36381},
      {4.23E-05,0.00026492,-0.08121,0.013018,0.5886,0.33961,-0.00030967,0.031655,-0.058577,-0.37908},
      {0.00017362,0.00012524,-0.089229,0.012548,0.58532,0.33779,-7.06E-05,0.04057,-0.060332,-0.37589},
      {0.00036685,5.46E-06,-0.092223,0.012689,0.5864,0.33847,0.00020248,0.045511,-0.059832,-0.37687},
      {0.00047227,-1.23E-05,-0.097104,0.012356,0.58637,0.33849,0.00030994,0.05239,-0.059817,-0.37681},
      {0.042186,-0.019862,0.025802,-0.069269,-0.0021004,0.0016383,0.29168,-0.032134,0.24874,0.1772},
      {0.045885,-0.019686,0.021916,-0.073581,-0.0021699,0.0017523,0.28542,-0.038031,0.24806,0.17719},
      {0.052826,-0.019495,0.015698,-0.079855,-0.0022816,0.0019448,0.27565,-0.047028,0.24758,0.17712},
      {0.052839,-0.015072,0.013304,-0.10245,-0.0019482,0.0022447,0.25334,-0.065827,0.22529,0.17702},
      {0.052725,-0.0079858,0.011084,-0.13214,-0.0013023,0.0026477,0.22382,-0.090195,0.19452,0.1768},
      {0.05447,0.0018399,0.0081963,-0.16653,-0.00029777,0.0031503,0.18851,-0.11912,0.15838,0.17645},
      {0.058531,0.014978,0.0045565,-0.205,0.0011698,0.0037357,0.14814,-0.15241,0.1173,0.17598},
      {0.069772,0.025095,0.0022048,-0.24937,0.0044105,0.0053731,0.10166,-0.19692,0.056104,0.1737},
      {0.077885,0.034619,0.00038521,-0.29078,0.0095219,0.0079712,0.055077,-0.24721,-0.016007,0.16981},
      {0.055477,0.056796,-0.0029584,-0.29945,0.021997,0.014377,0.013072,-0.2776,-0.065401,0.15928},
      {0.032077,0.082337,-0.0074292,-0.27458,0.041691,0.024991,-0.026278,-0.29554,-0.10363,0.1416},
      {0.023941,0.087222,-0.011641,-0.21026,0.070307,0.041506,-0.048343,-0.296,-0.12686,0.11422},
      {0.014697,0.089681,-0.016532,-0.13019,0.10545,0.061686,-0.061381,-0.2919,-0.14787,0.080955},
      {0.0046342,0.089288,-0.022031,-0.035963,0.14538,0.08445,-0.064553,-0.28524,-0.16826,0.043553},
      {0.0012167,0.083969,-0.026782,0.019162,0.17724,0.10271,-0.061042,-0.26925,-0.17135,0.013435},
      {0.00064142,0.075859,-0.030995,0.039535,0.21526,0.12463,-0.055579,-0.24319,-0.16256,-0.022843},
      {0.00030994,0.062599,-0.033529,0.06191,0.26501,0.15336,-0.046035,-0.21524,-0.15295,-0.070294},
      {0.00013751,0.042525,-0.034511,0.084687,0.32531,0.18817,-0.031353,-0.18718,-0.14477,-0.12778},
      {0.00015849,0.034896,-0.033436,0.11556,0.374,0.21614,-0.025634,-0.16084,-0.12887,-0.17438},
      {0.00015245,0.028219,-0.035045,0.1173,0.40891,0.2361,-0.020718,-0.13923,-0.11861,-0.20771},
      {0.00012179,0.020442,-0.03788,0.10125,0.4469,0.25782,-0.015071,-0.11424,-0.10785,-0.24396},
      {7.47E-05,0.011616,-0.039158,0.079441,0.49365,0.28465,-0.008711,-0.085988,-0.093727,-0.2886},
      {4.74E-05,0.006539,-0.042875,0.060275,0.5328,0.30716,-0.0050747,-0.056837,-0.079441,-0.32601},
      {3.99E-05,0.0045587,-0.048823,0.039854,0.56583,0.32616,-0.003662,-0.026522,-0.064966,-0.35763},
      {2.36E-05,0.0028479,-0.060541,0.037249,0.56424,0.32527,-0.0023859,-0.012451,-0.067647,-0.35604},
      {8.96E-06,0.0016877,-0.071568,0.035095,0.56327,0.32479,-0.0015117,0.0014798,-0.069444,-0.35503},
      {-3.86E-06,0.00065712,-0.079126,0.028909,0.5686,0.32795,-0.00069685,0.014999,-0.068021,-0.36003},
      {1.37E-05,0.00051782,-0.089295,0.020355,0.57163,0.32974,-0.00057762,0.031398,-0.066675,-0.36291},
      {5.70E-05,0.00035767,-0.098533,0.0086412,0.57772,0.3333,-0.00041303,0.048614,-0.063822,-0.3687},
      {0.00018614,0.00020099,-0.1094,0.010498,0.56905,0.32837,-0.00015728,0.057723,-0.068303,-0.36034},
      {0.00036991,6.18E-05,-0.11439,0.010488,0.56795,0.32779,0.00012609,0.063917,-0.06893,-0.35923},
      {0.00060798,-1.50E-05,-0.1125,0.0081744,0.57562,0.33228,0.00040238,0.066671,-0.065048,-0.36653},
      {0.16813,-0.042548,0.069496,-0.039743,-0.0052961,0.0034347,0.21956,0.019111,0.23181,0.1738},
      {0.17232,-0.042731,0.064564,-0.043973,-0.0053985,0.0035865,0.21278,0.012504,0.23222,0.17372},
      {0.17953,-0.043101,0.056833,-0.050232,-0.0055667,0.0038316,0.20221,0.0024035,0.23321,0.17357},
      {0.19087,-0.04379,0.045892,-0.058416,-0.0058215,0.0041912,0.18739,-0.011429,0.23523,0.17331},
      {0.20751,-0.044985,0.031326,-0.068299,-0.0061915,0.0046881,0.16784,-0.029153,0.23886,0.17288},
      {0.21711,-0.040405,0.020277,-0.091682,-0.0058305,0.0052484,0.13823,-0.055353,0.22313,0.17241},
      {0.20345,-0.025106,0.016072,-0.12937,-0.0039276,0.005732,0.10192,-0.088885,0.1828,0.17206},
      {0.1742,-0.0043231,0.010862,-0.16058,-0.00098508,0.0065229,0.06748,-0.1192,0.14786,0.17103},
      {0.14663,0.018906,0.0045014,-0.18344,0.0023299,0.0082883,0.030395,-0.14615,0.11803,0.16819},
      {0.11627,0.041652,0.00056254,-0.18641,0.015283,0.015462,-0.0095591,-0.17709,0.06758,0.15632},
      {0.084563,0.073961,-0.0042501,-0.17244,0.034115,0.025178,-0.050302,-0.20355,0.019836,0.14027},
      {0.052157,0.1168,-0.0099815,-0.14093,0.05874,0.037127,-0.090433,-0.22482,-0.023387,0.12056},
      {0.034901,0.13075,-0.0151,-0.075431,0.091035,0.054788,-0.10802,-0.23081,-0.054168,0.09158},
      {0.01978,0.13243,-0.022539,-0.010888,0.12811,0.075618,-0.10897,-0.2261,-0.07977,0.057067},
      {0.0071211,0.13365,-0.031665,0.041184,0.16983,0.098964,-0.1035,-0.21337,-0.099329,0.018619},
      {0.00092102,0.12957,-0.039228,0.078407,0.21415,0.12403,-0.094206,-0.19359,-0.1074,-0.022428},
      {0.00061342,0.11589,-0.040918,0.092035,0.26036,0.15072,-0.084388,-0.16947,-0.099962,-0.066453},
      {0.00045915,0.092733,-0.042413,0.11154,0.31413,0.18178,-0.067582,-0.14722,-0.098036,-0.11773},
      {0.00032216,0.061342,-0.046325,0.11702,0.36531,0.21121,-0.044778,-0.12923,-0.10556,-0.16639},
      {0.00025032,0.041389,-0.052441,0.1049,0.40256,0.23247,-0.030304,-0.10912,-0.10786,-0.20182},
      {0.00022237,0.033136,-0.056577,0.089571,0.43864,0.25302,-0.024326,-0.083925,-0.098502,-0.23627},
      {0.00017784,0.023859,-0.058963,0.068575,0.48351,0.2787,-0.017651,-0.055731,-0.085759,-0.27913},
      {0.00011583,0.013265,-0.058516,0.042848,0.53668,0.30922,-0.010051,-0.026638,-0.070187,-0.32994},
      {6.32E-05,0.0057333,-0.064701,0.029267,0.56157,0.32354,-0.0046277,-0.0059323,-0.065605,-0.35369},
      {4.70E-05,0.0040672,-0.079864,0.029203,0.55497,0.31978,-0.0034088,0.0095211,-0.070711,-0.34729},
      {3.33E-05,0.0028961,-0.094399,0.027665,0.55014,0.31708,-0.0025416,0.025686,-0.074432,-0.34256},
      {2.14E-05,0.0017364,-0.10454,0.021133,0.55312,0.31889,-0.0016409,0.041108,-0.074307,-0.34532},
      {1.19E-05,0.00065738,-0.10894,0.0090279,0.5657,0.32625,-0.00075522,0.055201,-0.069369,-0.35728},
      {6.74E-05,0.00044846,-0.12371,0.0063467,0.55722,0.32142,-0.00052372,0.069878,-0.073875,-0.3491},
      {0.00018615,0.00026155,-0.13702,0.0080623,0.54587,0.31495,-0.00024951,0.080511,-0.079744,-0.33817},
      {0.00035999,9.38E-05,-0.14428,0.0079513,0.54227,0.31294,5.13E-05,0.088103,-0.081669,-0.33466},
      {0.00057952,5.00E-06,-0.14565,0.0054669,0.54647,0.31543,0.00032761,0.092996,-0.079562,-0.33864},
      {0.21846,-0.063579,0.16798,-0.021741,-0.0080145,0.0044306,0.12918,0.10137,0.15046,0.17212},
      {0.22608,-0.067026,0.1481,-0.022903,-0.0085447,0.0048016,0.12622,0.08639,0.16899,0.17172},
      {0.23806,-0.072349,0.11735,-0.024612,-0.0093588,0.005362,0.12153,0.063292,0.19768,0.17109},
      {0.2376,-0.072346,0.10232,-0.031322,-0.0099385,0.0058985,0.11237,0.047586,0.20491,0.17034},
      {0.23724,-0.072518,0.084267,-0.038905,-0.010759,0.0066486,0.09998,0.029012,0.21383,0.16924},
      {0.23782,-0.073351,0.062566,-0.046538,-0.011926,0.0076816,0.084074,0.0076905,0.22582,0.16769},
      {0.23967,-0.075173,0.037303,-0.053492,-0.013563,0.0090791,0.064343,-0.015817,0.2414,0.16553},
      {0.22239,-0.062002,0.023566,-0.072614,-0.012353,0.010677,0.035042,-0.043115,0.22711,0.16305},
      {0.19536,-0.037356,0.016814,-0.094408,-0.0084496,0.012499,-0.00073029,-0.070198,0.19771,0.16018},
      {0.17035,-0.0091359,0.0093647,-0.10944,-0.0033132,0.014678,-0.039543,-0.094421,0.17269,0.15667},
      {0.14259,0.024596,0.0024521,-0.10713,0.0091516,0.020496,-0.079435,-0.11837,0.13998,0.14715},
      {0.10333,0.073388,-0.0039832,-0.080752,0.034665,0.032141,-0.11703,-0.14313,0.09111,0.1277},
      {0.058306,0.13991,-0.013106,-0.051637,0.064429,0.044345,-0.15134,-0.16118,0.046341,0.10683},
      {0.02538,0.19565,-0.022941,-0.012973,0.097939,0.059416,-0.17346,-0.16766,0.012995,0.081879},
      {0.013368,0.19624,-0.031167,0.035431,0.13916,0.082482,-0.16587,-0.15806,-0.0087763,0.044148},
      {0.0055662,0.19307,-0.039858,0.077728,0.18561,0.10857,-0.15328,-0.14233,-0.025031,0.001726},
      {0.0012611,0.18058,-0.050157,0.11888,0.23504,0.13633,-0.13258,-0.12442,-0.04258,-0.043401},
      {0.00077061,0.15151,-0.055419,0.12805,0.2769,0.16019,-0.11003,-0.11163,-0.055525,-0.082953},
      {0.00059886,0.11602,-0.063439,0.11826,0.31722,0.18313,-0.084165,-0.098326,-0.07273,-0.12118},
      {0.00045551,0.079545,-0.072932,0.10115,0.36706,0.2117,-0.057806,-0.07673,-0.085851,-0.16843},
      {0.00035862,0.048192,-0.082875,0.079584,0.4207,0.24248,-0.035317,-0.047811,-0.091436,-0.21939},
      {0.00031554,0.038505,-0.086554,0.058775,0.46442,0.26743,-0.028363,-0.018859,-0.079656,-0.26115},
      {0.00024505,0.026874,-0.089946,0.037664,0.50673,0.29163,-0.020017,0.0072628,-0.070559,-0.30161},
      {0.00014633,0.013946,-0.097886,0.027311,0.52648,0.30297,-0.010708,0.022779,-0.074168,-0.32042},
      {7.67E-05,0.0054505,-0.10968,0.021551,0.53606,0.30871,-0.00462,0.039755,-0.078292,-0.32932},
      {6.37E-05,0.0041116,-0.12733,0.019661,0.52832,0.30433,-0.0036379,0.058145,-0.08364,-0.32181},
      {5.25E-05,0.0028,-0.14029,0.012855,0.52862,0.3046,-0.0026334,0.075559,-0.085008,-0.322},
      {4.58E-05,0.0015841,-0.14892,0.0034018,0.53407,0.30785,-0.0016408,0.090468,-0.083789,-0.32711},
      {6.31E-05,0.00058004,-0.15928,0.0039154,0.52651,0.30365,-0.00069915,0.098683,-0.08896,-0.31974},
      {0.00016602,0.00028176,-0.17411,0.0053447,0.5136,0.29628,-0.000334,0.11023,-0.095784,-0.3073},
      {0.00033007,7.47E-05,-0.18383,0.0052103,0.50724,0.29269,-7.09E-06,0.11931,-0.099145,-0.30115},
      {0.00052285,2.98E-05,-0.18995,0.0026573,0.5064,0.29227,0.00022862,0.12734,-0.09956,-0.30029},
      {0.1466,-0.062071,0.31005,-0.011329,-0.0086969,0.0041582,0.080312,0.20952,0.019491,0.17222},
      {0.15495,-0.066357,0.28897,-0.01232,-0.009638,0.0047609,0.076893,0.19381,0.039003,0.17132},
      {0.16758,-0.073116,0.2569,-0.013759,-0.011142,0.0057156,0.071261,0.16995,0.068696,0.16987},
      {0.18455,-0.082768,0.21335,-0.01558,-0.013326,0.0070858,0.062787,0.13763,0.10905,0.16775},
      {0.20566,-0.095784,0.15826,-0.017665,-0.016321,0.008941,0.05074,0.096886,0.16015,0.16482},
      {0.21575,-0.1025,0.12124,-0.022301,-0.018563,0.010567,0.034482,0.066871,0.19006,0.16228},
      {0.21935,-0.1054,0.094718,-0.027862,-0.020548,0.012228,0.014494,0.043385,0.20792,0.1597},
      {0.22372,-0.10963,0.064351,-0.032498,-0.023249,0.014405,-0.0092311,0.01767,0.22975,0.15627},
      {0.22722,-0.11381,0.031503,-0.036387,-0.026403,0.01716,-0.037074,-0.0097943,0.2533,0.15189},
      {0.19426,-0.075893,0.024549,-0.050587,-0.019514,0.018564,-0.074358,-0.033547,0.22661,0.14873},
      {0.15718,-0.025878,0.015617,-0.060172,-0.010626,0.019929,-0.11487,-0.056077,0.20232,0.14523},
      {0.12067,0.0344,0.003606,-0.063728,-0.00020124,0.021631,-0.15852,-0.077247,0.1831,0.14132},
      {0.079889,0.1037,-0.0058269,-0.036637,0.029021,0.033081,-0.18914,-0.0956,0.14107,0.12223},
      {0.044901,0.17914,-0.016073,-0.0027993,0.061599,0.046139,-0.21545,-0.10599,0.10654,0.10113},
      {0.017337,0.25749,-0.027927,0.039116,0.094514,0.059593,-0.23588,-0.10899,0.080498,0.079725},
      {0.0078223,0.26347,-0.037863,0.08464,0.13717,0.082643,-0.22291,-0.10032,0.056895,0.042385},
      {0.0041711,0.24045,-0.051834,0.11169,0.17626,0.10343,-0.19221,-0.093209,0.022239,0.0074643},
      {0.0018047,0.21252,-0.069984,0.12725,0.21163,0.12226,-0.15906,-0.08349,-0.014738,-0.023103},
      {0.00086649,0.17978,-0.084712,0.12496,0.2509,0.14426,-0.12985,-0.067948,-0.040058,-0.058638},
      {0.00071342,0.14244,-0.094929,0.10592,0.30162,0.17331,-0.10286,-0.045394,-0.053693,-0.10666},
      {0.00058959,0.10239,-0.10759,0.080944,0.36202,0.20802,-0.074153,-0.014226,-0.06484,-0.16395},
      {0.00048892,0.057639,-0.1247,0.052176,0.42893,0.24647,-0.042333,0.024836,-0.077001,-0.2276},
      {0.00037432,0.039995,-0.13896,0.04085,0.44653,0.25624,-0.029676,0.044554,-0.086345,-0.24458},
      {0.00027524,0.026556,-0.15255,0.033595,0.45966,0.26384,-0.020049,0.063046,-0.093718,-0.25699},
      {0.00018249,0.015029,-0.16399,0.023249,0.47632,0.2737,-0.011779,0.082214,-0.097493,-0.27261},
      {0.00010075,0.0052189,-0.17355,0.011666,0.4943,0.28451,-0.0047317,0.10081,-0.098926,-0.28939},
      {8.99E-05,0.0037361,-0.18945,0.0046707,0.49171,0.2831,-0.0036072,0.12021,-0.10192,-0.2868},
      {8.27E-05,0.0023514,-0.20524,0.0031804,0.48071,0.27689,-0.0024378,0.1334,-0.10918,-0.27615},
      {9.55E-05,0.001212,-0.21733,0.0034056,0.47136,0.27166,-0.0013876,0.14268,-0.11541,-0.26706},
      {0.00013441,0.0003281,-0.22516,0.0029278,0.46712,0.26939,-0.00048958,0.14971,-0.11884,-0.26284},
      {0.00026151,7.16E-05,-0.23742,0.0024518,0.45828,0.2644,-0.00010185,0.16048,-0.12362,-0.25429},
      {0.00043616,5.73E-05,-0.24688,7.65E-05,0.45362,0.26178,0.00010923,0.17054,-0.12595,-0.24977},
      {0.087091,-0.049308,0.46833,-0.0048913,-0.0054692,0.0019125,0.045288,0.32673,-0.1286,0.17646},
      {0.093521,-0.054042,0.45302,-0.0052917,-0.0062479,0.0023696,0.042569,0.31548,-0.11421,0.17567},
      {0.10601,-0.062299,0.42063,-0.0064034,-0.0081471,0.0035334,0.034966,0.2916,-0.08417,0.17379},
      {0.12276,-0.074005,0.37634,-0.0078272,-0.010849,0.0051796,0.024024,0.25902,-0.043068,0.17111},
      {0.14317,-0.089505,0.31997,-0.0094812,-0.014459,0.007354,0.0092785,0.21766,0.009257,0.16752},
      {0.16069,-0.10661,0.25463,-0.011201,-0.018843,0.0097459,-0.0080917,0.16981,0.069722,0.16292},
      {0.17953,-0.12669,0.17984,-0.012887,-0.024037,0.01246,-0.02946,0.11524,0.13889,0.15735},
      {0.17842,-0.12753,0.14537,-0.016394,-0.026634,0.01422,-0.051362,0.08734,0.16516,0.15354},
      {0.17473,-0.12513,0.11027,-0.019573,-0.029245,0.016173,-0.076997,0.058942,0.19127,0.14938},
      {0.17096,-0.1219,0.067995,-0.021865,-0.03229,0.01851,-0.10717,0.02583,0.22411,0.14454},
      {0.15055,-0.087567,0.040863,-0.025747,-0.027907,0.020411,-0.14344,-0.0026491,0.2292,0.14054},
      {0.11774,-0.02195,0.027341,-0.027188,-0.016612,0.021956,-0.18412,-0.024094,0.21262,0.13738},
      {0.087687,0.054327,0.01012,-0.020072,-0.0057976,0.024327,-0.22347,-0.044655,0.20112,0.13278},
      {0.058839,0.13332,-0.0051895,0.0067387,0.016149,0.032205,-0.2524,-0.059166,0.18004,0.11987},
      {0.03422,0.21044,-0.018689,0.045356,0.047652,0.043099,-0.26446,-0.065575,0.14806,0.10066},
      {0.015387,0.28164,-0.036278,0.075796,0.074495,0.04946,-0.26736,-0.070941,0.11431,0.088179},
      {0.0056409,0.30765,-0.054011,0.099857,0.10417,0.061253,-0.25342,-0.070185,0.080336,0.06996},
      {0.0033671,0.27981,-0.072465,0.11341,0.14148,0.081188,-0.21955,-0.059851,0.043087,0.038185},
      {0.0018098,0.2502,-0.094899,0.11958,0.17769,0.10119,-0.18698,-0.042263,0.008711,0.007675},
      {0.0009515,0.21765,-0.11943,0.11469,0.21588,0.12303,-0.15643,-0.016313,-0.019713,-0.025398},
      {0.00081143,0.1751,-0.13413,0.088547,0.27524,0.15699,-0.12595,0.015272,-0.033878,-0.081783},
      {0.00064401,0.11982,-0.16314,0.068138,0.32053,0.18226,-0.086584,0.048696,-0.067242,-0.12544},
      {0.00051647,0.065522,-0.19887,0.05233,0.35727,0.20357,-0.048129,0.085974,-0.10388,-0.16017},
      {0.00041214,0.038325,-0.22353,0.039038,0.37805,0.21589,-0.028844,0.11556,-0.12132,-0.17959},
      {0.00031306,0.026275,-0.23708,0.025827,0.39536,0.22612,-0.02019,0.13776,-0.12534,-0.19582},
      {0.00022355,0.015635,-0.24831,0.011614,0.41453,0.23762,-0.01254,0.15891,-0.12707,-0.21372},
      {0.00013715,0.005897,-0.25964,0.0030726,0.42488,0.2442,-0.0054751,0.17447,-0.13242,-0.22308},
      {0.00010961,0.0028366,-0.27649,0.0027006,0.41262,0.2374,-0.0030797,0.18691,-0.14215,-0.21111},
      {0.00011656,0.0015786,-0.2896,0.0026922,0.40221,0.23156,-0.001928,0.19672,-0.14908,-0.20099},
      {0.00014676,0.00066489,-0.29884,0.0020109,0.39643,0.22842,-0.0009866,0.2046,-0.15336,-0.1953},
      {0.00018606,0.00025452,-0.30848,0.00046755,0.39104,0.22552,-0.00038331,0.21365,-0.15697,-0.18996},
      {0.0003113,8.34E-05,-0.31858,-0.0018313,0.38545,0.22241,-2.92E-05,0.22369,-0.16009,-0.18451},
      {0.035149,-0.028516,0.58661,-0.0027802,-0.0034675,0.0007053,0.011242,0.41253,-0.24135,0.17946},
      {0.037736,-0.03203,0.57822,-0.0028723,-0.0038697,0.00083427,0.010054,0.40641,-0.2334,0.17897},
      {0.041443,-0.037287,0.56586,-0.0030075,-0.0044791,0.0010173,0.0081292,0.39741,-0.2217,0.17821},
      {0.046025,-0.044233,0.54991,-0.0031812,-0.0052996,0.0012396,0.0052942,0.38579,-0.20665,0.17718},
      {0.055782,-0.055627,0.51357,-0.0038562,-0.0076268,0.0023084,-0.0036871,0.35931,-0.17286,0.17455},
      {0.072358,-0.072977,0.44907,-0.0051165,-0.012057,0.0045733,-0.021474,0.31238,-0.11317,0.1697},
      {0.09012,-0.093204,0.3756,-0.0063343,-0.0172,0.0071164,-0.043165,0.25905,-0.0452,0.16397},
      {0.10809,-0.11607,0.29487,-0.0073826,-0.022961,0.0098547,-0.068998,0.20063,0.029486,0.15743},
      {0.11994,-0.13047,0.22326,-0.0085984,-0.028318,0.012681,-0.096371,0.14812,0.093581,0.15084},
      {0.12119,-0.1242,0.17334,-0.0098413,-0.032694,0.015915,-0.12241,0.10993,0.13344,0.14457},
      {0.12195,-0.11708,0.11676,-0.0097201,-0.037972,0.019769,-0.15281,0.067438,0.1794,0.13722},
      {0.11786,-0.09886,0.06083,-0.0073361,-0.041588,0.023914,-0.18758,0.024698,0.22135,0.12941},
      {0.089979,-0.014533,0.043045,0.0016256,-0.029681,0.02297,-0.22177,0.0047645,0.20784,0.12474},
      {0.063888,0.080211,0.019108,0.013191,-0.01687,0.019391,-0.25498,-0.015542,0.19718,0.12146},
      {0.041549,0.17655,-0.011269,0.02979,-0.0017535,0.017645,-0.28565,-0.036043,0.18964,0.11934},
      {0.024756,0.24772,-0.029017,0.058922,0.025728,0.02436,-0.28718,-0.041918,0.15657,0.109},
      {0.012171,0.31098,-0.048303,0.084943,0.049339,0.030763,-0.28726,-0.044749,0.12794,0.10373},
      {0.0038204,0.36128,-0.069027,0.1062,0.069775,0.037808,-0.28471,-0.04329,0.10375,0.1014},
      {0.0024168,0.33134,-0.091938,0.11024,0.10761,0.058791,-0.25144,-0.024897,0.069136,0.069923},
      {0.0015509,0.29316,-0.12355,0.107,0.1406,0.076578,-0.21593,0.002482,0.031292,0.04145},
      {0.00098913,0.23787,-0.1716,0.10347,0.16416,0.089438,-0.1712,0.038527,-0.02296,0.021151},
      {0.00075919,0.17704,-0.20834,0.086767,0.20695,0.1138,-0.12709,0.075424,-0.064909,-0.019241},
      {0.0006231,0.12174,-0.2456,0.065876,0.24755,0.13735,-0.087918,0.11684,-0.10068,-0.057648},
      {0.00052332,0.071953,-0.28939,0.044462,0.27901,0.15653,-0.052845,0.16464,-0.13552,-0.086617},
      {0.00044519,0.036912,-0.32816,0.024383,0.30103,0.17057,-0.02822,0.20904,-0.16033,-0.10638},
      {0.00033726,0.025332,-0.33952,0.012043,0.31695,0.18019,-0.019838,0.2273,-0.16474,-0.1212},
      {0.00022824,0.014541,-0.34939,0.0076055,0.32348,0.18455,-0.011937,0.2372,-0.17322,-0.12693},
      {0.00014427,0.0057407,-0.36282,0.0036246,0.32461,0.18602,-0.0054571,0.24967,-0.18242,-0.12733},
      {0.00011754,0.0016185,-0.37734,0.0018634,0.31766,0.18256,-0.0022699,0.26153,-0.19076,-0.12021},
      {0.00012671,0.0011863,-0.38577,0.0011076,0.3122,0.17965,-0.0015872,0.26866,-0.19459,-0.11477},
      {0.00015803,0.00074857,-0.39387,-0.00066345,0.30818,0.17755,-0.00093811,0.27643,-0.19759,-0.11074},
      {0.00020208,0.00027947,-0.39854,-0.001377,0.30575,0.17628,-0.00033035,0.28063,-0.19967,-0.1083},
      {0.0025685,-0.0089278,0.66594,-0.0015192,-0.0014634,1.60E-05,-0.00053952,0.46972,-0.31623,0.18235},
      {0.0046726,-0.011715,0.65905,-0.0016152,-0.0018478,8.60E-05,-0.0015803,0.46472,-0.30984,0.18183},
      {0.0077752,-0.015864,0.64881,-0.0017564,-0.0024392,0.00018841,-0.0031943,0.45729,-0.30036,0.18103},
      {0.011793,-0.021309,0.63545,-0.0019377,-0.0032538,0.00031886,-0.0054436,0.44758,-0.28801,0.17992},
      {0.016544,-0.027851,0.6195,-0.0021476,-0.0042996,0.00046825,-0.0083776,0.436,-0.27334,0.17847},
      {0.021774,-0.035171,0.60182,-0.0023686,-0.005577,0.00062269,-0.012035,0.42316,-0.25718,0.17669},
      {0.03401,-0.049749,0.55125,-0.0028709,-0.0096614,0.0023382,-0.026327,0.38662,-0.21077,0.17188},
      {0.051119,-0.07069,0.47289,-0.0034049,-0.016405,0.0054798,-0.050475,0.33015,-0.13889,0.16414},
      {0.067568,-0.093155,0.38945,-0.0036269,-0.024193,0.0090285,-0.078096,0.27017,-0.06264,0.15514},
      {0.081146,-0.11437,0.30677,-0.0035517,-0.032522,0.011151,-0.10484,0.21083,0.01172,0.14412},
      {0.082053,-0.10369,0.24826,-0.0026064,-0.037509,0.011525,-0.13114,0.16752,0.057975,0.13454},
      {0.080903,-0.084592,0.18443,-0.00043751,-0.04241,0.010565,-0.16203,0.12092,0.10711,0.12367},
      {0.0787,-0.059274,0.11225,0.0031246,-0.047554,0.0080714,-0.19803,0.069123,0.16221,0.11109},
      {0.060937,0.023804,0.072568,0.014354,-0.037749,0.0048396,-0.23222,0.039597,0.17059,0.10838},
      {0.0418,0.12595,0.035218,0.029676,-0.023913,0.0023174,-0.26703,0.014662,0.17217,0.11122},
      {0.02574,0.23371,-0.011181,0.047513,-0.010137,0.00078769,-0.30419,-0.012786,0.18165,0.1175},
      {0.014702,0.30577,-0.037827,0.070551,0.011036,0.0058744,-0.31159,-0.021082,0.1636,0.11727},
      {0.0073357,0.36022,-0.058708,0.090775,0.030528,0.01253,-0.31034,-0.020342,0.14129,0.11819},
      {0.0032839,0.38829,-0.085332,0.1024,0.043387,0.012416,-0.29985,-0.014569,0.1152,0.11807},
      {0.0019884,0.35145,-0.12386,0.10462,0.069713,0.025024,-0.26114,0.0089828,0.067207,0.097893},
      {0.0014564,0.2921,-0.17463,0.099501,0.096565,0.039978,-0.21346,0.047996,0.010302,0.074773},
      {0.00096987,0.2319,-0.23727,0.090203,0.11681,0.054394,-0.16694,0.098925,-0.049214,0.060136},
      {0.00066374,0.17447,-0.29431,0.07111,0.14443,0.073394,-0.12496,0.15321,-0.097587,0.037426},
      {0.00055868,0.12428,-0.33937,0.045175,0.17909,0.094474,-0.089619,0.20473,-0.13127,0.0054549},
      {0.00047967,0.075944,-0.3889,0.025845,0.20117,0.10904,-0.055718,0.25472,-0.16941,-0.013982},
      {0.00041057,0.032588,-0.43855,0.016471,0.20719,0.11541,-0.025333,0.29645,-0.21097,-0.017279},
      {0.00028793,0.021399,-0.4447,0.011115,0.21856,0.12255,-0.017109,0.30415,-0.21751,-0.027661},
      {0.00019016,0.0122,-0.45456,0.0063459,0.22427,0.12665,-0.010299,0.31441,-0.22493,-0.032445},
      {0.00011077,0.0056112,-0.46633,0.0026334,0.22527,0.12838,-0.0052551,0.32565,-0.23231,-0.032454},
      {8.10E-05,0.0016966,-0.48137,0.00020324,0.21896,0.1257,-0.0021323,0.33848,-0.24046,-0.025605},
      {0.00010563,0.0011468,-0.48159,-0.00089913,0.22146,0.12728,-0.0013811,0.33968,-0.24032,-0.027877},
      {0.00014431,0.00061279,-0.47781,-0.00089805,0.22628,0.13012,-0.00071853,0.33706,-0.23882,-0.03244},
      {-0.0021492,0.0022504,0.69772,-0.0016673,-1.91E-05,-0.00016443,0.00064897,0.49234,-0.34642,0.18442},
      {-0.0019859,0.0022322,0.69763,-0.00175,-2.00E-05,-0.00017574,0.0005863,0.49222,-0.34643,0.18441},
      {-0.00033506,-0.00024634,0.69157,-0.0018372,-0.00049161,-0.00015019,-0.00066325,0.48781,-0.34096,0.18372},
      {0.0022758,-0.0043298,0.68159,-0.0019334,-0.0012924,-0.00013329,-0.0027291,0.48058,-0.33191,0.18253},
      {0.0053739,-0.0092661,0.66946,-0.0020353,-0.0023025,-0.00017418,-0.0052899,0.4718,-0.32097,0.18098},
      {0.0087868,-0.014835,0.65568,-0.0021252,-0.0035075,-0.00032272,-0.0082779,0.46183,-0.30861,0.17905},
      {0.012302,-0.020743,0.64087,-0.0021795,-0.0048812,-0.00064242,-0.011592,0.45115,-0.29543,0.17672},
      {0.015685,-0.026636,0.6258,-0.0021682,-0.0063854,-0.0012099,-0.015101,0.44033,-0.28217,0.17398},
      {0.02694,-0.044347,0.55407,-0.0020022,-0.013702,-0.00013449,-0.037744,0.38886,-0.21815,0.16362},
      {0.036729,-0.060717,0.48294,-0.0015698,-0.021395,-0.00010374,-0.060991,0.33788,-0.1556,0.15181},
      {0.044442,-0.074583,0.41504,-0.00081682,-0.029189,-0.0015194,-0.08411,0.28929,-0.09708,0.1386},
      {0.046936,-0.066731,0.34677,0.001505,-0.035179,-0.0040982,-0.11312,0.24032,-0.042151,0.12589},
      {0.045826,-0.037627,0.26861,0.005965,-0.039857,-0.0076227,-0.15141,0.1846,0.017885,0.11329},
      {0.043826,-0.0020132,0.18218,0.011863,-0.0447,-0.012693,-0.19473,0.1236,0.083748,0.099202},
      {0.035547,0.068817,0.11152,0.023511,-0.040658,-0.016854,-0.2365,0.075672,0.12561,0.094189},
      {0.022632,0.1787,0.06062,0.041989,-0.026217,-0.017618,-0.27366,0.045969,0.1396,0.10351},
      {0.01421,0.27589,-0.002128,0.056598,-0.01338,-0.034077,-0.3024,0.01199,0.15909,0.10157},
      {0.0091594,0.33699,-0.048564,0.069958,0.0007349,-0.04156,-0.30975,-0.0036999,0.156,0.1},
      {0.0058487,0.35767,-0.078516,0.081789,0.015031,-0.038999,-0.29519,0.0036206,0.12554,0.10025},
      {0.0032927,0.37133,-0.11479,0.090694,0.025797,-0.02782,-0.2825,0.018309,0.09504,0.10988},
      {0.0018561,0.35386,-0.1625,0.090298,0.040514,-0.010257,-0.25789,0.049669,0.054681,0.11251},
      {0.0013764,0.294,-0.22758,0.07712,0.062085,0.0053802,-0.21174,0.10497,-0.0039185,0.097118},
      {0.00091557,0.23346,-0.30505,0.05906,0.077274,0.02081,-0.16679,0.17307,-0.065001,0.089939},
      {0.00050175,0.16613,-0.38475,0.045617,0.089349,0.036047,-0.11876,0.23907,-0.13195,0.085967},
      {0.00040781,0.11189,-0.42881,0.03377,0.11296,0.051273,-0.080683,0.27836,-0.17511,0.064772},
      {0.00033671,0.067422,-0.4764,0.022899,0.12367,0.060433,-0.049504,0.3196,-0.2155,0.057059},
      {0.00027382,0.032304,-0.5249,0.013493,0.12401,0.064956,-0.024878,0.36055,-0.25237,0.060365},
      {0.00016893,0.017793,-0.53831,0.007223,0.13441,0.073307,-0.014313,0.37433,-0.26348,0.052369},
      {8.61E-05,0.010904,-0.54565,0.0025668,0.14097,0.078291,-0.0090234,0.38292,-0.26847,0.047083},
      {4.46E-05,0.0055078,-0.55713,-0.00022585,0.13993,0.078855,-0.0048517,0.39324,-0.27559,0.049059},
      {3.42E-05,0.0013949,-0.56458,-0.0004552,0.13833,0.078914,-0.0016664,0.3987,-0.28143,0.051408},
      {7.21E-05,0.00084733,-0.55513,-0.00051217,0.14875,0.084965,-0.00099089,0.39203,-0.27714,0.041453},
      {-0.0025033,0.0019743,0.69785,-0.0024635,1.35E-05,-0.00014048,0.0008751,0.49179,-0.34712,0.18444},
      {-0.0023493,0.0019449,0.69781,-0.0025051,1.35E-05,-0.00015275,0.00081837,0.49174,-0.34714,0.18442},
      {-0.0021123,0.001898,0.69777,-0.0025637,1.34E-05,-0.00017177,0.00073143,0.49166,-0.34719,0.1844},
      {-0.0017855,0.0018296,0.69772,-0.0026337,1.36E-05,-0.00019824,0.0006122,0.49159,-0.34726,0.18437},
      {-0.001233,0.0014487,0.69694,-0.0026975,-6.31E-05,-0.00026146,0.00029477,0.49098,-0.34669,0.18418},
      {0.0010009,-0.0024862,0.68672,-0.0026441,-0.0011272,-0.00076596,-0.0021343,0.48367,-0.33775,0.18215},
      {0.0033178,-0.0065968,0.67577,-0.0025281,-0.0023226,-0.0014987,-0.0047996,0.47588,-0.32824,0.17973},
      {0.0055691,-0.010593,0.66466,-0.0023203,-0.0036069,-0.0025308,-0.0075774,0.46803,-0.31873,0.17692},
      {0.0076065,-0.014145,0.65407,-0.0019859,-0.0049262,-0.0039444,-0.010319,0.46064,-0.3098,0.17372},
      {0.011852,-0.021534,0.61699,-0.0013181,-0.0093051,-0.0059044,-0.02273,0.43424,-0.2783,0.16532},
      {0.016926,-0.030327,0.55962,-0.00025062,-0.016082,-0.0092858,-0.042971,0.39324,-0.23025,0.15198},
      {0.020175,-0.035317,0.5069,0.0011287,-0.022401,-0.014618,-0.062302,0.35563,-0.18746,0.13766},
      {0.021138,-0.028392,0.45167,0.0037075,-0.027748,-0.021564,-0.085394,0.31639,-0.14465,0.12297},
      {0.020997,0.0074094,0.35079,0.0099557,-0.032849,-0.035696,-0.12973,0.24541,-0.069044,0.10136},
      {0.021538,0.044926,0.23439,0.016149,-0.038323,-0.06818,-0.17183,0.16406,0.013325,0.064478},
      {0.020318,0.095423,0.1243,0.023554,-0.0397,-0.10849,-0.20904,0.089299,0.084004,0.026498},
      {0.014359,0.18702,0.060332,0.03695,-0.026457,-0.12141,-0.23608,0.056778,0.10457,0.028318},
      {0.0099504,0.27404,-0.0027188,0.048191,-0.014419,-0.12358,-0.26457,0.030346,0.12625,0.039411},
      {0.0069865,0.34651,-0.060747,0.056792,-0.0036106,-0.11427,-0.28836,0.015499,0.1413,0.057762},
      {0.0047632,0.35876,-0.099387,0.063338,0.0072248,-0.099632,-0.27675,0.033639,0.11169,0.070283},
      {0.0030423,0.36546,-0.14524,0.065193,0.01472,-0.076218,-0.26748,0.060881,0.082677,0.091082},
      {0.0017665,0.36245,-0.20012,0.060743,0.019871,-0.045048,-0.2579,0.09979,0.052137,0.11689},
      {0.0012397,0.28127,-0.27742,0.053124,0.035939,-0.034216,-0.20017,0.15932,-0.023836,0.10347},
      {0.00076606,0.20635,-0.36249,0.045104,0.045342,-0.018705,-0.14702,0.22466,-0.10018,0.10338},
      {0.00033652,0.13769,-0.45461,0.036707,0.048575,0.001507,-0.098433,0.2953,-0.17659,0.11593},
      {0.00021248,0.091093,-0.50676,0.024806,0.061801,0.016298,-0.065677,0.34036,-0.21994,0.10931},
      {0.00014732,0.056346,-0.54907,0.01406,0.069847,0.025822,-0.041232,0.37781,-0.25295,0.10569},
      {8.17E-05,0.029667,-0.59051,0.0055692,0.069437,0.031275,-0.022395,0.41315,-0.28259,0.11083},
      {2.35E-05,0.014456,-0.61404,0.00062753,0.070714,0.036189,-0.011454,0.43335,-0.2995,0.11308},
      {5.15E-06,0.0087449,-0.6103,0.00023471,0.081842,0.04342,-0.0070989,0.43091,-0.30058,0.1031},
      {-2.14E-06,0.0044867,-0.61286,-3.91E-05,0.085197,0.046285,-0.0038226,0.43291,-0.30405,0.10066},
      {-6.00E-07,0.0015126,-0.62097,-0.00020719,0.081746,0.045386,-0.0015026,0.43879,-0.30962,0.10487},
      {-0.0029737,0.0018869,0.69676,-0.0040969,4.24E-05,-6.05E-05,0.0010564,0.48982,-0.34748,0.18449},
      {-0.0028228,0.0018434,0.69679,-0.0041028,4.31E-05,-7.19E-05,0.0010016,0.48983,-0.34753,0.18448},
      {-0.0025897,0.0017743,0.69684,-0.0041078,4.42E-05,-8.93E-05,0.00091705,0.48987,-0.34761,0.18445},
      {-0.0022665,0.001675,0.69692,-0.0041064,4.58E-05,-0.00011315,0.00079995,0.48993,-0.34773,0.18442},
      {-0.0018474,0.00154,0.69705,-0.0040903,4.83E-05,-0.00014337,0.00064822,0.49003,-0.34789,0.18438},
      {-0.0013279,0.0013627,0.69726,-0.0040486,5.18E-05,-0.0001796,0.00046021,0.49021,-0.34811,0.18432},
      {-0.00052684,0.0006425,0.69573,-0.0039096,-0.00017614,-0.00051159,-0.0001739,0.4892,-0.34686,0.18367},
      {0.00086593,-0.0015291,0.68828,-0.0034828,-0.0011894,-0.0020294,-0.0021594,0.48413,-0.34072,0.18083},
      {0.0021435,-0.0031851,0.68139,-0.0029032,-0.0021954,-0.003977,-0.0040307,0.47957,-0.33518,0.17764},
      {0.0033126,-0.0044568,0.67412,-0.0020567,-0.0032656,-0.0071669,-0.0057739,0.47493,-0.32962,0.17328},
      {0.0047731,-0.0066582,0.65593,-0.0010394,-0.0053659,-0.014021,-0.010434,0.46249,-0.31602,0.16428},
      {0.0074307,-0.01047,0.59836,0.00039383,-0.011661,-0.029429,-0.027556,0.42145,-0.27266,0.14169},
      {0.0094939,-0.012203,0.5372,0.0019003,-0.017895,-0.052592,-0.043538,0.37788,-0.2291,0.11278},
      {0.010886,-0.01138,0.47266,0.0034505,-0.023755,-0.085021,-0.057853,0.33193,-0.1859,0.076772},
      {0.011415,0.025363,0.36135,0.0089556,-0.027512,-0.12556,-0.094736,0.25471,-0.10956,0.03615},
      {0.011405,0.06975,0.24352,0.014523,-0.029683,-0.1777,-0.13125,0.17404,-0.031745,-0.011495},
      {0.010932,0.11868,0.12413,0.019516,-0.030041,-0.24264,-0.16442,0.093534,0.0436,-0.066649},
      {0.008224,0.19785,0.054592,0.028244,-0.019441,-0.24685,-0.19445,0.063953,0.07332,-0.058154},
      {0.0062593,0.27739,-0.0069123,0.034575,-0.0091729,-0.22955,-0.22636,0.048601,0.097817,-0.031146},
      {0.0053073,0.3526,-0.067751,0.036944,-0.0013142,-0.19862,-0.26081,0.041477,0.1239,0.0052915},
      {0.0039125,0.34645,-0.11463,0.041195,0.0043646,-0.17722,-0.25063,0.061192,0.09692,0.022151},
      {0.0026079,0.32364,-0.16897,0.045198,0.0083196,-0.14869,-0.23195,0.092884,0.055753,0.044088},
      {0.0015768,0.3011,-0.23536,0.046951,0.010838,-0.10726,-0.21406,0.13542,0.010112,0.078165},
      {0.0010174,0.2397,-0.32042,0.03968,0.018214,-0.081022,-0.17018,0.19967,-0.059769,0.090417},
      {0.0005907,0.1714,-0.41325,0.029613,0.023913,-0.057147,-0.12186,0.27194,-0.13554,0.10244},
      {0.0002146,0.11179,-0.50798,0.019371,0.025799,-0.02762,-0.079765,0.3457,-0.20768,0.12453},
      {2.37E-05,0.069793,-0.57484,0.0086353,0.029559,-0.0063326,-0.050163,0.40035,-0.25665,0.1369},
      {-2.01E-05,0.043624,-0.60926,0.0019844,0.03367,0.0018312,-0.031714,0.42939,-0.28347,0.13779},
      {-3.66E-05,0.023965,-0.63284,0.001159,0.036131,0.0091594,-0.017842,0.44657,-0.30461,0.14034},
      {-4.43E-05,0.010524,-0.65241,0.00053161,0.036035,0.014719,-0.0082752,0.46077,-0.3208,0.14509},
      {-4.69E-05,0.0063091,-0.65116,0.00023035,0.043076,0.019641,-0.0050459,0.46007,-0.32232,0.13906},
      {-4.16E-05,0.0032926,-0.65525,2.93E-05,0.043607,0.020983,-0.0027094,0.46311,-0.3259,0.13941},
      {-0.0039515,0.0019887,0.69464,-0.0058796,7.11E-05,-9.63E-05,0.0015455,0.48704,-0.34709,0.18445},
      {-0.0038084,0.0019228,0.69472,-0.0058011,7.33E-05,-0.00016833,0.0015025,0.48715,-0.34713,0.18438},
      {-0.003587,0.0018219,0.69484,-0.0056751,7.70E-05,-0.00030162,0.0014346,0.48733,-0.3472,0.18426},
      {-0.0032796,0.0016838,0.69498,-0.0054913,8.25E-05,-0.00053046,0.0013374,0.48756,-0.34728,0.18405},
      {-0.0028792,0.0015077,0.69511,-0.0052375,9.04E-05,-0.00090319,0.0012057,0.48784,-0.34736,0.18371},
      {-0.0023795,0.0012947,0.69522,-0.0049002,0.0001014,-0.0014833,0.0010329,0.48815,-0.34741,0.1832},
      {-0.0017732,0.0010468,0.69525,-0.0044644,0.00011645,-0.0023498,0.00081039,0.48848,-0.34743,0.18243},
      {-0.0010508,0.00076755,0.69515,-0.0039147,0.00013655,-0.0035963,0.00052686,0.48881,-0.34737,0.18135},
      {-0.00015794,-0.00020419,0.68942,-0.0032068,-0.00051207,-0.0074824,-0.00060434,0.48521,-0.34335,0.17704},
      {0.00076944,-0.0014644,0.67972,-0.0024332,-0.0015431,-0.013916,-0.0021665,0.47883,-0.33679,0.17002},
      {0.0016565,-0.0025779,0.66864,-0.0016419,-0.0025724,-0.022258,-0.0036949,0.4715,-0.32966,0.16139},
      {0.0024751,-0.0034586,0.65609,-0.00084992,-0.003544,-0.032873,-0.0051277,0.46314,-0.32201,0.15092},
      {0.0037284,-0.0025884,0.60125,0.00050177,-0.0081942,-0.062385,-0.016665,0.42417,-0.28575,0.11916},
      {0.0046331,0.00080134,0.53622,0.001957,-0.012806,-0.10353,-0.028447,0.37791,-0.24473,0.077787},
      {0.0050589,0.0070259,0.46759,0.0033902,-0.016366,-0.15555,-0.038273,0.32916,-0.20395,0.028952},
      {0.0051232,0.040057,0.36725,0.0070118,-0.017296,-0.21651,-0.062505,0.26054,-0.14149,-0.023688},
      {0.0049599,0.090095,0.24927,0.01124,-0.015735,-0.2877,-0.093172,0.18196,-0.068301,-0.080985},
      {0.0046181,0.14397,0.13045,0.014453,-0.012,-0.37149,-0.12034,0.10435,0.0024417,-0.14512},
      {0.004312,0.19119,0.04503,0.018846,-0.0090601,-0.38697,-0.14965,0.062412,0.048055,-0.15483},
      {0.0039262,0.23838,-0.010599,0.023329,-0.0051705,-0.35396,-0.17863,0.051302,0.071329,-0.12329},
      {0.0036808,0.27939,-0.059222,0.026378,-0.0018225,-0.31987,-0.20375,0.046353,0.089178,-0.09104},
      {0.0029912,0.2809,-0.11422,0.028599,0.0013379,-0.28403,-0.20212,0.068773,0.069098,-0.060479},
      {0.0020442,0.25573,-0.18783,0.02904,0.0038441,-0.23755,-0.18258,0.11755,0.019263,-0.022378},
      {0.0012823,0.23251,-0.2737,0.026451,0.0052715,-0.17717,-0.16492,0.1777,-0.03395,0.028313},
      {0.00076303,0.19179,-0.36842,0.018512,0.007799,-0.12563,-0.13568,0.24903,-0.09765,0.068743},
      {0.00040281,0.1348,-0.46281,0.0074242,0.010134,-0.093719,-0.095431,0.32316,-0.16785,0.092174},
      {9.11E-05,0.08569,-0.54843,0.0031622,0.011232,-0.056364,-0.06092,0.38624,-0.23302,0.1217},
      {-9.68E-05,0.049371,-0.61545,0.0023751,0.012984,-0.019985,-0.03543,0.43379,-0.28419,0.14941},
      {-0.00010475,0.030577,-0.63688,0.0015325,0.016756,-0.011863,-0.022186,0.44946,-0.3038,0.15073},
      {-0.00010474,0.01686,-0.65674,0.00086424,0.017101,-0.0055393,-0.012464,0.46389,-0.3202,0.15548},
      {-9.76E-05,0.007643,-0.67487,0.00037455,0.014683,-0.00067472,-0.0058702,0.47696,-0.3336,0.16299},
      {-8.60E-05,0.0040577,-0.67926,0.00012836,0.016395,0.0023785,-0.0031709,0.48021,-0.33756,0.16306},
      {-0.0055727,0.0019314,0.69413,-0.0045715,0.00011101,-0.00047764,0.0026994,0.48761,-0.34547,0.18408},
      {-0.0055235,0.0018533,0.69394,-0.0048314,0.00011598,-0.00051788,0.0027264,0.48729,-0.34556,0.18404},
      {-0.0054545,0.0017334,0.69364,-0.0052314,0.00012388,-0.00058248,0.0027725,0.48679,-0.34568,0.18398},
      {-0.0053733,0.0015685,0.69319,-0.0057823,0.00013525,-0.00067691,0.0028457,0.48609,-0.34585,0.18388},
      {-0.0050192,0.0014002,0.69295,-0.0057187,0.00014973,-0.0013433,0.0027269,0.48597,-0.34585,0.1833},
      {-0.0044578,0.0012141,0.69274,-0.0053011,0.00016843,-0.002486,0.0024731,0.48612,-0.34576,0.1823},
      {-0.003765,0.00099762,0.69241,-0.0047821,0.00019256,-0.0040022,0.0021474,0.48626,-0.34562,0.18099},
      {-0.0029256,0.00075377,0.69192,-0.0041523,0.00022317,-0.0059748,0.0017355,0.48636,-0.34541,0.17929},
      {-0.0019207,0.00048665,0.69122,-0.003403,0.00026143,-0.0084981,0.0012199,0.4864,-0.34512,0.17711},
      {-0.00084984,0.00010909,0.6881,-0.002587,0.0001211,-0.01297,0.00046302,0.48476,-0.34339,0.17302},
      {-0.00015577,-0.00049271,0.67618,-0.001926,-0.00064904,-0.023703,-0.00073268,0.47677,-0.33636,0.16276},
      {0.00050474,-0.00084763,0.66273,-0.0012576,-0.0012993,-0.036831,-0.0018272,0.46771,-0.32876,0.15065},
      {0.0011173,-0.00087315,0.64766,-0.00059451,-0.0017575,-0.052712,-0.0027614,0.45751,-0.32059,0.13649},
      {0.0015974,0.0030377,0.60248,0.00044998,-0.0035425,-0.090699,-0.0081686,0.42563,-0.29452,0.10196},
      {0.0017754,0.011793,0.53307,0.0017404,-0.0053634,-0.15205,-0.015492,0.37641,-0.25547,0.047949},
      {0.0018749,0.019959,0.44757,0.002904,-0.0071155,-0.23354,-0.022152,0.3159,-0.20895,-0.022551},
      {0.0020659,0.038932,0.33883,0.004858,-0.0085607,-0.3233,-0.037278,0.24086,-0.14677,-0.099267},
      {0.0023251,0.074285,0.21877,0.0078522,-0.008855,-0.40354,-0.063276,0.16049,-0.073978,-0.16618},
      {0.0024592,0.10424,0.11082,0.01016,-0.0089245,-0.48052,-0.084795,0.088266,-0.0096317,-0.22988},
      {0.0025139,0.13333,0.030383,0.012308,-0.0078785,-0.51502,-0.10392,0.045909,0.031769,-0.25707},
      {0.0024438,0.16914,-0.017338,0.014466,-0.0047523,-0.47794,-0.12573,0.046844,0.044202,-0.2225},
      {0.0023907,0.1972,-0.061748,0.01476,-0.002204,-0.44275,-0.14267,0.053858,0.05087,-0.18979},
      {0.0021321,0.20611,-0.11493,0.013203,-0.00022052,-0.40196,-0.14686,0.079078,0.037363,-0.1537},
      {0.0014496,0.18604,-0.20426,0.0094615,0.0012334,-0.33499,-0.13151,0.14257,-0.015275,-0.097412},
      {0.00090677,0.16728,-0.30466,0.0037677,0.0017434,-0.25365,-0.11776,0.2159,-0.071596,-0.028952},
      {0.00046523,0.14174,-0.40211,0.0037874,0.0026059,-0.17214,-0.099958,0.28368,-0.13258,0.037924},
      {0.0001761,0.095782,-0.48184,0.0029724,0.0045957,-0.13214,-0.06775,0.34009,-0.1949,0.068307},
      {-3.23E-05,0.059217,-0.55968,0.0022403,0.0053537,-0.08545,-0.042095,0.39515,-0.2516,0.10601},
      {-0.00016739,0.031412,-0.6351,0.0015971,0.0051334,-0.032928,-0.022558,0.4485,-0.30275,0.14995},
      {-0.0001675,0.018076,-0.65737,0.0009341,0.0061517,-0.022247,-0.01312,0.46459,-0.32015,0.15735},
      {-0.00014792,0.0097953,-0.67204,0.00043252,0.0057045,-0.016859,-0.0072105,0.4752,-0.33133,0.16246},
      {-0.00012288,0.0048703,-0.68439,0.00010518,0.0042853,-0.011776,-0.0036476,0.48405,-0.33977,0.16872},
      {-0.0067957,0.0019536,0.6944,-0.0029579,0.00014375,-0.00062347,0.0035079,0.48894,-0.34421,0.18391},
      {-0.0068222,0.0018829,0.69413,-0.0031943,0.00015095,-0.00068459,0.0035825,0.48858,-0.3442,0.18385},
      {-0.0068715,0.0017739,0.69369,-0.0035581,0.0001623,-0.00078121,0.0037032,0.48802,-0.34419,0.18376},
      {-0.006957,0.0016237,0.69307,-0.0040593,0.00017851,-0.00091959,0.003882,0.48723,-0.34414,0.18362},
      {-0.0070982,0.0014305,0.69224,-0.0047037,0.00020033,-0.0011066,0.0041341,0.48618,-0.34405,0.18343},
      {-0.0073217,0.0011935,0.69114,-0.0054924,0.00022864,-0.0013502,0.0044786,0.48486,-0.34388,0.18319},
      {-0.0069211,0.00097185,0.69022,-0.005493,0.00026272,-0.0028092,0.004358,0.4842,-0.34363,0.18192},
      {-0.005912,0.00076205,0.68937,-0.004821,0.00030366,-0.0054781,0.0037868,0.48409,-0.34333,0.17962},
      {-0.0047007,0.00053252,0.68828,-0.004038,0.00035359,-0.0087654,0.0030836,0.48387,-0.34295,0.1768},
      {-0.0032604,0.00028776,0.6869,-0.0031416,0.00041377,-0.012764,0.0022258,0.48354,-0.34249,0.17337},
      {-0.0015596,3.29E-05,0.68519,-0.0021314,0.00048562,-0.017572,0.0011869,0.48305,-0.34195,0.16926},
      {-0.00080678,8.49E-05,0.66931,-0.0014934,0.00022045,-0.035395,0.00031119,0.47234,-0.33373,0.15382},
      {-0.0002416,0.00018716,0.6448,-0.00094951,-8.48E-05,-0.062621,-0.00053306,0.45549,-0.32115,0.1305},
      {0.00030551,0.00028632,0.61307,-0.00044527,-0.00035222,-0.098286,-0.0013663,0.43351,-0.30502,0.10019},
      {0.0007115,0.0024282,0.55847,0.00020549,-0.001175,-0.1551,-0.0040082,0.39516,-0.27635,0.051529},
      {0.00085241,0.0085343,0.46645,0.0011848,-0.0031396,-0.24502,-0.010036,0.3301,-0.22686,-0.026117},
      {0.00096169,0.013912,0.36924,0.0020094,-0.0048653,-0.34328,-0.015128,0.26151,-0.17544,-0.11023},
      {0.0010378,0.021946,0.26607,0.0028704,-0.0060801,-0.44598,-0.021585,0.18952,-0.12071,-0.19709},
      {0.001227,0.046769,0.17064,0.0045806,-0.0060804,-0.51465,-0.039097,0.12732,-0.065699,-0.25369},
      {0.0013189,0.06588,0.086396,0.0054373,-0.0058065,-0.58071,-0.051984,0.073247,-0.019003,-0.30754},
      {0.0013216,0.080813,0.01655,0.0053947,-0.0049791,-0.63516,-0.061161,0.032198,0.01664,-0.35087},
      {0.0013316,0.10745,-0.026218,0.0047516,-0.0024206,-0.59831,-0.077368,0.042288,0.02173,-0.31663},
      {0.0013465,0.12714,-0.066089,0.0019146,-0.00066849,-0.56301,-0.089249,0.058324,0.021856,-0.28439},
      {0.0013526,0.14135,-0.10294,0.0019355,-0.00033428,-0.51591,-0.099171,0.077287,0.015599,-0.24489},
      {0.00086465,0.1253,-0.20044,0.0022733,0.00032848,-0.42419,-0.088081,0.14451,-0.040602,-0.1691},
      {0.00046464,0.10814,-0.30336,0.0024648,0.0007924,-0.32741,-0.076162,0.21593,-0.1001,-0.088859},
      {0.00014744,0.090153,-0.41159,0.0024895,0.0010665,-0.22533,-0.063611,0.2915,-0.1627,-0.004026},
      {-3.85E-05,0.059339,-0.49173,0.0018415,0.0017883,-0.1694,-0.041996,0.34808,-0.21766,0.041441},
      {-0.00014969,0.034561,-0.56493,0.0012067,0.001907,-0.11538,-0.024588,0.3998,-0.26616,0.086132},
      {-0.00019594,0.017582,-0.63277,0.00067271,0.0016897,-0.058908,-0.012637,0.44772,-0.30813,0.13334},
      {-0.00018449,0.0086322,-0.66475,0.00020909,0.0015383,-0.033924,-0.0062863,0.47047,-0.32828,0.1543},
      {-0.00015126,0.0056613,-0.67097,9.09E-05,0.0018893,-0.030189,-0.0041841,0.47479,-0.33274,0.15689},
      {-0.0069391,0.0020599,0.69591,-0.0013966,0.00015531,-0.0004843,0.0034917,0.49111,-0.34411,0.18401},
      {-0.0070416,0.0019922,0.69555,-0.0015947,0.00016455,-0.00058757,0.0036164,0.49072,-0.344,0.18391},
      {-0.0072014,0.0018886,0.69499,-0.0018938,0.00017892,-0.00075828,0.0038093,0.49013,-0.34384,0.18375},
      {-0.0074261,0.0017469,0.6942,-0.0022945,0.00019906,-0.0010174,0.0040772,0.4893,-0.3436,0.18351},
      {-0.0077224,0.0015667,0.69316,-0.0027903,0.00022555,-0.0013921,0.0044249,0.48823,-0.34326,0.18316},
      {-0.0080969,0.0013492,0.69183,-0.0033676,0.00025891,-0.0019167,0.004856,0.48691,-0.3428,0.18268},
      {-0.008556,0.0010974,0.69018,-0.0040069,0.00029969,-0.0026326,0.0053723,0.48534,-0.3422,0.18202},
      {-0.0091056,0.00081572,0.68818,-0.0046843,0.00034842,-0.0035886,0.0059743,0.48351,-0.34142,0.18116},
      {-0.0077774,0.00061566,0.68491,-0.0040421,0.00039996,-0.0093486,0.0051505,0.48173,-0.34017,0.17629},
      {-0.0060769,0.00041517,0.68,-0.0032311,0.00045847,-0.017526,0.0040525,0.47895,-0.33822,0.16941},
      {-0.0042177,0.00020456,0.67358,-0.0023995,0.00052544,-0.027594,0.0028603,0.47514,-0.33561,0.16095},
      {-0.0022289,2.72E-06,0.66541,-0.0015666,0.00060422,-0.03975,0.0015801,0.47012,-0.3322,0.15074},
      {-0.0010011,-2.62E-05,0.64373,-0.00096553,0.00053288,-0.065551,0.00057862,0.45535,-0.32159,0.1289},
      {-0.0004724,8.50E-05,0.60726,-0.00058617,0.00037133,-0.10685,-0.0001233,0.42989,-0.3032,0.093981},
      {2.77E-05,0.00020924,0.56401,-0.00027085,0.00028158,-0.15604,-0.00077587,0.3996,-0.28149,0.052548},
      {0.00045156,0.00073322,0.51012,1.41E-05,0.00015857,-0.21663,-0.0016789,0.36173,-0.25433,0.0015669},
      {0.00050825,0.0052603,0.41194,0.00062678,-0.0011629,-0.31908,-0.005729,0.29256,-0.20309,-0.08527},
      {0.00051381,0.0091847,0.30675,0.0010358,-0.002055,-0.43247,-0.0088992,0.21858,-0.14892,-0.18037},
      {0.0004676,0.012466,0.1943,0.0011991,-0.0023966,-0.55759,-0.011085,0.13961,-0.091723,-0.28419},
      {0.00051964,0.026912,0.11731,0.0013664,-0.0017787,-0.62447,-0.020351,0.090225,-0.050249,-0.33811},
      {0.00053193,0.038091,0.056172,0.00079356,-0.0009385,-0.67959,-0.026939,0.052243,-0.018036,-0.38182},
      {0.00057484,0.047344,0.010392,0.00084279,-0.0013421,-0.71338,-0.033344,0.025019,0.0058091,-0.4097},
      {0.00065424,0.065552,-0.026675,0.00098977,-0.0010969,-0.67431,-0.046085,0.035944,0.007169,-0.37688},
      {0.00067778,0.079576,-0.061778,0.0010925,-0.00076415,-0.62862,-0.055907,0.05402,0.00141,-0.33851},
      {0.00063374,0.087231,-0.095481,0.0011172,-0.00047493,-0.59005,-0.061267,0.072407,-0.0077162,-0.30607},
      {0.00036302,0.076911,-0.18375,0.0012386,-7.97E-05,-0.50361,-0.054095,0.13275,-0.055784,-0.23424},
      {0.00010039,0.061824,-0.29332,0.0012556,0.00021864,-0.39656,-0.043571,0.20927,-0.11756,-0.1453},
      {-7.82E-05,0.047646,-0.40412,0.0010903,0.00038055,-0.28684,-0.033657,0.28702,-0.17952,-0.054081},
      {-0.00017181,0.030467,-0.48868,0.00060059,0.00050559,-0.21079,-0.021589,0.34666,-0.22989,0.0089713},
      {-0.00020137,0.016412,-0.55411,0.00015436,0.00044929,-0.15331,-0.011704,0.39282,-0.26924,0.056784},
      {-0.00019467,0.0097772,-0.61221,0.00013648,0.00058471,-0.094525,-0.0070925,0.43358,-0.30144,0.10539},
      {-0.000175,0.0059219,-0.64945,0.00010615,0.00080948,-0.056212,-0.0044103,0.45972,-0.32188,0.13686},
      {-0.0050205,0.0018311,0.69999,-1.05E-05,0.00013952,6.50E-05,0.0022641,0.49502,-0.34661,0.18449},
      {-0.0051321,0.0017727,0.69959,-0.00014189,0.00014982,-0.00012738,0.0023879,0.49466,-0.34645,0.18432},
      {-0.0053073,0.001684,0.69897,-0.00034038,0.00016579,-0.00043106,0.0025801,0.4941,-0.3462,0.18404},
      {-0.0055556,0.001564,0.69809,-0.00060655,0.00018805,-0.00086492,0.0028482,0.49332,-0.34584,0.18365},
      {-0.0058862,0.0014139,0.69693,-0.00093597,0.00021709,-0.001449,0.0031983,0.49232,-0.34535,0.18312},
      {-0.0063079,0.0012363,0.69547,-0.0013193,0.00025332,-0.0022047,0.0036347,0.49107,-0.34471,0.18245},
      {-0.0068288,0.0010358,0.69368,-0.0017428,0.00029705,-0.0031546,0.0041598,0.48958,-0.34389,0.18159},
      {-0.0074548,0.0008185,0.69154,-0.0021884,0.00034851,-0.0043217,0.0047739,0.48784,-0.34287,0.18055},
      {-0.0081893,0.00059156,0.68904,-0.0026352,0.00040787,-0.0057277,0.005474,0.48588,-0.34164,0.1793},
      {-0.0080338,0.00039371,0.68463,-0.0026668,0.00047724,-0.010665,0.0055136,0.48289,-0.33968,0.1751},
      {-0.0062107,0.00024985,0.67658,-0.0020454,0.00056132,-0.022239,0.0043193,0.47781,-0.33635,0.16537},
      {-0.0042948,0.00011545,0.6669,-0.0014319,0.00065972,-0.035704,0.0030599,0.47161,-0.33228,0.15405},
      {-0.0023243,-3.87E-06,0.65544,-0.00084584,0.00077435,-0.051148,0.001761,0.46417,-0.32739,0.14107},
      {-0.00076514,-4.22E-05,0.63396,-0.0003917,0.0008659,-0.077273,0.00065526,0.44952,-0.31729,0.1191},
      {-0.00034937,0.00010222,0.58618,-0.00021019,0.00091263,-0.13179,0.00012105,0.41592,-0.29341,0.073343},
      {6.66E-06,0.00027404,0.53153,-7.45E-05,0.0010668,-0.19431,-0.00034202,0.37744,-0.26614,0.021008},
      {0.00028097,0.00048015,0.46956,1.53E-05,0.0013529,-0.26535,-0.00071282,0.33376,-0.23526,-0.038312},
      {0.00028378,0.0032898,0.36815,0.00015816,0.0011349,-0.37835,-0.0026335,0.26253,-0.18371,-0.13209},
      {0.00024886,0.0059893,0.2597,0.00025347,0.00061952,-0.49935,-0.0045003,0.18652,-0.12876,-0.23236},
      {0.00020794,0.008157,0.1534,0.0003285,3.32E-05,-0.61865,-0.0060292,0.11191,-0.075026,-0.33122},
      {0.00023426,0.015606,0.08917,0.00039481,-0.00041973,-0.67817,-0.011196,0.0702,-0.041863,-0.38042},
      {0.00026456,0.023712,0.047251,0.00043435,-0.00077655,-0.70907,-0.016814,0.045601,-0.020436,-0.40586},
      {0.00026319,0.029613,0.010904,0.00043703,-0.0010735,-0.73663,-0.020901,0.024703,-0.0027079,-0.4285},
      {0.00025705,0.03808,-0.022704,0.00047778,-0.00096016,-0.72049,-0.026816,0.028749,-0.0013131,-0.4147},
      {0.00022942,0.045058,-0.056526,0.00049985,-0.0006357,-0.68185,-0.031702,0.047678,-0.011143,-0.38214},
      {0.00017069,0.047332,-0.089283,0.00044421,-0.00037225,-0.64813,-0.033287,0.067037,-0.023581,-0.35372},
      {3.69E-05,0.040748,-0.16072,0.00036463,-0.00014283,-0.57688,-0.028669,0.11571,-0.061237,-0.29435},
      {-0.00010764,0.029049,-0.27099,0.00017179,-2.80E-07,-0.46483,-0.020463,0.19319,-0.12172,-0.20121},
      {-0.00017745,0.021718,-0.38061,9.47E-05,7.63E-05,-0.34737,-0.015373,0.27049,-0.17993,-0.10373},
      {-0.00020513,0.015937,-0.46992,0.00010446,0.00018858,-0.25131,-0.011386,0.33337,-0.22729,-0.024139},
      {-0.00019583,0.010209,-0.52636,9.02E-05,0.00032596,-0.19334,-0.0074082,0.37298,-0.25823,0.023784},
      {-0.00018163,0.006348,-0.5785,7.60E-05,0.00041788,-0.13804,-0.004734,0.40966,-0.28614,0.069548},
      {-0.0023723,0.0011702,0.70327,0,0.00017235,9.95E-05,0.00085946,0.49736,-0.34991,0.18447},
      {-0.0024481,0.0011446,0.70321,0,0.00018025,0.00010407,0.00093164,0.49732,-0.34986,0.18446},
      {-0.0025605,0.0011058,0.70311,0,0.0001927,0.00011126,0.0010392,0.49726,-0.34978,0.18445},
      {-0.0027066,0.0010538,0.70299,0,0.00021044,0.00012149,0.0011803,0.49718,-0.34967,0.18444},
      {-0.002896,0.00098713,0.70275,-1.44E-05,0.00023473,8.30E-05,0.0013633,0.49702,-0.34951,0.18437},
      {-0.0033761,0.0008729,0.7012,-0.00024356,0.00027264,-0.00078016,0.0017961,0.49584,-0.3487,0.1836},
      {-0.0039484,0.00074448,0.69934,-0.00049302,0.00031828,-0.0018373,0.0023066,0.49444,-0.34772,0.18266},
      {-0.0046098,0.00060605,0.69716,-0.00075004,0.00037181,-0.0031004,0.0028896,0.49284,-0.34655,0.18153},
      {-0.0053529,0.00046263,0.69467,-0.00099963,0.00043334,-0.004579,0.0035362,0.49105,-0.3452,0.18022},
      {-0.0061652,0.00031986,0.69189,-0.0012252,0.00050285,-0.006279,0.0042335,0.4891,-0.34368,0.17871},
      {-0.0070281,0.00018372,0.68884,-0.0014092,0.00058028,-0.0082015,0.0049639,0.48701,-0.34199,0.177},
      {-0.0053464,0.00010432,0.67831,-0.0010123,0.00069843,-0.022042,0.0038498,0.48009,-0.33751,0.16535},
      {-0.0035685,3.93E-05,0.66602,-0.00062905,0.00083591,-0.037887,0.0026682,0.47195,-0.33222,0.152},
      {-0.0018195,-8.93E-06,0.65212,-0.00029332,0.000994,-0.055386,0.0015086,0.46268,-0.32617,0.13726},
      {-0.00025246,-3.71E-05,0.63357,-5.01E-05,0.0011473,-0.077438,0.000463,0.45036,-0.31795,0.11874},
      {-7.57E-05,0.00012406,0.5722,-1.96E-05,0.001317,-0.14713,0.00014547,0.40738,-0.28755,0.060602},
      {7.70E-05,0.00027269,0.5045,6.78E-06,0.0014846,-0.22436,-0.00014526,0.35981,-0.25391,-0.003773},
      {0.00020122,0.00040614,0.42994,2.87E-05,0.0016457,-0.30976,-0.00040363,0.30726,-0.21677,-0.074899},
      {0.00021187,0.0017971,0.3352,8.16E-05,0.0013207,-0.41687,-0.0014391,0.24063,-0.16905,-0.16376},
      {0.00016705,0.0035524,0.23343,0.00013465,0.00074042,-0.53183,-0.0026767,0.16907,-0.11766,-0.25894},
      {0.00011814,0.0048781,0.13415,0.00016434,0.00018685,-0.64478,-0.0036082,0.099147,-0.067626,-0.35236},
      {9.69E-05,0.0083681,0.066058,0.00017807,-0.0002192,-0.71569,-0.0060332,0.053483,-0.033619,-0.41084},
      {9.56E-05,0.013255,0.0335,0.00017301,-0.00043299,-0.73959,-0.0094232,0.035614,-0.018525,-0.43034},
      {7.75E-05,0.016295,0.0061413,0.00014169,-0.00055725,-0.7597,-0.011525,0.021441,-0.0069518,-0.44667},
      {4.60E-05,0.018933,-0.020685,0.00010526,-0.00047984,-0.75652,-0.013349,0.021829,-0.0058507,-0.44363},
      {-7.48E-06,0.02083,-0.053152,4.25E-05,-0.00024967,-0.72279,-0.014643,0.041485,-0.018692,-0.41524},
      {-5.81E-05,0.021027,-0.08604,-2.08E-05,-0.00014081,-0.68781,-0.014754,0.062953,-0.033669,-0.38603},
      {-9.17E-05,0.019918,-0.14185,-1.05E-05,-8.12E-05,-0.62586,-0.014006,0.1016,-0.061501,-0.33461},
      {-0.00013672,0.015323,-0.25035,1.95E-05,9.57E-06,-0.50609,-0.010863,0.17812,-0.11788,-0.2353},
      {-0.00017348,0.011446,-0.3517,3.99E-05,8.90E-05,-0.39375,-0.0082243,0.24959,-0.17031,-0.14215},
      {-0.00019958,0.0082145,-0.4419,5.05E-05,0.00016097,-0.29354,-0.0060346,0.3132,-0.21686,-0.059074},
      {-0.00018324,0.0052057,-0.49243,3.96E-05,0.00025329,-0.23906,-0.003955,0.34875,-0.24355,-0.014},
      {-0.00070878,0.00055052,0.70554,0,0.00019368,0.00011182,0.00011996,0.49896,-0.35219,0.18445},
      {-0.00073377,0.00053791,0.70551,0,0.00020468,0.00011817,0.00014703,0.49895,-0.35217,0.18444},
      {-0.00076854,0.00051898,0.70547,0,0.00022197,0.00012816,0.00018577,0.49892,-0.35214,0.18442},
      {-0.00080902,0.00049385,0.70541,0,0.00024652,0.00014233,0.00023323,0.49889,-0.35211,0.1844},
      {-0.000848,0.00046317,0.70535,0,0.00027934,0.00016128,0.00028388,0.49886,-0.35209,0.18437},
      {-0.00087501,0.00042815,0.70529,0,0.00032158,0.00018567,0.00032947,0.49884,-0.35207,0.18433},
      {-0.0008762,0.00039049,0.70525,0,0.00037453,0.00021624,0.00035904,0.49882,-0.35208,0.18428},
      {-0.0014247,0.00031553,0.70336,-0.00010204,0.00042958,-0.00093783,0.00081534,0.49755,-0.35102,0.18324},
      {-0.0022015,0.00025438,0.70071,-0.00021032,0.00053881,-0.0024881,0.0014266,0.49579,-0.3495,0.1818},
      {-0.0030485,0.00019423,0.69751,-0.00031176,0.00064584,-0.0044703,0.002089,0.49372,-0.34771,0.18},
      {-0.0039224,0.00013328,0.69378,-0.00039937,0.00072817,-0.0069677,0.002773,0.49136,-0.34569,0.17781},
      {-0.0047969,7.33E-05,0.68947,-0.00046737,0.00076894,-0.010079,0.0034586,0.48869,-0.34344,0.17518},
      {-0.0042505,3.41E-05,0.67787,-0.00038138,0.00084758,-0.023054,0.0031315,0.48111,-0.33823,0.1643},
      {-0.0028793,8.20E-06,0.66026,-0.00023387,0.00096531,-0.043645,0.0022174,0.46945,-0.33048,0.14705},
      {-0.0015494,-1.41E-05,0.64012,-0.00011487,0.0010688,-0.066882,0.001333,0.45612,-0.32155,0.12763},
      {-0.00029926,-3.20E-05,0.61734,-2.71E-05,0.0011503,-0.092883,0.00050479,0.44103,-0.31137,0.10595},
      {1.90E-05,6.41E-05,0.55494,3.43E-07,0.0012794,-0.16446,0.00016216,0.39716,-0.28046,0.046354},
      {0.00010235,0.00017701,0.47636,1.44E-05,0.0014056,-0.25485,-4.56E-05,0.34162,-0.2412,-0.028841},
      {0.00016332,0.00027443,0.38886,2.31E-05,0.0014539,-0.35579,-0.00021374,0.27973,-0.19746,-0.11265},
      {0.00015619,0.0008602,0.29375,3.73E-05,0.0012197,-0.46498,-0.00067601,0.21258,-0.14975,-0.20308},
      {0.0001082,0.0018338,0.19985,4.96E-05,0.00071642,-0.57228,-0.0013651,0.14647,-0.10257,-0.29167},
      {5.91E-05,0.0024444,0.11008,4.54E-05,0.00030919,-0.67532,-0.0017999,0.083295,-0.057623,-0.37669},
      {2.03E-05,0.0035102,0.039935,2.80E-05,3.80E-05,-0.75305,-0.0025425,0.03529,-0.02315,-0.44074},
      {2.61E-07,0.0058029,0.016146,-2.79E-06,-4.13E-05,-0.76984,-0.0041179,0.02367,-0.013758,-0.45434},
      {-1.67E-05,0.0072564,-0.0013719,-2.74E-05,-0.00010795,-0.77927,-0.0051192,0.017013,-0.0083002,-0.46198},
      {-2.79E-05,0.0084882,-0.019168,-3.46E-05,-0.00017867,-0.77753,-0.0059822,0.017199,-0.0077913,-0.46048},
      {-5.13E-05,0.0099557,-0.054624,-3.29E-05,-0.0001324,-0.73653,-0.0070205,0.04119,-0.023951,-0.42642},
      {-7.64E-05,0.010206,-0.092255,-3.21E-05,-8.21E-05,-0.69421,-0.0072168,0.066858,-0.041912,-0.39128},
      {-0.00010186,0.0094204,-0.1328,-3.20E-05,-2.84E-05,-0.64948,-0.0066986,0.094744,-0.061966,-0.35415},
      {-0.00013175,0.0066029,-0.23172,-1.28E-05,4.85E-05,-0.53868,-0.0048035,0.16451,-0.11266,-0.26228},
      {-0.0001552,0.0044247,-0.32187,-4.14E-07,0.00011525,-0.43727,-0.0033546,0.2281,-0.15866,-0.17821},
      {-0.00017286,0.0028804,-0.40191,6.31E-06,0.00017209,-0.34677,-0.0023461,0.28456,-0.1993,-0.10319},
      {-0.00016799,0.00025058,0.70627,0,0.00033445,0.00019309,-5.33E-05,0.49946,-0.35296,0.18432},
      {-0.00018353,0.00024847,0.70621,0,0.00037095,0.00021417,-4.04E-05,0.49943,-0.35293,0.18428},
      {-0.00020714,0.00024522,0.70612,0,0.00042983,0.00024817,-2.06E-05,0.49937,-0.35288,0.18423},
      {-0.00023903,0.00024073,0.70598,0,0.00051659,0.00029825,6.22E-06,0.49929,-0.3528,0.18414},
      {-0.00027889,0.00023492,0.7058,0,0.00063812,0.00036842,3.99E-05,0.49918,-0.35271,0.18403},
      {-0.00032588,0.00022775,0.70556,0,0.00080325,0.00046376,8.00E-05,0.49903,-0.35258,0.18387},
      {-0.00037864,0.00021923,0.70526,0,0.0010231,0.00059069,0.00012536,0.49884,-0.35243,0.18366},
      {-0.00043531,0.00020937,0.70488,0,0.0013115,0.00075722,0.00017482,0.4986,-0.35223,0.18338},
      {-0.00059318,0.00019345,0.70393,-7.11E-06,0.0016193,0.00052641,0.00030318,0.49802,-0.35175,0.18275},
      {-0.0012526,0.00015285,0.70039,-4.49E-05,0.001621,-0.0021841,0.00081839,0.49583,-0.3499,0.1805},
      {-0.0019169,0.00011205,0.69632,-7.34E-05,0.0015739,-0.0054891,0.0013391,0.49333,-0.34783,0.17783},
      {-0.0025598,7.24E-05,0.69169,-8.99E-05,0.0014583,-0.0094846,0.0018459,0.49052,-0.34552,0.17468},
      {-0.003027,3.62E-05,0.68644,-0.00010881,0.0012628,-0.014373,0.0022485,0.48734,-0.34303,0.17091},
      {-0.0028523,1.01E-05,0.676,-0.00010569,0.0010114,-0.025877,0.002196,0.48063,-0.33833,0.16173},
      {-0.0017358,5.09E-07,0.65417,-6.70E-05,0.001028,-0.050814,0.0014816,0.46608,-0.32851,0.14102},
      {-0.00079065,-5.05E-06,0.62952,-3.45E-05,0.0010118,-0.078701,0.00089121,0.44963,-0.31726,0.11792},
      {-4.04E-05,-6.21E-06,0.60192,-9.03E-06,0.0009577,-0.10969,0.00044103,0.43117,-0.3045,0.092301},
      {0.00022053,4.46E-05,0.53941,3.30E-06,0.00094924,-0.18145,0.00020727,0.38738,-0.27364,0.032793},
      {0.00021282,0.0001184,0.44759,8.37E-06,0.00097614,-0.2876,6.64E-05,0.32235,-0.22769,-0.055283},
      {0.00016841,0.00017696,0.34748,1.14E-05,0.00098,-0.4034,-5.48E-05,0.25148,-0.17762,-0.15131},
      {9.83E-05,0.00034048,0.24506,1.13E-05,0.00087977,-0.52173,-0.00022831,0.17907,-0.12639,-0.24931},
      {5.19E-05,0.00072049,0.16247,1.22E-06,0.00056594,-0.61672,-0.00050719,0.12095,-0.085123,-0.32769},
      {2.27E-05,0.0010149,0.090906,-8.15E-06,0.00030653,-0.69896,-0.00073554,0.070583,-0.04936,-0.3956},
      {-4.05E-06,0.0012896,0.024882,-1.77E-05,9.66E-05,-0.77387,-0.00094893,0.02467,-0.016757,-0.45748},
      {-1.25E-05,0.0026807,0.0097042,-2.65E-05,2.07E-06,-0.77888,-0.0019222,0.020623,-0.013183,-0.46157},
      {-2.12E-05,0.0034757,-0.0049121,-3.49E-05,-7.14E-05,-0.78231,-0.0024816,0.017954,-0.010882,-0.46437},
      {-2.95E-05,0.0037292,-0.018922,-4.31E-05,-0.00012286,-0.78394,-0.0026662,0.016769,-0.0099036,-0.46568},
      {-5.13E-05,0.0038992,-0.055929,-4.33E-05,-7.61E-05,-0.7435,-0.0028109,0.041347,-0.027138,-0.43211},
      {-7.30E-05,0.0034109,-0.096955,-4.36E-05,-2.02E-05,-0.69777,-0.0025065,0.06963,-0.047323,-0.39416},
      {-9.18E-05,0.0024265,-0.1401,-4.49E-05,3.66E-05,-0.64991,-0.0018662,0.099569,-0.06893,-0.35446},
      {-0.00010595,0.0015727,-0.21359,-3.58E-05,9.35E-05,-0.56626,-0.0013368,0.15133,-0.10591,-0.28511},
      {-0.00011993,0.00096461,-0.28862,-2.60E-05,0.00014141,-0.48039,-0.00097853,0.2043,-0.14361,-0.21394},
      {-1.95E-05,0.00013478,0.70668,0,0.00023696,0.00013681,-7.50E-05,0.49972,-0.35327,0.18441},
      {-2.70E-05,0.0001334,0.70657,0,0.00032781,0.00018926,-6.57E-05,0.49965,-0.35322,0.18432},
      {-3.80E-05,0.00013127,0.7064,0,0.0004747,0.00027407,-5.14E-05,0.49953,-0.35313,0.18418},
      {-5.21E-05,0.00012833,0.70614,0,0.00069181,0.00039942,-3.20E-05,0.49936,-0.353,0.18397},
      {-6.84E-05,0.00012452,0.70578,0,0.00099749,0.0005759,-7.29E-06,0.49913,-0.35282,0.18368},
      {-8.54E-05,0.00011982,0.7053,0,0.0014157,0.00081737,2.24E-05,0.49881,-0.35257,0.18328},
      {-0.00010147,0.00011421,0.70466,0,0.0019777,0.0011418,5.66E-05,0.49838,-0.35226,0.18274},
      {-0.00011449,0.00010772,0.70382,0,0.0027237,0.0015725,9.44E-05,0.49783,-0.35184,0.18203},
      {-0.00012236,0.00010038,0.70274,0,0.0037045,0.0021388,0.00013454,0.4971,-0.35131,0.18109},
      {-0.00012313,9.22E-05,0.70136,0,0.0049842,0.0028776,0.00017536,0.49617,-0.35063,0.17987},
      {-0.00031291,7.42E-05,0.698,-8.52E-06,0.005375,0.00042258,0.00035054,0.49408,-0.34905,0.17727},
      {-0.00057413,5.15E-05,0.69317,-2.04E-05,0.0048565,-0.0048856,0.00057455,0.49116,-0.34686,0.17361},
      {-0.00075612,3.10E-05,0.68788,-2.93E-05,0.0040127,-0.011294,0.0007431,0.48797,-0.34451,0.16951},
      {-0.0008412,1.35E-05,0.68214,-3.44E-05,0.0027368,-0.018987,0.00084509,0.48453,-0.34201,0.16496},
      {-0.00078267,8.13E-07,0.67473,-3.42E-05,0.0010417,-0.029379,0.00085109,0.47997,-0.33879,0.15878},
      {-0.00028482,2.23E-06,0.64851,-1.75E-05,0.00097239,-0.058764,0.00056549,0.46234,-0.32651,0.13452},
      {8.26E-05,6.55E-06,0.61954,-5.50E-06,0.00086893,-0.091132,0.00037411,0.44282,-0.31284,0.10782},
      {0.00031449,1.37E-05,0.58776,1.68E-06,0.00072741,-0.1266,0.00027996,0.42135,-0.29772,0.078619},
      {0.00035831,3.71E-05,0.52859,4.26E-06,0.00062159,-0.19438,0.00022742,0.37998,-0.26848,0.022567},
      {0.0002666,7.69E-05,0.42757,4.71E-06,0.00061948,-0.31177,0.00012267,0.30812,-0.2177,-0.074771},
      {0.000171,0.00010941,0.3246,4.08E-06,0.00060857,-0.43114,2.20E-05,0.23507,-0.16608,-0.17373},
      {7.72E-05,0.00014485,0.22185,2.00E-06,0.00057915,-0.54995,-7.74E-05,0.16237,-0.1147,-0.27221},
      {4.85E-05,0.0003566,0.15363,-7.26E-06,0.00037173,-0.62799,-0.00024884,0.11459,-0.080811,-0.33669},
      {2.19E-05,0.00048786,0.088026,-1.68E-05,0.00020088,-0.7027,-0.00036383,0.068862,-0.048417,-0.39846},
      {-1.65E-06,0.0005431,0.025667,-2.66E-05,6.74E-05,-0.77332,-0.00042518,0.025672,-0.017853,-0.45687},
      {-1.15E-05,0.00097378,0.0046484,-3.51E-05,2.89E-06,-0.78508,-0.00073518,0.018167,-0.012319,-0.46657},
      {-1.84E-05,0.0011156,-0.0090579,-4.31E-05,-3.47E-05,-0.78533,-0.00084511,0.017903,-0.012046,-0.46674},
      {-2.32E-05,0.00099225,-0.02215,-5.11E-05,-5.00E-05,-0.78351,-0.00077496,0.019091,-0.012934,-0.4652},
      {-3.49E-05,0.00085664,-0.054379,-5.36E-05,-1.02E-05,-0.75042,-0.00071582,0.039406,-0.027325,-0.43773},
      {-4.78E-05,0.00050189,-0.094527,-5.37E-05,3.87E-05,-0.70517,-0.00051715,0.0673,-0.047175,-0.4002},
      {-5.78E-05,8.86E-05,-0.13351,-5.31E-05,0.00019453,-0.66078,-0.00028444,0.094573,-0.066617,-0.36359},
      {-6.98E-05,0.00014565,-0.18882,-4.43E-05,0.00067968,-0.596,-0.00038704,0.13363,-0.094138,-0.31056},
      {0,4.72E-05,0.70704,0,1.98E-05,1.14E-05,-3.34E-05,0.49995,-0.3535,0.18462},
      {0,4.78E-05,0.70704,0,2.03E-05,1.17E-05,-3.38E-05,0.49995,-0.3535,0.18462},
      {0,4.87E-05,0.70704,0,2.11E-05,1.22E-05,-3.44E-05,0.49995,-0.35349,0.18462},
      {0,4.97E-05,0.70703,0,2.22E-05,1.28E-05,-3.51E-05,0.49995,-0.35349,0.18462},
      {1.64E-07,4.89E-05,0.70667,0,0.00036573,0.00021115,-2.72E-05,0.4997,-0.35331,0.18429},
      {1.33E-06,4.58E-05,0.70575,0,0.0012326,0.00071165,-8.37E-06,0.49907,-0.35286,0.18346},
      {3.99E-06,4.22E-05,0.70456,0,0.0023554,0.0013599,1.22E-05,0.49826,-0.35227,0.18238},
      {8.53E-06,3.79E-05,0.70306,0,0.0037875,0.0021867,3.33E-05,0.49723,-0.35154,0.18101},
      {1.51E-05,3.32E-05,0.70118,0,0.0055942,0.0032298,5.33E-05,0.49594,-0.35061,0.17928},
      {2.35E-05,2.80E-05,0.69885,0,0.0078538,0.0045344,7.01E-05,0.49434,-0.34947,0.17712},
      {3.30E-05,2.25E-05,0.69597,0,0.01066,0.0061544,8.12E-05,0.49235,-0.34806,0.17443},
      {3.39E-05,1.60E-05,0.69225,-4.35E-07,0.013203,0.0064869,9.28E-05,0.48985,-0.3463,0.17105},
      {3.12E-05,7.40E-06,0.68711,-1.74E-06,0.011412,-0.0016543,0.00012349,0.48674,-0.34408,0.16688},
      {9.21E-05,1.28E-06,0.68157,-8.77E-07,0.0090235,-0.011272,0.00011906,0.4834,-0.34173,0.16233},
      {0.00015199,-6.28E-07,0.67444,-3.44E-07,0.0060153,-0.023833,0.00014027,0.47888,-0.33852,0.15624},
      {0.00019888,-1.58E-06,0.66545,-4.21E-07,0.0021193,-0.040137,0.00017887,0.47299,-0.33433,0.14831},
      {0.00025229,2.35E-06,0.63687,3.94E-07,0.0012836,-0.073608,0.00020333,0.45334,-0.32041,0.12176},
      {0.00030383,6.87E-06,0.60222,1.29E-06,0.0011035,-0.11303,0.00022478,0.42936,-0.30343,0.089332},
      {0.00035078,1.08E-05,0.5651,2.04E-06,0.00077192,-0.15571,0.00024542,0.40355,-0.28516,0.054421},
      {0.00036453,1.89E-05,0.51404,2.30E-06,0.00036393,-0.21494,0.00024149,0.3677,-0.25981,0.0058978},
      {0.00026309,4.30E-05,0.41317,5.05E-07,0.00035481,-0.33148,0.00014504,0.29638,-0.20942,-0.090726},
      {0.00016458,6.06E-05,0.31084,-2.30E-06,0.00033821,-0.44948,5.64E-05,0.22419,-0.15841,-0.18854},
      {7.23E-05,7.15E-05,0.20756,-6.17E-06,0.00031396,-0.56833,-2.20E-05,0.15148,-0.10704,-0.28706},
      {3.87E-05,0.00013411,0.13984,-1.50E-05,0.00020185,-0.64524,-9.55E-05,0.10442,-0.073744,-0.35071},
      {1.76E-05,0.00016311,0.080501,-2.51E-05,0.0001053,-0.71186,-0.00013852,0.063666,-0.044918,-0.40584},
      {1.64E-06,0.0001645,0.025315,-3.61E-05,4.00E-05,-0.77294,-0.00016024,0.026306,-0.018505,-0.4564},
      {-5.39E-06,0.00021521,-0.0010593,-4.49E-05,1.13E-05,-0.79148,-0.00021166,0.014919,-0.010421,-0.47172},
      {-8.18E-06,0.00017353,-0.013426,-5.18E-05,4.84E-06,-0.78849,-0.00020146,0.016764,-0.011733,-0.46922},
      {-9.39E-06,3.60E-05,-0.024703,-5.75E-05,1.14E-05,-0.78375,-0.00012996,0.019744,-0.013893,-0.46527},
      {-1.62E-05,1.51E-05,-0.048348,-5.92E-05,0.0001125,-0.75934,-0.00015379,0.034544,-0.024332,-0.44517},
      {-2.64E-05,-2.43E-05,-0.085386,-5.66E-05,0.0004674,-0.71609,-0.00018031,0.060605,-0.042724,-0.40982},
      {-3.34E-05,-7.83E-05,-0.12052,-5.25E-05,0.00097589,-0.67477,-0.00020109,0.085342,-0.060187,-0.37628},
      {0,3.37E-06,0.70709,0,1.15E-05,6.62E-06,-2.38E-06,0.49999,-0.35354,0.18463},
      {0,3.15E-06,0.70709,0,1.19E-05,6.86E-06,-2.23E-06,0.49999,-0.35354,0.18463},
      {0,2.77E-06,0.70709,0,1.25E-05,7.23E-06,-1.96E-06,0.49999,-0.35354,0.18463},
      {0,2.14E-06,0.70709,0,1.34E-05,7.73E-06,-1.51E-06,0.49999,-0.35354,0.18462},
      {0,1.16E-06,0.70709,0,1.45E-05,8.38E-06,-8.21E-07,0.49999,-0.35354,0.18462},
      {0,1.05E-06,0.70709,0,1.59E-05,9.17E-06,-7.46E-07,0.49999,-0.35354,0.18462},
      {0,1.13E-06,0.70709,0,1.75E-05,1.01E-05,-8.00E-07,0.49999,-0.35354,0.18462},
      {3.57E-06,1.19E-06,0.70485,0,0.0022102,0.001276,2.25E-06,0.49843,-0.35244,0.18252},
      {7.90E-06,1.24E-06,0.70195,0,0.0050563,0.0029192,5.89E-06,0.49642,-0.35101,0.1798},
      {1.28E-05,1.28E-06,0.69841,0,0.0085452,0.0049336,9.95E-06,0.49395,-0.34926,0.17646},
      {1.83E-05,1.31E-06,0.69412,0,0.01278,0.0073783,1.44E-05,0.49095,-0.34714,0.1724},
      {2.43E-05,1.32E-06,0.68896,0,0.017872,0.010319,1.92E-05,0.48734,-0.34459,0.16753},
      {3.08E-05,1.31E-06,0.68283,0,0.023946,0.013825,2.42E-05,0.48304,-0.34154,0.16171},
      {6.56E-05,7.10E-07,0.67515,-4.94E-08,0.022215,0.0025155,5.24E-05,0.47792,-0.3379,0.15482},
      {0.00010868,2.79E-08,0.66584,-1.01E-07,0.017699,-0.015439,8.62E-05,0.47169,-0.33347,0.14642},
      {0.00015262,-5.74E-07,0.6547,-1.41E-07,0.01224,-0.037202,0.00011943,0.46411,-0.32809,0.13621},
      {0.00019616,-1.08E-06,0.64142,-1.68E-07,0.0057279,-0.063329,0.00015118,0.45499,-0.32162,0.1239},
      {0.00023496,7.83E-07,0.61387,1.92E-07,0.0026158,-0.10002,0.00017334,0.4358,-0.30803,0.097951},
      {0.00026682,3.72E-06,0.57615,6.93E-07,0.002057,-0.14406,0.00018856,0.4094,-0.28935,0.062238},
      {0.00029167,6.08E-06,0.53592,1.05E-06,0.001257,-0.19158,0.00020066,0.38113,-0.26935,0.023985},
      {0.00030927,7.82E-06,0.49194,1.18E-06,0.00017564,-0.244,0.00020961,0.35016,-0.24744,-0.017932},
      {0.00021723,1.90E-05,0.38974,-2.90E-06,0.0001649,-0.36123,0.00013188,0.27843,-0.19676,-0.11512},
      {0.00013032,2.50E-05,0.28677,-8.15E-06,0.00014731,-0.47915,6.17E-05,0.20628,-0.14579,-0.21286},
      {5.33E-05,2.52E-05,0.18328,-1.46E-05,0.00012338,-0.59744,2.85E-06,0.13391,-0.094656,-0.31092},
      {2.03E-05,2.99E-05,0.11349,-2.41E-05,7.44E-05,-0.67578,-3.15E-05,0.085979,-0.060777,-0.37581},
      {8.34E-06,1.67E-05,0.064273,-3.45E-05,3.27E-05,-0.72952,-4.13E-05,0.053105,-0.037542,-0.4203},
      {2.29E-06,-3.74E-06,0.021039,-4.61E-05,1.50E-05,-0.77601,-4.45E-05,0.024643,-0.01743,-0.45882},
      {-8.65E-07,-9.59E-06,-0.0047009,-5.68E-05,1.37E-05,-0.79604,-6.14E-05,0.012339,-0.0087261,-0.47543},
      {-2.64E-06,-2.03E-05,-0.014616,-6.24E-05,2.31E-05,-0.79044,-8.05E-05,0.015722,-0.011106,-0.4708},
      {-3.60E-06,-4.00E-05,-0.024081,-6.51E-05,3.85E-05,-0.78456,-9.59E-05,0.019278,-0.013608,-0.46595},
      {-5.99E-06,-7.13E-05,-0.039995,-6.38E-05,0.00015971,-0.76922,-0.00011208,0.028522,-0.020127,-0.45341},
      {-1.24E-05,-0.0001216,-0.07363,-5.90E-05,0.00058826,-0.72974,-0.00013546,0.052211,-0.036847,-0.42129},
      {0,2.43E-07,0.7071,0,6.02E-06,3.47E-06,-1.72E-07,0.5,-0.35355,0.18463},
      {0,2.53E-07,0.7071,0,6.35E-06,3.66E-06,-1.79E-07,0.5,-0.35355,0.18463},
      {0,2.70E-07,0.7071,0,6.85E-06,3.96E-06,-1.91E-07,0.49999,-0.35355,0.18463},
      {0,2.91E-07,0.7071,0,7.55E-06,4.36E-06,-2.06E-07,0.49999,-0.35355,0.18463},
      {0,3.16E-07,0.7071,0,8.44E-06,4.87E-06,-2.23E-07,0.49999,-0.35355,0.18463},
      {0,3.44E-07,0.7071,0,9.53E-06,5.50E-06,-2.43E-07,0.49999,-0.35355,0.18463},
      {0,3.73E-07,0.7071,0,1.08E-05,6.25E-06,-2.64E-07,0.49999,-0.35355,0.18463},
      {0,4.01E-07,0.70709,0,1.23E-05,7.10E-06,-2.83E-07,0.49999,-0.35355,0.18463},
      {8.98E-08,4.24E-07,0.70701,0,9.79E-05,5.65E-05,-2.30E-07,0.49993,-0.3535,0.18454},
      {4.92E-06,4.26E-07,0.70226,0,0.004806,0.0027747,3.48E-06,0.4966,-0.35114,0.18004},
      {1.02E-05,4.19E-07,0.69665,0,0.010375,0.0059901,7.47E-06,0.49266,-0.34835,0.1747},
      {1.57E-05,4.01E-07,0.69007,0,0.016909,0.0097623,1.16E-05,0.48803,-0.34508,0.16845},
      {2.15E-05,3.70E-07,0.68241,0,0.024519,0.014156,1.59E-05,0.48265,-0.34127,0.16116},
      {2.73E-05,3.26E-07,0.67356,0,0.033326,0.019241,2.02E-05,0.47641,-0.33686,0.15273},
      {4.90E-05,1.17E-07,0.66265,-1.00E-08,0.035304,0.010268,3.59E-05,0.46881,-0.33147,0.14245},
      {9.25E-05,-1.66E-07,0.64983,-2.76E-08,0.027783,-0.017193,6.72E-05,0.45993,-0.32518,0.13048},
      {0.00013705,-3.88E-07,0.63475,-4.08E-08,0.019483,-0.048636,9.91E-05,0.44945,-0.31774,0.11633},
      {0.00018032,-5.45E-07,0.61719,-4.93E-08,0.010346,-0.084441,0.00012989,0.43719,-0.30904,0.099764},
      {0.00021097,8.65E-08,0.58925,-6.63E-10,0.0040302,-0.12732,0.00015046,0.4176,-0.29518,0.073278},
      {0.00021896,1.41E-06,0.54636,-9.96E-09,0.0029272,-0.17839,0.00015385,0.38749,-0.27389,0.032517},
      {0.00021483,2.12E-06,0.49982,-2.36E-07,0.0016841,-0.234,0.00014954,0.35476,-0.25075,-0.011801},
      {0.00019847,2.19E-06,0.44977,-7.04E-07,0.0003087,-0.29395,0.00013748,0.31952,-0.22584,-0.059534},
      {0.00012652,2.47E-06,0.35887,-6.20E-06,4.49E-05,-0.39829,8.26E-05,0.25594,-0.18092,-0.14567},
      {6.42E-05,-1.08E-06,0.25883,-1.40E-05,2.87E-05,-0.51236,3.61E-05,0.18614,-0.1316,-0.24023},
      {2.98E-05,-4.56E-06,0.16001,-2.45E-05,2.73E-05,-0.62494,6.54E-06,0.1172,-0.082874,-0.33358},
      {1.04E-05,-9.90E-06,0.091244,-3.74E-05,2.26E-05,-0.70192,-1.53E-05,0.070052,-0.049549,-0.3974},
      {6.45E-06,-1.74E-05,0.053607,-5.13E-05,1.69E-05,-0.74184,-2.81E-05,0.04558,-0.032252,-0.43049},
      {3.11E-06,-2.72E-05,0.019788,-6.61E-05,1.39E-05,-0.77712,-3.97E-05,0.023951,-0.016967,-0.45974},
      {7.45E-07,-4.05E-05,-0.0051174,-7.85E-05,1.70E-05,-0.79869,-5.18E-05,0.010708,-0.0076068,-0.47763},
      {1.67E-08,-6.24E-05,-0.014061,-7.96E-05,3.39E-05,-0.79287,-6.69E-05,0.014228,-0.010084,-0.47283},
      {-1.75E-07,-8.92E-05,-0.022347,-7.67E-05,5.49E-05,-0.78709,-8.06E-05,0.017735,-0.012549,-0.46807},
      {-2.00E-07,-0.0001202,-0.031115,-6.94E-05,9.60E-05,-0.77984,-9.43E-05,0.022128,-0.015638,-0.46211},
      {0,3.27E-08,0.7071,0,2.40E-06,1.38E-06,-2.31E-08,0.5,-0.35355,0.18463},
      {0,3.60E-08,0.7071,0,2.66E-06,1.54E-06,-2.55E-08,0.5,-0.35355,0.18463},
      {0,4.11E-08,0.7071,0,3.07E-06,1.77E-06,-2.90E-08,0.5,-0.35355,0.18463},
      {0,4.78E-08,0.7071,0,3.62E-06,2.09E-06,-3.38E-08,0.5,-0.35355,0.18463},
      {0,5.62E-08,0.7071,0,4.34E-06,2.51E-06,-3.97E-08,0.5,-0.35355,0.18463},
      {0,6.59E-08,0.7071,0,5.21E-06,3.01E-06,-4.66E-08,0.5,-0.35355,0.18463},
      {0,7.65E-08,0.7071,0,6.23E-06,3.60E-06,-5.41E-08,0.5,-0.35355,0.18463},
      {0,8.75E-08,0.7071,0,7.39E-06,4.26E-06,-6.19E-08,0.49999,-0.35355,0.18463},
      {0,9.83E-08,0.7071,0,8.66E-06,5.00E-06,-6.95E-08,0.49999,-0.35355,0.18463},
      {0,1.08E-07,0.7071,0,1.00E-05,5.79E-06,-7.66E-08,0.49999,-0.35355,0.18463},
      {2.22E-06,1.14E-07,0.70477,0,0.0023204,0.0013397,1.53E-06,0.49836,-0.35239,0.18242},
      {9.03E-06,1.14E-07,0.69751,0,0.0095481,0.0055126,6.45E-06,0.49324,-0.34877,0.1755},
      {1.63E-05,1.11E-07,0.68934,0,0.017686,0.010211,1.17E-05,0.48748,-0.34469,0.1677},
      {2.39E-05,1.06E-07,0.68019,0,0.026798,0.015472,1.71E-05,0.48103,-0.34013,0.15898},
      {3.13E-05,9.75E-08,0.67,0,0.036954,0.021335,2.24E-05,0.47385,-0.33504,0.14926},
      {4.42E-05,6.32E-08,0.65778,-1.43E-09,0.044052,0.019606,3.16E-05,0.46525,-0.32896,0.13763},
      {7.73E-05,-3.30E-08,0.64028,-6.50E-09,0.035155,-0.015785,5.51E-05,0.45299,-0.32027,0.12106},
      {0.00010328,-8.26E-08,0.62037,-8.40E-09,0.025306,-0.055634,7.35E-05,0.43902,-0.31038,0.10217},
      {0.00011876,-8.29E-08,0.59789,-7.06E-09,0.014408,-0.10031,8.43E-05,0.4232,-0.29919,0.080769},
      {0.00011618,9.72E-09,0.56866,-8.67E-08,0.0046723,-0.15081,8.22E-05,0.40261,-0.28463,0.052883},
      {0.00011067,5.98E-08,0.51929,-6.69E-07,0.003162,-0.21018,7.79E-05,0.36786,-0.26006,0.0058212},
      {0.00011692,-1.30E-07,0.46518,-1.66E-06,0.0016679,-0.27499,8.19E-05,0.32975,-0.23311,-0.045771},
      {0.00012125,-5.98E-07,0.4072,-3.16E-06,0.00040195,-0.34392,8.44E-05,0.28888,-0.20421,-0.1011},
      {9.86E-05,-3.31E-06,0.32402,-1.11E-05,1.60E-05,-0.43957,6.47E-05,0.23071,-0.1631,-0.17986},
      {6.34E-05,-8.52E-06,0.23114,-2.45E-05,1.50E-05,-0.54528,3.39E-05,0.16598,-0.11735,-0.2675},
      {3.03E-05,-1.56E-05,0.1418,-4.10E-05,1.37E-05,-0.64691,3.88E-06,0.10374,-0.073366,-0.35178},
      {8.31E-06,-2.47E-05,0.072667,-5.91E-05,1.22E-05,-0.72453,-1.96E-05,0.056188,-0.039768,-0.41613},
      {5.30E-06,-3.56E-05,0.042798,-7.50E-05,1.17E-05,-0.75511,-3.07E-05,0.037433,-0.026516,-0.44148},
      {2.89E-06,-4.81E-05,0.016488,-9.18E-05,1.32E-05,-0.78144,-4.11E-05,0.021271,-0.015099,-0.46332},
      {1.21E-06,-6.27E-05,-0.0052825,-0.00010836,1.75E-05,-0.80176,-5.13E-05,0.0087926,-0.0062865,-0.48017},
      {1.10E-06,-8.94E-05,-0.012951,-0.0001032,3.91E-05,-0.7962,-6.57E-05,0.012167,-0.008656,-0.47559},
      {1.21E-06,-0.00011537,-0.01966,-9.73E-05,6.29E-05,-0.79103,-8.10E-05,0.015298,-0.010852,-0.47134},
      {0,1.55E-10,0.70711,0,0,0,-1.10E-10,0.5,-0.35355,0.18464},
      {0,4.66E-10,0.70711,0,4.21E-08,2.43E-08,-3.29E-10,0.5,-0.35355,0.18464},
      {0,2.58E-09,0.70711,0,3.35E-07,1.94E-07,-1.82E-09,0.5,-0.35355,0.18464},
      {0,5.35E-09,0.70711,0,7.37E-07,4.26E-07,-3.78E-09,0.5,-0.35355,0.18464},
      {0,8.68E-09,0.70711,0,1.25E-06,7.23E-07,-6.14E-09,0.5,-0.35355,0.18464},
      {0,1.24E-08,0.7071,0,1.88E-06,1.08E-06,-8.76E-09,0.5,-0.35355,0.18464},
      {0,1.62E-08,0.7071,0,2.60E-06,1.50E-06,-1.15E-08,0.5,-0.35355,0.18463},
      {0,1.99E-08,0.7071,0,3.43E-06,1.98E-06,-1.41E-08,0.5,-0.35355,0.18463},
      {0,2.30E-08,0.7071,0,4.33E-06,2.50E-06,-1.62E-08,0.5,-0.35355,0.18463},
      {0,2.51E-08,0.7071,0,5.29E-06,3.05E-06,-1.77E-08,0.5,-0.35355,0.18463},
      {0,2.58E-08,0.7071,0,6.29E-06,3.63E-06,-1.82E-08,0.5,-0.35355,0.18463},
      {0,2.47E-08,0.7071,0,7.31E-06,4.22E-06,-1.75E-08,0.49999,-0.35355,0.18463},
      {4.44E-06,2.05E-08,0.69978,0,0.007302,0.0042158,3.14E-06,0.49483,-0.3499,0.17765},
      {8.99E-06,1.43E-08,0.68991,0,0.017151,0.0099022,6.37E-06,0.48787,-0.34497,0.16822},
      {1.20E-05,6.55E-09,0.67891,0,0.02813,0.016241,8.53E-06,0.4801,-0.33948,0.15771},
      {1.41E-05,0,0.66741,0,0.03961,0.022869,9.95E-06,0.47198,-0.33373,0.14671},
      {1.83E-05,0,0.65754,0,0.049466,0.028559,1.29E-05,0.46501,-0.3288,0.13728},
      {3.87E-05,0,0.63682,0,0.037744,-0.015546,2.74E-05,0.45042,-0.31847,0.11754},
      {6.02E-05,0,0.61037,0,0.025409,-0.067337,4.25E-05,0.43177,-0.30528,0.092313},
      {8.14E-05,0,0.57795,0,0.013698,-0.12495,5.75E-05,0.4089,-0.28909,0.06136},
      {0.0001014,-8.02E-09,0.53868,-2.66E-08,0.0030007,-0.18874,7.17E-05,0.38117,-0.26947,0.023833},
      {0.00010318,-5.84E-07,0.48284,-1.72E-06,0.0019274,-0.25487,7.23E-05,0.3418,-0.24164,-0.029459},
      {0.00010315,-1.49E-06,0.4233,-4.06E-06,0.0010281,-0.32499,7.15E-05,0.29981,-0.21195,-0.08631},
      {0.00010113,-2.80E-06,0.36004,-7.15E-06,0.00030927,-0.39913,6.90E-05,0.25517,-0.18039,-0.14675},
      {8.29E-05,-7.24E-06,0.28444,-1.74E-05,6.80E-06,-0.48615,5.22E-05,0.2022,-0.14295,-0.21847},
      {5.14E-05,-1.61E-05,0.20111,-3.71E-05,6.10E-06,-0.58088,2.25E-05,0.14418,-0.10195,-0.29701},
      {2.43E-05,-2.70E-05,0.12185,-6.05E-05,5.45E-06,-0.67096,-4.95E-06,0.088992,-0.06296,-0.3717},
      {5.12E-06,-3.99E-05,0.053687,-8.64E-05,5.31E-06,-0.74794,-2.78E-05,0.04182,-0.029633,-0.43553},
      {2.95E-06,-5.19E-05,0.031198,-0.00010637,8.68E-06,-0.76985,-3.75E-05,0.028362,-0.020132,-0.4537},
      {1.54E-06,-6.51E-05,0.011955,-0.00013223,1.28E-05,-0.78815,-4.71E-05,0.017104,-0.012192,-0.46888},
      {8.62E-07,-7.97E-05,-0.0039694,-0.00016548,1.77E-05,-0.80282,-5.69E-05,0.0080631,-0.0058256,-0.48105},
      {9.18E-07,-0.00010369,-0.011004,-0.00016486,3.97E-05,-0.80021,-7.24E-05,0.0096228,-0.0069167,-0.47892},
      {0,1.27E-11,0.70711,0,0,0,-8.96E-12,0.5,-0.35355,0.18464},
      {0,1.20E-11,0.70711,0,0,0,-8.51E-12,0.5,-0.35355,0.18464},
      {0,1.09E-11,0.70711,0,0,0,-7.74E-12,0.5,-0.35355,0.18464},
      {0,9.27E-12,0.70711,0,0,0,-6.56E-12,0.5,-0.35355,0.18464},
      {0,6.81E-12,0.70711,0,0,0,-4.82E-12,0.5,-0.35355,0.18464},
      {0,3.32E-12,0.70711,0,0,0,-2.35E-12,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,4.46E-07,2.57E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.60E-07,5.54E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.50E-06,8.65E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.04E-06,1.18E-06,0,0.5,-0.35355,0.18464},
      {0,0,0.7071,0,2.56E-06,1.48E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.04E-06,1.76E-06,0,0.5,-0.35355,0.18463},
      {0,0,0.7071,0,3.45E-06,1.99E-06,0,0.5,-0.35355,0.18463},
      {1.40E-06,0,0.70385,0,0.0032517,0.0018774,9.87E-07,0.4977,-0.35193,0.18152},
      {5.09E-06,0,0.69552,0,0.011562,0.0066755,3.60E-06,0.49182,-0.34777,0.17357},
      {8.88E-06,0,0.68745,0,0.019625,0.011331,6.28E-06,0.48612,-0.34373,0.16585},
      {1.27E-05,0,0.67982,0,0.027248,0.015731,8.97E-06,0.48072,-0.33992,0.15855},
      {1.64E-05,0,0.67283,0,0.034228,0.019761,1.16E-05,0.47579,-0.33642,0.15187},
      {3.13E-05,0,0.6463,0,0.028665,-0.020444,2.21E-05,0.45705,-0.32317,0.12652},
      {4.95E-05,0,0.60683,0,0.019039,-0.082633,3.50E-05,0.42917,-0.30344,0.088779},
      {6.59E-05,0,0.56071,0,0.01026,-0.15103,4.66E-05,0.39658,-0.28039,0.044671},
      {7.98E-05,0,0.50733,0,0.0025396,-0.22602,5.64E-05,0.35884,-0.2537,-0.0064167},
      {7.83E-05,-1.21E-06,0.44666,-2.81E-06,0.00093207,-0.29873,5.44E-05,0.31602,-0.22342,-0.064397},
      {7.24E-05,-3.07E-06,0.38218,-6.96E-06,0.00047837,-0.37384,4.88E-05,0.2705,-0.19124,-0.12602},
      {6.19E-05,-5.60E-06,0.31039,-1.28E-05,0.00015763,-0.45713,3.96E-05,0.21983,-0.15542,-0.19462},
      {4.47E-05,-1.12E-05,0.23365,-2.57E-05,2.06E-06,-0.54546,2.33E-05,0.1659,-0.1173,-0.26764},
      {2.23E-05,-2.29E-05,0.16057,-5.29E-05,2.15E-06,-0.62848,-1.09E-06,0.11503,-0.081365,-0.33647},
      {7.70E-06,-3.58E-05,0.095091,-8.36E-05,2.27E-06,-0.7029,-2.05E-05,0.069413,-0.049144,-0.39818},
      {7.41E-07,-4.98E-05,0.037843,-0.00011802,2.40E-06,-0.76804,-3.50E-05,0.029468,-0.02093,-0.45219},
      {2.50E-07,-6.37E-05,0.02067,-0.00015361,7.06E-06,-0.7842,-4.49E-05,0.01951,-0.013918,-0.46559},
      {3.76E-07,-7.94E-05,0.007855,-0.00020162,1.29E-05,-0.79517,-5.59E-05,0.012702,-0.0091432,-0.47471},
      {4.69E-07,-9.77E-05,-0.0027711,-0.00026361,1.94E-05,-0.8038,-6.87E-05,0.0073105,-0.0053838,-0.48187},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.21E-07,6.96E-08,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.26E-07,1.88E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.07E-07,2.93E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,6.50E-07,3.75E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.44E-07,4.30E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,7.78E-07,4.49E-07,0,0.5,-0.35355,0.18464},
      {5.95E-08,0,0.70699,0,0.00011182,6.46E-05,4.21E-08,0.49992,-0.3535,0.18453},
      {3.32E-06,0,0.70103,0,0.0060744,0.0035071,2.35E-06,0.4957,-0.35051,0.17882},
      {6.45E-06,0,0.69554,0,0.011553,0.0066699,4.56E-06,0.49183,-0.34777,0.17358},
      {9.35E-06,0,0.69073,0,0.016363,0.0094471,6.61E-06,0.48842,-0.34536,0.16897},
      {1.19E-05,0,0.68696,0,0.020132,0.011623,8.40E-06,0.48576,-0.34348,0.16536},
      {1.96E-05,0,0.6614,0,0.017404,-0.022588,1.39E-05,0.46769,-0.3307,0.14091},
      {3.04E-05,0,0.60718,0,0.010634,-0.096891,2.15E-05,0.42937,-0.30359,0.089029},
      {3.76E-05,0,0.54431,0,0.0052764,-0.17874,2.66E-05,0.38492,-0.27216,0.028857},
      {4.04E-05,0,0.47218,0,0.0014037,-0.26872,2.86E-05,0.33393,-0.2361,-0.04019},
      {3.29E-05,-1.90E-06,0.3988,-4.52E-06,0.00028832,-0.35528,2.19E-05,0.2821,-0.19946,-0.11036},
      {2.11E-05,-5.41E-06,0.32448,-1.28E-05,0.00011627,-0.44126,1.10E-05,0.22962,-0.16237,-0.18141},
      {8.85E-06,-9.79E-06,0.24608,-2.33E-05,2.23E-05,-0.53185,-6.89E-07,0.17424,-0.12322,-0.25638},
      {3.72E-09,-1.64E-05,0.16824,-3.92E-05,8.82E-08,-0.62153,-1.16E-05,0.11933,-0.084407,-0.33071},
      {2.67E-08,-2.99E-05,0.11576,-7.48E-05,7.16E-07,-0.68103,-2.11E-05,0.082828,-0.058628,-0.38004},
      {4.45E-08,-4.38E-05,0.069363,-0.00011391,1.36E-06,-0.73362,-3.09E-05,0.050558,-0.035842,-0.42365},
      {5.72E-08,-5.79E-05,0.029332,-0.00015638,2.00E-06,-0.77899,-4.09E-05,0.022703,-0.016181,-0.46127},
      {1.40E-07,-7.51E-05,0.013347,-0.00021376,6.82E-06,-0.79444,-5.30E-05,0.013144,-0.0094704,-0.47409},
      {2.18E-07,-9.56E-05,0.004624,-0.00028923,1.32E-05,-0.80109,-6.75E-05,0.0089458,-0.0065669,-0.47961},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {1.50E-06,0,0.70516,0,0.0019457,0.0011233,1.06E-06,0.49862,-0.35258,0.18277},
      {3.32E-06,0,0.70301,0,0.0040931,0.0023631,2.35E-06,0.4971,-0.3515,0.18072},
      {4.61E-06,0,0.70171,0,0.0053893,0.0031115,3.26E-06,0.49619,-0.35085,0.17948},
      {5.24E-06,0,0.70133,0,0.0057668,0.0033295,3.71E-06,0.49592,-0.35066,0.17912},
      {6.19E-06,0,0.68128,0,0.0044749,-0.022055,4.38E-06,0.48174,-0.34064,0.15992},
      {6.84E-06,0,0.60872,0,0.0018795,-0.11033,4.83E-06,0.43044,-0.30436,0.090455},
      {2.92E-06,0,0.5273,0,0.00032607,-0.20703,2.07E-06,0.37287,-0.26366,0.012511},
      {0,0,0.43702,0,0,-0.31184,0,0.30904,-0.21852,-0.073928},
      {0,-2.53E-06,0.35147,-6.12E-06,0,-0.41055,-1.79E-06,0.24858,-0.17578,-0.15578},
      {0,-8.66E-06,0.27524,-2.10E-05,0,-0.49844,-6.12E-06,0.19474,-0.13772,-0.22864},
      {0,-1.63E-05,0.19735,-3.95E-05,0,-0.58823,-1.16E-05,0.13972,-0.098826,-0.3031},
      {0,-2.58E-05,0.11842,-6.22E-05,0,-0.67923,-1.82E-05,0.083952,-0.059413,-0.37855},
      {1.30E-08,-3.95E-05,0.079545,-0.00010282,5.72E-07,-0.72329,-2.79E-05,0.056906,-0.040321,-0.41508},
      {2.25E-08,-5.35E-05,0.046949,-0.00014669,1.14E-06,-0.7602,-3.78E-05,0.034231,-0.024325,-0.44569},
      {2.82E-08,-6.78E-05,0.020004,-0.00019343,1.66E-06,-0.79072,-4.79E-05,0.015463,-0.011093,-0.47099},
      {6.46E-08,-8.78E-05,0.0070225,-0.00026949,5.77E-06,-0.80362,-6.20E-05,0.0074369,-0.0054843,-0.4817},
      {-0.45306,1.24E-05,-6.59E-06,-0.25177,-9.21E-05,4.42E-05,0.32146,-0.1782,0.10126,0.18447},
      {-0.42984,1.26E-05,-1.51E-05,-0.27485,-6.99E-05,1.28E-05,0.30511,-0.19455,0.07814,0.18447},
      {-0.39435,1.28E-05,-2.79E-05,-0.31028,-3.74E-05,-4.66E-05,0.28001,-0.21963,0.042655,0.18445},
      {-0.34609,1.32E-05,-4.45E-05,-0.35872,2.12E-06,-0.00015034,0.24567,-0.25395,-0.0058948,0.1844},
      {-0.28545,1.50E-05,-6.43E-05,-0.41989,4.19E-05,-0.00032044,0.20227,-0.29731,-0.067251,0.18429},
      {-0.22103,1.79E-05,-7.64E-05,-0.48417,6.09E-05,-0.00047091,0.15659,-0.34288,-0.13179,0.18415},
      {-0.15207,2.00E-05,-8.48E-05,-0.5527,7.70E-05,-0.00060342,0.10787,-0.3915,-0.20062,0.18402},
      {-0.10547,0.00010315,-0.00018609,-0.59223,0.00039362,-0.0015318,0.075226,-0.42297,-0.24597,0.18279},
      {-0.068466,0.00015761,-0.00032809,-0.62008,0.00081564,-0.0023399,0.049195,-0.44778,-0.28201,0.18152},
      {-0.038773,0.00016664,-0.00048917,-0.63995,0.0013209,-0.0027891,0.028132,-0.4678,-0.3112,0.18042},
      {-0.016548,0.00012606,-0.00065368,-0.65255,0.0019208,-0.0027008,0.012162,-0.48302,-0.33347,0.17963},
      {-0.0045337,0.00027621,-0.0011693,-0.63919,0.006359,0.0014378,0.0030659,-0.48792,-0.34437,0.17668},
      {-0.0020784,0.00028122,-0.0016625,-0.61116,0.010966,0.0057008,0.0012122,-0.48528,-0.3452,0.17359},
      {-0.0010017,0.00026766,-0.0021204,-0.57965,0.015422,0.0089054,0.00042645,-0.48149,-0.34423,0.16983},
      {-0.00040925,0.00025257,-0.0027374,-0.53139,0.022963,0.013292,2.96E-05,-0.47572,-0.34105,0.16259},
      {-0.00025896,0.0015439,-0.0050236,-0.40408,0.064726,0.037233,-0.0013133,-0.44141,-0.31837,0.12237},
      {-0.00015801,0.0015811,-0.0059368,-0.26739,0.10916,0.062549,-0.0015293,-0.40732,-0.29584,0.079505},
      {-8.15E-05,0.00078828,-0.0055598,-0.12311,0.15518,0.088671,-0.00092077,-0.37425,-0.27361,0.035066},
      {-3.41E-05,0.00080628,-0.005198,0.041739,0.1987,0.11367,-0.00081749,-0.34381,-0.25199,-0.0067294},
      {-5.78E-06,0.0015335,-0.0061762,0.11125,0.25362,0.14572,-0.0011747,-0.30623,-0.22434,-0.058993},
      {3.87E-07,0.0015322,-0.0070217,0.1635,0.29793,0.17168,-0.0011653,-0.27581,-0.20243,-0.10118},
      {-6.42E-06,0.0010841,-0.0075809,0.20209,0.33612,0.19392,-0.0008505,-0.2497,-0.18395,-0.13754},
      {-2.04E-05,0.00036952,-0.0077098,0.2282,0.37016,0.21359,-0.00033236,-0.22676,-0.16781,-0.16994},
      {-2.44E-05,0.00011386,-0.01371,0.21437,0.40282,0.23245,-0.00014783,-0.19544,-0.15178,-0.20117},
      {-2.42E-05,0.00011335,-0.020019,0.19398,0.43469,0.25084,-0.00015251,-0.16399,-0.13585,-0.23167},
      {-2.45E-05,5.42E-05,-0.025162,0.16565,0.46966,0.27101,-0.0001097,-0.13203,-0.11843,-0.26516},
      {-2.68E-05,9.94E-06,-0.029247,0.13341,0.50474,0.29126,-7.32E-05,-0.10147,-0.10093,-0.29875},
      {-1.92E-05,3.81E-05,-0.034694,0.12249,0.516,0.29778,-7.34E-05,-0.085765,-0.095305,-0.30951},
      {1.52E-06,1.05E-05,-0.038807,0.11282,0.52654,0.3039,-1.86E-05,-0.072528,-0.090109,-0.31957},
      {2.07E-05,8.61E-08,-0.042475,0.10124,0.53935,0.31131,-2.05E-06,-0.058317,-0.083721,-0.33182},
      {3.41E-05,-4.11E-06,-0.045508,0.075539,0.56587,0.32664,4.71E-06,-0.03533,-0.070475,-0.35719},
      {5.53E-05,-5.90E-06,-0.048177,0.046632,0.59582,0.34395,2.17E-05,-0.01042,-0.055505,-0.38586},
      {-0.47153,2.02E-05,-3.35E-06,-0.23003,-0.00012551,8.14E-05,0.33647,-0.16291,0.12271,0.18438},
      {-0.44895,1.96E-05,-1.19E-05,-0.2524,-0.00010017,4.58E-05,0.32061,-0.17875,0.1003,0.18438},
      {-0.41471,1.88E-05,-2.45E-05,-0.28644,-6.33E-05,-1.87E-05,0.29649,-0.20286,0.066196,0.18436},
      {-0.3686,1.79E-05,-4.10E-05,-0.33242,-1.73E-05,-0.00012638,0.26387,-0.23544,0.020095,0.18431},
      {-0.31134,1.78E-05,-6.06E-05,-0.38967,3.30E-05,-0.00029502,0.22321,-0.27602,-0.037359,0.1842},
      {-0.24098,1.99E-05,-8.30E-05,-0.46051,8.03E-05,-0.00055285,0.17287,-0.32626,-0.10849,0.18401},
      {-0.16802,0.00016765,-0.0001692,-0.53037,0.00029113,-0.0012111,0.12037,-0.37791,-0.18205,0.1832},
      {-0.11656,0.00021404,-0.00031265,-0.57422,0.00066625,-0.0018595,0.083593,-0.41376,-0.23355,0.18213},
      {-0.077235,0.0002756,-0.00047829,-0.60355,0.0011035,-0.0023016,0.055923,-0.44037,-0.27203,0.18113},
      {-0.045633,0.00029,-0.00065987,-0.62462,0.001619,-0.0024558,0.033503,-0.46187,-0.30326,0.18026},
      {-0.022716,0.00061903,-0.00096771,-0.63236,0.0033547,-0.0011824,0.016799,-0.47645,-0.32543,0.17882},
      {-0.0097062,0.001292,-0.0016118,-0.6134,0.0087989,0.0035026,0.0066625,-0.48051,-0.33616,0.17487},
      {-0.0020013,0.00035563,-0.0019042,-0.59435,0.012916,0.0070421,0.0010767,-0.48253,-0.34422,0.17189},
      {-0.00096897,0.00034696,-0.0023971,-0.5579,0.017907,0.010352,0.00032377,-0.47815,-0.34285,0.16744},
      {-0.0004222,0.00082527,-0.0035834,-0.49459,0.032133,0.018584,-0.00048262,-0.46639,-0.33561,0.15376},
      {-0.00028411,0.0023774,-0.006127,-0.36695,0.074964,0.043156,-0.0020174,-0.43111,-0.3121,0.11252},
      {-0.00017536,0.0024886,-0.0070997,-0.23477,0.11806,0.067723,-0.0022765,-0.39818,-0.29019,0.070946},
      {-8.89E-05,0.0015108,-0.0066008,-0.098108,0.16341,0.093418,-0.001512,-0.36596,-0.26854,0.027114},
      {-3.06E-05,0.0011822,-0.006071,0.039796,0.21118,0.12078,-0.0010759,-0.33325,-0.2453,-0.018786},
      {-2.34E-06,0.0018701,-0.0069399,0.10771,0.26466,0.15202,-0.0014077,-0.29696,-0.21841,-0.069658},
      {2.92E-06,0.001874,-0.0077838,0.15886,0.30751,0.17719,-0.0014228,-0.26765,-0.19722,-0.11041},
      {-4.27E-06,0.0014139,-0.0082941,0.19685,0.34509,0.19908,-0.0011013,-0.24209,-0.17907,-0.14617},
      {-1.80E-05,0.00070269,-0.0088723,0.21945,0.37882,0.21858,-0.00058756,-0.21873,-0.16309,-0.17826},
      {-2.50E-05,0.00012988,-0.014689,0.20087,0.4143,0.23907,-0.00016748,-0.18591,-0.14601,-0.21217},
      {-2.45E-05,0.00011973,-0.020929,0.18167,0.44529,0.25695,-0.00016599,-0.15518,-0.13052,-0.24184},
      {-2.46E-05,5.09E-05,-0.026029,0.15441,0.47945,0.27665,-0.00011692,-0.12386,-0.11351,-0.27455},
      {-2.72E-05,1.08E-05,-0.030304,0.12411,0.51286,0.29593,-8.54E-05,-0.094198,-0.096845,-0.30654},
      {-1.82E-05,5.13E-05,-0.036384,0.11707,0.51994,0.30004,-9.37E-05,-0.080559,-0.093299,-0.31329},
      {2.49E-06,2.62E-05,-0.040889,0.10758,0.52992,0.30584,-4.13E-05,-0.067162,-0.088378,-0.32281},
      {2.46E-05,-5.94E-07,-0.044138,0.093547,0.54522,0.3147,-1.71E-06,-0.051798,-0.080773,-0.33745},
      {3.89E-05,-5.18E-06,-0.0473,0.068712,0.57078,0.32947,5.52E-06,-0.029313,-0.068009,-0.3619},
      {6.87E-05,-6.76E-06,-0.050513,0.04424,0.59601,0.34406,2.91E-05,-0.0069635,-0.05539,-0.38604},
      {-0.49168,-0.00036664,0.00011203,-0.19473,-5.68E-05,0.00010001,0.36002,-0.13793,0.15752,0.18435},
      {-0.47846,-0.00027091,7.20E-05,-0.20937,-4.62E-05,0.00010649,0.34982,-0.14834,0.14286,0.18435},
      {-0.45839,-9.90E-05,8.57E-06,-0.23195,-1.95E-05,0.00011155,0.33413,-0.16439,0.12024,0.18436},
      {-0.42045,8.47E-06,-3.87E-05,-0.2713,3.94E-05,4.59E-05,0.30643,-0.19231,0.080802,0.18435},
      {-0.3621,4.08E-06,-6.01E-05,-0.32946,0.000115,-0.00012437,0.26514,-0.23353,0.02246,0.18427},
      {-0.28494,0.0010393,-0.00017406,-0.39678,0.00033205,-0.00043115,0.21237,-0.28337,-0.048478,0.18368},
      {-0.21001,0.0014915,-0.00031987,-0.46389,0.00062838,-0.00089802,0.15923,-0.33465,-0.12161,0.18286},
      {-0.14241,0.0013331,-0.00050746,-0.52599,0.0010241,-0.0014208,0.10897,-0.3845,-0.19287,0.18188},
      {-0.085605,0.00064723,-0.00075122,-0.57952,0.0015457,-0.0018313,0.063773,-0.43102,-0.25954,0.18086},
      {-0.050953,0.00051232,-0.00097173,-0.60409,0.0020855,-0.0017334,0.038134,-0.45638,-0.29618,0.18018},
      {-0.029416,0.0027027,-0.0017647,-0.59119,0.0076951,0.0024927,0.021201,-0.46515,-0.31311,0.1756},
      {-0.014652,0.0035546,-0.0024433,-0.57107,0.012998,0.0066294,0.0096928,-0.4701,-0.32523,0.17139},
      {-0.0054136,0.002756,-0.0027681,-0.55111,0.016982,0.0097001,0.0029159,-0.47294,-0.33455,0.16821},
      {-0.00098529,0.00070436,-0.0029191,-0.5213,0.021684,0.012558,0.00014372,-0.47258,-0.34027,0.16379},
      {-0.0004623,0.0023025,-0.0055049,-0.43319,0.049369,0.028559,-0.0017483,-0.44889,-0.32495,0.13718},
      {-0.00031317,0.0039035,-0.0080941,-0.31276,0.089839,0.051804,-0.0032962,-0.4157,-0.30264,0.098219},
      {-0.00019504,0.0040425,-0.009102,-0.18696,0.13077,0.07515,-0.003557,-0.38468,-0.28184,0.058735},
      {-0.00010066,0.0030735,-0.0086287,-0.055976,0.17412,0.099718,-0.0027833,-0.35421,-0.26122,0.016834},
      {-2.56E-05,0.0021112,-0.0076241,0.039367,0.22915,0.13111,-0.0017385,-0.31771,-0.23526,-0.036098},
      {2.97E-06,0.0024448,-0.0081967,0.10186,0.28071,0.16126,-0.0018362,-0.28333,-0.20968,-0.085139},
      {7.26E-06,0.0024199,-0.0089638,0.15183,0.32243,0.18578,-0.0018354,-0.25501,-0.1891,-0.12476},
      {-9.14E-07,0.0019263,-0.009405,0.18884,0.35901,0.2071,-0.001493,-0.23033,-0.17152,-0.15953},
      {-1.33E-05,0.0012454,-0.01124,0.20294,0.39216,0.22627,-0.0010033,-0.20547,-0.15579,-0.19107},
      {-2.16E-05,0.000488,-0.016772,0.184,0.42803,0.24697,-0.0004481,-0.17294,-0.13872,-0.22534},
      {-2.50E-05,0.00012587,-0.022374,0.16319,0.46139,0.26622,-0.00018485,-0.14172,-0.12243,-0.25726},
      {-2.47E-05,4.06E-05,-0.027431,0.13746,0.49433,0.28522,-0.00012501,-0.11133,-0.10604,-0.28881},
      {-2.79E-05,1.17E-05,-0.032,0.11008,0.52527,0.30307,-0.00010502,-0.082984,-0.090599,-0.31843},
      {-1.69E-05,7.46E-05,-0.039248,0.10885,0.52565,0.30332,-0.00012792,-0.072416,-0.090377,-0.31877},
      {3.81E-06,5.14E-05,-0.044369,0.099633,0.53475,0.30861,-7.78E-05,-0.058777,-0.085897,-0.32745},
      {3.11E-05,-1.80E-06,-0.046798,0.08214,0.55376,0.31962,-9.95E-07,-0.041983,-0.076489,-0.34562},
      {4.69E-05,-7.02E-06,-0.05016,0.058538,0.57792,0.33358,6.96E-06,-0.020204,-0.06442,-0.36874},
      {9.19E-05,-8.08E-06,-0.054327,0.040626,0.59602,0.34406,4.25E-05,-0.0015374,-0.055355,-0.38606},
      {-0.49479,-0.002428,0.00057944,-0.14157,7.24E-05,1.92E-05,0.3925,-0.099947,0.20972,0.18423},
      {-0.47639,-0.0018729,0.00053146,-0.15815,9.94E-05,3.74E-05,0.37961,-0.11184,0.1929,0.18418},
      {-0.44295,-0.00058342,0.00044511,-0.18637,0.00016584,8.59E-05,0.35645,-0.13233,0.16387,0.18406},
      {-0.40037,0.00087226,0.00030321,-0.22505,0.00027121,0.00016125,0.32543,-0.16067,0.12374,0.18391},
      {-0.35132,0.0023586,7.55E-05,-0.27354,0.00043227,0.00026962,0.28752,-0.19671,0.072807,0.18374},
      {-0.29904,0.0038266,-0.00027987,-0.33063,0.00067434,0.00041528,0.2441,-0.23999,0.011748,0.18357},
      {-0.23253,0.0043972,-0.00056312,-0.39664,0.0009804,0.00023569,0.19281,-0.29106,-0.060742,0.18304},
      {-0.16317,0.0039686,-0.00076493,-0.46106,0.0013638,-0.00017085,0.14069,-0.34299,-0.13491,0.18218},
      {-0.104,0.0030801,-0.0010222,-0.51731,0.001873,-0.00045112,0.093328,-0.39183,-0.20482,0.18128},
      {-0.060919,0.0058506,-0.0019276,-0.53502,0.0073064,0.0027769,0.052292,-0.42592,-0.25736,0.1762},
      {-0.032381,0.0069962,-0.0031844,-0.5287,0.014571,0.0074191,0.022077,-0.45168,-0.29972,0.16974},
      {-0.016806,0.0076785,-0.0039085,-0.50683,0.019484,0.010918,0.010053,-0.4574,-0.31288,0.16556},
      {-0.0069032,0.0068397,-0.004372,-0.4778,0.023754,0.013686,0.002678,-0.46045,-0.32279,0.16169},
      {-0.0019274,0.0063002,-0.0053405,-0.43434,0.034965,0.020263,-0.0018657,-0.45422,-0.32435,0.15096},
      {-0.00066636,0.0066804,-0.0087228,-0.3494,0.071326,0.041325,-0.0047802,-0.42448,-0.30816,0.11605},
      {-0.0003369,0.006382,-0.01128,-0.24356,0.10829,0.062611,-0.0053659,-0.39561,-0.29022,0.080508},
      {-0.00021029,0.0064199,-0.012241,-0.1256,0.1461,0.084198,-0.0055236,-0.36739,-0.27117,0.044022},
      {-0.00010842,0.0053569,-0.011728,-0.0016514,0.18664,0.10717,-0.0046571,-0.33945,-0.25212,0.0048389},
      {-2.88E-05,0.0057236,-0.01132,0.054501,0.24525,0.14077,-0.0044576,-0.29985,-0.22332,-0.051367},
      {1.14E-05,0.0034365,-0.010032,0.09478,0.30275,0.17401,-0.0025812,-0.26452,-0.1975,-0.10634},
      {1.37E-05,0.0031971,-0.010611,0.14233,0.34329,0.19782,-0.002426,-0.23745,-0.17776,-0.14479},
      {3.53E-06,0.0026309,-0.010967,0.17789,0.37834,0.21824,-0.0020362,-0.21405,-0.16104,-0.17805},
      {-6.15E-06,0.0020024,-0.014604,0.18092,0.40981,0.23644,-0.0015856,-0.18758,-0.14608,-0.20802},
      {-1.36E-05,0.0011777,-0.020151,0.16361,0.44398,0.25616,-0.00098539,-0.15626,-0.12992,-0.24067},
      {-2.43E-05,0.00019275,-0.02463,0.1392,0.4823,0.27827,-0.00025712,-0.12363,-0.11185,-0.27731},
      {-2.48E-05,1.73E-05,-0.029546,0.11491,0.51431,0.29672,-0.00013143,-0.094177,-0.096026,-0.30796},
      {-2.68E-05,4.34E-05,-0.035458,0.097628,0.53481,0.30856,-0.00015272,-0.071268,-0.085736,-0.32759},
      {-1.54E-05,0.00011137,-0.043746,0.097767,0.5328,0.30742,-0.00018008,-0.060925,-0.086708,-0.32564},
      {5.26E-06,8.74E-05,-0.049733,0.088947,0.54062,0.31198,-0.00013066,-0.046966,-0.082865,-0.3331},
      {3.51E-05,2.06E-05,-0.052313,0.070389,0.5603,0.32337,-3.68E-05,-0.029506,-0.073148,-0.3519},
      {5.91E-05,-9.94E-06,-0.054309,0.045149,0.58695,0.33879,9.40E-06,-0.0079291,-0.059879,-0.3774},
      {0.00012935,-9.93E-06,-0.060033,0.035787,0.59544,0.34372,6.48E-05,0.0061576,-0.055599,-0.3855},
      {-0.35009,-0.0026126,0.0033429,-0.11601,1.01E-06,0.0001298,0.3734,-0.080775,0.22932,0.1827},
      {-0.34294,-0.0016721,0.0029636,-0.12713,4.34E-05,0.000184,0.36408,-0.089144,0.21811,0.1827},
      {-0.33244,-0.00016005,0.0023254,-0.14454,0.00012166,0.0002578,0.34973,-0.1023,0.20058,0.18271},
      {-0.31882,0.0020649,0.0013354,-0.16905,0.0002578,0.00034121,0.33002,-0.12096,0.17589,0.18277},
      {-0.27651,0.0027411,0.0010745,-0.21727,0.00040729,0.00046246,0.29341,-0.15718,0.12479,0.18265},
      {-0.23097,0.0034635,0.00068983,-0.27372,0.00064058,0.00061872,0.25147,-0.20046,0.063816,0.18253},
      {-0.18568,0.0043982,0.00011663,-0.33622,0.00099227,0.00081013,0.20613,-0.24975,-0.0054569,0.18241},
      {-0.14557,0.008705,-0.0007975,-0.39271,0.0024352,0.0015994,0.15884,-0.29838,-0.074225,0.18132},
      {-0.10269,0.015549,-0.0017502,-0.42715,0.0062089,0.0035421,0.11079,-0.33809,-0.13269,0.17769},
      {-0.060001,0.018035,-0.0026395,-0.44428,0.011447,0.0064645,0.06819,-0.37352,-0.1871,0.17261},
      {-0.029598,0.017919,-0.0039198,-0.44338,0.018193,0.010452,0.033895,-0.40615,-0.23895,0.16639},
      {-0.01283,0.015376,-0.0057245,-0.41299,0.026392,0.015231,0.0093969,-0.43466,-0.28697,0.15888},
      {-0.0048872,0.013786,-0.0070637,-0.36885,0.033907,0.019641,-0.001848,-0.44473,-0.30925,0.15189},
      {-0.002555,0.02142,-0.010053,-0.30419,0.063759,0.036942,-0.01137,-0.41567,-0.29093,0.12313},
      {-0.0010956,0.021951,-0.012832,-0.23221,0.094859,0.054978,-0.014637,-0.39063,-0.27776,0.093255},
      {-0.00038682,0.01598,-0.015366,-0.15181,0.12748,0.073887,-0.012169,-0.36916,-0.26932,0.061988},
      {-0.00021375,0.0097202,-0.016836,-0.053847,0.16166,0.093543,-0.0082781,-0.34785,-0.25926,0.029137},
      {-0.000104,0.010654,-0.016922,0.027943,0.20703,0.11939,-0.0086098,-0.3154,-0.23623,-0.014549},
      {-1.89E-05,0.011447,-0.016485,0.07045,0.26259,0.15126,-0.008729,-0.27749,-0.20851,-0.067854},
      {2.64E-05,0.0092191,-0.01528,0.10559,0.31616,0.18218,-0.0069131,-0.24439,-0.18457,-0.11908},
      {2.32E-05,0.0045407,-0.012991,0.13149,0.36923,0.21284,-0.0034468,-0.21505,-0.16329,-0.16966},
      {8.73E-06,0.0035273,-0.013231,0.16272,0.40313,0.23255,-0.0027356,-0.19288,-0.14762,-0.20179},
      {4.39E-06,0.0029639,-0.019187,0.15392,0.43124,0.24878,-0.0023318,-0.1651,-0.13423,-0.22861},
      {-2.04E-06,0.0020174,-0.024858,0.13866,0.46337,0.2673,-0.0016495,-0.13513,-0.1192,-0.25931},
      {-1.17E-05,0.00091735,-0.029468,0.11618,0.49979,0.2883,-0.00084351,-0.10373,-0.10219,-0.29414},
      {-2.62E-05,1.86E-05,-0.03294,0.089337,0.53733,0.30997,-0.00016984,-0.073017,-0.084428,-0.33004},
      {-2.57E-05,0.00010188,-0.041024,0.08336,0.54439,0.31405,-0.00022898,-0.056512,-0.080809,-0.3368},
      {-1.42E-05,0.0001642,-0.05053,0.083987,0.54064,0.31192,-0.00025409,-0.045691,-0.082659,-0.33317},
      {6.50E-06,0.00013373,-0.057656,0.075704,0.54675,0.31548,-0.00020171,-0.031339,-0.079677,-0.33899},
      {3.63E-05,5.94E-05,-0.061308,0.057727,0.56474,0.3259,-0.00010416,-0.013562,-0.070811,-0.35618},
      {7.51E-05,-1.17E-05,-0.060435,0.029308,0.59653,0.3443,7.45E-06,0.0075336,-0.05505,-0.38658},
      {0.00018687,-1.23E-05,-0.068169,0.029825,0.59362,0.34266,0.00010035,0.016433,-0.056439,-0.38377},
      {-0.14825,-0.016016,0.010729,-0.083831,-0.0011353,0.00071843,0.33955,-0.052809,0.25193,0.18009},
      {-0.14482,-0.015209,0.010231,-0.095713,-0.0010849,0.00076449,0.33038,-0.061871,0.24001,0.18014},
      {-0.13965,-0.013879,0.0094146,-0.11413,-0.00099147,0.00082665,0.3164,-0.075978,0.22152,0.18024},
      {-0.13273,-0.011865,0.0081885,-0.13976,-0.00082994,0.00089561,0.29737,-0.095745,0.19578,0.18039},
      {-0.12477,-0.0084454,0.0064196,-0.17123,-0.00053605,0.0010147,0.27326,-0.12041,0.16406,0.18053},
      {-0.11696,-0.0013012,0.0039701,-0.20155,0.00010507,0.0013888,0.24366,-0.14549,0.13271,0.18033},
      {-0.095486,0.0058315,0.0020935,-0.24204,0.0013,0.0021053,0.20387,-0.18045,0.085627,0.17949},
      {-0.065559,0.012296,0.0010342,-0.2888,0.0035942,0.0034681,0.15637,-0.22476,0.022586,0.17751},
      {-0.041518,0.020995,-0.00041825,-0.33193,0.0071739,0.0053666,0.10908,-0.27167,-0.044376,0.17467},
      {-0.02518,0.032255,-0.002352,-0.36723,0.012232,0.0078467,0.064421,-0.32037,-0.11421,0.17088},
      {-0.003206,0.033465,-0.0040359,-0.36512,0.018677,0.011414,0.028761,-0.35919,-0.1742,0.16505},
      {0.0081227,0.033017,-0.006316,-0.32718,0.030028,0.017937,0.0027118,-0.38315,-0.21841,0.15433},
      {0.0031166,0.041228,-0.010561,-0.25198,0.057448,0.033631,-0.017968,-0.37974,-0.23575,0.12826},
      {-0.0023161,0.046624,-0.015223,-0.16536,0.089864,0.052113,-0.029189,-0.37176,-0.24966,0.097733},
      {-0.00083423,0.046047,-0.017369,-0.10679,0.11565,0.067101,-0.031703,-0.35224,-0.24048,0.072953},
      {-6.34E-05,0.039318,-0.019327,-0.038791,0.14343,0.083232,-0.028777,-0.33566,-0.23549,0.046325},
      {5.49E-05,0.028648,-0.021548,0.025068,0.17711,0.10271,-0.021912,-0.3173,-0.231,0.014116},
      {-7.82E-05,0.019311,-0.023908,0.049875,0.22905,0.13262,-0.014927,-0.28524,-0.21615,-0.035529},
      {2.01E-05,0.019761,-0.023582,0.087179,0.27987,0.16174,-0.014875,-0.25036,-0.19101,-0.084359},
      {6.62E-05,0.017219,-0.022341,0.11722,0.32937,0.19019,-0.012831,-0.22006,-0.16942,-0.13171},
      {6.45E-05,0.012298,-0.020018,0.13858,0.37881,0.21866,-0.0091861,-0.19317,-0.1502,-0.17884},
      {2.95E-05,0.0059544,-0.019915,0.13265,0.42574,0.24561,-0.0045612,-0.16546,-0.1336,-0.22353},
      {1.95E-05,0.0040726,-0.02536,0.123,0.45553,0.26274,-0.0032074,-0.13819,-0.12075,-0.25196},
      {1.45E-05,0.0029325,-0.031313,0.11014,0.48534,0.2799,-0.0023938,-0.10958,-0.10706,-0.28046},
      {6.01E-06,0.0016567,-0.036183,0.089942,0.5196,0.29962,-0.0014687,-0.079451,-0.091294,-0.31323},
      {-1.02E-05,0.0007453,-0.040596,0.067467,0.55344,0.31916,-0.00080387,-0.050006,-0.075359,-0.34558},
      {-2.56E-05,0.00018636,-0.049457,0.066651,0.55395,0.31953,-0.00033642,-0.037687,-0.075844,-0.34598},
      {-1.38E-05,0.00023229,-0.060497,0.067922,0.54793,0.31608,-0.00035208,-0.026315,-0.078844,-0.34019},
      {7.05E-06,0.00018613,-0.069045,0.060328,0.55186,0.31838,-0.00029062,-0.011511,-0.076972,-0.34392},
      {3.70E-05,9.64E-05,-0.074026,0.04308,0.56772,0.32758,-0.00018406,0.0066298,-0.069184,-0.35907},
      {9.73E-05,1.31E-05,-0.075836,0.021761,0.59011,0.34056,-4.54E-05,0.024881,-0.05812,-0.38046},
      {0.00027226,-1.54E-05,-0.079431,0.022959,0.58965,0.34036,0.00015483,0.029628,-0.058326,-0.37997},
      {0.015401,-0.035796,0.042333,-0.056741,-0.0036828,0.0022958,0.27526,-0.011692,0.24461,0.17655},
      {0.019139,-0.036011,0.038277,-0.060766,-0.0037298,0.0023841,0.27015,-0.017508,0.24441,0.17655},
      {0.025668,-0.036402,0.031867,-0.066731,-0.0038109,0.0025332,0.26212,-0.026425,0.24447,0.17652},
      {0.036073,-0.037067,0.022696,-0.074548,-0.0039417,0.0027637,0.25069,-0.038687,0.24523,0.17641},
      {0.04167,-0.033841,0.016959,-0.09558,-0.0036944,0.0030667,0.22919,-0.058833,0.22775,0.17629},
      {0.043441,-0.026228,0.014082,-0.12782,-0.0029485,0.0034266,0.19909,-0.085986,0.1944,0.17614},
      {0.046906,-0.015832,0.010506,-0.16441,-0.0018214,0.0038426,0.16452,-0.11758,0.15599,0.17592},
      {0.051819,-0.002697,0.0060508,-0.20377,-0.00049655,0.0045208,0.12586,-0.15324,0.11309,0.1752},
      {0.061773,0.0078519,0.0028839,-0.24278,0.0023618,0.0062758,0.0823,-0.19804,0.05268,0.17257},
      {0.069055,0.017558,0.00062434,-0.27271,0.0074422,0.0089669,0.039893,-0.24932,-0.020944,0.16838},
      {0.046699,0.041015,-0.003011,-0.26892,0.019818,0.014885,0.0035363,-0.28208,-0.073351,0.15858},
      {0.024218,0.070765,-0.0074502,-0.24263,0.038253,0.023693,-0.030962,-0.30595,-0.11744,0.144},
      {0.018138,0.075864,-0.011227,-0.17595,0.062503,0.037619,-0.04928,-0.30886,-0.14112,0.12099},
      {0.011184,0.078471,-0.015625,-0.095339,0.091857,0.054339,-0.058778,-0.30885,-0.16391,0.093498},
      {0.0036136,0.078195,-0.02059,-0.0021236,0.12479,0.0729,-0.058638,-0.30767,-0.18724,0.063067},
      {0.00068749,0.073176,-0.024208,0.061249,0.15393,0.089498,-0.053657,-0.29743,-0.19426,0.035754},
      {0.0003337,0.06761,-0.027736,0.072857,0.19079,0.11072,-0.049779,-0.27124,-0.18338,0.00055488},
      {0.00020823,0.05473,-0.030516,0.089805,0.23792,0.13792,-0.040375,-0.24431,-0.17446,-0.044543},
      {0.00012341,0.034944,-0.032463,0.10684,0.29245,0.16937,-0.02593,-0.21853,-0.16869,-0.096562},
      {0.00013929,0.027511,-0.03163,0.12952,0.3398,0.19653,-0.020397,-0.1925,-0.15325,-0.14178},
      {0.00013532,0.022058,-0.031118,0.13897,0.38225,0.22083,-0.016377,-0.16791,-0.13803,-0.18224},
      {0.00010622,0.015501,-0.034743,0.12026,0.42265,0.2439,-0.011591,-0.13925,-0.12485,-0.22078},
      {6.01E-05,0.0077412,-0.036207,0.096323,0.47158,0.27193,-0.0059729,-0.10848,-0.10861,-0.26749},
      {3.75E-05,0.0037831,-0.040144,0.079545,0.50874,0.29327,-0.003128,-0.079617,-0.094184,-0.30301},
      {3.03E-05,0.0025879,-0.046652,0.064817,0.53759,0.30986,-0.0022928,-0.050886,-0.080977,-0.3306},
      {1.51E-05,0.0017352,-0.056169,0.055881,0.5511,0.31768,-0.0016719,-0.028576,-0.075162,-0.34346},
      {-3.12E-06,0.0009619,-0.067368,0.055249,0.54878,0.31644,-0.0010417,-0.015142,-0.077311,-0.34114},
      {-1.49E-05,0.00030867,-0.074837,0.050264,0.55287,0.31888,-0.00047249,-0.0023933,-0.076172,-0.34496},
      {6.31E-06,0.00023429,-0.085084,0.043511,0.55412,0.31964,-0.00039337,0.012903,-0.075665,-0.34613},
      {3.65E-05,0.0001184,-0.091641,0.027139,0.56742,0.32736,-0.00027049,0.031441,-0.069187,-0.35883},
      {0.0001297,2.19E-05,-0.098502,0.018255,0.57287,0.33057,-8.58E-05,0.04487,-0.066591,-0.364},
      {0.0003013,-1.29E-05,-0.10398,0.018333,0.57096,0.32954,0.00012859,0.051225,-0.067556,-0.36211},
      {0.1214,-0.062877,0.094854,-0.028715,-0.0077194,0.0044012,0.18897,0.044921,0.21803,0.17303},
      {0.12557,-0.063383,0.089507,-0.032673,-0.0079261,0.0046067,0.18369,0.038206,0.21903,0.1728},
      {0.13237,-0.064297,0.081065,-0.03856,-0.0083494,0.0049906,0.17549,0.027852,0.22088,0.17233},
      {0.14257,-0.065811,0.06945,-0.04625,-0.0089972,0.0055581,0.16373,0.013871,0.22377,0.17159},
      {0.15696,-0.068186,0.054524,-0.055473,-0.0099452,0.0063568,0.14785,-0.0036685,0.228,0.1705},
      {0.17626,-0.071746,0.036216,-0.065844,-0.011293,0.007447,0.12733,-0.024578,0.23393,0.16895},
      {0.18897,-0.069635,0.022187,-0.087906,-0.011942,0.0086092,0.098843,-0.052565,0.22097,0.16733},
      {0.17346,-0.054101,0.017189,-0.12293,-0.010159,0.009338,0.067986,-0.086495,0.18118,0.16637},
      {0.14793,-0.033662,0.011534,-0.15162,-0.0069882,0.01017,0.038228,-0.11755,0.14586,0.16513},
      {0.12453,-0.0097573,0.0052054,-0.17406,-0.0026036,0.011321,0.0055346,-0.14604,0.11446,0.16332},
      {0.098186,0.016016,0.0010556,-0.1718,0.010193,0.017204,-0.028377,-0.17976,0.062017,0.15369},
      {0.070559,0.050753,-0.0036152,-0.15287,0.028723,0.025463,-0.062044,-0.21024,0.010313,0.14018},
      {0.042506,0.095578,-0.0090501,-0.11798,0.052545,0.035562,-0.094272,-0.23611,-0.037106,0.12369},
      {0.026498,0.11563,-0.013937,-0.0527,0.080618,0.049795,-0.10895,-0.24766,-0.071407,0.10044},
      {0.015591,0.11816,-0.020106,0.017963,0.11154,0.066945,-0.10698,-0.24765,-0.097768,0.07216},
      {0.0057998,0.12218,-0.028339,0.072788,0.14736,0.086663,-0.099314,-0.23889,-0.11801,0.039628},
      {0.00062922,0.11872,-0.036492,0.11739,0.18734,0.10892,-0.086664,-0.22406,-0.13168,0.0030297},
      {0.00049924,0.10359,-0.038977,0.12854,0.22936,0.13315,-0.075692,-0.20263,-0.12759,-0.037091},
      {0.00040138,0.081916,-0.040727,0.13955,0.27865,0.16155,-0.059955,-0.18201,-0.12634,-0.084027},
      {0.00030525,0.05368,-0.042845,0.1452,0.33256,0.19252,-0.039459,-0.16242,-0.1293,-0.13522},
      {0.00024015,0.033842,-0.050924,0.12769,0.37237,0.21515,-0.025037,-0.1377,-0.13027,-0.17306},
      {0.00021375,0.026961,-0.055953,0.10934,0.41122,0.23725,-0.020031,-0.10834,-0.11818,-0.21013},
      {0.00017025,0.018885,-0.058616,0.085932,0.45855,0.2643,-0.014194,-0.0772,-0.10303,-0.25532},
      {0.00010947,0.009528,-0.058646,0.059822,0.51232,0.29514,-0.0074649,-0.046159,-0.085939,-0.30668},
      {6.57E-05,0.0036408,-0.062768,0.041386,0.5514,0.31763,-0.0032834,-0.01706,-0.072471,-0.344},
      {4.69E-05,0.0027648,-0.080691,0.045026,0.53945,0.31082,-0.0026253,-0.00094392,-0.079469,-0.33245},
      {2.95E-05,0.0018592,-0.094852,0.044063,0.53439,0.30799,-0.0019056,0.014643,-0.083125,-0.3275},
      {1.42E-05,0.00099155,-0.10393,0.037902,0.538,0.31017,-0.0011717,0.029139,-0.082477,-0.33085},
      {3.59E-06,0.00025903,-0.10727,0.026239,0.55111,0.31784,-0.00050042,0.042293,-0.076991,-0.3433},
      {3.63E-05,0.0001059,-0.11608,0.011919,0.55998,0.323,-0.00034972,0.060855,-0.072772,-0.35175},
      {0.00014823,-7.22E-06,-0.12945,0.014251,0.54793,0.31613,-0.00011729,0.071095,-0.078953,-0.34015},
      {0.00029759,-5.06E-06,-0.13969,0.014068,0.54111,0.31227,6.43E-05,0.080701,-0.082377,-0.33355},
      {0.15004,-0.077743,0.21597,-0.017716,-0.012358,0.0068442,0.10024,0.13814,0.10532,0.1687},
      {0.15764,-0.081929,0.19705,-0.018791,-0.013328,0.0074562,0.09765,0.12392,0.12262,0.1678},
      {0.16919,-0.088497,0.16824,-0.020359,-0.01487,0.008422,0.093282,0.10233,0.14897,0.16636},
      {0.18484,-0.097819,0.12907,-0.022359,-0.017093,0.009801,0.086527,0.073058,0.18483,0.16425},
      {0.18938,-0.1009,0.10735,-0.028716,-0.018253,0.010669,0.075864,0.052759,0.19865,0.16294},
      {0.19165,-0.10282,0.087859,-0.036376,-0.019378,0.0116,0.061928,0.032937,0.20851,0.16152},
      {0.19493,-0.1057,0.064903,-0.043885,-0.020953,0.012869,0.044678,0.010628,0.22138,0.15955},
      {0.19927,-0.10982,0.038476,-0.05066,-0.02312,0.014567,0.023899,-0.013776,0.23774,0.15686},
      {0.18571,-0.096995,0.02428,-0.06904,-0.02142,0.015906,-0.0031165,-0.042139,0.22312,0.1548},
      {0.16288,-0.071561,0.017576,-0.090089,-0.016422,0.017098,-0.03454,-0.070556,0.19244,0.15297},
      {0.14158,-0.042664,0.010201,-0.10492,-0.010253,0.018608,-0.068627,-0.096478,0.16575,0.15058},
      {0.11825,-0.0077916,0.003248,-0.10215,0.0019228,0.022961,-0.10281,-0.1226,0.13232,0.14354},
      {0.085628,0.042959,-0.0026647,-0.07005,0.026775,0.032756,-0.13196,-0.15118,0.08081,0.12743},
      {0.047565,0.11441,-0.010869,-0.036287,0.055537,0.042589,-0.1577,-0.17314,0.034396,0.11077},
      {0.019657,0.17929,-0.020423,0.0092107,0.08509,0.053834,-0.17349,-0.18544,-0.0022585,0.092109},
      {0.01104,0.1791,-0.028598,0.065542,0.11927,0.072729,-0.16091,-0.18107,-0.027806,0.060982},
      {0.0050532,0.17389,-0.037574,0.11546,0.15816,0.094052,-0.14374,-0.17287,-0.051222,0.026171},
      {0.0013456,0.16293,-0.047408,0.15823,0.20065,0.11716,-0.12194,-0.16194,-0.073634,-0.01131},
      {0.00069594,0.13949,-0.052025,0.16875,0.24438,0.1419,-0.10174,-0.14748,-0.083363,-0.052066},
      {0.00055384,0.1074,-0.061683,0.15155,0.28398,0.16428,-0.078263,-0.12998,-0.09755,-0.089546},
      {0.00043905,0.073333,-0.073199,0.12795,0.3332,0.19232,-0.053586,-0.10425,-0.10857,-0.1362},
      {0.00035907,0.040691,-0.085901,0.1003,0.38915,0.22429,-0.030153,-0.07073,-0.11433,-0.18937},
      {0.00031817,0.03237,-0.090308,0.07809,0.43458,0.2502,-0.024165,-0.038602,-0.10034,-0.23274},
      {0.00026413,0.022888,-0.093704,0.057061,0.48196,0.27738,-0.017405,-0.0073406,-0.086474,-0.27791},
      {0.00016738,0.011805,-0.104,0.043403,0.50553,0.29094,-0.0094381,0.015544,-0.086271,-0.30034},
      {8.59E-05,0.0037209,-0.11669,0.033491,0.51792,0.29822,-0.0035985,0.03599,-0.088667,-0.31198},
      {6.90E-05,0.0026598,-0.13401,0.032301,0.50979,0.29362,-0.0027705,0.053765,-0.094017,-0.3041},
      {5.40E-05,0.0016521,-0.14597,0.025974,0.51058,0.29417,-0.0019393,0.070232,-0.094924,-0.30475},
      {4.16E-05,0.00076112,-0.15131,0.01395,0.52197,0.30085,-0.0011492,0.084862,-0.090486,-0.31554},
      {4.70E-05,7.98E-05,-0.15568,0.0077734,0.52691,0.30385,-0.0004169,0.093612,-0.089154,-0.32014},
      {0.00013746,-1.04E-05,-0.17336,0.0098097,0.51054,0.29451,-0.00018826,0.10684,-0.097547,-0.30438},
      {0.00026977,6.49E-06,-0.18696,0.0098065,0.49989,0.28844,-2.01E-05,0.11847,-0.10291,-0.29411},
      {0.081166,-0.067985,0.36566,-0.0085377,-0.010147,0.0050615,0.060639,0.25089,-0.032689,0.17159},
      {0.08894,-0.072958,0.34668,-0.0094005,-0.011337,0.0057887,0.056741,0.23677,-0.015299,0.17045},
      {0.10073,-0.080746,0.31763,-0.01067,-0.013205,0.0069271,0.050485,0.21521,0.011328,0.16864},
      {0.11663,-0.091761,0.27787,-0.01231,-0.015859,0.0085353,0.041361,0.18574,0.047812,0.16607},
      {0.1365,-0.10643,0.22707,-0.014239,-0.019405,0.010671,0.028802,0.14821,0.09446,0.16261},
      {0.15997,-0.12522,0.16515,-0.016347,-0.02396,0.013396,0.012192,0.10262,0.15139,0.15815},
      {0.17152,-0.135,0.12598,-0.021085,-0.027052,0.015506,-0.0064282,0.070869,0.18265,0.15476},
      {0.1769,-0.14012,0.098046,-0.02663,-0.029672,0.017528,-0.027366,0.046194,0.20133,0.15156},
      {0.18271,-0.14676,0.066315,-0.031293,-0.033132,0.02013,-0.051712,0.019283,0.22383,0.14741},
      {0.18713,-0.15313,0.032282,-0.035377,-0.037024,0.023308,-0.079599,-0.0094976,0.24755,0.14232},
      {0.15927,-0.11391,0.025566,-0.04885,-0.028896,0.0239,-0.11105,-0.03458,0.21978,0.14065},
      {0.1281,-0.061484,0.01697,-0.057328,-0.019035,0.024361,-0.14391,-0.058428,0.19473,0.13882},
      {0.099255,0.0010905,0.0050817,-0.057284,-0.0091786,0.025507,-0.17632,-0.080754,0.17496,0.13585},
      {0.06708,0.072498,-0.0043011,-0.023053,0.016584,0.034119,-0.19606,-0.10286,0.13204,0.12134},
      {0.039014,0.14723,-0.014315,0.02046,0.046079,0.043907,-0.21166,-0.11923,0.092102,0.10546},
      {0.016077,0.22445,-0.025636,0.068558,0.076703,0.05353,-0.22516,-0.12925,0.060064,0.090405},
      {0.0068036,0.24099,-0.035443,0.11638,0.11329,0.071216,-0.21356,-0.12758,0.032789,0.062017},
      {0.003618,0.22355,-0.04794,0.1489,0.1497,0.090053,-0.18508,-0.12308,-0.00057286,0.030848},
      {0.0016776,0.19954,-0.066452,0.1653,0.18091,0.10564,-0.15255,-0.1156,-0.038638,0.0053057},
      {0.0007848,0.17116,-0.083973,0.16304,0.21645,0.12487,-0.124,-0.09901,-0.065474,-0.025777},
      {0.00066328,0.13653,-0.096136,0.13715,0.26662,0.15344,-0.098921,-0.072148,-0.07665,-0.07327},
      {0.00057313,0.097423,-0.11159,0.10828,0.32567,0.18721,-0.070872,-0.03725,-0.087469,-0.12931},
      {0.00051884,0.054072,-0.13254,0.081402,0.38777,0.22285,-0.040093,0.0049189,-0.10049,-0.18827},
      {0.00042591,0.035382,-0.14963,0.066444,0.41349,0.23744,-0.026762,0.033613,-0.10679,-0.2128},
      {0.00031464,0.023273,-0.16498,0.052867,0.42994,0.24686,-0.018035,0.057814,-0.11125,-0.22844},
      {0.0002113,0.012803,-0.178,0.037292,0.44917,0.25809,-0.010475,0.081738,-0.11274,-0.2466},
      {0.00011847,0.0035759,-0.18864,0.021241,0.46986,0.27035,-0.0038008,0.10415,-0.1123,-0.26605},
      {0.00010042,0.0020767,-0.20313,0.014298,0.46894,0.26993,-0.0026189,0.12261,-0.11459,-0.26504},
      {8.83E-05,0.0010528,-0.21303,0.006214,0.47132,0.27142,-0.0017058,0.13719,-0.11483,-0.2672},
      {9.03E-05,0.00037365,-0.22352,0.0065781,0.46307,0.26685,-0.00091566,0.14516,-0.12018,-0.25915},
      {0.00010821,8.34E-05,-0.23414,0.0061179,0.45572,0.2628,-0.0003813,0.15423,-0.12471,-0.25194},
      {0.00020942,2.01E-05,-0.24816,0.0058303,0.44461,0.2565,-0.00012524,0.16597,-0.13051,-0.2412},
      {0.036591,-0.048991,0.51665,-0.0038567,-0.005748,0.0023513,0.023867,0.36171,-0.17431,0.17707},
      {0.040054,-0.053144,0.50786,-0.0039856,-0.0062018,0.0025922,0.022119,0.3553,-0.16597,0.1766},
      {0.045327,-0.059522,0.49475,-0.0041752,-0.0068868,0.0029496,0.019233,0.34575,-0.15354,0.17588},
      {0.060127,-0.072115,0.45561,-0.0053938,-0.0098273,0.0046964,0.0085576,0.317,-0.11751,0.17298},
      {0.07936,-0.089184,0.40311,-0.0069417,-0.013922,0.0071283,-0.0063966,0.27852,-0.069193,0.16894},
      {0.10201,-0.1109,0.33871,-0.0086606,-0.019114,0.0102,-0.025588,0.23143,-0.009874,0.16381},
      {0.12184,-0.13456,0.26494,-0.010389,-0.02515,0.01356,-0.04658,0.17763,0.05799,0.15761},
      {0.14105,-0.16074,0.18343,-0.012011,-0.031931,0.017172,-0.070947,0.11836,0.13291,0.15047},
      {0.14157,-0.1601,0.1491,-0.015563,-0.035542,0.019551,-0.08882,0.090214,0.15795,0.1456},
      {0.1413,-0.15651,0.11162,-0.018356,-0.039806,0.022434,-0.10895,0.05998,0.18536,0.13982},
      {0.14058,-0.15206,0.068085,-0.019917,-0.044859,0.025869,-0.13328,0.025872,0.21836,0.13305},
      {0.12517,-0.11617,0.040834,-0.021452,-0.041823,0.028049,-0.16127,-0.0035336,0.22242,0.12845},
      {0.099147,-0.050892,0.027472,-0.018443,-0.03134,0.028926,-0.19223,-0.026494,0.20432,0.12625},
      {0.073907,0.021981,0.011252,-0.0078442,-0.019866,0.029689,-0.22633,-0.048598,0.19091,0.12448},
      {0.049818,0.099441,-0.0037426,0.02181,0.00054173,0.034198,-0.25137,-0.067376,0.16842,0.11725},
      {0.029238,0.17703,-0.015805,0.06766,0.031085,0.042436,-0.26015,-0.079285,0.13393,0.10394},
      {0.013544,0.25189,-0.032614,0.10259,0.057596,0.045453,-0.25998,-0.08944,0.09773,0.09702},
      {0.0045806,0.29147,-0.050204,0.13057,0.083873,0.052476,-0.24845,-0.093451,0.063092,0.086862},
      {0.0027761,0.26755,-0.069073,0.14503,0.11661,0.068937,-0.21529,-0.085387,0.024786,0.060486},
      {0.0015647,0.24161,-0.092402,0.15186,0.14828,0.085501,-0.18355,-0.069169,-0.010542,0.035039},
      {0.0008695,0.2077,-0.12126,0.15343,0.18102,0.10349,-0.14963,-0.045047,-0.046746,0.0080048},
      {0.00077796,0.16289,-0.13828,0.12783,0.24043,0.1375,-0.11755,-0.011812,-0.063151,-0.048224},
      {0.00066088,0.11091,-0.17054,0.10434,0.28515,0.16249,-0.080578,0.028188,-0.093386,-0.09118},
      {0.00056148,0.062222,-0.21162,0.081078,0.31771,0.1811,-0.046135,0.074281,-0.1263,-0.1221},
      {0.00046717,0.033762,-0.24318,0.060339,0.33991,0.19417,-0.02599,0.11373,-0.14425,-0.14287},
      {0.00035718,0.022945,-0.25815,0.041616,0.36012,0.20597,-0.018169,0.14083,-0.14565,-0.16197},
      {0.00025822,0.013281,-0.27066,0.022892,0.38151,0.21862,-0.011171,0.16602,-0.14535,-0.18208},
      {0.00017183,0.0043952,-0.28073,0.0060385,0.40219,0.23102,-0.0047237,0.18778,-0.14465,-0.20144},
      {0.00012483,0.0010877,-0.29432,0.0050226,0.39427,0.22676,-0.0020798,0.1983,-0.15263,-0.19359},
      {0.00010891,0.00079471,-0.3062,0.005394,0.38417,0.22115,-0.0014911,0.20706,-0.15868,-0.18373},
      {0.00011719,0.00048212,-0.31591,0.0047054,0.3775,0.21751,-0.00091547,0.21525,-0.16296,-0.17716},
      {0.00014715,0.00016437,-0.32602,0.0029974,0.37146,0.21422,-0.0003781,0.22458,-0.16681,-0.17121},
      {0.0080587,-0.025822,0.62201,-0.0021294,-0.0032893,0.0010337,6.54E-06,0.43788,-0.27448,0.18037},
      {0.010354,-0.029294,0.61365,-0.0022548,-0.0037427,0.0012114,-0.00097459,0.43182,-0.26666,0.17983},
      {0.013735,-0.034499,0.60117,-0.0024419,-0.0044411,0.0014786,-0.0024998,0.42276,-0.25498,0.179},
      {0.018106,-0.041402,0.58469,-0.002688,-0.0054048,0.0018347,-0.0046321,0.4108,-0.23961,0.17785},
      {0.023257,-0.049823,0.5647,-0.0029839,-0.0066451,0.0022717,-0.0074251,0.3963,-0.22102,0.17635},
      {0.034364,-0.063895,0.52203,-0.0037504,-0.010149,0.0039986,-0.016779,0.36529,-0.18181,0.17252},
      {0.052636,-0.085213,0.44997,-0.0049935,-0.016786,0.0075146,-0.03542,0.31299,-0.11595,0.16544},
      {0.0714,-0.10885,0.37088,-0.0061072,-0.024545,0.011545,-0.057521,0.2557,-0.043863,0.1571},
      {0.089734,-0.13435,0.28648,-0.0069683,-0.033442,0.016068,-0.083133,0.19472,0.032795,0.14744},
      {0.10054,-0.14873,0.21654,-0.007802,-0.041297,0.020365,-0.10928,0.14327,0.093704,0.13839},
      {0.10118,-0.14415,0.16868,-0.0082091,-0.046836,0.024182,-0.13474,0.1064,0.13093,0.13115},
      {0.10126,-0.13897,0.11433,-0.0072194,-0.053404,0.028674,-0.16424,0.065263,0.17395,0.12274},
      {0.097363,-0.12354,0.060205,-0.0035964,-0.058215,0.033178,-0.19733,0.023264,0.21339,0.11435},
      {0.074281,-0.043926,0.043127,0.0093023,-0.045402,0.031401,-0.22803,0.0014318,0.19954,0.1133},
      {0.052396,0.048994,0.020883,0.02425,-0.030918,0.025855,-0.257,-0.020153,0.18729,0.1139},
      {0.033772,0.14585,-0.0090327,0.042967,-0.015474,0.021592,-0.28597,-0.043316,0.18036,0.11687},
      {0.020105,0.22018,-0.026018,0.076565,0.011338,0.024871,-0.28451,-0.053822,0.14501,0.11214},
      {0.0099829,0.28692,-0.04447,0.10648,0.034261,0.028048,-0.28235,-0.060942,0.11441,0.11175},
      {0.0032362,0.3425,-0.064869,0.13356,0.05357,0.031656,-0.27774,-0.065048,0.086612,0.1146},
      {0.002061,0.31187,-0.090147,0.14445,0.087882,0.04947,-0.24058,-0.051432,0.044106,0.087831},
      {0.0014034,0.27201,-0.1214,0.14764,0.12133,0.067604,-0.20226,-0.027962,0.0020338,0.060335},
      {0.00095142,0.21606,-0.17121,0.14426,0.14345,0.07849,-0.15663,0.0090254,-0.053825,0.041128},
      {0.0007219,0.16154,-0.21561,0.12355,0.17798,0.097937,-0.11634,0.054294,-0.094752,0.0090419},
      {0.00061654,0.11244,-0.25824,0.095316,0.2138,0.11844,-0.081609,0.10456,-0.12649,-0.024967},
      {0.00054776,0.068014,-0.30769,0.067168,0.24029,0.13448,-0.050369,0.16087,-0.15824,-0.049373},
      {0.0005014,0.032482,-0.35705,0.040454,0.25844,0.14631,-0.025483,0.21722,-0.18535,-0.065376},
      {0.00039588,0.022662,-0.37083,0.018551,0.28143,0.15991,-0.01836,0.24519,-0.18446,-0.087006},
      {0.00026855,0.012582,-0.3772,0.011759,0.29333,0.16723,-0.010885,0.25437,-0.18964,-0.098002},
      {0.00015487,0.0049958,-0.38681,0.006818,0.2984,0.1709,-0.0050995,0.26482,-0.19594,-0.10222},
      {0.0001018,0.0012141,-0.39965,0.0042311,0.29404,0.16899,-0.002034,0.27616,-0.2029,-0.097542},
      {0.00010276,0.00087379,-0.40709,0.0032677,0.28954,0.16662,-0.0014089,0.28259,-0.20619,-0.093045},
      {0.00012515,0.00053185,-0.41535,0.0013236,0.28522,0.16433,-0.00082743,0.29044,-0.20927,-0.088736},
      {-0.0046307,-0.0041067,0.67789,-0.0016771,-0.00096981,6.20E-05,0.0026672,0.4781,-0.32766,0.18314},
      {-0.0029944,-0.0068721,0.67148,-0.0017734,-0.0014282,0.00021051,0.0015827,0.47344,-0.32174,0.18258},
      {-0.00055909,-0.011019,0.6619,-0.0019158,-0.002132,0.0004335,-9.58E-05,0.46649,-0.31291,0.18171},
      {0.0026391,-0.01652,0.64925,-0.0021003,-0.0030986,0.00072984,-0.0024281,0.45731,-0.3013,0.18051},
      {0.0064953,-0.023228,0.63396,-0.0023174,-0.0043353,0.001092,-0.0054597,0.44621,-0.2873,0.17897},
      {0.010853,-0.030887,0.61669,-0.0025514,-0.0058397,0.0015064,-0.0092233,0.43368,-0.27158,0.17707},
      {0.015527,-0.039144,0.59837,-0.0027809,-0.0076007,0.0019538,-0.013741,0.42039,-0.25503,0.17483},
      {0.027237,-0.057014,0.54331,-0.0031857,-0.013755,0.0048737,-0.031078,0.38067,-0.20525,0.16799},
      {0.042317,-0.081401,0.46432,-0.0034839,-0.023105,0.00951,-0.057602,0.32382,-0.13397,0.15773},
      {0.056358,-0.10725,0.38109,-0.0034413,-0.033615,0.014622,-0.087248,0.26406,-0.059165,0.1461},
      {0.067685,-0.13219,0.29778,-0.0030515,-0.044669,0.018734,-0.11683,0.20437,0.014801,0.13279},
      {0.067166,-0.12171,0.24254,-0.0012693,-0.050368,0.019541,-0.1421,0.16302,0.0572,0.12274},
      {0.065305,-0.1043,0.18108,0.0017617,-0.056071,0.019017,-0.17172,0.11771,0.10355,0.11142},
      {0.062506,-0.080751,0.11157,0.0061743,-0.061985,0.017017,-0.20622,0.067316,0.15558,0.098565},
      {0.047917,-0.00045464,0.073044,0.019992,-0.051479,0.012501,-0.2371,0.036633,0.16301,0.098567},
      {0.03239,0.10011,0.037557,0.038283,-0.036187,0.0083562,-0.26811,0.010422,0.16281,0.10532},
      {0.020175,0.20638,-0.0072912,0.059755,-0.020799,0.0054764,-0.30011,-0.019213,0.16906,0.11506},
      {0.01199,0.28028,-0.036193,0.088554,0.00038063,0.0077181,-0.30383,-0.03439,0.1479,0.11885},
      {0.0063878,0.32862,-0.057922,0.11683,0.020986,0.012305,-0.29448,-0.039774,0.11609,0.12152},
      {0.0030395,0.3523,-0.085148,0.13717,0.036501,0.012562,-0.27822,-0.038588,0.082123,0.12271},
      {0.0017569,0.32474,-0.12403,0.1409,0.058335,0.020894,-0.24359,-0.016399,0.036388,0.10892},
      {0.0013128,0.26932,-0.17609,0.13341,0.081989,0.03296,-0.19841,0.024954,-0.018307,0.088682},
      {0.00089808,0.21299,-0.24022,0.12146,0.099328,0.044763,-0.15429,0.078576,-0.075629,0.076617},
      {0.00059671,0.15927,-0.30565,0.099797,0.11896,0.059417,-0.11442,0.14051,-0.12543,0.062303},
      {0.00052513,0.11491,-0.35646,0.067282,0.14804,0.077014,-0.083237,0.20057,-0.15587,0.03549},
      {0.00049303,0.074007,-0.41499,0.035798,0.16685,0.089587,-0.054663,0.26642,-0.18803,0.019172},
      {0.0004419,0.033037,-0.46473,0.02361,0.17287,0.095601,-0.025945,0.31013,-0.22707,0.015582},
      {0.00029516,0.019686,-0.4691,0.016241,0.19095,0.10705,-0.01609,0.31801,-0.23283,-0.00086613},
      {0.00017644,0.011749,-0.47404,0.010272,0.20188,0.11415,-0.010018,0.32569,-0.23664,-0.010675},
      {9.86E-05,0.0054865,-0.48705,0.0053239,0.20242,0.11536,-0.0051845,0.33868,-0.24387,-0.010431},
      {6.17E-05,0.001233,-0.50536,0.0017923,0.19421,0.1115,-0.0018155,0.35456,-0.2533,-0.0018429},
      {7.87E-05,0.00086296,-0.51061,-0.00042857,0.19289,0.11095,-0.0011842,0.36019,-0.25498,-0.00039339},
      {-0.0035765,0.0019099,0.69705,-0.0019345,-4.95E-06,-0.00013409,0.0016056,0.49156,-0.34595,0.18446},
      {-0.0033375,0.0018886,0.69708,-0.0020512,-6.00E-06,-0.00013773,0.0014735,0.49152,-0.34608,0.18446},
      {-0.0029416,0.0018549,0.69716,-0.0022265,-7.63E-06,-0.00014317,0.0012507,0.49148,-0.34633,0.18445},
      {-0.0016852,0.00031804,0.69398,-0.0024134,-0.00035489,-6.34E-05,0.00012931,0.48908,-0.34364,0.184},
      {0.00083131,-0.0047788,0.68253,-0.0025148,-0.0015434,0.00017717,-0.0026534,0.4808,-0.33336,0.18243},
      {0.0036457,-0.010642,0.66931,-0.002607,-0.0029652,0.00038029,-0.0059304,0.47125,-0.32154,0.18047},
      {0.0066067,-0.017025,0.65483,-0.0026685,-0.0045932,0.00048614,-0.0096124,0.46082,-0.30867,0.17813},
      {0.0095409,-0.023624,0.63972,-0.0026717,-0.0063877,0.0004211,-0.013578,0.44998,-0.29535,0.17539},
      {0.01281,-0.031213,0.62031,-0.0025733,-0.0088523,0.00034746,-0.019176,0.4361,-0.27833,0.17161},
      {0.021963,-0.051925,0.54728,-0.002169,-0.018411,0.0027149,-0.043601,0.38376,-0.21405,0.15909},
      {0.029639,-0.070905,0.47565,-0.0014985,-0.028198,0.0039352,-0.06829,0.33247,-0.15196,0.14523},
      {0.035402,-0.086979,0.40774,-0.00052025,-0.037887,0.0035855,-0.092533,0.2839,-0.09428,0.13019},
      {0.036511,-0.079703,0.34073,0.0024425,-0.044975,0.0017446,-0.12159,0.23556,-0.041419,0.11666},
      {0.035252,-0.052022,0.26429,0.0079339,-0.050918,-0.0010591,-0.15809,0.18041,0.015913,0.10324},
      {0.033973,-0.017004,0.17849,0.01531,-0.057386,-0.0052592,-0.19872,0.11884,0.079122,0.087858},
      {0.028228,0.051435,0.10694,0.029548,-0.05408,-0.009663,-0.23663,0.06806,0.11947,0.082761},
      {0.01859,0.15799,0.057374,0.052377,-0.037639,-0.011727,-0.26742,0.03588,0.12837,0.094865},
      {0.011767,0.25513,-0.0013871,0.072367,-0.021329,-0.024937,-0.29291,0.0021091,0.14166,0.10014},
      {0.0076082,0.31648,-0.049063,0.088819,-0.0054962,-0.035748,-0.29942,-0.016416,0.13759,0.10159},
      {0.0049592,0.33181,-0.07954,0.10423,0.0093778,-0.036539,-0.28073,-0.011077,0.10258,0.10216},
      {0.0029161,0.34107,-0.11675,0.11579,0.020869,-0.028633,-0.2642,0.0024872,0.06792,0.11146},
      {0.0016292,0.32998,-0.16448,0.11787,0.032804,-0.01344,-0.24218,0.03166,0.02854,0.11954},
      {0.0012242,0.27402,-0.23123,0.10226,0.051024,-0.00059746,-0.19849,0.089651,-0.028008,0.10718},
      {0.00082409,0.2173,-0.31055,0.0815,0.063125,0.012286,-0.15591,0.16078,-0.087059,0.10277},
      {0.00041242,0.15651,-0.40093,0.059912,0.068949,0.025181,-0.11213,0.24054,-0.15191,0.10626},
      {0.0003508,0.10604,-0.44585,0.044428,0.091672,0.040067,-0.07671,0.28294,-0.19181,0.086055},
      {0.00029158,0.065116,-0.48972,0.030749,0.10536,0.050895,-0.047952,0.32344,-0.22727,0.075435},
      {0.00023258,0.032951,-0.53284,0.019265,0.10996,0.057427,-0.025288,0.36198,-0.25904,0.074283},
      {0.0001466,0.016699,-0.55404,0.011116,0.1165,0.063759,-0.013543,0.38273,-0.27382,0.070159},
      {6.71E-05,0.010228,-0.56311,0.0052345,0.12205,0.067915,-0.0085303,0.39346,-0.27883,0.065656},
      {2.25E-05,0.0052175,-0.57999,0.00065211,0.11706,0.066036,-0.0046045,0.40895,-0.28753,0.071269},
      {1.63E-05,0.0014178,-0.59054,-0.00024516,0.11261,0.06416,-0.0016483,0.41715,-0.29436,0.07611},
      {-0.0032724,0.0017795,0.69759,-0.0028149,2.09E-05,-8.41E-05,0.0013189,0.49132,-0.34709,0.1845},
      {-0.0031437,0.0017404,0.69755,-0.002888,2.13E-05,-9.17E-05,0.0012703,0.49124,-0.34713,0.18449},
      {-0.0029448,0.0016785,0.69749,-0.0029959,2.21E-05,-0.0001033,0.0011954,0.49112,-0.34721,0.18447},
      {-0.0026691,0.0015896,0.69742,-0.0031357,2.33E-05,-0.00011944,0.0010919,0.49098,-0.34731,0.18445},
      {-0.0023117,0.0014691,0.69737,-0.0033001,2.52E-05,-0.00014028,0.00095838,0.49082,-0.34746,0.18442},
      {-0.001812,0.0011379,0.69692,-0.0034675,-2.58E-05,-0.000174,0.00068614,0.49038,-0.34728,0.18429},
      {0.00012977,-0.003509,0.68602,-0.003358,-0.0014457,-0.00049885,-0.0023233,0.48264,-0.3378,0.18188},
      {0.002072,-0.0082439,0.67468,-0.0031641,-0.0029924,-0.0010488,-0.0055307,0.47463,-0.32801,0.17909},
      {0.0039145,-0.012781,0.66341,-0.0028406,-0.0046329,-0.0018894,-0.0087963,0.46676,-0.31838,0.1759},
      {0.0056575,-0.016861,0.65241,-0.0022928,-0.0064863,-0.0029765,-0.011952,0.45925,-0.30912,0.17218},
      {0.0094684,-0.026376,0.61035,-0.001338,-0.012907,-0.0040089,-0.02643,0.42933,-0.27392,0.16156},
      {0.0137,-0.036949,0.55093,6.39E-05,-0.022119,-0.0061412,-0.047365,0.38682,-0.22523,0.14576},
      {0.016547,-0.043393,0.49562,0.0018194,-0.031101,-0.010229,-0.066996,0.34721,-0.18158,0.12866},
      {0.017534,-0.036735,0.43689,0.0051831,-0.038992,-0.015988,-0.090162,0.30505,-0.13762,0.11134},
      {0.016987,0.00086196,0.34182,0.013436,-0.045013,-0.024766,-0.13278,0.23699,-0.068223,0.092907},
      {0.017141,0.037369,0.22686,0.020972,-0.050684,-0.05671,-0.17365,0.15575,0.011413,0.056268},
      {0.01612,0.08433,0.11692,0.029448,-0.052252,-0.097721,-0.20958,0.079951,0.081122,0.017788},
      {0.011405,0.1716,0.056307,0.045611,-0.035765,-0.11362,-0.23207,0.048361,0.096303,0.022336},
      {0.0079832,0.25475,-0.0036595,0.059097,-0.020829,-0.11821,-0.25641,0.023279,0.1128,0.035862},
      {0.0057531,0.32935,-0.061462,0.069355,-0.0078781,-0.11036,-0.28027,0.0074287,0.12756,0.057716},
      {0.0040261,0.33707,-0.1012,0.07851,0.0035203,-0.098852,-0.26483,0.024608,0.093722,0.070007},
      {0.0026734,0.34005,-0.14853,0.082158,0.0117,-0.078475,-0.25199,0.051646,0.060844,0.090035},
      {0.0015985,0.33873,-0.20423,0.079096,0.01655,-0.048636,-0.24218,0.08993,0.029365,0.1177},
      {0.0011109,0.26911,-0.28394,0.066546,0.028798,-0.036852,-0.19179,0.15461,-0.039905,0.11139},
      {0.0006737,0.19539,-0.36987,0.056159,0.037619,-0.022563,-0.13948,0.22213,-0.11492,0.11114},
      {0.00028832,0.13048,-0.45851,0.04546,0.04233,-0.0022399,-0.093475,0.29182,-0.18659,0.12172},
      {0.0001418,0.085321,-0.51612,0.032193,0.052693,0.013513,-0.061627,0.34167,-0.23131,0.12007},
      {9.33E-05,0.05349,-0.55753,0.019605,0.059977,0.021821,-0.039191,0.3798,-0.2615,0.11654},
      {4.31E-05,0.028984,-0.59802,0.0093802,0.059418,0.02635,-0.021838,0.41571,-0.28873,0.12113},
      {-1.18E-05,0.013253,-0.63058,0.0017727,0.05531,0.028413,-0.010527,0.44427,-0.30899,0.12875},
      {-2.79E-05,0.0080496,-0.63061,0.00039976,0.063053,0.03339,-0.0065372,0.44528,-0.31113,0.12176},
      {-2.67E-05,0.0041455,-0.63364,0.0001288,0.065253,0.035196,-0.0035352,0.44764,-0.31461,0.1201},
      {-0.003973,0.0018446,0.69616,-0.0039469,4.79E-05,-1.72E-05,0.0016471,0.48928,-0.34696,0.18454},
      {-0.0038465,0.0017949,0.69619,-0.0039622,4.92E-05,-2.43E-05,0.0015997,0.4893,-0.34702,0.18452},
      {-0.0036484,0.0017173,0.69626,-0.0039832,5.13E-05,-3.53E-05,0.0015245,0.48934,-0.34711,0.18451},
      {-0.0033681,0.0016079,0.69637,-0.0040071,5.44E-05,-5.04E-05,0.0014158,0.48942,-0.34724,0.18448},
      {-0.0029944,0.001463,0.69654,-0.0040283,5.89E-05,-6.97E-05,0.0012669,0.48956,-0.34743,0.18445},
      {-0.0025144,0.0012788,0.6968,-0.0040384,6.51E-05,-9.33E-05,0.0010691,0.48978,-0.34768,0.1844},
      {-0.0019126,0.001051,0.69718,-0.0040256,7.36E-05,-0.00012078,0.00081104,0.49011,-0.34802,0.18435},
      {-0.0010269,6.48E-05,0.69531,-0.0038631,-0.00031697,-0.00040824,-7.24E-05,0.48893,-0.34648,0.18348},
      {0.00028787,-0.0026418,0.68715,-0.0033125,-0.0018461,-0.0015853,-0.0024502,0.48345,-0.33978,0.18016},
      {0.001538,-0.0047674,0.67962,-0.0026445,-0.0033946,-0.0031163,-0.0046637,0.47851,-0.33379,0.17649},
      {0.0026762,-0.005999,0.67332,-0.0018483,-0.004873,-0.0050794,-0.0065505,0.47452,-0.32904,0.17255},
      {0.0040439,-0.0087379,0.65217,-0.00077177,-0.0081219,-0.011395,-0.012414,0.45985,-0.31346,0.16229},
      {0.0061066,-0.013723,0.59241,0.00095971,-0.01654,-0.026016,-0.029897,0.41704,-0.26953,0.13731},
      {0.0076536,-0.016583,0.52906,0.0027405,-0.024648,-0.048889,-0.046123,0.3717,-0.22537,0.10596},
      {0.0086421,-0.016857,0.46227,0.0045358,-0.032086,-0.081539,-0.0606,0.32396,-0.18148,0.067509},
      {0.0088652,0.019128,0.35161,0.011189,-0.036059,-0.12143,-0.09674,0.24649,-0.107,0.027154},
      {0.0086959,0.06188,0.23572,0.017719,-0.038217,-0.17262,-0.13201,0.16654,-0.031745,-0.019625},
      {0.0082243,0.10874,0.1186,0.023458,-0.038407,-0.23628,-0.16395,0.08713,0.041144,-0.073437},
      {0.0063334,0.18305,0.049493,0.033674,-0.026131,-0.24503,-0.19058,0.056784,0.068361,-0.065952},
      {0.0049878,0.2593,-0.009252,0.041558,-0.013576,-0.22918,-0.21888,0.043421,0.08789,-0.036866},
      {0.004422,0.33167,-0.0676,0.045018,-0.0037515,-0.19919,-0.25012,0.038641,0.10921,0.0013834},
      {0.0034629,0.33352,-0.12008,0.048648,0.0027272,-0.17549,-0.24224,0.060575,0.083473,0.023603},
      {0.0023305,0.30265,-0.17894,0.053651,0.0066385,-0.15007,-0.21784,0.094738,0.035657,0.043519},
      {0.0014008,0.2739,-0.24976,0.055944,0.0094628,-0.11086,-0.19542,0.13981,-0.01541,0.076183},
      {0.00084811,0.22055,-0.33371,0.048769,0.015375,-0.081099,-0.15693,0.20277,-0.080652,0.094185},
      {0.00047878,0.15825,-0.42204,0.037095,0.020599,-0.058407,-0.11276,0.27294,-0.15035,0.10601},
      {0.00015575,0.10418,-0.51188,0.025413,0.02234,-0.03029,-0.074476,0.34422,-0.21653,0.12721},
      {-4.07E-05,0.063815,-0.58393,0.013439,0.024001,-0.0065906,-0.045947,0.40334,-0.26666,0.14467},
      {-8.11E-05,0.040087,-0.62279,0.0023613,0.025366,-0.00070921,-0.029132,0.43872,-0.29226,0.14761},
      {-8.64E-05,0.022468,-0.6447,0.0013529,0.026812,0.005023,-0.016681,0.45486,-0.31146,0.15029},
      {-8.33E-05,0.0098931,-0.6647,0.0006649,0.025047,0.009097,-0.0077343,0.46942,-0.32737,0.1562},
      {-7.50E-05,0.0056989,-0.66534,0.00034929,0.030147,0.012839,-0.0045609,0.47009,-0.32976,0.15198},
      {-0.0057762,0.0021686,0.69429,-0.0044671,6.97E-05,3.92E-05,0.0026505,0.48777,-0.34529,0.18457},
      {-0.0056595,0.0020954,0.69425,-0.0047023,7.21E-05,4.08E-05,0.0026239,0.48759,-0.34547,0.18457},
      {-0.0054558,0.001976,0.69427,-0.0049201,7.69E-05,1.97E-05,0.0025681,0.48746,-0.34571,0.18454},
      {-0.0051072,0.0018293,0.69451,-0.0048384,8.43E-05,-6.44E-05,0.0024201,0.48768,-0.34592,0.18445},
      {-0.0046511,0.0016418,0.69478,-0.0047196,9.46E-05,-0.00024137,0.0022221,0.48796,-0.34618,0.18428},
      {-0.0040791,0.0014139,0.69505,-0.0045529,0.00010845,-0.00056697,0.0019666,0.48827,-0.34646,0.18397},
      {-0.0033819,0.0011476,0.69529,-0.0043258,0.00012668,-0.0011119,0.0016447,0.48861,-0.34676,0.18348},
      {-0.0025486,0.00084601,0.69546,-0.004025,0.00015025,-0.0019613,0.0012451,0.48894,-0.34704,0.18272},
      {-0.0015654,0.00051327,0.6955,-0.0036368,0.00018027,-0.0032139,0.00075368,0.48925,-0.34729,0.18162},
      {-0.00060868,-0.00071978,0.68909,-0.0029927,-0.00079588,-0.0071021,-0.00067543,0.48512,-0.34294,0.1768},
      {0.00028302,-0.0022261,0.67901,-0.0022507,-0.0021914,-0.013367,-0.0024566,0.47847,-0.33626,0.16937},
      {0.0011391,-0.0035625,0.66755,-0.0014981,-0.0035493,-0.021637,-0.0041867,0.47084,-0.32904,0.16029},
      {0.0019395,-0.0046416,0.65461,-0.00074893,-0.0048008,-0.032291,-0.0058037,0.46218,-0.3213,0.14936},
      {0.0029057,-0.004715,0.59517,0.0008478,-0.011077,-0.062901,-0.018216,0.41973,-0.28254,0.11434},
      {0.0035407,-0.0023594,0.52767,0.0025162,-0.016947,-0.10478,-0.030161,0.37156,-0.24057,0.070548},
      {0.0038108,0.0028542,0.4565,0.004134,-0.021476,-0.158,-0.040082,0.32086,-0.1987,0.019322},
      {0.0038104,0.034407,0.35647,0.0083165,-0.022612,-0.21881,-0.063603,0.2521,-0.13732,-0.03346},
      {0.0036952,0.082266,0.24087,0.013157,-0.020839,-0.28873,-0.093021,0.17478,-0.066533,-0.089357},
      {0.00357,0.13325,0.12484,0.01678,-0.016816,-0.37057,-0.1187,0.099129,0.0015004,-0.15145},
      {0.0034761,0.18067,0.039858,0.021469,-0.012138,-0.38993,-0.14369,0.060761,0.041326,-0.16164},
      {0.003292,0.22112,-0.017183,0.026754,-0.0077236,-0.35463,-0.16779,0.054972,0.056734,-0.12737},
      {0.0031317,0.2536,-0.070715,0.030356,-0.0037716,-0.3213,-0.18684,0.055252,0.066088,-0.094824},
      {0.0025988,0.25492,-0.12831,0.033058,-0.00021199,-0.28759,-0.18484,0.076845,0.046074,-0.06457},
      {0.0017538,0.2295,-0.20234,0.034257,0.002667,-0.24194,-0.16483,0.12503,-0.0042318,-0.026374},
      {0.0010715,0.20587,-0.28891,0.032117,0.0044813,-0.18225,-0.14662,0.18503,-0.058015,0.024267},
      {0.00058912,0.17261,-0.3837,0.024448,0.0064035,-0.12479,-0.12238,0.25584,-0.11797,0.071272},
      {0.0002836,0.1214,-0.47315,0.011986,0.008425,-0.094285,-0.086109,0.3274,-0.18211,0.094063},
      {2.11E-05,0.077807,-0.558,0.0034035,0.0084124,-0.058794,-0.055353,0.39298,-0.24193,0.12372},
      {-0.00016224,0.043534,-0.62816,0.0025978,0.0087868,-0.019092,-0.031282,0.44265,-0.2936,0.15618},
      {-0.00015852,0.027016,-0.64773,0.0017186,0.011322,-0.012717,-0.019621,0.45704,-0.31113,0.15783},
      {-0.00014025,0.015547,-0.66358,0.0010113,0.012175,-0.0075925,-0.01148,0.46864,-0.32439,0.16085},
      {-0.00011548,0.0078276,-0.67676,0.0004775,0.012021,-0.0028038,-0.0059578,0.47824,-0.33454,0.16504},
      {-0.0075667,0.0022137,0.69347,-0.0031423,0.0001097,-0.00034244,0.0038604,0.48815,-0.34331,0.1842},
      {-0.0075071,0.0021372,0.69336,-0.0033368,0.00011478,-0.00037484,0.0038766,0.48794,-0.34342,0.18416},
      {-0.0074222,0.0020194,0.69319,-0.0036364,0.00012283,-0.00042711,0.0039064,0.4876,-0.34357,0.18411},
      {-0.0073195,0.001857,0.69292,-0.0040496,0.00013443,-0.00050405,0.0039574,0.48712,-0.34376,0.18403},
      {-0.0072127,0.0016482,0.69254,-0.0045816,0.00015019,-0.00061154,0.0040411,0.48648,-0.34398,0.18391},
      {-0.0068454,0.0014195,0.69226,-0.0047952,0.00017104,-0.0011258,0.003938,0.48614,-0.34416,0.18345},
      {-0.0060552,0.0011849,0.69216,-0.0044857,0.0001978,-0.0023118,0.0035137,0.48628,-0.34431,0.18241},
      {-0.0051005,0.00091915,0.69194,-0.0041028,0.00023124,-0.0038826,0.0029882,0.4864,-0.34444,0.18104},
      {-0.0039628,0.000626,0.69155,-0.0036383,0.00027245,-0.0059258,0.002345,0.48646,-0.34454,0.17927},
      {-0.0026197,0.00031014,0.69096,-0.0030848,0.00032266,-0.0085393,0.0015644,0.48644,-0.3446,0.17701},
      {-0.0013074,-0.00018398,0.68721,-0.0024521,6.83E-05,-0.013452,0.00050818,0.48423,-0.34273,0.17236},
      {-0.00060613,-0.00097496,0.67484,-0.0018171,-0.00094183,-0.02432,-0.00086789,0.4759,-0.33554,0.1616},
      {7.36E-05,-0.0014976,0.66093,-0.0011787,-0.0017876,-0.037678,-0.0021269,0.4665,-0.32778,0.14898},
      {0.00072352,-0.0016682,0.64539,-0.00054724,-0.0023876,-0.053896,-0.0032095,0.45595,-0.31946,0.13431},
      {0.0011459,0.0018201,0.59646,0.00062154,-0.0048819,-0.094086,-0.0090934,0.4213,-0.29137,0.096912},
      {0.0013333,0.0095819,0.5252,0.0020683,-0.0074364,-0.15603,-0.016389,0.37067,-0.25153,0.041342},
      {0.0014354,0.01833,0.44507,0.0033667,-0.0090469,-0.23301,-0.022084,0.31396,-0.20859,-0.025258},
      {0.0016508,0.03558,0.33785,0.0055099,-0.011004,-0.32073,-0.035994,0.24051,-0.14864,-0.10098},
      {0.0019319,0.067868,0.21957,0.0088387,-0.011669,-0.3977,-0.059791,0.16342,-0.080145,-0.16566},
      {0.0021039,0.094127,0.11222,0.011395,-0.012147,-0.47201,-0.078754,0.094503,-0.020245,-0.22768},
      {0.0021342,0.11912,0.027525,0.013761,-0.011087,-0.51353,-0.095207,0.050321,0.020331,-0.26051},
      {0.0020454,0.15019,-0.024147,0.016478,-0.0070413,-0.47853,-0.11354,0.053677,0.02808,-0.22629},
      {0.001968,0.17408,-0.072728,0.017167,-0.0036936,-0.44516,-0.12738,0.062982,0.030585,-0.19394},
      {0.0017806,0.18398,-0.12548,0.015798,-0.0011515,-0.40824,-0.13204,0.08584,0.019043,-0.1599},
      {0.001177,0.16335,-0.21582,0.012424,0.00064257,-0.34175,-0.11606,0.14949,-0.034365,-0.10351},
      {0.00069973,0.14421,-0.31923,0.005135,0.0013917,-0.26098,-0.10171,0.22579,-0.091461,-0.034952},
      {0.00030899,0.12415,-0.42285,0.0041012,0.0018655,-0.16901,-0.087646,0.29838,-0.15205,0.041552},
      {6.69E-05,0.083654,-0.49637,0.0032256,0.0032589,-0.13109,-0.059244,0.35038,-0.20845,0.07108},
      {-9.75E-05,0.052129,-0.56698,0.002439,0.0037916,-0.087475,-0.037108,0.40029,-0.25894,0.10656},
      {-0.00019006,0.029245,-0.63291,0.0017459,0.003987,-0.039648,-0.021014,0.44686,-0.30282,0.14601},
      {-0.00018411,0.017214,-0.6584,0.0010728,0.005158,-0.023625,-0.0125,0.46516,-0.32116,0.15763},
      {-0.00015588,0.0099088,-0.67045,0.00053565,0.0054946,-0.018807,-0.0072841,0.47397,-0.33052,0.16115},
      {-0.0086234,0.0023132,0.69361,-0.0018004,0.00013681,-0.00043611,0.0045059,0.4892,-0.34217,0.18408},
      {-0.0086439,0.002243,0.69341,-0.0019767,0.00014411,-0.00048898,0.0045735,0.48893,-0.34218,0.18402},
      {-0.0086839,0.0021348,0.6931,-0.0022482,0.00015561,-0.00057268,0.0046837,0.48852,-0.34218,0.18394},
      {-0.008756,0.0019854,0.69264,-0.0026228,0.000172,-0.00069284,0.0048477,0.48793,-0.34216,0.18382},
      {-0.0088793,0.0017925,0.69201,-0.003105,0.00019404,-0.00085571,0.0050806,0.48715,-0.3421,0.18365},
      {-0.0090794,0.0015552,0.69117,-0.0036963,0.00022257,-0.0010685,0.0054011,0.48614,-0.34198,0.18343},
      {-0.0093902,0.0012734,0.69009,-0.0043952,0.00025857,-0.0013396,0.0058332,0.48488,-0.34174,0.18316},
      {-0.0089687,0.00099985,0.68915,-0.004526,0.00030234,-0.0027473,0.0057088,0.48413,-0.3416,0.18192},
      {-0.0076268,0.00074502,0.68838,-0.0040206,0.00035461,-0.0055552,0.0048843,0.48395,-0.3416,0.1795},
      {-0.0060421,0.00047004,0.68738,-0.0034349,0.00041697,-0.0089759,0.0038967,0.48367,-0.34159,0.17655},
      {-0.0041761,0.00018101,0.6864,-0.0027369,0.00049002,-0.012809,0.00274,0.48347,-0.34166,0.17325},
      {-0.0019859,-0.00010119,0.68534,-0.0019206,0.00057761,-0.017187,0.0013584,0.48332,-0.3418,0.16947},
      {-0.0011819,-8.53E-05,0.67168,-0.0013316,0.0002326,-0.032263,0.00043033,0.4741,-0.3347,0.15612},
      {-0.00049341,-3.15E-05,0.6488,-0.00080998,-0.00013914,-0.057522,-0.00047087,0.45841,-0.32305,0.13426},
      {0.00018454,2.68E-05,0.61957,-0.00035925,-0.00046019,-0.090148,-0.0013369,0.43817,-0.3083,0.1063},
      {0.00066846,0.0020911,0.56627,0.00029796,-0.0015707,-0.14455,-0.0040257,0.40073,-0.28042,0.059145},
      {0.00079582,0.0074881,0.47432,0.0013674,-0.0041013,-0.23369,-0.009685,0.33578,-0.23143,-0.018645},
      {0.00086692,0.012232,0.37569,0.0022605,-0.0063035,-0.33314,-0.014472,0.26623,-0.17969,-0.10435},
      {0.00090537,0.019038,0.27093,0.0031694,-0.0078997,-0.43789,-0.020183,0.19334,-0.12497,-0.19337},
      {0.0010442,0.041574,0.17446,0.0051095,-0.0080212,-0.50676,-0.036154,0.1322,-0.072116,-0.25024},
      {0.0011017,0.05892,0.08909,0.0061335,-0.0077804,-0.57314,-0.047868,0.078895,-0.026996,-0.30436},
      {0.0010835,0.0713,0.016521,0.0061326,-0.0070168,-0.63457,-0.055398,0.035194,0.0093155,-0.35344},
      {0.0010632,0.093664,-0.03042,0.0057935,-0.0037491,-0.5996,-0.068457,0.04763,0.010243,-0.31975},
      {0.0010426,0.10957,-0.074651,0.0031092,-0.0013981,-0.56596,-0.077524,0.065905,0.006665,-0.28807},
      {0.001021,0.1208,-0.11477,0.0018689,-0.0006089,-0.52391,-0.084881,0.086932,-0.0015635,-0.25185},
      {0.00063445,0.10712,-0.2097,0.0022629,3.33E-05,-0.43353,-0.075404,0.1517,-0.054819,-0.1769},
      {0.00030097,0.09101,-0.31437,0.002535,0.00054101,-0.33391,-0.0642,0.22406,-0.11449,-0.094157},
      {5.88E-05,0.075853,-0.42124,0.0026441,0.00091803,-0.23044,-0.053633,0.29831,-0.1748,-0.0081526},
      {-8.03E-05,0.052633,-0.49782,0.0020705,0.0014927,-0.17035,-0.037335,0.35215,-0.22409,0.041072},
      {-0.00015815,0.032057,-0.56194,0.0013815,0.0017706,-0.12181,-0.022856,0.39745,-0.26592,0.080997},
      {-0.0001967,0.017186,-0.62407,0.00079394,0.0016559,-0.069319,-0.012365,0.44142,-0.30399,0.12475},
      {-0.00018888,0.0086163,-0.66177,0.00030273,0.0015771,-0.03724,-0.0062836,0.46823,-0.3268,0.15149},
      {-0.0077586,0.0022977,0.69607,-0.00055474,0.00013327,-0.00016244,0.003884,0.49182,-0.34326,0.18431},
      {-0.0078741,0.0022294,0.69578,-0.00071426,0.00014247,-0.0002272,0.0040179,0.4915,-0.34316,0.18424},
      {-0.0080642,0.0021247,0.69531,-0.00096015,0.00015685,-0.00032799,0.0042326,0.49099,-0.34299,0.18414},
      {-0.0083507,0.0019813,0.69463,-0.0012998,0.00017714,-0.00046914,0.0045454,0.49028,-0.34274,0.18399},
      {-0.0087622,0.0017983,0.69371,-0.0017376,0.00020405,-0.00065439,0.0049776,0.48932,-0.34236,0.1838},
      {-0.0092684,0.0015725,0.69255,-0.002239,0.00023769,-0.00094994,0.0055094,0.48816,-0.34187,0.18351},
      {-0.0098739,0.0013124,0.69111,-0.0027858,0.00027822,-0.0013887,0.0061384,0.48678,-0.34124,0.18309},
      {-0.010612,0.0010274,0.68935,-0.0033707,0.00032609,-0.0019794,0.0068818,0.48517,-0.34042,0.18253},
      {-0.011493,0.00072565,0.68725,-0.0039704,0.00038153,-0.0027533,0.0077405,0.48331,-0.33938,0.18181},
      {-0.0097593,0.00050951,0.68517,-0.0034014,0.00044961,-0.0075001,0.0066403,0.48232,-0.33896,0.17776},
      {-0.0075056,0.00030535,0.68202,-0.0026605,0.00052975,-0.014154,0.0051595,0.48073,-0.33819,0.17211},
      {-0.0051028,0.00010742,0.6775,-0.0019177,0.00062293,-0.022485,0.0035734,0.4782,-0.33683,0.16505},
      {-0.0025867,-7.78E-05,0.6714,-0.0011935,0.00073084,-0.032663,0.0019051,0.47457,-0.33477,0.15644},
      {-0.0011717,-0.00011154,0.65082,-0.00071409,0.00063189,-0.057062,0.00074684,0.46049,-0.32486,0.13564},
      {-0.00056451,-3.93E-05,0.61641,-0.00042426,0.00043772,-0.095787,-4.03E-06,0.43646,-0.30764,0.10271},
      {1.16E-06,5.16E-05,0.57548,-0.00018901,0.00033005,-0.14209,-0.0006974,0.40779,-0.28722,0.063526},
      {0.0004624,0.00057964,0.52304,5.01E-05,0.00013419,-0.20059,-0.0016745,0.37094,-0.26087,0.014089},
      {0.00048931,0.0045814,0.42301,0.00071285,-0.0015737,-0.30483,-0.0054716,0.30053,-0.20904,-0.074685},
      {0.00047247,0.0080537,0.31585,0.0011524,-0.0027701,-0.42028,-0.0084167,0.22521,-0.15417,-0.17182},
      {0.00041237,0.010972,0.20126,0.0013265,-0.0033282,-0.54779,-0.010417,0.14482,-0.096127,-0.27779},
      {0.00043499,0.023669,0.122,0.001579,-0.0027284,-0.61729,-0.018518,0.094929,-0.055231,-0.33385},
      {0.00041915,0.033496,0.058405,0.0008664,-0.0015325,-0.67639,-0.023959,0.056364,-0.023272,-0.38026},
      {0.00042645,0.041316,0.011112,0.00073717,-0.001753,-0.71324,-0.029168,0.029069,-6.64E-05,-0.41031},
      {0.0004625,0.055414,-0.029636,0.00089598,-0.0014879,-0.68016,-0.039042,0.039337,-0.0003171,-0.38234},
      {0.00047374,0.066673,-0.069211,0.0010319,-0.0010178,-0.6329,-0.046955,0.060389,-0.0095708,-0.34246},
      {0.00044814,0.072687,-0.10779,0.0010919,-0.00060511,-0.5911,-0.051205,0.081903,-0.02172,-0.30718},
      {0.00026689,0.065234,-0.1897,0.0012491,-0.0001629,-0.50972,-0.046028,0.13708,-0.064678,-0.2394},
      {6.16E-05,0.052653,-0.29626,0.0013364,0.00019377,-0.40354,-0.037231,0.21122,-0.12359,-0.15115},
      {-9.27E-05,0.040538,-0.40323,0.001219,0.00038746,-0.29607,-0.02873,0.28612,-0.18255,-0.061792},
      {-0.00017737,0.026788,-0.48881,0.00075719,0.00050777,-0.21496,-0.019048,0.34644,-0.23171,0.0055227},
      {-0.00020195,0.014165,-0.54927,0.00018081,0.00045929,-0.16168,-0.010132,0.38923,-0.26783,0.049837},
      {-0.00019507,0.0084841,-0.60316,0.00010664,0.00055066,-0.10672,-0.0061718,0.42712,-0.29747,0.095322},
      {-0.0045774,0.0017476,0.70057,0,0.00013987,8.08E-05,0.0020137,0.49542,-0.34714,0.1845},
      {-0.0047161,0.0017101,0.70046,0,0.00014568,8.41E-05,0.0021388,0.49534,-0.34704,0.1845},
      {-0.0049254,0.0016532,0.70029,0,0.00015483,8.94E-05,0.0023279,0.49522,-0.34688,0.18449},
      {-0.0052332,0.001567,0.69986,-7.18E-05,0.00017086,-1.18E-06,0.0026102,0.49489,-0.34659,0.18439},
      {-0.0057017,0.001435,0.69879,-0.00034372,0.00019962,-0.00038613,0.0030462,0.49397,-0.34603,0.18403},
      {-0.0062871,0.001278,0.69745,-0.00066141,0.00023547,-0.00088788,0.0035853,0.49283,-0.3453,0.18356},
      {-0.0069935,0.0010994,0.69581,-0.0010141,0.00027872,-0.0015236,0.0042282,0.49148,-0.3444,0.18297},
      {-0.0078226,0.00090389,0.69387,-0.0013879,0.00032958,-0.0023108,0.0049724,0.48992,-0.34332,0.18225},
      {-0.0087721,0.00069728,0.69163,-0.0017657,0.00038819,-0.0032668,0.0058125,0.48816,-0.34204,0.18137},
      {-0.0098352,0.00048611,0.68908,-0.0021288,0.00045462,-0.0044068,0.0067387,0.48621,-0.34056,0.18033},
      {-0.0096689,0.00030406,0.68533,-0.0021217,0.00053836,-0.0085953,0.006761,0.4837,-0.33889,0.17673},
      {-0.0073855,0.00017,0.67921,-0.0015857,0.00065005,-0.018306,0.0052318,0.47993,-0.33678,0.16851},
      {-0.0050232,4.66E-05,0.67173,-0.0010717,0.00077873,-0.029558,0.0036476,0.4752,-0.33407,0.15898},
      {-0.0026286,-6.14E-05,0.66276,-0.0005974,0.00092635,-0.042405,0.0020406,0.46945,-0.33068,0.14811},
      {-0.00083774,-9.19E-05,0.6427,-0.00025725,0.0010329,-0.066881,0.00075345,0.45573,-0.32146,0.12742},
      {-0.00037549,3.00E-05,0.59719,-0.00013,0.0010794,-0.1186,0.00018717,0.42373,-0.29881,0.083876},
      {1.35E-05,0.00018561,0.54506,-3.66E-05,0.0012484,-0.178,-0.00030001,0.38705,-0.2729,0.034026},
      {0.00030602,0.00038292,0.48592,2.57E-05,0.0015653,-0.24559,-0.00068698,0.34541,-0.2435,-0.022515},
      {0.00029555,0.0029099,0.38258,0.00017775,0.0011584,-0.3607,-0.0024681,0.27288,-0.19118,-0.1182},
      {0.00023623,0.0053288,0.2692,0.00022532,0.00068147,-0.48821,-0.0040235,0.19345,-0.134,-0.22368},
      {0.00017806,0.0072259,0.15835,0.00028502,-4.73E-05,-0.61299,-0.0053605,0.11573,-0.0782,-0.32707},
      {0.00017907,0.013379,0.09028,0.00033697,-0.00057483,-0.67741,-0.0096398,0.072011,-0.04426,-0.38025},
      {0.00019635,0.020247,0.047605,0.00036811,-0.0009327,-0.70814,-0.014415,0.048456,-0.024175,-0.40544},
      {0.00019371,0.025091,0.010156,0.00037007,-0.0012038,-0.73508,-0.017785,0.0287,-0.0077664,-0.42749},
      {0.00018837,0.031242,-0.026349,0.00041965,-0.0010672,-0.72248,-0.022097,0.03222,-0.0071545,-0.41656},
      {0.00016552,0.036637,-0.064623,0.00047385,-0.00069027,-0.68093,-0.02589,0.054038,-0.019832,-0.38152},
      {0.00011078,0.038081,-0.10127,0.000449,-0.00039642,-0.64408,-0.026892,0.075886,-0.034469,-0.35048},
      {4.82E-06,0.033225,-0.1645,0.00039186,-0.00015174,-0.58098,-0.023456,0.11837,-0.066894,-0.29781},
      {-0.00011601,0.023482,-0.27086,0.00023911,1.81E-05,-0.47139,-0.016592,0.19294,-0.1244,-0.2067},
      {-0.00018145,0.016384,-0.37625,6.83E-05,8.73E-05,-0.35902,-0.011631,0.2672,-0.18026,-0.11339},
      {-0.00020601,0.012113,-0.46757,7.98E-05,0.00018244,-0.25888,-0.0087084,0.3315,-0.22785,-0.03039},
      {-0.00019474,0.0078394,-0.5192,6.60E-05,0.00031473,-0.20468,-0.0057429,0.36778,-0.2557,0.014404},
      {-0.002124,0.0010992,0.70362,0,0.00017034,9.83E-05,0.00073604,0.49759,-0.35023,0.18447},
      {-0.0022066,0.0010772,0.70355,0,0.00017879,0.00010322,0.00081053,0.49754,-0.35016,0.18447},
      {-0.0023301,0.0010438,0.70344,0,0.00019209,0.0001109,0.00092238,0.49747,-0.35007,0.18445},
      {-0.0024934,0.00099891,0.70329,0,0.00021103,0.00012184,0.0010709,0.49737,-0.34994,0.18444},
      {-0.0026911,0.00094298,0.70311,0,0.00023645,0.00013651,0.0012518,0.49725,-0.34978,0.18441},
      {-0.0029136,0.00087733,0.7029,0,0.00026932,0.00015549,0.0014576,0.49711,-0.3496,0.18438},
      {-0.0034753,0.00077572,0.70169,-0.00013411,0.00031276,-0.00033536,0.0019386,0.49622,-0.34886,0.18391},
      {-0.0042913,0.00065032,0.69976,-0.00034142,0.00036522,-0.0012081,0.0026235,0.49481,-0.34769,0.18311},
      {-0.0052012,0.00051854,0.69758,-0.00054368,0.0004255,-0.0022307,0.0033817,0.49323,-0.34635,0.18218},
      {-0.0061891,0.00038488,0.69515,-0.00072762,0.0004936,-0.003407,0.0041989,0.49152,-0.34486,0.1811},
      {-0.0072329,0.00025417,0.69251,-0.00087913,0.00056944,-0.004737,0.0050556,0.48971,-0.34323,0.17989},
      {-0.0083036,0.00013133,0.6897,-0.00098394,0.00065286,-0.0062155,0.0059277,0.48783,-0.3415,0.17855},
      {-0.0062047,5.94E-05,0.6813,-0.00066657,0.00080274,-0.017898,0.0045138,0.48236,-0.33831,0.16864},
      {-0.0040774,7.55E-07,0.6716,-0.00038707,0.00097425,-0.030955,0.0030825,0.47598,-0.33454,0.15756},
      {-0.0020085,-4.18E-05,0.66061,-0.00016478,0.001169,-0.045248,0.0016959,0.46868,-0.33014,0.14542},
      {-0.00017415,-5.64E-05,0.64537,-2.19E-05,0.0013804,-0.063883,0.0004612,0.45842,-0.32361,0.12965},
      {-1.49E-05,0.00010024,0.58567,1.61E-06,0.0015767,-0.13157,0.00015393,0.41663,-0.29407,0.073127},
      {0.00012732,0.00024559,0.51898,2.04E-05,0.0017431,-0.20754,-0.00012245,0.36982,-0.26099,0.0097948},
      {0.00024227,0.00037524,0.44376,3.28E-05,0.0018317,-0.29367,-0.00035743,0.31691,-0.2236,-0.061833},
      {0.0002358,0.0015764,0.34546,7.05E-05,0.0013825,-0.40505,-0.0012528,0.24793,-0.17432,-0.1541},
      {0.00017707,0.0030619,0.24001,0.00010722,0.00072084,-0.52429,-0.0023089,0.17404,-0.12142,-0.2527},
      {0.00011421,0.0041458,0.13851,0.00012447,0.00015942,-0.63953,-0.0030878,0.10294,-0.070662,-0.34795},
      {7.92E-05,0.0067967,0.066902,0.00013347,-0.00023612,-0.71409,-0.0049461,0.055615,-0.035896,-0.40947},
      {7.24E-05,0.01075,0.03325,0.00013403,-0.00046191,-0.73757,-0.0076934,0.038593,-0.021866,-0.42869},
      {5.23E-05,0.013089,0.004711,0.0001119,-0.00059621,-0.75727,-0.0093077,0.025098,-0.011127,-0.44475},
      {2.12E-05,0.014699,-0.02308,8.74E-05,-0.00054191,-0.75737,-0.010409,0.02418,-0.0096311,-0.44447},
      {-2.79E-05,0.015811,-0.059304,5.17E-05,-0.00028271,-0.72058,-0.011148,0.04626,-0.024602,-0.41351},
      {-8.38E-05,0.014907,-0.094832,-2.66E-05,-0.00012539,-0.68466,-0.010461,0.069224,-0.041188,-0.38342},
      {-0.0001137,0.01401,-0.14394,-2.11E-05,-5.98E-05,-0.63044,-0.0098576,0.103,-0.065464,-0.3384},
      {-0.00014641,0.010434,-0.24886,3.62E-06,2.82E-05,-0.51373,-0.0074318,0.17694,-0.11949,-0.24163},
      {-0.00017195,0.0075284,-0.34585,2.03E-05,0.0001056,-0.40538,-0.0054754,0.24528,-0.16923,-0.1518},
      {-0.00019094,0.0052889,-0.43359,3.01E-05,0.00017248,-0.30693,-0.003984,0.30711,-0.21401,-0.070185},
      {-0.00063691,0.00052721,0.70569,0,0.0001748,0.00010092,8.56E-05,0.49905,-0.35229,0.18447},
      {-0.00067206,0.00051626,0.70565,0,0.00018643,0.00010763,0.0001188,0.49902,-0.35226,0.18446},
      {-0.00072314,0.00049975,0.70559,0,0.00020467,0.00011817,0.00016752,0.49898,-0.35221,0.18444},
      {-0.0007874,0.00047766,0.70551,0,0.00023055,0.00013311,0.00022988,0.49893,-0.35216,0.18442},
      {-0.00085926,0.00045039,0.70541,0,0.00026512,0.00015307,0.00030165,0.49887,-0.35209,0.18438},
      {-0.00093007,0.00041878,0.70531,0,0.00030952,0.0001787,0.00037617,0.49881,-0.35203,0.18434},
      {-0.00098813,0.00038402,0.7052,0,0.00036506,0.00021077,0.00044433,0.49875,-0.35197,0.18429},
      {-0.0010187,0.0003476,0.70511,0,0.00043322,0.00025012,0.00049464,0.49871,-0.35194,0.18422},
      {-0.0015908,0.000283,0.70364,-4.78E-05,0.0004991,-0.00047006,0.00096074,0.49774,-0.35103,0.18353},
      {-0.0024073,0.0002084,0.70151,-9.44E-05,0.00056752,-0.0015803,0.0016132,0.49635,-0.34969,0.18251},
      {-0.0033919,0.00014914,0.69869,-0.00012922,0.00070201,-0.0030601,0.0023759,0.49455,-0.34795,0.18109},
      {-0.0044082,9.39E-05,0.6953,-0.00015337,0.00081563,-0.0050897,0.0031645,0.49241,-0.34594,0.17925},
      {-0.0051915,4.21E-05,0.69149,-0.00018781,0.00085239,-0.0078342,0.003813,0.49004,-0.34388,0.17692},
      {-0.0043059,1.04E-05,0.68151,-0.0001593,0.00091573,-0.019357,0.0032742,0.48348,-0.3396,0.16727},
      {-0.0026902,-8.48E-06,0.66637,-0.00010325,0.0010178,-0.037391,0.0022231,0.47342,-0.33316,0.15217},
      {-0.0012577,-2.29E-05,0.6486,-5.38E-05,0.0010897,-0.058117,0.0013052,0.4616,-0.32539,0.13487},
      {-4.07E-05,-3.24E-05,0.62801,-1.21E-05,0.0011255,-0.081739,0.00054294,0.44788,-0.31619,0.11523},
      {0.00021019,6.20E-05,0.56405,2.83E-06,0.0011965,-0.1551,0.00024508,0.40295,-0.28452,0.054243},
      {0.00024584,0.00016461,0.48408,1.07E-05,0.0012598,-0.24704,4.51E-05,0.34655,-0.24467,-0.022137},
      {0.00023992,0.000251,0.39605,1.61E-05,0.0012986,-0.34842,-0.00013246,0.28443,-0.20079,-0.10629},
      {0.00019,0.00072572,0.30022,2.51E-05,0.0010878,-0.45816,-0.00053955,0.21701,-0.15295,-0.1972},
      {0.0001255,0.0015149,0.20533,3.21E-05,0.00063064,-0.56615,-0.0011203,0.15056,-0.10562,-0.28644},
      {6.32E-05,0.0019927,0.11464,2.66E-05,0.00026277,-0.6697,-0.0014788,0.087101,-0.060535,-0.37196},
      {1.43E-05,0.0026778,0.040835,1.25E-05,8.78E-06,-0.7514,-0.0019666,0.036885,-0.024693,-0.43935},
      {-6.37E-06,0.0043511,0.015919,-8.59E-06,-7.74E-05,-0.76777,-0.003108,0.025903,-0.016069,-0.45267},
      {-2.71E-05,0.0051266,-0.0031964,-3.37E-05,-0.00011953,-0.778,-0.0036236,0.019273,-0.010973,-0.46095},
      {-3.89E-05,0.0057051,-0.020218,-4.19E-05,-0.00019302,-0.77926,-0.0040281,0.018079,-0.0098215,-0.46195},
      {-6.46E-05,0.0063433,-0.05892,-3.97E-05,-0.00013151,-0.73557,-0.0044876,0.04432,-0.027988,-0.42564},
      {-9.03E-05,0.0060518,-0.099736,-3.84E-05,-6.73E-05,-0.69029,-0.0043064,0.0722,-0.047784,-0.38803},
      {-0.00011456,0.0050349,-0.14268,-3.80E-05,-1.26E-06,-0.64313,-0.0036287,0.10174,-0.069121,-0.34888},
      {-0.0001267,0.0039116,-0.22784,-2.37E-05,6.97E-05,-0.54642,-0.0029155,0.1617,-0.11203,-0.2687},
      {-0.00013751,0.0030461,-0.31008,-1.03E-05,0.00013019,-0.45262,-0.0023822,0.2197,-0.15342,-0.19094},
      {-7.18E-05,0.00021092,0.70653,0,0.00022495,0.00012987,-7.29E-05,0.49962,-0.35312,0.18442},
      {-8.28E-05,0.00020931,0.70647,0,0.0002643,0.00015259,-5.88E-05,0.49958,-0.35309,0.18438},
      {-9.90E-05,0.00020682,0.70637,0,0.00032932,0.00019014,-3.71E-05,0.49951,-0.35303,0.18432},
      {-0.00011979,0.00020336,0.70622,0,0.00042836,0.00024731,-7.05E-06,0.49942,-0.35294,0.18423},
      {-0.00014413,0.00019889,0.70601,0,0.000573,0.00033082,3.16E-05,0.49928,-0.35282,0.18409},
      {-0.00017012,0.00019335,0.70573,0,0.00077934,0.00044995,7.88E-05,0.4991,-0.35267,0.18389},
      {-0.00019535,0.00018673,0.70534,0,0.0010694,0.00061741,0.00013449,0.49885,-0.35246,0.18361},
      {-0.00021692,0.00017905,0.70483,0,0.0014727,0.00085025,0.00019798,0.49851,-0.35218,0.18323},
      {-0.00023166,0.00017033,0.70415,0,0.0020282,0.001171,0.00026833,0.49806,-0.35182,0.1827},
      {-0.00027662,0.00015885,0.70312,-1.71E-06,0.0027316,0.0014244,0.00037062,0.49738,-0.35128,0.1819},
      {-0.00084916,0.00012279,0.69989,-2.61E-05,0.0027359,-0.0011098,0.00082337,0.49537,-0.34958,0.17979},
      {-0.0013698,8.74E-05,0.69625,-4.85E-05,0.002591,-0.0043529,0.0012364,0.49312,-0.34775,0.17731},
      {-0.0018129,5.37E-05,0.69221,-6.77E-05,0.0022257,-0.0084597,0.0015909,0.49064,-0.34579,0.17443},
      {-0.0021546,2.30E-05,0.68775,-8.29E-05,0.0015502,-0.013608,0.0018703,0.48793,-0.34371,0.17113},
      {-0.0019693,2.32E-06,0.67824,-7.85E-05,0.00090559,-0.024935,0.0017906,0.48177,-0.33941,0.16266},
      {-0.0010829,-3.08E-06,0.65835,-4.84E-05,0.00091762,-0.04761,0.0012459,0.46843,-0.33033,0.14384},
      {-0.00034581,-5.05E-06,0.63586,-2.37E-05,0.00089738,-0.073051,0.0008094,0.45332,-0.31993,0.12277},
      {0.00022944,-3.50E-06,0.61065,-4.81E-06,0.00084036,-0.10141,0.00048945,0.43634,-0.30813,0.099336},
      {0.00038899,4.35E-05,0.54801,3.39E-06,0.00082808,-0.17331,0.00029485,0.39244,-0.27717,0.039724},
      {0.00032492,0.00010894,0.45551,5.95E-06,0.00084833,-0.28001,0.00013981,0.3271,-0.23102,-0.048802},
      {0.00022999,0.00016081,0.35481,7.05E-06,0.00084792,-0.3962,-3.88E-07,0.25601,-0.18081,-0.14515},
      {0.00012194,0.0002836,0.25132,5.95E-06,0.00076069,-0.51537,-0.00017068,0.18311,-0.12927,-0.24387},
      {6.37E-05,0.00055846,0.167,-3.35E-06,0.00048086,-0.61179,-0.00038681,0.12415,-0.087463,-0.32349},
      {2.66E-05,0.00074649,0.09394,-1.36E-05,0.00025769,-0.69518,-0.00054438,0.073129,-0.051294,-0.39239},
      {-6.75E-06,0.0008528,0.024594,-2.39E-05,7.46E-05,-0.77395,-0.00064537,0.024942,-0.017173,-0.45752},
      {-1.72E-05,0.0016833,0.0086683,-3.28E-05,-1.20E-05,-0.77826,-0.0012249,0.021702,-0.01445,-0.46105},
      {-2.72E-05,0.0020339,-0.0067169,-4.14E-05,-7.83E-05,-0.78085,-0.0014726,0.019852,-0.012952,-0.46317},
      {-3.47E-05,0.0020924,-0.021479,-5.05E-05,-0.00011841,-0.78141,-0.0015211,0.019451,-0.012627,-0.4636},
      {-5.00E-05,0.0022654,-0.05749,-5.18E-05,-6.27E-05,-0.74345,-0.0016685,0.042526,-0.028807,-0.43206},
      {-6.39E-05,0.0021692,-0.097557,-5.09E-05,-1.16E-06,-0.69842,-0.0016384,0.070113,-0.048305,-0.39469},
      {-7.42E-05,0.0018052,-0.13693,-4.99E-05,5.10E-05,-0.65423,-0.0014295,0.097374,-0.067713,-0.35803},
      {-8.58E-05,0.0012555,-0.20131,-4.09E-05,0.00010085,-0.58085,-0.0011076,0.14264,-0.099947,-0.2972},
      {0,0.00010587,0.70698,0,2.43E-05,1.40E-05,-7.49E-05,0.49991,-0.35344,0.18461},
      {0,0.00010767,0.70697,0,2.49E-05,1.44E-05,-7.61E-05,0.49991,-0.35343,0.18461},
      {0,0.00011034,0.70697,0,2.58E-05,1.49E-05,-7.80E-05,0.4999,-0.35343,0.18461},
      {-7.28E-07,0.00010847,0.70666,0,0.00029384,0.00016965,-5.57E-05,0.49969,-0.35327,0.18436},
      {-5.66E-07,0.00010534,0.70619,0,0.00070337,0.00040609,-2.41E-05,0.49938,-0.35303,0.18396},
      {1.52E-06,0.00010148,0.70557,0,0.0012557,0.00072498,1.41E-05,0.49895,-0.3527,0.18343},
      {6.61E-06,9.69E-05,0.70476,0,0.001986,0.0011466,5.82E-05,0.4984,-0.35228,0.18274},
      {1.58E-05,9.16E-05,0.70371,0,0.0029382,0.0016964,0.0001073,0.49769,-0.35175,0.18182},
      {3.03E-05,8.56E-05,0.70238,0,0.0041672,0.002406,0.00016008,0.49677,-0.35107,0.18065},
      {5.07E-05,7.90E-05,0.70069,0,0.0057402,0.0033141,0.0002147,0.49561,-0.35022,0.17914},
      {7.76E-05,7.18E-05,0.69858,0,0.0077386,0.0044679,0.00026891,0.49416,-0.34916,0.17723},
      {-4.38E-05,5.70E-05,0.69536,-5.73E-06,0.0083462,0.0023579,0.00039471,0.4921,-0.34763,0.17461},
      {-0.00024179,3.77E-05,0.69126,-1.43E-05,0.0072629,-0.0033525,0.00054893,0.4896,-0.34578,0.17143},
      {-0.00037066,2.07E-05,0.68681,-2.04E-05,0.0057088,-0.010293,0.00065835,0.4869,-0.34381,0.1679},
      {-0.00041982,6.67E-06,0.68203,-2.35E-05,0.0035576,-0.018671,0.00071856,0.484,-0.34173,0.16405},
      {-0.00035379,-2.99E-06,0.67549,-2.26E-05,0.00093183,-0.029947,0.00071109,0.4799,-0.33884,0.15847},
      {1.48E-05,3.25E-07,0.65143,-1.09E-05,0.00086092,-0.057007,0.00052364,0.46359,-0.32742,0.13613},
      {0.000285,5.70E-06,0.62486,-2.69E-06,0.00075688,-0.086865,0.00040753,0.44553,-0.31473,0.11152},
      {0.00046055,1.29E-05,0.59572,2.20E-06,0.00061632,-0.11964,0.00035954,0.42566,-0.30071,0.08455},
      {0.00047846,3.47E-05,0.53771,3.80E-06,0.0005116,-0.18611,0.00030801,0.38509,-0.27204,0.029583},
      {0.00034843,6.99E-05,0.43469,3.06E-06,0.00050999,-0.30537,0.00018164,0.31212,-0.22049,-0.0693},
      {0.00021786,9.82E-05,0.33002,1.29E-06,0.00050044,-0.42629,6.11E-05,0.23814,-0.16823,-0.16955},
      {9.17E-05,0.00012231,0.22495,-1.71E-06,0.00047911,-0.5474,-5.19E-05,0.16405,-0.11589,-0.26995},
      {5.74E-05,0.00024845,0.1562,-1.16E-05,0.0003035,-0.62548,-0.00016749,0.11626,-0.082047,-0.33452},
      {2.60E-05,0.00032314,0.089524,-2.24E-05,0.00016331,-0.70062,-0.00024662,0.070285,-0.049506,-0.39668},
      {-3.19E-07,0.00036934,0.02721,-3.42E-05,5.89E-05,-0.77003,-0.00030401,0.027821,-0.019466,-0.45411},
      {-1.03E-05,0.00063233,0.0032223,-4.40E-05,7.96E-06,-0.78422,-0.0004978,0.01894,-0.013047,-0.46583},
      {-1.51E-05,0.00079075,-0.010829,-5.26E-05,-1.77E-05,-0.78343,-0.0006198,0.019294,-0.013207,-0.46514},
      {-1.78E-05,0.00077819,-0.023956,-6.01E-05,-2.69E-05,-0.78087,-0.00062817,0.020857,-0.014305,-0.46298},
      {-2.58E-05,0.00064839,-0.052626,-6.11E-05,2.79E-06,-0.75262,-0.000571,0.038212,-0.026603,-0.43953},
      {-3.61E-05,0.00036307,-0.091292,-5.87E-05,4.55E-05,-0.70903,-0.00041933,0.065045,-0.045667,-0.40339},
      {-4.42E-05,-5.24E-06,-0.12874,-5.65E-05,0.00012444,-0.66656,-0.0002167,0.091204,-0.0643,-0.36826},
      {0,3.27E-05,0.70706,0,1.41E-05,8.15E-06,-2.32E-05,0.49997,-0.35351,0.18462},
      {0,3.33E-05,0.70706,0,1.46E-05,8.40E-06,-2.36E-05,0.49997,-0.35351,0.18462},
      {0,3.42E-05,0.70706,0,1.52E-05,8.79E-06,-2.42E-05,0.49997,-0.35351,0.18462},
      {0,3.52E-05,0.70706,0,1.61E-05,9.32E-06,-2.49E-05,0.49996,-0.35351,0.18462},
      {0,3.63E-05,0.70705,0,1.73E-05,1.00E-05,-2.57E-05,0.49996,-0.35351,0.18462},
      {0,3.74E-05,0.70705,0,1.88E-05,1.08E-05,-2.65E-05,0.49996,-0.35351,0.18462},
      {1.11E-05,3.57E-05,0.70605,0,0.00097786,0.00056457,-6.44E-06,0.49926,-0.353,0.1837},
      {2.88E-05,3.25E-05,0.7043,0,0.0026499,0.0015299,2.38E-05,0.49806,-0.35213,0.1821},
      {4.85E-05,2.89E-05,0.70214,0,0.0047374,0.0027351,5.41E-05,0.49656,-0.35105,0.1801},
      {6.89E-05,2.50E-05,0.69948,0,0.0073201,0.0042262,8.24E-05,0.49471,-0.34973,0.17763},
      {8.84E-05,2.09E-05,0.69623,0,0.010492,0.0060575,0.00010607,0.49245,-0.34812,0.17459},
      {0.00010465,1.66E-05,0.69229,0,0.014363,0.0082922,0.00012202,0.4897,-0.34617,0.17089},
      {0.00011007,1.19E-05,0.68768,-2.27E-07,0.018038,0.0094843,0.00013124,0.48653,-0.34392,0.1666},
      {0.00011023,5.25E-06,0.68341,-1.16E-06,0.015329,0.00054291,0.00015324,0.48391,-0.34206,0.16307},
      {0.00015405,8.02E-07,0.67887,-8.81E-07,0.011855,-0.010026,0.00016004,0.48112,-0.34009,0.1593},
      {0.00022643,-1.04E-06,0.67333,-2.20E-07,0.0075197,-0.023266,0.00017771,0.4776,-0.33758,0.15455},
      {0.00029046,-1.77E-06,0.66527,-2.61E-07,0.0022565,-0.041102,0.00022442,0.47221,-0.33374,0.14732},
      {0.00034901,2.17E-06,0.63803,5.25E-07,0.0012895,-0.073534,0.00025553,0.45333,-0.32037,0.12181},
      {0.00040251,6.57E-06,0.6052,1.36E-06,0.0011208,-0.11112,0.00028283,0.43046,-0.30417,0.090888},
      {0.00045029,1.04E-05,0.57,2.05E-06,0.00075545,-0.15196,0.00030822,0.4058,-0.28671,0.057554},
      {0.00046204,1.76E-05,0.51867,1.99E-06,0.00028507,-0.21165,0.00030728,0.36973,-0.2612,0.0087341},
      {0.00033495,3.87E-05,0.41284,-1.15E-06,0.0002821,-0.33326,0.00019678,0.29532,-0.20864,-0.092098},
      {0.00020775,5.47E-05,0.30636,-5.48E-06,0.00027102,-0.45543,9.03E-05,0.22059,-0.15585,-0.19338},
      {8.49E-05,6.49E-05,0.19952,-1.11E-05,0.00025224,-0.5778,-8.73E-06,0.14574,-0.10298,-0.29482},
      {4.24E-05,0.00011078,0.13092,-2.15E-05,0.00016726,-0.6547,-7.71E-05,0.098682,-0.069705,-0.35848},
      {2.05E-05,0.00013794,0.075034,-3.31E-05,9.20E-05,-0.71621,-0.00011952,0.061036,-0.043079,-0.40941},
      {4.05E-06,0.00013627,0.024482,-4.47E-05,4.02E-05,-0.77109,-0.00013946,0.027462,-0.019347,-0.45484},
      {-3.08E-06,0.00015977,-0.0025402,-5.33E-05,1.63E-05,-0.79048,-0.00017321,0.01557,-0.010921,-0.47088},
      {-5.14E-06,0.00011803,-0.014949,-5.89E-05,1.06E-05,-0.78687,-0.00016445,0.017792,-0.012498,-0.46786},
      {-5.70E-06,-7.54E-06,-0.026324,-6.31E-05,1.51E-05,-0.78168,-0.0001029,0.021038,-0.014838,-0.46354},
      {-1.00E-05,-3.66E-05,-0.046295,-6.47E-05,7.37E-05,-0.76186,-0.0001191,0.033084,-0.023338,-0.44719},
      {-1.81E-05,-8.26E-05,-0.081324,-6.11E-05,0.00029129,-0.72118,-0.00013859,0.05773,-0.040735,-0.41377},
      {0,3.32E-06,0.7071,0,7.63E-06,4.40E-06,-2.35E-06,0.49999,-0.35355,0.18463},
      {0,3.30E-06,0.7071,0,7.97E-06,4.60E-06,-2.33E-06,0.49999,-0.35355,0.18463},
      {0,3.24E-06,0.7071,0,8.49E-06,4.90E-06,-2.29E-06,0.49999,-0.35355,0.18463},
      {0,3.10E-06,0.70709,0,9.22E-06,5.32E-06,-2.19E-06,0.49999,-0.35355,0.18463},
      {0,2.83E-06,0.70709,0,1.02E-05,5.86E-06,-2.00E-06,0.49999,-0.35355,0.18463},
      {0,2.35E-06,0.70709,0,1.13E-05,6.52E-06,-1.66E-06,0.49999,-0.35355,0.18463},
      {0,1.60E-06,0.70709,0,1.26E-05,7.30E-06,-1.13E-06,0.49999,-0.35355,0.18463},
      {0,6.05E-07,0.70709,0,1.42E-05,8.18E-06,-4.28E-07,0.49999,-0.35355,0.18462},
      {3.39E-06,6.27E-07,0.70525,0,0.0018364,0.0010602,2.18E-06,0.4987,-0.35263,0.18288},
      {9.96E-06,6.32E-07,0.70145,0,0.0055901,0.0032275,7.23E-06,0.49604,-0.35075,0.17929},
      {1.72E-05,6.25E-07,0.6969,0,0.010093,0.0058274,1.27E-05,0.49285,-0.34849,0.17497},
      {2.51E-05,6.02E-07,0.69149,0,0.01545,0.0089203,1.86E-05,0.48906,-0.3458,0.16984},
      {3.34E-05,5.61E-07,0.68512,0,0.021775,0.012572,2.49E-05,0.48458,-0.34263,0.16379},
      {4.22E-05,5.01E-07,0.67765,0,0.029189,0.016852,3.13E-05,0.47933,-0.33891,0.15669},
      {8.98E-05,5.49E-08,0.67041,-2.49E-08,0.026966,0.0050234,6.58E-05,0.47441,-0.33541,0.15008},
      {0.00015795,-3.87E-07,0.66245,-5.33E-08,0.020641,-0.014649,0.00011492,0.46902,-0.33156,0.14285},
      {0.00023141,-7.69E-07,0.6524,-7.72E-08,0.013676,-0.037863,0.00016762,0.46214,-0.32666,0.1336},
      {0.00030833,-1.08E-06,0.64002,-9.56E-08,0.0060009,-0.06503,0.00022258,0.45359,-0.32058,0.1221},
      {0.00036343,7.06E-07,0.61212,1.74E-07,0.0025109,-0.1028,0.00025871,0.43412,-0.30678,0.095792},
      {0.00039379,3.29E-06,0.57231,4.73E-07,0.0018741,-0.14938,0.00027603,0.40625,-0.28706,0.058088},
      {0.00041067,5.22E-06,0.52851,5.62E-07,0.001085,-0.2009,0.00028477,0.37552,-0.26533,0.016505},
      {0.00041366,6.46E-06,0.48083,4.14E-07,0.00014675,-0.25725,0.00028469,0.34201,-0.24163,-0.028873},
      {0.00028498,1.68E-05,0.37894,-5.14E-06,0.00013342,-0.37386,0.0001813,0.27068,-0.19125,-0.12554},
      {0.00016689,2.20E-05,0.27606,-1.19E-05,0.00011692,-0.49141,8.91E-05,0.19878,-0.14047,-0.22299},
      {6.50E-05,2.16E-05,0.1725,-1.98E-05,9.60E-05,-0.60954,1.23E-05,0.12652,-0.08943,-0.3209},
      {2.25E-05,2.26E-05,0.10361,-3.01E-05,5.88E-05,-0.68624,-2.63E-05,0.079586,-0.056265,-0.38446},
      {1.01E-05,8.65E-06,0.058714,-4.10E-05,2.69E-05,-0.73417,-3.59E-05,0.050261,-0.035542,-0.42415},
      {3.58E-06,-1.23E-05,0.019358,-5.31E-05,1.32E-05,-0.77541,-3.89E-05,0.02501,-0.017701,-0.45832},
      {4.87E-07,-2.38E-05,-0.0059779,-6.51E-05,1.34E-05,-0.79541,-5.24E-05,0.01273,-0.00902,-0.4749},
      {-6.37E-07,-4.34E-05,-0.015746,-7.04E-05,2.32E-05,-0.78951,-6.69E-05,0.016296,-0.011533,-0.47003},
      {-1.11E-06,-6.96E-05,-0.024947,-7.22E-05,3.79E-05,-0.78352,-7.89E-05,0.019928,-0.014091,-0.46509},
      {-2.06E-06,-0.00010346,-0.037435,-6.97E-05,8.73E-05,-0.77235,-9.10E-05,0.026704,-0.018868,-0.45589},
      {0,6.90E-08,0.7071,0,3.39E-06,1.96E-06,-4.88E-08,0.5,-0.35355,0.18463},
      {0,7.41E-08,0.7071,0,3.66E-06,2.11E-06,-5.24E-08,0.5,-0.35355,0.18463},
      {0,8.18E-08,0.7071,0,4.07E-06,2.35E-06,-5.78E-08,0.5,-0.35355,0.18463},
      {0,9.22E-08,0.7071,0,4.63E-06,2.68E-06,-6.52E-08,0.5,-0.35355,0.18463},
      {0,1.05E-07,0.7071,0,5.35E-06,3.09E-06,-7.45E-08,0.5,-0.35355,0.18463},
      {0,1.21E-07,0.7071,0,6.23E-06,3.60E-06,-8.54E-08,0.5,-0.35355,0.18463},
      {0,1.38E-07,0.7071,0,7.26E-06,4.19E-06,-9.77E-08,0.49999,-0.35355,0.18463},
      {0,1.57E-07,0.7071,0,8.42E-06,4.86E-06,-1.11E-07,0.49999,-0.35355,0.18463},
      {0,1.76E-07,0.7071,0,9.71E-06,5.60E-06,-1.25E-07,0.49999,-0.35355,0.18463},
      {0,1.95E-07,0.7071,0,1.11E-05,6.40E-06,-1.38E-07,0.49999,-0.35355,0.18463},
      {7.63E-06,2.04E-07,0.7029,0,0.0041709,0.0024081,5.40E-06,0.49705,-0.35146,0.18064},
      {1.87E-05,2.09E-07,0.6969,0,0.010133,0.0058505,1.34E-05,0.49282,-0.34847,0.17494},
      {3.11E-05,2.12E-07,0.69012,0,0.016875,0.0097429,2.23E-05,0.48804,-0.34508,0.16848},
      {4.47E-05,2.12E-07,0.68249,0,0.024458,0.014121,3.21E-05,0.48267,-0.34128,0.16122},
      {5.93E-05,2.09E-07,0.67395,0,0.032951,0.019024,4.26E-05,0.47666,-0.33702,0.15309},
      {9.92E-05,8.49E-08,0.66372,-7.32E-09,0.034607,0.01027,7.11E-05,0.46951,-0.33194,0.14345},
      {0.00016697,-1.38E-07,0.65088,-2.04E-08,0.027142,-0.017133,0.00011938,0.4606,-0.32561,0.13145},
      {0.00023226,-3.10E-07,0.63581,-2.99E-08,0.018848,-0.048588,0.0001658,0.45009,-0.31814,0.11728},
      {0.00029201,-4.25E-07,0.6183,-3.55E-08,0.0096356,-0.084495,0.00020817,0.43783,-0.30944,0.10074},
      {0.0003216,9.48E-08,0.58913,-7.23E-08,0.0033042,-0.12887,0.00022817,0.41735,-0.29495,0.073041},
      {0.0003094,1.14E-06,0.5434,-3.03E-07,0.0023925,-0.18295,0.00021773,0.3852,-0.27223,0.029506},
      {0.0002869,1.65E-06,0.49452,-7.57E-07,0.0013756,-0.2409,0.00020072,0.35081,-0.24792,-0.017084},
      {0.00025442,1.61E-06,0.44274,-1.46E-06,0.00026439,-0.30245,0.00017736,0.31432,-0.22213,-0.066517},
      {0.00016178,1.30E-06,0.35209,-8.05E-06,3.36E-05,-0.40625,0.0001078,0.25105,-0.17744,-0.15226},
      {8.20E-05,-2.95E-06,0.25149,-1.73E-05,2.04E-05,-0.52073,4.86E-05,0.18101,-0.12796,-0.24715},
      {3.75E-05,-7.52E-06,0.15156,-3.00E-05,1.88E-05,-0.63436,1.15E-05,0.11143,-0.078795,-0.34137},
      {1.18E-05,-1.44E-05,0.081601,-4.49E-05,1.58E-05,-0.71237,-1.44E-05,0.06365,-0.04503,-0.40605},
      {7.61E-06,-2.37E-05,0.047693,-6.01E-05,1.30E-05,-0.74733,-2.63E-05,0.042215,-0.029883,-0.43503},
      {4.04E-06,-3.48E-05,0.017444,-7.63E-05,1.24E-05,-0.77788,-3.73E-05,0.023472,-0.016641,-0.46037},
      {1.49E-06,-4.98E-05,-0.0061016,-9.07E-05,1.60E-05,-0.79843,-4.80E-05,0.010855,-0.0077273,-0.47741},
      {1.19E-06,-7.72E-05,-0.014729,-9.05E-05,3.19E-05,-0.79257,-6.03E-05,0.014409,-0.010229,-0.47258},
      {1.17E-06,-0.0001032,-0.022398,-8.91E-05,5.07E-05,-0.78708,-7.37E-05,0.017739,-0.012572,-0.46805},
      {0,7.46E-09,0.70711,0,5.00E-07,2.89E-07,-5.28E-09,0.5,-0.35355,0.18464},
      {0,1.02E-08,0.70711,0,6.92E-07,4.00E-07,-7.18E-09,0.5,-0.35355,0.18464},
      {0,1.42E-08,0.70711,0,9.87E-07,5.70E-07,-1.01E-08,0.5,-0.35355,0.18464},
      {0,1.97E-08,0.70711,0,1.39E-06,8.03E-07,-1.39E-08,0.5,-0.35355,0.18464},
      {0,2.65E-08,0.7071,0,1.91E-06,1.10E-06,-1.87E-08,0.5,-0.35355,0.18464},
      {0,3.44E-08,0.7071,0,2.54E-06,1.46E-06,-2.43E-08,0.5,-0.35355,0.18463},
      {0,4.31E-08,0.7071,0,3.27E-06,1.89E-06,-3.05E-08,0.5,-0.35355,0.18463},
      {0,5.23E-08,0.7071,0,4.09E-06,2.36E-06,-3.70E-08,0.5,-0.35355,0.18463},
      {0,6.14E-08,0.7071,0,5.00E-06,2.88E-06,-4.34E-08,0.5,-0.35355,0.18463},
      {0,7.01E-08,0.7071,0,5.96E-06,3.44E-06,-4.95E-08,0.5,-0.35355,0.18463},
      {0,7.76E-08,0.7071,0,6.96E-06,4.02E-06,-5.49E-08,0.5,-0.35355,0.18463},
      {2.23E-06,8.25E-08,0.70581,0,0.0012881,0.00074371,1.54E-06,0.49909,-0.35291,0.1834},
      {1.45E-05,8.14E-08,0.6984,0,0.0086684,0.0050047,1.03E-05,0.49386,-0.3492,0.17634},
      {2.68E-05,7.85E-08,0.69006,0,0.016972,0.0097986,1.91E-05,0.48798,-0.34504,0.16839},
      {3.89E-05,7.36E-08,0.68073,0,0.026271,0.015168,2.77E-05,0.4814,-0.34038,0.15948},
      {5.00E-05,6.66E-08,0.67032,0,0.036647,0.021158,3.55E-05,0.47405,-0.33518,0.14955},
      {6.73E-05,4.20E-08,0.65797,-8.90E-10,0.04426,0.020146,4.78E-05,0.46534,-0.32901,0.13778},
      {0.00011272,-2.79E-08,0.64047,-4.20E-09,0.035181,-0.015574,8.00E-05,0.45307,-0.32031,0.1212},
      {0.00014681,-6.17E-08,0.62064,-5.28E-09,0.025068,-0.055832,0.00010409,0.43912,-0.31043,0.10234},
      {0.00016542,-5.94E-08,0.5983,-4.27E-09,0.01381,-0.10101,0.00011717,0.42338,-0.29929,0.081047},
      {0.00015832,-2.41E-09,0.56892,-1.27E-07,0.0037052,-0.15236,0.00011194,0.40266,-0.28464,0.052989},
      {0.0001452,-6.74E-08,0.51757,-9.69E-07,0.0024888,-0.21353,0.00010229,0.36649,-0.25908,0.00401},
      {0.00014855,-4.31E-07,0.46149,-2.35E-06,0.0013052,-0.28012,0.00010417,0.32697,-0.23113,-0.049498},
      {0.00014993,-1.14E-06,0.40165,-4.39E-06,0.00032294,-0.35071,0.00010446,0.28478,-0.2013,-0.10662},
      {0.00012112,-4.58E-06,0.31787,-1.37E-05,1.02E-05,-0.44682,8.02E-05,0.22626,-0.15994,-0.18586},
      {7.74E-05,-1.09E-05,0.2241,-2.96E-05,9.13E-06,-0.55336,4.29E-05,0.16102,-0.11384,-0.2742},
      {3.70E-05,-1.92E-05,0.13415,-4.88E-05,7.98E-06,-0.65552,7.11E-06,0.098454,-0.069634,-0.3589},
      {9.21E-06,-2.97E-05,0.063072,-6.98E-05,7.29E-06,-0.73523,-2.08E-05,0.049621,-0.035133,-0.425},
      {5.77E-06,-4.04E-05,0.036812,-8.89E-05,9.27E-06,-0.76106,-3.11E-05,0.033768,-0.023938,-0.44642},
      {3.18E-06,-5.23E-05,0.013907,-0.00011266,1.21E-05,-0.78313,-4.11E-05,0.020212,-0.014371,-0.46472},
      {1.43E-06,-6.55E-05,-0.005534,-0.00014259,1.57E-05,-0.80135,-5.11E-05,0.0089966,-0.0064657,-0.47983},
      {1.41E-06,-9.05E-05,-0.01269,-0.0001408,3.48E-05,-0.79661,-6.56E-05,0.011865,-0.0084806,-0.47593},
      {0,1.00E-10,0.70711,0,0,0,-7.09E-11,0.5,-0.35355,0.18464},
      {0,1.01E-10,0.70711,0,0,0,-7.16E-11,0.5,-0.35355,0.18464},
      {0,1.03E-10,0.70711,0,0,0,-7.25E-11,0.5,-0.35355,0.18464},
      {0,1.04E-10,0.70711,0,0,0,-7.36E-11,0.5,-0.35355,0.18464},
      {0,1.06E-10,0.70711,0,0,0,-7.48E-11,0.5,-0.35355,0.18464},
      {0,2.71E-09,0.70711,0,3.55E-07,2.05E-07,-1.92E-09,0.5,-0.35355,0.18464},
      {0,5.90E-09,0.70711,0,8.27E-07,4.78E-07,-4.17E-09,0.5,-0.35355,0.18464},
      {0,9.05E-09,0.70711,0,1.35E-06,7.82E-07,-6.40E-09,0.5,-0.35355,0.18464},
      {0,1.19E-08,0.7071,0,1.92E-06,1.11E-06,-8.43E-09,0.5,-0.35355,0.18464},
      {0,1.42E-08,0.7071,0,2.52E-06,1.45E-06,-1.01E-08,0.5,-0.35355,0.18463},
      {0,1.57E-08,0.7071,0,3.12E-06,1.80E-06,-1.11E-08,0.5,-0.35355,0.18463},
      {0,1.62E-08,0.7071,0,3.71E-06,2.14E-06,-1.14E-08,0.5,-0.35355,0.18463},
      {0,1.54E-08,0.7071,0,4.27E-06,2.46E-06,-1.09E-08,0.5,-0.35355,0.18463},
      {5.67E-06,1.26E-08,0.70057,0,0.0065215,0.0037652,4.01E-06,0.49538,-0.35029,0.17839},
      {1.23E-05,8.61E-09,0.69036,0,0.016711,0.0096481,8.70E-06,0.48817,-0.34519,0.16864},
      {1.65E-05,3.95E-09,0.67899,0,0.028066,0.016204,1.17E-05,0.48014,-0.3395,0.15777},
      {1.87E-05,0,0.66697,0,0.040072,0.023136,1.32E-05,0.47165,-0.3335,0.14627},
      {2.41E-05,0,0.65686,0,0.050173,0.028967,1.71E-05,0.46451,-0.32844,0.1366},
      {5.03E-05,0,0.63644,0,0.038273,-0.015131,3.56E-05,0.4501,-0.31825,0.11713},
      {7.75E-05,0,0.60998,0,0.025439,-0.067825,5.48E-05,0.43143,-0.30503,0.091866},
      {0.00010373,0,0.57737,0,0.013319,-0.1264,7.33E-05,0.40839,-0.28873,0.060701},
      {0.00012808,-5.64E-09,0.53781,-1.67E-08,0.002219,-0.19125,9.06E-05,0.38044,-0.26895,0.022875},
      {0.00012715,-8.21E-07,0.48008,-2.25E-06,0.0014035,-0.25913,8.92E-05,0.33973,-0.24017,-0.032238},
      {0.00012436,-2.04E-06,0.41877,-5.24E-06,0.00073788,-0.3309,8.62E-05,0.29648,-0.20959,-0.090794},
      {0.0001142,-3.83E-06,0.34915,-9.79E-06,0.00022959,-0.41196,7.77E-05,0.24739,-0.17488,-0.15727},
      {8.80E-05,-8.83E-06,0.26874,-2.22E-05,4.06E-06,-0.50428,5.51E-05,0.19109,-0.13509,-0.23349},
      {5.16E-05,-1.80E-05,0.18537,-4.51E-05,4.01E-06,-0.59883,2.19E-05,0.13318,-0.094179,-0.31189},
      {2.34E-05,-2.85E-05,0.10966,-7.13E-05,3.98E-06,-0.68465,-5.95E-06,0.080594,-0.057032,-0.38305},
      {4.54E-06,-4.01E-05,0.045533,-0.00010086,4.21E-06,-0.75707,-2.76E-05,0.036208,-0.02568,-0.4431},
      {2.66E-06,-5.28E-05,0.026035,-0.00013111,7.50E-06,-0.77547,-3.77E-05,0.024888,-0.0177,-0.45836},
      {1.43E-06,-6.69E-05,0.0095709,-0.00016888,1.14E-05,-0.79055,-4.80E-05,0.015585,-0.011154,-0.47087},
      {8.09E-07,-8.28E-05,-0.0037871,-0.00021567,1.59E-05,-0.80229,-5.88E-05,0.0083164,-0.0060537,-0.48061},
      {0,9.04E-12,0.70711,0,0,0,-6.39E-12,0.5,-0.35355,0.18464},
      {0,8.85E-12,0.70711,0,0,0,-6.26E-12,0.5,-0.35355,0.18464},
      {0,8.51E-12,0.70711,0,0,0,-6.02E-12,0.5,-0.35355,0.18464},
      {0,7.97E-12,0.70711,0,0,0,-5.63E-12,0.5,-0.35355,0.18464},
      {0,7.12E-12,0.70711,0,0,0,-5.04E-12,0.5,-0.35355,0.18464},
      {0,5.87E-12,0.70711,0,0,0,-4.15E-12,0.5,-0.35355,0.18464},
      {0,4.11E-12,0.70711,0,0,0,-2.90E-12,0.5,-0.35355,0.18464},
      {0,1.23E-11,0.70711,0,4.01E-08,2.32E-08,-8.73E-12,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,3.14E-07,1.81E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,5.74E-07,3.31E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,8.03E-07,4.64E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,9.85E-07,5.69E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.10E-06,6.37E-07,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,1.14E-06,6.58E-07,0,0.5,-0.35355,0.18464},
      {1.40E-06,0,0.7045,0,0.0026066,0.0015049,9.91E-07,0.49816,-0.35225,0.18214},
      {6.18E-06,0,0.69584,0,0.011258,0.0064997,4.37E-06,0.49204,-0.34792,0.17386},
      {1.10E-05,0,0.68751,0,0.019581,0.011305,7.76E-06,0.48615,-0.34375,0.16589},
      {1.57E-05,0,0.6797,0,0.027385,0.015811,1.11E-05,0.48062,-0.33985,0.15842},
      {2.02E-05,0,0.67308,0,0.034002,0.019631,1.43E-05,0.47594,-0.33653,0.15208},
      {3.76E-05,0,0.64718,0,0.027595,-0.021328,2.66E-05,0.45764,-0.32358,0.12732},
      {5.84E-05,0,0.606,0,0.017511,-0.086289,4.13E-05,0.42854,-0.303,0.087942},
      {7.59E-05,0,0.5564,0,0.0089628,-0.15831,5.37E-05,0.39349,-0.2782,0.0405},
      {8.97E-05,0,0.49772,0,0.0020589,-0.23799,6.34E-05,0.35201,-0.24887,-0.015652},
      {8.25E-05,-1.68E-06,0.43014,-4.31E-06,0.00068186,-0.31823,5.71E-05,0.30434,-0.21516,-0.080203},
      {6.95E-05,-4.33E-06,0.35765,-1.10E-05,0.0003539,-0.4023,4.60E-05,0.2532,-0.17901,-0.14944},
      {5.52E-05,-7.77E-06,0.28069,-1.97E-05,0.00011747,-0.49137,3.34E-05,0.1989,-0.14063,-0.22296},
      {3.79E-05,-1.37E-05,0.2032,-3.47E-05,1.50E-06,-0.58052,1.68E-05,0.14442,-0.10213,-0.29671},
      {1.87E-05,-2.48E-05,0.1384,-6.39E-05,1.62E-06,-0.65398,-4.81E-06,0.099397,-0.070326,-0.35762},
      {6.23E-06,-3.69E-05,0.081116,-9.68E-05,1.75E-06,-0.71901,-2.21E-05,0.059526,-0.042166,-0.41154},
      {5.26E-07,-5.01E-05,0.031905,-0.00013345,1.88E-06,-0.77503,-3.52E-05,0.025167,-0.017904,-0.45799},
      {2.05E-07,-6.51E-05,0.015946,-0.00018145,6.03E-06,-0.78986,-4.59E-05,0.016002,-0.011464,-0.47029},
      {3.17E-07,-8.26E-05,0.005512,-0.00024452,1.13E-05,-0.79804,-5.82E-05,0.010886,-0.0079003,-0.47708},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {0,0,0.70711,0,0,0,0,0.5,-0.35355,0.18464},
      {3.76E-06,0,0.70225,0,0.0048467,0.0027983,2.66E-06,0.49657,-0.35113,0.18},
      {7.52E-06,0,0.69789,0,0.0092067,0.0053155,5.32E-06,0.49348,-0.34894,0.17582},
      {1.09E-05,0,0.69444,0,0.012651,0.0073041,7.72E-06,0.49105,-0.34722,0.17252},
      {1.38E-05,0,0.69201,0,0.015078,0.0087055,9.77E-06,0.48933,-0.346,0.1702},
      {2.17E-05,0,0.66484,0,0.012964,-0.026311,1.53E-05,0.47012,-0.33242,0.1442},
      {3.27E-05,0,0.60469,0,0.0077815,-0.10471,2.31E-05,0.4276,-0.30234,0.08664},
      {3.96E-05,0,0.53589,0,0.0037861,-0.19106,2.80E-05,0.37896,-0.26794,0.020784},
      {4.18E-05,0,0.45787,0,0.00099573,-0.28596,2.95E-05,0.3238,-0.22894,-0.053899},
      {3.22E-05,-2.43E-06,0.37927,-6.13E-06,0.00018566,-0.37801,2.10E-05,0.26829,-0.1897,-0.12906},
      {1.84E-05,-6.94E-06,0.30083,-1.74E-05,6.98E-05,-0.46862,8.10E-06,0.21291,-0.15056,-0.20402},
      {5.85E-06,-1.25E-05,0.2189,-3.11E-05,1.08E-05,-0.56321,-4.69E-06,0.15504,-0.10965,-0.28237},
      {2.11E-09,-2.00E-05,0.13926,-5.01E-05,5.20E-08,-0.65498,-1.42E-05,0.098825,-0.06992,-0.35844},
      {1.99E-08,-3.29E-05,0.094774,-8.76E-05,5.52E-07,-0.7053,-2.32E-05,0.067948,-0.048118,-0.40016},
      {3.33E-08,-4.60E-05,0.056016,-0.00012819,1.05E-06,-0.74913,-3.25E-05,0.04104,-0.029125,-0.43651},
      {4.24E-08,-5.95E-05,0.023192,-0.00017186,1.52E-06,-0.78624,-4.20E-05,0.018241,-0.013041,-0.46728},
      {1.09E-07,-7.77E-05,0.0091653,-0.00024101,5.52E-06,-0.79964,-5.49E-05,0.0099188,-0.0072157,-0.4784},
      {-0.44219,3.43E-06,-1.45E-05,-0.26447,-0.0001174,7.42E-05,0.31274,-0.1871,0.088811,0.18451},
      {-0.42559,3.06E-06,-1.86E-05,-0.28118,-5.73E-05,3.96E-05,0.30097,-0.19891,0.072139,0.18457},
      {-0.39927,2.48E-06,-2.50E-05,-0.30763,5.78E-06,3.24E-06,0.28232,-0.21761,0.045728,0.18463},
      {-0.3626,3.37E-06,-2.88E-05,-0.34422,8.73E-06,-1.82E-05,0.25641,-0.24351,0.0090935,0.18461},
      {-0.31423,5.97E-06,-3.74E-05,-0.39229,1.88E-05,-0.0001001,0.22226,-0.27758,-0.039153,0.18452},
      {-0.25793,8.55E-06,-4.65E-05,-0.44822,3.13E-05,-0.00019893,0.1825,-0.31724,-0.095316,0.18442},
      {-0.19458,1.05E-05,-5.44E-05,-0.51116,4.70E-05,-0.0002896,0.13774,-0.36192,-0.15857,0.18433},
      {-0.12946,1.14E-05,-6.18E-05,-0.57552,7.44E-05,-0.00032701,0.091702,-0.4079,-0.22363,0.18425},
      {-0.072277,1.81E-05,-8.45E-05,-0.63066,0.00016088,-0.00044127,0.051274,-0.44812,-0.28068,0.18404},
      {-0.042633,4.52E-05,-0.00021781,-0.65159,0.00060269,-0.0011232,0.030357,-0.46793,-0.30958,0.18284},
      {-0.019518,2.89E-05,-0.00035845,-0.66593,0.0011339,-0.0013228,0.013886,-0.48355,-0.33243,0.18191},
      {-0.0078045,1.05E-05,-0.00050384,-0.66882,0.0017916,-0.0006615,0.0055131,-0.49145,-0.3441,0.18152},
      {-0.0028699,2.09E-05,-0.00067919,-0.66255,0.0029756,0.00096457,0.0020136,-0.49431,-0.34883,0.18116},
      {-0.0016443,9.12E-05,-0.001184,-0.63052,0.0080211,0.0046093,0.0010695,-0.49019,-0.34768,0.17692},
      {-0.00092236,0.0001137,-0.0017253,-0.5876,0.01489,0.0086051,0.00053744,-0.48464,-0.3449,0.17034},
      {-0.00043819,9.17E-05,-0.0022293,-0.53859,0.023637,0.013677,0.00022205,-0.4783,-0.34102,0.16195},
      {-0.00017287,0.00011642,-0.0027869,-0.47028,0.040263,0.023235,3.92E-06,-0.46635,-0.3329,0.14597},
      {-0.00010484,0.0002828,-0.0034029,-0.31685,0.085546,0.049074,-0.00025985,-0.43163,-0.3098,0.10233},
      {-6.11E-05,0.00039362,-0.0034619,-0.14919,0.12968,0.07436,-0.0003488,-0.39915,-0.28755,0.059881},
      {-2.42E-05,0.00040261,-0.0030538,0.017635,0.1723,0.098879,-0.0002935,-0.36922,-0.26633,0.019},
      {-2.75E-06,0.00038755,-0.0027785,0.1588,0.20868,0.12017,-0.00028542,-0.3444,-0.24821,-0.01584},
      {-4.43E-06,0.00040905,-0.0036875,0.20918,0.24962,0.1441,-0.00031395,-0.31588,-0.22788,-0.054864},
      {-1.54E-05,7.98E-05,-0.0042121,0.24695,0.28604,0.16523,-8.22E-05,-0.29071,-0.21014,-0.089589},
      {-2.32E-05,4.46E-06,-0.0050737,0.28058,0.31211,0.18022,-3.30E-05,-0.27164,-0.19725,-0.11441},
      {-2.92E-05,2.73E-06,-0.0060784,0.30172,0.33292,0.19216,-3.36E-05,-0.25583,-0.18693,-0.13418},
      {-2.83E-05,1.37E-05,-0.012038,0.28073,0.36476,0.21052,-4.53E-05,-0.22489,-0.171,-0.16466},
      {-2.92E-05,4.98E-06,-0.017172,0.25496,0.39645,0.2288,-3.87E-05,-0.19521,-0.15516,-0.19501},
      {-3.14E-05,8.57E-06,-0.02157,0.22681,0.42682,0.24634,-3.35E-05,-0.16747,-0.13998,-0.22408},
      {-3.39E-05,1.51E-05,-0.024501,0.19777,0.4563,0.26337,-2.00E-05,-0.14242,-0.12527,-0.2523},
      {-1.81E-05,1.29E-05,-0.028415,0.19521,0.46013,0.26559,-1.53E-05,-0.13418,-0.12336,-0.25596},
      {-5.28E-07,8.02E-06,-0.032287,0.18187,0.47422,0.27374,-7.24E-06,-0.11879,-0.11632,-0.26944},
      {1.09E-05,3.56E-06,-0.035171,0.15397,0.50284,0.29027,-5.44E-07,-0.094536,-0.10203,-0.29683},
      {-0.46169,7.74E-06,-3.27E-06,-0.24451,-0.00019259,0.0001224,0.3267,-0.17302,0.10862,0.18443},
      {-0.44471,7.77E-06,-7.96E-06,-0.26145,-0.00012865,8.03E-05,0.31474,-0.18501,0.091686,0.18448},
      {-0.41599,8.55E-06,-1.82E-05,-0.28976,-9.14E-05,2.58E-05,0.29466,-0.20506,0.063317,0.18447},
      {-0.37689,9.74E-06,-3.17E-05,-0.32846,-4.65E-05,-6.71E-05,0.26718,-0.23249,0.024493,0.18443},
      {-0.32598,1.18E-05,-4.85E-05,-0.37921,4.02E-06,-0.00021772,0.23114,-0.26846,-0.026431,0.18434},
      {-0.26232,1.59E-05,-6.73E-05,-0.44315,5.22E-05,-0.00044104,0.18572,-0.3138,-0.090622,0.18419},
      {-0.19657,1.84E-05,-7.69E-05,-0.50821,7.73E-05,-0.00053967,0.13926,-0.36016,-0.15626,0.18407},
      {-0.13158,1.95E-05,-8.56E-05,-0.57234,0.00010772,-0.00059457,0.093311,-0.40603,-0.22119,0.18398},
      {-0.085873,6.99E-05,-0.00018313,-0.61167,0.00039041,-0.00096527,0.061142,-0.43746,-0.26621,0.18327},
      {-0.053608,0.00010873,-0.00033647,-0.63452,0.00084993,-0.0012777,0.038399,-0.45925,-0.29781,0.18235},
      {-0.028315,0.00010191,-0.00049493,-0.65042,0.001394,-0.0011761,0.020409,-0.47652,-0.32291,0.18165},
      {-0.0098796,4.63E-05,-0.00064312,-0.6603,0.0020346,-0.00048018,0.0071108,-0.48945,-0.34166,0.18131},
      {-0.0029087,6.46E-05,-0.00092776,-0.64977,0.0044676,0.0021167,0.0019974,-0.49249,-0.34808,0.17997},
      {-0.0017361,0.00013705,-0.0014409,-0.6135,0.0099449,0.005724,0.0010883,-0.48772,-0.34652,0.17507},
      {-0.00097667,0.00016242,-0.0019923,-0.569,0.016928,0.0097905,0.00052838,-0.48201,-0.34371,0.16837},
      {-0.00046243,0.00014229,-0.0025067,-0.51875,0.025726,0.014896,0.00019123,-0.47557,-0.33983,0.15993},
      {-0.00020761,0.00039472,-0.0033667,-0.43435,0.049325,0.02843,-0.00023608,-0.45772,-0.32785,0.13722},
      {-0.00010738,0.0003617,-0.0038865,-0.3006,0.094508,0.054144,-0.00033822,-0.42385,-0.3051,0.093634},
      {-6.07E-05,0.00047323,-0.0039036,-0.13531,0.1383,0.079213,-0.00040884,-0.39171,-0.28304,0.051499},
      {-2.05E-05,0.00047863,-0.0034794,0.029785,0.17997,0.10322,-0.00034617,-0.36251,-0.26229,0.011487},
      {-7.62E-07,0.00055075,-0.0034745,0.15303,0.21771,0.12533,-0.00040869,-0.33669,-0.24344,-0.024579},
      {-2.36E-06,0.0005881,-0.0043317,0.20292,0.25818,0.14901,-0.00045025,-0.30863,-0.22334,-0.063131},
      {-1.35E-05,0.00026692,-0.0048128,0.24029,0.29416,0.16989,-0.00022599,-0.28389,-0.20583,-0.097398},
      {-2.49E-05,3.88E-06,-0.0052853,0.27003,0.32281,0.18639,-3.72E-05,-0.26379,-0.19189,-0.12465},
      {-3.01E-05,7.88E-06,-0.0070015,0.28708,0.34462,0.1989,-4.34E-05,-0.24624,-0.18106,-0.14539},
      {-2.91E-05,1.24E-05,-0.012871,0.26733,0.37562,0.21679,-5.12E-05,-0.21601,-0.16555,-0.17507},
      {-3.01E-05,5.07E-06,-0.018095,0.24348,0.40568,0.23412,-4.72E-05,-0.18735,-0.15052,-0.20386},
      {-3.24E-05,8.35E-06,-0.022488,0.21656,0.43529,0.25122,-4.30E-05,-0.16016,-0.13572,-0.23221},
      {-3.51E-05,1.51E-05,-0.025393,0.18715,0.46548,0.26866,-2.79E-05,-0.13464,-0.12066,-0.26109},
      {-1.67E-05,1.32E-05,-0.029588,0.1849,0.46895,0.27068,-1.60E-05,-0.12626,-0.11894,-0.26441},
      {1.78E-06,7.92E-06,-0.033594,0.17265,0.48188,0.27816,-7.55E-06,-0.11151,-0.11248,-0.27677},
      {1.41E-05,3.10E-06,-0.036606,0.14571,0.50946,0.29409,-4.21E-07,-0.087813,-0.09871,-0.30316},
      {-0.50076,1.51E-05,4.27E-06,-0.201,-0.00026647,0.00018051,0.3569,-0.14239,0.15165,0.18426},
      {-0.48291,1.41E-05,-2.78E-06,-0.21832,-0.00023329,0.0001501,0.3446,-0.15466,0.13429,0.18427},
      {-0.45495,1.25E-05,-1.35E-05,-0.24561,-0.00018357,9.41E-05,0.32523,-0.17399,0.10694,0.18427},
      {-0.41557,1.05E-05,-2.80E-05,-0.28433,-0.0001188,-1.26E-06,0.29775,-0.20143,0.06811,0.18425},
      {-0.36189,8.46E-06,-4.72E-05,-0.33761,-3.89E-05,-0.00014785,0.25988,-0.23923,0.014614,0.18419},
      {-0.29528,7.98E-06,-7.08E-05,-0.40425,4.60E-05,-0.00035448,0.21242,-0.28661,-0.05245,0.18407},
      {-0.21891,1.28E-05,-9.71E-05,-0.48122,0.0001198,-0.00063683,0.15746,-0.34148,-0.13013,0.18387},
      {-0.1452,0.00013833,-0.00020815,-0.5511,0.0003611,-0.0010841,0.10401,-0.39425,-0.20523,0.1832},
      {-0.098843,0.00019589,-0.00038083,-0.58849,0.00077212,-0.0012781,0.070855,-0.42666,-0.25177,0.18245},
      {-0.064592,0.00024314,-0.00056203,-0.61232,0.0012475,-0.0011973,0.046708,-0.45003,-0.2855,0.18184},
      {-0.03752,0.00024355,-0.00074492,-0.62911,0.0018032,-0.00076112,0.027455,-0.4687,-0.3125,0.1814},
      {-0.017523,0.00019401,-0.00091437,-0.63977,0.0024513,0.00021285,0.013046,-0.48287,-0.33292,0.18128},
      {-0.0062232,0.00054726,-0.0014056,-0.62054,0.0072161,0.0040688,0.004335,-0.48615,-0.34243,0.17762},
      {-0.0017932,0.00022073,-0.0018646,-0.58527,0.012942,0.0074676,0.0010456,-0.48366,-0.34478,0.17218},
      {-0.0009986,0.00024678,-0.002436,-0.53885,0.019966,0.011564,0.00046267,-0.47783,-0.34197,0.16543},
      {-0.00045523,0.00022671,-0.0029689,-0.4871,0.028749,0.016666,0.00010715,-0.47134,-0.33812,0.15699},
      {-0.00025256,0.001052,-0.0045029,-0.38146,0.062621,0.036083,-0.0007891,-0.44469,-0.32018,0.12438},
      {-0.00014097,0.0011393,-0.0051204,-0.25397,0.10617,0.060886,-0.0009678,-0.41223,-0.29817,0.082376},
      {-5.71E-05,0.00060458,-0.0045972,-0.11476,0.15177,0.086779,-0.00049671,-0.38005,-0.27599,0.038375},
      {-1.29E-05,0.00059621,-0.0041597,0.047489,0.19171,0.10986,-0.00043579,-0.35219,-0.25609,7.92E-07},
      {3.21E-06,0.00084283,-0.0045463,0.14434,0.2319,0.13347,-0.00062912,-0.32467,-0.23592,-0.038292},
      {1.30E-06,0.0008866,-0.0053305,0.19342,0.27157,0.1567,-0.0006781,-0.29737,-0.21624,-0.07603},
      {-1.03E-05,0.000564,-0.0057499,0.2301,0.30677,0.17714,-0.00045558,-0.27333,-0.19914,-0.10952},
      {-2.66E-05,5.98E-05,-0.0057221,0.25504,0.33854,0.19545,-8.74E-05,-0.25202,-0.18394,-0.13972},
      {-3.15E-05,1.50E-05,-0.0084266,0.26507,0.36241,0.20916,-5.85E-05,-0.23161,-0.17213,-0.16243},
      {-3.01E-05,7.76E-06,-0.014186,0.24711,0.39215,0.22632,-5.90E-05,-0.20244,-0.15726,-0.19091},
      {-3.17E-05,5.07E-06,-0.019567,0.22622,0.41973,0.24222,-6.11E-05,-0.1753,-0.14346,-0.21733},
      {-3.38E-05,7.71E-06,-0.02396,0.20105,0.44825,0.25868,-5.84E-05,-0.14888,-0.12921,-0.24463},
      {-3.63E-05,1.38E-05,-0.026905,0.17337,0.47727,0.27545,-4.47E-05,-0.12413,-0.11473,-0.27239},
      {-1.41E-05,1.35E-05,-0.03148,0.16955,0.48196,0.27819,-1.70E-05,-0.11436,-0.11242,-0.27687},
      {5.82E-06,7.63E-06,-0.035696,0.15887,0.4932,0.28469,-7.86E-06,-0.1005,-0.1068,-0.28762},
      {1.96E-05,2.23E-06,-0.038907,0.13332,0.51926,0.29975,-4.31E-08,-0.077609,-0.093794,-0.31255},
      {-0.51454,-0.00085517,0.00026042,-0.16049,-5.52E-05,0.0001056,0.38301,-0.11362,0.19147,0.18429},
      {-0.50093,-0.00079838,0.00022691,-0.17505,-4.81E-05,0.00011428,0.37276,-0.12397,0.17686,0.18428},
      {-0.48011,-0.00067955,0.00016977,-0.19786,-2.95E-05,0.00012447,0.35676,-0.14019,0.15398,0.18427},
      {-0.45163,-0.00045605,7.98E-05,-0.23004,1.14E-05,0.00013228,0.33431,-0.1631,0.1217,0.18428},
      {-0.41531,-7.23E-05,-5.51E-05,-0.27261,8.87E-05,0.0001318,0.30479,-0.19345,0.078987,0.1843},
      {-0.34789,0.00020066,-0.00011429,-0.33816,0.00021704,-4.40E-05,0.25693,-0.2406,0.012222,0.18415},
      {-0.26911,0.00096967,-0.00025394,-0.40686,0.00045576,-0.00025262,0.20235,-0.2925,-0.06164,0.18361},
      {-0.1948,0.0012578,-0.00043007,-0.47284,0.00078149,-0.0005154,0.14905,-0.34428,-0.13546,0.18292},
      {-0.12868,0.0010919,-0.00065452,-0.53254,0.0012182,-0.00070814,0.099314,-0.39398,-0.20646,0.18217},
      {-0.07366,0.00058494,-0.00094145,-0.58285,0.0017923,-0.00066026,0.055008,-0.43997,-0.27228,0.18147},
      {-0.043716,0.00048708,-0.0011688,-0.60264,0.0023739,1.96E-05,0.032667,-0.46235,-0.3045,0.18122},
      {-0.024838,0.0019111,-0.0018224,-0.59063,0.0067644,0.0034549,0.018106,-0.47078,-0.32019,0.17774},
      {-0.012648,0.0025461,-0.0024685,-0.56,0.012312,0.006958,0.0085119,-0.47331,-0.32959,0.17264},
      {-0.0047542,0.0018333,-0.0028807,-0.52848,0.017725,0.010227,0.0026747,-0.47397,-0.33651,0.16752},
      {-0.0009275,0.00037786,-0.003121,-0.49473,0.023795,0.013815,0.00028843,-0.47197,-0.33981,0.16171},
      {-0.00044933,0.00095699,-0.0043511,-0.42734,0.040066,0.023229,-0.00054239,-0.45884,-0.33138,0.14606},
      {-0.00029971,0.00233,-0.0065088,-0.31312,0.079399,0.045804,-0.0018543,-0.