"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Easter"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Easter", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Easter", { abbr: true }),

	"1932" : helpers.makeTestYear("Pacific/Easter", [
		["1932-09-01T07:17:27+00:00", "23:59:59", "EMT", 26248 / 60],
		["1932-09-01T07:17:28+00:00", "00:17:28", "-07", 420]
	]),

	"1968" : helpers.makeTestYear("Pacific/Easter", [
		["1968-11-03T03:59:59+00:00", "20:59:59", "-07", 420],
		["1968-11-03T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1969" : helpers.makeTestYear("Pacific/Easter", [
		["1969-03-30T02:59:59+00:00", "20:59:59", "-06", 360],
		["1969-03-30T03:00:00+00:00", "20:00:00", "-07", 420],
		["1969-11-23T03:59:59+00:00", "20:59:59", "-07", 420],
		["1969-11-23T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1970" : helpers.makeTestYear("Pacific/Easter", [
		["1970-03-29T02:59:59+00:00", "20:59:59", "-06", 360],
		["1970-03-29T03:00:00+00:00", "20:00:00", "-07", 420],
		["1970-10-11T03:59:59+00:00", "20:59:59", "-07", 420],
		["1970-10-11T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1971" : helpers.makeTestYear("Pacific/Easter", [
		["1971-03-14T02:59:59+00:00", "20:59:59", "-06", 360],
		["1971-03-14T03:00:00+00:00", "20:00:00", "-07", 420],
		["1971-10-10T03:59:59+00:00", "20:59:59", "-07", 420],
		["1971-10-10T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1972" : helpers.makeTestYear("Pacific/Easter", [
		["1972-03-12T02:59:59+00:00", "20:59:59", "-06", 360],
		["1972-03-12T03:00:00+00:00", "20:00:00", "-07", 420],
		["1972-10-15T03:59:59+00:00", "20:59:59", "-07", 420],
		["1972-10-15T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1973" : helpers.makeTestYear("Pacific/Easter", [
		["1973-03-11T02:59:59+00:00", "20:59:59", "-06", 360],
		["1973-03-11T03:00:00+00:00", "20:00:00", "-07", 420],
		["1973-09-30T03:59:59+00:00", "20:59:59", "-07", 420],
		["1973-09-30T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1974" : helpers.makeTestYear("Pacific/Easter", [
		["1974-03-10T02:59:59+00:00", "20:59:59", "-06", 360],
		["1974-03-10T03:00:00+00:00", "20:00:00", "-07", 420],
		["1974-10-13T03:59:59+00:00", "20:59:59", "-07", 420],
		["1974-10-13T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1975" : helpers.makeTestYear("Pacific/Easter", [
		["1975-03-09T02:59:59+00:00", "20:59:59", "-06", 360],
		["1975-03-09T03:00:00+00:00", "20:00:00", "-07", 420],
		["1975-10-12T03:59:59+00:00", "20:59:59", "-07", 420],
		["1975-10-12T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1976" : helpers.makeTestYear("Pacific/Easter", [
		["1976-03-14T02:59:59+00:00", "20:59:59", "-06", 360],
		["1976-03-14T03:00:00+00:00", "20:00:00", "-07", 420],
		["1976-10-10T03:59:59+00:00", "20:59:59", "-07", 420],
		["1976-10-10T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1977" : helpers.makeTestYear("Pacific/Easter", [
		["1977-03-13T02:59:59+00:00", "20:59:59", "-06", 360],
		["1977-03-13T03:00:00+00:00", "20:00:00", "-07", 420],
		["1977-10-09T03:59:59+00:00", "20:59:59", "-07", 420],
		["1977-10-09T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1978" : helpers.makeTestYear("Pacific/Easter", [
		["1978-03-12T02:59:59+00:00", "20:59:59", "-06", 360],
		["1978-03-12T03:00:00+00:00", "20:00:00", "-07", 420],
		["1978-10-15T03:59:59+00:00", "20:59:59", "-07", 420],
		["1978-10-15T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1979" : helpers.makeTestYear("Pacific/Easter", [
		["1979-03-11T02:59:59+00:00", "20:59:59", "-06", 360],
		["1979-03-11T03:00:00+00:00", "20:00:00", "-07", 420],
		["1979-10-14T03:59:59+00:00", "20:59:59", "-07", 420],
		["1979-10-14T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1980" : helpers.makeTestYear("Pacific/Easter", [
		["1980-03-09T02:59:59+00:00", "20:59:59", "-06", 360],
		["1980-03-09T03:00:00+00:00", "20:00:00", "-07", 420],
		["1980-10-12T03:59:59+00:00", "20:59:59", "-07", 420],
		["1980-10-12T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1981" : helpers.makeTestYear("Pacific/Easter", [
		["1981-03-15T02:59:59+00:00", "20:59:59", "-06", 360],
		["1981-03-15T03:00:00+00:00", "20:00:00", "-07", 420],
		["1981-10-11T03:59:59+00:00", "20:59:59", "-07", 420],
		["1981-10-11T04:00:00+00:00", "22:00:00", "-06", 360]
	]),

	"1982" : helpers.makeTestYear("Pacific/Easter", [
		["1982-03-14T02:59:59+00:00", "20:59:59", "-06", 360],
		["1982-03-14T03:00:00+00:00", "21:00:00", "-06", 360],
		["1982-10-10T03:59:59+00:00", "21:59:59", "-06", 360],
		["1982-10-10T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1983" : helpers.makeTestYear("Pacific/Easter", [
		["1983-03-13T02:59:59+00:00", "21:59:59", "-05", 300],
		["1983-03-13T03:00:00+00:00", "21:00:00", "-06", 360],
		["1983-10-09T03:59:59+00:00", "21:59:59", "-06", 360],
		["1983-10-09T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1984" : helpers.makeTestYear("Pacific/Easter", [
		["1984-03-11T02:59:59+00:00", "21:59:59", "-05", 300],
		["1984-03-11T03:00:00+00:00", "21:00:00", "-06", 360],
		["1984-10-14T03:59:59+00:00", "21:59:59", "-06", 360],
		["1984-10-14T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1985" : helpers.makeTestYear("Pacific/Easter", [
		["1985-03-10T02:59:59+00:00", "21:59:59", "-05", 300],
		["1985-03-10T03:00:00+00:00", "21:00:00", "-06", 360],
		["1985-10-13T03:59:59+00:00", "21:59:59", "-06", 360],
		["1985-10-13T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1986" : helpers.makeTestYear("Pacific/Easter", [
		["1986-03-09T02:59:59+00:00", "21:59:59", "-05", 300],
		["1986-03-09T03:00:00+00:00", "21:00:00", "-06", 360],
		["1986-10-12T03:59:59+00:00", "21:59:59", "-06", 360],
		["1986-10-12T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1987" : helpers.makeTestYear("Pacific/Easter", [
		["1987-04-12T02:59:59+00:00", "21:59:59", "-05", 300],
		["1987-04-12T03:00:00+00:00", "21:00:00", "-06", 360],
		["1987-10-11T03:59:59+00:00", "21:59:59", "-06", 360],
		["1987-10-11T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1988" : helpers.makeTestYear("Pacific/Easter", [
		["1988-03-13T02:59:59+00:00", "21:59:59", "-05", 300],
		["1988-03-13T03:00:00+00:00", "21:00:00", "-06", 360],
		["1988-10-09T03:59:59+00:00", "21:59:59", "-06", 360],
		["1988-10-09T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1989" : helpers.makeTestYear("Pacific/Easter", [
		["1989-03-12T02:59:59+00:00", "21:59:59", "-05", 300],
		["1989-03-12T03:00:00+00:00", "21:00:00", "-06", 360],
		["1989-10-15T03:59:59+00:00", "21:59:59", "-06", 360],
		["1989-10-15T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1990" : helpers.makeTestYear("Pacific/Easter", [
		["1990-03-11T02:59:59+00:00", "21:59:59", "-05", 300],
		["1990-03-11T03:00:00+00:00", "21:00:00", "-06", 360],
		["1990-09-16T03:59:59+00:00", "21:59:59", "-06", 360],
		["1990-09-16T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1991" : helpers.makeTestYear("Pacific/Easter", [
		["1991-03-10T02:59:59+00:00", "21:59:59", "-05", 300],
		["1991-03-10T03:00:00+00:00", "21:00:00", "-06", 360],
		["1991-10-13T03:59:59+00:00", "21:59:59", "-06", 360],
		["1991-10-13T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1992" : helpers.makeTestYear("Pacific/Easter", [
		["1992-03-15T02:59:59+00:00", "21:59:59", "-05", 300],
		["1992-03-15T03:00:00+00:00", "21:00:00", "-06", 360],
		["1992-10-11T03:59:59+00:00", "21:59:59", "-06", 360],
		["1992-10-11T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1993" : helpers.makeTestYear("Pacific/Easter", [
		["1993-03-14T02:59:59+00:00", "21:59:59", "-05", 300],
		["1993-03-14T03:00:00+00:00", "21:00:00", "-06", 360],
		["1993-10-10T03:59:59+00:00", "21:59:59", "-06", 360],
		["1993-10-10T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1994" : helpers.makeTestYear("Pacific/Easter", [
		["1994-03-13T02:59:59+00:00", "21:59:59", "-05", 300],
		["1994-03-13T03:00:00+00:00", "21:00:00", "-06", 360],
		["1994-10-09T03:59:59+00:00", "21:59:59", "-06", 360],
		["1994-10-09T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1995" : helpers.makeTestYear("Pacific/Easter", [
		["1995-03-12T02:59:59+00:00", "21:59:59", "-05", 300],
		["1995-03-12T03:00:00+00:00", "21:00:00", "-06", 360],
		["1995-10-15T03:59:59+00:00", "21:59:59", "-06", 360],
		["1995-10-15T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1996" : helpers.makeTestYear("Pacific/Easter", [
		["1996-03-10T02:59:59+00:00", "21:59:59", "-05", 300],
		["1996-03-10T03:00:00+00:00", "21:00:00", "-06", 360],
		["1996-10-13T03:59:59+00:00", "21:59:59", "-06", 360],
		["1996-10-13T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1997" : helpers.makeTestYear("Pacific/Easter", [
		["1997-03-30T02:59:59+00:00", "21:59:59", "-05", 300],
		["1997-03-30T03:00:00+00:00", "21:00:00", "-06", 360],
		["1997-10-12T03:59:59+00:00", "21:59:59", "-06", 360],
		["1997-10-12T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1998" : helpers.makeTestYear("Pacific/Easter", [
		["1998-03-15T02:59:59+00:00", "21:59:59", "-05", 300],
		["1998-03-15T03:00:00+00:00", "21:00:00", "-06", 360],
		["1998-09-27T03:59:59+00:00", "21:59:59", "-06", 360],
		["1998-09-27T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"1999" : helpers.makeTestYear("Pacific/Easter", [
		["1999-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["1999-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["1999-10-10T03:59:59+00:00", "21:59:59", "-06", 360],
		["1999-10-10T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2000" : helpers.makeTestYear("Pacific/Easter", [
		["2000-03-12T02:59:59+00:00", "21:59:59", "-05", 300],
		["2000-03-12T03:00:00+00:00", "21:00:00", "-06", 360],
		["2000-10-15T03:59:59+00:00", "21:59:59", "-06", 360],
		["2000-10-15T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2001" : helpers.makeTestYear("Pacific/Easter", [
		["2001-03-11T02:59:59+00:00", "21:59:59", "-05", 300],
		["2001-03-11T03:00:00+00:00", "21:00:00", "-06", 360],
		["2001-10-14T03:59:59+00:00", "21:59:59", "-06", 360],
		["2001-10-14T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2002" : helpers.makeTestYear("Pacific/Easter", [
		["2002-03-10T02:59:59+00:00", "21:59:59", "-05", 300],
		["2002-03-10T03:00:00+00:00", "21:00:00", "-06", 360],
		["2002-10-13T03:59:59+00:00", "21:59:59", "-06", 360],
		["2002-10-13T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2003" : helpers.makeTestYear("Pacific/Easter", [
		["2003-03-09T02:59:59+00:00", "21:59:59", "-05", 300],
		["2003-03-09T03:00:00+00:00", "21:00:00", "-06", 360],
		["2003-10-12T03:59:59+00:00", "21:59:59", "-06", 360],
		["2003-10-12T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2004" : helpers.makeTestYear("Pacific/Easter", [
		["2004-03-14T02:59:59+00:00", "21:59:59", "-05", 300],
		["2004-03-14T03:00:00+00:00", "21:00:00", "-06", 360],
		["2004-10-10T03:59:59+00:00", "21:59:59", "-06", 360],
		["2004-10-10T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2005" : helpers.makeTestYear("Pacific/Easter", [
		["2005-03-13T02:59:59+00:00", "21:59:59", "-05", 300],
		["2005-03-13T03:00:00+00:00", "21:00:00", "-06", 360],
		["2005-10-09T03:59:59+00:00", "21:59:59", "-06", 360],
		["2005-10-09T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2006" : helpers.makeTestYear("Pacific/Easter", [
		["2006-03-12T02:59:59+00:00", "21:59:59", "-05", 300],
		["2006-03-12T03:00:00+00:00", "21:00:00", "-06", 360],
		["2006-10-15T03:59:59+00:00", "21:59:59", "-06", 360],
		["2006-10-15T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2007" : helpers.makeTestYear("Pacific/Easter", [
		["2007-03-11T02:59:59+00:00", "21:59:59", "-05", 300],
		["2007-03-11T03:00:00+00:00", "21:00:00", "-06", 360],
		["2007-10-14T03:59:59+00:00", "21:59:59", "-06", 360],
		["2007-10-14T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2008" : helpers.makeTestYear("Pacific/Easter", [
		["2008-03-30T02:59:59+00:00", "21:59:59", "-05", 300],
		["2008-03-30T03:00:00+00:00", "21:00:00", "-06", 360],
		["2008-10-12T03:59:59+00:00", "21:59:59", "-06", 360],
		["2008-10-12T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2009" : helpers.makeTestYear("Pacific/Easter", [
		["2009-03-15T02:59:59+00:00", "21:59:59", "-05", 300],
		["2009-03-15T03:00:00+00:00", "21:00:00", "-06", 360],
		["2009-10-11T03:59:59+00:00", "21:59:59", "-06", 360],
		["2009-10-11T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2010" : helpers.makeTestYear("Pacific/Easter", [
		["2010-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2010-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2010-10-10T03:59:59+00:00", "21:59:59", "-06", 360],
		["2010-10-10T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2011" : helpers.makeTestYear("Pacific/Easter", [
		["2011-05-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2011-05-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2011-08-21T03:59:59+00:00", "21:59:59", "-06", 360],
		["2011-08-21T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2012" : helpers.makeTestYear("Pacific/Easter", [
		["2012-04-29T02:59:59+00:00", "21:59:59", "-05", 300],
		["2012-04-29T03:00:00+00:00", "21:00:00", "-06", 360],
		["2012-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2012-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2013" : helpers.makeTestYear("Pacific/Easter", [
		["2013-04-28T02:59:59+00:00", "21:59:59", "-05", 300],
		["2013-04-28T03:00:00+00:00", "21:00:00", "-06", 360],
		["2013-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2013-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2014" : helpers.makeTestYear("Pacific/Easter", [
		["2014-04-27T02:59:59+00:00", "21:59:59", "-05", 300],
		["2014-04-27T03:00:00+00:00", "21:00:00", "-06", 360],
		["2014-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2014-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2016" : helpers.makeTestYear("Pacific/Easter", [
		["2016-05-15T02:59:59+00:00", "21:59:59", "-05", 300],
		["2016-05-15T03:00:00+00:00", "21:00:00", "-06", 360],
		["2016-08-14T03:59:59+00:00", "21:59:59", "-06", 360],
		["2016-08-14T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2017" : helpers.makeTestYear("Pacific/Easter", [
		["2017-05-14T02:59:59+00:00", "21:59:59", "-05", 300],
		["2017-05-14T03:00:00+00:00", "21:00:00", "-06", 360],
		["2017-08-13T03:59:59+00:00", "21:59:59", "-06", 360],
		["2017-08-13T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2018" : helpers.makeTestYear("Pacific/Easter", [
		["2018-05-13T02:59:59+00:00", "21:59:59", "-05", 300],
		["2018-05-13T03:00:00+00:00", "21:00:00", "-06", 360],
		["2018-08-12T03:59:59+00:00", "21:59:59", "-06", 360],
		["2018-08-12T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2019" : helpers.makeTestYear("Pacific/Easter", [
		["2019-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2019-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2019-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2019-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2020" : helpers.makeTestYear("Pacific/Easter", [
		["2020-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2020-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2020-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2020-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2021" : helpers.makeTestYear("Pacific/Easter", [
		["2021-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2021-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2021-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2021-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2022" : helpers.makeTestYear("Pacific/Easter", [
		["2022-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2022-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2022-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2022-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2023" : helpers.makeTestYear("Pacific/Easter", [
		["2023-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2023-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2023-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2023-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2024" : helpers.makeTestYear("Pacific/Easter", [
		["2024-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2024-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2024-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2024-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2025" : helpers.makeTestYear("Pacific/Easter", [
		["2025-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2025-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2025-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2025-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2026" : helpers.makeTestYear("Pacific/Easter", [
		["2026-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2026-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2026-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2026-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2027" : helpers.makeTestYear("Pacific/Easter", [
		["2027-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2027-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2027-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2027-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2028" : helpers.makeTestYear("Pacific/Easter", [
		["2028-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2028-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2028-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2028-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2029" : helpers.makeTestYear("Pacific/Easter", [
		["2029-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2029-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2029-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2029-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2030" : helpers.makeTestYear("Pacific/Easter", [
		["2030-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2030-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2030-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2030-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2031" : helpers.makeTestYear("Pacific/Easter", [
		["2031-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2031-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2031-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2031-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2032" : helpers.makeTestYear("Pacific/Easter", [
		["2032-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2032-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2032-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2032-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2033" : helpers.makeTestYear("Pacific/Easter", [
		["2033-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2033-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2033-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2033-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2034" : helpers.makeTestYear("Pacific/Easter", [
		["2034-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2034-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2034-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2034-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2035" : helpers.makeTestYear("Pacific/Easter", [
		["2035-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2035-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2035-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2035-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2036" : helpers.makeTestYear("Pacific/Easter", [
		["2036-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2036-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2036-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2036-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2037" : helpers.makeTestYear("Pacific/Easter", [
		["2037-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2037-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2037-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2037-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2038" : helpers.makeTestYear("Pacific/Easter", [
		["2038-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2038-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2038-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2038-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2039" : helpers.makeTestYear("Pacific/Easter", [
		["2039-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2039-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2039-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2039-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2040" : helpers.makeTestYear("Pacific/Easter", [
		["2040-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2040-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2040-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2040-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2041" : helpers.makeTestYear("Pacific/Easter", [
		["2041-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2041-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2041-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2041-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2042" : helpers.makeTestYear("Pacific/Easter", [
		["2042-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2042-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2042-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2042-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2043" : helpers.makeTestYear("Pacific/Easter", [
		["2043-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2043-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2043-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2043-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2044" : helpers.makeTestYear("Pacific/Easter", [
		["2044-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2044-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2044-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2044-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2045" : helpers.makeTestYear("Pacific/Easter", [
		["2045-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2045-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2045-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2045-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2046" : helpers.makeTestYear("Pacific/Easter", [
		["2046-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2046-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2046-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2046-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2047" : helpers.makeTestYear("Pacific/Easter", [
		["2047-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2047-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2047-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2047-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2048" : helpers.makeTestYear("Pacific/Easter", [
		["2048-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2048-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2048-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2048-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2049" : helpers.makeTestYear("Pacific/Easter", [
		["2049-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2049-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2049-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2049-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2050" : helpers.makeTestYear("Pacific/Easter", [
		["2050-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2050-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2050-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2050-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2051" : helpers.makeTestYear("Pacific/Easter", [
		["2051-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2051-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2051-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2051-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2052" : helpers.makeTestYear("Pacific/Easter", [
		["2052-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2052-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2052-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2052-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2053" : helpers.makeTestYear("Pacific/Easter", [
		["2053-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2053-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2053-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2053-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2054" : helpers.makeTestYear("Pacific/Easter", [
		["2054-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2054-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2054-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2054-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2055" : helpers.makeTestYear("Pacific/Easter", [
		["2055-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2055-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2055-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2055-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2056" : helpers.makeTestYear("Pacific/Easter", [
		["2056-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2056-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2056-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2056-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2057" : helpers.makeTestYear("Pacific/Easter", [
		["2057-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2057-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2057-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2057-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2058" : helpers.makeTestYear("Pacific/Easter", [
		["2058-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2058-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2058-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2058-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2059" : helpers.makeTestYear("Pacific/Easter", [
		["2059-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2059-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2059-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2059-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2060" : helpers.makeTestYear("Pacific/Easter", [
		["2060-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2060-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2060-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2060-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2061" : helpers.makeTestYear("Pacific/Easter", [
		["2061-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2061-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2061-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2061-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2062" : helpers.makeTestYear("Pacific/Easter", [
		["2062-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2062-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2062-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2062-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2063" : helpers.makeTestYear("Pacific/Easter", [
		["2063-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2063-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2063-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2063-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2064" : helpers.makeTestYear("Pacific/Easter", [
		["2064-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2064-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2064-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2064-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2065" : helpers.makeTestYear("Pacific/Easter", [
		["2065-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2065-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2065-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2065-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2066" : helpers.makeTestYear("Pacific/Easter", [
		["2066-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2066-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2066-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2066-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2067" : helpers.makeTestYear("Pacific/Easter", [
		["2067-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2067-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2067-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2067-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2068" : helpers.makeTestYear("Pacific/Easter", [
		["2068-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2068-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2068-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2068-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2069" : helpers.makeTestYear("Pacific/Easter", [
		["2069-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2069-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2069-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2069-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2070" : helpers.makeTestYear("Pacific/Easter", [
		["2070-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2070-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2070-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2070-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2071" : helpers.makeTestYear("Pacific/Easter", [
		["2071-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2071-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2071-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2071-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2072" : helpers.makeTestYear("Pacific/Easter", [
		["2072-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2072-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2072-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2072-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2073" : helpers.makeTestYear("Pacific/Easter", [
		["2073-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2073-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2073-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2073-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2074" : helpers.makeTestYear("Pacific/Easter", [
		["2074-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2074-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2074-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2074-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2075" : helpers.makeTestYear("Pacific/Easter", [
		["2075-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2075-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2075-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2075-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2076" : helpers.makeTestYear("Pacific/Easter", [
		["2076-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2076-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2076-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2076-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2077" : helpers.makeTestYear("Pacific/Easter", [
		["2077-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2077-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2077-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2077-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2078" : helpers.makeTestYear("Pacific/Easter", [
		["2078-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2078-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2078-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2078-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2079" : helpers.makeTestYear("Pacific/Easter", [
		["2079-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2079-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2079-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2079-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2080" : helpers.makeTestYear("Pacific/Easter", [
		["2080-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2080-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2080-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2080-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2081" : helpers.makeTestYear("Pacific/Easter", [
		["2081-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2081-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2081-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2081-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2082" : helpers.makeTestYear("Pacific/Easter", [
		["2082-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2082-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2082-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2082-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2083" : helpers.makeTestYear("Pacific/Easter", [
		["2083-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2083-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2083-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2083-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2084" : helpers.makeTestYear("Pacific/Easter", [
		["2084-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2084-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2084-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2084-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2085" : helpers.makeTestYear("Pacific/Easter", [
		["2085-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2085-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2085-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2085-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2086" : helpers.makeTestYear("Pacific/Easter", [
		["2086-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2086-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2086-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2086-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2087" : helpers.makeTestYear("Pacific/Easter", [
		["2087-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2087-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2087-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2087-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2088" : helpers.makeTestYear("Pacific/Easter", [
		["2088-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2088-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2088-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2088-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2089" : helpers.makeTestYear("Pacific/Easter", [
		["2089-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2089-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2089-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2089-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2090" : helpers.makeTestYear("Pacific/Easter", [
		["2090-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2090-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2090-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2090-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2091" : helpers.makeTestYear("Pacific/Easter", [
		["2091-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2091-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2091-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2091-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2092" : helpers.makeTestYear("Pacific/Easter", [
		["2092-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2092-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2092-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2092-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2093" : helpers.makeTestYear("Pacific/Easter", [
		["2093-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2093-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2093-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2093-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2094" : helpers.makeTestYear("Pacific/Easter", [
		["2094-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2094-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2094-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2094-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2095" : helpers.makeTestYear("Pacific/Easter", [
		["2095-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2095-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2095-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2095-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2096" : helpers.makeTestYear("Pacific/Easter", [
		["2096-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2096-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2096-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2096-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2097" : helpers.makeTestYear("Pacific/Easter", [
		["2097-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2097-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2097-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2097-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2098" : helpers.makeTestYear("Pacific/Easter", [
		["2098-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2098-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2098-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2098-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2099" : helpers.makeTestYear("Pacific/Easter", [
		["2099-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2099-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2099-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2099-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2100" : helpers.makeTestYear("Pacific/Easter", [
		["2100-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2100-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2100-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2100-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2101" : helpers.makeTestYear("Pacific/Easter", [
		["2101-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2101-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2101-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2101-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2102" : helpers.makeTestYear("Pacific/Easter", [
		["2102-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2102-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2102-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2102-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2103" : helpers.makeTestYear("Pacific/Easter", [
		["2103-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2103-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2103-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2103-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2104" : helpers.makeTestYear("Pacific/Easter", [
		["2104-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2104-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2104-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2104-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2105" : helpers.makeTestYear("Pacific/Easter", [
		["2105-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2105-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2105-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2105-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2106" : helpers.makeTestYear("Pacific/Easter", [
		["2106-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2106-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2106-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2106-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2107" : helpers.makeTestYear("Pacific/Easter", [
		["2107-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2107-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2107-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2107-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2108" : helpers.makeTestYear("Pacific/Easter", [
		["2108-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2108-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2108-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2108-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2109" : helpers.makeTestYear("Pacific/Easter", [
		["2109-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2109-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2109-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2109-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2110" : helpers.makeTestYear("Pacific/Easter", [
		["2110-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2110-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2110-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2110-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2111" : helpers.makeTestYear("Pacific/Easter", [
		["2111-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2111-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2111-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2111-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2112" : helpers.makeTestYear("Pacific/Easter", [
		["2112-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2112-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2112-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2112-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2113" : helpers.makeTestYear("Pacific/Easter", [
		["2113-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2113-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2113-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2113-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2114" : helpers.makeTestYear("Pacific/Easter", [
		["2114-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2114-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2114-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2114-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2115" : helpers.makeTestYear("Pacific/Easter", [
		["2115-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2115-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2115-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2115-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2116" : helpers.makeTestYear("Pacific/Easter", [
		["2116-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2116-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2116-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2116-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2117" : helpers.makeTestYear("Pacific/Easter", [
		["2117-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2117-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2117-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2117-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2118" : helpers.makeTestYear("Pacific/Easter", [
		["2118-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2118-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2118-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2118-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2119" : helpers.makeTestYear("Pacific/Easter", [
		["2119-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2119-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2119-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2119-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2120" : helpers.makeTestYear("Pacific/Easter", [
		["2120-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2120-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2120-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2120-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2121" : helpers.makeTestYear("Pacific/Easter", [
		["2121-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2121-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2121-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2121-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2122" : helpers.makeTestYear("Pacific/Easter", [
		["2122-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2122-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2122-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2122-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2123" : helpers.makeTestYear("Pacific/Easter", [
		["2123-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2123-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2123-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2123-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2124" : helpers.makeTestYear("Pacific/Easter", [
		["2124-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2124-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2124-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2124-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2125" : helpers.makeTestYear("Pacific/Easter", [
		["2125-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2125-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2125-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2125-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2126" : helpers.makeTestYear("Pacific/Easter", [
		["2126-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2126-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2126-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2126-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2127" : helpers.makeTestYear("Pacific/Easter", [
		["2127-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2127-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2127-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2127-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2128" : helpers.makeTestYear("Pacific/Easter", [
		["2128-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2128-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2128-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2128-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2129" : helpers.makeTestYear("Pacific/Easter", [
		["2129-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2129-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2129-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2129-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2130" : helpers.makeTestYear("Pacific/Easter", [
		["2130-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2130-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2130-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2130-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2131" : helpers.makeTestYear("Pacific/Easter", [
		["2131-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2131-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2131-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2131-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2132" : helpers.makeTestYear("Pacific/Easter", [
		["2132-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2132-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2132-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2132-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2133" : helpers.makeTestYear("Pacific/Easter", [
		["2133-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2133-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2133-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2133-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2134" : helpers.makeTestYear("Pacific/Easter", [
		["2134-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2134-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2134-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2134-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2135" : helpers.makeTestYear("Pacific/Easter", [
		["2135-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2135-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2135-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2135-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2136" : helpers.makeTestYear("Pacific/Easter", [
		["2136-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2136-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2136-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2136-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2137" : helpers.makeTestYear("Pacific/Easter", [
		["2137-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2137-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2137-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2137-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2138" : helpers.makeTestYear("Pacific/Easter", [
		["2138-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2138-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2138-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2138-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2139" : helpers.makeTestYear("Pacific/Easter", [
		["2139-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2139-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2139-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2139-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2140" : helpers.makeTestYear("Pacific/Easter", [
		["2140-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2140-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2140-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2140-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2141" : helpers.makeTestYear("Pacific/Easter", [
		["2141-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2141-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2141-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2141-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2142" : helpers.makeTestYear("Pacific/Easter", [
		["2142-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2142-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2142-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2142-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2143" : helpers.makeTestYear("Pacific/Easter", [
		["2143-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2143-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2143-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2143-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2144" : helpers.makeTestYear("Pacific/Easter", [
		["2144-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2144-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2144-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2144-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2145" : helpers.makeTestYear("Pacific/Easter", [
		["2145-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2145-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2145-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2145-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2146" : helpers.makeTestYear("Pacific/Easter", [
		["2146-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2146-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2146-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2146-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2147" : helpers.makeTestYear("Pacific/Easter", [
		["2147-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2147-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2147-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2147-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2148" : helpers.makeTestYear("Pacific/Easter", [
		["2148-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2148-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2148-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2148-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2149" : helpers.makeTestYear("Pacific/Easter", [
		["2149-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2149-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2149-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2149-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2150" : helpers.makeTestYear("Pacific/Easter", [
		["2150-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2150-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2150-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2150-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2151" : helpers.makeTestYear("Pacific/Easter", [
		["2151-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2151-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2151-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2151-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2152" : helpers.makeTestYear("Pacific/Easter", [
		["2152-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2152-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2152-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2152-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2153" : helpers.makeTestYear("Pacific/Easter", [
		["2153-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2153-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2153-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2153-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2154" : helpers.makeTestYear("Pacific/Easter", [
		["2154-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2154-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2154-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2154-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2155" : helpers.makeTestYear("Pacific/Easter", [
		["2155-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2155-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2155-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2155-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2156" : helpers.makeTestYear("Pacific/Easter", [
		["2156-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2156-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2156-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2156-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2157" : helpers.makeTestYear("Pacific/Easter", [
		["2157-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2157-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2157-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2157-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2158" : helpers.makeTestYear("Pacific/Easter", [
		["2158-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2158-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2158-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2158-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2159" : helpers.makeTestYear("Pacific/Easter", [
		["2159-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2159-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2159-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2159-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2160" : helpers.makeTestYear("Pacific/Easter", [
		["2160-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2160-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2160-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2160-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2161" : helpers.makeTestYear("Pacific/Easter", [
		["2161-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2161-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2161-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2161-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2162" : helpers.makeTestYear("Pacific/Easter", [
		["2162-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2162-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2162-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2162-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2163" : helpers.makeTestYear("Pacific/Easter", [
		["2163-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2163-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2163-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2163-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2164" : helpers.makeTestYear("Pacific/Easter", [
		["2164-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2164-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2164-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2164-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2165" : helpers.makeTestYear("Pacific/Easter", [
		["2165-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2165-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2165-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2165-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2166" : helpers.makeTestYear("Pacific/Easter", [
		["2166-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2166-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2166-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2166-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2167" : helpers.makeTestYear("Pacific/Easter", [
		["2167-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2167-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2167-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2167-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2168" : helpers.makeTestYear("Pacific/Easter", [
		["2168-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2168-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2168-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2168-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2169" : helpers.makeTestYear("Pacific/Easter", [
		["2169-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2169-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2169-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2169-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2170" : helpers.makeTestYear("Pacific/Easter", [
		["2170-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2170-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2170-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2170-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2171" : helpers.makeTestYear("Pacific/Easter", [
		["2171-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2171-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2171-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2171-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2172" : helpers.makeTestYear("Pacific/Easter", [
		["2172-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2172-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2172-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2172-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2173" : helpers.makeTestYear("Pacific/Easter", [
		["2173-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2173-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2173-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2173-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2174" : helpers.makeTestYear("Pacific/Easter", [
		["2174-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2174-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2174-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2174-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2175" : helpers.makeTestYear("Pacific/Easter", [
		["2175-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2175-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2175-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2175-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2176" : helpers.makeTestYear("Pacific/Easter", [
		["2176-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2176-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2176-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2176-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2177" : helpers.makeTestYear("Pacific/Easter", [
		["2177-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2177-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2177-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2177-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2178" : helpers.makeTestYear("Pacific/Easter", [
		["2178-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2178-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2178-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2178-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2179" : helpers.makeTestYear("Pacific/Easter", [
		["2179-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2179-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2179-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2179-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2180" : helpers.makeTestYear("Pacific/Easter", [
		["2180-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2180-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2180-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2180-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2181" : helpers.makeTestYear("Pacific/Easter", [
		["2181-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2181-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2181-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2181-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2182" : helpers.makeTestYear("Pacific/Easter", [
		["2182-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2182-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2182-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2182-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2183" : helpers.makeTestYear("Pacific/Easter", [
		["2183-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2183-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2183-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2183-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2184" : helpers.makeTestYear("Pacific/Easter", [
		["2184-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2184-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2184-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2184-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2185" : helpers.makeTestYear("Pacific/Easter", [
		["2185-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2185-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2185-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2185-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2186" : helpers.makeTestYear("Pacific/Easter", [
		["2186-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2186-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2186-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2186-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2187" : helpers.makeTestYear("Pacific/Easter", [
		["2187-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2187-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2187-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2187-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2188" : helpers.makeTestYear("Pacific/Easter", [
		["2188-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2188-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2188-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2188-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2189" : helpers.makeTestYear("Pacific/Easter", [
		["2189-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2189-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2189-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2189-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2190" : helpers.makeTestYear("Pacific/Easter", [
		["2190-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2190-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2190-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2190-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2191" : helpers.makeTestYear("Pacific/Easter", [
		["2191-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2191-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2191-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2191-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2192" : helpers.makeTestYear("Pacific/Easter", [
		["2192-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2192-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2192-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2192-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2193" : helpers.makeTestYear("Pacific/Easter", [
		["2193-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2193-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2193-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2193-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2194" : helpers.makeTestYear("Pacific/Easter", [
		["2194-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2194-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2194-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2194-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2195" : helpers.makeTestYear("Pacific/Easter", [
		["2195-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2195-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2195-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2195-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2196" : helpers.makeTestYear("Pacific/Easter", [
		["2196-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2196-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2196-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2196-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2197" : helpers.makeTestYear("Pacific/Easter", [
		["2197-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2197-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2197-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2197-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2198" : helpers.makeTestYear("Pacific/Easter", [
		["2198-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2198-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2198-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2198-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2199" : helpers.makeTestYear("Pacific/Easter", [
		["2199-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2199-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2199-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2199-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2200" : helpers.makeTestYear("Pacific/Easter", [
		["2200-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2200-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2200-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2200-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2201" : helpers.makeTestYear("Pacific/Easter", [
		["2201-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2201-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2201-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2201-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2202" : helpers.makeTestYear("Pacific/Easter", [
		["2202-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2202-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2202-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2202-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2203" : helpers.makeTestYear("Pacific/Easter", [
		["2203-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2203-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2203-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2203-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2204" : helpers.makeTestYear("Pacific/Easter", [
		["2204-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2204-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2204-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2204-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2205" : helpers.makeTestYear("Pacific/Easter", [
		["2205-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2205-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2205-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2205-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2206" : helpers.makeTestYear("Pacific/Easter", [
		["2206-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2206-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2206-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2206-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2207" : helpers.makeTestYear("Pacific/Easter", [
		["2207-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2207-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2207-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2207-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2208" : helpers.makeTestYear("Pacific/Easter", [
		["2208-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2208-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2208-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2208-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2209" : helpers.makeTestYear("Pacific/Easter", [
		["2209-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2209-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2209-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2209-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2210" : helpers.makeTestYear("Pacific/Easter", [
		["2210-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2210-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2210-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2210-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2211" : helpers.makeTestYear("Pacific/Easter", [
		["2211-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2211-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2211-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2211-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2212" : helpers.makeTestYear("Pacific/Easter", [
		["2212-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2212-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2212-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2212-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2213" : helpers.makeTestYear("Pacific/Easter", [
		["2213-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2213-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2213-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2213-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2214" : helpers.makeTestYear("Pacific/Easter", [
		["2214-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2214-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2214-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2214-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2215" : helpers.makeTestYear("Pacific/Easter", [
		["2215-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2215-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2215-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2215-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2216" : helpers.makeTestYear("Pacific/Easter", [
		["2216-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2216-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2216-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2216-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2217" : helpers.makeTestYear("Pacific/Easter", [
		["2217-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2217-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2217-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2217-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2218" : helpers.makeTestYear("Pacific/Easter", [
		["2218-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2218-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2218-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2218-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2219" : helpers.makeTestYear("Pacific/Easter", [
		["2219-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2219-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2219-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2219-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2220" : helpers.makeTestYear("Pacific/Easter", [
		["2220-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2220-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2220-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2220-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2221" : helpers.makeTestYear("Pacific/Easter", [
		["2221-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2221-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2221-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2221-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2222" : helpers.makeTestYear("Pacific/Easter", [
		["2222-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2222-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2222-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2222-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2223" : helpers.makeTestYear("Pacific/Easter", [
		["2223-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2223-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2223-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2223-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2224" : helpers.makeTestYear("Pacific/Easter", [
		["2224-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2224-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2224-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2224-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2225" : helpers.makeTestYear("Pacific/Easter", [
		["2225-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2225-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2225-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2225-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2226" : helpers.makeTestYear("Pacific/Easter", [
		["2226-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2226-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2226-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2226-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2227" : helpers.makeTestYear("Pacific/Easter", [
		["2227-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2227-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2227-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2227-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2228" : helpers.makeTestYear("Pacific/Easter", [
		["2228-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2228-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2228-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2228-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2229" : helpers.makeTestYear("Pacific/Easter", [
		["2229-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2229-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2229-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2229-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2230" : helpers.makeTestYear("Pacific/Easter", [
		["2230-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2230-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2230-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2230-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2231" : helpers.makeTestYear("Pacific/Easter", [
		["2231-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2231-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2231-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2231-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2232" : helpers.makeTestYear("Pacific/Easter", [
		["2232-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2232-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2232-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2232-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2233" : helpers.makeTestYear("Pacific/Easter", [
		["2233-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2233-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2233-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2233-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2234" : helpers.makeTestYear("Pacific/Easter", [
		["2234-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2234-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2234-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2234-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2235" : helpers.makeTestYear("Pacific/Easter", [
		["2235-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2235-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2235-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2235-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2236" : helpers.makeTestYear("Pacific/Easter", [
		["2236-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2236-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2236-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2236-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2237" : helpers.makeTestYear("Pacific/Easter", [
		["2237-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2237-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2237-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2237-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2238" : helpers.makeTestYear("Pacific/Easter", [
		["2238-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2238-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2238-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2238-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2239" : helpers.makeTestYear("Pacific/Easter", [
		["2239-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2239-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2239-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2239-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2240" : helpers.makeTestYear("Pacific/Easter", [
		["2240-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2240-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2240-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2240-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2241" : helpers.makeTestYear("Pacific/Easter", [
		["2241-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2241-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2241-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2241-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2242" : helpers.makeTestYear("Pacific/Easter", [
		["2242-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2242-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2242-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2242-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2243" : helpers.makeTestYear("Pacific/Easter", [
		["2243-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2243-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2243-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2243-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2244" : helpers.makeTestYear("Pacific/Easter", [
		["2244-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2244-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2244-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2244-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2245" : helpers.makeTestYear("Pacific/Easter", [
		["2245-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2245-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2245-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2245-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2246" : helpers.makeTestYear("Pacific/Easter", [
		["2246-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2246-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2246-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2246-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2247" : helpers.makeTestYear("Pacific/Easter", [
		["2247-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2247-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2247-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2247-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2248" : helpers.makeTestYear("Pacific/Easter", [
		["2248-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2248-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2248-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2248-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2249" : helpers.makeTestYear("Pacific/Easter", [
		["2249-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2249-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2249-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2249-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2250" : helpers.makeTestYear("Pacific/Easter", [
		["2250-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2250-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2250-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2250-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2251" : helpers.makeTestYear("Pacific/Easter", [
		["2251-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2251-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2251-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2251-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2252" : helpers.makeTestYear("Pacific/Easter", [
		["2252-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2252-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2252-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2252-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2253" : helpers.makeTestYear("Pacific/Easter", [
		["2253-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2253-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2253-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2253-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2254" : helpers.makeTestYear("Pacific/Easter", [
		["2254-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2254-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2254-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2254-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2255" : helpers.makeTestYear("Pacific/Easter", [
		["2255-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2255-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2255-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2255-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2256" : helpers.makeTestYear("Pacific/Easter", [
		["2256-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2256-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2256-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2256-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2257" : helpers.makeTestYear("Pacific/Easter", [
		["2257-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2257-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2257-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2257-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2258" : helpers.makeTestYear("Pacific/Easter", [
		["2258-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2258-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2258-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2258-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2259" : helpers.makeTestYear("Pacific/Easter", [
		["2259-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2259-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2259-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2259-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2260" : helpers.makeTestYear("Pacific/Easter", [
		["2260-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2260-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2260-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2260-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2261" : helpers.makeTestYear("Pacific/Easter", [
		["2261-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2261-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2261-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2261-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2262" : helpers.makeTestYear("Pacific/Easter", [
		["2262-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2262-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2262-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2262-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2263" : helpers.makeTestYear("Pacific/Easter", [
		["2263-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2263-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2263-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2263-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2264" : helpers.makeTestYear("Pacific/Easter", [
		["2264-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2264-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2264-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2264-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2265" : helpers.makeTestYear("Pacific/Easter", [
		["2265-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2265-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2265-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2265-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2266" : helpers.makeTestYear("Pacific/Easter", [
		["2266-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2266-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2266-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2266-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2267" : helpers.makeTestYear("Pacific/Easter", [
		["2267-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2267-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2267-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2267-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2268" : helpers.makeTestYear("Pacific/Easter", [
		["2268-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2268-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2268-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2268-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2269" : helpers.makeTestYear("Pacific/Easter", [
		["2269-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2269-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2269-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2269-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2270" : helpers.makeTestYear("Pacific/Easter", [
		["2270-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2270-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2270-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2270-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2271" : helpers.makeTestYear("Pacific/Easter", [
		["2271-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2271-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2271-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2271-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2272" : helpers.makeTestYear("Pacific/Easter", [
		["2272-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2272-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2272-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2272-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2273" : helpers.makeTestYear("Pacific/Easter", [
		["2273-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2273-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2273-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2273-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2274" : helpers.makeTestYear("Pacific/Easter", [
		["2274-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2274-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2274-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2274-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2275" : helpers.makeTestYear("Pacific/Easter", [
		["2275-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2275-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2275-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2275-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2276" : helpers.makeTestYear("Pacific/Easter", [
		["2276-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2276-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2276-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2276-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2277" : helpers.makeTestYear("Pacific/Easter", [
		["2277-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2277-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2277-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2277-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2278" : helpers.makeTestYear("Pacific/Easter", [
		["2278-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2278-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2278-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2278-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2279" : helpers.makeTestYear("Pacific/Easter", [
		["2279-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2279-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2279-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2279-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2280" : helpers.makeTestYear("Pacific/Easter", [
		["2280-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2280-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2280-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2280-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2281" : helpers.makeTestYear("Pacific/Easter", [
		["2281-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2281-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2281-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2281-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2282" : helpers.makeTestYear("Pacific/Easter", [
		["2282-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2282-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2282-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2282-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2283" : helpers.makeTestYear("Pacific/Easter", [
		["2283-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2283-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2283-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2283-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2284" : helpers.makeTestYear("Pacific/Easter", [
		["2284-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2284-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2284-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2284-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2285" : helpers.makeTestYear("Pacific/Easter", [
		["2285-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2285-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2285-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2285-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2286" : helpers.makeTestYear("Pacific/Easter", [
		["2286-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2286-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2286-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2286-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2287" : helpers.makeTestYear("Pacific/Easter", [
		["2287-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2287-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2287-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2287-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2288" : helpers.makeTestYear("Pacific/Easter", [
		["2288-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2288-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2288-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2288-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2289" : helpers.makeTestYear("Pacific/Easter", [
		["2289-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2289-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2289-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2289-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2290" : helpers.makeTestYear("Pacific/Easter", [
		["2290-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2290-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2290-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2290-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2291" : helpers.makeTestYear("Pacific/Easter", [
		["2291-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2291-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2291-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2291-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2292" : helpers.makeTestYear("Pacific/Easter", [
		["2292-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2292-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2292-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2292-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2293" : helpers.makeTestYear("Pacific/Easter", [
		["2293-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2293-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2293-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2293-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2294" : helpers.makeTestYear("Pacific/Easter", [
		["2294-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2294-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2294-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2294-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2295" : helpers.makeTestYear("Pacific/Easter", [
		["2295-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2295-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2295-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2295-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2296" : helpers.makeTestYear("Pacific/Easter", [
		["2296-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2296-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2296-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2296-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2297" : helpers.makeTestYear("Pacific/Easter", [
		["2297-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2297-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2297-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2297-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2298" : helpers.makeTestYear("Pacific/Easter", [
		["2298-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2298-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2298-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2298-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2299" : helpers.makeTestYear("Pacific/Easter", [
		["2299-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2299-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2299-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2299-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2300" : helpers.makeTestYear("Pacific/Easter", [
		["2300-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2300-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2300-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2300-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2301" : helpers.makeTestYear("Pacific/Easter", [
		["2301-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2301-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2301-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2301-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2302" : helpers.makeTestYear("Pacific/Easter", [
		["2302-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2302-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2302-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2302-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2303" : helpers.makeTestYear("Pacific/Easter", [
		["2303-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2303-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2303-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2303-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2304" : helpers.makeTestYear("Pacific/Easter", [
		["2304-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2304-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2304-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2304-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2305" : helpers.makeTestYear("Pacific/Easter", [
		["2305-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2305-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2305-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2305-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2306" : helpers.makeTestYear("Pacific/Easter", [
		["2306-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2306-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2306-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2306-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2307" : helpers.makeTestYear("Pacific/Easter", [
		["2307-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2307-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2307-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2307-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2308" : helpers.makeTestYear("Pacific/Easter", [
		["2308-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2308-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2308-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2308-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2309" : helpers.makeTestYear("Pacific/Easter", [
		["2309-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2309-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2309-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2309-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2310" : helpers.makeTestYear("Pacific/Easter", [
		["2310-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2310-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2310-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2310-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2311" : helpers.makeTestYear("Pacific/Easter", [
		["2311-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2311-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2311-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2311-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2312" : helpers.makeTestYear("Pacific/Easter", [
		["2312-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2312-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2312-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2312-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2313" : helpers.makeTestYear("Pacific/Easter", [
		["2313-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2313-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2313-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2313-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2314" : helpers.makeTestYear("Pacific/Easter", [
		["2314-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2314-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2314-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2314-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2315" : helpers.makeTestYear("Pacific/Easter", [
		["2315-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2315-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2315-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2315-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2316" : helpers.makeTestYear("Pacific/Easter", [
		["2316-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2316-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2316-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2316-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2317" : helpers.makeTestYear("Pacific/Easter", [
		["2317-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2317-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2317-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2317-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2318" : helpers.makeTestYear("Pacific/Easter", [
		["2318-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2318-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2318-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2318-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2319" : helpers.makeTestYear("Pacific/Easter", [
		["2319-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2319-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2319-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2319-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2320" : helpers.makeTestYear("Pacific/Easter", [
		["2320-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2320-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2320-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2320-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2321" : helpers.makeTestYear("Pacific/Easter", [
		["2321-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2321-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2321-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2321-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2322" : helpers.makeTestYear("Pacific/Easter", [
		["2322-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2322-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2322-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2322-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2323" : helpers.makeTestYear("Pacific/Easter", [
		["2323-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2323-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2323-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2323-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2324" : helpers.makeTestYear("Pacific/Easter", [
		["2324-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2324-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2324-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2324-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2325" : helpers.makeTestYear("Pacific/Easter", [
		["2325-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2325-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2325-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2325-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2326" : helpers.makeTestYear("Pacific/Easter", [
		["2326-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2326-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2326-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2326-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2327" : helpers.makeTestYear("Pacific/Easter", [
		["2327-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2327-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2327-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2327-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2328" : helpers.makeTestYear("Pacific/Easter", [
		["2328-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2328-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2328-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2328-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2329" : helpers.makeTestYear("Pacific/Easter", [
		["2329-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2329-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2329-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2329-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2330" : helpers.makeTestYear("Pacific/Easter", [
		["2330-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2330-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2330-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2330-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2331" : helpers.makeTestYear("Pacific/Easter", [
		["2331-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2331-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2331-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2331-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2332" : helpers.makeTestYear("Pacific/Easter", [
		["2332-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2332-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2332-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2332-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2333" : helpers.makeTestYear("Pacific/Easter", [
		["2333-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2333-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2333-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2333-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2334" : helpers.makeTestYear("Pacific/Easter", [
		["2334-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2334-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2334-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2334-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2335" : helpers.makeTestYear("Pacific/Easter", [
		["2335-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2335-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2335-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2335-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2336" : helpers.makeTestYear("Pacific/Easter", [
		["2336-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2336-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2336-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2336-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2337" : helpers.makeTestYear("Pacific/Easter", [
		["2337-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2337-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2337-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2337-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2338" : helpers.makeTestYear("Pacific/Easter", [
		["2338-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2338-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2338-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2338-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2339" : helpers.makeTestYear("Pacific/Easter", [
		["2339-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2339-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2339-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2339-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2340" : helpers.makeTestYear("Pacific/Easter", [
		["2340-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2340-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2340-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2340-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2341" : helpers.makeTestYear("Pacific/Easter", [
		["2341-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2341-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2341-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2341-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2342" : helpers.makeTestYear("Pacific/Easter", [
		["2342-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2342-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2342-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2342-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2343" : helpers.makeTestYear("Pacific/Easter", [
		["2343-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2343-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2343-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2343-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2344" : helpers.makeTestYear("Pacific/Easter", [
		["2344-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2344-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2344-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2344-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2345" : helpers.makeTestYear("Pacific/Easter", [
		["2345-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2345-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2345-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2345-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2346" : helpers.makeTestYear("Pacific/Easter", [
		["2346-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2346-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2346-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2346-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2347" : helpers.makeTestYear("Pacific/Easter", [
		["2347-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2347-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2347-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2347-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2348" : helpers.makeTestYear("Pacific/Easter", [
		["2348-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2348-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2348-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2348-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2349" : helpers.makeTestYear("Pacific/Easter", [
		["2349-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2349-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2349-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2349-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2350" : helpers.makeTestYear("Pacific/Easter", [
		["2350-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2350-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2350-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2350-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2351" : helpers.makeTestYear("Pacific/Easter", [
		["2351-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2351-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2351-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2351-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2352" : helpers.makeTestYear("Pacific/Easter", [
		["2352-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2352-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2352-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2352-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2353" : helpers.makeTestYear("Pacific/Easter", [
		["2353-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2353-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2353-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2353-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2354" : helpers.makeTestYear("Pacific/Easter", [
		["2354-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2354-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2354-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2354-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2355" : helpers.makeTestYear("Pacific/Easter", [
		["2355-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2355-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2355-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2355-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2356" : helpers.makeTestYear("Pacific/Easter", [
		["2356-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2356-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2356-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2356-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2357" : helpers.makeTestYear("Pacific/Easter", [
		["2357-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2357-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2357-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2357-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2358" : helpers.makeTestYear("Pacific/Easter", [
		["2358-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2358-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2358-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2358-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2359" : helpers.makeTestYear("Pacific/Easter", [
		["2359-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2359-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2359-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2359-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2360" : helpers.makeTestYear("Pacific/Easter", [
		["2360-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2360-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2360-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2360-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2361" : helpers.makeTestYear("Pacific/Easter", [
		["2361-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2361-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2361-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2361-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2362" : helpers.makeTestYear("Pacific/Easter", [
		["2362-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2362-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2362-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2362-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2363" : helpers.makeTestYear("Pacific/Easter", [
		["2363-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2363-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2363-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2363-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2364" : helpers.makeTestYear("Pacific/Easter", [
		["2364-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2364-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2364-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2364-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2365" : helpers.makeTestYear("Pacific/Easter", [
		["2365-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2365-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2365-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2365-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2366" : helpers.makeTestYear("Pacific/Easter", [
		["2366-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2366-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2366-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2366-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2367" : helpers.makeTestYear("Pacific/Easter", [
		["2367-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2367-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2367-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2367-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2368" : helpers.makeTestYear("Pacific/Easter", [
		["2368-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2368-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2368-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2368-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2369" : helpers.makeTestYear("Pacific/Easter", [
		["2369-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2369-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2369-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2369-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2370" : helpers.makeTestYear("Pacific/Easter", [
		["2370-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2370-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2370-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2370-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2371" : helpers.makeTestYear("Pacific/Easter", [
		["2371-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2371-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2371-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2371-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2372" : helpers.makeTestYear("Pacific/Easter", [
		["2372-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2372-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2372-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2372-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2373" : helpers.makeTestYear("Pacific/Easter", [
		["2373-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2373-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2373-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2373-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2374" : helpers.makeTestYear("Pacific/Easter", [
		["2374-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2374-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2374-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2374-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2375" : helpers.makeTestYear("Pacific/Easter", [
		["2375-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2375-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2375-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2375-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2376" : helpers.makeTestYear("Pacific/Easter", [
		["2376-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2376-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2376-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2376-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2377" : helpers.makeTestYear("Pacific/Easter", [
		["2377-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2377-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2377-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2377-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2378" : helpers.makeTestYear("Pacific/Easter", [
		["2378-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2378-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2378-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2378-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2379" : helpers.makeTestYear("Pacific/Easter", [
		["2379-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2379-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2379-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2379-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2380" : helpers.makeTestYear("Pacific/Easter", [
		["2380-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2380-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2380-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2380-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2381" : helpers.makeTestYear("Pacific/Easter", [
		["2381-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2381-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2381-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2381-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2382" : helpers.makeTestYear("Pacific/Easter", [
		["2382-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2382-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2382-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2382-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2383" : helpers.makeTestYear("Pacific/Easter", [
		["2383-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2383-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2383-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2383-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2384" : helpers.makeTestYear("Pacific/Easter", [
		["2384-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2384-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2384-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2384-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2385" : helpers.makeTestYear("Pacific/Easter", [
		["2385-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2385-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2385-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2385-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2386" : helpers.makeTestYear("Pacific/Easter", [
		["2386-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2386-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2386-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2386-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2387" : helpers.makeTestYear("Pacific/Easter", [
		["2387-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2387-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2387-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2387-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2388" : helpers.makeTestYear("Pacific/Easter", [
		["2388-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2388-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2388-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2388-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2389" : helpers.makeTestYear("Pacific/Easter", [
		["2389-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2389-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2389-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2389-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2390" : helpers.makeTestYear("Pacific/Easter", [
		["2390-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2390-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2390-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2390-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2391" : helpers.makeTestYear("Pacific/Easter", [
		["2391-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2391-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2391-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2391-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2392" : helpers.makeTestYear("Pacific/Easter", [
		["2392-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2392-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2392-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2392-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2393" : helpers.makeTestYear("Pacific/Easter", [
		["2393-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2393-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2393-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2393-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2394" : helpers.makeTestYear("Pacific/Easter", [
		["2394-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2394-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2394-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2394-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2395" : helpers.makeTestYear("Pacific/Easter", [
		["2395-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2395-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2395-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2395-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2396" : helpers.makeTestYear("Pacific/Easter", [
		["2396-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2396-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2396-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2396-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2397" : helpers.makeTestYear("Pacific/Easter", [
		["2397-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2397-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2397-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2397-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2398" : helpers.makeTestYear("Pacific/Easter", [
		["2398-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2398-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2398-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2398-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2399" : helpers.makeTestYear("Pacific/Easter", [
		["2399-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2399-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2399-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2399-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2400" : helpers.makeTestYear("Pacific/Easter", [
		["2400-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2400-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2400-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2400-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2401" : helpers.makeTestYear("Pacific/Easter", [
		["2401-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2401-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2401-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2401-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2402" : helpers.makeTestYear("Pacific/Easter", [
		["2402-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2402-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2402-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2402-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2403" : helpers.makeTestYear("Pacific/Easter", [
		["2403-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2403-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2403-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2403-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2404" : helpers.makeTestYear("Pacific/Easter", [
		["2404-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2404-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2404-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2404-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2405" : helpers.makeTestYear("Pacific/Easter", [
		["2405-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2405-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2405-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2405-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2406" : helpers.makeTestYear("Pacific/Easter", [
		["2406-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2406-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2406-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2406-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2407" : helpers.makeTestYear("Pacific/Easter", [
		["2407-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2407-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2407-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2407-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2408" : helpers.makeTestYear("Pacific/Easter", [
		["2408-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2408-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2408-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2408-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2409" : helpers.makeTestYear("Pacific/Easter", [
		["2409-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2409-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2409-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2409-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2410" : helpers.makeTestYear("Pacific/Easter", [
		["2410-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2410-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2410-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2410-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2411" : helpers.makeTestYear("Pacific/Easter", [
		["2411-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2411-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2411-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2411-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2412" : helpers.makeTestYear("Pacific/Easter", [
		["2412-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2412-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2412-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2412-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2413" : helpers.makeTestYear("Pacific/Easter", [
		["2413-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2413-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2413-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2413-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2414" : helpers.makeTestYear("Pacific/Easter", [
		["2414-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2414-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2414-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2414-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2415" : helpers.makeTestYear("Pacific/Easter", [
		["2415-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2415-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2415-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2415-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2416" : helpers.makeTestYear("Pacific/Easter", [
		["2416-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2416-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2416-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2416-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2417" : helpers.makeTestYear("Pacific/Easter", [
		["2417-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2417-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2417-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2417-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2418" : helpers.makeTestYear("Pacific/Easter", [
		["2418-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2418-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2418-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2418-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2419" : helpers.makeTestYear("Pacific/Easter", [
		["2419-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2419-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2419-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2419-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2420" : helpers.makeTestYear("Pacific/Easter", [
		["2420-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2420-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2420-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2420-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2421" : helpers.makeTestYear("Pacific/Easter", [
		["2421-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2421-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2421-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2421-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2422" : helpers.makeTestYear("Pacific/Easter", [
		["2422-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2422-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2422-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2422-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2423" : helpers.makeTestYear("Pacific/Easter", [
		["2423-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2423-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2423-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2423-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2424" : helpers.makeTestYear("Pacific/Easter", [
		["2424-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2424-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2424-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2424-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2425" : helpers.makeTestYear("Pacific/Easter", [
		["2425-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2425-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2425-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2425-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2426" : helpers.makeTestYear("Pacific/Easter", [
		["2426-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2426-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2426-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2426-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2427" : helpers.makeTestYear("Pacific/Easter", [
		["2427-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2427-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2427-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2427-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2428" : helpers.makeTestYear("Pacific/Easter", [
		["2428-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2428-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2428-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2428-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2429" : helpers.makeTestYear("Pacific/Easter", [
		["2429-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2429-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2429-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2429-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2430" : helpers.makeTestYear("Pacific/Easter", [
		["2430-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2430-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2430-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2430-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2431" : helpers.makeTestYear("Pacific/Easter", [
		["2431-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2431-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2431-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2431-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2432" : helpers.makeTestYear("Pacific/Easter", [
		["2432-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2432-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2432-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2432-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2433" : helpers.makeTestYear("Pacific/Easter", [
		["2433-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2433-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2433-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2433-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2434" : helpers.makeTestYear("Pacific/Easter", [
		["2434-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2434-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2434-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2434-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2435" : helpers.makeTestYear("Pacific/Easter", [
		["2435-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2435-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2435-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2435-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2436" : helpers.makeTestYear("Pacific/Easter", [
		["2436-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2436-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2436-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2436-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2437" : helpers.makeTestYear("Pacific/Easter", [
		["2437-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2437-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2437-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2437-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2438" : helpers.makeTestYear("Pacific/Easter", [
		["2438-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2438-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2438-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2438-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2439" : helpers.makeTestYear("Pacific/Easter", [
		["2439-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2439-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2439-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2439-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2440" : helpers.makeTestYear("Pacific/Easter", [
		["2440-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2440-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2440-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2440-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2441" : helpers.makeTestYear("Pacific/Easter", [
		["2441-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2441-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2441-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2441-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2442" : helpers.makeTestYear("Pacific/Easter", [
		["2442-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2442-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2442-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2442-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2443" : helpers.makeTestYear("Pacific/Easter", [
		["2443-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2443-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2443-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2443-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2444" : helpers.makeTestYear("Pacific/Easter", [
		["2444-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2444-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2444-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2444-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2445" : helpers.makeTestYear("Pacific/Easter", [
		["2445-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2445-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2445-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2445-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2446" : helpers.makeTestYear("Pacific/Easter", [
		["2446-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2446-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2446-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2446-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2447" : helpers.makeTestYear("Pacific/Easter", [
		["2447-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2447-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2447-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2447-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2448" : helpers.makeTestYear("Pacific/Easter", [
		["2448-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2448-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2448-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2448-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2449" : helpers.makeTestYear("Pacific/Easter", [
		["2449-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2449-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2449-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2449-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2450" : helpers.makeTestYear("Pacific/Easter", [
		["2450-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2450-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2450-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2450-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2451" : helpers.makeTestYear("Pacific/Easter", [
		["2451-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2451-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2451-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2451-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2452" : helpers.makeTestYear("Pacific/Easter", [
		["2452-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2452-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2452-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2452-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2453" : helpers.makeTestYear("Pacific/Easter", [
		["2453-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2453-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2453-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2453-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2454" : helpers.makeTestYear("Pacific/Easter", [
		["2454-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2454-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2454-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2454-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2455" : helpers.makeTestYear("Pacific/Easter", [
		["2455-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2455-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2455-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2455-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2456" : helpers.makeTestYear("Pacific/Easter", [
		["2456-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2456-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2456-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2456-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2457" : helpers.makeTestYear("Pacific/Easter", [
		["2457-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2457-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2457-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2457-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2458" : helpers.makeTestYear("Pacific/Easter", [
		["2458-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2458-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2458-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2458-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2459" : helpers.makeTestYear("Pacific/Easter", [
		["2459-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2459-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2459-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2459-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2460" : helpers.makeTestYear("Pacific/Easter", [
		["2460-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2460-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2460-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2460-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2461" : helpers.makeTestYear("Pacific/Easter", [
		["2461-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2461-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2461-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2461-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2462" : helpers.makeTestYear("Pacific/Easter", [
		["2462-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2462-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2462-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2462-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2463" : helpers.makeTestYear("Pacific/Easter", [
		["2463-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2463-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2463-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2463-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2464" : helpers.makeTestYear("Pacific/Easter", [
		["2464-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2464-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2464-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2464-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2465" : helpers.makeTestYear("Pacific/Easter", [
		["2465-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2465-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2465-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2465-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2466" : helpers.makeTestYear("Pacific/Easter", [
		["2466-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2466-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2466-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2466-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2467" : helpers.makeTestYear("Pacific/Easter", [
		["2467-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2467-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2467-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2467-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2468" : helpers.makeTestYear("Pacific/Easter", [
		["2468-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2468-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2468-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2468-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2469" : helpers.makeTestYear("Pacific/Easter", [
		["2469-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2469-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2469-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2469-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2470" : helpers.makeTestYear("Pacific/Easter", [
		["2470-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2470-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2470-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2470-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2471" : helpers.makeTestYear("Pacific/Easter", [
		["2471-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2471-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2471-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2471-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2472" : helpers.makeTestYear("Pacific/Easter", [
		["2472-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2472-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2472-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2472-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2473" : helpers.makeTestYear("Pacific/Easter", [
		["2473-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2473-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2473-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2473-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2474" : helpers.makeTestYear("Pacific/Easter", [
		["2474-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2474-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2474-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2474-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2475" : helpers.makeTestYear("Pacific/Easter", [
		["2475-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2475-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2475-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2475-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2476" : helpers.makeTestYear("Pacific/Easter", [
		["2476-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2476-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2476-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2476-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2477" : helpers.makeTestYear("Pacific/Easter", [
		["2477-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2477-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2477-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2477-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2478" : helpers.makeTestYear("Pacific/Easter", [
		["2478-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2478-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2478-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2478-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2479" : helpers.makeTestYear("Pacific/Easter", [
		["2479-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2479-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2479-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2479-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2480" : helpers.makeTestYear("Pacific/Easter", [
		["2480-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2480-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2480-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2480-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2481" : helpers.makeTestYear("Pacific/Easter", [
		["2481-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2481-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2481-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2481-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2482" : helpers.makeTestYear("Pacific/Easter", [
		["2482-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2482-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2482-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2482-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2483" : helpers.makeTestYear("Pacific/Easter", [
		["2483-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2483-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2483-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2483-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2484" : helpers.makeTestYear("Pacific/Easter", [
		["2484-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2484-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2484-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2484-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2485" : helpers.makeTestYear("Pacific/Easter", [
		["2485-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2485-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2485-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2485-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2486" : helpers.makeTestYear("Pacific/Easter", [
		["2486-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2486-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2486-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2486-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2487" : helpers.makeTestYear("Pacific/Easter", [
		["2487-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2487-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2487-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2487-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2488" : helpers.makeTestYear("Pacific/Easter", [
		["2488-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2488-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2488-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2488-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2489" : helpers.makeTestYear("Pacific/Easter", [
		["2489-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2489-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2489-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2489-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2490" : helpers.makeTestYear("Pacific/Easter", [
		["2490-04-02T02:59:59+00:00", "21:59:59", "-05", 300],
		["2490-04-02T03:00:00+00:00", "21:00:00", "-06", 360],
		["2490-09-03T03:59:59+00:00", "21:59:59", "-06", 360],
		["2490-09-03T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2491" : helpers.makeTestYear("Pacific/Easter", [
		["2491-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2491-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2491-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2491-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2492" : helpers.makeTestYear("Pacific/Easter", [
		["2492-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2492-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2492-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2492-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2493" : helpers.makeTestYear("Pacific/Easter", [
		["2493-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2493-04-05T03:00:00+00:00", "21:00:00", "-06", 360],
		["2493-09-06T03:59:59+00:00", "21:59:59", "-06", 360],
		["2493-09-06T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2494" : helpers.makeTestYear("Pacific/Easter", [
		["2494-04-04T02:59:59+00:00", "21:59:59", "-05", 300],
		["2494-04-04T03:00:00+00:00", "21:00:00", "-06", 360],
		["2494-09-05T03:59:59+00:00", "21:59:59", "-06", 360],
		["2494-09-05T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2495" : helpers.makeTestYear("Pacific/Easter", [
		["2495-04-03T02:59:59+00:00", "21:59:59", "-05", 300],
		["2495-04-03T03:00:00+00:00", "21:00:00", "-06", 360],
		["2495-09-04T03:59:59+00:00", "21:59:59", "-06", 360],
		["2495-09-04T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2496" : helpers.makeTestYear("Pacific/Easter", [
		["2496-04-08T02:59:59+00:00", "21:59:59", "-05", 300],
		["2496-04-08T03:00:00+00:00", "21:00:00", "-06", 360],
		["2496-09-02T03:59:59+00:00", "21:59:59", "-06", 360],
		["2496-09-02T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2497" : helpers.makeTestYear("Pacific/Easter", [
		["2497-04-07T02:59:59+00:00", "21:59:59", "-05", 300],
		["2497-04-07T03:00:00+00:00", "21:00:00", "-06", 360],
		["2497-09-08T03:59:59+00:00", "21:59:59", "-06", 360],
		["2497-09-08T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2498" : helpers.makeTestYear("Pacific/Easter", [
		["2498-04-06T02:59:59+00:00", "21:59:59", "-05", 300],
		["2498-04-06T03:00:00+00:00", "21:00:00", "-06", 360],
		["2498-09-07T03:59:59+00:00", "21:59:59", "-06", 360],
		["2498-09-07T04:00:00+00:00", "23:00:00", "-05", 300]
	]),

	"2499" : helpers.makeTestYear("Pacific/Easter", [
		["2499-04-05T02:59:59+00:00", "21:59:59", "-05", 300],
		["2499-04-05T03:00:00+00:00", "21:00:00", "-06", 360]
	])
};