/*
 * This file was generated by LibCSS gen_parser 
 * 
 * Generated from:
 *
 * unicode_bidi:CSS_PROP_UNICODE_BIDI IDENT:( INHERIT: NORMAL:0,UNICODE_BIDI_NORMAL EMBED:0,UNICODE_BIDI_EMBED BIDI_OVERRIDE:0,UNICODE_BIDI_BIDI_OVERRIDE IDENT:)
 * 
 * Licensed under the MIT License,
 *		  http://www.opensource.org/licenses/mit-license.php
 * Copyright 2010 The NetSurf Browser Project.
 * Copyright (C) 2021 Beijing FMSoft Technologies Co., Ltd.
 */

#include <assert.h>
#include <string.h>

#include "bytecode/bytecode.h"
#include "bytecode/opcodes.h"
#include "parse/properties/properties.h"
#include "parse/properties/utils.h"

/**
 * Parse unicode_bidi
 *
 * \param c	  Parsing context
 * \param vector  Vector of tokens to process
 * \param ctx	  Pointer to vector iteration context
 * \param result  resulting style
 * \return CSS_OK on success,
 *	   CSS_NOMEM on memory exhaustion,
 *	   CSS_INVALID if the input is not valid
 *
 * Post condition: \a *ctx is updated with the next token to process
 *		   If the input is invalid, then \a *ctx remains unchanged.
 */
css_error css__parse_unicode_bidi(css_language *c,
		const parserutils_vector *vector, int *ctx,
		css_style *result)
{
	int orig_ctx = *ctx;
	css_error error;
	const css_token *token;
	bool match;

	token = parserutils_vector_iterate(vector, ctx);
	if ((token == NULL) || ((token->type != CSS_TOKEN_IDENT))) {
		*ctx = orig_ctx;
		return CSS_INVALID;
	}

	if ((lwc_string_caseless_isequal(token->idata, c->strings[INHERIT], &match) == lwc_error_ok && match)) {
			error = css_stylesheet_style_inherit(result, CSS_PROP_UNICODE_BIDI);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[NORMAL], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_NORMAL);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[EMBED], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_EMBED);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[BIDI_OVERRIDE], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_BIDI_OVERRIDE);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[ISOLATE], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_ISOLATE);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[ISOLATE_OVERRIDE], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_ISOLATE_OVERRIDE);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[PLAINTEXT], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_UNICODE_BIDI, 0,UNICODE_BIDI_PLAINTEXT);
	} else {
		error = CSS_INVALID;
	}

	if (error != CSS_OK)
		*ctx = orig_ctx;
	
	return error;
}

