/*
 * Copyright (C) 2007-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* FIXME */
#if defined CONFIG_MMU_TLB_SIZE
/* MMU with TLB for all sizes. */
#define SETS	CONFIG_MMU_TLB_ASSOC
#define LINES	(CONFIG_MMU_TLB_SIZE / SETS)

#elif defined CONFIG_MMU_TLB4M_SIZE && defined CONFIG_MMU_TLB4K_SIZE
/* MMU with distinct TLBs for 4K/4M sizes. */
#define SETS	CONFIG_MMU_TLB4K_ASSOC
#define LINES	(CONFIG_MMU_TLB4K_SIZE / SETS4K)

#else
/* No MMU - FIXME */
#define SETS	4
#define LINES	4
#endif


#ifdef INCLUDE

#include "glue-lru.h"

#endif /* INCLUDE */
#ifdef STATE

#if (defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT) \
	|| (defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT)
#define mmu_entry_t	uint64_t
#else
#define mmu_entry_t	uint32_t
#endif

struct {
	struct {
		struct {
			vaddr_t vaddr;
			mmu_entry_t entry;
			paddr_t psize_mask;
#if defined CONFIG_CPU_MTRR_SUPPORT && CONFIG_CPU_MTRR_SUPPORT
			uint8_t type;
#endif
		} cache[SETS];
		LRU_DECL(SETS, lru);
	} mmu_tlb[LINES];
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static int
NAME_(map)(struct cpssp *cpssp,
		vaddr_t vaddr,
		bool wflag,
		bool uflag,
		bool xflag,
		paddr_t *paddrp,
		uint16_t *errp);
#if 80486 <= CONFIG_CPU
/*forward*/ static void
NAME_(invlpg)(struct cpssp *cpssp, vaddr_t vaddr);
#endif
/*forward*/ static void
NAME_(tlb_flush)(struct cpssp *cpssp, int all);
/*forward*/ static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int val);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(read_entry)(struct cpssp *cpssp, paddr_t paddr, mmu_entry_t *valp)
{
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	if (NAME_(cr4_pae_get)(cpssp)) {
		/* mmu_entry_t == 8 byte */
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		NAME_(mr)(cpssp, paddr, 0xff, valp);
#else
		udata_t tmp0;
		udata_t tmp1;

		NAME_(mr)(cpssp, paddr + 0, 0xf, &tmp0);
		NAME_(mr)(cpssp, paddr + 4, 0xf, &tmp1);
		*valp = ((mmu_entry_t) tmp1 << 32) | ((mmu_entry_t) tmp0 << 0);
#endif
	} else
#endif /* defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT */
	{
		/* mmu_entry_t == 4 byte */
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		if (paddr & 0x7) {
			/* not 8 byte aligned -> read upper half */
			udata_t tmp;

			NAME_(mr)(cpssp, (paddr & ~0x7), 0xf0, &tmp);
			*valp = tmp >> 32;
		} else {
			/* 8 byte aligned -> read lower half */
			udata_t tmp;

			NAME_(mr)(cpssp, paddr, 0x0f, &tmp);
			*valp = tmp;
		}
#else
		udata_t tmp;

		NAME_(mr)(cpssp, paddr, 0xf, &tmp);
		*valp = (mmu_entry_t) tmp;
#endif
	}
}


static void
NAME_(write_entry)(struct cpssp *cpssp, paddr_t paddr, mmu_entry_t val)
{
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	if (NAME_(cr4_pae_get)(cpssp)) {
		/* mmu_entry_t == 8 byte */
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		NAME_(mw)(cpssp, paddr, 0xff, val);
#else
		udata_t tmp0;
		udata_t tmp1;

		tmp0 = val >> 0;
		tmp1 = val >> 32;
		NAME_(mw)(cpssp, paddr + 0, 0xf, tmp0);
		NAME_(mw)(cpssp, paddr + 4, 0xf, tmp1);
#endif
	} else
#endif /* defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT */
	{
		/* mmu_entry_t == 4 byte */
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		if (paddr & 0x7) {
			/* not 8 byte aligned -> read upper half */
			udata_t tmp;

			tmp = val << 32;
			NAME_(mw)(cpssp, (paddr & ~0x7), 0xf0, tmp);
		} else {
			/* 8 byte aligned -> read lower half */
			udata_t tmp;

			tmp = val;
			NAME_(mw)(cpssp, paddr, 0x0f, tmp);
		}
#else
		udata_t tmp;

		tmp = val;
		NAME_(mw)(cpssp, paddr, 0xf, tmp);
#endif
	}
}


static int
NAME_(check)(struct cpssp *cpssp, mmu_entry_t entry, bool wflag, bool uflag, bool xflag)
{
	int wp;

#if 80486 <= CONFIG_CPU
	wp = NAME_(cr0_wp_get)(cpssp);
#else
	wp = 0;
#endif

	return (((entry >> 0) & 1)
#if defined CONFIG_CPU_NX_SUPPORT && CONFIG_CPU_NX_SUPPORT
		&& (!xflag || ! (NAME_(efer_nxe_get)(cpssp) && NAME_(cr4_pae_get)(cpssp)) || !((entry >> 63) & 1))
#endif
		&& (!wflag || (! uflag && ! wp) || (entry >> 1) & 1)
		&& (!uflag || (entry >> 2) & 1));
}


#define MASK		((1L << 52) - 1)
#define CANON_MASK	((1L << CONFIG_CPU_PHYS_BITS) - 1)

static mmu_entry_t
NAME_(virt_entry)(struct cpssp *cpssp, vaddr_t addr, bool wflag, bool uflag, bool xflag, unsigned int *line, unsigned int *set)
{
	paddr_t idx;
	paddr_t table;
	paddr_t paddr;
	mmu_entry_t entry_old, entry_new;
	mmu_entry_t entry, valid;
	bool check;
	bool accessed;
	bool dirty;
	paddr_t mask;
	paddr_t psize;
	uint8_t shift;
	unsigned int line_old;

	entry = 0;
	valid = 0x7;
	psize = 4 * 1024;
	line_old = *line;

	// TODO check if addr is canonical + check if entries have bits 51:CONFIG_CPU_PHYS_BITS == 0
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	if (NAME_(cr4_pae_get)(cpssp)) {
		mask = 0x1ff << 3;
		shift = 9;
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		if (NAME_(efer_lme_get)(cpssp)) {
			table = NAME_(cr3_get)(cpssp) & ~0xfff;

			/* PML4 Entry */
			idx = (addr >> (shift + 3*shift)) & mask;
			paddr = table | idx;

			NAME_(read_entry)(cpssp, paddr, &entry_old);
			check = NAME_(check)(cpssp, entry_old, wflag, uflag, xflag);
			accessed = (entry_old >> 5) & 1;
			accessed |= check;
			entry_new = entry_old | (accessed << 5);
			if (entry_new != entry_old) {
				NAME_(write_entry)(cpssp, paddr, entry_new);
			}

			if (! ((entry_new >> 0) & 1)) {
				/* Page-Directory-Pointer-Table not present. */
				*line = (addr >> 12) % LINES;
				goto MAP_TLB;
			}

			valid &= entry_new;
			table = entry_new & (CANON_MASK & ~0xfff); // TODO

		} else
#endif /* defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT */
		{
			table = NAME_(cr3_get)(cpssp) & 0xffffffe0;
		}

		/* Page-Directory-Pointer-Table Entry */
		idx = (addr >> (shift + 2*shift)) & mask;
		paddr = table | idx;

		NAME_(read_entry)(cpssp, paddr, &entry_old);
		check = NAME_(check)(cpssp, entry_old, wflag, uflag, xflag);
		accessed = (entry_old >> 5) & 1;
		accessed |= check;
		dirty = (entry_old >> 6) & 1;
#if (defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT) \
 && (defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT)
		dirty |= wflag & check & ((entry_old >> 7) & 1) & NAME_(efer_lme_get)(cpssp);
#endif
		entry_new = entry_old | (accessed << 5) | (dirty << 6);
		if (entry_new != entry_old) {
			NAME_(write_entry)(cpssp, paddr, entry_new);
		}

		if (! ((entry_new >> 0) & 1)) {
			/* Page-Directory not present. */
			*line = (addr >> 12) % LINES;
			goto MAP_TLB;
		}

#if (defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT) \
 && (defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT)
		if (((entry_new >> 7) & 1) && NAME_(efer_lme_get)(cpssp)) {
			/* 1GB page. */
			entry = entry_new & (~0x7 | valid);
			psize = 1024 * 1024 * 1024;
			*line = (addr >> 30) % LINES;
			goto MAP_TLB;
		}
#endif

		valid &= entry_new;
		table = entry_new & (CANON_MASK & ~0xfff); // TODO

	} else
#endif /* defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT */
	{
		table = NAME_(cr3_get)(cpssp) & ~0xfff;
		mask = 0x3ff << 2;
		shift = 10;
	}

	/* Page-Directory Entry */
	idx = (addr >> (shift + 1*shift)) & mask;
	paddr = table | idx;

	/*
	 * Read-Modify-Write Cycle:
	 * Set "accessed" bit only if page is present.
	 * Set "dirty" bit only if page is present and write access
	 * and PS bit is set and PSE is enabled.
	 */
	NAME_(read_entry)(cpssp, paddr, &entry_old);
	check = NAME_(check)(cpssp, entry_old, wflag, uflag, xflag);
	accessed = (entry_old >> 5) & 1;
	accessed |= check;
	dirty = (entry_old >> 6) & 1;
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
	dirty |= wflag & check & ((entry_old >> 7) & 1) & NAME_(cr4_pse_get)(cpssp);
#endif
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	dirty |= wflag & check & ((entry_old >> 7) & 1) & NAME_(cr4_pae_get)(cpssp);
#endif
	entry_new = entry_old | (accessed << 5) | (dirty << 6);
	if (entry_new != entry_old) {
		NAME_(write_entry)(cpssp, paddr, entry_new);
	}

	if (! ((entry_new >> 0) & 1)) {
		/* Page-table not present. */
		*line = (addr >> 12) % LINES;
		goto MAP_TLB;
	}

#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	if (((entry_new >> 7) & 1) && NAME_(cr4_pae_get)(cpssp)) {
		/* 2MB page. */
		psize = 2 * 1024 * 1024;
		entry = entry_new & (~0x7 | valid);
		*line = (addr >> 21) % LINES;
		goto MAP_TLB;
	}
#endif
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
	if (((entry_new >> 7) & 1) && NAME_(cr4_pse_get)(cpssp)) {
		/* 4MB page. */
		psize = 4 * 1024 * 1024;
		entry = entry_new & (~0x7 | valid);
		*line = (addr >> 22) % LINES;
		goto MAP_TLB;
	}
#endif

	valid &= entry_new;
	table = entry_new & (CANON_MASK & ~0xfff); // TODO

	/* Page-Table Entry */
	idx = (addr >> (shift + 0*shift)) & mask;
	paddr = table | idx;

	/*
	 * Read-Modify-Write Cycle:
	 * Set "accessed" bit only if page is present.
	 * Set "dirty" bit only if page is present and write access.
	 */
	NAME_(read_entry)(cpssp, paddr, &entry_old);
	valid &= entry_old;
	check = NAME_(check)(cpssp, entry_old, wflag, uflag, xflag);
	accessed = (entry_old >> 5) & 1;
	accessed |= check;
	dirty = (entry_old >> 6) & 1;
	dirty |= wflag & check;
	entry_new = entry_old | (accessed << 5) | (dirty << 6);
	if (entry_new != entry_old) {
		NAME_(write_entry)(cpssp, paddr, entry_new);
	}

	if (! ((entry_new >> 0) & 1)) {
		/* Page not present. */
		*line = (addr >> 12) % LINES;
		goto MAP_TLB;
	}

	entry = entry_new & (~0x7 | valid);
	*line = (addr >> 12) % LINES;

MAP_TLB:
	if ((*set == SETS) || (*line != line_old)) {
		*set = lru_oldest(SETS, cpssp->NAME.mmu_tlb[*line].lru);
	}
	cpssp->NAME.mmu_tlb[*line].cache[*set].psize_mask = ~(psize - 1);
	cpssp->NAME.mmu_tlb[*line].cache[*set].vaddr = addr & ~(psize - 1);
	cpssp->NAME.mmu_tlb[*line].cache[*set].entry = entry;
#if defined CONFIG_CPU_MTRR_SUPPORT && CONFIG_CPU_MTRR_SUPPORT
	cpssp->NAME.mmu_tlb[*line].cache[*set].type = NAME_(type)(cpssp, entry & ~0xfff);
#endif
	return entry;
}


static int
NAME_(virt_addr)(
	struct cpssp *cpssp,
	vaddr_t addr,
	int wflag,
	int uflag,
	int xflag,
	paddr_t *paddrp,
	uint16_t *errp
)
{
	unsigned int set;
	unsigned int line;
	mmu_entry_t entry;
	paddr_t mask;

	unsigned int line4k;
	paddr_t mask4k;
	line4k = (addr >> 12) % LINES;
	mask4k = ~((1 << 12) - 1);
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
	unsigned int line4m;
	paddr_t mask4m;
	line4m = (addr >> 22) % LINES;
	mask4m = ~((1 << 22) - 1);
#endif
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	unsigned int line2m;
	paddr_t mask2m;
	line2m = (addr >> 21) % LINES;
	mask2m = ~((1 << 21) - 1);
#endif
#if defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT
	unsigned int line1g;
	paddr_t mask1g;
	line1g = (addr >> 30) % LINES;
	mask1g = ~((1 << 30) - 1);
#endif

	for (set = 0; ; set++) {
		if (set == SETS) {
			/* Miss */
			line = -1;
			goto TLB_MISS;
		}

#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
#if (defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT) \
		&& (defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT)
		paddr_t cond1g = (cpssp->NAME.mmu_tlb[line1g].cache[set].vaddr ^ (addr & mask1g)) |
			(cpssp->NAME.mmu_tlb[line1g].cache[set].psize_mask ^ mask1g) |
			(! NAME_(efer_lme_get)(cpssp));
		if (!cond1g) {
			/* Hit */
			line = line1g;
			break;
		}
#endif
		paddr_t cond2m = (cpssp->NAME.mmu_tlb[line2m].cache[set].vaddr ^ (addr & mask2m)) |
			(cpssp->NAME.mmu_tlb[line2m].cache[set].psize_mask ^ mask2m) |
			(!NAME_(cr4_pae_get)(cpssp));
		if (!cond2m) {
			/* Hit */
			line = line2m;
			break;
		}
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
		paddr_t cond4m = (cpssp->NAME.mmu_tlb[line4m].cache[set].vaddr ^ (addr & mask4m)) |
			(cpssp->NAME.mmu_tlb[line4m].cache[set].psize_mask ^ mask4m) |
			(!NAME_(cr4_pse_get)(cpssp)) | NAME_(cr4_pae_get)(cpssp);
		if (!cond4m) {
			/* Hit */
			line = line4m;
			break;
		}
#endif
#elif defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
		paddr_t cond4m = (cpssp->NAME.mmu_tlb[line4m].cache[set].vaddr ^ (addr & mask4m)) |
			(cpssp->NAME.mmu_tlb[line4m].cache[set].psize_mask ^ mask4m) |
			(!NAME_(cr4_pse_get)(cpssp));
		if (!cond4m) {
			/* Hit */
			line = line4m;
			break;
		}
#endif
		paddr_t cond4k = ((cpssp->NAME.mmu_tlb[line4k].cache[set].vaddr ^ (addr & mask4k)) |
			(cpssp->NAME.mmu_tlb[line4k].cache[set].psize_mask ^ mask4k));
		if (!cond4k) {
			/* Hit */
			line = line4k;
			break;
		}
	}

	lru_use(SETS, cpssp->NAME.mmu_tlb[line].lru, set);
	entry = cpssp->NAME.mmu_tlb[line].cache[set].entry;

	if ((wflag && ! ((entry >> 6) & 1))	/* "modified" bit */
	 || ! ((entry >> 5) & 1)		/* "accessed" bit */
	 || (uflag && ! ((entry >> 2) & 1))	/* "user" bit */
	 || (wflag && ! ((entry >> 1) & 1))	/* "write" bit */
	 || ! ((entry >> 0) & 1)) {		/* "present" bit */
		cpssp->NAME.mmu_tlb[line].cache[set].vaddr = -1;
		cpssp->NAME.mmu_tlb[line].cache[set].psize_mask = 0;
TLB_MISS:
		entry = NAME_(virt_entry)(cpssp, addr, wflag, uflag, xflag, &line, &set);
		lru_use(SETS, cpssp->NAME.mmu_tlb[line].lru, set);
	}

	/* Check. */
	if (! NAME_(check)(cpssp, entry, wflag, uflag, xflag)) {
		/* Page fault. */
		*paddrp = 0x00000000;
		*errp =
#if defined CONFIG_CPU_NX_SUPPORT && CONFIG_CPU_NX_SUPPORT
			((xflag & NAME_(efer_nxe_get)(cpssp) & NAME_(cr4_pae_get)(cpssp)) << 4) |
#endif
			(0 << 3) | (uflag << 2) | (wflag << 1) | (entry & 1);
		return 0;
	}

	mask = cpssp->NAME.mmu_tlb[line].cache[set].psize_mask;
	*paddrp = (entry & mask) | (addr & ~mask);
	*errp = 0;
	return 1;
}


static void
NAME_(tlb_flush)(struct cpssp *cpssp, int all)
{
	unsigned int line;
	unsigned int set;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
#if defined CONFIG_CPU_PGE_SUPPORT && CONFIG_CPU_PGE_SUPPORT
			if (all
			 || ! NAME_(cr4_pge_get)(cpssp)
			 || ((cpssp->NAME.mmu_tlb[line].cache[set].entry >> 8) & 1) == 0)
#endif /* defined CONFIG_CPU_PGE_SUPPORT && CONFIG_CPU_PGE_SUPPORT */
			{
				cpssp->NAME.mmu_tlb[line].cache[set].vaddr = -1;
				cpssp->NAME.mmu_tlb[line].cache[set].psize_mask = 0;
			}
		}
	}

	NAME_(cache1_tlb_flush)(cpssp, all);
}

#if 80486 <= CONFIG_CPU
static void
NAME_(invlpg)(struct cpssp *cpssp, vaddr_t vaddr)
{
	unsigned int set;
	unsigned int line4k;
	paddr_t mask4k;
	line4k = (vaddr >> 12) % LINES;
	mask4k = ~((1 << 12) - 1);
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
	unsigned int line4m;
	paddr_t mask4m;
	line4m = (vaddr >> 22) % LINES;
	mask4m = ~((1 << 22) - 1);
#endif
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
	unsigned int line2m;
	paddr_t mask2m;
	line2m = (vaddr >> 21) % LINES;
	mask2m = ~((1 << 21) - 1);
#endif
#if defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT
	unsigned int line1g;
	paddr_t mask1g;
	line1g = (vaddr >> 30) % LINES;
	mask1g = ~((1 << 30) - 1);
#endif

	for (set = 0; set < SETS; set++) {
#if defined CONFIG_CPU_PAE_SUPPORT && CONFIG_CPU_PAE_SUPPORT
#if (defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT) \
		&& (defined CONFIG_CPU_PAGE1GB_SUPPORT && CONFIG_CPU_PAGE1GB_SUPPORT)
		paddr_t cond1g = (cpssp->NAME.mmu_tlb[line1g].cache[set].vaddr ^ (vaddr & mask1g)) |
			(cpssp->NAME.mmu_tlb[line1g].cache[set].psize_mask ^ mask1g);
		if (!cond1g) {
			cpssp->NAME.mmu_tlb[line1g].cache[set].vaddr = -1;
			cpssp->NAME.mmu_tlb[line1g].cache[set].psize_mask = 0;
		}
#endif
		paddr_t cond2m = (cpssp->NAME.mmu_tlb[line2m].cache[set].vaddr ^ (vaddr & mask2m)) |
			(cpssp->NAME.mmu_tlb[line2m].cache[set].psize_mask ^ mask2m);
		if (!cond2m) {
			cpssp->NAME.mmu_tlb[line2m].cache[set].vaddr = -1;
			cpssp->NAME.mmu_tlb[line2m].cache[set].psize_mask = 0;
		}
#endif
#if defined CONFIG_CPU_PSE_SUPPORT && CONFIG_CPU_PSE_SUPPORT
		paddr_t cond4m = (cpssp->NAME.mmu_tlb[line4m].cache[set].vaddr ^ (vaddr & mask4m)) |
			(cpssp->NAME.mmu_tlb[line4m].cache[set].psize_mask ^ mask4m);
		if (!cond4m) {
			cpssp->NAME.mmu_tlb[line4m].cache[set].vaddr = -1;
			cpssp->NAME.mmu_tlb[line4m].cache[set].psize_mask = 0;
		}
#endif
		paddr_t cond4k = ((cpssp->NAME.mmu_tlb[line4k].cache[set].vaddr ^ (vaddr & mask4k)) |
			(cpssp->NAME.mmu_tlb[line4k].cache[set].psize_mask ^ mask4k));
		if (!cond4k) {
			cpssp->NAME.mmu_tlb[line4k].cache[set].vaddr = -1;
			cpssp->NAME.mmu_tlb[line4k].cache[set].psize_mask = 0;
		}
	}

	NAME_(cache1_invlpg)(cpssp, vaddr);
}
#endif /* 80486 <= CONFIG_CPU */

static int
NAME_(map)(
	struct cpssp *cpssp,
	vaddr_t vaddr,
	bool wflag,
	bool uflag,
	bool xflag,
	paddr_t *paddrp,
	uint16_t *errp
)
{
	int fail;

	if (NAME_(cr0_pg_get)(cpssp)) {
		fail = ! NAME_(virt_addr)(cpssp, vaddr, wflag, uflag, xflag, paddrp, errp);
	} else {
		*paddrp = vaddr;
		*errp = 0;
		fail = 0;
	}

	return fail;
}

static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int n_val)
{
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef SETS
#undef LINES
