(ert-deftest elpy-shell-kill-should-kill-shell ()
  (elpy-testcase ()
    (python-mode)
    (elpy-mode 1)
    (let ((shell-buffer (process-buffer (elpy-shell-get-or-create-process))))
      (elpy-shell-kill)
      (should (not (get-buffer-process shell-buffer))))))

(ert-deftest elpy-shell-kill-should-kill-shell-and-buffer ()
  (elpy-testcase ()
    (python-mode)
    (elpy-mode 1)
    (let ((shell-buffer (process-buffer (elpy-shell-get-or-create-process))))
      (elpy-shell-kill t)
      (should (not (get-buffer-process shell-buffer)))
      (should (not (buffer-name shell-buffer))))))

(ert-deftest elpy-shell-kill-all-should-kill-all-shells ()
  (elpy-testcase ()
    (let ((buff1 (generate-new-buffer "buff1"))
          (buff2 (generate-new-buffer "buff2"))
          (shell-buff1 nil)
          (shell-buff2 nil))
      (with-current-buffer buff1
        (python-mode)
        (elpy-mode 1)
        (elpy-shell-toggle-dedicated-shell 1)
        (setq shell-buff1 (process-buffer (elpy-shell-get-or-create-process))))
      (with-current-buffer buff2
        (python-mode)
        (elpy-mode 1)
        (elpy-shell-toggle-dedicated-shell 1)
        (setq shell-buff2 (process-buffer (elpy-shell-get-or-create-process))))
      (defun yes-or-no-p (&rest args)
        t)
      (defun y-or-n-p (&rest args)
        t)
      (elpy-shell-kill-all)
      (should (not (and
                    (get-buffer-process shell-buff1)
                    (get-buffer-process shell-buff2)))))))

(ert-deftest elpy-shell-kill-all-should-kill-all-shells-and-buffers ()
  (elpy-testcase ()
    (let ((buff1 (generate-new-buffer "buff1"))
	  (buff2 (generate-new-buffer "buff2"))
	  (shell-buff1 nil)
	  (shell-buff2 nil))
      (with-current-buffer buff1
	(python-mode)
	(elpy-mode 1)
        (elpy-shell-toggle-dedicated-shell 1)
        (setq shell-buff1 (process-buffer (elpy-shell-get-or-create-process))))
      (with-current-buffer buff2
	(python-mode)
	(elpy-mode 1)
        (elpy-shell-toggle-dedicated-shell 1)
	(setq shell-buff2 (process-buffer (elpy-shell-get-or-create-process))))
      (defun yes-or-no-p (&rest args)
	t)
      (defun y-or-n-p (&rest args)
	t)
      (elpy-shell-kill-all t)
      (should (not (and
		    (buffer-name shell-buff1)
		    (buffer-name shell-buff2)))))))
