package launcher

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type Data struct {
	Version     string `json:"version"`
	DisplayMode string `json:"display_mode"`
	Fullscreen  bool   `json:"fullscreen"`
}

const (
	Name = "launcher"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeString(&core.DisplayMode, curInfo.DisplayMode, cacheInfo.DisplayMode)
	utils.MergeBool(&core.Fullscreen, curInfo.Fullscreen, cacheInfo.Fullscreen)
}
