#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# mount target

target="/target"
mkdir -pv ${target}
if [ -f /etc/deepin-repair-tools-os-type.conf ]; then
    rm -f /etc/deepin-repair-tools-os-type.conf
fi
Roota=$(lsblk -f -o PATH,LABEL | grep -i "Roota" | awk '{print $1}')

if [ -z $Roota ]; then
    cd /usr/lib/deepin-repair-tools/plugins/mount_target
    sh advanced_mount_target.sh  
    return 1 
fi

linesNumber=$(lsblk -f -o PATH,LABEL | grep -i "Roota" | wc -l)
if [ $linesNumber -ge 2 ]; then
    echo multiOs > /etc/deepin-repair-tools-os-type.conf
    return -1
fi

Boot=$(lsblk -f -o PATH,LABEL | grep -i "Boot" | awk '{print $1}')

EFI=$(lsblk -f -o PATH,LABEL | grep -i "EFI" | awk '{print $1}')

_dde_data=$(lsblk -f -o PATH,LABEL | grep -i "_dde_data" | awk '{print $1}')

Backup=$(lsblk -f -o PATH,LABEL | grep -i "Backup" | awk '{print $1}')

SWAP=$(lsblk -f -o PATH,LABEL | grep -i "SWAP" | awk '{print $1}')

Opt=$(lsblk -f -o PATH,LABEL | grep -i "Opt" | awk '{print $1}')

Var=$(lsblk -f -o PATH,LABEL | grep -i "Var" | awk '{print $1}')

UsrLocal=$(lsblk -f -o PATH,LABEL | grep -i "UsrLocal" | awk '{print $1}')

Home=$(lsblk -f -o PATH,LABEL | grep -i "Home" | awk '{print $1}')

Tmp=$(lsblk -f -o PATH,LABEL | grep -i "Tmp" | awk '{print $1}')

Srv=$(lsblk -f -o PATH,LABEL | grep -i "Srv" | awk '{print $1}')


if [ ! -z $Roota ];then
   mount $Roota ${target}
fi

if [ ! -z $Boot ];then
   mount $Boot ${target}/boot
fi

if [ ! -z $EFI ];then
   mount $EFI ${target}/boot/efi
fi

if [ ! -z $_dde_data ];then
   mount $_dde_data ${target}/data
fi

if [ ! -z $Backup ];then
   mount $Backup ${target}/recovery
fi

if [ ! -z $SWAP ];then
   swapon $SWAP
fi

if [ ! -z $Opt ];then
    mount $Opt ${target}/opt
fi

if [ ! -z $Var ]; then
    mount $Var ${target}/var
fi

if [ ! -z $UsrLocal ]; then
    mount $UsrLocal ${target}/usr/local
fi

if [ ! -z $Home ];then
    mount $Home ${target}/home
fi

if [ ! -z $Tmp ]; then
    mount $Home ${target}/Tmp
fi

if [ ! -z $Srv];then
    mount $Srv ${target}/srv
fi

if [ -d /target/data/home ];then
     mount --bind /target/data/home /target/home || echo "Faild to mount /target/home"
fi

if [ -d /target/data/opt ];then
     mount --bind /target/data/opt /target/opt || echo "Faild to mount /target/opt"
fi

if [ -d /target/data/root ];then
     mount --bind /target/data/root /target/root || echo "Faild to mount /target/root"
fi

if [ -d /target/data/var ];then
     mount --bind /target/data/var /target/var || echo "Failed to mount /target/var"
fi
touch /target/var/log/deepin-repair-tools.log

