// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "dsstestwidget.h"
#include "network_module.h"

#include <DPalette>

#include <QMouseEvent>
#include <QHBoxLayout>

#include <networkcontroller.h>

using namespace dss::module;
using namespace dde::network;
using namespace Dtk::Widget;
DGUI_USE_NAMESPACE

DssTestWidget::DssTestWidget(QWidget *parent)
    : QWidget(parent)
    , m_pModule(new NetworkPlugin)
{
    NetworkController::setServiceType(ServiceLoadType::LoadFromManager);

    QWidget *iconWidget = new QWidget(this);
    m_iconButton = new FloatingButton(iconWidget);
    m_iconButton->setIconSize(QSize(26, 26));
    m_iconButton->setFixedSize(QSize(52, 52));
    m_iconButton->setAutoExclusive(true);
    QPalette palette = m_iconButton->palette();
    palette.setColor(QPalette::ColorRole::Background, Qt::transparent);
    m_iconButton->setPalette(palette);
    m_iconButton->installEventFilter(this);
    connect(m_iconButton, &Dtk::Widget::DFloatingButton::clicked, this, &DssTestWidget::onClickButton);

    QHBoxLayout *iconLayout = new QHBoxLayout(iconWidget);
    iconLayout->setAlignment(Qt::AlignHCenter);
    iconLayout->addWidget(m_iconButton);

    QPalette paletteSelf = this->palette();
    paletteSelf.setColor(QPalette::ColorRole::Background, Qt::black);
    setAutoFillBackground(true);
    setPalette(paletteSelf);
    m_pModule->init();

    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->addStretch();
    layout->addWidget(iconWidget);

    QHBoxLayout *iconButtonLayout = new QHBoxLayout(m_iconButton);
    QWidget *itemWidget = m_pModule->itemWidget();
    itemWidget->setParent(m_iconButton);
    iconButtonLayout->addWidget(itemWidget);

    installEventFilter(this);
}

DssTestWidget::~DssTestWidget()
{
    m_pModule->deleteLater();
}

void DssTestWidget::onClickButton()
{
    // 左键弹出菜单
    if (m_pModule->content()) {
        m_pModule->content()->show();
    }
}

FloatingButton::FloatingButton(QWidget *parent)
    : DFloatingButton(parent)
{
}
