/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:29:32 GMT 2018
 */

package uk.ac.sanger.artemis.chado;

import org.junit.Test;
import static org.junit.Assert.*;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.time.MockLocalDateTime;
import org.evosuite.runtime.mock.java.time.chrono.MockHijrahDate;
import org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.ChadoTransaction;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ChadoTransaction_ESTest extends ChadoTransaction_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      String string0 = chadoTransaction0.getTypeAsString();
      assertEquals(0, chadoTransaction0.getType());
      assertEquals(">sa$32C", chadoTransaction0.getFeatureKey());
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      Timestamp timestamp0 = new Timestamp((-3099));
      Key key0 = new Key("t9_/jB(%Zx>rE-&=9D");
      Range range0 = new Range(240, 240);
      Location location0 = new Location(range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, (QualifierVector) null, chadoCanonicalGene0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-3099), fileSystemHandling0, timestamp0, databaseInferredFeature0, "CDS", "CDS");
      ChadoTransaction chadoTransaction1 = chadoTransaction0.copy();
      assertEquals("", chadoTransaction1.getTypeAsString());
      
      chadoTransaction1.type = 2;
      int int0 = chadoTransaction1.getType();
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      Timestamp timestamp0 = new Timestamp((-3099));
      Key key0 = new Key("t9_/jB(%Zx>rE-&=9D");
      Range range0 = new Range(240, 240);
      Location location0 = new Location(range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, (QualifierVector) null, chadoCanonicalGene0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-3099), fileSystemHandling0, timestamp0, databaseInferredFeature0, "CDS", "CDS");
      int int0 = chadoTransaction0.getType();
      assertEquals((-3099), int0);
      assertEquals("exon", chadoTransaction0.getFeatureKey());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, integer0, (Timestamp) null, (GFFStreamFeature) null, "QE~T'6$RVQs!n%7/x", "WvhP<+Z");
      chadoTransaction0.setOldUniquename("WvhP<+Z");
      String string0 = chadoTransaction0.getOldUniquename();
      assertEquals("QE~T'6$RVQs!n%7/x", chadoTransaction0.getFeatureKey());
      assertEquals(0, chadoTransaction0.getType());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LocalDateTime localDateTime0 = MockLocalDateTime.of(3, 3, 3, 3, 3, 3);
      Timestamp timestamp0 = Timestamp.valueOf(localDateTime0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(3, (Object) null, timestamp0, (GFFStreamFeature) null, (String) null, (String) null);
      chadoTransaction0.getLastModified();
      assertEquals("DELETE", chadoTransaction0.getTypeAsString());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      LocalDateTime localDateTime0 = MockLocalDateTime.now();
      Timestamp timestamp0 = Timestamp.valueOf(localDateTime0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(3, (Object) null, timestamp0, (GFFStreamFeature) null, (String) null, (String) null);
      chadoTransaction0.getLastModified();
      assertEquals("DELETE", chadoTransaction0.getTypeAsString());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      chadoTransaction0.getGff_feature();
      assertEquals(">sa$32C", chadoTransaction0.getFeatureKey());
      assertEquals(0, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-1437733547), (Object) null, (Timestamp) null, (GFFStreamFeature) null, "[", "[");
      chadoTransaction0.getFeatureObject();
      assertEquals((-1437733547), chadoTransaction0.getType());
      assertEquals("[", chadoTransaction0.getFeatureKey());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      String string0 = chadoTransaction0.getFeatureKey();
      assertNotNull(string0);
      assertEquals(">sa$32C", string0);
      assertEquals(0, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockMinguoDate mockMinguoDate0 = new MockMinguoDate();
      Timestamp timestamp0 = new Timestamp(0L);
      Key key0 = new Key("");
      Range range0 = new Range(0, 418);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(1331, mockMinguoDate0, timestamp0, gFFStreamFeature0, "", "");
      String string0 = chadoTransaction0.getFeatureKey();
      assertNotNull(string0);
      assertEquals(1331, chadoTransaction0.getType());
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      ChadoTransaction chadoTransaction1 = chadoTransaction0.copy();
      assertEquals(">sa$32C", chadoTransaction1.getFeatureKey());
      assertNotSame(chadoTransaction1, chadoTransaction0);
      assertEquals(0, chadoTransaction1.getType());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LocalDateTime localDateTime0 = MockLocalDateTime.now();
      Timestamp timestamp0 = Timestamp.valueOf(localDateTime0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(3, (Object) null, timestamp0, (GFFStreamFeature) null, (String) null, (String) null);
      String string0 = chadoTransaction0.getTypeAsString();
      assertEquals("DELETE", string0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      int int0 = chadoTransaction0.getType();
      assertEquals(0, int0);
      assertEquals(">sa$32C", chadoTransaction0.getFeatureKey());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MockHijrahDate mockHijrahDate0 = new MockHijrahDate();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(60, mockHijrahDate0, (Timestamp) null, databaseStreamFeature0, (String) null, (String) null);
      chadoTransaction0.getLastModified();
      assertEquals(60, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-1437733547), (Object) null, (Timestamp) null, (GFFStreamFeature) null, "[", "[");
      chadoTransaction0.getGff_feature();
      assertEquals("[", chadoTransaction0.getFeatureKey());
      assertEquals((-1437733547), chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MockHijrahDate mockHijrahDate0 = new MockHijrahDate();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(60, mockHijrahDate0, (Timestamp) null, databaseStreamFeature0, (String) null, (String) null);
      chadoTransaction0.getFeatureKey();
      assertEquals(60, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockHijrahDate mockHijrahDate0 = new MockHijrahDate();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(60, mockHijrahDate0, (Timestamp) null, databaseStreamFeature0, (String) null, (String) null);
      chadoTransaction0.getFeatureObject();
      assertEquals(60, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0, true);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(1, (Object) null, (Timestamp) null, gFFStreamFeature0, "gX@Va4$", "exon");
      String string0 = chadoTransaction0.getLogComment();
      assertEquals("[UPDATE] exon KEY=gX@Va4$", string0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, integer0, (Timestamp) null, (GFFStreamFeature) null, "QE~T'6$RVQs!n%7/x", "WvhP<+Z");
      chadoTransaction0.getUniquename();
      assertEquals("QE~T'6$RVQs!n%7/x", chadoTransaction0.getFeatureKey());
      assertEquals(0, chadoTransaction0.getType());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      chadoTransaction0.setUniquename("CDS");
      String string0 = chadoTransaction0.getUniquename();
      assertEquals(0, chadoTransaction0.getType());
      assertEquals(">sa$32C", chadoTransaction0.getFeatureKey());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(0, (Object) null, (Timestamp) null, databaseStreamFeature0, ">sa$32C", " could not be found");
      String string0 = chadoTransaction0.getUniquename();
      assertEquals(0, chadoTransaction0.getType());
      assertEquals(">sa$32C", chadoTransaction0.getFeatureKey());
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      LocalDateTime localDateTime0 = MockLocalDateTime.of(3, 3, 3, 3, 3, 3);
      Timestamp timestamp0 = Timestamp.valueOf(localDateTime0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(3, (Object) null, timestamp0, (GFFStreamFeature) null, (String) null, (String) null);
      String string0 = chadoTransaction0.getLogComment();
      assertEquals("[DELETE] null", string0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      Timestamp timestamp0 = new Timestamp((-3099));
      Key key0 = new Key("t9_/jB(%Zx>rE-&=9D");
      Range range0 = new Range(240, 240);
      Location location0 = new Location(range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, (QualifierVector) null, chadoCanonicalGene0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-3099), fileSystemHandling0, timestamp0, databaseInferredFeature0, "CDS", "CDS");
      ChadoTransaction chadoTransaction1 = chadoTransaction0.copy();
      assertEquals((-3099), chadoTransaction1.getType());
      
      chadoTransaction1.type = 2;
      String string0 = chadoTransaction1.getTypeAsString();
      assertEquals("INSERT", string0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0, true);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(1, (Object) null, (Timestamp) null, gFFStreamFeature0, "gX@Va4$", "exon");
      String string0 = chadoTransaction0.getTypeAsString();
      assertEquals("UPDATE", string0);
      assertEquals("gX@Va4$", chadoTransaction0.getFeatureKey());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MockHijrahDate mockHijrahDate0 = new MockHijrahDate();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(60, mockHijrahDate0, (Timestamp) null, databaseStreamFeature0, (String) null, (String) null);
      String string0 = chadoTransaction0.getTypeAsString();
      assertEquals(60, chadoTransaction0.getType());
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0, true);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction(1, (Object) null, (Timestamp) null, gFFStreamFeature0, "gX@Va4$", "exon");
      chadoTransaction0.setUniquename("");
      ChadoTransaction chadoTransaction1 = chadoTransaction0.copy();
      assertEquals(1, chadoTransaction0.getType());
      assertEquals("gX@Va4$", chadoTransaction1.getFeatureKey());
      assertNotSame(chadoTransaction1, chadoTransaction0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      Timestamp timestamp0 = new Timestamp((-3099));
      Key key0 = new Key("t9_/jB(%Zx>rE-&=9D");
      Range range0 = new Range(240, 240);
      Location location0 = new Location(range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, (QualifierVector) null, chadoCanonicalGene0);
      ChadoTransaction chadoTransaction0 = new ChadoTransaction((-3099), fileSystemHandling0, timestamp0, databaseInferredFeature0, "CDS", "CDS");
      chadoTransaction0.getOldUniquename();
  }
}
