#ifndef UOS_RECOVERY_RSYNC_DRYRUN_TASK_H
#define UOS_RECOVERY_RSYNC_DRYRUN_TASK_H

#include "RsyncTask.h"

class RsyncDryRunTask : public RsyncTask
{
    Q_OBJECT
public:
    explicit RsyncDryRunTask(bool reportProgress);
    virtual ~RsyncDryRunTask();

    void readStandardOutput() override;
    void doResult() override;
    void setDestUUID(const QString &destUUID);
signals:
    void spaceChanged(const QJsonObject &space);

private:
    void reportSpace(const quint64 &spaceBytes);
    bool getPartitionSpace(quint64 &availableBytes);

private:
    QString m_destUUID;
};

#endif
