#ifndef UOS_RECOVERY_DIMFILERESTOREWIDGET_H
#define UOS_RECOVERY_DIMFILERESTOREWIDGET_H

#include <DWidget>
#include <DGuiApplicationHelper>
#include <DFontSizeManager>
#include <DLabel>
#include <DPushButton>
#include <DSuggestButton>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class QVBoxLayout;

class dimFileRestoreWidget : public DWidget
{
    Q_OBJECT

public:
    explicit dimFileRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initConnect();
    void setDestPath(const QString &destPath);
    void startCalculateTip(bool start, const QString &tipInfo);
    void setErrorTips(const QString &tips);

Q_SIGNALS:
    void cancelBtnSignal();
    void startDimRestoreSignal(const QString &dimFilePath);

private Q_SLOTS:
    void startDimRestoreBtnClicked();
    void onSelectPathBtnClicked();
    void onThemeChange();

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    QWidget *m_selectPathWidget    = nullptr;
    DLabel *m_title                = nullptr;
    DLabel *m_subTitle             = nullptr;
    DLabel *m_destPathLabel        = nullptr;
    DLabel *m_fileSizeLabel        = nullptr;
    DLabel *m_errorInfoLabel       = nullptr;
    DPushButton *m_selectPath      = nullptr;
    DPushButton *m_cancel          = nullptr;
    DSuggestButton *m_startRestore = nullptr;
    DSpinner *m_calculateTip = nullptr;
};

#endif
