#ifndef UOS_RECOVERY_SELECTPARTITIONTREEVIEW_H
#define UOS_RECOVERY_SELECTPARTITIONTREEVIEW_H

#include <QItemDelegate>
#include <DTreeView>
#include <DHeaderView>
#include <QJsonObject>

DWIDGET_USE_NAMESPACE

class BaseItemDelegate;
class BaseHeaderView;
class QModelIndex;
class QLabel;
class QAbstractTableModel;

class QModelIndex;
class SelectPartitionHeaderView : public DHeaderView
{
Q_OBJECT

public:
    explicit SelectPartitionHeaderView(Qt::Orientation orientation, QWidget *parent = nullptr);
    int sectionSizeHint(int logicalIndex) const;
    QSize sizeHint() const override;

protected:
    void paintEvent(QPaintEvent *e) override;
    void paintSection(QPainter *painter, const QRect &rect,
                      int logicalIndex) const override;

private:
    int m_spacing {1};
};

//备份信息
struct SelectPartitionModelItem {
    QString uuid;
    QString itemType;
    QString deviceName;
    QString name;
    QString deviceType;
    quint64 size;
    quint64 used;
    quint64 free;
    int partIndexInMap;
    int partListSize;

    SelectPartitionModelItem() : uuid(""), itemType(""), deviceName(""), name(""), deviceType(""), size(0), used(0),
                                 free(0), partIndexInMap(-1), partListSize(-1)
    {
    }

    QJsonObject marshal() const {
        QJsonObject jsonObject;
        jsonObject.insert("uuid", uuid);
        jsonObject.insert("itemType", itemType);
        jsonObject.insert("deviceName", deviceName);
        jsonObject.insert("name", name);
        jsonObject.insert("deviceType", deviceType);
        jsonObject.insert("size", QString::number(size));
        jsonObject.insert("used", QString::number(used));
        jsonObject.insert("free", QString::number(free));
        jsonObject.insert("partIndexInMap", partIndexInMap);
        jsonObject.insert("partListSize", partListSize);
        return jsonObject;
    }

    void unmarshal(const QJsonObject &jsonObject) {
        uuid = jsonObject.value("uuid").toString();
        itemType = jsonObject.value("itemType").toString();
        deviceName = jsonObject.value("deviceName").toString();
        name = jsonObject.value("name").toString();
        deviceType = jsonObject.value("deviceType").toString();
        size = jsonObject.value("size").toString().toULongLong();
        used = jsonObject.value("used").toString().toULongLong();
        free = jsonObject.value("free").toString().toULongLong();
        partIndexInMap = jsonObject.value("partIndexInMap").toInt();
        partListSize = jsonObject.value("partListSize").toInt();
    }
};

class SelectPartitionItemModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    explicit SelectPartitionItemModel(int columnCount, QObject *parent = Q_NULLPTR);

    int rowCount(const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;
    int columnCount(const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;
    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;

    void setHeadData(const QStringList &heads);
    SelectPartitionModelItem getDataInfo(int row);
    QList<SelectPartitionModelItem>& getDataInfos() { return m_dataInfo; }

public slots:
    void setDatas(QMap<QString, QList<QJsonObject>> modeData);

private:
    QList<SelectPartitionModelItem> m_dataInfo;
    QStringList m_headItems;
    int m_columnCount = 0;
};

class SelectPartitionItemDelegate : public QItemDelegate
{
    Q_OBJECT

public:
    explicit SelectPartitionItemDelegate(QObject *parent = Q_NULLPTR);

    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const Q_DECL_OVERRIDE;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const Q_DECL_OVERRIDE;
    void setSelect(int selectrow) { m_selectRow = selectrow; }
    void setColumnsRowSize(const QList<int> &widths, const int &height) { m_sizes = widths; m_rowHeiht = height; }

private:
    int m_selectRow = 0;
    int m_rowHeiht = 0;
    QList<int> m_sizes;
};

class SelectPartitionTreeView : public DTreeView
{
    Q_OBJECT

public:
    explicit SelectPartitionTreeView(QWidget *parent = Q_NULLPTR);
    void setColumnsRowSize(const QList<int> &widths, const int &height);
    void setSelectIndex(int index);
    int getTreeViewClickedDeviceName(const QModelIndex &index, int &partIndex, QString &deviceName);

signals:
    void itemSelectSignal(const QString &name, const int index);

protected:
    void drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index) const override;
    bool viewportEvent(QEvent *event) override;
    void paintEvent(QPaintEvent *event) override;

private:
    SelectPartitionItemDelegate *m_itemDelegate = Q_NULLPTR;
    SelectPartitionHeaderView *m_headerView = Q_NULLPTR;
    QModelIndex m_hover;
    QModelIndex m_pressed;
};


#endif //UOS_RECOVERY_SELECTPARTITIONTREEVIEW_H
