//
// Created by uos on 2022/3/21.
//

#ifndef UOS_RECOVERY_RESULTWIDGET_H
#define UOS_RECOVERY_RESULTWIDGET_H

#include <DWidget>
#include <DLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ResultWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ResultWidget(bool success, const QString &resultText,
                          const QString &errorMsg, const QString &btnText, DWidget *parent = nullptr);

    void set(bool success, const QString &resultText,
             const QString &errorMsg, const QString &btnText);
    bool isSuccess() { return m_isSuccess; }
    void showViewButton(bool show, const QString &btnText, const QString &style);
Q_SIGNALS:
    void done();
    void viewBtnClicked();
private:
    DLabel *m_resultIcon = nullptr;
    DLabel *m_resultText = nullptr;
    DLabel *m_errorMsg = nullptr;
    DPushButton *m_viewButton = nullptr;
    DPushButton *m_button = nullptr;
    bool m_isSuccess = false;
};


#endif //UOS_RECOVERY_RESULTWIDGET_H
