//
// Created by uos on 2022/3/17.
//

#include "ProgressWidget.h"
#include <QVBoxLayout>
#include <DFontSizeManager>

ProgressWidget::ProgressWidget(const QString &mainTitle, const QString &subTitle,
                               const QString &warning, DWidget *parent)
    : DWidget(parent)
{
    //垂直布局
    QVBoxLayout *verticalLayout = new QVBoxLayout(this);
    m_waterProgress = new DWaterProgress(this);
    m_waterProgress->setValue(0);
    m_waterProgress->setTextVisible(true);
    m_waterProgress->setFixedSize(98, 98);
    verticalLayout->addWidget(m_waterProgress);
    verticalLayout->setAlignment(m_waterProgress, Qt::AlignHCenter);
    verticalLayout->addSpacing(25);

    m_mainTitle = new DLabel(this);
    m_mainTitle->setText(mainTitle);
    auto font = m_mainTitle->font();
    font.setPointSize(14);
    font.setWeight(QFont::Medium);
    m_mainTitle->setFont(font);
    m_mainTitle->setAlignment(Qt::AlignCenter);

    verticalLayout->addWidget(m_mainTitle);
    verticalLayout->addSpacing(20);

    auto hLayout = new QHBoxLayout;
    hLayout->setAlignment(Qt::AlignCenter);
    m_subTitle = new DLabel(this);
    m_subTitle->setText(subTitle);
    m_subTitle->setAlignment(Qt::AlignCenter);
    font = m_subTitle->font();
    font.setPointSize(12);
    font.setWeight(QFont::Normal);
    m_subTitle->setFont(font);
    m_subTitle->setStyleSheet("QLabel {"
                             "font-family: SourceHanSansSC, SourceHanSansSC-Normal;"
                             "font-size: 12px;"
                             "font-weight: 500;"
                             "color: #000000;"
                             "}");
    hLayout->addWidget(m_subTitle);
    hLayout->addSpacing(10);

    m_remainTime = new DLabel;
    m_remainTime->setFont(font);
    m_remainTime->setStyleSheet("QLabel {"
                              "font-family: SourceHanSansSC, SourceHanSansSC-Normal;"
                              "font-size: 12px;"
                              "font-weight: 500;"
                              "color: #000000;"
                              "}");
    hLayout->addWidget(m_remainTime);
    verticalLayout->addLayout(hLayout);
    verticalLayout->addStretch();

    m_warning = new DLabel(this);
    m_warning->setText(warning);
    m_warning->setAlignment(Qt::AlignCenter);
    m_warning->setWordWrap(true);
    m_warning->setStyleSheet("QLabel {"
                             "font-family: SourceHanSansSC, SourceHanSansSC-Medium;"
                             "font-size: 14px;"
                             "font-weight: 500;"
                             "color: #ff5736;"
                             "}");
    verticalLayout->addWidget(m_warning);
    verticalLayout->setAlignment(Qt::AlignCenter);
    verticalLayout->setContentsMargins(0, 138, 0, 10);
}

void ProgressWidget::start()
{
    m_waterProgress->start();
}

void ProgressWidget::stop(bool success)
{
    m_waterProgress->stop();
}

void ProgressWidget::setValue(int value)
{
    m_waterProgress->setValue(value);
}

void ProgressWidget::setMainTitle(const QString &mainTitle)
{
    m_mainTitle->setText(mainTitle);
}

void ProgressWidget::setSubTitle(const QString &subTitle)
{
    m_subTitle->setText(subTitle);
}

void ProgressWidget::setWarning(const QString &warning)
{
    m_warning->setText(warning);
}

void ProgressWidget::setRemainTime(int remainSecond)
{
    int hours = remainSecond / 3600;
    int minute = (remainSecond - hours * 3600) / 60;
    int second = (remainSecond - hours * 3600 - minute * 60);

    auto remainTime = QString("%1:%2:%3")
            .arg(hours, 2, 10, QLatin1Char('0'))
            .arg(minute, 2, 10, QLatin1Char('0') )
            .arg(second, 2, 10, QLatin1Char('0'));
    m_remainTime->setText(remainTime);
}


