#include "wordwizardwidget.h"
#include "themedlable.h"
#include "wordwizarditem.h"

#include <QVBoxLayout>
#include <QHBoxLayout>

#include <DLabel>
#include <DFontSizeManager>
#include <DBackgroundGroup>
#include <DGuiApplicationHelper>

WordWizardWidget::WordWizardWidget(DWidget *parent)
    : DWidget(parent)
{
    initUI();
    onThemeTypeChanged();
    connect(DGuiApplicationHelper::instance(), &DGuiApplicationHelper::themeTypeChanged, this, &WordWizardWidget::onThemeTypeChanged);
}

void WordWizardWidget::initUI()
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(10);

    m_pWidgetLabel = new ThemedLable(tr("UOS AI FollowAlong"));
    m_pWidgetLabel->setPaletteColor(QPalette::Text, DPalette::TextTitle);
    DFontSizeManager::instance()->bind(m_pWidgetLabel, DFontSizeManager::T5, QFont::Bold);

    layout->addWidget(m_pWidgetLabel, 0, Qt::AlignLeft);
    layout->addWidget(wordWizardWidget());
    layout->addStretch();
}

void WordWizardWidget::onThemeTypeChanged()
{
    DPalette pl = m_pWordWizardWidget->palette();
    pl.setBrush(DPalette::Base, DGuiApplicationHelper::instance()->applicationPalette().color(DPalette::ItemBackground));
    m_pWordWizardWidget->setPalette(pl);
}

DBackgroundGroup *WordWizardWidget::wordWizardWidget()
{
    m_WordWizardItem = new WordWizardItem(this);
    m_WordWizardItem->setText(tr("Automatically display the UOS AI FollowAlong toolbar when text is selected."), tr("After closing, the selected text can still be woken up by the shortcut Super+Space bar."));
    m_WordWizardItem->setMinimumHeight(60);
    m_WordWizardItem->setMaximumHeight(75);
    m_WordWizardItem->setSwitchChecked(true);

    connect(m_WordWizardItem, &WordWizardItem::signalSwitchChanged, this, &WordWizardWidget::signalChangeHiddenStatus);

    QHBoxLayout *bgLayout = new QHBoxLayout;
    bgLayout->setContentsMargins(0, 0, 0, 0);
    bgLayout->addWidget(m_WordWizardItem);

    m_pWordWizardWidget = new DBackgroundGroup(bgLayout, this);
    m_pWordWizardWidget->setContentsMargins(0, 0, 0, 0);

    return m_pWordWizardWidget;
}

QString WordWizardWidget::getTitleName()
{
    return m_pWidgetLabel->text();
}

void WordWizardWidget::updateHiddenStatus(bool isHidden)
{
    m_WordWizardItem->setSwitchChecked(isHidden);
}
