// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef MODELSERVER_H
#define MODELSERVER_H

#include "global_header.h"

#include <QObject>

class QFile;
class QTimer;
GLOBAL_BEGIN_NAMESPACE
class ModelProxy;
class RuntimeState;
class HttpServer;
class HttpContext;
class ModelRunner;
class ModelServer : public QObject
{
    Q_OBJECT
public:
    explicit ModelServer(QObject *parent = nullptr);
    ~ModelServer();
    inline void setHost(const QString &host) {
        uHost = host;
    }
    inline void setPort(int port) {
        uPort = port;
    }
    bool run(ModelRunner *mr);
    void stop();
    void setIdle(int s);
    void resetIdle();
    void stopIdle();
    static int instance(const QString &model);
signals:

public slots:
    void onReqeust(void *ptr);
protected slots:
    void onIdle();
protected:
    ModelRunner *runner = nullptr;
    QFile *stateFile = nullptr;
    RuntimeState *state = nullptr;
    HttpServer *http = nullptr;
    QString uHost;
    int uPort = -1;
    QTimer *idleTimer = nullptr;
};

GLOBAL_END_NAMESPACE

#endif // MODELSERVER_H
