// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "global_header.h"
#include "command.h"
#include "../environments.h"

#include <QGuiApplication>
#include <QLoggingCategory>
#include <QDebug>
#include <QDateTime>

#include <signal.h>
#include <unistd.h>

static void appExitHandler(int sig)
{
    qInfo() << "signal" << sig << "exit.";

    // 释放资源
    qApp->quit();
}

GLOBAL_USE_NAMESPACE

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    a.setOrganizationName("deepin");
    a.setApplicationVersion(VERSION);
    a.setApplicationName(EXE_NAME);

    // 安全退出
    signal(SIGINT, appExitHandler);
    signal(SIGQUIT, appExitHandler);
    signal(SIGTERM, appExitHandler);

#ifndef QT_DEBUG
    qsrand(QDateTime::currentMSecsSinceEpoch());
#endif
    Command cmd;
    return cmd.processCmd(a);
}
