#!/bin/bash
# A script to configure the module's debug log level.
# 
# Note: Please do not modify this script directly, 
# as modifying this script will invalidate this script.
set -e

pkg_name="wpa"
debug="no"

deepin_debug_config_file="/etc/deepin/deepin-debug-config"
wpa_debug_file="/etc/deepin/deepin-debug-config/deepin_wpa_supplicant.conf"

# 获取当前用户的UID
current_uid=$(id -u)
# 判断是否是Root权限
if [ "$current_uid" -ne 0 ]; then
    echo "You need to have root privileges to run this script."                                             
    exit 1
fi


for x in "$@"; do
        case $x in
        debug=*)
                debug=${x#debug=}
                ;;
        esac
done

mkdir -p ${deepin_debug_config_file}

# 检查传入的参数
case "${debug}" in
    "on" | "debug")
        # 如果传入的参数是 "on"
        # 删除已存在的 deepin-bluetoothd.conf 脚本
        if [ -f "${wpa_debug_file}" ]; then
            rm "${wpa_debug_file}"
        fi
        # 创建新的 deepin-bluetoothd.conf 脚本并写入内
        echo "-ddd -K" > "${wpa_debug_file}"
        echo "Debug logs are enabled for ${pkg_name}."
        ;;
    "off" | "warning")
        # 如果传入的参数是 "off"
        # 删除已存在的 deepin-bluetoothd.conf 脚本
        if [ -f "${wpa_debug_file}" ]; then
            rm "${wpa_debug_file}"
            echo "Removed ${wpa_debug_file}"
        fi
        echo "Debug logs are disabled for ${pkg_name}."
        ;;
    *)
        # 如果传入的参数不是 "on", "off", 或 "debug"/"warning"
        echo "Usage: $debug {on|off|debug|warning}"
        exit 1
        ;;
esac
