/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "videowidget.h"
#include "ddlog.h"

VideoWidget::VideoWidget(QUrl file, QWidget *parent)
    : ModuleInterface(parent)
{
    qCDebug(app) << "VideoWidget::VideoWidget - Creating player widget and layout";
    setProperty("forceBind", true);
    dmr::CompositingManager::get().setProperty("forceBind", true);
    m_video = new dmr::PlayerWidget(this);
    // remove frame width(eliminate white lines)
    setFrameStyle(QFrame::NoFrame);
    m_selectBtn->hide();
    setObjectName("VideoWidget");

    QHBoxLayout *layout = new QHBoxLayout;
    layout->setSpacing(0);
    layout->setContentsMargins(0, 0, 0, 0);

    // mute by default
    setMute(true);
    m_video->engine().setBackendProperty("keep-open", "always");
    auto list = m_video->engine().getplaylist()->items();

    layout->addWidget(m_video, 0, Qt::AlignCenter);
    m_video->engine().setBackendProperty("panscan", 1.0);
    // based on a 1920x1080 resolution ratio
    m_video->setFixedSize(1002, 564);

    setLayout(layout);
    m_video->show();
}

void VideoWidget::startPlay()
{
    qCDebug(app) << "VideoWidget::startPlay - Resetting playback position to start";
    m_video->engine().seekAbsolute(0);
    if (m_video->engine().state() != dmr::PlayerEngine::CoreState::Playing) {
        m_video->engine().pauseResume();
    }
    this->blockSignals(false);
    connect(&m_video->engine(), &dmr::PlayerEngine::elapsedChanged, this, &VideoWidget::slotShowMore, Qt::DirectConnection);
}

void VideoWidget::pause()
{
    qCDebug(app) << "VideoWidget::pause - Disconnecting elapsed time signal";
    disconnect(&m_video->engine(), &dmr::PlayerEngine::elapsedChanged, this, &VideoWidget::slotShowMore);
}

void VideoWidget::setFile(QUrl file)
{
    qCDebug(app) << "VideoWidget::setFile - Clearing playlist and adding new file";
    m_video->engine().getplaylist()->clear();
    m_video->engine().addPlayFile(file);
    m_video->engine().pauseResume();
    m_video->engine().play();
}

void VideoWidget::setMute(bool b)
{
    qCDebug(app) << "VideoWidget::setMute - Setting mute state:" << b;
    m_video->engine().setBackendProperty("mute", b ? "yes" : "no");
}

/*******************************************************************************
 1. @函数:    updateBigIcon
 2. @作者:
 3. @日期:    2020-12-08
 4. @说明:    更新第一次启动背景图
*******************************************************************************/
void VideoWidget::updateBigIcon() {}

/*******************************************************************************
 1. @函数:    updateSmallIcon
 2. @作者:
 3. @日期:    2020-12-08
 4. @说明:    更新日常的背景图
*******************************************************************************/
void VideoWidget::updateSmallIcon() {}

void VideoWidget::updateSelectBtnPos() {}

void VideoWidget::keyPressEvent(QKeyEvent *e) {}

void VideoWidget::showEvent(QShowEvent *event)
{
    qCDebug(app) << "VideoWidget::showEvent - Video widget shown";
    emit finishedShow();
    ModuleInterface::showEvent(event);
}

void VideoWidget::slotShowMore()
{
    qCDebug(app) << "VideoWidget::slotShowMore - Video elapsed time:" << m_video->engine().elapsed();
    int elapsed = m_video->engine().elapsed();
    if (elapsed == 7) {
        QTimer::singleShot(200, [=]() {
            emit showMore();
            this->blockSignals(true);
        });
        disconnect(&m_video->engine(), &dmr::PlayerEngine::elapsedChanged, this, &VideoWidget::slotShowMore);
    }
}
